#ifndef _SlicerManagerCommand_h_
#define _SlicerManagerCommand_h_


#include "CAPTk.h"
#include "SlicerManager.h"
#include "InteractorStyleNavigator.h"
#include "fMainWindow.h"


class SlicerManagerCommand : public vtkCommand
{
public:
  static SlicerManagerCommand *New()
  {
    return new SlicerManagerCommand;
  }

  void Execute(vtkObject *caller, unsigned long event, void *vtkNotUsed(callData));

  SlicerManager *SM;
  void Dolly(double factor, vtkRenderWindowInteractor *interactor);
  void SetSlicerNumber(int slicer) { mSlicerNumber = slicer; }
  void AddActions();


protected:
  SlicerManagerCommand();
  ~SlicerManagerCommand() {}

private:
  int FindSlicerNumber(vtkRenderWindow* renwin);
  double InitialWindow;
  double InitialLevel;
  int mStartSlicer;
  int mSlicerNumber;


};


#endif
