#include "TextureFeatures.h"

TextureFeatures::TextureFeatures()
{


}
TextureFeatures::~TextureFeatures()
{

}
void TextureFeatures::HistogramFeatures(std::vector<double> &intensities, int start, int interval, int end, std::vector<std::string> &histogram_featurename, std::vector<double> &histogram_feature)
{
  VariableLengthVectorType BinCount;
  std::vector<double> finalBins;
  std::vector<string> Bin_no;
  std::vector<std::vector<double>> Ranges;
  int counter = 0;
  for (int i = start; i <= end; i = i + interval)
  {
    std::vector<double> onerange;
    int lowerbound = i - (interval / 2); 
    if (lowerbound < 0)
      lowerbound = 0;

    int upperbound = i + (interval / 2);
    //if (upperbound > 255)
    //  upperbound = 255;

    //if (i+interval>end)
    // upperbound = 255;

    onerange.push_back(lowerbound);
    onerange.push_back(upperbound);
    Ranges.push_back(onerange);
  }
  std::vector<double> finalRange = Ranges[Ranges.size() - 1];
  finalRange[1] = end + (interval / 2);

  Ranges.resize(Ranges.size() - 1);
  Ranges.push_back(finalRange);

  BinCount.SetSize(Ranges.size());
  for (int j = 0; j < Ranges.size(); j++)
  {
    std::vector<double> onerange = Ranges[j];
    int counter = 0;
    for (int i = 0; i < intensities.size(); i++)
    {
      if (onerange[0] == 0)
      {
        if (intensities[i] >= onerange[0] && intensities[i] <= onerange[1])
          counter = counter + 1;
      }
      else
      {
        if (intensities[i] > onerange[0] && intensities[i] <= onerange[1])
          counter = counter + 1;
      }
    }
    finalBins.push_back(counter);
    Bin_no.push_back("histogram" + to_string(j));
  }
  histogram_feature.insert(histogram_feature.end(), finalBins.begin(), finalBins.end());
  histogram_featurename.insert(histogram_featurename.end(), Bin_no.begin(), Bin_no.end());
}
