///////////////////////////////////////////////////////////////////////////////////////
// fFeaturePanel.h
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fFeaturePanel_h_
#define _fFeaturePanel_h_


#include "CAPTk.h"
#include "Landmarks.h"
#include "ui_fFeaturePanel.h"


/**
\class fFeaturePanel

\brief This class controls the elements in the Feature panel of the tab
*/
class fFeaturePanel : public QWidget, private Ui::fFeaturePanel
{
  Q_OBJECT

public:
  //! Constructor
  fFeaturePanel(QWidget * parent = 0);

  //! Destructor
  ~fFeaturePanel() {}

  void setListner(void* lst)
  {
    m_listener = lst;
    cancelClicked = false;
  }

  //! Sets the same temporary folder everywhere
  void setTempFolderLocation(const std::string& input_tempFolder)
  {
    tempFolderLocation = input_tempFolder;
  }

signals :
  void m_btnComputeClicked();

public slots :
  void browseOutputFileName();
  void ComputeFunctionality(); 
  void CancelFunctionality();
  void computeFeature(int type);
  void featureTypeChanged(int type);
private :
  bool cancelClicked;
  void* m_listener;//TBD this is a bad design (because of time pressure): needs to be changed RK
};


#endif
