///////////////////////////////////////////////////////////////////////////////////////
// fHelpDialog.h
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fHelpDialog_h_
#define _fHelpDialog_h_


#include "CAPTk.h"
#include "ui_fHelpDialog.h"
#include <QWebView>


/**
\class fHelpDialog

\brief This class controls the elements in the help dialog
*/
class fHelpDialog : public QDialog
{
  Q_OBJECT
private:
  QWebView* m_webView;
  QPushButton *homeButton;
  QPushButton *backButton;
  QPushButton *forwardButton;
  QPushButton *refreshButton;
  std::string m_helpFileFullPath;


private slots:
  void on_homeButton_clicked();
  void on_backButton_clicked();
  void on_forwardButton_clicked();
  void on_refreshButton_clicked();

public:
  fHelpDialog();
  ~fHelpDialog();

  public slots:


};
#endif
