/**
\file CapTk.cpp

\brief Main entry point for CapTk
*/

#include "fMainWindow.h"
#include "CAPTk.h"
//#include <QtPlugin>
//#include <QtSvg>

void setStyleSheet(const std::string &styleFileName = "../data/CaPTk.qss")
{
  std::string styleFileName_wrap = styleFileName;
	//std::cout << QDir::currentPath().toStdString();
  QFile f(styleFileName_wrap.c_str());
	if (!f.exists())
	{
    styleFileName_wrap = std::string(PROJECT_SOURCE_DIR) + "data/" + styleFileName_wrap;
    f.setFileName(styleFileName_wrap.c_str());
    if (!f.exists())
    {
      styleFileName_wrap = "CaPTk.qss";
      f.setFileName(styleFileName_wrap.c_str());
      if (!f.exists())
      {
        cbica::Logging(loggerFile, "Unable to set stylesheet, file not found");
        return;
      }
    }
  }

  f.open(QFile::ReadOnly | QFile::Text);
  QTextStream ts(&f);
  qApp->setStyleSheet(ts.readAll());
  f.close();
}
#ifdef _WIN32
// ensures no console pops up when launching the program
int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE prevInstance, LPSTR lpCmdLine, int nShowCmd)
{
  int argc = __argc;
  char **argv = __argv;
#else

int main(int argc, char** argv)
{
#endif

  cbica::createDir(loggerFolder);
  if (argc > 1)
  {
    if (strcmp(argv[1], "-rt") == 0 || strcmp(argv[1], "--run_test") == 0)
    {
      qSleep(std::rand() % 1000 + 1);
      // a FAR more meaningful test series needs to be added
      exit(EXIT_SUCCESS);
    }
    else
    {
      cbica::Logging(loggerFile, "This program has a graphical interface. Please don't try to use any command line parameters.");
      return EXIT_FAILURE;
    }
  }

  QApplication app(argc, argv);
  
  // initialize and store the size of the current screen
  SetScreenSize(QApplication::desktop()->screenGeometry());

  setStyleSheet();
#ifndef _WIN32
  std::string old_locale = setlocale(LC_NUMERIC, NULL);
  setlocale(LC_NUMERIC, "POSIX");
#endif

  app.processEvents();

  fMainWindow window;

#ifdef DEVELOPER_MODE
  //window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_flair_pp_shrunk.nii.gz").c_str());
  window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_flair_pp.nii.gz").c_str());
  window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_t1ce_pp.nii.gz").c_str());
#endif

  // show the "about" screen in the first run
  if (!cbica::fileExists(aboutScreenSeen))
  {
    window.about();
  }
  window.showMaximized();
  window.show();

#ifndef _WIN32
  setlocale(LC_NUMERIC, old_locale.c_str());
#endif

  return app.exec();
}

