///////////////////////////////////////////////////////////////////////////////////////
// fDrawingPanel.h
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fDrawingPanel_h_
#define _fDrawingPanel_h_


#include "CAPTk.h"
#include "Landmarks.h"
#include "ui_fDrawingPanel.h"


/**
\class fDrawingPanel

\brief This class controls the elements in the drawing panel of the tab
*/
class fDrawingPanel : public QWidget, private Ui::fDrawingPanel
{
  Q_OBJECT

public:
  //! Constructor
  fDrawingPanel(QWidget * parent = 0);

  //! Destructor
  ~fDrawingPanel() {}

signals :
  void DrawNearButtonClicked();
  void DrawFarButtonClicked();
  void EscapeButtonClicked();
  void EraseSelectedButtonClicked();
  void EraseNearButtonClicked();
  void EraseFarButtonClicked();
  void UndoButtonClicked();
  void CurrentBrushSizeChanged(int);

public slots :
  //! Enable near drawing functionality
  void DrawNearButton();

  //! Enable far drawing functionality
  void DrawFarButton();

  //! Converts system to normal mode from drawing/erasing mode
  void EscapeButton();

  //! Enable voxel based erase functionality
  void EraseSelectedButton();

  //! Erase near drawing
  void EraseNearButton();

  //! Erase far drawing
  void EraseFarButton();

  //! Change in the size of drawing/erasing brush
  void CurrentSizeChanged(int size);

  //! Undo drawing actions
  void UndoButtonFunctionality(); 
};


#endif
