/**
\file CAPTk.cpp

\brief Main entry point for CAPTk
*/

#include "fMainWindow.h"
#include "CAPTk.h"

void setStyleSheet(const std::string &styleFileName = STYLESHEET_FILE)
{
  string styleFileFullPath;
#ifdef DEVELOPER_MODE
  styleFileFullPath = QApplication::applicationDirPath().toStdString() + "/../../data/" + STYLESHEET_FILE;
#else
  styleFileFullPath = QApplication::applicationDirPath().toStdString() + "/" + STYLESHEET_FILE;
#endif

  QFile f(styleFileFullPath.c_str());
	if (!f.exists())
	{
      cbica::Logging(loggerFile, "Unable to set stylesheet, file not found");
  }
  else
  {
    f.open(QFile::ReadOnly | QFile::Text);
    QTextStream ts(&f);
    qApp->setStyleSheet(ts.readAll());
    f.close();
  }
}
#ifdef _WIN32
// ensures no console pops up when launching the program
int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE prevInstance, LPSTR lpCmdLine, int nShowCmd)
{
  int argc = __argc;
  char **argv = __argv;
#else

int main(int argc, char** argv)
{
#endif

  cbica::createDir(loggerFolderBase);
  cbica::createDir(loggerFolder);
  if (argc > 1)
  {
    if (strcmp(argv[1], "-rt") == 0 || strcmp(argv[1], "--run_test") == 0)
    {
      cbica::sleep();
      // a FAR more meaningful test series needs to be added
      exit(EXIT_SUCCESS);
    }
    else
    {
      cbica::Logging(loggerFile, "This program has a graphical interface. Please don't try to use any command line parameters.");
      return EXIT_FAILURE;
    }
  }

  QApplication app(argc, argv);
  setStyleSheet();
#ifndef _WIN32
  std::string old_locale = setlocale(LC_NUMERIC, NULL);
  setlocale(LC_NUMERIC, "POSIX");
#endif

  app.processEvents();

  fMainWindow window;

#ifdef DEVELOPER_MODE
  // window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_perf_pp.nii.gz").c_str());
  window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_flair_pp_shrunk.nii.gz").c_str());
  //window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_flair_pp.nii.gz").c_str());
  //window.runDevTestMode(std::string(std::string(DATA_DIR) + "AAAC/AAAC0_t1ce_pp.nii.gz").c_str());

  //auto svm2 = cv::Algorithm::load<cv::ml::SVM>("E:/Data/Survival/test/EighteenModelFile.xml");
  //auto svm1 = cv::Algorithm::load<cv::ml::SVM>("E:/Data/Survival/test/SixModelFile.xml");

#else
  // if test data is present, load it up otherwise forget about it
  std::string appDir = QApplication::applicationDirPath().toStdString();
  if (cbica::fileExists(appDir + "/data/AAAC0_flair_pp_shrunk.nii.gz"))
  {
    window.runDevTestMode((appDir + "/data/AAAC0_flair_pp_shrunk.nii.gz").c_str());
  }
  else if (cbica::fileExists(appDir + "/../data/AAAC0_flair_pp_shrunk.nii.gz"))
  {
    window.runDevTestMode((appDir + "/../data/AAAC0_flair_pp_shrunk.nii.gz").c_str());
  }
#endif

  // show the "about" screen in the first run
  if (!cbica::fileExists(aboutScreenSeen))
  {
    window.about();
  }
  //window.setFixedSize(QSize(2735, 1538)); // useful when doing video recording from SP4 and maintain 16x9 ratio
  window.showMaximized();
  window.show();

#ifndef _WIN32
  setlocale(LC_NUMERIC, old_locale.c_str());
#endif

  return app.exec();
}

