///////////////////////////////////////////////////////////////////////////////////////
// fDrawingPanel.cpp
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
// Contact details: software@cbica.upenn.edu
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#include "fDrawingPanel.h"
#include "CAPTk.h"
#include "fMainWindow.h"
#include "SlicerManager.h"
#include "Landmarks.h"
#include <QtSvg>
#include "qimage.h"
#include <QStyle>

fDrawingPanel::fDrawingPanel(QWidget * parent) : QWidget(parent)
{
  setupUi(this);



  connect(clearSelectedLabelButton, SIGNAL(clicked()), this, SLOT(clearSelectedLabelButtonFunctionality()));
  connect(clearAllLabelButton, SIGNAL(clicked()), this, SLOT(clearAllLabelButtonFunctionality()));
  connect(sizeComboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(CurrentSizeChanged(int)));
  connect(labelSelectorBox, SIGNAL(currentIndexChanged(int)), this, SLOT(CurrentLabelChanged(int)));
  connect(maskOpacitySpinBox, SIGNAL(currentIndexChanged(int)), this, SLOT(CurrentOpacityChanged(int)));
  connect(UndoButton, SIGNAL(clicked()), this, SLOT(UndoButtonFunctionality()));
  connect(shapeNoneButton, SIGNAL(clicked()), this, SLOT(shapesNoneButtonFunctionality()));
  connect(shapeEracerButton, SIGNAL(clicked()), this, SLOT(shapeEraceButtonFunctionality()));
  connect(shapeFreeHandButton, SIGNAL(clicked()), this, SLOT(shapeFreeHandButtonFunctionality()));
  connect(shapesLineButton, SIGNAL(clicked()), this, SLOT(shapesLineButtonFunctionality()));
  connect(shapesRectangleButton, SIGNAL(clicked()), this, SLOT(shapesRectangleButtonFunctionality()));
  connect(shapesCircleButton, SIGNAL(clicked()), this, SLOT(shapesCircleButtonFunctionality()));
}


void fDrawingPanel::clearSelectedLabelButtonFunctionality()
{

  emit clearMask(getSelectedDrawLabel());
}
void fDrawingPanel::clearAllLabelButtonFunctionality()
{
  emit clearMask();
}
void fDrawingPanel::CurrentSizeChanged(int size)
{
  emit CurrentBrushSizeChanged(size);
}

void fDrawingPanel::CurrentLabelChanged(int size)
{
  emit CurrentDrawingLabelChanged(size);
}

void fDrawingPanel::CurrentOpacityChanged(int size)
{
  emit CurrentMaskOpacityChanged(size);
}
void fDrawingPanel::UndoButtonFunctionality()
{
  emit UndoButtonClicked();
}

void fDrawingPanel::shapesNoneButtonFunctionality()
{
  enableShapeButton(shapeNoneButton);
  emit shapesButtonClicked(SHAPE_MODE_NONE);
}
void fDrawingPanel::shapeEraceButtonFunctionality()
{
  enableShapeButton(shapeEracerButton);
  emit shapesButtonClicked(SHAPE_MODE_ERACER);
}
void fDrawingPanel::shapeFreeHandButtonFunctionality()
{
  enableShapeButton(shapeFreeHandButton);
  emit shapesButtonClicked(SHAPE_MODE_FREE_HAND);
}
void fDrawingPanel::shapesLineButtonFunctionality()
{
  enableShapeButton(shapesLineButton);
  emit shapesButtonClicked(SHAPE_MODE_LINE);
}
void fDrawingPanel::shapesRectangleButtonFunctionality()
{
  enableShapeButton(shapesRectangleButton);
	emit shapesButtonClicked(SHAPE_MODE_RECTANGLE);
}
void fDrawingPanel::shapesCircleButtonFunctionality()
{
  enableShapeButton(shapesCircleButton);
  emit shapesButtonClicked(SHAPE_MODE_CIRCLE);
}



