#include "fSurvivalDialog.h"
#include "fProgressDialog.h"

fSurvivalPredictor::fSurvivalPredictor()
{
  setupUi(this);
  this->setWindowModality(Qt::NonModal);
  mode = -1;
  connect(cancelButton, SIGNAL(clicked()), this, SLOT(CancelButtonPressed()));
  connect(confirmButton, SIGNAL(clicked()), this, SLOT(ConfirmButtonPressed()));
  connect(existingMasksButton, SIGNAL(clicked()), this, SLOT(OpenExistingMasksDirectory()));
  connect(svmModelButton, SIGNAL(clicked()), this, SLOT(OpenSVMModelFile()));
  connect(testSubjectsDirectoryButton, SIGNAL(clicked()), this, SLOT(OpenTestSubjectsDirectory()));
  connect(outputDirectoryButton, SIGNAL(clicked()), this, SLOT(SelectOutputDirectory()));
  connect(rdExistingClassification, SIGNAL(toggled(bool)), this, SLOT(ExistingClassificationRadioButtonChecked()));
  connect(rdCreateModel, SIGNAL(toggled(bool)), this, SLOT(NewModelRadioButtonChecked()));

  //rdExistingClassification->setEnabled(false);
  //rdExistingClassification->setChecked(true);
  rdCreateModel->setChecked(true);
  NewModelRadioButtonChecked();
  
  //existingMaskDirectoryName->setEnabled(false);
  //existingMasksButton->setEnabled(false);
}
fSurvivalPredictor::~fSurvivalPredictor()
{
}
void fSurvivalPredictor::CancelButtonPressed()
{
  this->close();
}
void fSurvivalPredictor::ConfirmButtonPressed()
{
  if (rdExistingClassification->isChecked())
  {
    svmModelButton->setEnabled(true);
    svmModelFileName->setEnabled(true);
    testSubjectsDirectoryButton->setEnabled(true);
    testSubjectsDirectoryName->setEnabled(true);
    if (svmModelFileName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the directory of SVM model.");
      return;
    }
    if (testSubjectsDirectoryName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the directory of test subjects.");
      return;
    }
    if (outputDirectoryName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the output directory.");
      return;
    }
    emit SurvivalPredictionOnExistingModel(svmModelFileName->text().toStdString(), testSubjectsDirectoryName->text().toStdString(), outputDirectoryName->text().toStdString());
  }
  else
  {
    existingMaskDirectoryName->setEnabled(true);
    existingMasksButton->setEnabled(true);
    emit PrepareNewSurvivalPredictionModel(existingMaskDirectoryName->text().toStdString(), outputDirectoryName->text().toStdString());
  }
  this->close();
}

void fSurvivalPredictor::OpenSVMModelFile()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), mInputPathName, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    svmModelFileName->setText(directory);

  mInputPathName = directory;
}

void fSurvivalPredictor::OpenExistingMasksDirectory()
{
  std::string root_directory;
  //int imagetype;
  //if (!outputDirectoryName->text().toStdString().empty())
  //{ 
  //  root_directory = outputDirectoryName->text().toStdString();
  //}
  //else
  //{
  //  root_directory = mInputPathName.toStdString();
  //}
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), mInputPathName, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    existingMaskDirectoryName->setText(directory);

  mInputPathName = directory;
}


void fSurvivalPredictor::SelectOutputDirectory()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), mInputPathName, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    outputDirectoryName->setText(directory);
}
void fSurvivalPredictor::OpenTestSubjectsDirectory()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), mInputPathName, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    testSubjectsDirectoryName->setText(directory);

  mInputPathName = directory;
}

void fSurvivalPredictor::ExistingClassificationRadioButtonChecked()
{
  if (rdExistingClassification->isChecked())
  {
    svmModelButton->setEnabled(true);
    svmModelFileName->setEnabled(true);
    testSubjectsDirectoryButton->setEnabled(true);
    testSubjectsDirectoryName->setEnabled(true);
    existingMaskDirectoryName->setEnabled(false);
    existingMasksButton->setEnabled(false);
  }
}
void fSurvivalPredictor::NewModelRadioButtonChecked()
{
  if (rdCreateModel->isChecked())
  {
    svmModelButton->setEnabled(false);
    svmModelFileName->setEnabled(false);
    testSubjectsDirectoryButton->setEnabled(false);
    testSubjectsDirectoryName->setEnabled(false);
    existingMaskDirectoryName->setEnabled(true);
    existingMasksButton->setEnabled(true);
  }
}