function fout = hippo_filename(fin, varargin)
% Filename modification tools
% Syntax:
%     fout = hippo_filename(fin, 'option', 'value', ...)
% Parameters:
%     fin         One or more filenames
%     'option'    See below
% Output:
%     fout        Modified filename
% Options:
%     'p' 'prf'   Add prefix 'prf' to the filename (p.img -> prfp.img)
%     's' 'sfx'   Add suffix 'sfx' to the filename (p.img -> psfx.img)
%     'e' 'ext'   Set the extension to 'ext' (p.img -> p.ext)
%     'n' num     Append a number as in ',num' (p.img -> p.img,num)
%     'd' 'dir'   Change the directory to dir (foo/p.img -> dir/foo.img)

fout = [];

for i = 1:size(fin,1)

    [p f e v] = fileparts(deblank(fin(i,:)));
    for q = 1:2:nargin-1
        switch varargin{q}
        case {'p'}
            f = [varargin{q+1} f];
        case {'s'}
            f = [f varargin{q+1}];                
        case {'e'}
            e = varargin{q+1};
        case {'n'}
            v = [v sprintf(',%d',varargin{q+1})];
        case {'d'}
            p = varargin{q+1};
        end
    end

    fout = strvcat(fout, fullfile(p, [f e v]));

end
    
    

