function B = baseline_correction(A, npts)
% Peform baseline correction on 2D NMR data
% Usage:
%       B = baseline_correction(A, npts)
% Parameters:
%       A       A 2D complex spectrum (k-space)
%       npts    Number of correction points
% Output:
%       B       A corrected spectrum
% Notes:
%   A should be a complex matrix of size (np x nv), with the rows
%   in the readout direction and columns in the phase encode direction
%
%   * This method is adopted from Steve Pickup's IDL library

ss = size(A);
if length(ss) ~= 2
    error('A must be a 2d complex matrix');
end

np = ss(1);
nv = ss(2);

% Allocate output array
B = complex(zeros(np, nv));

% Compute the correction
corr = 0;
for i=1:nv
    corr = corr + sum(A(1+np-npts:np,i)) / npts + sum(A(1:npts,i)) / npts;
end
corr = corr / (2 * nv);

% Apply the correction
B = A - corr;



