function correct_darker_slices(fn_in, fn_out)
% correct_darker_slices
% ---------------------
% This function corrects Varian images where some of the slices appear
% darker than others. It tries to automatically detect the 'bad' slices
% and it uses an adhoc technique to correct them.
% ---------------------
% Usage: 
%       correct_darker_slices(fn_in, fn_out)
% Parameters:
%       fn_in           Input image (analyze format)
%       fn_out          Output image (analyzer too)
%
fprintf('test\n')

% Read the input data
v = spm_vol(fn_in);
Y = spm_read_vols(v);

% Compute the 85th quantile (?) of the intensity in each slice
x = quantile(reshape(Y,[],v.dim[3]),0.85);

% Detect the slices that need correction. The first and last slices are
% discarded because we don't have neighbor information
mx = median_filter(x, 1);
qx = (x - mx) ./ mx;
ix = find(qx(2:end-1) < -0.15) + 1;

% Apply the correction procedure to each slice (assume there are no
% adjacent bad slices)
for i = ix
    fprintf('Fixing slice %d\n',i)
    a = Y(:,:,i);
    b = Y(:,:,i-1);
    c = Y(:,:,i+1);
    da = 0.5 * (b + c) ./ a;
    mda = median_filter(da, 5);
    %gauss = pdf('norm',-32:32,0,8)' * pdf('norm',-32:32,0,8);
    %mda2 = conv2(mda,gauss,'same');
    afix = a .* mda;
    Y(:,:,i) = afix;
end

% Save the output image
v.fname = fn_out;
spm_write_vol(v, Y);
