function export_vars(fid,fn_analyze)
% Export some variables from the FID file to a text file

% Get the text file
[f_p f_f f_e f_v] = fileparts(fn_analyze);
fn_text = fullfile(f_p,[f_f '.txt']);
f = fopen(fn_text,'w');

% Write the common parameters
fprintf(f, 'SEQUENCE = %s\n',      read_procpar(fid, 'layout'));
fprintf(f, 'NAME = %s\n',          read_procpar(fid, 'name'));
fprintf(f, 'DATE = %s\n',          read_procpar(fid, 'date'));
fprintf(f, 'TR(s) = %f\n',         read_procpar(fid, 'tr'));
fprintf(f, 'TE(s) = %f\n',         read_procpar(fid, 'te'));
fprintf(f, 'TI(s) = %f\n',         read_procpar(fid, 'ti'));

% The following is for 3D sequences only
seq = read_procpar(fid, 'layout');

if strcmp(seq,'ge3d') || strcmp(seq,'se3d')
    
    % Get the FOV and the matrix
    fov(1) = read_procpar(fid, 'lro');
    fov(2) = read_procpar(fid, 'lpe');
    fov(3) = read_procpar(fid, 'lpe2');    
    mat(1) = read_procpar(fid, 'np') / 2;
    mat(2) = read_procpar(fid, 'nv');
    mat(3) = read_procpar(fid, 'nv2');
    
    % Write this information
    fprintf(f, 'FOV(mm) = (%.4f,%.4f,%.4f)\n', 10 * fov);
    fprintf(f, 'MATRIX = (%d,%d,%d)\n', mat);
    
else
    
    % Get the FOV and the matrix
    fov(1) = read_procpar(fid, 'lro');
    fov(2) = read_procpar(fid, 'lpe');
    mat(1) = read_procpar(fid, 'np') / 2;
    mat(2) = read_procpar(fid, 'nv');
    
    % Write this information
    fprintf(f, 'FOV(mm) = (%.4f,%.4f)\n', 10 * fov);
    fprintf(f, 'MATRIX = (%d,%d)\n', mat);
    fprintf(f, 'SLICE THICKNESS(mm) = %f\n', read_procpar(fid, 'thk'));
    fprintf(f, 'SLICE GAP(mm) = %f\n', read_procpar(fid, 'gap'));
    
end

% For DTI data, write a separate direction file
if is_dti(fid)

    % Write the diffusion parameters
    fprintf(f, 'Small delta(s) = %f\n', read_procpar(fid, 'tdelta'));
    fprintf(f, 'Big Delta(s) = %f\n', read_procpar(fid, 'tDELTA'));
        
end

% Close file
fclose(f);

