function recon_3d(path, fn_analyze)
% Reconstructs a 3D NMR image from Varian FID file, converts to Analyze
% Usage:
%       recon_3d(path)
% Parameters:
%       path        Directory containing the 'fid' file
%       fn_analyze  Analyze filename where to save the output
%

% Get the dimensions of the image
np = read_procpar(path,'np') / 2;
nv = read_procpar(path,'nv');
nv2 = read_procpar(path,'nv2');

% Get the FOV specification
lro = read_procpar(path,'lro');
lpe = read_procpar(path,'lpe');
lpe2 = read_procpar(path,'lpe2');

% Compute the voxel size in mm
vox(1) = 10 * lro / np;
vox(2) = 10 * lpe / nv;
vox(3) = 10 * lpe2 / nv2;
vox(4) = 1;
fprintf('Voxel Size: (%d, %d, %d)\n',vox(1:3));

% Read the FID file
[RE,IM,NP,NB,NT,HDR]=read_fid(path);
fprintf('Read FID: NP = %d, NB = %d, NT = %d\n',NP,NB,NT);

% Create the output image
Vi.fname = fn_analyze;
Vi.dim = [np nv nv2 64];
Vi.mat = diag(vox);
Vi.pinfo = [1;0;0];
Vo = spm_create_vol(Vi);

% Allocate data for output
Y = zeros(NP,NB,NT);

% There is no loop to do, but we must remap the image to a 3D k-space
kspace = reshape(complex(RE,IM),np,nv,nv2);

% Peform 3D fft
ispace = fftshift(fftn(fftshift(kspace)));
    
% Store the slice in Y
Y = abs(ispace);

% Save the output image
spm_write_vol(Vo, Y);