function [V pss]=recon_least_squares(fn_list, thk)
% Least squares based interleaved MRI reconstruction

% For each image, get the pss
min_pss = 0; max_pss = 0; nsi = 0; pssi=[]; thki = [];
for i = 1:size(fn_list,1)
    rec(i).pss = read_procpar(deblank(fn_list(i,:)),'pss');
    rec(i).thk = read_procpar(deblank(fn_list(i,:)),'thk');
    if i == 1
        min_pss = rec(i).pss(1);
        max_pss = rec(i).pss(end);
    else
        min_pss = max(min_pss, rec(i).pss(1));
        max_pss = min(max_pss, rec(i).pss(end));
    end
    nsi = nsi + length(rec(i).pss);
    pssi = [pssi; rec(i).pss];
    thki = [thki; 0.1 * rec(i).thk * ones(length(rec(i).pss), 1)];
end

% Generate a set of slices for the output
ns = floor((max_pss - min_pss) / thk);
pss = min_pss + 0.5 * (max_pss - (min_pss + ns * thk)) + thk * (0:ns-1);

% Now that we have an output slice array, generate an overlap matrix. We
% will currently assume that the slice selection profile is a box filter
W = zeros(nsi, ns);
for i = 1:nsi
    % Get the slice interval
    x1 = pssi(i) - 0.5 * thki(i);
    x2 = x1 + thki(i);
    
    % Find the range of slices that overlap this one
    iovl = find((pss >= x1 - 0.5 * thk) .* (pss <= x2 + 0.5 * thk));
    
    % Distribute the overlaps
    for j = iovl
        W(i, j) = (min(pss(j)+0.5*thk, x2) - max(pss(j)-0.5*thk, x1)) / thk;
    end
end;

% Compute the least squares fit matrix
A = inv(W'*W)*W';

% Read each of the datasets
icol = 1;
for i = 1:size(fn_list,1)
    
    % Read the volume
    Vi = read_multislice(deblank(fn_list(i,:)));
    [np nv nsi] = size(Vi);
    
    % If this is the first volume, use its dimensions to initialize 
    if i==1, V = complex(zeros(np, nv, ns)); end;
    
    % Reshape the data to flatten it
    S = reshape(Vi, [], nsi);
    
    % Multiply by the appropriate subset of the matrix
    AS = A(:,icol:icol+nsi-1) * S';
    icol = icol + nsi;
    
    % Add the result to the output
    V = V + reshape(AS', np, nv, ns);
end




    