function recon_varian(dir_fid, fn_analyze)
% Reconstructs a 3D NMR image from Varian FID file, converts to Analyze
% Usage:
%       recon_varian(path)
% Parameters:
%       path        Directory containing the 'fid' file
%       fn_analyze  Analyze filename where to save the output
% Notes:
%       This parent-level routine determines what type of file this FID
%       is and selects the appropriate reconstruction routine. 
%
%       Currently, this routine supports 2D and 3D sequences and DTI

% Get sequence
seq = read_procpar(dir_fid, 'layout');

% Choose 2D or 3D
if strcmp(seq,'ge3d') || strcmp(seq,'se3d')
    fprintf('RECONSTRUCTING 3D IMAGE %s\n',dir_fid);
    recon_3d(dir_fid, fn_analyze);
elseif is_dti(dir_fid)
    fprintf('RECONSTRUCTING DW-MRI SERIES %s\n',dir_fid);
    recon_dti(dir_fid, fn_analyze);
else
    fprintf('RECONSTRUCTING MULTI-SLICE IMAGE %s\n',dir_fid);
    recon_sems(dir_fid, fn_analyze);
end

% Write the text manifest
export_vars(dir_fid, fn_analyze);