\mainpage MOE 

  Section of Biomedical Image Analysis <br>
  Department of Radiology <br>
  University of Pennsylvania <br>
  Goddard Building <br>
  3701 Hamilton Walk, 6th Floor <br>
  Philadelphia, PA 19104 <br>

  Web:   http://www.cbica.upenn.edu/sbia/ <br>
  Email: sbia-software at uphs.upenn.edu

  Copyright (c) 2015 University of Pennsylvania. All rights reserved. <br>
  See http://www.cbica.upenn.edu/sbia/software/license.html or COPYING file.

<b> Author: </b>
Harini Eavani
Harini.Eavani@uphs.upenn.edu 
cbica-software@uphs.upenn.edu

===============
1. INTRODUCTION
===============
This software can be used for datasets where the reference group ("controls") and the affected group ("patients") cannot be separated by a single line ("hyperplane"). MOE combines multiple hyperplanes along with a clustering objective, to split the affected group into multiple sub-groups. This is done in such a manner that each of the resulting sub-group is separable from the reference group by a single line. 

See Figure in test/All_test_results.png, where the reference group is denoted by circles, and the affected group by triangles. In Case1, the affected group is not heterogeneous, as it is seperable from the reference group with a single line. Cases 2, 3, 4 require multiple lines to separate the affected group from the reference group.

This software works with data saved in comma-separated value format. Input features can be based on any type of data - volumes, density, connectivity, diffusion, clinical scores, cognitive data etc.

For more details, please read UserManual.pdf

===============
2. TESTING & INSTALLATION
===============

This software has been primarily implemented for Linux operating systems. It is implemented in Python.

----------------
 Dependencies
----------------
- Python 2.7.9
- Python library numpy 1.7.2
- Python library scipy 0.15.1
- Python library pandas 0.16.2
- Python library sklearn 0.15
- Python library matplotlib 1.4.3

Make sure all dependencies are met before proceeding with install.

From within the src/ folder, run: 

1) ./make test

This runs test.py from within the src directory. 

We have provided synthetic two dimensional data for four test cases. In each of these cases, data points denoted by circles are the reference (control) samples, while points denoted by triangles are the affected (patient) cases which are made up of heterogeneous sub-groups. These are located in src/test/Case∗. 

Test cases are used to check if the cross-validation accuracy in four test cases is greater than that of linear-SVM.

Proceed to the install step only if test passes in all four cases.

2) ./make install ${installDir}

Installation requires the installation directory as a user-input. 
This creates four folders within installDir - bin, libexec, share and doc.
bin/ contains the main executible moe.
libexec/ has all python scripts.
share/ has the test data.
doc/ has the doxygen documentation.

3) Add the binary folder to the system path:

export PATH=${PATH}:${installDir}/bin/

==========
3. Usage
==========

To run this software you will need:

1. An input csv file, with the following mandatory fields:
(a) Subject index in the first column
(b) Header row in the first row
(c) A column containing the binary group labels - the name of the column and the value of the patient group (of whose heterogeneous sub-groups you want to find) needs to be provided in the command line options.

For a csv file ROI_values.csv that looks like below:
    
    Subject_id, ROI_1, ROI_2, ROI_3, ..., Label, ...
    BLSA_0001, 0.234, 0.4545, 0.212,...., AD , ...
    BLSA_0002, 0.122, 0.1213, 0.3434,..., CN, ...  
    ...
    ...
    
Run the following command:
moe -d ROI_values.csv -p ROI_results -l AD -n 3 -o ./ -v


In the output directory, the software returns:
1. One python numpy file containing all the results, with file name <prefix>_results_allResults.npz
2. A csv file containing the hyperplanes, indexed against feature name in the first row. Filename <prefix>_results_hyperplanes.csv
3. A csv file containing the memberships, indexed against subject id in the first column. Filename <prefix>_results_memberships.csv
 
 
===========
4. LICENSING
===========

  See http://www.cbica.upenn.edu/sbia/software/license.html or "licences/COPYING" file.
