#!/usr/bin/env python
###########################################################################
# @package makeAll
# @brief This script installs MOE in user-provided install dir
# It takes as input 
# (1) install directory
# It outputs 
# bin/ libexec/ share/ doc/ within install dir
#
# @author Harini Eavani
#
# @link: https://www.cbica.upenn.edu/sbia/software/
#
# @author: sbia-software@uphs.upenn.edu
##########################################################################

import os, sys
from MOEUtils import *

## check input arguments
if len(sys.argv) < 2:
    cryandexit("Please specify a install directory")

## check if installDir exists
installDir = sys.argv[1]
if not os.path.exists(installDir):
    os.makedirs(installDir)
elif not os.path.isdir(installDir):
    cryandexit("Install argument is not a directory", installDir)    
## make path full path
installDir = os.path.abspath(installDir)
    
os.makedirs(installDir+'/bin')
os.makedirs(installDir+'/doc')
os.makedirs(installDir+'/libexec')
os.makedirs(installDir+'/share')


## copy all python dependencies to libexec
for pyf in ['MOE.py','SV_fuzzy.py','draw_moe_plot.py','MOEUtils.py','QP.py','test.py']:
    cmdArray=['cp',pyf,installDir+'/libexec/']
    execCmd(cmdArray,verbose=1,simulate=False,shell=True)
    pyFile=installDir+'/libexec/'+pyf
    if not fileExists(pyFile):
        cryandexit("Error in copying python files to libexec dir, ", pyFile," not found")

## make sym link to MOE.py
cmdArray=['ln','-s',installDir+'/libexec/MOE.py',installDir+'/bin/moe']
execCmd(cmdArray,verbose=1,simulate=False,shell=True)
if not fileExists(installDir+'/bin/moe'):
    cryandexit("Error creating symlink to MOE.py")

cmdArray=['chmod','u+x',installDir+'/bin/moe']
execCmd(cmdArray,verbose=1,simulate=False,shell=True)
    
## copy test files to share
cmdArray=['cp','-r','test/','test/All_test_results.png',installDir+'/share/']
execCmd(cmdArray,verbose=1,simulate=False,shell=True)
if not fileExists(installDir+'/share/'+'test/Case1/Case1.csv'):
    cryandexit("Error in copying test files to share dir, test/Case1/Case1.csv not found")
    
## generate documentation
cmdArray=['cd','../',';','doxygen','Doxyfile']
execCmd(cmdArray,verbose=1,simulate=False,shell=True)
if not os.path.exists('../docs/'):
    cryandexit("Error in building documentation, docs/ not found")
    
## copy to docs
cmdArray=['cp','-r','../docs/*',installDir+'/doc/']
execCmd(cmdArray,verbose=1,simulate=False,shell=True)
if not os.path.exists(installDir+'/doc/'):
    cryandexit("Error in copying documentation to doc dir, doc/ not found")
    