#!/usr/bin/env python
###########################################################################
# @package test
# @brief Script that runs all four synthetic test cases
# It takes as input 
# @param installDir the installation directory
# It outputs 
# bin/ libexec/ share/ doc/ within install dir
#
# @author Harini Eavani
#
# @link: https://www.cbica.upenn.edu/sbia/software/
#
# @author: sbia-software@uphs.upenn.edu
##########################################################################

import numpy as  np
from draw_moe_plot import draw_moe_plot
import pandas as pd
from MOEUtils import execCmd, fileExists, cryandexit
from SV_fuzzy import OutputVals

import os, sys

## check input arguments
if len(sys.argv) < 2:
    cryandexit("Please specify a install directory")

## check if installDir exists
installDir = sys.argv[1]
if not os.path.exists(installDir):
    cryandexit("Install dir does not exist", installDir)    
    
## make path full path
installDir = os.path.abspath(installDir)

## iterate through four test cases
N=[1,2,3,2]
testcases = ['Case'+str(i+1) for i in range(4)]
for e,testcase in enumerate(testcases):
    
    print('Running code on test '+str(testcase))
    ## set up input and output command line arguments
    inData=installDir+'/share/test/'+testcase+'/'+testcase+'.csv'
    prefix=testcase+'_results'
    outDir=installDir+'/share/test/'+testcase+'/'
    cmdArray=['moe','-d',inData,'-p',prefix,'-H','label','-l','1','-o',outDir,'-n',str(N[e]),'-c',str(1000)]
    ## call executable 
    execCmd(cmdArray,verbose=1,simulate=False)
    
    ## check if output file is created
    outputfile = outDir+'/'+prefix+'_allResults.npz'
    if not fileExists(outputfile):
        cryandexit("Error in running MOE, ", outputfile," not found")

    ## read input data
    mydata = pd.read_csv(inData,header=0,quotechar='"',sep=',',na_values = ['NA', '-', '.', ''],index_col=0)
    y = mydata['label'].as_matrix()
    mydata = mydata.drop('label', 1)
    X = mydata.as_matrix().astype('float64')    

    ## read output data
    
    out_data = np.load(outputfile)
    out_vals = OutputVals()
    out_vals.hyperplanes = out_data['hyperplanes']
    out_vals.intercepts = out_data['intercepts']
    out_vals.memberships = out_data['memberships']
    
    
    ## now draw the plot and save
    outImage = outDir+'/'+prefix+'_MOEplot.png'
    draw_moe_plot(X,y,out_vals,outImage)
    
