/***************** Header file for algorithms ************************
All the basic mathematical operations is based on OpenCV, Intel Corp.
All rights reserved. 2006.3.24 -- 2006.
*********************************************************************/

#include "CAlgorithm.h"
#include "CommonEx.h"
//#include "CRecognitionEx.h"
#define FREE_ARG char*


//*******************************************************************/
ublas::vector<double> NDP(ublas::matrix<double>& X, Var_matrix mat, double aa)
//ublas::vector<double> NDP(ublas::matrix<double>& X,ublas::vector<double> V,Var_matrix mat)

{
	//time_t s1 = clock();
	ublas::matrix<double> intraClass(mat.n,mat.m/2);
	ublas::matrix<double> transintraClass(mat.m/2,mat.n);
	ublas::matrix<double> eintraCov1(mat.n,mat.n);
	ublas::matrix<double> eintraCov2(mat.n,mat.n);
	ublas::matrix<double> meanCov1(mat.n,mat.n);
    ublas::matrix<double> A1(mat.n,mat.n);
	ublas::matrix<double> A2(mat.n,mat.n);
	meanCov1=ublas::zero_matrix<double>(mat.n,mat.n);
	A1=ublas::zero_matrix<double>(mat.n,mat.n);//////////////////////
    A2=ublas::zero_matrix<double>(mat.n,mat.n);//////////////////////
   
 	atlas::gemv(X,mat.E,mat.extraMean);

	for ( int j =  0; j < mat.nSmp1 ; j++ )
	 {
		ublas::matrix_column<ublas::matrix<double> > (intraClass, j)=ublas::matrix_column<ublas::matrix<double> > (X, j);
	 }
	atlas::gemv(intraClass,mat.E2,mat.intraMean1);

		for ( int ii = 0 ; ii < mat.n ; ii++ )
		{
			for ( int jj = 0 ; jj < mat.nSmp1 ; jj++ )
	           {
				  intraClass(ii,jj)-=mat.intraMean1(ii);
			   }
		}
	transintraClass=ublas::trans(intraClass);
	atlas::gemm(intraClass,transintraClass,eintraCov1);


	for ( int j =mat.nSmp1 ; j < mat.nSmp1+mat.nSmp2 ; j++ )
	{
		//ublas::matrix_column< ublas::matrix<double> > (mat.intraClass2, j-mat.nSmp1)=ublas::matrix_column<ublas::matrix<double> > (X, j);
	    ublas::matrix_column< ublas::matrix<double> > (intraClass, j-mat.nSmp1)=ublas::matrix_column<ublas::matrix<double> > (X, j);
	}

	atlas::gemv(intraClass,mat.E2,mat.intraMean1);
		for ( int ii = 0 ; ii < mat.n ; ii++ )
		{
			for ( int jj = 0 ; jj < mat.nSmp1 ; jj++ )
	           {
				  intraClass(ii,jj)-=mat.intraMean1(ii);
			   }
		}
	transintraClass=ublas::trans(intraClass);
	atlas::gemm(intraClass,transintraClass,eintraCov2);

	for ( int ii = 0 ; ii < mat.n ; ii++ )
      {
	  for ( int jj = 0 ; jj < mat.n ; jj++ )
		{
	          eintraCov1(ii,jj)+=eintraCov2(ii,jj);
		}
	}

	mat.intraMean1=mat.intraMean1-mat.extraMean;
 	atlas::ger(mat.intraMean1, mat.intraMean1, meanCov1);

 	for ( int ii = 0 ; ii < mat.n ; ii++ )
	{
		for ( int jj = 0 ; jj < mat.n ; jj++ )
		{
           cvSetReal2D(mat.A_rep,ii,jj,eintraCov1(ii,jj)*aa-meanCov1(ii,jj)*2);
		}
	}

	cvCopy(mat.A_rep, mat.AA); 
	cvEigenVV(mat.A_rep,mat.Eigvector,mat.Eigvalue,0.1);
	cvMinMaxLoc(mat.Eigvalue,&mat.minVal,&mat.maxVal);
	cvSetIdentity(mat.A_shift,cvRealScalar(mat.minVal));
	cvSub(mat.AA,mat.A_shift,mat.AA);

 	for ( int i = 0 ; i < mat.n ; i++ )
	{
	    
		//mat.b(i)=-0.99;
		mat.V(i)=1;
		for ( int j = 0 ; j < mat.n ; j++ )
		{
			double A_element=cvGetReal2D(mat.AA,i,j);
			if (A_element>0)
			{
				//mat.A1(i,j)=A_element;
				A1(i,j)=A_element;
			}
			else
			{
				//mat.A2(i,j)=-A_element;
				A2(i,j)=-A_element;
			}
		}
	}	

    for (int i = 0; i <15; i++ )
	{
		atlas::gemv(A1,mat.V,mat.a);
		atlas::gemv(A2,mat.V,mat.c);
		for ( int j = 0 ; j < mat.n ; j++ )
		 {
			 mat.a(j)=mat.a(j)+0.00000000000000001;
			 mat.ad(j)=(mat.b(j)+pow(16*mat.a(j)*mat.c(j)+pow(mat.b(j),2),0.5))/(4*mat.a(j));
		 }
		 mat.V=ublas::element_prod(mat.V,mat.ad);
     } 		

//   time_t t1 = clock();
	 //  cout<<"time1 = "<< t1-s1<<endl;
	return mat.V;

}
	
char ***cc3tensor(long nrh, long nch, long ndh)

/* allocate an unsigned  char 3tensor with range t[0..nrh-1][0..nch-1][0..ndh-1] */
{
  long i,j,nrow=nrh, ncol=nch, ndep=ndh;
  char  ***t;
  
  /* allocate pointers to pointers to  rows */
  t=(char  ***) malloc((size_t)((nrow)*sizeof(char **)));
  if (!t) nrerror("allocate failure 1 in cc3tensor()");
  
  /* allocate pointers to rows and set pointers to them */
  for(i=0;i<nrow;i++)  
    t[i]=(char **) malloc((size_t)((ncol)*sizeof(char*)));
  if(!t[nrh-1]) nrerror("allocation failure 2 in cc3tensor()");
  

  /* allocate rows and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
        t[j][i]=(char *) malloc((size_t)((ndep)*sizeof(char)));
  if(!t[nrh-1][nch-1]) nrerror(" allocation failure 3 in cc3tensor()");
    
  /* return pointers to array of pointers to rows  */
  return t;
}
 
float *fvector(long nh)
//allocate a float vector with subscript range v[nl..nh]  
{
  float *v;
  
  v=(float *)malloc((size_t)((nh)*sizeof(float)));
  if(!v) nrerror("allocation failure in vector()");
  return v;
}
 

float ****f4tensor(long nrh, long nch, long ndh, long nth)
/* allocate a float 4tensor with range t[0..nrh-1][0..nch-1][0..ndh-1][0..nth-1] */
{
  long i,j,k,nrow=nrh, ncol=nch, ndep=ndh, ntim=nth;
  float ****t;
  
  /* allocate pointers to pointers to  rows */
  t=(float ****) malloc((size_t)((nrow)*sizeof(float ***)));
  if (!t) nrerror("allocate failure 1 in f4tensor()");
  

  /* allocate pointers to rows and set pointers to them */
  for(i=0;i<nrow;i++)  
    t[i]=(float ***) malloc((size_t)((ncol)*sizeof(float**)));
  if(!t[nrh-1]) nrerror("allocation failure 2 in f4tensor()");
  

  /* allocate rows and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
        t[j][i]=(float **) malloc((size_t)((ndep)*sizeof(float *)));
  if(!t[nrh-1][nch-1]) nrerror(" allocation failure 3 in f4tensor()");

   /* allocate cols  and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
      for(k=0;k<ndep;k++)
        t[j][i][k]=(float *) malloc((size_t)((ntim)*sizeof(float)));
  if(!t[nrh-1][nch-1][ndh-1]) nrerror(" allocation failure 4 in f4tensor()");
    
  /* return pointers to array of pointers to rows  */
  return t;
}



void free_f4tensor(float ****t, long nrh, long nch, long ndh, long nth)
     /* free a float f4tensor allocated by f4tensor()  */
{
  long i,j,k;
  
  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
      for(k=0;k<ndh;k++)
       free((FREE_ARG)(t[i][j][k]));


  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
       free((FREE_ARG)(t[i][j])); 
  
  for(i=0;i<nrh;i++)
    free((FREE_ARG)(t[i])); 
  free((FREE_ARG)(t));   
}

void free_cc3tensor(char  ***t, long nrh, long nch, long ndh)
     /* free an unsigned char  c3tensor allocated by c3tensor()  */
{
  long i,j;
  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
       free((FREE_ARG)(t[i][j])); 
  
  for(i=0;i<nrh;i++)
    free((FREE_ARG)(t[i])); 
  free((FREE_ARG)(t));   
}

void nrerror(char error_text[])
/*Numerical Recipes standard handler */
{
  fprintf(stderr, "Numerical Recipes run-time error...\n");
  fprintf(stderr, "%s\n", error_text);
  fprintf(stderr, "... now exiting to system ...\n");
  exit(1);
}












