/***************** Header file for algorithms ************************
All the basic mathematical operations is based on OpenCV, Intel Corp.
All rights reserved. 2006.3.24 -- 2006.
A  
*********************************************************************/
#include "CEx.h"
#include "CAlgorithm.h"
#include <algorithm>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
 
////////////////////////////////////////////////////////////////
//void NDPSPACE(SubParas& subNDP,ublas::matrix<double>& X,Options opt,Var_matrix mat)
//{
//	NDPParas nParas;
//	nParas.U = 0;
	//nldaParas.numLabel = 0;
	//nldaParas.numLabel = opt.numLabel;
//	NDP(nParas,X,opt,mat);
	//subNDP.weight =mat.weight;
    //subNDP.U=nldaParas.U;		
	//cvMatMul(X,subNDP.U,subNDP.weight);	// training database*/
//}


/*********************************************************************************
/******************************************************/
void compMap(mapResults mapW,ublas::matrix<double>& X,Options opt,Var_matrix mat,ExDatabase  MRIdata, ublas::matrix<double>& fea, MapParas mParas)
{
   	 
	int cou=0;
	cvZero(mat.vot);
    double aa=opt.g;
	ublas::vector<double> V(opt.nNeighbor);
	ublas::matrix<double> fea2(opt.nSample,opt.nNeighbor);
	mat.nSmp1 = int(cvGetReal1D(opt.numLabel,0)); // number of samples per class
	mat.nSmp2 =  int(cvGetReal1D(opt.numLabel,1));
	mat.n = opt.nNeighbor; // number of samples per class
	mat.m = opt.nSample;
    time_t s1 = clock();
	for ( int i = 0 ; i < opt.nn; i++)
	{ 
		
		//time_t s2 = clock();
		if (MRIdata.NI_new(1,i)>0)
		    {
			  for ( int q = 0 ; q < opt.nSample ; q++)
			  {
					   for ( int p = 0 ; p < opt.nNeighbor; p++)
					   {
						   fea(p,q)=X(int(MRIdata.NI_new(p,i)-1),q);
					   }	   
			  }

		 mParas.sum11=0;
		 mParas.sum22=0;

		 for ( int j = 0 ; j < MRIdata.n/2 ; j++ ) 
	      {
			  for ( int ii = 0 ; ii <opt.nNeighbor; ii++)
			   {
				mParas.sum11+=fea(ii,j);
				mParas.sum22+=fea(ii,j+MRIdata.n/2);
			   }
		  }

		 if ((mParas.sum11>mParas.sum22)||(mParas.sum11==0))
	     {
		  V = ublas::zero_vector<double>(mat.n); 
		  mat.weight= ublas::zero_vector<double>(mat.n);
		  //cout<<"fdfdfdfdfdfdfdfd"<<endl;
		  cou++;
		 }
		 else
		 {
		   	//time_t t2 = clock();
			V =NDP(fea,mat,aa);
			// time_t s2 = clock();
			fea2=ublas::trans(fea);
	        //cout<<"time2 = "<< t2-s2<<endl;
	        atlas::gemv(fea2,V,mat.weight);	
			//cout<<"V = "<< V(100)<<endl;
		 }
	     mParas.sum1=0;
		 mParas.sum2=0;
		 mParas.sw1=0;
		 mParas.sw2=0;
		 for ( int j = 0 ; j < MRIdata.n/2 ; j++ ) 
	      {
		       mParas.sum1+=mat.weight(j);
			   mParas.sum2+=mat.weight(j+MRIdata.n/2);
		  }
         mParas.me1=mParas.sum1/MRIdata.n/2;
		 mParas.me2=mParas.sum2/MRIdata.n/2;
         if (mParas.sum1>mParas.sum2)
	     {
	     	V = ublas::zero_vector<double>(mat.n);
	     }
         for ( int j = 0 ; j < opt.nNeighbor ; j++)
		 {
			cvSetReal2D (mapW.W1,j,i,V(j));
		 }
	

		 for ( int j = 0 ; j < MRIdata.n/2 ; j++ ) 
	      {
			   mParas.sw1+=pow(fabs(mat.weight(j)-mParas.me1),2);
			   mParas.sw2+=pow(fabs(mat.weight(j+MRIdata.n/2)-mParas.me2),2);
		  }    
	
         mParas.sw=pow(mParas.sw1+mParas.sw2,0.5);
         mParas.diff=(mParas.me2-mParas.me1);
		 		  
		 mParas.delta=(mParas.diff/mParas.sw)*pow(opt.nSample-2,0.5);
		 if (mParas.diff>0)
		 {
		    if (mParas.sw!=0)
		    {
			  mParas.voti=pow(mParas.delta,opt.aa);
		    }
		    else
		     {
              mParas.voti=0;
		     }
		 }
		 else
	      {
           if (mParas.sw!=0)
		   {
		      mParas.voti=pow (-mParas.delta,opt.aa);
		   }
		   else
		   {
            mParas.voti=0;
		   }
		  }
          cvSetReal1D(mat.vot,i,mParas.voti);
	 //  cout<<"wwwwwwwww = "<< mParas.voti<<endl;
      }
	 // time_t t2 = clock();
	// cout<<"time1 = "<< t2-s2<<endl;
	 // cout<<"cou = "<< cou<<endl;
	 // cout<<"i = "<< i<<endl;		
	}



	  time_t t1 = clock();
	  cout<<"time = "<< t1-s1<<endl;
  	     

   for (int i = 0 ; i < opt.nn; i++)
	{
			for ( int j = 0 ; j <opt.nNeighbor; j++)
			{
               int index=int(cvGetReal2D(MRIdata.NI,j,i))-1;
			   if (index>-1)
			   {
				  cvSetReal1D(mapW.map1,index,cvGetReal1D(mapW.map1,index)+cvGetReal2D(mapW.W1,j,i)*cvGetReal1D(mat.vot,i));
			   }
	        }
	}
}	   
//////////////////////////////////////////////////////////////////
/*********************************************************************************/
bool readDatabase(ExDatabase& database,const char* name1, const char* name2)
{
	//if ( !database.index ) 
	//{
		database.index = cvCreateMat(database.m,1,CV_32FC1);
	//}
	//if ( !database.NI ) 
	//{
		database.NI = cvCreateMat(database.NE,database.nn,CV_32FC1);
	//}

	if ( ! readData(database.index,name1) )
		return false;
	 
	if ( ! readData(database.NI,name2) )
	    return false;

	return true;
}
/******************************************************************/
int* random(int n)   
{   
   int *d =  new  int[n];   

   srand( (unsigned)time( NULL ) );

   for( int i = 0;  i < n;i++ )
   {
	   *(d+i)=rand();
   }
   return d;
   delete d;
    
}
/******************************************************************/
Var_matrix init_mat(Var_matrix matt, int n,int m,int N, int type)
{
	
	matt.A_shift = cvCreateMat(n,n,CV_32FC1);
	matt.A_rep =cvCreateMat(n,n,CV_32FC1);
	matt.AA =cvCreateMat(n,n,CV_32FC1);
	matt.vot = cvCreateMat(N,1,CV_32FC1); 
	matt.Eigvector	= cvCreateMat(n,n,CV_32FC1);
	matt.Eigvalue	= cvCreateMat(1,n,CV_32FC1);
	matt.intraMean1 = ublas::vector<double>(n);
	matt.intraMean2 = ublas::vector<double>(n);
	matt.extraMean = ublas::vector<double>(n);
	matt.a = ublas::vector<double>(n);
	matt.b = ublas::vector<double>(n);
	matt.c = ublas::vector<double>(n);
	matt.ad = ublas::vector<double>(n);
	matt.V = ublas::vector<double>(n);
	matt.weight = ublas::vector<double>(n);
	matt.E = ublas::vector<double>(m);
	matt.E2 = ublas::vector<double>(m/2);

	for ( int i = 0 ; i < m ; i++ )
	{
		matt.E(i)=1.0/m;
	}
  	for ( int i = 0 ; i < m/2 ; i++ )
	{
		matt.E2(i)=2.0/m;
	}
	for ( int j = 0 ; j < n ; j++ )
	{
	   matt.b(j)=-0.99;
	}

	return matt;

}
/******************************************************************/

int* randperm(int n)
{
	int  *d =random(n);
 	int  *rep_d=  new  int[n];
	for( int i = 0;  i < n;i++ ) 
	{
       *(rep_d+i)=*(d+i);
	}
		

	sort(d,d+n);
 
	int *ind_sort =  new int[n];
	for( int i = 0;  i < n;i++ ) 
	{
		for( int j = 0;  j < n;j++ ) 
		{
           if (*(rep_d+i)==*(d+j))
		   {
			   *(ind_sort+j)=i+1;
		   }
		}
	}

	return ind_sort;
	delete rep_d;
	delete ind_sort;

}
FeatureExtraction::FeatureExtraction()
{
  // Default parameters for debugging
  _DebugFlag = True;

}

FeatureExtraction::~FeatureExtraction()
{
}

inline void FeatureExtraction::Debug(char *message)
{
  if (_DebugFlag == True) printf("\n %s \n", message);
}

void FeatureExtraction :: SetInput (char *sublist, int subject_id)
{
  //this->Debug("SetInput");
  
  _file_sublist = sublist;
  
  _subject_id       = subject_id;

}

void FeatureExtraction::GetInput()
{
  //this->Debug("GetInput");
  FILE *fp;
  if((fp=fopen(_file_sublist,"r"))==NULL)
    {
      printf("\n cannot open file %s.\n",_file_sublist);
      exit(1);
    }

  int num_subj, num_feat;
  int xdim, ydim, zdim;
  char root[10240];
  if(fscanf(fp,"%d %d",&_num_subject,&_num_feature)!=2)
    {
      printf("\n please check file %s (num_subject).\n",_file_sublist);
      exit(1);
    }
    
  if(fscanf(fp,"%d %d %d",&_xdim,&_ydim,&_zdim)!=3)
    {
      printf("\n please check file %s (dimension).\n",_file_sublist);
      exit(1);
    }

 //  char  dir_str [200];
 
  if(fscanf(fp,"%s",_data_root_dir)!=1)
   //if(fscanf(fp,"%s",dir_str)!=1)
    {
      printf("\n please check file %s.(data root)\n",_file_sublist);
      exit(1);
    }
  //_data_root_dir=dir_str;
  _file_name = cc3tensor(_num_subject,_num_feature,1024);
  _label  = fvector(_num_subject);
  int tmp;
  for(int i=0; i<_num_subject; i++)
    {
      for(int j=0; j<_num_feature; j++)
	{
	  if(fscanf(fp,"%s", _file_name[i][j])!=1)
	     {
	       printf("\n please check file (file_name) %s.\n",_file_sublist);
	       exit(1);
	     }
	
	}
      if(fscanf(fp,"%d", &tmp)!=1)
	{
	  printf("\n please check file %s.(label)\n",_file_sublist);
	  exit(1);
	}
     _label[i] = tmp;

    }
  
  fclose(fp);
  
  for(int i=0; i<_num_subject; i++)
    {
     if(fabs(_label[i])!=1.0)
	{
	  //printf("\n please check file1 %s.\n",_label[i]);
	 
	  printf("\n please check file1 %s.\n",_file_sublist);
	  exit(1);
	}
    }
	  
}

void FeatureExtraction::Initialize()
{

  this->Debug("Initialize");
  
  _im_size = _xdim * _ydim * _zdim;

  _feature_data = f4tensor(_num_subject, _xdim, _ydim, _zdim);
 
}


void FeatureExtraction::Finalize()
{

  this->Debug("Finalize");
  
 // free_f4tensor(_feature_data, _num_subject, _xdim, _ydim, _zdim);
  free_cc3tensor(_file_name, _num_subject,_num_feature,1024);
  	  
  //delete [] _data_root_dir;
}

void FeatureExtraction::Run( )
{
  GetInput();
  Initialize();
  if(_subject_id>=0)
    {
      for(int feat=0; feat<_num_feature; feat++)
	{
	  ReadData(feat);
	}
    }
  else
    {
      printf("\n subject_id should be in the range of 0 to num_subject-1.\n");
      exit(1);
    }
 
  Finalize();
}
void FeatureExtraction::ReadData(int feat)
{
  this->Debug("ReadData");
  
  FILE *fp;
  short tmp;
  
  char filename[1024];
   
  _num_po_subject = 0;
  _num_ne_subject = 0;
  for(int i=0; i<_num_subject; i++)
    {
      if(_label[i]>0)
	_num_po_subject += 1;
      else
	_num_ne_subject += 1;
    }

 
 origin_data = cvCreateMat(_zdim*_ydim*_xdim,_num_subject,CV_32FC1);
 
  for(int i=0; i< _num_subject; i++)
    {
      sprintf(filename, "%s/%s",_data_root_dir,_file_name[i][feat]);
      if((fp = fopen(filename, "rb"))== NULL)
	{
	  printf("\n could not open file1: %s\n",filename);
	  exit(1);
	}
      printf(".");
    //printf("\n please check file %s.(data root)\n",_num_subject);

	  for(int kk=0; kk<_zdim*_ydim*_xdim; kk++)
	  {
	    fread(&tmp,sizeof(short),1,fp);
		cvSetReal2D(origin_data,kk,i,tmp);
		//database.X = cvCreateMat(1019712,1,CV_32FC1);
	  }	  
	/*
	  int tttt=0;
      for(int kk=0; kk<_zdim; kk++)
	  for(int jj=0; jj<_ydim; jj++)
	  for(int ii=0; ii<_xdim; ii++)
	    {
	      fread(&tmp,sizeof(short),1,fp);
		  tttt++;
	      _feature_data[i][ii][jj][kk] = tmp;
		  if (tmp>1000)
		  {
			  int fff=0;
		  }
	    }
	*/
      fclose(fp);
    }
}

int isfiles(char (*arr)[40], string path)
{
	struct dirent *de=NULL;
  DIR *d=NULL;
  char *filename;
  int len; 
  d=opendir(path.c_str());
  if(d == NULL)
  {
    perror("Couldn't open directory");
    return(2);
  }
///////////////////////////
   int count=0;
   while((de = readdir(d))!=NULL)
   {
	  filename=de->d_name;
	  len=strlen(filename);
	  char* ff=filename+len-3;
	  if(strcmp (ff,"txt") == 0)
	  {   
		  strcpy(arr[count], filename);
		  count++;
	  }
   }
  closedir(d);
  return count;
}

void ex_number(char *s)
{   
   char *p=s,*q=s;
   while (*p)
   {
      if(*p>='0' && *p<='9') *q++=*p++;
      else p++;
   }
   *q='\0';
}
