#include "CEx.h"
#include <getopt.h>

void usage()
{
	printf( " \n This program implements a new group analysis method");
 
	printf( " \n Usage: ODVBA (data.list) (index.txt) (NI.txt) [options]");
 
	printf( " \n Required parameters:");
	printf( " \n   data.list   : the input file containing the location of the data");
	printf( " \n   index.txt   : location of non-zero voxel in the volumes");
	printf( " \n   NI.txt      : location of neighorhood for each voxel in the volumes");
   
	printf( " \n Optional parameters:");
	printf( " \n  [-m    <int>     ]  number of non-zero voxel in the volumes(length of the vector in index.txt)");
	printf( " \n  [-n    <int>     ]  number of the selected neighborhoods");
	printf( " \n  [-e    <int>     ]  number of the selected voxel in each neighborhood");
	printf( " \n  [-p    <int>     ]  the times of relabeling in the permutation test");
	printf( " \n  [-a    <double>  ]  phi in the discrimination degree defined in the Eq.(4) of the MICCAI paper");

	printf( " \n More information:");
	printf( " \n Email to tianhao.zhang@uphs.upenn.edu");
 

	printf( " \n Suggested use: qsub-run ./bin/ODVBA ../list/subjects.list ../list/index.txt ../list/NI.txt -m 197364 -n 10000 -e 400  -p 100 -a 1");
	printf( " \n ");
}

int main(int argc, char **argv)
{
 
 static struct option long_options []=
 {
	 {"usage", no_argument, 0, 'u'},
	 {"help", no_argument, 0, 'h'},
	 {"version", no_argument, 0, 'v'},
 };

  ExDatabase datapara; 
  Options opt;

  if(argc<3){
	usage();
	exit(1); 
  }

	char *sublist  = argv[1];
	argc--;
	argv++;
	char *name_index  = argv[1];
	argc--;
	argv++;
	char *name_NI  = argv[1];
	argc--;
	argv++;
	
	int c, option_index = 0;

  if(argc!=3){
	  while ((c = getopt_long (argc, argv, "m:n:e:p:a:",
               long_options, &option_index)) != -1){
      switch (c)
      {
        case 'm':
	
		  //printf ("datapara.m with value '%s'\n", optarg);
          datapara.m =atol(optarg);    
          break; 

		case 'n':
        datapara.nn= atol(optarg);
        break;

        case 'e':
          datapara.NE=atoi(optarg);
          break;

		case 'p':
          opt.nPerm=atoi(optarg);
          break;
		
		  
		case 'a':
          opt.aa=atof(optarg);
          break;

		 // case 's':
         // opt.nn=atof(optarg);
         // break;

      case '?':
          /* getopt_long already printed an error message. */
		  usage();
          exit(1);
        //  default:
        //  return 1;
      }
    }
  }
 // char *sublist  = argv[1];
   //char *sublist = "test_sub.lst";
  //argc--;
  //argv++;
  int subject_id      = 2;
  //argc--;
  //argv++;
  printf("\n The input options are below:"); 
  printf("\n ===============================================\n");
  printf("\n sublist:      %s",sublist);
  printf("\n name_index:   %s",name_index);
  printf("\n name_NI:      %s",name_NI);
  
  printf("\n m:      %d",datapara.m);
  printf("\n n:      %d",datapara.nn);
  printf("\n e:      %d",datapara.NE);
  printf("\n p:      %d",opt.nPerm);
  printf("\n a:      %f",opt.aa);
  //printf("\n s:      %d",opt.nn);
  
  printf("\n ==============================================\n");

  FeatureExtraction *featExt = new FeatureExtraction;  
  featExt->SetInput (sublist, subject_id);
  featExt->Run();
 
  datapara.n = featExt->_num_subject;	    // dimensionality of samples
  //datapara.nn=int(datapara.m/datapara.DS);
  opt.nn=datapara.nn;
  opt.g=0.000001;

//cout<<"opt.g = "<< opt.g<<endl;
//cout<<" opt.nn = "<<  opt.nn<<endl;

readDatabase(datapara,name_index,name_NI);// Make the data input
CvMat* NI = datapara.NI;
   //datapara.NI=0;
  // datapara.index=0;
     // writeData(NI,"fdffdf2.txt");
  // CvMat* X = cvCreateMat(datapara.m,featExt->_num_subject,CV_32FC1);
   ublas::matrix<double> X(datapara.m,featExt->_num_subject);
   createX(X, featExt->origin_data,datapara.index);  

    //for ( int p = 0 ; p < datapara.m ; p++)
	//{
		//for ( int q = 0 ; q<featExt->_num_subject ; q++)
		//{
		//    X_new(p,q)=cvGetReal2D(X,p,q);
		//}
	//}
 
   datapara.NI_new=ublas::matrix<double>(datapara.NI->height,datapara.NI->width);
   for ( int p = 0 ; p < datapara.NI->height ; p++)
	 {
		for ( int q = 0 ; q< datapara.NI->width ; q++)
		{
			datapara.NI_new(p,q)=cvGetReal2D(datapara.NI,p,q);
		}
	}
/*****************************************************/
  opt.nNeighbor=datapara.NE;
  opt.nSample=datapara.n;
  opt.gnd=cvCreateMat(opt.nSample,1,CV_32F);
  opt.numLabel=cvCreateMat(1,2,opt.gnd->type);
	//datapara.gnd= cvCreateMat(datapara.m, 1, CV_32FC1);
	for ( int i = 0 ; i < 2 ; i++ )
	{
		cvSetReal1D(opt.numLabel,i,opt.nSample/2);
	}
	MapParas mParas;
	
    ublas::matrix<double> fea(opt.nNeighbor,opt.nSample);
	mapResults mapW;
	mapW.map1= cvCreateMat(datapara.m,1, CV_32FC1);
	mapW.W1= cvCreateMat(opt.nNeighbor,datapara.nn,CV_32FC1);

    Var_matrix mat;
	mat= init_mat(mat,opt.nNeighbor,opt.nSample,datapara.nn,opt.nSample);
 	//mat.vot2 = cvCreateMat(N,1,CV_32FC1); 
/*****************************************************/
	cvZero(mapW.map1);
	compMap(mapW,X,opt,mat,datapara,fea,mParas);

/*****************************************************/
	CvMat* permResult=cvCreateMat(opt.nPerm+1, datapara.m,CV_32FC1);
	cvZero(permResult);
	for ( int i = 0; i < datapara.m; i++ )
    {
	cvSetReal2D(permResult,0,i,cvGetReal1D(mapW.map1,i));
    }
 
    //CvMat* X2 = cvCreateMat(datapara.m,datapara.n,CV_32FC1); 
	ublas::matrix<double> X2(datapara.m,featExt->_num_subject);

 
    char str[5];
    string name1="../results/";	

    for ( int i = 1; i < opt.nPerm+1; i++ )
    {
	  cvZero(mapW.map1);
	  cvZero(mapW.W1);
	  int* ra=randperm(opt.nSample);
	  for ( int k = 0 ; k < datapara.n ; k++ )
	  {
		for ( int j = 0 ; j < datapara.m; j++ )
	    {
			//cvSetReal2D(X2,j,*(ra+k)-1,cvGetReal2D(X,j,k));
			 X2(j,*(ra+k)-1)=X(j,k);
	    }     
	  }
 	
   	 // for ( int p = 0 ; p < datapara.m ; p++)
	  // {
		//	for ( int q = 0 ; q<featExt->_num_subject ; q++)
		//	{
			//	X2_new(p,q)=cvGetReal2D(X2,p,q);
			//}
	  //}
      compMap(mapW,X2,opt,mat,datapara,fea,mParas);

	  for ( int j = 0; j < datapara.m; j++ )
      {
		cvSetReal2D(permResult,i,j,cvGetReal1D(mapW.map1,j));	
      }
	}

/*****************************************************/

    string savename_txt = name1 +"perm.txt";
    printf ("datapara.m with value '%s'\n", savename_txt.c_str());
    writeData(permResult,savename_txt.c_str());
 
/*****************************************************/
    if (datapara.NI )cvReleaseMat(&datapara.NI);
    //if (permResult )cvReleaseMat(&permResult);
/*****************************************************/ 

	 CvMat* pvalue=cvCreateMat(datapara.m,1, CV_32FC1);
	 CvMat* pimage=cvCreateMat(featExt->_im_size,1, CV_32FC1);
     cvZero(pvalue);
     for ( int j = 1; j < opt.nPerm+1; j++ )
	   for ( int i = 0; i < datapara.m; i++ )
     {   
	   {
	   if ((cvGetReal2D(permResult,j,i)>cvGetReal2D(permResult,0,i))||(cvGetReal2D(permResult,j,i)==cvGetReal2D(permResult,0,i)))
	   cvSetReal1D(pvalue,i,cvGetReal1D(pvalue,i)+1);
	   }
     }
     for ( int i = 0; i < featExt->_im_size; i++ )
     {   
	   cvSetReal1D(pimage,i,1);
     }
     for( int i = 0; i < datapara.m; i++ )
     {  
	  cvSetReal1D(pimage,int(cvGetReal1D(datapara.index,i)),cvGetReal1D(pvalue,i)/opt.nPerm);
     }

 /*****************************************************/
     string savename = name1+"p.img";
     writeimg(pimage,savename.c_str());

 /*****************************************************/
	 return 0;
}
		
			
		

