/*******************************************************

Functions for Constructing the neighorhoods.

last modified : Dec 4, 2010

Contact: Tianhao Zhang(tianhao.zhang@uphs.upenn.edu)

*******************************************************/
#include "CFunction.h"


#define FREE_ARG char*
 
bool readDatabase(ExDatabase& database,const char* name1)
{

		database.index = cvCreateMat(database.m,1,CV_32FC1);

	if ( ! readData(database.index,name1) )
		return false;

	return true;
}
/******************************************************************/
int* random(int n)   
{   
   int *d =  new  int[n];   

   srand( (unsigned)time( NULL ) );

   for( int i = 0;  i < n;i++ )
   {
	   *(d+i)=rand();
   }
   return d;
   delete d;
    
}

/******************************************************************/

int* randperm(int n)
{
	int  *d =random(n);
 	int  *rep_d=  new  int[n];
	for( int i = 0;  i < n;i++ ) 
	{
       *(rep_d+i)=*(d+i);
	}
		
	sort(d,d+n);
 
	int *ind_sort =  new int[n];
	for( int i = 0;  i < n;i++ ) 
	{
		for( int j = 0;  j < n;j++ ) 
		{
           if (*(rep_d+i)==*(d+j))
		   {
			   *(ind_sort+j)=i+1;
		   }
		}
	}

	return ind_sort;
	delete rep_d;
	delete ind_sort;

}
FeatureExtraction::FeatureExtraction()
{
  // Default parameters for debugging
  _DebugFlag = True;

}

FeatureExtraction::~FeatureExtraction()
{
}

inline void FeatureExtraction::Debug(char *message)
{
  if (_DebugFlag == True) printf("\n %s \n", message);
}

void FeatureExtraction :: SetInput (char *sublist, int subject_id)
{
  //this->Debug("SetInput");
  
  _file_sublist = sublist;
  
  _subject_id       = subject_id;

}

void FeatureExtraction::GetInput()
{
  //this->Debug("GetInput");
  FILE *fp;
  if((fp=fopen(_file_sublist,"r"))==NULL)
    {
      printf("\n cannot open file %s.\n",_file_sublist);
      exit(1);
    }

  int num_subj, num_feat;
  int xdim, ydim, zdim;
  char root[10240];
  if(fscanf(fp,"%d %d",&_num_subject,&_num_feature)!=2)
    {
      printf("\n please check file %s (num_subject).\n",_file_sublist);
      exit(1);
    }
    
  if(fscanf(fp,"%d %d %d",&_xdim,&_ydim,&_zdim)!=3)
    {
      printf("\n please check file %s (dimension).\n",_file_sublist);
      exit(1);
    }

 //  char  dir_str [200];
 
  if(fscanf(fp,"%s",_data_root_dir)!=1)
   //if(fscanf(fp,"%s",dir_str)!=1)
    {
      printf("\n please check file %s.(data root)\n",_file_sublist);
      exit(1);
    }
  //_data_root_dir=dir_str;
  _file_name = cc3tensor(_num_subject,_num_feature,1024);
  _label  = fvector(_num_subject);
  int tmp;
  for(int i=0; i<_num_subject; i++)
    {
      for(int j=0; j<_num_feature; j++)
	{
	  if(fscanf(fp,"%s", _file_name[i][j])!=1)
	     {
	       printf("\n please check file (file_name) %s.\n",_file_sublist);
	       exit(1);
	     }
	
	}
      if(fscanf(fp,"%d", &tmp)!=1)
	{
	  printf("\n please check file %s.(label)\n",_file_sublist);
	  exit(1);
	}
     _label[i] = tmp;

    }
  
  fclose(fp);
  
  for(int i=0; i<_num_subject; i++)
    {
     if(fabs(_label[i])!=1.0)
	{
	  //printf("\n please check file1 %s.\n",_label[i]);
	 
	  printf("\n please check file1 %s.\n",_file_sublist);
	  exit(1);
	}
    }
	  
}

void FeatureExtraction::Initialize()
{

  this->Debug("Initialize");
  
  _im_size = _xdim * _ydim * _zdim;

  _feature_data = f4tensor(_num_subject, _xdim, _ydim, _zdim);
 
}

void FeatureExtraction::Finalize()
{

  this->Debug("Finalize");
  
 // free_f4tensor(_feature_data, _num_subject, _xdim, _ydim, _zdim);
  free_cc3tensor(_file_name, _num_subject,_num_feature,1024);
  	  
  //delete [] _data_root_dir;
}

void FeatureExtraction::Run( )
{
  GetInput();
  Initialize();
  if(_subject_id>=0)
    {
      for(int feat=0; feat<_num_feature; feat++)
	{
	  ReadData(feat);
	}
    }
  else
    {
      printf("\n subject_id should be in the range of 0 to num_subject-1.\n");
      exit(1);
    }
 
  Finalize();
}
void FeatureExtraction::ReadData(int feat)
{
  this->Debug("ReadData");
  
  FILE *fp;
  short tmp;
  
  char filename[1024];
   
  _num_po_subject = 0;
  _num_ne_subject = 0;
  for(int i=0; i<_num_subject; i++)
    {
      if(_label[i]>0)
	_num_po_subject += 1;
      else
	_num_ne_subject += 1;
    }

 
 origin_data = cvCreateMat(_zdim*_ydim*_xdim,_num_subject,CV_32FC1);
 
  for(int i=0; i< _num_subject; i++)
    {
      sprintf(filename, "%s/%s",_data_root_dir,_file_name[i][feat]);
      if((fp = fopen(filename, "rb"))== NULL)
	{
	  printf("\n could not open file1: %s\n",filename);
	  exit(1);
	}
      printf(".");
    //printf("\n please check file %s.(data root)\n",_num_subject);

	  for(int kk=0; kk<_zdim*_ydim*_xdim; kk++)
	  {
	    fread(&tmp,sizeof(short),1,fp);
		cvSetReal2D(origin_data,kk,i,tmp);
		//database.X = cvCreateMat(1019712,1,CV_32FC1);
	  }	  

      fclose(fp);
    }
}

void randperm2(int n, int perm[])
{
	int i, j, t;

	for(i=0; i<n; i++)
		perm[i] = i;
	for(i=0; i<n; i++) {
		j = rand()%(n-i)+i;
		t = perm[j];
		perm[j] = perm[i];
		perm[i] = t;
	}
}

bool writeData(CvMat* X,const char* name)
{
	long i,j,ii;

    FILE* pFile = fopen(name, "w"); 
    i=0;
    j=0;
    ii=0;

 	for ( int k = 0; k<X->width*X->height; k++ )
	{
		if (j >= X->width)
		{
			i++;
			j=0;
			fprintf(pFile,"%s","\n");   
		}
		if(i < X->height)
		{
			fprintf(pFile,"%f ", cvGetReal2D(X,i,j) );
			j++;
		}
	}
	 fclose(pFile);
     return true;
}

char ***cc3tensor(long nrh, long nch, long ndh)

/* allocate an unsigned  char 3tensor with range t[0..nrh-1][0..nch-1][0..ndh-1] */
{
  long i,j,nrow=nrh, ncol=nch, ndep=ndh;
  char  ***t;
  
  /* allocate pointers to pointers to  rows */
  t=(char  ***) malloc((size_t)((nrow)*sizeof(char **)));
  if (!t) nrerror("allocate failure 1 in cc3tensor()");
  
  /* allocate pointers to rows and set pointers to them */
  for(i=0;i<nrow;i++)  
    t[i]=(char **) malloc((size_t)((ncol)*sizeof(char*)));
  if(!t[nrh-1]) nrerror("allocation failure 2 in cc3tensor()");
  

  /* allocate rows and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
        t[j][i]=(char *) malloc((size_t)((ndep)*sizeof(char)));
  if(!t[nrh-1][nch-1]) nrerror(" allocation failure 3 in cc3tensor()");
    
  /* return pointers to array of pointers to rows  */
  return t;
}
 
float *fvector(long nh)
//allocate a float vector with subscript range v[nl..nh]  
{
  float *v;
  
  v=(float *)malloc((size_t)((nh)*sizeof(float)));
  if(!v) nrerror("allocation failure in vector()");
  return v;
}
 

float ****f4tensor(long nrh, long nch, long ndh, long nth)
/* allocate a float 4tensor with range t[0..nrh-1][0..nch-1][0..ndh-1][0..nth-1] */
{
  long i,j,k,nrow=nrh, ncol=nch, ndep=ndh, ntim=nth;
  float ****t;
  
  /* allocate pointers to pointers to  rows */
  t=(float ****) malloc((size_t)((nrow)*sizeof(float ***)));
  if (!t) nrerror("allocate failure 1 in f4tensor()");
  

  /* allocate pointers to rows and set pointers to them */
  for(i=0;i<nrow;i++)  
    t[i]=(float ***) malloc((size_t)((ncol)*sizeof(float**)));
  if(!t[nrh-1]) nrerror("allocation failure 2 in f4tensor()");
  

  /* allocate rows and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
        t[j][i]=(float **) malloc((size_t)((ndep)*sizeof(float *)));
  if(!t[nrh-1][nch-1]) nrerror(" allocation failure 3 in f4tensor()");

   /* allocate cols  and set  pointers to them  */
  for(j=0;j<nrow;j++)
    for(i=0;i<ncol;i++)
      for(k=0;k<ndep;k++)
        t[j][i][k]=(float *) malloc((size_t)((ntim)*sizeof(float)));
  if(!t[nrh-1][nch-1][ndh-1]) nrerror(" allocation failure 4 in f4tensor()");
    
  /* return pointers to array of pointers to rows  */
  return t;
}



void free_f4tensor(float ****t, long nrh, long nch, long ndh, long nth)
     /* free a float f4tensor allocated by f4tensor()  */
{
  long i,j,k;
  
  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
      for(k=0;k<ndh;k++)
       free((FREE_ARG)(t[i][j][k]));


  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
       free((FREE_ARG)(t[i][j])); 
  
  for(i=0;i<nrh;i++)
    free((FREE_ARG)(t[i])); 
  free((FREE_ARG)(t));   
}

void free_cc3tensor(char  ***t, long nrh, long nch, long ndh)
     /* free an unsigned char  c3tensor allocated by c3tensor()  */
{
  long i,j;
  for(i=0;i<nrh;i++)
    for(j=0;j<nch;j++)
       free((FREE_ARG)(t[i][j])); 
  
  for(i=0;i<nrh;i++)
    free((FREE_ARG)(t[i])); 
  free((FREE_ARG)(t));   
}

void nrerror(char error_text[])
/*Numerical Recipes standard handler */
{
  fprintf(stderr, "Numerical Recipes run-time error...\n");
  fprintf(stderr, "%s\n", error_text);
  fprintf(stderr, "... now exiting to system ...\n");
  exit(1);
}

bool readData(CvMat* X,const char* name)
{
	long i,j,ii;
	i = 0;
	j = 0;
	ii=0;
    FILE* pFile = fopen(name, "r"); 
   float* pForX=new float[X->width*X->height];
   while ( !feof(pFile) && ii!=X->width*X->height )
   {
       fscanf( pFile, "%e ", &pForX[ii] );
	   float xx=pForX[ii];
       ii++;
   }

	for ( int k = 0 ; k < X->width*X->height ; k++ )
	{
		if (j >= X->width)
		{
			i++;
			j=0;
		}
		if(i < X->height)
		{
			cvSetReal2D(X,i,j,pForX[k]);
			j++;
		}
	}
	
	delete pForX;
	return true;
}



