
/*******************************************************

Construct the neighorhoods.

last modified : Dec 5, 2010

Contact: Tianhao Zhang(tianhao.zhang@uphs.upenn.edu)

*******************************************************/

#include "CFunction.h"
#include <getopt.h>
using namespace std; 

int main(int argc, char **argv)
{
 
 static struct option long_options []=
 {
	 {"usage", no_argument, 0, 'u'},
	 {"help", no_argument, 0, 'h'},
	 {"version", no_argument, 0, 'v'},
 };

  ExDatabase datapara; 
 // int ncpu;
   int si;
  
  char *sublist  = argv[1];
  argc--;
  argv++;
  char *name_index  = argv[1];
  argc--;
  argv++;

  int c, option_index = 0;

  cout<<argc<<endl;

  if(argc!=9){
 	  
  printf( " \n This program implements a new group analysis method");
 
  printf( " \n Usage: ODVBA (data.list) (index.txt)[options]");
 
  printf( " \n Required parameters:");
  printf( " \n   data.list   : the input file containing the location of the data");
  printf( " \n   index.txt   : location of non-zero voxel in the volumes");
   
  printf( " \n Optional parameters:");
  printf( " \n  [-m    <int>     ]  number of non-zero voxel in the volumes(length of the vector in index.txt)");
  printf( " \n  [-n    <int>     ]  number of the selected neighborhoods");
  printf( " \n  [-e    <int>     ]  number of the selected voxel in each neighborhood");
  printf( " \n  [-s    <int>     ]  size of  neighborhood");


  printf( " \n More information:");
  printf( " \n Email to tianhao.zhang@uphs.upenn.edu");
 
  printf( " \n Suggested use: ./bin/NE_cons ../../list/subjects.list ../../list/index.txt  -m 197364 -n 10000 -e 400  -s 15");
  printf( " \n ");
 
  exit(0); 
  }

  if(argc!=2){
	  while ((c = getopt_long (argc, argv, "m:n:e:s:",
               long_options, &option_index)) != -1){
      switch (c)
      {
        case 'm':

          datapara.m =atol(optarg);    
          break; 

		case 'n':
          datapara.nn= atol(optarg);
          break;

        case 'e':
          datapara.NE=atoi(optarg);
          break;
	    case 's':
          si =atoi(optarg);
          break;

      case '?':
          break;
      }
    }
  }
  int subject_id      = atoi("2");

  printf("\n The input options are below:"); 
  printf("\n ===============================================\n");
  printf("\n sublist:      %s",sublist);
  printf("\n name_index:   %s",name_index);

  printf("\n m:      %d",datapara.m);
  printf("\n n:      %d",datapara.nn);
  printf("\n e:      %d",datapara.NE);
  printf("\n s:      %d",si);

  printf("\n ==============================================\n");
  FeatureExtraction *featExt = new FeatureExtraction;  
  featExt->SetInput (sublist, subject_id);
  featExt->Run();
  datapara.n = featExt->_num_subject;	    // dimensionality of samples

readDatabase(datapara,name_index);// Make the data input

CvMat* x_vector=cvCreateMat(datapara.m, 1,CV_32FC1);
CvMat* y_vector=cvCreateMat(datapara.m, 1,CV_32FC1);
CvMat* z_vector=cvCreateMat(datapara.m, 1,CV_32FC1);

for ( int i = 0; i < datapara.m; i++ )
{
  double NN=cvGetReal1D(datapara.index,i);
  double z_temp=ceil(NN/featExt->_xdim/featExt->_ydim);
  cvSetReal1D(z_vector,i,z_temp );
  double y_temp=ceil((NN-(z_temp-1)*featExt->_xdim*featExt->_ydim)/featExt->_xdim);
  cvSetReal1D(y_vector,i,y_temp);
  double x_temp=NN-(z_temp-1)*featExt->_xdim*featExt->_ydim-(y_temp-1)*featExt->_xdim;
  cvSetReal1D(x_vector,i,x_temp );
} 

int ra[datapara.m];
randperm2(datapara.m, ra);
CvMat* result=cvCreateMat(datapara.m, 1,CV_32FC1);
for ( int i = 0; i < datapara.nn; i++ )
{
  cvSetReal1D(result,i,ra[i]);
} 

CvMat* NI_short=cvCreateMat(datapara.NE, datapara.nn,CV_32FC1);

int ni[si*si*si] ;
int ni2[datapara.NE];
//CvMat* ni2=cvCreateMat(datapara.NE, 1,CV_32FC1);

printf ("Creating the neighorhoods... \n");
  
for ( int i = 0; i < datapara.nn; i++ )
{  
         
			int ind=cvGetReal1D(result,i);
	        int xi=cvGetReal1D(x_vector,ind);
			int yi=cvGetReal1D(y_vector,ind);
			int zi=cvGetReal1D(z_vector,ind);

			int minx=xi-(si-1)/2;
			if (minx<1)
			{
				minx=1;
			}

			int maxx=xi+(si-1)/2;
			if (maxx>featExt->_xdim)
			{
				maxx=featExt->_xdim;
			}

			int miny=yi-(si-1)/2;
			if (miny<1)
			{
				miny=1;
			}

			int maxy=yi+(si-1)/2;
			if (maxy>featExt->_ydim)
			{
				maxy=featExt->_ydim;
			}

			int minz=zi-(si-1)/2;
			if (minz<1)
			{
				minz=1;
			}

			int maxz=zi+(si-1)/2;
			if (maxz>featExt->_zdim)
			{
				maxz=featExt->_zdim;
			}

			int num_ni=0;
			int xj;
			int yj;
			int zj;

			for ( int j = 0; j < datapara.m; j++ )
			{ 

     	    int ind2=j;

			   xj=cvGetReal1D(x_vector,ind2);
			   yj=cvGetReal1D(y_vector,ind2);
			   zj=cvGetReal1D(z_vector,ind2);
			   if ((xj<maxx+1)&&(xj>minx-1)&&(yj<maxy+1)&&(yj>miny-1)&&(zj<maxz+1)&&(zj>minz-1))
			   {
				  ni[num_ni]=ind2+1;
				  num_ni++;
			   }
			}
        
		    if (num_ni<datapara.NE)
			{
				for ( int kk = 0; kk < datapara.NE-num_ni; kk++ )
				{
					ni[num_ni+kk]=0;
				}
            }
			 
				int ra3[num_ni];
				randperm2(num_ni, ra3);
				for ( int ss = 0; ss < datapara.NE; ss++ )
				{
					ni2[ss]=ni[ra3[ss]];
				}

			int flag=0;
            for ( int tt = 0; tt < datapara.NE; tt++ )
              {
				  if (ni2[tt]==ind)
					  {
						  flag=1;
						  break;
					  }
                }
 				if (flag==0)
				{
                  ni2[0]=ind;
				}

			for ( int ss = 0; ss < datapara.NE; ss++ )
			{cvSetReal2D(NI_short,ss,i,ni2[ss]);}

}
/*****************************************************/
    string savename_txt = "../../list/NI.txt";
    printf ("The result is stored into '%s'\n", savename_txt.c_str());
    writeData(NI_short,savename_txt.c_str());
 
 /*****************************************************/
	 return 0;
}
		
			
		

