/***************** Header file for algorithms ************************
All the basic mathematical operations is based on OpenCV, Intel Corp.
All rights reserved. 2006.3.24 -- 2006.
Anteagle Wang.
*********************************************************************/

#ifndef _ALGORITHM_H
#define _ALGORITHM_H

#include "CommonEx.h"



#define EUCLIDEAN	0
#define HEATKERNEL	1
#define COSINE		2
#define	SIMPLE		3

// data size: m*n
// m is the number of samples and n is the dimensionality of samples

typedef struct NDPParas
{	
	CvMat* U;						// generalized eigenvectors of NDP, n*k
	CvMat* lambda;					// genearalized eigenvalues of NDP, 1*k
	CvMat* numLabel;				
}NDPParas;

typedef struct mapResults
{	
	CvMat* W1;						// generalized eigenvectors of NDP, n*k
	//CvMat* W2;					// genearalized eigenvalues of NDP, 1*k
	//CvMat* W3;
	//CvMat* W4;
	//CvMat* W5;
	CvMat* map1;						// generalized eigenvectors of NDP, n*k
	//CvMat* map2;					// genearalized eigenvalues of NDP, 1*k
	//CvMat* map3;
	//CvMat* map4;
	//CvMat* map5;
	 
}mapResults;

typedef struct Var_matrix
{	
    //CvRNG  rng ;
    int n;
	int m;
	int nSmp1;
	int nSmp2;
	double minVal;
	double  maxVal;
	ublas::vector<double> intraMean1;
	ublas::vector<double> intraMean2;
	ublas::vector<double> extraMean;
	CvMat* Eigvector;
	CvMat* Eigvalue;
	CvMat*  A_shift;
	CvMat* A_rep;
	CvMat* AA;
	ublas::vector<double> a ;
	ublas::vector<double> b;
	ublas::vector<double> c ;
	ublas::vector<double> ad ;
	ublas::vector<double> V ;
	ublas::vector<double> weight ;
	ublas::matrix<double> aa;
	ublas::matrix<double> eintraCov1;
	ublas::matrix<double> eintraCov2;
	ublas::matrix<double> X2;
	ublas::matrix<double> A1;
	ublas::matrix<double> A2;
	CvMat* vot;
	ublas::vector<double> E;
	ublas::vector<double> E2;

}Var_matrix;



typedef struct Options
{
	double aa;
	double g;
	int ReducedDim;
	int nNeighbor;
	int nSample;
	int N_C;
	int nPerm;
	int maxiter;
	int nn;
	CvMat* numLabel;			                 
	CvMat* gnd;	
	//double th;
		// ID of database, m*1
}Options;

// if number of samples per class are same, numLabel[0] is number of classes, numLabel[1] is number of samples per class
// if number of samples per class are different, numLabel is 1*C, C is the number of classes and the data is number of samples per classes
//ublas::vector<double> NDP(ublas::matrix<double>& X,ublas::vector<double> V, Options opt,Var_matrix mat);

ublas::vector<double> NDP(ublas::matrix<double>& X, Var_matrix mat, double aa);
	
char ***cc3tensor(long nrh, long nch, long ndh);

float *fvector(long nh);

float ****f4tensor(long nrh, long nch, long ndh, long nth);


void free_f4tensor(float ****t, long nrh, long nch, long ndh, long nth);
 
void free_cc3tensor(char  ***t, long nrh, long nch, long ndh);
 
void nrerror(char error_text[]);
 











#endif
