/***************** Header file for CRecognitionEx ************************
All the basic mathematical operations are based on OpenCV, Intel Corp.

Tianhao Zhang.
*********************************************************************/

#ifndef _CRECOGNITION_H
#define _CRECOGNITION_H

#define True  1
#define False 0

#include "CAlgorithm.h"
#include "CommonEx.h"

typedef struct MapParas
{
		 double sum11;
         double sum22;
		 double sum1;
         double sum2;
		 double sw1;
         double sw2;
		 double voti;
		 double sw;
		 double me1;
		 double me2;
		 double diff;
		 double delta;
		 //double voti;

}MapParas;

// experimental database, and ID of samples
// m is the number of samples in the database
// n is the dimensionality of samples
typedef struct ExDatabase
{
	long m;									//m : number of samples
	long n;	
	long nn;	//n : dimensionality of samples
	//CvMat* X;								// database, m*n
	CvMat* NI;								// ID of database, m*1
	//CvMat* gnd;
	CvMat* index;
	//CvMat* in;
	//int H;
	//int W;
	int NE; 
	int DS;
	ublas::matrix<double> NI_new;


}ExDatabase;

typedef struct SplitDatabase
{
	CvMat* trainX;							// training samples, m1*n
	CvMat* testX;							// testing samples, m2*n
	CvMat* gndTrain;						// ID of training samples, m1*1
	CvMat* gndTest;							// ID of testing samples, m2*1
}SplitDatabase;




bool readDatabase(ExDatabase& database,const char* name1, const char* name2);
int* random(int n);  
int* randperm(int n);
Var_matrix init_mat(Var_matrix matt, int n,int m,int N, int type);
void compMap(mapResults mapW,ublas::matrix<double>& X,Options opt,Var_matrix mat, ExDatabase MRIdata, ublas::matrix<double>& fea, MapParas mParas);
//recognition approaches
//void NDPSPACE(SubParas& subNDP,ublas::matrix<double>& X,Options opt, Var_matrix mat);
//void computeDLAFaces(SubParas& DLAFace, CvMat* fea, CvMat* gnd, int k1, int k2, double beta);
int isfiles(char (*arr)[40], string path);
void ex_number(char *s);

class FeatureExtraction {
  
 public:
 
  int  _DebugFlag;
  /// Constructor
  FeatureExtraction();
  /// Destructor
  ~FeatureExtraction();
  /// Returns the name of the class
  char *NameOfClass();
  /// Prints debugging messages if debugging is enabled
  void Debug(char *);

 public:
 
  char *_file_sublist;
  char ***_file_name;  
  float *_label;
  int _num_po_subject;
  int _num_ne_subject;
  int _num_subject;
  int  _xdim;
  int  _ydim;
  int  _zdim;
  long _im_size;
  long _num_feature;
  int  _subject_id; // for leave one out test
  float _smooth_size;  // smooth the enhanced score map
  float _p;
  
  long _num_classification_feature;
  char _data_root_dir[200];
  
  float ****_feature_data;  // store the features of all the subjects [sub][x][y][z];
  CvMat* origin_data;
  void ReadData(int feat);
  /// Sets input for the feature selection routine
  void SetInput (char *sublist,int subject_id);
  void GetInput();  
  /// Initial set up for the feature selection
  void Initialize();
  /// Final set up for the feature selection
  void Finalize();
  void Run(); 

};


#endif

