/***************** Header file for algorithms ************************
All the basic mathematical operations is based on OpenCV, Intel Corp.
All rights reserved. 2006.3.24 -- 2006.
Anteagle Wang.
*********************************************************************/

#ifndef _COMMON_H
#define _COMMON_H

#include "StdAfx.h"
#include <string.h>
#include <stdio.h>
#include <iostream>
#include <vector>
#include <sys/stat.h>
#include <cstdlib>
# include <sys/time.h>
#include <boost/any.hpp>

#include <boost/numeric/ublas/matrix.hpp> 
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/vector.hpp> 
#include <boost/numeric/ublas/vector_proxy.hpp> 
#include <boost/numeric/ublas/operation.hpp> 
#include <boost/numeric/ublas/operation_sparse.hpp> 
#include <boost/numeric/ublas/matrix_sparse.hpp> 
#include <boost/numeric/ublas/vector_sparse.hpp> 
#include <boost/numeric/ublas/symmetric.hpp>

#include <boost/numeric/ublas/io.hpp> 

#include <boost/numeric/bindings/atlas/cblas3.hpp>
#include <boost/numeric/bindings/atlas/cblas2.hpp>
#include <boost/numeric/bindings/traits/ublas_matrix.hpp>

namespace ublas = boost::numeric::ublas;
namespace atlas = boost::numeric::bindings::atlas; 
using namespace std; 

bool readData(CvMat* X,const char* name);
bool writeData(CvMat* X,const char* name);


#define MINVALUE 10e-5
#define MAXVALUE 10e+10

bool readData(CvMat* X,const char* name);				// read data
bool writeData(CvMat* X,const char* name);	
bool writeimg(CvMat* X,const char* name);// write data
void createX(ublas::matrix<double>& X,CvMat* data,CvMat* index);
CvMat* solver_opencv(CvMat* A, CvMat* b, int n);
//ublas::vector<double>&  solver_ublas(ublas::matrix<double>& A, ublas::vector<double>& b, int n);
//ublas::matrix<double>&  solver_atlas(ublas::matrix<double>& A, ublas::matrix<double>& b, int n);
CvMat*  solver_ublas(CvMat* A, CvMat* b, int n);
CvMat*  solver_atlas(CvMat* Q, CvMat* u, int n);

//void init_mat(Var_matrix matt, int n,int m, int type);
#endif
