# Find the directory where MKL lives
FIND_PATH( CBLAS_INCLUDES cblas.h ENV C_INCLUDE_PATH)

FIND_LIBRARY(LAPACK_LIB lapack  PATH "/lib" "/usr/lib" "/usr/local/lib" ENV LD_LIBRARY_PATH
  DOC "Find the Lapack library")
FIND_LIBRARY(BLAS_LIB blas PATH "/lib" "/usr/lib" "/usr/local/lib"  ENV LD_LIBRARY_PATH 
  DOC "Find the BLAS library")
FIND_LIBRARY(CBLAS_LIB cblas PATH "/lib" "/usr/lib" "/usr/local/lib"  ENV LD_LIBRARY_PATH 
  DOC "Find the CBLAS library")
FIND_LIBRARY(G2C_LIB g2c PATH "/lib" "/usr/lib" "/usr/local/lib"   ENV LD_LIBRARY_PATH
  DOC "Find the Fortran-to-C library")
FIND_LIBRARY(ATLAS_LIB atlas PATH "/lib" "/usr/lib" "/usr/local/lib"   ENV LD_LIBRARY_PATH
  DOC "Find the Fortran-to-C library")

# Set the flag that LAPACK is present
#IF(LAPACK_LIB AND BLAS_LIB AND G2C_LIB AND ATLAS_LIB AND CBLAS_INCLUDES AND CBLAS_LIB)
  SET(LAPACK_LIBS ${LAPACK_LIB} ${BLAS_LIB}  ${ATLAS_LIB} ${CBLAS_LIB})
  SET(LAPACK_FOUND 1 CACHE INTERNAL "Lapack is available")
  #ENDIF(LAPACK_LIB AND BLAS_LIB AND G2C_LIB AND ATLAS_LIB AND CBLAS_INCLUDES AND )
