##############################################################################
#
# \file   FindNiftCLib.cmake
# \brief  Find nifticlib package.
# \author Andreas Schuh
# \date   01/17/11
#
# $Revision: 129 $
# $Id: FindNiftiCLib.cmake 129 2011-02-02 22:38:14Z schuha@UPHS.PENNHEALTH.PRV $
#
# <b>Last changed</b>
# $Date: 2011-02-02 17:38:14 -0500 (Wed, 02 Feb 2011) $
# $Author: schuha@UPHS.PENNHEALTH.PRV $
#
# Sets the following CMake variables:
#
#   NiftiCLib_FOUND        Whether the nifticlib package was found and the
#                          following CMake variables are valid.
#   NiftiCLib_INCLUDE_DIR  Cached include directory/ies.
#   NiftiCLib_INCLUDE_DIRS Alias for NiftiCLib_INCLUDE_DIR (not cached).
#   NiftiCLib_INCLUDES     Alias for NiftiCLib_INCLUDE_DIR (not cached).
#   NiftiCLib_LIB          Path of niftio library.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# For copyright information see Copyright section of project
# ReadMe.html in the project's root directory.
#
# Contact: sbia-software@uphs.upenn.edu
#
##############################################################################

# ============================================================================
# find paths/files
# ============================================================================

find_path (NiftiCLib_INCLUDE_DIR
  NAMES
    nifti1.h
  DOC
    "Path of directory containing nifti1.h"
)

find_library (NiftiCLib_LIB
  NAMES
    niftiio
  DOC
    "Path of niftiio library"
)

# ============================================================================
# set other variables
# ============================================================================

# ============================================================================
# aliases
# ============================================================================

if (NiftiCLib_INCLUDE_DIR)
  set (NiftiCLib_INCLUDE_DIRS "${NiftiCLib_INCLUDE_DIR}")
  set (NiftiCLib_INCLUDES     "${NiftiCLib_INCLUDE_DIR}")
endif ()

# ============================================================================
# found ?
# ============================================================================

if (NiftiCLib_INCLUDE_DIR AND NiftiCLib_LIB)
   set (NiftiCLib_FOUND TRUE)
endif ()

if (NiftiCLib_FOUND)
   if (NOT NiftiCLib_FIND_QUIETLY)
      message (STATUS "Found NiftiCLib: ${NiftiCLib_INCLUDE_DIR}")
      message (STATUS "                 ${NiftiCLib_LIB}")
   endif ()
else ()
   if (NiftiCLib_FIND_REQUIRED)
      message (FATAL_ERROR "Could not find nifticlib package. Set NiftiCLib_INCLUDE_DIR"
                           " and NiftiCLib_LIB manually and try again.")
   endif ()
endif ()
