##############################################################################
#
# \file   ATLAS.cmake
# \brief  Find ATLAS package.
# \author Andreas Schuh
# \date   01/05/11
#
# $Revision: 129 $
# $Id: FindATLAS.cmake 129 2011-02-02 22:38:14Z schuha@UPHS.PENNHEALTH.PRV $
#
# <b>Last changed</b>
# $Author: schuha@UPHS.PENNHEALTH.PRV $
# $Date: 2011-02-02 17:38:14 -0500 (Wed, 02 Feb 2011) $
#
# Sets the following CMake variables:
#
#   ATLAS_FOUND        Whether the ATLAS package was found and the remaining
#                      CMake variables are valid.
#   ATLAS_USE_FILE     Path to the CMake use file of the ATLAS package.
#   ATLAS_INCLUDE_DIR  Cached include directory/ies of the ATLAS package.
#   ATLAS_INCLUDE_DIRS Alias for ATLAS_INCLUDE_DIR (not cached).
#   ATLAS_INCLUDES     Alias for ATLAS_INCLUDE_DIR (not cached).
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# For copyright information see Copyright section of project
# ReadMe.html in the project's root directory.
#
# Contact: sbia-software@uphs.upenn.edu
#
##############################################################################

# ============================================================================
# find paths/files
# ============================================================================

find_path (ATLAS_DIR
  NAMES
    UseATLAS.cmake
  PATHS
    "${PROJECT_EXTERNAL_DIR}/ATLAS"
  DOC
    "Path to the root directory of the ATLAS package where the "
    "file UseATLAS.cmake is located."
)

# ============================================================================
# set other variables
# ============================================================================

if (ATLAS_DIR)
  set (ATLAS_USE_FILE "${ATLAS_DIR}/UseATLAS.cmake")

  set (ATLAS_INCLUDE_DIR
    ${ATLAS_DIR}/boost-numeric-bindings
    CACHE PATH "Include directories of ATLAS package"
  )
endif ()

# ============================================================================
# aliases
# ============================================================================

if (ATLAS_INCLUDE_DIR)
  set (ATLAS_INCLUDE_DIRS "${ATLAS_INCLUDE_DIR}")
  set (ATLAS_INCLUDES     "${ATLAS_INCLUDE_DIR}")
endif ()

# ============================================================================
# found ?
# ============================================================================

if (ATLAS_INCLUDE_DIR)
   set (ATLAS_FOUND TRUE)
endif ()

if (ATLAS_FOUND)
   if (NOT ATLAS_FIND_QUIETLY)
      message (STATUS "Found ATLAS: ${ATLAS_INCLUDE_DIR}")
   endif ()
else ()
   if (ATLAS_FIND_REQUIRED)
      message (FATAL_ERROR "Could not find ATLAS package. Set ATLAS_DIR"
                           " manually and try again.")
   endif ()
endif ()