##############################################################################
#
# \file   SbiaDefaults.cmake
# \brief  Default CMake settings used at SBIA.
# \author Andreas Schuh
# \date   01/05/10
#
# $Revision: 129 $
# $Id: SbiaDefaults.cmake 129 2011-02-02 22:38:14Z schuha@UPHS.PENNHEALTH.PRV $
#
# <b>Last changed</b>
# $Author: schuha@UPHS.PENNHEALTH.PRV $
# $Date: 2011-02-02 17:38:14 -0500 (Wed, 02 Feb 2011) $
#
# This file should be included in the root CMake file of any SBIA project
# right after the SbiaProject CMake module was loaded using the following
# CMake code:
#
#   include (SbiaProject)
#   include (SbiaDefaults)
#
# In order that these defaults are available globally, copy this file to the
# default CMAKE_MODULE_PATH directory. In order to overwrite the global
# defaults, place a modified version of this file in the cmake directory of
# your project.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# For copyright information see Copyright section of project
# ReadMe.html in the project's root directory.
#
# Contact: sbia-software@uphs.upenn.edu
#
##############################################################################

##
## Note: As this file will be loaded prior to the project CMake command,
##       use the CMake variables CMAKE_SOURCE_DIR and CMAKE_BINARY_DIR
##       instead of PROJECT_SOURCE_DIR and PROJECT_BINARY_DIR herein.
##

# ============================================================================
# naming conventions
# ============================================================================

option (
  ${PROJECT_NAME_UPPER}_USE_OUTPUT_NAME_PREFIX
  "Whether target output names should be prefixed by ${PROJECT_NAME_UPPER}_OUTPUT_NAME_PREFIX."
  OFF
)

set (
  ${PROJECT_NAME_UPPER}_OUTPUT_NAME_PREFIX "Sbia"
  CACHE
    STRING
	"If ${PROJECT_NAME_UPPER}_USE_OUTPUT_NAME_PREFIX is ON, the output name of targets will be prefixed by this string value."
)

mark_as_advanced (${PROJECT_NAME_UPPER}_USE_OUTPUT_NAME_PREFIX)
mark_as_advanced (${PROJECT_NAME_UPPER}_OUTPUT_NAME_PREFIX)

set (SBIA_USE_OUTPUT_NAME_PREFIX ${${PROJECT_NAME_UPPER}_USE_OUTPUT_NAME_PREFIX})
set (SBIA_OUTPUT_NAME_PREFIX     ${${PROJECT_NAME_UPPER}_OUTPUT_NAME_PREFIX})

# ============================================================================
# output directories
# ============================================================================

if (NOT RUNTIME_OUTPUT_DIRECTORY)
  set (RUNTIME_OUTPUT_DIRECTORY "${CMAKE_BINARY_DIR}/bin"
    CACHE PATH "Single directory for all executables."
  )

  set (LIBRARY_OUTPUT_DIRECTORY "${CMAKE_BINARY_DIR}/lib"
    CACHE PATH "Single directory for all libraries."
  )

  set (EXECUTABLE_OUTPUT_PATH "${CMAKE_BINARY_DIR}/bin"
    CACHE PATH "Single output directory for building all executables."
  )

  set (LIBRARY_OUTPUT_PATH "${CMAKE_BINARY_DIR}/lib"
    CACHE PATH "Single output directory for building all executables."
  )
  
endif ()

mark_as_advanced (
  RUNTIME_OUTPUT_DIRECTORY
  LIBRARY_OUTPUT_DIRECTORY
  EXECUTABLE_OUTPUT_PATH
	LIBRARY_OUTPUT_PATH
)

# ============================================================================
# build configuration(s)
# ============================================================================

set (CMAKE_CONFIGURATION_TYPES "Debug;Release"
  CACHE STRING "Build configurations" FORCE
)

set (CMAKE_C_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_C_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_CXX_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_CXX_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_EXE_LINKER_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_MODULE_LINKER_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_MODULE_LINKER_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_SHARED_LINKER_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_SHARED_LINKER_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_VERBOSE OFF CACHE BOOL "Verbose mode")

set (CMAKE_EXE_LINKER_FLAGS -lm ${CMAKE_EXE_LINKER_FLAGS})
