##############################################################################
# \file  Depends.cmake
# \brief Contains find_package () commands to resolve external dependencies.
#
# This file is included by the macro sbia_project () if found in the top
# directory of the source tree of the project. It is supposed to resolve
# dependencies to external packages using the find_package () command of
# CMake. Alternatively, packages which are shipped with this project
# are located in PROJECT_UTILITIES_DIR (defined in Settings.cmake).
# CMake variables that are usually set by the find_package () call, should
# be set here as well using the PROJECT_UTILITIES_DIR variable.
#
# If no CMake Find module for an external package is available yet and the
# package does not provide a <Package>Config.cmake or <package>-config.cmake
# file, write your own Find module and store it in the 'CMake' folder of the
# project or have someone else write one for you. Consider also to inform
# the manager of the project template at SBIA to integrate your Find module
# into the collection of lab-wide available CMake modules.
#
# Note that the CMAKE_MODULE_PATH is by default set to
# DEFAULT_CMAKE_MODULE_PATH. This path does not necessarily lead to the
# 'CMake' folder of the project. Instead, use PROJECT_CMAKE_MODULE_PATH.
# Alternatively, set the CMAKE_MODULE_PATH to PROJECT_CMAKE_MODULE_PATH
# before using the find_package () command when the find modules in
# the 'CMake' folder should be used. The macro sbia_project () will
# reset the CMAKE_MODULE_PATH to DEFAULT_CMAKE_MODULE_PATH.
#
# For copyright information please see Copyright.txt in the root
# directory of the project.
#
# Contact: SBIA Group <sbia-software@uphs.upenn.edu>
##############################################################################

# ============================================================================
# intra-project
# ============================================================================

include_directories ("${PROJECT_SOURCE_DIR}/Code")
include_directories ("${PROJECT_BINARY_DIR}/Code")

# ----------------------------------------------------------------------------
# ATLAS (Boost bindings)
# ----------------------------------------------------------------------------

include_directories ("${PROJECT_UTILITIES_DIR}/ATLAS/boost-numeric-bindings")

# ============================================================================
# external
# ============================================================================

# ----------------------------------------------------------------------------
# Nifti
# ----------------------------------------------------------------------------

find_package (NiftiCLib REQUIRED)

include_directories (${NiftiCLib_INCLUDE_DIRS})

# ----------------------------------------------------------------------------
# Boost
# ----------------------------------------------------------------------------

set (Boost_FIND_REQUIRED       TRUE)
set (Boost_FIND_QUIETLY        TRUE)
set (Boost_USE_MULTITHREADED   TRUE)
set (Boost_USE_STATIC_LIBS     TRUE)
set (Boost_ADDITIONAL_VERSIONS "1.39" "1.39.0")

find_package (
  Boost
  COMPONENTS
    program_options
    unit_test_framework
    test_exec_monitor
)

include_directories (${Boost_INCLUDE_DIR})
link_directories    (${Boost_LIBRARY_DIRS})

# ----------------------------------------------------------------------------
# LAPACK
# ----------------------------------------------------------------------------

find_package (Lapack REQUIRED)

include_directories (${CBLAS_INCLUDES})

# ----------------------------------------------------------------------------
# OpenCV
# ----------------------------------------------------------------------------

find_package (OpenCV REQUIRED)

# ----------------------------------------------------------------------------
# MPI
# ----------------------------------------------------------------------------

find_package (MPI)

if (MPI_FOUND)
  include_directories (${MPI_INCLUDE_PATH})
endif ()
