##############################################################################
# \file  SbiaCommands.cmake
# \brief Finds command line tools used for configuring the build system.
#
# This CMake module finds command line tools which are required for the
# configuration of the build system via CMake.
#
# DO NOT edit this file for your project. Instead, create a new file named
# "Macros.cmake", for example, and include it in the root CMake file.
#
# For copyright information please see Copyright.txt in the root
# directory of the project.
#
# Contact: SBIA Group <sbia-software@uphs.upenn.edu>
##############################################################################

# ============================================================================
# version control
# ============================================================================

find_program (
  SBIA_CMD_SVN
    NAMES svn
    DOC "Subversion command line client (svn)."
)
mark_as_advanced (SBIA_CMD_SVN)

# ============================================================================
# scripting
# ============================================================================

find_program (
  SBIA_CMD_MATLAB
    NAMES matlab
    DOC "The MATLAB application (matlab)."
)
mark_as_advanced (SBIA_CMD_MATLAB)

find_program (
  SBIA_CMD_PYTHON
    NAMES python
    DOC "The Python interpreter (python)."
)
mark_as_advanced (SBIA_CMD_PYTHON)

find_program (
  SBIA_SCRIPT_EXECUTE_PROCESS
    NAMES SbiaExecuteProcess.cmake
    HINTS "${CMAKE_MODULE_PATH}" "${DEFAULT_CMAKE_MODULE_PATH}"
    DOC   "The CMake script SbiaExecuteProcess.cmake."
)
mark_as_advanced (SBIA_SCRIPT_EXECUTE_PROCESS)

# ============================================================================
# build
# ============================================================================

find_program (
  SBIA_CMD_MCC
    NAMES mcc
    DOC "The MATLAB Compiler (mcc)."
)
mark_as_advanced (SBIA_CMD_MCC)

find_file (
  SBIA_SCRIPT_RUN_MCC
    NAMES SbiaRunMcc.m
    HINTS ${CMAKE_MODULE_PATH}
    DOC "MATLAB script SbiaRunMcc.m used to invoke MATLAB Compiler in MATLAB mode."
    NO_DEFAULT_PATH
)
mark_as_advanced (SBIA_SCRIPT_RUN_MCC)

find_program (
  SBIA_CMD_MEX
    NAMES mex
    DOC "The MEX-file generator of MATLAB (mex)."
)
mark_as_advanced (SBIA_CMD_MEX)

find_program (
  SBIA_CMD_MEXEXT
    NAMES mexext
    DOC "The MEXEXT script of MATLAB (mexext)."
)
mark_as_advanced (SBIA_CMD_MEXEXT)

# ============================================================================
# documentation
# ============================================================================

find_program (
  SBIA_CMD_SVN2CL
    NAMES svn2cl
    DOC   "The command line tool svn2cl."
)
mark_as_advanced (SBIA_CMD_SVN2CL)
