///////////////////////////////////////////////////////////////////////////////////////
// stdafx.h
// Developed by Dongjin Kwon
///////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011-2014 Dongjin Kwon
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
///////////////////////////////////////////////////////////////////////////////////////

#pragma once

#if defined(WIN32) || defined(WIN64)
////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <Windows.h>
//
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
////////////////////////////////////////////////////////////////////////////////////////////////////////
#else
////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
//
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>
#include <float.h>
#include <fcntl.h>
#if !defined(__APPLE__)
#include <sys/sendfile.h>
#endif
#include <dirent.h>
#include <fnmatch.h>
////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

#define USE_11A_PRIORS
//
#define USE_4_IMAGES
//
#define USE_OPTIM_DG
//
//#define USE_VS_PRIOR
#define USE_TUMOR_MASK_ADD_ED
//#define USE_ED_INC_GM
//
#define USE_ED_0_5
//#define USE_SMOOTH_POSTERIOR
//
#define USE_SYMM_REG
#define USE_APPLY_BRAIN_MASK
#define USE_INIT_FIELD
#define USE_TUMOR_ENERGY
#define USE_DISCRETE_OPTIMIZATION
#define USE_CONTINUOUS_OPTIMIZATION
//
#define USE_CC_NCC
//#define USE_WARPED_BG
//
//#define USE_SCAN0_SEED_OF_SCAN0
//#define USE_SCAN0_REINIT_MEANS
//
#define USE_TE_L2
//#define USE_TE_JS
//
#define USE_ALIGN_SCAN
//
//#define USE_COMPUTEQ2
#define USE_SUM_EPSS
#define USE_SUM_EPSS2

#ifdef USE_4_IMAGES
#define NumberOfImageChannels	4
#endif
#ifdef USE_11A_PRIORS
#define NumberOfPriorChannels	11
#endif

#ifdef USE_11A_PRIORS
// BG, CSF, VT, GM, WM, VS (VEIN), ED, NCR (CAN), TU (CAE), RTN, RTE
static const char label[NumberOfPriorChannels][32] = { "BG", "CSF", "VT", "GM", "WM", "VS", "ED", "NCR", "TU", "RTN", "RTE" }; // for pre
static const char label2[NumberOfPriorChannels][32] = { "BG", "CSF", "VT", "GM", "WM", "VS", "ED", "CAN", "CAE", "RTN", "RTE" }; // for post
static const char label3[NumberOfPriorChannels][32] = { "BG", "CSF", "VT", "GM", "WM", "VEIN", "ED", "NCR", "TU", "RTN", "RTE" };
static const char label4[NumberOfPriorChannels][32] = { "BG", "CSF", "VT", "GM", "WM", "VEINS", "ED", "NCR", "TU", "RTN", "RTE" };
static const int label_idx[NumberOfPriorChannels] = { 0, 10, 50, 150, 250, 25, 100, 175, 200, 210, 220 };
static const int label_s_idx[NumberOfPriorChannels] = { 0, 10, 50, 150, 250, 10, 250, 200, 200, 200, 200 };
//static const int label_s_idx[NumberOfPriorChannels] = { 0, 10, 10, 150, 250, 10, 250, 250, 250, 250, 250 };
enum {
	BG = 0,
    CSF,
    VT,
    GM,
    WM,
    VS,
    ED,
    NCR,
    TU,
	RTN,
	RTE
};
#endif

#if defined(WIN32) || defined(WIN64)
	#define DIR_SEP "\\"
	#define DIR_SEP_C '\\'
#else
	#define DIR_SEP "/"
	#define DIR_SEP_C '/'
#endif

#if (defined(WIN32) || defined(WIN64)) && defined(_DEBUG)
#if 1
#define MODULE_FOLDER					"D:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\bin"
#ifdef _DEBUG
#define EVALUATE_Q_PATH					"D:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\x64\\Debug\\EvaluateQ.exe"
#else
#define EVALUATE_Q_PATH					"D:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\x64\\Release\\EvaluateQ.exe"
#endif
//#define HOPSPACK_PATH					"D:\\LIBRARY\\HOPSPACK\\hopspack-2.0.2-win32\\HOPSPACK_main_serial.exe"
#define HOPSPACK_PATH					"D:\\LIBRARY\\HOPSPACK\\hopspack-2.0.2-win32\\HOPSPACK_main_threaded.exe"
#else
#define MODULE_FOLDER					"C:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\bin"
#ifdef _DEBUG
#define EVALUATE_Q_PATH					"C:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\x64\\Debug\\EvaluateQ.exe"
#else
#define EVALUATE_Q_PATH					"C:\\WORKSPACE\\PROJECT\\BrainTumorRegistrationS\\x64\\Release\\EvaluateQ.exe"
#endif
//#define HOPSPACK_PATH					MODULE_FOLDER ## "\\HOPSPACK_main_serial.exe"
#define HOPSPACK_PATH					MODULE_FOLDER ## "\\HOPSPACK_main_threaded.exe"
#endif
//
#define FLIRT_PATH						MODULE_FOLDER ## "\\flirt.exe"
#define CONVERT_XFM_PATH				MODULE_FOLDER ## "\\convert_xfm.exe"
#define TDCALC_PATH						MODULE_FOLDER ## "\\3dcalc.exe"
#define RESAMPLE_IMAGE_PATH				MODULE_FOLDER ## "\\ResampleImage.exe"
//
#define SIMULATOR_PATH					MODULE_FOLDER ## "\\ForwardSolverDiffusion.exe"
//
#define RESAMPLE_DEFORMATION_FIELD_PATH MODULE_FOLDER ## "\\ResampleDeformationField.exe"
#define REVERSE_DEFORMATION_FIELD_PATH	MODULE_FOLDER ## "\\ReverseDeformationField.exe"
#define WARP_IMAGE_PATH					MODULE_FOLDER ## "\\WarpImage.exe"
#define CONCATENATE_FIELD_PATH			MODULE_FOLDER ## "\\ConcatenateFields.exe"
#endif


#define USE_TRACE
#define USE_METAIO


#ifndef BOOL
#define BOOL int
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef BYTE
#define BYTE unsigned char
#endif
#ifndef DWORD
#define DWORD unsigned long
#endif
#ifndef LPCTSTR
#define LPCTSTR const char*
#endif

#define MIN(a,b)  (((a) < (b)) ? (a) : (b))
#define MAX(a,b)  (((a) > (b)) ? (a) : (b))

#ifdef USE_TRACE
extern BOOL g_bTrace;
extern FILE *g_fp_trace;
extern char g_trace_file[1024];
extern BOOL g_bTraceStdOut;
extern int g_verbose;
//
//#ifdef _DEBUG
#if 1
#undef TRACE
#define TRACE Trace
#define TRACE1(...) {(g_verbose>=1)?Trace(__VA_ARGS__):((void)0);}
#define TRACE2(...) {(g_verbose>=2)?Trace(__VA_ARGS__):((void)0);}
#define TRACE3(...) {(g_verbose>=3)?Trace(__VA_ARGS__):((void)0);}
#ifdef __cplusplus
extern "C" {
#endif
void Trace(const char* szFormat, ...);
#ifdef __cplusplus
}
#endif
#else
#ifndef TRACE
#define TRACE printf
#define TRACE1(...) {(g_verbose>=1)?printf(__VA_ARGS__):((void)0);}
#define TRACE2(...) {(g_verbose>=2)?printf(__VA_ARGS__):((void)0);}
#define TRACE3(...) {(g_verbose>=3)?printf(__VA_ARGS__):((void)0);}
#endif
#endif
//
#endif
