///////////////////////////////////////////////////////////////////////////////////////
// FFD_table.h
// Developed by Dongjin Kwon
///////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011-2014 Dongjin Kwon
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
///////////////////////////////////////////////////////////////////////////////////////

#if !defined(FFD_TABLE_H)
#define FFD_TABLE_H


// For the round up purpose, we multiply 10001 instead of 10000
#define FFD_B(i, t)		(T_FFD_B[(i)][(int)((t)*10001)])
#define FFD_B_d(i, t)	(T_FFD_B_d[(i)][(int)((t)*10001)])
#define FFD_B_d2(i, t)	(T_FFD_B_d2[(i)][(int)((t)*10001)])

#define MAX_FFD 10002


static double T_FFD_B[4][MAX_FFD] = {
{
1.666667e-001, 1.666167e-001, 1.665667e-001, 1.665167e-001, 1.664667e-001, 1.664168e-001, 1.663668e-001, 1.663169e-001, 1.662670e-001, 1.662171e-001, 1.661672e-001, 1.661173e-001, 1.660674e-001, 1.660175e-001, 1.659676e-001, 1.659178e-001, 1.658679e-001, 1.658181e-001, 1.657683e-001, 1.657185e-001, 1.656687e-001, 1.656189e-001, 1.655691e-001, 1.655193e-001, 1.654695e-001, 1.654198e-001, 1.653700e-001, 1.653203e-001, 1.652706e-001, 1.652209e-001, 1.651712e-001, 1.651215e-001, 1.650718e-001, 1.650221e-001, 1.649724e-001, 1.649228e-001, 1.648731e-001, 1.648235e-001, 1.647739e-001, 1.647243e-001, 1.646747e-001, 1.646251e-001, 1.645755e-001, 1.645259e-001, 1.644763e-001, 1.644268e-001, 1.643772e-001, 1.643277e-001, 1.642782e-001, 1.642287e-001, 1.641791e-001, 1.641296e-001, 1.640802e-001, 1.640307e-001, 1.639812e-001, 1.639318e-001, 1.638823e-001, 1.638329e-001, 1.637835e-001, 1.637340e-001, 1.636846e-001, 1.636352e-001, 1.635858e-001, 1.635365e-001, 1.634871e-001, 1.634377e-001, 1.633884e-001, 1.633391e-001, 1.632897e-001, 1.632404e-001, 1.631911e-001, 1.631418e-001, 1.630925e-001, 1.630432e-001, 1.629940e-001, 1.629447e-001, 1.628955e-001, 1.628462e-001, 1.627970e-001, 1.627478e-001, 1.626986e-001, 1.626494e-001, 1.626002e-001, 1.625510e-001, 1.625018e-001, 1.624527e-001, 1.624035e-001, 1.623544e-001, 1.623053e-001, 1.622562e-001, 1.622070e-001, 1.621579e-001, 1.621089e-001, 1.620598e-001, 1.620107e-001, 1.619616e-001, 1.619126e-001, 1.618636e-001, 1.618145e-001, 1.617655e-001, 
1.617165e-001, 1.616675e-001, 1.616185e-001, 1.615695e-001, 1.615206e-001, 1.614716e-001, 1.614226e-001, 1.613737e-001, 1.613248e-001, 1.612759e-001, 1.612269e-001, 1.611780e-001, 1.611292e-001, 1.610803e-001, 1.610314e-001, 1.609825e-001, 1.609337e-001, 1.608848e-001, 1.608360e-001, 1.607872e-001, 1.607384e-001, 1.606896e-001, 1.606408e-001, 1.605920e-001, 1.605432e-001, 1.604945e-001, 1.604457e-001, 1.603970e-001, 1.603482e-001, 1.602995e-001, 1.602508e-001, 1.602021e-001, 1.601534e-001, 1.601047e-001, 1.600560e-001, 1.600074e-001, 1.599587e-001, 1.599101e-001, 1.598614e-001, 1.598128e-001, 1.597642e-001, 1.597156e-001, 1.596670e-001, 1.596184e-001, 1.595698e-001, 1.595213e-001, 1.594727e-001, 1.594242e-001, 1.593756e-001, 1.593271e-001, 1.592786e-001, 1.592301e-001, 1.591816e-001, 1.591331e-001, 1.590846e-001, 1.590362e-001, 1.589877e-001, 1.589393e-001, 1.588908e-001, 1.588424e-001, 1.587940e-001, 1.587456e-001, 1.586972e-001, 1.586488e-001, 1.586004e-001, 1.585520e-001, 1.585037e-001, 1.584553e-001, 1.584070e-001, 1.583587e-001, 1.583103e-001, 1.582620e-001, 1.582137e-001, 1.581654e-001, 1.581172e-001, 1.580689e-001, 1.580206e-001, 1.579724e-001, 1.579241e-001, 1.578759e-001, 1.578277e-001, 1.577795e-001, 1.577313e-001, 1.576831e-001, 1.576349e-001, 1.575867e-001, 1.575386e-001, 1.574904e-001, 1.574423e-001, 1.573941e-001, 1.573460e-001, 1.572979e-001, 1.572498e-001, 1.572017e-001, 1.571536e-001, 1.571056e-001, 1.570575e-001, 1.570094e-001, 1.569614e-001, 1.569134e-001, 
1.568653e-001, 1.568173e-001, 1.567693e-001, 1.567213e-001, 1.566733e-001, 1.566254e-001, 1.565774e-001, 1.565294e-001, 1.564815e-001, 1.564336e-001, 1.563856e-001, 1.563377e-001, 1.562898e-001, 1.562419e-001, 1.561940e-001, 1.561461e-001, 1.560983e-001, 1.560504e-001, 1.560026e-001, 1.559547e-001, 1.559069e-001, 1.558591e-001, 1.558113e-001, 1.557635e-001, 1.557157e-001, 1.556679e-001, 1.556201e-001, 1.555724e-001, 1.555246e-001, 1.554769e-001, 1.554291e-001, 1.553814e-001, 1.553337e-001, 1.552860e-001, 1.552383e-001, 1.551906e-001, 1.551430e-001, 1.550953e-001, 1.550476e-001, 1.550000e-001, 1.549524e-001, 1.549047e-001, 1.548571e-001, 1.548095e-001, 1.547619e-001, 1.547143e-001, 1.546668e-001, 1.546192e-001, 1.545716e-001, 1.545241e-001, 1.544766e-001, 1.544290e-001, 1.543815e-001, 1.543340e-001, 1.542865e-001, 1.542390e-001, 1.541916e-001, 1.541441e-001, 1.540966e-001, 1.540492e-001, 1.540017e-001, 1.539543e-001, 1.539069e-001, 1.538595e-001, 1.538121e-001, 1.537647e-001, 1.537173e-001, 1.536699e-001, 1.536226e-001, 1.535752e-001, 1.535279e-001, 1.534806e-001, 1.534332e-001, 1.533859e-001, 1.533386e-001, 1.532913e-001, 1.532440e-001, 1.531968e-001, 1.531495e-001, 1.531023e-001, 1.530550e-001, 1.530078e-001, 1.529605e-001, 1.529133e-001, 1.528661e-001, 1.528189e-001, 1.527717e-001, 1.527246e-001, 1.526774e-001, 1.526302e-001, 1.525831e-001, 1.525360e-001, 1.524888e-001, 1.524417e-001, 1.523946e-001, 1.523475e-001, 1.523004e-001, 1.522533e-001, 1.522063e-001, 1.521592e-001, 
1.521122e-001, 1.520651e-001, 1.520181e-001, 1.519711e-001, 1.519241e-001, 1.518771e-001, 1.518301e-001, 1.517831e-001, 1.517361e-001, 1.516892e-001, 1.516422e-001, 1.515953e-001, 1.515483e-001, 1.515014e-001, 1.514545e-001, 1.514076e-001, 1.513607e-001, 1.513138e-001, 1.512669e-001, 1.512201e-001, 1.511732e-001, 1.511264e-001, 1.510795e-001, 1.510327e-001, 1.509859e-001, 1.509391e-001, 1.508923e-001, 1.508455e-001, 1.507987e-001, 1.507519e-001, 1.507052e-001, 1.506584e-001, 1.506117e-001, 1.505650e-001, 1.505182e-001, 1.504715e-001, 1.504248e-001, 1.503781e-001, 1.503315e-001, 1.502848e-001, 1.502381e-001, 1.501915e-001, 1.501448e-001, 1.500982e-001, 1.500516e-001, 1.500049e-001, 1.499583e-001, 1.499117e-001, 1.498652e-001, 1.498186e-001, 1.497720e-001, 1.497255e-001, 1.496789e-001, 1.496324e-001, 1.495859e-001, 1.495393e-001, 1.494928e-001, 1.494463e-001, 1.493998e-001, 1.493534e-001, 1.493069e-001, 1.492604e-001, 1.492140e-001, 1.491675e-001, 1.491211e-001, 1.490747e-001, 1.490283e-001, 1.489819e-001, 1.489355e-001, 1.488891e-001, 1.488427e-001, 1.487964e-001, 1.487500e-001, 1.487037e-001, 1.486573e-001, 1.486110e-001, 1.485647e-001, 1.485184e-001, 1.484721e-001, 1.484258e-001, 1.483795e-001, 1.483333e-001, 1.482870e-001, 1.482407e-001, 1.481945e-001, 1.481483e-001, 1.481021e-001, 1.480559e-001, 1.480097e-001, 1.479635e-001, 1.479173e-001, 1.478711e-001, 1.478249e-001, 1.477788e-001, 1.477327e-001, 1.476865e-001, 1.476404e-001, 1.475943e-001, 1.475482e-001, 1.475021e-001, 
1.474560e-001, 1.474099e-001, 1.473639e-001, 1.473178e-001, 1.472718e-001, 1.472257e-001, 1.471797e-001, 1.471337e-001, 1.470877e-001, 1.470417e-001, 1.469957e-001, 1.469497e-001, 1.469037e-001, 1.468578e-001, 1.468118e-001, 1.467659e-001, 1.467199e-001, 1.466740e-001, 1.466281e-001, 1.465822e-001, 1.465363e-001, 1.464904e-001, 1.464446e-001, 1.463987e-001, 1.463528e-001, 1.463070e-001, 1.462612e-001, 1.462153e-001, 1.461695e-001, 1.461237e-001, 1.460779e-001, 1.460321e-001, 1.459863e-001, 1.459406e-001, 1.458948e-001, 1.458491e-001, 1.458033e-001, 1.457576e-001, 1.457119e-001, 1.456662e-001, 1.456205e-001, 1.455748e-001, 1.455291e-001, 1.454834e-001, 1.454378e-001, 1.453921e-001, 1.453465e-001, 1.453008e-001, 1.452552e-001, 1.452096e-001, 1.451640e-001, 1.451184e-001, 1.450728e-001, 1.450272e-001, 1.449817e-001, 1.449361e-001, 1.448905e-001, 1.448450e-001, 1.447995e-001, 1.447540e-001, 1.447084e-001, 1.446629e-001, 1.446175e-001, 1.445720e-001, 1.445265e-001, 1.444810e-001, 1.444356e-001, 1.443901e-001, 1.443447e-001, 1.442993e-001, 1.442539e-001, 1.442085e-001, 1.441631e-001, 1.441177e-001, 1.440723e-001, 1.440269e-001, 1.439816e-001, 1.439362e-001, 1.438909e-001, 1.438456e-001, 1.438002e-001, 1.437549e-001, 1.437096e-001, 1.436643e-001, 1.436191e-001, 1.435738e-001, 1.435285e-001, 1.434833e-001, 1.434380e-001, 1.433928e-001, 1.433476e-001, 1.433023e-001, 1.432571e-001, 1.432119e-001, 1.431668e-001, 1.431216e-001, 1.430764e-001, 1.430313e-001, 1.429861e-001, 1.429410e-001, 
1.428958e-001, 1.428507e-001, 1.428056e-001, 1.427605e-001, 1.427154e-001, 1.426703e-001, 1.426253e-001, 1.425802e-001, 1.425351e-001, 1.424901e-001, 1.424451e-001, 1.424000e-001, 1.423550e-001, 1.423100e-001, 1.422650e-001, 1.422200e-001, 1.421750e-001, 1.421301e-001, 1.420851e-001, 1.420402e-001, 1.419952e-001, 1.419503e-001, 1.419054e-001, 1.418605e-001, 1.418156e-001, 1.417707e-001, 1.417258e-001, 1.416809e-001, 1.416361e-001, 1.415912e-001, 1.415464e-001, 1.415015e-001, 1.414567e-001, 1.414119e-001, 1.413671e-001, 1.413223e-001, 1.412775e-001, 1.412327e-001, 1.411879e-001, 1.411432e-001, 1.410984e-001, 1.410537e-001, 1.410089e-001, 1.409642e-001, 1.409195e-001, 1.408748e-001, 1.408301e-001, 1.407854e-001, 1.407408e-001, 1.406961e-001, 1.406514e-001, 1.406068e-001, 1.405622e-001, 1.405175e-001, 1.404729e-001, 1.404283e-001, 1.403837e-001, 1.403391e-001, 1.402945e-001, 1.402500e-001, 1.402054e-001, 1.401608e-001, 1.401163e-001, 1.400718e-001, 1.400272e-001, 1.399827e-001, 1.399382e-001, 1.398937e-001, 1.398492e-001, 1.398048e-001, 1.397603e-001, 1.397158e-001, 1.396714e-001, 1.396270e-001, 1.395825e-001, 1.395381e-001, 1.394937e-001, 1.394493e-001, 1.394049e-001, 1.393605e-001, 1.393161e-001, 1.392718e-001, 1.392274e-001, 1.391831e-001, 1.391388e-001, 1.390944e-001, 1.390501e-001, 1.390058e-001, 1.389615e-001, 1.389172e-001, 1.388729e-001, 1.388287e-001, 1.387844e-001, 1.387402e-001, 1.386959e-001, 1.386517e-001, 1.386075e-001, 1.385632e-001, 1.385190e-001, 1.384749e-001, 
1.384307e-001, 1.383865e-001, 1.383423e-001, 1.382982e-001, 1.382540e-001, 1.382099e-001, 1.381658e-001, 1.381216e-001, 1.380775e-001, 1.380334e-001, 1.379893e-001, 1.379453e-001, 1.379012e-001, 1.378571e-001, 1.378131e-001, 1.377690e-001, 1.377250e-001, 1.376810e-001, 1.376369e-001, 1.375929e-001, 1.375489e-001, 1.375050e-001, 1.374610e-001, 1.374170e-001, 1.373731e-001, 1.373291e-001, 1.372852e-001, 1.372412e-001, 1.371973e-001, 1.371534e-001, 1.371095e-001, 1.370656e-001, 1.370217e-001, 1.369778e-001, 1.369340e-001, 1.368901e-001, 1.368463e-001, 1.368024e-001, 1.367586e-001, 1.367148e-001, 1.366710e-001, 1.366272e-001, 1.365834e-001, 1.365396e-001, 1.364958e-001, 1.364521e-001, 1.364083e-001, 1.363646e-001, 1.363208e-001, 1.362771e-001, 1.362334e-001, 1.361897e-001, 1.361460e-001, 1.361023e-001, 1.360586e-001, 1.360150e-001, 1.359713e-001, 1.359276e-001, 1.358840e-001, 1.358404e-001, 1.357968e-001, 1.357531e-001, 1.357095e-001, 1.356659e-001, 1.356224e-001, 1.355788e-001, 1.355352e-001, 1.354917e-001, 1.354481e-001, 1.354046e-001, 1.353610e-001, 1.353175e-001, 1.352740e-001, 1.352305e-001, 1.351870e-001, 1.351435e-001, 1.351001e-001, 1.350566e-001, 1.350131e-001, 1.349697e-001, 1.349263e-001, 1.348828e-001, 1.348394e-001, 1.347960e-001, 1.347526e-001, 1.347092e-001, 1.346658e-001, 1.346225e-001, 1.345791e-001, 1.345358e-001, 1.344924e-001, 1.344491e-001, 1.344058e-001, 1.343624e-001, 1.343191e-001, 1.342758e-001, 1.342326e-001, 1.341893e-001, 1.341460e-001, 1.341027e-001, 
1.340595e-001, 1.340163e-001, 1.339730e-001, 1.339298e-001, 1.338866e-001, 1.338434e-001, 1.338002e-001, 1.337570e-001, 1.337138e-001, 1.336707e-001, 1.336275e-001, 1.335844e-001, 1.335412e-001, 1.334981e-001, 1.334550e-001, 1.334119e-001, 1.333688e-001, 1.333257e-001, 1.332826e-001, 1.332395e-001, 1.331965e-001, 1.331534e-001, 1.331104e-001, 1.330673e-001, 1.330243e-001, 1.329813e-001, 1.329383e-001, 1.328953e-001, 1.328523e-001, 1.328093e-001, 1.327663e-001, 1.327234e-001, 1.326804e-001, 1.326375e-001, 1.325945e-001, 1.325516e-001, 1.325087e-001, 1.324658e-001, 1.324229e-001, 1.323800e-001, 1.323371e-001, 1.322943e-001, 1.322514e-001, 1.322085e-001, 1.321657e-001, 1.321229e-001, 1.320801e-001, 1.320372e-001, 1.319944e-001, 1.319516e-001, 1.319089e-001, 1.318661e-001, 1.318233e-001, 1.317806e-001, 1.317378e-001, 1.316951e-001, 1.316523e-001, 1.316096e-001, 1.315669e-001, 1.315242e-001, 1.314815e-001, 1.314388e-001, 1.313961e-001, 1.313535e-001, 1.313108e-001, 1.312682e-001, 1.312255e-001, 1.311829e-001, 1.311403e-001, 1.310977e-001, 1.310551e-001, 1.310125e-001, 1.309699e-001, 1.309273e-001, 1.308848e-001, 1.308422e-001, 1.307997e-001, 1.307571e-001, 1.307146e-001, 1.306721e-001, 1.306296e-001, 1.305871e-001, 1.305446e-001, 1.305021e-001, 1.304596e-001, 1.304172e-001, 1.303747e-001, 1.303323e-001, 1.302898e-001, 1.302474e-001, 1.302050e-001, 1.301626e-001, 1.301202e-001, 1.300778e-001, 1.300354e-001, 1.299930e-001, 1.299507e-001, 1.299083e-001, 1.298660e-001, 1.298237e-001, 
1.297813e-001, 1.297390e-001, 1.296967e-001, 1.296544e-001, 1.296121e-001, 1.295698e-001, 1.295276e-001, 1.294853e-001, 1.294431e-001, 1.294008e-001, 1.293586e-001, 1.293164e-001, 1.292742e-001, 1.292320e-001, 1.291898e-001, 1.291476e-001, 1.291054e-001, 1.290632e-001, 1.290211e-001, 1.289789e-001, 1.289368e-001, 1.288946e-001, 1.288525e-001, 1.288104e-001, 1.287683e-001, 1.287262e-001, 1.286841e-001, 1.286420e-001, 1.286000e-001, 1.285579e-001, 1.285159e-001, 1.284738e-001, 1.284318e-001, 1.283898e-001, 1.283478e-001, 1.283058e-001, 1.282638e-001, 1.282218e-001, 1.281798e-001, 1.281378e-001, 1.280959e-001, 1.280539e-001, 1.280120e-001, 1.279701e-001, 1.279281e-001, 1.278862e-001, 1.278443e-001, 1.278024e-001, 1.277606e-001, 1.277187e-001, 1.276768e-001, 1.276350e-001, 1.275931e-001, 1.275513e-001, 1.275094e-001, 1.274676e-001, 1.274258e-001, 1.273840e-001, 1.273422e-001, 1.273004e-001, 1.272587e-001, 1.272169e-001, 1.271751e-001, 1.271334e-001, 1.270917e-001, 1.270499e-001, 1.270082e-001, 1.269665e-001, 1.269248e-001, 1.268831e-001, 1.268414e-001, 1.267997e-001, 1.267581e-001, 1.267164e-001, 1.266748e-001, 1.266331e-001, 1.265915e-001, 1.265499e-001, 1.265083e-001, 1.264667e-001, 1.264251e-001, 1.263835e-001, 1.263419e-001, 1.263004e-001, 1.262588e-001, 1.262173e-001, 1.261757e-001, 1.261342e-001, 1.260927e-001, 1.260512e-001, 1.260097e-001, 1.259682e-001, 1.259267e-001, 1.258852e-001, 1.258438e-001, 1.258023e-001, 1.257609e-001, 1.257194e-001, 1.256780e-001, 1.256366e-001, 
1.255952e-001, 1.255538e-001, 1.255124e-001, 1.254710e-001, 1.254296e-001, 1.253883e-001, 1.253469e-001, 1.253056e-001, 1.252642e-001, 1.252229e-001, 1.251816e-001, 1.251403e-001, 1.250990e-001, 1.250577e-001, 1.250164e-001, 1.249751e-001, 1.249339e-001, 1.248926e-001, 1.248513e-001, 1.248101e-001, 1.247689e-001, 1.247277e-001, 1.246865e-001, 1.246453e-001, 1.246041e-001, 1.245629e-001, 1.245217e-001, 1.244805e-001, 1.244394e-001, 1.243982e-001, 1.243571e-001, 1.243160e-001, 1.242749e-001, 1.242338e-001, 1.241926e-001, 1.241516e-001, 1.241105e-001, 1.240694e-001, 1.240283e-001, 1.239873e-001, 1.239462e-001, 1.239052e-001, 1.238642e-001, 1.238232e-001, 1.237821e-001, 1.237411e-001, 1.237001e-001, 1.236592e-001, 1.236182e-001, 1.235772e-001, 1.235363e-001, 1.234953e-001, 1.234544e-001, 1.234135e-001, 1.233725e-001, 1.233316e-001, 1.232907e-001, 1.232498e-001, 1.232090e-001, 1.231681e-001, 1.231272e-001, 1.230864e-001, 1.230455e-001, 1.230047e-001, 1.229638e-001, 1.229230e-001, 1.228822e-001, 1.228414e-001, 1.228006e-001, 1.227598e-001, 1.227191e-001, 1.226783e-001, 1.226375e-001, 1.225968e-001, 1.225560e-001, 1.225153e-001, 1.224746e-001, 1.224339e-001, 1.223932e-001, 1.223525e-001, 1.223118e-001, 1.222711e-001, 1.222305e-001, 1.221898e-001, 1.221492e-001, 1.221085e-001, 1.220679e-001, 1.220273e-001, 1.219866e-001, 1.219460e-001, 1.219055e-001, 1.218649e-001, 1.218243e-001, 1.217837e-001, 1.217432e-001, 1.217026e-001, 1.216621e-001, 1.216215e-001, 1.215810e-001, 1.215405e-001, 
1.215000e-001, 1.214595e-001, 1.214190e-001, 1.213785e-001, 1.213381e-001, 1.212976e-001, 1.212572e-001, 1.212167e-001, 1.211763e-001, 1.211359e-001, 1.210954e-001, 1.210550e-001, 1.210146e-001, 1.209743e-001, 1.209339e-001, 1.208935e-001, 1.208532e-001, 1.208128e-001, 1.207725e-001, 1.207321e-001, 1.206918e-001, 1.206515e-001, 1.206112e-001, 1.205709e-001, 1.205306e-001, 1.204903e-001, 1.204500e-001, 1.204098e-001, 1.203695e-001, 1.203293e-001, 1.202890e-001, 1.202488e-001, 1.202086e-001, 1.201684e-001, 1.201282e-001, 1.200880e-001, 1.200478e-001, 1.200077e-001, 1.199675e-001, 1.199273e-001, 1.198872e-001, 1.198471e-001, 1.198069e-001, 1.197668e-001, 1.197267e-001, 1.196866e-001, 1.196465e-001, 1.196064e-001, 1.195663e-001, 1.195263e-001, 1.194862e-001, 1.194462e-001, 1.194061e-001, 1.193661e-001, 1.193261e-001, 1.192861e-001, 1.192461e-001, 1.192061e-001, 1.191661e-001, 1.191261e-001, 1.190862e-001, 1.190462e-001, 1.190063e-001, 1.189663e-001, 1.189264e-001, 1.188865e-001, 1.188466e-001, 1.188067e-001, 1.187668e-001, 1.187269e-001, 1.186870e-001, 1.186471e-001, 1.186073e-001, 1.185674e-001, 1.185276e-001, 1.184877e-001, 1.184479e-001, 1.184081e-001, 1.183683e-001, 1.183285e-001, 1.182887e-001, 1.182489e-001, 1.182092e-001, 1.181694e-001, 1.181297e-001, 1.180899e-001, 1.180502e-001, 1.180105e-001, 1.179707e-001, 1.179310e-001, 1.178913e-001, 1.178516e-001, 1.178120e-001, 1.177723e-001, 1.177326e-001, 1.176930e-001, 1.176533e-001, 1.176137e-001, 1.175741e-001, 1.175344e-001, 
1.174948e-001, 1.174552e-001, 1.174156e-001, 1.173761e-001, 1.173365e-001, 1.172969e-001, 1.172574e-001, 1.172178e-001, 1.171783e-001, 1.171387e-001, 1.170992e-001, 1.170597e-001, 1.170202e-001, 1.169807e-001, 1.169412e-001, 1.169018e-001, 1.168623e-001, 1.168228e-001, 1.167834e-001, 1.167439e-001, 1.167045e-001, 1.166651e-001, 1.166257e-001, 1.165863e-001, 1.165469e-001, 1.165075e-001, 1.164681e-001, 1.164287e-001, 1.163894e-001, 1.163500e-001, 1.163107e-001, 1.162713e-001, 1.162320e-001, 1.161927e-001, 1.161534e-001, 1.161141e-001, 1.160748e-001, 1.160355e-001, 1.159963e-001, 1.159570e-001, 1.159177e-001, 1.158785e-001, 1.158393e-001, 1.158000e-001, 1.157608e-001, 1.157216e-001, 1.156824e-001, 1.156432e-001, 1.156040e-001, 1.155649e-001, 1.155257e-001, 1.154865e-001, 1.154474e-001, 1.154082e-001, 1.153691e-001, 1.153300e-001, 1.152909e-001, 1.152518e-001, 1.152127e-001, 1.151736e-001, 1.151345e-001, 1.150954e-001, 1.150564e-001, 1.150173e-001, 1.149783e-001, 1.149393e-001, 1.149002e-001, 1.148612e-001, 1.148222e-001, 1.147832e-001, 1.147442e-001, 1.147053e-001, 1.146663e-001, 1.146273e-001, 1.145884e-001, 1.145494e-001, 1.145105e-001, 1.144716e-001, 1.144326e-001, 1.143937e-001, 1.143548e-001, 1.143159e-001, 1.142771e-001, 1.142382e-001, 1.141993e-001, 1.141605e-001, 1.141216e-001, 1.140828e-001, 1.140439e-001, 1.140051e-001, 1.139663e-001, 1.139275e-001, 1.138887e-001, 1.138499e-001, 1.138111e-001, 1.137724e-001, 1.137336e-001, 1.136949e-001, 1.136561e-001, 1.136174e-001, 
1.135787e-001, 1.135400e-001, 1.135012e-001, 1.134625e-001, 1.134239e-001, 1.133852e-001, 1.133465e-001, 1.133078e-001, 1.132692e-001, 1.132305e-001, 1.131919e-001, 1.131533e-001, 1.131147e-001, 1.130760e-001, 1.130374e-001, 1.129989e-001, 1.129603e-001, 1.129217e-001, 1.128831e-001, 1.128446e-001, 1.128060e-001, 1.127675e-001, 1.127290e-001, 1.126904e-001, 1.126519e-001, 1.126134e-001, 1.125749e-001, 1.125364e-001, 1.124980e-001, 1.124595e-001, 1.124210e-001, 1.123826e-001, 1.123441e-001, 1.123057e-001, 1.122673e-001, 1.122288e-001, 1.121904e-001, 1.121520e-001, 1.121137e-001, 1.120753e-001, 1.120369e-001, 1.119985e-001, 1.119602e-001, 1.119218e-001, 1.118835e-001, 1.118452e-001, 1.118068e-001, 1.117685e-001, 1.117302e-001, 1.116919e-001, 1.116536e-001, 1.116154e-001, 1.115771e-001, 1.115388e-001, 1.115006e-001, 1.114623e-001, 1.114241e-001, 1.113859e-001, 1.113477e-001, 1.113095e-001, 1.112713e-001, 1.112331e-001, 1.111949e-001, 1.111567e-001, 1.111186e-001, 1.110804e-001, 1.110423e-001, 1.110041e-001, 1.109660e-001, 1.109279e-001, 1.108898e-001, 1.108517e-001, 1.108136e-001, 1.107755e-001, 1.107374e-001, 1.106993e-001, 1.106613e-001, 1.106232e-001, 1.105852e-001, 1.105472e-001, 1.105091e-001, 1.104711e-001, 1.104331e-001, 1.103951e-001, 1.103571e-001, 1.103192e-001, 1.102812e-001, 1.102432e-001, 1.102053e-001, 1.101673e-001, 1.101294e-001, 1.100915e-001, 1.100535e-001, 1.100156e-001, 1.099777e-001, 1.099398e-001, 1.099019e-001, 1.098641e-001, 1.098262e-001, 1.097883e-001, 
1.097505e-001, 1.097127e-001, 1.096748e-001, 1.096370e-001, 1.095992e-001, 1.095614e-001, 1.095236e-001, 1.094858e-001, 1.094480e-001, 1.094102e-001, 1.093725e-001, 1.093347e-001, 1.092970e-001, 1.092592e-001, 1.092215e-001, 1.091838e-001, 1.091461e-001, 1.091084e-001, 1.090707e-001, 1.090330e-001, 1.089953e-001, 1.089577e-001, 1.089200e-001, 1.088824e-001, 1.088447e-001, 1.088071e-001, 1.087695e-001, 1.087319e-001, 1.086942e-001, 1.086566e-001, 1.086191e-001, 1.085815e-001, 1.085439e-001, 1.085063e-001, 1.084688e-001, 1.084312e-001, 1.083937e-001, 1.083562e-001, 1.083187e-001, 1.082812e-001, 1.082436e-001, 1.082062e-001, 1.081687e-001, 1.081312e-001, 1.080937e-001, 1.080563e-001, 1.080188e-001, 1.079814e-001, 1.079439e-001, 1.079065e-001, 1.078691e-001, 1.078317e-001, 1.077943e-001, 1.077569e-001, 1.077195e-001, 1.076822e-001, 1.076448e-001, 1.076074e-001, 1.075701e-001, 1.075328e-001, 1.074954e-001, 1.074581e-001, 1.074208e-001, 1.073835e-001, 1.073462e-001, 1.073089e-001, 1.072716e-001, 1.072344e-001, 1.071971e-001, 1.071599e-001, 1.071226e-001, 1.070854e-001, 1.070481e-001, 1.070109e-001, 1.069737e-001, 1.069365e-001, 1.068993e-001, 1.068622e-001, 1.068250e-001, 1.067878e-001, 1.067507e-001, 1.067135e-001, 1.066764e-001, 1.066392e-001, 1.066021e-001, 1.065650e-001, 1.065279e-001, 1.064908e-001, 1.064537e-001, 1.064166e-001, 1.063796e-001, 1.063425e-001, 1.063054e-001, 1.062684e-001, 1.062314e-001, 1.061943e-001, 1.061573e-001, 1.061203e-001, 1.060833e-001, 1.060463e-001, 
1.060093e-001, 1.059724e-001, 1.059354e-001, 1.058984e-001, 1.058615e-001, 1.058245e-001, 1.057876e-001, 1.057507e-001, 1.057138e-001, 1.056769e-001, 1.056400e-001, 1.056031e-001, 1.055662e-001, 1.055293e-001, 1.054925e-001, 1.054556e-001, 1.054188e-001, 1.053819e-001, 1.053451e-001, 1.053083e-001, 1.052715e-001, 1.052346e-001, 1.051979e-001, 1.051611e-001, 1.051243e-001, 1.050875e-001, 1.050508e-001, 1.050140e-001, 1.049773e-001, 1.049405e-001, 1.049038e-001, 1.048671e-001, 1.048304e-001, 1.047937e-001, 1.047570e-001, 1.047203e-001, 1.046836e-001, 1.046470e-001, 1.046103e-001, 1.045736e-001, 1.045370e-001, 1.045004e-001, 1.044637e-001, 1.044271e-001, 1.043905e-001, 1.043539e-001, 1.043173e-001, 1.042808e-001, 1.042442e-001, 1.042076e-001, 1.041711e-001, 1.041345e-001, 1.040980e-001, 1.040614e-001, 1.040249e-001, 1.039884e-001, 1.039519e-001, 1.039154e-001, 1.038789e-001, 1.038424e-001, 1.038060e-001, 1.037695e-001, 1.037331e-001, 1.036966e-001, 1.036602e-001, 1.036238e-001, 1.035873e-001, 1.035509e-001, 1.035145e-001, 1.034781e-001, 1.034417e-001, 1.034054e-001, 1.033690e-001, 1.033326e-001, 1.032963e-001, 1.032600e-001, 1.032236e-001, 1.031873e-001, 1.031510e-001, 1.031147e-001, 1.030784e-001, 1.030421e-001, 1.030058e-001, 1.029695e-001, 1.029333e-001, 1.028970e-001, 1.028608e-001, 1.028245e-001, 1.027883e-001, 1.027521e-001, 1.027158e-001, 1.026796e-001, 1.026434e-001, 1.026072e-001, 1.025711e-001, 1.025349e-001, 1.024987e-001, 1.024626e-001, 1.024264e-001, 1.023903e-001, 
1.023542e-001, 1.023180e-001, 1.022819e-001, 1.022458e-001, 1.022097e-001, 1.021736e-001, 1.021376e-001, 1.021015e-001, 1.020654e-001, 1.020294e-001, 1.019933e-001, 1.019573e-001, 1.019213e-001, 1.018853e-001, 1.018492e-001, 1.018132e-001, 1.017773e-001, 1.017413e-001, 1.017053e-001, 1.016693e-001, 1.016334e-001, 1.015974e-001, 1.015615e-001, 1.015255e-001, 1.014896e-001, 1.014537e-001, 1.014178e-001, 1.013819e-001, 1.013460e-001, 1.013101e-001, 1.012742e-001, 1.012384e-001, 1.012025e-001, 1.011667e-001, 1.011308e-001, 1.010950e-001, 1.010592e-001, 1.010234e-001, 1.009875e-001, 1.009517e-001, 1.009160e-001, 1.008802e-001, 1.008444e-001, 1.008086e-001, 1.007729e-001, 1.007371e-001, 1.007014e-001, 1.006657e-001, 1.006299e-001, 1.005942e-001, 1.005585e-001, 1.005228e-001, 1.004871e-001, 1.004515e-001, 1.004158e-001, 1.003801e-001, 1.003445e-001, 1.003088e-001, 1.002732e-001, 1.002376e-001, 1.002019e-001, 1.001663e-001, 1.001307e-001, 1.000951e-001, 1.000595e-001, 1.000240e-001, 9.998838e-002, 9.995282e-002, 9.991727e-002, 9.988172e-002, 9.984618e-002, 9.981066e-002, 9.977514e-002, 9.973963e-002, 9.970412e-002, 9.966863e-002, 9.963314e-002, 9.959766e-002, 9.956219e-002, 9.952673e-002, 9.949128e-002, 9.945584e-002, 9.942040e-002, 9.938497e-002, 9.934956e-002, 9.931415e-002, 9.927874e-002, 9.924335e-002, 9.920797e-002, 9.917259e-002, 9.913722e-002, 9.910186e-002, 9.906651e-002, 9.903117e-002, 9.899583e-002, 9.896051e-002, 9.892519e-002, 9.888988e-002, 9.885458e-002, 9.881928e-002, 
9.878400e-002, 9.874872e-002, 9.871346e-002, 9.867820e-002, 9.864295e-002, 9.860770e-002, 9.857247e-002, 9.853725e-002, 9.850203e-002, 9.846682e-002, 9.843162e-002, 9.839643e-002, 9.836124e-002, 9.832607e-002, 9.829090e-002, 9.825574e-002, 9.822059e-002, 9.818545e-002, 9.815032e-002, 9.811520e-002, 9.808008e-002, 9.804497e-002, 9.800987e-002, 9.797478e-002, 9.793970e-002, 9.790462e-002, 9.786956e-002, 9.783450e-002, 9.779945e-002, 9.776441e-002, 9.772938e-002, 9.769435e-002, 9.765934e-002, 9.762433e-002, 9.758933e-002, 9.755434e-002, 9.751936e-002, 9.748438e-002, 9.744942e-002, 9.741446e-002, 9.737951e-002, 9.734457e-002, 9.730964e-002, 9.727471e-002, 9.723980e-002, 9.720489e-002, 9.716999e-002, 9.713510e-002, 9.710022e-002, 9.706534e-002, 9.703048e-002, 9.699562e-002, 9.696077e-002, 9.692593e-002, 9.689110e-002, 9.685628e-002, 9.682146e-002, 9.678665e-002, 9.675186e-002, 9.671707e-002, 9.668228e-002, 9.664751e-002, 9.661275e-002, 9.657799e-002, 9.654324e-002, 9.650850e-002, 9.647377e-002, 9.643904e-002, 9.640433e-002, 9.636962e-002, 9.633492e-002, 9.630023e-002, 9.626555e-002, 9.623088e-002, 9.619621e-002, 9.616155e-002, 9.612691e-002, 9.609227e-002, 9.605763e-002, 9.602301e-002, 9.598839e-002, 9.595379e-002, 9.591919e-002, 9.588460e-002, 9.585002e-002, 9.581544e-002, 9.578088e-002, 9.574632e-002, 9.571177e-002, 9.567723e-002, 9.564270e-002, 9.560817e-002, 9.557366e-002, 9.553915e-002, 9.550465e-002, 9.547016e-002, 9.543568e-002, 9.540121e-002, 9.536674e-002, 9.533228e-002, 
9.529783e-002, 9.526339e-002, 9.522896e-002, 9.519454e-002, 9.516012e-002, 9.512571e-002, 9.509131e-002, 9.505692e-002, 9.502254e-002, 9.498816e-002, 9.495380e-002, 9.491944e-002, 9.488509e-002, 9.485075e-002, 9.481642e-002, 9.478209e-002, 9.474778e-002, 9.471347e-002, 9.467917e-002, 9.464488e-002, 9.461059e-002, 9.457632e-002, 9.454205e-002, 9.450779e-002, 9.447354e-002, 9.443930e-002, 9.440507e-002, 9.437084e-002, 9.433662e-002, 9.430241e-002, 9.426821e-002, 9.423402e-002, 9.419984e-002, 9.416566e-002, 9.413149e-002, 9.409733e-002, 9.406318e-002, 9.402904e-002, 9.399491e-002, 9.396078e-002, 9.392666e-002, 9.389255e-002, 9.385845e-002, 9.382436e-002, 9.379027e-002, 9.375620e-002, 9.372213e-002, 9.368807e-002, 9.365402e-002, 9.361997e-002, 9.358594e-002, 9.355191e-002, 9.351789e-002, 9.348388e-002, 9.344988e-002, 9.341588e-002, 9.338190e-002, 9.334792e-002, 9.331395e-002, 9.327999e-002, 9.324604e-002, 9.321209e-002, 9.317816e-002, 9.314423e-002, 9.311031e-002, 9.307640e-002, 9.304249e-002, 9.300860e-002, 9.297471e-002, 9.294083e-002, 9.290696e-002, 9.287310e-002, 9.283924e-002, 9.280540e-002, 9.277156e-002, 9.273773e-002, 9.270391e-002, 9.267010e-002, 9.263629e-002, 9.260250e-002, 9.256871e-002, 9.253493e-002, 9.250116e-002, 9.246739e-002, 9.243364e-002, 9.239989e-002, 9.236615e-002, 9.233242e-002, 9.229870e-002, 9.226498e-002, 9.223128e-002, 9.219758e-002, 9.216389e-002, 9.213021e-002, 9.209653e-002, 9.206287e-002, 9.202921e-002, 9.199556e-002, 9.196192e-002, 9.192829e-002, 
9.189467e-002, 9.186105e-002, 9.182744e-002, 9.179384e-002, 9.176025e-002, 9.172667e-002, 9.169309e-002, 9.165953e-002, 9.162597e-002, 9.159242e-002, 9.155888e-002, 9.152534e-002, 9.149182e-002, 9.145830e-002, 9.142479e-002, 9.139129e-002, 9.135780e-002, 9.132431e-002, 9.129083e-002, 9.125737e-002, 9.122391e-002, 9.119045e-002, 9.115701e-002, 9.112357e-002, 9.109015e-002, 9.105673e-002, 9.102332e-002, 9.098991e-002, 9.095652e-002, 9.092313e-002, 9.088975e-002, 9.085638e-002, 9.082302e-002, 9.078967e-002, 9.075632e-002, 9.072298e-002, 9.068965e-002, 9.065633e-002, 9.062302e-002, 9.058971e-002, 9.055642e-002, 9.052313e-002, 9.048985e-002, 9.045657e-002, 9.042331e-002, 9.039005e-002, 9.035681e-002, 9.032357e-002, 9.029033e-002, 9.025711e-002, 9.022390e-002, 9.019069e-002, 9.015749e-002, 9.012430e-002, 9.009112e-002, 9.005794e-002, 9.002477e-002, 8.999162e-002, 8.995847e-002, 8.992532e-002, 8.989219e-002, 8.985906e-002, 8.982595e-002, 8.979284e-002, 8.975974e-002, 8.972664e-002, 8.969356e-002, 8.966048e-002, 8.962741e-002, 8.959435e-002, 8.956130e-002, 8.952826e-002, 8.949522e-002, 8.946219e-002, 8.942917e-002, 8.939616e-002, 8.936316e-002, 8.933016e-002, 8.929717e-002, 8.926419e-002, 8.923122e-002, 8.919826e-002, 8.916530e-002, 8.913236e-002, 8.909942e-002, 8.906649e-002, 8.903356e-002, 8.900065e-002, 8.896774e-002, 8.893485e-002, 8.890196e-002, 8.886907e-002, 8.883620e-002, 8.880333e-002, 8.877048e-002, 8.873763e-002, 8.870478e-002, 8.867195e-002, 8.863913e-002, 8.860631e-002, 
8.857350e-002, 8.854070e-002, 8.850791e-002, 8.847512e-002, 8.844234e-002, 8.840958e-002, 8.837682e-002, 8.834406e-002, 8.831132e-002, 8.827858e-002, 8.824585e-002, 8.821313e-002, 8.818042e-002, 8.814772e-002, 8.811502e-002, 8.808234e-002, 8.804966e-002, 8.801698e-002, 8.798432e-002, 8.795167e-002, 8.791902e-002, 8.788638e-002, 8.785375e-002, 8.782113e-002, 8.778851e-002, 8.775590e-002, 8.772330e-002, 8.769071e-002, 8.765813e-002, 8.762556e-002, 8.759299e-002, 8.756043e-002, 8.752788e-002, 8.749534e-002, 8.746281e-002, 8.743028e-002, 8.739776e-002, 8.736525e-002, 8.733275e-002, 8.730026e-002, 8.726777e-002, 8.723529e-002, 8.720282e-002, 8.717036e-002, 8.713791e-002, 8.710546e-002, 8.707302e-002, 8.704059e-002, 8.700817e-002, 8.697576e-002, 8.694335e-002, 8.691096e-002, 8.687857e-002, 8.684619e-002, 8.681381e-002, 8.678145e-002, 8.674909e-002, 8.671674e-002, 8.668440e-002, 8.665207e-002, 8.661974e-002, 8.658743e-002, 8.655512e-002, 8.652282e-002, 8.649053e-002, 8.645824e-002, 8.642596e-002, 8.639370e-002, 8.636143e-002, 8.632918e-002, 8.629694e-002, 8.626470e-002, 8.623247e-002, 8.620025e-002, 8.616804e-002, 8.613584e-002, 8.610364e-002, 8.607145e-002, 8.603927e-002, 8.600710e-002, 8.597493e-002, 8.594278e-002, 8.591063e-002, 8.587849e-002, 8.584636e-002, 8.581423e-002, 8.578212e-002, 8.575001e-002, 8.571791e-002, 8.568582e-002, 8.565373e-002, 8.562166e-002, 8.558959e-002, 8.555753e-002, 8.552548e-002, 8.549343e-002, 8.546140e-002, 8.542937e-002, 8.539735e-002, 8.536534e-002, 
8.533333e-002, 8.530134e-002, 8.526935e-002, 8.523737e-002, 8.520540e-002, 8.517343e-002, 8.514148e-002, 8.510953e-002, 8.507759e-002, 8.504566e-002, 8.501373e-002, 8.498182e-002, 8.494991e-002, 8.491801e-002, 8.488612e-002, 8.485423e-002, 8.482236e-002, 8.479049e-002, 8.475863e-002, 8.472678e-002, 8.469493e-002, 8.466310e-002, 8.463127e-002, 8.459945e-002, 8.456764e-002, 8.453583e-002, 8.450403e-002, 8.447225e-002, 8.444047e-002, 8.440869e-002, 8.437693e-002, 8.434517e-002, 8.431342e-002, 8.428168e-002, 8.424995e-002, 8.421823e-002, 8.418651e-002, 8.415480e-002, 8.412310e-002, 8.409141e-002, 8.405972e-002, 8.402805e-002, 8.399638e-002, 8.396472e-002, 8.393306e-002, 8.390142e-002, 8.386978e-002, 8.383815e-002, 8.380653e-002, 8.377492e-002, 8.374331e-002, 8.371172e-002, 8.368013e-002, 8.364854e-002, 8.361697e-002, 8.358541e-002, 8.355385e-002, 8.352230e-002, 8.349076e-002, 8.345922e-002, 8.342770e-002, 8.339618e-002, 8.336467e-002, 8.333317e-002, 8.330167e-002, 8.327019e-002, 8.323871e-002, 8.320724e-002, 8.317578e-002, 8.314432e-002, 8.311288e-002, 8.308144e-002, 8.305001e-002, 8.301858e-002, 8.298717e-002, 8.295576e-002, 8.292436e-002, 8.289297e-002, 8.286159e-002, 8.283022e-002, 8.279885e-002, 8.276749e-002, 8.273614e-002, 8.270479e-002, 8.267346e-002, 8.264213e-002, 8.261081e-002, 8.257950e-002, 8.254820e-002, 8.251690e-002, 8.248561e-002, 8.245433e-002, 8.242306e-002, 8.239180e-002, 8.236054e-002, 8.232929e-002, 8.229805e-002, 8.226682e-002, 8.223559e-002, 8.220438e-002, 
8.217317e-002, 8.214197e-002, 8.211077e-002, 8.207959e-002, 8.204841e-002, 8.201724e-002, 8.198608e-002, 8.195493e-002, 8.192378e-002, 8.189264e-002, 8.186151e-002, 8.183039e-002, 8.179928e-002, 8.176817e-002, 8.173707e-002, 8.170598e-002, 8.167490e-002, 8.164382e-002, 8.161276e-002, 8.158170e-002, 8.155065e-002, 8.151960e-002, 8.148857e-002, 8.145754e-002, 8.142652e-002, 8.139551e-002, 8.136450e-002, 8.133351e-002, 8.130252e-002, 8.127154e-002, 8.124057e-002, 8.120960e-002, 8.117865e-002, 8.114770e-002, 8.111676e-002, 8.108582e-002, 8.105490e-002, 8.102398e-002, 8.099307e-002, 8.096217e-002, 8.093128e-002, 8.090039e-002, 8.086951e-002, 8.083864e-002, 8.080778e-002, 8.077693e-002, 8.074608e-002, 8.071524e-002, 8.068441e-002, 8.065359e-002, 8.062277e-002, 8.059196e-002, 8.056116e-002, 8.053037e-002, 8.049959e-002, 8.046881e-002, 8.043804e-002, 8.040728e-002, 8.037653e-002, 8.034579e-002, 8.031505e-002, 8.028432e-002, 8.025360e-002, 8.022289e-002, 8.019218e-002, 8.016148e-002, 8.013079e-002, 8.010011e-002, 8.006944e-002, 8.003877e-002, 8.000811e-002, 7.997746e-002, 7.994682e-002, 7.991619e-002, 7.988556e-002, 7.985494e-002, 7.982433e-002, 7.979373e-002, 7.976313e-002, 7.973254e-002, 7.970196e-002, 7.967139e-002, 7.964082e-002, 7.961027e-002, 7.957972e-002, 7.954918e-002, 7.951864e-002, 7.948812e-002, 7.945760e-002, 7.942709e-002, 7.939659e-002, 7.936610e-002, 7.933561e-002, 7.930513e-002, 7.927466e-002, 7.924420e-002, 7.921374e-002, 7.918330e-002, 7.915286e-002, 7.912242e-002, 
7.909200e-002, 7.906158e-002, 7.903118e-002, 7.900078e-002, 7.897038e-002, 7.894000e-002, 7.890962e-002, 7.887925e-002, 7.884889e-002, 7.881854e-002, 7.878819e-002, 7.875785e-002, 7.872752e-002, 7.869720e-002, 7.866688e-002, 7.863658e-002, 7.860628e-002, 7.857599e-002, 7.854570e-002, 7.851543e-002, 7.848516e-002, 7.845490e-002, 7.842465e-002, 7.839440e-002, 7.836416e-002, 7.833393e-002, 7.830371e-002, 7.827350e-002, 7.824329e-002, 7.821310e-002, 7.818291e-002, 7.815272e-002, 7.812255e-002, 7.809238e-002, 7.806222e-002, 7.803207e-002, 7.800193e-002, 7.797179e-002, 7.794166e-002, 7.791154e-002, 7.788143e-002, 7.785132e-002, 7.782123e-002, 7.779114e-002, 7.776106e-002, 7.773098e-002, 7.770092e-002, 7.767086e-002, 7.764081e-002, 7.761076e-002, 7.758073e-002, 7.755070e-002, 7.752068e-002, 7.749067e-002, 7.746067e-002, 7.743067e-002, 7.740068e-002, 7.737070e-002, 7.734073e-002, 7.731076e-002, 7.728080e-002, 7.725085e-002, 7.722091e-002, 7.719098e-002, 7.716105e-002, 7.713113e-002, 7.710122e-002, 7.707132e-002, 7.704142e-002, 7.701153e-002, 7.698165e-002, 7.695178e-002, 7.692192e-002, 7.689206e-002, 7.686221e-002, 7.683237e-002, 7.680253e-002, 7.677271e-002, 7.674289e-002, 7.671308e-002, 7.668327e-002, 7.665348e-002, 7.662369e-002, 7.659391e-002, 7.656414e-002, 7.653438e-002, 7.650462e-002, 7.647487e-002, 7.644513e-002, 7.641539e-002, 7.638567e-002, 7.635595e-002, 7.632624e-002, 7.629654e-002, 7.626684e-002, 7.623715e-002, 7.620747e-002, 7.617780e-002, 7.614814e-002, 7.611848e-002, 
7.608883e-002, 7.605919e-002, 7.602956e-002, 7.599993e-002, 7.597031e-002, 7.594070e-002, 7.591110e-002, 7.588151e-002, 7.585192e-002, 7.582234e-002, 7.579277e-002, 7.576320e-002, 7.573365e-002, 7.570410e-002, 7.567456e-002, 7.564502e-002, 7.561550e-002, 7.558598e-002, 7.555647e-002, 7.552697e-002, 7.549747e-002, 7.546798e-002, 7.543850e-002, 7.540903e-002, 7.537957e-002, 7.535011e-002, 7.532066e-002, 7.529122e-002, 7.526179e-002, 7.523236e-002, 7.520294e-002, 7.517353e-002, 7.514413e-002, 7.511473e-002, 7.508535e-002, 7.505597e-002, 7.502660e-002, 7.499723e-002, 7.496787e-002, 7.493852e-002, 7.490918e-002, 7.487985e-002, 7.485052e-002, 7.482120e-002, 7.479189e-002, 7.476259e-002, 7.473329e-002, 7.470401e-002, 7.467473e-002, 7.464545e-002, 7.461619e-002, 7.458693e-002, 7.455768e-002, 7.452844e-002, 7.449920e-002, 7.446998e-002, 7.444076e-002, 7.441155e-002, 7.438234e-002, 7.435315e-002, 7.432396e-002, 7.429478e-002, 7.426560e-002, 7.423644e-002, 7.420728e-002, 7.417813e-002, 7.414899e-002, 7.411985e-002, 7.409072e-002, 7.406160e-002, 7.403249e-002, 7.400339e-002, 7.397429e-002, 7.394520e-002, 7.391612e-002, 7.388704e-002, 7.385798e-002, 7.382892e-002, 7.379987e-002, 7.377082e-002, 7.374179e-002, 7.371276e-002, 7.368374e-002, 7.365473e-002, 7.362572e-002, 7.359672e-002, 7.356773e-002, 7.353875e-002, 7.350977e-002, 7.348081e-002, 7.345185e-002, 7.342289e-002, 7.339395e-002, 7.336501e-002, 7.333608e-002, 7.330716e-002, 7.327825e-002, 7.324934e-002, 7.322044e-002, 7.319155e-002, 
7.316267e-002, 7.313379e-002, 7.310492e-002, 7.307606e-002, 7.304721e-002, 7.301836e-002, 7.298952e-002, 7.296069e-002, 7.293187e-002, 7.290305e-002, 7.287425e-002, 7.284545e-002, 7.281665e-002, 7.278787e-002, 7.275909e-002, 7.273032e-002, 7.270156e-002, 7.267280e-002, 7.264406e-002, 7.261532e-002, 7.258659e-002, 7.255786e-002, 7.252914e-002, 7.250043e-002, 7.247173e-002, 7.244304e-002, 7.241435e-002, 7.238567e-002, 7.235700e-002, 7.232834e-002, 7.229968e-002, 7.227103e-002, 7.224239e-002, 7.221376e-002, 7.218513e-002, 7.215651e-002, 7.212790e-002, 7.209930e-002, 7.207070e-002, 7.204212e-002, 7.201354e-002, 7.198496e-002, 7.195640e-002, 7.192784e-002, 7.189929e-002, 7.187075e-002, 7.184221e-002, 7.181368e-002, 7.178516e-002, 7.175665e-002, 7.172815e-002, 7.169965e-002, 7.167116e-002, 7.164268e-002, 7.161420e-002, 7.158573e-002, 7.155727e-002, 7.152882e-002, 7.150038e-002, 7.147194e-002, 7.144351e-002, 7.141509e-002, 7.138667e-002, 7.135827e-002, 7.132987e-002, 7.130148e-002, 7.127309e-002, 7.124471e-002, 7.121635e-002, 7.118798e-002, 7.115963e-002, 7.113128e-002, 7.110294e-002, 7.107461e-002, 7.104629e-002, 7.101797e-002, 7.098966e-002, 7.096136e-002, 7.093307e-002, 7.090478e-002, 7.087650e-002, 7.084823e-002, 7.081997e-002, 7.079171e-002, 7.076346e-002, 7.073522e-002, 7.070699e-002, 7.067876e-002, 7.065054e-002, 7.062233e-002, 7.059413e-002, 7.056593e-002, 7.053774e-002, 7.050956e-002, 7.048139e-002, 7.045322e-002, 7.042506e-002, 7.039691e-002, 7.036877e-002, 7.034063e-002, 
7.031250e-002, 7.028438e-002, 7.025626e-002, 7.022816e-002, 7.020006e-002, 7.017197e-002, 7.014388e-002, 7.011581e-002, 7.008774e-002, 7.005968e-002, 7.003162e-002, 7.000358e-002, 6.997554e-002, 6.994751e-002, 6.991948e-002, 6.989147e-002, 6.986346e-002, 6.983546e-002, 6.980746e-002, 6.977948e-002, 6.975150e-002, 6.972353e-002, 6.969556e-002, 6.966761e-002, 6.963966e-002, 6.961172e-002, 6.958378e-002, 6.955586e-002, 6.952794e-002, 6.950002e-002, 6.947212e-002, 6.944422e-002, 6.941633e-002, 6.938845e-002, 6.936058e-002, 6.933271e-002, 6.930485e-002, 6.927700e-002, 6.924916e-002, 6.922132e-002, 6.919349e-002, 6.916567e-002, 6.913785e-002, 6.911005e-002, 6.908225e-002, 6.905445e-002, 6.902667e-002, 6.899889e-002, 6.897112e-002, 6.894336e-002, 6.891560e-002, 6.888786e-002, 6.886012e-002, 6.883238e-002, 6.880466e-002, 6.877694e-002, 6.874923e-002, 6.872153e-002, 6.869383e-002, 6.866614e-002, 6.863846e-002, 6.861079e-002, 6.858313e-002, 6.855547e-002, 6.852782e-002, 6.850017e-002, 6.847254e-002, 6.844491e-002, 6.841729e-002, 6.838967e-002, 6.836207e-002, 6.833447e-002, 6.830688e-002, 6.827929e-002, 6.825172e-002, 6.822415e-002, 6.819659e-002, 6.816903e-002, 6.814149e-002, 6.811395e-002, 6.808641e-002, 6.805889e-002, 6.803137e-002, 6.800386e-002, 6.797636e-002, 6.794887e-002, 6.792138e-002, 6.789390e-002, 6.786643e-002, 6.783896e-002, 6.781150e-002, 6.778405e-002, 6.775661e-002, 6.772917e-002, 6.770175e-002, 6.767433e-002, 6.764691e-002, 6.761951e-002, 6.759211e-002, 6.756472e-002, 
6.753733e-002, 6.750996e-002, 6.748259e-002, 6.745523e-002, 6.742787e-002, 6.740053e-002, 6.737319e-002, 6.734585e-002, 6.731853e-002, 6.729121e-002, 6.726390e-002, 6.723660e-002, 6.720931e-002, 6.718202e-002, 6.715474e-002, 6.712747e-002, 6.710020e-002, 6.707294e-002, 6.704569e-002, 6.701845e-002, 6.699121e-002, 6.696398e-002, 6.693676e-002, 6.690955e-002, 6.688234e-002, 6.685514e-002, 6.682795e-002, 6.680077e-002, 6.677359e-002, 6.674642e-002, 6.671926e-002, 6.669210e-002, 6.666496e-002, 6.663782e-002, 6.661068e-002, 6.658356e-002, 6.655644e-002, 6.652933e-002, 6.650223e-002, 6.647513e-002, 6.644804e-002, 6.642096e-002, 6.639389e-002, 6.636682e-002, 6.633976e-002, 6.631271e-002, 6.628567e-002, 6.625863e-002, 6.623160e-002, 6.620458e-002, 6.617756e-002, 6.615055e-002, 6.612355e-002, 6.609656e-002, 6.606958e-002, 6.604260e-002, 6.601563e-002, 6.598866e-002, 6.596171e-002, 6.593476e-002, 6.590782e-002, 6.588088e-002, 6.585396e-002, 6.582704e-002, 6.580012e-002, 6.577322e-002, 6.574632e-002, 6.571943e-002, 6.569255e-002, 6.566567e-002, 6.563881e-002, 6.561195e-002, 6.558509e-002, 6.555825e-002, 6.553141e-002, 6.550458e-002, 6.547775e-002, 6.545093e-002, 6.542413e-002, 6.539732e-002, 6.537053e-002, 6.534374e-002, 6.531696e-002, 6.529019e-002, 6.526342e-002, 6.523666e-002, 6.520991e-002, 6.518317e-002, 6.515643e-002, 6.512970e-002, 6.510298e-002, 6.507627e-002, 6.504956e-002, 6.502286e-002, 6.499617e-002, 6.496948e-002, 6.494281e-002, 6.491613e-002, 6.488947e-002, 6.486282e-002, 
6.483617e-002, 6.480953e-002, 6.478289e-002, 6.475626e-002, 6.472965e-002, 6.470303e-002, 6.467643e-002, 6.464983e-002, 6.462324e-002, 6.459666e-002, 6.457008e-002, 6.454351e-002, 6.451695e-002, 6.449040e-002, 6.446385e-002, 6.443731e-002, 6.441078e-002, 6.438426e-002, 6.435774e-002, 6.433123e-002, 6.430473e-002, 6.427823e-002, 6.425174e-002, 6.422526e-002, 6.419879e-002, 6.417232e-002, 6.414586e-002, 6.411941e-002, 6.409296e-002, 6.406653e-002, 6.404010e-002, 6.401367e-002, 6.398726e-002, 6.396085e-002, 6.393445e-002, 6.390806e-002, 6.388167e-002, 6.385529e-002, 6.382892e-002, 6.380255e-002, 6.377620e-002, 6.374985e-002, 6.372350e-002, 6.369717e-002, 6.367084e-002, 6.364452e-002, 6.361820e-002, 6.359190e-002, 6.356560e-002, 6.353931e-002, 6.351302e-002, 6.348674e-002, 6.346047e-002, 6.343421e-002, 6.340795e-002, 6.338171e-002, 6.335546e-002, 6.332923e-002, 6.330300e-002, 6.327678e-002, 6.325057e-002, 6.322437e-002, 6.319817e-002, 6.317198e-002, 6.314579e-002, 6.311962e-002, 6.309345e-002, 6.306729e-002, 6.304113e-002, 6.301498e-002, 6.298884e-002, 6.296271e-002, 6.293659e-002, 6.291047e-002, 6.288436e-002, 6.285825e-002, 6.283216e-002, 6.280607e-002, 6.277998e-002, 6.275391e-002, 6.272784e-002, 6.270178e-002, 6.267573e-002, 6.264968e-002, 6.262364e-002, 6.259761e-002, 6.257159e-002, 6.254557e-002, 6.251956e-002, 6.249356e-002, 6.246756e-002, 6.244157e-002, 6.241559e-002, 6.238962e-002, 6.236365e-002, 6.233769e-002, 6.231174e-002, 6.228579e-002, 6.225985e-002, 6.223392e-002, 
6.220800e-002, 6.218208e-002, 6.215617e-002, 6.213027e-002, 6.210438e-002, 6.207849e-002, 6.205261e-002, 6.202674e-002, 6.200087e-002, 6.197501e-002, 6.194916e-002, 6.192332e-002, 6.189748e-002, 6.187165e-002, 6.184583e-002, 6.182001e-002, 6.179420e-002, 6.176840e-002, 6.174261e-002, 6.171682e-002, 6.169104e-002, 6.166527e-002, 6.163950e-002, 6.161374e-002, 6.158799e-002, 6.156225e-002, 6.153651e-002, 6.151078e-002, 6.148506e-002, 6.145934e-002, 6.143364e-002, 6.140793e-002, 6.138224e-002, 6.135655e-002, 6.133088e-002, 6.130520e-002, 6.127954e-002, 6.125388e-002, 6.122823e-002, 6.120259e-002, 6.117695e-002, 6.115132e-002, 6.112570e-002, 6.110008e-002, 6.107448e-002, 6.104887e-002, 6.102328e-002, 6.099770e-002, 6.097212e-002, 6.094654e-002, 6.092098e-002, 6.089542e-002, 6.086987e-002, 6.084433e-002, 6.081879e-002, 6.079326e-002, 6.076774e-002, 6.074223e-002, 6.071672e-002, 6.069122e-002, 6.066572e-002, 6.064024e-002, 6.061476e-002, 6.058929e-002, 6.056382e-002, 6.053836e-002, 6.051291e-002, 6.048747e-002, 6.046203e-002, 6.043660e-002, 6.041118e-002, 6.038577e-002, 6.036036e-002, 6.033496e-002, 6.030957e-002, 6.028418e-002, 6.025880e-002, 6.023343e-002, 6.020806e-002, 6.018271e-002, 6.015735e-002, 6.013201e-002, 6.010667e-002, 6.008135e-002, 6.005602e-002, 6.003071e-002, 6.000540e-002, 5.998010e-002, 5.995480e-002, 5.992952e-002, 5.990424e-002, 5.987897e-002, 5.985370e-002, 5.982844e-002, 5.980319e-002, 5.977795e-002, 5.975271e-002, 5.972748e-002, 5.970226e-002, 5.967704e-002, 
5.965183e-002, 5.962663e-002, 5.960144e-002, 5.957625e-002, 5.955107e-002, 5.952590e-002, 5.950073e-002, 5.947557e-002, 5.945042e-002, 5.942528e-002, 5.940014e-002, 5.937501e-002, 5.934988e-002, 5.932477e-002, 5.929966e-002, 5.927456e-002, 5.924946e-002, 5.922437e-002, 5.919929e-002, 5.917422e-002, 5.914915e-002, 5.912409e-002, 5.909904e-002, 5.907399e-002, 5.904896e-002, 5.902392e-002, 5.899890e-002, 5.897388e-002, 5.894887e-002, 5.892387e-002, 5.889887e-002, 5.887388e-002, 5.884890e-002, 5.882393e-002, 5.879896e-002, 5.877400e-002, 5.874905e-002, 5.872410e-002, 5.869916e-002, 5.867423e-002, 5.864930e-002, 5.862438e-002, 5.859947e-002, 5.857457e-002, 5.854967e-002, 5.852478e-002, 5.849990e-002, 5.847502e-002, 5.845015e-002, 5.842529e-002, 5.840044e-002, 5.837559e-002, 5.835075e-002, 5.832592e-002, 5.830109e-002, 5.827627e-002, 5.825146e-002, 5.822665e-002, 5.820185e-002, 5.817706e-002, 5.815228e-002, 5.812750e-002, 5.810273e-002, 5.807797e-002, 5.805321e-002, 5.802846e-002, 5.800372e-002, 5.797898e-002, 5.795426e-002, 5.792954e-002, 5.790482e-002, 5.788011e-002, 5.785541e-002, 5.783072e-002, 5.780604e-002, 5.778136e-002, 5.775668e-002, 5.773202e-002, 5.770736e-002, 5.768271e-002, 5.765807e-002, 5.763343e-002, 5.760880e-002, 5.758418e-002, 5.755956e-002, 5.753495e-002, 5.751035e-002, 5.748576e-002, 5.746117e-002, 5.743659e-002, 5.741202e-002, 5.738745e-002, 5.736289e-002, 5.733834e-002, 5.731379e-002, 5.728925e-002, 5.726472e-002, 5.724020e-002, 5.721568e-002, 5.719117e-002, 
5.716667e-002, 5.714217e-002, 5.711768e-002, 5.709320e-002, 5.706872e-002, 5.704425e-002, 5.701979e-002, 5.699534e-002, 5.697089e-002, 5.694645e-002, 5.692202e-002, 5.689759e-002, 5.687317e-002, 5.684876e-002, 5.682435e-002, 5.679995e-002, 5.677556e-002, 5.675118e-002, 5.672680e-002, 5.670243e-002, 5.667807e-002, 5.665371e-002, 5.662936e-002, 5.660502e-002, 5.658068e-002, 5.655635e-002, 5.653203e-002, 5.650771e-002, 5.648341e-002, 5.645911e-002, 5.643481e-002, 5.641053e-002, 5.638625e-002, 5.636197e-002, 5.633771e-002, 5.631345e-002, 5.628919e-002, 5.626495e-002, 5.624071e-002, 5.621648e-002, 5.619226e-002, 5.616804e-002, 5.614383e-002, 5.611962e-002, 5.609543e-002, 5.607124e-002, 5.604706e-002, 5.602288e-002, 5.599871e-002, 5.597455e-002, 5.595040e-002, 5.592625e-002, 5.590211e-002, 5.587797e-002, 5.585385e-002, 5.582973e-002, 5.580561e-002, 5.578151e-002, 5.575741e-002, 5.573332e-002, 5.570923e-002, 5.568515e-002, 5.566108e-002, 5.563702e-002, 5.561296e-002, 5.558891e-002, 5.556486e-002, 5.554083e-002, 5.551680e-002, 5.549278e-002, 5.546876e-002, 5.544475e-002, 5.542075e-002, 5.539675e-002, 5.537277e-002, 5.534878e-002, 5.532481e-002, 5.530084e-002, 5.527688e-002, 5.525293e-002, 5.522898e-002, 5.520504e-002, 5.518111e-002, 5.515718e-002, 5.513326e-002, 5.510935e-002, 5.508545e-002, 5.506155e-002, 5.503766e-002, 5.501377e-002, 5.498990e-002, 5.496602e-002, 5.494216e-002, 5.491830e-002, 5.489445e-002, 5.487061e-002, 5.484678e-002, 5.482295e-002, 5.479912e-002, 5.477531e-002, 
5.475150e-002, 5.472770e-002, 5.470390e-002, 5.468012e-002, 5.465634e-002, 5.463256e-002, 5.460879e-002, 5.458503e-002, 5.456128e-002, 5.453753e-002, 5.451379e-002, 5.449006e-002, 5.446634e-002, 5.444262e-002, 5.441891e-002, 5.439520e-002, 5.437150e-002, 5.434781e-002, 5.432413e-002, 5.430045e-002, 5.427678e-002, 5.425311e-002, 5.422946e-002, 5.420581e-002, 5.418216e-002, 5.415853e-002, 5.413490e-002, 5.411128e-002, 5.408766e-002, 5.406405e-002, 5.404045e-002, 5.401686e-002, 5.399327e-002, 5.396969e-002, 5.394611e-002, 5.392254e-002, 5.389898e-002, 5.387543e-002, 5.385188e-002, 5.382834e-002, 5.380481e-002, 5.378128e-002, 5.375776e-002, 5.373425e-002, 5.371075e-002, 5.368725e-002, 5.366375e-002, 5.364027e-002, 5.361679e-002, 5.359332e-002, 5.356985e-002, 5.354640e-002, 5.352295e-002, 5.349950e-002, 5.347606e-002, 5.345263e-002, 5.342921e-002, 5.340579e-002, 5.338238e-002, 5.335898e-002, 5.333558e-002, 5.331219e-002, 5.328881e-002, 5.326544e-002, 5.324207e-002, 5.321871e-002, 5.319535e-002, 5.317200e-002, 5.314866e-002, 5.312533e-002, 5.310200e-002, 5.307868e-002, 5.305536e-002, 5.303206e-002, 5.300875e-002, 5.298546e-002, 5.296217e-002, 5.293889e-002, 5.291562e-002, 5.289235e-002, 5.286909e-002, 5.284584e-002, 5.282260e-002, 5.279936e-002, 5.277612e-002, 5.275290e-002, 5.272968e-002, 5.270647e-002, 5.268326e-002, 5.266006e-002, 5.263687e-002, 5.261369e-002, 5.259051e-002, 5.256734e-002, 5.254418e-002, 5.252102e-002, 5.249787e-002, 5.247472e-002, 5.245159e-002, 5.242846e-002, 
5.240533e-002, 5.238222e-002, 5.235911e-002, 5.233600e-002, 5.231291e-002, 5.228982e-002, 5.226674e-002, 5.224366e-002, 5.222059e-002, 5.219753e-002, 5.217447e-002, 5.215142e-002, 5.212838e-002, 5.210535e-002, 5.208232e-002, 5.205930e-002, 5.203628e-002, 5.201328e-002, 5.199027e-002, 5.196728e-002, 5.194429e-002, 5.192131e-002, 5.189834e-002, 5.187537e-002, 5.185241e-002, 5.182946e-002, 5.180651e-002, 5.178357e-002, 5.176064e-002, 5.173771e-002, 5.171479e-002, 5.169188e-002, 5.166897e-002, 5.164607e-002, 5.162318e-002, 5.160029e-002, 5.157741e-002, 5.155454e-002, 5.153167e-002, 5.150881e-002, 5.148596e-002, 5.146312e-002, 5.144028e-002, 5.141745e-002, 5.139462e-002, 5.137180e-002, 5.134899e-002, 5.132619e-002, 5.130339e-002, 5.128060e-002, 5.125781e-002, 5.123503e-002, 5.121226e-002, 5.118950e-002, 5.116674e-002, 5.114399e-002, 5.112125e-002, 5.109851e-002, 5.107578e-002, 5.105305e-002, 5.103034e-002, 5.100763e-002, 5.098492e-002, 5.096223e-002, 5.093954e-002, 5.091685e-002, 5.089418e-002, 5.087151e-002, 5.084884e-002, 5.082619e-002, 5.080354e-002, 5.078089e-002, 5.075826e-002, 5.073563e-002, 5.071300e-002, 5.069039e-002, 5.066778e-002, 5.064518e-002, 5.062258e-002, 5.059999e-002, 5.057741e-002, 5.055483e-002, 5.053226e-002, 5.050970e-002, 5.048714e-002, 5.046460e-002, 5.044205e-002, 5.041952e-002, 5.039699e-002, 5.037447e-002, 5.035195e-002, 5.032944e-002, 5.030694e-002, 5.028445e-002, 5.026196e-002, 5.023948e-002, 5.021700e-002, 5.019453e-002, 5.017207e-002, 5.014962e-002, 
5.012717e-002, 5.010473e-002, 5.008229e-002, 5.005986e-002, 5.003744e-002, 5.001503e-002, 4.999262e-002, 4.997022e-002, 4.994782e-002, 4.992543e-002, 4.990305e-002, 4.988068e-002, 4.985831e-002, 4.983595e-002, 4.981359e-002, 4.979124e-002, 4.976890e-002, 4.974657e-002, 4.972424e-002, 4.970192e-002, 4.967961e-002, 4.965730e-002, 4.963500e-002, 4.961270e-002, 4.959041e-002, 4.956813e-002, 4.954586e-002, 4.952359e-002, 4.950133e-002, 4.947907e-002, 4.945683e-002, 4.943459e-002, 4.941235e-002, 4.939012e-002, 4.936790e-002, 4.934569e-002, 4.932348e-002, 4.930128e-002, 4.927908e-002, 4.925690e-002, 4.923472e-002, 4.921254e-002, 4.919037e-002, 4.916821e-002, 4.914606e-002, 4.912391e-002, 4.910177e-002, 4.907963e-002, 4.905751e-002, 4.903539e-002, 4.901327e-002, 4.899116e-002, 4.896906e-002, 4.894697e-002, 4.892488e-002, 4.890280e-002, 4.888072e-002, 4.885865e-002, 4.883659e-002, 4.881454e-002, 4.879249e-002, 4.877045e-002, 4.874841e-002, 4.872639e-002, 4.870436e-002, 4.868235e-002, 4.866034e-002, 4.863834e-002, 4.861634e-002, 4.859436e-002, 4.857237e-002, 4.855040e-002, 4.852843e-002, 4.850647e-002, 4.848451e-002, 4.846257e-002, 4.844062e-002, 4.841869e-002, 4.839676e-002, 4.837484e-002, 4.835292e-002, 4.833101e-002, 4.830911e-002, 4.828721e-002, 4.826533e-002, 4.824344e-002, 4.822157e-002, 4.819970e-002, 4.817784e-002, 4.815598e-002, 4.813413e-002, 4.811229e-002, 4.809045e-002, 4.806862e-002, 4.804680e-002, 4.802498e-002, 4.800317e-002, 4.798137e-002, 4.795957e-002, 4.793778e-002, 
4.791600e-002, 4.789422e-002, 4.787245e-002, 4.785069e-002, 4.782893e-002, 4.780718e-002, 4.778544e-002, 4.776370e-002, 4.774197e-002, 4.772025e-002, 4.769853e-002, 4.767682e-002, 4.765511e-002, 4.763342e-002, 4.761173e-002, 4.759004e-002, 4.756836e-002, 4.754669e-002, 4.752503e-002, 4.750337e-002, 4.748172e-002, 4.746007e-002, 4.743844e-002, 4.741680e-002, 4.739518e-002, 4.737356e-002, 4.735195e-002, 4.733034e-002, 4.730874e-002, 4.728715e-002, 4.726557e-002, 4.724399e-002, 4.722241e-002, 4.720085e-002, 4.717929e-002, 4.715774e-002, 4.713619e-002, 4.711465e-002, 4.709312e-002, 4.707159e-002, 4.705007e-002, 4.702856e-002, 4.700705e-002, 4.698555e-002, 4.696405e-002, 4.694257e-002, 4.692109e-002, 4.689961e-002, 4.687814e-002, 4.685668e-002, 4.683523e-002, 4.681378e-002, 4.679234e-002, 4.677090e-002, 4.674948e-002, 4.672805e-002, 4.670664e-002, 4.668523e-002, 4.666383e-002, 4.664243e-002, 4.662104e-002, 4.659966e-002, 4.657829e-002, 4.655692e-002, 4.653555e-002, 4.651420e-002, 4.649285e-002, 4.647150e-002, 4.645017e-002, 4.642884e-002, 4.640751e-002, 4.638620e-002, 4.636488e-002, 4.634358e-002, 4.632228e-002, 4.630099e-002, 4.627971e-002, 4.625843e-002, 4.623716e-002, 4.621589e-002, 4.619463e-002, 4.617338e-002, 4.615214e-002, 4.613090e-002, 4.610967e-002, 4.608844e-002, 4.606722e-002, 4.604601e-002, 4.602480e-002, 4.600360e-002, 4.598241e-002, 4.596122e-002, 4.594004e-002, 4.591887e-002, 4.589770e-002, 4.587654e-002, 4.585539e-002, 4.583424e-002, 4.581310e-002, 4.579196e-002, 
4.577083e-002, 4.574971e-002, 4.572860e-002, 4.570749e-002, 4.568639e-002, 4.566529e-002, 4.564420e-002, 4.562312e-002, 4.560204e-002, 4.558097e-002, 4.555991e-002, 4.553885e-002, 4.551780e-002, 4.549676e-002, 4.547572e-002, 4.545469e-002, 4.543366e-002, 4.541265e-002, 4.539164e-002, 4.537063e-002, 4.534963e-002, 4.532864e-002, 4.530765e-002, 4.528668e-002, 4.526570e-002, 4.524474e-002, 4.522378e-002, 4.520282e-002, 4.518188e-002, 4.516094e-002, 4.514000e-002, 4.511908e-002, 4.509816e-002, 4.507724e-002, 4.505633e-002, 4.503543e-002, 4.501454e-002, 4.499365e-002, 4.497277e-002, 4.495189e-002, 4.493102e-002, 4.491016e-002, 4.488930e-002, 4.486845e-002, 4.484761e-002, 4.482677e-002, 4.480594e-002, 4.478512e-002, 4.476430e-002, 4.474349e-002, 4.472269e-002, 4.470189e-002, 4.468110e-002, 4.466031e-002, 4.463953e-002, 4.461876e-002, 4.459800e-002, 4.457724e-002, 4.455648e-002, 4.453574e-002, 4.451500e-002, 4.449426e-002, 4.447354e-002, 4.445282e-002, 4.443210e-002, 4.441139e-002, 4.439069e-002, 4.437000e-002, 4.434931e-002, 4.432863e-002, 4.430795e-002, 4.428728e-002, 4.426662e-002, 4.424596e-002, 4.422531e-002, 4.420467e-002, 4.418403e-002, 4.416340e-002, 4.414278e-002, 4.412216e-002, 4.410155e-002, 4.408094e-002, 4.406034e-002, 4.403975e-002, 4.401917e-002, 4.399859e-002, 4.397801e-002, 4.395745e-002, 4.393689e-002, 4.391633e-002, 4.389579e-002, 4.387525e-002, 4.385471e-002, 4.383418e-002, 4.381366e-002, 4.379315e-002, 4.377264e-002, 4.375214e-002, 4.373164e-002, 4.371115e-002, 
4.369067e-002, 4.367019e-002, 4.364972e-002, 4.362926e-002, 4.360880e-002, 4.358835e-002, 4.356790e-002, 4.354746e-002, 4.352703e-002, 4.350661e-002, 4.348619e-002, 4.346577e-002, 4.344537e-002, 4.342497e-002, 4.340457e-002, 4.338419e-002, 4.336381e-002, 4.334343e-002, 4.332306e-002, 4.330270e-002, 4.328235e-002, 4.326200e-002, 4.324165e-002, 4.322132e-002, 4.320099e-002, 4.318066e-002, 4.316035e-002, 4.314004e-002, 4.311973e-002, 4.309943e-002, 4.307914e-002, 4.305886e-002, 4.303858e-002, 4.301831e-002, 4.299804e-002, 4.297778e-002, 4.295753e-002, 4.293728e-002, 4.291704e-002, 4.289680e-002, 4.287658e-002, 4.285635e-002, 4.283614e-002, 4.281593e-002, 4.279573e-002, 4.277553e-002, 4.275534e-002, 4.273516e-002, 4.271498e-002, 4.269481e-002, 4.267465e-002, 4.265449e-002, 4.263434e-002, 4.261419e-002, 4.259405e-002, 4.257392e-002, 4.255379e-002, 4.253367e-002, 4.251356e-002, 4.249345e-002, 4.247335e-002, 4.245326e-002, 4.243317e-002, 4.241309e-002, 4.239301e-002, 4.237294e-002, 4.235288e-002, 4.233282e-002, 4.231277e-002, 4.229273e-002, 4.227269e-002, 4.225266e-002, 4.223263e-002, 4.221261e-002, 4.219260e-002, 4.217260e-002, 4.215260e-002, 4.213260e-002, 4.211262e-002, 4.209264e-002, 4.207266e-002, 4.205269e-002, 4.203273e-002, 4.201278e-002, 4.199283e-002, 4.197288e-002, 4.195295e-002, 4.193302e-002, 4.191309e-002, 4.189318e-002, 4.187327e-002, 4.185336e-002, 4.183346e-002, 4.181357e-002, 4.179368e-002, 4.177380e-002, 4.175393e-002, 4.173406e-002, 4.171420e-002, 4.169435e-002, 
4.167450e-002, 4.165466e-002, 4.163482e-002, 4.161499e-002, 4.159517e-002, 4.157535e-002, 4.155554e-002, 4.153574e-002, 4.151594e-002, 4.149615e-002, 4.147636e-002, 4.145659e-002, 4.143681e-002, 4.141705e-002, 4.139729e-002, 4.137753e-002, 4.135779e-002, 4.133804e-002, 4.131831e-002, 4.129858e-002, 4.127886e-002, 4.125914e-002, 4.123943e-002, 4.121973e-002, 4.120003e-002, 4.118034e-002, 4.116066e-002, 4.114098e-002, 4.112131e-002, 4.110164e-002, 4.108198e-002, 4.106233e-002, 4.104268e-002, 4.102304e-002, 4.100340e-002, 4.098378e-002, 4.096415e-002, 4.094454e-002, 4.092493e-002, 4.090533e-002, 4.088573e-002, 4.086614e-002, 4.084655e-002, 4.082698e-002, 4.080740e-002, 4.078784e-002, 4.076828e-002, 4.074873e-002, 4.072918e-002, 4.070964e-002, 4.069010e-002, 4.067058e-002, 4.065105e-002, 4.063154e-002, 4.061203e-002, 4.059253e-002, 4.057303e-002, 4.055354e-002, 4.053405e-002, 4.051458e-002, 4.049510e-002, 4.047564e-002, 4.045618e-002, 4.043673e-002, 4.041728e-002, 4.039784e-002, 4.037840e-002, 4.035898e-002, 4.033955e-002, 4.032014e-002, 4.030073e-002, 4.028132e-002, 4.026193e-002, 4.024254e-002, 4.022315e-002, 4.020377e-002, 4.018440e-002, 4.016504e-002, 4.014568e-002, 4.012632e-002, 4.010697e-002, 4.008763e-002, 4.006830e-002, 4.004897e-002, 4.002965e-002, 4.001033e-002, 3.999102e-002, 3.997172e-002, 3.995242e-002, 3.993313e-002, 3.991384e-002, 3.989456e-002, 3.987529e-002, 3.985603e-002, 3.983676e-002, 3.981751e-002, 3.979826e-002, 3.977902e-002, 3.975979e-002, 3.974056e-002, 
3.972133e-002, 3.970212e-002, 3.968291e-002, 3.966370e-002, 3.964450e-002, 3.962531e-002, 3.960612e-002, 3.958695e-002, 3.956777e-002, 3.954860e-002, 3.952944e-002, 3.951029e-002, 3.949114e-002, 3.947200e-002, 3.945286e-002, 3.943373e-002, 3.941461e-002, 3.939549e-002, 3.937638e-002, 3.935727e-002, 3.933817e-002, 3.931908e-002, 3.929999e-002, 3.928091e-002, 3.926184e-002, 3.924277e-002, 3.922371e-002, 3.920465e-002, 3.918560e-002, 3.916656e-002, 3.914752e-002, 3.912849e-002, 3.910946e-002, 3.909044e-002, 3.907143e-002, 3.905242e-002, 3.903342e-002, 3.901443e-002, 3.899544e-002, 3.897646e-002, 3.895748e-002, 3.893851e-002, 3.891955e-002, 3.890059e-002, 3.888164e-002, 3.886270e-002, 3.884376e-002, 3.882482e-002, 3.880590e-002, 3.878698e-002, 3.876806e-002, 3.874915e-002, 3.873025e-002, 3.871136e-002, 3.869247e-002, 3.867358e-002, 3.865471e-002, 3.863583e-002, 3.861697e-002, 3.859811e-002, 3.857926e-002, 3.856041e-002, 3.854157e-002, 3.852274e-002, 3.850391e-002, 3.848509e-002, 3.846627e-002, 3.844746e-002, 3.842866e-002, 3.840986e-002, 3.839107e-002, 3.837228e-002, 3.835350e-002, 3.833473e-002, 3.831596e-002, 3.829720e-002, 3.827845e-002, 3.825970e-002, 3.824095e-002, 3.822222e-002, 3.820349e-002, 3.818476e-002, 3.816605e-002, 3.814733e-002, 3.812863e-002, 3.810993e-002, 3.809123e-002, 3.807255e-002, 3.805387e-002, 3.803519e-002, 3.801652e-002, 3.799786e-002, 3.797920e-002, 3.796055e-002, 3.794191e-002, 3.792327e-002, 3.790464e-002, 3.788601e-002, 3.786739e-002, 3.784877e-002, 
3.783017e-002, 3.781156e-002, 3.779297e-002, 3.777438e-002, 3.775580e-002, 3.773722e-002, 3.771865e-002, 3.770008e-002, 3.768152e-002, 3.766297e-002, 3.764442e-002, 3.762588e-002, 3.760735e-002, 3.758882e-002, 3.757029e-002, 3.755178e-002, 3.753327e-002, 3.751476e-002, 3.749626e-002, 3.747777e-002, 3.745929e-002, 3.744081e-002, 3.742233e-002, 3.740386e-002, 3.738540e-002, 3.736695e-002, 3.734850e-002, 3.733005e-002, 3.731161e-002, 3.729318e-002, 3.727476e-002, 3.725634e-002, 3.723792e-002, 3.721952e-002, 3.720112e-002, 3.718272e-002, 3.716433e-002, 3.714595e-002, 3.712757e-002, 3.710920e-002, 3.709084e-002, 3.707248e-002, 3.705412e-002, 3.703578e-002, 3.701744e-002, 3.699910e-002, 3.698077e-002, 3.696245e-002, 3.694414e-002, 3.692583e-002, 3.690752e-002, 3.688922e-002, 3.687093e-002, 3.685264e-002, 3.683436e-002, 3.681609e-002, 3.679782e-002, 3.677956e-002, 3.676130e-002, 3.674305e-002, 3.672481e-002, 3.670657e-002, 3.668834e-002, 3.667012e-002, 3.665190e-002, 3.663368e-002, 3.661547e-002, 3.659727e-002, 3.657908e-002, 3.656089e-002, 3.654270e-002, 3.652453e-002, 3.650636e-002, 3.648819e-002, 3.647003e-002, 3.645188e-002, 3.643373e-002, 3.641559e-002, 3.639745e-002, 3.637932e-002, 3.636120e-002, 3.634308e-002, 3.632497e-002, 3.630687e-002, 3.628877e-002, 3.627068e-002, 3.625259e-002, 3.623451e-002, 3.621643e-002, 3.619836e-002, 3.618030e-002, 3.616224e-002, 3.614419e-002, 3.612615e-002, 3.610811e-002, 3.609008e-002, 3.607205e-002, 3.605403e-002, 3.603601e-002, 3.601800e-002, 
3.600000e-002, 3.598200e-002, 3.596401e-002, 3.594603e-002, 3.592805e-002, 3.591007e-002, 3.589211e-002, 3.587415e-002, 3.585619e-002, 3.583824e-002, 3.582030e-002, 3.580236e-002, 3.578443e-002, 3.576651e-002, 3.574859e-002, 3.573067e-002, 3.571277e-002, 3.569487e-002, 3.567697e-002, 3.565908e-002, 3.564120e-002, 3.562332e-002, 3.560545e-002, 3.558758e-002, 3.556973e-002, 3.555187e-002, 3.553403e-002, 3.551618e-002, 3.549835e-002, 3.548052e-002, 3.546270e-002, 3.544488e-002, 3.542707e-002, 3.540926e-002, 3.539146e-002, 3.537367e-002, 3.535588e-002, 3.533810e-002, 3.532032e-002, 3.530255e-002, 3.528479e-002, 3.526703e-002, 3.524928e-002, 3.523153e-002, 3.521379e-002, 3.519606e-002, 3.517833e-002, 3.516061e-002, 3.514289e-002, 3.512518e-002, 3.510748e-002, 3.508978e-002, 3.507209e-002, 3.505440e-002, 3.503672e-002, 3.501905e-002, 3.500138e-002, 3.498372e-002, 3.496606e-002, 3.494841e-002, 3.493076e-002, 3.491313e-002, 3.489549e-002, 3.487787e-002, 3.486024e-002, 3.484263e-002, 3.482502e-002, 3.480742e-002, 3.478982e-002, 3.477223e-002, 3.475464e-002, 3.473706e-002, 3.471949e-002, 3.470192e-002, 3.468436e-002, 3.466680e-002, 3.464925e-002, 3.463171e-002, 3.461417e-002, 3.459664e-002, 3.457911e-002, 3.456159e-002, 3.454408e-002, 3.452657e-002, 3.450907e-002, 3.449157e-002, 3.447408e-002, 3.445660e-002, 3.443912e-002, 3.442165e-002, 3.440418e-002, 3.438672e-002, 3.436926e-002, 3.435181e-002, 3.433437e-002, 3.431693e-002, 3.429950e-002, 3.428207e-002, 3.426466e-002, 3.424724e-002, 
3.422983e-002, 3.421243e-002, 3.419504e-002, 3.417764e-002, 3.416026e-002, 3.414288e-002, 3.412551e-002, 3.410814e-002, 3.409078e-002, 3.407343e-002, 3.405608e-002, 3.403874e-002, 3.402140e-002, 3.400407e-002, 3.398674e-002, 3.396942e-002, 3.395211e-002, 3.393480e-002, 3.391750e-002, 3.390020e-002, 3.388291e-002, 3.386563e-002, 3.384835e-002, 3.383108e-002, 3.381381e-002, 3.379655e-002, 3.377929e-002, 3.376205e-002, 3.374480e-002, 3.372757e-002, 3.371033e-002, 3.369311e-002, 3.367589e-002, 3.365867e-002, 3.364147e-002, 3.362426e-002, 3.360707e-002, 3.358988e-002, 3.357269e-002, 3.355552e-002, 3.353834e-002, 3.352118e-002, 3.350401e-002, 3.348686e-002, 3.346971e-002, 3.345257e-002, 3.343543e-002, 3.341830e-002, 3.340117e-002, 3.338405e-002, 3.336694e-002, 3.334983e-002, 3.333273e-002, 3.331563e-002, 3.329854e-002, 3.328145e-002, 3.326438e-002, 3.324730e-002, 3.323023e-002, 3.321317e-002, 3.319612e-002, 3.317907e-002, 3.316202e-002, 3.314499e-002, 3.312795e-002, 3.311093e-002, 3.309391e-002, 3.307689e-002, 3.305988e-002, 3.304288e-002, 3.302588e-002, 3.300889e-002, 3.299190e-002, 3.297492e-002, 3.295795e-002, 3.294098e-002, 3.292402e-002, 3.290706e-002, 3.289011e-002, 3.287317e-002, 3.285623e-002, 3.283929e-002, 3.282237e-002, 3.280545e-002, 3.278853e-002, 3.277162e-002, 3.275472e-002, 3.273782e-002, 3.272092e-002, 3.270404e-002, 3.268716e-002, 3.267028e-002, 3.265341e-002, 3.263655e-002, 3.261969e-002, 3.260284e-002, 3.258599e-002, 3.256915e-002, 3.255232e-002, 3.253549e-002, 
3.251867e-002, 3.250185e-002, 3.248504e-002, 3.246823e-002, 3.245143e-002, 3.243464e-002, 3.241785e-002, 3.240107e-002, 3.238429e-002, 3.236752e-002, 3.235076e-002, 3.233400e-002, 3.231724e-002, 3.230050e-002, 3.228375e-002, 3.226702e-002, 3.225029e-002, 3.223356e-002, 3.221685e-002, 3.220013e-002, 3.218343e-002, 3.216672e-002, 3.215003e-002, 3.213334e-002, 3.211665e-002, 3.209998e-002, 3.208330e-002, 3.206664e-002, 3.204998e-002, 3.203332e-002, 3.201667e-002, 3.200003e-002, 3.198339e-002, 3.196676e-002, 3.195013e-002, 3.193351e-002, 3.191690e-002, 3.190029e-002, 3.188369e-002, 3.186709e-002, 3.185050e-002, 3.183391e-002, 3.181733e-002, 3.180076e-002, 3.178419e-002, 3.176762e-002, 3.175107e-002, 3.173452e-002, 3.171797e-002, 3.170143e-002, 3.168490e-002, 3.166837e-002, 3.165184e-002, 3.163533e-002, 3.161882e-002, 3.160231e-002, 3.158581e-002, 3.156932e-002, 3.155283e-002, 3.153635e-002, 3.151987e-002, 3.150340e-002, 3.148693e-002, 3.147048e-002, 3.145402e-002, 3.143757e-002, 3.142113e-002, 3.140469e-002, 3.138826e-002, 3.137184e-002, 3.135542e-002, 3.133901e-002, 3.132260e-002, 3.130620e-002, 3.128980e-002, 3.127341e-002, 3.125702e-002, 3.124064e-002, 3.122427e-002, 3.120790e-002, 3.119154e-002, 3.117518e-002, 3.115883e-002, 3.114249e-002, 3.112615e-002, 3.110982e-002, 3.109349e-002, 3.107717e-002, 3.106085e-002, 3.104454e-002, 3.102824e-002, 3.101194e-002, 3.099564e-002, 3.097935e-002, 3.096307e-002, 3.094680e-002, 3.093053e-002, 3.091426e-002, 3.089800e-002, 3.088175e-002, 
3.086550e-002, 3.084926e-002, 3.083302e-002, 3.081679e-002, 3.080057e-002, 3.078435e-002, 3.076813e-002, 3.075192e-002, 3.073572e-002, 3.071953e-002, 3.070333e-002, 3.068715e-002, 3.067097e-002, 3.065480e-002, 3.063863e-002, 3.062247e-002, 3.060631e-002, 3.059016e-002, 3.057401e-002, 3.055787e-002, 3.054174e-002, 3.052561e-002, 3.050949e-002, 3.049337e-002, 3.047726e-002, 3.046115e-002, 3.044505e-002, 3.042896e-002, 3.041287e-002, 3.039679e-002, 3.038071e-002, 3.036464e-002, 3.034857e-002, 3.033251e-002, 3.031646e-002, 3.030041e-002, 3.028437e-002, 3.026833e-002, 3.025230e-002, 3.023627e-002, 3.022025e-002, 3.020423e-002, 3.018823e-002, 3.017222e-002, 3.015622e-002, 3.014023e-002, 3.012424e-002, 3.010826e-002, 3.009229e-002, 3.007632e-002, 3.006035e-002, 3.004440e-002, 3.002844e-002, 3.001250e-002, 2.999655e-002, 2.998062e-002, 2.996469e-002, 2.994876e-002, 2.993284e-002, 2.991693e-002, 2.990102e-002, 2.988512e-002, 2.986923e-002, 2.985333e-002, 2.983745e-002, 2.982157e-002, 2.980570e-002, 2.978983e-002, 2.977397e-002, 2.975811e-002, 2.974226e-002, 2.972641e-002, 2.971057e-002, 2.969474e-002, 2.967891e-002, 2.966309e-002, 2.964727e-002, 2.963146e-002, 2.961565e-002, 2.959985e-002, 2.958405e-002, 2.956827e-002, 2.955248e-002, 2.953670e-002, 2.952093e-002, 2.950516e-002, 2.948940e-002, 2.947365e-002, 2.945790e-002, 2.944215e-002, 2.942641e-002, 2.941068e-002, 2.939495e-002, 2.937923e-002, 2.936351e-002, 2.934780e-002, 2.933210e-002, 2.931640e-002, 2.930070e-002, 2.928502e-002, 
2.926933e-002, 2.925366e-002, 2.923798e-002, 2.922232e-002, 2.920666e-002, 2.919100e-002, 2.917535e-002, 2.915971e-002, 2.914407e-002, 2.912844e-002, 2.911281e-002, 2.909719e-002, 2.908158e-002, 2.906597e-002, 2.905036e-002, 2.903476e-002, 2.901917e-002, 2.900358e-002, 2.898800e-002, 2.897242e-002, 2.895685e-002, 2.894129e-002, 2.892573e-002, 2.891017e-002, 2.889462e-002, 2.887908e-002, 2.886354e-002, 2.884801e-002, 2.883248e-002, 2.881696e-002, 2.880145e-002, 2.878594e-002, 2.877044e-002, 2.875494e-002, 2.873944e-002, 2.872396e-002, 2.870847e-002, 2.869300e-002, 2.867753e-002, 2.866206e-002, 2.864660e-002, 2.863115e-002, 2.861570e-002, 2.860026e-002, 2.858482e-002, 2.856939e-002, 2.855396e-002, 2.853854e-002, 2.852313e-002, 2.850772e-002, 2.849231e-002, 2.847691e-002, 2.846152e-002, 2.844613e-002, 2.843075e-002, 2.841538e-002, 2.840000e-002, 2.838464e-002, 2.836928e-002, 2.835393e-002, 2.833858e-002, 2.832323e-002, 2.830790e-002, 2.829256e-002, 2.827724e-002, 2.826192e-002, 2.824660e-002, 2.823129e-002, 2.821599e-002, 2.820069e-002, 2.818540e-002, 2.817011e-002, 2.815483e-002, 2.813955e-002, 2.812428e-002, 2.810901e-002, 2.809375e-002, 2.807850e-002, 2.806325e-002, 2.804801e-002, 2.803277e-002, 2.801754e-002, 2.800231e-002, 2.798709e-002, 2.797187e-002, 2.795666e-002, 2.794146e-002, 2.792626e-002, 2.791106e-002, 2.789587e-002, 2.788069e-002, 2.786551e-002, 2.785034e-002, 2.783518e-002, 2.782002e-002, 2.780486e-002, 2.778971e-002, 2.777457e-002, 2.775943e-002, 2.774429e-002, 
2.772917e-002, 2.771404e-002, 2.769893e-002, 2.768382e-002, 2.766871e-002, 2.765361e-002, 2.763852e-002, 2.762343e-002, 2.760834e-002, 2.759326e-002, 2.757819e-002, 2.756312e-002, 2.754806e-002, 2.753301e-002, 2.751796e-002, 2.750291e-002, 2.748787e-002, 2.747284e-002, 2.745781e-002, 2.744278e-002, 2.742777e-002, 2.741275e-002, 2.739775e-002, 2.738274e-002, 2.736775e-002, 2.735276e-002, 2.733777e-002, 2.732279e-002, 2.730782e-002, 2.729285e-002, 2.727789e-002, 2.726293e-002, 2.724798e-002, 2.723303e-002, 2.721809e-002, 2.720315e-002, 2.718822e-002, 2.717330e-002, 2.715838e-002, 2.714346e-002, 2.712856e-002, 2.711365e-002, 2.709876e-002, 2.708386e-002, 2.706898e-002, 2.705410e-002, 2.703922e-002, 2.702435e-002, 2.700948e-002, 2.699462e-002, 2.697977e-002, 2.696492e-002, 2.695008e-002, 2.693524e-002, 2.692041e-002, 2.690558e-002, 2.689076e-002, 2.687595e-002, 2.686114e-002, 2.684633e-002, 2.683153e-002, 2.681674e-002, 2.680195e-002, 2.678716e-002, 2.677239e-002, 2.675761e-002, 2.674285e-002, 2.672809e-002, 2.671333e-002, 2.669858e-002, 2.668383e-002, 2.666909e-002, 2.665436e-002, 2.663963e-002, 2.662491e-002, 2.661019e-002, 2.659548e-002, 2.658077e-002, 2.656607e-002, 2.655137e-002, 2.653668e-002, 2.652200e-002, 2.650732e-002, 2.649264e-002, 2.647797e-002, 2.646331e-002, 2.644865e-002, 2.643400e-002, 2.641935e-002, 2.640471e-002, 2.639007e-002, 2.637544e-002, 2.636081e-002, 2.634619e-002, 2.633158e-002, 2.631697e-002, 2.630236e-002, 2.628776e-002, 2.627317e-002, 2.625858e-002, 
2.624400e-002, 2.622942e-002, 2.621485e-002, 2.620028e-002, 2.618572e-002, 2.617117e-002, 2.615662e-002, 2.614207e-002, 2.612753e-002, 2.611300e-002, 2.609847e-002, 2.608395e-002, 2.606943e-002, 2.605492e-002, 2.604041e-002, 2.602591e-002, 2.601141e-002, 2.599692e-002, 2.598243e-002, 2.596795e-002, 2.595348e-002, 2.593901e-002, 2.592455e-002, 2.591009e-002, 2.589563e-002, 2.588118e-002, 2.586674e-002, 2.585231e-002, 2.583787e-002, 2.582345e-002, 2.580903e-002, 2.579461e-002, 2.578020e-002, 2.576579e-002, 2.575139e-002, 2.573700e-002, 2.572261e-002, 2.570823e-002, 2.569385e-002, 2.567948e-002, 2.566511e-002, 2.565075e-002, 2.563639e-002, 2.562204e-002, 2.560769e-002, 2.559335e-002, 2.557902e-002, 2.556469e-002, 2.555036e-002, 2.553604e-002, 2.552173e-002, 2.550742e-002, 2.549312e-002, 2.547882e-002, 2.546453e-002, 2.545024e-002, 2.543596e-002, 2.542168e-002, 2.540741e-002, 2.539314e-002, 2.537888e-002, 2.536463e-002, 2.535038e-002, 2.533613e-002, 2.532190e-002, 2.530766e-002, 2.529343e-002, 2.527921e-002, 2.526499e-002, 2.525078e-002, 2.523657e-002, 2.522237e-002, 2.520817e-002, 2.519398e-002, 2.517980e-002, 2.516562e-002, 2.515144e-002, 2.513727e-002, 2.512311e-002, 2.510895e-002, 2.509479e-002, 2.508065e-002, 2.506650e-002, 2.505237e-002, 2.503823e-002, 2.502411e-002, 2.500998e-002, 2.499587e-002, 2.498176e-002, 2.496765e-002, 2.495355e-002, 2.493945e-002, 2.492536e-002, 2.491128e-002, 2.489720e-002, 2.488312e-002, 2.486906e-002, 2.485499e-002, 2.484093e-002, 2.482688e-002, 
2.481283e-002, 2.479879e-002, 2.478475e-002, 2.477072e-002, 2.475670e-002, 2.474267e-002, 2.472866e-002, 2.471465e-002, 2.470064e-002, 2.468664e-002, 2.467265e-002, 2.465866e-002, 2.464467e-002, 2.463070e-002, 2.461672e-002, 2.460275e-002, 2.458879e-002, 2.457483e-002, 2.456088e-002, 2.454693e-002, 2.453299e-002, 2.451906e-002, 2.450512e-002, 2.449120e-002, 2.447728e-002, 2.446336e-002, 2.444945e-002, 2.443555e-002, 2.442165e-002, 2.440775e-002, 2.439386e-002, 2.437998e-002, 2.436610e-002, 2.435223e-002, 2.433836e-002, 2.432450e-002, 2.431064e-002, 2.429679e-002, 2.428294e-002, 2.426910e-002, 2.425526e-002, 2.424143e-002, 2.422761e-002, 2.421378e-002, 2.419997e-002, 2.418616e-002, 2.417235e-002, 2.415855e-002, 2.414476e-002, 2.413097e-002, 2.411719e-002, 2.410341e-002, 2.408964e-002, 2.407587e-002, 2.406210e-002, 2.404835e-002, 2.403459e-002, 2.402085e-002, 2.400711e-002, 2.399337e-002, 2.397964e-002, 2.396591e-002, 2.395219e-002, 2.393847e-002, 2.392476e-002, 2.391106e-002, 2.389736e-002, 2.388366e-002, 2.386997e-002, 2.385629e-002, 2.384261e-002, 2.382894e-002, 2.381527e-002, 2.380161e-002, 2.378795e-002, 2.377429e-002, 2.376065e-002, 2.374700e-002, 2.373337e-002, 2.371973e-002, 2.370611e-002, 2.369249e-002, 2.367887e-002, 2.366526e-002, 2.365165e-002, 2.363805e-002, 2.362446e-002, 2.361087e-002, 2.359728e-002, 2.358370e-002, 2.357013e-002, 2.355656e-002, 2.354299e-002, 2.352943e-002, 2.351588e-002, 2.350233e-002, 2.348879e-002, 2.347525e-002, 2.346172e-002, 2.344819e-002, 
2.343467e-002, 2.342115e-002, 2.340764e-002, 2.339413e-002, 2.338063e-002, 2.336713e-002, 2.335364e-002, 2.334015e-002, 2.332667e-002, 2.331320e-002, 2.329973e-002, 2.328626e-002, 2.327280e-002, 2.325935e-002, 2.324590e-002, 2.323245e-002, 2.321901e-002, 2.320558e-002, 2.319215e-002, 2.317872e-002, 2.316531e-002, 2.315189e-002, 2.313848e-002, 2.312508e-002, 2.311168e-002, 2.309829e-002, 2.308490e-002, 2.307152e-002, 2.305814e-002, 2.304477e-002, 2.303140e-002, 2.301804e-002, 2.300468e-002, 2.299133e-002, 2.297799e-002, 2.296464e-002, 2.295131e-002, 2.293798e-002, 2.292465e-002, 2.291133e-002, 2.289802e-002, 2.288471e-002, 2.287140e-002, 2.285810e-002, 2.284481e-002, 2.283152e-002, 2.281823e-002, 2.280495e-002, 2.279168e-002, 2.277841e-002, 2.276515e-002, 2.275189e-002, 2.273863e-002, 2.272539e-002, 2.271214e-002, 2.269890e-002, 2.268567e-002, 2.267244e-002, 2.265922e-002, 2.264600e-002, 2.263279e-002, 2.261958e-002, 2.260638e-002, 2.259318e-002, 2.257999e-002, 2.256681e-002, 2.255362e-002, 2.254045e-002, 2.252728e-002, 2.251411e-002, 2.250095e-002, 2.248779e-002, 2.247464e-002, 2.246150e-002, 2.244836e-002, 2.243522e-002, 2.242209e-002, 2.240897e-002, 2.239585e-002, 2.238273e-002, 2.236962e-002, 2.235652e-002, 2.234342e-002, 2.233032e-002, 2.231723e-002, 2.230415e-002, 2.229107e-002, 2.227800e-002, 2.226493e-002, 2.225186e-002, 2.223881e-002, 2.222575e-002, 2.221270e-002, 2.219966e-002, 2.218662e-002, 2.217359e-002, 2.216056e-002, 2.214754e-002, 2.213452e-002, 2.212151e-002, 
2.210850e-002, 2.209550e-002, 2.208250e-002, 2.206951e-002, 2.205652e-002, 2.204354e-002, 2.203056e-002, 2.201759e-002, 2.200462e-002, 2.199166e-002, 2.197870e-002, 2.196575e-002, 2.195281e-002, 2.193987e-002, 2.192693e-002, 2.191400e-002, 2.190107e-002, 2.188815e-002, 2.187524e-002, 2.186232e-002, 2.184942e-002, 2.183652e-002, 2.182362e-002, 2.181073e-002, 2.179785e-002, 2.178497e-002, 2.177209e-002, 2.175922e-002, 2.174636e-002, 2.173350e-002, 2.172064e-002, 2.170779e-002, 2.169495e-002, 2.168211e-002, 2.166927e-002, 2.165644e-002, 2.164362e-002, 2.163080e-002, 2.161798e-002, 2.160517e-002, 2.159237e-002, 2.157957e-002, 2.156678e-002, 2.155399e-002, 2.154120e-002, 2.152842e-002, 2.151565e-002, 2.150288e-002, 2.149012e-002, 2.147736e-002, 2.146460e-002, 2.145186e-002, 2.143911e-002, 2.142637e-002, 2.141364e-002, 2.140091e-002, 2.138819e-002, 2.137547e-002, 2.136276e-002, 2.135005e-002, 2.133734e-002, 2.132465e-002, 2.131195e-002, 2.129926e-002, 2.128658e-002, 2.127390e-002, 2.126123e-002, 2.124856e-002, 2.123590e-002, 2.122324e-002, 2.121059e-002, 2.119794e-002, 2.118530e-002, 2.117266e-002, 2.116003e-002, 2.114740e-002, 2.113478e-002, 2.112216e-002, 2.110955e-002, 2.109694e-002, 2.108433e-002, 2.107174e-002, 2.105914e-002, 2.104656e-002, 2.103397e-002, 2.102140e-002, 2.100882e-002, 2.099626e-002, 2.098369e-002, 2.097114e-002, 2.095858e-002, 2.094604e-002, 2.093349e-002, 2.092096e-002, 2.090842e-002, 2.089590e-002, 2.088337e-002, 2.087086e-002, 2.085834e-002, 2.084584e-002, 
2.083333e-002, 2.082084e-002, 2.080834e-002, 2.079586e-002, 2.078337e-002, 2.077090e-002, 2.075842e-002, 2.074596e-002, 2.073349e-002, 2.072104e-002, 2.070858e-002, 2.069614e-002, 2.068369e-002, 2.067126e-002, 2.065882e-002, 2.064640e-002, 2.063397e-002, 2.062156e-002, 2.060914e-002, 2.059673e-002, 2.058433e-002, 2.057193e-002, 2.055954e-002, 2.054715e-002, 2.053477e-002, 2.052239e-002, 2.051002e-002, 2.049765e-002, 2.048529e-002, 2.047293e-002, 2.046058e-002, 2.044823e-002, 2.043589e-002, 2.042355e-002, 2.041122e-002, 2.039889e-002, 2.038657e-002, 2.037425e-002, 2.036193e-002, 2.034963e-002, 2.033732e-002, 2.032502e-002, 2.031273e-002, 2.030044e-002, 2.028816e-002, 2.027588e-002, 2.026361e-002, 2.025134e-002, 2.023907e-002, 2.022682e-002, 2.021456e-002, 2.020231e-002, 2.019007e-002, 2.017783e-002, 2.016560e-002, 2.015337e-002, 2.014114e-002, 2.012892e-002, 2.011671e-002, 2.010450e-002, 2.009230e-002, 2.008010e-002, 2.006790e-002, 2.005571e-002, 2.004353e-002, 2.003135e-002, 2.001918e-002, 2.000701e-002, 1.999484e-002, 1.998268e-002, 1.997053e-002, 1.995838e-002, 1.994623e-002, 1.993409e-002, 1.992196e-002, 1.990983e-002, 1.989770e-002, 1.988558e-002, 1.987346e-002, 1.986135e-002, 1.984925e-002, 1.983715e-002, 1.982505e-002, 1.981296e-002, 1.980087e-002, 1.978879e-002, 1.977672e-002, 1.976465e-002, 1.975258e-002, 1.974052e-002, 1.972846e-002, 1.971641e-002, 1.970436e-002, 1.969232e-002, 1.968028e-002, 1.966825e-002, 1.965623e-002, 1.964420e-002, 1.963219e-002, 1.962017e-002, 
1.960817e-002, 1.959616e-002, 1.958417e-002, 1.957217e-002, 1.956019e-002, 1.954820e-002, 1.953622e-002, 1.952425e-002, 1.951228e-002, 1.950032e-002, 1.948836e-002, 1.947641e-002, 1.946446e-002, 1.945252e-002, 1.944058e-002, 1.942864e-002, 1.941671e-002, 1.940479e-002, 1.939287e-002, 1.938095e-002, 1.936905e-002, 1.935714e-002, 1.934524e-002, 1.933335e-002, 1.932146e-002, 1.930957e-002, 1.929769e-002, 1.928581e-002, 1.927394e-002, 1.926208e-002, 1.925022e-002, 1.923836e-002, 1.922651e-002, 1.921466e-002, 1.920282e-002, 1.919099e-002, 1.917915e-002, 1.916733e-002, 1.915551e-002, 1.914369e-002, 1.913188e-002, 1.912007e-002, 1.910827e-002, 1.909647e-002, 1.908468e-002, 1.907289e-002, 1.906110e-002, 1.904933e-002, 1.903755e-002, 1.902578e-002, 1.901402e-002, 1.900226e-002, 1.899051e-002, 1.897876e-002, 1.896701e-002, 1.895528e-002, 1.894354e-002, 1.893181e-002, 1.892009e-002, 1.890837e-002, 1.889665e-002, 1.888494e-002, 1.887323e-002, 1.886153e-002, 1.884984e-002, 1.883815e-002, 1.882646e-002, 1.881478e-002, 1.880310e-002, 1.879143e-002, 1.877976e-002, 1.876810e-002, 1.875645e-002, 1.874479e-002, 1.873315e-002, 1.872150e-002, 1.870986e-002, 1.869823e-002, 1.868660e-002, 1.867498e-002, 1.866336e-002, 1.865175e-002, 1.864014e-002, 1.862853e-002, 1.861694e-002, 1.860534e-002, 1.859375e-002, 1.858217e-002, 1.857059e-002, 1.855901e-002, 1.854744e-002, 1.853587e-002, 1.852431e-002, 1.851276e-002, 1.850121e-002, 1.848966e-002, 1.847812e-002, 1.846658e-002, 1.845505e-002, 1.844352e-002, 
1.843200e-002, 1.842048e-002, 1.840897e-002, 1.839746e-002, 1.838596e-002, 1.837446e-002, 1.836297e-002, 1.835148e-002, 1.833999e-002, 1.832851e-002, 1.831704e-002, 1.830557e-002, 1.829411e-002, 1.828265e-002, 1.827119e-002, 1.825974e-002, 1.824829e-002, 1.823685e-002, 1.822542e-002, 1.821399e-002, 1.820256e-002, 1.819114e-002, 1.817972e-002, 1.816831e-002, 1.815690e-002, 1.814550e-002, 1.813410e-002, 1.812271e-002, 1.811132e-002, 1.809993e-002, 1.808856e-002, 1.807718e-002, 1.806581e-002, 1.805445e-002, 1.804309e-002, 1.803173e-002, 1.802038e-002, 1.800904e-002, 1.799770e-002, 1.798636e-002, 1.797503e-002, 1.796370e-002, 1.795238e-002, 1.794106e-002, 1.792975e-002, 1.791844e-002, 1.790714e-002, 1.789584e-002, 1.788455e-002, 1.787326e-002, 1.786198e-002, 1.785070e-002, 1.783943e-002, 1.782816e-002, 1.781689e-002, 1.780563e-002, 1.779438e-002, 1.778313e-002, 1.777188e-002, 1.776064e-002, 1.774940e-002, 1.773817e-002, 1.772695e-002, 1.771572e-002, 1.770451e-002, 1.769329e-002, 1.768209e-002, 1.767088e-002, 1.765969e-002, 1.764849e-002, 1.763730e-002, 1.762612e-002, 1.761494e-002, 1.760376e-002, 1.759259e-002, 1.758143e-002, 1.757027e-002, 1.755911e-002, 1.754796e-002, 1.753682e-002, 1.752567e-002, 1.751454e-002, 1.750341e-002, 1.749228e-002, 1.748116e-002, 1.747004e-002, 1.745892e-002, 1.744782e-002, 1.743671e-002, 1.742561e-002, 1.741452e-002, 1.740343e-002, 1.739234e-002, 1.738126e-002, 1.737019e-002, 1.735912e-002, 1.734805e-002, 1.733699e-002, 1.732593e-002, 1.731488e-002, 
1.730383e-002, 1.729279e-002, 1.728175e-002, 1.727072e-002, 1.725969e-002, 1.724867e-002, 1.723765e-002, 1.722663e-002, 1.721562e-002, 1.720462e-002, 1.719362e-002, 1.718262e-002, 1.717163e-002, 1.716065e-002, 1.714966e-002, 1.713869e-002, 1.712771e-002, 1.711675e-002, 1.710578e-002, 1.709483e-002, 1.708387e-002, 1.707292e-002, 1.706198e-002, 1.705104e-002, 1.704010e-002, 1.702917e-002, 1.701825e-002, 1.700733e-002, 1.699641e-002, 1.698550e-002, 1.697459e-002, 1.696369e-002, 1.695279e-002, 1.694190e-002, 1.693101e-002, 1.692013e-002, 1.690925e-002, 1.689838e-002, 1.688751e-002, 1.687664e-002, 1.686578e-002, 1.685493e-002, 1.684408e-002, 1.683323e-002, 1.682239e-002, 1.681155e-002, 1.680072e-002, 1.678989e-002, 1.677907e-002, 1.676825e-002, 1.675744e-002, 1.674663e-002, 1.673582e-002, 1.672502e-002, 1.671423e-002, 1.670344e-002, 1.669265e-002, 1.668187e-002, 1.667110e-002, 1.666032e-002, 1.664956e-002, 1.663879e-002, 1.662804e-002, 1.661728e-002, 1.660654e-002, 1.659579e-002, 1.658505e-002, 1.657432e-002, 1.656359e-002, 1.655286e-002, 1.654214e-002, 1.653143e-002, 1.652071e-002, 1.651001e-002, 1.649930e-002, 1.648861e-002, 1.647791e-002, 1.646723e-002, 1.645654e-002, 1.644586e-002, 1.643519e-002, 1.642452e-002, 1.641385e-002, 1.640319e-002, 1.639254e-002, 1.638188e-002, 1.637124e-002, 1.636060e-002, 1.634996e-002, 1.633933e-002, 1.632870e-002, 1.631807e-002, 1.630745e-002, 1.629684e-002, 1.628623e-002, 1.627562e-002, 1.626502e-002, 1.625443e-002, 1.624384e-002, 1.623325e-002, 
1.622267e-002, 1.621209e-002, 1.620152e-002, 1.619095e-002, 1.618038e-002, 1.616982e-002, 1.615927e-002, 1.614872e-002, 1.613817e-002, 1.612763e-002, 1.611710e-002, 1.610656e-002, 1.609604e-002, 1.608552e-002, 1.607500e-002, 1.606448e-002, 1.605397e-002, 1.604347e-002, 1.603297e-002, 1.602248e-002, 1.601199e-002, 1.600150e-002, 1.599102e-002, 1.598054e-002, 1.597007e-002, 1.595960e-002, 1.594914e-002, 1.593868e-002, 1.592823e-002, 1.591778e-002, 1.590733e-002, 1.589689e-002, 1.588646e-002, 1.587603e-002, 1.586560e-002, 1.585518e-002, 1.584476e-002, 1.583435e-002, 1.582394e-002, 1.581354e-002, 1.580314e-002, 1.579274e-002, 1.578235e-002, 1.577197e-002, 1.576159e-002, 1.575121e-002, 1.574084e-002, 1.573047e-002, 1.572011e-002, 1.570975e-002, 1.569940e-002, 1.568905e-002, 1.567870e-002, 1.566836e-002, 1.565803e-002, 1.564770e-002, 1.563737e-002, 1.562705e-002, 1.561673e-002, 1.560642e-002, 1.559611e-002, 1.558581e-002, 1.557551e-002, 1.556521e-002, 1.555492e-002, 1.554464e-002, 1.553436e-002, 1.552408e-002, 1.551381e-002, 1.550354e-002, 1.549328e-002, 1.548302e-002, 1.547277e-002, 1.546252e-002, 1.545227e-002, 1.544203e-002, 1.543180e-002, 1.542157e-002, 1.541134e-002, 1.540112e-002, 1.539090e-002, 1.538069e-002, 1.537048e-002, 1.536028e-002, 1.535008e-002, 1.533988e-002, 1.532969e-002, 1.531951e-002, 1.530932e-002, 1.529915e-002, 1.528898e-002, 1.527881e-002, 1.526864e-002, 1.525849e-002, 1.524833e-002, 1.523818e-002, 1.522804e-002, 1.521790e-002, 1.520776e-002, 1.519763e-002, 
1.518750e-002, 1.517738e-002, 1.516726e-002, 1.515715e-002, 1.514704e-002, 1.513693e-002, 1.512683e-002, 1.511674e-002, 1.510664e-002, 1.509656e-002, 1.508647e-002, 1.507640e-002, 1.506632e-002, 1.505625e-002, 1.504619e-002, 1.503613e-002, 1.502608e-002, 1.501602e-002, 1.500598e-002, 1.499594e-002, 1.498590e-002, 1.497587e-002, 1.496584e-002, 1.495581e-002, 1.494579e-002, 1.493578e-002, 1.492577e-002, 1.491576e-002, 1.490576e-002, 1.489576e-002, 1.488577e-002, 1.487578e-002, 1.486580e-002, 1.485582e-002, 1.484584e-002, 1.483587e-002, 1.482591e-002, 1.481595e-002, 1.480599e-002, 1.479604e-002, 1.478609e-002, 1.477615e-002, 1.476621e-002, 1.475627e-002, 1.474634e-002, 1.473642e-002, 1.472649e-002, 1.471658e-002, 1.470667e-002, 1.469676e-002, 1.468685e-002, 1.467696e-002, 1.466706e-002, 1.465717e-002, 1.464728e-002, 1.463740e-002, 1.462753e-002, 1.461765e-002, 1.460779e-002, 1.459792e-002, 1.458806e-002, 1.457821e-002, 1.456836e-002, 1.455851e-002, 1.454867e-002, 1.453884e-002, 1.452900e-002, 1.451918e-002, 1.450935e-002, 1.449953e-002, 1.448972e-002, 1.447991e-002, 1.447010e-002, 1.446030e-002, 1.445050e-002, 1.444071e-002, 1.443092e-002, 1.442114e-002, 1.441136e-002, 1.440159e-002, 1.439181e-002, 1.438205e-002, 1.437229e-002, 1.436253e-002, 1.435278e-002, 1.434303e-002, 1.433328e-002, 1.432355e-002, 1.431381e-002, 1.430408e-002, 1.429435e-002, 1.428463e-002, 1.427491e-002, 1.426520e-002, 1.425549e-002, 1.424579e-002, 1.423609e-002, 1.422639e-002, 1.421670e-002, 1.420702e-002, 
1.419733e-002, 1.418766e-002, 1.417798e-002, 1.416831e-002, 1.415865e-002, 1.414899e-002, 1.413933e-002, 1.412968e-002, 1.412003e-002, 1.411039e-002, 1.410075e-002, 1.409112e-002, 1.408149e-002, 1.407186e-002, 1.406224e-002, 1.405263e-002, 1.404302e-002, 1.403341e-002, 1.402381e-002, 1.401421e-002, 1.400461e-002, 1.399502e-002, 1.398544e-002, 1.397586e-002, 1.396628e-002, 1.395671e-002, 1.394714e-002, 1.393757e-002, 1.392801e-002, 1.391846e-002, 1.390891e-002, 1.389936e-002, 1.388982e-002, 1.388028e-002, 1.387075e-002, 1.386122e-002, 1.385170e-002, 1.384218e-002, 1.383266e-002, 1.382315e-002, 1.381364e-002, 1.380414e-002, 1.379464e-002, 1.378515e-002, 1.377566e-002, 1.376617e-002, 1.375669e-002, 1.374722e-002, 1.373774e-002, 1.372828e-002, 1.371881e-002, 1.370935e-002, 1.369990e-002, 1.369045e-002, 1.368100e-002, 1.367156e-002, 1.366212e-002, 1.365269e-002, 1.364326e-002, 1.363384e-002, 1.362442e-002, 1.361500e-002, 1.360559e-002, 1.359618e-002, 1.358678e-002, 1.357738e-002, 1.356799e-002, 1.355860e-002, 1.354921e-002, 1.353983e-002, 1.353046e-002, 1.352108e-002, 1.351172e-002, 1.350235e-002, 1.349299e-002, 1.348364e-002, 1.347429e-002, 1.346494e-002, 1.345560e-002, 1.344626e-002, 1.343693e-002, 1.342760e-002, 1.341827e-002, 1.340895e-002, 1.339964e-002, 1.339033e-002, 1.338102e-002, 1.337172e-002, 1.336242e-002, 1.335312e-002, 1.334383e-002, 1.333455e-002, 1.332526e-002, 1.331599e-002, 1.330671e-002, 1.329745e-002, 1.328818e-002, 1.327892e-002, 1.326967e-002, 1.326041e-002, 
1.325117e-002, 1.324192e-002, 1.323269e-002, 1.322345e-002, 1.321422e-002, 1.320500e-002, 1.319577e-002, 1.318656e-002, 1.317734e-002, 1.316814e-002, 1.315893e-002, 1.314973e-002, 1.314054e-002, 1.313134e-002, 1.312216e-002, 1.311297e-002, 1.310380e-002, 1.309462e-002, 1.308545e-002, 1.307629e-002, 1.306713e-002, 1.305797e-002, 1.304882e-002, 1.303967e-002, 1.303052e-002, 1.302138e-002, 1.301225e-002, 1.300312e-002, 1.299399e-002, 1.298487e-002, 1.297575e-002, 1.296663e-002, 1.295752e-002, 1.294842e-002, 1.293932e-002, 1.293022e-002, 1.292113e-002, 1.291204e-002, 1.290295e-002, 1.289387e-002, 1.288480e-002, 1.287572e-002, 1.286666e-002, 1.285759e-002, 1.284853e-002, 1.283948e-002, 1.283043e-002, 1.282138e-002, 1.281234e-002, 1.280330e-002, 1.279427e-002, 1.278524e-002, 1.277622e-002, 1.276720e-002, 1.275818e-002, 1.274917e-002, 1.274016e-002, 1.273116e-002, 1.272216e-002, 1.271316e-002, 1.270417e-002, 1.269518e-002, 1.268620e-002, 1.267722e-002, 1.266825e-002, 1.265928e-002, 1.265031e-002, 1.264135e-002, 1.263240e-002, 1.262344e-002, 1.261449e-002, 1.260555e-002, 1.259661e-002, 1.258767e-002, 1.257874e-002, 1.256982e-002, 1.256089e-002, 1.255197e-002, 1.254306e-002, 1.253415e-002, 1.252524e-002, 1.251634e-002, 1.250744e-002, 1.249855e-002, 1.248966e-002, 1.248077e-002, 1.247189e-002, 1.246302e-002, 1.245414e-002, 1.244527e-002, 1.243641e-002, 1.242755e-002, 1.241869e-002, 1.240984e-002, 1.240100e-002, 1.239215e-002, 1.238331e-002, 1.237448e-002, 1.236565e-002, 1.235682e-002, 
1.234800e-002, 1.233918e-002, 1.233037e-002, 1.232156e-002, 1.231275e-002, 1.230395e-002, 1.229516e-002, 1.228636e-002, 1.227757e-002, 1.226879e-002, 1.226001e-002, 1.225123e-002, 1.224246e-002, 1.223369e-002, 1.222493e-002, 1.221617e-002, 1.220742e-002, 1.219867e-002, 1.218992e-002, 1.218118e-002, 1.217244e-002, 1.216370e-002, 1.215497e-002, 1.214625e-002, 1.213753e-002, 1.212881e-002, 1.212010e-002, 1.211139e-002, 1.210268e-002, 1.209398e-002, 1.208529e-002, 1.207659e-002, 1.206790e-002, 1.205922e-002, 1.205054e-002, 1.204187e-002, 1.203319e-002, 1.202453e-002, 1.201586e-002, 1.200720e-002, 1.199855e-002, 1.198990e-002, 1.198125e-002, 1.197261e-002, 1.196397e-002, 1.195534e-002, 1.194671e-002, 1.193808e-002, 1.192946e-002, 1.192084e-002, 1.191223e-002, 1.190362e-002, 1.189501e-002, 1.188641e-002, 1.187782e-002, 1.186922e-002, 1.186064e-002, 1.185205e-002, 1.184347e-002, 1.183490e-002, 1.182632e-002, 1.181776e-002, 1.180919e-002, 1.180063e-002, 1.179208e-002, 1.178353e-002, 1.177498e-002, 1.176644e-002, 1.175790e-002, 1.174936e-002, 1.174083e-002, 1.173231e-002, 1.172378e-002, 1.171527e-002, 1.170675e-002, 1.169824e-002, 1.168974e-002, 1.168123e-002, 1.167274e-002, 1.166424e-002, 1.165575e-002, 1.164727e-002, 1.163879e-002, 1.163031e-002, 1.162184e-002, 1.161337e-002, 1.160491e-002, 1.159645e-002, 1.158799e-002, 1.157954e-002, 1.157109e-002, 1.156264e-002, 1.155420e-002, 1.154577e-002, 1.153734e-002, 1.152891e-002, 1.152049e-002, 1.151207e-002, 1.150365e-002, 1.149524e-002, 
1.148683e-002, 1.147843e-002, 1.147003e-002, 1.146164e-002, 1.145325e-002, 1.144486e-002, 1.143648e-002, 1.142810e-002, 1.141972e-002, 1.141135e-002, 1.140299e-002, 1.139463e-002, 1.138627e-002, 1.137791e-002, 1.136956e-002, 1.136122e-002, 1.135288e-002, 1.134454e-002, 1.133621e-002, 1.132788e-002, 1.131955e-002, 1.131123e-002, 1.130291e-002, 1.129460e-002, 1.128629e-002, 1.127799e-002, 1.126969e-002, 1.126139e-002, 1.125310e-002, 1.124481e-002, 1.123652e-002, 1.122824e-002, 1.121997e-002, 1.121169e-002, 1.120343e-002, 1.119516e-002, 1.118690e-002, 1.117865e-002, 1.117039e-002, 1.116215e-002, 1.115390e-002, 1.114566e-002, 1.113743e-002, 1.112920e-002, 1.112097e-002, 1.111274e-002, 1.110452e-002, 1.109631e-002, 1.108810e-002, 1.107989e-002, 1.107169e-002, 1.106349e-002, 1.105529e-002, 1.104710e-002, 1.103891e-002, 1.103073e-002, 1.102255e-002, 1.101438e-002, 1.100621e-002, 1.099804e-002, 1.098988e-002, 1.098172e-002, 1.097356e-002, 1.096541e-002, 1.095727e-002, 1.094912e-002, 1.094099e-002, 1.093285e-002, 1.092472e-002, 1.091659e-002, 1.090847e-002, 1.090035e-002, 1.089224e-002, 1.088413e-002, 1.087602e-002, 1.086792e-002, 1.085982e-002, 1.085173e-002, 1.084364e-002, 1.083555e-002, 1.082747e-002, 1.081939e-002, 1.081132e-002, 1.080325e-002, 1.079518e-002, 1.078712e-002, 1.077906e-002, 1.077101e-002, 1.076295e-002, 1.075491e-002, 1.074687e-002, 1.073883e-002, 1.073079e-002, 1.072276e-002, 1.071474e-002, 1.070672e-002, 1.069870e-002, 1.069068e-002, 1.068267e-002, 1.067467e-002, 
1.066667e-002, 1.065867e-002, 1.065067e-002, 1.064268e-002, 1.063470e-002, 1.062672e-002, 1.061874e-002, 1.061076e-002, 1.060279e-002, 1.059483e-002, 1.058687e-002, 1.057891e-002, 1.057095e-002, 1.056300e-002, 1.055506e-002, 1.054712e-002, 1.053918e-002, 1.053124e-002, 1.052331e-002, 1.051539e-002, 1.050747e-002, 1.049955e-002, 1.049163e-002, 1.048372e-002, 1.047582e-002, 1.046791e-002, 1.046002e-002, 1.045212e-002, 1.044423e-002, 1.043634e-002, 1.042846e-002, 1.042058e-002, 1.041271e-002, 1.040484e-002, 1.039697e-002, 1.038911e-002, 1.038125e-002, 1.037340e-002, 1.036555e-002, 1.035770e-002, 1.034986e-002, 1.034202e-002, 1.033418e-002, 1.032635e-002, 1.031852e-002, 1.031070e-002, 1.030288e-002, 1.029507e-002, 1.028726e-002, 1.027945e-002, 1.027165e-002, 1.026385e-002, 1.025605e-002, 1.024826e-002, 1.024047e-002, 1.023269e-002, 1.022491e-002, 1.021713e-002, 1.020936e-002, 1.020159e-002, 1.019383e-002, 1.018607e-002, 1.017831e-002, 1.017056e-002, 1.016281e-002, 1.015507e-002, 1.014733e-002, 1.013959e-002, 1.013186e-002, 1.012413e-002, 1.011641e-002, 1.010869e-002, 1.010097e-002, 1.009326e-002, 1.008555e-002, 1.007785e-002, 1.007015e-002, 1.006245e-002, 1.005476e-002, 1.004707e-002, 1.003938e-002, 1.003170e-002, 1.002402e-002, 1.001635e-002, 1.000868e-002, 1.000101e-002, 9.993353e-003, 9.985695e-003, 9.978041e-003, 9.970391e-003, 9.962745e-003, 9.955103e-003, 9.947465e-003, 9.939831e-003, 9.932200e-003, 9.924574e-003, 9.916951e-003, 9.909333e-003, 9.901718e-003, 9.894107e-003, 
9.886500e-003, 9.878897e-003, 9.871298e-003, 9.863703e-003, 9.856111e-003, 9.848524e-003, 9.840940e-003, 9.833360e-003, 9.825785e-003, 9.818213e-003, 9.810645e-003, 9.803081e-003, 9.795521e-003, 9.787964e-003, 9.780412e-003, 9.772863e-003, 9.765319e-003, 9.757778e-003, 9.750241e-003, 9.742708e-003, 9.735179e-003, 9.727653e-003, 9.720132e-003, 9.712615e-003, 9.705101e-003, 9.697591e-003, 9.690085e-003, 9.682583e-003, 9.675085e-003, 9.667591e-003, 9.660101e-003, 9.652614e-003, 9.645131e-003, 9.637653e-003, 9.630178e-003, 9.622707e-003, 9.615239e-003, 9.607776e-003, 9.600317e-003, 9.592861e-003, 9.585409e-003, 9.577961e-003, 9.570517e-003, 9.563077e-003, 9.555641e-003, 9.548209e-003, 9.540780e-003, 9.533355e-003, 9.525934e-003, 9.518517e-003, 9.511104e-003, 9.503695e-003, 9.496289e-003, 9.488888e-003, 9.481490e-003, 9.474096e-003, 9.466706e-003, 9.459320e-003, 9.451937e-003, 9.444559e-003, 9.437184e-003, 9.429813e-003, 9.422446e-003, 9.415083e-003, 9.407724e-003, 9.400368e-003, 9.393016e-003, 9.385668e-003, 9.378324e-003, 9.370984e-003, 9.363648e-003, 9.356315e-003, 9.348987e-003, 9.341662e-003, 9.334341e-003, 9.327023e-003, 9.319710e-003, 9.312400e-003, 9.305095e-003, 9.297793e-003, 9.290495e-003, 9.283200e-003, 9.275910e-003, 9.268623e-003, 9.261340e-003, 9.254061e-003, 9.246786e-003, 9.239515e-003, 9.232247e-003, 9.224983e-003, 9.217724e-003, 9.210467e-003, 9.203215e-003, 9.195966e-003, 9.188722e-003, 9.181481e-003, 9.174244e-003, 9.167010e-003, 9.159781e-003, 9.152555e-003, 
9.145333e-003, 9.138115e-003, 9.130901e-003, 9.123690e-003, 9.116484e-003, 9.109281e-003, 9.102082e-003, 9.094886e-003, 9.087695e-003, 9.080507e-003, 9.073323e-003, 9.066143e-003, 9.058967e-003, 9.051794e-003, 9.044625e-003, 9.037460e-003, 9.030299e-003, 9.023142e-003, 9.015988e-003, 9.008838e-003, 9.001692e-003, 8.994550e-003, 8.987411e-003, 8.980276e-003, 8.973145e-003, 8.966018e-003, 8.958895e-003, 8.951775e-003, 8.944659e-003, 8.937547e-003, 8.930439e-003, 8.923334e-003, 8.916233e-003, 8.909136e-003, 8.902043e-003, 8.894954e-003, 8.887868e-003, 8.880786e-003, 8.873708e-003, 8.866633e-003, 8.859563e-003, 8.852496e-003, 8.845433e-003, 8.838373e-003, 8.831318e-003, 8.824266e-003, 8.817218e-003, 8.810173e-003, 8.803133e-003, 8.796096e-003, 8.789063e-003, 8.782033e-003, 8.775007e-003, 8.767986e-003, 8.760967e-003, 8.753953e-003, 8.746942e-003, 8.739936e-003, 8.732932e-003, 8.725933e-003, 8.718937e-003, 8.711945e-003, 8.704957e-003, 8.697973e-003, 8.690992e-003, 8.684015e-003, 8.677042e-003, 8.670072e-003, 8.663107e-003, 8.656144e-003, 8.649186e-003, 8.642232e-003, 8.635281e-003, 8.628334e-003, 8.621390e-003, 8.614451e-003, 8.607515e-003, 8.600582e-003, 8.593654e-003, 8.586729e-003, 8.579808e-003, 8.572891e-003, 8.565977e-003, 8.559067e-003, 8.552161e-003, 8.545258e-003, 8.538360e-003, 8.531465e-003, 8.524573e-003, 8.517686e-003, 8.510802e-003, 8.503922e-003, 8.497045e-003, 8.490172e-003, 8.483303e-003, 8.476438e-003, 8.469576e-003, 8.462718e-003, 8.455864e-003, 8.449014e-003, 
8.442167e-003, 8.435324e-003, 8.428484e-003, 8.421648e-003, 8.414816e-003, 8.407988e-003, 8.401163e-003, 8.394342e-003, 8.387525e-003, 8.380711e-003, 8.373902e-003, 8.367095e-003, 8.360293e-003, 8.353494e-003, 8.346699e-003, 8.339907e-003, 8.333120e-003, 8.326335e-003, 8.319555e-003, 8.312778e-003, 8.306005e-003, 8.299236e-003, 8.292470e-003, 8.285708e-003, 8.278950e-003, 8.272195e-003, 8.265444e-003, 8.258697e-003, 8.251953e-003, 8.245213e-003, 8.238477e-003, 8.231745e-003, 8.225016e-003, 8.218290e-003, 8.211569e-003, 8.204851e-003, 8.198136e-003, 8.191426e-003, 8.184719e-003, 8.178016e-003, 8.171316e-003, 8.164620e-003, 8.157928e-003, 8.151239e-003, 8.144554e-003, 8.137873e-003, 8.131195e-003, 8.124521e-003, 8.117851e-003, 8.111184e-003, 8.104521e-003, 8.097861e-003, 8.091206e-003, 8.084554e-003, 8.077905e-003, 8.071260e-003, 8.064619e-003, 8.057981e-003, 8.051348e-003, 8.044717e-003, 8.038091e-003, 8.031468e-003, 8.024848e-003, 8.018233e-003, 8.011621e-003, 8.005012e-003, 7.998407e-003, 7.991806e-003, 7.985209e-003, 7.978615e-003, 7.972024e-003, 7.965438e-003, 7.958855e-003, 7.952275e-003, 7.945700e-003, 7.939128e-003, 7.932559e-003, 7.925994e-003, 7.919433e-003, 7.912875e-003, 7.906321e-003, 7.899771e-003, 7.893224e-003, 7.886681e-003, 7.880141e-003, 7.873606e-003, 7.867073e-003, 7.860545e-003, 7.854019e-003, 7.847498e-003, 7.840980e-003, 7.834466e-003, 7.827955e-003, 7.821448e-003, 7.814945e-003, 7.808445e-003, 7.801949e-003, 7.795456e-003, 7.788967e-003, 7.782482e-003, 
7.776000e-003, 7.769522e-003, 7.763047e-003, 7.756576e-003, 7.750109e-003, 7.743645e-003, 7.737185e-003, 7.730728e-003, 7.724275e-003, 7.717826e-003, 7.711380e-003, 7.704938e-003, 7.698499e-003, 7.692064e-003, 7.685632e-003, 7.679204e-003, 7.672780e-003, 7.666359e-003, 7.659942e-003, 7.653529e-003, 7.647119e-003, 7.640712e-003, 7.634309e-003, 7.627910e-003, 7.621514e-003, 7.615122e-003, 7.608734e-003, 7.602349e-003, 7.595968e-003, 7.589590e-003, 7.583215e-003, 7.576845e-003, 7.570478e-003, 7.564114e-003, 7.557754e-003, 7.551398e-003, 7.545045e-003, 7.538696e-003, 7.532350e-003, 7.526008e-003, 7.519669e-003, 7.513334e-003, 7.507003e-003, 7.500675e-003, 7.494351e-003, 7.488030e-003, 7.481713e-003, 7.475399e-003, 7.469089e-003, 7.462782e-003, 7.456479e-003, 7.450180e-003, 7.443884e-003, 7.437591e-003, 7.431303e-003, 7.425017e-003, 7.418736e-003, 7.412457e-003, 7.406183e-003, 7.399912e-003, 7.393644e-003, 7.387380e-003, 7.381119e-003, 7.374863e-003, 7.368609e-003, 7.362359e-003, 7.356113e-003, 7.349870e-003, 7.343631e-003, 7.337395e-003, 7.331163e-003, 7.324934e-003, 7.318709e-003, 7.312487e-003, 7.306269e-003, 7.300055e-003, 7.293844e-003, 7.287636e-003, 7.281432e-003, 7.275232e-003, 7.269035e-003, 7.262841e-003, 7.256651e-003, 7.250465e-003, 7.244282e-003, 7.238103e-003, 7.231927e-003, 7.225754e-003, 7.219586e-003, 7.213420e-003, 7.207258e-003, 7.201100e-003, 7.194945e-003, 7.188794e-003, 7.182646e-003, 7.176502e-003, 7.170361e-003, 7.164224e-003, 7.158090e-003, 7.151960e-003, 
7.145833e-003, 7.139710e-003, 7.133590e-003, 7.127474e-003, 7.121361e-003, 7.115252e-003, 7.109146e-003, 7.103044e-003, 7.096945e-003, 7.090850e-003, 7.084758e-003, 7.078670e-003, 7.072585e-003, 7.066504e-003, 7.060426e-003, 7.054352e-003, 7.048281e-003, 7.042213e-003, 7.036149e-003, 7.030089e-003, 7.024032e-003, 7.017979e-003, 7.011929e-003, 7.005882e-003, 6.999839e-003, 6.993799e-003, 6.987763e-003, 6.981731e-003, 6.975702e-003, 6.969676e-003, 6.963654e-003, 6.957635e-003, 6.951620e-003, 6.945608e-003, 6.939600e-003, 6.933595e-003, 6.927594e-003, 6.921596e-003, 6.915601e-003, 6.909610e-003, 6.903623e-003, 6.897639e-003, 6.891658e-003, 6.885681e-003, 6.879707e-003, 6.873737e-003, 6.867770e-003, 6.861807e-003, 6.855847e-003, 6.849890e-003, 6.843937e-003, 6.837988e-003, 6.832042e-003, 6.826099e-003, 6.820160e-003, 6.814224e-003, 6.808292e-003, 6.802363e-003, 6.796438e-003, 6.790516e-003, 6.784597e-003, 6.778682e-003, 6.772771e-003, 6.766862e-003, 6.760958e-003, 6.755056e-003, 6.749158e-003, 6.743264e-003, 6.737373e-003, 6.731485e-003, 6.725601e-003, 6.719720e-003, 6.713843e-003, 6.707969e-003, 6.702099e-003, 6.696232e-003, 6.690368e-003, 6.684508e-003, 6.678651e-003, 6.672798e-003, 6.666948e-003, 6.661102e-003, 6.655258e-003, 6.649419e-003, 6.643583e-003, 6.637750e-003, 6.631920e-003, 6.626094e-003, 6.620272e-003, 6.614453e-003, 6.608637e-003, 6.602824e-003, 6.597016e-003, 6.591210e-003, 6.585408e-003, 6.579609e-003, 6.573814e-003, 6.568022e-003, 6.562233e-003, 6.556448e-003, 
6.550667e-003, 6.544888e-003, 6.539113e-003, 6.533342e-003, 6.527574e-003, 6.521809e-003, 6.516048e-003, 6.510290e-003, 6.504535e-003, 6.498784e-003, 6.493036e-003, 6.487292e-003, 6.481551e-003, 6.475814e-003, 6.470079e-003, 6.464349e-003, 6.458621e-003, 6.452897e-003, 6.447176e-003, 6.441459e-003, 6.435745e-003, 6.430035e-003, 6.424328e-003, 6.418624e-003, 6.412924e-003, 6.407227e-003, 6.401533e-003, 6.395843e-003, 6.390156e-003, 6.384472e-003, 6.378792e-003, 6.373115e-003, 6.367442e-003, 6.361772e-003, 6.356105e-003, 6.350442e-003, 6.344782e-003, 6.339126e-003, 6.333472e-003, 6.327822e-003, 6.322176e-003, 6.316533e-003, 6.310893e-003, 6.305257e-003, 6.299624e-003, 6.293994e-003, 6.288368e-003, 6.282745e-003, 6.277125e-003, 6.271509e-003, 6.265896e-003, 6.260286e-003, 6.254680e-003, 6.249077e-003, 6.243478e-003, 6.237881e-003, 6.232289e-003, 6.226699e-003, 6.221113e-003, 6.215530e-003, 6.209951e-003, 6.204375e-003, 6.198802e-003, 6.193232e-003, 6.187666e-003, 6.182103e-003, 6.176544e-003, 6.170988e-003, 6.165435e-003, 6.159886e-003, 6.154339e-003, 6.148797e-003, 6.143257e-003, 6.137721e-003, 6.132188e-003, 6.126659e-003, 6.121133e-003, 6.115610e-003, 6.110090e-003, 6.104574e-003, 6.099061e-003, 6.093552e-003, 6.088046e-003, 6.082543e-003, 6.077043e-003, 6.071547e-003, 6.066054e-003, 6.060564e-003, 6.055078e-003, 6.049595e-003, 6.044115e-003, 6.038639e-003, 6.033166e-003, 6.027696e-003, 6.022229e-003, 6.016766e-003, 6.011306e-003, 6.005850e-003, 6.000397e-003, 5.994947e-003, 
5.989500e-003, 5.984057e-003, 5.978617e-003, 5.973180e-003, 5.967746e-003, 5.962316e-003, 5.956889e-003, 5.951466e-003, 5.946046e-003, 5.940629e-003, 5.935215e-003, 5.929804e-003, 5.924397e-003, 5.918993e-003, 5.913593e-003, 5.908196e-003, 5.902802e-003, 5.897411e-003, 5.892024e-003, 5.886640e-003, 5.881259e-003, 5.875881e-003, 5.870507e-003, 5.865136e-003, 5.859768e-003, 5.854404e-003, 5.849042e-003, 5.843685e-003, 5.838330e-003, 5.832979e-003, 5.827630e-003, 5.822286e-003, 5.816944e-003, 5.811606e-003, 5.806271e-003, 5.800939e-003, 5.795611e-003, 5.790285e-003, 5.784963e-003, 5.779645e-003, 5.774329e-003, 5.769017e-003, 5.763708e-003, 5.758403e-003, 5.753100e-003, 5.747801e-003, 5.742505e-003, 5.737213e-003, 5.731923e-003, 5.726637e-003, 5.721354e-003, 5.716075e-003, 5.710798e-003, 5.705525e-003, 5.700255e-003, 5.694989e-003, 5.689725e-003, 5.684465e-003, 5.679208e-003, 5.673954e-003, 5.668704e-003, 5.663457e-003, 5.658213e-003, 5.652972e-003, 5.647735e-003, 5.642500e-003, 5.637269e-003, 5.632042e-003, 5.626817e-003, 5.621596e-003, 5.616378e-003, 5.611163e-003, 5.605951e-003, 5.600743e-003, 5.595538e-003, 5.590336e-003, 5.585137e-003, 5.579942e-003, 5.574750e-003, 5.569560e-003, 5.564375e-003, 5.559192e-003, 5.554013e-003, 5.548837e-003, 5.543664e-003, 5.538494e-003, 5.533327e-003, 5.528164e-003, 5.523004e-003, 5.517847e-003, 5.512693e-003, 5.507543e-003, 5.502396e-003, 5.497252e-003, 5.492111e-003, 5.486973e-003, 5.481839e-003, 5.476708e-003, 5.471580e-003, 5.466455e-003, 
5.461333e-003, 5.456215e-003, 5.451100e-003, 5.445988e-003, 5.440879e-003, 5.435773e-003, 5.430671e-003, 5.425572e-003, 5.420476e-003, 5.415383e-003, 5.410293e-003, 5.405207e-003, 5.400123e-003, 5.395043e-003, 5.389966e-003, 5.384893e-003, 5.379822e-003, 5.374755e-003, 5.369691e-003, 5.364630e-003, 5.359572e-003, 5.354517e-003, 5.349466e-003, 5.344418e-003, 5.339373e-003, 5.334331e-003, 5.329292e-003, 5.324256e-003, 5.319224e-003, 5.314195e-003, 5.309169e-003, 5.304146e-003, 5.299126e-003, 5.294110e-003, 5.289096e-003, 5.284086e-003, 5.279079e-003, 5.274075e-003, 5.269075e-003, 5.264077e-003, 5.259083e-003, 5.254091e-003, 5.249103e-003, 5.244118e-003, 5.239137e-003, 5.234158e-003, 5.229183e-003, 5.224210e-003, 5.219241e-003, 5.214275e-003, 5.209312e-003, 5.204353e-003, 5.199396e-003, 5.194443e-003, 5.189493e-003, 5.184546e-003, 5.179602e-003, 5.174661e-003, 5.169723e-003, 5.164789e-003, 5.159857e-003, 5.154929e-003, 5.150004e-003, 5.145082e-003, 5.140163e-003, 5.135248e-003, 5.130335e-003, 5.125426e-003, 5.120519e-003, 5.115616e-003, 5.110716e-003, 5.105819e-003, 5.100926e-003, 5.096035e-003, 5.091147e-003, 5.086263e-003, 5.081382e-003, 5.076504e-003, 5.071629e-003, 5.066757e-003, 5.061888e-003, 5.057022e-003, 5.052160e-003, 5.047300e-003, 5.042444e-003, 5.037591e-003, 5.032741e-003, 5.027894e-003, 5.023050e-003, 5.018209e-003, 5.013372e-003, 5.008537e-003, 5.003706e-003, 4.998878e-003, 4.994053e-003, 4.989230e-003, 4.984411e-003, 4.979596e-003, 4.974783e-003, 4.969973e-003, 
4.965167e-003, 4.960363e-003, 4.955563e-003, 4.950766e-003, 4.945971e-003, 4.941180e-003, 4.936392e-003, 4.931608e-003, 4.926826e-003, 4.922047e-003, 4.917272e-003, 4.912499e-003, 4.907730e-003, 4.902963e-003, 4.898200e-003, 4.893440e-003, 4.888683e-003, 4.883929e-003, 4.879178e-003, 4.874430e-003, 4.869685e-003, 4.864944e-003, 4.860205e-003, 4.855470e-003, 4.850737e-003, 4.846008e-003, 4.841282e-003, 4.836558e-003, 4.831838e-003, 4.827121e-003, 4.822407e-003, 4.817696e-003, 4.812988e-003, 4.808284e-003, 4.803582e-003, 4.798883e-003, 4.794188e-003, 4.789495e-003, 4.784806e-003, 4.780119e-003, 4.775436e-003, 4.770756e-003, 4.766079e-003, 4.761404e-003, 4.756733e-003, 4.752065e-003, 4.747400e-003, 4.742738e-003, 4.738079e-003, 4.733424e-003, 4.728771e-003, 4.724121e-003, 4.719474e-003, 4.714831e-003, 4.710190e-003, 4.705553e-003, 4.700918e-003, 4.696287e-003, 4.691658e-003, 4.687033e-003, 4.682411e-003, 4.677791e-003, 4.673175e-003, 4.668562e-003, 4.663952e-003, 4.659345e-003, 4.654741e-003, 4.650139e-003, 4.645541e-003, 4.640946e-003, 4.636355e-003, 4.631766e-003, 4.627180e-003, 4.622597e-003, 4.618017e-003, 4.613440e-003, 4.608866e-003, 4.604296e-003, 4.599728e-003, 4.595163e-003, 4.590601e-003, 4.586043e-003, 4.581487e-003, 4.576934e-003, 4.572385e-003, 4.567838e-003, 4.563294e-003, 4.558754e-003, 4.554216e-003, 4.549682e-003, 4.545150e-003, 4.540622e-003, 4.536096e-003, 4.531574e-003, 4.527054e-003, 4.522538e-003, 4.518024e-003, 4.513514e-003, 4.509006e-003, 4.504502e-003, 
4.500000e-003, 4.495501e-003, 4.491006e-003, 4.486513e-003, 4.482024e-003, 4.477537e-003, 4.473054e-003, 4.468573e-003, 4.464096e-003, 4.459621e-003, 4.455150e-003, 4.450681e-003, 4.446216e-003, 4.441753e-003, 4.437294e-003, 4.432837e-003, 4.428383e-003, 4.423933e-003, 4.419485e-003, 4.415040e-003, 4.410599e-003, 4.406160e-003, 4.401724e-003, 4.397291e-003, 4.392862e-003, 4.388435e-003, 4.384011e-003, 4.379590e-003, 4.375172e-003, 4.370757e-003, 4.366346e-003, 4.361937e-003, 4.357531e-003, 4.353128e-003, 4.348727e-003, 4.344330e-003, 4.339936e-003, 4.335545e-003, 4.331157e-003, 4.326772e-003, 4.322389e-003, 4.318010e-003, 4.313634e-003, 4.309260e-003, 4.304890e-003, 4.300522e-003, 4.296158e-003, 4.291796e-003, 4.287438e-003, 4.283082e-003, 4.278729e-003, 4.274379e-003, 4.270033e-003, 4.265689e-003, 4.261348e-003, 4.257010e-003, 4.252675e-003, 4.248343e-003, 4.244013e-003, 4.239687e-003, 4.235364e-003, 4.231044e-003, 4.226726e-003, 4.222412e-003, 4.218100e-003, 4.213792e-003, 4.209486e-003, 4.205183e-003, 4.200884e-003, 4.196587e-003, 4.192293e-003, 4.188002e-003, 4.183714e-003, 4.179429e-003, 4.175146e-003, 4.170867e-003, 4.166591e-003, 4.162317e-003, 4.158047e-003, 4.153779e-003, 4.149515e-003, 4.145253e-003, 4.140994e-003, 4.136738e-003, 4.132485e-003, 4.128235e-003, 4.123988e-003, 4.119744e-003, 4.115502e-003, 4.111264e-003, 4.107029e-003, 4.102796e-003, 4.098566e-003, 4.094339e-003, 4.090116e-003, 4.085895e-003, 4.081677e-003, 4.077461e-003, 4.073249e-003, 4.069040e-003, 
4.064833e-003, 4.060630e-003, 4.056429e-003, 4.052231e-003, 4.048037e-003, 4.043845e-003, 4.039655e-003, 4.035469e-003, 4.031286e-003, 4.027106e-003, 4.022928e-003, 4.018754e-003, 4.014582e-003, 4.010413e-003, 4.006247e-003, 4.002084e-003, 3.997924e-003, 3.993767e-003, 3.989612e-003, 3.985461e-003, 3.981312e-003, 3.977166e-003, 3.973023e-003, 3.968883e-003, 3.964746e-003, 3.960612e-003, 3.956481e-003, 3.952352e-003, 3.948226e-003, 3.944104e-003, 3.939984e-003, 3.935867e-003, 3.931753e-003, 3.927641e-003, 3.923533e-003, 3.919427e-003, 3.915325e-003, 3.911225e-003, 3.907128e-003, 3.903034e-003, 3.898943e-003, 3.894854e-003, 3.890769e-003, 3.886686e-003, 3.882606e-003, 3.878529e-003, 3.874455e-003, 3.870384e-003, 3.866316e-003, 3.862250e-003, 3.858188e-003, 3.854128e-003, 3.850071e-003, 3.846017e-003, 3.841965e-003, 3.837917e-003, 3.833871e-003, 3.829829e-003, 3.825789e-003, 3.821752e-003, 3.817717e-003, 3.813686e-003, 3.809657e-003, 3.805632e-003, 3.801609e-003, 3.797589e-003, 3.793572e-003, 3.789557e-003, 3.785546e-003, 3.781537e-003, 3.777531e-003, 3.773528e-003, 3.769528e-003, 3.765531e-003, 3.761536e-003, 3.757544e-003, 3.753555e-003, 3.749569e-003, 3.745586e-003, 3.741606e-003, 3.737628e-003, 3.733653e-003, 3.729681e-003, 3.725712e-003, 3.721746e-003, 3.717782e-003, 3.713822e-003, 3.709864e-003, 3.705909e-003, 3.701956e-003, 3.698007e-003, 3.694060e-003, 3.690116e-003, 3.686175e-003, 3.682237e-003, 3.678302e-003, 3.674369e-003, 3.670439e-003, 3.666512e-003, 3.662588e-003, 
3.658667e-003, 3.654748e-003, 3.650832e-003, 3.646919e-003, 3.643009e-003, 3.639102e-003, 3.635197e-003, 3.631295e-003, 3.627396e-003, 3.623500e-003, 3.619607e-003, 3.615716e-003, 3.611828e-003, 3.607943e-003, 3.604061e-003, 3.600181e-003, 3.596304e-003, 3.592430e-003, 3.588559e-003, 3.584691e-003, 3.580825e-003, 3.576963e-003, 3.573102e-003, 3.569245e-003, 3.565391e-003, 3.561539e-003, 3.557690e-003, 3.553844e-003, 3.550001e-003, 3.546160e-003, 3.542322e-003, 3.538487e-003, 3.534655e-003, 3.530825e-003, 3.526999e-003, 3.523175e-003, 3.519353e-003, 3.515535e-003, 3.511719e-003, 3.507906e-003, 3.504096e-003, 3.500289e-003, 3.496484e-003, 3.492682e-003, 3.488883e-003, 3.485086e-003, 3.481293e-003, 3.477502e-003, 3.473714e-003, 3.469928e-003, 3.466146e-003, 3.462366e-003, 3.458589e-003, 3.454814e-003, 3.451043e-003, 3.447274e-003, 3.443508e-003, 3.439744e-003, 3.435984e-003, 3.432226e-003, 3.428471e-003, 3.424718e-003, 3.420969e-003, 3.417222e-003, 3.413477e-003, 3.409736e-003, 3.405997e-003, 3.402261e-003, 3.398528e-003, 3.394797e-003, 3.391070e-003, 3.387344e-003, 3.383622e-003, 3.379902e-003, 3.376186e-003, 3.372471e-003, 3.368760e-003, 3.365051e-003, 3.361345e-003, 3.357642e-003, 3.353941e-003, 3.350243e-003, 3.346548e-003, 3.342856e-003, 3.339166e-003, 3.335479e-003, 3.331795e-003, 3.328114e-003, 3.324435e-003, 3.320759e-003, 3.317085e-003, 3.313414e-003, 3.309746e-003, 3.306081e-003, 3.302419e-003, 3.298759e-003, 3.295102e-003, 3.291447e-003, 3.287795e-003, 3.284146e-003, 
3.280500e-003, 3.276856e-003, 3.273215e-003, 3.269577e-003, 3.265942e-003, 3.262309e-003, 3.258679e-003, 3.255051e-003, 3.251426e-003, 3.247804e-003, 3.244185e-003, 3.240568e-003, 3.236954e-003, 3.233343e-003, 3.229734e-003, 3.226128e-003, 3.222525e-003, 3.218924e-003, 3.215326e-003, 3.211731e-003, 3.208139e-003, 3.204549e-003, 3.200962e-003, 3.197377e-003, 3.193795e-003, 3.190216e-003, 3.186640e-003, 3.183066e-003, 3.179495e-003, 3.175926e-003, 3.172361e-003, 3.168797e-003, 3.165237e-003, 3.161679e-003, 3.158124e-003, 3.154572e-003, 3.151022e-003, 3.147475e-003, 3.143930e-003, 3.140388e-003, 3.136849e-003, 3.133313e-003, 3.129779e-003, 3.126248e-003, 3.122719e-003, 3.119194e-003, 3.115670e-003, 3.112150e-003, 3.108632e-003, 3.105117e-003, 3.101604e-003, 3.098094e-003, 3.094587e-003, 3.091082e-003, 3.087580e-003, 3.084081e-003, 3.080584e-003, 3.077090e-003, 3.073599e-003, 3.070110e-003, 3.066624e-003, 3.063141e-003, 3.059660e-003, 3.056181e-003, 3.052706e-003, 3.049233e-003, 3.045763e-003, 3.042295e-003, 3.038830e-003, 3.035368e-003, 3.031908e-003, 3.028451e-003, 3.024996e-003, 3.021544e-003, 3.018095e-003, 3.014648e-003, 3.011204e-003, 3.007763e-003, 3.004324e-003, 3.000888e-003, 2.997455e-003, 2.994024e-003, 2.990596e-003, 2.987170e-003, 2.983747e-003, 2.980326e-003, 2.976909e-003, 2.973493e-003, 2.970081e-003, 2.966671e-003, 2.963264e-003, 2.959859e-003, 2.956457e-003, 2.953057e-003, 2.949660e-003, 2.946266e-003, 2.942874e-003, 2.939485e-003, 2.936099e-003, 2.932715e-003, 
2.929333e-003, 2.925955e-003, 2.922579e-003, 2.919205e-003, 2.915834e-003, 2.912466e-003, 2.909100e-003, 2.905737e-003, 2.902376e-003, 2.899019e-003, 2.895663e-003, 2.892310e-003, 2.888960e-003, 2.885613e-003, 2.882268e-003, 2.878925e-003, 2.875585e-003, 2.872248e-003, 2.868914e-003, 2.865581e-003, 2.862252e-003, 2.858925e-003, 2.855601e-003, 2.852279e-003, 2.848960e-003, 2.845643e-003, 2.842329e-003, 2.839018e-003, 2.835709e-003, 2.832403e-003, 2.829099e-003, 2.825798e-003, 2.822499e-003, 2.819203e-003, 2.815910e-003, 2.812619e-003, 2.809330e-003, 2.806045e-003, 2.802761e-003, 2.799481e-003, 2.796203e-003, 2.792927e-003, 2.789654e-003, 2.786384e-003, 2.783116e-003, 2.779851e-003, 2.776588e-003, 2.773328e-003, 2.770070e-003, 2.766815e-003, 2.763563e-003, 2.760313e-003, 2.757065e-003, 2.753820e-003, 2.750578e-003, 2.747338e-003, 2.744101e-003, 2.740866e-003, 2.737634e-003, 2.734404e-003, 2.731177e-003, 2.727953e-003, 2.724731e-003, 2.721511e-003, 2.718294e-003, 2.715080e-003, 2.711868e-003, 2.708659e-003, 2.705452e-003, 2.702248e-003, 2.699046e-003, 2.695847e-003, 2.692650e-003, 2.689456e-003, 2.686265e-003, 2.683076e-003, 2.679889e-003, 2.676705e-003, 2.673523e-003, 2.670344e-003, 2.667168e-003, 2.663994e-003, 2.660823e-003, 2.657654e-003, 2.654487e-003, 2.651323e-003, 2.648162e-003, 2.645003e-003, 2.641847e-003, 2.638693e-003, 2.635542e-003, 2.632393e-003, 2.629247e-003, 2.626103e-003, 2.622962e-003, 2.619823e-003, 2.616687e-003, 2.613553e-003, 2.610422e-003, 2.607293e-003, 
2.604167e-003, 2.601043e-003, 2.597922e-003, 2.594803e-003, 2.591687e-003, 2.588573e-003, 2.585462e-003, 2.582353e-003, 2.579247e-003, 2.576143e-003, 2.573042e-003, 2.569943e-003, 2.566846e-003, 2.563753e-003, 2.560661e-003, 2.557572e-003, 2.554486e-003, 2.551402e-003, 2.548321e-003, 2.545242e-003, 2.542165e-003, 2.539091e-003, 2.536020e-003, 2.532951e-003, 2.529884e-003, 2.526820e-003, 2.523759e-003, 2.520700e-003, 2.517643e-003, 2.514589e-003, 2.511537e-003, 2.508488e-003, 2.505441e-003, 2.502397e-003, 2.499355e-003, 2.496316e-003, 2.493279e-003, 2.490244e-003, 2.487213e-003, 2.484183e-003, 2.481156e-003, 2.478131e-003, 2.475109e-003, 2.472090e-003, 2.469072e-003, 2.466058e-003, 2.463045e-003, 2.460036e-003, 2.457028e-003, 2.454023e-003, 2.451021e-003, 2.448021e-003, 2.445023e-003, 2.442028e-003, 2.439035e-003, 2.436045e-003, 2.433057e-003, 2.430072e-003, 2.427089e-003, 2.424109e-003, 2.421131e-003, 2.418155e-003, 2.415182e-003, 2.412211e-003, 2.409243e-003, 2.406277e-003, 2.403314e-003, 2.400353e-003, 2.397394e-003, 2.394438e-003, 2.391484e-003, 2.388533e-003, 2.385584e-003, 2.382638e-003, 2.379694e-003, 2.376753e-003, 2.373814e-003, 2.370877e-003, 2.367943e-003, 2.365011e-003, 2.362081e-003, 2.359154e-003, 2.356230e-003, 2.353308e-003, 2.350388e-003, 2.347471e-003, 2.344556e-003, 2.341643e-003, 2.338733e-003, 2.335825e-003, 2.332920e-003, 2.330017e-003, 2.327117e-003, 2.324219e-003, 2.321323e-003, 2.318430e-003, 2.315539e-003, 2.312651e-003, 2.309765e-003, 2.306881e-003, 
2.304000e-003, 2.301121e-003, 2.298245e-003, 2.295371e-003, 2.292499e-003, 2.289630e-003, 2.286763e-003, 2.283899e-003, 2.281037e-003, 2.278177e-003, 2.275320e-003, 2.272465e-003, 2.269613e-003, 2.266762e-003, 2.263915e-003, 2.261069e-003, 2.258227e-003, 2.255386e-003, 2.252548e-003, 2.249712e-003, 2.246879e-003, 2.244048e-003, 2.241219e-003, 2.238393e-003, 2.235569e-003, 2.232747e-003, 2.229928e-003, 2.227112e-003, 2.224297e-003, 2.221485e-003, 2.218676e-003, 2.215868e-003, 2.213063e-003, 2.210261e-003, 2.207461e-003, 2.204663e-003, 2.201867e-003, 2.199074e-003, 2.196284e-003, 2.193495e-003, 2.190709e-003, 2.187926e-003, 2.185144e-003, 2.182366e-003, 2.179589e-003, 2.176815e-003, 2.174043e-003, 2.171273e-003, 2.168506e-003, 2.165742e-003, 2.162979e-003, 2.160219e-003, 2.157461e-003, 2.154706e-003, 2.151953e-003, 2.149202e-003, 2.146454e-003, 2.143708e-003, 2.140964e-003, 2.138223e-003, 2.135484e-003, 2.132747e-003, 2.130013e-003, 2.127281e-003, 2.124552e-003, 2.121824e-003, 2.119099e-003, 2.116377e-003, 2.113656e-003, 2.110938e-003, 2.108223e-003, 2.105510e-003, 2.102799e-003, 2.100090e-003, 2.097384e-003, 2.094680e-003, 2.091978e-003, 2.089279e-003, 2.086582e-003, 2.083887e-003, 2.081195e-003, 2.078505e-003, 2.075817e-003, 2.073132e-003, 2.070448e-003, 2.067768e-003, 2.065089e-003, 2.062413e-003, 2.059739e-003, 2.057068e-003, 2.054398e-003, 2.051732e-003, 2.049067e-003, 2.046405e-003, 2.043745e-003, 2.041087e-003, 2.038432e-003, 2.035779e-003, 2.033128e-003, 2.030479e-003, 
2.027833e-003, 2.025189e-003, 2.022548e-003, 2.019909e-003, 2.017272e-003, 2.014637e-003, 2.012005e-003, 2.009375e-003, 2.006747e-003, 2.004121e-003, 2.001498e-003, 1.998877e-003, 1.996259e-003, 1.993642e-003, 1.991028e-003, 1.988417e-003, 1.985807e-003, 1.983200e-003, 1.980595e-003, 1.977992e-003, 1.975392e-003, 1.972794e-003, 1.970198e-003, 1.967605e-003, 1.965013e-003, 1.962424e-003, 1.959838e-003, 1.957253e-003, 1.954671e-003, 1.952091e-003, 1.949514e-003, 1.946939e-003, 1.944365e-003, 1.941795e-003, 1.939226e-003, 1.936660e-003, 1.934096e-003, 1.931534e-003, 1.928975e-003, 1.926418e-003, 1.923863e-003, 1.921310e-003, 1.918760e-003, 1.916211e-003, 1.913666e-003, 1.911122e-003, 1.908581e-003, 1.906041e-003, 1.903505e-003, 1.900970e-003, 1.898437e-003, 1.895907e-003, 1.893379e-003, 1.890854e-003, 1.888330e-003, 1.885809e-003, 1.883290e-003, 1.880774e-003, 1.878259e-003, 1.875747e-003, 1.873237e-003, 1.870730e-003, 1.868224e-003, 1.865721e-003, 1.863220e-003, 1.860721e-003, 1.858225e-003, 1.855731e-003, 1.853239e-003, 1.850749e-003, 1.848261e-003, 1.845776e-003, 1.843293e-003, 1.840812e-003, 1.838333e-003, 1.835857e-003, 1.833383e-003, 1.830911e-003, 1.828441e-003, 1.825973e-003, 1.823508e-003, 1.821045e-003, 1.818584e-003, 1.816125e-003, 1.813669e-003, 1.811215e-003, 1.808763e-003, 1.806313e-003, 1.803865e-003, 1.801420e-003, 1.798977e-003, 1.796536e-003, 1.794097e-003, 1.791661e-003, 1.789226e-003, 1.786794e-003, 1.784364e-003, 1.781937e-003, 1.779511e-003, 1.777088e-003, 
1.774667e-003, 1.772248e-003, 1.769831e-003, 1.767417e-003, 1.765004e-003, 1.762594e-003, 1.760186e-003, 1.757781e-003, 1.755377e-003, 1.752976e-003, 1.750576e-003, 1.748180e-003, 1.745785e-003, 1.743392e-003, 1.741002e-003, 1.738614e-003, 1.736228e-003, 1.733844e-003, 1.731462e-003, 1.729083e-003, 1.726705e-003, 1.724330e-003, 1.721957e-003, 1.719587e-003, 1.717218e-003, 1.714852e-003, 1.712487e-003, 1.710125e-003, 1.707765e-003, 1.705408e-003, 1.703052e-003, 1.700699e-003, 1.698348e-003, 1.695999e-003, 1.693652e-003, 1.691307e-003, 1.688964e-003, 1.686624e-003, 1.684286e-003, 1.681950e-003, 1.679616e-003, 1.677284e-003, 1.674955e-003, 1.672627e-003, 1.670302e-003, 1.667979e-003, 1.665658e-003, 1.663339e-003, 1.661023e-003, 1.658708e-003, 1.656396e-003, 1.654086e-003, 1.651778e-003, 1.649472e-003, 1.647168e-003, 1.644866e-003, 1.642567e-003, 1.640270e-003, 1.637975e-003, 1.635682e-003, 1.633391e-003, 1.631102e-003, 1.628815e-003, 1.626531e-003, 1.624249e-003, 1.621968e-003, 1.619690e-003, 1.617414e-003, 1.615141e-003, 1.612869e-003, 1.610599e-003, 1.608332e-003, 1.606067e-003, 1.603804e-003, 1.601543e-003, 1.599284e-003, 1.597027e-003, 1.594772e-003, 1.592520e-003, 1.590270e-003, 1.588021e-003, 1.585775e-003, 1.583531e-003, 1.581289e-003, 1.579049e-003, 1.576812e-003, 1.574576e-003, 1.572343e-003, 1.570111e-003, 1.567882e-003, 1.565655e-003, 1.563430e-003, 1.561207e-003, 1.558987e-003, 1.556768e-003, 1.554551e-003, 1.552337e-003, 1.550124e-003, 1.547914e-003, 1.545706e-003, 
1.543500e-003, 1.541296e-003, 1.539094e-003, 1.536894e-003, 1.534697e-003, 1.532501e-003, 1.530308e-003, 1.528116e-003, 1.525927e-003, 1.523740e-003, 1.521555e-003, 1.519372e-003, 1.517191e-003, 1.515012e-003, 1.512835e-003, 1.510661e-003, 1.508488e-003, 1.506318e-003, 1.504149e-003, 1.501983e-003, 1.499819e-003, 1.497657e-003, 1.495496e-003, 1.493338e-003, 1.491182e-003, 1.489029e-003, 1.486877e-003, 1.484727e-003, 1.482580e-003, 1.480434e-003, 1.478290e-003, 1.476149e-003, 1.474010e-003, 1.471872e-003, 1.469737e-003, 1.467604e-003, 1.465473e-003, 1.463344e-003, 1.461217e-003, 1.459092e-003, 1.456969e-003, 1.454849e-003, 1.452730e-003, 1.450613e-003, 1.448499e-003, 1.446386e-003, 1.444276e-003, 1.442167e-003, 1.440061e-003, 1.437956e-003, 1.435854e-003, 1.433754e-003, 1.431656e-003, 1.429560e-003, 1.427466e-003, 1.425374e-003, 1.423284e-003, 1.421196e-003, 1.419110e-003, 1.417026e-003, 1.414944e-003, 1.412864e-003, 1.410786e-003, 1.408711e-003, 1.406637e-003, 1.404565e-003, 1.402496e-003, 1.400428e-003, 1.398363e-003, 1.396299e-003, 1.394238e-003, 1.392178e-003, 1.390121e-003, 1.388066e-003, 1.386012e-003, 1.383961e-003, 1.381912e-003, 1.379864e-003, 1.377819e-003, 1.375776e-003, 1.373735e-003, 1.371695e-003, 1.369658e-003, 1.367623e-003, 1.365590e-003, 1.363559e-003, 1.361530e-003, 1.359503e-003, 1.357478e-003, 1.355455e-003, 1.353433e-003, 1.351414e-003, 1.349397e-003, 1.347382e-003, 1.345369e-003, 1.343358e-003, 1.341349e-003, 1.339342e-003, 1.337337e-003, 1.335334e-003, 
1.333333e-003, 1.331334e-003, 1.329337e-003, 1.327342e-003, 1.325349e-003, 1.323358e-003, 1.321369e-003, 1.319382e-003, 1.317397e-003, 1.315414e-003, 1.313433e-003, 1.311454e-003, 1.309477e-003, 1.307502e-003, 1.305529e-003, 1.303558e-003, 1.301589e-003, 1.299622e-003, 1.297656e-003, 1.295693e-003, 1.293732e-003, 1.291773e-003, 1.289816e-003, 1.287860e-003, 1.285907e-003, 1.283956e-003, 1.282006e-003, 1.280059e-003, 1.278114e-003, 1.276170e-003, 1.274229e-003, 1.272289e-003, 1.270352e-003, 1.268416e-003, 1.266483e-003, 1.264551e-003, 1.262622e-003, 1.260694e-003, 1.258768e-003, 1.256844e-003, 1.254923e-003, 1.253003e-003, 1.251085e-003, 1.249169e-003, 1.247255e-003, 1.245343e-003, 1.243433e-003, 1.241525e-003, 1.239619e-003, 1.237715e-003, 1.235812e-003, 1.233912e-003, 1.232014e-003, 1.230118e-003, 1.228223e-003, 1.226331e-003, 1.224440e-003, 1.222551e-003, 1.220665e-003, 1.218780e-003, 1.216897e-003, 1.215017e-003, 1.213138e-003, 1.211261e-003, 1.209386e-003, 1.207513e-003, 1.205641e-003, 1.203772e-003, 1.201905e-003, 1.200040e-003, 1.198176e-003, 1.196315e-003, 1.194455e-003, 1.192597e-003, 1.190742e-003, 1.188888e-003, 1.187036e-003, 1.185186e-003, 1.183338e-003, 1.181492e-003, 1.179648e-003, 1.177806e-003, 1.175965e-003, 1.174127e-003, 1.172291e-003, 1.170456e-003, 1.168623e-003, 1.166793e-003, 1.164964e-003, 1.163137e-003, 1.161312e-003, 1.159489e-003, 1.157668e-003, 1.155848e-003, 1.154031e-003, 1.152215e-003, 1.150402e-003, 1.148590e-003, 1.146780e-003, 1.144973e-003, 
1.143167e-003, 1.141363e-003, 1.139560e-003, 1.137760e-003, 1.135962e-003, 1.134165e-003, 1.132371e-003, 1.130578e-003, 1.128787e-003, 1.126998e-003, 1.125211e-003, 1.123426e-003, 1.121643e-003, 1.119862e-003, 1.118082e-003, 1.116305e-003, 1.114529e-003, 1.112755e-003, 1.110983e-003, 1.109213e-003, 1.107445e-003, 1.105679e-003, 1.103915e-003, 1.102152e-003, 1.100392e-003, 1.098633e-003, 1.096876e-003, 1.095121e-003, 1.093368e-003, 1.091617e-003, 1.089867e-003, 1.088120e-003, 1.086374e-003, 1.084630e-003, 1.082888e-003, 1.081148e-003, 1.079410e-003, 1.077674e-003, 1.075939e-003, 1.074207e-003, 1.072476e-003, 1.070747e-003, 1.069020e-003, 1.067295e-003, 1.065572e-003, 1.063850e-003, 1.062131e-003, 1.060413e-003, 1.058697e-003, 1.056983e-003, 1.055271e-003, 1.053561e-003, 1.051852e-003, 1.050145e-003, 1.048441e-003, 1.046738e-003, 1.045037e-003, 1.043337e-003, 1.041640e-003, 1.039944e-003, 1.038251e-003, 1.036559e-003, 1.034869e-003, 1.033181e-003, 1.031494e-003, 1.029810e-003, 1.028127e-003, 1.026446e-003, 1.024767e-003, 1.023090e-003, 1.021415e-003, 1.019741e-003, 1.018069e-003, 1.016399e-003, 1.014731e-003, 1.013065e-003, 1.011401e-003, 1.009738e-003, 1.008077e-003, 1.006418e-003, 1.004761e-003, 1.003106e-003, 1.001453e-003, 9.998009e-004, 9.981511e-004, 9.965031e-004, 9.948569e-004, 9.932125e-004, 9.915699e-004, 9.899291e-004, 9.882902e-004, 9.866530e-004, 9.850177e-004, 9.833842e-004, 9.817524e-004, 9.801225e-004, 9.784944e-004, 9.768681e-004, 9.752436e-004, 9.736209e-004, 
9.720000e-004, 9.703809e-004, 9.687636e-004, 9.671481e-004, 9.655344e-004, 9.639225e-004, 9.623124e-004, 9.607040e-004, 9.590975e-004, 9.574928e-004, 9.558898e-004, 9.542887e-004, 9.526893e-004, 9.510917e-004, 9.494959e-004, 9.479019e-004, 9.463097e-004, 9.447193e-004, 9.431306e-004, 9.415438e-004, 9.399587e-004, 9.383754e-004, 9.367938e-004, 9.352141e-004, 9.336361e-004, 9.320599e-004, 9.304855e-004, 9.289128e-004, 9.273419e-004, 9.257728e-004, 9.242055e-004, 9.226399e-004, 9.210761e-004, 9.195141e-004, 9.179538e-004, 9.163954e-004, 9.148386e-004, 9.132837e-004, 9.117305e-004, 9.101790e-004, 9.086293e-004, 9.070814e-004, 9.055353e-004, 9.039908e-004, 9.024482e-004, 9.009073e-004, 8.993682e-004, 8.978308e-004, 8.962952e-004, 8.947613e-004, 8.932292e-004, 8.916988e-004, 8.901702e-004, 8.886433e-004, 8.871182e-004, 8.855948e-004, 8.840731e-004, 8.825532e-004, 8.810351e-004, 8.795187e-004, 8.780040e-004, 8.764911e-004, 8.749799e-004, 8.734704e-004, 8.719627e-004, 8.704567e-004, 8.689525e-004, 8.674500e-004, 8.659492e-004, 8.644501e-004, 8.629528e-004, 8.614572e-004, 8.599634e-004, 8.584713e-004, 8.569809e-004, 8.554922e-004, 8.540052e-004, 8.525200e-004, 8.510365e-004, 8.495547e-004, 8.480747e-004, 8.465963e-004, 8.451197e-004, 8.436448e-004, 8.421716e-004, 8.407001e-004, 8.392304e-004, 8.377623e-004, 8.362960e-004, 8.348314e-004, 8.333685e-004, 8.319073e-004, 8.304478e-004, 8.289900e-004, 8.275340e-004, 8.260796e-004, 8.246269e-004, 8.231760e-004, 8.217267e-004, 8.202792e-004, 
8.188333e-004, 8.173892e-004, 8.159467e-004, 8.145060e-004, 8.130669e-004, 8.116296e-004, 8.101939e-004, 8.087599e-004, 8.073276e-004, 8.058971e-004, 8.044682e-004, 8.030410e-004, 8.016154e-004, 8.001916e-004, 7.987695e-004, 7.973490e-004, 7.959303e-004, 7.945132e-004, 7.930978e-004, 7.916840e-004, 7.902720e-004, 7.888616e-004, 7.874530e-004, 7.860460e-004, 7.846406e-004, 7.832370e-004, 7.818350e-004, 7.804347e-004, 7.790361e-004, 7.776391e-004, 7.762438e-004, 7.748502e-004, 7.734583e-004, 7.720680e-004, 7.706794e-004, 7.692924e-004, 7.679072e-004, 7.665235e-004, 7.651416e-004, 7.637613e-004, 7.623827e-004, 7.610057e-004, 7.596304e-004, 7.582567e-004, 7.568847e-004, 7.555144e-004, 7.541457e-004, 7.527787e-004, 7.514133e-004, 7.500496e-004, 7.486875e-004, 7.473271e-004, 7.459683e-004, 7.446112e-004, 7.432557e-004, 7.419019e-004, 7.405497e-004, 7.391991e-004, 7.378502e-004, 7.365030e-004, 7.351573e-004, 7.338134e-004, 7.324710e-004, 7.311303e-004, 7.297912e-004, 7.284538e-004, 7.271180e-004, 7.257839e-004, 7.244513e-004, 7.231204e-004, 7.217912e-004, 7.204635e-004, 7.191375e-004, 7.178131e-004, 7.164904e-004, 7.151693e-004, 7.138498e-004, 7.125319e-004, 7.112156e-004, 7.099010e-004, 7.085880e-004, 7.072766e-004, 7.059668e-004, 7.046587e-004, 7.033521e-004, 7.020472e-004, 7.007439e-004, 6.994422e-004, 6.981422e-004, 6.968437e-004, 6.955468e-004, 6.942516e-004, 6.929580e-004, 6.916659e-004, 6.903755e-004, 6.890867e-004, 6.877995e-004, 6.865139e-004, 6.852299e-004, 6.839475e-004, 
6.826667e-004, 6.813875e-004, 6.801099e-004, 6.788339e-004, 6.775595e-004, 6.762866e-004, 6.750154e-004, 6.737458e-004, 6.724778e-004, 6.712113e-004, 6.699465e-004, 6.686832e-004, 6.674216e-004, 6.661615e-004, 6.649030e-004, 6.636461e-004, 6.623908e-004, 6.611370e-004, 6.598849e-004, 6.586343e-004, 6.573853e-004, 6.561379e-004, 6.548921e-004, 6.536478e-004, 6.524052e-004, 6.511641e-004, 6.499245e-004, 6.486866e-004, 6.474502e-004, 6.462154e-004, 6.449822e-004, 6.437505e-004, 6.425204e-004, 6.412919e-004, 6.400649e-004, 6.388395e-004, 6.376157e-004, 6.363934e-004, 6.351727e-004, 6.339536e-004, 6.327360e-004, 6.315200e-004, 6.303055e-004, 6.290926e-004, 6.278813e-004, 6.266715e-004, 6.254632e-004, 6.242566e-004, 6.230514e-004, 6.218479e-004, 6.206458e-004, 6.194454e-004, 6.182464e-004, 6.170491e-004, 6.158532e-004, 6.146589e-004, 6.134662e-004, 6.122750e-004, 6.110853e-004, 6.098972e-004, 6.087107e-004, 6.075256e-004, 6.063421e-004, 6.051602e-004, 6.039798e-004, 6.028009e-004, 6.016236e-004, 6.004477e-004, 5.992735e-004, 5.981007e-004, 5.969295e-004, 5.957598e-004, 5.945917e-004, 5.934250e-004, 5.922599e-004, 5.910964e-004, 5.899343e-004, 5.887738e-004, 5.876148e-004, 5.864573e-004, 5.853013e-004, 5.841469e-004, 5.829940e-004, 5.818426e-004, 5.806927e-004, 5.795443e-004, 5.783975e-004, 5.772521e-004, 5.761083e-004, 5.749660e-004, 5.738252e-004, 5.726859e-004, 5.715481e-004, 5.704118e-004, 5.692770e-004, 5.681438e-004, 5.670120e-004, 5.658818e-004, 5.647530e-004, 5.636258e-004, 
5.625000e-004, 5.613757e-004, 5.602530e-004, 5.591317e-004, 5.580120e-004, 5.568937e-004, 5.557770e-004, 5.546617e-004, 5.535479e-004, 5.524356e-004, 5.513248e-004, 5.502155e-004, 5.491077e-004, 5.480014e-004, 5.468965e-004, 5.457932e-004, 5.446913e-004, 5.435909e-004, 5.424920e-004, 5.413946e-004, 5.402987e-004, 5.392042e-004, 5.381112e-004, 5.370197e-004, 5.359297e-004, 5.348411e-004, 5.337541e-004, 5.326685e-004, 5.315843e-004, 5.305017e-004, 5.294205e-004, 5.283408e-004, 5.272625e-004, 5.261858e-004, 5.251104e-004, 5.240366e-004, 5.229642e-004, 5.218933e-004, 5.208239e-004, 5.197559e-004, 5.186893e-004, 5.176243e-004, 5.165607e-004, 5.154985e-004, 5.144378e-004, 5.133786e-004, 5.123208e-004, 5.112644e-004, 5.102096e-004, 5.091561e-004, 5.081042e-004, 5.070536e-004, 5.060046e-004, 5.049569e-004, 5.039108e-004, 5.028660e-004, 5.018227e-004, 5.007809e-004, 4.997405e-004, 4.987015e-004, 4.976640e-004, 4.966279e-004, 4.955933e-004, 4.945601e-004, 4.935283e-004, 4.924980e-004, 4.914691e-004, 4.904416e-004, 4.894156e-004, 4.883910e-004, 4.873678e-004, 4.863461e-004, 4.853258e-004, 4.843069e-004, 4.832895e-004, 4.822734e-004, 4.812588e-004, 4.802457e-004, 4.792339e-004, 4.782236e-004, 4.772147e-004, 4.762072e-004, 4.752011e-004, 4.741965e-004, 4.731932e-004, 4.721914e-004, 4.711910e-004, 4.701920e-004, 4.691944e-004, 4.681983e-004, 4.672035e-004, 4.662102e-004, 4.652182e-004, 4.642277e-004, 4.632386e-004, 4.622509e-004, 4.612645e-004, 4.602796e-004, 4.592961e-004, 4.583140e-004, 
4.573333e-004, 4.563540e-004, 4.553761e-004, 4.543996e-004, 4.534245e-004, 4.524508e-004, 4.514785e-004, 4.505076e-004, 4.495380e-004, 4.485699e-004, 4.476032e-004, 4.466378e-004, 4.456738e-004, 4.447113e-004, 4.437501e-004, 4.427903e-004, 4.418319e-004, 4.408748e-004, 4.399192e-004, 4.389649e-004, 4.380120e-004, 4.370605e-004, 4.361104e-004, 4.351616e-004, 4.342142e-004, 4.332682e-004, 4.323236e-004, 4.313804e-004, 4.304385e-004, 4.294980e-004, 4.285588e-004, 4.276211e-004, 4.266847e-004, 4.257496e-004, 4.248160e-004, 4.238837e-004, 4.229528e-004, 4.220232e-004, 4.210950e-004, 4.201681e-004, 4.192427e-004, 4.183185e-004, 4.173958e-004, 4.164744e-004, 4.155543e-004, 4.146356e-004, 4.137183e-004, 4.128023e-004, 4.118877e-004, 4.109744e-004, 4.100625e-004, 4.091519e-004, 4.082427e-004, 4.073348e-004, 4.064283e-004, 4.055231e-004, 4.046193e-004, 4.037168e-004, 4.028156e-004, 4.019158e-004, 4.010173e-004, 4.001202e-004, 3.992244e-004, 3.983300e-004, 3.974368e-004, 3.965451e-004, 3.956546e-004, 3.947655e-004, 3.938777e-004, 3.929913e-004, 3.921062e-004, 3.912224e-004, 3.903399e-004, 3.894588e-004, 3.885790e-004, 3.877005e-004, 3.868234e-004, 3.859475e-004, 3.850730e-004, 3.841999e-004, 3.833280e-004, 3.824575e-004, 3.815882e-004, 3.807203e-004, 3.798537e-004, 3.789885e-004, 3.781245e-004, 3.772619e-004, 3.764006e-004, 3.755405e-004, 3.746818e-004, 3.738244e-004, 3.729684e-004, 3.721136e-004, 3.712601e-004, 3.704079e-004, 3.695571e-004, 3.687075e-004, 3.678593e-004, 3.670123e-004, 
3.661667e-004, 3.653223e-004, 3.644793e-004, 3.636375e-004, 3.627971e-004, 3.619579e-004, 3.611200e-004, 3.602835e-004, 3.594482e-004, 3.586142e-004, 3.577815e-004, 3.569501e-004, 3.561200e-004, 3.552912e-004, 3.544636e-004, 3.536374e-004, 3.528124e-004, 3.519887e-004, 3.511663e-004, 3.503452e-004, 3.495253e-004, 3.487068e-004, 3.478895e-004, 3.470735e-004, 3.462588e-004, 3.454453e-004, 3.446331e-004, 3.438222e-004, 3.430126e-004, 3.422043e-004, 3.413972e-004, 3.405914e-004, 3.397868e-004, 3.389835e-004, 3.381815e-004, 3.373808e-004, 3.365813e-004, 3.357831e-004, 3.349861e-004, 3.341904e-004, 3.333960e-004, 3.326028e-004, 3.318109e-004, 3.310203e-004, 3.302309e-004, 3.294427e-004, 3.286558e-004, 3.278702e-004, 3.270858e-004, 3.263027e-004, 3.255208e-004, 3.247402e-004, 3.239608e-004, 3.231827e-004, 3.224058e-004, 3.216302e-004, 3.208558e-004, 3.200827e-004, 3.193107e-004, 3.185401e-004, 3.177707e-004, 3.170025e-004, 3.162355e-004, 3.154698e-004, 3.147054e-004, 3.139421e-004, 3.131802e-004, 3.124194e-004, 3.116599e-004, 3.109016e-004, 3.101445e-004, 3.093887e-004, 3.086341e-004, 3.078807e-004, 3.071285e-004, 3.063776e-004, 3.056279e-004, 3.048794e-004, 3.041322e-004, 3.033861e-004, 3.026413e-004, 3.018977e-004, 3.011554e-004, 3.004142e-004, 2.996743e-004, 2.989356e-004, 2.981981e-004, 2.974618e-004, 2.967267e-004, 2.959928e-004, 2.952602e-004, 2.945287e-004, 2.937985e-004, 2.930695e-004, 2.923416e-004, 2.916150e-004, 2.908896e-004, 2.901654e-004, 2.894424e-004, 2.887206e-004, 
2.880000e-004, 2.872806e-004, 2.865624e-004, 2.858454e-004, 2.851296e-004, 2.844150e-004, 2.837016e-004, 2.829893e-004, 2.822783e-004, 2.815685e-004, 2.808598e-004, 2.801524e-004, 2.794461e-004, 2.787410e-004, 2.780371e-004, 2.773344e-004, 2.766329e-004, 2.759326e-004, 2.752334e-004, 2.745355e-004, 2.738387e-004, 2.731431e-004, 2.724486e-004, 2.717554e-004, 2.710633e-004, 2.703724e-004, 2.696827e-004, 2.689941e-004, 2.683067e-004, 2.676205e-004, 2.669355e-004, 2.662516e-004, 2.655689e-004, 2.648874e-004, 2.642070e-004, 2.635279e-004, 2.628498e-004, 2.621730e-004, 2.614973e-004, 2.608227e-004, 2.601493e-004, 2.594771e-004, 2.588061e-004, 2.581361e-004, 2.574674e-004, 2.567998e-004, 2.561334e-004, 2.554681e-004, 2.548040e-004, 2.541410e-004, 2.534792e-004, 2.528185e-004, 2.521590e-004, 2.515006e-004, 2.508434e-004, 2.501873e-004, 2.495323e-004, 2.488785e-004, 2.482259e-004, 2.475744e-004, 2.469240e-004, 2.462748e-004, 2.456267e-004, 2.449797e-004, 2.443339e-004, 2.436892e-004, 2.430457e-004, 2.424033e-004, 2.417620e-004, 2.411218e-004, 2.404828e-004, 2.398449e-004, 2.392082e-004, 2.385726e-004, 2.379381e-004, 2.373047e-004, 2.366724e-004, 2.360413e-004, 2.354113e-004, 2.347824e-004, 2.341547e-004, 2.335280e-004, 2.329025e-004, 2.322781e-004, 2.316548e-004, 2.310326e-004, 2.304116e-004, 2.297916e-004, 2.291728e-004, 2.285551e-004, 2.279385e-004, 2.273230e-004, 2.267086e-004, 2.260953e-004, 2.254832e-004, 2.248721e-004, 2.242621e-004, 2.236533e-004, 2.230455e-004, 2.224389e-004, 
2.218333e-004, 2.212289e-004, 2.206255e-004, 2.200233e-004, 2.194221e-004, 2.188221e-004, 2.182231e-004, 2.176252e-004, 2.170284e-004, 2.164328e-004, 2.158382e-004, 2.152447e-004, 2.146522e-004, 2.140609e-004, 2.134707e-004, 2.128815e-004, 2.122935e-004, 2.117065e-004, 2.111206e-004, 2.105357e-004, 2.099520e-004, 2.093693e-004, 2.087878e-004, 2.082073e-004, 2.076278e-004, 2.070495e-004, 2.064722e-004, 2.058960e-004, 2.053209e-004, 2.047468e-004, 2.041738e-004, 2.036019e-004, 2.030311e-004, 2.024613e-004, 2.018926e-004, 2.013249e-004, 2.007584e-004, 2.001928e-004, 1.996284e-004, 1.990650e-004, 1.985027e-004, 1.979414e-004, 1.973812e-004, 1.968220e-004, 1.962639e-004, 1.957069e-004, 1.951509e-004, 1.945960e-004, 1.940421e-004, 1.934893e-004, 1.929375e-004, 1.923868e-004, 1.918371e-004, 1.912885e-004, 1.907409e-004, 1.901944e-004, 1.896489e-004, 1.891044e-004, 1.885610e-004, 1.880187e-004, 1.874773e-004, 1.869371e-004, 1.863978e-004, 1.858596e-004, 1.853224e-004, 1.847863e-004, 1.842512e-004, 1.837172e-004, 1.831841e-004, 1.826521e-004, 1.821212e-004, 1.815912e-004, 1.810623e-004, 1.805344e-004, 1.800076e-004, 1.794818e-004, 1.789570e-004, 1.784332e-004, 1.779104e-004, 1.773887e-004, 1.768680e-004, 1.763483e-004, 1.758296e-004, 1.753120e-004, 1.747953e-004, 1.742797e-004, 1.737651e-004, 1.732515e-004, 1.727390e-004, 1.722274e-004, 1.717168e-004, 1.712073e-004, 1.706988e-004, 1.701912e-004, 1.696847e-004, 1.691792e-004, 1.686747e-004, 1.681712e-004, 1.676687e-004, 1.671672e-004, 
1.666667e-004, 1.661672e-004, 1.656687e-004, 1.651712e-004, 1.646747e-004, 1.641791e-004, 1.636846e-004, 1.631911e-004, 1.626986e-004, 1.622070e-004, 1.617165e-004, 1.612269e-004, 1.607384e-004, 1.602508e-004, 1.597642e-004, 1.592786e-004, 1.587940e-004, 1.583103e-004, 1.578277e-004, 1.573460e-004, 1.568653e-004, 1.563856e-004, 1.559069e-004, 1.554291e-004, 1.549524e-004, 1.544766e-004, 1.540017e-004, 1.535279e-004, 1.530550e-004, 1.525831e-004, 1.521122e-004, 1.516422e-004, 1.511732e-004, 1.507052e-004, 1.502381e-004, 1.497720e-004, 1.493069e-004, 1.488427e-004, 1.483795e-004, 1.479173e-004, 1.474560e-004, 1.469957e-004, 1.465363e-004, 1.460779e-004, 1.456205e-004, 1.451640e-004, 1.447084e-004, 1.442539e-004, 1.438002e-004, 1.433476e-004, 1.428958e-004, 1.424451e-004, 1.419952e-004, 1.415464e-004, 1.410984e-004, 1.406514e-004, 1.402054e-004, 1.397603e-004, 1.393161e-004, 1.388729e-004, 1.384307e-004, 1.379893e-004, 1.375489e-004, 1.371095e-004, 1.366710e-004, 1.362334e-004, 1.357968e-004, 1.353610e-004, 1.349263e-004, 1.344924e-004, 1.340595e-004, 1.336275e-004, 1.331965e-004, 1.327663e-004, 1.323371e-004, 1.319089e-004, 1.314815e-004, 1.310551e-004, 1.306296e-004, 1.302050e-004, 1.297813e-004, 1.293586e-004, 1.289368e-004, 1.285159e-004, 1.280959e-004, 1.276768e-004, 1.272587e-004, 1.268414e-004, 1.264251e-004, 1.260097e-004, 1.255952e-004, 1.251816e-004, 1.247689e-004, 1.243571e-004, 1.239462e-004, 1.235363e-004, 1.231272e-004, 1.227191e-004, 1.223118e-004, 1.219055e-004, 
1.215000e-004, 1.210954e-004, 1.206918e-004, 1.202890e-004, 1.198872e-004, 1.194862e-004, 1.190862e-004, 1.186870e-004, 1.182887e-004, 1.178913e-004, 1.174948e-004, 1.170992e-004, 1.167045e-004, 1.163107e-004, 1.159177e-004, 1.155257e-004, 1.151345e-004, 1.147442e-004, 1.143548e-004, 1.139663e-004, 1.135787e-004, 1.131919e-004, 1.128060e-004, 1.124210e-004, 1.120369e-004, 1.116536e-004, 1.112713e-004, 1.108898e-004, 1.105091e-004, 1.101294e-004, 1.097505e-004, 1.093725e-004, 1.089953e-004, 1.086191e-004, 1.082436e-004, 1.078691e-004, 1.074954e-004, 1.071226e-004, 1.067507e-004, 1.063796e-004, 1.060093e-004, 1.056400e-004, 1.052715e-004, 1.049038e-004, 1.045370e-004, 1.041711e-004, 1.038060e-004, 1.034417e-004, 1.030784e-004, 1.027158e-004, 1.023542e-004, 1.019933e-004, 1.016334e-004, 1.012742e-004, 1.009160e-004, 1.005585e-004, 1.002019e-004, 9.984618e-005, 9.949128e-005, 9.913722e-005, 9.878400e-005, 9.843162e-005, 9.808008e-005, 9.772938e-005, 9.737951e-005, 9.703048e-005, 9.668228e-005, 9.633492e-005, 9.598839e-005, 9.564270e-005, 9.529783e-005, 9.495380e-005, 9.461059e-005, 9.426821e-005, 9.392666e-005, 9.358594e-005, 9.324604e-005, 9.290696e-005, 9.256871e-005, 9.223128e-005, 9.189467e-005, 9.155888e-005, 9.122391e-005, 9.088975e-005, 9.055642e-005, 9.022390e-005, 8.989219e-005, 8.956130e-005, 8.923122e-005, 8.890196e-005, 8.857350e-005, 8.824585e-005, 8.791902e-005, 8.759299e-005, 8.726777e-005, 8.694335e-005, 8.661974e-005, 8.629694e-005, 8.597493e-005, 8.565373e-005, 
8.533333e-005, 8.501373e-005, 8.469493e-005, 8.437693e-005, 8.405972e-005, 8.374331e-005, 8.342770e-005, 8.311288e-005, 8.279885e-005, 8.248561e-005, 8.217317e-005, 8.186151e-005, 8.155065e-005, 8.124057e-005, 8.093128e-005, 8.062277e-005, 8.031505e-005, 8.000811e-005, 7.970196e-005, 7.939659e-005, 7.909200e-005, 7.878819e-005, 7.848516e-005, 7.818291e-005, 7.788143e-005, 7.758073e-005, 7.728080e-005, 7.698165e-005, 7.668327e-005, 7.638567e-005, 7.608883e-005, 7.579277e-005, 7.549747e-005, 7.520294e-005, 7.490918e-005, 7.461619e-005, 7.432396e-005, 7.403249e-005, 7.374179e-005, 7.345185e-005, 7.316267e-005, 7.287425e-005, 7.258659e-005, 7.229968e-005, 7.201354e-005, 7.172815e-005, 7.144351e-005, 7.115963e-005, 7.087650e-005, 7.059413e-005, 7.031250e-005, 7.003162e-005, 6.975150e-005, 6.947212e-005, 6.919349e-005, 6.891560e-005, 6.863846e-005, 6.836207e-005, 6.808641e-005, 6.781150e-005, 6.753733e-005, 6.726390e-005, 6.699121e-005, 6.671926e-005, 6.644804e-005, 6.617756e-005, 6.590782e-005, 6.563881e-005, 6.537053e-005, 6.510298e-005, 6.483617e-005, 6.457008e-005, 6.430473e-005, 6.404010e-005, 6.377620e-005, 6.351302e-005, 6.325057e-005, 6.298884e-005, 6.272784e-005, 6.246756e-005, 6.220800e-005, 6.194916e-005, 6.169104e-005, 6.143364e-005, 6.117695e-005, 6.092098e-005, 6.066572e-005, 6.041118e-005, 6.015735e-005, 5.990424e-005, 5.965183e-005, 5.940014e-005, 5.914915e-005, 5.889887e-005, 5.864930e-005, 5.840044e-005, 5.815228e-005, 5.790482e-005, 5.765807e-005, 5.741202e-005, 
5.716667e-005, 5.692202e-005, 5.667807e-005, 5.643481e-005, 5.619226e-005, 5.595040e-005, 5.570923e-005, 5.546876e-005, 5.522898e-005, 5.498990e-005, 5.475150e-005, 5.451379e-005, 5.427678e-005, 5.404045e-005, 5.380481e-005, 5.356985e-005, 5.333558e-005, 5.310200e-005, 5.286909e-005, 5.263687e-005, 5.240533e-005, 5.217447e-005, 5.194429e-005, 5.171479e-005, 5.148596e-005, 5.125781e-005, 5.103034e-005, 5.080354e-005, 5.057741e-005, 5.035195e-005, 5.012717e-005, 4.990305e-005, 4.967961e-005, 4.945683e-005, 4.923472e-005, 4.901327e-005, 4.879249e-005, 4.857237e-005, 4.835292e-005, 4.813413e-005, 4.791600e-005, 4.769853e-005, 4.748172e-005, 4.726557e-005, 4.705007e-005, 4.683523e-005, 4.662104e-005, 4.640751e-005, 4.619463e-005, 4.598241e-005, 4.577083e-005, 4.555991e-005, 4.534963e-005, 4.514000e-005, 4.493102e-005, 4.472269e-005, 4.451500e-005, 4.430795e-005, 4.410155e-005, 4.389579e-005, 4.369067e-005, 4.348619e-005, 4.328235e-005, 4.307914e-005, 4.287658e-005, 4.267465e-005, 4.247335e-005, 4.227269e-005, 4.207266e-005, 4.187327e-005, 4.167450e-005, 4.147636e-005, 4.127886e-005, 4.108198e-005, 4.088573e-005, 4.069010e-005, 4.049510e-005, 4.030073e-005, 4.010697e-005, 3.991384e-005, 3.972133e-005, 3.952944e-005, 3.933817e-005, 3.914752e-005, 3.895748e-005, 3.876806e-005, 3.857926e-005, 3.839107e-005, 3.820349e-005, 3.801652e-005, 3.783017e-005, 3.764442e-005, 3.745929e-005, 3.727476e-005, 3.709084e-005, 3.690752e-005, 3.672481e-005, 3.654270e-005, 3.636120e-005, 3.618030e-005, 
3.600000e-005, 3.582030e-005, 3.564120e-005, 3.546270e-005, 3.528479e-005, 3.510748e-005, 3.493076e-005, 3.475464e-005, 3.457911e-005, 3.440418e-005, 3.422983e-005, 3.405608e-005, 3.388291e-005, 3.371033e-005, 3.353834e-005, 3.336694e-005, 3.319612e-005, 3.302588e-005, 3.285623e-005, 3.268716e-005, 3.251867e-005, 3.235076e-005, 3.218343e-005, 3.201667e-005, 3.185050e-005, 3.168490e-005, 3.151987e-005, 3.135542e-005, 3.119154e-005, 3.102824e-005, 3.086550e-005, 3.070333e-005, 3.054174e-005, 3.038071e-005, 3.022025e-005, 3.006035e-005, 2.990102e-005, 2.974226e-005, 2.958405e-005, 2.942641e-005, 2.926933e-005, 2.911281e-005, 2.895685e-005, 2.880145e-005, 2.864660e-005, 2.849231e-005, 2.833858e-005, 2.818540e-005, 2.803277e-005, 2.788069e-005, 2.772917e-005, 2.757819e-005, 2.742777e-005, 2.727789e-005, 2.712856e-005, 2.697977e-005, 2.683153e-005, 2.668383e-005, 2.653668e-005, 2.639007e-005, 2.624400e-005, 2.609847e-005, 2.595348e-005, 2.580903e-005, 2.566511e-005, 2.552173e-005, 2.537888e-005, 2.523657e-005, 2.509479e-005, 2.495355e-005, 2.481283e-005, 2.467265e-005, 2.453299e-005, 2.439386e-005, 2.425526e-005, 2.411719e-005, 2.397964e-005, 2.384261e-005, 2.370611e-005, 2.357013e-005, 2.343467e-005, 2.329973e-005, 2.316531e-005, 2.303140e-005, 2.289802e-005, 2.276515e-005, 2.263279e-005, 2.250095e-005, 2.236962e-005, 2.223881e-005, 2.210850e-005, 2.197870e-005, 2.184942e-005, 2.172064e-005, 2.159237e-005, 2.146460e-005, 2.133734e-005, 2.121059e-005, 2.108433e-005, 2.095858e-005, 
2.083333e-005, 2.070858e-005, 2.058433e-005, 2.046058e-005, 2.033732e-005, 2.021456e-005, 2.009230e-005, 1.997053e-005, 1.984925e-005, 1.972846e-005, 1.960817e-005, 1.948836e-005, 1.936905e-005, 1.925022e-005, 1.913188e-005, 1.901402e-005, 1.889665e-005, 1.877976e-005, 1.866336e-005, 1.854744e-005, 1.843200e-005, 1.831704e-005, 1.820256e-005, 1.808856e-005, 1.797503e-005, 1.786198e-005, 1.774940e-005, 1.763730e-005, 1.752567e-005, 1.741452e-005, 1.730383e-005, 1.719362e-005, 1.708387e-005, 1.697459e-005, 1.686578e-005, 1.675744e-005, 1.664956e-005, 1.654214e-005, 1.643519e-005, 1.632870e-005, 1.622267e-005, 1.611710e-005, 1.601199e-005, 1.590733e-005, 1.580314e-005, 1.569940e-005, 1.559611e-005, 1.549328e-005, 1.539090e-005, 1.528898e-005, 1.518750e-005, 1.508647e-005, 1.498590e-005, 1.488577e-005, 1.478609e-005, 1.468685e-005, 1.458806e-005, 1.448972e-005, 1.439181e-005, 1.429435e-005, 1.419733e-005, 1.410075e-005, 1.400461e-005, 1.390891e-005, 1.381364e-005, 1.371881e-005, 1.362442e-005, 1.353046e-005, 1.343693e-005, 1.334383e-005, 1.325117e-005, 1.315893e-005, 1.306713e-005, 1.297575e-005, 1.288480e-005, 1.279427e-005, 1.270417e-005, 1.261449e-005, 1.252524e-005, 1.243641e-005, 1.234800e-005, 1.226001e-005, 1.217244e-005, 1.208529e-005, 1.199855e-005, 1.191223e-005, 1.182632e-005, 1.174083e-005, 1.165575e-005, 1.157109e-005, 1.148683e-005, 1.140299e-005, 1.131955e-005, 1.123652e-005, 1.115390e-005, 1.107169e-005, 1.098988e-005, 1.090847e-005, 1.082747e-005, 1.074687e-005, 
1.066667e-005, 1.058687e-005, 1.050747e-005, 1.042846e-005, 1.034986e-005, 1.027165e-005, 1.019383e-005, 1.011641e-005, 1.003938e-005, 9.962745e-006, 9.886500e-006, 9.810645e-006, 9.735179e-006, 9.660100e-006, 9.585409e-006, 9.511104e-006, 9.437184e-006, 9.363648e-006, 9.290495e-006, 9.217724e-006, 9.145333e-006, 9.073323e-006, 9.001692e-006, 8.930439e-006, 8.859563e-006, 8.789062e-006, 8.718937e-006, 8.649186e-006, 8.579808e-006, 8.510802e-006, 8.442167e-006, 8.373902e-006, 8.306005e-006, 8.238477e-006, 8.171316e-006, 8.104521e-006, 8.038091e-006, 7.972024e-006, 7.906321e-006, 7.840980e-006, 7.776000e-006, 7.711380e-006, 7.647119e-006, 7.583215e-006, 7.519669e-006, 7.456479e-006, 7.393644e-006, 7.331163e-006, 7.269035e-006, 7.207259e-006, 7.145833e-006, 7.084758e-006, 7.024032e-006, 6.963654e-006, 6.903623e-006, 6.843937e-006, 6.784597e-006, 6.725601e-006, 6.666948e-006, 6.608637e-006, 6.550667e-006, 6.493037e-006, 6.435745e-006, 6.378792e-006, 6.322176e-006, 6.265896e-006, 6.209951e-006, 6.154339e-006, 6.099061e-006, 6.044115e-006, 5.989500e-006, 5.935215e-006, 5.881259e-006, 5.827630e-006, 5.774329e-006, 5.721354e-006, 5.668704e-006, 5.616378e-006, 5.564375e-006, 5.512694e-006, 5.461333e-006, 5.410293e-006, 5.359572e-006, 5.309169e-006, 5.259083e-006, 5.209312e-006, 5.159857e-006, 5.110716e-006, 5.061888e-006, 5.013372e-006, 4.965167e-006, 4.917272e-006, 4.869685e-006, 4.822407e-006, 4.775436e-006, 4.728771e-006, 4.682411e-006, 4.636354e-006, 4.590601e-006, 4.545150e-006, 
4.500000e-006, 4.455150e-006, 4.410599e-006, 4.366345e-006, 4.322389e-006, 4.278729e-006, 4.235364e-006, 4.192293e-006, 4.149515e-006, 4.107029e-006, 4.064833e-006, 4.022928e-006, 3.981312e-006, 3.939984e-006, 3.898943e-006, 3.858187e-006, 3.817717e-006, 3.777531e-006, 3.737628e-006, 3.698007e-006, 3.658667e-006, 3.619607e-006, 3.580825e-006, 3.542322e-006, 3.504096e-006, 3.466146e-006, 3.428471e-006, 3.391069e-006, 3.353941e-006, 3.317085e-006, 3.280500e-006, 3.244185e-006, 3.208139e-006, 3.172360e-006, 3.136849e-006, 3.101604e-006, 3.066624e-006, 3.031908e-006, 2.997455e-006, 2.963264e-006, 2.929333e-006, 2.895663e-006, 2.862252e-006, 2.829099e-006, 2.796203e-006, 2.763562e-006, 2.731177e-006, 2.699046e-006, 2.667168e-006, 2.635542e-006, 2.604167e-006, 2.573042e-006, 2.542165e-006, 2.511537e-006, 2.481156e-006, 2.451021e-006, 2.421131e-006, 2.391484e-006, 2.362081e-006, 2.332920e-006, 2.304000e-006, 2.275320e-006, 2.246879e-006, 2.218676e-006, 2.190709e-006, 2.162979e-006, 2.135484e-006, 2.108223e-006, 2.081195e-006, 2.054399e-006, 2.027833e-006, 2.001498e-006, 1.975392e-006, 1.949514e-006, 1.923863e-006, 1.898437e-006, 1.873237e-006, 1.848261e-006, 1.823508e-006, 1.798977e-006, 1.774667e-006, 1.750577e-006, 1.726705e-006, 1.703052e-006, 1.679616e-006, 1.656396e-006, 1.633391e-006, 1.610599e-006, 1.588021e-006, 1.565655e-006, 1.543500e-006, 1.521555e-006, 1.499819e-006, 1.478291e-006, 1.456969e-006, 1.435854e-006, 1.414944e-006, 1.394238e-006, 1.373735e-006, 1.353434e-006, 
1.333333e-006, 1.313433e-006, 1.293732e-006, 1.274229e-006, 1.254923e-006, 1.235812e-006, 1.216897e-006, 1.198176e-006, 1.179648e-006, 1.161312e-006, 1.143167e-006, 1.125212e-006, 1.107445e-006, 1.089867e-006, 1.072476e-006, 1.055271e-006, 1.038251e-006, 1.021414e-006, 1.004761e-006, 9.882902e-007, 9.720000e-007, 9.558898e-007, 9.399587e-007, 9.242055e-007, 9.086293e-007, 8.932292e-007, 8.780040e-007, 8.629528e-007, 8.480747e-007, 8.333685e-007, 8.188333e-007, 8.044682e-007, 7.902720e-007, 7.762438e-007, 7.623827e-007, 7.486875e-007, 7.351573e-007, 7.217912e-007, 7.085880e-007, 6.955468e-007, 6.826667e-007, 6.699465e-007, 6.573853e-007, 6.449822e-007, 6.327360e-007, 6.206458e-007, 6.087107e-007, 5.969295e-007, 5.853013e-007, 5.738252e-007, 5.625000e-007, 5.513248e-007, 5.402987e-007, 5.294205e-007, 5.186893e-007, 5.081042e-007, 4.976640e-007, 4.873678e-007, 4.772147e-007, 4.672035e-007, 4.573333e-007, 4.476032e-007, 4.380120e-007, 4.285588e-007, 4.192427e-007, 4.100625e-007, 4.010173e-007, 3.921062e-007, 3.833280e-007, 3.746818e-007, 3.661667e-007, 3.577815e-007, 3.495253e-007, 3.413972e-007, 3.333960e-007, 3.255208e-007, 3.177707e-007, 3.101445e-007, 3.026413e-007, 2.952602e-007, 2.880000e-007, 2.808598e-007, 2.738387e-007, 2.669355e-007, 2.601493e-007, 2.534792e-007, 2.469240e-007, 2.404828e-007, 2.341547e-007, 2.279385e-007, 2.218333e-007, 2.158382e-007, 2.099520e-007, 2.041738e-007, 1.985027e-007, 1.929375e-007, 1.874773e-007, 1.821212e-007, 1.768680e-007, 1.717168e-007, 
1.666667e-007, 1.617165e-007, 1.568653e-007, 1.521122e-007, 1.474560e-007, 1.428958e-007, 1.384307e-007, 1.340595e-007, 1.297813e-007, 1.255952e-007, 1.215000e-007, 1.174948e-007, 1.135787e-007, 1.097505e-007, 1.060093e-007, 1.023542e-007, 9.878400e-008, 9.529783e-008, 9.189467e-008, 8.857350e-008, 8.533333e-008, 8.217317e-008, 7.909200e-008, 7.608883e-008, 7.316267e-008, 7.031250e-008, 6.753733e-008, 6.483617e-008, 6.220800e-008, 5.965183e-008, 5.716667e-008, 5.475150e-008, 5.240533e-008, 5.012717e-008, 4.791600e-008, 4.577083e-008, 4.369067e-008, 4.167450e-008, 3.972133e-008, 3.783017e-008, 3.600000e-008, 3.422983e-008, 3.251867e-008, 3.086550e-008, 2.926933e-008, 2.772917e-008, 2.624400e-008, 2.481283e-008, 2.343467e-008, 2.210850e-008, 2.083333e-008, 1.960817e-008, 1.843200e-008, 1.730383e-008, 1.622267e-008, 1.518750e-008, 1.419733e-008, 1.325117e-008, 1.234800e-008, 1.148683e-008, 1.066667e-008, 9.886500e-009, 9.145333e-009, 8.442167e-009, 7.776000e-009, 7.145833e-009, 6.550667e-009, 5.989500e-009, 5.461333e-009, 4.965167e-009, 4.500000e-009, 4.064833e-009, 3.658667e-009, 3.280500e-009, 2.929333e-009, 2.604167e-009, 2.304000e-009, 2.027833e-009, 1.774667e-009, 1.543500e-009, 1.333333e-009, 1.143167e-009, 9.720000e-010, 8.188333e-010, 6.826667e-010, 5.625000e-010, 4.573333e-010, 3.661667e-010, 2.880000e-010, 2.218333e-010, 1.666667e-010, 1.215000e-010, 8.533333e-011, 5.716667e-011, 3.600000e-011, 2.083333e-011, 1.066667e-011, 4.500000e-012, 1.333333e-012, 1.666667e-013, 
0.000000e+000, 0.000000e+000
},
{
6.666667e-001, 6.666667e-001, 6.666666e-001, 6.666666e-001, 6.666665e-001, 6.666664e-001, 6.666663e-001, 6.666662e-001, 6.666660e-001, 6.666659e-001, 6.666657e-001, 6.666655e-001, 6.666652e-001, 6.666650e-001, 6.666647e-001, 6.666644e-001, 6.666641e-001, 6.666638e-001, 6.666634e-001, 6.666631e-001, 6.666627e-001, 6.666623e-001, 6.666618e-001, 6.666614e-001, 6.666609e-001, 6.666604e-001, 6.666599e-001, 6.666594e-001, 6.666588e-001, 6.666583e-001, 6.666577e-001, 6.666571e-001, 6.666564e-001, 6.666558e-001, 6.666551e-001, 6.666544e-001, 6.666537e-001, 6.666530e-001, 6.666523e-001, 6.666515e-001, 6.666507e-001, 6.666499e-001, 6.666491e-001, 6.666482e-001, 6.666473e-001, 6.666465e-001, 6.666456e-001, 6.666446e-001, 6.666437e-001, 6.666427e-001, 6.666417e-001, 6.666407e-001, 6.666397e-001, 6.666387e-001, 6.666376e-001, 6.666365e-001, 6.666354e-001, 6.666343e-001, 6.666331e-001, 6.666320e-001, 6.666308e-001, 6.666296e-001, 6.666283e-001, 6.666271e-001, 6.666258e-001, 6.666246e-001, 6.666233e-001, 6.666219e-001, 6.666206e-001, 6.666192e-001, 6.666178e-001, 6.666164e-001, 6.666150e-001, 6.666136e-001, 6.666121e-001, 6.666106e-001, 6.666091e-001, 6.666076e-001, 6.666061e-001, 6.666045e-001, 6.666029e-001, 6.666013e-001, 6.665997e-001, 6.665981e-001, 6.665964e-001, 6.665947e-001, 6.665930e-001, 6.665913e-001, 6.665896e-001, 6.665878e-001, 6.665860e-001, 6.665842e-001, 6.665824e-001, 6.665806e-001, 6.665787e-001, 6.665768e-001, 6.665749e-001, 6.665730e-001, 6.665711e-001, 6.665691e-001, 
6.665672e-001, 6.665652e-001, 6.665632e-001, 6.665611e-001, 6.665591e-001, 6.665570e-001, 6.665549e-001, 6.665528e-001, 6.665507e-001, 6.665485e-001, 6.665463e-001, 6.665441e-001, 6.665419e-001, 6.665397e-001, 6.665374e-001, 6.665352e-001, 6.665329e-001, 6.665306e-001, 6.665282e-001, 6.665259e-001, 6.665235e-001, 6.665211e-001, 6.665187e-001, 6.665163e-001, 6.665139e-001, 6.665114e-001, 6.665089e-001, 6.665064e-001, 6.665039e-001, 6.665013e-001, 6.664988e-001, 6.664962e-001, 6.664936e-001, 6.664910e-001, 6.664883e-001, 6.664856e-001, 6.664830e-001, 6.664803e-001, 6.664775e-001, 6.664748e-001, 6.664720e-001, 6.664693e-001, 6.664665e-001, 6.664636e-001, 6.664608e-001, 6.664579e-001, 6.664551e-001, 6.664522e-001, 6.664492e-001, 6.664463e-001, 6.664434e-001, 6.664404e-001, 6.664374e-001, 6.664344e-001, 6.664313e-001, 6.664283e-001, 6.664252e-001, 6.664221e-001, 6.664190e-001, 6.664159e-001, 6.664127e-001, 6.664095e-001, 6.664064e-001, 6.664031e-001, 6.663999e-001, 6.663967e-001, 6.663934e-001, 6.663901e-001, 6.663868e-001, 6.663835e-001, 6.663801e-001, 6.663768e-001, 6.663734e-001, 6.663700e-001, 6.663665e-001, 6.663631e-001, 6.663596e-001, 6.663561e-001, 6.663526e-001, 6.663491e-001, 6.663456e-001, 6.663420e-001, 6.663384e-001, 6.663348e-001, 6.663312e-001, 6.663276e-001, 6.663239e-001, 6.663202e-001, 6.663165e-001, 6.663128e-001, 6.663091e-001, 6.663053e-001, 6.663016e-001, 6.662978e-001, 6.662940e-001, 6.662901e-001, 6.662863e-001, 6.662824e-001, 6.662785e-001, 6.662746e-001, 
6.662707e-001, 6.662667e-001, 6.662627e-001, 6.662588e-001, 6.662548e-001, 6.662507e-001, 6.662467e-001, 6.662426e-001, 6.662385e-001, 6.662344e-001, 6.662303e-001, 6.662262e-001, 6.662220e-001, 6.662178e-001, 6.662136e-001, 6.662094e-001, 6.662051e-001, 6.662009e-001, 6.661966e-001, 6.661923e-001, 6.661880e-001, 6.661837e-001, 6.661793e-001, 6.661749e-001, 6.661705e-001, 6.661661e-001, 6.661617e-001, 6.661572e-001, 6.661528e-001, 6.661483e-001, 6.661438e-001, 6.661392e-001, 6.661347e-001, 6.661301e-001, 6.661255e-001, 6.661209e-001, 6.661163e-001, 6.661116e-001, 6.661070e-001, 6.661023e-001, 6.660976e-001, 6.660929e-001, 6.660881e-001, 6.660834e-001, 6.660786e-001, 6.660738e-001, 6.660690e-001, 6.660641e-001, 6.660593e-001, 6.660544e-001, 6.660495e-001, 6.660446e-001, 6.660396e-001, 6.660347e-001, 6.660297e-001, 6.660247e-001, 6.660197e-001, 6.660147e-001, 6.660096e-001, 6.660045e-001, 6.659995e-001, 6.659943e-001, 6.659892e-001, 6.659841e-001, 6.659789e-001, 6.659737e-001, 6.659685e-001, 6.659633e-001, 6.659581e-001, 6.659528e-001, 6.659475e-001, 6.659422e-001, 6.659369e-001, 6.659315e-001, 6.659262e-001, 6.659208e-001, 6.659154e-001, 6.659100e-001, 6.659046e-001, 6.658991e-001, 6.658936e-001, 6.658882e-001, 6.658826e-001, 6.658771e-001, 6.658716e-001, 6.658660e-001, 6.658604e-001, 6.658548e-001, 6.658492e-001, 6.658435e-001, 6.658379e-001, 6.658322e-001, 6.658265e-001, 6.658208e-001, 6.658150e-001, 6.658093e-001, 6.658035e-001, 6.657977e-001, 6.657919e-001, 6.657860e-001, 
6.657802e-001, 6.657743e-001, 6.657684e-001, 6.657625e-001, 6.657566e-001, 6.657506e-001, 6.657446e-001, 6.657386e-001, 6.657326e-001, 6.657266e-001, 6.657206e-001, 6.657145e-001, 6.657084e-001, 6.657023e-001, 6.656962e-001, 6.656900e-001, 6.656839e-001, 6.656777e-001, 6.656715e-001, 6.656653e-001, 6.656591e-001, 6.656528e-001, 6.656465e-001, 6.656402e-001, 6.656339e-001, 6.656276e-001, 6.656212e-001, 6.656149e-001, 6.656085e-001, 6.656021e-001, 6.655956e-001, 6.655892e-001, 6.655827e-001, 6.655762e-001, 6.655697e-001, 6.655632e-001, 6.655567e-001, 6.655501e-001, 6.655435e-001, 6.655369e-001, 6.655303e-001, 6.655237e-001, 6.655170e-001, 6.655104e-001, 6.655037e-001, 6.654969e-001, 6.654902e-001, 6.654835e-001, 6.654767e-001, 6.654699e-001, 6.654631e-001, 6.654563e-001, 6.654494e-001, 6.654426e-001, 6.654357e-001, 6.654288e-001, 6.654219e-001, 6.654149e-001, 6.654080e-001, 6.654010e-001, 6.653940e-001, 6.653870e-001, 6.653799e-001, 6.653729e-001, 6.653658e-001, 6.653587e-001, 6.653516e-001, 6.653445e-001, 6.653373e-001, 6.653302e-001, 6.653230e-001, 6.653158e-001, 6.653086e-001, 6.653013e-001, 6.652941e-001, 6.652868e-001, 6.652795e-001, 6.652722e-001, 6.652648e-001, 6.652575e-001, 6.652501e-001, 6.652427e-001, 6.652353e-001, 6.652279e-001, 6.652204e-001, 6.652129e-001, 6.652055e-001, 6.651980e-001, 6.651904e-001, 6.651829e-001, 6.651753e-001, 6.651677e-001, 6.651601e-001, 6.651525e-001, 6.651449e-001, 6.651372e-001, 6.651296e-001, 6.651219e-001, 6.651141e-001, 6.651064e-001, 
6.650987e-001, 6.650909e-001, 6.650831e-001, 6.650753e-001, 6.650675e-001, 6.650596e-001, 6.650518e-001, 6.650439e-001, 6.650360e-001, 6.650281e-001, 6.650201e-001, 6.650122e-001, 6.650042e-001, 6.649962e-001, 6.649882e-001, 6.649802e-001, 6.649721e-001, 6.649640e-001, 6.649559e-001, 6.649478e-001, 6.649397e-001, 6.649316e-001, 6.649234e-001, 6.649152e-001, 6.649070e-001, 6.648988e-001, 6.648906e-001, 6.648823e-001, 6.648740e-001, 6.648657e-001, 6.648574e-001, 6.648491e-001, 6.648407e-001, 6.648324e-001, 6.648240e-001, 6.648156e-001, 6.648071e-001, 6.647987e-001, 6.647902e-001, 6.647818e-001, 6.647733e-001, 6.647647e-001, 6.647562e-001, 6.647476e-001, 6.647391e-001, 6.647305e-001, 6.647219e-001, 6.647132e-001, 6.647046e-001, 6.646959e-001, 6.646872e-001, 6.646785e-001, 6.646698e-001, 6.646611e-001, 6.646523e-001, 6.646435e-001, 6.646347e-001, 6.646259e-001, 6.646171e-001, 6.646082e-001, 6.645993e-001, 6.645904e-001, 6.645815e-001, 6.645726e-001, 6.645637e-001, 6.645547e-001, 6.645457e-001, 6.645367e-001, 6.645277e-001, 6.645186e-001, 6.645096e-001, 6.645005e-001, 6.644914e-001, 6.644823e-001, 6.644732e-001, 6.644640e-001, 6.644548e-001, 6.644456e-001, 6.644364e-001, 6.644272e-001, 6.644180e-001, 6.644087e-001, 6.643994e-001, 6.643901e-001, 6.643808e-001, 6.643715e-001, 6.643621e-001, 6.643527e-001, 6.643433e-001, 6.643339e-001, 6.643245e-001, 6.643150e-001, 6.643056e-001, 6.642961e-001, 6.642866e-001, 6.642771e-001, 6.642675e-001, 6.642580e-001, 6.642484e-001, 6.642388e-001, 
6.642292e-001, 6.642195e-001, 6.642099e-001, 6.642002e-001, 6.641905e-001, 6.641808e-001, 6.641711e-001, 6.641613e-001, 6.641516e-001, 6.641418e-001, 6.641320e-001, 6.641222e-001, 6.641123e-001, 6.641025e-001, 6.640926e-001, 6.640827e-001, 6.640728e-001, 6.640629e-001, 6.640529e-001, 6.640430e-001, 6.640330e-001, 6.640230e-001, 6.640129e-001, 6.640029e-001, 6.639928e-001, 6.639828e-001, 6.639727e-001, 6.639626e-001, 6.639524e-001, 6.639423e-001, 6.639321e-001, 6.639219e-001, 6.639117e-001, 6.639015e-001, 6.638912e-001, 6.638810e-001, 6.638707e-001, 6.638604e-001, 6.638501e-001, 6.638398e-001, 6.638294e-001, 6.638190e-001, 6.638086e-001, 6.637982e-001, 6.637878e-001, 6.637774e-001, 6.637669e-001, 6.637564e-001, 6.637459e-001, 6.637354e-001, 6.637249e-001, 6.637143e-001, 6.637037e-001, 6.636931e-001, 6.636825e-001, 6.636719e-001, 6.636612e-001, 6.636506e-001, 6.636399e-001, 6.636292e-001, 6.636185e-001, 6.636077e-001, 6.635970e-001, 6.635862e-001, 6.635754e-001, 6.635646e-001, 6.635538e-001, 6.635429e-001, 6.635321e-001, 6.635212e-001, 6.635103e-001, 6.634993e-001, 6.634884e-001, 6.634774e-001, 6.634665e-001, 6.634555e-001, 6.634445e-001, 6.634334e-001, 6.634224e-001, 6.634113e-001, 6.634002e-001, 6.633891e-001, 6.633780e-001, 6.633669e-001, 6.633557e-001, 6.633445e-001, 6.633333e-001, 6.633221e-001, 6.633109e-001, 6.632996e-001, 6.632884e-001, 6.632771e-001, 6.632658e-001, 6.632544e-001, 6.632431e-001, 6.632317e-001, 6.632204e-001, 6.632090e-001, 6.631976e-001, 6.631861e-001, 
6.631747e-001, 6.631632e-001, 6.631517e-001, 6.631402e-001, 6.631287e-001, 6.631171e-001, 6.631056e-001, 6.630940e-001, 6.630824e-001, 6.630708e-001, 6.630592e-001, 6.630475e-001, 6.630358e-001, 6.630241e-001, 6.630124e-001, 6.630007e-001, 6.629890e-001, 6.629772e-001, 6.629654e-001, 6.629536e-001, 6.629418e-001, 6.629300e-001, 6.629181e-001, 6.629063e-001, 6.628944e-001, 6.628825e-001, 6.628706e-001, 6.628586e-001, 6.628467e-001, 6.628347e-001, 6.628227e-001, 6.628107e-001, 6.627986e-001, 6.627866e-001, 6.627745e-001, 6.627624e-001, 6.627503e-001, 6.627382e-001, 6.627261e-001, 6.627139e-001, 6.627017e-001, 6.626895e-001, 6.626773e-001, 6.626651e-001, 6.626529e-001, 6.626406e-001, 6.626283e-001, 6.626160e-001, 6.626037e-001, 6.625913e-001, 6.625790e-001, 6.625666e-001, 6.625542e-001, 6.625418e-001, 6.625294e-001, 6.625169e-001, 6.625045e-001, 6.624920e-001, 6.624795e-001, 6.624670e-001, 6.624544e-001, 6.624419e-001, 6.624293e-001, 6.624167e-001, 6.624041e-001, 6.623915e-001, 6.623788e-001, 6.623661e-001, 6.623535e-001, 6.623408e-001, 6.623280e-001, 6.623153e-001, 6.623026e-001, 6.622898e-001, 6.622770e-001, 6.622642e-001, 6.622514e-001, 6.622385e-001, 6.622257e-001, 6.622128e-001, 6.621999e-001, 6.621870e-001, 6.621740e-001, 6.621611e-001, 6.621481e-001, 6.621351e-001, 6.621221e-001, 6.621091e-001, 6.620961e-001, 6.620830e-001, 6.620699e-001, 6.620568e-001, 6.620437e-001, 6.620306e-001, 6.620174e-001, 6.620043e-001, 6.619911e-001, 6.619779e-001, 6.619647e-001, 6.619514e-001, 
6.619382e-001, 6.619249e-001, 6.619116e-001, 6.618983e-001, 6.618850e-001, 6.618716e-001, 6.618583e-001, 6.618449e-001, 6.618315e-001, 6.618181e-001, 6.618046e-001, 6.617912e-001, 6.617777e-001, 6.617642e-001, 6.617507e-001, 6.617372e-001, 6.617236e-001, 6.617101e-001, 6.616965e-001, 6.616829e-001, 6.616693e-001, 6.616557e-001, 6.616420e-001, 6.616283e-001, 6.616147e-001, 6.616010e-001, 6.615872e-001, 6.615735e-001, 6.615597e-001, 6.615460e-001, 6.615322e-001, 6.615184e-001, 6.615045e-001, 6.614907e-001, 6.614768e-001, 6.614629e-001, 6.614491e-001, 6.614351e-001, 6.614212e-001, 6.614072e-001, 6.613933e-001, 6.613793e-001, 6.613653e-001, 6.613513e-001, 6.613372e-001, 6.613232e-001, 6.613091e-001, 6.612950e-001, 6.612809e-001, 6.612668e-001, 6.612526e-001, 6.612384e-001, 6.612243e-001, 6.612101e-001, 6.611958e-001, 6.611816e-001, 6.611673e-001, 6.611531e-001, 6.611388e-001, 6.611245e-001, 6.611102e-001, 6.610958e-001, 6.610815e-001, 6.610671e-001, 6.610527e-001, 6.610383e-001, 6.610238e-001, 6.610094e-001, 6.609949e-001, 6.609804e-001, 6.609659e-001, 6.609514e-001, 6.609369e-001, 6.609223e-001, 6.609077e-001, 6.608932e-001, 6.608786e-001, 6.608639e-001, 6.608493e-001, 6.608346e-001, 6.608199e-001, 6.608052e-001, 6.607905e-001, 6.607758e-001, 6.607611e-001, 6.607463e-001, 6.607315e-001, 6.607167e-001, 6.607019e-001, 6.606870e-001, 6.606722e-001, 6.606573e-001, 6.606424e-001, 6.606275e-001, 6.606126e-001, 6.605976e-001, 6.605827e-001, 6.605677e-001, 6.605527e-001, 6.605377e-001, 
6.605227e-001, 6.605076e-001, 6.604926e-001, 6.604775e-001, 6.604624e-001, 6.604472e-001, 6.604321e-001, 6.604170e-001, 6.604018e-001, 6.603866e-001, 6.603714e-001, 6.603562e-001, 6.603409e-001, 6.603257e-001, 6.603104e-001, 6.602951e-001, 6.602798e-001, 6.602644e-001, 6.602491e-001, 6.602337e-001, 6.602184e-001, 6.602030e-001, 6.601875e-001, 6.601721e-001, 6.601566e-001, 6.601412e-001, 6.601257e-001, 6.601102e-001, 6.600947e-001, 6.600791e-001, 6.600636e-001, 6.600480e-001, 6.600324e-001, 6.600168e-001, 6.600012e-001, 6.599855e-001, 6.599698e-001, 6.599542e-001, 6.599385e-001, 6.599228e-001, 6.599070e-001, 6.598913e-001, 6.598755e-001, 6.598597e-001, 6.598439e-001, 6.598281e-001, 6.598123e-001, 6.597964e-001, 6.597805e-001, 6.597646e-001, 6.597487e-001, 6.597328e-001, 6.597169e-001, 6.597009e-001, 6.596849e-001, 6.596689e-001, 6.596529e-001, 6.596369e-001, 6.596208e-001, 6.596048e-001, 6.595887e-001, 6.595726e-001, 6.595565e-001, 6.595403e-001, 6.595242e-001, 6.595080e-001, 6.594918e-001, 6.594756e-001, 6.594594e-001, 6.594432e-001, 6.594269e-001, 6.594106e-001, 6.593944e-001, 6.593780e-001, 6.593617e-001, 6.593454e-001, 6.593290e-001, 6.593126e-001, 6.592962e-001, 6.592798e-001, 6.592634e-001, 6.592470e-001, 6.592305e-001, 6.592140e-001, 6.591975e-001, 6.591810e-001, 6.591645e-001, 6.591479e-001, 6.591313e-001, 6.591148e-001, 6.590982e-001, 6.590815e-001, 6.590649e-001, 6.590482e-001, 6.590316e-001, 6.590149e-001, 6.589982e-001, 6.589814e-001, 6.589647e-001, 6.589479e-001, 
6.589312e-001, 6.589144e-001, 6.588976e-001, 6.588807e-001, 6.588639e-001, 6.588470e-001, 6.588301e-001, 6.588132e-001, 6.587963e-001, 6.587794e-001, 6.587625e-001, 6.587455e-001, 6.587285e-001, 6.587115e-001, 6.586945e-001, 6.586774e-001, 6.586604e-001, 6.586433e-001, 6.586262e-001, 6.586091e-001, 6.585920e-001, 6.585749e-001, 6.585577e-001, 6.585405e-001, 6.585234e-001, 6.585061e-001, 6.584889e-001, 6.584717e-001, 6.584544e-001, 6.584371e-001, 6.584198e-001, 6.584025e-001, 6.583852e-001, 6.583679e-001, 6.583505e-001, 6.583331e-001, 6.583157e-001, 6.582983e-001, 6.582809e-001, 6.582634e-001, 6.582460e-001, 6.582285e-001, 6.582110e-001, 6.581935e-001, 6.581759e-001, 6.581584e-001, 6.581408e-001, 6.581232e-001, 6.581056e-001, 6.580880e-001, 6.580704e-001, 6.580527e-001, 6.580350e-001, 6.580173e-001, 6.579996e-001, 6.579819e-001, 6.579642e-001, 6.579464e-001, 6.579286e-001, 6.579108e-001, 6.578930e-001, 6.578752e-001, 6.578574e-001, 6.578395e-001, 6.578216e-001, 6.578037e-001, 6.577858e-001, 6.577679e-001, 6.577499e-001, 6.577320e-001, 6.577140e-001, 6.576960e-001, 6.576780e-001, 6.576600e-001, 6.576419e-001, 6.576238e-001, 6.576058e-001, 6.575877e-001, 6.575695e-001, 6.575514e-001, 6.575333e-001, 6.575151e-001, 6.574969e-001, 6.574787e-001, 6.574605e-001, 6.574423e-001, 6.574240e-001, 6.574057e-001, 6.573874e-001, 6.573691e-001, 6.573508e-001, 6.573325e-001, 6.573141e-001, 6.572957e-001, 6.572774e-001, 6.572590e-001, 6.572405e-001, 6.572221e-001, 6.572036e-001, 6.571852e-001, 
6.571667e-001, 6.571482e-001, 6.571296e-001, 6.571111e-001, 6.570925e-001, 6.570740e-001, 6.570554e-001, 6.570368e-001, 6.570181e-001, 6.569995e-001, 6.569808e-001, 6.569621e-001, 6.569434e-001, 6.569247e-001, 6.569060e-001, 6.568873e-001, 6.568685e-001, 6.568497e-001, 6.568309e-001, 6.568121e-001, 6.567933e-001, 6.567744e-001, 6.567556e-001, 6.567367e-001, 6.567178e-001, 6.566989e-001, 6.566799e-001, 6.566610e-001, 6.566420e-001, 6.566230e-001, 6.566040e-001, 6.565850e-001, 6.565660e-001, 6.565469e-001, 6.565279e-001, 6.565088e-001, 6.564897e-001, 6.564706e-001, 6.564514e-001, 6.564323e-001, 6.564131e-001, 6.563939e-001, 6.563747e-001, 6.563555e-001, 6.563363e-001, 6.563170e-001, 6.562977e-001, 6.562784e-001, 6.562591e-001, 6.562398e-001, 6.562205e-001, 6.562011e-001, 6.561818e-001, 6.561624e-001, 6.561430e-001, 6.561235e-001, 6.561041e-001, 6.560846e-001, 6.560652e-001, 6.560457e-001, 6.560262e-001, 6.560067e-001, 6.559871e-001, 6.559676e-001, 6.559480e-001, 6.559284e-001, 6.559088e-001, 6.558892e-001, 6.558695e-001, 6.558499e-001, 6.558302e-001, 6.558105e-001, 6.557908e-001, 6.557711e-001, 6.557513e-001, 6.557316e-001, 6.557118e-001, 6.556920e-001, 6.556722e-001, 6.556524e-001, 6.556325e-001, 6.556127e-001, 6.555928e-001, 6.555729e-001, 6.555530e-001, 6.555331e-001, 6.555131e-001, 6.554932e-001, 6.554732e-001, 6.554532e-001, 6.554332e-001, 6.554132e-001, 6.553931e-001, 6.553731e-001, 6.553530e-001, 6.553329e-001, 6.553128e-001, 6.552926e-001, 6.552725e-001, 6.552523e-001, 
6.552322e-001, 6.552120e-001, 6.551918e-001, 6.551715e-001, 6.551513e-001, 6.551310e-001, 6.551108e-001, 6.550905e-001, 6.550702e-001, 6.550498e-001, 6.550295e-001, 6.550091e-001, 6.549887e-001, 6.549684e-001, 6.549479e-001, 6.549275e-001, 6.549071e-001, 6.548866e-001, 6.548661e-001, 6.548456e-001, 6.548251e-001, 6.548046e-001, 6.547841e-001, 6.547635e-001, 6.547429e-001, 6.547223e-001, 6.547017e-001, 6.546811e-001, 6.546605e-001, 6.546398e-001, 6.546191e-001, 6.545984e-001, 6.545777e-001, 6.545570e-001, 6.545362e-001, 6.545155e-001, 6.544947e-001, 6.544739e-001, 6.544531e-001, 6.544323e-001, 6.544114e-001, 6.543906e-001, 6.543697e-001, 6.543488e-001, 6.543279e-001, 6.543070e-001, 6.542860e-001, 6.542651e-001, 6.542441e-001, 6.542231e-001, 6.542021e-001, 6.541811e-001, 6.541600e-001, 6.541390e-001, 6.541179e-001, 6.540968e-001, 6.540757e-001, 6.540546e-001, 6.540334e-001, 6.540123e-001, 6.539911e-001, 6.539699e-001, 6.539487e-001, 6.539275e-001, 6.539063e-001, 6.538850e-001, 6.538637e-001, 6.538424e-001, 6.538211e-001, 6.537998e-001, 6.537785e-001, 6.537571e-001, 6.537357e-001, 6.537144e-001, 6.536930e-001, 6.536715e-001, 6.536501e-001, 6.536286e-001, 6.536072e-001, 6.535857e-001, 6.535642e-001, 6.535427e-001, 6.535211e-001, 6.534996e-001, 6.534780e-001, 6.534564e-001, 6.534348e-001, 6.534132e-001, 6.533916e-001, 6.533699e-001, 6.533482e-001, 6.533266e-001, 6.533049e-001, 6.532831e-001, 6.532614e-001, 6.532397e-001, 6.532179e-001, 6.531961e-001, 6.531743e-001, 6.531525e-001, 
6.531307e-001, 6.531088e-001, 6.530870e-001, 6.530651e-001, 6.530432e-001, 6.530213e-001, 6.529993e-001, 6.529774e-001, 6.529554e-001, 6.529334e-001, 6.529114e-001, 6.528894e-001, 6.528674e-001, 6.528454e-001, 6.528233e-001, 6.528012e-001, 6.527791e-001, 6.527570e-001, 6.527349e-001, 6.527127e-001, 6.526906e-001, 6.526684e-001, 6.526462e-001, 6.526240e-001, 6.526018e-001, 6.525795e-001, 6.525573e-001, 6.525350e-001, 6.525127e-001, 6.524904e-001, 6.524681e-001, 6.524458e-001, 6.524234e-001, 6.524010e-001, 6.523786e-001, 6.523562e-001, 6.523338e-001, 6.523114e-001, 6.522889e-001, 6.522665e-001, 6.522440e-001, 6.522215e-001, 6.521990e-001, 6.521764e-001, 6.521539e-001, 6.521313e-001, 6.521087e-001, 6.520861e-001, 6.520635e-001, 6.520409e-001, 6.520182e-001, 6.519956e-001, 6.519729e-001, 6.519502e-001, 6.519275e-001, 6.519047e-001, 6.518820e-001, 6.518592e-001, 6.518365e-001, 6.518137e-001, 6.517909e-001, 6.517680e-001, 6.517452e-001, 6.517223e-001, 6.516995e-001, 6.516766e-001, 6.516537e-001, 6.516307e-001, 6.516078e-001, 6.515848e-001, 6.515619e-001, 6.515389e-001, 6.515159e-001, 6.514928e-001, 6.514698e-001, 6.514468e-001, 6.514237e-001, 6.514006e-001, 6.513775e-001, 6.513544e-001, 6.513312e-001, 6.513081e-001, 6.512849e-001, 6.512617e-001, 6.512385e-001, 6.512153e-001, 6.511921e-001, 6.511689e-001, 6.511456e-001, 6.511223e-001, 6.510990e-001, 6.510757e-001, 6.510524e-001, 6.510290e-001, 6.510057e-001, 6.509823e-001, 6.509589e-001, 6.509355e-001, 6.509121e-001, 6.508886e-001, 
6.508652e-001, 6.508417e-001, 6.508182e-001, 6.507947e-001, 6.507712e-001, 6.507476e-001, 6.507241e-001, 6.507005e-001, 6.506769e-001, 6.506533e-001, 6.506297e-001, 6.506061e-001, 6.505824e-001, 6.505588e-001, 6.505351e-001, 6.505114e-001, 6.504877e-001, 6.504639e-001, 6.504402e-001, 6.504164e-001, 6.503927e-001, 6.503689e-001, 6.503450e-001, 6.503212e-001, 6.502974e-001, 6.502735e-001, 6.502496e-001, 6.502258e-001, 6.502018e-001, 6.501779e-001, 6.501540e-001, 6.501300e-001, 6.501061e-001, 6.500821e-001, 6.500581e-001, 6.500341e-001, 6.500100e-001, 6.499860e-001, 6.499619e-001, 6.499378e-001, 6.499137e-001, 6.498896e-001, 6.498655e-001, 6.498413e-001, 6.498172e-001, 6.497930e-001, 6.497688e-001, 6.497446e-001, 6.497204e-001, 6.496961e-001, 6.496719e-001, 6.496476e-001, 6.496233e-001, 6.495990e-001, 6.495747e-001, 6.495503e-001, 6.495260e-001, 6.495016e-001, 6.494772e-001, 6.494528e-001, 6.494284e-001, 6.494040e-001, 6.493795e-001, 6.493550e-001, 6.493306e-001, 6.493061e-001, 6.492816e-001, 6.492570e-001, 6.492325e-001, 6.492079e-001, 6.491833e-001, 6.491588e-001, 6.491341e-001, 6.491095e-001, 6.490849e-001, 6.490602e-001, 6.490355e-001, 6.490109e-001, 6.489862e-001, 6.489614e-001, 6.489367e-001, 6.489120e-001, 6.488872e-001, 6.488624e-001, 6.488376e-001, 6.488128e-001, 6.487880e-001, 6.487631e-001, 6.487382e-001, 6.487134e-001, 6.486885e-001, 6.486636e-001, 6.486386e-001, 6.486137e-001, 6.485887e-001, 6.485638e-001, 6.485388e-001, 6.485138e-001, 6.484888e-001, 6.484637e-001, 
6.484387e-001, 6.484136e-001, 6.483885e-001, 6.483634e-001, 6.483383e-001, 6.483132e-001, 6.482880e-001, 6.482629e-001, 6.482377e-001, 6.482125e-001, 6.481873e-001, 6.481621e-001, 6.481368e-001, 6.481116e-001, 6.480863e-001, 6.480610e-001, 6.480357e-001, 6.480104e-001, 6.479850e-001, 6.479597e-001, 6.479343e-001, 6.479089e-001, 6.478835e-001, 6.478581e-001, 6.478327e-001, 6.478072e-001, 6.477818e-001, 6.477563e-001, 6.477308e-001, 6.477053e-001, 6.476798e-001, 6.476542e-001, 6.476287e-001, 6.476031e-001, 6.475775e-001, 6.475519e-001, 6.475263e-001, 6.475007e-001, 6.474750e-001, 6.474493e-001, 6.474237e-001, 6.473980e-001, 6.473722e-001, 6.473465e-001, 6.473208e-001, 6.472950e-001, 6.472692e-001, 6.472434e-001, 6.472176e-001, 6.471918e-001, 6.471660e-001, 6.471401e-001, 6.471143e-001, 6.470884e-001, 6.470625e-001, 6.470366e-001, 6.470106e-001, 6.469847e-001, 6.469587e-001, 6.469327e-001, 6.469067e-001, 6.468807e-001, 6.468547e-001, 6.468287e-001, 6.468026e-001, 6.467765e-001, 6.467504e-001, 6.467243e-001, 6.466982e-001, 6.466721e-001, 6.466459e-001, 6.466198e-001, 6.465936e-001, 6.465674e-001, 6.465412e-001, 6.465149e-001, 6.464887e-001, 6.464624e-001, 6.464362e-001, 6.464099e-001, 6.463836e-001, 6.463572e-001, 6.463309e-001, 6.463045e-001, 6.462782e-001, 6.462518e-001, 6.462254e-001, 6.461990e-001, 6.461725e-001, 6.461461e-001, 6.461196e-001, 6.460932e-001, 6.460667e-001, 6.460402e-001, 6.460136e-001, 6.459871e-001, 6.459605e-001, 6.459340e-001, 6.459074e-001, 6.458808e-001, 
6.458542e-001, 6.458275e-001, 6.458009e-001, 6.457742e-001, 6.457475e-001, 6.457208e-001, 6.456941e-001, 6.456674e-001, 6.456407e-001, 6.456139e-001, 6.455871e-001, 6.455604e-001, 6.455336e-001, 6.455067e-001, 6.454799e-001, 6.454530e-001, 6.454262e-001, 6.453993e-001, 6.453724e-001, 6.453455e-001, 6.453186e-001, 6.452916e-001, 6.452647e-001, 6.452377e-001, 6.452107e-001, 6.451837e-001, 6.451567e-001, 6.451297e-001, 6.451026e-001, 6.450755e-001, 6.450485e-001, 6.450214e-001, 6.449942e-001, 6.449671e-001, 6.449400e-001, 6.449128e-001, 6.448856e-001, 6.448585e-001, 6.448313e-001, 6.448040e-001, 6.447768e-001, 6.447495e-001, 6.447223e-001, 6.446950e-001, 6.446677e-001, 6.446404e-001, 6.446131e-001, 6.445857e-001, 6.445584e-001, 6.445310e-001, 6.445036e-001, 6.444762e-001, 6.444488e-001, 6.444213e-001, 6.443939e-001, 6.443664e-001, 6.443390e-001, 6.443115e-001, 6.442839e-001, 6.442564e-001, 6.442289e-001, 6.442013e-001, 6.441737e-001, 6.441462e-001, 6.441186e-001, 6.440909e-001, 6.440633e-001, 6.440357e-001, 6.440080e-001, 6.439803e-001, 6.439526e-001, 6.439249e-001, 6.438972e-001, 6.438694e-001, 6.438417e-001, 6.438139e-001, 6.437861e-001, 6.437583e-001, 6.437305e-001, 6.437027e-001, 6.436748e-001, 6.436470e-001, 6.436191e-001, 6.435912e-001, 6.435633e-001, 6.435354e-001, 6.435074e-001, 6.434795e-001, 6.434515e-001, 6.434235e-001, 6.433955e-001, 6.433675e-001, 6.433395e-001, 6.433114e-001, 6.432834e-001, 6.432553e-001, 6.432272e-001, 6.431991e-001, 6.431710e-001, 6.431428e-001, 
6.431147e-001, 6.430865e-001, 6.430583e-001, 6.430301e-001, 6.430019e-001, 6.429737e-001, 6.429454e-001, 6.429172e-001, 6.428889e-001, 6.428606e-001, 6.428323e-001, 6.428040e-001, 6.427757e-001, 6.427473e-001, 6.427189e-001, 6.426906e-001, 6.426622e-001, 6.426338e-001, 6.426053e-001, 6.425769e-001, 6.425484e-001, 6.425200e-001, 6.424915e-001, 6.424630e-001, 6.424345e-001, 6.424059e-001, 6.423774e-001, 6.423488e-001, 6.423202e-001, 6.422916e-001, 6.422630e-001, 6.422344e-001, 6.422058e-001, 6.421771e-001, 6.421485e-001, 6.421198e-001, 6.420911e-001, 6.420624e-001, 6.420336e-001, 6.420049e-001, 6.419761e-001, 6.419474e-001, 6.419186e-001, 6.418898e-001, 6.418610e-001, 6.418321e-001, 6.418033e-001, 6.417744e-001, 6.417455e-001, 6.417166e-001, 6.416877e-001, 6.416588e-001, 6.416299e-001, 6.416009e-001, 6.415719e-001, 6.415430e-001, 6.415140e-001, 6.414849e-001, 6.414559e-001, 6.414269e-001, 6.413978e-001, 6.413687e-001, 6.413397e-001, 6.413105e-001, 6.412814e-001, 6.412523e-001, 6.412231e-001, 6.411940e-001, 6.411648e-001, 6.411356e-001, 6.411064e-001, 6.410772e-001, 6.410479e-001, 6.410187e-001, 6.409894e-001, 6.409601e-001, 6.409308e-001, 6.409015e-001, 6.408722e-001, 6.408428e-001, 6.408135e-001, 6.407841e-001, 6.407547e-001, 6.407253e-001, 6.406959e-001, 6.406665e-001, 6.406370e-001, 6.406076e-001, 6.405781e-001, 6.405486e-001, 6.405191e-001, 6.404895e-001, 6.404600e-001, 6.404305e-001, 6.404009e-001, 6.403713e-001, 6.403417e-001, 6.403121e-001, 6.402825e-001, 6.402528e-001, 
6.402232e-001, 6.401935e-001, 6.401638e-001, 6.401341e-001, 6.401044e-001, 6.400747e-001, 6.400449e-001, 6.400151e-001, 6.399854e-001, 6.399556e-001, 6.399258e-001, 6.398960e-001, 6.398661e-001, 6.398363e-001, 6.398064e-001, 6.397765e-001, 6.397466e-001, 6.397167e-001, 6.396868e-001, 6.396568e-001, 6.396269e-001, 6.395969e-001, 6.395669e-001, 6.395369e-001, 6.395069e-001, 6.394769e-001, 6.394468e-001, 6.394168e-001, 6.393867e-001, 6.393566e-001, 6.393265e-001, 6.392964e-001, 6.392663e-001, 6.392361e-001, 6.392060e-001, 6.391758e-001, 6.391456e-001, 6.391154e-001, 6.390852e-001, 6.390549e-001, 6.390247e-001, 6.389944e-001, 6.389641e-001, 6.389338e-001, 6.389035e-001, 6.388732e-001, 6.388429e-001, 6.388125e-001, 6.387821e-001, 6.387518e-001, 6.387214e-001, 6.386909e-001, 6.386605e-001, 6.386301e-001, 6.385996e-001, 6.385691e-001, 6.385387e-001, 6.385081e-001, 6.384776e-001, 6.384471e-001, 6.384166e-001, 6.383860e-001, 6.383554e-001, 6.383248e-001, 6.382942e-001, 6.382636e-001, 6.382330e-001, 6.382023e-001, 6.381717e-001, 6.381410e-001, 6.381103e-001, 6.380796e-001, 6.380489e-001, 6.380181e-001, 6.379874e-001, 6.379566e-001, 6.379258e-001, 6.378950e-001, 6.378642e-001, 6.378334e-001, 6.378025e-001, 6.377717e-001, 6.377408e-001, 6.377099e-001, 6.376790e-001, 6.376481e-001, 6.376172e-001, 6.375863e-001, 6.375553e-001, 6.375243e-001, 6.374933e-001, 6.374623e-001, 6.374313e-001, 6.374003e-001, 6.373692e-001, 6.373382e-001, 6.373071e-001, 6.372760e-001, 6.372449e-001, 6.372138e-001, 
6.371827e-001, 6.371515e-001, 6.371204e-001, 6.370892e-001, 6.370580e-001, 6.370268e-001, 6.369956e-001, 6.369643e-001, 6.369331e-001, 6.369018e-001, 6.368705e-001, 6.368392e-001, 6.368079e-001, 6.367766e-001, 6.367453e-001, 6.367139e-001, 6.366826e-001, 6.366512e-001, 6.366198e-001, 6.365884e-001, 6.365570e-001, 6.365255e-001, 6.364941e-001, 6.364626e-001, 6.364311e-001, 6.363996e-001, 6.363681e-001, 6.363366e-001, 6.363050e-001, 6.362735e-001, 6.362419e-001, 6.362103e-001, 6.361787e-001, 6.361471e-001, 6.361155e-001, 6.360838e-001, 6.360522e-001, 6.360205e-001, 6.359888e-001, 6.359571e-001, 6.359254e-001, 6.358937e-001, 6.358619e-001, 6.358302e-001, 6.357984e-001, 6.357666e-001, 6.357348e-001, 6.357030e-001, 6.356712e-001, 6.356393e-001, 6.356075e-001, 6.355756e-001, 6.355437e-001, 6.355118e-001, 6.354799e-001, 6.354480e-001, 6.354160e-001, 6.353841e-001, 6.353521e-001, 6.353201e-001, 6.352881e-001, 6.352561e-001, 6.352240e-001, 6.351920e-001, 6.351599e-001, 6.351279e-001, 6.350958e-001, 6.350637e-001, 6.350315e-001, 6.349994e-001, 6.349673e-001, 6.349351e-001, 6.349029e-001, 6.348707e-001, 6.348385e-001, 6.348063e-001, 6.347741e-001, 6.347418e-001, 6.347096e-001, 6.346773e-001, 6.346450e-001, 6.346127e-001, 6.345804e-001, 6.345480e-001, 6.345157e-001, 6.344833e-001, 6.344510e-001, 6.344186e-001, 6.343862e-001, 6.343537e-001, 6.343213e-001, 6.342889e-001, 6.342564e-001, 6.342239e-001, 6.341914e-001, 6.341589e-001, 6.341264e-001, 6.340939e-001, 6.340613e-001, 6.340287e-001, 
6.339962e-001, 6.339636e-001, 6.339310e-001, 6.338983e-001, 6.338657e-001, 6.338331e-001, 6.338004e-001, 6.337677e-001, 6.337350e-001, 6.337023e-001, 6.336696e-001, 6.336369e-001, 6.336041e-001, 6.335714e-001, 6.335386e-001, 6.335058e-001, 6.334730e-001, 6.334402e-001, 6.334073e-001, 6.333745e-001, 6.333416e-001, 6.333087e-001, 6.332758e-001, 6.332429e-001, 6.332100e-001, 6.331771e-001, 6.331441e-001, 6.331112e-001, 6.330782e-001, 6.330452e-001, 6.330122e-001, 6.329792e-001, 6.329461e-001, 6.329131e-001, 6.328800e-001, 6.328470e-001, 6.328139e-001, 6.327808e-001, 6.327476e-001, 6.327145e-001, 6.326814e-001, 6.326482e-001, 6.326150e-001, 6.325818e-001, 6.325486e-001, 6.325154e-001, 6.324822e-001, 6.324489e-001, 6.324157e-001, 6.323824e-001, 6.323491e-001, 6.323158e-001, 6.322825e-001, 6.322492e-001, 6.322158e-001, 6.321824e-001, 6.321491e-001, 6.321157e-001, 6.320823e-001, 6.320489e-001, 6.320154e-001, 6.319820e-001, 6.319485e-001, 6.319151e-001, 6.318816e-001, 6.318481e-001, 6.318146e-001, 6.317810e-001, 6.317475e-001, 6.317139e-001, 6.316804e-001, 6.316468e-001, 6.316132e-001, 6.315796e-001, 6.315459e-001, 6.315123e-001, 6.314786e-001, 6.314450e-001, 6.314113e-001, 6.313776e-001, 6.313439e-001, 6.313101e-001, 6.312764e-001, 6.312426e-001, 6.312089e-001, 6.311751e-001, 6.311413e-001, 6.311075e-001, 6.310737e-001, 6.310398e-001, 6.310060e-001, 6.309721e-001, 6.309382e-001, 6.309043e-001, 6.308704e-001, 6.308365e-001, 6.308026e-001, 6.307686e-001, 6.307346e-001, 6.307007e-001, 
6.306667e-001, 6.306327e-001, 6.305986e-001, 6.305646e-001, 6.305306e-001, 6.304965e-001, 6.304624e-001, 6.304283e-001, 6.303942e-001, 6.303601e-001, 6.303260e-001, 6.302918e-001, 6.302577e-001, 6.302235e-001, 6.301893e-001, 6.301551e-001, 6.301209e-001, 6.300866e-001, 6.300524e-001, 6.300181e-001, 6.299839e-001, 6.299496e-001, 6.299153e-001, 6.298810e-001, 6.298466e-001, 6.298123e-001, 6.297779e-001, 6.297436e-001, 6.297092e-001, 6.296748e-001, 6.296404e-001, 6.296060e-001, 6.295715e-001, 6.295371e-001, 6.295026e-001, 6.294681e-001, 6.294336e-001, 6.293991e-001, 6.293646e-001, 6.293300e-001, 6.292955e-001, 6.292609e-001, 6.292264e-001, 6.291918e-001, 6.291572e-001, 6.291225e-001, 6.290879e-001, 6.290533e-001, 6.290186e-001, 6.289839e-001, 6.289492e-001, 6.289145e-001, 6.288798e-001, 6.288451e-001, 6.288103e-001, 6.287756e-001, 6.287408e-001, 6.287060e-001, 6.286712e-001, 6.286364e-001, 6.286016e-001, 6.285667e-001, 6.285319e-001, 6.284970e-001, 6.284621e-001, 6.284272e-001, 6.283923e-001, 6.283574e-001, 6.283225e-001, 6.282875e-001, 6.282525e-001, 6.282176e-001, 6.281826e-001, 6.281476e-001, 6.281125e-001, 6.280775e-001, 6.280425e-001, 6.280074e-001, 6.279723e-001, 6.279372e-001, 6.279021e-001, 6.278670e-001, 6.278319e-001, 6.277967e-001, 6.277616e-001, 6.277264e-001, 6.276912e-001, 6.276560e-001, 6.276208e-001, 6.275856e-001, 6.275503e-001, 6.275151e-001, 6.274798e-001, 6.274445e-001, 6.274092e-001, 6.273739e-001, 6.273386e-001, 6.273033e-001, 6.272679e-001, 6.272325e-001, 
6.271972e-001, 6.271618e-001, 6.271264e-001, 6.270910e-001, 6.270555e-001, 6.270201e-001, 6.269846e-001, 6.269491e-001, 6.269136e-001, 6.268781e-001, 6.268426e-001, 6.268071e-001, 6.267716e-001, 6.267360e-001, 6.267004e-001, 6.266649e-001, 6.266293e-001, 6.265936e-001, 6.265580e-001, 6.265224e-001, 6.264867e-001, 6.264511e-001, 6.264154e-001, 6.263797e-001, 6.263440e-001, 6.263083e-001, 6.262725e-001, 6.262368e-001, 6.262010e-001, 6.261653e-001, 6.261295e-001, 6.260937e-001, 6.260578e-001, 6.260220e-001, 6.259862e-001, 6.259503e-001, 6.259145e-001, 6.258786e-001, 6.258427e-001, 6.258068e-001, 6.257708e-001, 6.257349e-001, 6.256990e-001, 6.256630e-001, 6.256270e-001, 6.255910e-001, 6.255550e-001, 6.255190e-001, 6.254830e-001, 6.254469e-001, 6.254109e-001, 6.253748e-001, 6.253387e-001, 6.253026e-001, 6.252665e-001, 6.252304e-001, 6.251942e-001, 6.251581e-001, 6.251219e-001, 6.250857e-001, 6.250495e-001, 6.250133e-001, 6.249771e-001, 6.249408e-001, 6.249046e-001, 6.248683e-001, 6.248321e-001, 6.247958e-001, 6.247595e-001, 6.247232e-001, 6.246868e-001, 6.246505e-001, 6.246141e-001, 6.245778e-001, 6.245414e-001, 6.245050e-001, 6.244686e-001, 6.244321e-001, 6.243957e-001, 6.243592e-001, 6.243228e-001, 6.242863e-001, 6.242498e-001, 6.242133e-001, 6.241768e-001, 6.241403e-001, 6.241037e-001, 6.240672e-001, 6.240306e-001, 6.239940e-001, 6.239574e-001, 6.239208e-001, 6.238842e-001, 6.238475e-001, 6.238109e-001, 6.237742e-001, 6.237375e-001, 6.237008e-001, 6.236641e-001, 6.236274e-001, 
6.235907e-001, 6.235539e-001, 6.235172e-001, 6.234804e-001, 6.234436e-001, 6.234068e-001, 6.233700e-001, 6.233332e-001, 6.232963e-001, 6.232595e-001, 6.232226e-001, 6.231857e-001, 6.231488e-001, 6.231119e-001, 6.230750e-001, 6.230381e-001, 6.230011e-001, 6.229642e-001, 6.229272e-001, 6.228902e-001, 6.228532e-001, 6.228162e-001, 6.227791e-001, 6.227421e-001, 6.227051e-001, 6.226680e-001, 6.226309e-001, 6.225938e-001, 6.225567e-001, 6.225196e-001, 6.224825e-001, 6.224453e-001, 6.224081e-001, 6.223710e-001, 6.223338e-001, 6.222966e-001, 6.222594e-001, 6.222221e-001, 6.221849e-001, 6.221476e-001, 6.221104e-001, 6.220731e-001, 6.220358e-001, 6.219985e-001, 6.219612e-001, 6.219238e-001, 6.218865e-001, 6.218491e-001, 6.218118e-001, 6.217744e-001, 6.217370e-001, 6.216996e-001, 6.216621e-001, 6.216247e-001, 6.215872e-001, 6.215498e-001, 6.215123e-001, 6.214748e-001, 6.214373e-001, 6.213998e-001, 6.213623e-001, 6.213247e-001, 6.212872e-001, 6.212496e-001, 6.212120e-001, 6.211744e-001, 6.211368e-001, 6.210992e-001, 6.210615e-001, 6.210239e-001, 6.209862e-001, 6.209485e-001, 6.209108e-001, 6.208731e-001, 6.208354e-001, 6.207977e-001, 6.207599e-001, 6.207222e-001, 6.206844e-001, 6.206466e-001, 6.206088e-001, 6.205710e-001, 6.205332e-001, 6.204954e-001, 6.204575e-001, 6.204197e-001, 6.203818e-001, 6.203439e-001, 6.203060e-001, 6.202681e-001, 6.202302e-001, 6.201922e-001, 6.201543e-001, 6.201163e-001, 6.200783e-001, 6.200403e-001, 6.200023e-001, 6.199643e-001, 6.199263e-001, 6.198882e-001, 
6.198502e-001, 6.198121e-001, 6.197740e-001, 6.197359e-001, 6.196978e-001, 6.196597e-001, 6.196215e-001, 6.195834e-001, 6.195452e-001, 6.195071e-001, 6.194689e-001, 6.194307e-001, 6.193924e-001, 6.193542e-001, 6.193160e-001, 6.192777e-001, 6.192395e-001, 6.192012e-001, 6.191629e-001, 6.191246e-001, 6.190863e-001, 6.190479e-001, 6.190096e-001, 6.189712e-001, 6.189328e-001, 6.188945e-001, 6.188561e-001, 6.188176e-001, 6.187792e-001, 6.187408e-001, 6.187023e-001, 6.186639e-001, 6.186254e-001, 6.185869e-001, 6.185484e-001, 6.185099e-001, 6.184714e-001, 6.184328e-001, 6.183943e-001, 6.183557e-001, 6.183171e-001, 6.182785e-001, 6.182399e-001, 6.182013e-001, 6.181627e-001, 6.181240e-001, 6.180854e-001, 6.180467e-001, 6.180080e-001, 6.179693e-001, 6.179306e-001, 6.178919e-001, 6.178531e-001, 6.178144e-001, 6.177756e-001, 6.177369e-001, 6.176981e-001, 6.176593e-001, 6.176205e-001, 6.175816e-001, 6.175428e-001, 6.175039e-001, 6.174651e-001, 6.174262e-001, 6.173873e-001, 6.173484e-001, 6.173095e-001, 6.172706e-001, 6.172316e-001, 6.171927e-001, 6.171537e-001, 6.171147e-001, 6.170757e-001, 6.170367e-001, 6.169977e-001, 6.169587e-001, 6.169196e-001, 6.168806e-001, 6.168415e-001, 6.168024e-001, 6.167633e-001, 6.167242e-001, 6.166851e-001, 6.166459e-001, 6.166068e-001, 6.165676e-001, 6.165285e-001, 6.164893e-001, 6.164501e-001, 6.164109e-001, 6.163716e-001, 6.163324e-001, 6.162931e-001, 6.162539e-001, 6.162146e-001, 6.161753e-001, 6.161360e-001, 6.160967e-001, 6.160574e-001, 6.160180e-001, 
6.159787e-001, 6.159393e-001, 6.158999e-001, 6.158605e-001, 6.158211e-001, 6.157817e-001, 6.157423e-001, 6.157028e-001, 6.156634e-001, 6.156239e-001, 6.155844e-001, 6.155449e-001, 6.155054e-001, 6.154659e-001, 6.154264e-001, 6.153868e-001, 6.153473e-001, 6.153077e-001, 6.152681e-001, 6.152285e-001, 6.151889e-001, 6.151493e-001, 6.151097e-001, 6.150700e-001, 6.150303e-001, 6.149907e-001, 6.149510e-001, 6.149113e-001, 6.148716e-001, 6.148319e-001, 6.147921e-001, 6.147524e-001, 6.147126e-001, 6.146728e-001, 6.146330e-001, 6.145932e-001, 6.145534e-001, 6.145136e-001, 6.144738e-001, 6.144339e-001, 6.143941e-001, 6.143542e-001, 6.143143e-001, 6.142744e-001, 6.142345e-001, 6.141946e-001, 6.141546e-001, 6.141147e-001, 6.140747e-001, 6.140347e-001, 6.139947e-001, 6.139547e-001, 6.139147e-001, 6.138747e-001, 6.138346e-001, 6.137946e-001, 6.137545e-001, 6.137144e-001, 6.136744e-001, 6.136343e-001, 6.135941e-001, 6.135540e-001, 6.135139e-001, 6.134737e-001, 6.134335e-001, 6.133934e-001, 6.133532e-001, 6.133130e-001, 6.132728e-001, 6.132325e-001, 6.131923e-001, 6.131520e-001, 6.131118e-001, 6.130715e-001, 6.130312e-001, 6.129909e-001, 6.129506e-001, 6.129102e-001, 6.128699e-001, 6.128295e-001, 6.127892e-001, 6.127488e-001, 6.127084e-001, 6.126680e-001, 6.126276e-001, 6.125871e-001, 6.125467e-001, 6.125062e-001, 6.124658e-001, 6.124253e-001, 6.123848e-001, 6.123443e-001, 6.123038e-001, 6.122632e-001, 6.122227e-001, 6.121821e-001, 6.121416e-001, 6.121010e-001, 6.120604e-001, 6.120198e-001, 
6.119792e-001, 6.119385e-001, 6.118979e-001, 6.118572e-001, 6.118166e-001, 6.117759e-001, 6.117352e-001, 6.116945e-001, 6.116538e-001, 6.116130e-001, 6.115723e-001, 6.115315e-001, 6.114908e-001, 6.114500e-001, 6.114092e-001, 6.113684e-001, 6.113276e-001, 6.112867e-001, 6.112459e-001, 6.112050e-001, 6.111642e-001, 6.111233e-001, 6.110824e-001, 6.110415e-001, 6.110006e-001, 6.109596e-001, 6.109187e-001, 6.108777e-001, 6.108368e-001, 6.107958e-001, 6.107548e-001, 6.107138e-001, 6.106728e-001, 6.106318e-001, 6.105907e-001, 6.105497e-001, 6.105086e-001, 6.104675e-001, 6.104264e-001, 6.103853e-001, 6.103442e-001, 6.103031e-001, 6.102619e-001, 6.102208e-001, 6.101796e-001, 6.101384e-001, 6.100972e-001, 6.100560e-001, 6.100148e-001, 6.099736e-001, 6.099324e-001, 6.098911e-001, 6.098498e-001, 6.098086e-001, 6.097673e-001, 6.097260e-001, 6.096847e-001, 6.096433e-001, 6.096020e-001, 6.095606e-001, 6.095193e-001, 6.094779e-001, 6.094365e-001, 6.093951e-001, 6.093537e-001, 6.093123e-001, 6.092708e-001, 6.092294e-001, 6.091879e-001, 6.091464e-001, 6.091050e-001, 6.090635e-001, 6.090220e-001, 6.089804e-001, 6.089389e-001, 6.088973e-001, 6.088558e-001, 6.088142e-001, 6.087726e-001, 6.087310e-001, 6.086894e-001, 6.086478e-001, 6.086062e-001, 6.085645e-001, 6.085229e-001, 6.084812e-001, 6.084395e-001, 6.083978e-001, 6.083561e-001, 6.083144e-001, 6.082727e-001, 6.082309e-001, 6.081892e-001, 6.081474e-001, 6.081056e-001, 6.080638e-001, 6.080220e-001, 6.079802e-001, 6.079384e-001, 6.078965e-001, 
6.078547e-001, 6.078128e-001, 6.077709e-001, 6.077290e-001, 6.076871e-001, 6.076452e-001, 6.076033e-001, 6.075613e-001, 6.075194e-001, 6.074774e-001, 6.074355e-001, 6.073935e-001, 6.073515e-001, 6.073095e-001, 6.072674e-001, 6.072254e-001, 6.071833e-001, 6.071413e-001, 6.070992e-001, 6.070571e-001, 6.070150e-001, 6.069729e-001, 6.069308e-001, 6.068887e-001, 6.068465e-001, 6.068044e-001, 6.067622e-001, 6.067200e-001, 6.066778e-001, 6.066356e-001, 6.065934e-001, 6.065512e-001, 6.065089e-001, 6.064667e-001, 6.064244e-001, 6.063821e-001, 6.063398e-001, 6.062975e-001, 6.062552e-001, 6.062129e-001, 6.061705e-001, 6.061282e-001, 6.060858e-001, 6.060434e-001, 6.060011e-001, 6.059587e-001, 6.059162e-001, 6.058738e-001, 6.058314e-001, 6.057889e-001, 6.057465e-001, 6.057040e-001, 6.056615e-001, 6.056190e-001, 6.055765e-001, 6.055340e-001, 6.054915e-001, 6.054489e-001, 6.054064e-001, 6.053638e-001, 6.053212e-001, 6.052786e-001, 6.052360e-001, 6.051934e-001, 6.051508e-001, 6.051081e-001, 6.050655e-001, 6.050228e-001, 6.049801e-001, 6.049374e-001, 6.048947e-001, 6.048520e-001, 6.048093e-001, 6.047666e-001, 6.047238e-001, 6.046811e-001, 6.046383e-001, 6.045955e-001, 6.045527e-001, 6.045099e-001, 6.044671e-001, 6.044243e-001, 6.043814e-001, 6.043385e-001, 6.042957e-001, 6.042528e-001, 6.042099e-001, 6.041670e-001, 6.041241e-001, 6.040812e-001, 6.040382e-001, 6.039953e-001, 6.039523e-001, 6.039093e-001, 6.038663e-001, 6.038233e-001, 6.037803e-001, 6.037373e-001, 6.036943e-001, 6.036512e-001, 
6.036082e-001, 6.035651e-001, 6.035220e-001, 6.034789e-001, 6.034358e-001, 6.033927e-001, 6.033496e-001, 6.033064e-001, 6.032633e-001, 6.032201e-001, 6.031769e-001, 6.031337e-001, 6.030905e-001, 6.030473e-001, 6.030041e-001, 6.029609e-001, 6.029176e-001, 6.028743e-001, 6.028311e-001, 6.027878e-001, 6.027445e-001, 6.027012e-001, 6.026579e-001, 6.026145e-001, 6.025712e-001, 6.025278e-001, 6.024845e-001, 6.024411e-001, 6.023977e-001, 6.023543e-001, 6.023109e-001, 6.022674e-001, 6.022240e-001, 6.021806e-001, 6.021371e-001, 6.020936e-001, 6.020501e-001, 6.020066e-001, 6.019631e-001, 6.019196e-001, 6.018761e-001, 6.018325e-001, 6.017890e-001, 6.017454e-001, 6.017018e-001, 6.016582e-001, 6.016146e-001, 6.015710e-001, 6.015274e-001, 6.014838e-001, 6.014401e-001, 6.013964e-001, 6.013528e-001, 6.013091e-001, 6.012654e-001, 6.012217e-001, 6.011780e-001, 6.011342e-001, 6.010905e-001, 6.010467e-001, 6.010030e-001, 6.009592e-001, 6.009154e-001, 6.008716e-001, 6.008278e-001, 6.007839e-001, 6.007401e-001, 6.006963e-001, 6.006524e-001, 6.006085e-001, 6.005646e-001, 6.005207e-001, 6.004768e-001, 6.004329e-001, 6.003890e-001, 6.003450e-001, 6.003011e-001, 6.002571e-001, 6.002131e-001, 6.001691e-001, 6.001251e-001, 6.000811e-001, 6.000371e-001, 5.999931e-001, 5.999490e-001, 5.999050e-001, 5.998609e-001, 5.998168e-001, 5.997727e-001, 5.997286e-001, 5.996845e-001, 5.996404e-001, 5.995962e-001, 5.995521e-001, 5.995079e-001, 5.994637e-001, 5.994195e-001, 5.993753e-001, 5.993311e-001, 5.992869e-001, 
5.992427e-001, 5.991984e-001, 5.991542e-001, 5.991099e-001, 5.990656e-001, 5.990213e-001, 5.989770e-001, 5.989327e-001, 5.988884e-001, 5.988440e-001, 5.987997e-001, 5.987553e-001, 5.987110e-001, 5.986666e-001, 5.986222e-001, 5.985778e-001, 5.985333e-001, 5.984889e-001, 5.984445e-001, 5.984000e-001, 5.983556e-001, 5.983111e-001, 5.982666e-001, 5.982221e-001, 5.981776e-001, 5.981330e-001, 5.980885e-001, 5.980440e-001, 5.979994e-001, 5.979548e-001, 5.979103e-001, 5.978657e-001, 5.978211e-001, 5.977764e-001, 5.977318e-001, 5.976872e-001, 5.976425e-001, 5.975979e-001, 5.975532e-001, 5.975085e-001, 5.974638e-001, 5.974191e-001, 5.973744e-001, 5.973297e-001, 5.972849e-001, 5.972402e-001, 5.971954e-001, 5.971506e-001, 5.971058e-001, 5.970610e-001, 5.970162e-001, 5.969714e-001, 5.969266e-001, 5.968817e-001, 5.968369e-001, 5.967920e-001, 5.967471e-001, 5.967022e-001, 5.966573e-001, 5.966124e-001, 5.965675e-001, 5.965226e-001, 5.964776e-001, 5.964327e-001, 5.963877e-001, 5.963427e-001, 5.962977e-001, 5.962527e-001, 5.962077e-001, 5.961627e-001, 5.961176e-001, 5.960726e-001, 5.960275e-001, 5.959824e-001, 5.959373e-001, 5.958923e-001, 5.958471e-001, 5.958020e-001, 5.957569e-001, 5.957118e-001, 5.956666e-001, 5.956214e-001, 5.955763e-001, 5.955311e-001, 5.954859e-001, 5.954407e-001, 5.953954e-001, 5.953502e-001, 5.953050e-001, 5.952597e-001, 5.952145e-001, 5.951692e-001, 5.951239e-001, 5.950786e-001, 5.950333e-001, 5.949880e-001, 5.949426e-001, 5.948973e-001, 5.948519e-001, 5.948065e-001, 
5.947612e-001, 5.947158e-001, 5.946704e-001, 5.946250e-001, 5.945795e-001, 5.945341e-001, 5.944887e-001, 5.944432e-001, 5.943977e-001, 5.943522e-001, 5.943068e-001, 5.942612e-001, 5.942157e-001, 5.941702e-001, 5.941247e-001, 5.940791e-001, 5.940336e-001, 5.939880e-001, 5.939424e-001, 5.938968e-001, 5.938512e-001, 5.938056e-001, 5.937600e-001, 5.937143e-001, 5.936687e-001, 5.936230e-001, 5.935773e-001, 5.935317e-001, 5.934860e-001, 5.934403e-001, 5.933945e-001, 5.933488e-001, 5.933031e-001, 5.932573e-001, 5.932116e-001, 5.931658e-001, 5.931200e-001, 5.930742e-001, 5.930284e-001, 5.929826e-001, 5.929368e-001, 5.928909e-001, 5.928451e-001, 5.927992e-001, 5.927533e-001, 5.927074e-001, 5.926615e-001, 5.926156e-001, 5.925697e-001, 5.925238e-001, 5.924779e-001, 5.924319e-001, 5.923859e-001, 5.923400e-001, 5.922940e-001, 5.922480e-001, 5.922020e-001, 5.921560e-001, 5.921099e-001, 5.920639e-001, 5.920178e-001, 5.919718e-001, 5.919257e-001, 5.918796e-001, 5.918335e-001, 5.917874e-001, 5.917413e-001, 5.916952e-001, 5.916490e-001, 5.916029e-001, 5.915567e-001, 5.915105e-001, 5.914643e-001, 5.914181e-001, 5.913719e-001, 5.913257e-001, 5.912795e-001, 5.912333e-001, 5.911870e-001, 5.911407e-001, 5.910945e-001, 5.910482e-001, 5.910019e-001, 5.909556e-001, 5.909093e-001, 5.908629e-001, 5.908166e-001, 5.907702e-001, 5.907239e-001, 5.906775e-001, 5.906311e-001, 5.905847e-001, 5.905383e-001, 5.904919e-001, 5.904455e-001, 5.903990e-001, 5.903526e-001, 5.903061e-001, 5.902596e-001, 5.902132e-001, 
5.901667e-001, 5.901202e-001, 5.900736e-001, 5.900271e-001, 5.899806e-001, 5.899340e-001, 5.898875e-001, 5.898409e-001, 5.897943e-001, 5.897477e-001, 5.897011e-001, 5.896545e-001, 5.896079e-001, 5.895612e-001, 5.895146e-001, 5.894679e-001, 5.894213e-001, 5.893746e-001, 5.893279e-001, 5.892812e-001, 5.892345e-001, 5.891877e-001, 5.891410e-001, 5.890943e-001, 5.890475e-001, 5.890007e-001, 5.889540e-001, 5.889072e-001, 5.888604e-001, 5.888136e-001, 5.887667e-001, 5.887199e-001, 5.886731e-001, 5.886262e-001, 5.885793e-001, 5.885325e-001, 5.884856e-001, 5.884387e-001, 5.883918e-001, 5.883448e-001, 5.882979e-001, 5.882510e-001, 5.882040e-001, 5.881570e-001, 5.881101e-001, 5.880631e-001, 5.880161e-001, 5.879691e-001, 5.879220e-001, 5.878750e-001, 5.878280e-001, 5.877809e-001, 5.877339e-001, 5.876868e-001, 5.876397e-001, 5.875926e-001, 5.875455e-001, 5.874984e-001, 5.874513e-001, 5.874041e-001, 5.873570e-001, 5.873098e-001, 5.872626e-001, 5.872155e-001, 5.871683e-001, 5.871211e-001, 5.870739e-001, 5.870266e-001, 5.869794e-001, 5.869321e-001, 5.868849e-001, 5.868376e-001, 5.867903e-001, 5.867431e-001, 5.866958e-001, 5.866484e-001, 5.866011e-001, 5.865538e-001, 5.865064e-001, 5.864591e-001, 5.864117e-001, 5.863643e-001, 5.863170e-001, 5.862696e-001, 5.862222e-001, 5.861747e-001, 5.861273e-001, 5.860799e-001, 5.860324e-001, 5.859850e-001, 5.859375e-001, 5.858900e-001, 5.858425e-001, 5.857950e-001, 5.857475e-001, 5.857000e-001, 5.856524e-001, 5.856049e-001, 5.855573e-001, 5.855097e-001, 
5.854622e-001, 5.854146e-001, 5.853670e-001, 5.853194e-001, 5.852717e-001, 5.852241e-001, 5.851765e-001, 5.851288e-001, 5.850811e-001, 5.850335e-001, 5.849858e-001, 5.849381e-001, 5.848904e-001, 5.848427e-001, 5.847949e-001, 5.847472e-001, 5.846994e-001, 5.846517e-001, 5.846039e-001, 5.845561e-001, 5.845083e-001, 5.844605e-001, 5.844127e-001, 5.843649e-001, 5.843171e-001, 5.842692e-001, 5.842213e-001, 5.841735e-001, 5.841256e-001, 5.840777e-001, 5.840298e-001, 5.839819e-001, 5.839340e-001, 5.838861e-001, 5.838381e-001, 5.837902e-001, 5.837422e-001, 5.836942e-001, 5.836462e-001, 5.835982e-001, 5.835502e-001, 5.835022e-001, 5.834542e-001, 5.834062e-001, 5.833581e-001, 5.833101e-001, 5.832620e-001, 5.832139e-001, 5.831658e-001, 5.831177e-001, 5.830696e-001, 5.830215e-001, 5.829734e-001, 5.829252e-001, 5.828771e-001, 5.828289e-001, 5.827807e-001, 5.827325e-001, 5.826843e-001, 5.826361e-001, 5.825879e-001, 5.825397e-001, 5.824915e-001, 5.824432e-001, 5.823949e-001, 5.823467e-001, 5.822984e-001, 5.822501e-001, 5.822018e-001, 5.821535e-001, 5.821052e-001, 5.820568e-001, 5.820085e-001, 5.819601e-001, 5.819118e-001, 5.818634e-001, 5.818150e-001, 5.817666e-001, 5.817182e-001, 5.816698e-001, 5.816214e-001, 5.815729e-001, 5.815245e-001, 5.814760e-001, 5.814276e-001, 5.813791e-001, 5.813306e-001, 5.812821e-001, 5.812336e-001, 5.811851e-001, 5.811365e-001, 5.810880e-001, 5.810395e-001, 5.809909e-001, 5.809423e-001, 5.808937e-001, 5.808451e-001, 5.807965e-001, 5.807479e-001, 5.806993e-001, 
5.806507e-001, 5.806020e-001, 5.805534e-001, 5.805047e-001, 5.804560e-001, 5.804073e-001, 5.803586e-001, 5.803099e-001, 5.802612e-001, 5.802125e-001, 5.801637e-001, 5.801150e-001, 5.800662e-001, 5.800175e-001, 5.799687e-001, 5.799199e-001, 5.798711e-001, 5.798223e-001, 5.797735e-001, 5.797246e-001, 5.796758e-001, 5.796269e-001, 5.795781e-001, 5.795292e-001, 5.794803e-001, 5.794314e-001, 5.793825e-001, 5.793336e-001, 5.792847e-001, 5.792357e-001, 5.791868e-001, 5.791378e-001, 5.790889e-001, 5.790399e-001, 5.789909e-001, 5.789419e-001, 5.788929e-001, 5.788439e-001, 5.787949e-001, 5.787458e-001, 5.786968e-001, 5.786477e-001, 5.785987e-001, 5.785496e-001, 5.785005e-001, 5.784514e-001, 5.784023e-001, 5.783532e-001, 5.783040e-001, 5.782549e-001, 5.782057e-001, 5.781566e-001, 5.781074e-001, 5.780582e-001, 5.780090e-001, 5.779598e-001, 5.779106e-001, 5.778614e-001, 5.778122e-001, 5.777629e-001, 5.777137e-001, 5.776644e-001, 5.776151e-001, 5.775658e-001, 5.775165e-001, 5.774672e-001, 5.774179e-001, 5.773686e-001, 5.773193e-001, 5.772699e-001, 5.772206e-001, 5.771712e-001, 5.771218e-001, 5.770724e-001, 5.770230e-001, 5.769736e-001, 5.769242e-001, 5.768748e-001, 5.768253e-001, 5.767759e-001, 5.767264e-001, 5.766770e-001, 5.766275e-001, 5.765780e-001, 5.765285e-001, 5.764790e-001, 5.764295e-001, 5.763800e-001, 5.763304e-001, 5.762809e-001, 5.762313e-001, 5.761817e-001, 5.761322e-001, 5.760826e-001, 5.760330e-001, 5.759834e-001, 5.759337e-001, 5.758841e-001, 5.758345e-001, 5.757848e-001, 
5.757352e-001, 5.756855e-001, 5.756358e-001, 5.755861e-001, 5.755364e-001, 5.754867e-001, 5.754370e-001, 5.753873e-001, 5.753375e-001, 5.752878e-001, 5.752380e-001, 5.751882e-001, 5.751385e-001, 5.750887e-001, 5.750389e-001, 5.749891e-001, 5.749392e-001, 5.748894e-001, 5.748396e-001, 5.747897e-001, 5.747399e-001, 5.746900e-001, 5.746401e-001, 5.745902e-001, 5.745403e-001, 5.744904e-001, 5.744405e-001, 5.743905e-001, 5.743406e-001, 5.742906e-001, 5.742407e-001, 5.741907e-001, 5.741407e-001, 5.740907e-001, 5.740407e-001, 5.739907e-001, 5.739407e-001, 5.738907e-001, 5.738406e-001, 5.737906e-001, 5.737405e-001, 5.736904e-001, 5.736404e-001, 5.735903e-001, 5.735402e-001, 5.734901e-001, 5.734399e-001, 5.733898e-001, 5.733397e-001, 5.732895e-001, 5.732394e-001, 5.731892e-001, 5.731390e-001, 5.730888e-001, 5.730386e-001, 5.729884e-001, 5.729382e-001, 5.728879e-001, 5.728377e-001, 5.727875e-001, 5.727372e-001, 5.726869e-001, 5.726366e-001, 5.725864e-001, 5.725361e-001, 5.724857e-001, 5.724354e-001, 5.723851e-001, 5.723348e-001, 5.722844e-001, 5.722340e-001, 5.721837e-001, 5.721333e-001, 5.720829e-001, 5.720325e-001, 5.719821e-001, 5.719317e-001, 5.718812e-001, 5.718308e-001, 5.717804e-001, 5.717299e-001, 5.716794e-001, 5.716290e-001, 5.715785e-001, 5.715280e-001, 5.714775e-001, 5.714269e-001, 5.713764e-001, 5.713259e-001, 5.712753e-001, 5.712248e-001, 5.711742e-001, 5.711236e-001, 5.710730e-001, 5.710225e-001, 5.709718e-001, 5.709212e-001, 5.708706e-001, 5.708200e-001, 5.707693e-001, 
5.707187e-001, 5.706680e-001, 5.706173e-001, 5.705666e-001, 5.705159e-001, 5.704652e-001, 5.704145e-001, 5.703638e-001, 5.703131e-001, 5.702623e-001, 5.702116e-001, 5.701608e-001, 5.701100e-001, 5.700593e-001, 5.700085e-001, 5.699577e-001, 5.699069e-001, 5.698560e-001, 5.698052e-001, 5.697544e-001, 5.697035e-001, 5.696527e-001, 5.696018e-001, 5.695509e-001, 5.695000e-001, 5.694491e-001, 5.693982e-001, 5.693473e-001, 5.692964e-001, 5.692454e-001, 5.691945e-001, 5.691435e-001, 5.690925e-001, 5.690416e-001, 5.689906e-001, 5.689396e-001, 5.688886e-001, 5.688376e-001, 5.687865e-001, 5.687355e-001, 5.686845e-001, 5.686334e-001, 5.685823e-001, 5.685313e-001, 5.684802e-001, 5.684291e-001, 5.683780e-001, 5.683269e-001, 5.682758e-001, 5.682246e-001, 5.681735e-001, 5.681223e-001, 5.680712e-001, 5.680200e-001, 5.679688e-001, 5.679176e-001, 5.678664e-001, 5.678152e-001, 5.677640e-001, 5.677128e-001, 5.676615e-001, 5.676103e-001, 5.675590e-001, 5.675078e-001, 5.674565e-001, 5.674052e-001, 5.673539e-001, 5.673026e-001, 5.672513e-001, 5.672000e-001, 5.671486e-001, 5.670973e-001, 5.670459e-001, 5.669946e-001, 5.669432e-001, 5.668918e-001, 5.668404e-001, 5.667890e-001, 5.667376e-001, 5.666862e-001, 5.666348e-001, 5.665833e-001, 5.665319e-001, 5.664804e-001, 5.664289e-001, 5.663775e-001, 5.663260e-001, 5.662745e-001, 5.662230e-001, 5.661715e-001, 5.661199e-001, 5.660684e-001, 5.660169e-001, 5.659653e-001, 5.659137e-001, 5.658622e-001, 5.658106e-001, 5.657590e-001, 5.657074e-001, 5.656558e-001, 
5.656042e-001, 5.655525e-001, 5.655009e-001, 5.654492e-001, 5.653976e-001, 5.653459e-001, 5.652942e-001, 5.652426e-001, 5.651909e-001, 5.651392e-001, 5.650874e-001, 5.650357e-001, 5.649840e-001, 5.649322e-001, 5.648805e-001, 5.648287e-001, 5.647770e-001, 5.647252e-001, 5.646734e-001, 5.646216e-001, 5.645698e-001, 5.645180e-001, 5.644661e-001, 5.644143e-001, 5.643624e-001, 5.643106e-001, 5.642587e-001, 5.642068e-001, 5.641550e-001, 5.641031e-001, 5.640512e-001, 5.639992e-001, 5.639473e-001, 5.638954e-001, 5.638434e-001, 5.637915e-001, 5.637395e-001, 5.636876e-001, 5.636356e-001, 5.635836e-001, 5.635316e-001, 5.634796e-001, 5.634276e-001, 5.633755e-001, 5.633235e-001, 5.632715e-001, 5.632194e-001, 5.631674e-001, 5.631153e-001, 5.630632e-001, 5.630111e-001, 5.629590e-001, 5.629069e-001, 5.628548e-001, 5.628026e-001, 5.627505e-001, 5.626984e-001, 5.626462e-001, 5.625940e-001, 5.625419e-001, 5.624897e-001, 5.624375e-001, 5.623853e-001, 5.623331e-001, 5.622808e-001, 5.622286e-001, 5.621764e-001, 5.621241e-001, 5.620719e-001, 5.620196e-001, 5.619673e-001, 5.619150e-001, 5.618627e-001, 5.618104e-001, 5.617581e-001, 5.617058e-001, 5.616535e-001, 5.616011e-001, 5.615488e-001, 5.614964e-001, 5.614440e-001, 5.613916e-001, 5.613393e-001, 5.612869e-001, 5.612344e-001, 5.611820e-001, 5.611296e-001, 5.610772e-001, 5.610247e-001, 5.609723e-001, 5.609198e-001, 5.608673e-001, 5.608149e-001, 5.607624e-001, 5.607099e-001, 5.606574e-001, 5.606048e-001, 5.605523e-001, 5.604998e-001, 5.604472e-001, 
5.603947e-001, 5.603421e-001, 5.602895e-001, 5.602369e-001, 5.601844e-001, 5.601318e-001, 5.600791e-001, 5.600265e-001, 5.599739e-001, 5.599213e-001, 5.598686e-001, 5.598160e-001, 5.597633e-001, 5.597106e-001, 5.596579e-001, 5.596052e-001, 5.595525e-001, 5.594998e-001, 5.594471e-001, 5.593944e-001, 5.593416e-001, 5.592889e-001, 5.592361e-001, 5.591834e-001, 5.591306e-001, 5.590778e-001, 5.590250e-001, 5.589722e-001, 5.589194e-001, 5.588666e-001, 5.588137e-001, 5.587609e-001, 5.587081e-001, 5.586552e-001, 5.586023e-001, 5.585495e-001, 5.584966e-001, 5.584437e-001, 5.583908e-001, 5.583379e-001, 5.582849e-001, 5.582320e-001, 5.581791e-001, 5.581261e-001, 5.580732e-001, 5.580202e-001, 5.579672e-001, 5.579142e-001, 5.578612e-001, 5.578082e-001, 5.577552e-001, 5.577022e-001, 5.576492e-001, 5.575961e-001, 5.575431e-001, 5.574900e-001, 5.574370e-001, 5.573839e-001, 5.573308e-001, 5.572777e-001, 5.572246e-001, 5.571715e-001, 5.571184e-001, 5.570653e-001, 5.570121e-001, 5.569590e-001, 5.569058e-001, 5.568526e-001, 5.567995e-001, 5.567463e-001, 5.566931e-001, 5.566399e-001, 5.565867e-001, 5.565335e-001, 5.564802e-001, 5.564270e-001, 5.563738e-001, 5.563205e-001, 5.562672e-001, 5.562140e-001, 5.561607e-001, 5.561074e-001, 5.560541e-001, 5.560008e-001, 5.559475e-001, 5.558941e-001, 5.558408e-001, 5.557875e-001, 5.557341e-001, 5.556807e-001, 5.556274e-001, 5.555740e-001, 5.555206e-001, 5.554672e-001, 5.554138e-001, 5.553604e-001, 5.553070e-001, 5.552535e-001, 5.552001e-001, 5.551466e-001, 
5.550932e-001, 5.550397e-001, 5.549862e-001, 5.549327e-001, 5.548792e-001, 5.548257e-001, 5.547722e-001, 5.547187e-001, 5.546652e-001, 5.546116e-001, 5.545581e-001, 5.545045e-001, 5.544509e-001, 5.543974e-001, 5.543438e-001, 5.542902e-001, 5.542366e-001, 5.541830e-001, 5.541294e-001, 5.540757e-001, 5.540221e-001, 5.539684e-001, 5.539148e-001, 5.538611e-001, 5.538075e-001, 5.537538e-001, 5.537001e-001, 5.536464e-001, 5.535927e-001, 5.535390e-001, 5.534852e-001, 5.534315e-001, 5.533777e-001, 5.533240e-001, 5.532702e-001, 5.532165e-001, 5.531627e-001, 5.531089e-001, 5.530551e-001, 5.530013e-001, 5.529475e-001, 5.528937e-001, 5.528398e-001, 5.527860e-001, 5.527321e-001, 5.526783e-001, 5.526244e-001, 5.525705e-001, 5.525166e-001, 5.524628e-001, 5.524089e-001, 5.523549e-001, 5.523010e-001, 5.522471e-001, 5.521932e-001, 5.521392e-001, 5.520853e-001, 5.520313e-001, 5.519773e-001, 5.519233e-001, 5.518694e-001, 5.518154e-001, 5.517614e-001, 5.517073e-001, 5.516533e-001, 5.515993e-001, 5.515452e-001, 5.514912e-001, 5.514371e-001, 5.513831e-001, 5.513290e-001, 5.512749e-001, 5.512208e-001, 5.511667e-001, 5.511126e-001, 5.510585e-001, 5.510043e-001, 5.509502e-001, 5.508961e-001, 5.508419e-001, 5.507877e-001, 5.507336e-001, 5.506794e-001, 5.506252e-001, 5.505710e-001, 5.505168e-001, 5.504626e-001, 5.504084e-001, 5.503541e-001, 5.502999e-001, 5.502456e-001, 5.501914e-001, 5.501371e-001, 5.500828e-001, 5.500286e-001, 5.499743e-001, 5.499200e-001, 5.498656e-001, 5.498113e-001, 5.497570e-001, 
5.497027e-001, 5.496483e-001, 5.495940e-001, 5.495396e-001, 5.494852e-001, 5.494309e-001, 5.493765e-001, 5.493221e-001, 5.492677e-001, 5.492133e-001, 5.491588e-001, 5.491044e-001, 5.490500e-001, 5.489955e-001, 5.489411e-001, 5.488866e-001, 5.488321e-001, 5.487776e-001, 5.487232e-001, 5.486687e-001, 5.486142e-001, 5.485596e-001, 5.485051e-001, 5.484506e-001, 5.483960e-001, 5.483415e-001, 5.482869e-001, 5.482324e-001, 5.481778e-001, 5.481232e-001, 5.480686e-001, 5.480140e-001, 5.479594e-001, 5.479048e-001, 5.478502e-001, 5.477955e-001, 5.477409e-001, 5.476862e-001, 5.476316e-001, 5.475769e-001, 5.475222e-001, 5.474675e-001, 5.474128e-001, 5.473581e-001, 5.473034e-001, 5.472487e-001, 5.471940e-001, 5.471392e-001, 5.470845e-001, 5.470297e-001, 5.469750e-001, 5.469202e-001, 5.468654e-001, 5.468106e-001, 5.467558e-001, 5.467010e-001, 5.466462e-001, 5.465914e-001, 5.465366e-001, 5.464817e-001, 5.464269e-001, 5.463720e-001, 5.463172e-001, 5.462623e-001, 5.462074e-001, 5.461525e-001, 5.460976e-001, 5.460427e-001, 5.459878e-001, 5.459329e-001, 5.458780e-001, 5.458230e-001, 5.457681e-001, 5.457131e-001, 5.456582e-001, 5.456032e-001, 5.455482e-001, 5.454932e-001, 5.454382e-001, 5.453832e-001, 5.453282e-001, 5.452732e-001, 5.452181e-001, 5.451631e-001, 5.451081e-001, 5.450530e-001, 5.449979e-001, 5.449429e-001, 5.448878e-001, 5.448327e-001, 5.447776e-001, 5.447225e-001, 5.446674e-001, 5.446123e-001, 5.445571e-001, 5.445020e-001, 5.444468e-001, 5.443917e-001, 5.443365e-001, 5.442813e-001, 
5.442262e-001, 5.441710e-001, 5.441158e-001, 5.440606e-001, 5.440054e-001, 5.439501e-001, 5.438949e-001, 5.438397e-001, 5.437844e-001, 5.437292e-001, 5.436739e-001, 5.436186e-001, 5.435633e-001, 5.435081e-001, 5.434528e-001, 5.433975e-001, 5.433421e-001, 5.432868e-001, 5.432315e-001, 5.431762e-001, 5.431208e-001, 5.430655e-001, 5.430101e-001, 5.429547e-001, 5.428993e-001, 5.428440e-001, 5.427886e-001, 5.427332e-001, 5.426777e-001, 5.426223e-001, 5.425669e-001, 5.425115e-001, 5.424560e-001, 5.424006e-001, 5.423451e-001, 5.422896e-001, 5.422342e-001, 5.421787e-001, 5.421232e-001, 5.420677e-001, 5.420122e-001, 5.419566e-001, 5.419011e-001, 5.418456e-001, 5.417900e-001, 5.417345e-001, 5.416789e-001, 5.416234e-001, 5.415678e-001, 5.415122e-001, 5.414566e-001, 5.414010e-001, 5.413454e-001, 5.412898e-001, 5.412342e-001, 5.411785e-001, 5.411229e-001, 5.410672e-001, 5.410116e-001, 5.409559e-001, 5.409002e-001, 5.408446e-001, 5.407889e-001, 5.407332e-001, 5.406775e-001, 5.406217e-001, 5.405660e-001, 5.405103e-001, 5.404546e-001, 5.403988e-001, 5.403431e-001, 5.402873e-001, 5.402315e-001, 5.401757e-001, 5.401200e-001, 5.400642e-001, 5.400084e-001, 5.399525e-001, 5.398967e-001, 5.398409e-001, 5.397851e-001, 5.397292e-001, 5.396734e-001, 5.396175e-001, 5.395616e-001, 5.395058e-001, 5.394499e-001, 5.393940e-001, 5.393381e-001, 5.392822e-001, 5.392263e-001, 5.391703e-001, 5.391144e-001, 5.390585e-001, 5.390025e-001, 5.389466e-001, 5.388906e-001, 5.388346e-001, 5.387787e-001, 5.387227e-001, 
5.386667e-001, 5.386107e-001, 5.385547e-001, 5.384986e-001, 5.384426e-001, 5.383866e-001, 5.383305e-001, 5.382745e-001, 5.382184e-001, 5.381623e-001, 5.381063e-001, 5.380502e-001, 5.379941e-001, 5.379380e-001, 5.378819e-001, 5.378258e-001, 5.377696e-001, 5.377135e-001, 5.376574e-001, 5.376012e-001, 5.375451e-001, 5.374889e-001, 5.374327e-001, 5.373766e-001, 5.373204e-001, 5.372642e-001, 5.372080e-001, 5.371518e-001, 5.370955e-001, 5.370393e-001, 5.369831e-001, 5.369268e-001, 5.368706e-001, 5.368143e-001, 5.367581e-001, 5.367018e-001, 5.366455e-001, 5.365892e-001, 5.365329e-001, 5.364766e-001, 5.364203e-001, 5.363640e-001, 5.363076e-001, 5.362513e-001, 5.361950e-001, 5.361386e-001, 5.360823e-001, 5.360259e-001, 5.359695e-001, 5.359131e-001, 5.358567e-001, 5.358003e-001, 5.357439e-001, 5.356875e-001, 5.356311e-001, 5.355746e-001, 5.355182e-001, 5.354618e-001, 5.354053e-001, 5.353488e-001, 5.352924e-001, 5.352359e-001, 5.351794e-001, 5.351229e-001, 5.350664e-001, 5.350099e-001, 5.349534e-001, 5.348969e-001, 5.348403e-001, 5.347838e-001, 5.347272e-001, 5.346707e-001, 5.346141e-001, 5.345575e-001, 5.345010e-001, 5.344444e-001, 5.343878e-001, 5.343312e-001, 5.342746e-001, 5.342179e-001, 5.341613e-001, 5.341047e-001, 5.340480e-001, 5.339914e-001, 5.339347e-001, 5.338781e-001, 5.338214e-001, 5.337647e-001, 5.337080e-001, 5.336513e-001, 5.335946e-001, 5.335379e-001, 5.334812e-001, 5.334245e-001, 5.333677e-001, 5.333110e-001, 5.332542e-001, 5.331975e-001, 5.331407e-001, 5.330839e-001, 
5.330272e-001, 5.329704e-001, 5.329136e-001, 5.328568e-001, 5.328000e-001, 5.327431e-001, 5.326863e-001, 5.326295e-001, 5.325726e-001, 5.325158e-001, 5.324589e-001, 5.324021e-001, 5.323452e-001, 5.322883e-001, 5.322314e-001, 5.321745e-001, 5.321176e-001, 5.320607e-001, 5.320038e-001, 5.319469e-001, 5.318899e-001, 5.318330e-001, 5.317760e-001, 5.317191e-001, 5.316621e-001, 5.316051e-001, 5.315482e-001, 5.314912e-001, 5.314342e-001, 5.313772e-001, 5.313202e-001, 5.312631e-001, 5.312061e-001, 5.311491e-001, 5.310920e-001, 5.310350e-001, 5.309779e-001, 5.309209e-001, 5.308638e-001, 5.308067e-001, 5.307496e-001, 5.306925e-001, 5.306354e-001, 5.305783e-001, 5.305212e-001, 5.304641e-001, 5.304070e-001, 5.303498e-001, 5.302927e-001, 5.302355e-001, 5.301784e-001, 5.301212e-001, 5.300640e-001, 5.300068e-001, 5.299496e-001, 5.298924e-001, 5.298352e-001, 5.297780e-001, 5.297208e-001, 5.296636e-001, 5.296063e-001, 5.295491e-001, 5.294918e-001, 5.294346e-001, 5.293773e-001, 5.293200e-001, 5.292627e-001, 5.292054e-001, 5.291481e-001, 5.290908e-001, 5.290335e-001, 5.289762e-001, 5.289189e-001, 5.288615e-001, 5.288042e-001, 5.287468e-001, 5.286895e-001, 5.286321e-001, 5.285748e-001, 5.285174e-001, 5.284600e-001, 5.284026e-001, 5.283452e-001, 5.282878e-001, 5.282304e-001, 5.281729e-001, 5.281155e-001, 5.280581e-001, 5.280006e-001, 5.279432e-001, 5.278857e-001, 5.278282e-001, 5.277707e-001, 5.277133e-001, 5.276558e-001, 5.275983e-001, 5.275408e-001, 5.274833e-001, 5.274257e-001, 5.273682e-001, 
5.273107e-001, 5.272531e-001, 5.271956e-001, 5.271380e-001, 5.270804e-001, 5.270229e-001, 5.269653e-001, 5.269077e-001, 5.268501e-001, 5.267925e-001, 5.267349e-001, 5.266773e-001, 5.266197e-001, 5.265620e-001, 5.265044e-001, 5.264467e-001, 5.263891e-001, 5.263314e-001, 5.262738e-001, 5.262161e-001, 5.261584e-001, 5.261007e-001, 5.260430e-001, 5.259853e-001, 5.259276e-001, 5.258699e-001, 5.258121e-001, 5.257544e-001, 5.256967e-001, 5.256389e-001, 5.255812e-001, 5.255234e-001, 5.254656e-001, 5.254078e-001, 5.253500e-001, 5.252923e-001, 5.252345e-001, 5.251766e-001, 5.251188e-001, 5.250610e-001, 5.250032e-001, 5.249453e-001, 5.248875e-001, 5.248296e-001, 5.247718e-001, 5.247139e-001, 5.246560e-001, 5.245982e-001, 5.245403e-001, 5.244824e-001, 5.244245e-001, 5.243666e-001, 5.243087e-001, 5.242507e-001, 5.241928e-001, 5.241349e-001, 5.240769e-001, 5.240190e-001, 5.239610e-001, 5.239030e-001, 5.238451e-001, 5.237871e-001, 5.237291e-001, 5.236711e-001, 5.236131e-001, 5.235551e-001, 5.234971e-001, 5.234390e-001, 5.233810e-001, 5.233230e-001, 5.232649e-001, 5.232069e-001, 5.231488e-001, 5.230907e-001, 5.230326e-001, 5.229746e-001, 5.229165e-001, 5.228584e-001, 5.228003e-001, 5.227422e-001, 5.226840e-001, 5.226259e-001, 5.225678e-001, 5.225096e-001, 5.224515e-001, 5.223933e-001, 5.223352e-001, 5.222770e-001, 5.222188e-001, 5.221607e-001, 5.221025e-001, 5.220443e-001, 5.219861e-001, 5.219278e-001, 5.218696e-001, 5.218114e-001, 5.217532e-001, 5.216949e-001, 5.216367e-001, 5.215784e-001, 
5.215202e-001, 5.214619e-001, 5.214036e-001, 5.213453e-001, 5.212870e-001, 5.212288e-001, 5.211704e-001, 5.211121e-001, 5.210538e-001, 5.209955e-001, 5.209372e-001, 5.208788e-001, 5.208205e-001, 5.207621e-001, 5.207038e-001, 5.206454e-001, 5.205870e-001, 5.205286e-001, 5.204702e-001, 5.204119e-001, 5.203535e-001, 5.202950e-001, 5.202366e-001, 5.201782e-001, 5.201198e-001, 5.200613e-001, 5.200029e-001, 5.199444e-001, 5.198860e-001, 5.198275e-001, 5.197690e-001, 5.197106e-001, 5.196521e-001, 5.195936e-001, 5.195351e-001, 5.194766e-001, 5.194180e-001, 5.193595e-001, 5.193010e-001, 5.192425e-001, 5.191839e-001, 5.191254e-001, 5.190668e-001, 5.190082e-001, 5.189497e-001, 5.188911e-001, 5.188325e-001, 5.187739e-001, 5.187153e-001, 5.186567e-001, 5.185981e-001, 5.185395e-001, 5.184809e-001, 5.184222e-001, 5.183636e-001, 5.183049e-001, 5.182463e-001, 5.181876e-001, 5.181290e-001, 5.180703e-001, 5.180116e-001, 5.179529e-001, 5.178942e-001, 5.178355e-001, 5.177768e-001, 5.177181e-001, 5.176594e-001, 5.176006e-001, 5.175419e-001, 5.174831e-001, 5.174244e-001, 5.173656e-001, 5.173069e-001, 5.172481e-001, 5.171893e-001, 5.171305e-001, 5.170717e-001, 5.170129e-001, 5.169541e-001, 5.168953e-001, 5.168365e-001, 5.167777e-001, 5.167188e-001, 5.166600e-001, 5.166012e-001, 5.165423e-001, 5.164834e-001, 5.164246e-001, 5.163657e-001, 5.163068e-001, 5.162479e-001, 5.161890e-001, 5.161301e-001, 5.160712e-001, 5.160123e-001, 5.159534e-001, 5.158945e-001, 5.158355e-001, 5.157766e-001, 5.157176e-001, 
5.156587e-001, 5.155997e-001, 5.155407e-001, 5.154818e-001, 5.154228e-001, 5.153638e-001, 5.153048e-001, 5.152458e-001, 5.151868e-001, 5.151278e-001, 5.150687e-001, 5.150097e-001, 5.149507e-001, 5.148916e-001, 5.148326e-001, 5.147735e-001, 5.147144e-001, 5.146554e-001, 5.145963e-001, 5.145372e-001, 5.144781e-001, 5.144190e-001, 5.143599e-001, 5.143008e-001, 5.142417e-001, 5.141825e-001, 5.141234e-001, 5.140643e-001, 5.140051e-001, 5.139460e-001, 5.138868e-001, 5.138277e-001, 5.137685e-001, 5.137093e-001, 5.136501e-001, 5.135909e-001, 5.135317e-001, 5.134725e-001, 5.134133e-001, 5.133541e-001, 5.132949e-001, 5.132356e-001, 5.131764e-001, 5.131171e-001, 5.130579e-001, 5.129986e-001, 5.129394e-001, 5.128801e-001, 5.128208e-001, 5.127615e-001, 5.127022e-001, 5.126429e-001, 5.125836e-001, 5.125243e-001, 5.124650e-001, 5.124057e-001, 5.123463e-001, 5.122870e-001, 5.122276e-001, 5.121683e-001, 5.121089e-001, 5.120496e-001, 5.119902e-001, 5.119308e-001, 5.118714e-001, 5.118120e-001, 5.117526e-001, 5.116932e-001, 5.116338e-001, 5.115744e-001, 5.115150e-001, 5.114555e-001, 5.113961e-001, 5.113367e-001, 5.112772e-001, 5.112178e-001, 5.111583e-001, 5.110988e-001, 5.110393e-001, 5.109799e-001, 5.109204e-001, 5.108609e-001, 5.108014e-001, 5.107418e-001, 5.106823e-001, 5.106228e-001, 5.105633e-001, 5.105037e-001, 5.104442e-001, 5.103846e-001, 5.103251e-001, 5.102655e-001, 5.102060e-001, 5.101464e-001, 5.100868e-001, 5.100272e-001, 5.099676e-001, 5.099080e-001, 5.098484e-001, 5.097888e-001, 
5.097292e-001, 5.096695e-001, 5.096099e-001, 5.095503e-001, 5.094906e-001, 5.094310e-001, 5.093713e-001, 5.093116e-001, 5.092520e-001, 5.091923e-001, 5.091326e-001, 5.090729e-001, 5.090132e-001, 5.089535e-001, 5.088938e-001, 5.088341e-001, 5.087743e-001, 5.087146e-001, 5.086549e-001, 5.085951e-001, 5.085354e-001, 5.084756e-001, 5.084158e-001, 5.083561e-001, 5.082963e-001, 5.082365e-001, 5.081767e-001, 5.081169e-001, 5.080571e-001, 5.079973e-001, 5.079375e-001, 5.078777e-001, 5.078179e-001, 5.077580e-001, 5.076982e-001, 5.076383e-001, 5.075785e-001, 5.075186e-001, 5.074588e-001, 5.073989e-001, 5.073390e-001, 5.072791e-001, 5.072192e-001, 5.071593e-001, 5.070994e-001, 5.070395e-001, 5.069796e-001, 5.069197e-001, 5.068597e-001, 5.067998e-001, 5.067399e-001, 5.066799e-001, 5.066199e-001, 5.065600e-001, 5.065000e-001, 5.064400e-001, 5.063801e-001, 5.063201e-001, 5.062601e-001, 5.062001e-001, 5.061401e-001, 5.060801e-001, 5.060200e-001, 5.059600e-001, 5.059000e-001, 5.058399e-001, 5.057799e-001, 5.057199e-001, 5.056598e-001, 5.055997e-001, 5.055397e-001, 5.054796e-001, 5.054195e-001, 5.053594e-001, 5.052993e-001, 5.052392e-001, 5.051791e-001, 5.051190e-001, 5.050589e-001, 5.049988e-001, 5.049386e-001, 5.048785e-001, 5.048183e-001, 5.047582e-001, 5.046980e-001, 5.046379e-001, 5.045777e-001, 5.045175e-001, 5.044573e-001, 5.043972e-001, 5.043370e-001, 5.042768e-001, 5.042165e-001, 5.041563e-001, 5.040961e-001, 5.040359e-001, 5.039757e-001, 5.039154e-001, 5.038552e-001, 5.037949e-001, 
5.037347e-001, 5.036744e-001, 5.036141e-001, 5.035539e-001, 5.034936e-001, 5.034333e-001, 5.033730e-001, 5.033127e-001, 5.032524e-001, 5.031921e-001, 5.031318e-001, 5.030714e-001, 5.030111e-001, 5.029508e-001, 5.028904e-001, 5.028301e-001, 5.027697e-001, 5.027094e-001, 5.026490e-001, 5.025886e-001, 5.025282e-001, 5.024678e-001, 5.024075e-001, 5.023471e-001, 5.022866e-001, 5.022262e-001, 5.021658e-001, 5.021054e-001, 5.020450e-001, 5.019845e-001, 5.019241e-001, 5.018636e-001, 5.018032e-001, 5.017427e-001, 5.016823e-001, 5.016218e-001, 5.015613e-001, 5.015008e-001, 5.014403e-001, 5.013798e-001, 5.013193e-001, 5.012588e-001, 5.011983e-001, 5.011378e-001, 5.010773e-001, 5.010167e-001, 5.009562e-001, 5.008957e-001, 5.008351e-001, 5.007745e-001, 5.007140e-001, 5.006534e-001, 5.005928e-001, 5.005323e-001, 5.004717e-001, 5.004111e-001, 5.003505e-001, 5.002899e-001, 5.002293e-001, 5.001686e-001, 5.001080e-001, 5.000474e-001, 4.999867e-001, 4.999261e-001, 4.998655e-001, 4.998048e-001, 4.997441e-001, 4.996835e-001, 4.996228e-001, 4.995621e-001, 4.995014e-001, 4.994408e-001, 4.993801e-001, 4.993194e-001, 4.992587e-001, 4.991979e-001, 4.991372e-001, 4.990765e-001, 4.990158e-001, 4.989550e-001, 4.988943e-001, 4.988335e-001, 4.987728e-001, 4.987120e-001, 4.986512e-001, 4.985905e-001, 4.985297e-001, 4.984689e-001, 4.984081e-001, 4.983473e-001, 4.982865e-001, 4.982257e-001, 4.981649e-001, 4.981041e-001, 4.980433e-001, 4.979824e-001, 4.979216e-001, 4.978607e-001, 4.977999e-001, 4.977390e-001, 
4.976782e-001, 4.976173e-001, 4.975564e-001, 4.974955e-001, 4.974347e-001, 4.973738e-001, 4.973129e-001, 4.972520e-001, 4.971911e-001, 4.971301e-001, 4.970692e-001, 4.970083e-001, 4.969474e-001, 4.968864e-001, 4.968255e-001, 4.967645e-001, 4.967036e-001, 4.966426e-001, 4.965816e-001, 4.965207e-001, 4.964597e-001, 4.963987e-001, 4.963377e-001, 4.962767e-001, 4.962157e-001, 4.961547e-001, 4.960937e-001, 4.960327e-001, 4.959716e-001, 4.959106e-001, 4.958496e-001, 4.957885e-001, 4.957275e-001, 4.956664e-001, 4.956054e-001, 4.955443e-001, 4.954832e-001, 4.954221e-001, 4.953611e-001, 4.953000e-001, 4.952389e-001, 4.951778e-001, 4.951167e-001, 4.950556e-001, 4.949944e-001, 4.949333e-001, 4.948722e-001, 4.948110e-001, 4.947499e-001, 4.946888e-001, 4.946276e-001, 4.945664e-001, 4.945053e-001, 4.944441e-001, 4.943829e-001, 4.943218e-001, 4.942606e-001, 4.941994e-001, 4.941382e-001, 4.940770e-001, 4.940158e-001, 4.939545e-001, 4.938933e-001, 4.938321e-001, 4.937709e-001, 4.937096e-001, 4.936484e-001, 4.935871e-001, 4.935259e-001, 4.934646e-001, 4.934033e-001, 4.933421e-001, 4.932808e-001, 4.932195e-001, 4.931582e-001, 4.930969e-001, 4.930356e-001, 4.929743e-001, 4.929130e-001, 4.928517e-001, 4.927903e-001, 4.927290e-001, 4.926677e-001, 4.926063e-001, 4.925450e-001, 4.924836e-001, 4.924223e-001, 4.923609e-001, 4.922995e-001, 4.922382e-001, 4.921768e-001, 4.921154e-001, 4.920540e-001, 4.919926e-001, 4.919312e-001, 4.918698e-001, 4.918084e-001, 4.917470e-001, 4.916855e-001, 4.916241e-001, 
4.915627e-001, 4.915012e-001, 4.914398e-001, 4.913783e-001, 4.913169e-001, 4.912554e-001, 4.911939e-001, 4.911324e-001, 4.910710e-001, 4.910095e-001, 4.909480e-001, 4.908865e-001, 4.908250e-001, 4.907635e-001, 4.907020e-001, 4.906404e-001, 4.905789e-001, 4.905174e-001, 4.904558e-001, 4.903943e-001, 4.903328e-001, 4.902712e-001, 4.902096e-001, 4.901481e-001, 4.900865e-001, 4.900249e-001, 4.899633e-001, 4.899018e-001, 4.898402e-001, 4.897786e-001, 4.897170e-001, 4.896554e-001, 4.895937e-001, 4.895321e-001, 4.894705e-001, 4.894089e-001, 4.893472e-001, 4.892856e-001, 4.892239e-001, 4.891623e-001, 4.891006e-001, 4.890390e-001, 4.889773e-001, 4.889156e-001, 4.888539e-001, 4.887922e-001, 4.887306e-001, 4.886689e-001, 4.886072e-001, 4.885454e-001, 4.884837e-001, 4.884220e-001, 4.883603e-001, 4.882986e-001, 4.882368e-001, 4.881751e-001, 4.881133e-001, 4.880516e-001, 4.879898e-001, 4.879281e-001, 4.878663e-001, 4.878045e-001, 4.877427e-001, 4.876810e-001, 4.876192e-001, 4.875574e-001, 4.874956e-001, 4.874338e-001, 4.873720e-001, 4.873101e-001, 4.872483e-001, 4.871865e-001, 4.871247e-001, 4.870628e-001, 4.870010e-001, 4.869391e-001, 4.868773e-001, 4.868154e-001, 4.867535e-001, 4.866917e-001, 4.866298e-001, 4.865679e-001, 4.865060e-001, 4.864441e-001, 4.863822e-001, 4.863203e-001, 4.862584e-001, 4.861965e-001, 4.861346e-001, 4.860727e-001, 4.860108e-001, 4.859488e-001, 4.858869e-001, 4.858249e-001, 4.857630e-001, 4.857010e-001, 4.856391e-001, 4.855771e-001, 4.855151e-001, 4.854531e-001, 
4.853912e-001, 4.853292e-001, 4.852672e-001, 4.852052e-001, 4.851432e-001, 4.850812e-001, 4.850192e-001, 4.849571e-001, 4.848951e-001, 4.848331e-001, 4.847711e-001, 4.847090e-001, 4.846470e-001, 4.845849e-001, 4.845229e-001, 4.844608e-001, 4.843987e-001, 4.843367e-001, 4.842746e-001, 4.842125e-001, 4.841504e-001, 4.840883e-001, 4.840262e-001, 4.839641e-001, 4.839020e-001, 4.838399e-001, 4.837778e-001, 4.837156e-001, 4.836535e-001, 4.835914e-001, 4.835292e-001, 4.834671e-001, 4.834049e-001, 4.833428e-001, 4.832806e-001, 4.832185e-001, 4.831563e-001, 4.830941e-001, 4.830319e-001, 4.829698e-001, 4.829076e-001, 4.828454e-001, 4.827832e-001, 4.827210e-001, 4.826587e-001, 4.825965e-001, 4.825343e-001, 4.824721e-001, 4.824098e-001, 4.823476e-001, 4.822854e-001, 4.822231e-001, 4.821609e-001, 4.820986e-001, 4.820363e-001, 4.819741e-001, 4.819118e-001, 4.818495e-001, 4.817872e-001, 4.817249e-001, 4.816626e-001, 4.816003e-001, 4.815380e-001, 4.814757e-001, 4.814134e-001, 4.813511e-001, 4.812888e-001, 4.812264e-001, 4.811641e-001, 4.811017e-001, 4.810394e-001, 4.809771e-001, 4.809147e-001, 4.808523e-001, 4.807900e-001, 4.807276e-001, 4.806652e-001, 4.806028e-001, 4.805405e-001, 4.804781e-001, 4.804157e-001, 4.803533e-001, 4.802909e-001, 4.802284e-001, 4.801660e-001, 4.801036e-001, 4.800412e-001, 4.799787e-001, 4.799163e-001, 4.798539e-001, 4.797914e-001, 4.797290e-001, 4.796665e-001, 4.796040e-001, 4.795416e-001, 4.794791e-001, 4.794166e-001, 4.793541e-001, 4.792917e-001, 4.792292e-001, 
4.791667e-001, 4.791042e-001, 4.790417e-001, 4.789791e-001, 4.789166e-001, 4.788541e-001, 4.787916e-001, 4.787290e-001, 4.786665e-001, 4.786040e-001, 4.785414e-001, 4.784789e-001, 4.784163e-001, 4.783537e-001, 4.782912e-001, 4.782286e-001, 4.781660e-001, 4.781034e-001, 4.780409e-001, 4.779783e-001, 4.779157e-001, 4.778531e-001, 4.777905e-001, 4.777279e-001, 4.776652e-001, 4.776026e-001, 4.775400e-001, 4.774774e-001, 4.774147e-001, 4.773521e-001, 4.772894e-001, 4.772268e-001, 4.771641e-001, 4.771015e-001, 4.770388e-001, 4.769761e-001, 4.769134e-001, 4.768508e-001, 4.767881e-001, 4.767254e-001, 4.766627e-001, 4.766000e-001, 4.765373e-001, 4.764746e-001, 4.764119e-001, 4.763491e-001, 4.762864e-001, 4.762237e-001, 4.761610e-001, 4.760982e-001, 4.760355e-001, 4.759727e-001, 4.759100e-001, 4.758472e-001, 4.757845e-001, 4.757217e-001, 4.756589e-001, 4.755961e-001, 4.755334e-001, 4.754706e-001, 4.754078e-001, 4.753450e-001, 4.752822e-001, 4.752194e-001, 4.751566e-001, 4.750937e-001, 4.750309e-001, 4.749681e-001, 4.749053e-001, 4.748424e-001, 4.747796e-001, 4.747167e-001, 4.746539e-001, 4.745910e-001, 4.745282e-001, 4.744653e-001, 4.744024e-001, 4.743396e-001, 4.742767e-001, 4.742138e-001, 4.741509e-001, 4.740880e-001, 4.740251e-001, 4.739622e-001, 4.738993e-001, 4.738364e-001, 4.737735e-001, 4.737106e-001, 4.736476e-001, 4.735847e-001, 4.735218e-001, 4.734588e-001, 4.733959e-001, 4.733329e-001, 4.732700e-001, 4.732070e-001, 4.731441e-001, 4.730811e-001, 4.730181e-001, 4.729551e-001, 
4.728922e-001, 4.728292e-001, 4.727662e-001, 4.727032e-001, 4.726402e-001, 4.725772e-001, 4.725142e-001, 4.724512e-001, 4.723881e-001, 4.723251e-001, 4.722621e-001, 4.721990e-001, 4.721360e-001, 4.720730e-001, 4.720099e-001, 4.719469e-001, 4.718838e-001, 4.718207e-001, 4.717577e-001, 4.716946e-001, 4.716315e-001, 4.715684e-001, 4.715054e-001, 4.714423e-001, 4.713792e-001, 4.713161e-001, 4.712530e-001, 4.711899e-001, 4.711268e-001, 4.710636e-001, 4.710005e-001, 4.709374e-001, 4.708743e-001, 4.708111e-001, 4.707480e-001, 4.706848e-001, 4.706217e-001, 4.705585e-001, 4.704954e-001, 4.704322e-001, 4.703690e-001, 4.703059e-001, 4.702427e-001, 4.701795e-001, 4.701163e-001, 4.700531e-001, 4.699899e-001, 4.699267e-001, 4.698635e-001, 4.698003e-001, 4.697371e-001, 4.696739e-001, 4.696107e-001, 4.695474e-001, 4.694842e-001, 4.694210e-001, 4.693577e-001, 4.692945e-001, 4.692312e-001, 4.691680e-001, 4.691047e-001, 4.690415e-001, 4.689782e-001, 4.689149e-001, 4.688516e-001, 4.687884e-001, 4.687251e-001, 4.686618e-001, 4.685985e-001, 4.685352e-001, 4.684719e-001, 4.684086e-001, 4.683453e-001, 4.682819e-001, 4.682186e-001, 4.681553e-001, 4.680920e-001, 4.680286e-001, 4.679653e-001, 4.679019e-001, 4.678386e-001, 4.677752e-001, 4.677119e-001, 4.676485e-001, 4.675851e-001, 4.675218e-001, 4.674584e-001, 4.673950e-001, 4.673316e-001, 4.672682e-001, 4.672048e-001, 4.671414e-001, 4.670780e-001, 4.670146e-001, 4.669512e-001, 4.668878e-001, 4.668244e-001, 4.667610e-001, 4.666975e-001, 4.666341e-001, 
4.665707e-001, 4.665072e-001, 4.664438e-001, 4.663803e-001, 4.663169e-001, 4.662534e-001, 4.661899e-001, 4.661265e-001, 4.660630e-001, 4.659995e-001, 4.659360e-001, 4.658726e-001, 4.658091e-001, 4.657456e-001, 4.656821e-001, 4.656186e-001, 4.655551e-001, 4.654916e-001, 4.654280e-001, 4.653645e-001, 4.653010e-001, 4.652375e-001, 4.651739e-001, 4.651104e-001, 4.650468e-001, 4.649833e-001, 4.649197e-001, 4.648562e-001, 4.647926e-001, 4.647291e-001, 4.646655e-001, 4.646019e-001, 4.645384e-001, 4.644748e-001, 4.644112e-001, 4.643476e-001, 4.642840e-001, 4.642204e-001, 4.641568e-001, 4.640932e-001, 4.640296e-001, 4.639660e-001, 4.639023e-001, 4.638387e-001, 4.637751e-001, 4.637115e-001, 4.636478e-001, 4.635842e-001, 4.635205e-001, 4.634569e-001, 4.633932e-001, 4.633296e-001, 4.632659e-001, 4.632022e-001, 4.631386e-001, 4.630749e-001, 4.630112e-001, 4.629475e-001, 4.628838e-001, 4.628202e-001, 4.627565e-001, 4.626928e-001, 4.626290e-001, 4.625653e-001, 4.625016e-001, 4.624379e-001, 4.623742e-001, 4.623105e-001, 4.622467e-001, 4.621830e-001, 4.621193e-001, 4.620555e-001, 4.619918e-001, 4.619280e-001, 4.618643e-001, 4.618005e-001, 4.617367e-001, 4.616730e-001, 4.616092e-001, 4.615454e-001, 4.614816e-001, 4.614179e-001, 4.613541e-001, 4.612903e-001, 4.612265e-001, 4.611627e-001, 4.610989e-001, 4.610351e-001, 4.609713e-001, 4.609074e-001, 4.608436e-001, 4.607798e-001, 4.607160e-001, 4.606521e-001, 4.605883e-001, 4.605244e-001, 4.604606e-001, 4.603967e-001, 4.603329e-001, 4.602690e-001, 
4.602052e-001, 4.601413e-001, 4.600774e-001, 4.600136e-001, 4.599497e-001, 4.598858e-001, 4.598219e-001, 4.597580e-001, 4.596941e-001, 4.596302e-001, 4.595663e-001, 4.595024e-001, 4.594385e-001, 4.593746e-001, 4.593107e-001, 4.592467e-001, 4.591828e-001, 4.591189e-001, 4.590549e-001, 4.589910e-001, 4.589271e-001, 4.588631e-001, 4.587991e-001, 4.587352e-001, 4.586712e-001, 4.586073e-001, 4.585433e-001, 4.584793e-001, 4.584154e-001, 4.583514e-001, 4.582874e-001, 4.582234e-001, 4.581594e-001, 4.580954e-001, 4.580314e-001, 4.579674e-001, 4.579034e-001, 4.578394e-001, 4.577754e-001, 4.577113e-001, 4.576473e-001, 4.575833e-001, 4.575193e-001, 4.574552e-001, 4.573912e-001, 4.573271e-001, 4.572631e-001, 4.571990e-001, 4.571350e-001, 4.570709e-001, 4.570069e-001, 4.569428e-001, 4.568787e-001, 4.568146e-001, 4.567506e-001, 4.566865e-001, 4.566224e-001, 4.565583e-001, 4.564942e-001, 4.564301e-001, 4.563660e-001, 4.563019e-001, 4.562378e-001, 4.561737e-001, 4.561095e-001, 4.560454e-001, 4.559813e-001, 4.559172e-001, 4.558530e-001, 4.557889e-001, 4.557247e-001, 4.556606e-001, 4.555964e-001, 4.555323e-001, 4.554681e-001, 4.554040e-001, 4.553398e-001, 4.552756e-001, 4.552115e-001, 4.551473e-001, 4.550831e-001, 4.550189e-001, 4.549547e-001, 4.548905e-001, 4.548263e-001, 4.547621e-001, 4.546979e-001, 4.546337e-001, 4.545695e-001, 4.545053e-001, 4.544411e-001, 4.543769e-001, 4.543126e-001, 4.542484e-001, 4.541842e-001, 4.541199e-001, 4.540557e-001, 4.539914e-001, 4.539272e-001, 4.538629e-001, 
4.537987e-001, 4.537344e-001, 4.536701e-001, 4.536059e-001, 4.535416e-001, 4.534773e-001, 4.534130e-001, 4.533488e-001, 4.532845e-001, 4.532202e-001, 4.531559e-001, 4.530916e-001, 4.530273e-001, 4.529630e-001, 4.528987e-001, 4.528343e-001, 4.527700e-001, 4.527057e-001, 4.526414e-001, 4.525770e-001, 4.525127e-001, 4.524484e-001, 4.523840e-001, 4.523197e-001, 4.522553e-001, 4.521910e-001, 4.521266e-001, 4.520623e-001, 4.519979e-001, 4.519335e-001, 4.518692e-001, 4.518048e-001, 4.517404e-001, 4.516760e-001, 4.516116e-001, 4.515473e-001, 4.514829e-001, 4.514185e-001, 4.513541e-001, 4.512897e-001, 4.512253e-001, 4.511608e-001, 4.510964e-001, 4.510320e-001, 4.509676e-001, 4.509032e-001, 4.508387e-001, 4.507743e-001, 4.507099e-001, 4.506454e-001, 4.505810e-001, 4.505165e-001, 4.504521e-001, 4.503876e-001, 4.503232e-001, 4.502587e-001, 4.501942e-001, 4.501298e-001, 4.500653e-001, 4.500008e-001, 4.499363e-001, 4.498719e-001, 4.498074e-001, 4.497429e-001, 4.496784e-001, 4.496139e-001, 4.495494e-001, 4.494849e-001, 4.494204e-001, 4.493558e-001, 4.492913e-001, 4.492268e-001, 4.491623e-001, 4.490978e-001, 4.490332e-001, 4.489687e-001, 4.489042e-001, 4.488396e-001, 4.487751e-001, 4.487105e-001, 4.486460e-001, 4.485814e-001, 4.485168e-001, 4.484523e-001, 4.483877e-001, 4.483231e-001, 4.482586e-001, 4.481940e-001, 4.481294e-001, 4.480648e-001, 4.480002e-001, 4.479356e-001, 4.478711e-001, 4.478065e-001, 4.477419e-001, 4.476772e-001, 4.476126e-001, 4.475480e-001, 4.474834e-001, 4.474188e-001, 
4.473542e-001, 4.472895e-001, 4.472249e-001, 4.471603e-001, 4.470956e-001, 4.470310e-001, 4.469664e-001, 4.469017e-001, 4.468371e-001, 4.467724e-001, 4.467077e-001, 4.466431e-001, 4.465784e-001, 4.465137e-001, 4.464491e-001, 4.463844e-001, 4.463197e-001, 4.462550e-001, 4.461904e-001, 4.461257e-001, 4.460610e-001, 4.459963e-001, 4.459316e-001, 4.458669e-001, 4.458022e-001, 4.457375e-001, 4.456727e-001, 4.456080e-001, 4.455433e-001, 4.454786e-001, 4.454139e-001, 4.453491e-001, 4.452844e-001, 4.452197e-001, 4.451549e-001, 4.450902e-001, 4.450254e-001, 4.449607e-001, 4.448959e-001, 4.448312e-001, 4.447664e-001, 4.447016e-001, 4.446369e-001, 4.445721e-001, 4.445073e-001, 4.444425e-001, 4.443778e-001, 4.443130e-001, 4.442482e-001, 4.441834e-001, 4.441186e-001, 4.440538e-001, 4.439890e-001, 4.439242e-001, 4.438594e-001, 4.437946e-001, 4.437298e-001, 4.436649e-001, 4.436001e-001, 4.435353e-001, 4.434705e-001, 4.434056e-001, 4.433408e-001, 4.432760e-001, 4.432111e-001, 4.431463e-001, 4.430814e-001, 4.430166e-001, 4.429517e-001, 4.428869e-001, 4.428220e-001, 4.427571e-001, 4.426923e-001, 4.426274e-001, 4.425625e-001, 4.424977e-001, 4.424328e-001, 4.423679e-001, 4.423030e-001, 4.422381e-001, 4.421732e-001, 4.421083e-001, 4.420434e-001, 4.419785e-001, 4.419136e-001, 4.418487e-001, 4.417838e-001, 4.417189e-001, 4.416540e-001, 4.415890e-001, 4.415241e-001, 4.414592e-001, 4.413942e-001, 4.413293e-001, 4.412644e-001, 4.411994e-001, 4.411345e-001, 4.410695e-001, 4.410046e-001, 4.409396e-001, 
4.408747e-001, 4.408097e-001, 4.407447e-001, 4.406798e-001, 4.406148e-001, 4.405498e-001, 4.404848e-001, 4.404199e-001, 4.403549e-001, 4.402899e-001, 4.402249e-001, 4.401599e-001, 4.400949e-001, 4.400299e-001, 4.399649e-001, 4.398999e-001, 4.398349e-001, 4.397699e-001, 4.397049e-001, 4.396399e-001, 4.395748e-001, 4.395098e-001, 4.394448e-001, 4.393797e-001, 4.393147e-001, 4.392497e-001, 4.391846e-001, 4.391196e-001, 4.390545e-001, 4.389895e-001, 4.389244e-001, 4.388594e-001, 4.387943e-001, 4.387293e-001, 4.386642e-001, 4.385991e-001, 4.385341e-001, 4.384690e-001, 4.384039e-001, 4.383388e-001, 4.382737e-001, 4.382087e-001, 4.381436e-001, 4.380785e-001, 4.380134e-001, 4.379483e-001, 4.378832e-001, 4.378181e-001, 4.377530e-001, 4.376878e-001, 4.376227e-001, 4.375576e-001, 4.374925e-001, 4.374274e-001, 4.373622e-001, 4.372971e-001, 4.372320e-001, 4.371668e-001, 4.371017e-001, 4.370366e-001, 4.369714e-001, 4.369063e-001, 4.368411e-001, 4.367760e-001, 4.367108e-001, 4.366456e-001, 4.365805e-001, 4.365153e-001, 4.364501e-001, 4.363850e-001, 4.363198e-001, 4.362546e-001, 4.361894e-001, 4.361243e-001, 4.360591e-001, 4.359939e-001, 4.359287e-001, 4.358635e-001, 4.357983e-001, 4.357331e-001, 4.356679e-001, 4.356027e-001, 4.355375e-001, 4.354723e-001, 4.354070e-001, 4.353418e-001, 4.352766e-001, 4.352114e-001, 4.351461e-001, 4.350809e-001, 4.350157e-001, 4.349504e-001, 4.348852e-001, 4.348200e-001, 4.347547e-001, 4.346895e-001, 4.346242e-001, 4.345589e-001, 4.344937e-001, 4.344284e-001, 
4.343632e-001, 4.342979e-001, 4.342326e-001, 4.341674e-001, 4.341021e-001, 4.340368e-001, 4.339715e-001, 4.339062e-001, 4.338410e-001, 4.337757e-001, 4.337104e-001, 4.336451e-001, 4.335798e-001, 4.335145e-001, 4.334492e-001, 4.333839e-001, 4.333186e-001, 4.332532e-001, 4.331879e-001, 4.331226e-001, 4.330573e-001, 4.329920e-001, 4.329266e-001, 4.328613e-001, 4.327960e-001, 4.327306e-001, 4.326653e-001, 4.326000e-001, 4.325346e-001, 4.324693e-001, 4.324039e-001, 4.323386e-001, 4.322732e-001, 4.322079e-001, 4.321425e-001, 4.320771e-001, 4.320118e-001, 4.319464e-001, 4.318810e-001, 4.318157e-001, 4.317503e-001, 4.316849e-001, 4.316195e-001, 4.315541e-001, 4.314887e-001, 4.314234e-001, 4.313580e-001, 4.312926e-001, 4.312272e-001, 4.311618e-001, 4.310964e-001, 4.310309e-001, 4.309655e-001, 4.309001e-001, 4.308347e-001, 4.307693e-001, 4.307039e-001, 4.306384e-001, 4.305730e-001, 4.305076e-001, 4.304422e-001, 4.303767e-001, 4.303113e-001, 4.302458e-001, 4.301804e-001, 4.301150e-001, 4.300495e-001, 4.299841e-001, 4.299186e-001, 4.298531e-001, 4.297877e-001, 4.297222e-001, 4.296568e-001, 4.295913e-001, 4.295258e-001, 4.294603e-001, 4.293949e-001, 4.293294e-001, 4.292639e-001, 4.291984e-001, 4.291329e-001, 4.290675e-001, 4.290020e-001, 4.289365e-001, 4.288710e-001, 4.288055e-001, 4.287400e-001, 4.286745e-001, 4.286090e-001, 4.285434e-001, 4.284779e-001, 4.284124e-001, 4.283469e-001, 4.282814e-001, 4.282159e-001, 4.281503e-001, 4.280848e-001, 4.280193e-001, 4.279537e-001, 4.278882e-001, 
4.278227e-001, 4.277571e-001, 4.276916e-001, 4.276260e-001, 4.275605e-001, 4.274949e-001, 4.274294e-001, 4.273638e-001, 4.272983e-001, 4.272327e-001, 4.271671e-001, 4.271016e-001, 4.270360e-001, 4.269704e-001, 4.269049e-001, 4.268393e-001, 4.267737e-001, 4.267081e-001, 4.266425e-001, 4.265769e-001, 4.265114e-001, 4.264458e-001, 4.263802e-001, 4.263146e-001, 4.262490e-001, 4.261834e-001, 4.261178e-001, 4.260521e-001, 4.259865e-001, 4.259209e-001, 4.258553e-001, 4.257897e-001, 4.257241e-001, 4.256584e-001, 4.255928e-001, 4.255272e-001, 4.254616e-001, 4.253959e-001, 4.253303e-001, 4.252647e-001, 4.251990e-001, 4.251334e-001, 4.250677e-001, 4.250021e-001, 4.249364e-001, 4.248708e-001, 4.248051e-001, 4.247395e-001, 4.246738e-001, 4.246081e-001, 4.245425e-001, 4.244768e-001, 4.244111e-001, 4.243455e-001, 4.242798e-001, 4.242141e-001, 4.241484e-001, 4.240828e-001, 4.240171e-001, 4.239514e-001, 4.238857e-001, 4.238200e-001, 4.237543e-001, 4.236886e-001, 4.236229e-001, 4.235572e-001, 4.234915e-001, 4.234258e-001, 4.233601e-001, 4.232944e-001, 4.232287e-001, 4.231630e-001, 4.230972e-001, 4.230315e-001, 4.229658e-001, 4.229001e-001, 4.228343e-001, 4.227686e-001, 4.227029e-001, 4.226371e-001, 4.225714e-001, 4.225057e-001, 4.224399e-001, 4.223742e-001, 4.223084e-001, 4.222427e-001, 4.221769e-001, 4.221112e-001, 4.220454e-001, 4.219797e-001, 4.219139e-001, 4.218481e-001, 4.217824e-001, 4.217166e-001, 4.216508e-001, 4.215851e-001, 4.215193e-001, 4.214535e-001, 4.213877e-001, 4.213220e-001, 
4.212562e-001, 4.211904e-001, 4.211246e-001, 4.210588e-001, 4.209930e-001, 4.209272e-001, 4.208614e-001, 4.207956e-001, 4.207298e-001, 4.206640e-001, 4.205982e-001, 4.205324e-001, 4.204666e-001, 4.204008e-001, 4.203350e-001, 4.202691e-001, 4.202033e-001, 4.201375e-001, 4.200717e-001, 4.200058e-001, 4.199400e-001, 4.198742e-001, 4.198083e-001, 4.197425e-001, 4.196767e-001, 4.196108e-001, 4.195450e-001, 4.194791e-001, 4.194133e-001, 4.193474e-001, 4.192816e-001, 4.192157e-001, 4.191499e-001, 4.190840e-001, 4.190182e-001, 4.189523e-001, 4.188864e-001, 4.188206e-001, 4.187547e-001, 4.186888e-001, 4.186230e-001, 4.185571e-001, 4.184912e-001, 4.184253e-001, 4.183594e-001, 4.182936e-001, 4.182277e-001, 4.181618e-001, 4.180959e-001, 4.180300e-001, 4.179641e-001, 4.178982e-001, 4.178323e-001, 4.177664e-001, 4.177005e-001, 4.176346e-001, 4.175687e-001, 4.175028e-001, 4.174369e-001, 4.173710e-001, 4.173050e-001, 4.172391e-001, 4.171732e-001, 4.171073e-001, 4.170413e-001, 4.169754e-001, 4.169095e-001, 4.168436e-001, 4.167776e-001, 4.167117e-001, 4.166458e-001, 4.165798e-001, 4.165139e-001, 4.164479e-001, 4.163820e-001, 4.163160e-001, 4.162501e-001, 4.161841e-001, 4.161182e-001, 4.160522e-001, 4.159863e-001, 4.159203e-001, 4.158543e-001, 4.157884e-001, 4.157224e-001, 4.156564e-001, 4.155905e-001, 4.155245e-001, 4.154585e-001, 4.153925e-001, 4.153266e-001, 4.152606e-001, 4.151946e-001, 4.151286e-001, 4.150626e-001, 4.149966e-001, 4.149307e-001, 4.148647e-001, 4.147987e-001, 4.147327e-001, 
4.146667e-001, 4.146007e-001, 4.145347e-001, 4.144687e-001, 4.144027e-001, 4.143366e-001, 4.142706e-001, 4.142046e-001, 4.141386e-001, 4.140726e-001, 4.140066e-001, 4.139405e-001, 4.138745e-001, 4.138085e-001, 4.137425e-001, 4.136764e-001, 4.136104e-001, 4.135444e-001, 4.134783e-001, 4.134123e-001, 4.133463e-001, 4.132802e-001, 4.132142e-001, 4.131481e-001, 4.130821e-001, 4.130160e-001, 4.129500e-001, 4.128839e-001, 4.128179e-001, 4.127518e-001, 4.126858e-001, 4.126197e-001, 4.125537e-001, 4.124876e-001, 4.124215e-001, 4.123555e-001, 4.122894e-001, 4.122233e-001, 4.121573e-001, 4.120912e-001, 4.120251e-001, 4.119590e-001, 4.118929e-001, 4.118269e-001, 4.117608e-001, 4.116947e-001, 4.116286e-001, 4.115625e-001, 4.114964e-001, 4.114303e-001, 4.113642e-001, 4.112981e-001, 4.112320e-001, 4.111659e-001, 4.110998e-001, 4.110337e-001, 4.109676e-001, 4.109015e-001, 4.108354e-001, 4.107693e-001, 4.107032e-001, 4.106371e-001, 4.105709e-001, 4.105048e-001, 4.104387e-001, 4.103726e-001, 4.103065e-001, 4.102403e-001, 4.101742e-001, 4.101081e-001, 4.100419e-001, 4.099758e-001, 4.099097e-001, 4.098435e-001, 4.097774e-001, 4.097113e-001, 4.096451e-001, 4.095790e-001, 4.095128e-001, 4.094467e-001, 4.093805e-001, 4.093144e-001, 4.092482e-001, 4.091821e-001, 4.091159e-001, 4.090497e-001, 4.089836e-001, 4.089174e-001, 4.088513e-001, 4.087851e-001, 4.087189e-001, 4.086528e-001, 4.085866e-001, 4.085204e-001, 4.084542e-001, 4.083881e-001, 4.083219e-001, 4.082557e-001, 4.081895e-001, 4.081234e-001, 
4.080572e-001, 4.079910e-001, 4.079248e-001, 4.078586e-001, 4.077924e-001, 4.077262e-001, 4.076600e-001, 4.075938e-001, 4.075276e-001, 4.074614e-001, 4.073952e-001, 4.073290e-001, 4.072628e-001, 4.071966e-001, 4.071304e-001, 4.070642e-001, 4.069980e-001, 4.069318e-001, 4.068656e-001, 4.067993e-001, 4.067331e-001, 4.066669e-001, 4.066007e-001, 4.065345e-001, 4.064682e-001, 4.064020e-001, 4.063358e-001, 4.062696e-001, 4.062033e-001, 4.061371e-001, 4.060709e-001, 4.060046e-001, 4.059384e-001, 4.058722e-001, 4.058059e-001, 4.057397e-001, 4.056734e-001, 4.056072e-001, 4.055409e-001, 4.054747e-001, 4.054084e-001, 4.053422e-001, 4.052759e-001, 4.052097e-001, 4.051434e-001, 4.050772e-001, 4.050109e-001, 4.049446e-001, 4.048784e-001, 4.048121e-001, 4.047459e-001, 4.046796e-001, 4.046133e-001, 4.045470e-001, 4.044808e-001, 4.044145e-001, 4.043482e-001, 4.042820e-001, 4.042157e-001, 4.041494e-001, 4.040831e-001, 4.040168e-001, 4.039505e-001, 4.038843e-001, 4.038180e-001, 4.037517e-001, 4.036854e-001, 4.036191e-001, 4.035528e-001, 4.034865e-001, 4.034202e-001, 4.033539e-001, 4.032876e-001, 4.032213e-001, 4.031550e-001, 4.030887e-001, 4.030224e-001, 4.029561e-001, 4.028898e-001, 4.028235e-001, 4.027572e-001, 4.026909e-001, 4.026246e-001, 4.025582e-001, 4.024919e-001, 4.024256e-001, 4.023593e-001, 4.022930e-001, 4.022266e-001, 4.021603e-001, 4.020940e-001, 4.020277e-001, 4.019613e-001, 4.018950e-001, 4.018287e-001, 4.017623e-001, 4.016960e-001, 4.016297e-001, 4.015633e-001, 4.014970e-001, 
4.014307e-001, 4.013643e-001, 4.012980e-001, 4.012316e-001, 4.011653e-001, 4.010989e-001, 4.010326e-001, 4.009663e-001, 4.008999e-001, 4.008336e-001, 4.007672e-001, 4.007008e-001, 4.006345e-001, 4.005681e-001, 4.005018e-001, 4.004354e-001, 4.003690e-001, 4.003027e-001, 4.002363e-001, 4.001700e-001, 4.001036e-001, 4.000372e-001, 3.999709e-001, 3.999045e-001, 3.998381e-001, 3.997717e-001, 3.997054e-001, 3.996390e-001, 3.995726e-001, 3.995062e-001, 3.994399e-001, 3.993735e-001, 3.993071e-001, 3.992407e-001, 3.991743e-001, 3.991079e-001, 3.990415e-001, 3.989752e-001, 3.989088e-001, 3.988424e-001, 3.987760e-001, 3.987096e-001, 3.986432e-001, 3.985768e-001, 3.985104e-001, 3.984440e-001, 3.983776e-001, 3.983112e-001, 3.982448e-001, 3.981784e-001, 3.981120e-001, 3.980456e-001, 3.979792e-001, 3.979128e-001, 3.978463e-001, 3.977799e-001, 3.977135e-001, 3.976471e-001, 3.975807e-001, 3.975143e-001, 3.974479e-001, 3.973814e-001, 3.973150e-001, 3.972486e-001, 3.971822e-001, 3.971157e-001, 3.970493e-001, 3.969829e-001, 3.969165e-001, 3.968500e-001, 3.967836e-001, 3.967172e-001, 3.966507e-001, 3.965843e-001, 3.965179e-001, 3.964514e-001, 3.963850e-001, 3.963186e-001, 3.962521e-001, 3.961857e-001, 3.961192e-001, 3.960528e-001, 3.959864e-001, 3.959199e-001, 3.958535e-001, 3.957870e-001, 3.957206e-001, 3.956541e-001, 3.955877e-001, 3.955212e-001, 3.954548e-001, 3.953883e-001, 3.953219e-001, 3.952554e-001, 3.951889e-001, 3.951225e-001, 3.950560e-001, 3.949896e-001, 3.949231e-001, 3.948566e-001, 
3.947902e-001, 3.947237e-001, 3.946572e-001, 3.945908e-001, 3.945243e-001, 3.944578e-001, 3.943914e-001, 3.943249e-001, 3.942584e-001, 3.941919e-001, 3.941255e-001, 3.940590e-001, 3.939925e-001, 3.939260e-001, 3.938596e-001, 3.937931e-001, 3.937266e-001, 3.936601e-001, 3.935936e-001, 3.935271e-001, 3.934607e-001, 3.933942e-001, 3.933277e-001, 3.932612e-001, 3.931947e-001, 3.931282e-001, 3.930617e-001, 3.929952e-001, 3.929287e-001, 3.928622e-001, 3.927957e-001, 3.927292e-001, 3.926627e-001, 3.925962e-001, 3.925297e-001, 3.924632e-001, 3.923967e-001, 3.923302e-001, 3.922637e-001, 3.921972e-001, 3.921307e-001, 3.920642e-001, 3.919977e-001, 3.919312e-001, 3.918647e-001, 3.917982e-001, 3.917317e-001, 3.916651e-001, 3.915986e-001, 3.915321e-001, 3.914656e-001, 3.913991e-001, 3.913326e-001, 3.912661e-001, 3.911995e-001, 3.911330e-001, 3.910665e-001, 3.910000e-001, 3.909334e-001, 3.908669e-001, 3.908004e-001, 3.907339e-001, 3.906673e-001, 3.906008e-001, 3.905343e-001, 3.904678e-001, 3.904012e-001, 3.903347e-001, 3.902682e-001, 3.902016e-001, 3.901351e-001, 3.900686e-001, 3.900020e-001, 3.899355e-001, 3.898689e-001, 3.898024e-001, 3.897359e-001, 3.896693e-001, 3.896028e-001, 3.895362e-001, 3.894697e-001, 3.894032e-001, 3.893366e-001, 3.892701e-001, 3.892035e-001, 3.891370e-001, 3.890704e-001, 3.890039e-001, 3.889373e-001, 3.888708e-001, 3.888042e-001, 3.887377e-001, 3.886711e-001, 3.886046e-001, 3.885380e-001, 3.884715e-001, 3.884049e-001, 3.883383e-001, 3.882718e-001, 3.882052e-001, 
3.881387e-001, 3.880721e-001, 3.880055e-001, 3.879390e-001, 3.878724e-001, 3.878059e-001, 3.877393e-001, 3.876727e-001, 3.876062e-001, 3.875396e-001, 3.874730e-001, 3.874065e-001, 3.873399e-001, 3.872733e-001, 3.872067e-001, 3.871402e-001, 3.870736e-001, 3.870070e-001, 3.869405e-001, 3.868739e-001, 3.868073e-001, 3.867407e-001, 3.866742e-001, 3.866076e-001, 3.865410e-001, 3.864744e-001, 3.864078e-001, 3.863413e-001, 3.862747e-001, 3.862081e-001, 3.861415e-001, 3.860749e-001, 3.860084e-001, 3.859418e-001, 3.858752e-001, 3.858086e-001, 3.857420e-001, 3.856754e-001, 3.856088e-001, 3.855422e-001, 3.854757e-001, 3.854091e-001, 3.853425e-001, 3.852759e-001, 3.852093e-001, 3.851427e-001, 3.850761e-001, 3.850095e-001, 3.849429e-001, 3.848763e-001, 3.848097e-001, 3.847431e-001, 3.846765e-001, 3.846099e-001, 3.845433e-001, 3.844767e-001, 3.844101e-001, 3.843435e-001, 3.842769e-001, 3.842103e-001, 3.841437e-001, 3.840771e-001, 3.840105e-001, 3.839439e-001, 3.838773e-001, 3.838107e-001, 3.837441e-001, 3.836775e-001, 3.836109e-001, 3.835443e-001, 3.834777e-001, 3.834111e-001, 3.833445e-001, 3.832778e-001, 3.832112e-001, 3.831446e-001, 3.830780e-001, 3.830114e-001, 3.829448e-001, 3.828782e-001, 3.828116e-001, 3.827449e-001, 3.826783e-001, 3.826117e-001, 3.825451e-001, 3.824785e-001, 3.824119e-001, 3.823452e-001, 3.822786e-001, 3.822120e-001, 3.821454e-001, 3.820788e-001, 3.820122e-001, 3.819455e-001, 3.818789e-001, 3.818123e-001, 3.817457e-001, 3.816790e-001, 3.816124e-001, 3.815458e-001, 
3.814792e-001, 3.814125e-001, 3.813459e-001, 3.812793e-001, 3.812127e-001, 3.811460e-001, 3.810794e-001, 3.810128e-001, 3.809462e-001, 3.808795e-001, 3.808129e-001, 3.807463e-001, 3.806796e-001, 3.806130e-001, 3.805464e-001, 3.804797e-001, 3.804131e-001, 3.803465e-001, 3.802798e-001, 3.802132e-001, 3.801466e-001, 3.800799e-001, 3.800133e-001, 3.799467e-001, 3.798800e-001, 3.798134e-001, 3.797468e-001, 3.796801e-001, 3.796135e-001, 3.795468e-001, 3.794802e-001, 3.794136e-001, 3.793469e-001, 3.792803e-001, 3.792136e-001, 3.791470e-001, 3.790804e-001, 3.790137e-001, 3.789471e-001, 3.788804e-001, 3.788138e-001, 3.787472e-001, 3.786805e-001, 3.786139e-001, 3.785472e-001, 3.784806e-001, 3.784139e-001, 3.783473e-001, 3.782806e-001, 3.782140e-001, 3.781474e-001, 3.780807e-001, 3.780141e-001, 3.779474e-001, 3.778808e-001, 3.778141e-001, 3.777475e-001, 3.776808e-001, 3.776142e-001, 3.775475e-001, 3.774809e-001, 3.774142e-001, 3.773476e-001, 3.772809e-001, 3.772143e-001, 3.771476e-001, 3.770810e-001, 3.770143e-001, 3.769477e-001, 3.768810e-001, 3.768144e-001, 3.767477e-001, 3.766811e-001, 3.766144e-001, 3.765478e-001, 3.764811e-001, 3.764144e-001, 3.763478e-001, 3.762811e-001, 3.762145e-001, 3.761478e-001, 3.760812e-001, 3.760145e-001, 3.759479e-001, 3.758812e-001, 3.758145e-001, 3.757479e-001, 3.756812e-001, 3.756146e-001, 3.755479e-001, 3.754813e-001, 3.754146e-001, 3.753479e-001, 3.752813e-001, 3.752146e-001, 3.751480e-001, 3.750813e-001, 3.750146e-001, 3.749480e-001, 3.748813e-001, 
3.748147e-001, 3.747480e-001, 3.746813e-001, 3.746147e-001, 3.745480e-001, 3.744814e-001, 3.744147e-001, 3.743480e-001, 3.742814e-001, 3.742147e-001, 3.741481e-001, 3.740814e-001, 3.740147e-001, 3.739481e-001, 3.738814e-001, 3.738147e-001, 3.737481e-001, 3.736814e-001, 3.736148e-001, 3.735481e-001, 3.734814e-001, 3.734148e-001, 3.733481e-001, 3.732814e-001, 3.732148e-001, 3.731481e-001, 3.730814e-001, 3.730148e-001, 3.729481e-001, 3.728815e-001, 3.728148e-001, 3.727481e-001, 3.726815e-001, 3.726148e-001, 3.725481e-001, 3.724815e-001, 3.724148e-001, 3.723481e-001, 3.722815e-001, 3.722148e-001, 3.721481e-001, 3.720815e-001, 3.720148e-001, 3.719481e-001, 3.718815e-001, 3.718148e-001, 3.717481e-001, 3.716815e-001, 3.716148e-001, 3.715481e-001, 3.714815e-001, 3.714148e-001, 3.713481e-001, 3.712815e-001, 3.712148e-001, 3.711481e-001, 3.710815e-001, 3.710148e-001, 3.709481e-001, 3.708815e-001, 3.708148e-001, 3.707481e-001, 3.706815e-001, 3.706148e-001, 3.705481e-001, 3.704815e-001, 3.704148e-001, 3.703481e-001, 3.702815e-001, 3.702148e-001, 3.701481e-001, 3.700815e-001, 3.700148e-001, 3.699481e-001, 3.698815e-001, 3.698148e-001, 3.697481e-001, 3.696815e-001, 3.696148e-001, 3.695481e-001, 3.694815e-001, 3.694148e-001, 3.693481e-001, 3.692815e-001, 3.692148e-001, 3.691482e-001, 3.690815e-001, 3.690148e-001, 3.689482e-001, 3.688815e-001, 3.688148e-001, 3.687482e-001, 3.686815e-001, 3.686148e-001, 3.685482e-001, 3.684815e-001, 3.684148e-001, 3.683482e-001, 3.682815e-001, 3.682148e-001, 
3.681482e-001, 3.680815e-001, 3.680148e-001, 3.679482e-001, 3.678815e-001, 3.678148e-001, 3.677482e-001, 3.676815e-001, 3.676149e-001, 3.675482e-001, 3.674815e-001, 3.674149e-001, 3.673482e-001, 3.672815e-001, 3.672149e-001, 3.671482e-001, 3.670815e-001, 3.670149e-001, 3.669482e-001, 3.668816e-001, 3.668149e-001, 3.667482e-001, 3.666816e-001, 3.666149e-001, 3.665482e-001, 3.664816e-001, 3.664149e-001, 3.663483e-001, 3.662816e-001, 3.662149e-001, 3.661483e-001, 3.660816e-001, 3.660150e-001, 3.659483e-001, 3.658816e-001, 3.658150e-001, 3.657483e-001, 3.656817e-001, 3.656150e-001, 3.655483e-001, 3.654817e-001, 3.654150e-001, 3.653484e-001, 3.652817e-001, 3.652150e-001, 3.651484e-001, 3.650817e-001, 3.650151e-001, 3.649484e-001, 3.648818e-001, 3.648151e-001, 3.647484e-001, 3.646818e-001, 3.646151e-001, 3.645485e-001, 3.644818e-001, 3.644152e-001, 3.643485e-001, 3.642819e-001, 3.642152e-001, 3.641486e-001, 3.640819e-001, 3.640152e-001, 3.639486e-001, 3.638819e-001, 3.638153e-001, 3.637486e-001, 3.636820e-001, 3.636153e-001, 3.635487e-001, 3.634820e-001, 3.634154e-001, 3.633487e-001, 3.632821e-001, 3.632154e-001, 3.631488e-001, 3.630821e-001, 3.630155e-001, 3.629488e-001, 3.628822e-001, 3.628155e-001, 3.627489e-001, 3.626822e-001, 3.626156e-001, 3.625490e-001, 3.624823e-001, 3.624157e-001, 3.623490e-001, 3.622824e-001, 3.622157e-001, 3.621491e-001, 3.620824e-001, 3.620158e-001, 3.619492e-001, 3.618825e-001, 3.618159e-001, 3.617492e-001, 3.616826e-001, 3.616159e-001, 3.615493e-001, 
3.614827e-001, 3.614160e-001, 3.613494e-001, 3.612827e-001, 3.612161e-001, 3.611495e-001, 3.610828e-001, 3.610162e-001, 3.609496e-001, 3.608829e-001, 3.608163e-001, 3.607497e-001, 3.606830e-001, 3.606164e-001, 3.605497e-001, 3.604831e-001, 3.604165e-001, 3.603498e-001, 3.602832e-001, 3.602166e-001, 3.601500e-001, 3.600833e-001, 3.600167e-001, 3.599501e-001, 3.598834e-001, 3.598168e-001, 3.597502e-001, 3.596835e-001, 3.596169e-001, 3.595503e-001, 3.594837e-001, 3.594170e-001, 3.593504e-001, 3.592838e-001, 3.592172e-001, 3.591505e-001, 3.590839e-001, 3.590173e-001, 3.589507e-001, 3.588840e-001, 3.588174e-001, 3.587508e-001, 3.586842e-001, 3.586176e-001, 3.585509e-001, 3.584843e-001, 3.584177e-001, 3.583511e-001, 3.582845e-001, 3.582178e-001, 3.581512e-001, 3.580846e-001, 3.580180e-001, 3.579514e-001, 3.578848e-001, 3.578182e-001, 3.577515e-001, 3.576849e-001, 3.576183e-001, 3.575517e-001, 3.574851e-001, 3.574185e-001, 3.573519e-001, 3.572853e-001, 3.572187e-001, 3.571520e-001, 3.570854e-001, 3.570188e-001, 3.569522e-001, 3.568856e-001, 3.568190e-001, 3.567524e-001, 3.566858e-001, 3.566192e-001, 3.565526e-001, 3.564860e-001, 3.564194e-001, 3.563528e-001, 3.562862e-001, 3.562196e-001, 3.561530e-001, 3.560864e-001, 3.560198e-001, 3.559532e-001, 3.558866e-001, 3.558200e-001, 3.557534e-001, 3.556868e-001, 3.556202e-001, 3.555536e-001, 3.554871e-001, 3.554205e-001, 3.553539e-001, 3.552873e-001, 3.552207e-001, 3.551541e-001, 3.550875e-001, 3.550209e-001, 3.549543e-001, 3.548878e-001, 
3.548212e-001, 3.547546e-001, 3.546880e-001, 3.546214e-001, 3.545548e-001, 3.544883e-001, 3.544217e-001, 3.543551e-001, 3.542885e-001, 3.542219e-001, 3.541554e-001, 3.540888e-001, 3.540222e-001, 3.539556e-001, 3.538890e-001, 3.538225e-001, 3.537559e-001, 3.536893e-001, 3.536228e-001, 3.535562e-001, 3.534896e-001, 3.534230e-001, 3.533565e-001, 3.532899e-001, 3.532233e-001, 3.531568e-001, 3.530902e-001, 3.530236e-001, 3.529571e-001, 3.528905e-001, 3.528239e-001, 3.527574e-001, 3.526908e-001, 3.526243e-001, 3.525577e-001, 3.524911e-001, 3.524246e-001, 3.523580e-001, 3.522915e-001, 3.522249e-001, 3.521584e-001, 3.520918e-001, 3.520253e-001, 3.519587e-001, 3.518921e-001, 3.518256e-001, 3.517590e-001, 3.516925e-001, 3.516259e-001, 3.515594e-001, 3.514929e-001, 3.514263e-001, 3.513598e-001, 3.512932e-001, 3.512267e-001, 3.511601e-001, 3.510936e-001, 3.510271e-001, 3.509605e-001, 3.508940e-001, 3.508274e-001, 3.507609e-001, 3.506944e-001, 3.506278e-001, 3.505613e-001, 3.504948e-001, 3.504282e-001, 3.503617e-001, 3.502952e-001, 3.502286e-001, 3.501621e-001, 3.500956e-001, 3.500290e-001, 3.499625e-001, 3.498960e-001, 3.498295e-001, 3.497629e-001, 3.496964e-001, 3.496299e-001, 3.495634e-001, 3.494969e-001, 3.494303e-001, 3.493638e-001, 3.492973e-001, 3.492308e-001, 3.491643e-001, 3.490978e-001, 3.490313e-001, 3.489647e-001, 3.488982e-001, 3.488317e-001, 3.487652e-001, 3.486987e-001, 3.486322e-001, 3.485657e-001, 3.484992e-001, 3.484327e-001, 3.483662e-001, 3.482997e-001, 3.482332e-001, 
3.481667e-001, 3.481002e-001, 3.480337e-001, 3.479672e-001, 3.479007e-001, 3.478342e-001, 3.477677e-001, 3.477012e-001, 3.476347e-001, 3.475682e-001, 3.475017e-001, 3.474352e-001, 3.473687e-001, 3.473023e-001, 3.472358e-001, 3.471693e-001, 3.471028e-001, 3.470363e-001, 3.469698e-001, 3.469034e-001, 3.468369e-001, 3.467704e-001, 3.467039e-001, 3.466374e-001, 3.465710e-001, 3.465045e-001, 3.464380e-001, 3.463715e-001, 3.463051e-001, 3.462386e-001, 3.461721e-001, 3.461057e-001, 3.460392e-001, 3.459727e-001, 3.459063e-001, 3.458398e-001, 3.457733e-001, 3.457069e-001, 3.456404e-001, 3.455740e-001, 3.455075e-001, 3.454410e-001, 3.453746e-001, 3.453081e-001, 3.452417e-001, 3.451752e-001, 3.451088e-001, 3.450423e-001, 3.449759e-001, 3.449094e-001, 3.448430e-001, 3.447765e-001, 3.447101e-001, 3.446436e-001, 3.445772e-001, 3.445108e-001, 3.444443e-001, 3.443779e-001, 3.443114e-001, 3.442450e-001, 3.441786e-001, 3.441121e-001, 3.440457e-001, 3.439793e-001, 3.439128e-001, 3.438464e-001, 3.437800e-001, 3.437136e-001, 3.436471e-001, 3.435807e-001, 3.435143e-001, 3.434479e-001, 3.433814e-001, 3.433150e-001, 3.432486e-001, 3.431822e-001, 3.431158e-001, 3.430494e-001, 3.429829e-001, 3.429165e-001, 3.428501e-001, 3.427837e-001, 3.427173e-001, 3.426509e-001, 3.425845e-001, 3.425181e-001, 3.424517e-001, 3.423853e-001, 3.423189e-001, 3.422525e-001, 3.421861e-001, 3.421197e-001, 3.420533e-001, 3.419869e-001, 3.419205e-001, 3.418541e-001, 3.417877e-001, 3.417213e-001, 3.416549e-001, 3.415886e-001, 
3.415222e-001, 3.414558e-001, 3.413894e-001, 3.413230e-001, 3.412566e-001, 3.411903e-001, 3.411239e-001, 3.410575e-001, 3.409911e-001, 3.409248e-001, 3.408584e-001, 3.407920e-001, 3.407256e-001, 3.406593e-001, 3.405929e-001, 3.405265e-001, 3.404602e-001, 3.403938e-001, 3.403275e-001, 3.402611e-001, 3.401947e-001, 3.401284e-001, 3.400620e-001, 3.399957e-001, 3.399293e-001, 3.398630e-001, 3.397966e-001, 3.397303e-001, 3.396639e-001, 3.395976e-001, 3.395312e-001, 3.394649e-001, 3.393985e-001, 3.393322e-001, 3.392658e-001, 3.391995e-001, 3.391332e-001, 3.390668e-001, 3.390005e-001, 3.389342e-001, 3.388678e-001, 3.388015e-001, 3.387352e-001, 3.386689e-001, 3.386025e-001, 3.385362e-001, 3.384699e-001, 3.384036e-001, 3.383372e-001, 3.382709e-001, 3.382046e-001, 3.381383e-001, 3.380720e-001, 3.380057e-001, 3.379394e-001, 3.378730e-001, 3.378067e-001, 3.377404e-001, 3.376741e-001, 3.376078e-001, 3.375415e-001, 3.374752e-001, 3.374089e-001, 3.373426e-001, 3.372763e-001, 3.372100e-001, 3.371437e-001, 3.370774e-001, 3.370111e-001, 3.369449e-001, 3.368786e-001, 3.368123e-001, 3.367460e-001, 3.366797e-001, 3.366134e-001, 3.365472e-001, 3.364809e-001, 3.364146e-001, 3.363483e-001, 3.362821e-001, 3.362158e-001, 3.361495e-001, 3.360832e-001, 3.360170e-001, 3.359507e-001, 3.358844e-001, 3.358182e-001, 3.357519e-001, 3.356857e-001, 3.356194e-001, 3.355531e-001, 3.354869e-001, 3.354206e-001, 3.353544e-001, 3.352881e-001, 3.352219e-001, 3.351556e-001, 3.350894e-001, 3.350231e-001, 3.349569e-001, 
3.348907e-001, 3.348244e-001, 3.347582e-001, 3.346920e-001, 3.346257e-001, 3.345595e-001, 3.344933e-001, 3.344270e-001, 3.343608e-001, 3.342946e-001, 3.342283e-001, 3.341621e-001, 3.340959e-001, 3.340297e-001, 3.339635e-001, 3.338972e-001, 3.338310e-001, 3.337648e-001, 3.336986e-001, 3.336324e-001, 3.335662e-001, 3.335000e-001, 3.334338e-001, 3.333676e-001, 3.333014e-001, 3.332352e-001, 3.331690e-001, 3.331028e-001, 3.330366e-001, 3.329704e-001, 3.329042e-001, 3.328380e-001, 3.327718e-001, 3.327056e-001, 3.326395e-001, 3.325733e-001, 3.325071e-001, 3.324409e-001, 3.323747e-001, 3.323086e-001, 3.322424e-001, 3.321762e-001, 3.321100e-001, 3.320439e-001, 3.319777e-001, 3.319115e-001, 3.318454e-001, 3.317792e-001, 3.317130e-001, 3.316469e-001, 3.315807e-001, 3.315146e-001, 3.314484e-001, 3.313823e-001, 3.313161e-001, 3.312500e-001, 3.311838e-001, 3.311177e-001, 3.310515e-001, 3.309854e-001, 3.309193e-001, 3.308531e-001, 3.307870e-001, 3.307208e-001, 3.306547e-001, 3.305886e-001, 3.305225e-001, 3.304563e-001, 3.303902e-001, 3.303241e-001, 3.302580e-001, 3.301918e-001, 3.301257e-001, 3.300596e-001, 3.299935e-001, 3.299274e-001, 3.298613e-001, 3.297952e-001, 3.297291e-001, 3.296629e-001, 3.295968e-001, 3.295307e-001, 3.294646e-001, 3.293985e-001, 3.293324e-001, 3.292664e-001, 3.292003e-001, 3.291342e-001, 3.290681e-001, 3.290020e-001, 3.289359e-001, 3.288698e-001, 3.288037e-001, 3.287377e-001, 3.286716e-001, 3.286055e-001, 3.285394e-001, 3.284734e-001, 3.284073e-001, 3.283412e-001, 
3.282752e-001, 3.282091e-001, 3.281430e-001, 3.280770e-001, 3.280109e-001, 3.279449e-001, 3.278788e-001, 3.278128e-001, 3.277467e-001, 3.276807e-001, 3.276146e-001, 3.275486e-001, 3.274825e-001, 3.274165e-001, 3.273504e-001, 3.272844e-001, 3.272184e-001, 3.271523e-001, 3.270863e-001, 3.270203e-001, 3.269543e-001, 3.268882e-001, 3.268222e-001, 3.267562e-001, 3.266902e-001, 3.266241e-001, 3.265581e-001, 3.264921e-001, 3.264261e-001, 3.263601e-001, 3.262941e-001, 3.262281e-001, 3.261621e-001, 3.260961e-001, 3.260301e-001, 3.259641e-001, 3.258981e-001, 3.258321e-001, 3.257661e-001, 3.257001e-001, 3.256341e-001, 3.255681e-001, 3.255021e-001, 3.254362e-001, 3.253702e-001, 3.253042e-001, 3.252382e-001, 3.251723e-001, 3.251063e-001, 3.250403e-001, 3.249744e-001, 3.249084e-001, 3.248424e-001, 3.247765e-001, 3.247105e-001, 3.246445e-001, 3.245786e-001, 3.245126e-001, 3.244467e-001, 3.243807e-001, 3.243148e-001, 3.242489e-001, 3.241829e-001, 3.241170e-001, 3.240510e-001, 3.239851e-001, 3.239192e-001, 3.238532e-001, 3.237873e-001, 3.237214e-001, 3.236554e-001, 3.235895e-001, 3.235236e-001, 3.234577e-001, 3.233918e-001, 3.233258e-001, 3.232599e-001, 3.231940e-001, 3.231281e-001, 3.230622e-001, 3.229963e-001, 3.229304e-001, 3.228645e-001, 3.227986e-001, 3.227327e-001, 3.226668e-001, 3.226009e-001, 3.225350e-001, 3.224691e-001, 3.224033e-001, 3.223374e-001, 3.222715e-001, 3.222056e-001, 3.221397e-001, 3.220739e-001, 3.220080e-001, 3.219421e-001, 3.218763e-001, 3.218104e-001, 3.217445e-001, 
3.216787e-001, 3.216128e-001, 3.215470e-001, 3.214811e-001, 3.214152e-001, 3.213494e-001, 3.212835e-001, 3.212177e-001, 3.211519e-001, 3.210860e-001, 3.210202e-001, 3.209543e-001, 3.208885e-001, 3.208227e-001, 3.207568e-001, 3.206910e-001, 3.206252e-001, 3.205594e-001, 3.204935e-001, 3.204277e-001, 3.203619e-001, 3.202961e-001, 3.202303e-001, 3.201645e-001, 3.200987e-001, 3.200329e-001, 3.199671e-001, 3.199013e-001, 3.198355e-001, 3.197697e-001, 3.197039e-001, 3.196381e-001, 3.195723e-001, 3.195065e-001, 3.194407e-001, 3.193749e-001, 3.193092e-001, 3.192434e-001, 3.191776e-001, 3.191118e-001, 3.190461e-001, 3.189803e-001, 3.189145e-001, 3.188488e-001, 3.187830e-001, 3.187172e-001, 3.186515e-001, 3.185857e-001, 3.185200e-001, 3.184542e-001, 3.183885e-001, 3.183227e-001, 3.182570e-001, 3.181913e-001, 3.181255e-001, 3.180598e-001, 3.179940e-001, 3.179283e-001, 3.178626e-001, 3.177969e-001, 3.177311e-001, 3.176654e-001, 3.175997e-001, 3.175340e-001, 3.174683e-001, 3.174026e-001, 3.173368e-001, 3.172711e-001, 3.172054e-001, 3.171397e-001, 3.170740e-001, 3.170083e-001, 3.169426e-001, 3.168769e-001, 3.168113e-001, 3.167456e-001, 3.166799e-001, 3.166142e-001, 3.165485e-001, 3.164828e-001, 3.164172e-001, 3.163515e-001, 3.162858e-001, 3.162202e-001, 3.161545e-001, 3.160888e-001, 3.160232e-001, 3.159575e-001, 3.158918e-001, 3.158262e-001, 3.157605e-001, 3.156949e-001, 3.156292e-001, 3.155636e-001, 3.154980e-001, 3.154323e-001, 3.153667e-001, 3.153011e-001, 3.152354e-001, 3.151698e-001, 
3.151042e-001, 3.150385e-001, 3.149729e-001, 3.149073e-001, 3.148417e-001, 3.147761e-001, 3.147105e-001, 3.146449e-001, 3.145792e-001, 3.145136e-001, 3.144480e-001, 3.143824e-001, 3.143168e-001, 3.142513e-001, 3.141857e-001, 3.141201e-001, 3.140545e-001, 3.139889e-001, 3.139233e-001, 3.138577e-001, 3.137922e-001, 3.137266e-001, 3.136610e-001, 3.135955e-001, 3.135299e-001, 3.134643e-001, 3.133988e-001, 3.133332e-001, 3.132677e-001, 3.132021e-001, 3.131366e-001, 3.130710e-001, 3.130055e-001, 3.129399e-001, 3.128744e-001, 3.128088e-001, 3.127433e-001, 3.126778e-001, 3.126122e-001, 3.125467e-001, 3.124812e-001, 3.124157e-001, 3.123502e-001, 3.122846e-001, 3.122191e-001, 3.121536e-001, 3.120881e-001, 3.120226e-001, 3.119571e-001, 3.118916e-001, 3.118261e-001, 3.117606e-001, 3.116951e-001, 3.116296e-001, 3.115641e-001, 3.114987e-001, 3.114332e-001, 3.113677e-001, 3.113022e-001, 3.112367e-001, 3.111713e-001, 3.111058e-001, 3.110403e-001, 3.109749e-001, 3.109094e-001, 3.108440e-001, 3.107785e-001, 3.107131e-001, 3.106476e-001, 3.105822e-001, 3.105167e-001, 3.104513e-001, 3.103858e-001, 3.103204e-001, 3.102550e-001, 3.101895e-001, 3.101241e-001, 3.100587e-001, 3.099933e-001, 3.099278e-001, 3.098624e-001, 3.097970e-001, 3.097316e-001, 3.096662e-001, 3.096008e-001, 3.095354e-001, 3.094700e-001, 3.094046e-001, 3.093392e-001, 3.092738e-001, 3.092084e-001, 3.091430e-001, 3.090776e-001, 3.090123e-001, 3.089469e-001, 3.088815e-001, 3.088161e-001, 3.087508e-001, 3.086854e-001, 3.086200e-001, 
3.085547e-001, 3.084893e-001, 3.084240e-001, 3.083586e-001, 3.082932e-001, 3.082279e-001, 3.081626e-001, 3.080972e-001, 3.080319e-001, 3.079665e-001, 3.079012e-001, 3.078359e-001, 3.077705e-001, 3.077052e-001, 3.076399e-001, 3.075746e-001, 3.075093e-001, 3.074440e-001, 3.073786e-001, 3.073133e-001, 3.072480e-001, 3.071827e-001, 3.071174e-001, 3.070521e-001, 3.069868e-001, 3.069215e-001, 3.068563e-001, 3.067910e-001, 3.067257e-001, 3.066604e-001, 3.065951e-001, 3.065299e-001, 3.064646e-001, 3.063993e-001, 3.063341e-001, 3.062688e-001, 3.062035e-001, 3.061383e-001, 3.060730e-001, 3.060078e-001, 3.059425e-001, 3.058773e-001, 3.058121e-001, 3.057468e-001, 3.056816e-001, 3.056163e-001, 3.055511e-001, 3.054859e-001, 3.054207e-001, 3.053554e-001, 3.052902e-001, 3.052250e-001, 3.051598e-001, 3.050946e-001, 3.050294e-001, 3.049642e-001, 3.048990e-001, 3.048338e-001, 3.047686e-001, 3.047034e-001, 3.046382e-001, 3.045730e-001, 3.045078e-001, 3.044427e-001, 3.043775e-001, 3.043123e-001, 3.042471e-001, 3.041820e-001, 3.041168e-001, 3.040517e-001, 3.039865e-001, 3.039213e-001, 3.038562e-001, 3.037910e-001, 3.037259e-001, 3.036608e-001, 3.035956e-001, 3.035305e-001, 3.034653e-001, 3.034002e-001, 3.033351e-001, 3.032700e-001, 3.032048e-001, 3.031397e-001, 3.030746e-001, 3.030095e-001, 3.029444e-001, 3.028793e-001, 3.028142e-001, 3.027491e-001, 3.026840e-001, 3.026189e-001, 3.025538e-001, 3.024887e-001, 3.024236e-001, 3.023585e-001, 3.022935e-001, 3.022284e-001, 3.021633e-001, 3.020982e-001, 
3.020332e-001, 3.019681e-001, 3.019030e-001, 3.018380e-001, 3.017729e-001, 3.017079e-001, 3.016428e-001, 3.015778e-001, 3.015127e-001, 3.014477e-001, 3.013827e-001, 3.013176e-001, 3.012526e-001, 3.011876e-001, 3.011226e-001, 3.010575e-001, 3.009925e-001, 3.009275e-001, 3.008625e-001, 3.007975e-001, 3.007325e-001, 3.006675e-001, 3.006025e-001, 3.005375e-001, 3.004725e-001, 3.004075e-001, 3.003425e-001, 3.002776e-001, 3.002126e-001, 3.001476e-001, 3.000826e-001, 3.000177e-001, 2.999527e-001, 2.998877e-001, 2.998228e-001, 2.997578e-001, 2.996929e-001, 2.996279e-001, 2.995630e-001, 2.994980e-001, 2.994331e-001, 2.993681e-001, 2.993032e-001, 2.992383e-001, 2.991734e-001, 2.991084e-001, 2.990435e-001, 2.989786e-001, 2.989137e-001, 2.988488e-001, 2.987839e-001, 2.987189e-001, 2.986540e-001, 2.985892e-001, 2.985243e-001, 2.984594e-001, 2.983945e-001, 2.983296e-001, 2.982647e-001, 2.981998e-001, 2.981350e-001, 2.980701e-001, 2.980052e-001, 2.979403e-001, 2.978755e-001, 2.978106e-001, 2.977458e-001, 2.976809e-001, 2.976161e-001, 2.975512e-001, 2.974864e-001, 2.974215e-001, 2.973567e-001, 2.972919e-001, 2.972270e-001, 2.971622e-001, 2.970974e-001, 2.970326e-001, 2.969678e-001, 2.969030e-001, 2.968381e-001, 2.967733e-001, 2.967085e-001, 2.966437e-001, 2.965789e-001, 2.965141e-001, 2.964494e-001, 2.963846e-001, 2.963198e-001, 2.962550e-001, 2.961902e-001, 2.961255e-001, 2.960607e-001, 2.959959e-001, 2.959312e-001, 2.958664e-001, 2.958017e-001, 2.957369e-001, 2.956722e-001, 2.956074e-001, 
2.955427e-001, 2.954779e-001, 2.954132e-001, 2.953485e-001, 2.952837e-001, 2.952190e-001, 2.951543e-001, 2.950896e-001, 2.950249e-001, 2.949601e-001, 2.948954e-001, 2.948307e-001, 2.947660e-001, 2.947013e-001, 2.946366e-001, 2.945720e-001, 2.945073e-001, 2.944426e-001, 2.943779e-001, 2.943132e-001, 2.942486e-001, 2.941839e-001, 2.941192e-001, 2.940546e-001, 2.939899e-001, 2.939252e-001, 2.938606e-001, 2.937959e-001, 2.937313e-001, 2.936666e-001, 2.936020e-001, 2.935374e-001, 2.934727e-001, 2.934081e-001, 2.933435e-001, 2.932789e-001, 2.932143e-001, 2.931496e-001, 2.930850e-001, 2.930204e-001, 2.929558e-001, 2.928912e-001, 2.928266e-001, 2.927620e-001, 2.926974e-001, 2.926329e-001, 2.925683e-001, 2.925037e-001, 2.924391e-001, 2.923745e-001, 2.923100e-001, 2.922454e-001, 2.921809e-001, 2.921163e-001, 2.920517e-001, 2.919872e-001, 2.919226e-001, 2.918581e-001, 2.917936e-001, 2.917290e-001, 2.916645e-001, 2.916000e-001, 2.915354e-001, 2.914709e-001, 2.914064e-001, 2.913419e-001, 2.912774e-001, 2.912129e-001, 2.911484e-001, 2.910839e-001, 2.910194e-001, 2.909549e-001, 2.908904e-001, 2.908259e-001, 2.907614e-001, 2.906969e-001, 2.906325e-001, 2.905680e-001, 2.905035e-001, 2.904391e-001, 2.903746e-001, 2.903101e-001, 2.902457e-001, 2.901812e-001, 2.901168e-001, 2.900524e-001, 2.899879e-001, 2.899235e-001, 2.898591e-001, 2.897946e-001, 2.897302e-001, 2.896658e-001, 2.896014e-001, 2.895370e-001, 2.894725e-001, 2.894081e-001, 2.893437e-001, 2.892793e-001, 2.892149e-001, 2.891506e-001, 
2.890862e-001, 2.890218e-001, 2.889574e-001, 2.888930e-001, 2.888287e-001, 2.887643e-001, 2.886999e-001, 2.886356e-001, 2.885712e-001, 2.885069e-001, 2.884425e-001, 2.883782e-001, 2.883138e-001, 2.882495e-001, 2.881851e-001, 2.881208e-001, 2.880565e-001, 2.879922e-001, 2.879278e-001, 2.878635e-001, 2.877992e-001, 2.877349e-001, 2.876706e-001, 2.876063e-001, 2.875420e-001, 2.874777e-001, 2.874134e-001, 2.873491e-001, 2.872848e-001, 2.872206e-001, 2.871563e-001, 2.870920e-001, 2.870278e-001, 2.869635e-001, 2.868992e-001, 2.868350e-001, 2.867707e-001, 2.867065e-001, 2.866422e-001, 2.865780e-001, 2.865138e-001, 2.864495e-001, 2.863853e-001, 2.863211e-001, 2.862569e-001, 2.861926e-001, 2.861284e-001, 2.860642e-001, 2.860000e-001, 2.859358e-001, 2.858716e-001, 2.858074e-001, 2.857432e-001, 2.856790e-001, 2.856148e-001, 2.855507e-001, 2.854865e-001, 2.854223e-001, 2.853582e-001, 2.852940e-001, 2.852298e-001, 2.851657e-001, 2.851015e-001, 2.850374e-001, 2.849732e-001, 2.849091e-001, 2.848450e-001, 2.847808e-001, 2.847167e-001, 2.846526e-001, 2.845885e-001, 2.845243e-001, 2.844602e-001, 2.843961e-001, 2.843320e-001, 2.842679e-001, 2.842038e-001, 2.841397e-001, 2.840756e-001, 2.840115e-001, 2.839475e-001, 2.838834e-001, 2.838193e-001, 2.837552e-001, 2.836912e-001, 2.836271e-001, 2.835631e-001, 2.834990e-001, 2.834350e-001, 2.833709e-001, 2.833069e-001, 2.832428e-001, 2.831788e-001, 2.831148e-001, 2.830507e-001, 2.829867e-001, 2.829227e-001, 2.828587e-001, 2.827947e-001, 2.827307e-001, 
2.826667e-001, 2.826027e-001, 2.825387e-001, 2.824747e-001, 2.824107e-001, 2.823467e-001, 2.822827e-001, 2.822188e-001, 2.821548e-001, 2.820908e-001, 2.820269e-001, 2.819629e-001, 2.818990e-001, 2.818350e-001, 2.817711e-001, 2.817071e-001, 2.816432e-001, 2.815792e-001, 2.815153e-001, 2.814514e-001, 2.813875e-001, 2.813236e-001, 2.812596e-001, 2.811957e-001, 2.811318e-001, 2.810679e-001, 2.810040e-001, 2.809401e-001, 2.808762e-001, 2.808124e-001, 2.807485e-001, 2.806846e-001, 2.806207e-001, 2.805569e-001, 2.804930e-001, 2.804291e-001, 2.803653e-001, 2.803014e-001, 2.802376e-001, 2.801737e-001, 2.801099e-001, 2.800461e-001, 2.799822e-001, 2.799184e-001, 2.798546e-001, 2.797908e-001, 2.797269e-001, 2.796631e-001, 2.795993e-001, 2.795355e-001, 2.794717e-001, 2.794079e-001, 2.793441e-001, 2.792804e-001, 2.792166e-001, 2.791528e-001, 2.790890e-001, 2.790253e-001, 2.789615e-001, 2.788977e-001, 2.788340e-001, 2.787702e-001, 2.787065e-001, 2.786427e-001, 2.785790e-001, 2.785153e-001, 2.784515e-001, 2.783878e-001, 2.783241e-001, 2.782604e-001, 2.781966e-001, 2.781329e-001, 2.780692e-001, 2.780055e-001, 2.779418e-001, 2.778781e-001, 2.778144e-001, 2.777508e-001, 2.776871e-001, 2.776234e-001, 2.775597e-001, 2.774961e-001, 2.774324e-001, 2.773687e-001, 2.773051e-001, 2.772414e-001, 2.771778e-001, 2.771141e-001, 2.770505e-001, 2.769869e-001, 2.769232e-001, 2.768596e-001, 2.767960e-001, 2.767324e-001, 2.766688e-001, 2.766051e-001, 2.765415e-001, 2.764779e-001, 2.764143e-001, 2.763508e-001, 
2.762872e-001, 2.762236e-001, 2.761600e-001, 2.760964e-001, 2.760329e-001, 2.759693e-001, 2.759057e-001, 2.758422e-001, 2.757786e-001, 2.757151e-001, 2.756515e-001, 2.755880e-001, 2.755245e-001, 2.754609e-001, 2.753974e-001, 2.753339e-001, 2.752704e-001, 2.752068e-001, 2.751433e-001, 2.750798e-001, 2.750163e-001, 2.749528e-001, 2.748893e-001, 2.748259e-001, 2.747624e-001, 2.746989e-001, 2.746354e-001, 2.745719e-001, 2.745085e-001, 2.744450e-001, 2.743816e-001, 2.743181e-001, 2.742547e-001, 2.741912e-001, 2.741278e-001, 2.740643e-001, 2.740009e-001, 2.739375e-001, 2.738741e-001, 2.738107e-001, 2.737472e-001, 2.736838e-001, 2.736204e-001, 2.735570e-001, 2.734936e-001, 2.734302e-001, 2.733669e-001, 2.733035e-001, 2.732401e-001, 2.731767e-001, 2.731134e-001, 2.730500e-001, 2.729866e-001, 2.729233e-001, 2.728599e-001, 2.727966e-001, 2.727332e-001, 2.726699e-001, 2.726066e-001, 2.725432e-001, 2.724799e-001, 2.724166e-001, 2.723533e-001, 2.722900e-001, 2.722267e-001, 2.721634e-001, 2.721001e-001, 2.720368e-001, 2.719735e-001, 2.719102e-001, 2.718469e-001, 2.717836e-001, 2.717204e-001, 2.716571e-001, 2.715939e-001, 2.715306e-001, 2.714673e-001, 2.714041e-001, 2.713409e-001, 2.712776e-001, 2.712144e-001, 2.711512e-001, 2.710879e-001, 2.710247e-001, 2.709615e-001, 2.708983e-001, 2.708351e-001, 2.707719e-001, 2.707087e-001, 2.706455e-001, 2.705823e-001, 2.705191e-001, 2.704559e-001, 2.703928e-001, 2.703296e-001, 2.702664e-001, 2.702033e-001, 2.701401e-001, 2.700770e-001, 2.700138e-001, 
2.699507e-001, 2.698875e-001, 2.698244e-001, 2.697613e-001, 2.696981e-001, 2.696350e-001, 2.695719e-001, 2.695088e-001, 2.694457e-001, 2.693826e-001, 2.693195e-001, 2.692564e-001, 2.691933e-001, 2.691302e-001, 2.690672e-001, 2.690041e-001, 2.689410e-001, 2.688780e-001, 2.688149e-001, 2.687518e-001, 2.686888e-001, 2.686257e-001, 2.685627e-001, 2.684997e-001, 2.684366e-001, 2.683736e-001, 2.683106e-001, 2.682476e-001, 2.681846e-001, 2.681216e-001, 2.680586e-001, 2.679956e-001, 2.679326e-001, 2.678696e-001, 2.678066e-001, 2.677436e-001, 2.676806e-001, 2.676177e-001, 2.675547e-001, 2.674917e-001, 2.674288e-001, 2.673658e-001, 2.673029e-001, 2.672399e-001, 2.671770e-001, 2.671141e-001, 2.670511e-001, 2.669882e-001, 2.669253e-001, 2.668624e-001, 2.667995e-001, 2.667366e-001, 2.666737e-001, 2.666108e-001, 2.665479e-001, 2.664850e-001, 2.664221e-001, 2.663593e-001, 2.662964e-001, 2.662335e-001, 2.661707e-001, 2.661078e-001, 2.660449e-001, 2.659821e-001, 2.659193e-001, 2.658564e-001, 2.657936e-001, 2.657308e-001, 2.656679e-001, 2.656051e-001, 2.655423e-001, 2.654795e-001, 2.654167e-001, 2.653539e-001, 2.652911e-001, 2.652283e-001, 2.651655e-001, 2.651028e-001, 2.650400e-001, 2.649772e-001, 2.649144e-001, 2.648517e-001, 2.647889e-001, 2.647262e-001, 2.646634e-001, 2.646007e-001, 2.645380e-001, 2.644752e-001, 2.644125e-001, 2.643498e-001, 2.642871e-001, 2.642243e-001, 2.641616e-001, 2.640989e-001, 2.640362e-001, 2.639736e-001, 2.639109e-001, 2.638482e-001, 2.637855e-001, 2.637228e-001, 
2.636602e-001, 2.635975e-001, 2.635348e-001, 2.634722e-001, 2.634095e-001, 2.633469e-001, 2.632843e-001, 2.632216e-001, 2.631590e-001, 2.630964e-001, 2.630338e-001, 2.629711e-001, 2.629085e-001, 2.628459e-001, 2.627833e-001, 2.627207e-001, 2.626582e-001, 2.625956e-001, 2.625330e-001, 2.624704e-001, 2.624079e-001, 2.623453e-001, 2.622827e-001, 2.622202e-001, 2.621576e-001, 2.620951e-001, 2.620325e-001, 2.619700e-001, 2.619075e-001, 2.618450e-001, 2.617824e-001, 2.617199e-001, 2.616574e-001, 2.615949e-001, 2.615324e-001, 2.614699e-001, 2.614074e-001, 2.613449e-001, 2.612825e-001, 2.612200e-001, 2.611575e-001, 2.610951e-001, 2.610326e-001, 2.609701e-001, 2.609077e-001, 2.608452e-001, 2.607828e-001, 2.607204e-001, 2.606579e-001, 2.605955e-001, 2.605331e-001, 2.604707e-001, 2.604083e-001, 2.603459e-001, 2.602835e-001, 2.602211e-001, 2.601587e-001, 2.600963e-001, 2.600339e-001, 2.599716e-001, 2.599092e-001, 2.598468e-001, 2.597845e-001, 2.597221e-001, 2.596598e-001, 2.595974e-001, 2.595351e-001, 2.594728e-001, 2.594104e-001, 2.593481e-001, 2.592858e-001, 2.592235e-001, 2.591612e-001, 2.590989e-001, 2.590366e-001, 2.589743e-001, 2.589120e-001, 2.588497e-001, 2.587874e-001, 2.587252e-001, 2.586629e-001, 2.586006e-001, 2.585384e-001, 2.584761e-001, 2.584139e-001, 2.583516e-001, 2.582894e-001, 2.582272e-001, 2.581650e-001, 2.581027e-001, 2.580405e-001, 2.579783e-001, 2.579161e-001, 2.578539e-001, 2.577917e-001, 2.577295e-001, 2.576673e-001, 2.576052e-001, 2.575430e-001, 2.574808e-001, 
2.574187e-001, 2.573565e-001, 2.572944e-001, 2.572322e-001, 2.571701e-001, 2.571079e-001, 2.570458e-001, 2.569837e-001, 2.569216e-001, 2.568594e-001, 2.567973e-001, 2.567352e-001, 2.566731e-001, 2.566110e-001, 2.565489e-001, 2.564869e-001, 2.564248e-001, 2.563627e-001, 2.563006e-001, 2.562386e-001, 2.561765e-001, 2.561145e-001, 2.560524e-001, 2.559904e-001, 2.559283e-001, 2.558663e-001, 2.558043e-001, 2.557423e-001, 2.556802e-001, 2.556182e-001, 2.555562e-001, 2.554942e-001, 2.554322e-001, 2.553702e-001, 2.553083e-001, 2.552463e-001, 2.551843e-001, 2.551223e-001, 2.550604e-001, 2.549984e-001, 2.549365e-001, 2.548745e-001, 2.548126e-001, 2.547506e-001, 2.546887e-001, 2.546268e-001, 2.545649e-001, 2.545029e-001, 2.544410e-001, 2.543791e-001, 2.543172e-001, 2.542553e-001, 2.541934e-001, 2.541316e-001, 2.540697e-001, 2.540078e-001, 2.539459e-001, 2.538841e-001, 2.538222e-001, 2.537604e-001, 2.536985e-001, 2.536367e-001, 2.535749e-001, 2.535130e-001, 2.534512e-001, 2.533894e-001, 2.533276e-001, 2.532658e-001, 2.532040e-001, 2.531422e-001, 2.530804e-001, 2.530186e-001, 2.529568e-001, 2.528950e-001, 2.528333e-001, 2.527715e-001, 2.527097e-001, 2.526480e-001, 2.525862e-001, 2.525245e-001, 2.524628e-001, 2.524010e-001, 2.523393e-001, 2.522776e-001, 2.522159e-001, 2.521542e-001, 2.520925e-001, 2.520308e-001, 2.519691e-001, 2.519074e-001, 2.518457e-001, 2.517840e-001, 2.517223e-001, 2.516607e-001, 2.515990e-001, 2.515374e-001, 2.514757e-001, 2.514141e-001, 2.513524e-001, 2.512908e-001, 
2.512292e-001, 2.511675e-001, 2.511059e-001, 2.510443e-001, 2.509827e-001, 2.509211e-001, 2.508595e-001, 2.507979e-001, 2.507363e-001, 2.506748e-001, 2.506132e-001, 2.505516e-001, 2.504901e-001, 2.504285e-001, 2.503670e-001, 2.503054e-001, 2.502439e-001, 2.501823e-001, 2.501208e-001, 2.500593e-001, 2.499978e-001, 2.499363e-001, 2.498748e-001, 2.498133e-001, 2.497518e-001, 2.496903e-001, 2.496288e-001, 2.495673e-001, 2.495058e-001, 2.494444e-001, 2.493829e-001, 2.493214e-001, 2.492600e-001, 2.491986e-001, 2.491371e-001, 2.490757e-001, 2.490143e-001, 2.489528e-001, 2.488914e-001, 2.488300e-001, 2.487686e-001, 2.487072e-001, 2.486458e-001, 2.485844e-001, 2.485230e-001, 2.484617e-001, 2.484003e-001, 2.483389e-001, 2.482776e-001, 2.482162e-001, 2.481549e-001, 2.480935e-001, 2.480322e-001, 2.479708e-001, 2.479095e-001, 2.478482e-001, 2.477869e-001, 2.477256e-001, 2.476643e-001, 2.476030e-001, 2.475417e-001, 2.474804e-001, 2.474191e-001, 2.473578e-001, 2.472966e-001, 2.472353e-001, 2.471740e-001, 2.471128e-001, 2.470515e-001, 2.469903e-001, 2.469291e-001, 2.468678e-001, 2.468066e-001, 2.467454e-001, 2.466842e-001, 2.466230e-001, 2.465618e-001, 2.465006e-001, 2.464394e-001, 2.463782e-001, 2.463170e-001, 2.462559e-001, 2.461947e-001, 2.461335e-001, 2.460724e-001, 2.460112e-001, 2.459501e-001, 2.458889e-001, 2.458278e-001, 2.457667e-001, 2.457056e-001, 2.456444e-001, 2.455833e-001, 2.455222e-001, 2.454611e-001, 2.454000e-001, 2.453390e-001, 2.452779e-001, 2.452168e-001, 2.451557e-001, 
2.450947e-001, 2.450336e-001, 2.449726e-001, 2.449115e-001, 2.448505e-001, 2.447894e-001, 2.447284e-001, 2.446674e-001, 2.446064e-001, 2.445454e-001, 2.444844e-001, 2.444234e-001, 2.443624e-001, 2.443014e-001, 2.442404e-001, 2.441794e-001, 2.441185e-001, 2.440575e-001, 2.439965e-001, 2.439356e-001, 2.438746e-001, 2.438137e-001, 2.437528e-001, 2.436918e-001, 2.436309e-001, 2.435700e-001, 2.435091e-001, 2.434482e-001, 2.433873e-001, 2.433264e-001, 2.432655e-001, 2.432046e-001, 2.431437e-001, 2.430829e-001, 2.430220e-001, 2.429611e-001, 2.429003e-001, 2.428394e-001, 2.427786e-001, 2.427178e-001, 2.426569e-001, 2.425961e-001, 2.425353e-001, 2.424745e-001, 2.424137e-001, 2.423529e-001, 2.422921e-001, 2.422313e-001, 2.421705e-001, 2.421097e-001, 2.420490e-001, 2.419882e-001, 2.419275e-001, 2.418667e-001, 2.418060e-001, 2.417452e-001, 2.416845e-001, 2.416238e-001, 2.415630e-001, 2.415023e-001, 2.414416e-001, 2.413809e-001, 2.413202e-001, 2.412595e-001, 2.411988e-001, 2.411382e-001, 2.410775e-001, 2.410168e-001, 2.409562e-001, 2.408955e-001, 2.408348e-001, 2.407742e-001, 2.407136e-001, 2.406529e-001, 2.405923e-001, 2.405317e-001, 2.404711e-001, 2.404105e-001, 2.403499e-001, 2.402893e-001, 2.402287e-001, 2.401681e-001, 2.401075e-001, 2.400470e-001, 2.399864e-001, 2.399258e-001, 2.398653e-001, 2.398047e-001, 2.397442e-001, 2.396837e-001, 2.396231e-001, 2.395626e-001, 2.395021e-001, 2.394416e-001, 2.393811e-001, 2.393206e-001, 2.392601e-001, 2.391996e-001, 2.391391e-001, 2.390786e-001, 
2.390182e-001, 2.389577e-001, 2.388972e-001, 2.388368e-001, 2.387764e-001, 2.387159e-001, 2.386555e-001, 2.385951e-001, 2.385346e-001, 2.384742e-001, 2.384138e-001, 2.383534e-001, 2.382930e-001, 2.382326e-001, 2.381723e-001, 2.381119e-001, 2.380515e-001, 2.379911e-001, 2.379308e-001, 2.378704e-001, 2.378101e-001, 2.377498e-001, 2.376894e-001, 2.376291e-001, 2.375688e-001, 2.375085e-001, 2.374481e-001, 2.373878e-001, 2.373275e-001, 2.372673e-001, 2.372070e-001, 2.371467e-001, 2.370864e-001, 2.370262e-001, 2.369659e-001, 2.369056e-001, 2.368454e-001, 2.367852e-001, 2.367249e-001, 2.366647e-001, 2.366045e-001, 2.365443e-001, 2.364841e-001, 2.364239e-001, 2.363637e-001, 2.363035e-001, 2.362433e-001, 2.361831e-001, 2.361229e-001, 2.360628e-001, 2.360026e-001, 2.359425e-001, 2.358823e-001, 2.358222e-001, 2.357620e-001, 2.357019e-001, 2.356418e-001, 2.355817e-001, 2.355216e-001, 2.354615e-001, 2.354014e-001, 2.353413e-001, 2.352812e-001, 2.352211e-001, 2.351610e-001, 2.351010e-001, 2.350409e-001, 2.349809e-001, 2.349208e-001, 2.348608e-001, 2.348007e-001, 2.347407e-001, 2.346807e-001, 2.346207e-001, 2.345607e-001, 2.345007e-001, 2.344407e-001, 2.343807e-001, 2.343207e-001, 2.342607e-001, 2.342007e-001, 2.341408e-001, 2.340808e-001, 2.340209e-001, 2.339609e-001, 2.339010e-001, 2.338411e-001, 2.337811e-001, 2.337212e-001, 2.336613e-001, 2.336014e-001, 2.335415e-001, 2.334816e-001, 2.334217e-001, 2.333618e-001, 2.333019e-001, 2.332421e-001, 2.331822e-001, 2.331224e-001, 2.330625e-001, 
2.330027e-001, 2.329428e-001, 2.328830e-001, 2.328232e-001, 2.327634e-001, 2.327035e-001, 2.326437e-001, 2.325839e-001, 2.325242e-001, 2.324644e-001, 2.324046e-001, 2.323448e-001, 2.322850e-001, 2.322253e-001, 2.321655e-001, 2.321058e-001, 2.320460e-001, 2.319863e-001, 2.319266e-001, 2.318669e-001, 2.318072e-001, 2.317474e-001, 2.316877e-001, 2.316280e-001, 2.315684e-001, 2.315087e-001, 2.314490e-001, 2.313893e-001, 2.313297e-001, 2.312700e-001, 2.312104e-001, 2.311507e-001, 2.310911e-001, 2.310314e-001, 2.309718e-001, 2.309122e-001, 2.308526e-001, 2.307930e-001, 2.307334e-001, 2.306738e-001, 2.306142e-001, 2.305546e-001, 2.304951e-001, 2.304355e-001, 2.303759e-001, 2.303164e-001, 2.302568e-001, 2.301973e-001, 2.301378e-001, 2.300782e-001, 2.300187e-001, 2.299592e-001, 2.298997e-001, 2.298402e-001, 2.297807e-001, 2.297212e-001, 2.296617e-001, 2.296023e-001, 2.295428e-001, 2.294833e-001, 2.294239e-001, 2.293644e-001, 2.293050e-001, 2.292456e-001, 2.291861e-001, 2.291267e-001, 2.290673e-001, 2.290079e-001, 2.289485e-001, 2.288891e-001, 2.288297e-001, 2.287703e-001, 2.287110e-001, 2.286516e-001, 2.285922e-001, 2.285329e-001, 2.284735e-001, 2.284142e-001, 2.283549e-001, 2.282955e-001, 2.282362e-001, 2.281769e-001, 2.281176e-001, 2.280583e-001, 2.279990e-001, 2.279397e-001, 2.278804e-001, 2.278211e-001, 2.277619e-001, 2.277026e-001, 2.276434e-001, 2.275841e-001, 2.275249e-001, 2.274656e-001, 2.274064e-001, 2.273472e-001, 2.272880e-001, 2.272288e-001, 2.271696e-001, 2.271104e-001, 
2.270512e-001, 2.269920e-001, 2.269328e-001, 2.268736e-001, 2.268145e-001, 2.267553e-001, 2.266962e-001, 2.266370e-001, 2.265779e-001, 2.265188e-001, 2.264597e-001, 2.264005e-001, 2.263414e-001, 2.262823e-001, 2.262232e-001, 2.261641e-001, 2.261051e-001, 2.260460e-001, 2.259869e-001, 2.259279e-001, 2.258688e-001, 2.258098e-001, 2.257507e-001, 2.256917e-001, 2.256327e-001, 2.255736e-001, 2.255146e-001, 2.254556e-001, 2.253966e-001, 2.253376e-001, 2.252786e-001, 2.252197e-001, 2.251607e-001, 2.251017e-001, 2.250428e-001, 2.249838e-001, 2.249249e-001, 2.248659e-001, 2.248070e-001, 2.247481e-001, 2.246892e-001, 2.246302e-001, 2.245713e-001, 2.245124e-001, 2.244536e-001, 2.243947e-001, 2.243358e-001, 2.242769e-001, 2.242181e-001, 2.241592e-001, 2.241004e-001, 2.240415e-001, 2.239827e-001, 2.239238e-001, 2.238650e-001, 2.238062e-001, 2.237474e-001, 2.236886e-001, 2.236298e-001, 2.235710e-001, 2.235122e-001, 2.234535e-001, 2.233947e-001, 2.233359e-001, 2.232772e-001, 2.232184e-001, 2.231597e-001, 2.231010e-001, 2.230422e-001, 2.229835e-001, 2.229248e-001, 2.228661e-001, 2.228074e-001, 2.227487e-001, 2.226900e-001, 2.226313e-001, 2.225727e-001, 2.225140e-001, 2.224554e-001, 2.223967e-001, 2.223381e-001, 2.222794e-001, 2.222208e-001, 2.221622e-001, 2.221036e-001, 2.220450e-001, 2.219864e-001, 2.219278e-001, 2.218692e-001, 2.218106e-001, 2.217520e-001, 2.216934e-001, 2.216349e-001, 2.215763e-001, 2.215178e-001, 2.214593e-001, 2.214007e-001, 2.213422e-001, 2.212837e-001, 2.212252e-001, 
2.211667e-001, 2.211082e-001, 2.210497e-001, 2.209912e-001, 2.209327e-001, 2.208743e-001, 2.208158e-001, 2.207573e-001, 2.206989e-001, 2.206405e-001, 2.205820e-001, 2.205236e-001, 2.204652e-001, 2.204068e-001, 2.203484e-001, 2.202900e-001, 2.202316e-001, 2.201732e-001, 2.201148e-001, 2.200564e-001, 2.199981e-001, 2.199397e-001, 2.198814e-001, 2.198230e-001, 2.197647e-001, 2.197064e-001, 2.196480e-001, 2.195897e-001, 2.195314e-001, 2.194731e-001, 2.194148e-001, 2.193565e-001, 2.192983e-001, 2.192400e-001, 2.191817e-001, 2.191235e-001, 2.190652e-001, 2.190070e-001, 2.189487e-001, 2.188905e-001, 2.188323e-001, 2.187741e-001, 2.187159e-001, 2.186577e-001, 2.185995e-001, 2.185413e-001, 2.184831e-001, 2.184250e-001, 2.183668e-001, 2.183086e-001, 2.182505e-001, 2.181923e-001, 2.181342e-001, 2.180761e-001, 2.180180e-001, 2.179598e-001, 2.179017e-001, 2.178436e-001, 2.177855e-001, 2.177275e-001, 2.176694e-001, 2.176113e-001, 2.175532e-001, 2.174952e-001, 2.174371e-001, 2.173791e-001, 2.173211e-001, 2.172630e-001, 2.172050e-001, 2.171470e-001, 2.170890e-001, 2.170310e-001, 2.169730e-001, 2.169150e-001, 2.168570e-001, 2.167991e-001, 2.167411e-001, 2.166831e-001, 2.166252e-001, 2.165673e-001, 2.165093e-001, 2.164514e-001, 2.163935e-001, 2.163356e-001, 2.162777e-001, 2.162198e-001, 2.161619e-001, 2.161040e-001, 2.160461e-001, 2.159882e-001, 2.159304e-001, 2.158725e-001, 2.158147e-001, 2.157568e-001, 2.156990e-001, 2.156412e-001, 2.155834e-001, 2.155256e-001, 2.154678e-001, 2.154100e-001, 
2.153522e-001, 2.152944e-001, 2.152366e-001, 2.151788e-001, 2.151211e-001, 2.150633e-001, 2.150056e-001, 2.149479e-001, 2.148901e-001, 2.148324e-001, 2.147747e-001, 2.147170e-001, 2.146593e-001, 2.146016e-001, 2.145439e-001, 2.144862e-001, 2.144285e-001, 2.143709e-001, 2.143132e-001, 2.142556e-001, 2.141979e-001, 2.141403e-001, 2.140827e-001, 2.140250e-001, 2.139674e-001, 2.139098e-001, 2.138522e-001, 2.137946e-001, 2.137371e-001, 2.136795e-001, 2.136219e-001, 2.135644e-001, 2.135068e-001, 2.134493e-001, 2.133917e-001, 2.133342e-001, 2.132767e-001, 2.132191e-001, 2.131616e-001, 2.131041e-001, 2.130466e-001, 2.129892e-001, 2.129317e-001, 2.128742e-001, 2.128167e-001, 2.127593e-001, 2.127018e-001, 2.126444e-001, 2.125870e-001, 2.125295e-001, 2.124721e-001, 2.124147e-001, 2.123573e-001, 2.122999e-001, 2.122425e-001, 2.121851e-001, 2.121277e-001, 2.120704e-001, 2.120130e-001, 2.119557e-001, 2.118983e-001, 2.118410e-001, 2.117836e-001, 2.117263e-001, 2.116690e-001, 2.116117e-001, 2.115544e-001, 2.114971e-001, 2.114398e-001, 2.113825e-001, 2.113253e-001, 2.112680e-001, 2.112108e-001, 2.111535e-001, 2.110963e-001, 2.110390e-001, 2.109818e-001, 2.109246e-001, 2.108674e-001, 2.108102e-001, 2.107530e-001, 2.106958e-001, 2.106386e-001, 2.105814e-001, 2.105243e-001, 2.104671e-001, 2.104100e-001, 2.103528e-001, 2.102957e-001, 2.102386e-001, 2.101814e-001, 2.101243e-001, 2.100672e-001, 2.100101e-001, 2.099530e-001, 2.098960e-001, 2.098389e-001, 2.097818e-001, 2.097248e-001, 2.096677e-001, 
2.096107e-001, 2.095536e-001, 2.094966e-001, 2.094396e-001, 2.093826e-001, 2.093256e-001, 2.092686e-001, 2.092116e-001, 2.091546e-001, 2.090976e-001, 2.090406e-001, 2.089837e-001, 2.089267e-001, 2.088698e-001, 2.088129e-001, 2.087559e-001, 2.086990e-001, 2.086421e-001, 2.085852e-001, 2.085283e-001, 2.084714e-001, 2.084145e-001, 2.083576e-001, 2.083008e-001, 2.082439e-001, 2.081870e-001, 2.081302e-001, 2.080734e-001, 2.080165e-001, 2.079597e-001, 2.079029e-001, 2.078461e-001, 2.077893e-001, 2.077325e-001, 2.076757e-001, 2.076189e-001, 2.075622e-001, 2.075054e-001, 2.074487e-001, 2.073919e-001, 2.073352e-001, 2.072784e-001, 2.072217e-001, 2.071650e-001, 2.071083e-001, 2.070516e-001, 2.069949e-001, 2.069382e-001, 2.068816e-001, 2.068249e-001, 2.067682e-001, 2.067116e-001, 2.066549e-001, 2.065983e-001, 2.065417e-001, 2.064850e-001, 2.064284e-001, 2.063718e-001, 2.063152e-001, 2.062586e-001, 2.062021e-001, 2.061455e-001, 2.060889e-001, 2.060324e-001, 2.059758e-001, 2.059193e-001, 2.058627e-001, 2.058062e-001, 2.057497e-001, 2.056932e-001, 2.056367e-001, 2.055802e-001, 2.055237e-001, 2.054672e-001, 2.054107e-001, 2.053543e-001, 2.052978e-001, 2.052413e-001, 2.051849e-001, 2.051285e-001, 2.050720e-001, 2.050156e-001, 2.049592e-001, 2.049028e-001, 2.048464e-001, 2.047900e-001, 2.047336e-001, 2.046773e-001, 2.046209e-001, 2.045646e-001, 2.045082e-001, 2.044519e-001, 2.043955e-001, 2.043392e-001, 2.042829e-001, 2.042266e-001, 2.041703e-001, 2.041140e-001, 2.040577e-001, 2.040014e-001, 
2.039452e-001, 2.038889e-001, 2.038327e-001, 2.037764e-001, 2.037202e-001, 2.036639e-001, 2.036077e-001, 2.035515e-001, 2.034953e-001, 2.034391e-001, 2.033829e-001, 2.033267e-001, 2.032706e-001, 2.032144e-001, 2.031582e-001, 2.031021e-001, 2.030459e-001, 2.029898e-001, 2.029337e-001, 2.028776e-001, 2.028215e-001, 2.027653e-001, 2.027093e-001, 2.026532e-001, 2.025971e-001, 2.025410e-001, 2.024850e-001, 2.024289e-001, 2.023729e-001, 2.023168e-001, 2.022608e-001, 2.022048e-001, 2.021487e-001, 2.020927e-001, 2.020367e-001, 2.019808e-001, 2.019248e-001, 2.018688e-001, 2.018128e-001, 2.017569e-001, 2.017009e-001, 2.016450e-001, 2.015890e-001, 2.015331e-001, 2.014772e-001, 2.014213e-001, 2.013654e-001, 2.013095e-001, 2.012536e-001, 2.011977e-001, 2.011419e-001, 2.010860e-001, 2.010301e-001, 2.009743e-001, 2.009185e-001, 2.008626e-001, 2.008068e-001, 2.007510e-001, 2.006952e-001, 2.006394e-001, 2.005836e-001, 2.005278e-001, 2.004720e-001, 2.004163e-001, 2.003605e-001, 2.003048e-001, 2.002490e-001, 2.001933e-001, 2.001376e-001, 2.000819e-001, 2.000261e-001, 1.999704e-001, 1.999148e-001, 1.998591e-001, 1.998034e-001, 1.997477e-001, 1.996921e-001, 1.996364e-001, 1.995808e-001, 1.995251e-001, 1.994695e-001, 1.994139e-001, 1.993583e-001, 1.993027e-001, 1.992471e-001, 1.991915e-001, 1.991359e-001, 1.990803e-001, 1.990248e-001, 1.989692e-001, 1.989137e-001, 1.988581e-001, 1.988026e-001, 1.987471e-001, 1.986916e-001, 1.986361e-001, 1.985806e-001, 1.985251e-001, 1.984696e-001, 1.984141e-001, 
1.983587e-001, 1.983032e-001, 1.982478e-001, 1.981923e-001, 1.981369e-001, 1.980815e-001, 1.980261e-001, 1.979706e-001, 1.979152e-001, 1.978599e-001, 1.978045e-001, 1.977491e-001, 1.976937e-001, 1.976384e-001, 1.975830e-001, 1.975277e-001, 1.974724e-001, 1.974170e-001, 1.973617e-001, 1.973064e-001, 1.972511e-001, 1.971958e-001, 1.971405e-001, 1.970853e-001, 1.970300e-001, 1.969747e-001, 1.969195e-001, 1.968642e-001, 1.968090e-001, 1.967538e-001, 1.966986e-001, 1.966434e-001, 1.965882e-001, 1.965330e-001, 1.964778e-001, 1.964226e-001, 1.963674e-001, 1.963123e-001, 1.962571e-001, 1.962020e-001, 1.961469e-001, 1.960917e-001, 1.960366e-001, 1.959815e-001, 1.959264e-001, 1.958713e-001, 1.958162e-001, 1.957612e-001, 1.957061e-001, 1.956510e-001, 1.955960e-001, 1.955409e-001, 1.954859e-001, 1.954309e-001, 1.953759e-001, 1.953209e-001, 1.952659e-001, 1.952109e-001, 1.951559e-001, 1.951009e-001, 1.950459e-001, 1.949910e-001, 1.949360e-001, 1.948811e-001, 1.948262e-001, 1.947712e-001, 1.947163e-001, 1.946614e-001, 1.946065e-001, 1.945516e-001, 1.944967e-001, 1.944419e-001, 1.943870e-001, 1.943321e-001, 1.942773e-001, 1.942224e-001, 1.941676e-001, 1.941128e-001, 1.940580e-001, 1.940032e-001, 1.939484e-001, 1.938936e-001, 1.938388e-001, 1.937840e-001, 1.937293e-001, 1.936745e-001, 1.936197e-001, 1.935650e-001, 1.935103e-001, 1.934556e-001, 1.934008e-001, 1.933461e-001, 1.932914e-001, 1.932367e-001, 1.931821e-001, 1.931274e-001, 1.930727e-001, 1.930181e-001, 1.929634e-001, 1.929088e-001, 
1.928542e-001, 1.927995e-001, 1.927449e-001, 1.926903e-001, 1.926357e-001, 1.925811e-001, 1.925266e-001, 1.924720e-001, 1.924174e-001, 1.923629e-001, 1.923083e-001, 1.922538e-001, 1.921993e-001, 1.921448e-001, 1.920903e-001, 1.920357e-001, 1.919813e-001, 1.919268e-001, 1.918723e-001, 1.918178e-001, 1.917634e-001, 1.917089e-001, 1.916545e-001, 1.916000e-001, 1.915456e-001, 1.914912e-001, 1.914368e-001, 1.913824e-001, 1.913280e-001, 1.912736e-001, 1.912193e-001, 1.911649e-001, 1.911105e-001, 1.910562e-001, 1.910018e-001, 1.909475e-001, 1.908932e-001, 1.908389e-001, 1.907846e-001, 1.907303e-001, 1.906760e-001, 1.906217e-001, 1.905675e-001, 1.905132e-001, 1.904589e-001, 1.904047e-001, 1.903505e-001, 1.902962e-001, 1.902420e-001, 1.901878e-001, 1.901336e-001, 1.900794e-001, 1.900252e-001, 1.899711e-001, 1.899169e-001, 1.898627e-001, 1.898086e-001, 1.897544e-001, 1.897003e-001, 1.896462e-001, 1.895921e-001, 1.895380e-001, 1.894839e-001, 1.894298e-001, 1.893757e-001, 1.893216e-001, 1.892676e-001, 1.892135e-001, 1.891595e-001, 1.891054e-001, 1.890514e-001, 1.889974e-001, 1.889434e-001, 1.888894e-001, 1.888354e-001, 1.887814e-001, 1.887274e-001, 1.886735e-001, 1.886195e-001, 1.885656e-001, 1.885116e-001, 1.884577e-001, 1.884038e-001, 1.883499e-001, 1.882960e-001, 1.882421e-001, 1.881882e-001, 1.881343e-001, 1.880804e-001, 1.880266e-001, 1.879727e-001, 1.879189e-001, 1.878650e-001, 1.878112e-001, 1.877574e-001, 1.877036e-001, 1.876498e-001, 1.875960e-001, 1.875422e-001, 1.874884e-001, 
1.874347e-001, 1.873809e-001, 1.873272e-001, 1.872734e-001, 1.872197e-001, 1.871660e-001, 1.871123e-001, 1.870586e-001, 1.870049e-001, 1.869512e-001, 1.868975e-001, 1.868438e-001, 1.867902e-001, 1.867365e-001, 1.866829e-001, 1.866293e-001, 1.865756e-001, 1.865220e-001, 1.864684e-001, 1.864148e-001, 1.863612e-001, 1.863077e-001, 1.862541e-001, 1.862005e-001, 1.861470e-001, 1.860934e-001, 1.860399e-001, 1.859864e-001, 1.859328e-001, 1.858793e-001, 1.858258e-001, 1.857723e-001, 1.857189e-001, 1.856654e-001, 1.856119e-001, 1.855585e-001, 1.855050e-001, 1.854516e-001, 1.853982e-001, 1.853447e-001, 1.852913e-001, 1.852379e-001, 1.851845e-001, 1.851312e-001, 1.850778e-001, 1.850244e-001, 1.849711e-001, 1.849177e-001, 1.848644e-001, 1.848110e-001, 1.847577e-001, 1.847044e-001, 1.846511e-001, 1.845978e-001, 1.845445e-001, 1.844913e-001, 1.844380e-001, 1.843847e-001, 1.843315e-001, 1.842782e-001, 1.842250e-001, 1.841718e-001, 1.841186e-001, 1.840654e-001, 1.840122e-001, 1.839590e-001, 1.839058e-001, 1.838526e-001, 1.837995e-001, 1.837463e-001, 1.836932e-001, 1.836401e-001, 1.835869e-001, 1.835338e-001, 1.834807e-001, 1.834276e-001, 1.833745e-001, 1.833215e-001, 1.832684e-001, 1.832153e-001, 1.831623e-001, 1.831092e-001, 1.830562e-001, 1.830032e-001, 1.829502e-001, 1.828972e-001, 1.828442e-001, 1.827912e-001, 1.827382e-001, 1.826852e-001, 1.826323e-001, 1.825793e-001, 1.825264e-001, 1.824734e-001, 1.824205e-001, 1.823676e-001, 1.823147e-001, 1.822618e-001, 1.822089e-001, 1.821560e-001, 
1.821032e-001, 1.820503e-001, 1.819975e-001, 1.819446e-001, 1.818918e-001, 1.818390e-001, 1.817861e-001, 1.817333e-001, 1.816805e-001, 1.816278e-001, 1.815750e-001, 1.815222e-001, 1.814694e-001, 1.814167e-001, 1.813639e-001, 1.813112e-001, 1.812585e-001, 1.812058e-001, 1.811531e-001, 1.811004e-001, 1.810477e-001, 1.809950e-001, 1.809423e-001, 1.808897e-001, 1.808370e-001, 1.807844e-001, 1.807318e-001, 1.806791e-001, 1.806265e-001, 1.805739e-001, 1.805213e-001, 1.804687e-001, 1.804162e-001, 1.803636e-001, 1.803110e-001, 1.802585e-001, 1.802059e-001, 1.801534e-001, 1.801009e-001, 1.800484e-001, 1.799959e-001, 1.799434e-001, 1.798909e-001, 1.798384e-001, 1.797860e-001, 1.797335e-001, 1.796811e-001, 1.796286e-001, 1.795762e-001, 1.795238e-001, 1.794714e-001, 1.794190e-001, 1.793666e-001, 1.793142e-001, 1.792618e-001, 1.792094e-001, 1.791571e-001, 1.791047e-001, 1.790524e-001, 1.790001e-001, 1.789478e-001, 1.788954e-001, 1.788431e-001, 1.787909e-001, 1.787386e-001, 1.786863e-001, 1.786340e-001, 1.785818e-001, 1.785295e-001, 1.784773e-001, 1.784251e-001, 1.783729e-001, 1.783207e-001, 1.782685e-001, 1.782163e-001, 1.781641e-001, 1.781119e-001, 1.780598e-001, 1.780076e-001, 1.779555e-001, 1.779033e-001, 1.778512e-001, 1.777991e-001, 1.777470e-001, 1.776949e-001, 1.776428e-001, 1.775907e-001, 1.775387e-001, 1.774866e-001, 1.774346e-001, 1.773825e-001, 1.773305e-001, 1.772785e-001, 1.772265e-001, 1.771745e-001, 1.771225e-001, 1.770705e-001, 1.770185e-001, 1.769666e-001, 1.769146e-001, 
1.768627e-001, 1.768107e-001, 1.767588e-001, 1.767069e-001, 1.766550e-001, 1.766031e-001, 1.765512e-001, 1.764993e-001, 1.764474e-001, 1.763956e-001, 1.763437e-001, 1.762919e-001, 1.762401e-001, 1.761882e-001, 1.761364e-001, 1.760846e-001, 1.760328e-001, 1.759810e-001, 1.759293e-001, 1.758775e-001, 1.758258e-001, 1.757740e-001, 1.757223e-001, 1.756705e-001, 1.756188e-001, 1.755671e-001, 1.755154e-001, 1.754637e-001, 1.754120e-001, 1.753604e-001, 1.753087e-001, 1.752571e-001, 1.752054e-001, 1.751538e-001, 1.751022e-001, 1.750505e-001, 1.749989e-001, 1.749473e-001, 1.748958e-001, 1.748442e-001, 1.747926e-001, 1.747411e-001, 1.746895e-001, 1.746380e-001, 1.745864e-001, 1.745349e-001, 1.744834e-001, 1.744319e-001, 1.743804e-001, 1.743290e-001, 1.742775e-001, 1.742260e-001, 1.741746e-001, 1.741231e-001, 1.740717e-001, 1.740203e-001, 1.739689e-001, 1.739174e-001, 1.738661e-001, 1.738147e-001, 1.737633e-001, 1.737119e-001, 1.736606e-001, 1.736092e-001, 1.735579e-001, 1.735066e-001, 1.734552e-001, 1.734039e-001, 1.733526e-001, 1.733013e-001, 1.732501e-001, 1.731988e-001, 1.731475e-001, 1.730963e-001, 1.730450e-001, 1.729938e-001, 1.729426e-001, 1.728914e-001, 1.728402e-001, 1.727890e-001, 1.727378e-001, 1.726866e-001, 1.726355e-001, 1.725843e-001, 1.725332e-001, 1.724820e-001, 1.724309e-001, 1.723798e-001, 1.723287e-001, 1.722776e-001, 1.722265e-001, 1.721754e-001, 1.721244e-001, 1.720733e-001, 1.720223e-001, 1.719712e-001, 1.719202e-001, 1.718692e-001, 1.718182e-001, 1.717672e-001, 
1.717162e-001, 1.716652e-001, 1.716142e-001, 1.715633e-001, 1.715123e-001, 1.714614e-001, 1.714104e-001, 1.713595e-001, 1.713086e-001, 1.712577e-001, 1.712068e-001, 1.711559e-001, 1.711050e-001, 1.710542e-001, 1.710033e-001, 1.709525e-001, 1.709017e-001, 1.708508e-001, 1.708000e-001, 1.707492e-001, 1.706984e-001, 1.706476e-001, 1.705968e-001, 1.705461e-001, 1.704953e-001, 1.704446e-001, 1.703938e-001, 1.703431e-001, 1.702924e-001, 1.702417e-001, 1.701910e-001, 1.701403e-001, 1.700896e-001, 1.700390e-001, 1.699883e-001, 1.699377e-001, 1.698870e-001, 1.698364e-001, 1.697858e-001, 1.697352e-001, 1.696846e-001, 1.696340e-001, 1.695834e-001, 1.695328e-001, 1.694823e-001, 1.694317e-001, 1.693812e-001, 1.693306e-001, 1.692801e-001, 1.692296e-001, 1.691791e-001, 1.691286e-001, 1.690781e-001, 1.690277e-001, 1.689772e-001, 1.689267e-001, 1.688763e-001, 1.688259e-001, 1.687754e-001, 1.687250e-001, 1.686746e-001, 1.686242e-001, 1.685739e-001, 1.685235e-001, 1.684731e-001, 1.684228e-001, 1.683724e-001, 1.683221e-001, 1.682718e-001, 1.682215e-001, 1.681712e-001, 1.681209e-001, 1.680706e-001, 1.680203e-001, 1.679700e-001, 1.679198e-001, 1.678695e-001, 1.678193e-001, 1.677691e-001, 1.677189e-001, 1.676687e-001, 1.676185e-001, 1.675683e-001, 1.675181e-001, 1.674679e-001, 1.674178e-001, 1.673676e-001, 1.673175e-001, 1.672674e-001, 1.672173e-001, 1.671672e-001, 1.671171e-001, 1.670670e-001, 1.670169e-001, 1.669668e-001, 1.669168e-001, 1.668667e-001, 1.668167e-001, 1.667667e-001, 1.667167e-001, 
1.666667e-001, 1.666667e-001
},
{
1.666667e-001, 1.667167e-001, 1.667667e-001, 1.668167e-001, 1.668667e-001, 1.669168e-001, 1.669668e-001, 1.670169e-001, 1.670670e-001, 1.671171e-001, 1.671672e-001, 1.672173e-001, 1.672674e-001, 1.673175e-001, 1.673676e-001, 1.674178e-001, 1.674679e-001, 1.675181e-001, 1.675683e-001, 1.676185e-001, 1.676687e-001, 1.677189e-001, 1.677691e-001, 1.678193e-001, 1.678695e-001, 1.679198e-001, 1.679700e-001, 1.680203e-001, 1.680706e-001, 1.681209e-001, 1.681712e-001, 1.682215e-001, 1.682718e-001, 1.683221e-001, 1.683724e-001, 1.684228e-001, 1.684731e-001, 1.685235e-001, 1.685739e-001, 1.686242e-001, 1.686746e-001, 1.687250e-001, 1.687754e-001, 1.688259e-001, 1.688763e-001, 1.689267e-001, 1.689772e-001, 1.690277e-001, 1.690781e-001, 1.691286e-001, 1.691791e-001, 1.692296e-001, 1.692801e-001, 1.693306e-001, 1.693812e-001, 1.694317e-001, 1.694823e-001, 1.695328e-001, 1.695834e-001, 1.696340e-001, 1.696846e-001, 1.697352e-001, 1.697858e-001, 1.698364e-001, 1.698870e-001, 1.699377e-001, 1.699883e-001, 1.700390e-001, 1.700896e-001, 1.701403e-001, 1.701910e-001, 1.702417e-001, 1.702924e-001, 1.703431e-001, 1.703938e-001, 1.704446e-001, 1.704953e-001, 1.705461e-001, 1.705968e-001, 1.706476e-001, 1.706984e-001, 1.707492e-001, 1.708000e-001, 1.708508e-001, 1.709017e-001, 1.709525e-001, 1.710033e-001, 1.710542e-001, 1.711050e-001, 1.711559e-001, 1.712068e-001, 1.712577e-001, 1.713086e-001, 1.713595e-001, 1.714104e-001, 1.714614e-001, 1.715123e-001, 1.715633e-001, 1.716142e-001, 1.716652e-001, 
1.717162e-001, 1.717672e-001, 1.718182e-001, 1.718692e-001, 1.719202e-001, 1.719712e-001, 1.720223e-001, 1.720733e-001, 1.721244e-001, 1.721754e-001, 1.722265e-001, 1.722776e-001, 1.723287e-001, 1.723798e-001, 1.724309e-001, 1.724820e-001, 1.725332e-001, 1.725843e-001, 1.726355e-001, 1.726866e-001, 1.727378e-001, 1.727890e-001, 1.728402e-001, 1.728914e-001, 1.729426e-001, 1.729938e-001, 1.730450e-001, 1.730963e-001, 1.731475e-001, 1.731988e-001, 1.732501e-001, 1.733013e-001, 1.733526e-001, 1.734039e-001, 1.734552e-001, 1.735066e-001, 1.735579e-001, 1.736092e-001, 1.736606e-001, 1.737119e-001, 1.737633e-001, 1.738147e-001, 1.738661e-001, 1.739174e-001, 1.739689e-001, 1.740203e-001, 1.740717e-001, 1.741231e-001, 1.741746e-001, 1.742260e-001, 1.742775e-001, 1.743290e-001, 1.743804e-001, 1.744319e-001, 1.744834e-001, 1.745349e-001, 1.745864e-001, 1.746380e-001, 1.746895e-001, 1.747411e-001, 1.747926e-001, 1.748442e-001, 1.748958e-001, 1.749473e-001, 1.749989e-001, 1.750505e-001, 1.751022e-001, 1.751538e-001, 1.752054e-001, 1.752571e-001, 1.753087e-001, 1.753604e-001, 1.754120e-001, 1.754637e-001, 1.755154e-001, 1.755671e-001, 1.756188e-001, 1.756705e-001, 1.757223e-001, 1.757740e-001, 1.758258e-001, 1.758775e-001, 1.759293e-001, 1.759810e-001, 1.760328e-001, 1.760846e-001, 1.761364e-001, 1.761882e-001, 1.762401e-001, 1.762919e-001, 1.763437e-001, 1.763956e-001, 1.764474e-001, 1.764993e-001, 1.765512e-001, 1.766031e-001, 1.766550e-001, 1.767069e-001, 1.767588e-001, 1.768107e-001, 
1.768627e-001, 1.769146e-001, 1.769666e-001, 1.770185e-001, 1.770705e-001, 1.771225e-001, 1.771745e-001, 1.772265e-001, 1.772785e-001, 1.773305e-001, 1.773825e-001, 1.774346e-001, 1.774866e-001, 1.775387e-001, 1.775907e-001, 1.776428e-001, 1.776949e-001, 1.777470e-001, 1.777991e-001, 1.778512e-001, 1.779033e-001, 1.779555e-001, 1.780076e-001, 1.780598e-001, 1.781119e-001, 1.781641e-001, 1.782163e-001, 1.782685e-001, 1.783207e-001, 1.783729e-001, 1.784251e-001, 1.784773e-001, 1.785295e-001, 1.785818e-001, 1.786340e-001, 1.786863e-001, 1.787386e-001, 1.787909e-001, 1.788431e-001, 1.788954e-001, 1.789478e-001, 1.790001e-001, 1.790524e-001, 1.791047e-001, 1.791571e-001, 1.792094e-001, 1.792618e-001, 1.793142e-001, 1.793666e-001, 1.794190e-001, 1.794714e-001, 1.795238e-001, 1.795762e-001, 1.796286e-001, 1.796811e-001, 1.797335e-001, 1.797860e-001, 1.798384e-001, 1.798909e-001, 1.799434e-001, 1.799959e-001, 1.800484e-001, 1.801009e-001, 1.801534e-001, 1.802059e-001, 1.802585e-001, 1.803110e-001, 1.803636e-001, 1.804162e-001, 1.804687e-001, 1.805213e-001, 1.805739e-001, 1.806265e-001, 1.806791e-001, 1.807318e-001, 1.807844e-001, 1.808370e-001, 1.808897e-001, 1.809423e-001, 1.809950e-001, 1.810477e-001, 1.811004e-001, 1.811531e-001, 1.812058e-001, 1.812585e-001, 1.813112e-001, 1.813639e-001, 1.814167e-001, 1.814694e-001, 1.815222e-001, 1.815750e-001, 1.816278e-001, 1.816805e-001, 1.817333e-001, 1.817861e-001, 1.818390e-001, 1.818918e-001, 1.819446e-001, 1.819975e-001, 1.820503e-001, 
1.821032e-001, 1.821560e-001, 1.822089e-001, 1.822618e-001, 1.823147e-001, 1.823676e-001, 1.824205e-001, 1.824734e-001, 1.825264e-001, 1.825793e-001, 1.826323e-001, 1.826852e-001, 1.827382e-001, 1.827912e-001, 1.828442e-001, 1.828972e-001, 1.829502e-001, 1.830032e-001, 1.830562e-001, 1.831092e-001, 1.831623e-001, 1.832153e-001, 1.832684e-001, 1.833215e-001, 1.833745e-001, 1.834276e-001, 1.834807e-001, 1.835338e-001, 1.835869e-001, 1.836401e-001, 1.836932e-001, 1.837463e-001, 1.837995e-001, 1.838526e-001, 1.839058e-001, 1.839590e-001, 1.840122e-001, 1.840654e-001, 1.841186e-001, 1.841718e-001, 1.842250e-001, 1.842782e-001, 1.843315e-001, 1.843847e-001, 1.844380e-001, 1.844913e-001, 1.845445e-001, 1.845978e-001, 1.846511e-001, 1.847044e-001, 1.847577e-001, 1.848110e-001, 1.848644e-001, 1.849177e-001, 1.849711e-001, 1.850244e-001, 1.850778e-001, 1.851312e-001, 1.851845e-001, 1.852379e-001, 1.852913e-001, 1.853447e-001, 1.853982e-001, 1.854516e-001, 1.855050e-001, 1.855585e-001, 1.856119e-001, 1.856654e-001, 1.857189e-001, 1.857723e-001, 1.858258e-001, 1.858793e-001, 1.859328e-001, 1.859864e-001, 1.860399e-001, 1.860934e-001, 1.861470e-001, 1.862005e-001, 1.862541e-001, 1.863077e-001, 1.863612e-001, 1.864148e-001, 1.864684e-001, 1.865220e-001, 1.865756e-001, 1.866293e-001, 1.866829e-001, 1.867365e-001, 1.867902e-001, 1.868438e-001, 1.868975e-001, 1.869512e-001, 1.870049e-001, 1.870586e-001, 1.871123e-001, 1.871660e-001, 1.872197e-001, 1.872734e-001, 1.873272e-001, 1.873809e-001, 
1.874347e-001, 1.874884e-001, 1.875422e-001, 1.875960e-001, 1.876498e-001, 1.877036e-001, 1.877574e-001, 1.878112e-001, 1.878650e-001, 1.879189e-001, 1.879727e-001, 1.880266e-001, 1.880804e-001, 1.881343e-001, 1.881882e-001, 1.882421e-001, 1.882960e-001, 1.883499e-001, 1.884038e-001, 1.884577e-001, 1.885116e-001, 1.885656e-001, 1.886195e-001, 1.886735e-001, 1.887274e-001, 1.887814e-001, 1.888354e-001, 1.888894e-001, 1.889434e-001, 1.889974e-001, 1.890514e-001, 1.891054e-001, 1.891595e-001, 1.892135e-001, 1.892676e-001, 1.893216e-001, 1.893757e-001, 1.894298e-001, 1.894839e-001, 1.895380e-001, 1.895921e-001, 1.896462e-001, 1.897003e-001, 1.897544e-001, 1.898086e-001, 1.898627e-001, 1.899169e-001, 1.899711e-001, 1.900252e-001, 1.900794e-001, 1.901336e-001, 1.901878e-001, 1.902420e-001, 1.902962e-001, 1.903505e-001, 1.904047e-001, 1.904589e-001, 1.905132e-001, 1.905675e-001, 1.906217e-001, 1.906760e-001, 1.907303e-001, 1.907846e-001, 1.908389e-001, 1.908932e-001, 1.909475e-001, 1.910018e-001, 1.910562e-001, 1.911105e-001, 1.911649e-001, 1.912193e-001, 1.912736e-001, 1.913280e-001, 1.913824e-001, 1.914368e-001, 1.914912e-001, 1.915456e-001, 1.916000e-001, 1.916545e-001, 1.917089e-001, 1.917634e-001, 1.918178e-001, 1.918723e-001, 1.919268e-001, 1.919813e-001, 1.920357e-001, 1.920903e-001, 1.921448e-001, 1.921993e-001, 1.922538e-001, 1.923083e-001, 1.923629e-001, 1.924174e-001, 1.924720e-001, 1.925266e-001, 1.925811e-001, 1.926357e-001, 1.926903e-001, 1.927449e-001, 1.927995e-001, 
1.928542e-001, 1.929088e-001, 1.929634e-001, 1.930181e-001, 1.930727e-001, 1.931274e-001, 1.931821e-001, 1.932367e-001, 1.932914e-001, 1.933461e-001, 1.934008e-001, 1.934556e-001, 1.935103e-001, 1.935650e-001, 1.936197e-001, 1.936745e-001, 1.937293e-001, 1.937840e-001, 1.938388e-001, 1.938936e-001, 1.939484e-001, 1.940032e-001, 1.940580e-001, 1.941128e-001, 1.941676e-001, 1.942224e-001, 1.942773e-001, 1.943321e-001, 1.943870e-001, 1.944419e-001, 1.944967e-001, 1.945516e-001, 1.946065e-001, 1.946614e-001, 1.947163e-001, 1.947712e-001, 1.948262e-001, 1.948811e-001, 1.949360e-001, 1.949910e-001, 1.950459e-001, 1.951009e-001, 1.951559e-001, 1.952109e-001, 1.952659e-001, 1.953209e-001, 1.953759e-001, 1.954309e-001, 1.954859e-001, 1.955409e-001, 1.955960e-001, 1.956510e-001, 1.957061e-001, 1.957612e-001, 1.958162e-001, 1.958713e-001, 1.959264e-001, 1.959815e-001, 1.960366e-001, 1.960917e-001, 1.961469e-001, 1.962020e-001, 1.962571e-001, 1.963123e-001, 1.963674e-001, 1.964226e-001, 1.964778e-001, 1.965330e-001, 1.965882e-001, 1.966434e-001, 1.966986e-001, 1.967538e-001, 1.968090e-001, 1.968642e-001, 1.969195e-001, 1.969747e-001, 1.970300e-001, 1.970853e-001, 1.971405e-001, 1.971958e-001, 1.972511e-001, 1.973064e-001, 1.973617e-001, 1.974170e-001, 1.974724e-001, 1.975277e-001, 1.975830e-001, 1.976384e-001, 1.976937e-001, 1.977491e-001, 1.978045e-001, 1.978599e-001, 1.979152e-001, 1.979706e-001, 1.980261e-001, 1.980815e-001, 1.981369e-001, 1.981923e-001, 1.982478e-001, 1.983032e-001, 
1.983587e-001, 1.984141e-001, 1.984696e-001, 1.985251e-001, 1.985806e-001, 1.986361e-001, 1.986916e-001, 1.987471e-001, 1.988026e-001, 1.988581e-001, 1.989137e-001, 1.989692e-001, 1.990248e-001, 1.990803e-001, 1.991359e-001, 1.991915e-001, 1.992471e-001, 1.993027e-001, 1.993583e-001, 1.994139e-001, 1.994695e-001, 1.995251e-001, 1.995808e-001, 1.996364e-001, 1.996921e-001, 1.997477e-001, 1.998034e-001, 1.998591e-001, 1.999148e-001, 1.999704e-001, 2.000261e-001, 2.000819e-001, 2.001376e-001, 2.001933e-001, 2.002490e-001, 2.003048e-001, 2.003605e-001, 2.004163e-001, 2.004720e-001, 2.005278e-001, 2.005836e-001, 2.006394e-001, 2.006952e-001, 2.007510e-001, 2.008068e-001, 2.008626e-001, 2.009185e-001, 2.009743e-001, 2.010301e-001, 2.010860e-001, 2.011419e-001, 2.011977e-001, 2.012536e-001, 2.013095e-001, 2.013654e-001, 2.014213e-001, 2.014772e-001, 2.015331e-001, 2.015890e-001, 2.016450e-001, 2.017009e-001, 2.017569e-001, 2.018128e-001, 2.018688e-001, 2.019248e-001, 2.019808e-001, 2.020367e-001, 2.020927e-001, 2.021487e-001, 2.022048e-001, 2.022608e-001, 2.023168e-001, 2.023729e-001, 2.024289e-001, 2.024850e-001, 2.025410e-001, 2.025971e-001, 2.026532e-001, 2.027093e-001, 2.027653e-001, 2.028215e-001, 2.028776e-001, 2.029337e-001, 2.029898e-001, 2.030459e-001, 2.031021e-001, 2.031582e-001, 2.032144e-001, 2.032706e-001, 2.033267e-001, 2.033829e-001, 2.034391e-001, 2.034953e-001, 2.035515e-001, 2.036077e-001, 2.036639e-001, 2.037202e-001, 2.037764e-001, 2.038327e-001, 2.038889e-001, 
2.039452e-001, 2.040014e-001, 2.040577e-001, 2.041140e-001, 2.041703e-001, 2.042266e-001, 2.042829e-001, 2.043392e-001, 2.043955e-001, 2.044519e-001, 2.045082e-001, 2.045646e-001, 2.046209e-001, 2.046773e-001, 2.047336e-001, 2.047900e-001, 2.048464e-001, 2.049028e-001, 2.049592e-001, 2.050156e-001, 2.050720e-001, 2.051285e-001, 2.051849e-001, 2.052413e-001, 2.052978e-001, 2.053543e-001, 2.054107e-001, 2.054672e-001, 2.055237e-001, 2.055802e-001, 2.056367e-001, 2.056932e-001, 2.057497e-001, 2.058062e-001, 2.058627e-001, 2.059193e-001, 2.059758e-001, 2.060324e-001, 2.060889e-001, 2.061455e-001, 2.062021e-001, 2.062586e-001, 2.063152e-001, 2.063718e-001, 2.064284e-001, 2.064850e-001, 2.065417e-001, 2.065983e-001, 2.066549e-001, 2.067116e-001, 2.067682e-001, 2.068249e-001, 2.068816e-001, 2.069382e-001, 2.069949e-001, 2.070516e-001, 2.071083e-001, 2.071650e-001, 2.072217e-001, 2.072784e-001, 2.073352e-001, 2.073919e-001, 2.074487e-001, 2.075054e-001, 2.075622e-001, 2.076189e-001, 2.076757e-001, 2.077325e-001, 2.077893e-001, 2.078461e-001, 2.079029e-001, 2.079597e-001, 2.080165e-001, 2.080734e-001, 2.081302e-001, 2.081870e-001, 2.082439e-001, 2.083008e-001, 2.083576e-001, 2.084145e-001, 2.084714e-001, 2.085283e-001, 2.085852e-001, 2.086421e-001, 2.086990e-001, 2.087559e-001, 2.088129e-001, 2.088698e-001, 2.089267e-001, 2.089837e-001, 2.090406e-001, 2.090976e-001, 2.091546e-001, 2.092116e-001, 2.092686e-001, 2.093256e-001, 2.093826e-001, 2.094396e-001, 2.094966e-001, 2.095536e-001, 
2.096107e-001, 2.096677e-001, 2.097248e-001, 2.097818e-001, 2.098389e-001, 2.098960e-001, 2.099530e-001, 2.100101e-001, 2.100672e-001, 2.101243e-001, 2.101814e-001, 2.102386e-001, 2.102957e-001, 2.103528e-001, 2.104100e-001, 2.104671e-001, 2.105243e-001, 2.105814e-001, 2.106386e-001, 2.106958e-001, 2.107530e-001, 2.108102e-001, 2.108674e-001, 2.109246e-001, 2.109818e-001, 2.110390e-001, 2.110963e-001, 2.111535e-001, 2.112108e-001, 2.112680e-001, 2.113253e-001, 2.113825e-001, 2.114398e-001, 2.114971e-001, 2.115544e-001, 2.116117e-001, 2.116690e-001, 2.117263e-001, 2.117836e-001, 2.118410e-001, 2.118983e-001, 2.119557e-001, 2.120130e-001, 2.120704e-001, 2.121277e-001, 2.121851e-001, 2.122425e-001, 2.122999e-001, 2.123573e-001, 2.124147e-001, 2.124721e-001, 2.125295e-001, 2.125870e-001, 2.126444e-001, 2.127018e-001, 2.127593e-001, 2.128167e-001, 2.128742e-001, 2.129317e-001, 2.129892e-001, 2.130466e-001, 2.131041e-001, 2.131616e-001, 2.132191e-001, 2.132767e-001, 2.133342e-001, 2.133917e-001, 2.134493e-001, 2.135068e-001, 2.135644e-001, 2.136219e-001, 2.136795e-001, 2.137371e-001, 2.137946e-001, 2.138522e-001, 2.139098e-001, 2.139674e-001, 2.140250e-001, 2.140827e-001, 2.141403e-001, 2.141979e-001, 2.142556e-001, 2.143132e-001, 2.143709e-001, 2.144285e-001, 2.144862e-001, 2.145439e-001, 2.146016e-001, 2.146593e-001, 2.147170e-001, 2.147747e-001, 2.148324e-001, 2.148901e-001, 2.149479e-001, 2.150056e-001, 2.150633e-001, 2.151211e-001, 2.151788e-001, 2.152366e-001, 2.152944e-001, 
2.153522e-001, 2.154100e-001, 2.154678e-001, 2.155256e-001, 2.155834e-001, 2.156412e-001, 2.156990e-001, 2.157568e-001, 2.158147e-001, 2.158725e-001, 2.159304e-001, 2.159882e-001, 2.160461e-001, 2.161040e-001, 2.161619e-001, 2.162198e-001, 2.162777e-001, 2.163356e-001, 2.163935e-001, 2.164514e-001, 2.165093e-001, 2.165673e-001, 2.166252e-001, 2.166831e-001, 2.167411e-001, 2.167991e-001, 2.168570e-001, 2.169150e-001, 2.169730e-001, 2.170310e-001, 2.170890e-001, 2.171470e-001, 2.172050e-001, 2.172630e-001, 2.173211e-001, 2.173791e-001, 2.174371e-001, 2.174952e-001, 2.175532e-001, 2.176113e-001, 2.176694e-001, 2.177275e-001, 2.177855e-001, 2.178436e-001, 2.179017e-001, 2.179598e-001, 2.180180e-001, 2.180761e-001, 2.181342e-001, 2.181923e-001, 2.182505e-001, 2.183086e-001, 2.183668e-001, 2.184250e-001, 2.184831e-001, 2.185413e-001, 2.185995e-001, 2.186577e-001, 2.187159e-001, 2.187741e-001, 2.188323e-001, 2.188905e-001, 2.189487e-001, 2.190070e-001, 2.190652e-001, 2.191235e-001, 2.191817e-001, 2.192400e-001, 2.192983e-001, 2.193565e-001, 2.194148e-001, 2.194731e-001, 2.195314e-001, 2.195897e-001, 2.196480e-001, 2.197064e-001, 2.197647e-001, 2.198230e-001, 2.198814e-001, 2.199397e-001, 2.199981e-001, 2.200564e-001, 2.201148e-001, 2.201732e-001, 2.202316e-001, 2.202900e-001, 2.203484e-001, 2.204068e-001, 2.204652e-001, 2.205236e-001, 2.205820e-001, 2.206405e-001, 2.206989e-001, 2.207573e-001, 2.208158e-001, 2.208743e-001, 2.209327e-001, 2.209912e-001, 2.210497e-001, 2.211082e-001, 
2.211667e-001, 2.212252e-001, 2.212837e-001, 2.213422e-001, 2.214007e-001, 2.214593e-001, 2.215178e-001, 2.215763e-001, 2.216349e-001, 2.216934e-001, 2.217520e-001, 2.218106e-001, 2.218692e-001, 2.219278e-001, 2.219864e-001, 2.220450e-001, 2.221036e-001, 2.221622e-001, 2.222208e-001, 2.222794e-001, 2.223381e-001, 2.223967e-001, 2.224554e-001, 2.225140e-001, 2.225727e-001, 2.226313e-001, 2.226900e-001, 2.227487e-001, 2.228074e-001, 2.228661e-001, 2.229248e-001, 2.229835e-001, 2.230422e-001, 2.231010e-001, 2.231597e-001, 2.232184e-001, 2.232772e-001, 2.233359e-001, 2.233947e-001, 2.234535e-001, 2.235122e-001, 2.235710e-001, 2.236298e-001, 2.236886e-001, 2.237474e-001, 2.238062e-001, 2.238650e-001, 2.239238e-001, 2.239827e-001, 2.240415e-001, 2.241004e-001, 2.241592e-001, 2.242181e-001, 2.242769e-001, 2.243358e-001, 2.243947e-001, 2.244536e-001, 2.245124e-001, 2.245713e-001, 2.246302e-001, 2.246892e-001, 2.247481e-001, 2.248070e-001, 2.248659e-001, 2.249249e-001, 2.249838e-001, 2.250428e-001, 2.251017e-001, 2.251607e-001, 2.252197e-001, 2.252786e-001, 2.253376e-001, 2.253966e-001, 2.254556e-001, 2.255146e-001, 2.255736e-001, 2.256327e-001, 2.256917e-001, 2.257507e-001, 2.258098e-001, 2.258688e-001, 2.259279e-001, 2.259869e-001, 2.260460e-001, 2.261051e-001, 2.261641e-001, 2.262232e-001, 2.262823e-001, 2.263414e-001, 2.264005e-001, 2.264597e-001, 2.265188e-001, 2.265779e-001, 2.266370e-001, 2.266962e-001, 2.267553e-001, 2.268145e-001, 2.268736e-001, 2.269328e-001, 2.269920e-001, 
2.270512e-001, 2.271104e-001, 2.271696e-001, 2.272288e-001, 2.272880e-001, 2.273472e-001, 2.274064e-001, 2.274656e-001, 2.275249e-001, 2.275841e-001, 2.276434e-001, 2.277026e-001, 2.277619e-001, 2.278211e-001, 2.278804e-001, 2.279397e-001, 2.279990e-001, 2.280583e-001, 2.281176e-001, 2.281769e-001, 2.282362e-001, 2.282955e-001, 2.283549e-001, 2.284142e-001, 2.284735e-001, 2.285329e-001, 2.285922e-001, 2.286516e-001, 2.287110e-001, 2.287703e-001, 2.288297e-001, 2.288891e-001, 2.289485e-001, 2.290079e-001, 2.290673e-001, 2.291267e-001, 2.291861e-001, 2.292456e-001, 2.293050e-001, 2.293644e-001, 2.294239e-001, 2.294833e-001, 2.295428e-001, 2.296023e-001, 2.296617e-001, 2.297212e-001, 2.297807e-001, 2.298402e-001, 2.298997e-001, 2.299592e-001, 2.300187e-001, 2.300782e-001, 2.301378e-001, 2.301973e-001, 2.302568e-001, 2.303164e-001, 2.303759e-001, 2.304355e-001, 2.304951e-001, 2.305546e-001, 2.306142e-001, 2.306738e-001, 2.307334e-001, 2.307930e-001, 2.308526e-001, 2.309122e-001, 2.309718e-001, 2.310314e-001, 2.310911e-001, 2.311507e-001, 2.312104e-001, 2.312700e-001, 2.313297e-001, 2.313893e-001, 2.314490e-001, 2.315087e-001, 2.315684e-001, 2.316280e-001, 2.316877e-001, 2.317474e-001, 2.318072e-001, 2.318669e-001, 2.319266e-001, 2.319863e-001, 2.320460e-001, 2.321058e-001, 2.321655e-001, 2.322253e-001, 2.322850e-001, 2.323448e-001, 2.324046e-001, 2.324644e-001, 2.325242e-001, 2.325839e-001, 2.326437e-001, 2.327035e-001, 2.327634e-001, 2.328232e-001, 2.328830e-001, 2.329428e-001, 
2.330027e-001, 2.330625e-001, 2.331224e-001, 2.331822e-001, 2.332421e-001, 2.333019e-001, 2.333618e-001, 2.334217e-001, 2.334816e-001, 2.335415e-001, 2.336014e-001, 2.336613e-001, 2.337212e-001, 2.337811e-001, 2.338411e-001, 2.339010e-001, 2.339609e-001, 2.340209e-001, 2.340808e-001, 2.341408e-001, 2.342007e-001, 2.342607e-001, 2.343207e-001, 2.343807e-001, 2.344407e-001, 2.345007e-001, 2.345607e-001, 2.346207e-001, 2.346807e-001, 2.347407e-001, 2.348007e-001, 2.348608e-001, 2.349208e-001, 2.349809e-001, 2.350409e-001, 2.351010e-001, 2.351610e-001, 2.352211e-001, 2.352812e-001, 2.353413e-001, 2.354014e-001, 2.354615e-001, 2.355216e-001, 2.355817e-001, 2.356418e-001, 2.357019e-001, 2.357620e-001, 2.358222e-001, 2.358823e-001, 2.359425e-001, 2.360026e-001, 2.360628e-001, 2.361229e-001, 2.361831e-001, 2.362433e-001, 2.363035e-001, 2.363637e-001, 2.364239e-001, 2.364841e-001, 2.365443e-001, 2.366045e-001, 2.366647e-001, 2.367249e-001, 2.367852e-001, 2.368454e-001, 2.369056e-001, 2.369659e-001, 2.370262e-001, 2.370864e-001, 2.371467e-001, 2.372070e-001, 2.372673e-001, 2.373275e-001, 2.373878e-001, 2.374481e-001, 2.375085e-001, 2.375688e-001, 2.376291e-001, 2.376894e-001, 2.377498e-001, 2.378101e-001, 2.378704e-001, 2.379308e-001, 2.379911e-001, 2.380515e-001, 2.381119e-001, 2.381723e-001, 2.382326e-001, 2.382930e-001, 2.383534e-001, 2.384138e-001, 2.384742e-001, 2.385346e-001, 2.385951e-001, 2.386555e-001, 2.387159e-001, 2.387764e-001, 2.388368e-001, 2.388972e-001, 2.389577e-001, 
2.390182e-001, 2.390786e-001, 2.391391e-001, 2.391996e-001, 2.392601e-001, 2.393206e-001, 2.393811e-001, 2.394416e-001, 2.395021e-001, 2.395626e-001, 2.396231e-001, 2.396837e-001, 2.397442e-001, 2.398047e-001, 2.398653e-001, 2.399258e-001, 2.399864e-001, 2.400470e-001, 2.401075e-001, 2.401681e-001, 2.402287e-001, 2.402893e-001, 2.403499e-001, 2.404105e-001, 2.404711e-001, 2.405317e-001, 2.405923e-001, 2.406529e-001, 2.407136e-001, 2.407742e-001, 2.408348e-001, 2.408955e-001, 2.409562e-001, 2.410168e-001, 2.410775e-001, 2.411382e-001, 2.411988e-001, 2.412595e-001, 2.413202e-001, 2.413809e-001, 2.414416e-001, 2.415023e-001, 2.415630e-001, 2.416238e-001, 2.416845e-001, 2.417452e-001, 2.418060e-001, 2.418667e-001, 2.419275e-001, 2.419882e-001, 2.420490e-001, 2.421097e-001, 2.421705e-001, 2.422313e-001, 2.422921e-001, 2.423529e-001, 2.424137e-001, 2.424745e-001, 2.425353e-001, 2.425961e-001, 2.426569e-001, 2.427178e-001, 2.427786e-001, 2.428394e-001, 2.429003e-001, 2.429611e-001, 2.430220e-001, 2.430829e-001, 2.431437e-001, 2.432046e-001, 2.432655e-001, 2.433264e-001, 2.433873e-001, 2.434482e-001, 2.435091e-001, 2.435700e-001, 2.436309e-001, 2.436918e-001, 2.437528e-001, 2.438137e-001, 2.438746e-001, 2.439356e-001, 2.439965e-001, 2.440575e-001, 2.441185e-001, 2.441794e-001, 2.442404e-001, 2.443014e-001, 2.443624e-001, 2.444234e-001, 2.444844e-001, 2.445454e-001, 2.446064e-001, 2.446674e-001, 2.447284e-001, 2.447894e-001, 2.448505e-001, 2.449115e-001, 2.449726e-001, 2.450336e-001, 
2.450947e-001, 2.451557e-001, 2.452168e-001, 2.452779e-001, 2.453390e-001, 2.454000e-001, 2.454611e-001, 2.455222e-001, 2.455833e-001, 2.456444e-001, 2.457056e-001, 2.457667e-001, 2.458278e-001, 2.458889e-001, 2.459501e-001, 2.460112e-001, 2.460724e-001, 2.461335e-001, 2.461947e-001, 2.462559e-001, 2.463170e-001, 2.463782e-001, 2.464394e-001, 2.465006e-001, 2.465618e-001, 2.466230e-001, 2.466842e-001, 2.467454e-001, 2.468066e-001, 2.468678e-001, 2.469291e-001, 2.469903e-001, 2.470515e-001, 2.471128e-001, 2.471740e-001, 2.472353e-001, 2.472966e-001, 2.473578e-001, 2.474191e-001, 2.474804e-001, 2.475417e-001, 2.476030e-001, 2.476643e-001, 2.477256e-001, 2.477869e-001, 2.478482e-001, 2.479095e-001, 2.479708e-001, 2.480322e-001, 2.480935e-001, 2.481549e-001, 2.482162e-001, 2.482776e-001, 2.483389e-001, 2.484003e-001, 2.484617e-001, 2.485230e-001, 2.485844e-001, 2.486458e-001, 2.487072e-001, 2.487686e-001, 2.488300e-001, 2.488914e-001, 2.489528e-001, 2.490143e-001, 2.490757e-001, 2.491371e-001, 2.491986e-001, 2.492600e-001, 2.493214e-001, 2.493829e-001, 2.494444e-001, 2.495058e-001, 2.495673e-001, 2.496288e-001, 2.496903e-001, 2.497518e-001, 2.498133e-001, 2.498748e-001, 2.499363e-001, 2.499978e-001, 2.500593e-001, 2.501208e-001, 2.501823e-001, 2.502439e-001, 2.503054e-001, 2.503670e-001, 2.504285e-001, 2.504901e-001, 2.505516e-001, 2.506132e-001, 2.506748e-001, 2.507363e-001, 2.507979e-001, 2.508595e-001, 2.509211e-001, 2.509827e-001, 2.510443e-001, 2.511059e-001, 2.511675e-001, 
2.512292e-001, 2.512908e-001, 2.513524e-001, 2.514141e-001, 2.514757e-001, 2.515374e-001, 2.515990e-001, 2.516607e-001, 2.517223e-001, 2.517840e-001, 2.518457e-001, 2.519074e-001, 2.519691e-001, 2.520308e-001, 2.520925e-001, 2.521542e-001, 2.522159e-001, 2.522776e-001, 2.523393e-001, 2.524010e-001, 2.524628e-001, 2.525245e-001, 2.525862e-001, 2.526480e-001, 2.527097e-001, 2.527715e-001, 2.528333e-001, 2.528950e-001, 2.529568e-001, 2.530186e-001, 2.530804e-001, 2.531422e-001, 2.532040e-001, 2.532658e-001, 2.533276e-001, 2.533894e-001, 2.534512e-001, 2.535130e-001, 2.535749e-001, 2.536367e-001, 2.536985e-001, 2.537604e-001, 2.538222e-001, 2.538841e-001, 2.539459e-001, 2.540078e-001, 2.540697e-001, 2.541316e-001, 2.541934e-001, 2.542553e-001, 2.543172e-001, 2.543791e-001, 2.544410e-001, 2.545029e-001, 2.545649e-001, 2.546268e-001, 2.546887e-001, 2.547506e-001, 2.548126e-001, 2.548745e-001, 2.549365e-001, 2.549984e-001, 2.550604e-001, 2.551223e-001, 2.551843e-001, 2.552463e-001, 2.553083e-001, 2.553702e-001, 2.554322e-001, 2.554942e-001, 2.555562e-001, 2.556182e-001, 2.556802e-001, 2.557423e-001, 2.558043e-001, 2.558663e-001, 2.559283e-001, 2.559904e-001, 2.560524e-001, 2.561145e-001, 2.561765e-001, 2.562386e-001, 2.563006e-001, 2.563627e-001, 2.564248e-001, 2.564869e-001, 2.565489e-001, 2.566110e-001, 2.566731e-001, 2.567352e-001, 2.567973e-001, 2.568594e-001, 2.569216e-001, 2.569837e-001, 2.570458e-001, 2.571079e-001, 2.571701e-001, 2.572322e-001, 2.572944e-001, 2.573565e-001, 
2.574187e-001, 2.574808e-001, 2.575430e-001, 2.576052e-001, 2.576673e-001, 2.577295e-001, 2.577917e-001, 2.578539e-001, 2.579161e-001, 2.579783e-001, 2.580405e-001, 2.581027e-001, 2.581650e-001, 2.582272e-001, 2.582894e-001, 2.583516e-001, 2.584139e-001, 2.584761e-001, 2.585384e-001, 2.586006e-001, 2.586629e-001, 2.587252e-001, 2.587874e-001, 2.588497e-001, 2.589120e-001, 2.589743e-001, 2.590366e-001, 2.590989e-001, 2.591612e-001, 2.592235e-001, 2.592858e-001, 2.593481e-001, 2.594104e-001, 2.594728e-001, 2.595351e-001, 2.595974e-001, 2.596598e-001, 2.597221e-001, 2.597845e-001, 2.598468e-001, 2.599092e-001, 2.599716e-001, 2.600339e-001, 2.600963e-001, 2.601587e-001, 2.602211e-001, 2.602835e-001, 2.603459e-001, 2.604083e-001, 2.604707e-001, 2.605331e-001, 2.605955e-001, 2.606579e-001, 2.607204e-001, 2.607828e-001, 2.608452e-001, 2.609077e-001, 2.609701e-001, 2.610326e-001, 2.610951e-001, 2.611575e-001, 2.612200e-001, 2.612825e-001, 2.613449e-001, 2.614074e-001, 2.614699e-001, 2.615324e-001, 2.615949e-001, 2.616574e-001, 2.617199e-001, 2.617824e-001, 2.618450e-001, 2.619075e-001, 2.619700e-001, 2.620325e-001, 2.620951e-001, 2.621576e-001, 2.622202e-001, 2.622827e-001, 2.623453e-001, 2.624079e-001, 2.624704e-001, 2.625330e-001, 2.625956e-001, 2.626582e-001, 2.627207e-001, 2.627833e-001, 2.628459e-001, 2.629085e-001, 2.629711e-001, 2.630338e-001, 2.630964e-001, 2.631590e-001, 2.632216e-001, 2.632843e-001, 2.633469e-001, 2.634095e-001, 2.634722e-001, 2.635348e-001, 2.635975e-001, 
2.636602e-001, 2.637228e-001, 2.637855e-001, 2.638482e-001, 2.639109e-001, 2.639736e-001, 2.640362e-001, 2.640989e-001, 2.641616e-001, 2.642243e-001, 2.642871e-001, 2.643498e-001, 2.644125e-001, 2.644752e-001, 2.645380e-001, 2.646007e-001, 2.646634e-001, 2.647262e-001, 2.647889e-001, 2.648517e-001, 2.649144e-001, 2.649772e-001, 2.650400e-001, 2.651028e-001, 2.651655e-001, 2.652283e-001, 2.652911e-001, 2.653539e-001, 2.654167e-001, 2.654795e-001, 2.655423e-001, 2.656051e-001, 2.656679e-001, 2.657308e-001, 2.657936e-001, 2.658564e-001, 2.659193e-001, 2.659821e-001, 2.660449e-001, 2.661078e-001, 2.661707e-001, 2.662335e-001, 2.662964e-001, 2.663593e-001, 2.664221e-001, 2.664850e-001, 2.665479e-001, 2.666108e-001, 2.666737e-001, 2.667366e-001, 2.667995e-001, 2.668624e-001, 2.669253e-001, 2.669882e-001, 2.670511e-001, 2.671141e-001, 2.671770e-001, 2.672399e-001, 2.673029e-001, 2.673658e-001, 2.674288e-001, 2.674917e-001, 2.675547e-001, 2.676177e-001, 2.676806e-001, 2.677436e-001, 2.678066e-001, 2.678696e-001, 2.679326e-001, 2.679956e-001, 2.680586e-001, 2.681216e-001, 2.681846e-001, 2.682476e-001, 2.683106e-001, 2.683736e-001, 2.684366e-001, 2.684997e-001, 2.685627e-001, 2.686257e-001, 2.686888e-001, 2.687518e-001, 2.688149e-001, 2.688780e-001, 2.689410e-001, 2.690041e-001, 2.690672e-001, 2.691302e-001, 2.691933e-001, 2.692564e-001, 2.693195e-001, 2.693826e-001, 2.694457e-001, 2.695088e-001, 2.695719e-001, 2.696350e-001, 2.696981e-001, 2.697613e-001, 2.698244e-001, 2.698875e-001, 
2.699507e-001, 2.700138e-001, 2.700770e-001, 2.701401e-001, 2.702033e-001, 2.702664e-001, 2.703296e-001, 2.703928e-001, 2.704559e-001, 2.705191e-001, 2.705823e-001, 2.706455e-001, 2.707087e-001, 2.707719e-001, 2.708351e-001, 2.708983e-001, 2.709615e-001, 2.710247e-001, 2.710879e-001, 2.711512e-001, 2.712144e-001, 2.712776e-001, 2.713409e-001, 2.714041e-001, 2.714673e-001, 2.715306e-001, 2.715939e-001, 2.716571e-001, 2.717204e-001, 2.717836e-001, 2.718469e-001, 2.719102e-001, 2.719735e-001, 2.720368e-001, 2.721001e-001, 2.721634e-001, 2.722267e-001, 2.722900e-001, 2.723533e-001, 2.724166e-001, 2.724799e-001, 2.725432e-001, 2.726066e-001, 2.726699e-001, 2.727332e-001, 2.727966e-001, 2.728599e-001, 2.729233e-001, 2.729866e-001, 2.730500e-001, 2.731134e-001, 2.731767e-001, 2.732401e-001, 2.733035e-001, 2.733669e-001, 2.734302e-001, 2.734936e-001, 2.735570e-001, 2.736204e-001, 2.736838e-001, 2.737472e-001, 2.738107e-001, 2.738741e-001, 2.739375e-001, 2.740009e-001, 2.740643e-001, 2.741278e-001, 2.741912e-001, 2.742547e-001, 2.743181e-001, 2.743816e-001, 2.744450e-001, 2.745085e-001, 2.745719e-001, 2.746354e-001, 2.746989e-001, 2.747624e-001, 2.748259e-001, 2.748893e-001, 2.749528e-001, 2.750163e-001, 2.750798e-001, 2.751433e-001, 2.752068e-001, 2.752704e-001, 2.753339e-001, 2.753974e-001, 2.754609e-001, 2.755245e-001, 2.755880e-001, 2.756515e-001, 2.757151e-001, 2.757786e-001, 2.758422e-001, 2.759057e-001, 2.759693e-001, 2.760329e-001, 2.760964e-001, 2.761600e-001, 2.762236e-001, 
2.762872e-001, 2.763508e-001, 2.764143e-001, 2.764779e-001, 2.765415e-001, 2.766051e-001, 2.766688e-001, 2.767324e-001, 2.767960e-001, 2.768596e-001, 2.769232e-001, 2.769869e-001, 2.770505e-001, 2.771141e-001, 2.771778e-001, 2.772414e-001, 2.773051e-001, 2.773687e-001, 2.774324e-001, 2.774961e-001, 2.775597e-001, 2.776234e-001, 2.776871e-001, 2.777508e-001, 2.778144e-001, 2.778781e-001, 2.779418e-001, 2.780055e-001, 2.780692e-001, 2.781329e-001, 2.781966e-001, 2.782604e-001, 2.783241e-001, 2.783878e-001, 2.784515e-001, 2.785153e-001, 2.785790e-001, 2.786427e-001, 2.787065e-001, 2.787702e-001, 2.788340e-001, 2.788977e-001, 2.789615e-001, 2.790253e-001, 2.790890e-001, 2.791528e-001, 2.792166e-001, 2.792804e-001, 2.793441e-001, 2.794079e-001, 2.794717e-001, 2.795355e-001, 2.795993e-001, 2.796631e-001, 2.797269e-001, 2.797908e-001, 2.798546e-001, 2.799184e-001, 2.799822e-001, 2.800461e-001, 2.801099e-001, 2.801737e-001, 2.802376e-001, 2.803014e-001, 2.803653e-001, 2.804291e-001, 2.804930e-001, 2.805569e-001, 2.806207e-001, 2.806846e-001, 2.807485e-001, 2.808124e-001, 2.808762e-001, 2.809401e-001, 2.810040e-001, 2.810679e-001, 2.811318e-001, 2.811957e-001, 2.812596e-001, 2.813236e-001, 2.813875e-001, 2.814514e-001, 2.815153e-001, 2.815792e-001, 2.816432e-001, 2.817071e-001, 2.817711e-001, 2.818350e-001, 2.818990e-001, 2.819629e-001, 2.820269e-001, 2.820908e-001, 2.821548e-001, 2.822188e-001, 2.822827e-001, 2.823467e-001, 2.824107e-001, 2.824747e-001, 2.825387e-001, 2.826027e-001, 
2.826667e-001, 2.827307e-001, 2.827947e-001, 2.828587e-001, 2.829227e-001, 2.829867e-001, 2.830507e-001, 2.831148e-001, 2.831788e-001, 2.832428e-001, 2.833069e-001, 2.833709e-001, 2.834350e-001, 2.834990e-001, 2.835631e-001, 2.836271e-001, 2.836912e-001, 2.837552e-001, 2.838193e-001, 2.838834e-001, 2.839475e-001, 2.840115e-001, 2.840756e-001, 2.841397e-001, 2.842038e-001, 2.842679e-001, 2.843320e-001, 2.843961e-001, 2.844602e-001, 2.845243e-001, 2.845885e-001, 2.846526e-001, 2.847167e-001, 2.847808e-001, 2.848450e-001, 2.849091e-001, 2.849732e-001, 2.850374e-001, 2.851015e-001, 2.851657e-001, 2.852298e-001, 2.852940e-001, 2.853582e-001, 2.854223e-001, 2.854865e-001, 2.855507e-001, 2.856148e-001, 2.856790e-001, 2.857432e-001, 2.858074e-001, 2.858716e-001, 2.859358e-001, 2.860000e-001, 2.860642e-001, 2.861284e-001, 2.861926e-001, 2.862569e-001, 2.863211e-001, 2.863853e-001, 2.864495e-001, 2.865138e-001, 2.865780e-001, 2.866422e-001, 2.867065e-001, 2.867707e-001, 2.868350e-001, 2.868992e-001, 2.869635e-001, 2.870278e-001, 2.870920e-001, 2.871563e-001, 2.872206e-001, 2.872848e-001, 2.873491e-001, 2.874134e-001, 2.874777e-001, 2.875420e-001, 2.876063e-001, 2.876706e-001, 2.877349e-001, 2.877992e-001, 2.878635e-001, 2.879278e-001, 2.879922e-001, 2.880565e-001, 2.881208e-001, 2.881851e-001, 2.882495e-001, 2.883138e-001, 2.883782e-001, 2.884425e-001, 2.885069e-001, 2.885712e-001, 2.886356e-001, 2.886999e-001, 2.887643e-001, 2.888287e-001, 2.888930e-001, 2.889574e-001, 2.890218e-001, 
2.890862e-001, 2.891506e-001, 2.892149e-001, 2.892793e-001, 2.893437e-001, 2.894081e-001, 2.894725e-001, 2.895370e-001, 2.896014e-001, 2.896658e-001, 2.897302e-001, 2.897946e-001, 2.898591e-001, 2.899235e-001, 2.899879e-001, 2.900524e-001, 2.901168e-001, 2.901812e-001, 2.902457e-001, 2.903101e-001, 2.903746e-001, 2.904391e-001, 2.905035e-001, 2.905680e-001, 2.906325e-001, 2.906969e-001, 2.907614e-001, 2.908259e-001, 2.908904e-001, 2.909549e-001, 2.910194e-001, 2.910839e-001, 2.911484e-001, 2.912129e-001, 2.912774e-001, 2.913419e-001, 2.914064e-001, 2.914709e-001, 2.915354e-001, 2.916000e-001, 2.916645e-001, 2.917290e-001, 2.917936e-001, 2.918581e-001, 2.919226e-001, 2.919872e-001, 2.920517e-001, 2.921163e-001, 2.921809e-001, 2.922454e-001, 2.923100e-001, 2.923745e-001, 2.924391e-001, 2.925037e-001, 2.925683e-001, 2.926329e-001, 2.926974e-001, 2.927620e-001, 2.928266e-001, 2.928912e-001, 2.929558e-001, 2.930204e-001, 2.930850e-001, 2.931496e-001, 2.932143e-001, 2.932789e-001, 2.933435e-001, 2.934081e-001, 2.934727e-001, 2.935374e-001, 2.936020e-001, 2.936666e-001, 2.937313e-001, 2.937959e-001, 2.938606e-001, 2.939252e-001, 2.939899e-001, 2.940546e-001, 2.941192e-001, 2.941839e-001, 2.942486e-001, 2.943132e-001, 2.943779e-001, 2.944426e-001, 2.945073e-001, 2.945720e-001, 2.946366e-001, 2.947013e-001, 2.947660e-001, 2.948307e-001, 2.948954e-001, 2.949601e-001, 2.950249e-001, 2.950896e-001, 2.951543e-001, 2.952190e-001, 2.952837e-001, 2.953485e-001, 2.954132e-001, 2.954779e-001, 
2.955427e-001, 2.956074e-001, 2.956722e-001, 2.957369e-001, 2.958017e-001, 2.958664e-001, 2.959312e-001, 2.959959e-001, 2.960607e-001, 2.961255e-001, 2.961902e-001, 2.962550e-001, 2.963198e-001, 2.963846e-001, 2.964494e-001, 2.965141e-001, 2.965789e-001, 2.966437e-001, 2.967085e-001, 2.967733e-001, 2.968381e-001, 2.969030e-001, 2.969678e-001, 2.970326e-001, 2.970974e-001, 2.971622e-001, 2.972270e-001, 2.972919e-001, 2.973567e-001, 2.974215e-001, 2.974864e-001, 2.975512e-001, 2.976161e-001, 2.976809e-001, 2.977458e-001, 2.978106e-001, 2.978755e-001, 2.979403e-001, 2.980052e-001, 2.980701e-001, 2.981350e-001, 2.981998e-001, 2.982647e-001, 2.983296e-001, 2.983945e-001, 2.984594e-001, 2.985243e-001, 2.985892e-001, 2.986540e-001, 2.987189e-001, 2.987839e-001, 2.988488e-001, 2.989137e-001, 2.989786e-001, 2.990435e-001, 2.991084e-001, 2.991734e-001, 2.992383e-001, 2.993032e-001, 2.993681e-001, 2.994331e-001, 2.994980e-001, 2.995630e-001, 2.996279e-001, 2.996929e-001, 2.997578e-001, 2.998228e-001, 2.998877e-001, 2.999527e-001, 3.000177e-001, 3.000826e-001, 3.001476e-001, 3.002126e-001, 3.002776e-001, 3.003425e-001, 3.004075e-001, 3.004725e-001, 3.005375e-001, 3.006025e-001, 3.006675e-001, 3.007325e-001, 3.007975e-001, 3.008625e-001, 3.009275e-001, 3.009925e-001, 3.010575e-001, 3.011226e-001, 3.011876e-001, 3.012526e-001, 3.013176e-001, 3.013827e-001, 3.014477e-001, 3.015127e-001, 3.015778e-001, 3.016428e-001, 3.017079e-001, 3.017729e-001, 3.018380e-001, 3.019030e-001, 3.019681e-001, 
3.020332e-001, 3.020982e-001, 3.021633e-001, 3.022284e-001, 3.022935e-001, 3.023585e-001, 3.024236e-001, 3.024887e-001, 3.025538e-001, 3.026189e-001, 3.026840e-001, 3.027491e-001, 3.028142e-001, 3.028793e-001, 3.029444e-001, 3.030095e-001, 3.030746e-001, 3.031397e-001, 3.032048e-001, 3.032700e-001, 3.033351e-001, 3.034002e-001, 3.034653e-001, 3.035305e-001, 3.035956e-001, 3.036608e-001, 3.037259e-001, 3.037910e-001, 3.038562e-001, 3.039213e-001, 3.039865e-001, 3.040517e-001, 3.041168e-001, 3.041820e-001, 3.042471e-001, 3.043123e-001, 3.043775e-001, 3.044427e-001, 3.045078e-001, 3.045730e-001, 3.046382e-001, 3.047034e-001, 3.047686e-001, 3.048338e-001, 3.048990e-001, 3.049642e-001, 3.050294e-001, 3.050946e-001, 3.051598e-001, 3.052250e-001, 3.052902e-001, 3.053554e-001, 3.054207e-001, 3.054859e-001, 3.055511e-001, 3.056163e-001, 3.056816e-001, 3.057468e-001, 3.058121e-001, 3.058773e-001, 3.059425e-001, 3.060078e-001, 3.060730e-001, 3.061383e-001, 3.062035e-001, 3.062688e-001, 3.063341e-001, 3.063993e-001, 3.064646e-001, 3.065299e-001, 3.065951e-001, 3.066604e-001, 3.067257e-001, 3.067910e-001, 3.068563e-001, 3.069215e-001, 3.069868e-001, 3.070521e-001, 3.071174e-001, 3.071827e-001, 3.072480e-001, 3.073133e-001, 3.073786e-001, 3.074440e-001, 3.075093e-001, 3.075746e-001, 3.076399e-001, 3.077052e-001, 3.077705e-001, 3.078359e-001, 3.079012e-001, 3.079665e-001, 3.080319e-001, 3.080972e-001, 3.081626e-001, 3.082279e-001, 3.082932e-001, 3.083586e-001, 3.084240e-001, 3.084893e-001, 
3.085547e-001, 3.086200e-001, 3.086854e-001, 3.087508e-001, 3.088161e-001, 3.088815e-001, 3.089469e-001, 3.090123e-001, 3.090776e-001, 3.091430e-001, 3.092084e-001, 3.092738e-001, 3.093392e-001, 3.094046e-001, 3.094700e-001, 3.095354e-001, 3.096008e-001, 3.096662e-001, 3.097316e-001, 3.097970e-001, 3.098624e-001, 3.099278e-001, 3.099933e-001, 3.100587e-001, 3.101241e-001, 3.101895e-001, 3.102550e-001, 3.103204e-001, 3.103858e-001, 3.104513e-001, 3.105167e-001, 3.105822e-001, 3.106476e-001, 3.107131e-001, 3.107785e-001, 3.108440e-001, 3.109094e-001, 3.109749e-001, 3.110403e-001, 3.111058e-001, 3.111713e-001, 3.112367e-001, 3.113022e-001, 3.113677e-001, 3.114332e-001, 3.114987e-001, 3.115641e-001, 3.116296e-001, 3.116951e-001, 3.117606e-001, 3.118261e-001, 3.118916e-001, 3.119571e-001, 3.120226e-001, 3.120881e-001, 3.121536e-001, 3.122191e-001, 3.122846e-001, 3.123502e-001, 3.124157e-001, 3.124812e-001, 3.125467e-001, 3.126122e-001, 3.126778e-001, 3.127433e-001, 3.128088e-001, 3.128744e-001, 3.129399e-001, 3.130055e-001, 3.130710e-001, 3.131366e-001, 3.132021e-001, 3.132677e-001, 3.133332e-001, 3.133988e-001, 3.134643e-001, 3.135299e-001, 3.135955e-001, 3.136610e-001, 3.137266e-001, 3.137922e-001, 3.138577e-001, 3.139233e-001, 3.139889e-001, 3.140545e-001, 3.141201e-001, 3.141857e-001, 3.142513e-001, 3.143168e-001, 3.143824e-001, 3.144480e-001, 3.145136e-001, 3.145792e-001, 3.146449e-001, 3.147105e-001, 3.147761e-001, 3.148417e-001, 3.149073e-001, 3.149729e-001, 3.150385e-001, 
3.151042e-001, 3.151698e-001, 3.152354e-001, 3.153011e-001, 3.153667e-001, 3.154323e-001, 3.154980e-001, 3.155636e-001, 3.156292e-001, 3.156949e-001, 3.157605e-001, 3.158262e-001, 3.158918e-001, 3.159575e-001, 3.160232e-001, 3.160888e-001, 3.161545e-001, 3.162202e-001, 3.162858e-001, 3.163515e-001, 3.164172e-001, 3.164828e-001, 3.165485e-001, 3.166142e-001, 3.166799e-001, 3.167456e-001, 3.168113e-001, 3.168769e-001, 3.169426e-001, 3.170083e-001, 3.170740e-001, 3.171397e-001, 3.172054e-001, 3.172711e-001, 3.173368e-001, 3.174026e-001, 3.174683e-001, 3.175340e-001, 3.175997e-001, 3.176654e-001, 3.177311e-001, 3.177969e-001, 3.178626e-001, 3.179283e-001, 3.179940e-001, 3.180598e-001, 3.181255e-001, 3.181913e-001, 3.182570e-001, 3.183227e-001, 3.183885e-001, 3.184542e-001, 3.185200e-001, 3.185857e-001, 3.186515e-001, 3.187172e-001, 3.187830e-001, 3.188488e-001, 3.189145e-001, 3.189803e-001, 3.190461e-001, 3.191118e-001, 3.191776e-001, 3.192434e-001, 3.193092e-001, 3.193749e-001, 3.194407e-001, 3.195065e-001, 3.195723e-001, 3.196381e-001, 3.197039e-001, 3.197697e-001, 3.198355e-001, 3.199013e-001, 3.199671e-001, 3.200329e-001, 3.200987e-001, 3.201645e-001, 3.202303e-001, 3.202961e-001, 3.203619e-001, 3.204277e-001, 3.204935e-001, 3.205594e-001, 3.206252e-001, 3.206910e-001, 3.207568e-001, 3.208227e-001, 3.208885e-001, 3.209543e-001, 3.210202e-001, 3.210860e-001, 3.211519e-001, 3.212177e-001, 3.212835e-001, 3.213494e-001, 3.214152e-001, 3.214811e-001, 3.215470e-001, 3.216128e-001, 
3.216787e-001, 3.217445e-001, 3.218104e-001, 3.218763e-001, 3.219421e-001, 3.220080e-001, 3.220739e-001, 3.221397e-001, 3.222056e-001, 3.222715e-001, 3.223374e-001, 3.224033e-001, 3.224691e-001, 3.225350e-001, 3.226009e-001, 3.226668e-001, 3.227327e-001, 3.227986e-001, 3.228645e-001, 3.229304e-001, 3.229963e-001, 3.230622e-001, 3.231281e-001, 3.231940e-001, 3.232599e-001, 3.233258e-001, 3.233918e-001, 3.234577e-001, 3.235236e-001, 3.235895e-001, 3.236554e-001, 3.237214e-001, 3.237873e-001, 3.238532e-001, 3.239192e-001, 3.239851e-001, 3.240510e-001, 3.241170e-001, 3.241829e-001, 3.242489e-001, 3.243148e-001, 3.243807e-001, 3.244467e-001, 3.245126e-001, 3.245786e-001, 3.246445e-001, 3.247105e-001, 3.247765e-001, 3.248424e-001, 3.249084e-001, 3.249744e-001, 3.250403e-001, 3.251063e-001, 3.251723e-001, 3.252382e-001, 3.253042e-001, 3.253702e-001, 3.254362e-001, 3.255021e-001, 3.255681e-001, 3.256341e-001, 3.257001e-001, 3.257661e-001, 3.258321e-001, 3.258981e-001, 3.259641e-001, 3.260301e-001, 3.260961e-001, 3.261621e-001, 3.262281e-001, 3.262941e-001, 3.263601e-001, 3.264261e-001, 3.264921e-001, 3.265581e-001, 3.266241e-001, 3.266902e-001, 3.267562e-001, 3.268222e-001, 3.268882e-001, 3.269543e-001, 3.270203e-001, 3.270863e-001, 3.271523e-001, 3.272184e-001, 3.272844e-001, 3.273504e-001, 3.274165e-001, 3.274825e-001, 3.275486e-001, 3.276146e-001, 3.276807e-001, 3.277467e-001, 3.278128e-001, 3.278788e-001, 3.279449e-001, 3.280109e-001, 3.280770e-001, 3.281430e-001, 3.282091e-001, 
3.282752e-001, 3.283412e-001, 3.284073e-001, 3.284734e-001, 3.285394e-001, 3.286055e-001, 3.286716e-001, 3.287377e-001, 3.288037e-001, 3.288698e-001, 3.289359e-001, 3.290020e-001, 3.290681e-001, 3.291342e-001, 3.292003e-001, 3.292664e-001, 3.293324e-001, 3.293985e-001, 3.294646e-001, 3.295307e-001, 3.295968e-001, 3.296629e-001, 3.297291e-001, 3.297952e-001, 3.298613e-001, 3.299274e-001, 3.299935e-001, 3.300596e-001, 3.301257e-001, 3.301918e-001, 3.302580e-001, 3.303241e-001, 3.303902e-001, 3.304563e-001, 3.305225e-001, 3.305886e-001, 3.306547e-001, 3.307208e-001, 3.307870e-001, 3.308531e-001, 3.309193e-001, 3.309854e-001, 3.310515e-001, 3.311177e-001, 3.311838e-001, 3.312500e-001, 3.313161e-001, 3.313823e-001, 3.314484e-001, 3.315146e-001, 3.315807e-001, 3.316469e-001, 3.317130e-001, 3.317792e-001, 3.318454e-001, 3.319115e-001, 3.319777e-001, 3.320439e-001, 3.321100e-001, 3.321762e-001, 3.322424e-001, 3.323086e-001, 3.323747e-001, 3.324409e-001, 3.325071e-001, 3.325733e-001, 3.326395e-001, 3.327056e-001, 3.327718e-001, 3.328380e-001, 3.329042e-001, 3.329704e-001, 3.330366e-001, 3.331028e-001, 3.331690e-001, 3.332352e-001, 3.333014e-001, 3.333676e-001, 3.334338e-001, 3.335000e-001, 3.335662e-001, 3.336324e-001, 3.336986e-001, 3.337648e-001, 3.338310e-001, 3.338972e-001, 3.339635e-001, 3.340297e-001, 3.340959e-001, 3.341621e-001, 3.342283e-001, 3.342946e-001, 3.343608e-001, 3.344270e-001, 3.344933e-001, 3.345595e-001, 3.346257e-001, 3.346920e-001, 3.347582e-001, 3.348244e-001, 
3.348907e-001, 3.349569e-001, 3.350231e-001, 3.350894e-001, 3.351556e-001, 3.352219e-001, 3.352881e-001, 3.353544e-001, 3.354206e-001, 3.354869e-001, 3.355531e-001, 3.356194e-001, 3.356857e-001, 3.357519e-001, 3.358182e-001, 3.358844e-001, 3.359507e-001, 3.360170e-001, 3.360832e-001, 3.361495e-001, 3.362158e-001, 3.362821e-001, 3.363483e-001, 3.364146e-001, 3.364809e-001, 3.365472e-001, 3.366134e-001, 3.366797e-001, 3.367460e-001, 3.368123e-001, 3.368786e-001, 3.369449e-001, 3.370111e-001, 3.370774e-001, 3.371437e-001, 3.372100e-001, 3.372763e-001, 3.373426e-001, 3.374089e-001, 3.374752e-001, 3.375415e-001, 3.376078e-001, 3.376741e-001, 3.377404e-001, 3.378067e-001, 3.378730e-001, 3.379394e-001, 3.380057e-001, 3.380720e-001, 3.381383e-001, 3.382046e-001, 3.382709e-001, 3.383372e-001, 3.384036e-001, 3.384699e-001, 3.385362e-001, 3.386025e-001, 3.386689e-001, 3.387352e-001, 3.388015e-001, 3.388678e-001, 3.389342e-001, 3.390005e-001, 3.390668e-001, 3.391332e-001, 3.391995e-001, 3.392658e-001, 3.393322e-001, 3.393985e-001, 3.394649e-001, 3.395312e-001, 3.395976e-001, 3.396639e-001, 3.397303e-001, 3.397966e-001, 3.398630e-001, 3.399293e-001, 3.399957e-001, 3.400620e-001, 3.401284e-001, 3.401947e-001, 3.402611e-001, 3.403275e-001, 3.403938e-001, 3.404602e-001, 3.405265e-001, 3.405929e-001, 3.406593e-001, 3.407256e-001, 3.407920e-001, 3.408584e-001, 3.409248e-001, 3.409911e-001, 3.410575e-001, 3.411239e-001, 3.411903e-001, 3.412566e-001, 3.413230e-001, 3.413894e-001, 3.414558e-001, 
3.415222e-001, 3.415886e-001, 3.416549e-001, 3.417213e-001, 3.417877e-001, 3.418541e-001, 3.419205e-001, 3.419869e-001, 3.420533e-001, 3.421197e-001, 3.421861e-001, 3.422525e-001, 3.423189e-001, 3.423853e-001, 3.424517e-001, 3.425181e-001, 3.425845e-001, 3.426509e-001, 3.427173e-001, 3.427837e-001, 3.428501e-001, 3.429165e-001, 3.429829e-001, 3.430494e-001, 3.431158e-001, 3.431822e-001, 3.432486e-001, 3.433150e-001, 3.433814e-001, 3.434479e-001, 3.435143e-001, 3.435807e-001, 3.436471e-001, 3.437136e-001, 3.437800e-001, 3.438464e-001, 3.439128e-001, 3.439793e-001, 3.440457e-001, 3.441121e-001, 3.441786e-001, 3.442450e-001, 3.443114e-001, 3.443779e-001, 3.444443e-001, 3.445108e-001, 3.445772e-001, 3.446436e-001, 3.447101e-001, 3.447765e-001, 3.448430e-001, 3.449094e-001, 3.449759e-001, 3.450423e-001, 3.451088e-001, 3.451752e-001, 3.452417e-001, 3.453081e-001, 3.453746e-001, 3.454410e-001, 3.455075e-001, 3.455740e-001, 3.456404e-001, 3.457069e-001, 3.457733e-001, 3.458398e-001, 3.459063e-001, 3.459727e-001, 3.460392e-001, 3.461057e-001, 3.461721e-001, 3.462386e-001, 3.463051e-001, 3.463715e-001, 3.464380e-001, 3.465045e-001, 3.465710e-001, 3.466374e-001, 3.467039e-001, 3.467704e-001, 3.468369e-001, 3.469034e-001, 3.469698e-001, 3.470363e-001, 3.471028e-001, 3.471693e-001, 3.472358e-001, 3.473023e-001, 3.473687e-001, 3.474352e-001, 3.475017e-001, 3.475682e-001, 3.476347e-001, 3.477012e-001, 3.477677e-001, 3.478342e-001, 3.479007e-001, 3.479672e-001, 3.480337e-001, 3.481002e-001, 
3.481667e-001, 3.482332e-001, 3.482997e-001, 3.483662e-001, 3.484327e-001, 3.484992e-001, 3.485657e-001, 3.486322e-001, 3.486987e-001, 3.487652e-001, 3.488317e-001, 3.488982e-001, 3.489647e-001, 3.490313e-001, 3.490978e-001, 3.491643e-001, 3.492308e-001, 3.492973e-001, 3.493638e-001, 3.494303e-001, 3.494969e-001, 3.495634e-001, 3.496299e-001, 3.496964e-001, 3.497629e-001, 3.498295e-001, 3.498960e-001, 3.499625e-001, 3.500290e-001, 3.500956e-001, 3.501621e-001, 3.502286e-001, 3.502952e-001, 3.503617e-001, 3.504282e-001, 3.504948e-001, 3.505613e-001, 3.506278e-001, 3.506944e-001, 3.507609e-001, 3.508274e-001, 3.508940e-001, 3.509605e-001, 3.510271e-001, 3.510936e-001, 3.511601e-001, 3.512267e-001, 3.512932e-001, 3.513598e-001, 3.514263e-001, 3.514929e-001, 3.515594e-001, 3.516259e-001, 3.516925e-001, 3.517590e-001, 3.518256e-001, 3.518921e-001, 3.519587e-001, 3.520253e-001, 3.520918e-001, 3.521584e-001, 3.522249e-001, 3.522915e-001, 3.523580e-001, 3.524246e-001, 3.524911e-001, 3.525577e-001, 3.526243e-001, 3.526908e-001, 3.527574e-001, 3.528239e-001, 3.528905e-001, 3.529571e-001, 3.530236e-001, 3.530902e-001, 3.531568e-001, 3.532233e-001, 3.532899e-001, 3.533565e-001, 3.534230e-001, 3.534896e-001, 3.535562e-001, 3.536228e-001, 3.536893e-001, 3.537559e-001, 3.538225e-001, 3.538890e-001, 3.539556e-001, 3.540222e-001, 3.540888e-001, 3.541554e-001, 3.542219e-001, 3.542885e-001, 3.543551e-001, 3.544217e-001, 3.544883e-001, 3.545548e-001, 3.546214e-001, 3.546880e-001, 3.547546e-001, 
3.548212e-001, 3.548878e-001, 3.549543e-001, 3.550209e-001, 3.550875e-001, 3.551541e-001, 3.552207e-001, 3.552873e-001, 3.553539e-001, 3.554205e-001, 3.554871e-001, 3.555536e-001, 3.556202e-001, 3.556868e-001, 3.557534e-001, 3.558200e-001, 3.558866e-001, 3.559532e-001, 3.560198e-001, 3.560864e-001, 3.561530e-001, 3.562196e-001, 3.562862e-001, 3.563528e-001, 3.564194e-001, 3.564860e-001, 3.565526e-001, 3.566192e-001, 3.566858e-001, 3.567524e-001, 3.568190e-001, 3.568856e-001, 3.569522e-001, 3.570188e-001, 3.570854e-001, 3.571520e-001, 3.572187e-001, 3.572853e-001, 3.573519e-001, 3.574185e-001, 3.574851e-001, 3.575517e-001, 3.576183e-001, 3.576849e-001, 3.577515e-001, 3.578182e-001, 3.578848e-001, 3.579514e-001, 3.580180e-001, 3.580846e-001, 3.581512e-001, 3.582178e-001, 3.582845e-001, 3.583511e-001, 3.584177e-001, 3.584843e-001, 3.585509e-001, 3.586176e-001, 3.586842e-001, 3.587508e-001, 3.588174e-001, 3.588840e-001, 3.589507e-001, 3.590173e-001, 3.590839e-001, 3.591505e-001, 3.592172e-001, 3.592838e-001, 3.593504e-001, 3.594170e-001, 3.594837e-001, 3.595503e-001, 3.596169e-001, 3.596835e-001, 3.597502e-001, 3.598168e-001, 3.598834e-001, 3.599501e-001, 3.600167e-001, 3.600833e-001, 3.601500e-001, 3.602166e-001, 3.602832e-001, 3.603498e-001, 3.604165e-001, 3.604831e-001, 3.605497e-001, 3.606164e-001, 3.606830e-001, 3.607497e-001, 3.608163e-001, 3.608829e-001, 3.609496e-001, 3.610162e-001, 3.610828e-001, 3.611495e-001, 3.612161e-001, 3.612827e-001, 3.613494e-001, 3.614160e-001, 
3.614827e-001, 3.615493e-001, 3.616159e-001, 3.616826e-001, 3.617492e-001, 3.618159e-001, 3.618825e-001, 3.619492e-001, 3.620158e-001, 3.620824e-001, 3.621491e-001, 3.622157e-001, 3.622824e-001, 3.623490e-001, 3.624157e-001, 3.624823e-001, 3.625490e-001, 3.626156e-001, 3.626822e-001, 3.627489e-001, 3.628155e-001, 3.628822e-001, 3.629488e-001, 3.630155e-001, 3.630821e-001, 3.631488e-001, 3.632154e-001, 3.632821e-001, 3.633487e-001, 3.634154e-001, 3.634820e-001, 3.635487e-001, 3.636153e-001, 3.636820e-001, 3.637486e-001, 3.638153e-001, 3.638819e-001, 3.639486e-001, 3.640152e-001, 3.640819e-001, 3.641486e-001, 3.642152e-001, 3.642819e-001, 3.643485e-001, 3.644152e-001, 3.644818e-001, 3.645485e-001, 3.646151e-001, 3.646818e-001, 3.647484e-001, 3.648151e-001, 3.648818e-001, 3.649484e-001, 3.650151e-001, 3.650817e-001, 3.651484e-001, 3.652150e-001, 3.652817e-001, 3.653484e-001, 3.654150e-001, 3.654817e-001, 3.655483e-001, 3.656150e-001, 3.656817e-001, 3.657483e-001, 3.658150e-001, 3.658816e-001, 3.659483e-001, 3.660150e-001, 3.660816e-001, 3.661483e-001, 3.662149e-001, 3.662816e-001, 3.663483e-001, 3.664149e-001, 3.664816e-001, 3.665482e-001, 3.666149e-001, 3.666816e-001, 3.667482e-001, 3.668149e-001, 3.668816e-001, 3.669482e-001, 3.670149e-001, 3.670815e-001, 3.671482e-001, 3.672149e-001, 3.672815e-001, 3.673482e-001, 3.674149e-001, 3.674815e-001, 3.675482e-001, 3.676149e-001, 3.676815e-001, 3.677482e-001, 3.678148e-001, 3.678815e-001, 3.679482e-001, 3.680148e-001, 3.680815e-001, 
3.681482e-001, 3.682148e-001, 3.682815e-001, 3.683482e-001, 3.684148e-001, 3.684815e-001, 3.685482e-001, 3.686148e-001, 3.686815e-001, 3.687482e-001, 3.688148e-001, 3.688815e-001, 3.689482e-001, 3.690148e-001, 3.690815e-001, 3.691482e-001, 3.692148e-001, 3.692815e-001, 3.693481e-001, 3.694148e-001, 3.694815e-001, 3.695481e-001, 3.696148e-001, 3.696815e-001, 3.697481e-001, 3.698148e-001, 3.698815e-001, 3.699481e-001, 3.700148e-001, 3.700815e-001, 3.701481e-001, 3.702148e-001, 3.702815e-001, 3.703481e-001, 3.704148e-001, 3.704815e-001, 3.705481e-001, 3.706148e-001, 3.706815e-001, 3.707481e-001, 3.708148e-001, 3.708815e-001, 3.709481e-001, 3.710148e-001, 3.710815e-001, 3.711481e-001, 3.712148e-001, 3.712815e-001, 3.713481e-001, 3.714148e-001, 3.714815e-001, 3.715481e-001, 3.716148e-001, 3.716815e-001, 3.717481e-001, 3.718148e-001, 3.718815e-001, 3.719481e-001, 3.720148e-001, 3.720815e-001, 3.721481e-001, 3.722148e-001, 3.722815e-001, 3.723481e-001, 3.724148e-001, 3.724815e-001, 3.725481e-001, 3.726148e-001, 3.726815e-001, 3.727481e-001, 3.728148e-001, 3.728815e-001, 3.729481e-001, 3.730148e-001, 3.730814e-001, 3.731481e-001, 3.732148e-001, 3.732814e-001, 3.733481e-001, 3.734148e-001, 3.734814e-001, 3.735481e-001, 3.736148e-001, 3.736814e-001, 3.737481e-001, 3.738147e-001, 3.738814e-001, 3.739481e-001, 3.740147e-001, 3.740814e-001, 3.741481e-001, 3.742147e-001, 3.742814e-001, 3.743480e-001, 3.744147e-001, 3.744814e-001, 3.745480e-001, 3.746147e-001, 3.746813e-001, 3.747480e-001, 
3.748147e-001, 3.748813e-001, 3.749480e-001, 3.750146e-001, 3.750813e-001, 3.751480e-001, 3.752146e-001, 3.752813e-001, 3.753479e-001, 3.754146e-001, 3.754813e-001, 3.755479e-001, 3.756146e-001, 3.756812e-001, 3.757479e-001, 3.758145e-001, 3.758812e-001, 3.759479e-001, 3.760145e-001, 3.760812e-001, 3.761478e-001, 3.762145e-001, 3.762811e-001, 3.763478e-001, 3.764144e-001, 3.764811e-001, 3.765478e-001, 3.766144e-001, 3.766811e-001, 3.767477e-001, 3.768144e-001, 3.768810e-001, 3.769477e-001, 3.770143e-001, 3.770810e-001, 3.771476e-001, 3.772143e-001, 3.772809e-001, 3.773476e-001, 3.774142e-001, 3.774809e-001, 3.775475e-001, 3.776142e-001, 3.776808e-001, 3.777475e-001, 3.778141e-001, 3.778808e-001, 3.779474e-001, 3.780141e-001, 3.780807e-001, 3.781474e-001, 3.782140e-001, 3.782806e-001, 3.783473e-001, 3.784139e-001, 3.784806e-001, 3.785472e-001, 3.786139e-001, 3.786805e-001, 3.787472e-001, 3.788138e-001, 3.788804e-001, 3.789471e-001, 3.790137e-001, 3.790804e-001, 3.791470e-001, 3.792136e-001, 3.792803e-001, 3.793469e-001, 3.794136e-001, 3.794802e-001, 3.795468e-001, 3.796135e-001, 3.796801e-001, 3.797468e-001, 3.798134e-001, 3.798800e-001, 3.799467e-001, 3.800133e-001, 3.800799e-001, 3.801466e-001, 3.802132e-001, 3.802798e-001, 3.803465e-001, 3.804131e-001, 3.804797e-001, 3.805464e-001, 3.806130e-001, 3.806796e-001, 3.807463e-001, 3.808129e-001, 3.808795e-001, 3.809462e-001, 3.810128e-001, 3.810794e-001, 3.811460e-001, 3.812127e-001, 3.812793e-001, 3.813459e-001, 3.814125e-001, 
3.814792e-001, 3.815458e-001, 3.816124e-001, 3.816790e-001, 3.817457e-001, 3.818123e-001, 3.818789e-001, 3.819455e-001, 3.820122e-001, 3.820788e-001, 3.821454e-001, 3.822120e-001, 3.822786e-001, 3.823452e-001, 3.824119e-001, 3.824785e-001, 3.825451e-001, 3.826117e-001, 3.826783e-001, 3.827449e-001, 3.828116e-001, 3.828782e-001, 3.829448e-001, 3.830114e-001, 3.830780e-001, 3.831446e-001, 3.832112e-001, 3.832778e-001, 3.833445e-001, 3.834111e-001, 3.834777e-001, 3.835443e-001, 3.836109e-001, 3.836775e-001, 3.837441e-001, 3.838107e-001, 3.838773e-001, 3.839439e-001, 3.840105e-001, 3.840771e-001, 3.841437e-001, 3.842103e-001, 3.842769e-001, 3.843435e-001, 3.844101e-001, 3.844767e-001, 3.845433e-001, 3.846099e-001, 3.846765e-001, 3.847431e-001, 3.848097e-001, 3.848763e-001, 3.849429e-001, 3.850095e-001, 3.850761e-001, 3.851427e-001, 3.852093e-001, 3.852759e-001, 3.853425e-001, 3.854091e-001, 3.854757e-001, 3.855422e-001, 3.856088e-001, 3.856754e-001, 3.857420e-001, 3.858086e-001, 3.858752e-001, 3.859418e-001, 3.860084e-001, 3.860749e-001, 3.861415e-001, 3.862081e-001, 3.862747e-001, 3.863413e-001, 3.864078e-001, 3.864744e-001, 3.865410e-001, 3.866076e-001, 3.866742e-001, 3.867407e-001, 3.868073e-001, 3.868739e-001, 3.869405e-001, 3.870070e-001, 3.870736e-001, 3.871402e-001, 3.872067e-001, 3.872733e-001, 3.873399e-001, 3.874065e-001, 3.874730e-001, 3.875396e-001, 3.876062e-001, 3.876727e-001, 3.877393e-001, 3.878059e-001, 3.878724e-001, 3.879390e-001, 3.880055e-001, 3.880721e-001, 
3.881387e-001, 3.882052e-001, 3.882718e-001, 3.883383e-001, 3.884049e-001, 3.884715e-001, 3.885380e-001, 3.886046e-001, 3.886711e-001, 3.887377e-001, 3.888042e-001, 3.888708e-001, 3.889373e-001, 3.890039e-001, 3.890704e-001, 3.891370e-001, 3.892035e-001, 3.892701e-001, 3.893366e-001, 3.894032e-001, 3.894697e-001, 3.895362e-001, 3.896028e-001, 3.896693e-001, 3.897359e-001, 3.898024e-001, 3.898689e-001, 3.899355e-001, 3.900020e-001, 3.900686e-001, 3.901351e-001, 3.902016e-001, 3.902682e-001, 3.903347e-001, 3.904012e-001, 3.904678e-001, 3.905343e-001, 3.906008e-001, 3.906673e-001, 3.907339e-001, 3.908004e-001, 3.908669e-001, 3.909334e-001, 3.910000e-001, 3.910665e-001, 3.911330e-001, 3.911995e-001, 3.912661e-001, 3.913326e-001, 3.913991e-001, 3.914656e-001, 3.915321e-001, 3.915986e-001, 3.916651e-001, 3.917317e-001, 3.917982e-001, 3.918647e-001, 3.919312e-001, 3.919977e-001, 3.920642e-001, 3.921307e-001, 3.921972e-001, 3.922637e-001, 3.923302e-001, 3.923967e-001, 3.924632e-001, 3.925297e-001, 3.925962e-001, 3.926627e-001, 3.927292e-001, 3.927957e-001, 3.928622e-001, 3.929287e-001, 3.929952e-001, 3.930617e-001, 3.931282e-001, 3.931947e-001, 3.932612e-001, 3.933277e-001, 3.933942e-001, 3.934607e-001, 3.935271e-001, 3.935936e-001, 3.936601e-001, 3.937266e-001, 3.937931e-001, 3.938596e-001, 3.939260e-001, 3.939925e-001, 3.940590e-001, 3.941255e-001, 3.941919e-001, 3.942584e-001, 3.943249e-001, 3.943914e-001, 3.944578e-001, 3.945243e-001, 3.945908e-001, 3.946572e-001, 3.947237e-001, 
3.947902e-001, 3.948566e-001, 3.949231e-001, 3.949896e-001, 3.950560e-001, 3.951225e-001, 3.951889e-001, 3.952554e-001, 3.953219e-001, 3.953883e-001, 3.954548e-001, 3.955212e-001, 3.955877e-001, 3.956541e-001, 3.957206e-001, 3.957870e-001, 3.958535e-001, 3.959199e-001, 3.959864e-001, 3.960528e-001, 3.961192e-001, 3.961857e-001, 3.962521e-001, 3.963186e-001, 3.963850e-001, 3.964514e-001, 3.965179e-001, 3.965843e-001, 3.966507e-001, 3.967172e-001, 3.967836e-001, 3.968500e-001, 3.969165e-001, 3.969829e-001, 3.970493e-001, 3.971157e-001, 3.971822e-001, 3.972486e-001, 3.973150e-001, 3.973814e-001, 3.974479e-001, 3.975143e-001, 3.975807e-001, 3.976471e-001, 3.977135e-001, 3.977799e-001, 3.978463e-001, 3.979128e-001, 3.979792e-001, 3.980456e-001, 3.981120e-001, 3.981784e-001, 3.982448e-001, 3.983112e-001, 3.983776e-001, 3.984440e-001, 3.985104e-001, 3.985768e-001, 3.986432e-001, 3.987096e-001, 3.987760e-001, 3.988424e-001, 3.989088e-001, 3.989752e-001, 3.990415e-001, 3.991079e-001, 3.991743e-001, 3.992407e-001, 3.993071e-001, 3.993735e-001, 3.994399e-001, 3.995062e-001, 3.995726e-001, 3.996390e-001, 3.997054e-001, 3.997717e-001, 3.998381e-001, 3.999045e-001, 3.999709e-001, 4.000372e-001, 4.001036e-001, 4.001700e-001, 4.002363e-001, 4.003027e-001, 4.003690e-001, 4.004354e-001, 4.005018e-001, 4.005681e-001, 4.006345e-001, 4.007008e-001, 4.007672e-001, 4.008336e-001, 4.008999e-001, 4.009663e-001, 4.010326e-001, 4.010989e-001, 4.011653e-001, 4.012316e-001, 4.012980e-001, 4.013643e-001, 
4.014307e-001, 4.014970e-001, 4.015633e-001, 4.016297e-001, 4.016960e-001, 4.017623e-001, 4.018287e-001, 4.018950e-001, 4.019613e-001, 4.020277e-001, 4.020940e-001, 4.021603e-001, 4.022266e-001, 4.022930e-001, 4.023593e-001, 4.024256e-001, 4.024919e-001, 4.025582e-001, 4.026246e-001, 4.026909e-001, 4.027572e-001, 4.028235e-001, 4.028898e-001, 4.029561e-001, 4.030224e-001, 4.030887e-001, 4.031550e-001, 4.032213e-001, 4.032876e-001, 4.033539e-001, 4.034202e-001, 4.034865e-001, 4.035528e-001, 4.036191e-001, 4.036854e-001, 4.037517e-001, 4.038180e-001, 4.038843e-001, 4.039505e-001, 4.040168e-001, 4.040831e-001, 4.041494e-001, 4.042157e-001, 4.042820e-001, 4.043482e-001, 4.044145e-001, 4.044808e-001, 4.045470e-001, 4.046133e-001, 4.046796e-001, 4.047459e-001, 4.048121e-001, 4.048784e-001, 4.049446e-001, 4.050109e-001, 4.050772e-001, 4.051434e-001, 4.052097e-001, 4.052759e-001, 4.053422e-001, 4.054084e-001, 4.054747e-001, 4.055409e-001, 4.056072e-001, 4.056734e-001, 4.057397e-001, 4.058059e-001, 4.058722e-001, 4.059384e-001, 4.060046e-001, 4.060709e-001, 4.061371e-001, 4.062033e-001, 4.062696e-001, 4.063358e-001, 4.064020e-001, 4.064682e-001, 4.065345e-001, 4.066007e-001, 4.066669e-001, 4.067331e-001, 4.067993e-001, 4.068656e-001, 4.069318e-001, 4.069980e-001, 4.070642e-001, 4.071304e-001, 4.071966e-001, 4.072628e-001, 4.073290e-001, 4.073952e-001, 4.074614e-001, 4.075276e-001, 4.075938e-001, 4.076600e-001, 4.077262e-001, 4.077924e-001, 4.078586e-001, 4.079248e-001, 4.079910e-001, 
4.080572e-001, 4.081234e-001, 4.081895e-001, 4.082557e-001, 4.083219e-001, 4.083881e-001, 4.084542e-001, 4.085204e-001, 4.085866e-001, 4.086528e-001, 4.087189e-001, 4.087851e-001, 4.088513e-001, 4.089174e-001, 4.089836e-001, 4.090497e-001, 4.091159e-001, 4.091821e-001, 4.092482e-001, 4.093144e-001, 4.093805e-001, 4.094467e-001, 4.095128e-001, 4.095790e-001, 4.096451e-001, 4.097113e-001, 4.097774e-001, 4.098435e-001, 4.099097e-001, 4.099758e-001, 4.100419e-001, 4.101081e-001, 4.101742e-001, 4.102403e-001, 4.103065e-001, 4.103726e-001, 4.104387e-001, 4.105048e-001, 4.105709e-001, 4.106371e-001, 4.107032e-001, 4.107693e-001, 4.108354e-001, 4.109015e-001, 4.109676e-001, 4.110337e-001, 4.110998e-001, 4.111659e-001, 4.112320e-001, 4.112981e-001, 4.113642e-001, 4.114303e-001, 4.114964e-001, 4.115625e-001, 4.116286e-001, 4.116947e-001, 4.117608e-001, 4.118269e-001, 4.118929e-001, 4.119590e-001, 4.120251e-001, 4.120912e-001, 4.121573e-001, 4.122233e-001, 4.122894e-001, 4.123555e-001, 4.124215e-001, 4.124876e-001, 4.125537e-001, 4.126197e-001, 4.126858e-001, 4.127518e-001, 4.128179e-001, 4.128839e-001, 4.129500e-001, 4.130160e-001, 4.130821e-001, 4.131481e-001, 4.132142e-001, 4.132802e-001, 4.133463e-001, 4.134123e-001, 4.134783e-001, 4.135444e-001, 4.136104e-001, 4.136764e-001, 4.137425e-001, 4.138085e-001, 4.138745e-001, 4.139405e-001, 4.140066e-001, 4.140726e-001, 4.141386e-001, 4.142046e-001, 4.142706e-001, 4.143366e-001, 4.144027e-001, 4.144687e-001, 4.145347e-001, 4.146007e-001, 
4.146667e-001, 4.147327e-001, 4.147987e-001, 4.148647e-001, 4.149307e-001, 4.149966e-001, 4.150626e-001, 4.151286e-001, 4.151946e-001, 4.152606e-001, 4.153266e-001, 4.153925e-001, 4.154585e-001, 4.155245e-001, 4.155905e-001, 4.156564e-001, 4.157224e-001, 4.157884e-001, 4.158543e-001, 4.159203e-001, 4.159863e-001, 4.160522e-001, 4.161182e-001, 4.161841e-001, 4.162501e-001, 4.163160e-001, 4.163820e-001, 4.164479e-001, 4.165139e-001, 4.165798e-001, 4.166458e-001, 4.167117e-001, 4.167776e-001, 4.168436e-001, 4.169095e-001, 4.169754e-001, 4.170413e-001, 4.171073e-001, 4.171732e-001, 4.172391e-001, 4.173050e-001, 4.173710e-001, 4.174369e-001, 4.175028e-001, 4.175687e-001, 4.176346e-001, 4.177005e-001, 4.177664e-001, 4.178323e-001, 4.178982e-001, 4.179641e-001, 4.180300e-001, 4.180959e-001, 4.181618e-001, 4.182277e-001, 4.182936e-001, 4.183594e-001, 4.184253e-001, 4.184912e-001, 4.185571e-001, 4.186230e-001, 4.186888e-001, 4.187547e-001, 4.188206e-001, 4.188864e-001, 4.189523e-001, 4.190182e-001, 4.190840e-001, 4.191499e-001, 4.192157e-001, 4.192816e-001, 4.193474e-001, 4.194133e-001, 4.194791e-001, 4.195450e-001, 4.196108e-001, 4.196767e-001, 4.197425e-001, 4.198083e-001, 4.198742e-001, 4.199400e-001, 4.200058e-001, 4.200717e-001, 4.201375e-001, 4.202033e-001, 4.202691e-001, 4.203350e-001, 4.204008e-001, 4.204666e-001, 4.205324e-001, 4.205982e-001, 4.206640e-001, 4.207298e-001, 4.207956e-001, 4.208614e-001, 4.209272e-001, 4.209930e-001, 4.210588e-001, 4.211246e-001, 4.211904e-001, 
4.212562e-001, 4.213220e-001, 4.213877e-001, 4.214535e-001, 4.215193e-001, 4.215851e-001, 4.216508e-001, 4.217166e-001, 4.217824e-001, 4.218481e-001, 4.219139e-001, 4.219797e-001, 4.220454e-001, 4.221112e-001, 4.221769e-001, 4.222427e-001, 4.223084e-001, 4.223742e-001, 4.224399e-001, 4.225057e-001, 4.225714e-001, 4.226371e-001, 4.227029e-001, 4.227686e-001, 4.228343e-001, 4.229001e-001, 4.229658e-001, 4.230315e-001, 4.230972e-001, 4.231630e-001, 4.232287e-001, 4.232944e-001, 4.233601e-001, 4.234258e-001, 4.234915e-001, 4.235572e-001, 4.236229e-001, 4.236886e-001, 4.237543e-001, 4.238200e-001, 4.238857e-001, 4.239514e-001, 4.240171e-001, 4.240828e-001, 4.241484e-001, 4.242141e-001, 4.242798e-001, 4.243455e-001, 4.244111e-001, 4.244768e-001, 4.245425e-001, 4.246081e-001, 4.246738e-001, 4.247395e-001, 4.248051e-001, 4.248708e-001, 4.249364e-001, 4.250021e-001, 4.250677e-001, 4.251334e-001, 4.251990e-001, 4.252647e-001, 4.253303e-001, 4.253959e-001, 4.254616e-001, 4.255272e-001, 4.255928e-001, 4.256584e-001, 4.257241e-001, 4.257897e-001, 4.258553e-001, 4.259209e-001, 4.259865e-001, 4.260521e-001, 4.261178e-001, 4.261834e-001, 4.262490e-001, 4.263146e-001, 4.263802e-001, 4.264458e-001, 4.265114e-001, 4.265769e-001, 4.266425e-001, 4.267081e-001, 4.267737e-001, 4.268393e-001, 4.269049e-001, 4.269704e-001, 4.270360e-001, 4.271016e-001, 4.271671e-001, 4.272327e-001, 4.272983e-001, 4.273638e-001, 4.274294e-001, 4.274949e-001, 4.275605e-001, 4.276260e-001, 4.276916e-001, 4.277571e-001, 
4.278227e-001, 4.278882e-001, 4.279537e-001, 4.280193e-001, 4.280848e-001, 4.281503e-001, 4.282159e-001, 4.282814e-001, 4.283469e-001, 4.284124e-001, 4.284779e-001, 4.285434e-001, 4.286090e-001, 4.286745e-001, 4.287400e-001, 4.288055e-001, 4.288710e-001, 4.289365e-001, 4.290020e-001, 4.290675e-001, 4.291329e-001, 4.291984e-001, 4.292639e-001, 4.293294e-001, 4.293949e-001, 4.294603e-001, 4.295258e-001, 4.295913e-001, 4.296568e-001, 4.297222e-001, 4.297877e-001, 4.298531e-001, 4.299186e-001, 4.299841e-001, 4.300495e-001, 4.301150e-001, 4.301804e-001, 4.302458e-001, 4.303113e-001, 4.303767e-001, 4.304422e-001, 4.305076e-001, 4.305730e-001, 4.306384e-001, 4.307039e-001, 4.307693e-001, 4.308347e-001, 4.309001e-001, 4.309655e-001, 4.310309e-001, 4.310964e-001, 4.311618e-001, 4.312272e-001, 4.312926e-001, 4.313580e-001, 4.314234e-001, 4.314887e-001, 4.315541e-001, 4.316195e-001, 4.316849e-001, 4.317503e-001, 4.318157e-001, 4.318810e-001, 4.319464e-001, 4.320118e-001, 4.320771e-001, 4.321425e-001, 4.322079e-001, 4.322732e-001, 4.323386e-001, 4.324039e-001, 4.324693e-001, 4.325346e-001, 4.326000e-001, 4.326653e-001, 4.327306e-001, 4.327960e-001, 4.328613e-001, 4.329266e-001, 4.329920e-001, 4.330573e-001, 4.331226e-001, 4.331879e-001, 4.332532e-001, 4.333186e-001, 4.333839e-001, 4.334492e-001, 4.335145e-001, 4.335798e-001, 4.336451e-001, 4.337104e-001, 4.337757e-001, 4.338410e-001, 4.339062e-001, 4.339715e-001, 4.340368e-001, 4.341021e-001, 4.341674e-001, 4.342326e-001, 4.342979e-001, 
4.343632e-001, 4.344284e-001, 4.344937e-001, 4.345589e-001, 4.346242e-001, 4.346895e-001, 4.347547e-001, 4.348200e-001, 4.348852e-001, 4.349504e-001, 4.350157e-001, 4.350809e-001, 4.351461e-001, 4.352114e-001, 4.352766e-001, 4.353418e-001, 4.354070e-001, 4.354723e-001, 4.355375e-001, 4.356027e-001, 4.356679e-001, 4.357331e-001, 4.357983e-001, 4.358635e-001, 4.359287e-001, 4.359939e-001, 4.360591e-001, 4.361243e-001, 4.361894e-001, 4.362546e-001, 4.363198e-001, 4.363850e-001, 4.364501e-001, 4.365153e-001, 4.365805e-001, 4.366456e-001, 4.367108e-001, 4.367760e-001, 4.368411e-001, 4.369063e-001, 4.369714e-001, 4.370366e-001, 4.371017e-001, 4.371668e-001, 4.372320e-001, 4.372971e-001, 4.373622e-001, 4.374274e-001, 4.374925e-001, 4.375576e-001, 4.376227e-001, 4.376878e-001, 4.377530e-001, 4.378181e-001, 4.378832e-001, 4.379483e-001, 4.380134e-001, 4.380785e-001, 4.381436e-001, 4.382087e-001, 4.382737e-001, 4.383388e-001, 4.384039e-001, 4.384690e-001, 4.385341e-001, 4.385991e-001, 4.386642e-001, 4.387293e-001, 4.387943e-001, 4.388594e-001, 4.389244e-001, 4.389895e-001, 4.390545e-001, 4.391196e-001, 4.391846e-001, 4.392497e-001, 4.393147e-001, 4.393797e-001, 4.394448e-001, 4.395098e-001, 4.395748e-001, 4.396399e-001, 4.397049e-001, 4.397699e-001, 4.398349e-001, 4.398999e-001, 4.399649e-001, 4.400299e-001, 4.400949e-001, 4.401599e-001, 4.402249e-001, 4.402899e-001, 4.403549e-001, 4.404199e-001, 4.404848e-001, 4.405498e-001, 4.406148e-001, 4.406798e-001, 4.407447e-001, 4.408097e-001, 
4.408747e-001, 4.409396e-001, 4.410046e-001, 4.410695e-001, 4.411345e-001, 4.411994e-001, 4.412644e-001, 4.413293e-001, 4.413942e-001, 4.414592e-001, 4.415241e-001, 4.415890e-001, 4.416540e-001, 4.417189e-001, 4.417838e-001, 4.418487e-001, 4.419136e-001, 4.419785e-001, 4.420434e-001, 4.421083e-001, 4.421732e-001, 4.422381e-001, 4.423030e-001, 4.423679e-001, 4.424328e-001, 4.424977e-001, 4.425625e-001, 4.426274e-001, 4.426923e-001, 4.427571e-001, 4.428220e-001, 4.428869e-001, 4.429517e-001, 4.430166e-001, 4.430814e-001, 4.431463e-001, 4.432111e-001, 4.432760e-001, 4.433408e-001, 4.434056e-001, 4.434705e-001, 4.435353e-001, 4.436001e-001, 4.436649e-001, 4.437298e-001, 4.437946e-001, 4.438594e-001, 4.439242e-001, 4.439890e-001, 4.440538e-001, 4.441186e-001, 4.441834e-001, 4.442482e-001, 4.443130e-001, 4.443778e-001, 4.444425e-001, 4.445073e-001, 4.445721e-001, 4.446369e-001, 4.447016e-001, 4.447664e-001, 4.448312e-001, 4.448959e-001, 4.449607e-001, 4.450254e-001, 4.450902e-001, 4.451549e-001, 4.452197e-001, 4.452844e-001, 4.453491e-001, 4.454139e-001, 4.454786e-001, 4.455433e-001, 4.456080e-001, 4.456727e-001, 4.457375e-001, 4.458022e-001, 4.458669e-001, 4.459316e-001, 4.459963e-001, 4.460610e-001, 4.461257e-001, 4.461904e-001, 4.462550e-001, 4.463197e-001, 4.463844e-001, 4.464491e-001, 4.465137e-001, 4.465784e-001, 4.466431e-001, 4.467077e-001, 4.467724e-001, 4.468371e-001, 4.469017e-001, 4.469664e-001, 4.470310e-001, 4.470956e-001, 4.471603e-001, 4.472249e-001, 4.472895e-001, 
4.473542e-001, 4.474188e-001, 4.474834e-001, 4.475480e-001, 4.476126e-001, 4.476772e-001, 4.477419e-001, 4.478065e-001, 4.478711e-001, 4.479356e-001, 4.480002e-001, 4.480648e-001, 4.481294e-001, 4.481940e-001, 4.482586e-001, 4.483231e-001, 4.483877e-001, 4.484523e-001, 4.485168e-001, 4.485814e-001, 4.486460e-001, 4.487105e-001, 4.487751e-001, 4.488396e-001, 4.489042e-001, 4.489687e-001, 4.490332e-001, 4.490978e-001, 4.491623e-001, 4.492268e-001, 4.492913e-001, 4.493558e-001, 4.494204e-001, 4.494849e-001, 4.495494e-001, 4.496139e-001, 4.496784e-001, 4.497429e-001, 4.498074e-001, 4.498719e-001, 4.499363e-001, 4.500008e-001, 4.500653e-001, 4.501298e-001, 4.501942e-001, 4.502587e-001, 4.503232e-001, 4.503876e-001, 4.504521e-001, 4.505165e-001, 4.505810e-001, 4.506454e-001, 4.507099e-001, 4.507743e-001, 4.508387e-001, 4.509032e-001, 4.509676e-001, 4.510320e-001, 4.510964e-001, 4.511608e-001, 4.512253e-001, 4.512897e-001, 4.513541e-001, 4.514185e-001, 4.514829e-001, 4.515473e-001, 4.516116e-001, 4.516760e-001, 4.517404e-001, 4.518048e-001, 4.518692e-001, 4.519335e-001, 4.519979e-001, 4.520623e-001, 4.521266e-001, 4.521910e-001, 4.522553e-001, 4.523197e-001, 4.523840e-001, 4.524484e-001, 4.525127e-001, 4.525770e-001, 4.526414e-001, 4.527057e-001, 4.527700e-001, 4.528343e-001, 4.528987e-001, 4.529630e-001, 4.530273e-001, 4.530916e-001, 4.531559e-001, 4.532202e-001, 4.532845e-001, 4.533488e-001, 4.534130e-001, 4.534773e-001, 4.535416e-001, 4.536059e-001, 4.536701e-001, 4.537344e-001, 
4.537987e-001, 4.538629e-001, 4.539272e-001, 4.539914e-001, 4.540557e-001, 4.541199e-001, 4.541842e-001, 4.542484e-001, 4.543126e-001, 4.543769e-001, 4.544411e-001, 4.545053e-001, 4.545695e-001, 4.546337e-001, 4.546979e-001, 4.547621e-001, 4.548263e-001, 4.548905e-001, 4.549547e-001, 4.550189e-001, 4.550831e-001, 4.551473e-001, 4.552115e-001, 4.552756e-001, 4.553398e-001, 4.554040e-001, 4.554681e-001, 4.555323e-001, 4.555964e-001, 4.556606e-001, 4.557247e-001, 4.557889e-001, 4.558530e-001, 4.559172e-001, 4.559813e-001, 4.560454e-001, 4.561095e-001, 4.561737e-001, 4.562378e-001, 4.563019e-001, 4.563660e-001, 4.564301e-001, 4.564942e-001, 4.565583e-001, 4.566224e-001, 4.566865e-001, 4.567506e-001, 4.568146e-001, 4.568787e-001, 4.569428e-001, 4.570069e-001, 4.570709e-001, 4.571350e-001, 4.571990e-001, 4.572631e-001, 4.573271e-001, 4.573912e-001, 4.574552e-001, 4.575193e-001, 4.575833e-001, 4.576473e-001, 4.577113e-001, 4.577754e-001, 4.578394e-001, 4.579034e-001, 4.579674e-001, 4.580314e-001, 4.580954e-001, 4.581594e-001, 4.582234e-001, 4.582874e-001, 4.583514e-001, 4.584154e-001, 4.584793e-001, 4.585433e-001, 4.586073e-001, 4.586712e-001, 4.587352e-001, 4.587991e-001, 4.588631e-001, 4.589271e-001, 4.589910e-001, 4.590549e-001, 4.591189e-001, 4.591828e-001, 4.592467e-001, 4.593107e-001, 4.593746e-001, 4.594385e-001, 4.595024e-001, 4.595663e-001, 4.596302e-001, 4.596941e-001, 4.597580e-001, 4.598219e-001, 4.598858e-001, 4.599497e-001, 4.600136e-001, 4.600774e-001, 4.601413e-001, 
4.602052e-001, 4.602690e-001, 4.603329e-001, 4.603967e-001, 4.604606e-001, 4.605244e-001, 4.605883e-001, 4.606521e-001, 4.607160e-001, 4.607798e-001, 4.608436e-001, 4.609074e-001, 4.609713e-001, 4.610351e-001, 4.610989e-001, 4.611627e-001, 4.612265e-001, 4.612903e-001, 4.613541e-001, 4.614179e-001, 4.614816e-001, 4.615454e-001, 4.616092e-001, 4.616730e-001, 4.617367e-001, 4.618005e-001, 4.618643e-001, 4.619280e-001, 4.619918e-001, 4.620555e-001, 4.621193e-001, 4.621830e-001, 4.622467e-001, 4.623105e-001, 4.623742e-001, 4.624379e-001, 4.625016e-001, 4.625653e-001, 4.626290e-001, 4.626928e-001, 4.627565e-001, 4.628202e-001, 4.628838e-001, 4.629475e-001, 4.630112e-001, 4.630749e-001, 4.631386e-001, 4.632022e-001, 4.632659e-001, 4.633296e-001, 4.633932e-001, 4.634569e-001, 4.635205e-001, 4.635842e-001, 4.636478e-001, 4.637115e-001, 4.637751e-001, 4.638387e-001, 4.639023e-001, 4.639660e-001, 4.640296e-001, 4.640932e-001, 4.641568e-001, 4.642204e-001, 4.642840e-001, 4.643476e-001, 4.644112e-001, 4.644748e-001, 4.645384e-001, 4.646019e-001, 4.646655e-001, 4.647291e-001, 4.647926e-001, 4.648562e-001, 4.649197e-001, 4.649833e-001, 4.650468e-001, 4.651104e-001, 4.651739e-001, 4.652375e-001, 4.653010e-001, 4.653645e-001, 4.654280e-001, 4.654916e-001, 4.655551e-001, 4.656186e-001, 4.656821e-001, 4.657456e-001, 4.658091e-001, 4.658726e-001, 4.659360e-001, 4.659995e-001, 4.660630e-001, 4.661265e-001, 4.661899e-001, 4.662534e-001, 4.663169e-001, 4.663803e-001, 4.664438e-001, 4.665072e-001, 
4.665707e-001, 4.666341e-001, 4.666975e-001, 4.667610e-001, 4.668244e-001, 4.668878e-001, 4.669512e-001, 4.670146e-001, 4.670780e-001, 4.671414e-001, 4.672048e-001, 4.672682e-001, 4.673316e-001, 4.673950e-001, 4.674584e-001, 4.675218e-001, 4.675851e-001, 4.676485e-001, 4.677119e-001, 4.677752e-001, 4.678386e-001, 4.679019e-001, 4.679653e-001, 4.680286e-001, 4.680920e-001, 4.681553e-001, 4.682186e-001, 4.682819e-001, 4.683453e-001, 4.684086e-001, 4.684719e-001, 4.685352e-001, 4.685985e-001, 4.686618e-001, 4.687251e-001, 4.687884e-001, 4.688516e-001, 4.689149e-001, 4.689782e-001, 4.690415e-001, 4.691047e-001, 4.691680e-001, 4.692312e-001, 4.692945e-001, 4.693577e-001, 4.694210e-001, 4.694842e-001, 4.695474e-001, 4.696107e-001, 4.696739e-001, 4.697371e-001, 4.698003e-001, 4.698635e-001, 4.699267e-001, 4.699899e-001, 4.700531e-001, 4.701163e-001, 4.701795e-001, 4.702427e-001, 4.703059e-001, 4.703690e-001, 4.704322e-001, 4.704954e-001, 4.705585e-001, 4.706217e-001, 4.706848e-001, 4.707480e-001, 4.708111e-001, 4.708743e-001, 4.709374e-001, 4.710005e-001, 4.710636e-001, 4.711268e-001, 4.711899e-001, 4.712530e-001, 4.713161e-001, 4.713792e-001, 4.714423e-001, 4.715054e-001, 4.715684e-001, 4.716315e-001, 4.716946e-001, 4.717577e-001, 4.718207e-001, 4.718838e-001, 4.719469e-001, 4.720099e-001, 4.720730e-001, 4.721360e-001, 4.721990e-001, 4.722621e-001, 4.723251e-001, 4.723881e-001, 4.724512e-001, 4.725142e-001, 4.725772e-001, 4.726402e-001, 4.727032e-001, 4.727662e-001, 4.728292e-001, 
4.728922e-001, 4.729551e-001, 4.730181e-001, 4.730811e-001, 4.731441e-001, 4.732070e-001, 4.732700e-001, 4.733329e-001, 4.733959e-001, 4.734588e-001, 4.735218e-001, 4.735847e-001, 4.736476e-001, 4.737106e-001, 4.737735e-001, 4.738364e-001, 4.738993e-001, 4.739622e-001, 4.740251e-001, 4.740880e-001, 4.741509e-001, 4.742138e-001, 4.742767e-001, 4.743396e-001, 4.744024e-001, 4.744653e-001, 4.745282e-001, 4.745910e-001, 4.746539e-001, 4.747167e-001, 4.747796e-001, 4.748424e-001, 4.749053e-001, 4.749681e-001, 4.750309e-001, 4.750937e-001, 4.751566e-001, 4.752194e-001, 4.752822e-001, 4.753450e-001, 4.754078e-001, 4.754706e-001, 4.755334e-001, 4.755961e-001, 4.756589e-001, 4.757217e-001, 4.757845e-001, 4.758472e-001, 4.759100e-001, 4.759727e-001, 4.760355e-001, 4.760982e-001, 4.761610e-001, 4.762237e-001, 4.762864e-001, 4.763491e-001, 4.764119e-001, 4.764746e-001, 4.765373e-001, 4.766000e-001, 4.766627e-001, 4.767254e-001, 4.767881e-001, 4.768508e-001, 4.769134e-001, 4.769761e-001, 4.770388e-001, 4.771015e-001, 4.771641e-001, 4.772268e-001, 4.772894e-001, 4.773521e-001, 4.774147e-001, 4.774774e-001, 4.775400e-001, 4.776026e-001, 4.776652e-001, 4.777279e-001, 4.777905e-001, 4.778531e-001, 4.779157e-001, 4.779783e-001, 4.780409e-001, 4.781034e-001, 4.781660e-001, 4.782286e-001, 4.782912e-001, 4.783537e-001, 4.784163e-001, 4.784789e-001, 4.785414e-001, 4.786040e-001, 4.786665e-001, 4.787290e-001, 4.787916e-001, 4.788541e-001, 4.789166e-001, 4.789791e-001, 4.790417e-001, 4.791042e-001, 
4.791667e-001, 4.792292e-001, 4.792917e-001, 4.793541e-001, 4.794166e-001, 4.794791e-001, 4.795416e-001, 4.796040e-001, 4.796665e-001, 4.797290e-001, 4.797914e-001, 4.798539e-001, 4.799163e-001, 4.799787e-001, 4.800412e-001, 4.801036e-001, 4.801660e-001, 4.802284e-001, 4.802909e-001, 4.803533e-001, 4.804157e-001, 4.804781e-001, 4.805405e-001, 4.806028e-001, 4.806652e-001, 4.807276e-001, 4.807900e-001, 4.808523e-001, 4.809147e-001, 4.809771e-001, 4.810394e-001, 4.811017e-001, 4.811641e-001, 4.812264e-001, 4.812888e-001, 4.813511e-001, 4.814134e-001, 4.814757e-001, 4.815380e-001, 4.816003e-001, 4.816626e-001, 4.817249e-001, 4.817872e-001, 4.818495e-001, 4.819118e-001, 4.819741e-001, 4.820363e-001, 4.820986e-001, 4.821609e-001, 4.822231e-001, 4.822854e-001, 4.823476e-001, 4.824098e-001, 4.824721e-001, 4.825343e-001, 4.825965e-001, 4.826587e-001, 4.827210e-001, 4.827832e-001, 4.828454e-001, 4.829076e-001, 4.829698e-001, 4.830319e-001, 4.830941e-001, 4.831563e-001, 4.832185e-001, 4.832806e-001, 4.833428e-001, 4.834049e-001, 4.834671e-001, 4.835292e-001, 4.835914e-001, 4.836535e-001, 4.837156e-001, 4.837778e-001, 4.838399e-001, 4.839020e-001, 4.839641e-001, 4.840262e-001, 4.840883e-001, 4.841504e-001, 4.842125e-001, 4.842746e-001, 4.843367e-001, 4.843987e-001, 4.844608e-001, 4.845229e-001, 4.845849e-001, 4.846470e-001, 4.847090e-001, 4.847711e-001, 4.848331e-001, 4.848951e-001, 4.849571e-001, 4.850192e-001, 4.850812e-001, 4.851432e-001, 4.852052e-001, 4.852672e-001, 4.853292e-001, 
4.853912e-001, 4.854531e-001, 4.855151e-001, 4.855771e-001, 4.856391e-001, 4.857010e-001, 4.857630e-001, 4.858249e-001, 4.858869e-001, 4.859488e-001, 4.860108e-001, 4.860727e-001, 4.861346e-001, 4.861965e-001, 4.862584e-001, 4.863203e-001, 4.863822e-001, 4.864441e-001, 4.865060e-001, 4.865679e-001, 4.866298e-001, 4.866917e-001, 4.867535e-001, 4.868154e-001, 4.868773e-001, 4.869391e-001, 4.870010e-001, 4.870628e-001, 4.871247e-001, 4.871865e-001, 4.872483e-001, 4.873101e-001, 4.873720e-001, 4.874338e-001, 4.874956e-001, 4.875574e-001, 4.876192e-001, 4.876810e-001, 4.877427e-001, 4.878045e-001, 4.878663e-001, 4.879281e-001, 4.879898e-001, 4.880516e-001, 4.881133e-001, 4.881751e-001, 4.882368e-001, 4.882986e-001, 4.883603e-001, 4.884220e-001, 4.884837e-001, 4.885454e-001, 4.886072e-001, 4.886689e-001, 4.887306e-001, 4.887922e-001, 4.888539e-001, 4.889156e-001, 4.889773e-001, 4.890390e-001, 4.891006e-001, 4.891623e-001, 4.892239e-001, 4.892856e-001, 4.893472e-001, 4.894089e-001, 4.894705e-001, 4.895321e-001, 4.895937e-001, 4.896554e-001, 4.897170e-001, 4.897786e-001, 4.898402e-001, 4.899018e-001, 4.899633e-001, 4.900249e-001, 4.900865e-001, 4.901481e-001, 4.902096e-001, 4.902712e-001, 4.903328e-001, 4.903943e-001, 4.904558e-001, 4.905174e-001, 4.905789e-001, 4.906404e-001, 4.907020e-001, 4.907635e-001, 4.908250e-001, 4.908865e-001, 4.909480e-001, 4.910095e-001, 4.910710e-001, 4.911324e-001, 4.911939e-001, 4.912554e-001, 4.913169e-001, 4.913783e-001, 4.914398e-001, 4.915012e-001, 
4.915627e-001, 4.916241e-001, 4.916855e-001, 4.917470e-001, 4.918084e-001, 4.918698e-001, 4.919312e-001, 4.919926e-001, 4.920540e-001, 4.921154e-001, 4.921768e-001, 4.922382e-001, 4.922995e-001, 4.923609e-001, 4.924223e-001, 4.924836e-001, 4.925450e-001, 4.926063e-001, 4.926677e-001, 4.927290e-001, 4.927903e-001, 4.928517e-001, 4.929130e-001, 4.929743e-001, 4.930356e-001, 4.930969e-001, 4.931582e-001, 4.932195e-001, 4.932808e-001, 4.933421e-001, 4.934033e-001, 4.934646e-001, 4.935259e-001, 4.935871e-001, 4.936484e-001, 4.937096e-001, 4.937709e-001, 4.938321e-001, 4.938933e-001, 4.939545e-001, 4.940158e-001, 4.940770e-001, 4.941382e-001, 4.941994e-001, 4.942606e-001, 4.943218e-001, 4.943829e-001, 4.944441e-001, 4.945053e-001, 4.945664e-001, 4.946276e-001, 4.946888e-001, 4.947499e-001, 4.948110e-001, 4.948722e-001, 4.949333e-001, 4.949944e-001, 4.950556e-001, 4.951167e-001, 4.951778e-001, 4.952389e-001, 4.953000e-001, 4.953611e-001, 4.954221e-001, 4.954832e-001, 4.955443e-001, 4.956054e-001, 4.956664e-001, 4.957275e-001, 4.957885e-001, 4.958496e-001, 4.959106e-001, 4.959716e-001, 4.960327e-001, 4.960937e-001, 4.961547e-001, 4.962157e-001, 4.962767e-001, 4.963377e-001, 4.963987e-001, 4.964597e-001, 4.965207e-001, 4.965816e-001, 4.966426e-001, 4.967036e-001, 4.967645e-001, 4.968255e-001, 4.968864e-001, 4.969474e-001, 4.970083e-001, 4.970692e-001, 4.971301e-001, 4.971911e-001, 4.972520e-001, 4.973129e-001, 4.973738e-001, 4.974347e-001, 4.974955e-001, 4.975564e-001, 4.976173e-001, 
4.976782e-001, 4.977390e-001, 4.977999e-001, 4.978607e-001, 4.979216e-001, 4.979824e-001, 4.980433e-001, 4.981041e-001, 4.981649e-001, 4.982257e-001, 4.982865e-001, 4.983473e-001, 4.984081e-001, 4.984689e-001, 4.985297e-001, 4.985905e-001, 4.986512e-001, 4.987120e-001, 4.987728e-001, 4.988335e-001, 4.988943e-001, 4.989550e-001, 4.990158e-001, 4.990765e-001, 4.991372e-001, 4.991979e-001, 4.992587e-001, 4.993194e-001, 4.993801e-001, 4.994408e-001, 4.995014e-001, 4.995621e-001, 4.996228e-001, 4.996835e-001, 4.997441e-001, 4.998048e-001, 4.998655e-001, 4.999261e-001, 4.999867e-001, 5.000474e-001, 5.001080e-001, 5.001686e-001, 5.002293e-001, 5.002899e-001, 5.003505e-001, 5.004111e-001, 5.004717e-001, 5.005323e-001, 5.005928e-001, 5.006534e-001, 5.007140e-001, 5.007745e-001, 5.008351e-001, 5.008957e-001, 5.009562e-001, 5.010167e-001, 5.010773e-001, 5.011378e-001, 5.011983e-001, 5.012588e-001, 5.013193e-001, 5.013798e-001, 5.014403e-001, 5.015008e-001, 5.015613e-001, 5.016218e-001, 5.016823e-001, 5.017427e-001, 5.018032e-001, 5.018636e-001, 5.019241e-001, 5.019845e-001, 5.020450e-001, 5.021054e-001, 5.021658e-001, 5.022262e-001, 5.022866e-001, 5.023471e-001, 5.024075e-001, 5.024678e-001, 5.025282e-001, 5.025886e-001, 5.026490e-001, 5.027094e-001, 5.027697e-001, 5.028301e-001, 5.028904e-001, 5.029508e-001, 5.030111e-001, 5.030714e-001, 5.031318e-001, 5.031921e-001, 5.032524e-001, 5.033127e-001, 5.033730e-001, 5.034333e-001, 5.034936e-001, 5.035539e-001, 5.036141e-001, 5.036744e-001, 
5.037347e-001, 5.037949e-001, 5.038552e-001, 5.039154e-001, 5.039757e-001, 5.040359e-001, 5.040961e-001, 5.041563e-001, 5.042165e-001, 5.042768e-001, 5.043370e-001, 5.043972e-001, 5.044573e-001, 5.045175e-001, 5.045777e-001, 5.046379e-001, 5.046980e-001, 5.047582e-001, 5.048183e-001, 5.048785e-001, 5.049386e-001, 5.049988e-001, 5.050589e-001, 5.051190e-001, 5.051791e-001, 5.052392e-001, 5.052993e-001, 5.053594e-001, 5.054195e-001, 5.054796e-001, 5.055397e-001, 5.055997e-001, 5.056598e-001, 5.057199e-001, 5.057799e-001, 5.058399e-001, 5.059000e-001, 5.059600e-001, 5.060200e-001, 5.060801e-001, 5.061401e-001, 5.062001e-001, 5.062601e-001, 5.063201e-001, 5.063801e-001, 5.064400e-001, 5.065000e-001, 5.065600e-001, 5.066199e-001, 5.066799e-001, 5.067399e-001, 5.067998e-001, 5.068597e-001, 5.069197e-001, 5.069796e-001, 5.070395e-001, 5.070994e-001, 5.071593e-001, 5.072192e-001, 5.072791e-001, 5.073390e-001, 5.073989e-001, 5.074588e-001, 5.075186e-001, 5.075785e-001, 5.076383e-001, 5.076982e-001, 5.077580e-001, 5.078179e-001, 5.078777e-001, 5.079375e-001, 5.079973e-001, 5.080571e-001, 5.081169e-001, 5.081767e-001, 5.082365e-001, 5.082963e-001, 5.083561e-001, 5.084158e-001, 5.084756e-001, 5.085354e-001, 5.085951e-001, 5.086549e-001, 5.087146e-001, 5.087743e-001, 5.088341e-001, 5.088938e-001, 5.089535e-001, 5.090132e-001, 5.090729e-001, 5.091326e-001, 5.091923e-001, 5.092520e-001, 5.093116e-001, 5.093713e-001, 5.094310e-001, 5.094906e-001, 5.095503e-001, 5.096099e-001, 5.096695e-001, 
5.097292e-001, 5.097888e-001, 5.098484e-001, 5.099080e-001, 5.099676e-001, 5.100272e-001, 5.100868e-001, 5.101464e-001, 5.102060e-001, 5.102655e-001, 5.103251e-001, 5.103846e-001, 5.104442e-001, 5.105037e-001, 5.105633e-001, 5.106228e-001, 5.106823e-001, 5.107418e-001, 5.108014e-001, 5.108609e-001, 5.109204e-001, 5.109799e-001, 5.110393e-001, 5.110988e-001, 5.111583e-001, 5.112178e-001, 5.112772e-001, 5.113367e-001, 5.113961e-001, 5.114555e-001, 5.115150e-001, 5.115744e-001, 5.116338e-001, 5.116932e-001, 5.117526e-001, 5.118120e-001, 5.118714e-001, 5.119308e-001, 5.119902e-001, 5.120496e-001, 5.121089e-001, 5.121683e-001, 5.122276e-001, 5.122870e-001, 5.123463e-001, 5.124057e-001, 5.124650e-001, 5.125243e-001, 5.125836e-001, 5.126429e-001, 5.127022e-001, 5.127615e-001, 5.128208e-001, 5.128801e-001, 5.129394e-001, 5.129986e-001, 5.130579e-001, 5.131171e-001, 5.131764e-001, 5.132356e-001, 5.132949e-001, 5.133541e-001, 5.134133e-001, 5.134725e-001, 5.135317e-001, 5.135909e-001, 5.136501e-001, 5.137093e-001, 5.137685e-001, 5.138277e-001, 5.138868e-001, 5.139460e-001, 5.140051e-001, 5.140643e-001, 5.141234e-001, 5.141825e-001, 5.142417e-001, 5.143008e-001, 5.143599e-001, 5.144190e-001, 5.144781e-001, 5.145372e-001, 5.145963e-001, 5.146554e-001, 5.147144e-001, 5.147735e-001, 5.148326e-001, 5.148916e-001, 5.149507e-001, 5.150097e-001, 5.150687e-001, 5.151278e-001, 5.151868e-001, 5.152458e-001, 5.153048e-001, 5.153638e-001, 5.154228e-001, 5.154818e-001, 5.155407e-001, 5.155997e-001, 
5.156587e-001, 5.157176e-001, 5.157766e-001, 5.158355e-001, 5.158945e-001, 5.159534e-001, 5.160123e-001, 5.160712e-001, 5.161301e-001, 5.161890e-001, 5.162479e-001, 5.163068e-001, 5.163657e-001, 5.164246e-001, 5.164834e-001, 5.165423e-001, 5.166012e-001, 5.166600e-001, 5.167188e-001, 5.167777e-001, 5.168365e-001, 5.168953e-001, 5.169541e-001, 5.170129e-001, 5.170717e-001, 5.171305e-001, 5.171893e-001, 5.172481e-001, 5.173069e-001, 5.173656e-001, 5.174244e-001, 5.174831e-001, 5.175419e-001, 5.176006e-001, 5.176594e-001, 5.177181e-001, 5.177768e-001, 5.178355e-001, 5.178942e-001, 5.179529e-001, 5.180116e-001, 5.180703e-001, 5.181290e-001, 5.181876e-001, 5.182463e-001, 5.183049e-001, 5.183636e-001, 5.184222e-001, 5.184809e-001, 5.185395e-001, 5.185981e-001, 5.186567e-001, 5.187153e-001, 5.187739e-001, 5.188325e-001, 5.188911e-001, 5.189497e-001, 5.190082e-001, 5.190668e-001, 5.191254e-001, 5.191839e-001, 5.192425e-001, 5.193010e-001, 5.193595e-001, 5.194180e-001, 5.194766e-001, 5.195351e-001, 5.195936e-001, 5.196521e-001, 5.197106e-001, 5.197690e-001, 5.198275e-001, 5.198860e-001, 5.199444e-001, 5.200029e-001, 5.200613e-001, 5.201198e-001, 5.201782e-001, 5.202366e-001, 5.202950e-001, 5.203535e-001, 5.204119e-001, 5.204702e-001, 5.205286e-001, 5.205870e-001, 5.206454e-001, 5.207038e-001, 5.207621e-001, 5.208205e-001, 5.208788e-001, 5.209372e-001, 5.209955e-001, 5.210538e-001, 5.211121e-001, 5.211704e-001, 5.212288e-001, 5.212870e-001, 5.213453e-001, 5.214036e-001, 5.214619e-001, 
5.215202e-001, 5.215784e-001, 5.216367e-001, 5.216949e-001, 5.217532e-001, 5.218114e-001, 5.218696e-001, 5.219278e-001, 5.219861e-001, 5.220443e-001, 5.221025e-001, 5.221607e-001, 5.222188e-001, 5.222770e-001, 5.223352e-001, 5.223933e-001, 5.224515e-001, 5.225096e-001, 5.225678e-001, 5.226259e-001, 5.226840e-001, 5.227422e-001, 5.228003e-001, 5.228584e-001, 5.229165e-001, 5.229746e-001, 5.230326e-001, 5.230907e-001, 5.231488e-001, 5.232069e-001, 5.232649e-001, 5.233230e-001, 5.233810e-001, 5.234390e-001, 5.234971e-001, 5.235551e-001, 5.236131e-001, 5.236711e-001, 5.237291e-001, 5.237871e-001, 5.238451e-001, 5.239030e-001, 5.239610e-001, 5.240190e-001, 5.240769e-001, 5.241349e-001, 5.241928e-001, 5.242507e-001, 5.243087e-001, 5.243666e-001, 5.244245e-001, 5.244824e-001, 5.245403e-001, 5.245982e-001, 5.246560e-001, 5.247139e-001, 5.247718e-001, 5.248296e-001, 5.248875e-001, 5.249453e-001, 5.250032e-001, 5.250610e-001, 5.251188e-001, 5.251766e-001, 5.252345e-001, 5.252923e-001, 5.253500e-001, 5.254078e-001, 5.254656e-001, 5.255234e-001, 5.255812e-001, 5.256389e-001, 5.256967e-001, 5.257544e-001, 5.258121e-001, 5.258699e-001, 5.259276e-001, 5.259853e-001, 5.260430e-001, 5.261007e-001, 5.261584e-001, 5.262161e-001, 5.262738e-001, 5.263314e-001, 5.263891e-001, 5.264467e-001, 5.265044e-001, 5.265620e-001, 5.266197e-001, 5.266773e-001, 5.267349e-001, 5.267925e-001, 5.268501e-001, 5.269077e-001, 5.269653e-001, 5.270229e-001, 5.270804e-001, 5.271380e-001, 5.271956e-001, 5.272531e-001, 
5.273107e-001, 5.273682e-001, 5.274257e-001, 5.274833e-001, 5.275408e-001, 5.275983e-001, 5.276558e-001, 5.277133e-001, 5.277707e-001, 5.278282e-001, 5.278857e-001, 5.279432e-001, 5.280006e-001, 5.280581e-001, 5.281155e-001, 5.281729e-001, 5.282304e-001, 5.282878e-001, 5.283452e-001, 5.284026e-001, 5.284600e-001, 5.285174e-001, 5.285748e-001, 5.286321e-001, 5.286895e-001, 5.287468e-001, 5.288042e-001, 5.288615e-001, 5.289189e-001, 5.289762e-001, 5.290335e-001, 5.290908e-001, 5.291481e-001, 5.292054e-001, 5.292627e-001, 5.293200e-001, 5.293773e-001, 5.294346e-001, 5.294918e-001, 5.295491e-001, 5.296063e-001, 5.296636e-001, 5.297208e-001, 5.297780e-001, 5.298352e-001, 5.298924e-001, 5.299496e-001, 5.300068e-001, 5.300640e-001, 5.301212e-001, 5.301784e-001, 5.302355e-001, 5.302927e-001, 5.303498e-001, 5.304070e-001, 5.304641e-001, 5.305212e-001, 5.305783e-001, 5.306354e-001, 5.306925e-001, 5.307496e-001, 5.308067e-001, 5.308638e-001, 5.309209e-001, 5.309779e-001, 5.310350e-001, 5.310920e-001, 5.311491e-001, 5.312061e-001, 5.312631e-001, 5.313202e-001, 5.313772e-001, 5.314342e-001, 5.314912e-001, 5.315482e-001, 5.316051e-001, 5.316621e-001, 5.317191e-001, 5.317760e-001, 5.318330e-001, 5.318899e-001, 5.319469e-001, 5.320038e-001, 5.320607e-001, 5.321176e-001, 5.321745e-001, 5.322314e-001, 5.322883e-001, 5.323452e-001, 5.324021e-001, 5.324589e-001, 5.325158e-001, 5.325726e-001, 5.326295e-001, 5.326863e-001, 5.327431e-001, 5.328000e-001, 5.328568e-001, 5.329136e-001, 5.329704e-001, 
5.330272e-001, 5.330839e-001, 5.331407e-001, 5.331975e-001, 5.332542e-001, 5.333110e-001, 5.333677e-001, 5.334245e-001, 5.334812e-001, 5.335379e-001, 5.335946e-001, 5.336513e-001, 5.337080e-001, 5.337647e-001, 5.338214e-001, 5.338781e-001, 5.339347e-001, 5.339914e-001, 5.340480e-001, 5.341047e-001, 5.341613e-001, 5.342179e-001, 5.342746e-001, 5.343312e-001, 5.343878e-001, 5.344444e-001, 5.345010e-001, 5.345575e-001, 5.346141e-001, 5.346707e-001, 5.347272e-001, 5.347838e-001, 5.348403e-001, 5.348969e-001, 5.349534e-001, 5.350099e-001, 5.350664e-001, 5.351229e-001, 5.351794e-001, 5.352359e-001, 5.352924e-001, 5.353488e-001, 5.354053e-001, 5.354618e-001, 5.355182e-001, 5.355746e-001, 5.356311e-001, 5.356875e-001, 5.357439e-001, 5.358003e-001, 5.358567e-001, 5.359131e-001, 5.359695e-001, 5.360259e-001, 5.360823e-001, 5.361386e-001, 5.361950e-001, 5.362513e-001, 5.363076e-001, 5.363640e-001, 5.364203e-001, 5.364766e-001, 5.365329e-001, 5.365892e-001, 5.366455e-001, 5.367018e-001, 5.367581e-001, 5.368143e-001, 5.368706e-001, 5.369268e-001, 5.369831e-001, 5.370393e-001, 5.370955e-001, 5.371518e-001, 5.372080e-001, 5.372642e-001, 5.373204e-001, 5.373766e-001, 5.374327e-001, 5.374889e-001, 5.375451e-001, 5.376012e-001, 5.376574e-001, 5.377135e-001, 5.377696e-001, 5.378258e-001, 5.378819e-001, 5.379380e-001, 5.379941e-001, 5.380502e-001, 5.381063e-001, 5.381623e-001, 5.382184e-001, 5.382745e-001, 5.383305e-001, 5.383866e-001, 5.384426e-001, 5.384986e-001, 5.385547e-001, 5.386107e-001, 
5.386667e-001, 5.387227e-001, 5.387787e-001, 5.388346e-001, 5.388906e-001, 5.389466e-001, 5.390025e-001, 5.390585e-001, 5.391144e-001, 5.391703e-001, 5.392263e-001, 5.392822e-001, 5.393381e-001, 5.393940e-001, 5.394499e-001, 5.395058e-001, 5.395616e-001, 5.396175e-001, 5.396734e-001, 5.397292e-001, 5.397851e-001, 5.398409e-001, 5.398967e-001, 5.399525e-001, 5.400084e-001, 5.400642e-001, 5.401200e-001, 5.401757e-001, 5.402315e-001, 5.402873e-001, 5.403431e-001, 5.403988e-001, 5.404546e-001, 5.405103e-001, 5.405660e-001, 5.406217e-001, 5.406775e-001, 5.407332e-001, 5.407889e-001, 5.408446e-001, 5.409002e-001, 5.409559e-001, 5.410116e-001, 5.410672e-001, 5.411229e-001, 5.411785e-001, 5.412342e-001, 5.412898e-001, 5.413454e-001, 5.414010e-001, 5.414566e-001, 5.415122e-001, 5.415678e-001, 5.416234e-001, 5.416789e-001, 5.417345e-001, 5.417900e-001, 5.418456e-001, 5.419011e-001, 5.419566e-001, 5.420122e-001, 5.420677e-001, 5.421232e-001, 5.421787e-001, 5.422342e-001, 5.422896e-001, 5.423451e-001, 5.424006e-001, 5.424560e-001, 5.425115e-001, 5.425669e-001, 5.426223e-001, 5.426777e-001, 5.427332e-001, 5.427886e-001, 5.428440e-001, 5.428993e-001, 5.429547e-001, 5.430101e-001, 5.430655e-001, 5.431208e-001, 5.431762e-001, 5.432315e-001, 5.432868e-001, 5.433421e-001, 5.433975e-001, 5.434528e-001, 5.435081e-001, 5.435633e-001, 5.436186e-001, 5.436739e-001, 5.437292e-001, 5.437844e-001, 5.438397e-001, 5.438949e-001, 5.439501e-001, 5.440054e-001, 5.440606e-001, 5.441158e-001, 5.441710e-001, 
5.442262e-001, 5.442813e-001, 5.443365e-001, 5.443917e-001, 5.444468e-001, 5.445020e-001, 5.445571e-001, 5.446123e-001, 5.446674e-001, 5.447225e-001, 5.447776e-001, 5.448327e-001, 5.448878e-001, 5.449429e-001, 5.449979e-001, 5.450530e-001, 5.451081e-001, 5.451631e-001, 5.452181e-001, 5.452732e-001, 5.453282e-001, 5.453832e-001, 5.454382e-001, 5.454932e-001, 5.455482e-001, 5.456032e-001, 5.456582e-001, 5.457131e-001, 5.457681e-001, 5.458230e-001, 5.458780e-001, 5.459329e-001, 5.459878e-001, 5.460427e-001, 5.460976e-001, 5.461525e-001, 5.462074e-001, 5.462623e-001, 5.463172e-001, 5.463720e-001, 5.464269e-001, 5.464817e-001, 5.465366e-001, 5.465914e-001, 5.466462e-001, 5.467010e-001, 5.467558e-001, 5.468106e-001, 5.468654e-001, 5.469202e-001, 5.469750e-001, 5.470297e-001, 5.470845e-001, 5.471392e-001, 5.471940e-001, 5.472487e-001, 5.473034e-001, 5.473581e-001, 5.474128e-001, 5.474675e-001, 5.475222e-001, 5.475769e-001, 5.476316e-001, 5.476862e-001, 5.477409e-001, 5.477955e-001, 5.478502e-001, 5.479048e-001, 5.479594e-001, 5.480140e-001, 5.480686e-001, 5.481232e-001, 5.481778e-001, 5.482324e-001, 5.482869e-001, 5.483415e-001, 5.483960e-001, 5.484506e-001, 5.485051e-001, 5.485596e-001, 5.486142e-001, 5.486687e-001, 5.487232e-001, 5.487776e-001, 5.488321e-001, 5.488866e-001, 5.489411e-001, 5.489955e-001, 5.490500e-001, 5.491044e-001, 5.491588e-001, 5.492133e-001, 5.492677e-001, 5.493221e-001, 5.493765e-001, 5.494309e-001, 5.494852e-001, 5.495396e-001, 5.495940e-001, 5.496483e-001, 
5.497027e-001, 5.497570e-001, 5.498113e-001, 5.498656e-001, 5.499200e-001, 5.499743e-001, 5.500286e-001, 5.500828e-001, 5.501371e-001, 5.501914e-001, 5.502456e-001, 5.502999e-001, 5.503541e-001, 5.504084e-001, 5.504626e-001, 5.505168e-001, 5.505710e-001, 5.506252e-001, 5.506794e-001, 5.507336e-001, 5.507877e-001, 5.508419e-001, 5.508961e-001, 5.509502e-001, 5.510043e-001, 5.510585e-001, 5.511126e-001, 5.511667e-001, 5.512208e-001, 5.512749e-001, 5.513290e-001, 5.513831e-001, 5.514371e-001, 5.514912e-001, 5.515452e-001, 5.515993e-001, 5.516533e-001, 5.517073e-001, 5.517614e-001, 5.518154e-001, 5.518694e-001, 5.519233e-001, 5.519773e-001, 5.520313e-001, 5.520853e-001, 5.521392e-001, 5.521932e-001, 5.522471e-001, 5.523010e-001, 5.523549e-001, 5.524089e-001, 5.524628e-001, 5.525166e-001, 5.525705e-001, 5.526244e-001, 5.526783e-001, 5.527321e-001, 5.527860e-001, 5.528398e-001, 5.528937e-001, 5.529475e-001, 5.530013e-001, 5.530551e-001, 5.531089e-001, 5.531627e-001, 5.532165e-001, 5.532702e-001, 5.533240e-001, 5.533777e-001, 5.534315e-001, 5.534852e-001, 5.535390e-001, 5.535927e-001, 5.536464e-001, 5.537001e-001, 5.537538e-001, 5.538075e-001, 5.538611e-001, 5.539148e-001, 5.539684e-001, 5.540221e-001, 5.540757e-001, 5.541294e-001, 5.541830e-001, 5.542366e-001, 5.542902e-001, 5.543438e-001, 5.543974e-001, 5.544509e-001, 5.545045e-001, 5.545581e-001, 5.546116e-001, 5.546652e-001, 5.547187e-001, 5.547722e-001, 5.548257e-001, 5.548792e-001, 5.549327e-001, 5.549862e-001, 5.550397e-001, 
5.550932e-001, 5.551466e-001, 5.552001e-001, 5.552535e-001, 5.553070e-001, 5.553604e-001, 5.554138e-001, 5.554672e-001, 5.555206e-001, 5.555740e-001, 5.556274e-001, 5.556807e-001, 5.557341e-001, 5.557875e-001, 5.558408e-001, 5.558941e-001, 5.559475e-001, 5.560008e-001, 5.560541e-001, 5.561074e-001, 5.561607e-001, 5.562140e-001, 5.562672e-001, 5.563205e-001, 5.563738e-001, 5.564270e-001, 5.564802e-001, 5.565335e-001, 5.565867e-001, 5.566399e-001, 5.566931e-001, 5.567463e-001, 5.567995e-001, 5.568526e-001, 5.569058e-001, 5.569590e-001, 5.570121e-001, 5.570653e-001, 5.571184e-001, 5.571715e-001, 5.572246e-001, 5.572777e-001, 5.573308e-001, 5.573839e-001, 5.574370e-001, 5.574900e-001, 5.575431e-001, 5.575961e-001, 5.576492e-001, 5.577022e-001, 5.577552e-001, 5.578082e-001, 5.578612e-001, 5.579142e-001, 5.579672e-001, 5.580202e-001, 5.580732e-001, 5.581261e-001, 5.581791e-001, 5.582320e-001, 5.582849e-001, 5.583379e-001, 5.583908e-001, 5.584437e-001, 5.584966e-001, 5.585495e-001, 5.586023e-001, 5.586552e-001, 5.587081e-001, 5.587609e-001, 5.588137e-001, 5.588666e-001, 5.589194e-001, 5.589722e-001, 5.590250e-001, 5.590778e-001, 5.591306e-001, 5.591834e-001, 5.592361e-001, 5.592889e-001, 5.593416e-001, 5.593944e-001, 5.594471e-001, 5.594998e-001, 5.595525e-001, 5.596052e-001, 5.596579e-001, 5.597106e-001, 5.597633e-001, 5.598160e-001, 5.598686e-001, 5.599213e-001, 5.599739e-001, 5.600265e-001, 5.600791e-001, 5.601318e-001, 5.601844e-001, 5.602369e-001, 5.602895e-001, 5.603421e-001, 
5.603947e-001, 5.604472e-001, 5.604998e-001, 5.605523e-001, 5.606048e-001, 5.606574e-001, 5.607099e-001, 5.607624e-001, 5.608149e-001, 5.608673e-001, 5.609198e-001, 5.609723e-001, 5.610247e-001, 5.610772e-001, 5.611296e-001, 5.611820e-001, 5.612344e-001, 5.612869e-001, 5.613393e-001, 5.613916e-001, 5.614440e-001, 5.614964e-001, 5.615488e-001, 5.616011e-001, 5.616535e-001, 5.617058e-001, 5.617581e-001, 5.618104e-001, 5.618627e-001, 5.619150e-001, 5.619673e-001, 5.620196e-001, 5.620719e-001, 5.621241e-001, 5.621764e-001, 5.622286e-001, 5.622808e-001, 5.623331e-001, 5.623853e-001, 5.624375e-001, 5.624897e-001, 5.625419e-001, 5.625940e-001, 5.626462e-001, 5.626984e-001, 5.627505e-001, 5.628026e-001, 5.628548e-001, 5.629069e-001, 5.629590e-001, 5.630111e-001, 5.630632e-001, 5.631153e-001, 5.631674e-001, 5.632194e-001, 5.632715e-001, 5.633235e-001, 5.633755e-001, 5.634276e-001, 5.634796e-001, 5.635316e-001, 5.635836e-001, 5.636356e-001, 5.636876e-001, 5.637395e-001, 5.637915e-001, 5.638434e-001, 5.638954e-001, 5.639473e-001, 5.639992e-001, 5.640512e-001, 5.641031e-001, 5.641550e-001, 5.642068e-001, 5.642587e-001, 5.643106e-001, 5.643624e-001, 5.644143e-001, 5.644661e-001, 5.645180e-001, 5.645698e-001, 5.646216e-001, 5.646734e-001, 5.647252e-001, 5.647770e-001, 5.648287e-001, 5.648805e-001, 5.649322e-001, 5.649840e-001, 5.650357e-001, 5.650874e-001, 5.651392e-001, 5.651909e-001, 5.652426e-001, 5.652942e-001, 5.653459e-001, 5.653976e-001, 5.654492e-001, 5.655009e-001, 5.655525e-001, 
5.656042e-001, 5.656558e-001, 5.657074e-001, 5.657590e-001, 5.658106e-001, 5.658622e-001, 5.659137e-001, 5.659653e-001, 5.660169e-001, 5.660684e-001, 5.661199e-001, 5.661715e-001, 5.662230e-001, 5.662745e-001, 5.663260e-001, 5.663775e-001, 5.664289e-001, 5.664804e-001, 5.665319e-001, 5.665833e-001, 5.666348e-001, 5.666862e-001, 5.667376e-001, 5.667890e-001, 5.668404e-001, 5.668918e-001, 5.669432e-001, 5.669946e-001, 5.670459e-001, 5.670973e-001, 5.671486e-001, 5.672000e-001, 5.672513e-001, 5.673026e-001, 5.673539e-001, 5.674052e-001, 5.674565e-001, 5.675078e-001, 5.675590e-001, 5.676103e-001, 5.676615e-001, 5.677128e-001, 5.677640e-001, 5.678152e-001, 5.678664e-001, 5.679176e-001, 5.679688e-001, 5.680200e-001, 5.680712e-001, 5.681223e-001, 5.681735e-001, 5.682246e-001, 5.682758e-001, 5.683269e-001, 5.683780e-001, 5.684291e-001, 5.684802e-001, 5.685313e-001, 5.685823e-001, 5.686334e-001, 5.686845e-001, 5.687355e-001, 5.687865e-001, 5.688376e-001, 5.688886e-001, 5.689396e-001, 5.689906e-001, 5.690416e-001, 5.690925e-001, 5.691435e-001, 5.691945e-001, 5.692454e-001, 5.692964e-001, 5.693473e-001, 5.693982e-001, 5.694491e-001, 5.695000e-001, 5.695509e-001, 5.696018e-001, 5.696527e-001, 5.697035e-001, 5.697544e-001, 5.698052e-001, 5.698560e-001, 5.699069e-001, 5.699577e-001, 5.700085e-001, 5.700593e-001, 5.701100e-001, 5.701608e-001, 5.702116e-001, 5.702623e-001, 5.703131e-001, 5.703638e-001, 5.704145e-001, 5.704652e-001, 5.705159e-001, 5.705666e-001, 5.706173e-001, 5.706680e-001, 
5.707187e-001, 5.707693e-001, 5.708200e-001, 5.708706e-001, 5.709212e-001, 5.709718e-001, 5.710225e-001, 5.710730e-001, 5.711236e-001, 5.711742e-001, 5.712248e-001, 5.712753e-001, 5.713259e-001, 5.713764e-001, 5.714269e-001, 5.714775e-001, 5.715280e-001, 5.715785e-001, 5.716290e-001, 5.716794e-001, 5.717299e-001, 5.717804e-001, 5.718308e-001, 5.718812e-001, 5.719317e-001, 5.719821e-001, 5.720325e-001, 5.720829e-001, 5.721333e-001, 5.721837e-001, 5.722340e-001, 5.722844e-001, 5.723348e-001, 5.723851e-001, 5.724354e-001, 5.724857e-001, 5.725361e-001, 5.725864e-001, 5.726366e-001, 5.726869e-001, 5.727372e-001, 5.727875e-001, 5.728377e-001, 5.728879e-001, 5.729382e-001, 5.729884e-001, 5.730386e-001, 5.730888e-001, 5.731390e-001, 5.731892e-001, 5.732394e-001, 5.732895e-001, 5.733397e-001, 5.733898e-001, 5.734399e-001, 5.734901e-001, 5.735402e-001, 5.735903e-001, 5.736404e-001, 5.736904e-001, 5.737405e-001, 5.737906e-001, 5.738406e-001, 5.738907e-001, 5.739407e-001, 5.739907e-001, 5.740407e-001, 5.740907e-001, 5.741407e-001, 5.741907e-001, 5.742407e-001, 5.742906e-001, 5.743406e-001, 5.743905e-001, 5.744405e-001, 5.744904e-001, 5.745403e-001, 5.745902e-001, 5.746401e-001, 5.746900e-001, 5.747399e-001, 5.747897e-001, 5.748396e-001, 5.748894e-001, 5.749392e-001, 5.749891e-001, 5.750389e-001, 5.750887e-001, 5.751385e-001, 5.751882e-001, 5.752380e-001, 5.752878e-001, 5.753375e-001, 5.753873e-001, 5.754370e-001, 5.754867e-001, 5.755364e-001, 5.755861e-001, 5.756358e-001, 5.756855e-001, 
5.757352e-001, 5.757848e-001, 5.758345e-001, 5.758841e-001, 5.759337e-001, 5.759834e-001, 5.760330e-001, 5.760826e-001, 5.761322e-001, 5.761817e-001, 5.762313e-001, 5.762809e-001, 5.763304e-001, 5.763800e-001, 5.764295e-001, 5.764790e-001, 5.765285e-001, 5.765780e-001, 5.766275e-001, 5.766770e-001, 5.767264e-001, 5.767759e-001, 5.768253e-001, 5.768748e-001, 5.769242e-001, 5.769736e-001, 5.770230e-001, 5.770724e-001, 5.771218e-001, 5.771712e-001, 5.772206e-001, 5.772699e-001, 5.773193e-001, 5.773686e-001, 5.774179e-001, 5.774672e-001, 5.775165e-001, 5.775658e-001, 5.776151e-001, 5.776644e-001, 5.777137e-001, 5.777629e-001, 5.778122e-001, 5.778614e-001, 5.779106e-001, 5.779598e-001, 5.780090e-001, 5.780582e-001, 5.781074e-001, 5.781566e-001, 5.782057e-001, 5.782549e-001, 5.783040e-001, 5.783532e-001, 5.784023e-001, 5.784514e-001, 5.785005e-001, 5.785496e-001, 5.785987e-001, 5.786477e-001, 5.786968e-001, 5.787458e-001, 5.787949e-001, 5.788439e-001, 5.788929e-001, 5.789419e-001, 5.789909e-001, 5.790399e-001, 5.790889e-001, 5.791378e-001, 5.791868e-001, 5.792357e-001, 5.792847e-001, 5.793336e-001, 5.793825e-001, 5.794314e-001, 5.794803e-001, 5.795292e-001, 5.795781e-001, 5.796269e-001, 5.796758e-001, 5.797246e-001, 5.797735e-001, 5.798223e-001, 5.798711e-001, 5.799199e-001, 5.799687e-001, 5.800175e-001, 5.800662e-001, 5.801150e-001, 5.801637e-001, 5.802125e-001, 5.802612e-001, 5.803099e-001, 5.803586e-001, 5.804073e-001, 5.804560e-001, 5.805047e-001, 5.805534e-001, 5.806020e-001, 
5.806507e-001, 5.806993e-001, 5.807479e-001, 5.807965e-001, 5.808451e-001, 5.808937e-001, 5.809423e-001, 5.809909e-001, 5.810395e-001, 5.810880e-001, 5.811365e-001, 5.811851e-001, 5.812336e-001, 5.812821e-001, 5.813306e-001, 5.813791e-001, 5.814276e-001, 5.814760e-001, 5.815245e-001, 5.815729e-001, 5.816214e-001, 5.816698e-001, 5.817182e-001, 5.817666e-001, 5.818150e-001, 5.818634e-001, 5.819118e-001, 5.819601e-001, 5.820085e-001, 5.820568e-001, 5.821052e-001, 5.821535e-001, 5.822018e-001, 5.822501e-001, 5.822984e-001, 5.823467e-001, 5.823949e-001, 5.824432e-001, 5.824915e-001, 5.825397e-001, 5.825879e-001, 5.826361e-001, 5.826843e-001, 5.827325e-001, 5.827807e-001, 5.828289e-001, 5.828771e-001, 5.829252e-001, 5.829734e-001, 5.830215e-001, 5.830696e-001, 5.831177e-001, 5.831658e-001, 5.832139e-001, 5.832620e-001, 5.833101e-001, 5.833581e-001, 5.834062e-001, 5.834542e-001, 5.835022e-001, 5.835502e-001, 5.835982e-001, 5.836462e-001, 5.836942e-001, 5.837422e-001, 5.837902e-001, 5.838381e-001, 5.838861e-001, 5.839340e-001, 5.839819e-001, 5.840298e-001, 5.840777e-001, 5.841256e-001, 5.841735e-001, 5.842213e-001, 5.842692e-001, 5.843171e-001, 5.843649e-001, 5.844127e-001, 5.844605e-001, 5.845083e-001, 5.845561e-001, 5.846039e-001, 5.846517e-001, 5.846994e-001, 5.847472e-001, 5.847949e-001, 5.848427e-001, 5.848904e-001, 5.849381e-001, 5.849858e-001, 5.850335e-001, 5.850811e-001, 5.851288e-001, 5.851765e-001, 5.852241e-001, 5.852717e-001, 5.853194e-001, 5.853670e-001, 5.854146e-001, 
5.854622e-001, 5.855097e-001, 5.855573e-001, 5.856049e-001, 5.856524e-001, 5.857000e-001, 5.857475e-001, 5.857950e-001, 5.858425e-001, 5.858900e-001, 5.859375e-001, 5.859850e-001, 5.860324e-001, 5.860799e-001, 5.861273e-001, 5.861747e-001, 5.862222e-001, 5.862696e-001, 5.863170e-001, 5.863643e-001, 5.864117e-001, 5.864591e-001, 5.865064e-001, 5.865538e-001, 5.866011e-001, 5.866484e-001, 5.866958e-001, 5.867431e-001, 5.867903e-001, 5.868376e-001, 5.868849e-001, 5.869321e-001, 5.869794e-001, 5.870266e-001, 5.870739e-001, 5.871211e-001, 5.871683e-001, 5.872155e-001, 5.872626e-001, 5.873098e-001, 5.873570e-001, 5.874041e-001, 5.874513e-001, 5.874984e-001, 5.875455e-001, 5.875926e-001, 5.876397e-001, 5.876868e-001, 5.877339e-001, 5.877809e-001, 5.878280e-001, 5.878750e-001, 5.879220e-001, 5.879691e-001, 5.880161e-001, 5.880631e-001, 5.881101e-001, 5.881570e-001, 5.882040e-001, 5.882510e-001, 5.882979e-001, 5.883448e-001, 5.883918e-001, 5.884387e-001, 5.884856e-001, 5.885325e-001, 5.885793e-001, 5.886262e-001, 5.886731e-001, 5.887199e-001, 5.887667e-001, 5.888136e-001, 5.888604e-001, 5.889072e-001, 5.889540e-001, 5.890007e-001, 5.890475e-001, 5.890943e-001, 5.891410e-001, 5.891877e-001, 5.892345e-001, 5.892812e-001, 5.893279e-001, 5.893746e-001, 5.894213e-001, 5.894679e-001, 5.895146e-001, 5.895612e-001, 5.896079e-001, 5.896545e-001, 5.897011e-001, 5.897477e-001, 5.897943e-001, 5.898409e-001, 5.898875e-001, 5.899340e-001, 5.899806e-001, 5.900271e-001, 5.900736e-001, 5.901202e-001, 
5.901667e-001, 5.902132e-001, 5.902596e-001, 5.903061e-001, 5.903526e-001, 5.903990e-001, 5.904455e-001, 5.904919e-001, 5.905383e-001, 5.905847e-001, 5.906311e-001, 5.906775e-001, 5.907239e-001, 5.907702e-001, 5.908166e-001, 5.908629e-001, 5.909093e-001, 5.909556e-001, 5.910019e-001, 5.910482e-001, 5.910945e-001, 5.911407e-001, 5.911870e-001, 5.912333e-001, 5.912795e-001, 5.913257e-001, 5.913719e-001, 5.914181e-001, 5.914643e-001, 5.915105e-001, 5.915567e-001, 5.916029e-001, 5.916490e-001, 5.916952e-001, 5.917413e-001, 5.917874e-001, 5.918335e-001, 5.918796e-001, 5.919257e-001, 5.919718e-001, 5.920178e-001, 5.920639e-001, 5.921099e-001, 5.921560e-001, 5.922020e-001, 5.922480e-001, 5.922940e-001, 5.923400e-001, 5.923859e-001, 5.924319e-001, 5.924779e-001, 5.925238e-001, 5.925697e-001, 5.926156e-001, 5.926615e-001, 5.927074e-001, 5.927533e-001, 5.927992e-001, 5.928451e-001, 5.928909e-001, 5.929368e-001, 5.929826e-001, 5.930284e-001, 5.930742e-001, 5.931200e-001, 5.931658e-001, 5.932116e-001, 5.932573e-001, 5.933031e-001, 5.933488e-001, 5.933945e-001, 5.934403e-001, 5.934860e-001, 5.935317e-001, 5.935773e-001, 5.936230e-001, 5.936687e-001, 5.937143e-001, 5.937600e-001, 5.938056e-001, 5.938512e-001, 5.938968e-001, 5.939424e-001, 5.939880e-001, 5.940336e-001, 5.940791e-001, 5.941247e-001, 5.941702e-001, 5.942157e-001, 5.942612e-001, 5.943068e-001, 5.943522e-001, 5.943977e-001, 5.944432e-001, 5.944887e-001, 5.945341e-001, 5.945795e-001, 5.946250e-001, 5.946704e-001, 5.947158e-001, 
5.947612e-001, 5.948065e-001, 5.948519e-001, 5.948973e-001, 5.949426e-001, 5.949880e-001, 5.950333e-001, 5.950786e-001, 5.951239e-001, 5.951692e-001, 5.952145e-001, 5.952597e-001, 5.953050e-001, 5.953502e-001, 5.953954e-001, 5.954407e-001, 5.954859e-001, 5.955311e-001, 5.955763e-001, 5.956214e-001, 5.956666e-001, 5.957118e-001, 5.957569e-001, 5.958020e-001, 5.958471e-001, 5.958923e-001, 5.959373e-001, 5.959824e-001, 5.960275e-001, 5.960726e-001, 5.961176e-001, 5.961627e-001, 5.962077e-001, 5.962527e-001, 5.962977e-001, 5.963427e-001, 5.963877e-001, 5.964327e-001, 5.964776e-001, 5.965226e-001, 5.965675e-001, 5.966124e-001, 5.966573e-001, 5.967022e-001, 5.967471e-001, 5.967920e-001, 5.968369e-001, 5.968817e-001, 5.969266e-001, 5.969714e-001, 5.970162e-001, 5.970610e-001, 5.971058e-001, 5.971506e-001, 5.971954e-001, 5.972402e-001, 5.972849e-001, 5.973297e-001, 5.973744e-001, 5.974191e-001, 5.974638e-001, 5.975085e-001, 5.975532e-001, 5.975979e-001, 5.976425e-001, 5.976872e-001, 5.977318e-001, 5.977764e-001, 5.978211e-001, 5.978657e-001, 5.979103e-001, 5.979548e-001, 5.979994e-001, 5.980440e-001, 5.980885e-001, 5.981330e-001, 5.981776e-001, 5.982221e-001, 5.982666e-001, 5.983111e-001, 5.983556e-001, 5.984000e-001, 5.984445e-001, 5.984889e-001, 5.985333e-001, 5.985778e-001, 5.986222e-001, 5.986666e-001, 5.987110e-001, 5.987553e-001, 5.987997e-001, 5.988440e-001, 5.988884e-001, 5.989327e-001, 5.989770e-001, 5.990213e-001, 5.990656e-001, 5.991099e-001, 5.991542e-001, 5.991984e-001, 
5.992427e-001, 5.992869e-001, 5.993311e-001, 5.993753e-001, 5.994195e-001, 5.994637e-001, 5.995079e-001, 5.995521e-001, 5.995962e-001, 5.996404e-001, 5.996845e-001, 5.997286e-001, 5.997727e-001, 5.998168e-001, 5.998609e-001, 5.999050e-001, 5.999490e-001, 5.999931e-001, 6.000371e-001, 6.000811e-001, 6.001251e-001, 6.001691e-001, 6.002131e-001, 6.002571e-001, 6.003011e-001, 6.003450e-001, 6.003890e-001, 6.004329e-001, 6.004768e-001, 6.005207e-001, 6.005646e-001, 6.006085e-001, 6.006524e-001, 6.006963e-001, 6.007401e-001, 6.007839e-001, 6.008278e-001, 6.008716e-001, 6.009154e-001, 6.009592e-001, 6.010030e-001, 6.010467e-001, 6.010905e-001, 6.011342e-001, 6.011780e-001, 6.012217e-001, 6.012654e-001, 6.013091e-001, 6.013528e-001, 6.013964e-001, 6.014401e-001, 6.014838e-001, 6.015274e-001, 6.015710e-001, 6.016146e-001, 6.016582e-001, 6.017018e-001, 6.017454e-001, 6.017890e-001, 6.018325e-001, 6.018761e-001, 6.019196e-001, 6.019631e-001, 6.020066e-001, 6.020501e-001, 6.020936e-001, 6.021371e-001, 6.021806e-001, 6.022240e-001, 6.022674e-001, 6.023109e-001, 6.023543e-001, 6.023977e-001, 6.024411e-001, 6.024845e-001, 6.025278e-001, 6.025712e-001, 6.026145e-001, 6.026579e-001, 6.027012e-001, 6.027445e-001, 6.027878e-001, 6.028311e-001, 6.028743e-001, 6.029176e-001, 6.029609e-001, 6.030041e-001, 6.030473e-001, 6.030905e-001, 6.031337e-001, 6.031769e-001, 6.032201e-001, 6.032633e-001, 6.033064e-001, 6.033496e-001, 6.033927e-001, 6.034358e-001, 6.034789e-001, 6.035220e-001, 6.035651e-001, 
6.036082e-001, 6.036512e-001, 6.036943e-001, 6.037373e-001, 6.037803e-001, 6.038233e-001, 6.038663e-001, 6.039093e-001, 6.039523e-001, 6.039953e-001, 6.040382e-001, 6.040812e-001, 6.041241e-001, 6.041670e-001, 6.042099e-001, 6.042528e-001, 6.042957e-001, 6.043385e-001, 6.043814e-001, 6.044243e-001, 6.044671e-001, 6.045099e-001, 6.045527e-001, 6.045955e-001, 6.046383e-001, 6.046811e-001, 6.047238e-001, 6.047666e-001, 6.048093e-001, 6.048520e-001, 6.048947e-001, 6.049374e-001, 6.049801e-001, 6.050228e-001, 6.050655e-001, 6.051081e-001, 6.051508e-001, 6.051934e-001, 6.052360e-001, 6.052786e-001, 6.053212e-001, 6.053638e-001, 6.054064e-001, 6.054489e-001, 6.054915e-001, 6.055340e-001, 6.055765e-001, 6.056190e-001, 6.056615e-001, 6.057040e-001, 6.057465e-001, 6.057889e-001, 6.058314e-001, 6.058738e-001, 6.059162e-001, 6.059587e-001, 6.060011e-001, 6.060434e-001, 6.060858e-001, 6.061282e-001, 6.061705e-001, 6.062129e-001, 6.062552e-001, 6.062975e-001, 6.063398e-001, 6.063821e-001, 6.064244e-001, 6.064667e-001, 6.065089e-001, 6.065512e-001, 6.065934e-001, 6.066356e-001, 6.066778e-001, 6.067200e-001, 6.067622e-001, 6.068044e-001, 6.068465e-001, 6.068887e-001, 6.069308e-001, 6.069729e-001, 6.070150e-001, 6.070571e-001, 6.070992e-001, 6.071413e-001, 6.071833e-001, 6.072254e-001, 6.072674e-001, 6.073095e-001, 6.073515e-001, 6.073935e-001, 6.074355e-001, 6.074774e-001, 6.075194e-001, 6.075613e-001, 6.076033e-001, 6.076452e-001, 6.076871e-001, 6.077290e-001, 6.077709e-001, 6.078128e-001, 
6.078547e-001, 6.078965e-001, 6.079384e-001, 6.079802e-001, 6.080220e-001, 6.080638e-001, 6.081056e-001, 6.081474e-001, 6.081892e-001, 6.082309e-001, 6.082727e-001, 6.083144e-001, 6.083561e-001, 6.083978e-001, 6.084395e-001, 6.084812e-001, 6.085229e-001, 6.085645e-001, 6.086062e-001, 6.086478e-001, 6.086894e-001, 6.087310e-001, 6.087726e-001, 6.088142e-001, 6.088558e-001, 6.088973e-001, 6.089389e-001, 6.089804e-001, 6.090220e-001, 6.090635e-001, 6.091050e-001, 6.091464e-001, 6.091879e-001, 6.092294e-001, 6.092708e-001, 6.093123e-001, 6.093537e-001, 6.093951e-001, 6.094365e-001, 6.094779e-001, 6.095193e-001, 6.095606e-001, 6.096020e-001, 6.096433e-001, 6.096847e-001, 6.097260e-001, 6.097673e-001, 6.098086e-001, 6.098498e-001, 6.098911e-001, 6.099324e-001, 6.099736e-001, 6.100148e-001, 6.100560e-001, 6.100972e-001, 6.101384e-001, 6.101796e-001, 6.102208e-001, 6.102619e-001, 6.103031e-001, 6.103442e-001, 6.103853e-001, 6.104264e-001, 6.104675e-001, 6.105086e-001, 6.105497e-001, 6.105907e-001, 6.106318e-001, 6.106728e-001, 6.107138e-001, 6.107548e-001, 6.107958e-001, 6.108368e-001, 6.108777e-001, 6.109187e-001, 6.109596e-001, 6.110006e-001, 6.110415e-001, 6.110824e-001, 6.111233e-001, 6.111642e-001, 6.112050e-001, 6.112459e-001, 6.112867e-001, 6.113276e-001, 6.113684e-001, 6.114092e-001, 6.114500e-001, 6.114908e-001, 6.115315e-001, 6.115723e-001, 6.116130e-001, 6.116538e-001, 6.116945e-001, 6.117352e-001, 6.117759e-001, 6.118166e-001, 6.118572e-001, 6.118979e-001, 6.119385e-001, 
6.119792e-001, 6.120198e-001, 6.120604e-001, 6.121010e-001, 6.121416e-001, 6.121821e-001, 6.122227e-001, 6.122632e-001, 6.123038e-001, 6.123443e-001, 6.123848e-001, 6.124253e-001, 6.124658e-001, 6.125062e-001, 6.125467e-001, 6.125871e-001, 6.126276e-001, 6.126680e-001, 6.127084e-001, 6.127488e-001, 6.127892e-001, 6.128295e-001, 6.128699e-001, 6.129102e-001, 6.129506e-001, 6.129909e-001, 6.130312e-001, 6.130715e-001, 6.131118e-001, 6.131520e-001, 6.131923e-001, 6.132325e-001, 6.132728e-001, 6.133130e-001, 6.133532e-001, 6.133934e-001, 6.134335e-001, 6.134737e-001, 6.135139e-001, 6.135540e-001, 6.135941e-001, 6.136343e-001, 6.136744e-001, 6.137144e-001, 6.137545e-001, 6.137946e-001, 6.138346e-001, 6.138747e-001, 6.139147e-001, 6.139547e-001, 6.139947e-001, 6.140347e-001, 6.140747e-001, 6.141147e-001, 6.141546e-001, 6.141946e-001, 6.142345e-001, 6.142744e-001, 6.143143e-001, 6.143542e-001, 6.143941e-001, 6.144339e-001, 6.144738e-001, 6.145136e-001, 6.145534e-001, 6.145932e-001, 6.146330e-001, 6.146728e-001, 6.147126e-001, 6.147524e-001, 6.147921e-001, 6.148319e-001, 6.148716e-001, 6.149113e-001, 6.149510e-001, 6.149907e-001, 6.150303e-001, 6.150700e-001, 6.151097e-001, 6.151493e-001, 6.151889e-001, 6.152285e-001, 6.152681e-001, 6.153077e-001, 6.153473e-001, 6.153868e-001, 6.154264e-001, 6.154659e-001, 6.155054e-001, 6.155449e-001, 6.155844e-001, 6.156239e-001, 6.156634e-001, 6.157028e-001, 6.157423e-001, 6.157817e-001, 6.158211e-001, 6.158605e-001, 6.158999e-001, 6.159393e-001, 
6.159787e-001, 6.160180e-001, 6.160574e-001, 6.160967e-001, 6.161360e-001, 6.161753e-001, 6.162146e-001, 6.162539e-001, 6.162931e-001, 6.163324e-001, 6.163716e-001, 6.164109e-001, 6.164501e-001, 6.164893e-001, 6.165285e-001, 6.165676e-001, 6.166068e-001, 6.166459e-001, 6.166851e-001, 6.167242e-001, 6.167633e-001, 6.168024e-001, 6.168415e-001, 6.168806e-001, 6.169196e-001, 6.169587e-001, 6.169977e-001, 6.170367e-001, 6.170757e-001, 6.171147e-001, 6.171537e-001, 6.171927e-001, 6.172316e-001, 6.172706e-001, 6.173095e-001, 6.173484e-001, 6.173873e-001, 6.174262e-001, 6.174651e-001, 6.175039e-001, 6.175428e-001, 6.175816e-001, 6.176205e-001, 6.176593e-001, 6.176981e-001, 6.177369e-001, 6.177756e-001, 6.178144e-001, 6.178531e-001, 6.178919e-001, 6.179306e-001, 6.179693e-001, 6.180080e-001, 6.180467e-001, 6.180854e-001, 6.181240e-001, 6.181627e-001, 6.182013e-001, 6.182399e-001, 6.182785e-001, 6.183171e-001, 6.183557e-001, 6.183943e-001, 6.184328e-001, 6.184714e-001, 6.185099e-001, 6.185484e-001, 6.185869e-001, 6.186254e-001, 6.186639e-001, 6.187023e-001, 6.187408e-001, 6.187792e-001, 6.188176e-001, 6.188561e-001, 6.188945e-001, 6.189328e-001, 6.189712e-001, 6.190096e-001, 6.190479e-001, 6.190863e-001, 6.191246e-001, 6.191629e-001, 6.192012e-001, 6.192395e-001, 6.192777e-001, 6.193160e-001, 6.193542e-001, 6.193924e-001, 6.194307e-001, 6.194689e-001, 6.195071e-001, 6.195452e-001, 6.195834e-001, 6.196215e-001, 6.196597e-001, 6.196978e-001, 6.197359e-001, 6.197740e-001, 6.198121e-001, 
6.198502e-001, 6.198882e-001, 6.199263e-001, 6.199643e-001, 6.200023e-001, 6.200403e-001, 6.200783e-001, 6.201163e-001, 6.201543e-001, 6.201922e-001, 6.202302e-001, 6.202681e-001, 6.203060e-001, 6.203439e-001, 6.203818e-001, 6.204197e-001, 6.204575e-001, 6.204954e-001, 6.205332e-001, 6.205710e-001, 6.206088e-001, 6.206466e-001, 6.206844e-001, 6.207222e-001, 6.207599e-001, 6.207977e-001, 6.208354e-001, 6.208731e-001, 6.209108e-001, 6.209485e-001, 6.209862e-001, 6.210239e-001, 6.210615e-001, 6.210992e-001, 6.211368e-001, 6.211744e-001, 6.212120e-001, 6.212496e-001, 6.212872e-001, 6.213247e-001, 6.213623e-001, 6.213998e-001, 6.214373e-001, 6.214748e-001, 6.215123e-001, 6.215498e-001, 6.215872e-001, 6.216247e-001, 6.216621e-001, 6.216996e-001, 6.217370e-001, 6.217744e-001, 6.218118e-001, 6.218491e-001, 6.218865e-001, 6.219238e-001, 6.219612e-001, 6.219985e-001, 6.220358e-001, 6.220731e-001, 6.221104e-001, 6.221476e-001, 6.221849e-001, 6.222221e-001, 6.222594e-001, 6.222966e-001, 6.223338e-001, 6.223710e-001, 6.224081e-001, 6.224453e-001, 6.224825e-001, 6.225196e-001, 6.225567e-001, 6.225938e-001, 6.226309e-001, 6.226680e-001, 6.227051e-001, 6.227421e-001, 6.227791e-001, 6.228162e-001, 6.228532e-001, 6.228902e-001, 6.229272e-001, 6.229642e-001, 6.230011e-001, 6.230381e-001, 6.230750e-001, 6.231119e-001, 6.231488e-001, 6.231857e-001, 6.232226e-001, 6.232595e-001, 6.232963e-001, 6.233332e-001, 6.233700e-001, 6.234068e-001, 6.234436e-001, 6.234804e-001, 6.235172e-001, 6.235539e-001, 
6.235907e-001, 6.236274e-001, 6.236641e-001, 6.237008e-001, 6.237375e-001, 6.237742e-001, 6.238109e-001, 6.238475e-001, 6.238842e-001, 6.239208e-001, 6.239574e-001, 6.239940e-001, 6.240306e-001, 6.240672e-001, 6.241037e-001, 6.241403e-001, 6.241768e-001, 6.242133e-001, 6.242498e-001, 6.242863e-001, 6.243228e-001, 6.243592e-001, 6.243957e-001, 6.244321e-001, 6.244686e-001, 6.245050e-001, 6.245414e-001, 6.245778e-001, 6.246141e-001, 6.246505e-001, 6.246868e-001, 6.247232e-001, 6.247595e-001, 6.247958e-001, 6.248321e-001, 6.248683e-001, 6.249046e-001, 6.249408e-001, 6.249771e-001, 6.250133e-001, 6.250495e-001, 6.250857e-001, 6.251219e-001, 6.251581e-001, 6.251942e-001, 6.252304e-001, 6.252665e-001, 6.253026e-001, 6.253387e-001, 6.253748e-001, 6.254109e-001, 6.254469e-001, 6.254830e-001, 6.255190e-001, 6.255550e-001, 6.255910e-001, 6.256270e-001, 6.256630e-001, 6.256990e-001, 6.257349e-001, 6.257708e-001, 6.258068e-001, 6.258427e-001, 6.258786e-001, 6.259145e-001, 6.259503e-001, 6.259862e-001, 6.260220e-001, 6.260578e-001, 6.260937e-001, 6.261295e-001, 6.261653e-001, 6.262010e-001, 6.262368e-001, 6.262725e-001, 6.263083e-001, 6.263440e-001, 6.263797e-001, 6.264154e-001, 6.264511e-001, 6.264867e-001, 6.265224e-001, 6.265580e-001, 6.265936e-001, 6.266293e-001, 6.266649e-001, 6.267004e-001, 6.267360e-001, 6.267716e-001, 6.268071e-001, 6.268426e-001, 6.268781e-001, 6.269136e-001, 6.269491e-001, 6.269846e-001, 6.270201e-001, 6.270555e-001, 6.270910e-001, 6.271264e-001, 6.271618e-001, 
6.271972e-001, 6.272325e-001, 6.272679e-001, 6.273033e-001, 6.273386e-001, 6.273739e-001, 6.274092e-001, 6.274445e-001, 6.274798e-001, 6.275151e-001, 6.275503e-001, 6.275856e-001, 6.276208e-001, 6.276560e-001, 6.276912e-001, 6.277264e-001, 6.277616e-001, 6.277967e-001, 6.278319e-001, 6.278670e-001, 6.279021e-001, 6.279372e-001, 6.279723e-001, 6.280074e-001, 6.280425e-001, 6.280775e-001, 6.281125e-001, 6.281476e-001, 6.281826e-001, 6.282176e-001, 6.282525e-001, 6.282875e-001, 6.283225e-001, 6.283574e-001, 6.283923e-001, 6.284272e-001, 6.284621e-001, 6.284970e-001, 6.285319e-001, 6.285667e-001, 6.286016e-001, 6.286364e-001, 6.286712e-001, 6.287060e-001, 6.287408e-001, 6.287756e-001, 6.288103e-001, 6.288451e-001, 6.288798e-001, 6.289145e-001, 6.289492e-001, 6.289839e-001, 6.290186e-001, 6.290533e-001, 6.290879e-001, 6.291225e-001, 6.291572e-001, 6.291918e-001, 6.292264e-001, 6.292609e-001, 6.292955e-001, 6.293300e-001, 6.293646e-001, 6.293991e-001, 6.294336e-001, 6.294681e-001, 6.295026e-001, 6.295371e-001, 6.295715e-001, 6.296060e-001, 6.296404e-001, 6.296748e-001, 6.297092e-001, 6.297436e-001, 6.297779e-001, 6.298123e-001, 6.298466e-001, 6.298810e-001, 6.299153e-001, 6.299496e-001, 6.299839e-001, 6.300181e-001, 6.300524e-001, 6.300866e-001, 6.301209e-001, 6.301551e-001, 6.301893e-001, 6.302235e-001, 6.302577e-001, 6.302918e-001, 6.303260e-001, 6.303601e-001, 6.303942e-001, 6.304283e-001, 6.304624e-001, 6.304965e-001, 6.305306e-001, 6.305646e-001, 6.305986e-001, 6.306327e-001, 
6.306667e-001, 6.307007e-001, 6.307346e-001, 6.307686e-001, 6.308026e-001, 6.308365e-001, 6.308704e-001, 6.309043e-001, 6.309382e-001, 6.309721e-001, 6.310060e-001, 6.310398e-001, 6.310737e-001, 6.311075e-001, 6.311413e-001, 6.311751e-001, 6.312089e-001, 6.312426e-001, 6.312764e-001, 6.313101e-001, 6.313439e-001, 6.313776e-001, 6.314113e-001, 6.314450e-001, 6.314786e-001, 6.315123e-001, 6.315459e-001, 6.315796e-001, 6.316132e-001, 6.316468e-001, 6.316804e-001, 6.317139e-001, 6.317475e-001, 6.317810e-001, 6.318146e-001, 6.318481e-001, 6.318816e-001, 6.319151e-001, 6.319485e-001, 6.319820e-001, 6.320154e-001, 6.320489e-001, 6.320823e-001, 6.321157e-001, 6.321491e-001, 6.321824e-001, 6.322158e-001, 6.322492e-001, 6.322825e-001, 6.323158e-001, 6.323491e-001, 6.323824e-001, 6.324157e-001, 6.324489e-001, 6.324822e-001, 6.325154e-001, 6.325486e-001, 6.325818e-001, 6.326150e-001, 6.326482e-001, 6.326814e-001, 6.327145e-001, 6.327476e-001, 6.327808e-001, 6.328139e-001, 6.328470e-001, 6.328800e-001, 6.329131e-001, 6.329461e-001, 6.329792e-001, 6.330122e-001, 6.330452e-001, 6.330782e-001, 6.331112e-001, 6.331441e-001, 6.331771e-001, 6.332100e-001, 6.332429e-001, 6.332758e-001, 6.333087e-001, 6.333416e-001, 6.333745e-001, 6.334073e-001, 6.334402e-001, 6.334730e-001, 6.335058e-001, 6.335386e-001, 6.335714e-001, 6.336041e-001, 6.336369e-001, 6.336696e-001, 6.337023e-001, 6.337350e-001, 6.337677e-001, 6.338004e-001, 6.338331e-001, 6.338657e-001, 6.338983e-001, 6.339310e-001, 6.339636e-001, 
6.339962e-001, 6.340287e-001, 6.340613e-001, 6.340939e-001, 6.341264e-001, 6.341589e-001, 6.341914e-001, 6.342239e-001, 6.342564e-001, 6.342889e-001, 6.343213e-001, 6.343537e-001, 6.343862e-001, 6.344186e-001, 6.344510e-001, 6.344833e-001, 6.345157e-001, 6.345480e-001, 6.345804e-001, 6.346127e-001, 6.346450e-001, 6.346773e-001, 6.347096e-001, 6.347418e-001, 6.347741e-001, 6.348063e-001, 6.348385e-001, 6.348707e-001, 6.349029e-001, 6.349351e-001, 6.349673e-001, 6.349994e-001, 6.350315e-001, 6.350637e-001, 6.350958e-001, 6.351279e-001, 6.351599e-001, 6.351920e-001, 6.352240e-001, 6.352561e-001, 6.352881e-001, 6.353201e-001, 6.353521e-001, 6.353841e-001, 6.354160e-001, 6.354480e-001, 6.354799e-001, 6.355118e-001, 6.355437e-001, 6.355756e-001, 6.356075e-001, 6.356393e-001, 6.356712e-001, 6.357030e-001, 6.357348e-001, 6.357666e-001, 6.357984e-001, 6.358302e-001, 6.358619e-001, 6.358937e-001, 6.359254e-001, 6.359571e-001, 6.359888e-001, 6.360205e-001, 6.360522e-001, 6.360838e-001, 6.361155e-001, 6.361471e-001, 6.361787e-001, 6.362103e-001, 6.362419e-001, 6.362735e-001, 6.363050e-001, 6.363366e-001, 6.363681e-001, 6.363996e-001, 6.364311e-001, 6.364626e-001, 6.364941e-001, 6.365255e-001, 6.365570e-001, 6.365884e-001, 6.366198e-001, 6.366512e-001, 6.366826e-001, 6.367139e-001, 6.367453e-001, 6.367766e-001, 6.368079e-001, 6.368392e-001, 6.368705e-001, 6.369018e-001, 6.369331e-001, 6.369643e-001, 6.369956e-001, 6.370268e-001, 6.370580e-001, 6.370892e-001, 6.371204e-001, 6.371515e-001, 
6.371827e-001, 6.372138e-001, 6.372449e-001, 6.372760e-001, 6.373071e-001, 6.373382e-001, 6.373692e-001, 6.374003e-001, 6.374313e-001, 6.374623e-001, 6.374933e-001, 6.375243e-001, 6.375553e-001, 6.375863e-001, 6.376172e-001, 6.376481e-001, 6.376790e-001, 6.377099e-001, 6.377408e-001, 6.377717e-001, 6.378025e-001, 6.378334e-001, 6.378642e-001, 6.378950e-001, 6.379258e-001, 6.379566e-001, 6.379874e-001, 6.380181e-001, 6.380489e-001, 6.380796e-001, 6.381103e-001, 6.381410e-001, 6.381717e-001, 6.382023e-001, 6.382330e-001, 6.382636e-001, 6.382942e-001, 6.383248e-001, 6.383554e-001, 6.383860e-001, 6.384166e-001, 6.384471e-001, 6.384776e-001, 6.385081e-001, 6.385387e-001, 6.385691e-001, 6.385996e-001, 6.386301e-001, 6.386605e-001, 6.386909e-001, 6.387214e-001, 6.387518e-001, 6.387821e-001, 6.388125e-001, 6.388429e-001, 6.388732e-001, 6.389035e-001, 6.389338e-001, 6.389641e-001, 6.389944e-001, 6.390247e-001, 6.390549e-001, 6.390852e-001, 6.391154e-001, 6.391456e-001, 6.391758e-001, 6.392060e-001, 6.392361e-001, 6.392663e-001, 6.392964e-001, 6.393265e-001, 6.393566e-001, 6.393867e-001, 6.394168e-001, 6.394468e-001, 6.394769e-001, 6.395069e-001, 6.395369e-001, 6.395669e-001, 6.395969e-001, 6.396269e-001, 6.396568e-001, 6.396868e-001, 6.397167e-001, 6.397466e-001, 6.397765e-001, 6.398064e-001, 6.398363e-001, 6.398661e-001, 6.398960e-001, 6.399258e-001, 6.399556e-001, 6.399854e-001, 6.400151e-001, 6.400449e-001, 6.400747e-001, 6.401044e-001, 6.401341e-001, 6.401638e-001, 6.401935e-001, 
6.402232e-001, 6.402528e-001, 6.402825e-001, 6.403121e-001, 6.403417e-001, 6.403713e-001, 6.404009e-001, 6.404305e-001, 6.404600e-001, 6.404895e-001, 6.405191e-001, 6.405486e-001, 6.405781e-001, 6.406076e-001, 6.406370e-001, 6.406665e-001, 6.406959e-001, 6.407253e-001, 6.407547e-001, 6.407841e-001, 6.408135e-001, 6.408428e-001, 6.408722e-001, 6.409015e-001, 6.409308e-001, 6.409601e-001, 6.409894e-001, 6.410187e-001, 6.410479e-001, 6.410772e-001, 6.411064e-001, 6.411356e-001, 6.411648e-001, 6.411940e-001, 6.412231e-001, 6.412523e-001, 6.412814e-001, 6.413105e-001, 6.413397e-001, 6.413687e-001, 6.413978e-001, 6.414269e-001, 6.414559e-001, 6.414849e-001, 6.415140e-001, 6.415430e-001, 6.415719e-001, 6.416009e-001, 6.416299e-001, 6.416588e-001, 6.416877e-001, 6.417166e-001, 6.417455e-001, 6.417744e-001, 6.418033e-001, 6.418321e-001, 6.418610e-001, 6.418898e-001, 6.419186e-001, 6.419474e-001, 6.419761e-001, 6.420049e-001, 6.420336e-001, 6.420624e-001, 6.420911e-001, 6.421198e-001, 6.421485e-001, 6.421771e-001, 6.422058e-001, 6.422344e-001, 6.422630e-001, 6.422916e-001, 6.423202e-001, 6.423488e-001, 6.423774e-001, 6.424059e-001, 6.424345e-001, 6.424630e-001, 6.424915e-001, 6.425200e-001, 6.425484e-001, 6.425769e-001, 6.426053e-001, 6.426338e-001, 6.426622e-001, 6.426906e-001, 6.427189e-001, 6.427473e-001, 6.427757e-001, 6.428040e-001, 6.428323e-001, 6.428606e-001, 6.428889e-001, 6.429172e-001, 6.429454e-001, 6.429737e-001, 6.430019e-001, 6.430301e-001, 6.430583e-001, 6.430865e-001, 
6.431147e-001, 6.431428e-001, 6.431710e-001, 6.431991e-001, 6.432272e-001, 6.432553e-001, 6.432834e-001, 6.433114e-001, 6.433395e-001, 6.433675e-001, 6.433955e-001, 6.434235e-001, 6.434515e-001, 6.434795e-001, 6.435074e-001, 6.435354e-001, 6.435633e-001, 6.435912e-001, 6.436191e-001, 6.436470e-001, 6.436748e-001, 6.437027e-001, 6.437305e-001, 6.437583e-001, 6.437861e-001, 6.438139e-001, 6.438417e-001, 6.438694e-001, 6.438972e-001, 6.439249e-001, 6.439526e-001, 6.439803e-001, 6.440080e-001, 6.440357e-001, 6.440633e-001, 6.440909e-001, 6.441186e-001, 6.441462e-001, 6.441737e-001, 6.442013e-001, 6.442289e-001, 6.442564e-001, 6.442839e-001, 6.443115e-001, 6.443390e-001, 6.443664e-001, 6.443939e-001, 6.444213e-001, 6.444488e-001, 6.444762e-001, 6.445036e-001, 6.445310e-001, 6.445584e-001, 6.445857e-001, 6.446131e-001, 6.446404e-001, 6.446677e-001, 6.446950e-001, 6.447223e-001, 6.447495e-001, 6.447768e-001, 6.448040e-001, 6.448313e-001, 6.448585e-001, 6.448856e-001, 6.449128e-001, 6.449400e-001, 6.449671e-001, 6.449942e-001, 6.450214e-001, 6.450485e-001, 6.450755e-001, 6.451026e-001, 6.451297e-001, 6.451567e-001, 6.451837e-001, 6.452107e-001, 6.452377e-001, 6.452647e-001, 6.452916e-001, 6.453186e-001, 6.453455e-001, 6.453724e-001, 6.453993e-001, 6.454262e-001, 6.454530e-001, 6.454799e-001, 6.455067e-001, 6.455336e-001, 6.455604e-001, 6.455871e-001, 6.456139e-001, 6.456407e-001, 6.456674e-001, 6.456941e-001, 6.457208e-001, 6.457475e-001, 6.457742e-001, 6.458009e-001, 6.458275e-001, 
6.458542e-001, 6.458808e-001, 6.459074e-001, 6.459340e-001, 6.459605e-001, 6.459871e-001, 6.460136e-001, 6.460402e-001, 6.460667e-001, 6.460932e-001, 6.461196e-001, 6.461461e-001, 6.461725e-001, 6.461990e-001, 6.462254e-001, 6.462518e-001, 6.462782e-001, 6.463045e-001, 6.463309e-001, 6.463572e-001, 6.463836e-001, 6.464099e-001, 6.464362e-001, 6.464624e-001, 6.464887e-001, 6.465149e-001, 6.465412e-001, 6.465674e-001, 6.465936e-001, 6.466198e-001, 6.466459e-001, 6.466721e-001, 6.466982e-001, 6.467243e-001, 6.467504e-001, 6.467765e-001, 6.468026e-001, 6.468287e-001, 6.468547e-001, 6.468807e-001, 6.469067e-001, 6.469327e-001, 6.469587e-001, 6.469847e-001, 6.470106e-001, 6.470366e-001, 6.470625e-001, 6.470884e-001, 6.471143e-001, 6.471401e-001, 6.471660e-001, 6.471918e-001, 6.472176e-001, 6.472434e-001, 6.472692e-001, 6.472950e-001, 6.473208e-001, 6.473465e-001, 6.473722e-001, 6.473980e-001, 6.474237e-001, 6.474493e-001, 6.474750e-001, 6.475007e-001, 6.475263e-001, 6.475519e-001, 6.475775e-001, 6.476031e-001, 6.476287e-001, 6.476542e-001, 6.476798e-001, 6.477053e-001, 6.477308e-001, 6.477563e-001, 6.477818e-001, 6.478072e-001, 6.478327e-001, 6.478581e-001, 6.478835e-001, 6.479089e-001, 6.479343e-001, 6.479597e-001, 6.479850e-001, 6.480104e-001, 6.480357e-001, 6.480610e-001, 6.480863e-001, 6.481116e-001, 6.481368e-001, 6.481621e-001, 6.481873e-001, 6.482125e-001, 6.482377e-001, 6.482629e-001, 6.482880e-001, 6.483132e-001, 6.483383e-001, 6.483634e-001, 6.483885e-001, 6.484136e-001, 
6.484387e-001, 6.484637e-001, 6.484888e-001, 6.485138e-001, 6.485388e-001, 6.485638e-001, 6.485887e-001, 6.486137e-001, 6.486386e-001, 6.486636e-001, 6.486885e-001, 6.487134e-001, 6.487382e-001, 6.487631e-001, 6.487880e-001, 6.488128e-001, 6.488376e-001, 6.488624e-001, 6.488872e-001, 6.489120e-001, 6.489367e-001, 6.489614e-001, 6.489862e-001, 6.490109e-001, 6.490355e-001, 6.490602e-001, 6.490849e-001, 6.491095e-001, 6.491341e-001, 6.491588e-001, 6.491833e-001, 6.492079e-001, 6.492325e-001, 6.492570e-001, 6.492816e-001, 6.493061e-001, 6.493306e-001, 6.493550e-001, 6.493795e-001, 6.494040e-001, 6.494284e-001, 6.494528e-001, 6.494772e-001, 6.495016e-001, 6.495260e-001, 6.495503e-001, 6.495747e-001, 6.495990e-001, 6.496233e-001, 6.496476e-001, 6.496719e-001, 6.496961e-001, 6.497204e-001, 6.497446e-001, 6.497688e-001, 6.497930e-001, 6.498172e-001, 6.498413e-001, 6.498655e-001, 6.498896e-001, 6.499137e-001, 6.499378e-001, 6.499619e-001, 6.499860e-001, 6.500100e-001, 6.500341e-001, 6.500581e-001, 6.500821e-001, 6.501061e-001, 6.501300e-001, 6.501540e-001, 6.501779e-001, 6.502018e-001, 6.502258e-001, 6.502496e-001, 6.502735e-001, 6.502974e-001, 6.503212e-001, 6.503450e-001, 6.503689e-001, 6.503927e-001, 6.504164e-001, 6.504402e-001, 6.504639e-001, 6.504877e-001, 6.505114e-001, 6.505351e-001, 6.505588e-001, 6.505824e-001, 6.506061e-001, 6.506297e-001, 6.506533e-001, 6.506769e-001, 6.507005e-001, 6.507241e-001, 6.507476e-001, 6.507712e-001, 6.507947e-001, 6.508182e-001, 6.508417e-001, 
6.508652e-001, 6.508886e-001, 6.509121e-001, 6.509355e-001, 6.509589e-001, 6.509823e-001, 6.510057e-001, 6.510290e-001, 6.510524e-001, 6.510757e-001, 6.510990e-001, 6.511223e-001, 6.511456e-001, 6.511689e-001, 6.511921e-001, 6.512153e-001, 6.512385e-001, 6.512617e-001, 6.512849e-001, 6.513081e-001, 6.513312e-001, 6.513544e-001, 6.513775e-001, 6.514006e-001, 6.514237e-001, 6.514468e-001, 6.514698e-001, 6.514928e-001, 6.515159e-001, 6.515389e-001, 6.515619e-001, 6.515848e-001, 6.516078e-001, 6.516307e-001, 6.516537e-001, 6.516766e-001, 6.516995e-001, 6.517223e-001, 6.517452e-001, 6.517680e-001, 6.517909e-001, 6.518137e-001, 6.518365e-001, 6.518592e-001, 6.518820e-001, 6.519047e-001, 6.519275e-001, 6.519502e-001, 6.519729e-001, 6.519956e-001, 6.520182e-001, 6.520409e-001, 6.520635e-001, 6.520861e-001, 6.521087e-001, 6.521313e-001, 6.521539e-001, 6.521764e-001, 6.521990e-001, 6.522215e-001, 6.522440e-001, 6.522665e-001, 6.522889e-001, 6.523114e-001, 6.523338e-001, 6.523562e-001, 6.523786e-001, 6.524010e-001, 6.524234e-001, 6.524458e-001, 6.524681e-001, 6.524904e-001, 6.525127e-001, 6.525350e-001, 6.525573e-001, 6.525795e-001, 6.526018e-001, 6.526240e-001, 6.526462e-001, 6.526684e-001, 6.526906e-001, 6.527127e-001, 6.527349e-001, 6.527570e-001, 6.527791e-001, 6.528012e-001, 6.528233e-001, 6.528454e-001, 6.528674e-001, 6.528894e-001, 6.529114e-001, 6.529334e-001, 6.529554e-001, 6.529774e-001, 6.529993e-001, 6.530213e-001, 6.530432e-001, 6.530651e-001, 6.530870e-001, 6.531088e-001, 
6.531307e-001, 6.531525e-001, 6.531743e-001, 6.531961e-001, 6.532179e-001, 6.532397e-001, 6.532614e-001, 6.532831e-001, 6.533049e-001, 6.533266e-001, 6.533482e-001, 6.533699e-001, 6.533916e-001, 6.534132e-001, 6.534348e-001, 6.534564e-001, 6.534780e-001, 6.534996e-001, 6.535211e-001, 6.535427e-001, 6.535642e-001, 6.535857e-001, 6.536072e-001, 6.536286e-001, 6.536501e-001, 6.536715e-001, 6.536930e-001, 6.537144e-001, 6.537357e-001, 6.537571e-001, 6.537785e-001, 6.537998e-001, 6.538211e-001, 6.538424e-001, 6.538637e-001, 6.538850e-001, 6.539063e-001, 6.539275e-001, 6.539487e-001, 6.539699e-001, 6.539911e-001, 6.540123e-001, 6.540334e-001, 6.540546e-001, 6.540757e-001, 6.540968e-001, 6.541179e-001, 6.541390e-001, 6.541600e-001, 6.541811e-001, 6.542021e-001, 6.542231e-001, 6.542441e-001, 6.542651e-001, 6.542860e-001, 6.543070e-001, 6.543279e-001, 6.543488e-001, 6.543697e-001, 6.543906e-001, 6.544114e-001, 6.544323e-001, 6.544531e-001, 6.544739e-001, 6.544947e-001, 6.545155e-001, 6.545362e-001, 6.545570e-001, 6.545777e-001, 6.545984e-001, 6.546191e-001, 6.546398e-001, 6.546605e-001, 6.546811e-001, 6.547017e-001, 6.547223e-001, 6.547429e-001, 6.547635e-001, 6.547841e-001, 6.548046e-001, 6.548251e-001, 6.548456e-001, 6.548661e-001, 6.548866e-001, 6.549071e-001, 6.549275e-001, 6.549479e-001, 6.549684e-001, 6.549887e-001, 6.550091e-001, 6.550295e-001, 6.550498e-001, 6.550702e-001, 6.550905e-001, 6.551108e-001, 6.551310e-001, 6.551513e-001, 6.551715e-001, 6.551918e-001, 6.552120e-001, 
6.552322e-001, 6.552523e-001, 6.552725e-001, 6.552926e-001, 6.553128e-001, 6.553329e-001, 6.553530e-001, 6.553731e-001, 6.553931e-001, 6.554132e-001, 6.554332e-001, 6.554532e-001, 6.554732e-001, 6.554932e-001, 6.555131e-001, 6.555331e-001, 6.555530e-001, 6.555729e-001, 6.555928e-001, 6.556127e-001, 6.556325e-001, 6.556524e-001, 6.556722e-001, 6.556920e-001, 6.557118e-001, 6.557316e-001, 6.557513e-001, 6.557711e-001, 6.557908e-001, 6.558105e-001, 6.558302e-001, 6.558499e-001, 6.558695e-001, 6.558892e-001, 6.559088e-001, 6.559284e-001, 6.559480e-001, 6.559676e-001, 6.559871e-001, 6.560067e-001, 6.560262e-001, 6.560457e-001, 6.560652e-001, 6.560846e-001, 6.561041e-001, 6.561235e-001, 6.561430e-001, 6.561624e-001, 6.561818e-001, 6.562011e-001, 6.562205e-001, 6.562398e-001, 6.562591e-001, 6.562784e-001, 6.562977e-001, 6.563170e-001, 6.563363e-001, 6.563555e-001, 6.563747e-001, 6.563939e-001, 6.564131e-001, 6.564323e-001, 6.564514e-001, 6.564706e-001, 6.564897e-001, 6.565088e-001, 6.565279e-001, 6.565469e-001, 6.565660e-001, 6.565850e-001, 6.566040e-001, 6.566230e-001, 6.566420e-001, 6.566610e-001, 6.566799e-001, 6.566989e-001, 6.567178e-001, 6.567367e-001, 6.567556e-001, 6.567744e-001, 6.567933e-001, 6.568121e-001, 6.568309e-001, 6.568497e-001, 6.568685e-001, 6.568873e-001, 6.569060e-001, 6.569247e-001, 6.569434e-001, 6.569621e-001, 6.569808e-001, 6.569995e-001, 6.570181e-001, 6.570368e-001, 6.570554e-001, 6.570740e-001, 6.570925e-001, 6.571111e-001, 6.571296e-001, 6.571482e-001, 
6.571667e-001, 6.571852e-001, 6.572036e-001, 6.572221e-001, 6.572405e-001, 6.572590e-001, 6.572774e-001, 6.572957e-001, 6.573141e-001, 6.573325e-001, 6.573508e-001, 6.573691e-001, 6.573874e-001, 6.574057e-001, 6.574240e-001, 6.574423e-001, 6.574605e-001, 6.574787e-001, 6.574969e-001, 6.575151e-001, 6.575333e-001, 6.575514e-001, 6.575695e-001, 6.575877e-001, 6.576058e-001, 6.576238e-001, 6.576419e-001, 6.576600e-001, 6.576780e-001, 6.576960e-001, 6.577140e-001, 6.577320e-001, 6.577499e-001, 6.577679e-001, 6.577858e-001, 6.578037e-001, 6.578216e-001, 6.578395e-001, 6.578574e-001, 6.578752e-001, 6.578930e-001, 6.579108e-001, 6.579286e-001, 6.579464e-001, 6.579642e-001, 6.579819e-001, 6.579996e-001, 6.580173e-001, 6.580350e-001, 6.580527e-001, 6.580704e-001, 6.580880e-001, 6.581056e-001, 6.581232e-001, 6.581408e-001, 6.581584e-001, 6.581759e-001, 6.581935e-001, 6.582110e-001, 6.582285e-001, 6.582460e-001, 6.582634e-001, 6.582809e-001, 6.582983e-001, 6.583157e-001, 6.583331e-001, 6.583505e-001, 6.583679e-001, 6.583852e-001, 6.584025e-001, 6.584198e-001, 6.584371e-001, 6.584544e-001, 6.584717e-001, 6.584889e-001, 6.585061e-001, 6.585234e-001, 6.585405e-001, 6.585577e-001, 6.585749e-001, 6.585920e-001, 6.586091e-001, 6.586262e-001, 6.586433e-001, 6.586604e-001, 6.586774e-001, 6.586945e-001, 6.587115e-001, 6.587285e-001, 6.587455e-001, 6.587625e-001, 6.587794e-001, 6.587963e-001, 6.588132e-001, 6.588301e-001, 6.588470e-001, 6.588639e-001, 6.588807e-001, 6.588976e-001, 6.589144e-001, 
6.589312e-001, 6.589479e-001, 6.589647e-001, 6.589814e-001, 6.589982e-001, 6.590149e-001, 6.590316e-001, 6.590482e-001, 6.590649e-001, 6.590815e-001, 6.590982e-001, 6.591148e-001, 6.591313e-001, 6.591479e-001, 6.591645e-001, 6.591810e-001, 6.591975e-001, 6.592140e-001, 6.592305e-001, 6.592470e-001, 6.592634e-001, 6.592798e-001, 6.592962e-001, 6.593126e-001, 6.593290e-001, 6.593454e-001, 6.593617e-001, 6.593780e-001, 6.593944e-001, 6.594106e-001, 6.594269e-001, 6.594432e-001, 6.594594e-001, 6.594756e-001, 6.594918e-001, 6.595080e-001, 6.595242e-001, 6.595403e-001, 6.595565e-001, 6.595726e-001, 6.595887e-001, 6.596048e-001, 6.596208e-001, 6.596369e-001, 6.596529e-001, 6.596689e-001, 6.596849e-001, 6.597009e-001, 6.597169e-001, 6.597328e-001, 6.597487e-001, 6.597646e-001, 6.597805e-001, 6.597964e-001, 6.598123e-001, 6.598281e-001, 6.598439e-001, 6.598597e-001, 6.598755e-001, 6.598913e-001, 6.599070e-001, 6.599228e-001, 6.599385e-001, 6.599542e-001, 6.599698e-001, 6.599855e-001, 6.600012e-001, 6.600168e-001, 6.600324e-001, 6.600480e-001, 6.600636e-001, 6.600791e-001, 6.600947e-001, 6.601102e-001, 6.601257e-001, 6.601412e-001, 6.601566e-001, 6.601721e-001, 6.601875e-001, 6.602030e-001, 6.602184e-001, 6.602337e-001, 6.602491e-001, 6.602644e-001, 6.602798e-001, 6.602951e-001, 6.603104e-001, 6.603257e-001, 6.603409e-001, 6.603562e-001, 6.603714e-001, 6.603866e-001, 6.604018e-001, 6.604170e-001, 6.604321e-001, 6.604472e-001, 6.604624e-001, 6.604775e-001, 6.604926e-001, 6.605076e-001, 
6.605227e-001, 6.605377e-001, 6.605527e-001, 6.605677e-001, 6.605827e-001, 6.605976e-001, 6.606126e-001, 6.606275e-001, 6.606424e-001, 6.606573e-001, 6.606722e-001, 6.606870e-001, 6.607019e-001, 6.607167e-001, 6.607315e-001, 6.607463e-001, 6.607611e-001, 6.607758e-001, 6.607905e-001, 6.608052e-001, 6.608199e-001, 6.608346e-001, 6.608493e-001, 6.608639e-001, 6.608786e-001, 6.608932e-001, 6.609077e-001, 6.609223e-001, 6.609369e-001, 6.609514e-001, 6.609659e-001, 6.609804e-001, 6.609949e-001, 6.610094e-001, 6.610238e-001, 6.610383e-001, 6.610527e-001, 6.610671e-001, 6.610815e-001, 6.610958e-001, 6.611102e-001, 6.611245e-001, 6.611388e-001, 6.611531e-001, 6.611673e-001, 6.611816e-001, 6.611958e-001, 6.612101e-001, 6.612243e-001, 6.612384e-001, 6.612526e-001, 6.612668e-001, 6.612809e-001, 6.612950e-001, 6.613091e-001, 6.613232e-001, 6.613372e-001, 6.613513e-001, 6.613653e-001, 6.613793e-001, 6.613933e-001, 6.614072e-001, 6.614212e-001, 6.614351e-001, 6.614491e-001, 6.614629e-001, 6.614768e-001, 6.614907e-001, 6.615045e-001, 6.615184e-001, 6.615322e-001, 6.615460e-001, 6.615597e-001, 6.615735e-001, 6.615872e-001, 6.616010e-001, 6.616147e-001, 6.616283e-001, 6.616420e-001, 6.616557e-001, 6.616693e-001, 6.616829e-001, 6.616965e-001, 6.617101e-001, 6.617236e-001, 6.617372e-001, 6.617507e-001, 6.617642e-001, 6.617777e-001, 6.617912e-001, 6.618046e-001, 6.618181e-001, 6.618315e-001, 6.618449e-001, 6.618583e-001, 6.618716e-001, 6.618850e-001, 6.618983e-001, 6.619116e-001, 6.619249e-001, 
6.619382e-001, 6.619514e-001, 6.619647e-001, 6.619779e-001, 6.619911e-001, 6.620043e-001, 6.620174e-001, 6.620306e-001, 6.620437e-001, 6.620568e-001, 6.620699e-001, 6.620830e-001, 6.620961e-001, 6.621091e-001, 6.621221e-001, 6.621351e-001, 6.621481e-001, 6.621611e-001, 6.621740e-001, 6.621870e-001, 6.621999e-001, 6.622128e-001, 6.622257e-001, 6.622385e-001, 6.622514e-001, 6.622642e-001, 6.622770e-001, 6.622898e-001, 6.623026e-001, 6.623153e-001, 6.623280e-001, 6.623408e-001, 6.623535e-001, 6.623661e-001, 6.623788e-001, 6.623915e-001, 6.624041e-001, 6.624167e-001, 6.624293e-001, 6.624419e-001, 6.624544e-001, 6.624670e-001, 6.624795e-001, 6.624920e-001, 6.625045e-001, 6.625169e-001, 6.625294e-001, 6.625418e-001, 6.625542e-001, 6.625666e-001, 6.625790e-001, 6.625913e-001, 6.626037e-001, 6.626160e-001, 6.626283e-001, 6.626406e-001, 6.626529e-001, 6.626651e-001, 6.626773e-001, 6.626895e-001, 6.627017e-001, 6.627139e-001, 6.627261e-001, 6.627382e-001, 6.627503e-001, 6.627624e-001, 6.627745e-001, 6.627866e-001, 6.627986e-001, 6.628107e-001, 6.628227e-001, 6.628347e-001, 6.628467e-001, 6.628586e-001, 6.628706e-001, 6.628825e-001, 6.628944e-001, 6.629063e-001, 6.629181e-001, 6.629300e-001, 6.629418e-001, 6.629536e-001, 6.629654e-001, 6.629772e-001, 6.629890e-001, 6.630007e-001, 6.630124e-001, 6.630241e-001, 6.630358e-001, 6.630475e-001, 6.630592e-001, 6.630708e-001, 6.630824e-001, 6.630940e-001, 6.631056e-001, 6.631171e-001, 6.631287e-001, 6.631402e-001, 6.631517e-001, 6.631632e-001, 
6.631747e-001, 6.631861e-001, 6.631976e-001, 6.632090e-001, 6.632204e-001, 6.632317e-001, 6.632431e-001, 6.632544e-001, 6.632658e-001, 6.632771e-001, 6.632884e-001, 6.632996e-001, 6.633109e-001, 6.633221e-001, 6.633333e-001, 6.633445e-001, 6.633557e-001, 6.633669e-001, 6.633780e-001, 6.633891e-001, 6.634002e-001, 6.634113e-001, 6.634224e-001, 6.634334e-001, 6.634445e-001, 6.634555e-001, 6.634665e-001, 6.634774e-001, 6.634884e-001, 6.634993e-001, 6.635103e-001, 6.635212e-001, 6.635321e-001, 6.635429e-001, 6.635538e-001, 6.635646e-001, 6.635754e-001, 6.635862e-001, 6.635970e-001, 6.636077e-001, 6.636185e-001, 6.636292e-001, 6.636399e-001, 6.636506e-001, 6.636612e-001, 6.636719e-001, 6.636825e-001, 6.636931e-001, 6.637037e-001, 6.637143e-001, 6.637249e-001, 6.637354e-001, 6.637459e-001, 6.637564e-001, 6.637669e-001, 6.637774e-001, 6.637878e-001, 6.637982e-001, 6.638086e-001, 6.638190e-001, 6.638294e-001, 6.638398e-001, 6.638501e-001, 6.638604e-001, 6.638707e-001, 6.638810e-001, 6.638912e-001, 6.639015e-001, 6.639117e-001, 6.639219e-001, 6.639321e-001, 6.639423e-001, 6.639524e-001, 6.639626e-001, 6.639727e-001, 6.639828e-001, 6.639928e-001, 6.640029e-001, 6.640129e-001, 6.640230e-001, 6.640330e-001, 6.640430e-001, 6.640529e-001, 6.640629e-001, 6.640728e-001, 6.640827e-001, 6.640926e-001, 6.641025e-001, 6.641123e-001, 6.641222e-001, 6.641320e-001, 6.641418e-001, 6.641516e-001, 6.641613e-001, 6.641711e-001, 6.641808e-001, 6.641905e-001, 6.642002e-001, 6.642099e-001, 6.642195e-001, 
6.642292e-001, 6.642388e-001, 6.642484e-001, 6.642580e-001, 6.642675e-001, 6.642771e-001, 6.642866e-001, 6.642961e-001, 6.643056e-001, 6.643150e-001, 6.643245e-001, 6.643339e-001, 6.643433e-001, 6.643527e-001, 6.643621e-001, 6.643715e-001, 6.643808e-001, 6.643901e-001, 6.643994e-001, 6.644087e-001, 6.644180e-001, 6.644272e-001, 6.644364e-001, 6.644456e-001, 6.644548e-001, 6.644640e-001, 6.644732e-001, 6.644823e-001, 6.644914e-001, 6.645005e-001, 6.645096e-001, 6.645186e-001, 6.645277e-001, 6.645367e-001, 6.645457e-001, 6.645547e-001, 6.645637e-001, 6.645726e-001, 6.645815e-001, 6.645904e-001, 6.645993e-001, 6.646082e-001, 6.646171e-001, 6.646259e-001, 6.646347e-001, 6.646435e-001, 6.646523e-001, 6.646611e-001, 6.646698e-001, 6.646785e-001, 6.646872e-001, 6.646959e-001, 6.647046e-001, 6.647132e-001, 6.647219e-001, 6.647305e-001, 6.647391e-001, 6.647476e-001, 6.647562e-001, 6.647647e-001, 6.647733e-001, 6.647818e-001, 6.647902e-001, 6.647987e-001, 6.648071e-001, 6.648156e-001, 6.648240e-001, 6.648324e-001, 6.648407e-001, 6.648491e-001, 6.648574e-001, 6.648657e-001, 6.648740e-001, 6.648823e-001, 6.648906e-001, 6.648988e-001, 6.649070e-001, 6.649152e-001, 6.649234e-001, 6.649316e-001, 6.649397e-001, 6.649478e-001, 6.649559e-001, 6.649640e-001, 6.649721e-001, 6.649802e-001, 6.649882e-001, 6.649962e-001, 6.650042e-001, 6.650122e-001, 6.650201e-001, 6.650281e-001, 6.650360e-001, 6.650439e-001, 6.650518e-001, 6.650596e-001, 6.650675e-001, 6.650753e-001, 6.650831e-001, 6.650909e-001, 
6.650987e-001, 6.651064e-001, 6.651141e-001, 6.651219e-001, 6.651296e-001, 6.651372e-001, 6.651449e-001, 6.651525e-001, 6.651601e-001, 6.651677e-001, 6.651753e-001, 6.651829e-001, 6.651904e-001, 6.651980e-001, 6.652055e-001, 6.652129e-001, 6.652204e-001, 6.652279e-001, 6.652353e-001, 6.652427e-001, 6.652501e-001, 6.652575e-001, 6.652648e-001, 6.652722e-001, 6.652795e-001, 6.652868e-001, 6.652941e-001, 6.653013e-001, 6.653086e-001, 6.653158e-001, 6.653230e-001, 6.653302e-001, 6.653373e-001, 6.653445e-001, 6.653516e-001, 6.653587e-001, 6.653658e-001, 6.653729e-001, 6.653799e-001, 6.653870e-001, 6.653940e-001, 6.654010e-001, 6.654080e-001, 6.654149e-001, 6.654219e-001, 6.654288e-001, 6.654357e-001, 6.654426e-001, 6.654494e-001, 6.654563e-001, 6.654631e-001, 6.654699e-001, 6.654767e-001, 6.654835e-001, 6.654902e-001, 6.654969e-001, 6.655037e-001, 6.655104e-001, 6.655170e-001, 6.655237e-001, 6.655303e-001, 6.655369e-001, 6.655435e-001, 6.655501e-001, 6.655567e-001, 6.655632e-001, 6.655697e-001, 6.655762e-001, 6.655827e-001, 6.655892e-001, 6.655956e-001, 6.656021e-001, 6.656085e-001, 6.656149e-001, 6.656212e-001, 6.656276e-001, 6.656339e-001, 6.656402e-001, 6.656465e-001, 6.656528e-001, 6.656591e-001, 6.656653e-001, 6.656715e-001, 6.656777e-001, 6.656839e-001, 6.656900e-001, 6.656962e-001, 6.657023e-001, 6.657084e-001, 6.657145e-001, 6.657206e-001, 6.657266e-001, 6.657326e-001, 6.657386e-001, 6.657446e-001, 6.657506e-001, 6.657566e-001, 6.657625e-001, 6.657684e-001, 6.657743e-001, 
6.657802e-001, 6.657860e-001, 6.657919e-001, 6.657977e-001, 6.658035e-001, 6.658093e-001, 6.658150e-001, 6.658208e-001, 6.658265e-001, 6.658322e-001, 6.658379e-001, 6.658435e-001, 6.658492e-001, 6.658548e-001, 6.658604e-001, 6.658660e-001, 6.658716e-001, 6.658771e-001, 6.658826e-001, 6.658882e-001, 6.658936e-001, 6.658991e-001, 6.659046e-001, 6.659100e-001, 6.659154e-001, 6.659208e-001, 6.659262e-001, 6.659315e-001, 6.659369e-001, 6.659422e-001, 6.659475e-001, 6.659528e-001, 6.659581e-001, 6.659633e-001, 6.659685e-001, 6.659737e-001, 6.659789e-001, 6.659841e-001, 6.659892e-001, 6.659943e-001, 6.659995e-001, 6.660045e-001, 6.660096e-001, 6.660147e-001, 6.660197e-001, 6.660247e-001, 6.660297e-001, 6.660347e-001, 6.660396e-001, 6.660446e-001, 6.660495e-001, 6.660544e-001, 6.660593e-001, 6.660641e-001, 6.660690e-001, 6.660738e-001, 6.660786e-001, 6.660834e-001, 6.660881e-001, 6.660929e-001, 6.660976e-001, 6.661023e-001, 6.661070e-001, 6.661116e-001, 6.661163e-001, 6.661209e-001, 6.661255e-001, 6.661301e-001, 6.661347e-001, 6.661392e-001, 6.661438e-001, 6.661483e-001, 6.661528e-001, 6.661572e-001, 6.661617e-001, 6.661661e-001, 6.661705e-001, 6.661749e-001, 6.661793e-001, 6.661837e-001, 6.661880e-001, 6.661923e-001, 6.661966e-001, 6.662009e-001, 6.662051e-001, 6.662094e-001, 6.662136e-001, 6.662178e-001, 6.662220e-001, 6.662262e-001, 6.662303e-001, 6.662344e-001, 6.662385e-001, 6.662426e-001, 6.662467e-001, 6.662507e-001, 6.662548e-001, 6.662588e-001, 6.662627e-001, 6.662667e-001, 
6.662707e-001, 6.662746e-001, 6.662785e-001, 6.662824e-001, 6.662863e-001, 6.662901e-001, 6.662940e-001, 6.662978e-001, 6.663016e-001, 6.663053e-001, 6.663091e-001, 6.663128e-001, 6.663165e-001, 6.663202e-001, 6.663239e-001, 6.663276e-001, 6.663312e-001, 6.663348e-001, 6.663384e-001, 6.663420e-001, 6.663456e-001, 6.663491e-001, 6.663526e-001, 6.663561e-001, 6.663596e-001, 6.663631e-001, 6.663665e-001, 6.663700e-001, 6.663734e-001, 6.663768e-001, 6.663801e-001, 6.663835e-001, 6.663868e-001, 6.663901e-001, 6.663934e-001, 6.663967e-001, 6.663999e-001, 6.664031e-001, 6.664064e-001, 6.664095e-001, 6.664127e-001, 6.664159e-001, 6.664190e-001, 6.664221e-001, 6.664252e-001, 6.664283e-001, 6.664313e-001, 6.664344e-001, 6.664374e-001, 6.664404e-001, 6.664434e-001, 6.664463e-001, 6.664492e-001, 6.664522e-001, 6.664551e-001, 6.664579e-001, 6.664608e-001, 6.664636e-001, 6.664665e-001, 6.664693e-001, 6.664720e-001, 6.664748e-001, 6.664775e-001, 6.664803e-001, 6.664830e-001, 6.664856e-001, 6.664883e-001, 6.664910e-001, 6.664936e-001, 6.664962e-001, 6.664988e-001, 6.665013e-001, 6.665039e-001, 6.665064e-001, 6.665089e-001, 6.665114e-001, 6.665139e-001, 6.665163e-001, 6.665187e-001, 6.665211e-001, 6.665235e-001, 6.665259e-001, 6.665282e-001, 6.665306e-001, 6.665329e-001, 6.665352e-001, 6.665374e-001, 6.665397e-001, 6.665419e-001, 6.665441e-001, 6.665463e-001, 6.665485e-001, 6.665507e-001, 6.665528e-001, 6.665549e-001, 6.665570e-001, 6.665591e-001, 6.665611e-001, 6.665632e-001, 6.665652e-001, 
6.665672e-001, 6.665691e-001, 6.665711e-001, 6.665730e-001, 6.665749e-001, 6.665768e-001, 6.665787e-001, 6.665806e-001, 6.665824e-001, 6.665842e-001, 6.665860e-001, 6.665878e-001, 6.665896e-001, 6.665913e-001, 6.665930e-001, 6.665947e-001, 6.665964e-001, 6.665981e-001, 6.665997e-001, 6.666013e-001, 6.666029e-001, 6.666045e-001, 6.666061e-001, 6.666076e-001, 6.666091e-001, 6.666106e-001, 6.666121e-001, 6.666136e-001, 6.666150e-001, 6.666164e-001, 6.666178e-001, 6.666192e-001, 6.666206e-001, 6.666219e-001, 6.666233e-001, 6.666246e-001, 6.666258e-001, 6.666271e-001, 6.666283e-001, 6.666296e-001, 6.666308e-001, 6.666320e-001, 6.666331e-001, 6.666343e-001, 6.666354e-001, 6.666365e-001, 6.666376e-001, 6.666387e-001, 6.666397e-001, 6.666407e-001, 6.666417e-001, 6.666427e-001, 6.666437e-001, 6.666446e-001, 6.666456e-001, 6.666465e-001, 6.666473e-001, 6.666482e-001, 6.666491e-001, 6.666499e-001, 6.666507e-001, 6.666515e-001, 6.666523e-001, 6.666530e-001, 6.666537e-001, 6.666544e-001, 6.666551e-001, 6.666558e-001, 6.666564e-001, 6.666571e-001, 6.666577e-001, 6.666583e-001, 6.666588e-001, 6.666594e-001, 6.666599e-001, 6.666604e-001, 6.666609e-001, 6.666614e-001, 6.666618e-001, 6.666623e-001, 6.666627e-001, 6.666631e-001, 6.666634e-001, 6.666638e-001, 6.666641e-001, 6.666644e-001, 6.666647e-001, 6.666650e-001, 6.666652e-001, 6.666655e-001, 6.666657e-001, 6.666659e-001, 6.666660e-001, 6.666662e-001, 6.666663e-001, 6.666664e-001, 6.666665e-001, 6.666666e-001, 6.666666e-001, 6.666667e-001, 
6.666667e-001, 6.666667e-001
},
{
0.000000e+000, 1.666667e-013, 1.333333e-012, 4.500000e-012, 1.066667e-011, 2.083333e-011, 3.600000e-011, 5.716667e-011, 8.533333e-011, 1.215000e-010, 1.666667e-010, 2.218333e-010, 2.880000e-010, 3.661667e-010, 4.573333e-010, 5.625000e-010, 6.826667e-010, 8.188333e-010, 9.720000e-010, 1.143167e-009, 1.333333e-009, 1.543500e-009, 1.774667e-009, 2.027833e-009, 2.304000e-009, 2.604167e-009, 2.929333e-009, 3.280500e-009, 3.658667e-009, 4.064833e-009, 4.500000e-009, 4.965167e-009, 5.461333e-009, 5.989500e-009, 6.550667e-009, 7.145833e-009, 7.776000e-009, 8.442167e-009, 9.145333e-009, 9.886500e-009, 1.066667e-008, 1.148683e-008, 1.234800e-008, 1.325117e-008, 1.419733e-008, 1.518750e-008, 1.622267e-008, 1.730383e-008, 1.843200e-008, 1.960817e-008, 2.083333e-008, 2.210850e-008, 2.343467e-008, 2.481283e-008, 2.624400e-008, 2.772917e-008, 2.926933e-008, 3.086550e-008, 3.251867e-008, 3.422983e-008, 3.600000e-008, 3.783017e-008, 3.972133e-008, 4.167450e-008, 4.369067e-008, 4.577083e-008, 4.791600e-008, 5.012717e-008, 5.240533e-008, 5.475150e-008, 5.716667e-008, 5.965183e-008, 6.220800e-008, 6.483617e-008, 6.753733e-008, 7.031250e-008, 7.316267e-008, 7.608883e-008, 7.909200e-008, 8.217317e-008, 8.533333e-008, 8.857350e-008, 9.189467e-008, 9.529783e-008, 9.878400e-008, 1.023542e-007, 1.060093e-007, 1.097505e-007, 1.135787e-007, 1.174948e-007, 1.215000e-007, 1.255952e-007, 1.297813e-007, 1.340595e-007, 1.384307e-007, 1.428958e-007, 1.474560e-007, 1.521122e-007, 1.568653e-007, 1.617165e-007, 
1.666667e-007, 1.717168e-007, 1.768680e-007, 1.821212e-007, 1.874773e-007, 1.929375e-007, 1.985027e-007, 2.041738e-007, 2.099520e-007, 2.158382e-007, 2.218333e-007, 2.279385e-007, 2.341547e-007, 2.404828e-007, 2.469240e-007, 2.534792e-007, 2.601493e-007, 2.669355e-007, 2.738387e-007, 2.808598e-007, 2.880000e-007, 2.952602e-007, 3.026413e-007, 3.101445e-007, 3.177707e-007, 3.255208e-007, 3.333960e-007, 3.413972e-007, 3.495253e-007, 3.577815e-007, 3.661667e-007, 3.746818e-007, 3.833280e-007, 3.921062e-007, 4.010173e-007, 4.100625e-007, 4.192427e-007, 4.285588e-007, 4.380120e-007, 4.476032e-007, 4.573333e-007, 4.672035e-007, 4.772147e-007, 4.873678e-007, 4.976640e-007, 5.081042e-007, 5.186893e-007, 5.294205e-007, 5.402987e-007, 5.513248e-007, 5.625000e-007, 5.738252e-007, 5.853013e-007, 5.969295e-007, 6.087107e-007, 6.206458e-007, 6.327360e-007, 6.449822e-007, 6.573853e-007, 6.699465e-007, 6.826667e-007, 6.955468e-007, 7.085880e-007, 7.217912e-007, 7.351573e-007, 7.486875e-007, 7.623827e-007, 7.762438e-007, 7.902720e-007, 8.044682e-007, 8.188333e-007, 8.333685e-007, 8.480747e-007, 8.629528e-007, 8.780040e-007, 8.932292e-007, 9.086293e-007, 9.242055e-007, 9.399587e-007, 9.558898e-007, 9.720000e-007, 9.882902e-007, 1.004761e-006, 1.021415e-006, 1.038251e-006, 1.055271e-006, 1.072476e-006, 1.089867e-006, 1.107445e-006, 1.125212e-006, 1.143167e-006, 1.161312e-006, 1.179648e-006, 1.198176e-006, 1.216897e-006, 1.235812e-006, 1.254923e-006, 1.274229e-006, 1.293732e-006, 1.313433e-006, 
1.333333e-006, 1.353433e-006, 1.373735e-006, 1.394238e-006, 1.414944e-006, 1.435854e-006, 1.456969e-006, 1.478290e-006, 1.499819e-006, 1.521555e-006, 1.543500e-006, 1.565655e-006, 1.588021e-006, 1.610599e-006, 1.633391e-006, 1.656396e-006, 1.679616e-006, 1.703052e-006, 1.726705e-006, 1.750576e-006, 1.774667e-006, 1.798977e-006, 1.823508e-006, 1.848261e-006, 1.873237e-006, 1.898437e-006, 1.923863e-006, 1.949514e-006, 1.975392e-006, 2.001498e-006, 2.027833e-006, 2.054398e-006, 2.081195e-006, 2.108223e-006, 2.135484e-006, 2.162979e-006, 2.190709e-006, 2.218675e-006, 2.246879e-006, 2.275320e-006, 2.304000e-006, 2.332920e-006, 2.362081e-006, 2.391484e-006, 2.421131e-006, 2.451021e-006, 2.481156e-006, 2.511537e-006, 2.542165e-006, 2.573041e-006, 2.604167e-006, 2.635542e-006, 2.667168e-006, 2.699046e-006, 2.731177e-006, 2.763562e-006, 2.796203e-006, 2.829099e-006, 2.862252e-006, 2.895663e-006, 2.929333e-006, 2.963264e-006, 2.997455e-006, 3.031908e-006, 3.066624e-006, 3.101604e-006, 3.136849e-006, 3.172361e-006, 3.208139e-006, 3.244185e-006, 3.280500e-006, 3.317085e-006, 3.353941e-006, 3.391070e-006, 3.428471e-006, 3.466146e-006, 3.504096e-006, 3.542322e-006, 3.580825e-006, 3.619607e-006, 3.658667e-006, 3.698007e-006, 3.737628e-006, 3.777531e-006, 3.817717e-006, 3.858188e-006, 3.898943e-006, 3.939984e-006, 3.981312e-006, 4.022928e-006, 4.064833e-006, 4.107029e-006, 4.149515e-006, 4.192293e-006, 4.235364e-006, 4.278729e-006, 4.322389e-006, 4.366346e-006, 4.410599e-006, 4.455150e-006, 
4.500000e-006, 4.545150e-006, 4.590601e-006, 4.636354e-006, 4.682411e-006, 4.728771e-006, 4.775436e-006, 4.822407e-006, 4.869685e-006, 4.917272e-006, 4.965167e-006, 5.013372e-006, 5.061888e-006, 5.110716e-006, 5.159857e-006, 5.209313e-006, 5.259083e-006, 5.309169e-006, 5.359572e-006, 5.410293e-006, 5.461333e-006, 5.512693e-006, 5.564375e-006, 5.616378e-006, 5.668704e-006, 5.721354e-006, 5.774329e-006, 5.827631e-006, 5.881259e-006, 5.935215e-006, 5.989500e-006, 6.044115e-006, 6.099061e-006, 6.154340e-006, 6.209951e-006, 6.265896e-006, 6.322176e-006, 6.378792e-006, 6.435745e-006, 6.493036e-006, 6.550667e-006, 6.608637e-006, 6.666948e-006, 6.725601e-006, 6.784597e-006, 6.843938e-006, 6.903623e-006, 6.963654e-006, 7.024032e-006, 7.084758e-006, 7.145833e-006, 7.207259e-006, 7.269035e-006, 7.331163e-006, 7.393644e-006, 7.456479e-006, 7.519669e-006, 7.583216e-006, 7.647119e-006, 7.711380e-006, 7.776000e-006, 7.840980e-006, 7.906321e-006, 7.972024e-006, 8.038091e-006, 8.104521e-006, 8.171316e-006, 8.238477e-006, 8.306005e-006, 8.373902e-006, 8.442167e-006, 8.510802e-006, 8.579808e-006, 8.649186e-006, 8.718937e-006, 8.789062e-006, 8.859563e-006, 8.930439e-006, 9.001692e-006, 9.073323e-006, 9.145333e-006, 9.217724e-006, 9.290495e-006, 9.363648e-006, 9.437184e-006, 9.511104e-006, 9.585409e-006, 9.660100e-006, 9.735179e-006, 9.810645e-006, 9.886500e-006, 9.962745e-006, 1.003938e-005, 1.011641e-005, 1.019383e-005, 1.027165e-005, 1.034986e-005, 1.042846e-005, 1.050747e-005, 1.058687e-005, 
1.066667e-005, 1.074687e-005, 1.082747e-005, 1.090847e-005, 1.098988e-005, 1.107169e-005, 1.115390e-005, 1.123652e-005, 1.131955e-005, 1.140299e-005, 1.148683e-005, 1.157109e-005, 1.165575e-005, 1.174083e-005, 1.182632e-005, 1.191223e-005, 1.199855e-005, 1.208529e-005, 1.217244e-005, 1.226001e-005, 1.234800e-005, 1.243641e-005, 1.252524e-005, 1.261449e-005, 1.270417e-005, 1.279427e-005, 1.288480e-005, 1.297575e-005, 1.306713e-005, 1.315893e-005, 1.325117e-005, 1.334383e-005, 1.343693e-005, 1.353046e-005, 1.362442e-005, 1.371881e-005, 1.381364e-005, 1.390891e-005, 1.400461e-005, 1.410075e-005, 1.419733e-005, 1.429435e-005, 1.439181e-005, 1.448972e-005, 1.458806e-005, 1.468685e-005, 1.478609e-005, 1.488577e-005, 1.498590e-005, 1.508647e-005, 1.518750e-005, 1.528898e-005, 1.539090e-005, 1.549328e-005, 1.559611e-005, 1.569940e-005, 1.580314e-005, 1.590733e-005, 1.601199e-005, 1.611710e-005, 1.622267e-005, 1.632870e-005, 1.643519e-005, 1.654214e-005, 1.664956e-005, 1.675744e-005, 1.686578e-005, 1.697459e-005, 1.708387e-005, 1.719362e-005, 1.730383e-005, 1.741452e-005, 1.752567e-005, 1.763730e-005, 1.774940e-005, 1.786198e-005, 1.797503e-005, 1.808856e-005, 1.820256e-005, 1.831704e-005, 1.843200e-005, 1.854744e-005, 1.866336e-005, 1.877976e-005, 1.889665e-005, 1.901402e-005, 1.913188e-005, 1.925022e-005, 1.936905e-005, 1.948836e-005, 1.960817e-005, 1.972846e-005, 1.984925e-005, 1.997053e-005, 2.009230e-005, 2.021456e-005, 2.033732e-005, 2.046058e-005, 2.058433e-005, 2.070858e-005, 
2.083333e-005, 2.095858e-005, 2.108433e-005, 2.121059e-005, 2.133734e-005, 2.146460e-005, 2.159237e-005, 2.172064e-005, 2.184942e-005, 2.197870e-005, 2.210850e-005, 2.223881e-005, 2.236962e-005, 2.250095e-005, 2.263279e-005, 2.276515e-005, 2.289802e-005, 2.303140e-005, 2.316531e-005, 2.329973e-005, 2.343467e-005, 2.357013e-005, 2.370611e-005, 2.384261e-005, 2.397964e-005, 2.411719e-005, 2.425526e-005, 2.439386e-005, 2.453299e-005, 2.467265e-005, 2.481283e-005, 2.495355e-005, 2.509479e-005, 2.523657e-005, 2.537888e-005, 2.552173e-005, 2.566511e-005, 2.580903e-005, 2.595348e-005, 2.609847e-005, 2.624400e-005, 2.639007e-005, 2.653668e-005, 2.668383e-005, 2.683153e-005, 2.697977e-005, 2.712856e-005, 2.727789e-005, 2.742777e-005, 2.757819e-005, 2.772917e-005, 2.788069e-005, 2.803277e-005, 2.818540e-005, 2.833858e-005, 2.849231e-005, 2.864660e-005, 2.880145e-005, 2.895685e-005, 2.911281e-005, 2.926933e-005, 2.942641e-005, 2.958405e-005, 2.974226e-005, 2.990102e-005, 3.006035e-005, 3.022025e-005, 3.038071e-005, 3.054174e-005, 3.070333e-005, 3.086550e-005, 3.102824e-005, 3.119154e-005, 3.135542e-005, 3.151987e-005, 3.168490e-005, 3.185050e-005, 3.201667e-005, 3.218343e-005, 3.235076e-005, 3.251867e-005, 3.268716e-005, 3.285623e-005, 3.302588e-005, 3.319612e-005, 3.336694e-005, 3.353834e-005, 3.371033e-005, 3.388291e-005, 3.405608e-005, 3.422983e-005, 3.440418e-005, 3.457911e-005, 3.475464e-005, 3.493076e-005, 3.510748e-005, 3.528479e-005, 3.546270e-005, 3.564120e-005, 3.582030e-005, 
3.600000e-005, 3.618030e-005, 3.636120e-005, 3.654270e-005, 3.672481e-005, 3.690752e-005, 3.709084e-005, 3.727476e-005, 3.745929e-005, 3.764442e-005, 3.783017e-005, 3.801652e-005, 3.820349e-005, 3.839107e-005, 3.857926e-005, 3.876806e-005, 3.895748e-005, 3.914752e-005, 3.933817e-005, 3.952944e-005, 3.972133e-005, 3.991384e-005, 4.010697e-005, 4.030073e-005, 4.049510e-005, 4.069010e-005, 4.088573e-005, 4.108198e-005, 4.127886e-005, 4.147636e-005, 4.167450e-005, 4.187327e-005, 4.207266e-005, 4.227269e-005, 4.247335e-005, 4.267465e-005, 4.287658e-005, 4.307914e-005, 4.328235e-005, 4.348619e-005, 4.369067e-005, 4.389579e-005, 4.410155e-005, 4.430795e-005, 4.451500e-005, 4.472269e-005, 4.493102e-005, 4.514000e-005, 4.534963e-005, 4.555991e-005, 4.577083e-005, 4.598241e-005, 4.619463e-005, 4.640751e-005, 4.662104e-005, 4.683523e-005, 4.705007e-005, 4.726557e-005, 4.748172e-005, 4.769853e-005, 4.791600e-005, 4.813413e-005, 4.835292e-005, 4.857237e-005, 4.879249e-005, 4.901327e-005, 4.923472e-005, 4.945683e-005, 4.967961e-005, 4.990305e-005, 5.012717e-005, 5.035195e-005, 5.057741e-005, 5.080354e-005, 5.103034e-005, 5.125781e-005, 5.148596e-005, 5.171479e-005, 5.194429e-005, 5.217447e-005, 5.240533e-005, 5.263687e-005, 5.286909e-005, 5.310200e-005, 5.333558e-005, 5.356985e-005, 5.380481e-005, 5.404045e-005, 5.427678e-005, 5.451379e-005, 5.475150e-005, 5.498990e-005, 5.522898e-005, 5.546876e-005, 5.570923e-005, 5.595040e-005, 5.619226e-005, 5.643481e-005, 5.667807e-005, 5.692202e-005, 
5.716667e-005, 5.741202e-005, 5.765807e-005, 5.790482e-005, 5.815228e-005, 5.840044e-005, 5.864930e-005, 5.889887e-005, 5.914915e-005, 5.940014e-005, 5.965183e-005, 5.990424e-005, 6.015735e-005, 6.041118e-005, 6.066572e-005, 6.092098e-005, 6.117695e-005, 6.143364e-005, 6.169104e-005, 6.194916e-005, 6.220800e-005, 6.246756e-005, 6.272784e-005, 6.298884e-005, 6.325057e-005, 6.351302e-005, 6.377620e-005, 6.404010e-005, 6.430473e-005, 6.457008e-005, 6.483617e-005, 6.510298e-005, 6.537053e-005, 6.563881e-005, 6.590782e-005, 6.617756e-005, 6.644804e-005, 6.671926e-005, 6.699121e-005, 6.726390e-005, 6.753733e-005, 6.781150e-005, 6.808641e-005, 6.836207e-005, 6.863846e-005, 6.891560e-005, 6.919349e-005, 6.947212e-005, 6.975150e-005, 7.003162e-005, 7.031250e-005, 7.059413e-005, 7.087650e-005, 7.115963e-005, 7.144351e-005, 7.172815e-005, 7.201354e-005, 7.229968e-005, 7.258659e-005, 7.287425e-005, 7.316267e-005, 7.345185e-005, 7.374179e-005, 7.403249e-005, 7.432396e-005, 7.461619e-005, 7.490918e-005, 7.520294e-005, 7.549747e-005, 7.579277e-005, 7.608883e-005, 7.638567e-005, 7.668327e-005, 7.698165e-005, 7.728080e-005, 7.758073e-005, 7.788143e-005, 7.818291e-005, 7.848516e-005, 7.878819e-005, 7.909200e-005, 7.939659e-005, 7.970196e-005, 8.000811e-005, 8.031505e-005, 8.062277e-005, 8.093128e-005, 8.124057e-005, 8.155065e-005, 8.186151e-005, 8.217317e-005, 8.248561e-005, 8.279885e-005, 8.311288e-005, 8.342770e-005, 8.374331e-005, 8.405972e-005, 8.437693e-005, 8.469493e-005, 8.501373e-005, 
8.533333e-005, 8.565373e-005, 8.597493e-005, 8.629694e-005, 8.661974e-005, 8.694335e-005, 8.726777e-005, 8.759299e-005, 8.791902e-005, 8.824585e-005, 8.857350e-005, 8.890196e-005, 8.923122e-005, 8.956130e-005, 8.989219e-005, 9.022390e-005, 9.055642e-005, 9.088975e-005, 9.122391e-005, 9.155888e-005, 9.189467e-005, 9.223128e-005, 9.256871e-005, 9.290696e-005, 9.324604e-005, 9.358594e-005, 9.392666e-005, 9.426821e-005, 9.461059e-005, 9.495380e-005, 9.529783e-005, 9.564270e-005, 9.598839e-005, 9.633492e-005, 9.668228e-005, 9.703048e-005, 9.737951e-005, 9.772938e-005, 9.808008e-005, 9.843162e-005, 9.878400e-005, 9.913722e-005, 9.949128e-005, 9.984618e-005, 1.002019e-004, 1.005585e-004, 1.009160e-004, 1.012742e-004, 1.016334e-004, 1.019933e-004, 1.023542e-004, 1.027158e-004, 1.030784e-004, 1.034417e-004, 1.038060e-004, 1.041711e-004, 1.045370e-004, 1.049038e-004, 1.052715e-004, 1.056400e-004, 1.060093e-004, 1.063796e-004, 1.067507e-004, 1.071226e-004, 1.074954e-004, 1.078691e-004, 1.082436e-004, 1.086191e-004, 1.089953e-004, 1.093725e-004, 1.097505e-004, 1.101294e-004, 1.105091e-004, 1.108898e-004, 1.112713e-004, 1.116536e-004, 1.120369e-004, 1.124210e-004, 1.128060e-004, 1.131919e-004, 1.135787e-004, 1.139663e-004, 1.143548e-004, 1.147442e-004, 1.151345e-004, 1.155257e-004, 1.159177e-004, 1.163107e-004, 1.167045e-004, 1.170992e-004, 1.174948e-004, 1.178913e-004, 1.182887e-004, 1.186870e-004, 1.190862e-004, 1.194862e-004, 1.198872e-004, 1.202890e-004, 1.206918e-004, 1.210954e-004, 
1.215000e-004, 1.219055e-004, 1.223118e-004, 1.227191e-004, 1.231272e-004, 1.235363e-004, 1.239462e-004, 1.243571e-004, 1.247689e-004, 1.251816e-004, 1.255952e-004, 1.260097e-004, 1.264251e-004, 1.268414e-004, 1.272587e-004, 1.276768e-004, 1.280959e-004, 1.285159e-004, 1.289368e-004, 1.293586e-004, 1.297813e-004, 1.302050e-004, 1.306296e-004, 1.310551e-004, 1.314815e-004, 1.319089e-004, 1.323371e-004, 1.327663e-004, 1.331965e-004, 1.336275e-004, 1.340595e-004, 1.344924e-004, 1.349263e-004, 1.353610e-004, 1.357968e-004, 1.362334e-004, 1.366710e-004, 1.371095e-004, 1.375489e-004, 1.379893e-004, 1.384307e-004, 1.388729e-004, 1.393161e-004, 1.397603e-004, 1.402054e-004, 1.406514e-004, 1.410984e-004, 1.415464e-004, 1.419952e-004, 1.424451e-004, 1.428958e-004, 1.433476e-004, 1.438002e-004, 1.442539e-004, 1.447084e-004, 1.451640e-004, 1.456205e-004, 1.460779e-004, 1.465363e-004, 1.469957e-004, 1.474560e-004, 1.479173e-004, 1.483795e-004, 1.488427e-004, 1.493069e-004, 1.497720e-004, 1.502381e-004, 1.507052e-004, 1.511732e-004, 1.516422e-004, 1.521122e-004, 1.525831e-004, 1.530550e-004, 1.535279e-004, 1.540017e-004, 1.544766e-004, 1.549524e-004, 1.554291e-004, 1.559069e-004, 1.563856e-004, 1.568653e-004, 1.573460e-004, 1.578277e-004, 1.583103e-004, 1.587940e-004, 1.592786e-004, 1.597642e-004, 1.602508e-004, 1.607384e-004, 1.612269e-004, 1.617165e-004, 1.622070e-004, 1.626986e-004, 1.631911e-004, 1.636846e-004, 1.641791e-004, 1.646747e-004, 1.651712e-004, 1.656687e-004, 1.661672e-004, 
1.666667e-004, 1.671672e-004, 1.676687e-004, 1.681712e-004, 1.686747e-004, 1.691792e-004, 1.696847e-004, 1.701912e-004, 1.706988e-004, 1.712073e-004, 1.717168e-004, 1.722274e-004, 1.727390e-004, 1.732515e-004, 1.737651e-004, 1.742797e-004, 1.747953e-004, 1.753120e-004, 1.758296e-004, 1.763483e-004, 1.768680e-004, 1.773887e-004, 1.779104e-004, 1.784332e-004, 1.789570e-004, 1.794818e-004, 1.800076e-004, 1.805344e-004, 1.810623e-004, 1.815912e-004, 1.821212e-004, 1.826521e-004, 1.831841e-004, 1.837172e-004, 1.842512e-004, 1.847863e-004, 1.853224e-004, 1.858596e-004, 1.863978e-004, 1.869371e-004, 1.874773e-004, 1.880187e-004, 1.885610e-004, 1.891044e-004, 1.896489e-004, 1.901944e-004, 1.907409e-004, 1.912885e-004, 1.918371e-004, 1.923868e-004, 1.929375e-004, 1.934893e-004, 1.940421e-004, 1.945960e-004, 1.951509e-004, 1.957069e-004, 1.962639e-004, 1.968220e-004, 1.973812e-004, 1.979414e-004, 1.985027e-004, 1.990650e-004, 1.996284e-004, 2.001928e-004, 2.007584e-004, 2.013249e-004, 2.018926e-004, 2.024613e-004, 2.030311e-004, 2.036019e-004, 2.041738e-004, 2.047468e-004, 2.053209e-004, 2.058960e-004, 2.064722e-004, 2.070495e-004, 2.076278e-004, 2.082073e-004, 2.087878e-004, 2.093693e-004, 2.099520e-004, 2.105357e-004, 2.111206e-004, 2.117065e-004, 2.122935e-004, 2.128815e-004, 2.134707e-004, 2.140609e-004, 2.146522e-004, 2.152447e-004, 2.158382e-004, 2.164328e-004, 2.170284e-004, 2.176252e-004, 2.182231e-004, 2.188221e-004, 2.194221e-004, 2.200233e-004, 2.206255e-004, 2.212289e-004, 
2.218333e-004, 2.224389e-004, 2.230455e-004, 2.236533e-004, 2.242621e-004, 2.248721e-004, 2.254832e-004, 2.260953e-004, 2.267086e-004, 2.273230e-004, 2.279385e-004, 2.285551e-004, 2.291728e-004, 2.297916e-004, 2.304116e-004, 2.310326e-004, 2.316548e-004, 2.322781e-004, 2.329025e-004, 2.335280e-004, 2.341547e-004, 2.347824e-004, 2.354113e-004, 2.360413e-004, 2.366724e-004, 2.373047e-004, 2.379381e-004, 2.385726e-004, 2.392082e-004, 2.398449e-004, 2.404828e-004, 2.411218e-004, 2.417620e-004, 2.424033e-004, 2.430457e-004, 2.436892e-004, 2.443339e-004, 2.449797e-004, 2.456267e-004, 2.462748e-004, 2.469240e-004, 2.475744e-004, 2.482259e-004, 2.488785e-004, 2.495323e-004, 2.501873e-004, 2.508434e-004, 2.515006e-004, 2.521590e-004, 2.528185e-004, 2.534792e-004, 2.541410e-004, 2.548040e-004, 2.554681e-004, 2.561334e-004, 2.567998e-004, 2.574674e-004, 2.581361e-004, 2.588061e-004, 2.594771e-004, 2.601493e-004, 2.608227e-004, 2.614973e-004, 2.621730e-004, 2.628498e-004, 2.635279e-004, 2.642070e-004, 2.648874e-004, 2.655689e-004, 2.662516e-004, 2.669355e-004, 2.676205e-004, 2.683067e-004, 2.689941e-004, 2.696827e-004, 2.703724e-004, 2.710633e-004, 2.717554e-004, 2.724486e-004, 2.731431e-004, 2.738387e-004, 2.745355e-004, 2.752334e-004, 2.759326e-004, 2.766329e-004, 2.773344e-004, 2.780371e-004, 2.787410e-004, 2.794461e-004, 2.801524e-004, 2.808598e-004, 2.815685e-004, 2.822783e-004, 2.829893e-004, 2.837016e-004, 2.844150e-004, 2.851296e-004, 2.858454e-004, 2.865624e-004, 2.872806e-004, 
2.880000e-004, 2.887206e-004, 2.894424e-004, 2.901654e-004, 2.908896e-004, 2.916150e-004, 2.923416e-004, 2.930695e-004, 2.937985e-004, 2.945287e-004, 2.952602e-004, 2.959928e-004, 2.967267e-004, 2.974618e-004, 2.981981e-004, 2.989356e-004, 2.996743e-004, 3.004142e-004, 3.011554e-004, 3.018977e-004, 3.026413e-004, 3.033861e-004, 3.041322e-004, 3.048794e-004, 3.056279e-004, 3.063776e-004, 3.071285e-004, 3.078807e-004, 3.086341e-004, 3.093887e-004, 3.101445e-004, 3.109016e-004, 3.116599e-004, 3.124194e-004, 3.131802e-004, 3.139421e-004, 3.147054e-004, 3.154698e-004, 3.162355e-004, 3.170025e-004, 3.177707e-004, 3.185401e-004, 3.193107e-004, 3.200827e-004, 3.208558e-004, 3.216302e-004, 3.224058e-004, 3.231827e-004, 3.239608e-004, 3.247402e-004, 3.255208e-004, 3.263027e-004, 3.270858e-004, 3.278702e-004, 3.286558e-004, 3.294427e-004, 3.302309e-004, 3.310203e-004, 3.318109e-004, 3.326028e-004, 3.333960e-004, 3.341904e-004, 3.349861e-004, 3.357831e-004, 3.365813e-004, 3.373808e-004, 3.381815e-004, 3.389835e-004, 3.397868e-004, 3.405914e-004, 3.413972e-004, 3.422043e-004, 3.430126e-004, 3.438222e-004, 3.446331e-004, 3.454453e-004, 3.462588e-004, 3.470735e-004, 3.478895e-004, 3.487068e-004, 3.495253e-004, 3.503452e-004, 3.511663e-004, 3.519887e-004, 3.528124e-004, 3.536374e-004, 3.544636e-004, 3.552912e-004, 3.561200e-004, 3.569501e-004, 3.577815e-004, 3.586142e-004, 3.594482e-004, 3.602835e-004, 3.611200e-004, 3.619579e-004, 3.627971e-004, 3.636375e-004, 3.644793e-004, 3.653223e-004, 
3.661667e-004, 3.670123e-004, 3.678593e-004, 3.687075e-004, 3.695571e-004, 3.704079e-004, 3.712601e-004, 3.721136e-004, 3.729684e-004, 3.738244e-004, 3.746818e-004, 3.755405e-004, 3.764006e-004, 3.772619e-004, 3.781245e-004, 3.789885e-004, 3.798537e-004, 3.807203e-004, 3.815882e-004, 3.824575e-004, 3.833280e-004, 3.841999e-004, 3.850730e-004, 3.859475e-004, 3.868234e-004, 3.877005e-004, 3.885790e-004, 3.894588e-004, 3.903399e-004, 3.912224e-004, 3.921062e-004, 3.929913e-004, 3.938777e-004, 3.947655e-004, 3.956546e-004, 3.965451e-004, 3.974368e-004, 3.983300e-004, 3.992244e-004, 4.001202e-004, 4.010173e-004, 4.019158e-004, 4.028156e-004, 4.037168e-004, 4.046193e-004, 4.055231e-004, 4.064283e-004, 4.073348e-004, 4.082427e-004, 4.091519e-004, 4.100625e-004, 4.109744e-004, 4.118877e-004, 4.128023e-004, 4.137183e-004, 4.146356e-004, 4.155543e-004, 4.164744e-004, 4.173958e-004, 4.183185e-004, 4.192427e-004, 4.201681e-004, 4.210950e-004, 4.220232e-004, 4.229528e-004, 4.238837e-004, 4.248160e-004, 4.257496e-004, 4.266847e-004, 4.276211e-004, 4.285588e-004, 4.294980e-004, 4.304385e-004, 4.313804e-004, 4.323236e-004, 4.332682e-004, 4.342142e-004, 4.351616e-004, 4.361104e-004, 4.370605e-004, 4.380120e-004, 4.389649e-004, 4.399192e-004, 4.408748e-004, 4.418319e-004, 4.427903e-004, 4.437501e-004, 4.447113e-004, 4.456738e-004, 4.466378e-004, 4.476032e-004, 4.485699e-004, 4.495380e-004, 4.505076e-004, 4.514785e-004, 4.524508e-004, 4.534245e-004, 4.543996e-004, 4.553761e-004, 4.563540e-004, 
4.573333e-004, 4.583140e-004, 4.592961e-004, 4.602796e-004, 4.612645e-004, 4.622509e-004, 4.632386e-004, 4.642277e-004, 4.652182e-004, 4.662102e-004, 4.672035e-004, 4.681983e-004, 4.691944e-004, 4.701920e-004, 4.711910e-004, 4.721914e-004, 4.731932e-004, 4.741965e-004, 4.752011e-004, 4.762072e-004, 4.772147e-004, 4.782236e-004, 4.792339e-004, 4.802457e-004, 4.812588e-004, 4.822734e-004, 4.832895e-004, 4.843069e-004, 4.853258e-004, 4.863461e-004, 4.873678e-004, 4.883910e-004, 4.894156e-004, 4.904416e-004, 4.914691e-004, 4.924980e-004, 4.935283e-004, 4.945601e-004, 4.955933e-004, 4.966279e-004, 4.976640e-004, 4.987015e-004, 4.997405e-004, 5.007809e-004, 5.018227e-004, 5.028660e-004, 5.039108e-004, 5.049569e-004, 5.060046e-004, 5.070536e-004, 5.081042e-004, 5.091561e-004, 5.102096e-004, 5.112644e-004, 5.123208e-004, 5.133786e-004, 5.144378e-004, 5.154985e-004, 5.165607e-004, 5.176243e-004, 5.186893e-004, 5.197559e-004, 5.208239e-004, 5.218933e-004, 5.229642e-004, 5.240366e-004, 5.251104e-004, 5.261858e-004, 5.272625e-004, 5.283408e-004, 5.294205e-004, 5.305017e-004, 5.315843e-004, 5.326685e-004, 5.337541e-004, 5.348411e-004, 5.359297e-004, 5.370197e-004, 5.381112e-004, 5.392042e-004, 5.402987e-004, 5.413946e-004, 5.424920e-004, 5.435909e-004, 5.446913e-004, 5.457932e-004, 5.468965e-004, 5.480014e-004, 5.491077e-004, 5.502155e-004, 5.513248e-004, 5.524356e-004, 5.535479e-004, 5.546617e-004, 5.557770e-004, 5.568937e-004, 5.580120e-004, 5.591317e-004, 5.602530e-004, 5.613757e-004, 
5.625000e-004, 5.636258e-004, 5.647530e-004, 5.658818e-004, 5.670120e-004, 5.681438e-004, 5.692770e-004, 5.704118e-004, 5.715481e-004, 5.726859e-004, 5.738252e-004, 5.749660e-004, 5.761083e-004, 5.772521e-004, 5.783975e-004, 5.795443e-004, 5.806927e-004, 5.818426e-004, 5.829940e-004, 5.841469e-004, 5.853013e-004, 5.864573e-004, 5.876148e-004, 5.887738e-004, 5.899343e-004, 5.910964e-004, 5.922599e-004, 5.934250e-004, 5.945917e-004, 5.957598e-004, 5.969295e-004, 5.981007e-004, 5.992735e-004, 6.004477e-004, 6.016236e-004, 6.028009e-004, 6.039798e-004, 6.051602e-004, 6.063421e-004, 6.075256e-004, 6.087107e-004, 6.098972e-004, 6.110853e-004, 6.122750e-004, 6.134662e-004, 6.146589e-004, 6.158532e-004, 6.170491e-004, 6.182464e-004, 6.194454e-004, 6.206458e-004, 6.218479e-004, 6.230514e-004, 6.242566e-004, 6.254632e-004, 6.266715e-004, 6.278813e-004, 6.290926e-004, 6.303055e-004, 6.315200e-004, 6.327360e-004, 6.339536e-004, 6.351727e-004, 6.363934e-004, 6.376157e-004, 6.388395e-004, 6.400649e-004, 6.412919e-004, 6.425204e-004, 6.437505e-004, 6.449822e-004, 6.462154e-004, 6.474502e-004, 6.486866e-004, 6.499245e-004, 6.511641e-004, 6.524052e-004, 6.536478e-004, 6.548921e-004, 6.561379e-004, 6.573853e-004, 6.586343e-004, 6.598849e-004, 6.611370e-004, 6.623908e-004, 6.636461e-004, 6.649030e-004, 6.661615e-004, 6.674216e-004, 6.686832e-004, 6.699465e-004, 6.712113e-004, 6.724778e-004, 6.737458e-004, 6.750154e-004, 6.762866e-004, 6.775595e-004, 6.788339e-004, 6.801099e-004, 6.813875e-004, 
6.826667e-004, 6.839475e-004, 6.852299e-004, 6.865139e-004, 6.877995e-004, 6.890867e-004, 6.903755e-004, 6.916659e-004, 6.929580e-004, 6.942516e-004, 6.955468e-004, 6.968437e-004, 6.981422e-004, 6.994422e-004, 7.007439e-004, 7.020472e-004, 7.033521e-004, 7.046587e-004, 7.059668e-004, 7.072766e-004, 7.085880e-004, 7.099010e-004, 7.112156e-004, 7.125319e-004, 7.138498e-004, 7.151693e-004, 7.164904e-004, 7.178131e-004, 7.191375e-004, 7.204635e-004, 7.217912e-004, 7.231204e-004, 7.244513e-004, 7.257839e-004, 7.271180e-004, 7.284538e-004, 7.297912e-004, 7.311303e-004, 7.324710e-004, 7.338134e-004, 7.351573e-004, 7.365030e-004, 7.378502e-004, 7.391991e-004, 7.405497e-004, 7.419019e-004, 7.432557e-004, 7.446112e-004, 7.459683e-004, 7.473271e-004, 7.486875e-004, 7.500496e-004, 7.514133e-004, 7.527787e-004, 7.541457e-004, 7.555144e-004, 7.568847e-004, 7.582567e-004, 7.596304e-004, 7.610057e-004, 7.623827e-004, 7.637613e-004, 7.651416e-004, 7.665235e-004, 7.679072e-004, 7.692924e-004, 7.706794e-004, 7.720680e-004, 7.734583e-004, 7.748502e-004, 7.762438e-004, 7.776391e-004, 7.790361e-004, 7.804347e-004, 7.818350e-004, 7.832370e-004, 7.846406e-004, 7.860460e-004, 7.874530e-004, 7.888616e-004, 7.902720e-004, 7.916840e-004, 7.930978e-004, 7.945132e-004, 7.959303e-004, 7.973490e-004, 7.987695e-004, 8.001916e-004, 8.016154e-004, 8.030410e-004, 8.044682e-004, 8.058971e-004, 8.073276e-004, 8.087599e-004, 8.101939e-004, 8.116296e-004, 8.130669e-004, 8.145060e-004, 8.159467e-004, 8.173892e-004, 
8.188333e-004, 8.202792e-004, 8.217267e-004, 8.231760e-004, 8.246269e-004, 8.260796e-004, 8.275340e-004, 8.289900e-004, 8.304478e-004, 8.319073e-004, 8.333685e-004, 8.348314e-004, 8.362960e-004, 8.377623e-004, 8.392304e-004, 8.407001e-004, 8.421716e-004, 8.436448e-004, 8.451197e-004, 8.465963e-004, 8.480747e-004, 8.495547e-004, 8.510365e-004, 8.525200e-004, 8.540052e-004, 8.554922e-004, 8.569809e-004, 8.584713e-004, 8.599634e-004, 8.614572e-004, 8.629528e-004, 8.644501e-004, 8.659492e-004, 8.674500e-004, 8.689525e-004, 8.704567e-004, 8.719627e-004, 8.734704e-004, 8.749799e-004, 8.764911e-004, 8.780040e-004, 8.795187e-004, 8.810351e-004, 8.825532e-004, 8.840731e-004, 8.855948e-004, 8.871182e-004, 8.886433e-004, 8.901702e-004, 8.916988e-004, 8.932292e-004, 8.947613e-004, 8.962952e-004, 8.978308e-004, 8.993682e-004, 9.009073e-004, 9.024482e-004, 9.039908e-004, 9.055353e-004, 9.070814e-004, 9.086293e-004, 9.101790e-004, 9.117305e-004, 9.132837e-004, 9.148386e-004, 9.163954e-004, 9.179538e-004, 9.195141e-004, 9.210761e-004, 9.226399e-004, 9.242055e-004, 9.257728e-004, 9.273419e-004, 9.289128e-004, 9.304855e-004, 9.320599e-004, 9.336361e-004, 9.352141e-004, 9.367938e-004, 9.383754e-004, 9.399587e-004, 9.415438e-004, 9.431306e-004, 9.447193e-004, 9.463097e-004, 9.479019e-004, 9.494959e-004, 9.510917e-004, 9.526893e-004, 9.542887e-004, 9.558898e-004, 9.574928e-004, 9.590975e-004, 9.607040e-004, 9.623124e-004, 9.639225e-004, 9.655344e-004, 9.671481e-004, 9.687636e-004, 9.703809e-004, 
9.720000e-004, 9.736209e-004, 9.752436e-004, 9.768681e-004, 9.784944e-004, 9.801225e-004, 9.817524e-004, 9.833842e-004, 9.850177e-004, 9.866530e-004, 9.882902e-004, 9.899291e-004, 9.915699e-004, 9.932125e-004, 9.948569e-004, 9.965031e-004, 9.981511e-004, 9.998009e-004, 1.001453e-003, 1.003106e-003, 1.004761e-003, 1.006418e-003, 1.008077e-003, 1.009738e-003, 1.011401e-003, 1.013065e-003, 1.014731e-003, 1.016399e-003, 1.018069e-003, 1.019741e-003, 1.021415e-003, 1.023090e-003, 1.024767e-003, 1.026446e-003, 1.028127e-003, 1.029810e-003, 1.031494e-003, 1.033181e-003, 1.034869e-003, 1.036559e-003, 1.038251e-003, 1.039944e-003, 1.041640e-003, 1.043337e-003, 1.045037e-003, 1.046738e-003, 1.048441e-003, 1.050145e-003, 1.051852e-003, 1.053561e-003, 1.055271e-003, 1.056983e-003, 1.058697e-003, 1.060413e-003, 1.062131e-003, 1.063850e-003, 1.065572e-003, 1.067295e-003, 1.069020e-003, 1.070747e-003, 1.072476e-003, 1.074207e-003, 1.075939e-003, 1.077674e-003, 1.079410e-003, 1.081148e-003, 1.082888e-003, 1.084630e-003, 1.086374e-003, 1.088120e-003, 1.089867e-003, 1.091617e-003, 1.093368e-003, 1.095121e-003, 1.096876e-003, 1.098633e-003, 1.100392e-003, 1.102152e-003, 1.103915e-003, 1.105679e-003, 1.107445e-003, 1.109213e-003, 1.110983e-003, 1.112755e-003, 1.114529e-003, 1.116305e-003, 1.118082e-003, 1.119862e-003, 1.121643e-003, 1.123426e-003, 1.125212e-003, 1.126998e-003, 1.128787e-003, 1.130578e-003, 1.132371e-003, 1.134165e-003, 1.135962e-003, 1.137760e-003, 1.139560e-003, 1.141363e-003, 
1.143167e-003, 1.144973e-003, 1.146780e-003, 1.148590e-003, 1.150402e-003, 1.152215e-003, 1.154031e-003, 1.155848e-003, 1.157668e-003, 1.159489e-003, 1.161312e-003, 1.163137e-003, 1.164964e-003, 1.166793e-003, 1.168623e-003, 1.170456e-003, 1.172291e-003, 1.174127e-003, 1.175965e-003, 1.177806e-003, 1.179648e-003, 1.181492e-003, 1.183338e-003, 1.185186e-003, 1.187036e-003, 1.188888e-003, 1.190742e-003, 1.192597e-003, 1.194455e-003, 1.196315e-003, 1.198176e-003, 1.200040e-003, 1.201905e-003, 1.203772e-003, 1.205641e-003, 1.207513e-003, 1.209386e-003, 1.211261e-003, 1.213138e-003, 1.215017e-003, 1.216897e-003, 1.218780e-003, 1.220665e-003, 1.222551e-003, 1.224440e-003, 1.226331e-003, 1.228223e-003, 1.230118e-003, 1.232014e-003, 1.233912e-003, 1.235813e-003, 1.237715e-003, 1.239619e-003, 1.241525e-003, 1.243433e-003, 1.245343e-003, 1.247255e-003, 1.249169e-003, 1.251085e-003, 1.253003e-003, 1.254923e-003, 1.256844e-003, 1.258768e-003, 1.260694e-003, 1.262622e-003, 1.264551e-003, 1.266483e-003, 1.268416e-003, 1.270352e-003, 1.272289e-003, 1.274229e-003, 1.276170e-003, 1.278114e-003, 1.280059e-003, 1.282006e-003, 1.283956e-003, 1.285907e-003, 1.287860e-003, 1.289816e-003, 1.291773e-003, 1.293732e-003, 1.295693e-003, 1.297656e-003, 1.299622e-003, 1.301589e-003, 1.303558e-003, 1.305529e-003, 1.307502e-003, 1.309477e-003, 1.311454e-003, 1.313433e-003, 1.315414e-003, 1.317397e-003, 1.319382e-003, 1.321369e-003, 1.323358e-003, 1.325349e-003, 1.327342e-003, 1.329337e-003, 1.331334e-003, 
1.333333e-003, 1.335334e-003, 1.337337e-003, 1.339342e-003, 1.341349e-003, 1.343358e-003, 1.345369e-003, 1.347382e-003, 1.349397e-003, 1.351414e-003, 1.353434e-003, 1.355455e-003, 1.357478e-003, 1.359503e-003, 1.361530e-003, 1.363559e-003, 1.365590e-003, 1.367623e-003, 1.369658e-003, 1.371695e-003, 1.373735e-003, 1.375776e-003, 1.377819e-003, 1.379864e-003, 1.381912e-003, 1.383961e-003, 1.386012e-003, 1.388066e-003, 1.390121e-003, 1.392178e-003, 1.394238e-003, 1.396299e-003, 1.398363e-003, 1.400428e-003, 1.402496e-003, 1.404565e-003, 1.406637e-003, 1.408711e-003, 1.410786e-003, 1.412864e-003, 1.414944e-003, 1.417026e-003, 1.419110e-003, 1.421196e-003, 1.423284e-003, 1.425374e-003, 1.427466e-003, 1.429560e-003, 1.431656e-003, 1.433754e-003, 1.435854e-003, 1.437956e-003, 1.440061e-003, 1.442167e-003, 1.444276e-003, 1.446386e-003, 1.448499e-003, 1.450613e-003, 1.452730e-003, 1.454849e-003, 1.456969e-003, 1.459092e-003, 1.461217e-003, 1.463344e-003, 1.465473e-003, 1.467604e-003, 1.469737e-003, 1.471872e-003, 1.474010e-003, 1.476149e-003, 1.478290e-003, 1.480434e-003, 1.482580e-003, 1.484727e-003, 1.486877e-003, 1.489029e-003, 1.491182e-003, 1.493338e-003, 1.495496e-003, 1.497657e-003, 1.499819e-003, 1.501983e-003, 1.504149e-003, 1.506318e-003, 1.508488e-003, 1.510661e-003, 1.512835e-003, 1.515012e-003, 1.517191e-003, 1.519372e-003, 1.521555e-003, 1.523740e-003, 1.525927e-003, 1.528116e-003, 1.530308e-003, 1.532501e-003, 1.534697e-003, 1.536894e-003, 1.539094e-003, 1.541296e-003, 
1.543500e-003, 1.545706e-003, 1.547914e-003, 1.550124e-003, 1.552337e-003, 1.554551e-003, 1.556768e-003, 1.558987e-003, 1.561207e-003, 1.563430e-003, 1.565655e-003, 1.567882e-003, 1.570111e-003, 1.572343e-003, 1.574576e-003, 1.576812e-003, 1.579049e-003, 1.581289e-003, 1.583531e-003, 1.585775e-003, 1.588021e-003, 1.590270e-003, 1.592520e-003, 1.594772e-003, 1.597027e-003, 1.599284e-003, 1.601543e-003, 1.603804e-003, 1.606067e-003, 1.608332e-003, 1.610599e-003, 1.612869e-003, 1.615141e-003, 1.617414e-003, 1.619690e-003, 1.621968e-003, 1.624249e-003, 1.626531e-003, 1.628815e-003, 1.631102e-003, 1.633391e-003, 1.635682e-003, 1.637975e-003, 1.640270e-003, 1.642567e-003, 1.644866e-003, 1.647168e-003, 1.649472e-003, 1.651778e-003, 1.654086e-003, 1.656396e-003, 1.658708e-003, 1.661023e-003, 1.663339e-003, 1.665658e-003, 1.667979e-003, 1.670302e-003, 1.672627e-003, 1.674955e-003, 1.677284e-003, 1.679616e-003, 1.681950e-003, 1.684286e-003, 1.686624e-003, 1.688964e-003, 1.691307e-003, 1.693652e-003, 1.695999e-003, 1.698348e-003, 1.700699e-003, 1.703052e-003, 1.705408e-003, 1.707765e-003, 1.710125e-003, 1.712487e-003, 1.714852e-003, 1.717218e-003, 1.719587e-003, 1.721957e-003, 1.724330e-003, 1.726705e-003, 1.729083e-003, 1.731462e-003, 1.733844e-003, 1.736228e-003, 1.738614e-003, 1.741002e-003, 1.743392e-003, 1.745785e-003, 1.748180e-003, 1.750577e-003, 1.752976e-003, 1.755377e-003, 1.757781e-003, 1.760186e-003, 1.762594e-003, 1.765004e-003, 1.767417e-003, 1.769831e-003, 1.772248e-003, 
1.774667e-003, 1.777088e-003, 1.779511e-003, 1.781937e-003, 1.784364e-003, 1.786794e-003, 1.789226e-003, 1.791661e-003, 1.794097e-003, 1.796536e-003, 1.798977e-003, 1.801420e-003, 1.803865e-003, 1.806313e-003, 1.808763e-003, 1.811215e-003, 1.813669e-003, 1.816125e-003, 1.818584e-003, 1.821045e-003, 1.823508e-003, 1.825973e-003, 1.828441e-003, 1.830911e-003, 1.833383e-003, 1.835857e-003, 1.838333e-003, 1.840812e-003, 1.843293e-003, 1.845776e-003, 1.848261e-003, 1.850749e-003, 1.853239e-003, 1.855731e-003, 1.858225e-003, 1.860721e-003, 1.863220e-003, 1.865721e-003, 1.868224e-003, 1.870730e-003, 1.873237e-003, 1.875747e-003, 1.878259e-003, 1.880774e-003, 1.883290e-003, 1.885809e-003, 1.888330e-003, 1.890854e-003, 1.893379e-003, 1.895907e-003, 1.898438e-003, 1.900970e-003, 1.903505e-003, 1.906041e-003, 1.908581e-003, 1.911122e-003, 1.913666e-003, 1.916211e-003, 1.918760e-003, 1.921310e-003, 1.923863e-003, 1.926418e-003, 1.928975e-003, 1.931534e-003, 1.934096e-003, 1.936660e-003, 1.939226e-003, 1.941795e-003, 1.944365e-003, 1.946939e-003, 1.949514e-003, 1.952091e-003, 1.954671e-003, 1.957253e-003, 1.959838e-003, 1.962424e-003, 1.965013e-003, 1.967605e-003, 1.970198e-003, 1.972794e-003, 1.975392e-003, 1.977992e-003, 1.980595e-003, 1.983200e-003, 1.985807e-003, 1.988417e-003, 1.991028e-003, 1.993642e-003, 1.996259e-003, 1.998877e-003, 2.001498e-003, 2.004121e-003, 2.006747e-003, 2.009375e-003, 2.012005e-003, 2.014637e-003, 2.017272e-003, 2.019909e-003, 2.022548e-003, 2.025189e-003, 
2.027833e-003, 2.030479e-003, 2.033128e-003, 2.035779e-003, 2.038432e-003, 2.041087e-003, 2.043745e-003, 2.046405e-003, 2.049067e-003, 2.051732e-003, 2.054399e-003, 2.057068e-003, 2.059739e-003, 2.062413e-003, 2.065089e-003, 2.067768e-003, 2.070448e-003, 2.073132e-003, 2.075817e-003, 2.078505e-003, 2.081195e-003, 2.083887e-003, 2.086582e-003, 2.089279e-003, 2.091978e-003, 2.094680e-003, 2.097384e-003, 2.100090e-003, 2.102799e-003, 2.105510e-003, 2.108223e-003, 2.110938e-003, 2.113656e-003, 2.116377e-003, 2.119099e-003, 2.121824e-003, 2.124552e-003, 2.127281e-003, 2.130013e-003, 2.132747e-003, 2.135484e-003, 2.138223e-003, 2.140964e-003, 2.143708e-003, 2.146454e-003, 2.149202e-003, 2.151953e-003, 2.154706e-003, 2.157461e-003, 2.160219e-003, 2.162979e-003, 2.165742e-003, 2.168506e-003, 2.171273e-003, 2.174043e-003, 2.176815e-003, 2.179589e-003, 2.182366e-003, 2.185144e-003, 2.187926e-003, 2.190709e-003, 2.193495e-003, 2.196284e-003, 2.199074e-003, 2.201867e-003, 2.204663e-003, 2.207461e-003, 2.210261e-003, 2.213063e-003, 2.215868e-003, 2.218676e-003, 2.221485e-003, 2.224297e-003, 2.227112e-003, 2.229928e-003, 2.232747e-003, 2.235569e-003, 2.238393e-003, 2.241219e-003, 2.244048e-003, 2.246879e-003, 2.249712e-003, 2.252548e-003, 2.255386e-003, 2.258227e-003, 2.261069e-003, 2.263915e-003, 2.266762e-003, 2.269613e-003, 2.272465e-003, 2.275320e-003, 2.278177e-003, 2.281037e-003, 2.283899e-003, 2.286763e-003, 2.289630e-003, 2.292499e-003, 2.295371e-003, 2.298245e-003, 2.301121e-003, 
2.304000e-003, 2.306881e-003, 2.309765e-003, 2.312651e-003, 2.315539e-003, 2.318430e-003, 2.321323e-003, 2.324219e-003, 2.327117e-003, 2.330017e-003, 2.332920e-003, 2.335825e-003, 2.338733e-003, 2.341643e-003, 2.344556e-003, 2.347471e-003, 2.350388e-003, 2.353308e-003, 2.356230e-003, 2.359154e-003, 2.362081e-003, 2.365011e-003, 2.367943e-003, 2.370877e-003, 2.373814e-003, 2.376753e-003, 2.379694e-003, 2.382638e-003, 2.385584e-003, 2.388533e-003, 2.391484e-003, 2.394438e-003, 2.397394e-003, 2.400353e-003, 2.403314e-003, 2.406277e-003, 2.409243e-003, 2.412211e-003, 2.415182e-003, 2.418155e-003, 2.421131e-003, 2.424109e-003, 2.427089e-003, 2.430072e-003, 2.433057e-003, 2.436045e-003, 2.439035e-003, 2.442028e-003, 2.445023e-003, 2.448021e-003, 2.451021e-003, 2.454023e-003, 2.457028e-003, 2.460036e-003, 2.463045e-003, 2.466058e-003, 2.469072e-003, 2.472090e-003, 2.475109e-003, 2.478131e-003, 2.481156e-003, 2.484183e-003, 2.487213e-003, 2.490244e-003, 2.493279e-003, 2.496316e-003, 2.499355e-003, 2.502397e-003, 2.505441e-003, 2.508488e-003, 2.511537e-003, 2.514589e-003, 2.517643e-003, 2.520700e-003, 2.523759e-003, 2.526820e-003, 2.529884e-003, 2.532951e-003, 2.536020e-003, 2.539091e-003, 2.542165e-003, 2.545242e-003, 2.548321e-003, 2.551402e-003, 2.554486e-003, 2.557572e-003, 2.560661e-003, 2.563753e-003, 2.566846e-003, 2.569943e-003, 2.573042e-003, 2.576143e-003, 2.579247e-003, 2.582353e-003, 2.585462e-003, 2.588573e-003, 2.591687e-003, 2.594803e-003, 2.597922e-003, 2.601043e-003, 
2.604167e-003, 2.607293e-003, 2.610422e-003, 2.613553e-003, 2.616687e-003, 2.619823e-003, 2.622962e-003, 2.626103e-003, 2.629247e-003, 2.632393e-003, 2.635542e-003, 2.638693e-003, 2.641847e-003, 2.645003e-003, 2.648162e-003, 2.651323e-003, 2.654487e-003, 2.657654e-003, 2.660823e-003, 2.663994e-003, 2.667168e-003, 2.670344e-003, 2.673523e-003, 2.676705e-003, 2.679889e-003, 2.683076e-003, 2.686265e-003, 2.689456e-003, 2.692650e-003, 2.695847e-003, 2.699046e-003, 2.702248e-003, 2.705452e-003, 2.708659e-003, 2.711868e-003, 2.715080e-003, 2.718294e-003, 2.721511e-003, 2.724731e-003, 2.727953e-003, 2.731177e-003, 2.734404e-003, 2.737634e-003, 2.740866e-003, 2.744101e-003, 2.747338e-003, 2.750578e-003, 2.753820e-003, 2.757065e-003, 2.760313e-003, 2.763563e-003, 2.766815e-003, 2.770070e-003, 2.773328e-003, 2.776588e-003, 2.779851e-003, 2.783116e-003, 2.786384e-003, 2.789654e-003, 2.792927e-003, 2.796203e-003, 2.799481e-003, 2.802761e-003, 2.806045e-003, 2.809330e-003, 2.812619e-003, 2.815910e-003, 2.819203e-003, 2.822499e-003, 2.825798e-003, 2.829099e-003, 2.832403e-003, 2.835709e-003, 2.839018e-003, 2.842329e-003, 2.845643e-003, 2.848960e-003, 2.852279e-003, 2.855601e-003, 2.858925e-003, 2.862252e-003, 2.865581e-003, 2.868914e-003, 2.872248e-003, 2.875585e-003, 2.878925e-003, 2.882268e-003, 2.885613e-003, 2.888960e-003, 2.892310e-003, 2.895663e-003, 2.899019e-003, 2.902376e-003, 2.905737e-003, 2.909100e-003, 2.912466e-003, 2.915834e-003, 2.919205e-003, 2.922579e-003, 2.925955e-003, 
2.929333e-003, 2.932715e-003, 2.936099e-003, 2.939485e-003, 2.942874e-003, 2.946266e-003, 2.949660e-003, 2.953057e-003, 2.956457e-003, 2.959859e-003, 2.963264e-003, 2.966671e-003, 2.970081e-003, 2.973493e-003, 2.976909e-003, 2.980326e-003, 2.983747e-003, 2.987170e-003, 2.990596e-003, 2.994024e-003, 2.997455e-003, 3.000888e-003, 3.004324e-003, 3.007763e-003, 3.011204e-003, 3.014648e-003, 3.018095e-003, 3.021544e-003, 3.024996e-003, 3.028451e-003, 3.031908e-003, 3.035368e-003, 3.038830e-003, 3.042295e-003, 3.045763e-003, 3.049233e-003, 3.052706e-003, 3.056181e-003, 3.059660e-003, 3.063141e-003, 3.066624e-003, 3.070110e-003, 3.073599e-003, 3.077090e-003, 3.080584e-003, 3.084081e-003, 3.087580e-003, 3.091082e-003, 3.094587e-003, 3.098094e-003, 3.101604e-003, 3.105117e-003, 3.108632e-003, 3.112150e-003, 3.115670e-003, 3.119194e-003, 3.122719e-003, 3.126248e-003, 3.129779e-003, 3.133313e-003, 3.136849e-003, 3.140388e-003, 3.143930e-003, 3.147475e-003, 3.151022e-003, 3.154572e-003, 3.158124e-003, 3.161679e-003, 3.165237e-003, 3.168797e-003, 3.172361e-003, 3.175926e-003, 3.179495e-003, 3.183066e-003, 3.186640e-003, 3.190216e-003, 3.193795e-003, 3.197377e-003, 3.200962e-003, 3.204549e-003, 3.208139e-003, 3.211731e-003, 3.215326e-003, 3.218924e-003, 3.222525e-003, 3.226128e-003, 3.229734e-003, 3.233343e-003, 3.236954e-003, 3.240568e-003, 3.244185e-003, 3.247804e-003, 3.251426e-003, 3.255051e-003, 3.258679e-003, 3.262309e-003, 3.265942e-003, 3.269577e-003, 3.273215e-003, 3.276856e-003, 
3.280500e-003, 3.284146e-003, 3.287795e-003, 3.291447e-003, 3.295102e-003, 3.298759e-003, 3.302419e-003, 3.306081e-003, 3.309746e-003, 3.313414e-003, 3.317085e-003, 3.320759e-003, 3.324435e-003, 3.328114e-003, 3.331795e-003, 3.335479e-003, 3.339166e-003, 3.342856e-003, 3.346548e-003, 3.350243e-003, 3.353941e-003, 3.357642e-003, 3.361345e-003, 3.365051e-003, 3.368760e-003, 3.372471e-003, 3.376186e-003, 3.379902e-003, 3.383622e-003, 3.387344e-003, 3.391070e-003, 3.394797e-003, 3.398528e-003, 3.402261e-003, 3.405997e-003, 3.409736e-003, 3.413477e-003, 3.417222e-003, 3.420969e-003, 3.424718e-003, 3.428471e-003, 3.432226e-003, 3.435984e-003, 3.439744e-003, 3.443508e-003, 3.447274e-003, 3.451043e-003, 3.454814e-003, 3.458589e-003, 3.462366e-003, 3.466146e-003, 3.469928e-003, 3.473714e-003, 3.477502e-003, 3.481293e-003, 3.485086e-003, 3.488883e-003, 3.492682e-003, 3.496484e-003, 3.500289e-003, 3.504096e-003, 3.507906e-003, 3.511719e-003, 3.515535e-003, 3.519353e-003, 3.523175e-003, 3.526999e-003, 3.530825e-003, 3.534655e-003, 3.538487e-003, 3.542322e-003, 3.546160e-003, 3.550001e-003, 3.553844e-003, 3.557690e-003, 3.561539e-003, 3.565391e-003, 3.569245e-003, 3.573102e-003, 3.576963e-003, 3.580825e-003, 3.584691e-003, 3.588559e-003, 3.592430e-003, 3.596304e-003, 3.600181e-003, 3.604061e-003, 3.607943e-003, 3.611828e-003, 3.615716e-003, 3.619607e-003, 3.623500e-003, 3.627396e-003, 3.631295e-003, 3.635197e-003, 3.639102e-003, 3.643009e-003, 3.646919e-003, 3.650832e-003, 3.654748e-003, 
3.658667e-003, 3.662588e-003, 3.666512e-003, 3.670439e-003, 3.674369e-003, 3.678302e-003, 3.682237e-003, 3.686175e-003, 3.690116e-003, 3.694060e-003, 3.698007e-003, 3.701956e-003, 3.705909e-003, 3.709864e-003, 3.713822e-003, 3.717782e-003, 3.721746e-003, 3.725712e-003, 3.729681e-003, 3.733653e-003, 3.737628e-003, 3.741606e-003, 3.745586e-003, 3.749569e-003, 3.753555e-003, 3.757544e-003, 3.761536e-003, 3.765531e-003, 3.769528e-003, 3.773528e-003, 3.777531e-003, 3.781537e-003, 3.785546e-003, 3.789557e-003, 3.793572e-003, 3.797589e-003, 3.801609e-003, 3.805632e-003, 3.809657e-003, 3.813686e-003, 3.817717e-003, 3.821752e-003, 3.825789e-003, 3.829829e-003, 3.833871e-003, 3.837917e-003, 3.841965e-003, 3.846017e-003, 3.850071e-003, 3.854128e-003, 3.858187e-003, 3.862250e-003, 3.866316e-003, 3.870384e-003, 3.874455e-003, 3.878529e-003, 3.882606e-003, 3.886686e-003, 3.890769e-003, 3.894854e-003, 3.898943e-003, 3.903034e-003, 3.907128e-003, 3.911225e-003, 3.915325e-003, 3.919427e-003, 3.923533e-003, 3.927641e-003, 3.931753e-003, 3.935867e-003, 3.939984e-003, 3.944104e-003, 3.948226e-003, 3.952352e-003, 3.956481e-003, 3.960612e-003, 3.964746e-003, 3.968883e-003, 3.973023e-003, 3.977166e-003, 3.981312e-003, 3.985461e-003, 3.989612e-003, 3.993767e-003, 3.997924e-003, 4.002084e-003, 4.006247e-003, 4.010413e-003, 4.014582e-003, 4.018754e-003, 4.022928e-003, 4.027106e-003, 4.031286e-003, 4.035469e-003, 4.039655e-003, 4.043845e-003, 4.048037e-003, 4.052231e-003, 4.056429e-003, 4.060630e-003, 
4.064833e-003, 4.069040e-003, 4.073249e-003, 4.077461e-003, 4.081677e-003, 4.085895e-003, 4.090116e-003, 4.094339e-003, 4.098566e-003, 4.102796e-003, 4.107028e-003, 4.111264e-003, 4.115502e-003, 4.119744e-003, 4.123988e-003, 4.128235e-003, 4.132485e-003, 4.136738e-003, 4.140994e-003, 4.145253e-003, 4.149515e-003, 4.153779e-003, 4.158047e-003, 4.162317e-003, 4.166591e-003, 4.170867e-003, 4.175146e-003, 4.179429e-003, 4.183714e-003, 4.188002e-003, 4.192293e-003, 4.196587e-003, 4.200884e-003, 4.205183e-003, 4.209486e-003, 4.213792e-003, 4.218100e-003, 4.222412e-003, 4.226726e-003, 4.231044e-003, 4.235364e-003, 4.239687e-003, 4.244013e-003, 4.248343e-003, 4.252675e-003, 4.257010e-003, 4.261348e-003, 4.265689e-003, 4.270033e-003, 4.274379e-003, 4.278729e-003, 4.283082e-003, 4.287438e-003, 4.291796e-003, 4.296158e-003, 4.300522e-003, 4.304890e-003, 4.309260e-003, 4.313634e-003, 4.318010e-003, 4.322389e-003, 4.326772e-003, 4.331157e-003, 4.335545e-003, 4.339936e-003, 4.344330e-003, 4.348727e-003, 4.353128e-003, 4.357531e-003, 4.361937e-003, 4.366345e-003, 4.370757e-003, 4.375172e-003, 4.379590e-003, 4.384011e-003, 4.388435e-003, 4.392862e-003, 4.397291e-003, 4.401724e-003, 4.406160e-003, 4.410599e-003, 4.415040e-003, 4.419485e-003, 4.423933e-003, 4.428383e-003, 4.432837e-003, 4.437294e-003, 4.441753e-003, 4.446216e-003, 4.450681e-003, 4.455150e-003, 4.459621e-003, 4.464096e-003, 4.468573e-003, 4.473054e-003, 4.477537e-003, 4.482024e-003, 4.486513e-003, 4.491006e-003, 4.495501e-003, 
4.500000e-003, 4.504502e-003, 4.509006e-003, 4.513514e-003, 4.518024e-003, 4.522538e-003, 4.527054e-003, 4.531574e-003, 4.536096e-003, 4.540622e-003, 4.545150e-003, 4.549682e-003, 4.554216e-003, 4.558754e-003, 4.563294e-003, 4.567838e-003, 4.572385e-003, 4.576934e-003, 4.581487e-003, 4.586043e-003, 4.590601e-003, 4.595163e-003, 4.599728e-003, 4.604296e-003, 4.608866e-003, 4.613440e-003, 4.618017e-003, 4.622597e-003, 4.627180e-003, 4.631766e-003, 4.636354e-003, 4.640946e-003, 4.645541e-003, 4.650139e-003, 4.654741e-003, 4.659345e-003, 4.663952e-003, 4.668562e-003, 4.673175e-003, 4.677791e-003, 4.682411e-003, 4.687033e-003, 4.691658e-003, 4.696287e-003, 4.700918e-003, 4.705553e-003, 4.710190e-003, 4.714831e-003, 4.719474e-003, 4.724121e-003, 4.728771e-003, 4.733424e-003, 4.738079e-003, 4.742738e-003, 4.747400e-003, 4.752065e-003, 4.756733e-003, 4.761404e-003, 4.766079e-003, 4.770756e-003, 4.775436e-003, 4.780119e-003, 4.784806e-003, 4.789495e-003, 4.794188e-003, 4.798883e-003, 4.803582e-003, 4.808284e-003, 4.812988e-003, 4.817696e-003, 4.822407e-003, 4.827121e-003, 4.831838e-003, 4.836558e-003, 4.841282e-003, 4.846008e-003, 4.850737e-003, 4.855470e-003, 4.860205e-003, 4.864944e-003, 4.869685e-003, 4.874430e-003, 4.879178e-003, 4.883929e-003, 4.888683e-003, 4.893440e-003, 4.898200e-003, 4.902963e-003, 4.907730e-003, 4.912499e-003, 4.917271e-003, 4.922047e-003, 4.926826e-003, 4.931608e-003, 4.936392e-003, 4.941180e-003, 4.945971e-003, 4.950766e-003, 4.955563e-003, 4.960363e-003, 
4.965167e-003, 4.969973e-003, 4.974783e-003, 4.979596e-003, 4.984411e-003, 4.989230e-003, 4.994053e-003, 4.998878e-003, 5.003706e-003, 5.008537e-003, 5.013372e-003, 5.018209e-003, 5.023050e-003, 5.027894e-003, 5.032741e-003, 5.037591e-003, 5.042444e-003, 5.047300e-003, 5.052160e-003, 5.057022e-003, 5.061888e-003, 5.066757e-003, 5.071629e-003, 5.076504e-003, 5.081382e-003, 5.086263e-003, 5.091147e-003, 5.096035e-003, 5.100926e-003, 5.105819e-003, 5.110716e-003, 5.115616e-003, 5.120519e-003, 5.125426e-003, 5.130335e-003, 5.135248e-003, 5.140163e-003, 5.145082e-003, 5.150004e-003, 5.154929e-003, 5.159857e-003, 5.164789e-003, 5.169723e-003, 5.174661e-003, 5.179602e-003, 5.184546e-003, 5.189493e-003, 5.194443e-003, 5.199396e-003, 5.204353e-003, 5.209313e-003, 5.214275e-003, 5.219241e-003, 5.224210e-003, 5.229183e-003, 5.234158e-003, 5.239137e-003, 5.244118e-003, 5.249103e-003, 5.254091e-003, 5.259083e-003, 5.264077e-003, 5.269075e-003, 5.274075e-003, 5.279079e-003, 5.284086e-003, 5.289096e-003, 5.294110e-003, 5.299126e-003, 5.304146e-003, 5.309169e-003, 5.314195e-003, 5.319224e-003, 5.324256e-003, 5.329292e-003, 5.334331e-003, 5.339373e-003, 5.344418e-003, 5.349466e-003, 5.354517e-003, 5.359572e-003, 5.364630e-003, 5.369691e-003, 5.374755e-003, 5.379822e-003, 5.384893e-003, 5.389966e-003, 5.395043e-003, 5.400123e-003, 5.405207e-003, 5.410293e-003, 5.415383e-003, 5.420476e-003, 5.425572e-003, 5.430671e-003, 5.435773e-003, 5.440879e-003, 5.445988e-003, 5.451100e-003, 5.456215e-003, 
5.461333e-003, 5.466455e-003, 5.471580e-003, 5.476708e-003, 5.481839e-003, 5.486973e-003, 5.492111e-003, 5.497252e-003, 5.502396e-003, 5.507543e-003, 5.512693e-003, 5.517847e-003, 5.523004e-003, 5.528164e-003, 5.533327e-003, 5.538494e-003, 5.543664e-003, 5.548837e-003, 5.554013e-003, 5.559192e-003, 5.564375e-003, 5.569560e-003, 5.574750e-003, 5.579942e-003, 5.585137e-003, 5.590336e-003, 5.595538e-003, 5.600743e-003, 5.605951e-003, 5.611163e-003, 5.616378e-003, 5.621596e-003, 5.626817e-003, 5.632042e-003, 5.637269e-003, 5.642500e-003, 5.647735e-003, 5.652972e-003, 5.658213e-003, 5.663457e-003, 5.668704e-003, 5.673954e-003, 5.679208e-003, 5.684465e-003, 5.689725e-003, 5.694989e-003, 5.700255e-003, 5.705525e-003, 5.710798e-003, 5.716075e-003, 5.721354e-003, 5.726637e-003, 5.731923e-003, 5.737213e-003, 5.742505e-003, 5.747801e-003, 5.753100e-003, 5.758403e-003, 5.763708e-003, 5.769017e-003, 5.774329e-003, 5.779645e-003, 5.784963e-003, 5.790285e-003, 5.795611e-003, 5.800939e-003, 5.806271e-003, 5.811606e-003, 5.816944e-003, 5.822286e-003, 5.827631e-003, 5.832979e-003, 5.838330e-003, 5.843685e-003, 5.849042e-003, 5.854404e-003, 5.859768e-003, 5.865136e-003, 5.870507e-003, 5.875881e-003, 5.881259e-003, 5.886640e-003, 5.892024e-003, 5.897411e-003, 5.902802e-003, 5.908196e-003, 5.913593e-003, 5.918993e-003, 5.924397e-003, 5.929804e-003, 5.935215e-003, 5.940629e-003, 5.946046e-003, 5.951466e-003, 5.956889e-003, 5.962316e-003, 5.967746e-003, 5.973180e-003, 5.978617e-003, 5.984057e-003, 
5.989500e-003, 5.994947e-003, 6.000397e-003, 6.005850e-003, 6.011306e-003, 6.016766e-003, 6.022229e-003, 6.027696e-003, 6.033166e-003, 6.038639e-003, 6.044115e-003, 6.049595e-003, 6.055078e-003, 6.060564e-003, 6.066054e-003, 6.071547e-003, 6.077043e-003, 6.082543e-003, 6.088046e-003, 6.093552e-003, 6.099061e-003, 6.104574e-003, 6.110090e-003, 6.115610e-003, 6.121133e-003, 6.126659e-003, 6.132188e-003, 6.137721e-003, 6.143257e-003, 6.148797e-003, 6.154340e-003, 6.159886e-003, 6.165435e-003, 6.170988e-003, 6.176544e-003, 6.182103e-003, 6.187666e-003, 6.193232e-003, 6.198802e-003, 6.204375e-003, 6.209951e-003, 6.215530e-003, 6.221113e-003, 6.226699e-003, 6.232289e-003, 6.237881e-003, 6.243478e-003, 6.249077e-003, 6.254680e-003, 6.260286e-003, 6.265896e-003, 6.271509e-003, 6.277125e-003, 6.282745e-003, 6.288368e-003, 6.293994e-003, 6.299624e-003, 6.305257e-003, 6.310893e-003, 6.316533e-003, 6.322176e-003, 6.327822e-003, 6.333472e-003, 6.339126e-003, 6.344782e-003, 6.350442e-003, 6.356105e-003, 6.361772e-003, 6.367442e-003, 6.373115e-003, 6.378792e-003, 6.384472e-003, 6.390156e-003, 6.395843e-003, 6.401533e-003, 6.407227e-003, 6.412924e-003, 6.418624e-003, 6.424328e-003, 6.430035e-003, 6.435745e-003, 6.441459e-003, 6.447176e-003, 6.452897e-003, 6.458621e-003, 6.464349e-003, 6.470079e-003, 6.475814e-003, 6.481551e-003, 6.487292e-003, 6.493037e-003, 6.498784e-003, 6.504535e-003, 6.510290e-003, 6.516048e-003, 6.521809e-003, 6.527574e-003, 6.533342e-003, 6.539113e-003, 6.544888e-003, 
6.550667e-003, 6.556448e-003, 6.562233e-003, 6.568022e-003, 6.573814e-003, 6.579609e-003, 6.585408e-003, 6.591210e-003, 6.597016e-003, 6.602824e-003, 6.608637e-003, 6.614453e-003, 6.620272e-003, 6.626094e-003, 6.631920e-003, 6.637750e-003, 6.643583e-003, 6.649419e-003, 6.655258e-003, 6.661102e-003, 6.666948e-003, 6.672798e-003, 6.678651e-003, 6.684508e-003, 6.690368e-003, 6.696232e-003, 6.702099e-003, 6.707969e-003, 6.713843e-003, 6.719720e-003, 6.725601e-003, 6.731485e-003, 6.737373e-003, 6.743264e-003, 6.749158e-003, 6.755056e-003, 6.760958e-003, 6.766862e-003, 6.772771e-003, 6.778682e-003, 6.784597e-003, 6.790516e-003, 6.796438e-003, 6.802363e-003, 6.808292e-003, 6.814224e-003, 6.820160e-003, 6.826099e-003, 6.832042e-003, 6.837988e-003, 6.843937e-003, 6.849890e-003, 6.855847e-003, 6.861807e-003, 6.867770e-003, 6.873737e-003, 6.879707e-003, 6.885681e-003, 6.891658e-003, 6.897639e-003, 6.903623e-003, 6.909610e-003, 6.915601e-003, 6.921596e-003, 6.927594e-003, 6.933595e-003, 6.939600e-003, 6.945608e-003, 6.951620e-003, 6.957635e-003, 6.963654e-003, 6.969676e-003, 6.975702e-003, 6.981731e-003, 6.987763e-003, 6.993799e-003, 6.999839e-003, 7.005882e-003, 7.011929e-003, 7.017979e-003, 7.024032e-003, 7.030089e-003, 7.036149e-003, 7.042213e-003, 7.048281e-003, 7.054352e-003, 7.060426e-003, 7.066504e-003, 7.072585e-003, 7.078670e-003, 7.084758e-003, 7.090850e-003, 7.096945e-003, 7.103044e-003, 7.109146e-003, 7.115252e-003, 7.121361e-003, 7.127474e-003, 7.133590e-003, 7.139710e-003, 
7.145833e-003, 7.151960e-003, 7.158090e-003, 7.164224e-003, 7.170361e-003, 7.176502e-003, 7.182646e-003, 7.188794e-003, 7.194945e-003, 7.201100e-003, 7.207258e-003, 7.213420e-003, 7.219586e-003, 7.225754e-003, 7.231927e-003, 7.238103e-003, 7.244282e-003, 7.250465e-003, 7.256651e-003, 7.262841e-003, 7.269035e-003, 7.275232e-003, 7.281432e-003, 7.287636e-003, 7.293844e-003, 7.300055e-003, 7.306269e-003, 7.312487e-003, 7.318709e-003, 7.324934e-003, 7.331163e-003, 7.337395e-003, 7.343631e-003, 7.349870e-003, 7.356113e-003, 7.362359e-003, 7.368609e-003, 7.374863e-003, 7.381119e-003, 7.387380e-003, 7.393644e-003, 7.399912e-003, 7.406183e-003, 7.412457e-003, 7.418736e-003, 7.425017e-003, 7.431303e-003, 7.437591e-003, 7.443884e-003, 7.450180e-003, 7.456479e-003, 7.462782e-003, 7.469089e-003, 7.475399e-003, 7.481713e-003, 7.488030e-003, 7.494351e-003, 7.500675e-003, 7.507003e-003, 7.513334e-003, 7.519669e-003, 7.526008e-003, 7.532350e-003, 7.538696e-003, 7.545045e-003, 7.551398e-003, 7.557754e-003, 7.564114e-003, 7.570478e-003, 7.576845e-003, 7.583215e-003, 7.589590e-003, 7.595968e-003, 7.602349e-003, 7.608734e-003, 7.615122e-003, 7.621514e-003, 7.627910e-003, 7.634309e-003, 7.640712e-003, 7.647119e-003, 7.653529e-003, 7.659942e-003, 7.666359e-003, 7.672780e-003, 7.679204e-003, 7.685632e-003, 7.692064e-003, 7.698499e-003, 7.704938e-003, 7.711380e-003, 7.717826e-003, 7.724275e-003, 7.730728e-003, 7.737185e-003, 7.743645e-003, 7.750109e-003, 7.756576e-003, 7.763047e-003, 7.769522e-003, 
7.776000e-003, 7.782482e-003, 7.788967e-003, 7.795456e-003, 7.801949e-003, 7.808445e-003, 7.814945e-003, 7.821448e-003, 7.827955e-003, 7.834466e-003, 7.840980e-003, 7.847498e-003, 7.854019e-003, 7.860545e-003, 7.867073e-003, 7.873606e-003, 7.880141e-003, 7.886681e-003, 7.893224e-003, 7.899771e-003, 7.906321e-003, 7.912875e-003, 7.919433e-003, 7.925994e-003, 7.932559e-003, 7.939128e-003, 7.945700e-003, 7.952275e-003, 7.958855e-003, 7.965438e-003, 7.972024e-003, 7.978615e-003, 7.985209e-003, 7.991806e-003, 7.998407e-003, 8.005012e-003, 8.011621e-003, 8.018233e-003, 8.024848e-003, 8.031468e-003, 8.038091e-003, 8.044717e-003, 8.051348e-003, 8.057981e-003, 8.064619e-003, 8.071260e-003, 8.077905e-003, 8.084554e-003, 8.091206e-003, 8.097861e-003, 8.104521e-003, 8.111184e-003, 8.117851e-003, 8.124521e-003, 8.131195e-003, 8.137873e-003, 8.144554e-003, 8.151239e-003, 8.157928e-003, 8.164620e-003, 8.171316e-003, 8.178016e-003, 8.184719e-003, 8.191426e-003, 8.198136e-003, 8.204851e-003, 8.211569e-003, 8.218290e-003, 8.225016e-003, 8.231745e-003, 8.238477e-003, 8.245213e-003, 8.251953e-003, 8.258697e-003, 8.265444e-003, 8.272195e-003, 8.278950e-003, 8.285708e-003, 8.292470e-003, 8.299236e-003, 8.306005e-003, 8.312778e-003, 8.319555e-003, 8.326335e-003, 8.333120e-003, 8.339907e-003, 8.346699e-003, 8.353494e-003, 8.360293e-003, 8.367095e-003, 8.373902e-003, 8.380711e-003, 8.387525e-003, 8.394342e-003, 8.401163e-003, 8.407988e-003, 8.414816e-003, 8.421648e-003, 8.428484e-003, 8.435324e-003, 
8.442167e-003, 8.449014e-003, 8.455864e-003, 8.462718e-003, 8.469576e-003, 8.476438e-003, 8.483303e-003, 8.490172e-003, 8.497045e-003, 8.503922e-003, 8.510802e-003, 8.517686e-003, 8.524573e-003, 8.531465e-003, 8.538360e-003, 8.545258e-003, 8.552161e-003, 8.559067e-003, 8.565977e-003, 8.572891e-003, 8.579808e-003, 8.586729e-003, 8.593654e-003, 8.600582e-003, 8.607515e-003, 8.614451e-003, 8.621390e-003, 8.628334e-003, 8.635281e-003, 8.642232e-003, 8.649186e-003, 8.656144e-003, 8.663107e-003, 8.670072e-003, 8.677042e-003, 8.684015e-003, 8.690992e-003, 8.697973e-003, 8.704957e-003, 8.711945e-003, 8.718937e-003, 8.725933e-003, 8.732932e-003, 8.739936e-003, 8.746942e-003, 8.753953e-003, 8.760967e-003, 8.767986e-003, 8.775007e-003, 8.782033e-003, 8.789063e-003, 8.796096e-003, 8.803133e-003, 8.810173e-003, 8.817218e-003, 8.824266e-003, 8.831318e-003, 8.838373e-003, 8.845433e-003, 8.852496e-003, 8.859563e-003, 8.866633e-003, 8.873708e-003, 8.880786e-003, 8.887868e-003, 8.894954e-003, 8.902043e-003, 8.909136e-003, 8.916233e-003, 8.923334e-003, 8.930439e-003, 8.937547e-003, 8.944659e-003, 8.951775e-003, 8.958895e-003, 8.966018e-003, 8.973145e-003, 8.980276e-003, 8.987411e-003, 8.994550e-003, 9.001692e-003, 9.008838e-003, 9.015988e-003, 9.023142e-003, 9.030299e-003, 9.037460e-003, 9.044625e-003, 9.051794e-003, 9.058967e-003, 9.066143e-003, 9.073323e-003, 9.080507e-003, 9.087695e-003, 9.094886e-003, 9.102082e-003, 9.109281e-003, 9.116484e-003, 9.123690e-003, 9.130901e-003, 9.138115e-003, 
9.145333e-003, 9.152555e-003, 9.159781e-003, 9.167010e-003, 9.174244e-003, 9.181481e-003, 9.188722e-003, 9.195966e-003, 9.203215e-003, 9.210467e-003, 9.217724e-003, 9.224983e-003, 9.232247e-003, 9.239515e-003, 9.246786e-003, 9.254061e-003, 9.261340e-003, 9.268623e-003, 9.275910e-003, 9.283200e-003, 9.290495e-003, 9.297793e-003, 9.305095e-003, 9.312400e-003, 9.319710e-003, 9.327023e-003, 9.334341e-003, 9.341662e-003, 9.348987e-003, 9.356315e-003, 9.363648e-003, 9.370984e-003, 9.378324e-003, 9.385668e-003, 9.393016e-003, 9.400368e-003, 9.407724e-003, 9.415083e-003, 9.422446e-003, 9.429813e-003, 9.437184e-003, 9.444559e-003, 9.451937e-003, 9.459320e-003, 9.466706e-003, 9.474096e-003, 9.481490e-003, 9.488888e-003, 9.496289e-003, 9.503695e-003, 9.511104e-003, 9.518517e-003, 9.525934e-003, 9.533355e-003, 9.540780e-003, 9.548209e-003, 9.555641e-003, 9.563077e-003, 9.570517e-003, 9.577961e-003, 9.585409e-003, 9.592861e-003, 9.600317e-003, 9.607776e-003, 9.615239e-003, 9.622707e-003, 9.630178e-003, 9.637653e-003, 9.645131e-003, 9.652614e-003, 9.660101e-003, 9.667591e-003, 9.675085e-003, 9.682583e-003, 9.690085e-003, 9.697591e-003, 9.705101e-003, 9.712615e-003, 9.720132e-003, 9.727653e-003, 9.735179e-003, 9.742708e-003, 9.750241e-003, 9.757778e-003, 9.765319e-003, 9.772863e-003, 9.780412e-003, 9.787964e-003, 9.795521e-003, 9.803081e-003, 9.810645e-003, 9.818213e-003, 9.825785e-003, 9.833360e-003, 9.840940e-003, 9.848524e-003, 9.856111e-003, 9.863703e-003, 9.871298e-003, 9.878897e-003, 
9.886500e-003, 9.894107e-003, 9.901718e-003, 9.909333e-003, 9.916951e-003, 9.924574e-003, 9.932200e-003, 9.939831e-003, 9.947465e-003, 9.955103e-003, 9.962745e-003, 9.970391e-003, 9.978041e-003, 9.985695e-003, 9.993353e-003, 1.000101e-002, 1.000868e-002, 1.001635e-002, 1.002402e-002, 1.003170e-002, 1.003938e-002, 1.004707e-002, 1.005476e-002, 1.006245e-002, 1.007015e-002, 1.007785e-002, 1.008555e-002, 1.009326e-002, 1.010097e-002, 1.010869e-002, 1.011641e-002, 1.012413e-002, 1.013186e-002, 1.013959e-002, 1.014733e-002, 1.015507e-002, 1.016281e-002, 1.017056e-002, 1.017831e-002, 1.018607e-002, 1.019383e-002, 1.020159e-002, 1.020936e-002, 1.021713e-002, 1.022491e-002, 1.023269e-002, 1.024047e-002, 1.024826e-002, 1.025605e-002, 1.026385e-002, 1.027165e-002, 1.027945e-002, 1.028726e-002, 1.029507e-002, 1.030288e-002, 1.031070e-002, 1.031852e-002, 1.032635e-002, 1.033418e-002, 1.034202e-002, 1.034986e-002, 1.035770e-002, 1.036555e-002, 1.037340e-002, 1.038125e-002, 1.038911e-002, 1.039697e-002, 1.040484e-002, 1.041271e-002, 1.042058e-002, 1.042846e-002, 1.043634e-002, 1.044423e-002, 1.045212e-002, 1.046002e-002, 1.046791e-002, 1.047582e-002, 1.048372e-002, 1.049163e-002, 1.049955e-002, 1.050747e-002, 1.051539e-002, 1.052331e-002, 1.053124e-002, 1.053918e-002, 1.054712e-002, 1.055506e-002, 1.056300e-002, 1.057095e-002, 1.057891e-002, 1.058687e-002, 1.059483e-002, 1.060279e-002, 1.061076e-002, 1.061874e-002, 1.062672e-002, 1.063470e-002, 1.064268e-002, 1.065067e-002, 1.065867e-002, 
1.066667e-002, 1.067467e-002, 1.068267e-002, 1.069068e-002, 1.069870e-002, 1.070672e-002, 1.071474e-002, 1.072276e-002, 1.073079e-002, 1.073883e-002, 1.074687e-002, 1.075491e-002, 1.076295e-002, 1.077101e-002, 1.077906e-002, 1.078712e-002, 1.079518e-002, 1.080325e-002, 1.081132e-002, 1.081939e-002, 1.082747e-002, 1.083555e-002, 1.084364e-002, 1.085173e-002, 1.085982e-002, 1.086792e-002, 1.087602e-002, 1.088413e-002, 1.089224e-002, 1.090035e-002, 1.090847e-002, 1.091659e-002, 1.092472e-002, 1.093285e-002, 1.094099e-002, 1.094912e-002, 1.095727e-002, 1.096541e-002, 1.097356e-002, 1.098172e-002, 1.098988e-002, 1.099804e-002, 1.100621e-002, 1.101438e-002, 1.102255e-002, 1.103073e-002, 1.103891e-002, 1.104710e-002, 1.105529e-002, 1.106349e-002, 1.107169e-002, 1.107989e-002, 1.108810e-002, 1.109631e-002, 1.110452e-002, 1.111274e-002, 1.112097e-002, 1.112920e-002, 1.113743e-002, 1.114566e-002, 1.115390e-002, 1.116215e-002, 1.117039e-002, 1.117865e-002, 1.118690e-002, 1.119516e-002, 1.120343e-002, 1.121169e-002, 1.121997e-002, 1.122824e-002, 1.123652e-002, 1.124481e-002, 1.125310e-002, 1.126139e-002, 1.126969e-002, 1.127799e-002, 1.128629e-002, 1.129460e-002, 1.130291e-002, 1.131123e-002, 1.131955e-002, 1.132788e-002, 1.133621e-002, 1.134454e-002, 1.135288e-002, 1.136122e-002, 1.136956e-002, 1.137791e-002, 1.138627e-002, 1.139463e-002, 1.140299e-002, 1.141135e-002, 1.141972e-002, 1.142810e-002, 1.143648e-002, 1.144486e-002, 1.145325e-002, 1.146164e-002, 1.147003e-002, 1.147843e-002, 
1.148683e-002, 1.149524e-002, 1.150365e-002, 1.151207e-002, 1.152049e-002, 1.152891e-002, 1.153734e-002, 1.154577e-002, 1.155420e-002, 1.156264e-002, 1.157109e-002, 1.157954e-002, 1.158799e-002, 1.159645e-002, 1.160491e-002, 1.161337e-002, 1.162184e-002, 1.163031e-002, 1.163879e-002, 1.164727e-002, 1.165575e-002, 1.166424e-002, 1.167274e-002, 1.168123e-002, 1.168974e-002, 1.169824e-002, 1.170675e-002, 1.171527e-002, 1.172378e-002, 1.173231e-002, 1.174083e-002, 1.174936e-002, 1.175790e-002, 1.176644e-002, 1.177498e-002, 1.178353e-002, 1.179208e-002, 1.180063e-002, 1.180919e-002, 1.181776e-002, 1.182632e-002, 1.183490e-002, 1.184347e-002, 1.185205e-002, 1.186064e-002, 1.186922e-002, 1.187782e-002, 1.188641e-002, 1.189501e-002, 1.190362e-002, 1.191223e-002, 1.192084e-002, 1.192946e-002, 1.193808e-002, 1.194671e-002, 1.195534e-002, 1.196397e-002, 1.197261e-002, 1.198125e-002, 1.198990e-002, 1.199855e-002, 1.200720e-002, 1.201586e-002, 1.202453e-002, 1.203319e-002, 1.204187e-002, 1.205054e-002, 1.205922e-002, 1.206790e-002, 1.207659e-002, 1.208529e-002, 1.209398e-002, 1.210268e-002, 1.211139e-002, 1.212010e-002, 1.212881e-002, 1.213753e-002, 1.214625e-002, 1.215497e-002, 1.216370e-002, 1.217244e-002, 1.218118e-002, 1.218992e-002, 1.219867e-002, 1.220742e-002, 1.221617e-002, 1.222493e-002, 1.223369e-002, 1.224246e-002, 1.225123e-002, 1.226001e-002, 1.226879e-002, 1.227757e-002, 1.228636e-002, 1.229516e-002, 1.230395e-002, 1.231275e-002, 1.232156e-002, 1.233037e-002, 1.233918e-002, 
1.234800e-002, 1.235682e-002, 1.236565e-002, 1.237448e-002, 1.238331e-002, 1.239215e-002, 1.240100e-002, 1.240984e-002, 1.241869e-002, 1.242755e-002, 1.243641e-002, 1.244527e-002, 1.245414e-002, 1.246302e-002, 1.247189e-002, 1.248077e-002, 1.248966e-002, 1.249855e-002, 1.250744e-002, 1.251634e-002, 1.252524e-002, 1.253415e-002, 1.254306e-002, 1.255197e-002, 1.256089e-002, 1.256982e-002, 1.257874e-002, 1.258767e-002, 1.259661e-002, 1.260555e-002, 1.261449e-002, 1.262344e-002, 1.263240e-002, 1.264135e-002, 1.265031e-002, 1.265928e-002, 1.266825e-002, 1.267722e-002, 1.268620e-002, 1.269518e-002, 1.270417e-002, 1.271316e-002, 1.272216e-002, 1.273116e-002, 1.274016e-002, 1.274917e-002, 1.275818e-002, 1.276720e-002, 1.277622e-002, 1.278524e-002, 1.279427e-002, 1.280330e-002, 1.281234e-002, 1.282138e-002, 1.283043e-002, 1.283948e-002, 1.284853e-002, 1.285759e-002, 1.286666e-002, 1.287572e-002, 1.288480e-002, 1.289387e-002, 1.290295e-002, 1.291204e-002, 1.292113e-002, 1.293022e-002, 1.293932e-002, 1.294842e-002, 1.295752e-002, 1.296663e-002, 1.297575e-002, 1.298487e-002, 1.299399e-002, 1.300312e-002, 1.301225e-002, 1.302138e-002, 1.303052e-002, 1.303967e-002, 1.304882e-002, 1.305797e-002, 1.306713e-002, 1.307629e-002, 1.308545e-002, 1.309462e-002, 1.310380e-002, 1.311297e-002, 1.312216e-002, 1.313134e-002, 1.314054e-002, 1.314973e-002, 1.315893e-002, 1.316814e-002, 1.317734e-002, 1.318656e-002, 1.319577e-002, 1.320500e-002, 1.321422e-002, 1.322345e-002, 1.323269e-002, 1.324192e-002, 
1.325117e-002, 1.326041e-002, 1.326967e-002, 1.327892e-002, 1.328818e-002, 1.329745e-002, 1.330671e-002, 1.331599e-002, 1.332526e-002, 1.333455e-002, 1.334383e-002, 1.335312e-002, 1.336242e-002, 1.337172e-002, 1.338102e-002, 1.339033e-002, 1.339964e-002, 1.340895e-002, 1.341827e-002, 1.342760e-002, 1.343693e-002, 1.344626e-002, 1.345560e-002, 1.346494e-002, 1.347429e-002, 1.348364e-002, 1.349299e-002, 1.350235e-002, 1.351172e-002, 1.352108e-002, 1.353046e-002, 1.353983e-002, 1.354921e-002, 1.355860e-002, 1.356799e-002, 1.357738e-002, 1.358678e-002, 1.359618e-002, 1.360559e-002, 1.361500e-002, 1.362442e-002, 1.363384e-002, 1.364326e-002, 1.365269e-002, 1.366212e-002, 1.367156e-002, 1.368100e-002, 1.369045e-002, 1.369990e-002, 1.370935e-002, 1.371881e-002, 1.372828e-002, 1.373774e-002, 1.374722e-002, 1.375669e-002, 1.376617e-002, 1.377566e-002, 1.378515e-002, 1.379464e-002, 1.380414e-002, 1.381364e-002, 1.382315e-002, 1.383266e-002, 1.384218e-002, 1.385170e-002, 1.386122e-002, 1.387075e-002, 1.388028e-002, 1.388982e-002, 1.389936e-002, 1.390891e-002, 1.391846e-002, 1.392801e-002, 1.393757e-002, 1.394714e-002, 1.395671e-002, 1.396628e-002, 1.397586e-002, 1.398544e-002, 1.399502e-002, 1.400461e-002, 1.401421e-002, 1.402381e-002, 1.403341e-002, 1.404302e-002, 1.405263e-002, 1.406224e-002, 1.407186e-002, 1.408149e-002, 1.409112e-002, 1.410075e-002, 1.411039e-002, 1.412003e-002, 1.412968e-002, 1.413933e-002, 1.414899e-002, 1.415865e-002, 1.416831e-002, 1.417798e-002, 1.418766e-002, 
1.419733e-002, 1.420702e-002, 1.421670e-002, 1.422639e-002, 1.423609e-002, 1.424579e-002, 1.425549e-002, 1.426520e-002, 1.427491e-002, 1.428463e-002, 1.429435e-002, 1.430408e-002, 1.431381e-002, 1.432355e-002, 1.433328e-002, 1.434303e-002, 1.435278e-002, 1.436253e-002, 1.437229e-002, 1.438205e-002, 1.439181e-002, 1.440159e-002, 1.441136e-002, 1.442114e-002, 1.443092e-002, 1.444071e-002, 1.445050e-002, 1.446030e-002, 1.447010e-002, 1.447991e-002, 1.448972e-002, 1.449953e-002, 1.450935e-002, 1.451918e-002, 1.452900e-002, 1.453884e-002, 1.454867e-002, 1.455851e-002, 1.456836e-002, 1.457821e-002, 1.458806e-002, 1.459792e-002, 1.460779e-002, 1.461765e-002, 1.462753e-002, 1.463740e-002, 1.464728e-002, 1.465717e-002, 1.466706e-002, 1.467696e-002, 1.468685e-002, 1.469676e-002, 1.470667e-002, 1.471658e-002, 1.472649e-002, 1.473642e-002, 1.474634e-002, 1.475627e-002, 1.476621e-002, 1.477615e-002, 1.478609e-002, 1.479604e-002, 1.480599e-002, 1.481595e-002, 1.482591e-002, 1.483587e-002, 1.484584e-002, 1.485582e-002, 1.486580e-002, 1.487578e-002, 1.488577e-002, 1.489576e-002, 1.490576e-002, 1.491576e-002, 1.492577e-002, 1.493578e-002, 1.494579e-002, 1.495581e-002, 1.496584e-002, 1.497587e-002, 1.498590e-002, 1.499594e-002, 1.500598e-002, 1.501602e-002, 1.502608e-002, 1.503613e-002, 1.504619e-002, 1.505625e-002, 1.506632e-002, 1.507640e-002, 1.508647e-002, 1.509656e-002, 1.510664e-002, 1.511674e-002, 1.512683e-002, 1.513693e-002, 1.514704e-002, 1.515715e-002, 1.516726e-002, 1.517738e-002, 
1.518750e-002, 1.519763e-002, 1.520776e-002, 1.521790e-002, 1.522804e-002, 1.523818e-002, 1.524833e-002, 1.525849e-002, 1.526864e-002, 1.527881e-002, 1.528898e-002, 1.529915e-002, 1.530932e-002, 1.531951e-002, 1.532969e-002, 1.533988e-002, 1.535008e-002, 1.536028e-002, 1.537048e-002, 1.538069e-002, 1.539090e-002, 1.540112e-002, 1.541134e-002, 1.542157e-002, 1.543180e-002, 1.544203e-002, 1.545227e-002, 1.546252e-002, 1.547277e-002, 1.548302e-002, 1.549328e-002, 1.550354e-002, 1.551381e-002, 1.552408e-002, 1.553436e-002, 1.554464e-002, 1.555492e-002, 1.556521e-002, 1.557551e-002, 1.558581e-002, 1.559611e-002, 1.560642e-002, 1.561673e-002, 1.562705e-002, 1.563737e-002, 1.564770e-002, 1.565803e-002, 1.566836e-002, 1.567870e-002, 1.568905e-002, 1.569940e-002, 1.570975e-002, 1.572011e-002, 1.573047e-002, 1.574084e-002, 1.575121e-002, 1.576159e-002, 1.577197e-002, 1.578235e-002, 1.579274e-002, 1.580314e-002, 1.581354e-002, 1.582394e-002, 1.583435e-002, 1.584476e-002, 1.585518e-002, 1.586560e-002, 1.587603e-002, 1.588646e-002, 1.589689e-002, 1.590733e-002, 1.591778e-002, 1.592823e-002, 1.593868e-002, 1.594914e-002, 1.595960e-002, 1.597007e-002, 1.598054e-002, 1.599102e-002, 1.600150e-002, 1.601199e-002, 1.602248e-002, 1.603297e-002, 1.604347e-002, 1.605397e-002, 1.606448e-002, 1.607500e-002, 1.608552e-002, 1.609604e-002, 1.610656e-002, 1.611710e-002, 1.612763e-002, 1.613817e-002, 1.614872e-002, 1.615927e-002, 1.616982e-002, 1.618038e-002, 1.619095e-002, 1.620152e-002, 1.621209e-002, 
1.622267e-002, 1.623325e-002, 1.624384e-002, 1.625443e-002, 1.626502e-002, 1.627562e-002, 1.628623e-002, 1.629684e-002, 1.630745e-002, 1.631807e-002, 1.632870e-002, 1.633933e-002, 1.634996e-002, 1.636060e-002, 1.637124e-002, 1.638188e-002, 1.639254e-002, 1.640319e-002, 1.641385e-002, 1.642452e-002, 1.643519e-002, 1.644586e-002, 1.645654e-002, 1.646723e-002, 1.647791e-002, 1.648861e-002, 1.649930e-002, 1.651001e-002, 1.652071e-002, 1.653143e-002, 1.654214e-002, 1.655286e-002, 1.656359e-002, 1.657432e-002, 1.658505e-002, 1.659579e-002, 1.660654e-002, 1.661728e-002, 1.662804e-002, 1.663879e-002, 1.664956e-002, 1.666032e-002, 1.667110e-002, 1.668187e-002, 1.669265e-002, 1.670344e-002, 1.671423e-002, 1.672502e-002, 1.673582e-002, 1.674663e-002, 1.675744e-002, 1.676825e-002, 1.677907e-002, 1.678989e-002, 1.680072e-002, 1.681155e-002, 1.682239e-002, 1.683323e-002, 1.684408e-002, 1.685493e-002, 1.686578e-002, 1.687664e-002, 1.688751e-002, 1.689838e-002, 1.690925e-002, 1.692013e-002, 1.693101e-002, 1.694190e-002, 1.695279e-002, 1.696369e-002, 1.697459e-002, 1.698550e-002, 1.699641e-002, 1.700733e-002, 1.701825e-002, 1.702917e-002, 1.704010e-002, 1.705104e-002, 1.706198e-002, 1.707292e-002, 1.708387e-002, 1.709483e-002, 1.710578e-002, 1.711675e-002, 1.712771e-002, 1.713869e-002, 1.714966e-002, 1.716065e-002, 1.717163e-002, 1.718262e-002, 1.719362e-002, 1.720462e-002, 1.721562e-002, 1.722663e-002, 1.723765e-002, 1.724867e-002, 1.725969e-002, 1.727072e-002, 1.728175e-002, 1.729279e-002, 
1.730383e-002, 1.731488e-002, 1.732593e-002, 1.733699e-002, 1.734805e-002, 1.735912e-002, 1.737019e-002, 1.738126e-002, 1.739234e-002, 1.740343e-002, 1.741452e-002, 1.742561e-002, 1.743671e-002, 1.744782e-002, 1.745892e-002, 1.747004e-002, 1.748116e-002, 1.749228e-002, 1.750341e-002, 1.751454e-002, 1.752567e-002, 1.753682e-002, 1.754796e-002, 1.755911e-002, 1.757027e-002, 1.758143e-002, 1.759259e-002, 1.760376e-002, 1.761494e-002, 1.762612e-002, 1.763730e-002, 1.764849e-002, 1.765969e-002, 1.767088e-002, 1.768209e-002, 1.769329e-002, 1.770451e-002, 1.771572e-002, 1.772695e-002, 1.773817e-002, 1.774940e-002, 1.776064e-002, 1.777188e-002, 1.778313e-002, 1.779438e-002, 1.780563e-002, 1.781689e-002, 1.782816e-002, 1.783943e-002, 1.785070e-002, 1.786198e-002, 1.787326e-002, 1.788455e-002, 1.789584e-002, 1.790714e-002, 1.791844e-002, 1.792975e-002, 1.794106e-002, 1.795238e-002, 1.796370e-002, 1.797503e-002, 1.798636e-002, 1.799770e-002, 1.800904e-002, 1.802038e-002, 1.803173e-002, 1.804309e-002, 1.805445e-002, 1.806581e-002, 1.807718e-002, 1.808856e-002, 1.809993e-002, 1.811132e-002, 1.812271e-002, 1.813410e-002, 1.814550e-002, 1.815690e-002, 1.816831e-002, 1.817972e-002, 1.819114e-002, 1.820256e-002, 1.821399e-002, 1.822542e-002, 1.823685e-002, 1.824829e-002, 1.825974e-002, 1.827119e-002, 1.828265e-002, 1.829411e-002, 1.830557e-002, 1.831704e-002, 1.832851e-002, 1.833999e-002, 1.835148e-002, 1.836297e-002, 1.837446e-002, 1.838596e-002, 1.839746e-002, 1.840897e-002, 1.842048e-002, 
1.843200e-002, 1.844352e-002, 1.845505e-002, 1.846658e-002, 1.847812e-002, 1.848966e-002, 1.850121e-002, 1.851276e-002, 1.852431e-002, 1.853587e-002, 1.854744e-002, 1.855901e-002, 1.857059e-002, 1.858217e-002, 1.859375e-002, 1.860534e-002, 1.861694e-002, 1.862853e-002, 1.864014e-002, 1.865175e-002, 1.866336e-002, 1.867498e-002, 1.868660e-002, 1.869823e-002, 1.870986e-002, 1.872150e-002, 1.873315e-002, 1.874479e-002, 1.875645e-002, 1.876810e-002, 1.877976e-002, 1.879143e-002, 1.880310e-002, 1.881478e-002, 1.882646e-002, 1.883815e-002, 1.884984e-002, 1.886153e-002, 1.887323e-002, 1.888494e-002, 1.889665e-002, 1.890837e-002, 1.892009e-002, 1.893181e-002, 1.894354e-002, 1.895528e-002, 1.896701e-002, 1.897876e-002, 1.899051e-002, 1.900226e-002, 1.901402e-002, 1.902578e-002, 1.903755e-002, 1.904933e-002, 1.906110e-002, 1.907289e-002, 1.908468e-002, 1.909647e-002, 1.910827e-002, 1.912007e-002, 1.913188e-002, 1.914369e-002, 1.915551e-002, 1.916733e-002, 1.917915e-002, 1.919099e-002, 1.920282e-002, 1.921466e-002, 1.922651e-002, 1.923836e-002, 1.925022e-002, 1.926208e-002, 1.927394e-002, 1.928581e-002, 1.929769e-002, 1.930957e-002, 1.932146e-002, 1.933335e-002, 1.934524e-002, 1.935714e-002, 1.936905e-002, 1.938095e-002, 1.939287e-002, 1.940479e-002, 1.941671e-002, 1.942864e-002, 1.944058e-002, 1.945252e-002, 1.946446e-002, 1.947641e-002, 1.948836e-002, 1.950032e-002, 1.951228e-002, 1.952425e-002, 1.953622e-002, 1.954820e-002, 1.956019e-002, 1.957217e-002, 1.958417e-002, 1.959616e-002, 
1.960817e-002, 1.962017e-002, 1.963219e-002, 1.964420e-002, 1.965623e-002, 1.966825e-002, 1.968028e-002, 1.969232e-002, 1.970436e-002, 1.971641e-002, 1.972846e-002, 1.974052e-002, 1.975258e-002, 1.976465e-002, 1.977672e-002, 1.978879e-002, 1.980087e-002, 1.981296e-002, 1.982505e-002, 1.983715e-002, 1.984925e-002, 1.986135e-002, 1.987346e-002, 1.988558e-002, 1.989770e-002, 1.990983e-002, 1.992196e-002, 1.993409e-002, 1.994623e-002, 1.995838e-002, 1.997053e-002, 1.998268e-002, 1.999484e-002, 2.000701e-002, 2.001918e-002, 2.003135e-002, 2.004353e-002, 2.005571e-002, 2.006790e-002, 2.008010e-002, 2.009230e-002, 2.010450e-002, 2.011671e-002, 2.012892e-002, 2.014114e-002, 2.015337e-002, 2.016560e-002, 2.017783e-002, 2.019007e-002, 2.020231e-002, 2.021456e-002, 2.022682e-002, 2.023907e-002, 2.025134e-002, 2.026361e-002, 2.027588e-002, 2.028816e-002, 2.030044e-002, 2.031273e-002, 2.032502e-002, 2.033732e-002, 2.034963e-002, 2.036193e-002, 2.037425e-002, 2.038657e-002, 2.039889e-002, 2.041122e-002, 2.042355e-002, 2.043589e-002, 2.044823e-002, 2.046058e-002, 2.047293e-002, 2.048529e-002, 2.049765e-002, 2.051002e-002, 2.052239e-002, 2.053477e-002, 2.054715e-002, 2.055954e-002, 2.057193e-002, 2.058433e-002, 2.059673e-002, 2.060914e-002, 2.062156e-002, 2.063397e-002, 2.064640e-002, 2.065882e-002, 2.067126e-002, 2.068369e-002, 2.069614e-002, 2.070858e-002, 2.072104e-002, 2.073349e-002, 2.074596e-002, 2.075842e-002, 2.077090e-002, 2.078337e-002, 2.079586e-002, 2.080834e-002, 2.082084e-002, 
2.083333e-002, 2.084584e-002, 2.085834e-002, 2.087086e-002, 2.088337e-002, 2.089590e-002, 2.090842e-002, 2.092096e-002, 2.093349e-002, 2.094604e-002, 2.095858e-002, 2.097114e-002, 2.098369e-002, 2.099626e-002, 2.100882e-002, 2.102140e-002, 2.103397e-002, 2.104656e-002, 2.105914e-002, 2.107174e-002, 2.108433e-002, 2.109694e-002, 2.110955e-002, 2.112216e-002, 2.113478e-002, 2.114740e-002, 2.116003e-002, 2.117266e-002, 2.118530e-002, 2.119794e-002, 2.121059e-002, 2.122324e-002, 2.123590e-002, 2.124856e-002, 2.126123e-002, 2.127390e-002, 2.128658e-002, 2.129926e-002, 2.131195e-002, 2.132465e-002, 2.133734e-002, 2.135005e-002, 2.136276e-002, 2.137547e-002, 2.138819e-002, 2.140091e-002, 2.141364e-002, 2.142637e-002, 2.143911e-002, 2.145186e-002, 2.146460e-002, 2.147736e-002, 2.149012e-002, 2.150288e-002, 2.151565e-002, 2.152842e-002, 2.154120e-002, 2.155399e-002, 2.156678e-002, 2.157957e-002, 2.159237e-002, 2.160517e-002, 2.161798e-002, 2.163080e-002, 2.164362e-002, 2.165644e-002, 2.166927e-002, 2.168211e-002, 2.169495e-002, 2.170779e-002, 2.172064e-002, 2.173350e-002, 2.174636e-002, 2.175922e-002, 2.177209e-002, 2.178497e-002, 2.179785e-002, 2.181073e-002, 2.182362e-002, 2.183652e-002, 2.184942e-002, 2.186232e-002, 2.187524e-002, 2.188815e-002, 2.190107e-002, 2.191400e-002, 2.192693e-002, 2.193987e-002, 2.195281e-002, 2.196575e-002, 2.197870e-002, 2.199166e-002, 2.200462e-002, 2.201759e-002, 2.203056e-002, 2.204354e-002, 2.205652e-002, 2.206951e-002, 2.208250e-002, 2.209550e-002, 
2.210850e-002, 2.212151e-002, 2.213452e-002, 2.214754e-002, 2.216056e-002, 2.217359e-002, 2.218662e-002, 2.219966e-002, 2.221270e-002, 2.222575e-002, 2.223881e-002, 2.225186e-002, 2.226493e-002, 2.227800e-002, 2.229107e-002, 2.230415e-002, 2.231723e-002, 2.233032e-002, 2.234342e-002, 2.235652e-002, 2.236962e-002, 2.238273e-002, 2.239585e-002, 2.240897e-002, 2.242209e-002, 2.243522e-002, 2.244836e-002, 2.246150e-002, 2.247464e-002, 2.248779e-002, 2.250095e-002, 2.251411e-002, 2.252728e-002, 2.254045e-002, 2.255362e-002, 2.256681e-002, 2.257999e-002, 2.259318e-002, 2.260638e-002, 2.261958e-002, 2.263279e-002, 2.264600e-002, 2.265922e-002, 2.267244e-002, 2.268567e-002, 2.269890e-002, 2.271214e-002, 2.272539e-002, 2.273863e-002, 2.275189e-002, 2.276515e-002, 2.277841e-002, 2.279168e-002, 2.280495e-002, 2.281823e-002, 2.283152e-002, 2.284481e-002, 2.285810e-002, 2.287140e-002, 2.288471e-002, 2.289802e-002, 2.291133e-002, 2.292465e-002, 2.293798e-002, 2.295131e-002, 2.296464e-002, 2.297799e-002, 2.299133e-002, 2.300468e-002, 2.301804e-002, 2.303140e-002, 2.304477e-002, 2.305814e-002, 2.307152e-002, 2.308490e-002, 2.309829e-002, 2.311168e-002, 2.312508e-002, 2.313848e-002, 2.315189e-002, 2.316531e-002, 2.317872e-002, 2.319215e-002, 2.320558e-002, 2.321901e-002, 2.323245e-002, 2.324590e-002, 2.325935e-002, 2.327280e-002, 2.328626e-002, 2.329973e-002, 2.331320e-002, 2.332667e-002, 2.334015e-002, 2.335364e-002, 2.336713e-002, 2.338063e-002, 2.339413e-002, 2.340764e-002, 2.342115e-002, 
2.343467e-002, 2.344819e-002, 2.346172e-002, 2.347525e-002, 2.348879e-002, 2.350233e-002, 2.351588e-002, 2.352943e-002, 2.354299e-002, 2.355656e-002, 2.357013e-002, 2.358370e-002, 2.359728e-002, 2.361087e-002, 2.362446e-002, 2.363805e-002, 2.365165e-002, 2.366526e-002, 2.367887e-002, 2.369249e-002, 2.370611e-002, 2.371973e-002, 2.373337e-002, 2.374700e-002, 2.376065e-002, 2.377429e-002, 2.378795e-002, 2.380161e-002, 2.381527e-002, 2.382894e-002, 2.384261e-002, 2.385629e-002, 2.386997e-002, 2.388366e-002, 2.389736e-002, 2.391106e-002, 2.392476e-002, 2.393847e-002, 2.395219e-002, 2.396591e-002, 2.397964e-002, 2.399337e-002, 2.400711e-002, 2.402085e-002, 2.403459e-002, 2.404835e-002, 2.406210e-002, 2.407587e-002, 2.408964e-002, 2.410341e-002, 2.411719e-002, 2.413097e-002, 2.414476e-002, 2.415855e-002, 2.417235e-002, 2.418616e-002, 2.419997e-002, 2.421378e-002, 2.422761e-002, 2.424143e-002, 2.425526e-002, 2.426910e-002, 2.428294e-002, 2.429679e-002, 2.431064e-002, 2.432450e-002, 2.433836e-002, 2.435223e-002, 2.436610e-002, 2.437998e-002, 2.439386e-002, 2.440775e-002, 2.442165e-002, 2.443555e-002, 2.444945e-002, 2.446336e-002, 2.447728e-002, 2.449120e-002, 2.450512e-002, 2.451906e-002, 2.453299e-002, 2.454693e-002, 2.456088e-002, 2.457483e-002, 2.458879e-002, 2.460275e-002, 2.461672e-002, 2.463070e-002, 2.464467e-002, 2.465866e-002, 2.467265e-002, 2.468664e-002, 2.470064e-002, 2.471465e-002, 2.472866e-002, 2.474267e-002, 2.475670e-002, 2.477072e-002, 2.478475e-002, 2.479879e-002, 
2.481283e-002, 2.482688e-002, 2.484093e-002, 2.485499e-002, 2.486906e-002, 2.488312e-002, 2.489720e-002, 2.491128e-002, 2.492536e-002, 2.493945e-002, 2.495355e-002, 2.496765e-002, 2.498176e-002, 2.499587e-002, 2.500998e-002, 2.502411e-002, 2.503823e-002, 2.505237e-002, 2.506650e-002, 2.508065e-002, 2.509479e-002, 2.510895e-002, 2.512311e-002, 2.513727e-002, 2.515144e-002, 2.516562e-002, 2.517980e-002, 2.519398e-002, 2.520817e-002, 2.522237e-002, 2.523657e-002, 2.525078e-002, 2.526499e-002, 2.527921e-002, 2.529343e-002, 2.530766e-002, 2.532190e-002, 2.533613e-002, 2.535038e-002, 2.536463e-002, 2.537888e-002, 2.539314e-002, 2.540741e-002, 2.542168e-002, 2.543596e-002, 2.545024e-002, 2.546453e-002, 2.547882e-002, 2.549312e-002, 2.550742e-002, 2.552173e-002, 2.553604e-002, 2.555036e-002, 2.556469e-002, 2.557902e-002, 2.559335e-002, 2.560769e-002, 2.562204e-002, 2.563639e-002, 2.565075e-002, 2.566511e-002, 2.567948e-002, 2.569385e-002, 2.570823e-002, 2.572261e-002, 2.573700e-002, 2.575139e-002, 2.576579e-002, 2.578020e-002, 2.579461e-002, 2.580903e-002, 2.582345e-002, 2.583787e-002, 2.585231e-002, 2.586674e-002, 2.588118e-002, 2.589563e-002, 2.591009e-002, 2.592455e-002, 2.593901e-002, 2.595348e-002, 2.596795e-002, 2.598243e-002, 2.599692e-002, 2.601141e-002, 2.602591e-002, 2.604041e-002, 2.605492e-002, 2.606943e-002, 2.608395e-002, 2.609847e-002, 2.611300e-002, 2.612753e-002, 2.614207e-002, 2.615662e-002, 2.617117e-002, 2.618572e-002, 2.620028e-002, 2.621485e-002, 2.622942e-002, 
2.624400e-002, 2.625858e-002, 2.627317e-002, 2.628776e-002, 2.630236e-002, 2.631697e-002, 2.633158e-002, 2.634619e-002, 2.636081e-002, 2.637544e-002, 2.639007e-002, 2.640471e-002, 2.641935e-002, 2.643400e-002, 2.644865e-002, 2.646331e-002, 2.647797e-002, 2.649264e-002, 2.650732e-002, 2.652200e-002, 2.653668e-002, 2.655137e-002, 2.656607e-002, 2.658077e-002, 2.659548e-002, 2.661019e-002, 2.662491e-002, 2.663963e-002, 2.665436e-002, 2.666909e-002, 2.668383e-002, 2.669858e-002, 2.671333e-002, 2.672809e-002, 2.674285e-002, 2.675761e-002, 2.677239e-002, 2.678716e-002, 2.680195e-002, 2.681674e-002, 2.683153e-002, 2.684633e-002, 2.686114e-002, 2.687595e-002, 2.689076e-002, 2.690558e-002, 2.692041e-002, 2.693524e-002, 2.695008e-002, 2.696492e-002, 2.697977e-002, 2.699462e-002, 2.700948e-002, 2.702435e-002, 2.703922e-002, 2.705410e-002, 2.706898e-002, 2.708386e-002, 2.709876e-002, 2.711365e-002, 2.712856e-002, 2.714346e-002, 2.715838e-002, 2.717330e-002, 2.718822e-002, 2.720315e-002, 2.721809e-002, 2.723303e-002, 2.724798e-002, 2.726293e-002, 2.727789e-002, 2.729285e-002, 2.730782e-002, 2.732279e-002, 2.733777e-002, 2.735276e-002, 2.736775e-002, 2.738274e-002, 2.739775e-002, 2.741275e-002, 2.742777e-002, 2.744278e-002, 2.745781e-002, 2.747284e-002, 2.748787e-002, 2.750291e-002, 2.751796e-002, 2.753301e-002, 2.754806e-002, 2.756312e-002, 2.757819e-002, 2.759326e-002, 2.760834e-002, 2.762343e-002, 2.763852e-002, 2.765361e-002, 2.766871e-002, 2.768382e-002, 2.769893e-002, 2.771404e-002, 
2.772917e-002, 2.774429e-002, 2.775943e-002, 2.777457e-002, 2.778971e-002, 2.780486e-002, 2.782002e-002, 2.783518e-002, 2.785034e-002, 2.786551e-002, 2.788069e-002, 2.789587e-002, 2.791106e-002, 2.792626e-002, 2.794146e-002, 2.795666e-002, 2.797187e-002, 2.798709e-002, 2.800231e-002, 2.801754e-002, 2.803277e-002, 2.804801e-002, 2.806325e-002, 2.807850e-002, 2.809375e-002, 2.810901e-002, 2.812428e-002, 2.813955e-002, 2.815483e-002, 2.817011e-002, 2.818540e-002, 2.820069e-002, 2.821599e-002, 2.823129e-002, 2.824660e-002, 2.826192e-002, 2.827724e-002, 2.829256e-002, 2.830790e-002, 2.832323e-002, 2.833858e-002, 2.835393e-002, 2.836928e-002, 2.838464e-002, 2.840000e-002, 2.841538e-002, 2.843075e-002, 2.844613e-002, 2.846152e-002, 2.847691e-002, 2.849231e-002, 2.850772e-002, 2.852313e-002, 2.853854e-002, 2.855396e-002, 2.856939e-002, 2.858482e-002, 2.860026e-002, 2.861570e-002, 2.863115e-002, 2.864660e-002, 2.866206e-002, 2.867753e-002, 2.869300e-002, 2.870847e-002, 2.872396e-002, 2.873944e-002, 2.875494e-002, 2.877044e-002, 2.878594e-002, 2.880145e-002, 2.881696e-002, 2.883248e-002, 2.884801e-002, 2.886354e-002, 2.887908e-002, 2.889462e-002, 2.891017e-002, 2.892573e-002, 2.894129e-002, 2.895685e-002, 2.897242e-002, 2.898800e-002, 2.900358e-002, 2.901917e-002, 2.903476e-002, 2.905036e-002, 2.906597e-002, 2.908158e-002, 2.909719e-002, 2.911281e-002, 2.912844e-002, 2.914407e-002, 2.915971e-002, 2.917535e-002, 2.919100e-002, 2.920666e-002, 2.922232e-002, 2.923798e-002, 2.925366e-002, 
2.926933e-002, 2.928502e-002, 2.930070e-002, 2.931640e-002, 2.933210e-002, 2.934780e-002, 2.936351e-002, 2.937923e-002, 2.939495e-002, 2.941068e-002, 2.942641e-002, 2.944215e-002, 2.945790e-002, 2.947365e-002, 2.948940e-002, 2.950516e-002, 2.952093e-002, 2.953670e-002, 2.955248e-002, 2.956827e-002, 2.958405e-002, 2.959985e-002, 2.961565e-002, 2.963146e-002, 2.964727e-002, 2.966309e-002, 2.967891e-002, 2.969474e-002, 2.971057e-002, 2.972641e-002, 2.974226e-002, 2.975811e-002, 2.977397e-002, 2.978983e-002, 2.980570e-002, 2.982157e-002, 2.983745e-002, 2.985333e-002, 2.986923e-002, 2.988512e-002, 2.990102e-002, 2.991693e-002, 2.993284e-002, 2.994876e-002, 2.996469e-002, 2.998062e-002, 2.999655e-002, 3.001250e-002, 3.002844e-002, 3.004440e-002, 3.006035e-002, 3.007632e-002, 3.009229e-002, 3.010826e-002, 3.012424e-002, 3.014023e-002, 3.015622e-002, 3.017222e-002, 3.018823e-002, 3.020423e-002, 3.022025e-002, 3.023627e-002, 3.025230e-002, 3.026833e-002, 3.028437e-002, 3.030041e-002, 3.031646e-002, 3.033251e-002, 3.034857e-002, 3.036464e-002, 3.038071e-002, 3.039679e-002, 3.041287e-002, 3.042896e-002, 3.044505e-002, 3.046115e-002, 3.047726e-002, 3.049337e-002, 3.050949e-002, 3.052561e-002, 3.054174e-002, 3.055787e-002, 3.057401e-002, 3.059016e-002, 3.060631e-002, 3.062247e-002, 3.063863e-002, 3.065480e-002, 3.067097e-002, 3.068715e-002, 3.070333e-002, 3.071953e-002, 3.073572e-002, 3.075192e-002, 3.076813e-002, 3.078435e-002, 3.080057e-002, 3.081679e-002, 3.083302e-002, 3.084926e-002, 
3.086550e-002, 3.088175e-002, 3.089800e-002, 3.091426e-002, 3.093053e-002, 3.094680e-002, 3.096307e-002, 3.097935e-002, 3.099564e-002, 3.101194e-002, 3.102824e-002, 3.104454e-002, 3.106085e-002, 3.107717e-002, 3.109349e-002, 3.110982e-002, 3.112615e-002, 3.114249e-002, 3.115883e-002, 3.117518e-002, 3.119154e-002, 3.120790e-002, 3.122427e-002, 3.124064e-002, 3.125702e-002, 3.127341e-002, 3.128980e-002, 3.130620e-002, 3.132260e-002, 3.133901e-002, 3.135542e-002, 3.137184e-002, 3.138826e-002, 3.140469e-002, 3.142113e-002, 3.143757e-002, 3.145402e-002, 3.147048e-002, 3.148693e-002, 3.150340e-002, 3.151987e-002, 3.153635e-002, 3.155283e-002, 3.156932e-002, 3.158581e-002, 3.160231e-002, 3.161882e-002, 3.163533e-002, 3.165184e-002, 3.166837e-002, 3.168490e-002, 3.170143e-002, 3.171797e-002, 3.173452e-002, 3.175107e-002, 3.176762e-002, 3.178419e-002, 3.180076e-002, 3.181733e-002, 3.183391e-002, 3.185050e-002, 3.186709e-002, 3.188369e-002, 3.190029e-002, 3.191690e-002, 3.193351e-002, 3.195013e-002, 3.196676e-002, 3.198339e-002, 3.200003e-002, 3.201667e-002, 3.203332e-002, 3.204998e-002, 3.206664e-002, 3.208330e-002, 3.209998e-002, 3.211665e-002, 3.213334e-002, 3.215003e-002, 3.216672e-002, 3.218343e-002, 3.220013e-002, 3.221685e-002, 3.223356e-002, 3.225029e-002, 3.226702e-002, 3.228375e-002, 3.230050e-002, 3.231724e-002, 3.233400e-002, 3.235076e-002, 3.236752e-002, 3.238429e-002, 3.240107e-002, 3.241785e-002, 3.243464e-002, 3.245143e-002, 3.246823e-002, 3.248504e-002, 3.250185e-002, 
3.251867e-002, 3.253549e-002, 3.255232e-002, 3.256915e-002, 3.258599e-002, 3.260284e-002, 3.261969e-002, 3.263655e-002, 3.265341e-002, 3.267028e-002, 3.268716e-002, 3.270404e-002, 3.272092e-002, 3.273782e-002, 3.275472e-002, 3.277162e-002, 3.278853e-002, 3.280545e-002, 3.282237e-002, 3.283929e-002, 3.285623e-002, 3.287317e-002, 3.289011e-002, 3.290706e-002, 3.292402e-002, 3.294098e-002, 3.295795e-002, 3.297492e-002, 3.299190e-002, 3.300889e-002, 3.302588e-002, 3.304288e-002, 3.305988e-002, 3.307689e-002, 3.309391e-002, 3.311093e-002, 3.312795e-002, 3.314499e-002, 3.316202e-002, 3.317907e-002, 3.319612e-002, 3.321317e-002, 3.323023e-002, 3.324730e-002, 3.326438e-002, 3.328145e-002, 3.329854e-002, 3.331563e-002, 3.333273e-002, 3.334983e-002, 3.336694e-002, 3.338405e-002, 3.340117e-002, 3.341830e-002, 3.343543e-002, 3.345257e-002, 3.346971e-002, 3.348686e-002, 3.350401e-002, 3.352118e-002, 3.353834e-002, 3.355552e-002, 3.357269e-002, 3.358988e-002, 3.360707e-002, 3.362426e-002, 3.364147e-002, 3.365867e-002, 3.367589e-002, 3.369311e-002, 3.371033e-002, 3.372757e-002, 3.374480e-002, 3.376205e-002, 3.377929e-002, 3.379655e-002, 3.381381e-002, 3.383108e-002, 3.384835e-002, 3.386563e-002, 3.388291e-002, 3.390020e-002, 3.391750e-002, 3.393480e-002, 3.395211e-002, 3.396942e-002, 3.398674e-002, 3.400407e-002, 3.402140e-002, 3.403874e-002, 3.405608e-002, 3.407343e-002, 3.409078e-002, 3.410814e-002, 3.412551e-002, 3.414288e-002, 3.416026e-002, 3.417764e-002, 3.419504e-002, 3.421243e-002, 
3.422983e-002, 3.424724e-002, 3.426466e-002, 3.428207e-002, 3.429950e-002, 3.431693e-002, 3.433437e-002, 3.435181e-002, 3.436926e-002, 3.438672e-002, 3.440418e-002, 3.442165e-002, 3.443912e-002, 3.445660e-002, 3.447408e-002, 3.449157e-002, 3.450907e-002, 3.452657e-002, 3.454408e-002, 3.456159e-002, 3.457911e-002, 3.459664e-002, 3.461417e-002, 3.463171e-002, 3.464925e-002, 3.466680e-002, 3.468436e-002, 3.470192e-002, 3.471949e-002, 3.473706e-002, 3.475464e-002, 3.477223e-002, 3.478982e-002, 3.480742e-002, 3.482502e-002, 3.484263e-002, 3.486024e-002, 3.487787e-002, 3.489549e-002, 3.491313e-002, 3.493076e-002, 3.494841e-002, 3.496606e-002, 3.498372e-002, 3.500138e-002, 3.501905e-002, 3.503672e-002, 3.505440e-002, 3.507209e-002, 3.508978e-002, 3.510748e-002, 3.512518e-002, 3.514289e-002, 3.516061e-002, 3.517833e-002, 3.519606e-002, 3.521379e-002, 3.523153e-002, 3.524928e-002, 3.526703e-002, 3.528479e-002, 3.530255e-002, 3.532032e-002, 3.533810e-002, 3.535588e-002, 3.537367e-002, 3.539146e-002, 3.540926e-002, 3.542707e-002, 3.544488e-002, 3.546270e-002, 3.548052e-002, 3.549835e-002, 3.551618e-002, 3.553403e-002, 3.555187e-002, 3.556973e-002, 3.558758e-002, 3.560545e-002, 3.562332e-002, 3.564120e-002, 3.565908e-002, 3.567697e-002, 3.569487e-002, 3.571277e-002, 3.573067e-002, 3.574859e-002, 3.576651e-002, 3.578443e-002, 3.580236e-002, 3.582030e-002, 3.583824e-002, 3.585619e-002, 3.587415e-002, 3.589211e-002, 3.591007e-002, 3.592805e-002, 3.594603e-002, 3.596401e-002, 3.598200e-002, 
3.600000e-002, 3.601800e-002, 3.603601e-002, 3.605403e-002, 3.607205e-002, 3.609008e-002, 3.610811e-002, 3.612615e-002, 3.614419e-002, 3.616224e-002, 3.618030e-002, 3.619836e-002, 3.621643e-002, 3.623451e-002, 3.625259e-002, 3.627068e-002, 3.628877e-002, 3.630687e-002, 3.632497e-002, 3.634308e-002, 3.636120e-002, 3.637932e-002, 3.639745e-002, 3.641559e-002, 3.643373e-002, 3.645188e-002, 3.647003e-002, 3.648819e-002, 3.650636e-002, 3.652453e-002, 3.654270e-002, 3.656089e-002, 3.657908e-002, 3.659727e-002, 3.661547e-002, 3.663368e-002, 3.665190e-002, 3.667012e-002, 3.668834e-002, 3.670657e-002, 3.672481e-002, 3.674305e-002, 3.676130e-002, 3.677956e-002, 3.679782e-002, 3.681609e-002, 3.683436e-002, 3.685264e-002, 3.687093e-002, 3.688922e-002, 3.690752e-002, 3.692583e-002, 3.694414e-002, 3.696245e-002, 3.698077e-002, 3.699910e-002, 3.701744e-002, 3.703578e-002, 3.705412e-002, 3.707248e-002, 3.709084e-002, 3.710920e-002, 3.712757e-002, 3.714595e-002, 3.716433e-002, 3.718272e-002, 3.720112e-002, 3.721952e-002, 3.723792e-002, 3.725634e-002, 3.727476e-002, 3.729318e-002, 3.731161e-002, 3.733005e-002, 3.734850e-002, 3.736695e-002, 3.738540e-002, 3.740386e-002, 3.742233e-002, 3.744081e-002, 3.745929e-002, 3.747777e-002, 3.749626e-002, 3.751476e-002, 3.753327e-002, 3.755178e-002, 3.757029e-002, 3.758882e-002, 3.760735e-002, 3.762588e-002, 3.764442e-002, 3.766297e-002, 3.768152e-002, 3.770008e-002, 3.771865e-002, 3.773722e-002, 3.775580e-002, 3.777438e-002, 3.779297e-002, 3.781156e-002, 
3.783017e-002, 3.784877e-002, 3.786739e-002, 3.788601e-002, 3.790464e-002, 3.792327e-002, 3.794191e-002, 3.796055e-002, 3.797920e-002, 3.799786e-002, 3.801652e-002, 3.803519e-002, 3.805387e-002, 3.807255e-002, 3.809123e-002, 3.810993e-002, 3.812863e-002, 3.814733e-002, 3.816605e-002, 3.818476e-002, 3.820349e-002, 3.822222e-002, 3.824095e-002, 3.825970e-002, 3.827845e-002, 3.829720e-002, 3.831596e-002, 3.833473e-002, 3.835350e-002, 3.837228e-002, 3.839107e-002, 3.840986e-002, 3.842866e-002, 3.844746e-002, 3.846627e-002, 3.848509e-002, 3.850391e-002, 3.852274e-002, 3.854157e-002, 3.856041e-002, 3.857926e-002, 3.859811e-002, 3.861697e-002, 3.863583e-002, 3.865471e-002, 3.867358e-002, 3.869247e-002, 3.871136e-002, 3.873025e-002, 3.874915e-002, 3.876806e-002, 3.878698e-002, 3.880590e-002, 3.882482e-002, 3.884376e-002, 3.886270e-002, 3.888164e-002, 3.890059e-002, 3.891955e-002, 3.893851e-002, 3.895748e-002, 3.897646e-002, 3.899544e-002, 3.901443e-002, 3.903342e-002, 3.905242e-002, 3.907143e-002, 3.909044e-002, 3.910946e-002, 3.912849e-002, 3.914752e-002, 3.916656e-002, 3.918560e-002, 3.920465e-002, 3.922371e-002, 3.924277e-002, 3.926184e-002, 3.928091e-002, 3.929999e-002, 3.931908e-002, 3.933817e-002, 3.935727e-002, 3.937638e-002, 3.939549e-002, 3.941461e-002, 3.943373e-002, 3.945286e-002, 3.947200e-002, 3.949114e-002, 3.951029e-002, 3.952944e-002, 3.954860e-002, 3.956777e-002, 3.958695e-002, 3.960612e-002, 3.962531e-002, 3.964450e-002, 3.966370e-002, 3.968291e-002, 3.970212e-002, 
3.972133e-002, 3.974056e-002, 3.975979e-002, 3.977902e-002, 3.979826e-002, 3.981751e-002, 3.983676e-002, 3.985603e-002, 3.987529e-002, 3.989456e-002, 3.991384e-002, 3.993313e-002, 3.995242e-002, 3.997172e-002, 3.999102e-002, 4.001033e-002, 4.002965e-002, 4.004897e-002, 4.006830e-002, 4.008763e-002, 4.010697e-002, 4.012632e-002, 4.014568e-002, 4.016504e-002, 4.018440e-002, 4.020377e-002, 4.022315e-002, 4.024254e-002, 4.026193e-002, 4.028132e-002, 4.030073e-002, 4.032014e-002, 4.033955e-002, 4.035898e-002, 4.037840e-002, 4.039784e-002, 4.041728e-002, 4.043673e-002, 4.045618e-002, 4.047564e-002, 4.049510e-002, 4.051458e-002, 4.053405e-002, 4.055354e-002, 4.057303e-002, 4.059253e-002, 4.061203e-002, 4.063154e-002, 4.065105e-002, 4.067058e-002, 4.069010e-002, 4.070964e-002, 4.072918e-002, 4.074873e-002, 4.076828e-002, 4.078784e-002, 4.080740e-002, 4.082698e-002, 4.084655e-002, 4.086614e-002, 4.088573e-002, 4.090533e-002, 4.092493e-002, 4.094454e-002, 4.096415e-002, 4.098378e-002, 4.100340e-002, 4.102304e-002, 4.104268e-002, 4.106233e-002, 4.108198e-002, 4.110164e-002, 4.112131e-002, 4.114098e-002, 4.116066e-002, 4.118034e-002, 4.120003e-002, 4.121973e-002, 4.123943e-002, 4.125914e-002, 4.127886e-002, 4.129858e-002, 4.131831e-002, 4.133804e-002, 4.135779e-002, 4.137753e-002, 4.139729e-002, 4.141705e-002, 4.143681e-002, 4.145659e-002, 4.147636e-002, 4.149615e-002, 4.151594e-002, 4.153574e-002, 4.155554e-002, 4.157535e-002, 4.159517e-002, 4.161499e-002, 4.163482e-002, 4.165466e-002, 
4.167450e-002, 4.169435e-002, 4.171420e-002, 4.173406e-002, 4.175393e-002, 4.177380e-002, 4.179368e-002, 4.181357e-002, 4.183346e-002, 4.185336e-002, 4.187327e-002, 4.189318e-002, 4.191309e-002, 4.193302e-002, 4.195295e-002, 4.197288e-002, 4.199283e-002, 4.201278e-002, 4.203273e-002, 4.205269e-002, 4.207266e-002, 4.209264e-002, 4.211262e-002, 4.213260e-002, 4.215260e-002, 4.217260e-002, 4.219260e-002, 4.221261e-002, 4.223263e-002, 4.225266e-002, 4.227269e-002, 4.229273e-002, 4.231277e-002, 4.233282e-002, 4.235288e-002, 4.237294e-002, 4.239301e-002, 4.241309e-002, 4.243317e-002, 4.245326e-002, 4.247335e-002, 4.249345e-002, 4.251356e-002, 4.253367e-002, 4.255379e-002, 4.257392e-002, 4.259405e-002, 4.261419e-002, 4.263434e-002, 4.265449e-002, 4.267465e-002, 4.269481e-002, 4.271498e-002, 4.273516e-002, 4.275534e-002, 4.277553e-002, 4.279573e-002, 4.281593e-002, 4.283614e-002, 4.285635e-002, 4.287658e-002, 4.289680e-002, 4.291704e-002, 4.293728e-002, 4.295753e-002, 4.297778e-002, 4.299804e-002, 4.301831e-002, 4.303858e-002, 4.305886e-002, 4.307914e-002, 4.309943e-002, 4.311973e-002, 4.314004e-002, 4.316035e-002, 4.318066e-002, 4.320099e-002, 4.322132e-002, 4.324165e-002, 4.326200e-002, 4.328235e-002, 4.330270e-002, 4.332306e-002, 4.334343e-002, 4.336381e-002, 4.338419e-002, 4.340457e-002, 4.342497e-002, 4.344537e-002, 4.346577e-002, 4.348619e-002, 4.350661e-002, 4.352703e-002, 4.354746e-002, 4.356790e-002, 4.358835e-002, 4.360880e-002, 4.362926e-002, 4.364972e-002, 4.367019e-002, 
4.369067e-002, 4.371115e-002, 4.373164e-002, 4.375214e-002, 4.377264e-002, 4.379315e-002, 4.381366e-002, 4.383418e-002, 4.385471e-002, 4.387525e-002, 4.389579e-002, 4.391633e-002, 4.393689e-002, 4.395745e-002, 4.397801e-002, 4.399859e-002, 4.401917e-002, 4.403975e-002, 4.406034e-002, 4.408094e-002, 4.410155e-002, 4.412216e-002, 4.414278e-002, 4.416340e-002, 4.418403e-002, 4.420467e-002, 4.422531e-002, 4.424596e-002, 4.426662e-002, 4.428728e-002, 4.430795e-002, 4.432863e-002, 4.434931e-002, 4.437000e-002, 4.439069e-002, 4.441139e-002, 4.443210e-002, 4.445282e-002, 4.447354e-002, 4.449426e-002, 4.451500e-002, 4.453574e-002, 4.455648e-002, 4.457724e-002, 4.459800e-002, 4.461876e-002, 4.463953e-002, 4.466031e-002, 4.468110e-002, 4.470189e-002, 4.472269e-002, 4.474349e-002, 4.476430e-002, 4.478512e-002, 4.480594e-002, 4.482677e-002, 4.484761e-002, 4.486845e-002, 4.488930e-002, 4.491016e-002, 4.493102e-002, 4.495189e-002, 4.497277e-002, 4.499365e-002, 4.501454e-002, 4.503543e-002, 4.505633e-002, 4.507724e-002, 4.509816e-002, 4.511908e-002, 4.514000e-002, 4.516094e-002, 4.518188e-002, 4.520282e-002, 4.522378e-002, 4.524474e-002, 4.526570e-002, 4.528668e-002, 4.530765e-002, 4.532864e-002, 4.534963e-002, 4.537063e-002, 4.539164e-002, 4.541265e-002, 4.543366e-002, 4.545469e-002, 4.547572e-002, 4.549676e-002, 4.551780e-002, 4.553885e-002, 4.555991e-002, 4.558097e-002, 4.560204e-002, 4.562312e-002, 4.564420e-002, 4.566529e-002, 4.568639e-002, 4.570749e-002, 4.572860e-002, 4.574971e-002, 
4.577083e-002, 4.579196e-002, 4.581310e-002, 4.583424e-002, 4.585539e-002, 4.587654e-002, 4.589770e-002, 4.591887e-002, 4.594004e-002, 4.596122e-002, 4.598241e-002, 4.600360e-002, 4.602480e-002, 4.604601e-002, 4.606722e-002, 4.608844e-002, 4.610967e-002, 4.613090e-002, 4.615214e-002, 4.617338e-002, 4.619463e-002, 4.621589e-002, 4.623716e-002, 4.625843e-002, 4.627971e-002, 4.630099e-002, 4.632228e-002, 4.634358e-002, 4.636488e-002, 4.638620e-002, 4.640751e-002, 4.642884e-002, 4.645017e-002, 4.647150e-002, 4.649285e-002, 4.651420e-002, 4.653555e-002, 4.655692e-002, 4.657829e-002, 4.659966e-002, 4.662104e-002, 4.664243e-002, 4.666383e-002, 4.668523e-002, 4.670664e-002, 4.672805e-002, 4.674948e-002, 4.677090e-002, 4.679234e-002, 4.681378e-002, 4.683523e-002, 4.685668e-002, 4.687814e-002, 4.689961e-002, 4.692109e-002, 4.694257e-002, 4.696405e-002, 4.698555e-002, 4.700705e-002, 4.702856e-002, 4.705007e-002, 4.707159e-002, 4.709312e-002, 4.711465e-002, 4.713619e-002, 4.715774e-002, 4.717929e-002, 4.720085e-002, 4.722241e-002, 4.724399e-002, 4.726557e-002, 4.728715e-002, 4.730874e-002, 4.733034e-002, 4.735195e-002, 4.737356e-002, 4.739518e-002, 4.741680e-002, 4.743844e-002, 4.746007e-002, 4.748172e-002, 4.750337e-002, 4.752503e-002, 4.754669e-002, 4.756836e-002, 4.759004e-002, 4.761173e-002, 4.763342e-002, 4.765511e-002, 4.767682e-002, 4.769853e-002, 4.772025e-002, 4.774197e-002, 4.776370e-002, 4.778544e-002, 4.780718e-002, 4.782893e-002, 4.785069e-002, 4.787245e-002, 4.789422e-002, 
4.791600e-002, 4.793778e-002, 4.795957e-002, 4.798137e-002, 4.800317e-002, 4.802498e-002, 4.804680e-002, 4.806862e-002, 4.809045e-002, 4.811229e-002, 4.813413e-002, 4.815598e-002, 4.817784e-002, 4.819970e-002, 4.822157e-002, 4.824344e-002, 4.826533e-002, 4.828721e-002, 4.830911e-002, 4.833101e-002, 4.835292e-002, 4.837484e-002, 4.839676e-002, 4.841869e-002, 4.844062e-002, 4.846257e-002, 4.848451e-002, 4.850647e-002, 4.852843e-002, 4.855040e-002, 4.857237e-002, 4.859436e-002, 4.861634e-002, 4.863834e-002, 4.866034e-002, 4.868235e-002, 4.870436e-002, 4.872639e-002, 4.874841e-002, 4.877045e-002, 4.879249e-002, 4.881454e-002, 4.883659e-002, 4.885865e-002, 4.888072e-002, 4.890280e-002, 4.892488e-002, 4.894697e-002, 4.896906e-002, 4.899116e-002, 4.901327e-002, 4.903539e-002, 4.905751e-002, 4.907963e-002, 4.910177e-002, 4.912391e-002, 4.914606e-002, 4.916821e-002, 4.919037e-002, 4.921254e-002, 4.923472e-002, 4.925690e-002, 4.927908e-002, 4.930128e-002, 4.932348e-002, 4.934569e-002, 4.936790e-002, 4.939012e-002, 4.941235e-002, 4.943459e-002, 4.945683e-002, 4.947907e-002, 4.950133e-002, 4.952359e-002, 4.954586e-002, 4.956813e-002, 4.959041e-002, 4.961270e-002, 4.963500e-002, 4.965730e-002, 4.967961e-002, 4.970192e-002, 4.972424e-002, 4.974657e-002, 4.976890e-002, 4.979124e-002, 4.981359e-002, 4.983595e-002, 4.985831e-002, 4.988068e-002, 4.990305e-002, 4.992543e-002, 4.994782e-002, 4.997022e-002, 4.999262e-002, 5.001503e-002, 5.003744e-002, 5.005986e-002, 5.008229e-002, 5.010473e-002, 
5.012717e-002, 5.014962e-002, 5.017207e-002, 5.019453e-002, 5.021700e-002, 5.023948e-002, 5.026196e-002, 5.028445e-002, 5.030694e-002, 5.032944e-002, 5.035195e-002, 5.037447e-002, 5.039699e-002, 5.041952e-002, 5.044205e-002, 5.046460e-002, 5.048714e-002, 5.050970e-002, 5.053226e-002, 5.055483e-002, 5.057741e-002, 5.059999e-002, 5.062258e-002, 5.064518e-002, 5.066778e-002, 5.069039e-002, 5.071300e-002, 5.073563e-002, 5.075826e-002, 5.078089e-002, 5.080354e-002, 5.082619e-002, 5.084884e-002, 5.087151e-002, 5.089418e-002, 5.091685e-002, 5.093954e-002, 5.096223e-002, 5.098492e-002, 5.100763e-002, 5.103034e-002, 5.105305e-002, 5.107578e-002, 5.109851e-002, 5.112125e-002, 5.114399e-002, 5.116674e-002, 5.118950e-002, 5.121226e-002, 5.123503e-002, 5.125781e-002, 5.128060e-002, 5.130339e-002, 5.132619e-002, 5.134899e-002, 5.137180e-002, 5.139462e-002, 5.141745e-002, 5.144028e-002, 5.146312e-002, 5.148596e-002, 5.150881e-002, 5.153167e-002, 5.155454e-002, 5.157741e-002, 5.160029e-002, 5.162318e-002, 5.164607e-002, 5.166897e-002, 5.169188e-002, 5.171479e-002, 5.173771e-002, 5.176064e-002, 5.178357e-002, 5.180651e-002, 5.182946e-002, 5.185241e-002, 5.187537e-002, 5.189834e-002, 5.192131e-002, 5.194429e-002, 5.196728e-002, 5.199027e-002, 5.201328e-002, 5.203628e-002, 5.205930e-002, 5.208232e-002, 5.210535e-002, 5.212838e-002, 5.215142e-002, 5.217447e-002, 5.219753e-002, 5.222059e-002, 5.224366e-002, 5.226674e-002, 5.228982e-002, 5.231291e-002, 5.233600e-002, 5.235911e-002, 5.238222e-002, 
5.240533e-002, 5.242846e-002, 5.245159e-002, 5.247472e-002, 5.249787e-002, 5.252102e-002, 5.254418e-002, 5.256734e-002, 5.259051e-002, 5.261369e-002, 5.263687e-002, 5.266006e-002, 5.268326e-002, 5.270647e-002, 5.272968e-002, 5.275290e-002, 5.277612e-002, 5.279936e-002, 5.282260e-002, 5.284584e-002, 5.286909e-002, 5.289235e-002, 5.291562e-002, 5.293889e-002, 5.296217e-002, 5.298546e-002, 5.300875e-002, 5.303206e-002, 5.305536e-002, 5.307868e-002, 5.310200e-002, 5.312533e-002, 5.314866e-002, 5.317200e-002, 5.319535e-002, 5.321871e-002, 5.324207e-002, 5.326544e-002, 5.328881e-002, 5.331219e-002, 5.333558e-002, 5.335898e-002, 5.338238e-002, 5.340579e-002, 5.342921e-002, 5.345263e-002, 5.347606e-002, 5.349950e-002, 5.352295e-002, 5.354640e-002, 5.356985e-002, 5.359332e-002, 5.361679e-002, 5.364027e-002, 5.366375e-002, 5.368725e-002, 5.371075e-002, 5.373425e-002, 5.375776e-002, 5.378128e-002, 5.380481e-002, 5.382834e-002, 5.385188e-002, 5.387543e-002, 5.389898e-002, 5.392254e-002, 5.394611e-002, 5.396969e-002, 5.399327e-002, 5.401686e-002, 5.404045e-002, 5.406405e-002, 5.408766e-002, 5.411128e-002, 5.413490e-002, 5.415853e-002, 5.418216e-002, 5.420581e-002, 5.422946e-002, 5.425311e-002, 5.427678e-002, 5.430045e-002, 5.432413e-002, 5.434781e-002, 5.437150e-002, 5.439520e-002, 5.441891e-002, 5.444262e-002, 5.446634e-002, 5.449006e-002, 5.451379e-002, 5.453753e-002, 5.456128e-002, 5.458503e-002, 5.460879e-002, 5.463256e-002, 5.465634e-002, 5.468012e-002, 5.470390e-002, 5.472770e-002, 
5.475150e-002, 5.477531e-002, 5.479912e-002, 5.482295e-002, 5.484678e-002, 5.487061e-002, 5.489445e-002, 5.491830e-002, 5.494216e-002, 5.496602e-002, 5.498990e-002, 5.501377e-002, 5.503766e-002, 5.506155e-002, 5.508545e-002, 5.510935e-002, 5.513326e-002, 5.515718e-002, 5.518111e-002, 5.520504e-002, 5.522898e-002, 5.525293e-002, 5.527688e-002, 5.530084e-002, 5.532481e-002, 5.534878e-002, 5.537277e-002, 5.539675e-002, 5.542075e-002, 5.544475e-002, 5.546876e-002, 5.549278e-002, 5.551680e-002, 5.554083e-002, 5.556486e-002, 5.558891e-002, 5.561296e-002, 5.563702e-002, 5.566108e-002, 5.568515e-002, 5.570923e-002, 5.573332e-002, 5.575741e-002, 5.578151e-002, 5.580561e-002, 5.582973e-002, 5.585385e-002, 5.587797e-002, 5.590211e-002, 5.592625e-002, 5.595040e-002, 5.597455e-002, 5.599871e-002, 5.602288e-002, 5.604706e-002, 5.607124e-002, 5.609543e-002, 5.611962e-002, 5.614383e-002, 5.616804e-002, 5.619226e-002, 5.621648e-002, 5.624071e-002, 5.626495e-002, 5.628919e-002, 5.631345e-002, 5.633771e-002, 5.636197e-002, 5.638625e-002, 5.641053e-002, 5.643481e-002, 5.645911e-002, 5.648341e-002, 5.650771e-002, 5.653203e-002, 5.655635e-002, 5.658068e-002, 5.660502e-002, 5.662936e-002, 5.665371e-002, 5.667807e-002, 5.670243e-002, 5.672680e-002, 5.675118e-002, 5.677556e-002, 5.679995e-002, 5.682435e-002, 5.684876e-002, 5.687317e-002, 5.689759e-002, 5.692202e-002, 5.694645e-002, 5.697089e-002, 5.699534e-002, 5.701979e-002, 5.704425e-002, 5.706872e-002, 5.709320e-002, 5.711768e-002, 5.714217e-002, 
5.716667e-002, 5.719117e-002, 5.721568e-002, 5.724020e-002, 5.726472e-002, 5.728925e-002, 5.731379e-002, 5.733834e-002, 5.736289e-002, 5.738745e-002, 5.741202e-002, 5.743659e-002, 5.746117e-002, 5.748576e-002, 5.751035e-002, 5.753495e-002, 5.755956e-002, 5.758418e-002, 5.760880e-002, 5.763343e-002, 5.765807e-002, 5.768271e-002, 5.770736e-002, 5.773202e-002, 5.775668e-002, 5.778136e-002, 5.780604e-002, 5.783072e-002, 5.785541e-002, 5.788011e-002, 5.790482e-002, 5.792954e-002, 5.795426e-002, 5.797898e-002, 5.800372e-002, 5.802846e-002, 5.805321e-002, 5.807797e-002, 5.810273e-002, 5.812750e-002, 5.815228e-002, 5.817706e-002, 5.820185e-002, 5.822665e-002, 5.825146e-002, 5.827627e-002, 5.830109e-002, 5.832592e-002, 5.835075e-002, 5.837559e-002, 5.840044e-002, 5.842529e-002, 5.845015e-002, 5.847502e-002, 5.849990e-002, 5.852478e-002, 5.854967e-002, 5.857457e-002, 5.859947e-002, 5.862438e-002, 5.864930e-002, 5.867423e-002, 5.869916e-002, 5.872410e-002, 5.874905e-002, 5.877400e-002, 5.879896e-002, 5.882393e-002, 5.884890e-002, 5.887388e-002, 5.889887e-002, 5.892387e-002, 5.894887e-002, 5.897388e-002, 5.899890e-002, 5.902392e-002, 5.904896e-002, 5.907399e-002, 5.909904e-002, 5.912409e-002, 5.914915e-002, 5.917422e-002, 5.919929e-002, 5.922437e-002, 5.924946e-002, 5.927456e-002, 5.929966e-002, 5.932477e-002, 5.934988e-002, 5.937501e-002, 5.940014e-002, 5.942528e-002, 5.945042e-002, 5.947557e-002, 5.950073e-002, 5.952590e-002, 5.955107e-002, 5.957625e-002, 5.960144e-002, 5.962663e-002, 
5.965183e-002, 5.967704e-002, 5.970226e-002, 5.972748e-002, 5.975271e-002, 5.977795e-002, 5.980319e-002, 5.982844e-002, 5.985370e-002, 5.987897e-002, 5.990424e-002, 5.992952e-002, 5.995480e-002, 5.998010e-002, 6.000540e-002, 6.003071e-002, 6.005602e-002, 6.008135e-002, 6.010667e-002, 6.013201e-002, 6.015735e-002, 6.018271e-002, 6.020806e-002, 6.023343e-002, 6.025880e-002, 6.028418e-002, 6.030957e-002, 6.033496e-002, 6.036036e-002, 6.038577e-002, 6.041118e-002, 6.043660e-002, 6.046203e-002, 6.048747e-002, 6.051291e-002, 6.053836e-002, 6.056382e-002, 6.058929e-002, 6.061476e-002, 6.064024e-002, 6.066572e-002, 6.069122e-002, 6.071672e-002, 6.074223e-002, 6.076774e-002, 6.079326e-002, 6.081879e-002, 6.084433e-002, 6.086987e-002, 6.089542e-002, 6.092098e-002, 6.094654e-002, 6.097212e-002, 6.099770e-002, 6.102328e-002, 6.104887e-002, 6.107448e-002, 6.110008e-002, 6.112570e-002, 6.115132e-002, 6.117695e-002, 6.120259e-002, 6.122823e-002, 6.125388e-002, 6.127954e-002, 6.130520e-002, 6.133088e-002, 6.135655e-002, 6.138224e-002, 6.140793e-002, 6.143364e-002, 6.145934e-002, 6.148506e-002, 6.151078e-002, 6.153651e-002, 6.156225e-002, 6.158799e-002, 6.161374e-002, 6.163950e-002, 6.166527e-002, 6.169104e-002, 6.171682e-002, 6.174261e-002, 6.176840e-002, 6.179420e-002, 6.182001e-002, 6.184583e-002, 6.187165e-002, 6.189748e-002, 6.192332e-002, 6.194916e-002, 6.197501e-002, 6.200087e-002, 6.202674e-002, 6.205261e-002, 6.207849e-002, 6.210438e-002, 6.213027e-002, 6.215617e-002, 6.218208e-002, 
6.220800e-002, 6.223392e-002, 6.225985e-002, 6.228579e-002, 6.231174e-002, 6.233769e-002, 6.236365e-002, 6.238962e-002, 6.241559e-002, 6.244157e-002, 6.246756e-002, 6.249356e-002, 6.251956e-002, 6.254557e-002, 6.257159e-002, 6.259761e-002, 6.262364e-002, 6.264968e-002, 6.267573e-002, 6.270178e-002, 6.272784e-002, 6.275391e-002, 6.277998e-002, 6.280607e-002, 6.283216e-002, 6.285825e-002, 6.288436e-002, 6.291047e-002, 6.293659e-002, 6.296271e-002, 6.298884e-002, 6.301498e-002, 6.304113e-002, 6.306729e-002, 6.309345e-002, 6.311962e-002, 6.314579e-002, 6.317198e-002, 6.319817e-002, 6.322437e-002, 6.325057e-002, 6.327678e-002, 6.330300e-002, 6.332923e-002, 6.335546e-002, 6.338171e-002, 6.340795e-002, 6.343421e-002, 6.346047e-002, 6.348674e-002, 6.351302e-002, 6.353931e-002, 6.356560e-002, 6.359190e-002, 6.361820e-002, 6.364452e-002, 6.367084e-002, 6.369717e-002, 6.372350e-002, 6.374985e-002, 6.377620e-002, 6.380255e-002, 6.382892e-002, 6.385529e-002, 6.388167e-002, 6.390806e-002, 6.393445e-002, 6.396085e-002, 6.398726e-002, 6.401367e-002, 6.404010e-002, 6.406653e-002, 6.409296e-002, 6.411941e-002, 6.414586e-002, 6.417232e-002, 6.419879e-002, 6.422526e-002, 6.425174e-002, 6.427823e-002, 6.430473e-002, 6.433123e-002, 6.435774e-002, 6.438426e-002, 6.441078e-002, 6.443731e-002, 6.446385e-002, 6.449040e-002, 6.451695e-002, 6.454351e-002, 6.457008e-002, 6.459666e-002, 6.462324e-002, 6.464983e-002, 6.467643e-002, 6.470303e-002, 6.472965e-002, 6.475626e-002, 6.478289e-002, 6.480953e-002, 
6.483617e-002, 6.486282e-002, 6.488947e-002, 6.491613e-002, 6.494281e-002, 6.496948e-002, 6.499617e-002, 6.502286e-002, 6.504956e-002, 6.507627e-002, 6.510298e-002, 6.512970e-002, 6.515643e-002, 6.518317e-002, 6.520991e-002, 6.523666e-002, 6.526342e-002, 6.529019e-002, 6.531696e-002, 6.534374e-002, 6.537053e-002, 6.539732e-002, 6.542413e-002, 6.545093e-002, 6.547775e-002, 6.550458e-002, 6.553141e-002, 6.555825e-002, 6.558509e-002, 6.561195e-002, 6.563881e-002, 6.566567e-002, 6.569255e-002, 6.571943e-002, 6.574632e-002, 6.577322e-002, 6.580012e-002, 6.582704e-002, 6.585396e-002, 6.588088e-002, 6.590782e-002, 6.593476e-002, 6.596171e-002, 6.598866e-002, 6.601563e-002, 6.604260e-002, 6.606958e-002, 6.609656e-002, 6.612355e-002, 6.615055e-002, 6.617756e-002, 6.620458e-002, 6.623160e-002, 6.625863e-002, 6.628567e-002, 6.631271e-002, 6.633976e-002, 6.636682e-002, 6.639389e-002, 6.642096e-002, 6.644804e-002, 6.647513e-002, 6.650223e-002, 6.652933e-002, 6.655644e-002, 6.658356e-002, 6.661068e-002, 6.663782e-002, 6.666496e-002, 6.669210e-002, 6.671926e-002, 6.674642e-002, 6.677359e-002, 6.680077e-002, 6.682795e-002, 6.685514e-002, 6.688234e-002, 6.690955e-002, 6.693676e-002, 6.696398e-002, 6.699121e-002, 6.701845e-002, 6.704569e-002, 6.707294e-002, 6.710020e-002, 6.712747e-002, 6.715474e-002, 6.718202e-002, 6.720931e-002, 6.723660e-002, 6.726390e-002, 6.729121e-002, 6.731853e-002, 6.734585e-002, 6.737319e-002, 6.740053e-002, 6.742787e-002, 6.745523e-002, 6.748259e-002, 6.750996e-002, 
6.753733e-002, 6.756472e-002, 6.759211e-002, 6.761951e-002, 6.764691e-002, 6.767433e-002, 6.770175e-002, 6.772917e-002, 6.775661e-002, 6.778405e-002, 6.781150e-002, 6.783896e-002, 6.786643e-002, 6.789390e-002, 6.792138e-002, 6.794887e-002, 6.797636e-002, 6.800386e-002, 6.803137e-002, 6.805889e-002, 6.808641e-002, 6.811395e-002, 6.814149e-002, 6.816903e-002, 6.819659e-002, 6.822415e-002, 6.825172e-002, 6.827929e-002, 6.830688e-002, 6.833447e-002, 6.836207e-002, 6.838967e-002, 6.841729e-002, 6.844491e-002, 6.847254e-002, 6.850017e-002, 6.852782e-002, 6.855547e-002, 6.858313e-002, 6.861079e-002, 6.863846e-002, 6.866614e-002, 6.869383e-002, 6.872153e-002, 6.874923e-002, 6.877694e-002, 6.880466e-002, 6.883238e-002, 6.886012e-002, 6.888786e-002, 6.891560e-002, 6.894336e-002, 6.897112e-002, 6.899889e-002, 6.902667e-002, 6.905445e-002, 6.908225e-002, 6.911005e-002, 6.913785e-002, 6.916567e-002, 6.919349e-002, 6.922132e-002, 6.924916e-002, 6.927700e-002, 6.930485e-002, 6.933271e-002, 6.936058e-002, 6.938845e-002, 6.941633e-002, 6.944422e-002, 6.947212e-002, 6.950002e-002, 6.952794e-002, 6.955586e-002, 6.958378e-002, 6.961172e-002, 6.963966e-002, 6.966761e-002, 6.969556e-002, 6.972353e-002, 6.975150e-002, 6.977948e-002, 6.980746e-002, 6.983546e-002, 6.986346e-002, 6.989147e-002, 6.991948e-002, 6.994751e-002, 6.997554e-002, 7.000358e-002, 7.003162e-002, 7.005968e-002, 7.008774e-002, 7.011581e-002, 7.014388e-002, 7.017197e-002, 7.020006e-002, 7.022816e-002, 7.025626e-002, 7.028438e-002, 
7.031250e-002, 7.034063e-002, 7.036877e-002, 7.039691e-002, 7.042506e-002, 7.045322e-002, 7.048139e-002, 7.050956e-002, 7.053774e-002, 7.056593e-002, 7.059413e-002, 7.062233e-002, 7.065054e-002, 7.067876e-002, 7.070699e-002, 7.073522e-002, 7.076346e-002, 7.079171e-002, 7.081997e-002, 7.084823e-002, 7.087650e-002, 7.090478e-002, 7.093307e-002, 7.096136e-002, 7.098966e-002, 7.101797e-002, 7.104629e-002, 7.107461e-002, 7.110294e-002, 7.113128e-002, 7.115963e-002, 7.118798e-002, 7.121635e-002, 7.124471e-002, 7.127309e-002, 7.130148e-002, 7.132987e-002, 7.135827e-002, 7.138667e-002, 7.141509e-002, 7.144351e-002, 7.147194e-002, 7.150038e-002, 7.152882e-002, 7.155727e-002, 7.158573e-002, 7.161420e-002, 7.164268e-002, 7.167116e-002, 7.169965e-002, 7.172815e-002, 7.175665e-002, 7.178516e-002, 7.181368e-002, 7.184221e-002, 7.187075e-002, 7.189929e-002, 7.192784e-002, 7.195640e-002, 7.198496e-002, 7.201354e-002, 7.204212e-002, 7.207070e-002, 7.209930e-002, 7.212790e-002, 7.215651e-002, 7.218513e-002, 7.221376e-002, 7.224239e-002, 7.227103e-002, 7.229968e-002, 7.232834e-002, 7.235700e-002, 7.238567e-002, 7.241435e-002, 7.244304e-002, 7.247173e-002, 7.250043e-002, 7.252914e-002, 7.255786e-002, 7.258659e-002, 7.261532e-002, 7.264406e-002, 7.267280e-002, 7.270156e-002, 7.273032e-002, 7.275909e-002, 7.278787e-002, 7.281665e-002, 7.284545e-002, 7.287425e-002, 7.290305e-002, 7.293187e-002, 7.296069e-002, 7.298952e-002, 7.301836e-002, 7.304721e-002, 7.307606e-002, 7.310492e-002, 7.313379e-002, 
7.316267e-002, 7.319155e-002, 7.322044e-002, 7.324934e-002, 7.327825e-002, 7.330716e-002, 7.333608e-002, 7.336501e-002, 7.339395e-002, 7.342289e-002, 7.345185e-002, 7.348081e-002, 7.350977e-002, 7.353875e-002, 7.356773e-002, 7.359672e-002, 7.362572e-002, 7.365473e-002, 7.368374e-002, 7.371276e-002, 7.374179e-002, 7.377082e-002, 7.379987e-002, 7.382892e-002, 7.385798e-002, 7.388704e-002, 7.391612e-002, 7.394520e-002, 7.397429e-002, 7.400339e-002, 7.403249e-002, 7.406160e-002, 7.409072e-002, 7.411985e-002, 7.414899e-002, 7.417813e-002, 7.420728e-002, 7.423644e-002, 7.426560e-002, 7.429478e-002, 7.432396e-002, 7.435315e-002, 7.438234e-002, 7.441155e-002, 7.444076e-002, 7.446998e-002, 7.449920e-002, 7.452844e-002, 7.455768e-002, 7.458693e-002, 7.461619e-002, 7.464545e-002, 7.467473e-002, 7.470401e-002, 7.473329e-002, 7.476259e-002, 7.479189e-002, 7.482120e-002, 7.485052e-002, 7.487985e-002, 7.490918e-002, 7.493852e-002, 7.496787e-002, 7.499723e-002, 7.502660e-002, 7.505597e-002, 7.508535e-002, 7.511473e-002, 7.514413e-002, 7.517353e-002, 7.520294e-002, 7.523236e-002, 7.526179e-002, 7.529122e-002, 7.532066e-002, 7.535011e-002, 7.537957e-002, 7.540903e-002, 7.543850e-002, 7.546798e-002, 7.549747e-002, 7.552697e-002, 7.555647e-002, 7.558598e-002, 7.561550e-002, 7.564502e-002, 7.567456e-002, 7.570410e-002, 7.573365e-002, 7.576320e-002, 7.579277e-002, 7.582234e-002, 7.585192e-002, 7.588151e-002, 7.591110e-002, 7.594070e-002, 7.597031e-002, 7.599993e-002, 7.602956e-002, 7.605919e-002, 
7.608883e-002, 7.611848e-002, 7.614814e-002, 7.617780e-002, 7.620747e-002, 7.623715e-002, 7.626684e-002, 7.629654e-002, 7.632624e-002, 7.635595e-002, 7.638567e-002, 7.641539e-002, 7.644513e-002, 7.647487e-002, 7.650462e-002, 7.653438e-002, 7.656414e-002, 7.659391e-002, 7.662369e-002, 7.665348e-002, 7.668327e-002, 7.671308e-002, 7.674289e-002, 7.677271e-002, 7.680253e-002, 7.683237e-002, 7.686221e-002, 7.689206e-002, 7.692192e-002, 7.695178e-002, 7.698165e-002, 7.701153e-002, 7.704142e-002, 7.707132e-002, 7.710122e-002, 7.713113e-002, 7.716105e-002, 7.719098e-002, 7.722091e-002, 7.725085e-002, 7.728080e-002, 7.731076e-002, 7.734073e-002, 7.737070e-002, 7.740068e-002, 7.743067e-002, 7.746067e-002, 7.749067e-002, 7.752068e-002, 7.755070e-002, 7.758073e-002, 7.761076e-002, 7.764081e-002, 7.767086e-002, 7.770092e-002, 7.773098e-002, 7.776106e-002, 7.779114e-002, 7.782123e-002, 7.785132e-002, 7.788143e-002, 7.791154e-002, 7.794166e-002, 7.797179e-002, 7.800193e-002, 7.803207e-002, 7.806222e-002, 7.809238e-002, 7.812255e-002, 7.815272e-002, 7.818291e-002, 7.821310e-002, 7.824329e-002, 7.827350e-002, 7.830371e-002, 7.833393e-002, 7.836416e-002, 7.839440e-002, 7.842465e-002, 7.845490e-002, 7.848516e-002, 7.851543e-002, 7.854570e-002, 7.857599e-002, 7.860628e-002, 7.863658e-002, 7.866688e-002, 7.869720e-002, 7.872752e-002, 7.875785e-002, 7.878819e-002, 7.881854e-002, 7.884889e-002, 7.887925e-002, 7.890962e-002, 7.894000e-002, 7.897038e-002, 7.900078e-002, 7.903118e-002, 7.906158e-002, 
7.909200e-002, 7.912242e-002, 7.915286e-002, 7.918330e-002, 7.921374e-002, 7.924420e-002, 7.927466e-002, 7.930513e-002, 7.933561e-002, 7.936610e-002, 7.939659e-002, 7.942709e-002, 7.945760e-002, 7.948812e-002, 7.951864e-002, 7.954918e-002, 7.957972e-002, 7.961027e-002, 7.964082e-002, 7.967139e-002, 7.970196e-002, 7.973254e-002, 7.976313e-002, 7.979373e-002, 7.982433e-002, 7.985494e-002, 7.988556e-002, 7.991619e-002, 7.994682e-002, 7.997746e-002, 8.000811e-002, 8.003877e-002, 8.006944e-002, 8.010011e-002, 8.013079e-002, 8.016148e-002, 8.019218e-002, 8.022289e-002, 8.025360e-002, 8.028432e-002, 8.031505e-002, 8.034579e-002, 8.037653e-002, 8.040728e-002, 8.043804e-002, 8.046881e-002, 8.049959e-002, 8.053037e-002, 8.056116e-002, 8.059196e-002, 8.062277e-002, 8.065359e-002, 8.068441e-002, 8.071524e-002, 8.074608e-002, 8.077693e-002, 8.080778e-002, 8.083864e-002, 8.086951e-002, 8.090039e-002, 8.093128e-002, 8.096217e-002, 8.099307e-002, 8.102398e-002, 8.105490e-002, 8.108582e-002, 8.111676e-002, 8.114770e-002, 8.117865e-002, 8.120960e-002, 8.124057e-002, 8.127154e-002, 8.130252e-002, 8.133351e-002, 8.136450e-002, 8.139551e-002, 8.142652e-002, 8.145754e-002, 8.148857e-002, 8.151960e-002, 8.155065e-002, 8.158170e-002, 8.161276e-002, 8.164382e-002, 8.167490e-002, 8.170598e-002, 8.173707e-002, 8.176817e-002, 8.179928e-002, 8.183039e-002, 8.186151e-002, 8.189264e-002, 8.192378e-002, 8.195493e-002, 8.198608e-002, 8.201724e-002, 8.204841e-002, 8.207959e-002, 8.211077e-002, 8.214197e-002, 
8.217317e-002, 8.220438e-002, 8.223559e-002, 8.226682e-002, 8.229805e-002, 8.232929e-002, 8.236054e-002, 8.239180e-002, 8.242306e-002, 8.245433e-002, 8.248561e-002, 8.251690e-002, 8.254820e-002, 8.257950e-002, 8.261081e-002, 8.264213e-002, 8.267346e-002, 8.270479e-002, 8.273614e-002, 8.276749e-002, 8.279885e-002, 8.283022e-002, 8.286159e-002, 8.289297e-002, 8.292436e-002, 8.295576e-002, 8.298717e-002, 8.301858e-002, 8.305001e-002, 8.308144e-002, 8.311288e-002, 8.314432e-002, 8.317578e-002, 8.320724e-002, 8.323871e-002, 8.327019e-002, 8.330167e-002, 8.333317e-002, 8.336467e-002, 8.339618e-002, 8.342770e-002, 8.345922e-002, 8.349076e-002, 8.352230e-002, 8.355385e-002, 8.358541e-002, 8.361697e-002, 8.364854e-002, 8.368013e-002, 8.371172e-002, 8.374331e-002, 8.377492e-002, 8.380653e-002, 8.383815e-002, 8.386978e-002, 8.390142e-002, 8.393306e-002, 8.396472e-002, 8.399638e-002, 8.402805e-002, 8.405972e-002, 8.409141e-002, 8.412310e-002, 8.415480e-002, 8.418651e-002, 8.421823e-002, 8.424995e-002, 8.428168e-002, 8.431342e-002, 8.434517e-002, 8.437693e-002, 8.440869e-002, 8.444047e-002, 8.447225e-002, 8.450403e-002, 8.453583e-002, 8.456764e-002, 8.459945e-002, 8.463127e-002, 8.466310e-002, 8.469493e-002, 8.472678e-002, 8.475863e-002, 8.479049e-002, 8.482236e-002, 8.485423e-002, 8.488612e-002, 8.491801e-002, 8.494991e-002, 8.498182e-002, 8.501373e-002, 8.504566e-002, 8.507759e-002, 8.510953e-002, 8.514148e-002, 8.517343e-002, 8.520540e-002, 8.523737e-002, 8.526935e-002, 8.530134e-002, 
8.533333e-002, 8.536534e-002, 8.539735e-002, 8.542937e-002, 8.546140e-002, 8.549343e-002, 8.552548e-002, 8.555753e-002, 8.558959e-002, 8.562166e-002, 8.565373e-002, 8.568582e-002, 8.571791e-002, 8.575001e-002, 8.578212e-002, 8.581423e-002, 8.584636e-002, 8.587849e-002, 8.591063e-002, 8.594278e-002, 8.597493e-002, 8.600710e-002, 8.603927e-002, 8.607145e-002, 8.610364e-002, 8.613584e-002, 8.616804e-002, 8.620025e-002, 8.623247e-002, 8.626470e-002, 8.629694e-002, 8.632918e-002, 8.636143e-002, 8.639370e-002, 8.642596e-002, 8.645824e-002, 8.649053e-002, 8.652282e-002, 8.655512e-002, 8.658743e-002, 8.661974e-002, 8.665207e-002, 8.668440e-002, 8.671674e-002, 8.674909e-002, 8.678145e-002, 8.681381e-002, 8.684619e-002, 8.687857e-002, 8.691096e-002, 8.694335e-002, 8.697576e-002, 8.700817e-002, 8.704059e-002, 8.707302e-002, 8.710546e-002, 8.713791e-002, 8.717036e-002, 8.720282e-002, 8.723529e-002, 8.726777e-002, 8.730026e-002, 8.733275e-002, 8.736525e-002, 8.739776e-002, 8.743028e-002, 8.746281e-002, 8.749534e-002, 8.752788e-002, 8.756043e-002, 8.759299e-002, 8.762556e-002, 8.765813e-002, 8.769071e-002, 8.772330e-002, 8.775590e-002, 8.778851e-002, 8.782113e-002, 8.785375e-002, 8.788638e-002, 8.791902e-002, 8.795167e-002, 8.798432e-002, 8.801698e-002, 8.804966e-002, 8.808234e-002, 8.811502e-002, 8.814772e-002, 8.818042e-002, 8.821313e-002, 8.824585e-002, 8.827858e-002, 8.831132e-002, 8.834406e-002, 8.837682e-002, 8.840958e-002, 8.844234e-002, 8.847512e-002, 8.850791e-002, 8.854070e-002, 
8.857350e-002, 8.860631e-002, 8.863913e-002, 8.867195e-002, 8.870478e-002, 8.873763e-002, 8.877048e-002, 8.880333e-002, 8.883620e-002, 8.886907e-002, 8.890196e-002, 8.893485e-002, 8.896774e-002, 8.900065e-002, 8.903356e-002, 8.906649e-002, 8.909942e-002, 8.913236e-002, 8.916530e-002, 8.919826e-002, 8.923122e-002, 8.926419e-002, 8.929717e-002, 8.933016e-002, 8.936316e-002, 8.939616e-002, 8.942917e-002, 8.946219e-002, 8.949522e-002, 8.952826e-002, 8.956130e-002, 8.959435e-002, 8.962741e-002, 8.966048e-002, 8.969356e-002, 8.972664e-002, 8.975974e-002, 8.979284e-002, 8.982595e-002, 8.985906e-002, 8.989219e-002, 8.992532e-002, 8.995847e-002, 8.999162e-002, 9.002477e-002, 9.005794e-002, 9.009112e-002, 9.012430e-002, 9.015749e-002, 9.019069e-002, 9.022390e-002, 9.025711e-002, 9.029033e-002, 9.032357e-002, 9.035681e-002, 9.039005e-002, 9.042331e-002, 9.045657e-002, 9.048985e-002, 9.052313e-002, 9.055642e-002, 9.058971e-002, 9.062302e-002, 9.065633e-002, 9.068965e-002, 9.072298e-002, 9.075632e-002, 9.078967e-002, 9.082302e-002, 9.085638e-002, 9.088975e-002, 9.092313e-002, 9.095652e-002, 9.098991e-002, 9.102332e-002, 9.105673e-002, 9.109015e-002, 9.112357e-002, 9.115701e-002, 9.119045e-002, 9.122391e-002, 9.125737e-002, 9.129083e-002, 9.132431e-002, 9.135780e-002, 9.139129e-002, 9.142479e-002, 9.145830e-002, 9.149182e-002, 9.152534e-002, 9.155888e-002, 9.159242e-002, 9.162597e-002, 9.165953e-002, 9.169309e-002, 9.172667e-002, 9.176025e-002, 9.179384e-002, 9.182744e-002, 9.186105e-002, 
9.189467e-002, 9.192829e-002, 9.196192e-002, 9.199556e-002, 9.202921e-002, 9.206287e-002, 9.209653e-002, 9.213021e-002, 9.216389e-002, 9.219758e-002, 9.223128e-002, 9.226498e-002, 9.229870e-002, 9.233242e-002, 9.236615e-002, 9.239989e-002, 9.243364e-002, 9.246739e-002, 9.250116e-002, 9.253493e-002, 9.256871e-002, 9.260250e-002, 9.263629e-002, 9.267010e-002, 9.270391e-002, 9.273773e-002, 9.277156e-002, 9.280540e-002, 9.283924e-002, 9.287310e-002, 9.290696e-002, 9.294083e-002, 9.297471e-002, 9.300860e-002, 9.304249e-002, 9.307640e-002, 9.311031e-002, 9.314423e-002, 9.317816e-002, 9.321209e-002, 9.324604e-002, 9.327999e-002, 9.331395e-002, 9.334792e-002, 9.338190e-002, 9.341588e-002, 9.344988e-002, 9.348388e-002, 9.351789e-002, 9.355191e-002, 9.358594e-002, 9.361997e-002, 9.365402e-002, 9.368807e-002, 9.372213e-002, 9.375620e-002, 9.379027e-002, 9.382436e-002, 9.385845e-002, 9.389255e-002, 9.392666e-002, 9.396078e-002, 9.399491e-002, 9.402904e-002, 9.406318e-002, 9.409733e-002, 9.413149e-002, 9.416566e-002, 9.419984e-002, 9.423402e-002, 9.426821e-002, 9.430241e-002, 9.433662e-002, 9.437084e-002, 9.440507e-002, 9.443930e-002, 9.447354e-002, 9.450779e-002, 9.454205e-002, 9.457632e-002, 9.461059e-002, 9.464488e-002, 9.467917e-002, 9.471347e-002, 9.474778e-002, 9.478209e-002, 9.481642e-002, 9.485075e-002, 9.488509e-002, 9.491944e-002, 9.495380e-002, 9.498816e-002, 9.502254e-002, 9.505692e-002, 9.509131e-002, 9.512571e-002, 9.516012e-002, 9.519454e-002, 9.522896e-002, 9.526339e-002, 
9.529783e-002, 9.533228e-002, 9.536674e-002, 9.540121e-002, 9.543568e-002, 9.547016e-002, 9.550465e-002, 9.553915e-002, 9.557366e-002, 9.560817e-002, 9.564270e-002, 9.567723e-002, 9.571177e-002, 9.574632e-002, 9.578088e-002, 9.581544e-002, 9.585002e-002, 9.588460e-002, 9.591919e-002, 9.595379e-002, 9.598839e-002, 9.602301e-002, 9.605763e-002, 9.609227e-002, 9.612691e-002, 9.616155e-002, 9.619621e-002, 9.623088e-002, 9.626555e-002, 9.630023e-002, 9.633492e-002, 9.636962e-002, 9.640433e-002, 9.643904e-002, 9.647377e-002, 9.650850e-002, 9.654324e-002, 9.657799e-002, 9.661275e-002, 9.664751e-002, 9.668228e-002, 9.671707e-002, 9.675186e-002, 9.678665e-002, 9.682146e-002, 9.685628e-002, 9.689110e-002, 9.692593e-002, 9.696077e-002, 9.699562e-002, 9.703048e-002, 9.706534e-002, 9.710022e-002, 9.713510e-002, 9.716999e-002, 9.720489e-002, 9.723980e-002, 9.727471e-002, 9.730964e-002, 9.734457e-002, 9.737951e-002, 9.741446e-002, 9.744942e-002, 9.748438e-002, 9.751936e-002, 9.755434e-002, 9.758933e-002, 9.762433e-002, 9.765934e-002, 9.769435e-002, 9.772938e-002, 9.776441e-002, 9.779945e-002, 9.783450e-002, 9.786956e-002, 9.790462e-002, 9.793970e-002, 9.797478e-002, 9.800987e-002, 9.804497e-002, 9.808008e-002, 9.811520e-002, 9.815032e-002, 9.818545e-002, 9.822059e-002, 9.825574e-002, 9.829090e-002, 9.832607e-002, 9.836124e-002, 9.839643e-002, 9.843162e-002, 9.846682e-002, 9.850203e-002, 9.853725e-002, 9.857247e-002, 9.860770e-002, 9.864295e-002, 9.867820e-002, 9.871346e-002, 9.874872e-002, 
9.878400e-002, 9.881928e-002, 9.885458e-002, 9.888988e-002, 9.892519e-002, 9.896051e-002, 9.899583e-002, 9.903117e-002, 9.906651e-002, 9.910186e-002, 9.913722e-002, 9.917259e-002, 9.920797e-002, 9.924335e-002, 9.927874e-002, 9.931415e-002, 9.934956e-002, 9.938497e-002, 9.942040e-002, 9.945584e-002, 9.949128e-002, 9.952673e-002, 9.956219e-002, 9.959766e-002, 9.963314e-002, 9.966863e-002, 9.970412e-002, 9.973963e-002, 9.977514e-002, 9.981066e-002, 9.984618e-002, 9.988172e-002, 9.991727e-002, 9.995282e-002, 9.998838e-002, 1.000240e-001, 1.000595e-001, 1.000951e-001, 1.001307e-001, 1.001663e-001, 1.002019e-001, 1.002376e-001, 1.002732e-001, 1.003088e-001, 1.003445e-001, 1.003801e-001, 1.004158e-001, 1.004515e-001, 1.004871e-001, 1.005228e-001, 1.005585e-001, 1.005942e-001, 1.006299e-001, 1.006657e-001, 1.007014e-001, 1.007371e-001, 1.007729e-001, 1.008086e-001, 1.008444e-001, 1.008802e-001, 1.009160e-001, 1.009517e-001, 1.009875e-001, 1.010234e-001, 1.010592e-001, 1.010950e-001, 1.011308e-001, 1.011667e-001, 1.012025e-001, 1.012384e-001, 1.012742e-001, 1.013101e-001, 1.013460e-001, 1.013819e-001, 1.014178e-001, 1.014537e-001, 1.014896e-001, 1.015255e-001, 1.015615e-001, 1.015974e-001, 1.016334e-001, 1.016693e-001, 1.017053e-001, 1.017413e-001, 1.017773e-001, 1.018132e-001, 1.018492e-001, 1.018853e-001, 1.019213e-001, 1.019573e-001, 1.019933e-001, 1.020294e-001, 1.020654e-001, 1.021015e-001, 1.021376e-001, 1.021736e-001, 1.022097e-001, 1.022458e-001, 1.022819e-001, 1.023180e-001, 
1.023542e-001, 1.023903e-001, 1.024264e-001, 1.024626e-001, 1.024987e-001, 1.025349e-001, 1.025711e-001, 1.026072e-001, 1.026434e-001, 1.026796e-001, 1.027158e-001, 1.027521e-001, 1.027883e-001, 1.028245e-001, 1.028608e-001, 1.028970e-001, 1.029333e-001, 1.029695e-001, 1.030058e-001, 1.030421e-001, 1.030784e-001, 1.031147e-001, 1.031510e-001, 1.031873e-001, 1.032236e-001, 1.032600e-001, 1.032963e-001, 1.033326e-001, 1.033690e-001, 1.034054e-001, 1.034417e-001, 1.034781e-001, 1.035145e-001, 1.035509e-001, 1.035873e-001, 1.036238e-001, 1.036602e-001, 1.036966e-001, 1.037331e-001, 1.037695e-001, 1.038060e-001, 1.038424e-001, 1.038789e-001, 1.039154e-001, 1.039519e-001, 1.039884e-001, 1.040249e-001, 1.040614e-001, 1.040980e-001, 1.041345e-001, 1.041711e-001, 1.042076e-001, 1.042442e-001, 1.042808e-001, 1.043173e-001, 1.043539e-001, 1.043905e-001, 1.044271e-001, 1.044637e-001, 1.045004e-001, 1.045370e-001, 1.045736e-001, 1.046103e-001, 1.046470e-001, 1.046836e-001, 1.047203e-001, 1.047570e-001, 1.047937e-001, 1.048304e-001, 1.048671e-001, 1.049038e-001, 1.049405e-001, 1.049773e-001, 1.050140e-001, 1.050508e-001, 1.050875e-001, 1.051243e-001, 1.051611e-001, 1.051979e-001, 1.052346e-001, 1.052715e-001, 1.053083e-001, 1.053451e-001, 1.053819e-001, 1.054188e-001, 1.054556e-001, 1.054925e-001, 1.055293e-001, 1.055662e-001, 1.056031e-001, 1.056400e-001, 1.056769e-001, 1.057138e-001, 1.057507e-001, 1.057876e-001, 1.058245e-001, 1.058615e-001, 1.058984e-001, 1.059354e-001, 1.059724e-001, 
1.060093e-001, 1.060463e-001, 1.060833e-001, 1.061203e-001, 1.061573e-001, 1.061943e-001, 1.062314e-001, 1.062684e-001, 1.063054e-001, 1.063425e-001, 1.063796e-001, 1.064166e-001, 1.064537e-001, 1.064908e-001, 1.065279e-001, 1.065650e-001, 1.066021e-001, 1.066392e-001, 1.066764e-001, 1.067135e-001, 1.067507e-001, 1.067878e-001, 1.068250e-001, 1.068622e-001, 1.068993e-001, 1.069365e-001, 1.069737e-001, 1.070109e-001, 1.070481e-001, 1.070854e-001, 1.071226e-001, 1.071599e-001, 1.071971e-001, 1.072344e-001, 1.072716e-001, 1.073089e-001, 1.073462e-001, 1.073835e-001, 1.074208e-001, 1.074581e-001, 1.074954e-001, 1.075328e-001, 1.075701e-001, 1.076074e-001, 1.076448e-001, 1.076822e-001, 1.077195e-001, 1.077569e-001, 1.077943e-001, 1.078317e-001, 1.078691e-001, 1.079065e-001, 1.079439e-001, 1.079814e-001, 1.080188e-001, 1.080563e-001, 1.080937e-001, 1.081312e-001, 1.081687e-001, 1.082062e-001, 1.082436e-001, 1.082812e-001, 1.083187e-001, 1.083562e-001, 1.083937e-001, 1.084312e-001, 1.084688e-001, 1.085063e-001, 1.085439e-001, 1.085815e-001, 1.086191e-001, 1.086566e-001, 1.086942e-001, 1.087319e-001, 1.087695e-001, 1.088071e-001, 1.088447e-001, 1.088824e-001, 1.089200e-001, 1.089577e-001, 1.089953e-001, 1.090330e-001, 1.090707e-001, 1.091084e-001, 1.091461e-001, 1.091838e-001, 1.092215e-001, 1.092592e-001, 1.092970e-001, 1.093347e-001, 1.093725e-001, 1.094102e-001, 1.094480e-001, 1.094858e-001, 1.095236e-001, 1.095614e-001, 1.095992e-001, 1.096370e-001, 1.096748e-001, 1.097127e-001, 
1.097505e-001, 1.097883e-001, 1.098262e-001, 1.098641e-001, 1.099019e-001, 1.099398e-001, 1.099777e-001, 1.100156e-001, 1.100535e-001, 1.100915e-001, 1.101294e-001, 1.101673e-001, 1.102053e-001, 1.102432e-001, 1.102812e-001, 1.103192e-001, 1.103571e-001, 1.103951e-001, 1.104331e-001, 1.104711e-001, 1.105091e-001, 1.105472e-001, 1.105852e-001, 1.106232e-001, 1.106613e-001, 1.106993e-001, 1.107374e-001, 1.107755e-001, 1.108136e-001, 1.108517e-001, 1.108898e-001, 1.109279e-001, 1.109660e-001, 1.110041e-001, 1.110423e-001, 1.110804e-001, 1.111186e-001, 1.111567e-001, 1.111949e-001, 1.112331e-001, 1.112713e-001, 1.113095e-001, 1.113477e-001, 1.113859e-001, 1.114241e-001, 1.114623e-001, 1.115006e-001, 1.115388e-001, 1.115771e-001, 1.116154e-001, 1.116536e-001, 1.116919e-001, 1.117302e-001, 1.117685e-001, 1.118068e-001, 1.118452e-001, 1.118835e-001, 1.119218e-001, 1.119602e-001, 1.119985e-001, 1.120369e-001, 1.120753e-001, 1.121137e-001, 1.121520e-001, 1.121904e-001, 1.122288e-001, 1.122673e-001, 1.123057e-001, 1.123441e-001, 1.123826e-001, 1.124210e-001, 1.124595e-001, 1.124980e-001, 1.125364e-001, 1.125749e-001, 1.126134e-001, 1.126519e-001, 1.126904e-001, 1.127290e-001, 1.127675e-001, 1.128060e-001, 1.128446e-001, 1.128831e-001, 1.129217e-001, 1.129603e-001, 1.129989e-001, 1.130374e-001, 1.130760e-001, 1.131147e-001, 1.131533e-001, 1.131919e-001, 1.132305e-001, 1.132692e-001, 1.133078e-001, 1.133465e-001, 1.133852e-001, 1.134239e-001, 1.134625e-001, 1.135012e-001, 1.135400e-001, 
1.135787e-001, 1.136174e-001, 1.136561e-001, 1.136949e-001, 1.137336e-001, 1.137724e-001, 1.138111e-001, 1.138499e-001, 1.138887e-001, 1.139275e-001, 1.139663e-001, 1.140051e-001, 1.140439e-001, 1.140828e-001, 1.141216e-001, 1.141605e-001, 1.141993e-001, 1.142382e-001, 1.142771e-001, 1.143159e-001, 1.143548e-001, 1.143937e-001, 1.144326e-001, 1.144716e-001, 1.145105e-001, 1.145494e-001, 1.145884e-001, 1.146273e-001, 1.146663e-001, 1.147053e-001, 1.147442e-001, 1.147832e-001, 1.148222e-001, 1.148612e-001, 1.149002e-001, 1.149393e-001, 1.149783e-001, 1.150173e-001, 1.150564e-001, 1.150954e-001, 1.151345e-001, 1.151736e-001, 1.152127e-001, 1.152518e-001, 1.152909e-001, 1.153300e-001, 1.153691e-001, 1.154082e-001, 1.154474e-001, 1.154865e-001, 1.155257e-001, 1.155649e-001, 1.156040e-001, 1.156432e-001, 1.156824e-001, 1.157216e-001, 1.157608e-001, 1.158000e-001, 1.158393e-001, 1.158785e-001, 1.159177e-001, 1.159570e-001, 1.159963e-001, 1.160355e-001, 1.160748e-001, 1.161141e-001, 1.161534e-001, 1.161927e-001, 1.162320e-001, 1.162713e-001, 1.163107e-001, 1.163500e-001, 1.163894e-001, 1.164287e-001, 1.164681e-001, 1.165075e-001, 1.165469e-001, 1.165863e-001, 1.166257e-001, 1.166651e-001, 1.167045e-001, 1.167439e-001, 1.167834e-001, 1.168228e-001, 1.168623e-001, 1.169018e-001, 1.169412e-001, 1.169807e-001, 1.170202e-001, 1.170597e-001, 1.170992e-001, 1.171387e-001, 1.171783e-001, 1.172178e-001, 1.172574e-001, 1.172969e-001, 1.173365e-001, 1.173761e-001, 1.174156e-001, 1.174552e-001, 
1.174948e-001, 1.175344e-001, 1.175741e-001, 1.176137e-001, 1.176533e-001, 1.176930e-001, 1.177326e-001, 1.177723e-001, 1.178120e-001, 1.178516e-001, 1.178913e-001, 1.179310e-001, 1.179707e-001, 1.180105e-001, 1.180502e-001, 1.180899e-001, 1.181297e-001, 1.181694e-001, 1.182092e-001, 1.182489e-001, 1.182887e-001, 1.183285e-001, 1.183683e-001, 1.184081e-001, 1.184479e-001, 1.184877e-001, 1.185276e-001, 1.185674e-001, 1.186073e-001, 1.186471e-001, 1.186870e-001, 1.187269e-001, 1.187668e-001, 1.188067e-001, 1.188466e-001, 1.188865e-001, 1.189264e-001, 1.189663e-001, 1.190063e-001, 1.190462e-001, 1.190862e-001, 1.191261e-001, 1.191661e-001, 1.192061e-001, 1.192461e-001, 1.192861e-001, 1.193261e-001, 1.193661e-001, 1.194061e-001, 1.194462e-001, 1.194862e-001, 1.195263e-001, 1.195663e-001, 1.196064e-001, 1.196465e-001, 1.196866e-001, 1.197267e-001, 1.197668e-001, 1.198069e-001, 1.198471e-001, 1.198872e-001, 1.199273e-001, 1.199675e-001, 1.200077e-001, 1.200478e-001, 1.200880e-001, 1.201282e-001, 1.201684e-001, 1.202086e-001, 1.202488e-001, 1.202890e-001, 1.203293e-001, 1.203695e-001, 1.204098e-001, 1.204500e-001, 1.204903e-001, 1.205306e-001, 1.205709e-001, 1.206112e-001, 1.206515e-001, 1.206918e-001, 1.207321e-001, 1.207725e-001, 1.208128e-001, 1.208532e-001, 1.208935e-001, 1.209339e-001, 1.209743e-001, 1.210146e-001, 1.210550e-001, 1.210954e-001, 1.211359e-001, 1.211763e-001, 1.212167e-001, 1.212572e-001, 1.212976e-001, 1.213381e-001, 1.213785e-001, 1.214190e-001, 1.214595e-001, 
1.215000e-001, 1.215405e-001, 1.215810e-001, 1.216215e-001, 1.216621e-001, 1.217026e-001, 1.217432e-001, 1.217837e-001, 1.218243e-001, 1.218649e-001, 1.219055e-001, 1.219460e-001, 1.219866e-001, 1.220273e-001, 1.220679e-001, 1.221085e-001, 1.221492e-001, 1.221898e-001, 1.222305e-001, 1.222711e-001, 1.223118e-001, 1.223525e-001, 1.223932e-001, 1.224339e-001, 1.224746e-001, 1.225153e-001, 1.225560e-001, 1.225968e-001, 1.226375e-001, 1.226783e-001, 1.227191e-001, 1.227598e-001, 1.228006e-001, 1.228414e-001, 1.228822e-001, 1.229230e-001, 1.229638e-001, 1.230047e-001, 1.230455e-001, 1.230864e-001, 1.231272e-001, 1.231681e-001, 1.232090e-001, 1.232498e-001, 1.232907e-001, 1.233316e-001, 1.233725e-001, 1.234135e-001, 1.234544e-001, 1.234953e-001, 1.235363e-001, 1.235772e-001, 1.236182e-001, 1.236592e-001, 1.237001e-001, 1.237411e-001, 1.237821e-001, 1.238232e-001, 1.238642e-001, 1.239052e-001, 1.239462e-001, 1.239873e-001, 1.240283e-001, 1.240694e-001, 1.241105e-001, 1.241516e-001, 1.241926e-001, 1.242338e-001, 1.242749e-001, 1.243160e-001, 1.243571e-001, 1.243982e-001, 1.244394e-001, 1.244805e-001, 1.245217e-001, 1.245629e-001, 1.246041e-001, 1.246453e-001, 1.246865e-001, 1.247277e-001, 1.247689e-001, 1.248101e-001, 1.248513e-001, 1.248926e-001, 1.249339e-001, 1.249751e-001, 1.250164e-001, 1.250577e-001, 1.250990e-001, 1.251403e-001, 1.251816e-001, 1.252229e-001, 1.252642e-001, 1.253056e-001, 1.253469e-001, 1.253883e-001, 1.254296e-001, 1.254710e-001, 1.255124e-001, 1.255538e-001, 
1.255952e-001, 1.256366e-001, 1.256780e-001, 1.257194e-001, 1.257609e-001, 1.258023e-001, 1.258438e-001, 1.258852e-001, 1.259267e-001, 1.259682e-001, 1.260097e-001, 1.260512e-001, 1.260927e-001, 1.261342e-001, 1.261757e-001, 1.262173e-001, 1.262588e-001, 1.263004e-001, 1.263419e-001, 1.263835e-001, 1.264251e-001, 1.264667e-001, 1.265083e-001, 1.265499e-001, 1.265915e-001, 1.266331e-001, 1.266748e-001, 1.267164e-001, 1.267581e-001, 1.267997e-001, 1.268414e-001, 1.268831e-001, 1.269248e-001, 1.269665e-001, 1.270082e-001, 1.270499e-001, 1.270917e-001, 1.271334e-001, 1.271751e-001, 1.272169e-001, 1.272587e-001, 1.273004e-001, 1.273422e-001, 1.273840e-001, 1.274258e-001, 1.274676e-001, 1.275094e-001, 1.275513e-001, 1.275931e-001, 1.276350e-001, 1.276768e-001, 1.277187e-001, 1.277606e-001, 1.278024e-001, 1.278443e-001, 1.278862e-001, 1.279281e-001, 1.279701e-001, 1.280120e-001, 1.280539e-001, 1.280959e-001, 1.281378e-001, 1.281798e-001, 1.282218e-001, 1.282638e-001, 1.283058e-001, 1.283478e-001, 1.283898e-001, 1.284318e-001, 1.284738e-001, 1.285159e-001, 1.285579e-001, 1.286000e-001, 1.286420e-001, 1.286841e-001, 1.287262e-001, 1.287683e-001, 1.288104e-001, 1.288525e-001, 1.288946e-001, 1.289368e-001, 1.289789e-001, 1.290211e-001, 1.290632e-001, 1.291054e-001, 1.291476e-001, 1.291898e-001, 1.292320e-001, 1.292742e-001, 1.293164e-001, 1.293586e-001, 1.294008e-001, 1.294431e-001, 1.294853e-001, 1.295276e-001, 1.295698e-001, 1.296121e-001, 1.296544e-001, 1.296967e-001, 1.297390e-001, 
1.297813e-001, 1.298237e-001, 1.298660e-001, 1.299083e-001, 1.299507e-001, 1.299930e-001, 1.300354e-001, 1.300778e-001, 1.301202e-001, 1.301626e-001, 1.302050e-001, 1.302474e-001, 1.302898e-001, 1.303323e-001, 1.303747e-001, 1.304172e-001, 1.304596e-001, 1.305021e-001, 1.305446e-001, 1.305871e-001, 1.306296e-001, 1.306721e-001, 1.307146e-001, 1.307571e-001, 1.307997e-001, 1.308422e-001, 1.308848e-001, 1.309273e-001, 1.309699e-001, 1.310125e-001, 1.310551e-001, 1.310977e-001, 1.311403e-001, 1.311829e-001, 1.312255e-001, 1.312682e-001, 1.313108e-001, 1.313535e-001, 1.313961e-001, 1.314388e-001, 1.314815e-001, 1.315242e-001, 1.315669e-001, 1.316096e-001, 1.316523e-001, 1.316951e-001, 1.317378e-001, 1.317806e-001, 1.318233e-001, 1.318661e-001, 1.319089e-001, 1.319516e-001, 1.319944e-001, 1.320372e-001, 1.320801e-001, 1.321229e-001, 1.321657e-001, 1.322085e-001, 1.322514e-001, 1.322943e-001, 1.323371e-001, 1.323800e-001, 1.324229e-001, 1.324658e-001, 1.325087e-001, 1.325516e-001, 1.325945e-001, 1.326375e-001, 1.326804e-001, 1.327234e-001, 1.327663e-001, 1.328093e-001, 1.328523e-001, 1.328953e-001, 1.329383e-001, 1.329813e-001, 1.330243e-001, 1.330673e-001, 1.331104e-001, 1.331534e-001, 1.331965e-001, 1.332395e-001, 1.332826e-001, 1.333257e-001, 1.333688e-001, 1.334119e-001, 1.334550e-001, 1.334981e-001, 1.335412e-001, 1.335844e-001, 1.336275e-001, 1.336707e-001, 1.337138e-001, 1.337570e-001, 1.338002e-001, 1.338434e-001, 1.338866e-001, 1.339298e-001, 1.339730e-001, 1.340163e-001, 
1.340595e-001, 1.341027e-001, 1.341460e-001, 1.341893e-001, 1.342326e-001, 1.342758e-001, 1.343191e-001, 1.343624e-001, 1.344058e-001, 1.344491e-001, 1.344924e-001, 1.345358e-001, 1.345791e-001, 1.346225e-001, 1.346658e-001, 1.347092e-001, 1.347526e-001, 1.347960e-001, 1.348394e-001, 1.348828e-001, 1.349263e-001, 1.349697e-001, 1.350131e-001, 1.350566e-001, 1.351001e-001, 1.351435e-001, 1.351870e-001, 1.352305e-001, 1.352740e-001, 1.353175e-001, 1.353610e-001, 1.354046e-001, 1.354481e-001, 1.354917e-001, 1.355352e-001, 1.355788e-001, 1.356224e-001, 1.356659e-001, 1.357095e-001, 1.357531e-001, 1.357968e-001, 1.358404e-001, 1.358840e-001, 1.359276e-001, 1.359713e-001, 1.360150e-001, 1.360586e-001, 1.361023e-001, 1.361460e-001, 1.361897e-001, 1.362334e-001, 1.362771e-001, 1.363208e-001, 1.363646e-001, 1.364083e-001, 1.364521e-001, 1.364958e-001, 1.365396e-001, 1.365834e-001, 1.366272e-001, 1.366710e-001, 1.367148e-001, 1.367586e-001, 1.368024e-001, 1.368463e-001, 1.368901e-001, 1.369340e-001, 1.369778e-001, 1.370217e-001, 1.370656e-001, 1.371095e-001, 1.371534e-001, 1.371973e-001, 1.372412e-001, 1.372852e-001, 1.373291e-001, 1.373731e-001, 1.374170e-001, 1.374610e-001, 1.375050e-001, 1.375489e-001, 1.375929e-001, 1.376369e-001, 1.376810e-001, 1.377250e-001, 1.377690e-001, 1.378131e-001, 1.378571e-001, 1.379012e-001, 1.379453e-001, 1.379893e-001, 1.380334e-001, 1.380775e-001, 1.381216e-001, 1.381658e-001, 1.382099e-001, 1.382540e-001, 1.382982e-001, 1.383423e-001, 1.383865e-001, 
1.384307e-001, 1.384749e-001, 1.385190e-001, 1.385632e-001, 1.386075e-001, 1.386517e-001, 1.386959e-001, 1.387402e-001, 1.387844e-001, 1.388287e-001, 1.388729e-001, 1.389172e-001, 1.389615e-001, 1.390058e-001, 1.390501e-001, 1.390944e-001, 1.391388e-001, 1.391831e-001, 1.392274e-001, 1.392718e-001, 1.393161e-001, 1.393605e-001, 1.394049e-001, 1.394493e-001, 1.394937e-001, 1.395381e-001, 1.395825e-001, 1.396270e-001, 1.396714e-001, 1.397158e-001, 1.397603e-001, 1.398048e-001, 1.398492e-001, 1.398937e-001, 1.399382e-001, 1.399827e-001, 1.400272e-001, 1.400718e-001, 1.401163e-001, 1.401608e-001, 1.402054e-001, 1.402500e-001, 1.402945e-001, 1.403391e-001, 1.403837e-001, 1.404283e-001, 1.404729e-001, 1.405175e-001, 1.405622e-001, 1.406068e-001, 1.406514e-001, 1.406961e-001, 1.407408e-001, 1.407854e-001, 1.408301e-001, 1.408748e-001, 1.409195e-001, 1.409642e-001, 1.410089e-001, 1.410537e-001, 1.410984e-001, 1.411432e-001, 1.411879e-001, 1.412327e-001, 1.412775e-001, 1.413223e-001, 1.413671e-001, 1.414119e-001, 1.414567e-001, 1.415015e-001, 1.415464e-001, 1.415912e-001, 1.416361e-001, 1.416809e-001, 1.417258e-001, 1.417707e-001, 1.418156e-001, 1.418605e-001, 1.419054e-001, 1.419503e-001, 1.419952e-001, 1.420402e-001, 1.420851e-001, 1.421301e-001, 1.421750e-001, 1.422200e-001, 1.422650e-001, 1.423100e-001, 1.423550e-001, 1.424000e-001, 1.424451e-001, 1.424901e-001, 1.425351e-001, 1.425802e-001, 1.426253e-001, 1.426703e-001, 1.427154e-001, 1.427605e-001, 1.428056e-001, 1.428507e-001, 
1.428958e-001, 1.429410e-001, 1.429861e-001, 1.430313e-001, 1.430764e-001, 1.431216e-001, 1.431668e-001, 1.432119e-001, 1.432571e-001, 1.433023e-001, 1.433476e-001, 1.433928e-001, 1.434380e-001, 1.434833e-001, 1.435285e-001, 1.435738e-001, 1.436191e-001, 1.436643e-001, 1.437096e-001, 1.437549e-001, 1.438002e-001, 1.438456e-001, 1.438909e-001, 1.439362e-001, 1.439816e-001, 1.440269e-001, 1.440723e-001, 1.441177e-001, 1.441631e-001, 1.442085e-001, 1.442539e-001, 1.442993e-001, 1.443447e-001, 1.443901e-001, 1.444356e-001, 1.444810e-001, 1.445265e-001, 1.445720e-001, 1.446175e-001, 1.446629e-001, 1.447084e-001, 1.447540e-001, 1.447995e-001, 1.448450e-001, 1.448905e-001, 1.449361e-001, 1.449817e-001, 1.450272e-001, 1.450728e-001, 1.451184e-001, 1.451640e-001, 1.452096e-001, 1.452552e-001, 1.453008e-001, 1.453465e-001, 1.453921e-001, 1.454378e-001, 1.454834e-001, 1.455291e-001, 1.455748e-001, 1.456205e-001, 1.456662e-001, 1.457119e-001, 1.457576e-001, 1.458033e-001, 1.458491e-001, 1.458948e-001, 1.459406e-001, 1.459863e-001, 1.460321e-001, 1.460779e-001, 1.461237e-001, 1.461695e-001, 1.462153e-001, 1.462612e-001, 1.463070e-001, 1.463528e-001, 1.463987e-001, 1.464446e-001, 1.464904e-001, 1.465363e-001, 1.465822e-001, 1.466281e-001, 1.466740e-001, 1.467199e-001, 1.467659e-001, 1.468118e-001, 1.468578e-001, 1.469037e-001, 1.469497e-001, 1.469957e-001, 1.470417e-001, 1.470877e-001, 1.471337e-001, 1.471797e-001, 1.472257e-001, 1.472718e-001, 1.473178e-001, 1.473639e-001, 1.474099e-001, 
1.474560e-001, 1.475021e-001, 1.475482e-001, 1.475943e-001, 1.476404e-001, 1.476865e-001, 1.477327e-001, 1.477788e-001, 1.478249e-001, 1.478711e-001, 1.479173e-001, 1.479635e-001, 1.480097e-001, 1.480559e-001, 1.481021e-001, 1.481483e-001, 1.481945e-001, 1.482407e-001, 1.482870e-001, 1.483333e-001, 1.483795e-001, 1.484258e-001, 1.484721e-001, 1.485184e-001, 1.485647e-001, 1.486110e-001, 1.486573e-001, 1.487037e-001, 1.487500e-001, 1.487964e-001, 1.488427e-001, 1.488891e-001, 1.489355e-001, 1.489819e-001, 1.490283e-001, 1.490747e-001, 1.491211e-001, 1.491675e-001, 1.492140e-001, 1.492604e-001, 1.493069e-001, 1.493534e-001, 1.493998e-001, 1.494463e-001, 1.494928e-001, 1.495393e-001, 1.495859e-001, 1.496324e-001, 1.496789e-001, 1.497255e-001, 1.497720e-001, 1.498186e-001, 1.498652e-001, 1.499117e-001, 1.499583e-001, 1.500049e-001, 1.500516e-001, 1.500982e-001, 1.501448e-001, 1.501915e-001, 1.502381e-001, 1.502848e-001, 1.503315e-001, 1.503781e-001, 1.504248e-001, 1.504715e-001, 1.505182e-001, 1.505650e-001, 1.506117e-001, 1.506584e-001, 1.507052e-001, 1.507519e-001, 1.507987e-001, 1.508455e-001, 1.508923e-001, 1.509391e-001, 1.509859e-001, 1.510327e-001, 1.510795e-001, 1.511264e-001, 1.511732e-001, 1.512201e-001, 1.512669e-001, 1.513138e-001, 1.513607e-001, 1.514076e-001, 1.514545e-001, 1.515014e-001, 1.515483e-001, 1.515953e-001, 1.516422e-001, 1.516892e-001, 1.517361e-001, 1.517831e-001, 1.518301e-001, 1.518771e-001, 1.519241e-001, 1.519711e-001, 1.520181e-001, 1.520651e-001, 
1.521122e-001, 1.521592e-001, 1.522063e-001, 1.522533e-001, 1.523004e-001, 1.523475e-001, 1.523946e-001, 1.524417e-001, 1.524888e-001, 1.525360e-001, 1.525831e-001, 1.526302e-001, 1.526774e-001, 1.527246e-001, 1.527717e-001, 1.528189e-001, 1.528661e-001, 1.529133e-001, 1.529605e-001, 1.530078e-001, 1.530550e-001, 1.531023e-001, 1.531495e-001, 1.531968e-001, 1.532440e-001, 1.532913e-001, 1.533386e-001, 1.533859e-001, 1.534332e-001, 1.534806e-001, 1.535279e-001, 1.535752e-001, 1.536226e-001, 1.536699e-001, 1.537173e-001, 1.537647e-001, 1.538121e-001, 1.538595e-001, 1.539069e-001, 1.539543e-001, 1.540017e-001, 1.540492e-001, 1.540966e-001, 1.541441e-001, 1.541916e-001, 1.542390e-001, 1.542865e-001, 1.543340e-001, 1.543815e-001, 1.544290e-001, 1.544766e-001, 1.545241e-001, 1.545716e-001, 1.546192e-001, 1.546668e-001, 1.547143e-001, 1.547619e-001, 1.548095e-001, 1.548571e-001, 1.549047e-001, 1.549524e-001, 1.550000e-001, 1.550476e-001, 1.550953e-001, 1.551430e-001, 1.551906e-001, 1.552383e-001, 1.552860e-001, 1.553337e-001, 1.553814e-001, 1.554291e-001, 1.554769e-001, 1.555246e-001, 1.555724e-001, 1.556201e-001, 1.556679e-001, 1.557157e-001, 1.557635e-001, 1.558113e-001, 1.558591e-001, 1.559069e-001, 1.559547e-001, 1.560026e-001, 1.560504e-001, 1.560983e-001, 1.561461e-001, 1.561940e-001, 1.562419e-001, 1.562898e-001, 1.563377e-001, 1.563856e-001, 1.564336e-001, 1.564815e-001, 1.565294e-001, 1.565774e-001, 1.566254e-001, 1.566733e-001, 1.567213e-001, 1.567693e-001, 1.568173e-001, 
1.568653e-001, 1.569134e-001, 1.569614e-001, 1.570094e-001, 1.570575e-001, 1.571056e-001, 1.571536e-001, 1.572017e-001, 1.572498e-001, 1.572979e-001, 1.573460e-001, 1.573941e-001, 1.574423e-001, 1.574904e-001, 1.575386e-001, 1.575867e-001, 1.576349e-001, 1.576831e-001, 1.577313e-001, 1.577795e-001, 1.578277e-001, 1.578759e-001, 1.579241e-001, 1.579724e-001, 1.580206e-001, 1.580689e-001, 1.581172e-001, 1.581654e-001, 1.582137e-001, 1.582620e-001, 1.583103e-001, 1.583587e-001, 1.584070e-001, 1.584553e-001, 1.585037e-001, 1.585520e-001, 1.586004e-001, 1.586488e-001, 1.586972e-001, 1.587456e-001, 1.587940e-001, 1.588424e-001, 1.588908e-001, 1.589393e-001, 1.589877e-001, 1.590362e-001, 1.590846e-001, 1.591331e-001, 1.591816e-001, 1.592301e-001, 1.592786e-001, 1.593271e-001, 1.593756e-001, 1.594242e-001, 1.594727e-001, 1.595213e-001, 1.595698e-001, 1.596184e-001, 1.596670e-001, 1.597156e-001, 1.597642e-001, 1.598128e-001, 1.598614e-001, 1.599101e-001, 1.599587e-001, 1.600074e-001, 1.600560e-001, 1.601047e-001, 1.601534e-001, 1.602021e-001, 1.602508e-001, 1.602995e-001, 1.603482e-001, 1.603970e-001, 1.604457e-001, 1.604945e-001, 1.605432e-001, 1.605920e-001, 1.606408e-001, 1.606896e-001, 1.607384e-001, 1.607872e-001, 1.608360e-001, 1.608848e-001, 1.609337e-001, 1.609825e-001, 1.610314e-001, 1.610803e-001, 1.611292e-001, 1.611780e-001, 1.612269e-001, 1.612759e-001, 1.613248e-001, 1.613737e-001, 1.614226e-001, 1.614716e-001, 1.615206e-001, 1.615695e-001, 1.616185e-001, 1.616675e-001, 
1.617165e-001, 1.617655e-001, 1.618145e-001, 1.618636e-001, 1.619126e-001, 1.619616e-001, 1.620107e-001, 1.620598e-001, 1.621089e-001, 1.621579e-001, 1.622070e-001, 1.622562e-001, 1.623053e-001, 1.623544e-001, 1.624035e-001, 1.624527e-001, 1.625018e-001, 1.625510e-001, 1.626002e-001, 1.626494e-001, 1.626986e-001, 1.627478e-001, 1.627970e-001, 1.628462e-001, 1.628955e-001, 1.629447e-001, 1.629940e-001, 1.630432e-001, 1.630925e-001, 1.631418e-001, 1.631911e-001, 1.632404e-001, 1.632897e-001, 1.633391e-001, 1.633884e-001, 1.634377e-001, 1.634871e-001, 1.635365e-001, 1.635858e-001, 1.636352e-001, 1.636846e-001, 1.637340e-001, 1.637835e-001, 1.638329e-001, 1.638823e-001, 1.639318e-001, 1.639812e-001, 1.640307e-001, 1.640802e-001, 1.641296e-001, 1.641791e-001, 1.642287e-001, 1.642782e-001, 1.643277e-001, 1.643772e-001, 1.644268e-001, 1.644763e-001, 1.645259e-001, 1.645755e-001, 1.646251e-001, 1.646747e-001, 1.647243e-001, 1.647739e-001, 1.648235e-001, 1.648731e-001, 1.649228e-001, 1.649724e-001, 1.650221e-001, 1.650718e-001, 1.651215e-001, 1.651712e-001, 1.652209e-001, 1.652706e-001, 1.653203e-001, 1.653700e-001, 1.654198e-001, 1.654695e-001, 1.655193e-001, 1.655691e-001, 1.656189e-001, 1.656687e-001, 1.657185e-001, 1.657683e-001, 1.658181e-001, 1.658679e-001, 1.659178e-001, 1.659676e-001, 1.660175e-001, 1.660674e-001, 1.661173e-001, 1.661672e-001, 1.662171e-001, 1.662670e-001, 1.663169e-001, 1.663668e-001, 1.664168e-001, 1.664667e-001, 1.665167e-001, 1.665667e-001, 1.666167e-001, 
1.666667e-001, 1.666667e-001
}
};

static double T_FFD_B_d[4][MAX_FFD] = {
{
-5.000000e-001, -4.999000e-001, -4.998000e-001, -4.997000e-001, -4.996001e-001, -4.995001e-001, -4.994002e-001, -4.993002e-001, -4.992003e-001, -4.991004e-001, -4.990005e-001, -4.989006e-001, -4.988007e-001, -4.987008e-001, -4.986010e-001, -4.985011e-001, -4.984013e-001, -4.983014e-001, -4.982016e-001, -4.981018e-001, -4.980020e-001, -4.979022e-001, -4.978024e-001, -4.977026e-001, -4.976029e-001, -4.975031e-001, -4.974034e-001, -4.973036e-001, -4.972039e-001, -4.971042e-001, -4.970045e-001, -4.969048e-001, -4.968051e-001, -4.967054e-001, -4.966058e-001, -4.965061e-001, -4.964065e-001, -4.963068e-001, -4.962072e-001, -4.961076e-001, -4.960080e-001, -4.959084e-001, -4.958088e-001, -4.957092e-001, -4.956097e-001, -4.955101e-001, -4.954106e-001, -4.953110e-001, -4.952115e-001, -4.951120e-001, -4.950125e-001, -4.949130e-001, -4.948135e-001, -4.947140e-001, -4.946146e-001, -4.945151e-001, -4.944157e-001, -4.943162e-001, -4.942168e-001, -4.941174e-001, -4.940180e-001, -4.939186e-001, -4.938192e-001, -4.937198e-001, -4.936205e-001, -4.935211e-001, -4.934218e-001, -4.933224e-001, -4.932231e-001, -4.931238e-001, -4.930245e-001, -4.929252e-001, -4.928259e-001, -4.927266e-001, -4.926274e-001, -4.925281e-001, -4.924289e-001, -4.923296e-001, -4.922304e-001, -4.921312e-001, -4.920320e-001, -4.919328e-001, -4.918336e-001, -4.917344e-001, -4.916353e-001, -4.915361e-001, -4.914370e-001, -4.913378e-001, -4.912387e-001, -4.911396e-001, -4.910405e-001, -4.909414e-001, -4.908423e-001, -4.907432e-001, -4.906442e-001, -4.905451e-001, -4.904461e-001, -4.903470e-001, -4.902480e-001, -4.901490e-001, 
-4.900500e-001, -4.899510e-001, -4.898520e-001, -4.897530e-001, -4.896541e-001, -4.895551e-001, -4.894562e-001, -4.893572e-001, -4.892583e-001, -4.891594e-001, -4.890605e-001, -4.889616e-001, -4.888627e-001, -4.887638e-001, -4.886650e-001, -4.885661e-001, -4.884673e-001, -4.883684e-001, -4.882696e-001, -4.881708e-001, -4.880720e-001, -4.879732e-001, -4.878744e-001, -4.877756e-001, -4.876769e-001, -4.875781e-001, -4.874794e-001, -4.873806e-001, -4.872819e-001, -4.871832e-001, -4.870845e-001, -4.869858e-001, -4.868871e-001, -4.867884e-001, -4.866898e-001, -4.865911e-001, -4.864925e-001, -4.863938e-001, -4.862952e-001, -4.861966e-001, -4.860980e-001, -4.859994e-001, -4.859008e-001, -4.858022e-001, -4.857037e-001, -4.856051e-001, -4.855066e-001, -4.854080e-001, -4.853095e-001, -4.852110e-001, -4.851125e-001, -4.850140e-001, -4.849155e-001, -4.848170e-001, -4.847186e-001, -4.846201e-001, -4.845217e-001, -4.844232e-001, -4.843248e-001, -4.842264e-001, -4.841280e-001, -4.840296e-001, -4.839312e-001, -4.838328e-001, -4.837345e-001, -4.836361e-001, -4.835378e-001, -4.834394e-001, -4.833411e-001, -4.832428e-001, -4.831445e-001, -4.830462e-001, -4.829479e-001, -4.828496e-001, -4.827514e-001, -4.826531e-001, -4.825549e-001, -4.824566e-001, -4.823584e-001, -4.822602e-001, -4.821620e-001, -4.820638e-001, -4.819656e-001, -4.818674e-001, -4.817693e-001, -4.816711e-001, -4.815730e-001, -4.814748e-001, -4.813767e-001, -4.812786e-001, -4.811805e-001, -4.810824e-001, -4.809843e-001, -4.808862e-001, -4.807882e-001, -4.806901e-001, -4.805921e-001, -4.804940e-001, -4.803960e-001, -4.802980e-001, 
-4.802000e-001, -4.801020e-001, -4.800040e-001, -4.799060e-001, -4.798081e-001, -4.797101e-001, -4.796122e-001, -4.795142e-001, -4.794163e-001, -4.793184e-001, -4.792205e-001, -4.791226e-001, -4.790247e-001, -4.789268e-001, -4.788290e-001, -4.787311e-001, -4.786333e-001, -4.785354e-001, -4.784376e-001, -4.783398e-001, -4.782420e-001, -4.781442e-001, -4.780464e-001, -4.779486e-001, -4.778509e-001, -4.777531e-001, -4.776554e-001, -4.775576e-001, -4.774599e-001, -4.773622e-001, -4.772645e-001, -4.771668e-001, -4.770691e-001, -4.769714e-001, -4.768738e-001, -4.767761e-001, -4.766785e-001, -4.765808e-001, -4.764832e-001, -4.763856e-001, -4.762880e-001, -4.761904e-001, -4.760928e-001, -4.759952e-001, -4.758977e-001, -4.758001e-001, -4.757026e-001, -4.756050e-001, -4.755075e-001, -4.754100e-001, -4.753125e-001, -4.752150e-001, -4.751175e-001, -4.750200e-001, -4.749226e-001, -4.748251e-001, -4.747277e-001, -4.746302e-001, -4.745328e-001, -4.744354e-001, -4.743380e-001, -4.742406e-001, -4.741432e-001, -4.740458e-001, -4.739485e-001, -4.738511e-001, -4.737538e-001, -4.736564e-001, -4.735591e-001, -4.734618e-001, -4.733645e-001, -4.732672e-001, -4.731699e-001, -4.730726e-001, -4.729754e-001, -4.728781e-001, -4.727809e-001, -4.726836e-001, -4.725864e-001, -4.724892e-001, -4.723920e-001, -4.722948e-001, -4.721976e-001, -4.721004e-001, -4.720033e-001, -4.719061e-001, -4.718090e-001, -4.717118e-001, -4.716147e-001, -4.715176e-001, -4.714205e-001, -4.713234e-001, -4.712263e-001, -4.711292e-001, -4.710322e-001, -4.709351e-001, -4.708381e-001, -4.707410e-001, -4.706440e-001, -4.705470e-001, 
-4.704500e-001, -4.703530e-001, -4.702560e-001, -4.701590e-001, -4.700621e-001, -4.699651e-001, -4.698682e-001, -4.697712e-001, -4.696743e-001, -4.695774e-001, -4.694805e-001, -4.693836e-001, -4.692867e-001, -4.691898e-001, -4.690930e-001, -4.689961e-001, -4.688993e-001, -4.688024e-001, -4.687056e-001, -4.686088e-001, -4.685120e-001, -4.684152e-001, -4.683184e-001, -4.682216e-001, -4.681249e-001, -4.680281e-001, -4.679314e-001, -4.678346e-001, -4.677379e-001, -4.676412e-001, -4.675445e-001, -4.674478e-001, -4.673511e-001, -4.672544e-001, -4.671578e-001, -4.670611e-001, -4.669645e-001, -4.668678e-001, -4.667712e-001, -4.666746e-001, -4.665780e-001, -4.664814e-001, -4.663848e-001, -4.662882e-001, -4.661917e-001, -4.660951e-001, -4.659986e-001, -4.659020e-001, -4.658055e-001, -4.657090e-001, -4.656125e-001, -4.655160e-001, -4.654195e-001, -4.653230e-001, -4.652266e-001, -4.651301e-001, -4.650337e-001, -4.649372e-001, -4.648408e-001, -4.647444e-001, -4.646480e-001, -4.645516e-001, -4.644552e-001, -4.643588e-001, -4.642625e-001, -4.641661e-001, -4.640698e-001, -4.639734e-001, -4.638771e-001, -4.637808e-001, -4.636845e-001, -4.635882e-001, -4.634919e-001, -4.633956e-001, -4.632994e-001, -4.632031e-001, -4.631069e-001, -4.630106e-001, -4.629144e-001, -4.628182e-001, -4.627220e-001, -4.626258e-001, -4.625296e-001, -4.624334e-001, -4.623373e-001, -4.622411e-001, -4.621450e-001, -4.620488e-001, -4.619527e-001, -4.618566e-001, -4.617605e-001, -4.616644e-001, -4.615683e-001, -4.614722e-001, -4.613762e-001, -4.612801e-001, -4.611841e-001, -4.610880e-001, -4.609920e-001, -4.608960e-001, 
-4.608000e-001, -4.607040e-001, -4.606080e-001, -4.605120e-001, -4.604161e-001, -4.603201e-001, -4.602242e-001, -4.601282e-001, -4.600323e-001, -4.599364e-001, -4.598405e-001, -4.597446e-001, -4.596487e-001, -4.595528e-001, -4.594570e-001, -4.593611e-001, -4.592653e-001, -4.591694e-001, -4.590736e-001, -4.589778e-001, -4.588820e-001, -4.587862e-001, -4.586904e-001, -4.585946e-001, -4.584989e-001, -4.584031e-001, -4.583074e-001, -4.582116e-001, -4.581159e-001, -4.580202e-001, -4.579245e-001, -4.578288e-001, -4.577331e-001, -4.576374e-001, -4.575418e-001, -4.574461e-001, -4.573505e-001, -4.572548e-001, -4.571592e-001, -4.570636e-001, -4.569680e-001, -4.568724e-001, -4.567768e-001, -4.566812e-001, -4.565857e-001, -4.564901e-001, -4.563946e-001, -4.562990e-001, -4.562035e-001, -4.561080e-001, -4.560125e-001, -4.559170e-001, -4.558215e-001, -4.557260e-001, -4.556306e-001, -4.555351e-001, -4.554397e-001, -4.553442e-001, -4.552488e-001, -4.551534e-001, -4.550580e-001, -4.549626e-001, -4.548672e-001, -4.547718e-001, -4.546765e-001, -4.545811e-001, -4.544858e-001, -4.543904e-001, -4.542951e-001, -4.541998e-001, -4.541045e-001, -4.540092e-001, -4.539139e-001, -4.538186e-001, -4.537234e-001, -4.536281e-001, -4.535329e-001, -4.534376e-001, -4.533424e-001, -4.532472e-001, -4.531520e-001, -4.530568e-001, -4.529616e-001, -4.528664e-001, -4.527713e-001, -4.526761e-001, -4.525810e-001, -4.524858e-001, -4.523907e-001, -4.522956e-001, -4.522005e-001, -4.521054e-001, -4.520103e-001, -4.519152e-001, -4.518202e-001, -4.517251e-001, -4.516301e-001, -4.515350e-001, -4.514400e-001, -4.513450e-001, 
-4.512500e-001, -4.511550e-001, -4.510600e-001, -4.509650e-001, -4.508701e-001, -4.507751e-001, -4.506802e-001, -4.505852e-001, -4.504903e-001, -4.503954e-001, -4.503005e-001, -4.502056e-001, -4.501107e-001, -4.500158e-001, -4.499210e-001, -4.498261e-001, -4.497313e-001, -4.496364e-001, -4.495416e-001, -4.494468e-001, -4.493520e-001, -4.492572e-001, -4.491624e-001, -4.490676e-001, -4.489729e-001, -4.488781e-001, -4.487834e-001, -4.486886e-001, -4.485939e-001, -4.484992e-001, -4.484045e-001, -4.483098e-001, -4.482151e-001, -4.481204e-001, -4.480258e-001, -4.479311e-001, -4.478365e-001, -4.477418e-001, -4.476472e-001, -4.475526e-001, -4.474580e-001, -4.473634e-001, -4.472688e-001, -4.471742e-001, -4.470797e-001, -4.469851e-001, -4.468906e-001, -4.467960e-001, -4.467015e-001, -4.466070e-001, -4.465125e-001, -4.464180e-001, -4.463235e-001, -4.462290e-001, -4.461346e-001, -4.460401e-001, -4.459457e-001, -4.458512e-001, -4.457568e-001, -4.456624e-001, -4.455680e-001, -4.454736e-001, -4.453792e-001, -4.452848e-001, -4.451905e-001, -4.450961e-001, -4.450018e-001, -4.449074e-001, -4.448131e-001, -4.447188e-001, -4.446245e-001, -4.445302e-001, -4.444359e-001, -4.443416e-001, -4.442474e-001, -4.441531e-001, -4.440589e-001, -4.439646e-001, -4.438704e-001, -4.437762e-001, -4.436820e-001, -4.435878e-001, -4.434936e-001, -4.433994e-001, -4.433053e-001, -4.432111e-001, -4.431170e-001, -4.430228e-001, -4.429287e-001, -4.428346e-001, -4.427405e-001, -4.426464e-001, -4.425523e-001, -4.424582e-001, -4.423642e-001, -4.422701e-001, -4.421761e-001, -4.420820e-001, -4.419880e-001, -4.418940e-001, 
-4.418000e-001, -4.417060e-001, -4.416120e-001, -4.415180e-001, -4.414241e-001, -4.413301e-001, -4.412362e-001, -4.411422e-001, -4.410483e-001, -4.409544e-001, -4.408605e-001, -4.407666e-001, -4.406727e-001, -4.405788e-001, -4.404850e-001, -4.403911e-001, -4.402973e-001, -4.402034e-001, -4.401096e-001, -4.400158e-001, -4.399220e-001, -4.398282e-001, -4.397344e-001, -4.396406e-001, -4.395469e-001, -4.394531e-001, -4.393594e-001, -4.392656e-001, -4.391719e-001, -4.390782e-001, -4.389845e-001, -4.388908e-001, -4.387971e-001, -4.387034e-001, -4.386098e-001, -4.385161e-001, -4.384225e-001, -4.383288e-001, -4.382352e-001, -4.381416e-001, -4.380480e-001, -4.379544e-001, -4.378608e-001, -4.377672e-001, -4.376737e-001, -4.375801e-001, -4.374866e-001, -4.373930e-001, -4.372995e-001, -4.372060e-001, -4.371125e-001, -4.370190e-001, -4.369255e-001, -4.368320e-001, -4.367386e-001, -4.366451e-001, -4.365517e-001, -4.364582e-001, -4.363648e-001, -4.362714e-001, -4.361780e-001, -4.360846e-001, -4.359912e-001, -4.358978e-001, -4.358045e-001, -4.357111e-001, -4.356178e-001, -4.355244e-001, -4.354311e-001, -4.353378e-001, -4.352445e-001, -4.351512e-001, -4.350579e-001, -4.349646e-001, -4.348714e-001, -4.347781e-001, -4.346849e-001, -4.345916e-001, -4.344984e-001, -4.344052e-001, -4.343120e-001, -4.342188e-001, -4.341256e-001, -4.340324e-001, -4.339393e-001, -4.338461e-001, -4.337530e-001, -4.336598e-001, -4.335667e-001, -4.334736e-001, -4.333805e-001, -4.332874e-001, -4.331943e-001, -4.331012e-001, -4.330082e-001, -4.329151e-001, -4.328221e-001, -4.327290e-001, -4.326360e-001, -4.325430e-001, 
-4.324500e-001, -4.323570e-001, -4.322640e-001, -4.321710e-001, -4.320781e-001, -4.319851e-001, -4.318922e-001, -4.317992e-001, -4.317063e-001, -4.316134e-001, -4.315205e-001, -4.314276e-001, -4.313347e-001, -4.312418e-001, -4.311490e-001, -4.310561e-001, -4.309633e-001, -4.308704e-001, -4.307776e-001, -4.306848e-001, -4.305920e-001, -4.304992e-001, -4.304064e-001, -4.303136e-001, -4.302209e-001, -4.301281e-001, -4.300354e-001, -4.299426e-001, -4.298499e-001, -4.297572e-001, -4.296645e-001, -4.295718e-001, -4.294791e-001, -4.293864e-001, -4.292938e-001, -4.292011e-001, -4.291085e-001, -4.290158e-001, -4.289232e-001, -4.288306e-001, -4.287380e-001, -4.286454e-001, -4.285528e-001, -4.284602e-001, -4.283677e-001, -4.282751e-001, -4.281826e-001, -4.280900e-001, -4.279975e-001, -4.279050e-001, -4.278125e-001, -4.277200e-001, -4.276275e-001, -4.275350e-001, -4.274426e-001, -4.273501e-001, -4.272577e-001, -4.271652e-001, -4.270728e-001, -4.269804e-001, -4.268880e-001, -4.267956e-001, -4.267032e-001, -4.266108e-001, -4.265185e-001, -4.264261e-001, -4.263338e-001, -4.262414e-001, -4.261491e-001, -4.260568e-001, -4.259645e-001, -4.258722e-001, -4.257799e-001, -4.256876e-001, -4.255954e-001, -4.255031e-001, -4.254109e-001, -4.253186e-001, -4.252264e-001, -4.251342e-001, -4.250420e-001, -4.249498e-001, -4.248576e-001, -4.247654e-001, -4.246733e-001, -4.245811e-001, -4.244890e-001, -4.243968e-001, -4.243047e-001, -4.242126e-001, -4.241205e-001, -4.240284e-001, -4.239363e-001, -4.238442e-001, -4.237522e-001, -4.236601e-001, -4.235681e-001, -4.234760e-001, -4.233840e-001, -4.232920e-001, 
-4.232000e-001, -4.231080e-001, -4.230160e-001, -4.229240e-001, -4.228321e-001, -4.227401e-001, -4.226482e-001, -4.225562e-001, -4.224643e-001, -4.223724e-001, -4.222805e-001, -4.221886e-001, -4.220967e-001, -4.220048e-001, -4.219130e-001, -4.218211e-001, -4.217293e-001, -4.216374e-001, -4.215456e-001, -4.214538e-001, -4.213620e-001, -4.212702e-001, -4.211784e-001, -4.210866e-001, -4.209949e-001, -4.209031e-001, -4.208114e-001, -4.207196e-001, -4.206279e-001, -4.205362e-001, -4.204445e-001, -4.203528e-001, -4.202611e-001, -4.201694e-001, -4.200778e-001, -4.199861e-001, -4.198945e-001, -4.198028e-001, -4.197112e-001, -4.196196e-001, -4.195280e-001, -4.194364e-001, -4.193448e-001, -4.192532e-001, -4.191617e-001, -4.190701e-001, -4.189786e-001, -4.188870e-001, -4.187955e-001, -4.187040e-001, -4.186125e-001, -4.185210e-001, -4.184295e-001, -4.183380e-001, -4.182466e-001, -4.181551e-001, -4.180637e-001, -4.179722e-001, -4.178808e-001, -4.177894e-001, -4.176980e-001, -4.176066e-001, -4.175152e-001, -4.174238e-001, -4.173325e-001, -4.172411e-001, -4.171498e-001, -4.170584e-001, -4.169671e-001, -4.168758e-001, -4.167845e-001, -4.166932e-001, -4.166019e-001, -4.165106e-001, -4.164194e-001, -4.163281e-001, -4.162369e-001, -4.161456e-001, -4.160544e-001, -4.159632e-001, -4.158720e-001, -4.157808e-001, -4.156896e-001, -4.155984e-001, -4.155073e-001, -4.154161e-001, -4.153250e-001, -4.152338e-001, -4.151427e-001, -4.150516e-001, -4.149605e-001, -4.148694e-001, -4.147783e-001, -4.146872e-001, -4.145962e-001, -4.145051e-001, -4.144141e-001, -4.143230e-001, -4.142320e-001, -4.141410e-001, 
-4.140500e-001, -4.139590e-001, -4.138680e-001, -4.137770e-001, -4.136861e-001, -4.135951e-001, -4.135042e-001, -4.134132e-001, -4.133223e-001, -4.132314e-001, -4.131405e-001, -4.130496e-001, -4.129587e-001, -4.128678e-001, -4.127770e-001, -4.126861e-001, -4.125953e-001, -4.125044e-001, -4.124136e-001, -4.123228e-001, -4.122320e-001, -4.121412e-001, -4.120504e-001, -4.119596e-001, -4.118689e-001, -4.117781e-001, -4.116874e-001, -4.115966e-001, -4.115059e-001, -4.114152e-001, -4.113245e-001, -4.112338e-001, -4.111431e-001, -4.110524e-001, -4.109618e-001, -4.108711e-001, -4.107805e-001, -4.106898e-001, -4.105992e-001, -4.105086e-001, -4.104180e-001, -4.103274e-001, -4.102368e-001, -4.101462e-001, -4.100557e-001, -4.099651e-001, -4.098746e-001, -4.097840e-001, -4.096935e-001, -4.096030e-001, -4.095125e-001, -4.094220e-001, -4.093315e-001, -4.092410e-001, -4.091506e-001, -4.090601e-001, -4.089697e-001, -4.088792e-001, -4.087888e-001, -4.086984e-001, -4.086080e-001, -4.085176e-001, -4.084272e-001, -4.083368e-001, -4.082465e-001, -4.081561e-001, -4.080658e-001, -4.079754e-001, -4.078851e-001, -4.077948e-001, -4.077045e-001, -4.076142e-001, -4.075239e-001, -4.074336e-001, -4.073434e-001, -4.072531e-001, -4.071629e-001, -4.070726e-001, -4.069824e-001, -4.068922e-001, -4.068020e-001, -4.067118e-001, -4.066216e-001, -4.065314e-001, -4.064413e-001, -4.063511e-001, -4.062610e-001, -4.061708e-001, -4.060807e-001, -4.059906e-001, -4.059005e-001, -4.058104e-001, -4.057203e-001, -4.056302e-001, -4.055402e-001, -4.054501e-001, -4.053601e-001, -4.052700e-001, -4.051800e-001, -4.050900e-001, 
-4.050000e-001, -4.049100e-001, -4.048200e-001, -4.047300e-001, -4.046401e-001, -4.045501e-001, -4.044602e-001, -4.043702e-001, -4.042803e-001, -4.041904e-001, -4.041005e-001, -4.040106e-001, -4.039207e-001, -4.038308e-001, -4.037410e-001, -4.036511e-001, -4.035613e-001, -4.034714e-001, -4.033816e-001, -4.032918e-001, -4.032020e-001, -4.031122e-001, -4.030224e-001, -4.029326e-001, -4.028429e-001, -4.027531e-001, -4.026634e-001, -4.025736e-001, -4.024839e-001, -4.023942e-001, -4.023045e-001, -4.022148e-001, -4.021251e-001, -4.020354e-001, -4.019458e-001, -4.018561e-001, -4.017665e-001, -4.016768e-001, -4.015872e-001, -4.014976e-001, -4.014080e-001, -4.013184e-001, -4.012288e-001, -4.011392e-001, -4.010497e-001, -4.009601e-001, -4.008706e-001, -4.007810e-001, -4.006915e-001, -4.006020e-001, -4.005125e-001, -4.004230e-001, -4.003335e-001, -4.002440e-001, -4.001546e-001, -4.000651e-001, -3.999757e-001, -3.998862e-001, -3.997968e-001, -3.997074e-001, -3.996180e-001, -3.995286e-001, -3.994392e-001, -3.993498e-001, -3.992605e-001, -3.991711e-001, -3.990818e-001, -3.989924e-001, -3.989031e-001, -3.988138e-001, -3.987245e-001, -3.986352e-001, -3.985459e-001, -3.984566e-001, -3.983674e-001, -3.982781e-001, -3.981889e-001, -3.980996e-001, -3.980104e-001, -3.979212e-001, -3.978320e-001, -3.977428e-001, -3.976536e-001, -3.975644e-001, -3.974753e-001, -3.973861e-001, -3.972970e-001, -3.972078e-001, -3.971187e-001, -3.970296e-001, -3.969405e-001, -3.968514e-001, -3.967623e-001, -3.966732e-001, -3.965842e-001, -3.964951e-001, -3.964061e-001, -3.963170e-001, -3.962280e-001, -3.961390e-001, 
-3.960500e-001, -3.959610e-001, -3.958720e-001, -3.957830e-001, -3.956941e-001, -3.956051e-001, -3.955162e-001, -3.954272e-001, -3.953383e-001, -3.952494e-001, -3.951605e-001, -3.950716e-001, -3.949827e-001, -3.948938e-001, -3.948050e-001, -3.947161e-001, -3.946273e-001, -3.945384e-001, -3.944496e-001, -3.943608e-001, -3.942720e-001, -3.941832e-001, -3.940944e-001, -3.940056e-001, -3.939169e-001, -3.938281e-001, -3.937394e-001, -3.936506e-001, -3.935619e-001, -3.934732e-001, -3.933845e-001, -3.932958e-001, -3.932071e-001, -3.931184e-001, -3.930298e-001, -3.929411e-001, -3.928525e-001, -3.927638e-001, -3.926752e-001, -3.925866e-001, -3.924980e-001, -3.924094e-001, -3.923208e-001, -3.922322e-001, -3.921437e-001, -3.920551e-001, -3.919666e-001, -3.918780e-001, -3.917895e-001, -3.917010e-001, -3.916125e-001, -3.915240e-001, -3.914355e-001, -3.913470e-001, -3.912586e-001, -3.911701e-001, -3.910817e-001, -3.909932e-001, -3.909048e-001, -3.908164e-001, -3.907280e-001, -3.906396e-001, -3.905512e-001, -3.904628e-001, -3.903745e-001, -3.902861e-001, -3.901978e-001, -3.901094e-001, -3.900211e-001, -3.899328e-001, -3.898445e-001, -3.897562e-001, -3.896679e-001, -3.895796e-001, -3.894914e-001, -3.894031e-001, -3.893149e-001, -3.892266e-001, -3.891384e-001, -3.890502e-001, -3.889620e-001, -3.888738e-001, -3.887856e-001, -3.886974e-001, -3.886093e-001, -3.885211e-001, -3.884330e-001, -3.883448e-001, -3.882567e-001, -3.881686e-001, -3.880805e-001, -3.879924e-001, -3.879043e-001, -3.878162e-001, -3.877282e-001, -3.876401e-001, -3.875521e-001, -3.874640e-001, -3.873760e-001, -3.872880e-001, 
-3.872000e-001, -3.871120e-001, -3.870240e-001, -3.869360e-001, -3.868481e-001, -3.867601e-001, -3.866722e-001, -3.865842e-001, -3.864963e-001, -3.864084e-001, -3.863205e-001, -3.862326e-001, -3.861447e-001, -3.860568e-001, -3.859690e-001, -3.858811e-001, -3.857933e-001, -3.857054e-001, -3.856176e-001, -3.855298e-001, -3.854420e-001, -3.853542e-001, -3.852664e-001, -3.851786e-001, -3.850909e-001, -3.850031e-001, -3.849154e-001, -3.848276e-001, -3.847399e-001, -3.846522e-001, -3.845645e-001, -3.844768e-001, -3.843891e-001, -3.843014e-001, -3.842138e-001, -3.841261e-001, -3.840385e-001, -3.839508e-001, -3.838632e-001, -3.837756e-001, -3.836880e-001, -3.836004e-001, -3.835128e-001, -3.834252e-001, -3.833377e-001, -3.832501e-001, -3.831626e-001, -3.830750e-001, -3.829875e-001, -3.829000e-001, -3.828125e-001, -3.827250e-001, -3.826375e-001, -3.825500e-001, -3.824626e-001, -3.823751e-001, -3.822877e-001, -3.822002e-001, -3.821128e-001, -3.820254e-001, -3.819380e-001, -3.818506e-001, -3.817632e-001, -3.816758e-001, -3.815885e-001, -3.815011e-001, -3.814138e-001, -3.813264e-001, -3.812391e-001, -3.811518e-001, -3.810645e-001, -3.809772e-001, -3.808899e-001, -3.808026e-001, -3.807154e-001, -3.806281e-001, -3.805409e-001, -3.804536e-001, -3.803664e-001, -3.802792e-001, -3.801920e-001, -3.801048e-001, -3.800176e-001, -3.799304e-001, -3.798433e-001, -3.797561e-001, -3.796690e-001, -3.795818e-001, -3.794947e-001, -3.794076e-001, -3.793205e-001, -3.792334e-001, -3.791463e-001, -3.790592e-001, -3.789722e-001, -3.788851e-001, -3.787981e-001, -3.787110e-001, -3.786240e-001, -3.785370e-001, 
-3.784500e-001, -3.783630e-001, -3.782760e-001, -3.781890e-001, -3.781021e-001, -3.780151e-001, -3.779282e-001, -3.778412e-001, -3.777543e-001, -3.776674e-001, -3.775805e-001, -3.774936e-001, -3.774067e-001, -3.773198e-001, -3.772330e-001, -3.771461e-001, -3.770593e-001, -3.769724e-001, -3.768856e-001, -3.767988e-001, -3.767120e-001, -3.766252e-001, -3.765384e-001, -3.764516e-001, -3.763649e-001, -3.762781e-001, -3.761914e-001, -3.761046e-001, -3.760179e-001, -3.759312e-001, -3.758445e-001, -3.757578e-001, -3.756711e-001, -3.755844e-001, -3.754978e-001, -3.754111e-001, -3.753245e-001, -3.752378e-001, -3.751512e-001, -3.750646e-001, -3.749780e-001, -3.748914e-001, -3.748048e-001, -3.747182e-001, -3.746317e-001, -3.745451e-001, -3.744586e-001, -3.743720e-001, -3.742855e-001, -3.741990e-001, -3.741125e-001, -3.740260e-001, -3.739395e-001, -3.738530e-001, -3.737666e-001, -3.736801e-001, -3.735937e-001, -3.735072e-001, -3.734208e-001, -3.733344e-001, -3.732480e-001, -3.731616e-001, -3.730752e-001, -3.729888e-001, -3.729025e-001, -3.728161e-001, -3.727298e-001, -3.726434e-001, -3.725571e-001, -3.724708e-001, -3.723845e-001, -3.722982e-001, -3.722119e-001, -3.721256e-001, -3.720394e-001, -3.719531e-001, -3.718669e-001, -3.717806e-001, -3.716944e-001, -3.716082e-001, -3.715220e-001, -3.714358e-001, -3.713496e-001, -3.712634e-001, -3.711773e-001, -3.710911e-001, -3.710050e-001, -3.709188e-001, -3.708327e-001, -3.707466e-001, -3.706605e-001, -3.705744e-001, -3.704883e-001, -3.704022e-001, -3.703162e-001, -3.702301e-001, -3.701441e-001, -3.700580e-001, -3.699720e-001, -3.698860e-001, 
-3.698000e-001, -3.697140e-001, -3.696280e-001, -3.695420e-001, -3.694561e-001, -3.693701e-001, -3.692842e-001, -3.691982e-001, -3.691123e-001, -3.690264e-001, -3.689405e-001, -3.688546e-001, -3.687687e-001, -3.686828e-001, -3.685970e-001, -3.685111e-001, -3.684253e-001, -3.683394e-001, -3.682536e-001, -3.681678e-001, -3.680820e-001, -3.679962e-001, -3.679104e-001, -3.678246e-001, -3.677389e-001, -3.676531e-001, -3.675674e-001, -3.674816e-001, -3.673959e-001, -3.673102e-001, -3.672245e-001, -3.671388e-001, -3.670531e-001, -3.669674e-001, -3.668818e-001, -3.667961e-001, -3.667105e-001, -3.666248e-001, -3.665392e-001, -3.664536e-001, -3.663680e-001, -3.662824e-001, -3.661968e-001, -3.661112e-001, -3.660257e-001, -3.659401e-001, -3.658546e-001, -3.657690e-001, -3.656835e-001, -3.655980e-001, -3.655125e-001, -3.654270e-001, -3.653415e-001, -3.652560e-001, -3.651706e-001, -3.650851e-001, -3.649997e-001, -3.649142e-001, -3.648288e-001, -3.647434e-001, -3.646580e-001, -3.645726e-001, -3.644872e-001, -3.644018e-001, -3.643165e-001, -3.642311e-001, -3.641458e-001, -3.640604e-001, -3.639751e-001, -3.638898e-001, -3.638045e-001, -3.637192e-001, -3.636339e-001, -3.635486e-001, -3.634634e-001, -3.633781e-001, -3.632929e-001, -3.632076e-001, -3.631224e-001, -3.630372e-001, -3.629520e-001, -3.628668e-001, -3.627816e-001, -3.626964e-001, -3.626113e-001, -3.625261e-001, -3.624410e-001, -3.623558e-001, -3.622707e-001, -3.621856e-001, -3.621005e-001, -3.620154e-001, -3.619303e-001, -3.618452e-001, -3.617602e-001, -3.616751e-001, -3.615901e-001, -3.615050e-001, -3.614200e-001, -3.613350e-001, 
-3.612500e-001, -3.611650e-001, -3.610800e-001, -3.609950e-001, -3.609101e-001, -3.608251e-001, -3.607402e-001, -3.606552e-001, -3.605703e-001, -3.604854e-001, -3.604005e-001, -3.603156e-001, -3.602307e-001, -3.601458e-001, -3.600610e-001, -3.599761e-001, -3.598913e-001, -3.598064e-001, -3.597216e-001, -3.596368e-001, -3.595520e-001, -3.594672e-001, -3.593824e-001, -3.592976e-001, -3.592129e-001, -3.591281e-001, -3.590434e-001, -3.589586e-001, -3.588739e-001, -3.587892e-001, -3.587045e-001, -3.586198e-001, -3.585351e-001, -3.584504e-001, -3.583658e-001, -3.582811e-001, -3.581965e-001, -3.581118e-001, -3.580272e-001, -3.579426e-001, -3.578580e-001, -3.577734e-001, -3.576888e-001, -3.576042e-001, -3.575197e-001, -3.574351e-001, -3.573506e-001, -3.572660e-001, -3.571815e-001, -3.570970e-001, -3.570125e-001, -3.569280e-001, -3.568435e-001, -3.567590e-001, -3.566746e-001, -3.565901e-001, -3.565057e-001, -3.564212e-001, -3.563368e-001, -3.562524e-001, -3.561680e-001, -3.560836e-001, -3.559992e-001, -3.559148e-001, -3.558305e-001, -3.557461e-001, -3.556618e-001, -3.555774e-001, -3.554931e-001, -3.554088e-001, -3.553245e-001, -3.552402e-001, -3.551559e-001, -3.550716e-001, -3.549874e-001, -3.549031e-001, -3.548189e-001, -3.547346e-001, -3.546504e-001, -3.545662e-001, -3.544820e-001, -3.543978e-001, -3.543136e-001, -3.542294e-001, -3.541453e-001, -3.540611e-001, -3.539770e-001, -3.538928e-001, -3.538087e-001, -3.537246e-001, -3.536405e-001, -3.535564e-001, -3.534723e-001, -3.533882e-001, -3.533042e-001, -3.532201e-001, -3.531361e-001, -3.530520e-001, -3.529680e-001, -3.528840e-001, 
-3.528000e-001, -3.527160e-001, -3.526320e-001, -3.525480e-001, -3.524641e-001, -3.523801e-001, -3.522962e-001, -3.522122e-001, -3.521283e-001, -3.520444e-001, -3.519605e-001, -3.518766e-001, -3.517927e-001, -3.517088e-001, -3.516250e-001, -3.515411e-001, -3.514573e-001, -3.513734e-001, -3.512896e-001, -3.512058e-001, -3.511220e-001, -3.510382e-001, -3.509544e-001, -3.508706e-001, -3.507869e-001, -3.507031e-001, -3.506194e-001, -3.505356e-001, -3.504519e-001, -3.503682e-001, -3.502845e-001, -3.502008e-001, -3.501171e-001, -3.500334e-001, -3.499498e-001, -3.498661e-001, -3.497825e-001, -3.496988e-001, -3.496152e-001, -3.495316e-001, -3.494480e-001, -3.493644e-001, -3.492808e-001, -3.491972e-001, -3.491137e-001, -3.490301e-001, -3.489466e-001, -3.488630e-001, -3.487795e-001, -3.486960e-001, -3.486125e-001, -3.485290e-001, -3.484455e-001, -3.483620e-001, -3.482786e-001, -3.481951e-001, -3.481117e-001, -3.480282e-001, -3.479448e-001, -3.478614e-001, -3.477780e-001, -3.476946e-001, -3.476112e-001, -3.475278e-001, -3.474445e-001, -3.473611e-001, -3.472778e-001, -3.471944e-001, -3.471111e-001, -3.470278e-001, -3.469445e-001, -3.468612e-001, -3.467779e-001, -3.466946e-001, -3.466114e-001, -3.465281e-001, -3.464449e-001, -3.463616e-001, -3.462784e-001, -3.461952e-001, -3.461120e-001, -3.460288e-001, -3.459456e-001, -3.458624e-001, -3.457793e-001, -3.456961e-001, -3.456130e-001, -3.455298e-001, -3.454467e-001, -3.453636e-001, -3.452805e-001, -3.451974e-001, -3.451143e-001, -3.450312e-001, -3.449482e-001, -3.448651e-001, -3.447821e-001, -3.446990e-001, -3.446160e-001, -3.445330e-001, 
-3.444500e-001, -3.443670e-001, -3.442840e-001, -3.442010e-001, -3.441181e-001, -3.440351e-001, -3.439522e-001, -3.438692e-001, -3.437863e-001, -3.437034e-001, -3.436205e-001, -3.435376e-001, -3.434547e-001, -3.433718e-001, -3.432890e-001, -3.432061e-001, -3.431233e-001, -3.430404e-001, -3.429576e-001, -3.428748e-001, -3.427920e-001, -3.427092e-001, -3.426264e-001, -3.425436e-001, -3.424609e-001, -3.423781e-001, -3.422954e-001, -3.422126e-001, -3.421299e-001, -3.420472e-001, -3.419645e-001, -3.418818e-001, -3.417991e-001, -3.417164e-001, -3.416338e-001, -3.415511e-001, -3.414685e-001, -3.413858e-001, -3.413032e-001, -3.412206e-001, -3.411380e-001, -3.410554e-001, -3.409728e-001, -3.408902e-001, -3.408077e-001, -3.407251e-001, -3.406426e-001, -3.405600e-001, -3.404775e-001, -3.403950e-001, -3.403125e-001, -3.402300e-001, -3.401475e-001, -3.400650e-001, -3.399826e-001, -3.399001e-001, -3.398177e-001, -3.397352e-001, -3.396528e-001, -3.395704e-001, -3.394880e-001, -3.394056e-001, -3.393232e-001, -3.392408e-001, -3.391585e-001, -3.390761e-001, -3.389938e-001, -3.389114e-001, -3.388291e-001, -3.387468e-001, -3.386645e-001, -3.385822e-001, -3.384999e-001, -3.384176e-001, -3.383354e-001, -3.382531e-001, -3.381709e-001, -3.380886e-001, -3.380064e-001, -3.379242e-001, -3.378420e-001, -3.377598e-001, -3.376776e-001, -3.375954e-001, -3.375133e-001, -3.374311e-001, -3.373490e-001, -3.372668e-001, -3.371847e-001, -3.371026e-001, -3.370205e-001, -3.369384e-001, -3.368563e-001, -3.367742e-001, -3.366922e-001, -3.366101e-001, -3.365281e-001, -3.364460e-001, -3.363640e-001, -3.362820e-001, 
-3.362000e-001, -3.361180e-001, -3.360360e-001, -3.359540e-001, -3.358721e-001, -3.357901e-001, -3.357082e-001, -3.356262e-001, -3.355443e-001, -3.354624e-001, -3.353805e-001, -3.352986e-001, -3.352167e-001, -3.351348e-001, -3.350530e-001, -3.349711e-001, -3.348893e-001, -3.348074e-001, -3.347256e-001, -3.346438e-001, -3.345620e-001, -3.344802e-001, -3.343984e-001, -3.343166e-001, -3.342349e-001, -3.341531e-001, -3.340714e-001, -3.339896e-001, -3.339079e-001, -3.338262e-001, -3.337445e-001, -3.336628e-001, -3.335811e-001, -3.334994e-001, -3.334178e-001, -3.333361e-001, -3.332545e-001, -3.331728e-001, -3.330912e-001, -3.330096e-001, -3.329280e-001, -3.328464e-001, -3.327648e-001, -3.326832e-001, -3.326017e-001, -3.325201e-001, -3.324386e-001, -3.323570e-001, -3.322755e-001, -3.321940e-001, -3.321125e-001, -3.320310e-001, -3.319495e-001, -3.318680e-001, -3.317866e-001, -3.317051e-001, -3.316237e-001, -3.315422e-001, -3.314608e-001, -3.313794e-001, -3.312980e-001, -3.312166e-001, -3.311352e-001, -3.310538e-001, -3.309725e-001, -3.308911e-001, -3.308098e-001, -3.307284e-001, -3.306471e-001, -3.305658e-001, -3.304845e-001, -3.304032e-001, -3.303219e-001, -3.302406e-001, -3.301594e-001, -3.300781e-001, -3.299969e-001, -3.299156e-001, -3.298344e-001, -3.297532e-001, -3.296720e-001, -3.295908e-001, -3.295096e-001, -3.294284e-001, -3.293473e-001, -3.292661e-001, -3.291850e-001, -3.291038e-001, -3.290227e-001, -3.289416e-001, -3.288605e-001, -3.287794e-001, -3.286983e-001, -3.286172e-001, -3.285362e-001, -3.284551e-001, -3.283741e-001, -3.282930e-001, -3.282120e-001, -3.281310e-001, 
-3.280500e-001, -3.279690e-001, -3.278880e-001, -3.278070e-001, -3.277261e-001, -3.276451e-001, -3.275642e-001, -3.274832e-001, -3.274023e-001, -3.273214e-001, -3.272405e-001, -3.271596e-001, -3.270787e-001, -3.269978e-001, -3.269170e-001, -3.268361e-001, -3.267553e-001, -3.266744e-001, -3.265936e-001, -3.265128e-001, -3.264320e-001, -3.263512e-001, -3.262704e-001, -3.261896e-001, -3.261089e-001, -3.260281e-001, -3.259474e-001, -3.258666e-001, -3.257859e-001, -3.257052e-001, -3.256245e-001, -3.255438e-001, -3.254631e-001, -3.253824e-001, -3.253018e-001, -3.252211e-001, -3.251405e-001, -3.250598e-001, -3.249792e-001, -3.248986e-001, -3.248180e-001, -3.247374e-001, -3.246568e-001, -3.245762e-001, -3.244957e-001, -3.244151e-001, -3.243346e-001, -3.242540e-001, -3.241735e-001, -3.240930e-001, -3.240125e-001, -3.239320e-001, -3.238515e-001, -3.237710e-001, -3.236906e-001, -3.236101e-001, -3.235297e-001, -3.234492e-001, -3.233688e-001, -3.232884e-001, -3.232080e-001, -3.231276e-001, -3.230472e-001, -3.229668e-001, -3.228865e-001, -3.228061e-001, -3.227258e-001, -3.226454e-001, -3.225651e-001, -3.224848e-001, -3.224045e-001, -3.223242e-001, -3.222439e-001, -3.221636e-001, -3.220834e-001, -3.220031e-001, -3.219229e-001, -3.218426e-001, -3.217624e-001, -3.216822e-001, -3.216020e-001, -3.215218e-001, -3.214416e-001, -3.213614e-001, -3.212813e-001, -3.212011e-001, -3.211210e-001, -3.210408e-001, -3.209607e-001, -3.208806e-001, -3.208005e-001, -3.207204e-001, -3.206403e-001, -3.205602e-001, -3.204802e-001, -3.204001e-001, -3.203201e-001, -3.202400e-001, -3.201600e-001, -3.200800e-001, 
-3.200000e-001, -3.199200e-001, -3.198400e-001, -3.197600e-001, -3.196801e-001, -3.196001e-001, -3.195202e-001, -3.194402e-001, -3.193603e-001, -3.192804e-001, -3.192005e-001, -3.191206e-001, -3.190407e-001, -3.189608e-001, -3.188810e-001, -3.188011e-001, -3.187213e-001, -3.186414e-001, -3.185616e-001, -3.184818e-001, -3.184020e-001, -3.183222e-001, -3.182424e-001, -3.181626e-001, -3.180829e-001, -3.180031e-001, -3.179234e-001, -3.178436e-001, -3.177639e-001, -3.176842e-001, -3.176045e-001, -3.175248e-001, -3.174451e-001, -3.173654e-001, -3.172858e-001, -3.172061e-001, -3.171265e-001, -3.170468e-001, -3.169672e-001, -3.168876e-001, -3.168080e-001, -3.167284e-001, -3.166488e-001, -3.165692e-001, -3.164897e-001, -3.164101e-001, -3.163306e-001, -3.162510e-001, -3.161715e-001, -3.160920e-001, -3.160125e-001, -3.159330e-001, -3.158535e-001, -3.157740e-001, -3.156946e-001, -3.156151e-001, -3.155357e-001, -3.154562e-001, -3.153768e-001, -3.152974e-001, -3.152180e-001, -3.151386e-001, -3.150592e-001, -3.149798e-001, -3.149005e-001, -3.148211e-001, -3.147418e-001, -3.146624e-001, -3.145831e-001, -3.145038e-001, -3.144245e-001, -3.143452e-001, -3.142659e-001, -3.141866e-001, -3.141074e-001, -3.140281e-001, -3.139489e-001, -3.138696e-001, -3.137904e-001, -3.137112e-001, -3.136320e-001, -3.135528e-001, -3.134736e-001, -3.133944e-001, -3.133153e-001, -3.132361e-001, -3.131570e-001, -3.130778e-001, -3.129987e-001, -3.129196e-001, -3.128405e-001, -3.127614e-001, -3.126823e-001, -3.126032e-001, -3.125242e-001, -3.124451e-001, -3.123661e-001, -3.122870e-001, -3.122080e-001, -3.121290e-001, 
-3.120500e-001, -3.119710e-001, -3.118920e-001, -3.118130e-001, -3.117341e-001, -3.116551e-001, -3.115762e-001, -3.114972e-001, -3.114183e-001, -3.113394e-001, -3.112605e-001, -3.111816e-001, -3.111027e-001, -3.110238e-001, -3.109450e-001, -3.108661e-001, -3.107873e-001, -3.107084e-001, -3.106296e-001, -3.105508e-001, -3.104720e-001, -3.103932e-001, -3.103144e-001, -3.102356e-001, -3.101569e-001, -3.100781e-001, -3.099994e-001, -3.099206e-001, -3.098419e-001, -3.097632e-001, -3.096845e-001, -3.096058e-001, -3.095271e-001, -3.094484e-001, -3.093698e-001, -3.092911e-001, -3.092125e-001, -3.091338e-001, -3.090552e-001, -3.089766e-001, -3.088980e-001, -3.088194e-001, -3.087408e-001, -3.086622e-001, -3.085837e-001, -3.085051e-001, -3.084266e-001, -3.083480e-001, -3.082695e-001, -3.081910e-001, -3.081125e-001, -3.080340e-001, -3.079555e-001, -3.078770e-001, -3.077986e-001, -3.077201e-001, -3.076417e-001, -3.075632e-001, -3.074848e-001, -3.074064e-001, -3.073280e-001, -3.072496e-001, -3.071712e-001, -3.070928e-001, -3.070145e-001, -3.069361e-001, -3.068578e-001, -3.067794e-001, -3.067011e-001, -3.066228e-001, -3.065445e-001, -3.064662e-001, -3.063879e-001, -3.063096e-001, -3.062314e-001, -3.061531e-001, -3.060749e-001, -3.059966e-001, -3.059184e-001, -3.058402e-001, -3.057620e-001, -3.056838e-001, -3.056056e-001, -3.055274e-001, -3.054493e-001, -3.053711e-001, -3.052930e-001, -3.052148e-001, -3.051367e-001, -3.050586e-001, -3.049805e-001, -3.049024e-001, -3.048243e-001, -3.047462e-001, -3.046682e-001, -3.045901e-001, -3.045121e-001, -3.044340e-001, -3.043560e-001, -3.042780e-001, 
-3.042000e-001, -3.041220e-001, -3.040440e-001, -3.039660e-001, -3.038881e-001, -3.038101e-001, -3.037322e-001, -3.036542e-001, -3.035763e-001, -3.034984e-001, -3.034205e-001, -3.033426e-001, -3.032647e-001, -3.031868e-001, -3.031090e-001, -3.030311e-001, -3.029533e-001, -3.028754e-001, -3.027976e-001, -3.027198e-001, -3.026420e-001, -3.025642e-001, -3.024864e-001, -3.024086e-001, -3.023309e-001, -3.022531e-001, -3.021754e-001, -3.020976e-001, -3.020199e-001, -3.019422e-001, -3.018645e-001, -3.017868e-001, -3.017091e-001, -3.016314e-001, -3.015538e-001, -3.014761e-001, -3.013985e-001, -3.013208e-001, -3.012432e-001, -3.011656e-001, -3.010880e-001, -3.010104e-001, -3.009328e-001, -3.008552e-001, -3.007777e-001, -3.007001e-001, -3.006226e-001, -3.005450e-001, -3.004675e-001, -3.003900e-001, -3.003125e-001, -3.002350e-001, -3.001575e-001, -3.000800e-001, -3.000026e-001, -2.999251e-001, -2.998477e-001, -2.997702e-001, -2.996928e-001, -2.996154e-001, -2.995380e-001, -2.994606e-001, -2.993832e-001, -2.993058e-001, -2.992285e-001, -2.991511e-001, -2.990738e-001, -2.989964e-001, -2.989191e-001, -2.988418e-001, -2.987645e-001, -2.986872e-001, -2.986099e-001, -2.985326e-001, -2.984554e-001, -2.983781e-001, -2.983009e-001, -2.982236e-001, -2.981464e-001, -2.980692e-001, -2.979920e-001, -2.979148e-001, -2.978376e-001, -2.977604e-001, -2.976833e-001, -2.976061e-001, -2.975290e-001, -2.974518e-001, -2.973747e-001, -2.972976e-001, -2.972205e-001, -2.971434e-001, -2.970663e-001, -2.969892e-001, -2.969122e-001, -2.968351e-001, -2.967581e-001, -2.966810e-001, -2.966040e-001, -2.965270e-001, 
-2.964500e-001, -2.963730e-001, -2.962960e-001, -2.962190e-001, -2.961421e-001, -2.960651e-001, -2.959882e-001, -2.959112e-001, -2.958343e-001, -2.957574e-001, -2.956805e-001, -2.956036e-001, -2.955267e-001, -2.954498e-001, -2.953730e-001, -2.952961e-001, -2.952193e-001, -2.951424e-001, -2.950656e-001, -2.949888e-001, -2.949120e-001, -2.948352e-001, -2.947584e-001, -2.946816e-001, -2.946049e-001, -2.945281e-001, -2.944514e-001, -2.943746e-001, -2.942979e-001, -2.942212e-001, -2.941445e-001, -2.940678e-001, -2.939911e-001, -2.939144e-001, -2.938378e-001, -2.937611e-001, -2.936845e-001, -2.936078e-001, -2.935312e-001, -2.934546e-001, -2.933780e-001, -2.933014e-001, -2.932248e-001, -2.931482e-001, -2.930717e-001, -2.929951e-001, -2.929186e-001, -2.928420e-001, -2.927655e-001, -2.926890e-001, -2.926125e-001, -2.925360e-001, -2.924595e-001, -2.923830e-001, -2.923066e-001, -2.922301e-001, -2.921537e-001, -2.920772e-001, -2.920008e-001, -2.919244e-001, -2.918480e-001, -2.917716e-001, -2.916952e-001, -2.916188e-001, -2.915425e-001, -2.914661e-001, -2.913898e-001, -2.913134e-001, -2.912371e-001, -2.911608e-001, -2.910845e-001, -2.910082e-001, -2.909319e-001, -2.908556e-001, -2.907794e-001, -2.907031e-001, -2.906269e-001, -2.905506e-001, -2.904744e-001, -2.903982e-001, -2.903220e-001, -2.902458e-001, -2.901696e-001, -2.900934e-001, -2.900173e-001, -2.899411e-001, -2.898650e-001, -2.897888e-001, -2.897127e-001, -2.896366e-001, -2.895605e-001, -2.894844e-001, -2.894083e-001, -2.893322e-001, -2.892562e-001, -2.891801e-001, -2.891041e-001, -2.890280e-001, -2.889520e-001, -2.888760e-001, 
-2.888000e-001, -2.887240e-001, -2.886480e-001, -2.885720e-001, -2.884961e-001, -2.884201e-001, -2.883442e-001, -2.882682e-001, -2.881923e-001, -2.881164e-001, -2.880405e-001, -2.879646e-001, -2.878887e-001, -2.878128e-001, -2.877370e-001, -2.876611e-001, -2.875853e-001, -2.875094e-001, -2.874336e-001, -2.873578e-001, -2.872820e-001, -2.872062e-001, -2.871304e-001, -2.870546e-001, -2.869789e-001, -2.869031e-001, -2.868274e-001, -2.867516e-001, -2.866759e-001, -2.866002e-001, -2.865245e-001, -2.864488e-001, -2.863731e-001, -2.862974e-001, -2.862218e-001, -2.861461e-001, -2.860705e-001, -2.859948e-001, -2.859192e-001, -2.858436e-001, -2.857680e-001, -2.856924e-001, -2.856168e-001, -2.855412e-001, -2.854657e-001, -2.853901e-001, -2.853146e-001, -2.852390e-001, -2.851635e-001, -2.850880e-001, -2.850125e-001, -2.849370e-001, -2.848615e-001, -2.847860e-001, -2.847106e-001, -2.846351e-001, -2.845597e-001, -2.844842e-001, -2.844088e-001, -2.843334e-001, -2.842580e-001, -2.841826e-001, -2.841072e-001, -2.840318e-001, -2.839565e-001, -2.838811e-001, -2.838058e-001, -2.837304e-001, -2.836551e-001, -2.835798e-001, -2.835045e-001, -2.834292e-001, -2.833539e-001, -2.832786e-001, -2.832034e-001, -2.831281e-001, -2.830529e-001, -2.829776e-001, -2.829024e-001, -2.828272e-001, -2.827520e-001, -2.826768e-001, -2.826016e-001, -2.825264e-001, -2.824513e-001, -2.823761e-001, -2.823010e-001, -2.822258e-001, -2.821507e-001, -2.820756e-001, -2.820005e-001, -2.819254e-001, -2.818503e-001, -2.817752e-001, -2.817002e-001, -2.816251e-001, -2.815501e-001, -2.814750e-001, -2.814000e-001, -2.813250e-001, 
-2.812500e-001, -2.811750e-001, -2.811000e-001, -2.810250e-001, -2.809501e-001, -2.808751e-001, -2.808002e-001, -2.807252e-001, -2.806503e-001, -2.805754e-001, -2.805005e-001, -2.804256e-001, -2.803507e-001, -2.802758e-001, -2.802010e-001, -2.801261e-001, -2.800513e-001, -2.799764e-001, -2.799016e-001, -2.798268e-001, -2.797520e-001, -2.796772e-001, -2.796024e-001, -2.795276e-001, -2.794529e-001, -2.793781e-001, -2.793034e-001, -2.792286e-001, -2.791539e-001, -2.790792e-001, -2.790045e-001, -2.789298e-001, -2.788551e-001, -2.787804e-001, -2.787058e-001, -2.786311e-001, -2.785565e-001, -2.784818e-001, -2.784072e-001, -2.783326e-001, -2.782580e-001, -2.781834e-001, -2.781088e-001, -2.780342e-001, -2.779597e-001, -2.778851e-001, -2.778106e-001, -2.777360e-001, -2.776615e-001, -2.775870e-001, -2.775125e-001, -2.774380e-001, -2.773635e-001, -2.772890e-001, -2.772146e-001, -2.771401e-001, -2.770657e-001, -2.769912e-001, -2.769168e-001, -2.768424e-001, -2.767680e-001, -2.766936e-001, -2.766192e-001, -2.765448e-001, -2.764705e-001, -2.763961e-001, -2.763218e-001, -2.762474e-001, -2.761731e-001, -2.760988e-001, -2.760245e-001, -2.759502e-001, -2.758759e-001, -2.758016e-001, -2.757274e-001, -2.756531e-001, -2.755789e-001, -2.755046e-001, -2.754304e-001, -2.753562e-001, -2.752820e-001, -2.752078e-001, -2.751336e-001, -2.750594e-001, -2.749853e-001, -2.749111e-001, -2.748370e-001, -2.747628e-001, -2.746887e-001, -2.746146e-001, -2.745405e-001, -2.744664e-001, -2.743923e-001, -2.743182e-001, -2.742442e-001, -2.741701e-001, -2.740961e-001, -2.740220e-001, -2.739480e-001, -2.738740e-001, 
-2.738000e-001, -2.737260e-001, -2.736520e-001, -2.735780e-001, -2.735041e-001, -2.734301e-001, -2.733562e-001, -2.732822e-001, -2.732083e-001, -2.731344e-001, -2.730605e-001, -2.729866e-001, -2.729127e-001, -2.728388e-001, -2.727650e-001, -2.726911e-001, -2.726173e-001, -2.725434e-001, -2.724696e-001, -2.723958e-001, -2.723220e-001, -2.722482e-001, -2.721744e-001, -2.721006e-001, -2.720269e-001, -2.719531e-001, -2.718794e-001, -2.718056e-001, -2.717319e-001, -2.716582e-001, -2.715845e-001, -2.715108e-001, -2.714371e-001, -2.713634e-001, -2.712898e-001, -2.712161e-001, -2.711425e-001, -2.710688e-001, -2.709952e-001, -2.709216e-001, -2.708480e-001, -2.707744e-001, -2.707008e-001, -2.706272e-001, -2.705537e-001, -2.704801e-001, -2.704066e-001, -2.703330e-001, -2.702595e-001, -2.701860e-001, -2.701125e-001, -2.700390e-001, -2.699655e-001, -2.698920e-001, -2.698186e-001, -2.697451e-001, -2.696717e-001, -2.695982e-001, -2.695248e-001, -2.694514e-001, -2.693780e-001, -2.693046e-001, -2.692312e-001, -2.691578e-001, -2.690845e-001, -2.690111e-001, -2.689378e-001, -2.688644e-001, -2.687911e-001, -2.687178e-001, -2.686445e-001, -2.685712e-001, -2.684979e-001, -2.684246e-001, -2.683514e-001, -2.682781e-001, -2.682049e-001, -2.681316e-001, -2.680584e-001, -2.679852e-001, -2.679120e-001, -2.678388e-001, -2.677656e-001, -2.676924e-001, -2.676193e-001, -2.675461e-001, -2.674730e-001, -2.673998e-001, -2.673267e-001, -2.672536e-001, -2.671805e-001, -2.671074e-001, -2.670343e-001, -2.669612e-001, -2.668882e-001, -2.668151e-001, -2.667421e-001, -2.666690e-001, -2.665960e-001, -2.665230e-001, 
-2.664500e-001, -2.663770e-001, -2.663040e-001, -2.662310e-001, -2.661581e-001, -2.660851e-001, -2.660122e-001, -2.659392e-001, -2.658663e-001, -2.657934e-001, -2.657205e-001, -2.656476e-001, -2.655747e-001, -2.655018e-001, -2.654290e-001, -2.653561e-001, -2.652833e-001, -2.652104e-001, -2.651376e-001, -2.650648e-001, -2.649920e-001, -2.649192e-001, -2.648464e-001, -2.647736e-001, -2.647009e-001, -2.646281e-001, -2.645554e-001, -2.644826e-001, -2.644099e-001, -2.643372e-001, -2.642645e-001, -2.641918e-001, -2.641191e-001, -2.640464e-001, -2.639738e-001, -2.639011e-001, -2.638285e-001, -2.637558e-001, -2.636832e-001, -2.636106e-001, -2.635380e-001, -2.634654e-001, -2.633928e-001, -2.633202e-001, -2.632477e-001, -2.631751e-001, -2.631026e-001, -2.630300e-001, -2.629575e-001, -2.628850e-001, -2.628125e-001, -2.627400e-001, -2.626675e-001, -2.625950e-001, -2.625226e-001, -2.624501e-001, -2.623777e-001, -2.623052e-001, -2.622328e-001, -2.621604e-001, -2.620880e-001, -2.620156e-001, -2.619432e-001, -2.618708e-001, -2.617985e-001, -2.617261e-001, -2.616538e-001, -2.615814e-001, -2.615091e-001, -2.614368e-001, -2.613645e-001, -2.612922e-001, -2.612199e-001, -2.611476e-001, -2.610754e-001, -2.610031e-001, -2.609309e-001, -2.608586e-001, -2.607864e-001, -2.607142e-001, -2.606420e-001, -2.605698e-001, -2.604976e-001, -2.604254e-001, -2.603533e-001, -2.602811e-001, -2.602090e-001, -2.601368e-001, -2.600647e-001, -2.599926e-001, -2.599205e-001, -2.598484e-001, -2.597763e-001, -2.597042e-001, -2.596322e-001, -2.595601e-001, -2.594881e-001, -2.594160e-001, -2.593440e-001, -2.592720e-001, 
-2.592000e-001, -2.591280e-001, -2.590560e-001, -2.589840e-001, -2.589121e-001, -2.588401e-001, -2.587682e-001, -2.586962e-001, -2.586243e-001, -2.585524e-001, -2.584805e-001, -2.584086e-001, -2.583367e-001, -2.582648e-001, -2.581930e-001, -2.581211e-001, -2.580493e-001, -2.579774e-001, -2.579056e-001, -2.578338e-001, -2.577620e-001, -2.576902e-001, -2.576184e-001, -2.575466e-001, -2.574749e-001, -2.574031e-001, -2.573314e-001, -2.572596e-001, -2.571879e-001, -2.571162e-001, -2.570445e-001, -2.569728e-001, -2.569011e-001, -2.568294e-001, -2.567578e-001, -2.566861e-001, -2.566145e-001, -2.565428e-001, -2.564712e-001, -2.563996e-001, -2.563280e-001, -2.562564e-001, -2.561848e-001, -2.561132e-001, -2.560417e-001, -2.559701e-001, -2.558986e-001, -2.558270e-001, -2.557555e-001, -2.556840e-001, -2.556125e-001, -2.555410e-001, -2.554695e-001, -2.553980e-001, -2.553266e-001, -2.552551e-001, -2.551837e-001, -2.551122e-001, -2.550408e-001, -2.549694e-001, -2.548980e-001, -2.548266e-001, -2.547552e-001, -2.546838e-001, -2.546125e-001, -2.545411e-001, -2.544698e-001, -2.543984e-001, -2.543271e-001, -2.542558e-001, -2.541845e-001, -2.541132e-001, -2.540419e-001, -2.539706e-001, -2.538994e-001, -2.538281e-001, -2.537569e-001, -2.536856e-001, -2.536144e-001, -2.535432e-001, -2.534720e-001, -2.534008e-001, -2.533296e-001, -2.532584e-001, -2.531873e-001, -2.531161e-001, -2.530450e-001, -2.529738e-001, -2.529027e-001, -2.528316e-001, -2.527605e-001, -2.526894e-001, -2.526183e-001, -2.525472e-001, -2.524762e-001, -2.524051e-001, -2.523341e-001, -2.522630e-001, -2.521920e-001, -2.521210e-001, 
-2.520500e-001, -2.519790e-001, -2.519080e-001, -2.518370e-001, -2.517661e-001, -2.516951e-001, -2.516242e-001, -2.515532e-001, -2.514823e-001, -2.514114e-001, -2.513405e-001, -2.512696e-001, -2.511987e-001, -2.511278e-001, -2.510570e-001, -2.509861e-001, -2.509153e-001, -2.508444e-001, -2.507736e-001, -2.507028e-001, -2.506320e-001, -2.505612e-001, -2.504904e-001, -2.504196e-001, -2.503489e-001, -2.502781e-001, -2.502074e-001, -2.501366e-001, -2.500659e-001, -2.499952e-001, -2.499245e-001, -2.498538e-001, -2.497831e-001, -2.497124e-001, -2.496418e-001, -2.495711e-001, -2.495005e-001, -2.494298e-001, -2.493592e-001, -2.492886e-001, -2.492180e-001, -2.491474e-001, -2.490768e-001, -2.490062e-001, -2.489357e-001, -2.488651e-001, -2.487946e-001, -2.487240e-001, -2.486535e-001, -2.485830e-001, -2.485125e-001, -2.484420e-001, -2.483715e-001, -2.483010e-001, -2.482306e-001, -2.481601e-001, -2.480897e-001, -2.480192e-001, -2.479488e-001, -2.478784e-001, -2.478080e-001, -2.477376e-001, -2.476672e-001, -2.475968e-001, -2.475265e-001, -2.474561e-001, -2.473858e-001, -2.473154e-001, -2.472451e-001, -2.471748e-001, -2.471045e-001, -2.470342e-001, -2.469639e-001, -2.468936e-001, -2.468234e-001, -2.467531e-001, -2.466829e-001, -2.466126e-001, -2.465424e-001, -2.464722e-001, -2.464020e-001, -2.463318e-001, -2.462616e-001, -2.461914e-001, -2.461213e-001, -2.460511e-001, -2.459810e-001, -2.459108e-001, -2.458407e-001, -2.457706e-001, -2.457005e-001, -2.456304e-001, -2.455603e-001, -2.454902e-001, -2.454202e-001, -2.453501e-001, -2.452801e-001, -2.452100e-001, -2.451400e-001, -2.450700e-001, 
-2.450000e-001, -2.449300e-001, -2.448600e-001, -2.447900e-001, -2.447201e-001, -2.446501e-001, -2.445802e-001, -2.445102e-001, -2.444403e-001, -2.443704e-001, -2.443005e-001, -2.442306e-001, -2.441607e-001, -2.440908e-001, -2.440210e-001, -2.439511e-001, -2.438813e-001, -2.438114e-001, -2.437416e-001, -2.436718e-001, -2.436020e-001, -2.435322e-001, -2.434624e-001, -2.433926e-001, -2.433229e-001, -2.432531e-001, -2.431834e-001, -2.431136e-001, -2.430439e-001, -2.429742e-001, -2.429045e-001, -2.428348e-001, -2.427651e-001, -2.426954e-001, -2.426258e-001, -2.425561e-001, -2.424865e-001, -2.424168e-001, -2.423472e-001, -2.422776e-001, -2.422080e-001, -2.421384e-001, -2.420688e-001, -2.419992e-001, -2.419297e-001, -2.418601e-001, -2.417906e-001, -2.417210e-001, -2.416515e-001, -2.415820e-001, -2.415125e-001, -2.414430e-001, -2.413735e-001, -2.413040e-001, -2.412346e-001, -2.411651e-001, -2.410957e-001, -2.410262e-001, -2.409568e-001, -2.408874e-001, -2.408180e-001, -2.407486e-001, -2.406792e-001, -2.406098e-001, -2.405405e-001, -2.404711e-001, -2.404018e-001, -2.403324e-001, -2.402631e-001, -2.401938e-001, -2.401245e-001, -2.400552e-001, -2.399859e-001, -2.399166e-001, -2.398474e-001, -2.397781e-001, -2.397089e-001, -2.396396e-001, -2.395704e-001, -2.395012e-001, -2.394320e-001, -2.393628e-001, -2.392936e-001, -2.392244e-001, -2.391553e-001, -2.390861e-001, -2.390170e-001, -2.389478e-001, -2.388787e-001, -2.388096e-001, -2.387405e-001, -2.386714e-001, -2.386023e-001, -2.385332e-001, -2.384642e-001, -2.383951e-001, -2.383261e-001, -2.382570e-001, -2.381880e-001, -2.381190e-001, 
-2.380500e-001, -2.379810e-001, -2.379120e-001, -2.378430e-001, -2.377741e-001, -2.377051e-001, -2.376362e-001, -2.375672e-001, -2.374983e-001, -2.374294e-001, -2.373605e-001, -2.372916e-001, -2.372227e-001, -2.371538e-001, -2.370850e-001, -2.370161e-001, -2.369473e-001, -2.368784e-001, -2.368096e-001, -2.367408e-001, -2.366720e-001, -2.366032e-001, -2.365344e-001, -2.364656e-001, -2.363969e-001, -2.363281e-001, -2.362594e-001, -2.361906e-001, -2.361219e-001, -2.360532e-001, -2.359845e-001, -2.359158e-001, -2.358471e-001, -2.357784e-001, -2.357098e-001, -2.356411e-001, -2.355725e-001, -2.355038e-001, -2.354352e-001, -2.353666e-001, -2.352980e-001, -2.352294e-001, -2.351608e-001, -2.350922e-001, -2.350237e-001, -2.349551e-001, -2.348866e-001, -2.348180e-001, -2.347495e-001, -2.346810e-001, -2.346125e-001, -2.345440e-001, -2.344755e-001, -2.344070e-001, -2.343386e-001, -2.342701e-001, -2.342017e-001, -2.341332e-001, -2.340648e-001, -2.339964e-001, -2.339280e-001, -2.338596e-001, -2.337912e-001, -2.337228e-001, -2.336545e-001, -2.335861e-001, -2.335178e-001, -2.334494e-001, -2.333811e-001, -2.333128e-001, -2.332445e-001, -2.331762e-001, -2.331079e-001, -2.330396e-001, -2.329714e-001, -2.329031e-001, -2.328349e-001, -2.327666e-001, -2.326984e-001, -2.326302e-001, -2.325620e-001, -2.324938e-001, -2.324256e-001, -2.323574e-001, -2.322893e-001, -2.322211e-001, -2.321530e-001, -2.320848e-001, -2.320167e-001, -2.319486e-001, -2.318805e-001, -2.318124e-001, -2.317443e-001, -2.316762e-001, -2.316082e-001, -2.315401e-001, -2.314721e-001, -2.314040e-001, -2.313360e-001, -2.312680e-001, 
-2.312000e-001, -2.311320e-001, -2.310640e-001, -2.309960e-001, -2.309281e-001, -2.308601e-001, -2.307922e-001, -2.307242e-001, -2.306563e-001, -2.305884e-001, -2.305205e-001, -2.304526e-001, -2.303847e-001, -2.303168e-001, -2.302490e-001, -2.301811e-001, -2.301133e-001, -2.300454e-001, -2.299776e-001, -2.299098e-001, -2.298420e-001, -2.297742e-001, -2.297064e-001, -2.296386e-001, -2.295709e-001, -2.295031e-001, -2.294354e-001, -2.293676e-001, -2.292999e-001, -2.292322e-001, -2.291645e-001, -2.290968e-001, -2.290291e-001, -2.289614e-001, -2.288938e-001, -2.288261e-001, -2.287585e-001, -2.286908e-001, -2.286232e-001, -2.285556e-001, -2.284880e-001, -2.284204e-001, -2.283528e-001, -2.282852e-001, -2.282177e-001, -2.281501e-001, -2.280826e-001, -2.280150e-001, -2.279475e-001, -2.278800e-001, -2.278125e-001, -2.277450e-001, -2.276775e-001, -2.276100e-001, -2.275426e-001, -2.274751e-001, -2.274077e-001, -2.273402e-001, -2.272728e-001, -2.272054e-001, -2.271380e-001, -2.270706e-001, -2.270032e-001, -2.269358e-001, -2.268685e-001, -2.268011e-001, -2.267338e-001, -2.266664e-001, -2.265991e-001, -2.265318e-001, -2.264645e-001, -2.263972e-001, -2.263299e-001, -2.262626e-001, -2.261954e-001, -2.261281e-001, -2.260609e-001, -2.259936e-001, -2.259264e-001, -2.258592e-001, -2.257920e-001, -2.257248e-001, -2.256576e-001, -2.255904e-001, -2.255233e-001, -2.254561e-001, -2.253890e-001, -2.253218e-001, -2.252547e-001, -2.251876e-001, -2.251205e-001, -2.250534e-001, -2.249863e-001, -2.249192e-001, -2.248522e-001, -2.247851e-001, -2.247181e-001, -2.246510e-001, -2.245840e-001, -2.245170e-001, 
-2.244500e-001, -2.243830e-001, -2.243160e-001, -2.242490e-001, -2.241821e-001, -2.241151e-001, -2.240482e-001, -2.239812e-001, -2.239143e-001, -2.238474e-001, -2.237805e-001, -2.237136e-001, -2.236467e-001, -2.235798e-001, -2.235130e-001, -2.234461e-001, -2.233793e-001, -2.233124e-001, -2.232456e-001, -2.231788e-001, -2.231120e-001, -2.230452e-001, -2.229784e-001, -2.229116e-001, -2.228449e-001, -2.227781e-001, -2.227114e-001, -2.226446e-001, -2.225779e-001, -2.225112e-001, -2.224445e-001, -2.223778e-001, -2.223111e-001, -2.222444e-001, -2.221778e-001, -2.221111e-001, -2.220445e-001, -2.219778e-001, -2.219112e-001, -2.218446e-001, -2.217780e-001, -2.217114e-001, -2.216448e-001, -2.215782e-001, -2.215117e-001, -2.214451e-001, -2.213786e-001, -2.213120e-001, -2.212455e-001, -2.211790e-001, -2.211125e-001, -2.210460e-001, -2.209795e-001, -2.209130e-001, -2.208466e-001, -2.207801e-001, -2.207137e-001, -2.206472e-001, -2.205808e-001, -2.205144e-001, -2.204480e-001, -2.203816e-001, -2.203152e-001, -2.202488e-001, -2.201825e-001, -2.201161e-001, -2.200498e-001, -2.199834e-001, -2.199171e-001, -2.198508e-001, -2.197845e-001, -2.197182e-001, -2.196519e-001, -2.195856e-001, -2.195194e-001, -2.194531e-001, -2.193869e-001, -2.193206e-001, -2.192544e-001, -2.191882e-001, -2.191220e-001, -2.190558e-001, -2.189896e-001, -2.189234e-001, -2.188573e-001, -2.187911e-001, -2.187250e-001, -2.186588e-001, -2.185927e-001, -2.185266e-001, -2.184605e-001, -2.183944e-001, -2.183283e-001, -2.182622e-001, -2.181962e-001, -2.181301e-001, -2.180641e-001, -2.179980e-001, -2.179320e-001, -2.178660e-001, 
-2.178000e-001, -2.177340e-001, -2.176680e-001, -2.176020e-001, -2.175361e-001, -2.174701e-001, -2.174042e-001, -2.173382e-001, -2.172723e-001, -2.172064e-001, -2.171405e-001, -2.170746e-001, -2.170087e-001, -2.169428e-001, -2.168770e-001, -2.168111e-001, -2.167453e-001, -2.166794e-001, -2.166136e-001, -2.165478e-001, -2.164820e-001, -2.164162e-001, -2.163504e-001, -2.162846e-001, -2.162189e-001, -2.161531e-001, -2.160874e-001, -2.160216e-001, -2.159559e-001, -2.158902e-001, -2.158245e-001, -2.157588e-001, -2.156931e-001, -2.156274e-001, -2.155618e-001, -2.154961e-001, -2.154305e-001, -2.153648e-001, -2.152992e-001, -2.152336e-001, -2.151680e-001, -2.151024e-001, -2.150368e-001, -2.149712e-001, -2.149057e-001, -2.148401e-001, -2.147746e-001, -2.147090e-001, -2.146435e-001, -2.145780e-001, -2.145125e-001, -2.144470e-001, -2.143815e-001, -2.143160e-001, -2.142506e-001, -2.141851e-001, -2.141197e-001, -2.140542e-001, -2.139888e-001, -2.139234e-001, -2.138580e-001, -2.137926e-001, -2.137272e-001, -2.136618e-001, -2.135965e-001, -2.135311e-001, -2.134658e-001, -2.134004e-001, -2.133351e-001, -2.132698e-001, -2.132045e-001, -2.131392e-001, -2.130739e-001, -2.130086e-001, -2.129434e-001, -2.128781e-001, -2.128129e-001, -2.127476e-001, -2.126824e-001, -2.126172e-001, -2.125520e-001, -2.124868e-001, -2.124216e-001, -2.123564e-001, -2.122913e-001, -2.122261e-001, -2.121610e-001, -2.120958e-001, -2.120307e-001, -2.119656e-001, -2.119005e-001, -2.118354e-001, -2.117703e-001, -2.117052e-001, -2.116402e-001, -2.115751e-001, -2.115101e-001, -2.114450e-001, -2.113800e-001, -2.113150e-001, 
-2.112500e-001, -2.111850e-001, -2.111200e-001, -2.110550e-001, -2.109901e-001, -2.109251e-001, -2.108602e-001, -2.107952e-001, -2.107303e-001, -2.106654e-001, -2.106005e-001, -2.105356e-001, -2.104707e-001, -2.104058e-001, -2.103410e-001, -2.102761e-001, -2.102113e-001, -2.101464e-001, -2.100816e-001, -2.100168e-001, -2.099520e-001, -2.098872e-001, -2.098224e-001, -2.097576e-001, -2.096929e-001, -2.096281e-001, -2.095634e-001, -2.094986e-001, -2.094339e-001, -2.093692e-001, -2.093045e-001, -2.092398e-001, -2.091751e-001, -2.091104e-001, -2.090458e-001, -2.089811e-001, -2.089165e-001, -2.088518e-001, -2.087872e-001, -2.087226e-001, -2.086580e-001, -2.085934e-001, -2.085288e-001, -2.084642e-001, -2.083997e-001, -2.083351e-001, -2.082706e-001, -2.082060e-001, -2.081415e-001, -2.080770e-001, -2.080125e-001, -2.079480e-001, -2.078835e-001, -2.078190e-001, -2.077546e-001, -2.076901e-001, -2.076257e-001, -2.075612e-001, -2.074968e-001, -2.074324e-001, -2.073680e-001, -2.073036e-001, -2.072392e-001, -2.071748e-001, -2.071105e-001, -2.070461e-001, -2.069818e-001, -2.069174e-001, -2.068531e-001, -2.067888e-001, -2.067245e-001, -2.066602e-001, -2.065959e-001, -2.065316e-001, -2.064674e-001, -2.064031e-001, -2.063389e-001, -2.062746e-001, -2.062104e-001, -2.061462e-001, -2.060820e-001, -2.060178e-001, -2.059536e-001, -2.058894e-001, -2.058253e-001, -2.057611e-001, -2.056970e-001, -2.056328e-001, -2.055687e-001, -2.055046e-001, -2.054405e-001, -2.053764e-001, -2.053123e-001, -2.052482e-001, -2.051842e-001, -2.051201e-001, -2.050561e-001, -2.049920e-001, -2.049280e-001, -2.048640e-001, 
-2.048000e-001, -2.047360e-001, -2.046720e-001, -2.046080e-001, -2.045441e-001, -2.044801e-001, -2.044162e-001, -2.043522e-001, -2.042883e-001, -2.042244e-001, -2.041605e-001, -2.040966e-001, -2.040327e-001, -2.039688e-001, -2.039050e-001, -2.038411e-001, -2.037773e-001, -2.037134e-001, -2.036496e-001, -2.035858e-001, -2.035220e-001, -2.034582e-001, -2.033944e-001, -2.033306e-001, -2.032669e-001, -2.032031e-001, -2.031394e-001, -2.030756e-001, -2.030119e-001, -2.029482e-001, -2.028845e-001, -2.028208e-001, -2.027571e-001, -2.026934e-001, -2.026298e-001, -2.025661e-001, -2.025025e-001, -2.024388e-001, -2.023752e-001, -2.023116e-001, -2.022480e-001, -2.021844e-001, -2.021208e-001, -2.020572e-001, -2.019937e-001, -2.019301e-001, -2.018666e-001, -2.018030e-001, -2.017395e-001, -2.016760e-001, -2.016125e-001, -2.015490e-001, -2.014855e-001, -2.014220e-001, -2.013586e-001, -2.012951e-001, -2.012317e-001, -2.011682e-001, -2.011048e-001, -2.010414e-001, -2.009780e-001, -2.009146e-001, -2.008512e-001, -2.007878e-001, -2.007245e-001, -2.006611e-001, -2.005978e-001, -2.005344e-001, -2.004711e-001, -2.004078e-001, -2.003445e-001, -2.002812e-001, -2.002179e-001, -2.001546e-001, -2.000914e-001, -2.000281e-001, -1.999649e-001, -1.999016e-001, -1.998384e-001, -1.997752e-001, -1.997120e-001, -1.996488e-001, -1.995856e-001, -1.995224e-001, -1.994593e-001, -1.993961e-001, -1.993330e-001, -1.992698e-001, -1.992067e-001, -1.991436e-001, -1.990805e-001, -1.990174e-001, -1.989543e-001, -1.988912e-001, -1.988282e-001, -1.987651e-001, -1.987021e-001, -1.986390e-001, -1.985760e-001, -1.985130e-001, 
-1.984500e-001, -1.983870e-001, -1.983240e-001, -1.982610e-001, -1.981981e-001, -1.981351e-001, -1.980722e-001, -1.980092e-001, -1.979463e-001, -1.978834e-001, -1.978205e-001, -1.977576e-001, -1.976947e-001, -1.976318e-001, -1.975690e-001, -1.975061e-001, -1.974433e-001, -1.973804e-001, -1.973176e-001, -1.972548e-001, -1.971920e-001, -1.971292e-001, -1.970664e-001, -1.970036e-001, -1.969409e-001, -1.968781e-001, -1.968154e-001, -1.967526e-001, -1.966899e-001, -1.966272e-001, -1.965645e-001, -1.965018e-001, -1.964391e-001, -1.963764e-001, -1.963138e-001, -1.962511e-001, -1.961885e-001, -1.961258e-001, -1.960632e-001, -1.960006e-001, -1.959380e-001, -1.958754e-001, -1.958128e-001, -1.957502e-001, -1.956877e-001, -1.956251e-001, -1.955626e-001, -1.955000e-001, -1.954375e-001, -1.953750e-001, -1.953125e-001, -1.952500e-001, -1.951875e-001, -1.951250e-001, -1.950626e-001, -1.950001e-001, -1.949377e-001, -1.948752e-001, -1.948128e-001, -1.947504e-001, -1.946880e-001, -1.946256e-001, -1.945632e-001, -1.945008e-001, -1.944385e-001, -1.943761e-001, -1.943138e-001, -1.942514e-001, -1.941891e-001, -1.941268e-001, -1.940645e-001, -1.940022e-001, -1.939399e-001, -1.938776e-001, -1.938154e-001, -1.937531e-001, -1.936909e-001, -1.936286e-001, -1.935664e-001, -1.935042e-001, -1.934420e-001, -1.933798e-001, -1.933176e-001, -1.932554e-001, -1.931933e-001, -1.931311e-001, -1.930690e-001, -1.930068e-001, -1.929447e-001, -1.928826e-001, -1.928205e-001, -1.927584e-001, -1.926963e-001, -1.926342e-001, -1.925722e-001, -1.925101e-001, -1.924481e-001, -1.923860e-001, -1.923240e-001, -1.922620e-001, 
-1.922000e-001, -1.921380e-001, -1.920760e-001, -1.920140e-001, -1.919521e-001, -1.918901e-001, -1.918282e-001, -1.917662e-001, -1.917043e-001, -1.916424e-001, -1.915805e-001, -1.915186e-001, -1.914567e-001, -1.913948e-001, -1.913330e-001, -1.912711e-001, -1.912093e-001, -1.911474e-001, -1.910856e-001, -1.910238e-001, -1.909620e-001, -1.909002e-001, -1.908384e-001, -1.907766e-001, -1.907149e-001, -1.906531e-001, -1.905914e-001, -1.905296e-001, -1.904679e-001, -1.904062e-001, -1.903445e-001, -1.902828e-001, -1.902211e-001, -1.901594e-001, -1.900978e-001, -1.900361e-001, -1.899745e-001, -1.899128e-001, -1.898512e-001, -1.897896e-001, -1.897280e-001, -1.896664e-001, -1.896048e-001, -1.895432e-001, -1.894817e-001, -1.894201e-001, -1.893586e-001, -1.892970e-001, -1.892355e-001, -1.891740e-001, -1.891125e-001, -1.890510e-001, -1.889895e-001, -1.889280e-001, -1.888666e-001, -1.888051e-001, -1.887437e-001, -1.886822e-001, -1.886208e-001, -1.885594e-001, -1.884980e-001, -1.884366e-001, -1.883752e-001, -1.883138e-001, -1.882525e-001, -1.881911e-001, -1.881298e-001, -1.880684e-001, -1.880071e-001, -1.879458e-001, -1.878845e-001, -1.878232e-001, -1.877619e-001, -1.877006e-001, -1.876394e-001, -1.875781e-001, -1.875169e-001, -1.874556e-001, -1.873944e-001, -1.873332e-001, -1.872720e-001, -1.872108e-001, -1.871496e-001, -1.870884e-001, -1.870273e-001, -1.869661e-001, -1.869050e-001, -1.868438e-001, -1.867827e-001, -1.867216e-001, -1.866605e-001, -1.865994e-001, -1.865383e-001, -1.864772e-001, -1.864162e-001, -1.863551e-001, -1.862941e-001, -1.862330e-001, -1.861720e-001, -1.861110e-001, 
-1.860500e-001, -1.859890e-001, -1.859280e-001, -1.858670e-001, -1.858061e-001, -1.857451e-001, -1.856842e-001, -1.856232e-001, -1.855623e-001, -1.855014e-001, -1.854405e-001, -1.853796e-001, -1.853187e-001, -1.852578e-001, -1.851970e-001, -1.851361e-001, -1.850753e-001, -1.850144e-001, -1.849536e-001, -1.848928e-001, -1.848320e-001, -1.847712e-001, -1.847104e-001, -1.846496e-001, -1.845889e-001, -1.845281e-001, -1.844674e-001, -1.844066e-001, -1.843459e-001, -1.842852e-001, -1.842245e-001, -1.841638e-001, -1.841031e-001, -1.840424e-001, -1.839818e-001, -1.839211e-001, -1.838605e-001, -1.837998e-001, -1.837392e-001, -1.836786e-001, -1.836180e-001, -1.835574e-001, -1.834968e-001, -1.834362e-001, -1.833757e-001, -1.833151e-001, -1.832546e-001, -1.831940e-001, -1.831335e-001, -1.830730e-001, -1.830125e-001, -1.829520e-001, -1.828915e-001, -1.828310e-001, -1.827706e-001, -1.827101e-001, -1.826497e-001, -1.825892e-001, -1.825288e-001, -1.824684e-001, -1.824080e-001, -1.823476e-001, -1.822872e-001, -1.822268e-001, -1.821665e-001, -1.821061e-001, -1.820458e-001, -1.819854e-001, -1.819251e-001, -1.818648e-001, -1.818045e-001, -1.817442e-001, -1.816839e-001, -1.816236e-001, -1.815634e-001, -1.815031e-001, -1.814429e-001, -1.813826e-001, -1.813224e-001, -1.812622e-001, -1.812020e-001, -1.811418e-001, -1.810816e-001, -1.810214e-001, -1.809613e-001, -1.809011e-001, -1.808410e-001, -1.807808e-001, -1.807207e-001, -1.806606e-001, -1.806005e-001, -1.805404e-001, -1.804803e-001, -1.804202e-001, -1.803602e-001, -1.803001e-001, -1.802401e-001, -1.801800e-001, -1.801200e-001, -1.800600e-001, 
-1.800000e-001, -1.799400e-001, -1.798800e-001, -1.798200e-001, -1.797601e-001, -1.797001e-001, -1.796402e-001, -1.795802e-001, -1.795203e-001, -1.794604e-001, -1.794005e-001, -1.793406e-001, -1.792807e-001, -1.792208e-001, -1.791610e-001, -1.791011e-001, -1.790413e-001, -1.789814e-001, -1.789216e-001, -1.788618e-001, -1.788020e-001, -1.787422e-001, -1.786824e-001, -1.786226e-001, -1.785629e-001, -1.785031e-001, -1.784434e-001, -1.783836e-001, -1.783239e-001, -1.782642e-001, -1.782045e-001, -1.781448e-001, -1.780851e-001, -1.780254e-001, -1.779658e-001, -1.779061e-001, -1.778465e-001, -1.777868e-001, -1.777272e-001, -1.776676e-001, -1.776080e-001, -1.775484e-001, -1.774888e-001, -1.774292e-001, -1.773697e-001, -1.773101e-001, -1.772506e-001, -1.771910e-001, -1.771315e-001, -1.770720e-001, -1.770125e-001, -1.769530e-001, -1.768935e-001, -1.768340e-001, -1.767746e-001, -1.767151e-001, -1.766557e-001, -1.765962e-001, -1.765368e-001, -1.764774e-001, -1.764180e-001, -1.763586e-001, -1.762992e-001, -1.762398e-001, -1.761805e-001, -1.761211e-001, -1.760618e-001, -1.760024e-001, -1.759431e-001, -1.758838e-001, -1.758245e-001, -1.757652e-001, -1.757059e-001, -1.756466e-001, -1.755874e-001, -1.755281e-001, -1.754689e-001, -1.754096e-001, -1.753504e-001, -1.752912e-001, -1.752320e-001, -1.751728e-001, -1.751136e-001, -1.750544e-001, -1.749953e-001, -1.749361e-001, -1.748770e-001, -1.748178e-001, -1.747587e-001, -1.746996e-001, -1.746405e-001, -1.745814e-001, -1.745223e-001, -1.744632e-001, -1.744042e-001, -1.743451e-001, -1.742861e-001, -1.742270e-001, -1.741680e-001, -1.741090e-001, 
-1.740500e-001, -1.739910e-001, -1.739320e-001, -1.738730e-001, -1.738141e-001, -1.737551e-001, -1.736962e-001, -1.736372e-001, -1.735783e-001, -1.735194e-001, -1.734605e-001, -1.734016e-001, -1.733427e-001, -1.732838e-001, -1.732250e-001, -1.731661e-001, -1.731073e-001, -1.730484e-001, -1.729896e-001, -1.729308e-001, -1.728720e-001, -1.728132e-001, -1.727544e-001, -1.726956e-001, -1.726369e-001, -1.725781e-001, -1.725194e-001, -1.724606e-001, -1.724019e-001, -1.723432e-001, -1.722845e-001, -1.722258e-001, -1.721671e-001, -1.721084e-001, -1.720498e-001, -1.719911e-001, -1.719325e-001, -1.718738e-001, -1.718152e-001, -1.717566e-001, -1.716980e-001, -1.716394e-001, -1.715808e-001, -1.715222e-001, -1.714637e-001, -1.714051e-001, -1.713466e-001, -1.712880e-001, -1.712295e-001, -1.711710e-001, -1.711125e-001, -1.710540e-001, -1.709955e-001, -1.709370e-001, -1.708786e-001, -1.708201e-001, -1.707617e-001, -1.707032e-001, -1.706448e-001, -1.705864e-001, -1.705280e-001, -1.704696e-001, -1.704112e-001, -1.703528e-001, -1.702945e-001, -1.702361e-001, -1.701778e-001, -1.701194e-001, -1.700611e-001, -1.700028e-001, -1.699445e-001, -1.698862e-001, -1.698279e-001, -1.697696e-001, -1.697114e-001, -1.696531e-001, -1.695949e-001, -1.695366e-001, -1.694784e-001, -1.694202e-001, -1.693620e-001, -1.693038e-001, -1.692456e-001, -1.691874e-001, -1.691293e-001, -1.690711e-001, -1.690130e-001, -1.689548e-001, -1.688967e-001, -1.688386e-001, -1.687805e-001, -1.687224e-001, -1.686643e-001, -1.686062e-001, -1.685482e-001, -1.684901e-001, -1.684321e-001, -1.683740e-001, -1.683160e-001, -1.682580e-001, 
-1.682000e-001, -1.681420e-001, -1.680840e-001, -1.680260e-001, -1.679681e-001, -1.679101e-001, -1.678522e-001, -1.677942e-001, -1.677363e-001, -1.676784e-001, -1.676205e-001, -1.675626e-001, -1.675047e-001, -1.674468e-001, -1.673890e-001, -1.673311e-001, -1.672733e-001, -1.672154e-001, -1.671576e-001, -1.670998e-001, -1.670420e-001, -1.669842e-001, -1.669264e-001, -1.668686e-001, -1.668109e-001, -1.667531e-001, -1.666954e-001, -1.666376e-001, -1.665799e-001, -1.665222e-001, -1.664645e-001, -1.664068e-001, -1.663491e-001, -1.662914e-001, -1.662338e-001, -1.661761e-001, -1.661185e-001, -1.660608e-001, -1.660032e-001, -1.659456e-001, -1.658880e-001, -1.658304e-001, -1.657728e-001, -1.657152e-001, -1.656577e-001, -1.656001e-001, -1.655426e-001, -1.654850e-001, -1.654275e-001, -1.653700e-001, -1.653125e-001, -1.652550e-001, -1.651975e-001, -1.651400e-001, -1.650826e-001, -1.650251e-001, -1.649677e-001, -1.649102e-001, -1.648528e-001, -1.647954e-001, -1.647380e-001, -1.646806e-001, -1.646232e-001, -1.645658e-001, -1.645085e-001, -1.644511e-001, -1.643938e-001, -1.643364e-001, -1.642791e-001, -1.642218e-001, -1.641645e-001, -1.641072e-001, -1.640499e-001, -1.639926e-001, -1.639354e-001, -1.638781e-001, -1.638209e-001, -1.637636e-001, -1.637064e-001, -1.636492e-001, -1.635920e-001, -1.635348e-001, -1.634776e-001, -1.634204e-001, -1.633633e-001, -1.633061e-001, -1.632490e-001, -1.631918e-001, -1.631347e-001, -1.630776e-001, -1.630205e-001, -1.629634e-001, -1.629063e-001, -1.628492e-001, -1.627922e-001, -1.627351e-001, -1.626781e-001, -1.626210e-001, -1.625640e-001, -1.625070e-001, 
-1.624500e-001, -1.623930e-001, -1.623360e-001, -1.622790e-001, -1.622221e-001, -1.621651e-001, -1.621082e-001, -1.620512e-001, -1.619943e-001, -1.619374e-001, -1.618805e-001, -1.618236e-001, -1.617667e-001, -1.617098e-001, -1.616530e-001, -1.615961e-001, -1.615393e-001, -1.614824e-001, -1.614256e-001, -1.613688e-001, -1.613120e-001, -1.612552e-001, -1.611984e-001, -1.611416e-001, -1.610849e-001, -1.610281e-001, -1.609714e-001, -1.609146e-001, -1.608579e-001, -1.608012e-001, -1.607445e-001, -1.606878e-001, -1.606311e-001, -1.605744e-001, -1.605178e-001, -1.604611e-001, -1.604045e-001, -1.603478e-001, -1.602912e-001, -1.602346e-001, -1.601780e-001, -1.601214e-001, -1.600648e-001, -1.600082e-001, -1.599517e-001, -1.598951e-001, -1.598386e-001, -1.597820e-001, -1.597255e-001, -1.596690e-001, -1.596125e-001, -1.595560e-001, -1.594995e-001, -1.594430e-001, -1.593866e-001, -1.593301e-001, -1.592737e-001, -1.592172e-001, -1.591608e-001, -1.591044e-001, -1.590480e-001, -1.589916e-001, -1.589352e-001, -1.588788e-001, -1.588225e-001, -1.587661e-001, -1.587098e-001, -1.586534e-001, -1.585971e-001, -1.585408e-001, -1.584845e-001, -1.584282e-001, -1.583719e-001, -1.583156e-001, -1.582594e-001, -1.582031e-001, -1.581469e-001, -1.580906e-001, -1.580344e-001, -1.579782e-001, -1.579220e-001, -1.578658e-001, -1.578096e-001, -1.577534e-001, -1.576973e-001, -1.576411e-001, -1.575850e-001, -1.575288e-001, -1.574727e-001, -1.574166e-001, -1.573605e-001, -1.573044e-001, -1.572483e-001, -1.571922e-001, -1.571362e-001, -1.570801e-001, -1.570241e-001, -1.569680e-001, -1.569120e-001, -1.568560e-001, 
-1.568000e-001, -1.567440e-001, -1.566880e-001, -1.566320e-001, -1.565761e-001, -1.565201e-001, -1.564642e-001, -1.564082e-001, -1.563523e-001, -1.562964e-001, -1.562405e-001, -1.561846e-001, -1.561287e-001, -1.560728e-001, -1.560170e-001, -1.559611e-001, -1.559053e-001, -1.558494e-001, -1.557936e-001, -1.557378e-001, -1.556820e-001, -1.556262e-001, -1.555704e-001, -1.555146e-001, -1.554589e-001, -1.554031e-001, -1.553474e-001, -1.552916e-001, -1.552359e-001, -1.551802e-001, -1.551245e-001, -1.550688e-001, -1.550131e-001, -1.549574e-001, -1.549018e-001, -1.548461e-001, -1.547905e-001, -1.547348e-001, -1.546792e-001, -1.546236e-001, -1.545680e-001, -1.545124e-001, -1.544568e-001, -1.544012e-001, -1.543457e-001, -1.542901e-001, -1.542346e-001, -1.541790e-001, -1.541235e-001, -1.540680e-001, -1.540125e-001, -1.539570e-001, -1.539015e-001, -1.538460e-001, -1.537906e-001, -1.537351e-001, -1.536797e-001, -1.536242e-001, -1.535688e-001, -1.535134e-001, -1.534580e-001, -1.534026e-001, -1.533472e-001, -1.532918e-001, -1.532365e-001, -1.531811e-001, -1.531258e-001, -1.530704e-001, -1.530151e-001, -1.529598e-001, -1.529045e-001, -1.528492e-001, -1.527939e-001, -1.527386e-001, -1.526834e-001, -1.526281e-001, -1.525729e-001, -1.525176e-001, -1.524624e-001, -1.524072e-001, -1.523520e-001, -1.522968e-001, -1.522416e-001, -1.521864e-001, -1.521313e-001, -1.520761e-001, -1.520210e-001, -1.519658e-001, -1.519107e-001, -1.518556e-001, -1.518005e-001, -1.517454e-001, -1.516903e-001, -1.516352e-001, -1.515802e-001, -1.515251e-001, -1.514701e-001, -1.514150e-001, -1.513600e-001, -1.513050e-001, 
-1.512500e-001, -1.511950e-001, -1.511400e-001, -1.510850e-001, -1.510301e-001, -1.509751e-001, -1.509202e-001, -1.508652e-001, -1.508103e-001, -1.507554e-001, -1.507005e-001, -1.506456e-001, -1.505907e-001, -1.505358e-001, -1.504810e-001, -1.504261e-001, -1.503713e-001, -1.503164e-001, -1.502616e-001, -1.502068e-001, -1.501520e-001, -1.500972e-001, -1.500424e-001, -1.499876e-001, -1.499329e-001, -1.498781e-001, -1.498234e-001, -1.497686e-001, -1.497139e-001, -1.496592e-001, -1.496045e-001, -1.495498e-001, -1.494951e-001, -1.494404e-001, -1.493858e-001, -1.493311e-001, -1.492765e-001, -1.492218e-001, -1.491672e-001, -1.491126e-001, -1.490580e-001, -1.490034e-001, -1.489488e-001, -1.488942e-001, -1.488397e-001, -1.487851e-001, -1.487306e-001, -1.486760e-001, -1.486215e-001, -1.485670e-001, -1.485125e-001, -1.484580e-001, -1.484035e-001, -1.483490e-001, -1.482946e-001, -1.482401e-001, -1.481857e-001, -1.481312e-001, -1.480768e-001, -1.480224e-001, -1.479680e-001, -1.479136e-001, -1.478592e-001, -1.478048e-001, -1.477505e-001, -1.476961e-001, -1.476418e-001, -1.475874e-001, -1.475331e-001, -1.474788e-001, -1.474245e-001, -1.473702e-001, -1.473159e-001, -1.472616e-001, -1.472074e-001, -1.471531e-001, -1.470989e-001, -1.470446e-001, -1.469904e-001, -1.469362e-001, -1.468820e-001, -1.468278e-001, -1.467736e-001, -1.467194e-001, -1.466653e-001, -1.466111e-001, -1.465570e-001, -1.465028e-001, -1.464487e-001, -1.463946e-001, -1.463405e-001, -1.462864e-001, -1.462323e-001, -1.461782e-001, -1.461242e-001, -1.460701e-001, -1.460161e-001, -1.459620e-001, -1.459080e-001, -1.458540e-001, 
-1.458000e-001, -1.457460e-001, -1.456920e-001, -1.456380e-001, -1.455841e-001, -1.455301e-001, -1.454762e-001, -1.454222e-001, -1.453683e-001, -1.453144e-001, -1.452605e-001, -1.452066e-001, -1.451527e-001, -1.450988e-001, -1.450450e-001, -1.449911e-001, -1.449373e-001, -1.448834e-001, -1.448296e-001, -1.447758e-001, -1.447220e-001, -1.446682e-001, -1.446144e-001, -1.445606e-001, -1.445069e-001, -1.444531e-001, -1.443994e-001, -1.443456e-001, -1.442919e-001, -1.442382e-001, -1.441845e-001, -1.441308e-001, -1.440771e-001, -1.440234e-001, -1.439698e-001, -1.439161e-001, -1.438625e-001, -1.438088e-001, -1.437552e-001, -1.437016e-001, -1.436480e-001, -1.435944e-001, -1.435408e-001, -1.434872e-001, -1.434337e-001, -1.433801e-001, -1.433266e-001, -1.432730e-001, -1.432195e-001, -1.431660e-001, -1.431125e-001, -1.430590e-001, -1.430055e-001, -1.429520e-001, -1.428986e-001, -1.428451e-001, -1.427917e-001, -1.427382e-001, -1.426848e-001, -1.426314e-001, -1.425780e-001, -1.425246e-001, -1.424712e-001, -1.424178e-001, -1.423645e-001, -1.423111e-001, -1.422578e-001, -1.422044e-001, -1.421511e-001, -1.420978e-001, -1.420445e-001, -1.419912e-001, -1.419379e-001, -1.418846e-001, -1.418314e-001, -1.417781e-001, -1.417249e-001, -1.416716e-001, -1.416184e-001, -1.415652e-001, -1.415120e-001, -1.414588e-001, -1.414056e-001, -1.413524e-001, -1.412993e-001, -1.412461e-001, -1.411930e-001, -1.411398e-001, -1.410867e-001, -1.410336e-001, -1.409805e-001, -1.409274e-001, -1.408743e-001, -1.408212e-001, -1.407682e-001, -1.407151e-001, -1.406621e-001, -1.406090e-001, -1.405560e-001, -1.405030e-001, 
-1.404500e-001, -1.403970e-001, -1.403440e-001, -1.402910e-001, -1.402381e-001, -1.401851e-001, -1.401322e-001, -1.400792e-001, -1.400263e-001, -1.399734e-001, -1.399205e-001, -1.398676e-001, -1.398147e-001, -1.397618e-001, -1.397090e-001, -1.396561e-001, -1.396033e-001, -1.395504e-001, -1.394976e-001, -1.394448e-001, -1.393920e-001, -1.393392e-001, -1.392864e-001, -1.392336e-001, -1.391809e-001, -1.391281e-001, -1.390754e-001, -1.390226e-001, -1.389699e-001, -1.389172e-001, -1.388645e-001, -1.388118e-001, -1.387591e-001, -1.387064e-001, -1.386538e-001, -1.386011e-001, -1.385485e-001, -1.384958e-001, -1.384432e-001, -1.383906e-001, -1.383380e-001, -1.382854e-001, -1.382328e-001, -1.381802e-001, -1.381277e-001, -1.380751e-001, -1.380226e-001, -1.379700e-001, -1.379175e-001, -1.378650e-001, -1.378125e-001, -1.377600e-001, -1.377075e-001, -1.376550e-001, -1.376026e-001, -1.375501e-001, -1.374977e-001, -1.374452e-001, -1.373928e-001, -1.373404e-001, -1.372880e-001, -1.372356e-001, -1.371832e-001, -1.371308e-001, -1.370785e-001, -1.370261e-001, -1.369738e-001, -1.369214e-001, -1.368691e-001, -1.368168e-001, -1.367645e-001, -1.367122e-001, -1.366599e-001, -1.366076e-001, -1.365554e-001, -1.365031e-001, -1.364509e-001, -1.363986e-001, -1.363464e-001, -1.362942e-001, -1.362420e-001, -1.361898e-001, -1.361376e-001, -1.360854e-001, -1.360333e-001, -1.359811e-001, -1.359290e-001, -1.358768e-001, -1.358247e-001, -1.357726e-001, -1.357205e-001, -1.356684e-001, -1.356163e-001, -1.355642e-001, -1.355122e-001, -1.354601e-001, -1.354081e-001, -1.353560e-001, -1.353040e-001, -1.352520e-001, 
-1.352000e-001, -1.351480e-001, -1.350960e-001, -1.350440e-001, -1.349921e-001, -1.349401e-001, -1.348882e-001, -1.348362e-001, -1.347843e-001, -1.347324e-001, -1.346805e-001, -1.346286e-001, -1.345767e-001, -1.345248e-001, -1.344730e-001, -1.344211e-001, -1.343693e-001, -1.343174e-001, -1.342656e-001, -1.342138e-001, -1.341620e-001, -1.341102e-001, -1.340584e-001, -1.340066e-001, -1.339549e-001, -1.339031e-001, -1.338514e-001, -1.337996e-001, -1.337479e-001, -1.336962e-001, -1.336445e-001, -1.335928e-001, -1.335411e-001, -1.334894e-001, -1.334378e-001, -1.333861e-001, -1.333345e-001, -1.332828e-001, -1.332312e-001, -1.331796e-001, -1.331280e-001, -1.330764e-001, -1.330248e-001, -1.329732e-001, -1.329217e-001, -1.328701e-001, -1.328186e-001, -1.327670e-001, -1.327155e-001, -1.326640e-001, -1.326125e-001, -1.325610e-001, -1.325095e-001, -1.324580e-001, -1.324066e-001, -1.323551e-001, -1.323037e-001, -1.322522e-001, -1.322008e-001, -1.321494e-001, -1.320980e-001, -1.320466e-001, -1.319952e-001, -1.319438e-001, -1.318925e-001, -1.318411e-001, -1.317898e-001, -1.317384e-001, -1.316871e-001, -1.316358e-001, -1.315845e-001, -1.315332e-001, -1.314819e-001, -1.314306e-001, -1.313794e-001, -1.313281e-001, -1.312769e-001, -1.312256e-001, -1.311744e-001, -1.311232e-001, -1.310720e-001, -1.310208e-001, -1.309696e-001, -1.309184e-001, -1.308673e-001, -1.308161e-001, -1.307650e-001, -1.307138e-001, -1.306627e-001, -1.306116e-001, -1.305605e-001, -1.305094e-001, -1.304583e-001, -1.304072e-001, -1.303562e-001, -1.303051e-001, -1.302541e-001, -1.302030e-001, -1.301520e-001, -1.301010e-001, 
-1.300500e-001, -1.299990e-001, -1.299480e-001, -1.298970e-001, -1.298461e-001, -1.297951e-001, -1.297442e-001, -1.296932e-001, -1.296423e-001, -1.295914e-001, -1.295405e-001, -1.294896e-001, -1.294387e-001, -1.293878e-001, -1.293370e-001, -1.292861e-001, -1.292353e-001, -1.291844e-001, -1.291336e-001, -1.290828e-001, -1.290320e-001, -1.289812e-001, -1.289304e-001, -1.288796e-001, -1.288289e-001, -1.287781e-001, -1.287274e-001, -1.286766e-001, -1.286259e-001, -1.285752e-001, -1.285245e-001, -1.284738e-001, -1.284231e-001, -1.283724e-001, -1.283218e-001, -1.282711e-001, -1.282205e-001, -1.281698e-001, -1.281192e-001, -1.280686e-001, -1.280180e-001, -1.279674e-001, -1.279168e-001, -1.278662e-001, -1.278157e-001, -1.277651e-001, -1.277146e-001, -1.276640e-001, -1.276135e-001, -1.275630e-001, -1.275125e-001, -1.274620e-001, -1.274115e-001, -1.273610e-001, -1.273106e-001, -1.272601e-001, -1.272097e-001, -1.271592e-001, -1.271088e-001, -1.270584e-001, -1.270080e-001, -1.269576e-001, -1.269072e-001, -1.268568e-001, -1.268065e-001, -1.267561e-001, -1.267058e-001, -1.266554e-001, -1.266051e-001, -1.265548e-001, -1.265045e-001, -1.264542e-001, -1.264039e-001, -1.263536e-001, -1.263034e-001, -1.262531e-001, -1.262029e-001, -1.261526e-001, -1.261024e-001, -1.260522e-001, -1.260020e-001, -1.259518e-001, -1.259016e-001, -1.258514e-001, -1.258013e-001, -1.257511e-001, -1.257010e-001, -1.256508e-001, -1.256007e-001, -1.255506e-001, -1.255005e-001, -1.254504e-001, -1.254003e-001, -1.253502e-001, -1.253002e-001, -1.252501e-001, -1.252001e-001, -1.251500e-001, -1.251000e-001, -1.250500e-001, 
-1.250000e-001, -1.249500e-001, -1.249000e-001, -1.248500e-001, -1.248001e-001, -1.247501e-001, -1.247002e-001, -1.246502e-001, -1.246003e-001, -1.245504e-001, -1.245005e-001, -1.244506e-001, -1.244007e-001, -1.243508e-001, -1.243010e-001, -1.242511e-001, -1.242013e-001, -1.241514e-001, -1.241016e-001, -1.240518e-001, -1.240020e-001, -1.239522e-001, -1.239024e-001, -1.238526e-001, -1.238029e-001, -1.237531e-001, -1.237034e-001, -1.236536e-001, -1.236039e-001, -1.235542e-001, -1.235045e-001, -1.234548e-001, -1.234051e-001, -1.233554e-001, -1.233058e-001, -1.232561e-001, -1.232065e-001, -1.231568e-001, -1.231072e-001, -1.230576e-001, -1.230080e-001, -1.229584e-001, -1.229088e-001, -1.228592e-001, -1.228097e-001, -1.227601e-001, -1.227106e-001, -1.226610e-001, -1.226115e-001, -1.225620e-001, -1.225125e-001, -1.224630e-001, -1.224135e-001, -1.223640e-001, -1.223146e-001, -1.222651e-001, -1.222157e-001, -1.221662e-001, -1.221168e-001, -1.220674e-001, -1.220180e-001, -1.219686e-001, -1.219192e-001, -1.218698e-001, -1.218205e-001, -1.217711e-001, -1.217218e-001, -1.216724e-001, -1.216231e-001, -1.215738e-001, -1.215245e-001, -1.214752e-001, -1.214259e-001, -1.213766e-001, -1.213274e-001, -1.212781e-001, -1.212289e-001, -1.211796e-001, -1.211304e-001, -1.210812e-001, -1.210320e-001, -1.209828e-001, -1.209336e-001, -1.208844e-001, -1.208353e-001, -1.207861e-001, -1.207370e-001, -1.206878e-001, -1.206387e-001, -1.205896e-001, -1.205405e-001, -1.204914e-001, -1.204423e-001, -1.203932e-001, -1.203442e-001, -1.202951e-001, -1.202461e-001, -1.201970e-001, -1.201480e-001, -1.200990e-001, 
-1.200500e-001, -1.200010e-001, -1.199520e-001, -1.199030e-001, -1.198541e-001, -1.198051e-001, -1.197562e-001, -1.197072e-001, -1.196583e-001, -1.196094e-001, -1.195605e-001, -1.195116e-001, -1.194627e-001, -1.194138e-001, -1.193650e-001, -1.193161e-001, -1.192673e-001, -1.192184e-001, -1.191696e-001, -1.191208e-001, -1.190720e-001, -1.190232e-001, -1.189744e-001, -1.189256e-001, -1.188769e-001, -1.188281e-001, -1.187794e-001, -1.187306e-001, -1.186819e-001, -1.186332e-001, -1.185845e-001, -1.185358e-001, -1.184871e-001, -1.184384e-001, -1.183898e-001, -1.183411e-001, -1.182925e-001, -1.182438e-001, -1.181952e-001, -1.181466e-001, -1.180980e-001, -1.180494e-001, -1.180008e-001, -1.179522e-001, -1.179037e-001, -1.178551e-001, -1.178066e-001, -1.177580e-001, -1.177095e-001, -1.176610e-001, -1.176125e-001, -1.175640e-001, -1.175155e-001, -1.174670e-001, -1.174186e-001, -1.173701e-001, -1.173217e-001, -1.172732e-001, -1.172248e-001, -1.171764e-001, -1.171280e-001, -1.170796e-001, -1.170312e-001, -1.169828e-001, -1.169345e-001, -1.168861e-001, -1.168378e-001, -1.167894e-001, -1.167411e-001, -1.166928e-001, -1.166445e-001, -1.165962e-001, -1.165479e-001, -1.164996e-001, -1.164514e-001, -1.164031e-001, -1.163549e-001, -1.163066e-001, -1.162584e-001, -1.162102e-001, -1.161620e-001, -1.161138e-001, -1.160656e-001, -1.160174e-001, -1.159693e-001, -1.159211e-001, -1.158730e-001, -1.158248e-001, -1.157767e-001, -1.157286e-001, -1.156805e-001, -1.156324e-001, -1.155843e-001, -1.155362e-001, -1.154882e-001, -1.154401e-001, -1.153921e-001, -1.153440e-001, -1.152960e-001, -1.152480e-001, 
-1.152000e-001, -1.151520e-001, -1.151040e-001, -1.150560e-001, -1.150081e-001, -1.149601e-001, -1.149122e-001, -1.148642e-001, -1.148163e-001, -1.147684e-001, -1.147205e-001, -1.146726e-001, -1.146247e-001, -1.145768e-001, -1.145290e-001, -1.144811e-001, -1.144333e-001, -1.143854e-001, -1.143376e-001, -1.142898e-001, -1.142420e-001, -1.141942e-001, -1.141464e-001, -1.140986e-001, -1.140509e-001, -1.140031e-001, -1.139554e-001, -1.139076e-001, -1.138599e-001, -1.138122e-001, -1.137645e-001, -1.137168e-001, -1.136691e-001, -1.136214e-001, -1.135738e-001, -1.135261e-001, -1.134785e-001, -1.134308e-001, -1.133832e-001, -1.133356e-001, -1.132880e-001, -1.132404e-001, -1.131928e-001, -1.131452e-001, -1.130977e-001, -1.130501e-001, -1.130026e-001, -1.129550e-001, -1.129075e-001, -1.128600e-001, -1.128125e-001, -1.127650e-001, -1.127175e-001, -1.126700e-001, -1.126226e-001, -1.125751e-001, -1.125277e-001, -1.124802e-001, -1.124328e-001, -1.123854e-001, -1.123380e-001, -1.122906e-001, -1.122432e-001, -1.121958e-001, -1.121485e-001, -1.121011e-001, -1.120538e-001, -1.120064e-001, -1.119591e-001, -1.119118e-001, -1.118645e-001, -1.118172e-001, -1.117699e-001, -1.117226e-001, -1.116754e-001, -1.116281e-001, -1.115809e-001, -1.115336e-001, -1.114864e-001, -1.114392e-001, -1.113920e-001, -1.113448e-001, -1.112976e-001, -1.112504e-001, -1.112033e-001, -1.111561e-001, -1.111090e-001, -1.110618e-001, -1.110147e-001, -1.109676e-001, -1.109205e-001, -1.108734e-001, -1.108263e-001, -1.107792e-001, -1.107322e-001, -1.106851e-001, -1.106381e-001, -1.105910e-001, -1.105440e-001, -1.104970e-001, 
-1.104500e-001, -1.104030e-001, -1.103560e-001, -1.103090e-001, -1.102621e-001, -1.102151e-001, -1.101682e-001, -1.101212e-001, -1.100743e-001, -1.100274e-001, -1.099805e-001, -1.099336e-001, -1.098867e-001, -1.098398e-001, -1.097930e-001, -1.097461e-001, -1.096993e-001, -1.096524e-001, -1.096056e-001, -1.095588e-001, -1.095120e-001, -1.094652e-001, -1.094184e-001, -1.093716e-001, -1.093249e-001, -1.092781e-001, -1.092314e-001, -1.091846e-001, -1.091379e-001, -1.090912e-001, -1.090445e-001, -1.089978e-001, -1.089511e-001, -1.089044e-001, -1.088578e-001, -1.088111e-001, -1.087645e-001, -1.087178e-001, -1.086712e-001, -1.086246e-001, -1.085780e-001, -1.085314e-001, -1.084848e-001, -1.084382e-001, -1.083917e-001, -1.083451e-001, -1.082986e-001, -1.082520e-001, -1.082055e-001, -1.081590e-001, -1.081125e-001, -1.080660e-001, -1.080195e-001, -1.079730e-001, -1.079266e-001, -1.078801e-001, -1.078337e-001, -1.077872e-001, -1.077408e-001, -1.076944e-001, -1.076480e-001, -1.076016e-001, -1.075552e-001, -1.075088e-001, -1.074625e-001, -1.074161e-001, -1.073698e-001, -1.073234e-001, -1.072771e-001, -1.072308e-001, -1.071845e-001, -1.071382e-001, -1.070919e-001, -1.070456e-001, -1.069994e-001, -1.069531e-001, -1.069069e-001, -1.068606e-001, -1.068144e-001, -1.067682e-001, -1.067220e-001, -1.066758e-001, -1.066296e-001, -1.065834e-001, -1.065373e-001, -1.064911e-001, -1.064450e-001, -1.063988e-001, -1.063527e-001, -1.063066e-001, -1.062605e-001, -1.062144e-001, -1.061683e-001, -1.061222e-001, -1.060762e-001, -1.060301e-001, -1.059841e-001, -1.059380e-001, -1.058920e-001, -1.058460e-001, 
-1.058000e-001, -1.057540e-001, -1.057080e-001, -1.056620e-001, -1.056161e-001, -1.055701e-001, -1.055242e-001, -1.054782e-001, -1.054323e-001, -1.053864e-001, -1.053405e-001, -1.052946e-001, -1.052487e-001, -1.052028e-001, -1.051570e-001, -1.051111e-001, -1.050653e-001, -1.050194e-001, -1.049736e-001, -1.049278e-001, -1.048820e-001, -1.048362e-001, -1.047904e-001, -1.047446e-001, -1.046989e-001, -1.046531e-001, -1.046074e-001, -1.045616e-001, -1.045159e-001, -1.044702e-001, -1.044245e-001, -1.043788e-001, -1.043331e-001, -1.042874e-001, -1.042418e-001, -1.041961e-001, -1.041505e-001, -1.041048e-001, -1.040592e-001, -1.040136e-001, -1.039680e-001, -1.039224e-001, -1.038768e-001, -1.038312e-001, -1.037857e-001, -1.037401e-001, -1.036946e-001, -1.036490e-001, -1.036035e-001, -1.035580e-001, -1.035125e-001, -1.034670e-001, -1.034215e-001, -1.033760e-001, -1.033306e-001, -1.032851e-001, -1.032397e-001, -1.031942e-001, -1.031488e-001, -1.031034e-001, -1.030580e-001, -1.030126e-001, -1.029672e-001, -1.029218e-001, -1.028765e-001, -1.028311e-001, -1.027858e-001, -1.027404e-001, -1.026951e-001, -1.026498e-001, -1.026045e-001, -1.025592e-001, -1.025139e-001, -1.024686e-001, -1.024234e-001, -1.023781e-001, -1.023329e-001, -1.022876e-001, -1.022424e-001, -1.021972e-001, -1.021520e-001, -1.021068e-001, -1.020616e-001, -1.020164e-001, -1.019713e-001, -1.019261e-001, -1.018810e-001, -1.018358e-001, -1.017907e-001, -1.017456e-001, -1.017005e-001, -1.016554e-001, -1.016103e-001, -1.015652e-001, -1.015202e-001, -1.014751e-001, -1.014301e-001, -1.013850e-001, -1.013400e-001, -1.012950e-001, 
-1.012500e-001, -1.012050e-001, -1.011600e-001, -1.011150e-001, -1.010701e-001, -1.010251e-001, -1.009802e-001, -1.009352e-001, -1.008903e-001, -1.008454e-001, -1.008005e-001, -1.007556e-001, -1.007107e-001, -1.006658e-001, -1.006210e-001, -1.005761e-001, -1.005313e-001, -1.004864e-001, -1.004416e-001, -1.003968e-001, -1.003520e-001, -1.003072e-001, -1.002624e-001, -1.002176e-001, -1.001729e-001, -1.001281e-001, -1.000834e-001, -1.000386e-001, -9.999392e-002, -9.994921e-002, -9.990450e-002, -9.985980e-002, -9.981512e-002, -9.977044e-002, -9.972578e-002, -9.968113e-002, -9.963648e-002, -9.959185e-002, -9.954722e-002, -9.950261e-002, -9.945800e-002, -9.941340e-002, -9.936882e-002, -9.932424e-002, -9.927968e-002, -9.923513e-002, -9.919058e-002, -9.914605e-002, -9.910152e-002, -9.905701e-002, -9.901250e-002, -9.896800e-002, -9.892352e-002, -9.887904e-002, -9.883458e-002, -9.879013e-002, -9.874568e-002, -9.870125e-002, -9.865682e-002, -9.861241e-002, -9.856800e-002, -9.852360e-002, -9.847922e-002, -9.843484e-002, -9.839048e-002, -9.834613e-002, -9.830178e-002, -9.825745e-002, -9.821312e-002, -9.816881e-002, -9.812450e-002, -9.808020e-002, -9.803592e-002, -9.799164e-002, -9.794738e-002, -9.790313e-002, -9.785888e-002, -9.781465e-002, -9.777042e-002, -9.772621e-002, -9.768200e-002, -9.763780e-002, -9.759362e-002, -9.754944e-002, -9.750528e-002, -9.746112e-002, -9.741698e-002, -9.737285e-002, -9.732872e-002, -9.728461e-002, -9.724050e-002, -9.719640e-002, -9.715232e-002, -9.710824e-002, -9.706418e-002, -9.702012e-002, -9.697608e-002, -9.693205e-002, -9.688802e-002, -9.684401e-002, 
-9.680000e-002, -9.675600e-002, -9.671202e-002, -9.666804e-002, -9.662408e-002, -9.658013e-002, -9.653618e-002, -9.649225e-002, -9.644832e-002, -9.640441e-002, -9.636050e-002, -9.631660e-002, -9.627272e-002, -9.622884e-002, -9.618498e-002, -9.614112e-002, -9.609728e-002, -9.605345e-002, -9.600962e-002, -9.596581e-002, -9.592200e-002, -9.587820e-002, -9.583442e-002, -9.579064e-002, -9.574688e-002, -9.570313e-002, -9.565938e-002, -9.561565e-002, -9.557192e-002, -9.552821e-002, -9.548450e-002, -9.544080e-002, -9.539712e-002, -9.535344e-002, -9.530978e-002, -9.526612e-002, -9.522248e-002, -9.517885e-002, -9.513522e-002, -9.509161e-002, -9.504800e-002, -9.500440e-002, -9.496082e-002, -9.491724e-002, -9.487368e-002, -9.483013e-002, -9.478658e-002, -9.474305e-002, -9.469952e-002, -9.465601e-002, -9.461250e-002, -9.456900e-002, -9.452552e-002, -9.448204e-002, -9.443858e-002, -9.439512e-002, -9.435168e-002, -9.430825e-002, -9.426482e-002, -9.422141e-002, -9.417800e-002, -9.413460e-002, -9.409122e-002, -9.404784e-002, -9.400448e-002, -9.396112e-002, -9.391778e-002, -9.387445e-002, -9.383112e-002, -9.378781e-002, -9.374450e-002, -9.370120e-002, -9.365792e-002, -9.361464e-002, -9.357138e-002, -9.352813e-002, -9.348488e-002, -9.344165e-002, -9.339842e-002, -9.335521e-002, -9.331200e-002, -9.326880e-002, -9.322562e-002, -9.318244e-002, -9.313928e-002, -9.309613e-002, -9.305298e-002, -9.300985e-002, -9.296672e-002, -9.292361e-002, -9.288050e-002, -9.283740e-002, -9.279432e-002, -9.275124e-002, -9.270818e-002, -9.266513e-002, -9.262208e-002, -9.257905e-002, -9.253602e-002, -9.249301e-002, 
-9.245000e-002, -9.240700e-002, -9.236402e-002, -9.232104e-002, -9.227808e-002, -9.223513e-002, -9.219218e-002, -9.214925e-002, -9.210632e-002, -9.206341e-002, -9.202050e-002, -9.197760e-002, -9.193472e-002, -9.189184e-002, -9.184898e-002, -9.180613e-002, -9.176328e-002, -9.172045e-002, -9.167762e-002, -9.163481e-002, -9.159200e-002, -9.154920e-002, -9.150642e-002, -9.146364e-002, -9.142088e-002, -9.137812e-002, -9.133538e-002, -9.129265e-002, -9.124992e-002, -9.120721e-002, -9.116450e-002, -9.112180e-002, -9.107912e-002, -9.103644e-002, -9.099378e-002, -9.095112e-002, -9.090848e-002, -9.086585e-002, -9.082322e-002, -9.078061e-002, -9.073800e-002, -9.069540e-002, -9.065282e-002, -9.061024e-002, -9.056768e-002, -9.052512e-002, -9.048258e-002, -9.044005e-002, -9.039752e-002, -9.035501e-002, -9.031250e-002, -9.027001e-002, -9.022752e-002, -9.018504e-002, -9.014258e-002, -9.010012e-002, -9.005768e-002, -9.001525e-002, -8.997282e-002, -8.993041e-002, -8.988800e-002, -8.984561e-002, -8.980322e-002, -8.976084e-002, -8.971848e-002, -8.967612e-002, -8.963378e-002, -8.959145e-002, -8.954912e-002, -8.950681e-002, -8.946450e-002, -8.942221e-002, -8.937992e-002, -8.933764e-002, -8.929538e-002, -8.925312e-002, -8.921088e-002, -8.916865e-002, -8.912642e-002, -8.908421e-002, -8.904200e-002, -8.899981e-002, -8.895762e-002, -8.891544e-002, -8.887328e-002, -8.883112e-002, -8.878898e-002, -8.874685e-002, -8.870472e-002, -8.866261e-002, -8.862050e-002, -8.857841e-002, -8.853632e-002, -8.849424e-002, -8.845218e-002, -8.841012e-002, -8.836808e-002, -8.832605e-002, -8.828402e-002, -8.824201e-002, 
-8.820000e-002, -8.815801e-002, -8.811602e-002, -8.807404e-002, -8.803208e-002, -8.799012e-002, -8.794818e-002, -8.790625e-002, -8.786432e-002, -8.782241e-002, -8.778050e-002, -8.773861e-002, -8.769672e-002, -8.765484e-002, -8.761298e-002, -8.757113e-002, -8.752928e-002, -8.748744e-002, -8.744562e-002, -8.740381e-002, -8.736200e-002, -8.732021e-002, -8.727842e-002, -8.723664e-002, -8.719488e-002, -8.715312e-002, -8.711138e-002, -8.706965e-002, -8.702792e-002, -8.698621e-002, -8.694450e-002, -8.690281e-002, -8.686112e-002, -8.681944e-002, -8.677778e-002, -8.673612e-002, -8.669448e-002, -8.665285e-002, -8.661122e-002, -8.656961e-002, -8.652800e-002, -8.648641e-002, -8.644482e-002, -8.640324e-002, -8.636168e-002, -8.632012e-002, -8.627858e-002, -8.623704e-002, -8.619552e-002, -8.615401e-002, -8.611250e-002, -8.607101e-002, -8.602952e-002, -8.598804e-002, -8.594658e-002, -8.590512e-002, -8.586368e-002, -8.582225e-002, -8.578082e-002, -8.573941e-002, -8.569800e-002, -8.565661e-002, -8.561522e-002, -8.557384e-002, -8.553248e-002, -8.549112e-002, -8.544978e-002, -8.540845e-002, -8.536712e-002, -8.532581e-002, -8.528450e-002, -8.524321e-002, -8.520192e-002, -8.516064e-002, -8.511938e-002, -8.507812e-002, -8.503688e-002, -8.499564e-002, -8.495442e-002, -8.491321e-002, -8.487200e-002, -8.483081e-002, -8.478962e-002, -8.474844e-002, -8.470728e-002, -8.466612e-002, -8.462498e-002, -8.458385e-002, -8.454272e-002, -8.450161e-002, -8.446050e-002, -8.441941e-002, -8.437832e-002, -8.433724e-002, -8.429618e-002, -8.425512e-002, -8.421408e-002, -8.417305e-002, -8.413202e-002, -8.409101e-002, 
-8.405000e-002, -8.400901e-002, -8.396802e-002, -8.392704e-002, -8.388608e-002, -8.384512e-002, -8.380418e-002, -8.376325e-002, -8.372232e-002, -8.368141e-002, -8.364050e-002, -8.359961e-002, -8.355872e-002, -8.351784e-002, -8.347698e-002, -8.343612e-002, -8.339528e-002, -8.335444e-002, -8.331362e-002, -8.327281e-002, -8.323200e-002, -8.319121e-002, -8.315042e-002, -8.310964e-002, -8.306888e-002, -8.302812e-002, -8.298738e-002, -8.294664e-002, -8.290592e-002, -8.286521e-002, -8.282450e-002, -8.278381e-002, -8.274312e-002, -8.270244e-002, -8.266178e-002, -8.262112e-002, -8.258048e-002, -8.253985e-002, -8.249922e-002, -8.245861e-002, -8.241800e-002, -8.237741e-002, -8.233682e-002, -8.229624e-002, -8.225568e-002, -8.221512e-002, -8.217458e-002, -8.213405e-002, -8.209352e-002, -8.205301e-002, -8.201250e-002, -8.197201e-002, -8.193152e-002, -8.189104e-002, -8.185058e-002, -8.181012e-002, -8.176968e-002, -8.172924e-002, -8.168882e-002, -8.164841e-002, -8.160800e-002, -8.156761e-002, -8.152722e-002, -8.148684e-002, -8.144648e-002, -8.140612e-002, -8.136578e-002, -8.132544e-002, -8.128512e-002, -8.124481e-002, -8.120450e-002, -8.116421e-002, -8.112392e-002, -8.108364e-002, -8.104338e-002, -8.100312e-002, -8.096288e-002, -8.092265e-002, -8.088242e-002, -8.084221e-002, -8.080200e-002, -8.076181e-002, -8.072162e-002, -8.068144e-002, -8.064128e-002, -8.060112e-002, -8.056098e-002, -8.052084e-002, -8.048072e-002, -8.044060e-002, -8.040050e-002, -8.036041e-002, -8.032032e-002, -8.028024e-002, -8.024018e-002, -8.020012e-002, -8.016008e-002, -8.012005e-002, -8.008002e-002, -8.004001e-002, 
-8.000000e-002, -7.996001e-002, -7.992002e-002, -7.988005e-002, -7.984008e-002, -7.980012e-002, -7.976018e-002, -7.972024e-002, -7.968032e-002, -7.964040e-002, -7.960050e-002, -7.956061e-002, -7.952072e-002, -7.948085e-002, -7.944098e-002, -7.940112e-002, -7.936128e-002, -7.932144e-002, -7.928162e-002, -7.924180e-002, -7.920200e-002, -7.916221e-002, -7.912242e-002, -7.908265e-002, -7.904288e-002, -7.900312e-002, -7.896338e-002, -7.892365e-002, -7.888392e-002, -7.884421e-002, -7.880450e-002, -7.876481e-002, -7.872512e-002, -7.868545e-002, -7.864578e-002, -7.860612e-002, -7.856648e-002, -7.852684e-002, -7.848722e-002, -7.844761e-002, -7.840800e-002, -7.836841e-002, -7.832882e-002, -7.828925e-002, -7.824968e-002, -7.821012e-002, -7.817058e-002, -7.813104e-002, -7.809152e-002, -7.805201e-002, -7.801250e-002, -7.797301e-002, -7.793352e-002, -7.789405e-002, -7.785458e-002, -7.781512e-002, -7.777568e-002, -7.773624e-002, -7.769682e-002, -7.765740e-002, -7.761800e-002, -7.757861e-002, -7.753922e-002, -7.749985e-002, -7.746048e-002, -7.742112e-002, -7.738178e-002, -7.734244e-002, -7.730312e-002, -7.726381e-002, -7.722450e-002, -7.718521e-002, -7.714592e-002, -7.710665e-002, -7.706738e-002, -7.702812e-002, -7.698888e-002, -7.694964e-002, -7.691042e-002, -7.687120e-002, -7.683200e-002, -7.679281e-002, -7.675362e-002, -7.671445e-002, -7.667528e-002, -7.663612e-002, -7.659698e-002, -7.655784e-002, -7.651872e-002, -7.647961e-002, -7.644050e-002, -7.640141e-002, -7.636232e-002, -7.632325e-002, -7.628418e-002, -7.624512e-002, -7.620608e-002, -7.616704e-002, -7.612802e-002, -7.608901e-002, 
-7.605000e-002, -7.601101e-002, -7.597202e-002, -7.593305e-002, -7.589408e-002, -7.585512e-002, -7.581618e-002, -7.577724e-002, -7.573832e-002, -7.569940e-002, -7.566050e-002, -7.562161e-002, -7.558272e-002, -7.554385e-002, -7.550498e-002, -7.546612e-002, -7.542728e-002, -7.538844e-002, -7.534962e-002, -7.531080e-002, -7.527200e-002, -7.523321e-002, -7.519442e-002, -7.515565e-002, -7.511688e-002, -7.507812e-002, -7.503938e-002, -7.500064e-002, -7.496192e-002, -7.492321e-002, -7.488450e-002, -7.484581e-002, -7.480712e-002, -7.476845e-002, -7.472978e-002, -7.469112e-002, -7.465248e-002, -7.461384e-002, -7.457522e-002, -7.453661e-002, -7.449800e-002, -7.445941e-002, -7.442082e-002, -7.438225e-002, -7.434368e-002, -7.430512e-002, -7.426658e-002, -7.422804e-002, -7.418952e-002, -7.415101e-002, -7.411250e-002, -7.407401e-002, -7.403552e-002, -7.399705e-002, -7.395858e-002, -7.392012e-002, -7.388168e-002, -7.384324e-002, -7.380482e-002, -7.376640e-002, -7.372800e-002, -7.368961e-002, -7.365122e-002, -7.361285e-002, -7.357448e-002, -7.353612e-002, -7.349778e-002, -7.345944e-002, -7.342112e-002, -7.338280e-002, -7.334450e-002, -7.330621e-002, -7.326792e-002, -7.322965e-002, -7.319138e-002, -7.315312e-002, -7.311488e-002, -7.307664e-002, -7.303842e-002, -7.300020e-002, -7.296200e-002, -7.292381e-002, -7.288562e-002, -7.284745e-002, -7.280928e-002, -7.277112e-002, -7.273298e-002, -7.269484e-002, -7.265672e-002, -7.261861e-002, -7.258050e-002, -7.254241e-002, -7.250432e-002, -7.246625e-002, -7.242818e-002, -7.239012e-002, -7.235208e-002, -7.231404e-002, -7.227602e-002, -7.223800e-002, 
-7.220000e-002, -7.216201e-002, -7.212402e-002, -7.208605e-002, -7.204808e-002, -7.201012e-002, -7.197218e-002, -7.193424e-002, -7.189632e-002, -7.185841e-002, -7.182050e-002, -7.178260e-002, -7.174472e-002, -7.170685e-002, -7.166898e-002, -7.163112e-002, -7.159328e-002, -7.155544e-002, -7.151762e-002, -7.147980e-002, -7.144200e-002, -7.140420e-002, -7.136642e-002, -7.132865e-002, -7.129088e-002, -7.125312e-002, -7.121538e-002, -7.117764e-002, -7.113992e-002, -7.110221e-002, -7.106450e-002, -7.102680e-002, -7.098912e-002, -7.095145e-002, -7.091378e-002, -7.087612e-002, -7.083848e-002, -7.080084e-002, -7.076322e-002, -7.072560e-002, -7.068800e-002, -7.065040e-002, -7.061282e-002, -7.057525e-002, -7.053768e-002, -7.050012e-002, -7.046258e-002, -7.042504e-002, -7.038752e-002, -7.035000e-002, -7.031250e-002, -7.027501e-002, -7.023752e-002, -7.020005e-002, -7.016258e-002, -7.012513e-002, -7.008768e-002, -7.005024e-002, -7.001282e-002, -6.997540e-002, -6.993800e-002, -6.990061e-002, -6.986322e-002, -6.982585e-002, -6.978848e-002, -6.975113e-002, -6.971378e-002, -6.967644e-002, -6.963912e-002, -6.960180e-002, -6.956450e-002, -6.952721e-002, -6.948992e-002, -6.945265e-002, -6.941538e-002, -6.937813e-002, -6.934088e-002, -6.930364e-002, -6.926642e-002, -6.922920e-002, -6.919200e-002, -6.915481e-002, -6.911762e-002, -6.908045e-002, -6.904328e-002, -6.900613e-002, -6.896898e-002, -6.893184e-002, -6.889472e-002, -6.885760e-002, -6.882050e-002, -6.878341e-002, -6.874632e-002, -6.870925e-002, -6.867218e-002, -6.863513e-002, -6.859808e-002, -6.856104e-002, -6.852402e-002, -6.848700e-002, 
-6.845000e-002, -6.841300e-002, -6.837602e-002, -6.833905e-002, -6.830208e-002, -6.826513e-002, -6.822818e-002, -6.819124e-002, -6.815432e-002, -6.811740e-002, -6.808050e-002, -6.804361e-002, -6.800672e-002, -6.796985e-002, -6.793298e-002, -6.789613e-002, -6.785928e-002, -6.782244e-002, -6.778562e-002, -6.774880e-002, -6.771200e-002, -6.767521e-002, -6.763842e-002, -6.760165e-002, -6.756488e-002, -6.752813e-002, -6.749138e-002, -6.745464e-002, -6.741792e-002, -6.738121e-002, -6.734450e-002, -6.730780e-002, -6.727112e-002, -6.723445e-002, -6.719778e-002, -6.716113e-002, -6.712448e-002, -6.708784e-002, -6.705122e-002, -6.701460e-002, -6.697800e-002, -6.694140e-002, -6.690482e-002, -6.686825e-002, -6.683168e-002, -6.679513e-002, -6.675858e-002, -6.672204e-002, -6.668552e-002, -6.664900e-002, -6.661250e-002, -6.657601e-002, -6.653952e-002, -6.650305e-002, -6.646658e-002, -6.643013e-002, -6.639368e-002, -6.635724e-002, -6.632082e-002, -6.628440e-002, -6.624800e-002, -6.621161e-002, -6.617522e-002, -6.613885e-002, -6.610248e-002, -6.606613e-002, -6.602978e-002, -6.599344e-002, -6.595712e-002, -6.592080e-002, -6.588450e-002, -6.584821e-002, -6.581192e-002, -6.577565e-002, -6.573938e-002, -6.570313e-002, -6.566688e-002, -6.563064e-002, -6.559442e-002, -6.555820e-002, -6.552200e-002, -6.548580e-002, -6.544962e-002, -6.541345e-002, -6.537728e-002, -6.534113e-002, -6.530498e-002, -6.526884e-002, -6.523272e-002, -6.519660e-002, -6.516050e-002, -6.512440e-002, -6.508832e-002, -6.505225e-002, -6.501618e-002, -6.498013e-002, -6.494408e-002, -6.490804e-002, -6.487202e-002, -6.483600e-002, 
-6.480000e-002, -6.476400e-002, -6.472802e-002, -6.469205e-002, -6.465608e-002, -6.462013e-002, -6.458418e-002, -6.454824e-002, -6.451232e-002, -6.447640e-002, -6.444050e-002, -6.440461e-002, -6.436872e-002, -6.433285e-002, -6.429698e-002, -6.426113e-002, -6.422528e-002, -6.418944e-002, -6.415362e-002, -6.411780e-002, -6.408200e-002, -6.404620e-002, -6.401042e-002, -6.397465e-002, -6.393888e-002, -6.390313e-002, -6.386738e-002, -6.383164e-002, -6.379592e-002, -6.376020e-002, -6.372450e-002, -6.368881e-002, -6.365312e-002, -6.361745e-002, -6.358178e-002, -6.354613e-002, -6.351048e-002, -6.347484e-002, -6.343922e-002, -6.340360e-002, -6.336800e-002, -6.333240e-002, -6.329682e-002, -6.326125e-002, -6.322568e-002, -6.319013e-002, -6.315458e-002, -6.311904e-002, -6.308352e-002, -6.304800e-002, -6.301250e-002, -6.297701e-002, -6.294152e-002, -6.290605e-002, -6.287058e-002, -6.283513e-002, -6.279968e-002, -6.276424e-002, -6.272882e-002, -6.269340e-002, -6.265800e-002, -6.262260e-002, -6.258722e-002, -6.255185e-002, -6.251648e-002, -6.248113e-002, -6.244578e-002, -6.241044e-002, -6.237512e-002, -6.233980e-002, -6.230450e-002, -6.226920e-002, -6.223392e-002, -6.219865e-002, -6.216338e-002, -6.212813e-002, -6.209288e-002, -6.205764e-002, -6.202242e-002, -6.198720e-002, -6.195200e-002, -6.191680e-002, -6.188162e-002, -6.184645e-002, -6.181128e-002, -6.177613e-002, -6.174098e-002, -6.170584e-002, -6.167072e-002, -6.163560e-002, -6.160050e-002, -6.156540e-002, -6.153032e-002, -6.149525e-002, -6.146018e-002, -6.142513e-002, -6.139008e-002, -6.135504e-002, -6.132002e-002, -6.128500e-002, 
-6.125000e-002, -6.121500e-002, -6.118002e-002, -6.114505e-002, -6.111008e-002, -6.107513e-002, -6.104018e-002, -6.100525e-002, -6.097032e-002, -6.093540e-002, -6.090050e-002, -6.086560e-002, -6.083072e-002, -6.079585e-002, -6.076098e-002, -6.072613e-002, -6.069128e-002, -6.065645e-002, -6.062162e-002, -6.058680e-002, -6.055200e-002, -6.051720e-002, -6.048242e-002, -6.044765e-002, -6.041288e-002, -6.037813e-002, -6.034338e-002, -6.030865e-002, -6.027392e-002, -6.023920e-002, -6.020450e-002, -6.016980e-002, -6.013512e-002, -6.010045e-002, -6.006578e-002, -6.003113e-002, -5.999648e-002, -5.996185e-002, -5.992722e-002, -5.989260e-002, -5.985800e-002, -5.982340e-002, -5.978882e-002, -5.975425e-002, -5.971968e-002, -5.968513e-002, -5.965058e-002, -5.961605e-002, -5.958152e-002, -5.954700e-002, -5.951250e-002, -5.947800e-002, -5.944352e-002, -5.940905e-002, -5.937458e-002, -5.934013e-002, -5.930568e-002, -5.927125e-002, -5.923682e-002, -5.920240e-002, -5.916800e-002, -5.913360e-002, -5.909922e-002, -5.906485e-002, -5.903048e-002, -5.899613e-002, -5.896178e-002, -5.892745e-002, -5.889312e-002, -5.885880e-002, -5.882450e-002, -5.879020e-002, -5.875592e-002, -5.872165e-002, -5.868738e-002, -5.865313e-002, -5.861888e-002, -5.858465e-002, -5.855042e-002, -5.851620e-002, -5.848200e-002, -5.844780e-002, -5.841362e-002, -5.837945e-002, -5.834528e-002, -5.831113e-002, -5.827698e-002, -5.824285e-002, -5.820872e-002, -5.817460e-002, -5.814050e-002, -5.810640e-002, -5.807232e-002, -5.803825e-002, -5.800418e-002, -5.797013e-002, -5.793608e-002, -5.790205e-002, -5.786802e-002, -5.783400e-002, 
-5.780000e-002, -5.776600e-002, -5.773202e-002, -5.769805e-002, -5.766408e-002, -5.763013e-002, -5.759618e-002, -5.756225e-002, -5.752832e-002, -5.749440e-002, -5.746050e-002, -5.742660e-002, -5.739272e-002, -5.735884e-002, -5.732498e-002, -5.729113e-002, -5.725728e-002, -5.722345e-002, -5.718962e-002, -5.715580e-002, -5.712200e-002, -5.708820e-002, -5.705442e-002, -5.702065e-002, -5.698688e-002, -5.695313e-002, -5.691938e-002, -5.688565e-002, -5.685192e-002, -5.681820e-002, -5.678450e-002, -5.675080e-002, -5.671712e-002, -5.668344e-002, -5.664978e-002, -5.661613e-002, -5.658248e-002, -5.654885e-002, -5.651522e-002, -5.648160e-002, -5.644800e-002, -5.641440e-002, -5.638082e-002, -5.634724e-002, -5.631368e-002, -5.628013e-002, -5.624658e-002, -5.621305e-002, -5.617952e-002, -5.614600e-002, -5.611250e-002, -5.607900e-002, -5.604552e-002, -5.601204e-002, -5.597858e-002, -5.594513e-002, -5.591168e-002, -5.587825e-002, -5.584482e-002, -5.581140e-002, -5.577800e-002, -5.574460e-002, -5.571122e-002, -5.567784e-002, -5.564448e-002, -5.561113e-002, -5.557778e-002, -5.554445e-002, -5.551112e-002, -5.547780e-002, -5.544450e-002, -5.541120e-002, -5.537792e-002, -5.534464e-002, -5.531138e-002, -5.527813e-002, -5.524488e-002, -5.521165e-002, -5.517842e-002, -5.514520e-002, -5.511200e-002, -5.507880e-002, -5.504562e-002, -5.501245e-002, -5.497928e-002, -5.494613e-002, -5.491298e-002, -5.487985e-002, -5.484672e-002, -5.481360e-002, -5.478050e-002, -5.474740e-002, -5.471432e-002, -5.468124e-002, -5.464818e-002, -5.461513e-002, -5.458208e-002, -5.454905e-002, -5.451602e-002, -5.448300e-002, 
-5.445000e-002, -5.441700e-002, -5.438402e-002, -5.435105e-002, -5.431808e-002, -5.428513e-002, -5.425218e-002, -5.421925e-002, -5.418632e-002, -5.415340e-002, -5.412050e-002, -5.408760e-002, -5.405472e-002, -5.402184e-002, -5.398898e-002, -5.395613e-002, -5.392328e-002, -5.389045e-002, -5.385762e-002, -5.382480e-002, -5.379200e-002, -5.375920e-002, -5.372642e-002, -5.369364e-002, -5.366088e-002, -5.362813e-002, -5.359538e-002, -5.356265e-002, -5.352992e-002, -5.349720e-002, -5.346450e-002, -5.343180e-002, -5.339912e-002, -5.336644e-002, -5.333378e-002, -5.330113e-002, -5.326848e-002, -5.323585e-002, -5.320322e-002, -5.317060e-002, -5.313800e-002, -5.310540e-002, -5.307282e-002, -5.304025e-002, -5.300768e-002, -5.297513e-002, -5.294258e-002, -5.291005e-002, -5.287752e-002, -5.284500e-002, -5.281250e-002, -5.278000e-002, -5.274752e-002, -5.271504e-002, -5.268258e-002, -5.265013e-002, -5.261768e-002, -5.258525e-002, -5.255282e-002, -5.252041e-002, -5.248800e-002, -5.245560e-002, -5.242322e-002, -5.239084e-002, -5.235848e-002, -5.232613e-002, -5.229378e-002, -5.226145e-002, -5.222912e-002, -5.219681e-002, -5.216450e-002, -5.213220e-002, -5.209992e-002, -5.206764e-002, -5.203538e-002, -5.200313e-002, -5.197088e-002, -5.193865e-002, -5.190642e-002, -5.187421e-002, -5.184200e-002, -5.180980e-002, -5.177762e-002, -5.174544e-002, -5.171328e-002, -5.168113e-002, -5.164898e-002, -5.161685e-002, -5.158472e-002, -5.155261e-002, -5.152050e-002, -5.148840e-002, -5.145632e-002, -5.142424e-002, -5.139218e-002, -5.136013e-002, -5.132808e-002, -5.129605e-002, -5.126402e-002, -5.123201e-002, 
-5.120000e-002, -5.116800e-002, -5.113602e-002, -5.110404e-002, -5.107208e-002, -5.104012e-002, -5.100818e-002, -5.097625e-002, -5.094432e-002, -5.091241e-002, -5.088050e-002, -5.084860e-002, -5.081672e-002, -5.078484e-002, -5.075298e-002, -5.072112e-002, -5.068928e-002, -5.065745e-002, -5.062562e-002, -5.059381e-002, -5.056200e-002, -5.053020e-002, -5.049842e-002, -5.046664e-002, -5.043488e-002, -5.040313e-002, -5.037138e-002, -5.033965e-002, -5.030792e-002, -5.027621e-002, -5.024450e-002, -5.021280e-002, -5.018112e-002, -5.014944e-002, -5.011778e-002, -5.008613e-002, -5.005448e-002, -5.002285e-002, -4.999122e-002, -4.995961e-002, -4.992800e-002, -4.989640e-002, -4.986482e-002, -4.983324e-002, -4.980168e-002, -4.977012e-002, -4.973858e-002, -4.970705e-002, -4.967552e-002, -4.964401e-002, -4.961250e-002, -4.958100e-002, -4.954952e-002, -4.951804e-002, -4.948658e-002, -4.945513e-002, -4.942368e-002, -4.939225e-002, -4.936082e-002, -4.932941e-002, -4.929800e-002, -4.926660e-002, -4.923522e-002, -4.920384e-002, -4.917248e-002, -4.914113e-002, -4.910978e-002, -4.907845e-002, -4.904712e-002, -4.901581e-002, -4.898450e-002, -4.895320e-002, -4.892192e-002, -4.889064e-002, -4.885938e-002, -4.882813e-002, -4.879688e-002, -4.876565e-002, -4.873442e-002, -4.870321e-002, -4.867200e-002, -4.864080e-002, -4.860962e-002, -4.857844e-002, -4.854728e-002, -4.851613e-002, -4.848498e-002, -4.845385e-002, -4.842272e-002, -4.839161e-002, -4.836050e-002, -4.832940e-002, -4.829832e-002, -4.826724e-002, -4.823618e-002, -4.820513e-002, -4.817408e-002, -4.814305e-002, -4.811202e-002, -4.808101e-002, 
-4.805000e-002, -4.801900e-002, -4.798802e-002, -4.795704e-002, -4.792608e-002, -4.789512e-002, -4.786418e-002, -4.783325e-002, -4.780232e-002, -4.777141e-002, -4.774050e-002, -4.770960e-002, -4.767872e-002, -4.764784e-002, -4.761698e-002, -4.758613e-002, -4.755528e-002, -4.752445e-002, -4.749362e-002, -4.746281e-002, -4.743200e-002, -4.740120e-002, -4.737042e-002, -4.733964e-002, -4.730888e-002, -4.727812e-002, -4.724738e-002, -4.721665e-002, -4.718592e-002, -4.715521e-002, -4.712450e-002, -4.709380e-002, -4.706312e-002, -4.703244e-002, -4.700178e-002, -4.697112e-002, -4.694048e-002, -4.690985e-002, -4.687922e-002, -4.684861e-002, -4.681800e-002, -4.678740e-002, -4.675682e-002, -4.672624e-002, -4.669568e-002, -4.666512e-002, -4.663458e-002, -4.660405e-002, -4.657352e-002, -4.654301e-002, -4.651250e-002, -4.648200e-002, -4.645152e-002, -4.642104e-002, -4.639058e-002, -4.636012e-002, -4.632968e-002, -4.629925e-002, -4.626882e-002, -4.623841e-002, -4.620800e-002, -4.617760e-002, -4.614722e-002, -4.611684e-002, -4.608648e-002, -4.605612e-002, -4.602578e-002, -4.599545e-002, -4.596512e-002, -4.593481e-002, -4.590450e-002, -4.587420e-002, -4.584392e-002, -4.581364e-002, -4.578338e-002, -4.575312e-002, -4.572288e-002, -4.569265e-002, -4.566242e-002, -4.563221e-002, -4.560200e-002, -4.557180e-002, -4.554162e-002, -4.551144e-002, -4.548128e-002, -4.545112e-002, -4.542098e-002, -4.539085e-002, -4.536072e-002, -4.533061e-002, -4.530050e-002, -4.527040e-002, -4.524032e-002, -4.521024e-002, -4.518018e-002, -4.515012e-002, -4.512008e-002, -4.509005e-002, -4.506002e-002, -4.503001e-002, 
-4.500000e-002, -4.497001e-002, -4.494002e-002, -4.491004e-002, -4.488008e-002, -4.485012e-002, -4.482018e-002, -4.479025e-002, -4.476032e-002, -4.473041e-002, -4.470050e-002, -4.467061e-002, -4.464072e-002, -4.461084e-002, -4.458098e-002, -4.455112e-002, -4.452128e-002, -4.449145e-002, -4.446162e-002, -4.443181e-002, -4.440200e-002, -4.437221e-002, -4.434242e-002, -4.431264e-002, -4.428288e-002, -4.425312e-002, -4.422338e-002, -4.419365e-002, -4.416392e-002, -4.413421e-002, -4.410450e-002, -4.407481e-002, -4.404512e-002, -4.401544e-002, -4.398578e-002, -4.395612e-002, -4.392648e-002, -4.389685e-002, -4.386722e-002, -4.383761e-002, -4.380800e-002, -4.377841e-002, -4.374882e-002, -4.371924e-002, -4.368968e-002, -4.366012e-002, -4.363058e-002, -4.360105e-002, -4.357152e-002, -4.354201e-002, -4.351250e-002, -4.348301e-002, -4.345352e-002, -4.342404e-002, -4.339458e-002, -4.336512e-002, -4.333568e-002, -4.330625e-002, -4.327682e-002, -4.324741e-002, -4.321800e-002, -4.318861e-002, -4.315922e-002, -4.312984e-002, -4.310048e-002, -4.307112e-002, -4.304178e-002, -4.301245e-002, -4.298312e-002, -4.295381e-002, -4.292450e-002, -4.289521e-002, -4.286592e-002, -4.283664e-002, -4.280738e-002, -4.277812e-002, -4.274888e-002, -4.271965e-002, -4.269042e-002, -4.266121e-002, -4.263200e-002, -4.260281e-002, -4.257362e-002, -4.254444e-002, -4.251528e-002, -4.248612e-002, -4.245698e-002, -4.242784e-002, -4.239872e-002, -4.236961e-002, -4.234050e-002, -4.231141e-002, -4.228232e-002, -4.225324e-002, -4.222418e-002, -4.219512e-002, -4.216608e-002, -4.213704e-002, -4.210802e-002, -4.207901e-002, 
-4.205000e-002, -4.202101e-002, -4.199202e-002, -4.196304e-002, -4.193408e-002, -4.190512e-002, -4.187618e-002, -4.184724e-002, -4.181832e-002, -4.178941e-002, -4.176050e-002, -4.173161e-002, -4.170272e-002, -4.167384e-002, -4.164498e-002, -4.161612e-002, -4.158728e-002, -4.155844e-002, -4.152962e-002, -4.150081e-002, -4.147200e-002, -4.144321e-002, -4.141442e-002, -4.138564e-002, -4.135688e-002, -4.132812e-002, -4.129938e-002, -4.127065e-002, -4.124192e-002, -4.121321e-002, -4.118450e-002, -4.115581e-002, -4.112712e-002, -4.109844e-002, -4.106978e-002, -4.104112e-002, -4.101248e-002, -4.098384e-002, -4.095522e-002, -4.092661e-002, -4.089800e-002, -4.086941e-002, -4.084082e-002, -4.081224e-002, -4.078368e-002, -4.075512e-002, -4.072658e-002, -4.069805e-002, -4.066952e-002, -4.064101e-002, -4.061250e-002, -4.058401e-002, -4.055552e-002, -4.052704e-002, -4.049858e-002, -4.047012e-002, -4.044168e-002, -4.041325e-002, -4.038482e-002, -4.035641e-002, -4.032800e-002, -4.029961e-002, -4.027122e-002, -4.024284e-002, -4.021448e-002, -4.018612e-002, -4.015778e-002, -4.012945e-002, -4.010112e-002, -4.007281e-002, -4.004450e-002, -4.001621e-002, -3.998792e-002, -3.995964e-002, -3.993138e-002, -3.990312e-002, -3.987488e-002, -3.984665e-002, -3.981842e-002, -3.979021e-002, -3.976200e-002, -3.973381e-002, -3.970562e-002, -3.967744e-002, -3.964928e-002, -3.962112e-002, -3.959298e-002, -3.956485e-002, -3.953672e-002, -3.950861e-002, -3.948050e-002, -3.945241e-002, -3.942432e-002, -3.939624e-002, -3.936818e-002, -3.934012e-002, -3.931208e-002, -3.928404e-002, -3.925602e-002, -3.922801e-002, 
-3.920000e-002, -3.917201e-002, -3.914402e-002, -3.911604e-002, -3.908808e-002, -3.906012e-002, -3.903218e-002, -3.900425e-002, -3.897632e-002, -3.894841e-002, -3.892050e-002, -3.889261e-002, -3.886472e-002, -3.883684e-002, -3.880898e-002, -3.878112e-002, -3.875328e-002, -3.872544e-002, -3.869762e-002, -3.866981e-002, -3.864200e-002, -3.861421e-002, -3.858642e-002, -3.855864e-002, -3.853088e-002, -3.850312e-002, -3.847538e-002, -3.844764e-002, -3.841992e-002, -3.839221e-002, -3.836450e-002, -3.833681e-002, -3.830912e-002, -3.828144e-002, -3.825378e-002, -3.822612e-002, -3.819848e-002, -3.817084e-002, -3.814322e-002, -3.811561e-002, -3.808800e-002, -3.806041e-002, -3.803282e-002, -3.800524e-002, -3.797768e-002, -3.795012e-002, -3.792258e-002, -3.789504e-002, -3.786752e-002, -3.784001e-002, -3.781250e-002, -3.778501e-002, -3.775752e-002, -3.773005e-002, -3.770258e-002, -3.767512e-002, -3.764768e-002, -3.762024e-002, -3.759282e-002, -3.756541e-002, -3.753800e-002, -3.751061e-002, -3.748322e-002, -3.745585e-002, -3.742848e-002, -3.740112e-002, -3.737378e-002, -3.734644e-002, -3.731912e-002, -3.729181e-002, -3.726450e-002, -3.723721e-002, -3.720992e-002, -3.718265e-002, -3.715538e-002, -3.712812e-002, -3.710088e-002, -3.707364e-002, -3.704642e-002, -3.701920e-002, -3.699200e-002, -3.696481e-002, -3.693762e-002, -3.691045e-002, -3.688328e-002, -3.685612e-002, -3.682898e-002, -3.680184e-002, -3.677472e-002, -3.674761e-002, -3.672050e-002, -3.669341e-002, -3.666632e-002, -3.663925e-002, -3.661218e-002, -3.658512e-002, -3.655808e-002, -3.653104e-002, -3.650402e-002, -3.647701e-002, 
-3.645000e-002, -3.642301e-002, -3.639602e-002, -3.636905e-002, -3.634208e-002, -3.631512e-002, -3.628818e-002, -3.626124e-002, -3.623432e-002, -3.620741e-002, -3.618050e-002, -3.615361e-002, -3.612672e-002, -3.609985e-002, -3.607298e-002, -3.604612e-002, -3.601928e-002, -3.599244e-002, -3.596562e-002, -3.593881e-002, -3.591200e-002, -3.588521e-002, -3.585842e-002, -3.583165e-002, -3.580488e-002, -3.577812e-002, -3.575138e-002, -3.572464e-002, -3.569792e-002, -3.567121e-002, -3.564450e-002, -3.561781e-002, -3.559112e-002, -3.556445e-002, -3.553778e-002, -3.551112e-002, -3.548448e-002, -3.545784e-002, -3.543122e-002, -3.540460e-002, -3.537800e-002, -3.535141e-002, -3.532482e-002, -3.529825e-002, -3.527168e-002, -3.524512e-002, -3.521858e-002, -3.519204e-002, -3.516552e-002, -3.513901e-002, -3.511250e-002, -3.508601e-002, -3.505952e-002, -3.503305e-002, -3.500658e-002, -3.498012e-002, -3.495368e-002, -3.492724e-002, -3.490082e-002, -3.487440e-002, -3.484800e-002, -3.482161e-002, -3.479522e-002, -3.476885e-002, -3.474248e-002, -3.471612e-002, -3.468978e-002, -3.466344e-002, -3.463712e-002, -3.461081e-002, -3.458450e-002, -3.455821e-002, -3.453192e-002, -3.450565e-002, -3.447938e-002, -3.445312e-002, -3.442688e-002, -3.440064e-002, -3.437442e-002, -3.434821e-002, -3.432200e-002, -3.429581e-002, -3.426962e-002, -3.424345e-002, -3.421728e-002, -3.419112e-002, -3.416498e-002, -3.413884e-002, -3.411272e-002, -3.408660e-002, -3.406050e-002, -3.403441e-002, -3.400832e-002, -3.398225e-002, -3.395618e-002, -3.393012e-002, -3.390408e-002, -3.387804e-002, -3.385202e-002, -3.382600e-002, 
-3.380000e-002, -3.377401e-002, -3.374802e-002, -3.372205e-002, -3.369608e-002, -3.367012e-002, -3.364418e-002, -3.361824e-002, -3.359232e-002, -3.356641e-002, -3.354050e-002, -3.351461e-002, -3.348872e-002, -3.346285e-002, -3.343698e-002, -3.341112e-002, -3.338528e-002, -3.335944e-002, -3.333362e-002, -3.330780e-002, -3.328200e-002, -3.325621e-002, -3.323042e-002, -3.320465e-002, -3.317888e-002, -3.315312e-002, -3.312738e-002, -3.310164e-002, -3.307592e-002, -3.305020e-002, -3.302450e-002, -3.299881e-002, -3.297312e-002, -3.294745e-002, -3.292178e-002, -3.289612e-002, -3.287048e-002, -3.284484e-002, -3.281922e-002, -3.279360e-002, -3.276800e-002, -3.274241e-002, -3.271682e-002, -3.269125e-002, -3.266568e-002, -3.264012e-002, -3.261458e-002, -3.258904e-002, -3.256352e-002, -3.253801e-002, -3.251250e-002, -3.248701e-002, -3.246152e-002, -3.243605e-002, -3.241058e-002, -3.238512e-002, -3.235968e-002, -3.233424e-002, -3.230882e-002, -3.228341e-002, -3.225800e-002, -3.223261e-002, -3.220722e-002, -3.218185e-002, -3.215648e-002, -3.213112e-002, -3.210578e-002, -3.208044e-002, -3.205512e-002, -3.202980e-002, -3.200450e-002, -3.197921e-002, -3.195392e-002, -3.192865e-002, -3.190338e-002, -3.187812e-002, -3.185288e-002, -3.182764e-002, -3.180242e-002, -3.177720e-002, -3.175200e-002, -3.172681e-002, -3.170162e-002, -3.167645e-002, -3.165128e-002, -3.162612e-002, -3.160098e-002, -3.157584e-002, -3.155072e-002, -3.152560e-002, -3.150050e-002, -3.147541e-002, -3.145032e-002, -3.142525e-002, -3.140018e-002, -3.137512e-002, -3.135008e-002, -3.132504e-002, -3.130002e-002, -3.127500e-002, 
-3.125000e-002, -3.122501e-002, -3.120002e-002, -3.117505e-002, -3.115008e-002, -3.112513e-002, -3.110018e-002, -3.107524e-002, -3.105032e-002, -3.102540e-002, -3.100050e-002, -3.097561e-002, -3.095072e-002, -3.092585e-002, -3.090098e-002, -3.087613e-002, -3.085128e-002, -3.082644e-002, -3.080162e-002, -3.077680e-002, -3.075200e-002, -3.072721e-002, -3.070242e-002, -3.067765e-002, -3.065288e-002, -3.062813e-002, -3.060338e-002, -3.057864e-002, -3.055392e-002, -3.052920e-002, -3.050450e-002, -3.047981e-002, -3.045512e-002, -3.043045e-002, -3.040578e-002, -3.038113e-002, -3.035648e-002, -3.033184e-002, -3.030722e-002, -3.028260e-002, -3.025800e-002, -3.023341e-002, -3.020882e-002, -3.018425e-002, -3.015968e-002, -3.013513e-002, -3.011058e-002, -3.008604e-002, -3.006152e-002, -3.003700e-002, -3.001250e-002, -2.998801e-002, -2.996352e-002, -2.993905e-002, -2.991458e-002, -2.989013e-002, -2.986568e-002, -2.984124e-002, -2.981682e-002, -2.979240e-002, -2.976800e-002, -2.974361e-002, -2.971922e-002, -2.969485e-002, -2.967048e-002, -2.964613e-002, -2.962178e-002, -2.959744e-002, -2.957312e-002, -2.954880e-002, -2.952450e-002, -2.950021e-002, -2.947592e-002, -2.945165e-002, -2.942738e-002, -2.940313e-002, -2.937888e-002, -2.935464e-002, -2.933042e-002, -2.930620e-002, -2.928200e-002, -2.925781e-002, -2.923362e-002, -2.920945e-002, -2.918528e-002, -2.916113e-002, -2.913698e-002, -2.911284e-002, -2.908872e-002, -2.906460e-002, -2.904050e-002, -2.901641e-002, -2.899232e-002, -2.896825e-002, -2.894418e-002, -2.892013e-002, -2.889608e-002, -2.887204e-002, -2.884802e-002, -2.882400e-002, 
-2.880000e-002, -2.877601e-002, -2.875202e-002, -2.872805e-002, -2.870408e-002, -2.868013e-002, -2.865618e-002, -2.863224e-002, -2.860832e-002, -2.858440e-002, -2.856050e-002, -2.853661e-002, -2.851272e-002, -2.848885e-002, -2.846498e-002, -2.844113e-002, -2.841728e-002, -2.839344e-002, -2.836962e-002, -2.834580e-002, -2.832200e-002, -2.829821e-002, -2.827442e-002, -2.825065e-002, -2.822688e-002, -2.820313e-002, -2.817938e-002, -2.815564e-002, -2.813192e-002, -2.810820e-002, -2.808450e-002, -2.806081e-002, -2.803712e-002, -2.801345e-002, -2.798978e-002, -2.796613e-002, -2.794248e-002, -2.791884e-002, -2.789522e-002, -2.787160e-002, -2.784800e-002, -2.782441e-002, -2.780082e-002, -2.777725e-002, -2.775368e-002, -2.773013e-002, -2.770658e-002, -2.768304e-002, -2.765952e-002, -2.763600e-002, -2.761250e-002, -2.758901e-002, -2.756552e-002, -2.754205e-002, -2.751858e-002, -2.749513e-002, -2.747168e-002, -2.744824e-002, -2.742482e-002, -2.740140e-002, -2.737800e-002, -2.735461e-002, -2.733122e-002, -2.730785e-002, -2.728448e-002, -2.726113e-002, -2.723778e-002, -2.721444e-002, -2.719112e-002, -2.716780e-002, -2.714450e-002, -2.712120e-002, -2.709792e-002, -2.707465e-002, -2.705138e-002, -2.702813e-002, -2.700488e-002, -2.698164e-002, -2.695842e-002, -2.693520e-002, -2.691200e-002, -2.688880e-002, -2.686562e-002, -2.684245e-002, -2.681928e-002, -2.679613e-002, -2.677298e-002, -2.674984e-002, -2.672672e-002, -2.670360e-002, -2.668050e-002, -2.665740e-002, -2.663432e-002, -2.661125e-002, -2.658818e-002, -2.656513e-002, -2.654208e-002, -2.651904e-002, -2.649602e-002, -2.647300e-002, 
-2.645000e-002, -2.642701e-002, -2.640402e-002, -2.638105e-002, -2.635808e-002, -2.633513e-002, -2.631218e-002, -2.628924e-002, -2.626632e-002, -2.624340e-002, -2.622050e-002, -2.619760e-002, -2.617472e-002, -2.615185e-002, -2.612898e-002, -2.610613e-002, -2.608328e-002, -2.606044e-002, -2.603762e-002, -2.601480e-002, -2.599200e-002, -2.596920e-002, -2.594642e-002, -2.592365e-002, -2.590088e-002, -2.587813e-002, -2.585538e-002, -2.583264e-002, -2.580992e-002, -2.578720e-002, -2.576450e-002, -2.574181e-002, -2.571912e-002, -2.569645e-002, -2.567378e-002, -2.565113e-002, -2.562848e-002, -2.560584e-002, -2.558322e-002, -2.556060e-002, -2.553800e-002, -2.551540e-002, -2.549282e-002, -2.547025e-002, -2.544768e-002, -2.542513e-002, -2.540258e-002, -2.538004e-002, -2.535752e-002, -2.533500e-002, -2.531250e-002, -2.529000e-002, -2.526752e-002, -2.524505e-002, -2.522258e-002, -2.520013e-002, -2.517768e-002, -2.515525e-002, -2.513282e-002, -2.511040e-002, -2.508800e-002, -2.506560e-002, -2.504322e-002, -2.502085e-002, -2.499848e-002, -2.497613e-002, -2.495378e-002, -2.493145e-002, -2.490912e-002, -2.488680e-002, -2.486450e-002, -2.484220e-002, -2.481992e-002, -2.479765e-002, -2.477538e-002, -2.475313e-002, -2.473088e-002, -2.470865e-002, -2.468642e-002, -2.466420e-002, -2.464200e-002, -2.461980e-002, -2.459762e-002, -2.457545e-002, -2.455328e-002, -2.453113e-002, -2.450898e-002, -2.448685e-002, -2.446472e-002, -2.444260e-002, -2.442050e-002, -2.439840e-002, -2.437632e-002, -2.435425e-002, -2.433218e-002, -2.431013e-002, -2.428808e-002, -2.426605e-002, -2.424402e-002, -2.422200e-002, 
-2.420000e-002, -2.417800e-002, -2.415602e-002, -2.413405e-002, -2.411208e-002, -2.409013e-002, -2.406818e-002, -2.404625e-002, -2.402432e-002, -2.400240e-002, -2.398050e-002, -2.395860e-002, -2.393672e-002, -2.391485e-002, -2.389298e-002, -2.387113e-002, -2.384928e-002, -2.382745e-002, -2.380562e-002, -2.378380e-002, -2.376200e-002, -2.374020e-002, -2.371842e-002, -2.369665e-002, -2.367488e-002, -2.365313e-002, -2.363138e-002, -2.360965e-002, -2.358792e-002, -2.356620e-002, -2.354450e-002, -2.352280e-002, -2.350112e-002, -2.347945e-002, -2.345778e-002, -2.343613e-002, -2.341448e-002, -2.339285e-002, -2.337122e-002, -2.334960e-002, -2.332800e-002, -2.330640e-002, -2.328482e-002, -2.326325e-002, -2.324168e-002, -2.322013e-002, -2.319858e-002, -2.317705e-002, -2.315552e-002, -2.313400e-002, -2.311250e-002, -2.309100e-002, -2.306952e-002, -2.304805e-002, -2.302658e-002, -2.300513e-002, -2.298368e-002, -2.296225e-002, -2.294082e-002, -2.291940e-002, -2.289800e-002, -2.287660e-002, -2.285522e-002, -2.283385e-002, -2.281248e-002, -2.279113e-002, -2.276978e-002, -2.274845e-002, -2.272712e-002, -2.270580e-002, -2.268450e-002, -2.266320e-002, -2.264192e-002, -2.262065e-002, -2.259938e-002, -2.257813e-002, -2.255688e-002, -2.253565e-002, -2.251442e-002, -2.249320e-002, -2.247200e-002, -2.245080e-002, -2.242962e-002, -2.240844e-002, -2.238728e-002, -2.236613e-002, -2.234498e-002, -2.232385e-002, -2.230272e-002, -2.228160e-002, -2.226050e-002, -2.223940e-002, -2.221832e-002, -2.219725e-002, -2.217618e-002, -2.215513e-002, -2.213408e-002, -2.211305e-002, -2.209202e-002, -2.207100e-002, 
-2.205000e-002, -2.202900e-002, -2.200802e-002, -2.198705e-002, -2.196608e-002, -2.194513e-002, -2.192418e-002, -2.190325e-002, -2.188232e-002, -2.186140e-002, -2.184050e-002, -2.181960e-002, -2.179872e-002, -2.177785e-002, -2.175698e-002, -2.173613e-002, -2.171528e-002, -2.169445e-002, -2.167362e-002, -2.165280e-002, -2.163200e-002, -2.161120e-002, -2.159042e-002, -2.156964e-002, -2.154888e-002, -2.152813e-002, -2.150738e-002, -2.148665e-002, -2.146592e-002, -2.144520e-002, -2.142450e-002, -2.140380e-002, -2.138312e-002, -2.136244e-002, -2.134178e-002, -2.132113e-002, -2.130048e-002, -2.127985e-002, -2.125922e-002, -2.123860e-002, -2.121800e-002, -2.119740e-002, -2.117682e-002, -2.115624e-002, -2.113568e-002, -2.111513e-002, -2.109458e-002, -2.107405e-002, -2.105352e-002, -2.103300e-002, -2.101250e-002, -2.099200e-002, -2.097152e-002, -2.095104e-002, -2.093058e-002, -2.091013e-002, -2.088968e-002, -2.086925e-002, -2.084882e-002, -2.082840e-002, -2.080800e-002, -2.078760e-002, -2.076722e-002, -2.074685e-002, -2.072648e-002, -2.070613e-002, -2.068578e-002, -2.066545e-002, -2.064512e-002, -2.062480e-002, -2.060450e-002, -2.058420e-002, -2.056392e-002, -2.054364e-002, -2.052338e-002, -2.050313e-002, -2.048288e-002, -2.046265e-002, -2.044242e-002, -2.042220e-002, -2.040200e-002, -2.038180e-002, -2.036162e-002, -2.034145e-002, -2.032128e-002, -2.030113e-002, -2.028098e-002, -2.026085e-002, -2.024072e-002, -2.022060e-002, -2.020050e-002, -2.018040e-002, -2.016032e-002, -2.014024e-002, -2.012018e-002, -2.010013e-002, -2.008008e-002, -2.006005e-002, -2.004002e-002, -2.002000e-002, 
-2.000000e-002, -1.998000e-002, -1.996002e-002, -1.994004e-002, -1.992008e-002, -1.990013e-002, -1.988018e-002, -1.986025e-002, -1.984032e-002, -1.982041e-002, -1.980050e-002, -1.978060e-002, -1.976072e-002, -1.974084e-002, -1.972098e-002, -1.970113e-002, -1.968128e-002, -1.966145e-002, -1.964162e-002, -1.962181e-002, -1.960200e-002, -1.958220e-002, -1.956242e-002, -1.954264e-002, -1.952288e-002, -1.950313e-002, -1.948338e-002, -1.946365e-002, -1.944392e-002, -1.942421e-002, -1.940450e-002, -1.938480e-002, -1.936512e-002, -1.934544e-002, -1.932578e-002, -1.930613e-002, -1.928648e-002, -1.926685e-002, -1.924722e-002, -1.922761e-002, -1.920800e-002, -1.918840e-002, -1.916882e-002, -1.914924e-002, -1.912968e-002, -1.911013e-002, -1.909058e-002, -1.907105e-002, -1.905152e-002, -1.903201e-002, -1.901250e-002, -1.899300e-002, -1.897352e-002, -1.895404e-002, -1.893458e-002, -1.891513e-002, -1.889568e-002, -1.887625e-002, -1.885682e-002, -1.883741e-002, -1.881800e-002, -1.879860e-002, -1.877922e-002, -1.875984e-002, -1.874048e-002, -1.872113e-002, -1.870178e-002, -1.868245e-002, -1.866312e-002, -1.864381e-002, -1.862450e-002, -1.860520e-002, -1.858592e-002, -1.856664e-002, -1.854738e-002, -1.852812e-002, -1.850888e-002, -1.848965e-002, -1.847042e-002, -1.845121e-002, -1.843200e-002, -1.841280e-002, -1.839362e-002, -1.837444e-002, -1.835528e-002, -1.833613e-002, -1.831698e-002, -1.829785e-002, -1.827872e-002, -1.825961e-002, -1.824050e-002, -1.822140e-002, -1.820232e-002, -1.818324e-002, -1.816418e-002, -1.814513e-002, -1.812608e-002, -1.810705e-002, -1.808802e-002, -1.806901e-002, 
-1.805000e-002, -1.803100e-002, -1.801202e-002, -1.799304e-002, -1.797408e-002, -1.795512e-002, -1.793618e-002, -1.791725e-002, -1.789832e-002, -1.787941e-002, -1.786050e-002, -1.784160e-002, -1.782272e-002, -1.780384e-002, -1.778498e-002, -1.776613e-002, -1.774728e-002, -1.772845e-002, -1.770962e-002, -1.769081e-002, -1.767200e-002, -1.765320e-002, -1.763442e-002, -1.761564e-002, -1.759688e-002, -1.757813e-002, -1.755938e-002, -1.754065e-002, -1.752192e-002, -1.750321e-002, -1.748450e-002, -1.746580e-002, -1.744712e-002, -1.742844e-002, -1.740978e-002, -1.739113e-002, -1.737248e-002, -1.735385e-002, -1.733522e-002, -1.731661e-002, -1.729800e-002, -1.727940e-002, -1.726082e-002, -1.724224e-002, -1.722368e-002, -1.720512e-002, -1.718658e-002, -1.716805e-002, -1.714952e-002, -1.713101e-002, -1.711250e-002, -1.709400e-002, -1.707552e-002, -1.705704e-002, -1.703858e-002, -1.702013e-002, -1.700168e-002, -1.698325e-002, -1.696482e-002, -1.694641e-002, -1.692800e-002, -1.690960e-002, -1.689122e-002, -1.687284e-002, -1.685448e-002, -1.683613e-002, -1.681778e-002, -1.679945e-002, -1.678112e-002, -1.676281e-002, -1.674450e-002, -1.672620e-002, -1.670792e-002, -1.668964e-002, -1.667138e-002, -1.665312e-002, -1.663488e-002, -1.661665e-002, -1.659842e-002, -1.658021e-002, -1.656200e-002, -1.654380e-002, -1.652562e-002, -1.650744e-002, -1.648928e-002, -1.647113e-002, -1.645298e-002, -1.643485e-002, -1.641672e-002, -1.639861e-002, -1.638050e-002, -1.636240e-002, -1.634432e-002, -1.632624e-002, -1.630818e-002, -1.629012e-002, -1.627208e-002, -1.625405e-002, -1.623602e-002, -1.621801e-002, 
-1.620000e-002, -1.618200e-002, -1.616402e-002, -1.614604e-002, -1.612808e-002, -1.611012e-002, -1.609218e-002, -1.607425e-002, -1.605632e-002, -1.603841e-002, -1.602050e-002, -1.600260e-002, -1.598472e-002, -1.596684e-002, -1.594898e-002, -1.593112e-002, -1.591328e-002, -1.589545e-002, -1.587762e-002, -1.585981e-002, -1.584200e-002, -1.582420e-002, -1.580642e-002, -1.578864e-002, -1.577088e-002, -1.575313e-002, -1.573538e-002, -1.571765e-002, -1.569992e-002, -1.568221e-002, -1.566450e-002, -1.564680e-002, -1.562912e-002, -1.561144e-002, -1.559378e-002, -1.557612e-002, -1.555848e-002, -1.554085e-002, -1.552322e-002, -1.550561e-002, -1.548800e-002, -1.547040e-002, -1.545282e-002, -1.543524e-002, -1.541768e-002, -1.540012e-002, -1.538258e-002, -1.536505e-002, -1.534752e-002, -1.533001e-002, -1.531250e-002, -1.529501e-002, -1.527752e-002, -1.526004e-002, -1.524258e-002, -1.522512e-002, -1.520768e-002, -1.519025e-002, -1.517282e-002, -1.515541e-002, -1.513800e-002, -1.512061e-002, -1.510322e-002, -1.508584e-002, -1.506848e-002, -1.505112e-002, -1.503378e-002, -1.501645e-002, -1.499912e-002, -1.498181e-002, -1.496450e-002, -1.494721e-002, -1.492992e-002, -1.491264e-002, -1.489538e-002, -1.487812e-002, -1.486088e-002, -1.484365e-002, -1.482642e-002, -1.480921e-002, -1.479200e-002, -1.477481e-002, -1.475762e-002, -1.474044e-002, -1.472328e-002, -1.470612e-002, -1.468898e-002, -1.467185e-002, -1.465472e-002, -1.463761e-002, -1.462050e-002, -1.460341e-002, -1.458632e-002, -1.456924e-002, -1.455218e-002, -1.453512e-002, -1.451808e-002, -1.450105e-002, -1.448402e-002, -1.446701e-002, 
-1.445000e-002, -1.443301e-002, -1.441602e-002, -1.439904e-002, -1.438208e-002, -1.436512e-002, -1.434818e-002, -1.433125e-002, -1.431432e-002, -1.429741e-002, -1.428050e-002, -1.426361e-002, -1.424672e-002, -1.422984e-002, -1.421298e-002, -1.419612e-002, -1.417928e-002, -1.416245e-002, -1.414562e-002, -1.412881e-002, -1.411200e-002, -1.409521e-002, -1.407842e-002, -1.406164e-002, -1.404488e-002, -1.402812e-002, -1.401138e-002, -1.399465e-002, -1.397792e-002, -1.396121e-002, -1.394450e-002, -1.392781e-002, -1.391112e-002, -1.389444e-002, -1.387778e-002, -1.386112e-002, -1.384448e-002, -1.382785e-002, -1.381122e-002, -1.379461e-002, -1.377800e-002, -1.376141e-002, -1.374482e-002, -1.372824e-002, -1.371168e-002, -1.369512e-002, -1.367858e-002, -1.366205e-002, -1.364552e-002, -1.362901e-002, -1.361250e-002, -1.359601e-002, -1.357952e-002, -1.356304e-002, -1.354658e-002, -1.353012e-002, -1.351368e-002, -1.349725e-002, -1.348082e-002, -1.346441e-002, -1.344800e-002, -1.343161e-002, -1.341522e-002, -1.339884e-002, -1.338248e-002, -1.336612e-002, -1.334978e-002, -1.333344e-002, -1.331712e-002, -1.330081e-002, -1.328450e-002, -1.326821e-002, -1.325192e-002, -1.323564e-002, -1.321938e-002, -1.320312e-002, -1.318688e-002, -1.317065e-002, -1.315442e-002, -1.313821e-002, -1.312200e-002, -1.310581e-002, -1.308962e-002, -1.307344e-002, -1.305728e-002, -1.304112e-002, -1.302498e-002, -1.300885e-002, -1.299272e-002, -1.297661e-002, -1.296050e-002, -1.294441e-002, -1.292832e-002, -1.291224e-002, -1.289618e-002, -1.288012e-002, -1.286408e-002, -1.284804e-002, -1.283202e-002, -1.281601e-002, 
-1.280000e-002, -1.278401e-002, -1.276802e-002, -1.275204e-002, -1.273608e-002, -1.272012e-002, -1.270418e-002, -1.268824e-002, -1.267232e-002, -1.265641e-002, -1.264050e-002, -1.262461e-002, -1.260872e-002, -1.259284e-002, -1.257698e-002, -1.256112e-002, -1.254528e-002, -1.252945e-002, -1.251362e-002, -1.249781e-002, -1.248200e-002, -1.246621e-002, -1.245042e-002, -1.243464e-002, -1.241888e-002, -1.240312e-002, -1.238738e-002, -1.237164e-002, -1.235592e-002, -1.234021e-002, -1.232450e-002, -1.230881e-002, -1.229312e-002, -1.227744e-002, -1.226178e-002, -1.224612e-002, -1.223048e-002, -1.221484e-002, -1.219922e-002, -1.218361e-002, -1.216800e-002, -1.215241e-002, -1.213682e-002, -1.212124e-002, -1.210568e-002, -1.209012e-002, -1.207458e-002, -1.205904e-002, -1.204352e-002, -1.202801e-002, -1.201250e-002, -1.199701e-002, -1.198152e-002, -1.196604e-002, -1.195058e-002, -1.193512e-002, -1.191968e-002, -1.190424e-002, -1.188882e-002, -1.187341e-002, -1.185800e-002, -1.184261e-002, -1.182722e-002, -1.181184e-002, -1.179648e-002, -1.178112e-002, -1.176578e-002, -1.175044e-002, -1.173512e-002, -1.171981e-002, -1.170450e-002, -1.168921e-002, -1.167392e-002, -1.165864e-002, -1.164338e-002, -1.162812e-002, -1.161288e-002, -1.159764e-002, -1.158242e-002, -1.156721e-002, -1.155200e-002, -1.153681e-002, -1.152162e-002, -1.150644e-002, -1.149128e-002, -1.147612e-002, -1.146098e-002, -1.144584e-002, -1.143072e-002, -1.141561e-002, -1.140050e-002, -1.138541e-002, -1.137032e-002, -1.135524e-002, -1.134018e-002, -1.132512e-002, -1.131008e-002, -1.129504e-002, -1.128002e-002, -1.126501e-002, 
-1.125000e-002, -1.123501e-002, -1.122002e-002, -1.120505e-002, -1.119008e-002, -1.117512e-002, -1.116018e-002, -1.114524e-002, -1.113032e-002, -1.111541e-002, -1.110050e-002, -1.108561e-002, -1.107072e-002, -1.105585e-002, -1.104098e-002, -1.102612e-002, -1.101128e-002, -1.099644e-002, -1.098162e-002, -1.096681e-002, -1.095200e-002, -1.093721e-002, -1.092242e-002, -1.090765e-002, -1.089288e-002, -1.087812e-002, -1.086338e-002, -1.084864e-002, -1.083392e-002, -1.081921e-002, -1.080450e-002, -1.078981e-002, -1.077512e-002, -1.076045e-002, -1.074578e-002, -1.073112e-002, -1.071648e-002, -1.070184e-002, -1.068722e-002, -1.067261e-002, -1.065800e-002, -1.064341e-002, -1.062882e-002, -1.061425e-002, -1.059968e-002, -1.058512e-002, -1.057058e-002, -1.055604e-002, -1.054152e-002, -1.052701e-002, -1.051250e-002, -1.049801e-002, -1.048352e-002, -1.046905e-002, -1.045458e-002, -1.044012e-002, -1.042568e-002, -1.041124e-002, -1.039682e-002, -1.038241e-002, -1.036800e-002, -1.035361e-002, -1.033922e-002, -1.032485e-002, -1.031048e-002, -1.029612e-002, -1.028178e-002, -1.026744e-002, -1.025312e-002, -1.023881e-002, -1.022450e-002, -1.021021e-002, -1.019592e-002, -1.018165e-002, -1.016738e-002, -1.015312e-002, -1.013888e-002, -1.012464e-002, -1.011042e-002, -1.009621e-002, -1.008200e-002, -1.006781e-002, -1.005362e-002, -1.003945e-002, -1.002528e-002, -1.001112e-002, -9.996980e-003, -9.982845e-003, -9.968720e-003, -9.954605e-003, -9.940500e-003, -9.926405e-003, -9.912320e-003, -9.898245e-003, -9.884180e-003, -9.870125e-003, -9.856080e-003, -9.842045e-003, -9.828020e-003, -9.814005e-003, 
-9.800000e-003, -9.786005e-003, -9.772020e-003, -9.758045e-003, -9.744080e-003, -9.730125e-003, -9.716180e-003, -9.702245e-003, -9.688320e-003, -9.674405e-003, -9.660500e-003, -9.646605e-003, -9.632720e-003, -9.618845e-003, -9.604980e-003, -9.591125e-003, -9.577280e-003, -9.563445e-003, -9.549620e-003, -9.535805e-003, -9.522000e-003, -9.508205e-003, -9.494420e-003, -9.480645e-003, -9.466880e-003, -9.453125e-003, -9.439380e-003, -9.425645e-003, -9.411920e-003, -9.398205e-003, -9.384500e-003, -9.370805e-003, -9.357120e-003, -9.343445e-003, -9.329780e-003, -9.316125e-003, -9.302480e-003, -9.288845e-003, -9.275220e-003, -9.261605e-003, -9.248000e-003, -9.234405e-003, -9.220820e-003, -9.207245e-003, -9.193680e-003, -9.180125e-003, -9.166580e-003, -9.153045e-003, -9.139520e-003, -9.126005e-003, -9.112500e-003, -9.099005e-003, -9.085520e-003, -9.072045e-003, -9.058580e-003, -9.045125e-003, -9.031680e-003, -9.018245e-003, -9.004820e-003, -8.991405e-003, -8.978000e-003, -8.964605e-003, -8.951220e-003, -8.937845e-003, -8.924480e-003, -8.911125e-003, -8.897780e-003, -8.884445e-003, -8.871120e-003, -8.857805e-003, -8.844500e-003, -8.831205e-003, -8.817920e-003, -8.804645e-003, -8.791380e-003, -8.778125e-003, -8.764880e-003, -8.751645e-003, -8.738420e-003, -8.725205e-003, -8.712000e-003, -8.698805e-003, -8.685620e-003, -8.672445e-003, -8.659280e-003, -8.646125e-003, -8.632980e-003, -8.619845e-003, -8.606720e-003, -8.593605e-003, -8.580500e-003, -8.567405e-003, -8.554320e-003, -8.541245e-003, -8.528180e-003, -8.515125e-003, -8.502080e-003, -8.489045e-003, -8.476020e-003, -8.463005e-003, 
-8.450000e-003, -8.437005e-003, -8.424020e-003, -8.411045e-003, -8.398080e-003, -8.385125e-003, -8.372180e-003, -8.359245e-003, -8.346320e-003, -8.333405e-003, -8.320500e-003, -8.307605e-003, -8.294720e-003, -8.281845e-003, -8.268980e-003, -8.256125e-003, -8.243280e-003, -8.230445e-003, -8.217620e-003, -8.204805e-003, -8.192000e-003, -8.179205e-003, -8.166420e-003, -8.153645e-003, -8.140880e-003, -8.128125e-003, -8.115380e-003, -8.102645e-003, -8.089920e-003, -8.077205e-003, -8.064500e-003, -8.051805e-003, -8.039120e-003, -8.026445e-003, -8.013780e-003, -8.001125e-003, -7.988480e-003, -7.975845e-003, -7.963220e-003, -7.950605e-003, -7.938000e-003, -7.925405e-003, -7.912820e-003, -7.900245e-003, -7.887680e-003, -7.875125e-003, -7.862580e-003, -7.850045e-003, -7.837520e-003, -7.825005e-003, -7.812500e-003, -7.800005e-003, -7.787520e-003, -7.775045e-003, -7.762580e-003, -7.750125e-003, -7.737680e-003, -7.725245e-003, -7.712820e-003, -7.700405e-003, -7.688000e-003, -7.675605e-003, -7.663220e-003, -7.650845e-003, -7.638480e-003, -7.626125e-003, -7.613780e-003, -7.601445e-003, -7.589120e-003, -7.576805e-003, -7.564500e-003, -7.552205e-003, -7.539920e-003, -7.527645e-003, -7.515380e-003, -7.503125e-003, -7.490880e-003, -7.478645e-003, -7.466420e-003, -7.454205e-003, -7.442000e-003, -7.429805e-003, -7.417620e-003, -7.405445e-003, -7.393280e-003, -7.381125e-003, -7.368980e-003, -7.356845e-003, -7.344720e-003, -7.332605e-003, -7.320500e-003, -7.308405e-003, -7.296320e-003, -7.284245e-003, -7.272180e-003, -7.260125e-003, -7.248080e-003, -7.236045e-003, -7.224020e-003, -7.212005e-003, 
-7.200000e-003, -7.188005e-003, -7.176020e-003, -7.164045e-003, -7.152080e-003, -7.140125e-003, -7.128180e-003, -7.116245e-003, -7.104320e-003, -7.092405e-003, -7.080500e-003, -7.068605e-003, -7.056720e-003, -7.044845e-003, -7.032980e-003, -7.021125e-003, -7.009280e-003, -6.997445e-003, -6.985620e-003, -6.973805e-003, -6.962000e-003, -6.950205e-003, -6.938420e-003, -6.926645e-003, -6.914880e-003, -6.903125e-003, -6.891380e-003, -6.879645e-003, -6.867920e-003, -6.856205e-003, -6.844500e-003, -6.832805e-003, -6.821120e-003, -6.809445e-003, -6.797780e-003, -6.786125e-003, -6.774480e-003, -6.762845e-003, -6.751220e-003, -6.739605e-003, -6.728000e-003, -6.716405e-003, -6.704820e-003, -6.693245e-003, -6.681680e-003, -6.670125e-003, -6.658580e-003, -6.647045e-003, -6.635520e-003, -6.624005e-003, -6.612500e-003, -6.601005e-003, -6.589520e-003, -6.578045e-003, -6.566580e-003, -6.555125e-003, -6.543680e-003, -6.532245e-003, -6.520820e-003, -6.509405e-003, -6.498000e-003, -6.486605e-003, -6.475220e-003, -6.463845e-003, -6.452480e-003, -6.441125e-003, -6.429780e-003, -6.418445e-003, -6.407120e-003, -6.395805e-003, -6.384500e-003, -6.373205e-003, -6.361920e-003, -6.350645e-003, -6.339380e-003, -6.328125e-003, -6.316880e-003, -6.305645e-003, -6.294420e-003, -6.283205e-003, -6.272000e-003, -6.260805e-003, -6.249620e-003, -6.238445e-003, -6.227280e-003, -6.216125e-003, -6.204980e-003, -6.193845e-003, -6.182720e-003, -6.171605e-003, -6.160500e-003, -6.149405e-003, -6.138320e-003, -6.127245e-003, -6.116180e-003, -6.105125e-003, -6.094080e-003, -6.083045e-003, -6.072020e-003, -6.061005e-003, 
-6.050000e-003, -6.039005e-003, -6.028020e-003, -6.017045e-003, -6.006080e-003, -5.995125e-003, -5.984180e-003, -5.973245e-003, -5.962320e-003, -5.951405e-003, -5.940500e-003, -5.929605e-003, -5.918720e-003, -5.907845e-003, -5.896980e-003, -5.886125e-003, -5.875280e-003, -5.864445e-003, -5.853620e-003, -5.842805e-003, -5.832000e-003, -5.821205e-003, -5.810420e-003, -5.799645e-003, -5.788880e-003, -5.778125e-003, -5.767380e-003, -5.756645e-003, -5.745920e-003, -5.735205e-003, -5.724500e-003, -5.713805e-003, -5.703120e-003, -5.692445e-003, -5.681780e-003, -5.671125e-003, -5.660480e-003, -5.649845e-003, -5.639220e-003, -5.628605e-003, -5.618000e-003, -5.607405e-003, -5.596820e-003, -5.586245e-003, -5.575680e-003, -5.565125e-003, -5.554580e-003, -5.544045e-003, -5.533520e-003, -5.523005e-003, -5.512500e-003, -5.502005e-003, -5.491520e-003, -5.481045e-003, -5.470580e-003, -5.460125e-003, -5.449680e-003, -5.439245e-003, -5.428820e-003, -5.418405e-003, -5.408000e-003, -5.397605e-003, -5.387220e-003, -5.376845e-003, -5.366480e-003, -5.356125e-003, -5.345780e-003, -5.335445e-003, -5.325120e-003, -5.314805e-003, -5.304500e-003, -5.294205e-003, -5.283920e-003, -5.273645e-003, -5.263380e-003, -5.253125e-003, -5.242880e-003, -5.232645e-003, -5.222420e-003, -5.212205e-003, -5.202000e-003, -5.191805e-003, -5.181620e-003, -5.171445e-003, -5.161280e-003, -5.151125e-003, -5.140980e-003, -5.130845e-003, -5.120720e-003, -5.110605e-003, -5.100500e-003, -5.090405e-003, -5.080320e-003, -5.070245e-003, -5.060180e-003, -5.050125e-003, -5.040080e-003, -5.030045e-003, -5.020020e-003, -5.010005e-003, 
-5.000000e-003, -4.990005e-003, -4.980020e-003, -4.970045e-003, -4.960080e-003, -4.950125e-003, -4.940180e-003, -4.930245e-003, -4.920320e-003, -4.910405e-003, -4.900500e-003, -4.890605e-003, -4.880720e-003, -4.870845e-003, -4.860980e-003, -4.851125e-003, -4.841280e-003, -4.831445e-003, -4.821620e-003, -4.811805e-003, -4.802000e-003, -4.792205e-003, -4.782420e-003, -4.772645e-003, -4.762880e-003, -4.753125e-003, -4.743380e-003, -4.733645e-003, -4.723920e-003, -4.714205e-003, -4.704500e-003, -4.694805e-003, -4.685120e-003, -4.675445e-003, -4.665780e-003, -4.656125e-003, -4.646480e-003, -4.636845e-003, -4.627220e-003, -4.617605e-003, -4.608000e-003, -4.598405e-003, -4.588820e-003, -4.579245e-003, -4.569680e-003, -4.560125e-003, -4.550580e-003, -4.541045e-003, -4.531520e-003, -4.522005e-003, -4.512500e-003, -4.503005e-003, -4.493520e-003, -4.484045e-003, -4.474580e-003, -4.465125e-003, -4.455680e-003, -4.446245e-003, -4.436820e-003, -4.427405e-003, -4.418000e-003, -4.408605e-003, -4.399220e-003, -4.389845e-003, -4.380480e-003, -4.371125e-003, -4.361780e-003, -4.352445e-003, -4.343120e-003, -4.333805e-003, -4.324500e-003, -4.315205e-003, -4.305920e-003, -4.296645e-003, -4.287380e-003, -4.278125e-003, -4.268880e-003, -4.259645e-003, -4.250420e-003, -4.241205e-003, -4.232000e-003, -4.222805e-003, -4.213620e-003, -4.204445e-003, -4.195280e-003, -4.186125e-003, -4.176980e-003, -4.167845e-003, -4.158720e-003, -4.149605e-003, -4.140500e-003, -4.131405e-003, -4.122320e-003, -4.113245e-003, -4.104180e-003, -4.095125e-003, -4.086080e-003, -4.077045e-003, -4.068020e-003, -4.059005e-003, 
-4.050000e-003, -4.041005e-003, -4.032020e-003, -4.023045e-003, -4.014080e-003, -4.005125e-003, -3.996180e-003, -3.987245e-003, -3.978320e-003, -3.969405e-003, -3.960500e-003, -3.951605e-003, -3.942720e-003, -3.933845e-003, -3.924980e-003, -3.916125e-003, -3.907280e-003, -3.898445e-003, -3.889620e-003, -3.880805e-003, -3.872000e-003, -3.863205e-003, -3.854420e-003, -3.845645e-003, -3.836880e-003, -3.828125e-003, -3.819380e-003, -3.810645e-003, -3.801920e-003, -3.793205e-003, -3.784500e-003, -3.775805e-003, -3.767120e-003, -3.758445e-003, -3.749780e-003, -3.741125e-003, -3.732480e-003, -3.723845e-003, -3.715220e-003, -3.706605e-003, -3.698000e-003, -3.689405e-003, -3.680820e-003, -3.672245e-003, -3.663680e-003, -3.655125e-003, -3.646580e-003, -3.638045e-003, -3.629520e-003, -3.621005e-003, -3.612500e-003, -3.604005e-003, -3.595520e-003, -3.587045e-003, -3.578580e-003, -3.570125e-003, -3.561680e-003, -3.553245e-003, -3.544820e-003, -3.536405e-003, -3.528000e-003, -3.519605e-003, -3.511220e-003, -3.502845e-003, -3.494480e-003, -3.486125e-003, -3.477780e-003, -3.469445e-003, -3.461120e-003, -3.452805e-003, -3.444500e-003, -3.436205e-003, -3.427920e-003, -3.419645e-003, -3.411380e-003, -3.403125e-003, -3.394880e-003, -3.386645e-003, -3.378420e-003, -3.370205e-003, -3.362000e-003, -3.353805e-003, -3.345620e-003, -3.337445e-003, -3.329280e-003, -3.321125e-003, -3.312980e-003, -3.304845e-003, -3.296720e-003, -3.288605e-003, -3.280500e-003, -3.272405e-003, -3.264320e-003, -3.256245e-003, -3.248180e-003, -3.240125e-003, -3.232080e-003, -3.224045e-003, -3.216020e-003, -3.208005e-003, 
-3.200000e-003, -3.192005e-003, -3.184020e-003, -3.176045e-003, -3.168080e-003, -3.160125e-003, -3.152180e-003, -3.144245e-003, -3.136320e-003, -3.128405e-003, -3.120500e-003, -3.112605e-003, -3.104720e-003, -3.096845e-003, -3.088980e-003, -3.081125e-003, -3.073280e-003, -3.065445e-003, -3.057620e-003, -3.049805e-003, -3.042000e-003, -3.034205e-003, -3.026420e-003, -3.018645e-003, -3.010880e-003, -3.003125e-003, -2.995380e-003, -2.987645e-003, -2.979920e-003, -2.972205e-003, -2.964500e-003, -2.956805e-003, -2.949120e-003, -2.941445e-003, -2.933780e-003, -2.926125e-003, -2.918480e-003, -2.910845e-003, -2.903220e-003, -2.895605e-003, -2.888000e-003, -2.880405e-003, -2.872820e-003, -2.865245e-003, -2.857680e-003, -2.850125e-003, -2.842580e-003, -2.835045e-003, -2.827520e-003, -2.820005e-003, -2.812500e-003, -2.805005e-003, -2.797520e-003, -2.790045e-003, -2.782580e-003, -2.775125e-003, -2.767680e-003, -2.760245e-003, -2.752820e-003, -2.745405e-003, -2.738000e-003, -2.730605e-003, -2.723220e-003, -2.715845e-003, -2.708480e-003, -2.701125e-003, -2.693780e-003, -2.686445e-003, -2.679120e-003, -2.671805e-003, -2.664500e-003, -2.657205e-003, -2.649920e-003, -2.642645e-003, -2.635380e-003, -2.628125e-003, -2.620880e-003, -2.613645e-003, -2.606420e-003, -2.599205e-003, -2.592000e-003, -2.584805e-003, -2.577620e-003, -2.570445e-003, -2.563280e-003, -2.556125e-003, -2.548980e-003, -2.541845e-003, -2.534720e-003, -2.527605e-003, -2.520500e-003, -2.513405e-003, -2.506320e-003, -2.499245e-003, -2.492180e-003, -2.485125e-003, -2.478080e-003, -2.471045e-003, -2.464020e-003, -2.457005e-003, 
-2.450000e-003, -2.443005e-003, -2.436020e-003, -2.429045e-003, -2.422080e-003, -2.415125e-003, -2.408180e-003, -2.401245e-003, -2.394320e-003, -2.387405e-003, -2.380500e-003, -2.373605e-003, -2.366720e-003, -2.359845e-003, -2.352980e-003, -2.346125e-003, -2.339280e-003, -2.332445e-003, -2.325620e-003, -2.318805e-003, -2.312000e-003, -2.305205e-003, -2.298420e-003, -2.291645e-003, -2.284880e-003, -2.278125e-003, -2.271380e-003, -2.264645e-003, -2.257920e-003, -2.251205e-003, -2.244500e-003, -2.237805e-003, -2.231120e-003, -2.224445e-003, -2.217780e-003, -2.211125e-003, -2.204480e-003, -2.197845e-003, -2.191220e-003, -2.184605e-003, -2.178000e-003, -2.171405e-003, -2.164820e-003, -2.158245e-003, -2.151680e-003, -2.145125e-003, -2.138580e-003, -2.132045e-003, -2.125520e-003, -2.119005e-003, -2.112500e-003, -2.106005e-003, -2.099520e-003, -2.093045e-003, -2.086580e-003, -2.080125e-003, -2.073680e-003, -2.067245e-003, -2.060820e-003, -2.054405e-003, -2.048000e-003, -2.041605e-003, -2.035220e-003, -2.028845e-003, -2.022480e-003, -2.016125e-003, -2.009780e-003, -2.003445e-003, -1.997120e-003, -1.990805e-003, -1.984500e-003, -1.978205e-003, -1.971920e-003, -1.965645e-003, -1.959380e-003, -1.953125e-003, -1.946880e-003, -1.940645e-003, -1.934420e-003, -1.928205e-003, -1.922000e-003, -1.915805e-003, -1.909620e-003, -1.903445e-003, -1.897280e-003, -1.891125e-003, -1.884980e-003, -1.878845e-003, -1.872720e-003, -1.866605e-003, -1.860500e-003, -1.854405e-003, -1.848320e-003, -1.842245e-003, -1.836180e-003, -1.830125e-003, -1.824080e-003, -1.818045e-003, -1.812020e-003, -1.806005e-003, 
-1.800000e-003, -1.794005e-003, -1.788020e-003, -1.782045e-003, -1.776080e-003, -1.770125e-003, -1.764180e-003, -1.758245e-003, -1.752320e-003, -1.746405e-003, -1.740500e-003, -1.734605e-003, -1.728720e-003, -1.722845e-003, -1.716980e-003, -1.711125e-003, -1.705280e-003, -1.699445e-003, -1.693620e-003, -1.687805e-003, -1.682000e-003, -1.676205e-003, -1.670420e-003, -1.664645e-003, -1.658880e-003, -1.653125e-003, -1.647380e-003, -1.641645e-003, -1.635920e-003, -1.630205e-003, -1.624500e-003, -1.618805e-003, -1.613120e-003, -1.607445e-003, -1.601780e-003, -1.596125e-003, -1.590480e-003, -1.584845e-003, -1.579220e-003, -1.573605e-003, -1.568000e-003, -1.562405e-003, -1.556820e-003, -1.551245e-003, -1.545680e-003, -1.540125e-003, -1.534580e-003, -1.529045e-003, -1.523520e-003, -1.518005e-003, -1.512500e-003, -1.507005e-003, -1.501520e-003, -1.496045e-003, -1.490580e-003, -1.485125e-003, -1.479680e-003, -1.474245e-003, -1.468820e-003, -1.463405e-003, -1.458000e-003, -1.452605e-003, -1.447220e-003, -1.441845e-003, -1.436480e-003, -1.431125e-003, -1.425780e-003, -1.420445e-003, -1.415120e-003, -1.409805e-003, -1.404500e-003, -1.399205e-003, -1.393920e-003, -1.388645e-003, -1.383380e-003, -1.378125e-003, -1.372880e-003, -1.367645e-003, -1.362420e-003, -1.357205e-003, -1.352000e-003, -1.346805e-003, -1.341620e-003, -1.336445e-003, -1.331280e-003, -1.326125e-003, -1.320980e-003, -1.315845e-003, -1.310720e-003, -1.305605e-003, -1.300500e-003, -1.295405e-003, -1.290320e-003, -1.285245e-003, -1.280180e-003, -1.275125e-003, -1.270080e-003, -1.265045e-003, -1.260020e-003, -1.255005e-003, 
-1.250000e-003, -1.245005e-003, -1.240020e-003, -1.235045e-003, -1.230080e-003, -1.225125e-003, -1.220180e-003, -1.215245e-003, -1.210320e-003, -1.205405e-003, -1.200500e-003, -1.195605e-003, -1.190720e-003, -1.185845e-003, -1.180980e-003, -1.176125e-003, -1.171280e-003, -1.166445e-003, -1.161620e-003, -1.156805e-003, -1.152000e-003, -1.147205e-003, -1.142420e-003, -1.137645e-003, -1.132880e-003, -1.128125e-003, -1.123380e-003, -1.118645e-003, -1.113920e-003, -1.109205e-003, -1.104500e-003, -1.099805e-003, -1.095120e-003, -1.090445e-003, -1.085780e-003, -1.081125e-003, -1.076480e-003, -1.071845e-003, -1.067220e-003, -1.062605e-003, -1.058000e-003, -1.053405e-003, -1.048820e-003, -1.044245e-003, -1.039680e-003, -1.035125e-003, -1.030580e-003, -1.026045e-003, -1.021520e-003, -1.017005e-003, -1.012500e-003, -1.008005e-003, -1.003520e-003, -9.990450e-004, -9.945800e-004, -9.901250e-004, -9.856800e-004, -9.812450e-004, -9.768200e-004, -9.724050e-004, -9.680000e-004, -9.636050e-004, -9.592200e-004, -9.548450e-004, -9.504800e-004, -9.461250e-004, -9.417800e-004, -9.374450e-004, -9.331200e-004, -9.288050e-004, -9.245000e-004, -9.202050e-004, -9.159200e-004, -9.116450e-004, -9.073800e-004, -9.031250e-004, -8.988800e-004, -8.946450e-004, -8.904200e-004, -8.862050e-004, -8.820000e-004, -8.778050e-004, -8.736200e-004, -8.694450e-004, -8.652800e-004, -8.611250e-004, -8.569800e-004, -8.528450e-004, -8.487200e-004, -8.446050e-004, -8.405000e-004, -8.364050e-004, -8.323200e-004, -8.282450e-004, -8.241800e-004, -8.201250e-004, -8.160800e-004, -8.120450e-004, -8.080200e-004, -8.040050e-004, 
-8.000000e-004, -7.960050e-004, -7.920200e-004, -7.880450e-004, -7.840800e-004, -7.801250e-004, -7.761800e-004, -7.722450e-004, -7.683200e-004, -7.644050e-004, -7.605000e-004, -7.566050e-004, -7.527200e-004, -7.488450e-004, -7.449800e-004, -7.411250e-004, -7.372800e-004, -7.334450e-004, -7.296200e-004, -7.258050e-004, -7.220000e-004, -7.182050e-004, -7.144200e-004, -7.106450e-004, -7.068800e-004, -7.031250e-004, -6.993800e-004, -6.956450e-004, -6.919200e-004, -6.882050e-004, -6.845000e-004, -6.808050e-004, -6.771200e-004, -6.734450e-004, -6.697800e-004, -6.661250e-004, -6.624800e-004, -6.588450e-004, -6.552200e-004, -6.516050e-004, -6.480000e-004, -6.444050e-004, -6.408200e-004, -6.372450e-004, -6.336800e-004, -6.301250e-004, -6.265800e-004, -6.230450e-004, -6.195200e-004, -6.160050e-004, -6.125000e-004, -6.090050e-004, -6.055200e-004, -6.020450e-004, -5.985800e-004, -5.951250e-004, -5.916800e-004, -5.882450e-004, -5.848200e-004, -5.814050e-004, -5.780000e-004, -5.746050e-004, -5.712200e-004, -5.678450e-004, -5.644800e-004, -5.611250e-004, -5.577800e-004, -5.544450e-004, -5.511200e-004, -5.478050e-004, -5.445000e-004, -5.412050e-004, -5.379200e-004, -5.346450e-004, -5.313800e-004, -5.281250e-004, -5.248800e-004, -5.216450e-004, -5.184200e-004, -5.152050e-004, -5.120000e-004, -5.088050e-004, -5.056200e-004, -5.024450e-004, -4.992800e-004, -4.961250e-004, -4.929800e-004, -4.898450e-004, -4.867200e-004, -4.836050e-004, -4.805000e-004, -4.774050e-004, -4.743200e-004, -4.712450e-004, -4.681800e-004, -4.651250e-004, -4.620800e-004, -4.590450e-004, -4.560200e-004, -4.530050e-004, 
-4.500000e-004, -4.470050e-004, -4.440200e-004, -4.410450e-004, -4.380800e-004, -4.351250e-004, -4.321800e-004, -4.292450e-004, -4.263200e-004, -4.234050e-004, -4.205000e-004, -4.176050e-004, -4.147200e-004, -4.118450e-004, -4.089800e-004, -4.061250e-004, -4.032800e-004, -4.004450e-004, -3.976200e-004, -3.948050e-004, -3.920000e-004, -3.892050e-004, -3.864200e-004, -3.836450e-004, -3.808800e-004, -3.781250e-004, -3.753800e-004, -3.726450e-004, -3.699200e-004, -3.672050e-004, -3.645000e-004, -3.618050e-004, -3.591200e-004, -3.564450e-004, -3.537800e-004, -3.511250e-004, -3.484800e-004, -3.458450e-004, -3.432200e-004, -3.406050e-004, -3.380000e-004, -3.354050e-004, -3.328200e-004, -3.302450e-004, -3.276800e-004, -3.251250e-004, -3.225800e-004, -3.200450e-004, -3.175200e-004, -3.150050e-004, -3.125000e-004, -3.100050e-004, -3.075200e-004, -3.050450e-004, -3.025800e-004, -3.001250e-004, -2.976800e-004, -2.952450e-004, -2.928200e-004, -2.904050e-004, -2.880000e-004, -2.856050e-004, -2.832200e-004, -2.808450e-004, -2.784800e-004, -2.761250e-004, -2.737800e-004, -2.714450e-004, -2.691200e-004, -2.668050e-004, -2.645000e-004, -2.622050e-004, -2.599200e-004, -2.576450e-004, -2.553800e-004, -2.531250e-004, -2.508800e-004, -2.486450e-004, -2.464200e-004, -2.442050e-004, -2.420000e-004, -2.398050e-004, -2.376200e-004, -2.354450e-004, -2.332800e-004, -2.311250e-004, -2.289800e-004, -2.268450e-004, -2.247200e-004, -2.226050e-004, -2.205000e-004, -2.184050e-004, -2.163200e-004, -2.142450e-004, -2.121800e-004, -2.101250e-004, -2.080800e-004, -2.060450e-004, -2.040200e-004, -2.020050e-004, 
-2.000000e-004, -1.980050e-004, -1.960200e-004, -1.940450e-004, -1.920800e-004, -1.901250e-004, -1.881800e-004, -1.862450e-004, -1.843200e-004, -1.824050e-004, -1.805000e-004, -1.786050e-004, -1.767200e-004, -1.748450e-004, -1.729800e-004, -1.711250e-004, -1.692800e-004, -1.674450e-004, -1.656200e-004, -1.638050e-004, -1.620000e-004, -1.602050e-004, -1.584200e-004, -1.566450e-004, -1.548800e-004, -1.531250e-004, -1.513800e-004, -1.496450e-004, -1.479200e-004, -1.462050e-004, -1.445000e-004, -1.428050e-004, -1.411200e-004, -1.394450e-004, -1.377800e-004, -1.361250e-004, -1.344800e-004, -1.328450e-004, -1.312200e-004, -1.296050e-004, -1.280000e-004, -1.264050e-004, -1.248200e-004, -1.232450e-004, -1.216800e-004, -1.201250e-004, -1.185800e-004, -1.170450e-004, -1.155200e-004, -1.140050e-004, -1.125000e-004, -1.110050e-004, -1.095200e-004, -1.080450e-004, -1.065800e-004, -1.051250e-004, -1.036800e-004, -1.022450e-004, -1.008200e-004, -9.940500e-005, -9.800000e-005, -9.660500e-005, -9.522000e-005, -9.384500e-005, -9.248000e-005, -9.112500e-005, -8.978000e-005, -8.844500e-005, -8.712000e-005, -8.580500e-005, -8.450000e-005, -8.320500e-005, -8.192000e-005, -8.064500e-005, -7.938000e-005, -7.812500e-005, -7.688000e-005, -7.564500e-005, -7.442000e-005, -7.320500e-005, -7.200000e-005, -7.080500e-005, -6.962000e-005, -6.844500e-005, -6.728000e-005, -6.612500e-005, -6.498000e-005, -6.384500e-005, -6.272000e-005, -6.160500e-005, -6.050000e-005, -5.940500e-005, -5.832000e-005, -5.724500e-005, -5.618000e-005, -5.512500e-005, -5.408000e-005, -5.304500e-005, -5.202000e-005, -5.100500e-005, 
-5.000000e-005, -4.900500e-005, -4.802000e-005, -4.704500e-005, -4.608000e-005, -4.512500e-005, -4.418000e-005, -4.324500e-005, -4.232000e-005, -4.140500e-005, -4.050000e-005, -3.960500e-005, -3.872000e-005, -3.784500e-005, -3.698000e-005, -3.612500e-005, -3.528000e-005, -3.444500e-005, -3.362000e-005, -3.280500e-005, -3.200000e-005, -3.120500e-005, -3.042000e-005, -2.964500e-005, -2.888000e-005, -2.812500e-005, -2.738000e-005, -2.664500e-005, -2.592000e-005, -2.520500e-005, -2.450000e-005, -2.380500e-005, -2.312000e-005, -2.244500e-005, -2.178000e-005, -2.112500e-005, -2.048000e-005, -1.984500e-005, -1.922000e-005, -1.860500e-005, -1.800000e-005, -1.740500e-005, -1.682000e-005, -1.624500e-005, -1.568000e-005, -1.512500e-005, -1.458000e-005, -1.404500e-005, -1.352000e-005, -1.300500e-005, -1.250000e-005, -1.200500e-005, -1.152000e-005, -1.104500e-005, -1.058000e-005, -1.012500e-005, -9.680000e-006, -9.245000e-006, -8.820000e-006, -8.405000e-006, -8.000000e-006, -7.605000e-006, -7.220000e-006, -6.845000e-006, -6.480000e-006, -6.125000e-006, -5.780000e-006, -5.445000e-006, -5.120000e-006, -4.805000e-006, -4.500000e-006, -4.205000e-006, -3.920000e-006, -3.645000e-006, -3.380000e-006, -3.125000e-006, -2.880000e-006, -2.645000e-006, -2.420000e-006, -2.205000e-006, -2.000000e-006, -1.805000e-006, -1.620000e-006, -1.445000e-006, -1.280000e-006, -1.125000e-006, -9.800000e-007, -8.450000e-007, -7.200000e-007, -6.050000e-007, -5.000000e-007, -4.050000e-007, -3.200000e-007, -2.450000e-007, -1.800000e-007, -1.250000e-007, -8.000000e-008, -4.500000e-008, -2.000000e-008, -5.000000e-009, 
0.000000e+000, 0.000000e+000
},
{
0.000000e+000, -1.999850e-004, -3.999400e-004, -5.998650e-004, -7.997600e-004, -9.996250e-004, -1.199460e-003, -1.399265e-003, -1.599040e-003, -1.798785e-003, -1.998500e-003, -2.198185e-003, -2.397840e-003, -2.597465e-003, -2.797060e-003, -2.996625e-003, -3.196160e-003, -3.395665e-003, -3.595140e-003, -3.794585e-003, -3.994000e-003, -4.193385e-003, -4.392740e-003, -4.592065e-003, -4.791360e-003, -4.990625e-003, -5.189860e-003, -5.389065e-003, -5.588240e-003, -5.787385e-003, -5.986500e-003, -6.185585e-003, -6.384640e-003, -6.583665e-003, -6.782660e-003, -6.981625e-003, -7.180560e-003, -7.379465e-003, -7.578340e-003, -7.777185e-003, -7.976000e-003, -8.174785e-003, -8.373540e-003, -8.572265e-003, -8.770960e-003, -8.969625e-003, -9.168260e-003, -9.366865e-003, -9.565440e-003, -9.763985e-003, -9.962500e-003, -1.016099e-002, -1.035944e-002, -1.055787e-002, -1.075626e-002, -1.095463e-002, -1.115296e-002, -1.135126e-002, -1.154954e-002, -1.174779e-002, -1.194600e-002, -1.214419e-002, -1.234234e-002, -1.254047e-002, -1.273856e-002, -1.293663e-002, -1.313466e-002, -1.333267e-002, -1.353064e-002, -1.372859e-002, -1.392650e-002, -1.412438e-002, -1.432224e-002, -1.452006e-002, -1.471786e-002, -1.491563e-002, -1.511336e-002, -1.531107e-002, -1.550874e-002, -1.570639e-002, -1.590400e-002, -1.610158e-002, -1.629914e-002, -1.649666e-002, -1.669416e-002, -1.689163e-002, -1.708906e-002, -1.728646e-002, -1.748384e-002, -1.768119e-002, -1.787850e-002, -1.807579e-002, -1.827304e-002, -1.847027e-002, -1.866746e-002, -1.886462e-002, -1.906176e-002, -1.925887e-002, -1.945594e-002, -1.965299e-002, 
-1.985000e-002, -2.004699e-002, -2.024394e-002, -2.044086e-002, -2.063776e-002, -2.083462e-002, -2.103146e-002, -2.122826e-002, -2.142504e-002, -2.162179e-002, -2.181850e-002, -2.201519e-002, -2.221184e-002, -2.240846e-002, -2.260506e-002, -2.280163e-002, -2.299816e-002, -2.319467e-002, -2.339114e-002, -2.358759e-002, -2.378400e-002, -2.398038e-002, -2.417674e-002, -2.437306e-002, -2.456936e-002, -2.476563e-002, -2.496186e-002, -2.515806e-002, -2.535424e-002, -2.555038e-002, -2.574650e-002, -2.594259e-002, -2.613864e-002, -2.633466e-002, -2.653066e-002, -2.672663e-002, -2.692256e-002, -2.711846e-002, -2.731434e-002, -2.751019e-002, -2.770600e-002, -2.790178e-002, -2.809754e-002, -2.829327e-002, -2.848896e-002, -2.868463e-002, -2.888026e-002, -2.907587e-002, -2.927144e-002, -2.946699e-002, -2.966250e-002, -2.985799e-002, -3.005344e-002, -3.024887e-002, -3.044426e-002, -3.063963e-002, -3.083496e-002, -3.103026e-002, -3.122554e-002, -3.142079e-002, -3.161600e-002, -3.181118e-002, -3.200634e-002, -3.220146e-002, -3.239656e-002, -3.259163e-002, -3.278666e-002, -3.298167e-002, -3.317664e-002, -3.337158e-002, -3.356650e-002, -3.376138e-002, -3.395624e-002, -3.415107e-002, -3.434586e-002, -3.454063e-002, -3.473536e-002, -3.493007e-002, -3.512474e-002, -3.531939e-002, -3.551400e-002, -3.570859e-002, -3.590314e-002, -3.609767e-002, -3.629216e-002, -3.648662e-002, -3.668106e-002, -3.687547e-002, -3.706984e-002, -3.726418e-002, -3.745850e-002, -3.765279e-002, -3.784704e-002, -3.804127e-002, -3.823546e-002, -3.842963e-002, -3.862376e-002, -3.881787e-002, -3.901194e-002, -3.920599e-002, 
-3.940000e-002, -3.959398e-002, -3.978794e-002, -3.998186e-002, -4.017576e-002, -4.036962e-002, -4.056346e-002, -4.075727e-002, -4.095104e-002, -4.114478e-002, -4.133850e-002, -4.153218e-002, -4.172584e-002, -4.191946e-002, -4.211306e-002, -4.230663e-002, -4.250016e-002, -4.269366e-002, -4.288714e-002, -4.308058e-002, -4.327400e-002, -4.346738e-002, -4.366074e-002, -4.385406e-002, -4.404736e-002, -4.424063e-002, -4.443386e-002, -4.462707e-002, -4.482024e-002, -4.501338e-002, -4.520650e-002, -4.539958e-002, -4.559264e-002, -4.578567e-002, -4.597866e-002, -4.617163e-002, -4.636456e-002, -4.655746e-002, -4.675034e-002, -4.694318e-002, -4.713600e-002, -4.732879e-002, -4.752154e-002, -4.771426e-002, -4.790696e-002, -4.809963e-002, -4.829226e-002, -4.848486e-002, -4.867744e-002, -4.886998e-002, -4.906250e-002, -4.925499e-002, -4.944744e-002, -4.963986e-002, -4.983226e-002, -5.002462e-002, -5.021696e-002, -5.040927e-002, -5.060154e-002, -5.079379e-002, -5.098600e-002, -5.117819e-002, -5.137034e-002, -5.156247e-002, -5.175456e-002, -5.194663e-002, -5.213866e-002, -5.233066e-002, -5.252264e-002, -5.271459e-002, -5.290650e-002, -5.309838e-002, -5.329024e-002, -5.348207e-002, -5.367386e-002, -5.386563e-002, -5.405736e-002, -5.424906e-002, -5.444074e-002, -5.463238e-002, -5.482400e-002, -5.501558e-002, -5.520714e-002, -5.539867e-002, -5.559016e-002, -5.578163e-002, -5.597306e-002, -5.616446e-002, -5.635584e-002, -5.654719e-002, -5.673850e-002, -5.692979e-002, -5.712104e-002, -5.731227e-002, -5.750346e-002, -5.769462e-002, -5.788576e-002, -5.807686e-002, -5.826794e-002, -5.845898e-002, 
-5.865000e-002, -5.884098e-002, -5.903194e-002, -5.922287e-002, -5.941376e-002, -5.960462e-002, -5.979546e-002, -5.998627e-002, -6.017704e-002, -6.036779e-002, -6.055850e-002, -6.074918e-002, -6.093984e-002, -6.113047e-002, -6.132106e-002, -6.151163e-002, -6.170216e-002, -6.189266e-002, -6.208314e-002, -6.227358e-002, -6.246400e-002, -6.265438e-002, -6.284474e-002, -6.303507e-002, -6.322536e-002, -6.341563e-002, -6.360586e-002, -6.379606e-002, -6.398624e-002, -6.417638e-002, -6.436650e-002, -6.455659e-002, -6.474664e-002, -6.493667e-002, -6.512666e-002, -6.531663e-002, -6.550656e-002, -6.569646e-002, -6.588634e-002, -6.607618e-002, -6.626600e-002, -6.645579e-002, -6.664554e-002, -6.683526e-002, -6.702496e-002, -6.721463e-002, -6.740426e-002, -6.759387e-002, -6.778344e-002, -6.797299e-002, -6.816250e-002, -6.835199e-002, -6.854144e-002, -6.873086e-002, -6.892026e-002, -6.910962e-002, -6.929896e-002, -6.948827e-002, -6.967754e-002, -6.986679e-002, -7.005600e-002, -7.024519e-002, -7.043434e-002, -7.062346e-002, -7.081256e-002, -7.100162e-002, -7.119066e-002, -7.137966e-002, -7.156864e-002, -7.175758e-002, -7.194650e-002, -7.213539e-002, -7.232424e-002, -7.251307e-002, -7.270186e-002, -7.289063e-002, -7.307936e-002, -7.326806e-002, -7.345674e-002, -7.364539e-002, -7.383400e-002, -7.402259e-002, -7.421114e-002, -7.439967e-002, -7.458816e-002, -7.477662e-002, -7.496506e-002, -7.515346e-002, -7.534184e-002, -7.553019e-002, -7.571850e-002, -7.590679e-002, -7.609504e-002, -7.628327e-002, -7.647146e-002, -7.665962e-002, -7.684776e-002, -7.703586e-002, -7.722394e-002, -7.741199e-002, 
-7.760000e-002, -7.778798e-002, -7.797594e-002, -7.816387e-002, -7.835176e-002, -7.853963e-002, -7.872746e-002, -7.891526e-002, -7.910304e-002, -7.929079e-002, -7.947850e-002, -7.966618e-002, -7.985384e-002, -8.004147e-002, -8.022906e-002, -8.041663e-002, -8.060416e-002, -8.079166e-002, -8.097914e-002, -8.116658e-002, -8.135400e-002, -8.154138e-002, -8.172874e-002, -8.191606e-002, -8.210336e-002, -8.229063e-002, -8.247786e-002, -8.266506e-002, -8.285224e-002, -8.303939e-002, -8.322650e-002, -8.341358e-002, -8.360064e-002, -8.378766e-002, -8.397466e-002, -8.416163e-002, -8.434856e-002, -8.453546e-002, -8.472234e-002, -8.490918e-002, -8.509600e-002, -8.528279e-002, -8.546954e-002, -8.565626e-002, -8.584296e-002, -8.602962e-002, -8.621626e-002, -8.640286e-002, -8.658944e-002, -8.677599e-002, -8.696250e-002, -8.714898e-002, -8.733544e-002, -8.752186e-002, -8.770826e-002, -8.789463e-002, -8.808096e-002, -8.826726e-002, -8.845354e-002, -8.863979e-002, -8.882600e-002, -8.901219e-002, -8.919834e-002, -8.938447e-002, -8.957056e-002, -8.975663e-002, -8.994266e-002, -9.012866e-002, -9.031464e-002, -9.050059e-002, -9.068650e-002, -9.087239e-002, -9.105824e-002, -9.124406e-002, -9.142986e-002, -9.161563e-002, -9.180136e-002, -9.198706e-002, -9.217274e-002, -9.235839e-002, -9.254400e-002, -9.272958e-002, -9.291514e-002, -9.310067e-002, -9.328616e-002, -9.347163e-002, -9.365706e-002, -9.384247e-002, -9.402784e-002, -9.421318e-002, -9.439850e-002, -9.458378e-002, -9.476904e-002, -9.495426e-002, -9.513946e-002, -9.532463e-002, -9.550976e-002, -9.569487e-002, -9.587994e-002, -9.606498e-002, 
-9.625000e-002, -9.643498e-002, -9.661994e-002, -9.680486e-002, -9.698976e-002, -9.717463e-002, -9.735946e-002, -9.754427e-002, -9.772904e-002, -9.791378e-002, -9.809850e-002, -9.828318e-002, -9.846784e-002, -9.865246e-002, -9.883706e-002, -9.902163e-002, -9.920616e-002, -9.939067e-002, -9.957514e-002, -9.975958e-002, -9.994400e-002, -1.001284e-001, -1.003127e-001, -1.004971e-001, -1.006814e-001, -1.008656e-001, -1.010499e-001, -1.012341e-001, -1.014182e-001, -1.016024e-001, -1.017865e-001, -1.019706e-001, -1.021546e-001, -1.023387e-001, -1.025227e-001, -1.027066e-001, -1.028906e-001, -1.030745e-001, -1.032583e-001, -1.034422e-001, -1.036260e-001, -1.038098e-001, -1.039935e-001, -1.041773e-001, -1.043610e-001, -1.045446e-001, -1.047283e-001, -1.049119e-001, -1.050954e-001, -1.052790e-001, -1.054625e-001, -1.056460e-001, -1.058294e-001, -1.060129e-001, -1.061963e-001, -1.063796e-001, -1.065630e-001, -1.067463e-001, -1.069295e-001, -1.071128e-001, -1.072960e-001, -1.074792e-001, -1.076623e-001, -1.078455e-001, -1.080286e-001, -1.082116e-001, -1.083947e-001, -1.085777e-001, -1.087606e-001, -1.089436e-001, -1.091265e-001, -1.093094e-001, -1.094922e-001, -1.096751e-001, -1.098579e-001, -1.100406e-001, -1.102234e-001, -1.104061e-001, -1.105887e-001, -1.107714e-001, -1.109540e-001, -1.111366e-001, -1.113191e-001, -1.115017e-001, -1.116842e-001, -1.118666e-001, -1.120491e-001, -1.122315e-001, -1.124138e-001, -1.125962e-001, -1.127785e-001, -1.129608e-001, -1.131430e-001, -1.133253e-001, -1.135075e-001, -1.136896e-001, -1.138718e-001, -1.140539e-001, -1.142359e-001, -1.144180e-001, 
-1.146000e-001, -1.147820e-001, -1.149639e-001, -1.151459e-001, -1.153278e-001, -1.155096e-001, -1.156915e-001, -1.158733e-001, -1.160550e-001, -1.162368e-001, -1.164185e-001, -1.166002e-001, -1.167818e-001, -1.169635e-001, -1.171451e-001, -1.173266e-001, -1.175082e-001, -1.176897e-001, -1.178711e-001, -1.180526e-001, -1.182340e-001, -1.184154e-001, -1.185967e-001, -1.187781e-001, -1.189594e-001, -1.191406e-001, -1.193219e-001, -1.195031e-001, -1.196842e-001, -1.198654e-001, -1.200465e-001, -1.202276e-001, -1.204086e-001, -1.205897e-001, -1.207707e-001, -1.209516e-001, -1.211326e-001, -1.213135e-001, -1.214943e-001, -1.216752e-001, -1.218560e-001, -1.220368e-001, -1.222175e-001, -1.223983e-001, -1.225790e-001, -1.227596e-001, -1.229403e-001, -1.231209e-001, -1.233014e-001, -1.234820e-001, -1.236625e-001, -1.238430e-001, -1.240234e-001, -1.242039e-001, -1.243843e-001, -1.245646e-001, -1.247450e-001, -1.249253e-001, -1.251055e-001, -1.252858e-001, -1.254660e-001, -1.256462e-001, -1.258263e-001, -1.260065e-001, -1.261866e-001, -1.263666e-001, -1.265467e-001, -1.267267e-001, -1.269066e-001, -1.270866e-001, -1.272665e-001, -1.274464e-001, -1.276262e-001, -1.278061e-001, -1.279859e-001, -1.281656e-001, -1.283454e-001, -1.285251e-001, -1.287047e-001, -1.288844e-001, -1.290640e-001, -1.292436e-001, -1.294231e-001, -1.296027e-001, -1.297822e-001, -1.299616e-001, -1.301411e-001, -1.303205e-001, -1.304998e-001, -1.306792e-001, -1.308585e-001, -1.310378e-001, -1.312170e-001, -1.313963e-001, -1.315755e-001, -1.317546e-001, -1.319338e-001, -1.321129e-001, -1.322919e-001, -1.324710e-001, 
-1.326500e-001, -1.328290e-001, -1.330079e-001, -1.331869e-001, -1.333658e-001, -1.335446e-001, -1.337235e-001, -1.339023e-001, -1.340810e-001, -1.342598e-001, -1.344385e-001, -1.346172e-001, -1.347958e-001, -1.349745e-001, -1.351531e-001, -1.353316e-001, -1.355102e-001, -1.356887e-001, -1.358671e-001, -1.360456e-001, -1.362240e-001, -1.364024e-001, -1.365807e-001, -1.367591e-001, -1.369374e-001, -1.371156e-001, -1.372939e-001, -1.374721e-001, -1.376502e-001, -1.378284e-001, -1.380065e-001, -1.381846e-001, -1.383626e-001, -1.385407e-001, -1.387187e-001, -1.388966e-001, -1.390746e-001, -1.392525e-001, -1.394303e-001, -1.396082e-001, -1.397860e-001, -1.399638e-001, -1.401415e-001, -1.403193e-001, -1.404970e-001, -1.406746e-001, -1.408523e-001, -1.410299e-001, -1.412074e-001, -1.413850e-001, -1.415625e-001, -1.417400e-001, -1.419174e-001, -1.420949e-001, -1.422723e-001, -1.424496e-001, -1.426270e-001, -1.428043e-001, -1.429815e-001, -1.431588e-001, -1.433360e-001, -1.435132e-001, -1.436903e-001, -1.438675e-001, -1.440446e-001, -1.442216e-001, -1.443987e-001, -1.445757e-001, -1.447526e-001, -1.449296e-001, -1.451065e-001, -1.452834e-001, -1.454602e-001, -1.456371e-001, -1.458139e-001, -1.459906e-001, -1.461674e-001, -1.463441e-001, -1.465207e-001, -1.466974e-001, -1.468740e-001, -1.470506e-001, -1.472271e-001, -1.474037e-001, -1.475802e-001, -1.477566e-001, -1.479331e-001, -1.481095e-001, -1.482858e-001, -1.484622e-001, -1.486385e-001, -1.488148e-001, -1.489910e-001, -1.491673e-001, -1.493435e-001, -1.495196e-001, -1.496958e-001, -1.498719e-001, -1.500479e-001, -1.502240e-001, 
-1.504000e-001, -1.505760e-001, -1.507519e-001, -1.509279e-001, -1.511038e-001, -1.512796e-001, -1.514555e-001, -1.516313e-001, -1.518070e-001, -1.519828e-001, -1.521585e-001, -1.523342e-001, -1.525098e-001, -1.526855e-001, -1.528611e-001, -1.530366e-001, -1.532122e-001, -1.533877e-001, -1.535631e-001, -1.537386e-001, -1.539140e-001, -1.540894e-001, -1.542647e-001, -1.544401e-001, -1.546154e-001, -1.547906e-001, -1.549659e-001, -1.551411e-001, -1.553162e-001, -1.554914e-001, -1.556665e-001, -1.558416e-001, -1.560166e-001, -1.561917e-001, -1.563667e-001, -1.565416e-001, -1.567166e-001, -1.568915e-001, -1.570663e-001, -1.572412e-001, -1.574160e-001, -1.575908e-001, -1.577655e-001, -1.579403e-001, -1.581150e-001, -1.582896e-001, -1.584643e-001, -1.586389e-001, -1.588134e-001, -1.589880e-001, -1.591625e-001, -1.593370e-001, -1.595114e-001, -1.596859e-001, -1.598603e-001, -1.600346e-001, -1.602090e-001, -1.603833e-001, -1.605575e-001, -1.607318e-001, -1.609060e-001, -1.610802e-001, -1.612543e-001, -1.614285e-001, -1.616026e-001, -1.617766e-001, -1.619507e-001, -1.621247e-001, -1.622986e-001, -1.624726e-001, -1.626465e-001, -1.628204e-001, -1.629942e-001, -1.631681e-001, -1.633419e-001, -1.635156e-001, -1.636894e-001, -1.638631e-001, -1.640367e-001, -1.642104e-001, -1.643840e-001, -1.645576e-001, -1.647311e-001, -1.649047e-001, -1.650782e-001, -1.652516e-001, -1.654251e-001, -1.655985e-001, -1.657718e-001, -1.659452e-001, -1.661185e-001, -1.662918e-001, -1.664650e-001, -1.666383e-001, -1.668115e-001, -1.669846e-001, -1.671578e-001, -1.673309e-001, -1.675039e-001, -1.676770e-001, 
-1.678500e-001, -1.680230e-001, -1.681959e-001, -1.683689e-001, -1.685418e-001, -1.687146e-001, -1.688875e-001, -1.690603e-001, -1.692330e-001, -1.694058e-001, -1.695785e-001, -1.697512e-001, -1.699238e-001, -1.700965e-001, -1.702691e-001, -1.704416e-001, -1.706142e-001, -1.707867e-001, -1.709591e-001, -1.711316e-001, -1.713040e-001, -1.714764e-001, -1.716487e-001, -1.718211e-001, -1.719934e-001, -1.721656e-001, -1.723379e-001, -1.725101e-001, -1.726822e-001, -1.728544e-001, -1.730265e-001, -1.731986e-001, -1.733706e-001, -1.735427e-001, -1.737147e-001, -1.738866e-001, -1.740586e-001, -1.742305e-001, -1.744023e-001, -1.745742e-001, -1.747460e-001, -1.749178e-001, -1.750895e-001, -1.752613e-001, -1.754330e-001, -1.756046e-001, -1.757763e-001, -1.759479e-001, -1.761194e-001, -1.762910e-001, -1.764625e-001, -1.766340e-001, -1.768054e-001, -1.769769e-001, -1.771483e-001, -1.773196e-001, -1.774910e-001, -1.776623e-001, -1.778335e-001, -1.780048e-001, -1.781760e-001, -1.783472e-001, -1.785183e-001, -1.786895e-001, -1.788606e-001, -1.790316e-001, -1.792027e-001, -1.793737e-001, -1.795446e-001, -1.797156e-001, -1.798865e-001, -1.800574e-001, -1.802282e-001, -1.803991e-001, -1.805699e-001, -1.807406e-001, -1.809114e-001, -1.810821e-001, -1.812527e-001, -1.814234e-001, -1.815940e-001, -1.817646e-001, -1.819351e-001, -1.821057e-001, -1.822762e-001, -1.824466e-001, -1.826171e-001, -1.827875e-001, -1.829578e-001, -1.831282e-001, -1.832985e-001, -1.834688e-001, -1.836390e-001, -1.838093e-001, -1.839795e-001, -1.841496e-001, -1.843198e-001, -1.844899e-001, -1.846599e-001, -1.848300e-001, 
-1.850000e-001, -1.851700e-001, -1.853399e-001, -1.855099e-001, -1.856798e-001, -1.858496e-001, -1.860195e-001, -1.861893e-001, -1.863590e-001, -1.865288e-001, -1.866985e-001, -1.868682e-001, -1.870378e-001, -1.872075e-001, -1.873771e-001, -1.875466e-001, -1.877162e-001, -1.878857e-001, -1.880551e-001, -1.882246e-001, -1.883940e-001, -1.885634e-001, -1.887327e-001, -1.889021e-001, -1.890714e-001, -1.892406e-001, -1.894099e-001, -1.895791e-001, -1.897482e-001, -1.899174e-001, -1.900865e-001, -1.902556e-001, -1.904246e-001, -1.905937e-001, -1.907627e-001, -1.909316e-001, -1.911006e-001, -1.912695e-001, -1.914383e-001, -1.916072e-001, -1.917760e-001, -1.919448e-001, -1.921135e-001, -1.922823e-001, -1.924510e-001, -1.926196e-001, -1.927883e-001, -1.929569e-001, -1.931254e-001, -1.932940e-001, -1.934625e-001, -1.936310e-001, -1.937994e-001, -1.939679e-001, -1.941363e-001, -1.943046e-001, -1.944730e-001, -1.946413e-001, -1.948095e-001, -1.949778e-001, -1.951460e-001, -1.953142e-001, -1.954823e-001, -1.956505e-001, -1.958186e-001, -1.959866e-001, -1.961547e-001, -1.963227e-001, -1.964906e-001, -1.966586e-001, -1.968265e-001, -1.969944e-001, -1.971622e-001, -1.973301e-001, -1.974979e-001, -1.976656e-001, -1.978334e-001, -1.980011e-001, -1.981687e-001, -1.983364e-001, -1.985040e-001, -1.986716e-001, -1.988391e-001, -1.990067e-001, -1.991742e-001, -1.993416e-001, -1.995091e-001, -1.996765e-001, -1.998438e-001, -2.000112e-001, -2.001785e-001, -2.003458e-001, -2.005130e-001, -2.006803e-001, -2.008475e-001, -2.010146e-001, -2.011818e-001, -2.013489e-001, -2.015159e-001, -2.016830e-001, 
-2.018500e-001, -2.020170e-001, -2.021839e-001, -2.023509e-001, -2.025178e-001, -2.026846e-001, -2.028515e-001, -2.030183e-001, -2.031850e-001, -2.033518e-001, -2.035185e-001, -2.036852e-001, -2.038518e-001, -2.040185e-001, -2.041851e-001, -2.043516e-001, -2.045182e-001, -2.046847e-001, -2.048511e-001, -2.050176e-001, -2.051840e-001, -2.053504e-001, -2.055167e-001, -2.056831e-001, -2.058494e-001, -2.060156e-001, -2.061819e-001, -2.063481e-001, -2.065142e-001, -2.066804e-001, -2.068465e-001, -2.070126e-001, -2.071786e-001, -2.073447e-001, -2.075107e-001, -2.076766e-001, -2.078426e-001, -2.080085e-001, -2.081743e-001, -2.083402e-001, -2.085060e-001, -2.086718e-001, -2.088375e-001, -2.090033e-001, -2.091690e-001, -2.093346e-001, -2.095003e-001, -2.096659e-001, -2.098314e-001, -2.099970e-001, -2.101625e-001, -2.103280e-001, -2.104934e-001, -2.106589e-001, -2.108243e-001, -2.109896e-001, -2.111550e-001, -2.113203e-001, -2.114855e-001, -2.116508e-001, -2.118160e-001, -2.119812e-001, -2.121463e-001, -2.123115e-001, -2.124766e-001, -2.126416e-001, -2.128067e-001, -2.129717e-001, -2.131366e-001, -2.133016e-001, -2.134665e-001, -2.136314e-001, -2.137962e-001, -2.139611e-001, -2.141259e-001, -2.142906e-001, -2.144554e-001, -2.146201e-001, -2.147847e-001, -2.149494e-001, -2.151140e-001, -2.152786e-001, -2.154431e-001, -2.156077e-001, -2.157722e-001, -2.159366e-001, -2.161011e-001, -2.162655e-001, -2.164298e-001, -2.165942e-001, -2.167585e-001, -2.169228e-001, -2.170870e-001, -2.172513e-001, -2.174155e-001, -2.175796e-001, -2.177438e-001, -2.179079e-001, -2.180719e-001, -2.182360e-001, 
-2.184000e-001, -2.185640e-001, -2.187279e-001, -2.188919e-001, -2.190558e-001, -2.192196e-001, -2.193835e-001, -2.195473e-001, -2.197110e-001, -2.198748e-001, -2.200385e-001, -2.202022e-001, -2.203658e-001, -2.205295e-001, -2.206931e-001, -2.208566e-001, -2.210202e-001, -2.211837e-001, -2.213471e-001, -2.215106e-001, -2.216740e-001, -2.218374e-001, -2.220007e-001, -2.221641e-001, -2.223274e-001, -2.224906e-001, -2.226539e-001, -2.228171e-001, -2.229802e-001, -2.231434e-001, -2.233065e-001, -2.234696e-001, -2.236326e-001, -2.237957e-001, -2.239587e-001, -2.241216e-001, -2.242846e-001, -2.244475e-001, -2.246103e-001, -2.247732e-001, -2.249360e-001, -2.250988e-001, -2.252615e-001, -2.254243e-001, -2.255870e-001, -2.257496e-001, -2.259123e-001, -2.260749e-001, -2.262374e-001, -2.264000e-001, -2.265625e-001, -2.267250e-001, -2.268874e-001, -2.270499e-001, -2.272123e-001, -2.273746e-001, -2.275370e-001, -2.276993e-001, -2.278615e-001, -2.280238e-001, -2.281860e-001, -2.283482e-001, -2.285103e-001, -2.286725e-001, -2.288346e-001, -2.289966e-001, -2.291587e-001, -2.293207e-001, -2.294826e-001, -2.296446e-001, -2.298065e-001, -2.299684e-001, -2.301302e-001, -2.302921e-001, -2.304539e-001, -2.306156e-001, -2.307774e-001, -2.309391e-001, -2.311007e-001, -2.312624e-001, -2.314240e-001, -2.315856e-001, -2.317471e-001, -2.319087e-001, -2.320702e-001, -2.322316e-001, -2.323931e-001, -2.325545e-001, -2.327158e-001, -2.328772e-001, -2.330385e-001, -2.331998e-001, -2.333610e-001, -2.335223e-001, -2.336835e-001, -2.338446e-001, -2.340058e-001, -2.341669e-001, -2.343279e-001, -2.344890e-001, 
-2.346500e-001, -2.348110e-001, -2.349719e-001, -2.351329e-001, -2.352938e-001, -2.354546e-001, -2.356155e-001, -2.357763e-001, -2.359370e-001, -2.360978e-001, -2.362585e-001, -2.364192e-001, -2.365798e-001, -2.367405e-001, -2.369011e-001, -2.370616e-001, -2.372222e-001, -2.373827e-001, -2.375431e-001, -2.377036e-001, -2.378640e-001, -2.380244e-001, -2.381847e-001, -2.383451e-001, -2.385054e-001, -2.386656e-001, -2.388259e-001, -2.389861e-001, -2.391462e-001, -2.393064e-001, -2.394665e-001, -2.396266e-001, -2.397866e-001, -2.399467e-001, -2.401067e-001, -2.402666e-001, -2.404266e-001, -2.405865e-001, -2.407463e-001, -2.409062e-001, -2.410660e-001, -2.412258e-001, -2.413855e-001, -2.415453e-001, -2.417050e-001, -2.418646e-001, -2.420243e-001, -2.421839e-001, -2.423434e-001, -2.425030e-001, -2.426625e-001, -2.428220e-001, -2.429814e-001, -2.431409e-001, -2.433003e-001, -2.434596e-001, -2.436190e-001, -2.437783e-001, -2.439375e-001, -2.440968e-001, -2.442560e-001, -2.444152e-001, -2.445743e-001, -2.447335e-001, -2.448926e-001, -2.450516e-001, -2.452107e-001, -2.453697e-001, -2.455286e-001, -2.456876e-001, -2.458465e-001, -2.460054e-001, -2.461642e-001, -2.463231e-001, -2.464819e-001, -2.466406e-001, -2.467994e-001, -2.469581e-001, -2.471167e-001, -2.472754e-001, -2.474340e-001, -2.475926e-001, -2.477511e-001, -2.479097e-001, -2.480682e-001, -2.482266e-001, -2.483851e-001, -2.485435e-001, -2.487018e-001, -2.488602e-001, -2.490185e-001, -2.491768e-001, -2.493350e-001, -2.494933e-001, -2.496515e-001, -2.498096e-001, -2.499678e-001, -2.501259e-001, -2.502839e-001, -2.504420e-001, 
-2.506000e-001, -2.507580e-001, -2.509159e-001, -2.510739e-001, -2.512318e-001, -2.513896e-001, -2.515475e-001, -2.517053e-001, -2.518630e-001, -2.520208e-001, -2.521785e-001, -2.523362e-001, -2.524938e-001, -2.526515e-001, -2.528091e-001, -2.529666e-001, -2.531242e-001, -2.532817e-001, -2.534391e-001, -2.535966e-001, -2.537540e-001, -2.539114e-001, -2.540687e-001, -2.542261e-001, -2.543834e-001, -2.545406e-001, -2.546979e-001, -2.548551e-001, -2.550122e-001, -2.551694e-001, -2.553265e-001, -2.554836e-001, -2.556406e-001, -2.557977e-001, -2.559547e-001, -2.561116e-001, -2.562686e-001, -2.564255e-001, -2.565823e-001, -2.567392e-001, -2.568960e-001, -2.570528e-001, -2.572095e-001, -2.573663e-001, -2.575230e-001, -2.576796e-001, -2.578363e-001, -2.579929e-001, -2.581494e-001, -2.583060e-001, -2.584625e-001, -2.586190e-001, -2.587754e-001, -2.589319e-001, -2.590883e-001, -2.592446e-001, -2.594010e-001, -2.595573e-001, -2.597135e-001, -2.598698e-001, -2.600260e-001, -2.601822e-001, -2.603383e-001, -2.604945e-001, -2.606506e-001, -2.608066e-001, -2.609627e-001, -2.611187e-001, -2.612746e-001, -2.614306e-001, -2.615865e-001, -2.617424e-001, -2.618982e-001, -2.620541e-001, -2.622099e-001, -2.623656e-001, -2.625214e-001, -2.626771e-001, -2.628327e-001, -2.629884e-001, -2.631440e-001, -2.632996e-001, -2.634551e-001, -2.636107e-001, -2.637662e-001, -2.639216e-001, -2.640771e-001, -2.642325e-001, -2.643878e-001, -2.645432e-001, -2.646985e-001, -2.648538e-001, -2.650090e-001, -2.651643e-001, -2.653195e-001, -2.654746e-001, -2.656298e-001, -2.657849e-001, -2.659399e-001, -2.660950e-001, 
-2.662500e-001, -2.664050e-001, -2.665599e-001, -2.667149e-001, -2.668698e-001, -2.670246e-001, -2.671795e-001, -2.673343e-001, -2.674890e-001, -2.676438e-001, -2.677985e-001, -2.679532e-001, -2.681078e-001, -2.682625e-001, -2.684171e-001, -2.685716e-001, -2.687262e-001, -2.688807e-001, -2.690351e-001, -2.691896e-001, -2.693440e-001, -2.694984e-001, -2.696527e-001, -2.698071e-001, -2.699614e-001, -2.701156e-001, -2.702699e-001, -2.704241e-001, -2.705782e-001, -2.707324e-001, -2.708865e-001, -2.710406e-001, -2.711946e-001, -2.713487e-001, -2.715027e-001, -2.716566e-001, -2.718106e-001, -2.719645e-001, -2.721183e-001, -2.722722e-001, -2.724260e-001, -2.725798e-001, -2.727335e-001, -2.728873e-001, -2.730410e-001, -2.731946e-001, -2.733483e-001, -2.735019e-001, -2.736554e-001, -2.738090e-001, -2.739625e-001, -2.741160e-001, -2.742694e-001, -2.744229e-001, -2.745763e-001, -2.747296e-001, -2.748830e-001, -2.750363e-001, -2.751895e-001, -2.753428e-001, -2.754960e-001, -2.756492e-001, -2.758023e-001, -2.759555e-001, -2.761086e-001, -2.762616e-001, -2.764147e-001, -2.765677e-001, -2.767206e-001, -2.768736e-001, -2.770265e-001, -2.771794e-001, -2.773322e-001, -2.774851e-001, -2.776379e-001, -2.777906e-001, -2.779434e-001, -2.780961e-001, -2.782487e-001, -2.784014e-001, -2.785540e-001, -2.787066e-001, -2.788591e-001, -2.790117e-001, -2.791642e-001, -2.793166e-001, -2.794691e-001, -2.796215e-001, -2.797738e-001, -2.799262e-001, -2.800785e-001, -2.802308e-001, -2.803830e-001, -2.805353e-001, -2.806875e-001, -2.808396e-001, -2.809918e-001, -2.811439e-001, -2.812959e-001, -2.814480e-001, 
-2.816000e-001, -2.817520e-001, -2.819039e-001, -2.820559e-001, -2.822078e-001, -2.823596e-001, -2.825115e-001, -2.826633e-001, -2.828150e-001, -2.829668e-001, -2.831185e-001, -2.832702e-001, -2.834218e-001, -2.835735e-001, -2.837251e-001, -2.838766e-001, -2.840282e-001, -2.841797e-001, -2.843311e-001, -2.844826e-001, -2.846340e-001, -2.847854e-001, -2.849367e-001, -2.850881e-001, -2.852394e-001, -2.853906e-001, -2.855419e-001, -2.856931e-001, -2.858442e-001, -2.859954e-001, -2.861465e-001, -2.862976e-001, -2.864486e-001, -2.865997e-001, -2.867507e-001, -2.869016e-001, -2.870526e-001, -2.872035e-001, -2.873543e-001, -2.875052e-001, -2.876560e-001, -2.878068e-001, -2.879575e-001, -2.881083e-001, -2.882590e-001, -2.884096e-001, -2.885603e-001, -2.887109e-001, -2.888614e-001, -2.890120e-001, -2.891625e-001, -2.893130e-001, -2.894634e-001, -2.896139e-001, -2.897643e-001, -2.899146e-001, -2.900650e-001, -2.902153e-001, -2.903655e-001, -2.905158e-001, -2.906660e-001, -2.908162e-001, -2.909663e-001, -2.911165e-001, -2.912666e-001, -2.914166e-001, -2.915667e-001, -2.917167e-001, -2.918666e-001, -2.920166e-001, -2.921665e-001, -2.923164e-001, -2.924662e-001, -2.926161e-001, -2.927659e-001, -2.929156e-001, -2.930654e-001, -2.932151e-001, -2.933647e-001, -2.935144e-001, -2.936640e-001, -2.938136e-001, -2.939631e-001, -2.941127e-001, -2.942622e-001, -2.944116e-001, -2.945611e-001, -2.947105e-001, -2.948598e-001, -2.950092e-001, -2.951585e-001, -2.953078e-001, -2.954570e-001, -2.956063e-001, -2.957555e-001, -2.959046e-001, -2.960538e-001, -2.962029e-001, -2.963519e-001, -2.965010e-001, 
-2.966500e-001, -2.967990e-001, -2.969479e-001, -2.970969e-001, -2.972458e-001, -2.973946e-001, -2.975435e-001, -2.976923e-001, -2.978410e-001, -2.979898e-001, -2.981385e-001, -2.982872e-001, -2.984358e-001, -2.985845e-001, -2.987331e-001, -2.988816e-001, -2.990302e-001, -2.991787e-001, -2.993271e-001, -2.994756e-001, -2.996240e-001, -2.997724e-001, -2.999207e-001, -3.000691e-001, -3.002174e-001, -3.003656e-001, -3.005139e-001, -3.006621e-001, -3.008102e-001, -3.009584e-001, -3.011065e-001, -3.012546e-001, -3.014026e-001, -3.015507e-001, -3.016987e-001, -3.018466e-001, -3.019946e-001, -3.021425e-001, -3.022903e-001, -3.024382e-001, -3.025860e-001, -3.027338e-001, -3.028815e-001, -3.030293e-001, -3.031770e-001, -3.033246e-001, -3.034723e-001, -3.036199e-001, -3.037674e-001, -3.039150e-001, -3.040625e-001, -3.042100e-001, -3.043574e-001, -3.045049e-001, -3.046523e-001, -3.047996e-001, -3.049470e-001, -3.050943e-001, -3.052415e-001, -3.053888e-001, -3.055360e-001, -3.056832e-001, -3.058303e-001, -3.059775e-001, -3.061246e-001, -3.062716e-001, -3.064187e-001, -3.065657e-001, -3.067126e-001, -3.068596e-001, -3.070065e-001, -3.071534e-001, -3.073002e-001, -3.074471e-001, -3.075939e-001, -3.077406e-001, -3.078874e-001, -3.080341e-001, -3.081807e-001, -3.083274e-001, -3.084740e-001, -3.086206e-001, -3.087671e-001, -3.089137e-001, -3.090602e-001, -3.092066e-001, -3.093531e-001, -3.094995e-001, -3.096458e-001, -3.097922e-001, -3.099385e-001, -3.100848e-001, -3.102310e-001, -3.103773e-001, -3.105235e-001, -3.106696e-001, -3.108158e-001, -3.109619e-001, -3.111079e-001, -3.112540e-001, 
-3.114000e-001, -3.115460e-001, -3.116919e-001, -3.118379e-001, -3.119838e-001, -3.121296e-001, -3.122755e-001, -3.124213e-001, -3.125670e-001, -3.127128e-001, -3.128585e-001, -3.130042e-001, -3.131498e-001, -3.132955e-001, -3.134411e-001, -3.135866e-001, -3.137322e-001, -3.138777e-001, -3.140231e-001, -3.141686e-001, -3.143140e-001, -3.144594e-001, -3.146047e-001, -3.147501e-001, -3.148954e-001, -3.150406e-001, -3.151859e-001, -3.153311e-001, -3.154762e-001, -3.156214e-001, -3.157665e-001, -3.159116e-001, -3.160566e-001, -3.162017e-001, -3.163467e-001, -3.164916e-001, -3.166366e-001, -3.167815e-001, -3.169263e-001, -3.170712e-001, -3.172160e-001, -3.173608e-001, -3.175055e-001, -3.176503e-001, -3.177950e-001, -3.179396e-001, -3.180843e-001, -3.182289e-001, -3.183734e-001, -3.185180e-001, -3.186625e-001, -3.188070e-001, -3.189514e-001, -3.190959e-001, -3.192403e-001, -3.193846e-001, -3.195290e-001, -3.196733e-001, -3.198175e-001, -3.199618e-001, -3.201060e-001, -3.202502e-001, -3.203943e-001, -3.205385e-001, -3.206826e-001, -3.208266e-001, -3.209707e-001, -3.211147e-001, -3.212586e-001, -3.214026e-001, -3.215465e-001, -3.216904e-001, -3.218342e-001, -3.219781e-001, -3.221219e-001, -3.222656e-001, -3.224094e-001, -3.225531e-001, -3.226967e-001, -3.228404e-001, -3.229840e-001, -3.231276e-001, -3.232711e-001, -3.234147e-001, -3.235582e-001, -3.237016e-001, -3.238451e-001, -3.239885e-001, -3.241318e-001, -3.242752e-001, -3.244185e-001, -3.245618e-001, -3.247050e-001, -3.248483e-001, -3.249915e-001, -3.251346e-001, -3.252778e-001, -3.254209e-001, -3.255639e-001, -3.257070e-001, 
-3.258500e-001, -3.259930e-001, -3.261359e-001, -3.262789e-001, -3.264218e-001, -3.265646e-001, -3.267075e-001, -3.268503e-001, -3.269930e-001, -3.271358e-001, -3.272785e-001, -3.274212e-001, -3.275638e-001, -3.277065e-001, -3.278491e-001, -3.279916e-001, -3.281342e-001, -3.282767e-001, -3.284191e-001, -3.285616e-001, -3.287040e-001, -3.288464e-001, -3.289887e-001, -3.291311e-001, -3.292734e-001, -3.294156e-001, -3.295579e-001, -3.297001e-001, -3.298422e-001, -3.299844e-001, -3.301265e-001, -3.302686e-001, -3.304106e-001, -3.305527e-001, -3.306947e-001, -3.308366e-001, -3.309786e-001, -3.311205e-001, -3.312623e-001, -3.314042e-001, -3.315460e-001, -3.316878e-001, -3.318295e-001, -3.319713e-001, -3.321130e-001, -3.322546e-001, -3.323963e-001, -3.325379e-001, -3.326794e-001, -3.328210e-001, -3.329625e-001, -3.331040e-001, -3.332454e-001, -3.333869e-001, -3.335283e-001, -3.336696e-001, -3.338110e-001, -3.339523e-001, -3.340935e-001, -3.342348e-001, -3.343760e-001, -3.345172e-001, -3.346583e-001, -3.347995e-001, -3.349406e-001, -3.350816e-001, -3.352227e-001, -3.353637e-001, -3.355046e-001, -3.356456e-001, -3.357865e-001, -3.359274e-001, -3.360682e-001, -3.362091e-001, -3.363499e-001, -3.364906e-001, -3.366314e-001, -3.367721e-001, -3.369127e-001, -3.370534e-001, -3.371940e-001, -3.373346e-001, -3.374751e-001, -3.376157e-001, -3.377562e-001, -3.378966e-001, -3.380371e-001, -3.381775e-001, -3.383178e-001, -3.384582e-001, -3.385985e-001, -3.387388e-001, -3.388790e-001, -3.390193e-001, -3.391595e-001, -3.392996e-001, -3.394398e-001, -3.395799e-001, -3.397199e-001, -3.398600e-001, 
-3.400000e-001, -3.401400e-001, -3.402799e-001, -3.404199e-001, -3.405598e-001, -3.406996e-001, -3.408395e-001, -3.409793e-001, -3.411190e-001, -3.412588e-001, -3.413985e-001, -3.415382e-001, -3.416778e-001, -3.418175e-001, -3.419571e-001, -3.420966e-001, -3.422362e-001, -3.423757e-001, -3.425151e-001, -3.426546e-001, -3.427940e-001, -3.429334e-001, -3.430727e-001, -3.432121e-001, -3.433514e-001, -3.434906e-001, -3.436299e-001, -3.437691e-001, -3.439082e-001, -3.440474e-001, -3.441865e-001, -3.443256e-001, -3.444646e-001, -3.446037e-001, -3.447427e-001, -3.448816e-001, -3.450206e-001, -3.451595e-001, -3.452983e-001, -3.454372e-001, -3.455760e-001, -3.457148e-001, -3.458535e-001, -3.459923e-001, -3.461310e-001, -3.462696e-001, -3.464083e-001, -3.465469e-001, -3.466854e-001, -3.468240e-001, -3.469625e-001, -3.471010e-001, -3.472394e-001, -3.473779e-001, -3.475163e-001, -3.476546e-001, -3.477930e-001, -3.479313e-001, -3.480695e-001, -3.482078e-001, -3.483460e-001, -3.484842e-001, -3.486223e-001, -3.487605e-001, -3.488986e-001, -3.490366e-001, -3.491747e-001, -3.493127e-001, -3.494506e-001, -3.495886e-001, -3.497265e-001, -3.498644e-001, -3.500022e-001, -3.501401e-001, -3.502779e-001, -3.504156e-001, -3.505534e-001, -3.506911e-001, -3.508287e-001, -3.509664e-001, -3.511040e-001, -3.512416e-001, -3.513791e-001, -3.515167e-001, -3.516542e-001, -3.517916e-001, -3.519291e-001, -3.520665e-001, -3.522038e-001, -3.523412e-001, -3.524785e-001, -3.526158e-001, -3.527530e-001, -3.528903e-001, -3.530275e-001, -3.531646e-001, -3.533018e-001, -3.534389e-001, -3.535759e-001, -3.537130e-001, 
-3.538500e-001, -3.539870e-001, -3.541239e-001, -3.542609e-001, -3.543978e-001, -3.545346e-001, -3.546715e-001, -3.548083e-001, -3.549450e-001, -3.550818e-001, -3.552185e-001, -3.553552e-001, -3.554918e-001, -3.556285e-001, -3.557651e-001, -3.559016e-001, -3.560382e-001, -3.561747e-001, -3.563111e-001, -3.564476e-001, -3.565840e-001, -3.567204e-001, -3.568567e-001, -3.569931e-001, -3.571294e-001, -3.572656e-001, -3.574019e-001, -3.575381e-001, -3.576742e-001, -3.578104e-001, -3.579465e-001, -3.580826e-001, -3.582186e-001, -3.583547e-001, -3.584907e-001, -3.586266e-001, -3.587626e-001, -3.588985e-001, -3.590343e-001, -3.591702e-001, -3.593060e-001, -3.594418e-001, -3.595775e-001, -3.597133e-001, -3.598490e-001, -3.599846e-001, -3.601203e-001, -3.602559e-001, -3.603914e-001, -3.605270e-001, -3.606625e-001, -3.607980e-001, -3.609334e-001, -3.610689e-001, -3.612043e-001, -3.613396e-001, -3.614750e-001, -3.616103e-001, -3.617455e-001, -3.618808e-001, -3.620160e-001, -3.621512e-001, -3.622863e-001, -3.624215e-001, -3.625566e-001, -3.626916e-001, -3.628267e-001, -3.629617e-001, -3.630966e-001, -3.632316e-001, -3.633665e-001, -3.635014e-001, -3.636362e-001, -3.637711e-001, -3.639059e-001, -3.640406e-001, -3.641754e-001, -3.643101e-001, -3.644447e-001, -3.645794e-001, -3.647140e-001, -3.648486e-001, -3.649831e-001, -3.651177e-001, -3.652522e-001, -3.653866e-001, -3.655211e-001, -3.656555e-001, -3.657898e-001, -3.659242e-001, -3.660585e-001, -3.661928e-001, -3.663270e-001, -3.664613e-001, -3.665955e-001, -3.667296e-001, -3.668638e-001, -3.669979e-001, -3.671319e-001, -3.672660e-001, 
-3.674000e-001, -3.675340e-001, -3.676679e-001, -3.678019e-001, -3.679358e-001, -3.680696e-001, -3.682035e-001, -3.683373e-001, -3.684710e-001, -3.686048e-001, -3.687385e-001, -3.688722e-001, -3.690058e-001, -3.691395e-001, -3.692731e-001, -3.694066e-001, -3.695402e-001, -3.696737e-001, -3.698071e-001, -3.699406e-001, -3.700740e-001, -3.702074e-001, -3.703407e-001, -3.704741e-001, -3.706074e-001, -3.707406e-001, -3.708739e-001, -3.710071e-001, -3.711402e-001, -3.712734e-001, -3.714065e-001, -3.715396e-001, -3.716726e-001, -3.718057e-001, -3.719387e-001, -3.720716e-001, -3.722046e-001, -3.723375e-001, -3.724703e-001, -3.726032e-001, -3.727360e-001, -3.728688e-001, -3.730015e-001, -3.731343e-001, -3.732670e-001, -3.733996e-001, -3.735323e-001, -3.736649e-001, -3.737974e-001, -3.739300e-001, -3.740625e-001, -3.741950e-001, -3.743274e-001, -3.744599e-001, -3.745923e-001, -3.747246e-001, -3.748570e-001, -3.749893e-001, -3.751215e-001, -3.752538e-001, -3.753860e-001, -3.755182e-001, -3.756503e-001, -3.757825e-001, -3.759146e-001, -3.760466e-001, -3.761787e-001, -3.763107e-001, -3.764426e-001, -3.765746e-001, -3.767065e-001, -3.768384e-001, -3.769702e-001, -3.771021e-001, -3.772339e-001, -3.773656e-001, -3.774974e-001, -3.776291e-001, -3.777607e-001, -3.778924e-001, -3.780240e-001, -3.781556e-001, -3.782871e-001, -3.784187e-001, -3.785502e-001, -3.786816e-001, -3.788131e-001, -3.789445e-001, -3.790758e-001, -3.792072e-001, -3.793385e-001, -3.794698e-001, -3.796010e-001, -3.797323e-001, -3.798635e-001, -3.799946e-001, -3.801258e-001, -3.802569e-001, -3.803879e-001, -3.805190e-001, 
-3.806500e-001, -3.807810e-001, -3.809119e-001, -3.810429e-001, -3.811738e-001, -3.813046e-001, -3.814355e-001, -3.815663e-001, -3.816970e-001, -3.818278e-001, -3.819585e-001, -3.820892e-001, -3.822198e-001, -3.823505e-001, -3.824811e-001, -3.826116e-001, -3.827422e-001, -3.828727e-001, -3.830031e-001, -3.831336e-001, -3.832640e-001, -3.833944e-001, -3.835247e-001, -3.836551e-001, -3.837854e-001, -3.839156e-001, -3.840459e-001, -3.841761e-001, -3.843062e-001, -3.844364e-001, -3.845665e-001, -3.846966e-001, -3.848266e-001, -3.849567e-001, -3.850867e-001, -3.852166e-001, -3.853466e-001, -3.854765e-001, -3.856063e-001, -3.857362e-001, -3.858660e-001, -3.859958e-001, -3.861255e-001, -3.862553e-001, -3.863850e-001, -3.865146e-001, -3.866443e-001, -3.867739e-001, -3.869034e-001, -3.870330e-001, -3.871625e-001, -3.872920e-001, -3.874214e-001, -3.875509e-001, -3.876803e-001, -3.878096e-001, -3.879390e-001, -3.880683e-001, -3.881975e-001, -3.883268e-001, -3.884560e-001, -3.885852e-001, -3.887143e-001, -3.888435e-001, -3.889726e-001, -3.891016e-001, -3.892307e-001, -3.893597e-001, -3.894886e-001, -3.896176e-001, -3.897465e-001, -3.898754e-001, -3.900042e-001, -3.901331e-001, -3.902619e-001, -3.903906e-001, -3.905194e-001, -3.906481e-001, -3.907767e-001, -3.909054e-001, -3.910340e-001, -3.911626e-001, -3.912911e-001, -3.914197e-001, -3.915482e-001, -3.916766e-001, -3.918051e-001, -3.919335e-001, -3.920618e-001, -3.921902e-001, -3.923185e-001, -3.924468e-001, -3.925750e-001, -3.927033e-001, -3.928315e-001, -3.929596e-001, -3.930878e-001, -3.932159e-001, -3.933439e-001, -3.934720e-001, 
-3.936000e-001, -3.937280e-001, -3.938559e-001, -3.939839e-001, -3.941118e-001, -3.942396e-001, -3.943675e-001, -3.944953e-001, -3.946230e-001, -3.947508e-001, -3.948785e-001, -3.950062e-001, -3.951338e-001, -3.952615e-001, -3.953891e-001, -3.955166e-001, -3.956442e-001, -3.957717e-001, -3.958991e-001, -3.960266e-001, -3.961540e-001, -3.962814e-001, -3.964087e-001, -3.965361e-001, -3.966634e-001, -3.967906e-001, -3.969179e-001, -3.970451e-001, -3.971722e-001, -3.972994e-001, -3.974265e-001, -3.975536e-001, -3.976806e-001, -3.978077e-001, -3.979347e-001, -3.980616e-001, -3.981886e-001, -3.983155e-001, -3.984423e-001, -3.985692e-001, -3.986960e-001, -3.988228e-001, -3.989495e-001, -3.990763e-001, -3.992030e-001, -3.993296e-001, -3.994563e-001, -3.995829e-001, -3.997094e-001, -3.998360e-001, -3.999625e-001, -4.000890e-001, -4.002154e-001, -4.003419e-001, -4.004683e-001, -4.005946e-001, -4.007210e-001, -4.008473e-001, -4.009735e-001, -4.010998e-001, -4.012260e-001, -4.013522e-001, -4.014783e-001, -4.016045e-001, -4.017306e-001, -4.018566e-001, -4.019827e-001, -4.021087e-001, -4.022346e-001, -4.023606e-001, -4.024865e-001, -4.026124e-001, -4.027382e-001, -4.028641e-001, -4.029899e-001, -4.031156e-001, -4.032414e-001, -4.033671e-001, -4.034927e-001, -4.036184e-001, -4.037440e-001, -4.038696e-001, -4.039951e-001, -4.041207e-001, -4.042462e-001, -4.043716e-001, -4.044971e-001, -4.046225e-001, -4.047478e-001, -4.048732e-001, -4.049985e-001, -4.051238e-001, -4.052490e-001, -4.053743e-001, -4.054995e-001, -4.056246e-001, -4.057498e-001, -4.058749e-001, -4.059999e-001, -4.061250e-001, 
-4.062500e-001, -4.063750e-001, -4.064999e-001, -4.066249e-001, -4.067498e-001, -4.068746e-001, -4.069995e-001, -4.071243e-001, -4.072490e-001, -4.073738e-001, -4.074985e-001, -4.076232e-001, -4.077478e-001, -4.078725e-001, -4.079971e-001, -4.081216e-001, -4.082462e-001, -4.083707e-001, -4.084951e-001, -4.086196e-001, -4.087440e-001, -4.088684e-001, -4.089927e-001, -4.091171e-001, -4.092414e-001, -4.093656e-001, -4.094899e-001, -4.096141e-001, -4.097382e-001, -4.098624e-001, -4.099865e-001, -4.101106e-001, -4.102346e-001, -4.103587e-001, -4.104827e-001, -4.106066e-001, -4.107306e-001, -4.108545e-001, -4.109783e-001, -4.111022e-001, -4.112260e-001, -4.113498e-001, -4.114735e-001, -4.115973e-001, -4.117210e-001, -4.118446e-001, -4.119683e-001, -4.120919e-001, -4.122154e-001, -4.123390e-001, -4.124625e-001, -4.125860e-001, -4.127094e-001, -4.128329e-001, -4.129563e-001, -4.130796e-001, -4.132030e-001, -4.133263e-001, -4.134495e-001, -4.135728e-001, -4.136960e-001, -4.138192e-001, -4.139423e-001, -4.140655e-001, -4.141886e-001, -4.143116e-001, -4.144347e-001, -4.145577e-001, -4.146806e-001, -4.148036e-001, -4.149265e-001, -4.150494e-001, -4.151722e-001, -4.152951e-001, -4.154179e-001, -4.155406e-001, -4.156634e-001, -4.157861e-001, -4.159087e-001, -4.160314e-001, -4.161540e-001, -4.162766e-001, -4.163991e-001, -4.165217e-001, -4.166442e-001, -4.167666e-001, -4.168891e-001, -4.170115e-001, -4.171338e-001, -4.172562e-001, -4.173785e-001, -4.175008e-001, -4.176230e-001, -4.177453e-001, -4.178675e-001, -4.179896e-001, -4.181118e-001, -4.182339e-001, -4.183559e-001, -4.184780e-001, 
-4.186000e-001, -4.187220e-001, -4.188439e-001, -4.189659e-001, -4.190878e-001, -4.192096e-001, -4.193315e-001, -4.194533e-001, -4.195750e-001, -4.196968e-001, -4.198185e-001, -4.199402e-001, -4.200618e-001, -4.201835e-001, -4.203051e-001, -4.204266e-001, -4.205482e-001, -4.206697e-001, -4.207911e-001, -4.209126e-001, -4.210340e-001, -4.211554e-001, -4.212767e-001, -4.213981e-001, -4.215194e-001, -4.216406e-001, -4.217619e-001, -4.218831e-001, -4.220042e-001, -4.221254e-001, -4.222465e-001, -4.223676e-001, -4.224886e-001, -4.226097e-001, -4.227307e-001, -4.228516e-001, -4.229726e-001, -4.230935e-001, -4.232143e-001, -4.233352e-001, -4.234560e-001, -4.235768e-001, -4.236975e-001, -4.238183e-001, -4.239390e-001, -4.240596e-001, -4.241803e-001, -4.243009e-001, -4.244214e-001, -4.245420e-001, -4.246625e-001, -4.247830e-001, -4.249034e-001, -4.250239e-001, -4.251443e-001, -4.252646e-001, -4.253850e-001, -4.255053e-001, -4.256255e-001, -4.257458e-001, -4.258660e-001, -4.259862e-001, -4.261063e-001, -4.262265e-001, -4.263466e-001, -4.264666e-001, -4.265867e-001, -4.267067e-001, -4.268266e-001, -4.269466e-001, -4.270665e-001, -4.271864e-001, -4.273062e-001, -4.274261e-001, -4.275459e-001, -4.276656e-001, -4.277854e-001, -4.279051e-001, -4.280247e-001, -4.281444e-001, -4.282640e-001, -4.283836e-001, -4.285031e-001, -4.286227e-001, -4.287422e-001, -4.288616e-001, -4.289811e-001, -4.291005e-001, -4.292198e-001, -4.293392e-001, -4.294585e-001, -4.295778e-001, -4.296970e-001, -4.298163e-001, -4.299355e-001, -4.300546e-001, -4.301738e-001, -4.302929e-001, -4.304119e-001, -4.305310e-001, 
-4.306500e-001, -4.307690e-001, -4.308879e-001, -4.310069e-001, -4.311258e-001, -4.312446e-001, -4.313635e-001, -4.314823e-001, -4.316010e-001, -4.317198e-001, -4.318385e-001, -4.319572e-001, -4.320758e-001, -4.321945e-001, -4.323131e-001, -4.324316e-001, -4.325502e-001, -4.326687e-001, -4.327871e-001, -4.329056e-001, -4.330240e-001, -4.331424e-001, -4.332607e-001, -4.333791e-001, -4.334974e-001, -4.336156e-001, -4.337339e-001, -4.338521e-001, -4.339702e-001, -4.340884e-001, -4.342065e-001, -4.343246e-001, -4.344426e-001, -4.345607e-001, -4.346787e-001, -4.347966e-001, -4.349146e-001, -4.350325e-001, -4.351503e-001, -4.352682e-001, -4.353860e-001, -4.355038e-001, -4.356215e-001, -4.357393e-001, -4.358570e-001, -4.359746e-001, -4.360923e-001, -4.362099e-001, -4.363274e-001, -4.364450e-001, -4.365625e-001, -4.366800e-001, -4.367974e-001, -4.369149e-001, -4.370323e-001, -4.371496e-001, -4.372670e-001, -4.373843e-001, -4.375015e-001, -4.376188e-001, -4.377360e-001, -4.378532e-001, -4.379703e-001, -4.380875e-001, -4.382046e-001, -4.383216e-001, -4.384387e-001, -4.385557e-001, -4.386726e-001, -4.387896e-001, -4.389065e-001, -4.390234e-001, -4.391402e-001, -4.392571e-001, -4.393739e-001, -4.394906e-001, -4.396074e-001, -4.397241e-001, -4.398407e-001, -4.399574e-001, -4.400740e-001, -4.401906e-001, -4.403071e-001, -4.404237e-001, -4.405402e-001, -4.406566e-001, -4.407731e-001, -4.408895e-001, -4.410058e-001, -4.411222e-001, -4.412385e-001, -4.413548e-001, -4.414710e-001, -4.415873e-001, -4.417035e-001, -4.418196e-001, -4.419358e-001, -4.420519e-001, -4.421679e-001, -4.422840e-001, 
-4.424000e-001, -4.425160e-001, -4.426319e-001, -4.427479e-001, -4.428638e-001, -4.429796e-001, -4.430955e-001, -4.432113e-001, -4.433270e-001, -4.434428e-001, -4.435585e-001, -4.436742e-001, -4.437898e-001, -4.439055e-001, -4.440211e-001, -4.441366e-001, -4.442522e-001, -4.443677e-001, -4.444831e-001, -4.445986e-001, -4.447140e-001, -4.448294e-001, -4.449447e-001, -4.450601e-001, -4.451754e-001, -4.452906e-001, -4.454059e-001, -4.455211e-001, -4.456362e-001, -4.457514e-001, -4.458665e-001, -4.459816e-001, -4.460966e-001, -4.462117e-001, -4.463267e-001, -4.464416e-001, -4.465566e-001, -4.466715e-001, -4.467863e-001, -4.469012e-001, -4.470160e-001, -4.471308e-001, -4.472455e-001, -4.473603e-001, -4.474750e-001, -4.475896e-001, -4.477043e-001, -4.478189e-001, -4.479334e-001, -4.480480e-001, -4.481625e-001, -4.482770e-001, -4.483914e-001, -4.485059e-001, -4.486203e-001, -4.487346e-001, -4.488490e-001, -4.489633e-001, -4.490775e-001, -4.491918e-001, -4.493060e-001, -4.494202e-001, -4.495343e-001, -4.496485e-001, -4.497626e-001, -4.498766e-001, -4.499907e-001, -4.501047e-001, -4.502186e-001, -4.503326e-001, -4.504465e-001, -4.505604e-001, -4.506742e-001, -4.507881e-001, -4.509019e-001, -4.510156e-001, -4.511294e-001, -4.512431e-001, -4.513567e-001, -4.514704e-001, -4.515840e-001, -4.516976e-001, -4.518111e-001, -4.519247e-001, -4.520382e-001, -4.521516e-001, -4.522651e-001, -4.523785e-001, -4.524918e-001, -4.526052e-001, -4.527185e-001, -4.528318e-001, -4.529450e-001, -4.530583e-001, -4.531715e-001, -4.532846e-001, -4.533978e-001, -4.535109e-001, -4.536239e-001, -4.537370e-001, 
-4.538500e-001, -4.539630e-001, -4.540759e-001, -4.541889e-001, -4.543018e-001, -4.544146e-001, -4.545275e-001, -4.546403e-001, -4.547530e-001, -4.548658e-001, -4.549785e-001, -4.550912e-001, -4.552038e-001, -4.553165e-001, -4.554291e-001, -4.555416e-001, -4.556542e-001, -4.557667e-001, -4.558791e-001, -4.559916e-001, -4.561040e-001, -4.562164e-001, -4.563287e-001, -4.564411e-001, -4.565534e-001, -4.566656e-001, -4.567779e-001, -4.568901e-001, -4.570022e-001, -4.571144e-001, -4.572265e-001, -4.573386e-001, -4.574506e-001, -4.575627e-001, -4.576747e-001, -4.577866e-001, -4.578986e-001, -4.580105e-001, -4.581223e-001, -4.582342e-001, -4.583460e-001, -4.584578e-001, -4.585695e-001, -4.586813e-001, -4.587930e-001, -4.589046e-001, -4.590163e-001, -4.591279e-001, -4.592394e-001, -4.593510e-001, -4.594625e-001, -4.595740e-001, -4.596854e-001, -4.597969e-001, -4.599083e-001, -4.600196e-001, -4.601310e-001, -4.602423e-001, -4.603535e-001, -4.604648e-001, -4.605760e-001, -4.606872e-001, -4.607983e-001, -4.609095e-001, -4.610206e-001, -4.611316e-001, -4.612427e-001, -4.613537e-001, -4.614646e-001, -4.615756e-001, -4.616865e-001, -4.617974e-001, -4.619082e-001, -4.620191e-001, -4.621299e-001, -4.622406e-001, -4.623514e-001, -4.624621e-001, -4.625727e-001, -4.626834e-001, -4.627940e-001, -4.629046e-001, -4.630151e-001, -4.631257e-001, -4.632362e-001, -4.633466e-001, -4.634571e-001, -4.635675e-001, -4.636778e-001, -4.637882e-001, -4.638985e-001, -4.640088e-001, -4.641190e-001, -4.642293e-001, -4.643395e-001, -4.644496e-001, -4.645598e-001, -4.646699e-001, -4.647799e-001, -4.648900e-001, 
-4.650000e-001, -4.651100e-001, -4.652199e-001, -4.653299e-001, -4.654398e-001, -4.655496e-001, -4.656595e-001, -4.657693e-001, -4.658790e-001, -4.659888e-001, -4.660985e-001, -4.662082e-001, -4.663178e-001, -4.664275e-001, -4.665371e-001, -4.666466e-001, -4.667562e-001, -4.668657e-001, -4.669751e-001, -4.670846e-001, -4.671940e-001, -4.673034e-001, -4.674127e-001, -4.675221e-001, -4.676314e-001, -4.677406e-001, -4.678499e-001, -4.679591e-001, -4.680682e-001, -4.681774e-001, -4.682865e-001, -4.683956e-001, -4.685046e-001, -4.686137e-001, -4.687227e-001, -4.688316e-001, -4.689406e-001, -4.690495e-001, -4.691583e-001, -4.692672e-001, -4.693760e-001, -4.694848e-001, -4.695935e-001, -4.697023e-001, -4.698110e-001, -4.699196e-001, -4.700283e-001, -4.701369e-001, -4.702454e-001, -4.703540e-001, -4.704625e-001, -4.705710e-001, -4.706794e-001, -4.707879e-001, -4.708963e-001, -4.710046e-001, -4.711130e-001, -4.712213e-001, -4.713295e-001, -4.714378e-001, -4.715460e-001, -4.716542e-001, -4.717623e-001, -4.718705e-001, -4.719786e-001, -4.720866e-001, -4.721947e-001, -4.723027e-001, -4.724106e-001, -4.725186e-001, -4.726265e-001, -4.727344e-001, -4.728422e-001, -4.729501e-001, -4.730579e-001, -4.731656e-001, -4.732734e-001, -4.733811e-001, -4.734887e-001, -4.735964e-001, -4.737040e-001, -4.738116e-001, -4.739191e-001, -4.740267e-001, -4.741342e-001, -4.742416e-001, -4.743491e-001, -4.744565e-001, -4.745638e-001, -4.746712e-001, -4.747785e-001, -4.748858e-001, -4.749930e-001, -4.751003e-001, -4.752075e-001, -4.753146e-001, -4.754218e-001, -4.755289e-001, -4.756359e-001, -4.757430e-001, 
-4.758500e-001, -4.759570e-001, -4.760639e-001, -4.761709e-001, -4.762778e-001, -4.763846e-001, -4.764915e-001, -4.765983e-001, -4.767050e-001, -4.768118e-001, -4.769185e-001, -4.770252e-001, -4.771318e-001, -4.772385e-001, -4.773451e-001, -4.774516e-001, -4.775582e-001, -4.776647e-001, -4.777711e-001, -4.778776e-001, -4.779840e-001, -4.780904e-001, -4.781967e-001, -4.783031e-001, -4.784094e-001, -4.785156e-001, -4.786219e-001, -4.787281e-001, -4.788342e-001, -4.789404e-001, -4.790465e-001, -4.791526e-001, -4.792586e-001, -4.793647e-001, -4.794707e-001, -4.795766e-001, -4.796826e-001, -4.797885e-001, -4.798943e-001, -4.800002e-001, -4.801060e-001, -4.802118e-001, -4.803175e-001, -4.804233e-001, -4.805290e-001, -4.806346e-001, -4.807403e-001, -4.808459e-001, -4.809514e-001, -4.810570e-001, -4.811625e-001, -4.812680e-001, -4.813734e-001, -4.814789e-001, -4.815843e-001, -4.816896e-001, -4.817950e-001, -4.819003e-001, -4.820055e-001, -4.821108e-001, -4.822160e-001, -4.823212e-001, -4.824263e-001, -4.825315e-001, -4.826366e-001, -4.827416e-001, -4.828467e-001, -4.829517e-001, -4.830566e-001, -4.831616e-001, -4.832665e-001, -4.833714e-001, -4.834762e-001, -4.835811e-001, -4.836859e-001, -4.837906e-001, -4.838954e-001, -4.840001e-001, -4.841047e-001, -4.842094e-001, -4.843140e-001, -4.844186e-001, -4.845231e-001, -4.846277e-001, -4.847322e-001, -4.848366e-001, -4.849411e-001, -4.850455e-001, -4.851498e-001, -4.852542e-001, -4.853585e-001, -4.854628e-001, -4.855670e-001, -4.856713e-001, -4.857755e-001, -4.858796e-001, -4.859838e-001, -4.860879e-001, -4.861919e-001, -4.862960e-001, 
-4.864000e-001, -4.865040e-001, -4.866079e-001, -4.867119e-001, -4.868158e-001, -4.869196e-001, -4.870235e-001, -4.871273e-001, -4.872310e-001, -4.873348e-001, -4.874385e-001, -4.875422e-001, -4.876458e-001, -4.877495e-001, -4.878531e-001, -4.879566e-001, -4.880602e-001, -4.881637e-001, -4.882671e-001, -4.883706e-001, -4.884740e-001, -4.885774e-001, -4.886807e-001, -4.887841e-001, -4.888874e-001, -4.889906e-001, -4.890939e-001, -4.891971e-001, -4.893002e-001, -4.894034e-001, -4.895065e-001, -4.896096e-001, -4.897126e-001, -4.898157e-001, -4.899187e-001, -4.900216e-001, -4.901246e-001, -4.902275e-001, -4.903303e-001, -4.904332e-001, -4.905360e-001, -4.906388e-001, -4.907415e-001, -4.908443e-001, -4.909470e-001, -4.910496e-001, -4.911523e-001, -4.912549e-001, -4.913574e-001, -4.914600e-001, -4.915625e-001, -4.916650e-001, -4.917674e-001, -4.918699e-001, -4.919723e-001, -4.920746e-001, -4.921770e-001, -4.922793e-001, -4.923815e-001, -4.924838e-001, -4.925860e-001, -4.926882e-001, -4.927903e-001, -4.928925e-001, -4.929946e-001, -4.930966e-001, -4.931987e-001, -4.933007e-001, -4.934026e-001, -4.935046e-001, -4.936065e-001, -4.937084e-001, -4.938102e-001, -4.939121e-001, -4.940139e-001, -4.941156e-001, -4.942174e-001, -4.943191e-001, -4.944207e-001, -4.945224e-001, -4.946240e-001, -4.947256e-001, -4.948271e-001, -4.949287e-001, -4.950302e-001, -4.951316e-001, -4.952331e-001, -4.953345e-001, -4.954358e-001, -4.955372e-001, -4.956385e-001, -4.957398e-001, -4.958410e-001, -4.959423e-001, -4.960435e-001, -4.961446e-001, -4.962458e-001, -4.963469e-001, -4.964479e-001, -4.965490e-001, 
-4.966500e-001, -4.967510e-001, -4.968519e-001, -4.969529e-001, -4.970538e-001, -4.971546e-001, -4.972555e-001, -4.973563e-001, -4.974570e-001, -4.975578e-001, -4.976585e-001, -4.977592e-001, -4.978598e-001, -4.979605e-001, -4.980611e-001, -4.981616e-001, -4.982622e-001, -4.983627e-001, -4.984631e-001, -4.985636e-001, -4.986640e-001, -4.987644e-001, -4.988647e-001, -4.989651e-001, -4.990654e-001, -4.991656e-001, -4.992659e-001, -4.993661e-001, -4.994662e-001, -4.995664e-001, -4.996665e-001, -4.997666e-001, -4.998666e-001, -4.999667e-001, -5.000667e-001, -5.001666e-001, -5.002666e-001, -5.003665e-001, -5.004663e-001, -5.005662e-001, -5.006660e-001, -5.007658e-001, -5.008655e-001, -5.009653e-001, -5.010650e-001, -5.011646e-001, -5.012643e-001, -5.013639e-001, -5.014634e-001, -5.015630e-001, -5.016625e-001, -5.017620e-001, -5.018614e-001, -5.019609e-001, -5.020603e-001, -5.021596e-001, -5.022590e-001, -5.023583e-001, -5.024575e-001, -5.025568e-001, -5.026560e-001, -5.027552e-001, -5.028543e-001, -5.029535e-001, -5.030526e-001, -5.031516e-001, -5.032507e-001, -5.033497e-001, -5.034486e-001, -5.035476e-001, -5.036465e-001, -5.037454e-001, -5.038442e-001, -5.039431e-001, -5.040419e-001, -5.041406e-001, -5.042394e-001, -5.043381e-001, -5.044367e-001, -5.045354e-001, -5.046340e-001, -5.047326e-001, -5.048311e-001, -5.049297e-001, -5.050282e-001, -5.051266e-001, -5.052251e-001, -5.053235e-001, -5.054218e-001, -5.055202e-001, -5.056185e-001, -5.057168e-001, -5.058150e-001, -5.059133e-001, -5.060115e-001, -5.061096e-001, -5.062078e-001, -5.063059e-001, -5.064039e-001, -5.065020e-001, 
-5.066000e-001, -5.066980e-001, -5.067959e-001, -5.068939e-001, -5.069918e-001, -5.070896e-001, -5.071875e-001, -5.072853e-001, -5.073830e-001, -5.074808e-001, -5.075785e-001, -5.076762e-001, -5.077738e-001, -5.078715e-001, -5.079691e-001, -5.080666e-001, -5.081642e-001, -5.082617e-001, -5.083591e-001, -5.084566e-001, -5.085540e-001, -5.086514e-001, -5.087487e-001, -5.088461e-001, -5.089434e-001, -5.090406e-001, -5.091379e-001, -5.092351e-001, -5.093322e-001, -5.094294e-001, -5.095265e-001, -5.096236e-001, -5.097206e-001, -5.098177e-001, -5.099147e-001, -5.100116e-001, -5.101086e-001, -5.102055e-001, -5.103023e-001, -5.103992e-001, -5.104960e-001, -5.105928e-001, -5.106895e-001, -5.107863e-001, -5.108830e-001, -5.109796e-001, -5.110763e-001, -5.111729e-001, -5.112694e-001, -5.113660e-001, -5.114625e-001, -5.115590e-001, -5.116554e-001, -5.117519e-001, -5.118483e-001, -5.119446e-001, -5.120410e-001, -5.121373e-001, -5.122335e-001, -5.123298e-001, -5.124260e-001, -5.125222e-001, -5.126183e-001, -5.127145e-001, -5.128106e-001, -5.129066e-001, -5.130027e-001, -5.130987e-001, -5.131946e-001, -5.132906e-001, -5.133865e-001, -5.134824e-001, -5.135782e-001, -5.136741e-001, -5.137699e-001, -5.138656e-001, -5.139614e-001, -5.140571e-001, -5.141527e-001, -5.142484e-001, -5.143440e-001, -5.144396e-001, -5.145351e-001, -5.146307e-001, -5.147262e-001, -5.148216e-001, -5.149171e-001, -5.150125e-001, -5.151078e-001, -5.152032e-001, -5.152985e-001, -5.153938e-001, -5.154890e-001, -5.155843e-001, -5.156795e-001, -5.157746e-001, -5.158698e-001, -5.159649e-001, -5.160599e-001, -5.161550e-001, 
-5.162500e-001, -5.163450e-001, -5.164399e-001, -5.165349e-001, -5.166298e-001, -5.167246e-001, -5.168195e-001, -5.169143e-001, -5.170090e-001, -5.171038e-001, -5.171985e-001, -5.172932e-001, -5.173878e-001, -5.174825e-001, -5.175771e-001, -5.176716e-001, -5.177662e-001, -5.178607e-001, -5.179551e-001, -5.180496e-001, -5.181440e-001, -5.182384e-001, -5.183327e-001, -5.184271e-001, -5.185214e-001, -5.186156e-001, -5.187099e-001, -5.188041e-001, -5.188982e-001, -5.189924e-001, -5.190865e-001, -5.191806e-001, -5.192746e-001, -5.193687e-001, -5.194627e-001, -5.195566e-001, -5.196506e-001, -5.197445e-001, -5.198383e-001, -5.199322e-001, -5.200260e-001, -5.201198e-001, -5.202135e-001, -5.203073e-001, -5.204010e-001, -5.204946e-001, -5.205883e-001, -5.206819e-001, -5.207754e-001, -5.208690e-001, -5.209625e-001, -5.210560e-001, -5.211494e-001, -5.212429e-001, -5.213363e-001, -5.214296e-001, -5.215230e-001, -5.216163e-001, -5.217095e-001, -5.218028e-001, -5.218960e-001, -5.219892e-001, -5.220823e-001, -5.221755e-001, -5.222686e-001, -5.223616e-001, -5.224547e-001, -5.225477e-001, -5.226406e-001, -5.227336e-001, -5.228265e-001, -5.229194e-001, -5.230122e-001, -5.231051e-001, -5.231979e-001, -5.232906e-001, -5.233834e-001, -5.234761e-001, -5.235687e-001, -5.236614e-001, -5.237540e-001, -5.238466e-001, -5.239391e-001, -5.240317e-001, -5.241242e-001, -5.242166e-001, -5.243091e-001, -5.244015e-001, -5.244938e-001, -5.245862e-001, -5.246785e-001, -5.247708e-001, -5.248630e-001, -5.249553e-001, -5.250475e-001, -5.251396e-001, -5.252318e-001, -5.253239e-001, -5.254159e-001, -5.255080e-001, 
-5.256000e-001, -5.256920e-001, -5.257839e-001, -5.258759e-001, -5.259678e-001, -5.260596e-001, -5.261515e-001, -5.262433e-001, -5.263350e-001, -5.264268e-001, -5.265185e-001, -5.266102e-001, -5.267018e-001, -5.267935e-001, -5.268851e-001, -5.269766e-001, -5.270682e-001, -5.271597e-001, -5.272511e-001, -5.273426e-001, -5.274340e-001, -5.275254e-001, -5.276167e-001, -5.277081e-001, -5.277994e-001, -5.278906e-001, -5.279819e-001, -5.280731e-001, -5.281642e-001, -5.282554e-001, -5.283465e-001, -5.284376e-001, -5.285286e-001, -5.286197e-001, -5.287107e-001, -5.288016e-001, -5.288926e-001, -5.289835e-001, -5.290743e-001, -5.291652e-001, -5.292560e-001, -5.293468e-001, -5.294375e-001, -5.295283e-001, -5.296190e-001, -5.297096e-001, -5.298003e-001, -5.298909e-001, -5.299814e-001, -5.300720e-001, -5.301625e-001, -5.302530e-001, -5.303434e-001, -5.304339e-001, -5.305243e-001, -5.306146e-001, -5.307050e-001, -5.307953e-001, -5.308855e-001, -5.309758e-001, -5.310660e-001, -5.311562e-001, -5.312463e-001, -5.313365e-001, -5.314266e-001, -5.315166e-001, -5.316067e-001, -5.316967e-001, -5.317866e-001, -5.318766e-001, -5.319665e-001, -5.320564e-001, -5.321462e-001, -5.322361e-001, -5.323259e-001, -5.324156e-001, -5.325054e-001, -5.325951e-001, -5.326847e-001, -5.327744e-001, -5.328640e-001, -5.329536e-001, -5.330431e-001, -5.331327e-001, -5.332222e-001, -5.333116e-001, -5.334011e-001, -5.334905e-001, -5.335798e-001, -5.336692e-001, -5.337585e-001, -5.338478e-001, -5.339370e-001, -5.340263e-001, -5.341155e-001, -5.342046e-001, -5.342938e-001, -5.343829e-001, -5.344719e-001, -5.345610e-001, 
-5.346500e-001, -5.347390e-001, -5.348279e-001, -5.349169e-001, -5.350058e-001, -5.350946e-001, -5.351835e-001, -5.352723e-001, -5.353610e-001, -5.354498e-001, -5.355385e-001, -5.356272e-001, -5.357158e-001, -5.358045e-001, -5.358931e-001, -5.359816e-001, -5.360702e-001, -5.361587e-001, -5.362471e-001, -5.363356e-001, -5.364240e-001, -5.365124e-001, -5.366007e-001, -5.366891e-001, -5.367774e-001, -5.368656e-001, -5.369539e-001, -5.370421e-001, -5.371302e-001, -5.372184e-001, -5.373065e-001, -5.373946e-001, -5.374826e-001, -5.375707e-001, -5.376587e-001, -5.377466e-001, -5.378346e-001, -5.379225e-001, -5.380103e-001, -5.380982e-001, -5.381860e-001, -5.382738e-001, -5.383615e-001, -5.384493e-001, -5.385370e-001, -5.386246e-001, -5.387123e-001, -5.387999e-001, -5.388874e-001, -5.389750e-001, -5.390625e-001, -5.391500e-001, -5.392374e-001, -5.393249e-001, -5.394123e-001, -5.394996e-001, -5.395870e-001, -5.396743e-001, -5.397615e-001, -5.398488e-001, -5.399360e-001, -5.400232e-001, -5.401103e-001, -5.401975e-001, -5.402846e-001, -5.403716e-001, -5.404587e-001, -5.405457e-001, -5.406326e-001, -5.407196e-001, -5.408065e-001, -5.408934e-001, -5.409802e-001, -5.410671e-001, -5.411539e-001, -5.412406e-001, -5.413274e-001, -5.414141e-001, -5.415007e-001, -5.415874e-001, -5.416740e-001, -5.417606e-001, -5.418471e-001, -5.419337e-001, -5.420202e-001, -5.421066e-001, -5.421931e-001, -5.422795e-001, -5.423658e-001, -5.424522e-001, -5.425385e-001, -5.426248e-001, -5.427110e-001, -5.427973e-001, -5.428835e-001, -5.429696e-001, -5.430558e-001, -5.431419e-001, -5.432279e-001, -5.433140e-001, 
-5.434000e-001, -5.434860e-001, -5.435719e-001, -5.436579e-001, -5.437438e-001, -5.438296e-001, -5.439155e-001, -5.440013e-001, -5.440870e-001, -5.441728e-001, -5.442585e-001, -5.443442e-001, -5.444298e-001, -5.445155e-001, -5.446011e-001, -5.446866e-001, -5.447722e-001, -5.448577e-001, -5.449431e-001, -5.450286e-001, -5.451140e-001, -5.451994e-001, -5.452847e-001, -5.453701e-001, -5.454554e-001, -5.455406e-001, -5.456259e-001, -5.457111e-001, -5.457962e-001, -5.458814e-001, -5.459665e-001, -5.460516e-001, -5.461366e-001, -5.462217e-001, -5.463067e-001, -5.463916e-001, -5.464766e-001, -5.465615e-001, -5.466463e-001, -5.467312e-001, -5.468160e-001, -5.469008e-001, -5.469855e-001, -5.470703e-001, -5.471550e-001, -5.472396e-001, -5.473243e-001, -5.474089e-001, -5.474934e-001, -5.475780e-001, -5.476625e-001, -5.477470e-001, -5.478314e-001, -5.479159e-001, -5.480003e-001, -5.480846e-001, -5.481690e-001, -5.482533e-001, -5.483375e-001, -5.484218e-001, -5.485060e-001, -5.485902e-001, -5.486743e-001, -5.487585e-001, -5.488426e-001, -5.489266e-001, -5.490107e-001, -5.490947e-001, -5.491786e-001, -5.492626e-001, -5.493465e-001, -5.494304e-001, -5.495142e-001, -5.495981e-001, -5.496819e-001, -5.497656e-001, -5.498494e-001, -5.499331e-001, -5.500167e-001, -5.501004e-001, -5.501840e-001, -5.502676e-001, -5.503511e-001, -5.504347e-001, -5.505182e-001, -5.506016e-001, -5.506851e-001, -5.507685e-001, -5.508518e-001, -5.509352e-001, -5.510185e-001, -5.511018e-001, -5.511850e-001, -5.512683e-001, -5.513515e-001, -5.514346e-001, -5.515178e-001, -5.516009e-001, -5.516839e-001, -5.517670e-001, 
-5.518500e-001, -5.519330e-001, -5.520159e-001, -5.520989e-001, -5.521818e-001, -5.522646e-001, -5.523475e-001, -5.524303e-001, -5.525130e-001, -5.525958e-001, -5.526785e-001, -5.527612e-001, -5.528438e-001, -5.529265e-001, -5.530091e-001, -5.530916e-001, -5.531742e-001, -5.532567e-001, -5.533391e-001, -5.534216e-001, -5.535040e-001, -5.535864e-001, -5.536687e-001, -5.537511e-001, -5.538334e-001, -5.539156e-001, -5.539979e-001, -5.540801e-001, -5.541622e-001, -5.542444e-001, -5.543265e-001, -5.544086e-001, -5.544906e-001, -5.545727e-001, -5.546547e-001, -5.547366e-001, -5.548186e-001, -5.549005e-001, -5.549823e-001, -5.550642e-001, -5.551460e-001, -5.552278e-001, -5.553095e-001, -5.553913e-001, -5.554730e-001, -5.555546e-001, -5.556363e-001, -5.557179e-001, -5.557994e-001, -5.558810e-001, -5.559625e-001, -5.560440e-001, -5.561254e-001, -5.562069e-001, -5.562883e-001, -5.563696e-001, -5.564510e-001, -5.565323e-001, -5.566135e-001, -5.566948e-001, -5.567760e-001, -5.568572e-001, -5.569383e-001, -5.570195e-001, -5.571006e-001, -5.571816e-001, -5.572627e-001, -5.573437e-001, -5.574246e-001, -5.575056e-001, -5.575865e-001, -5.576674e-001, -5.577482e-001, -5.578291e-001, -5.579099e-001, -5.579906e-001, -5.580714e-001, -5.581521e-001, -5.582327e-001, -5.583134e-001, -5.583940e-001, -5.584746e-001, -5.585551e-001, -5.586357e-001, -5.587162e-001, -5.587966e-001, -5.588771e-001, -5.589575e-001, -5.590378e-001, -5.591182e-001, -5.591985e-001, -5.592788e-001, -5.593590e-001, -5.594393e-001, -5.595195e-001, -5.595996e-001, -5.596798e-001, -5.597599e-001, -5.598399e-001, -5.599200e-001, 
-5.600000e-001, -5.600800e-001, -5.601599e-001, -5.602399e-001, -5.603198e-001, -5.603996e-001, -5.604795e-001, -5.605593e-001, -5.606390e-001, -5.607188e-001, -5.607985e-001, -5.608782e-001, -5.609578e-001, -5.610375e-001, -5.611171e-001, -5.611966e-001, -5.612762e-001, -5.613557e-001, -5.614351e-001, -5.615146e-001, -5.615940e-001, -5.616734e-001, -5.617527e-001, -5.618321e-001, -5.619114e-001, -5.619906e-001, -5.620699e-001, -5.621491e-001, -5.622282e-001, -5.623074e-001, -5.623865e-001, -5.624656e-001, -5.625446e-001, -5.626237e-001, -5.627027e-001, -5.627816e-001, -5.628606e-001, -5.629395e-001, -5.630183e-001, -5.630972e-001, -5.631760e-001, -5.632548e-001, -5.633335e-001, -5.634123e-001, -5.634910e-001, -5.635696e-001, -5.636483e-001, -5.637269e-001, -5.638054e-001, -5.638840e-001, -5.639625e-001, -5.640410e-001, -5.641194e-001, -5.641979e-001, -5.642763e-001, -5.643546e-001, -5.644330e-001, -5.645113e-001, -5.645895e-001, -5.646678e-001, -5.647460e-001, -5.648242e-001, -5.649023e-001, -5.649805e-001, -5.650586e-001, -5.651366e-001, -5.652147e-001, -5.652927e-001, -5.653706e-001, -5.654486e-001, -5.655265e-001, -5.656044e-001, -5.656822e-001, -5.657601e-001, -5.658379e-001, -5.659156e-001, -5.659934e-001, -5.660711e-001, -5.661487e-001, -5.662264e-001, -5.663040e-001, -5.663816e-001, -5.664591e-001, -5.665367e-001, -5.666142e-001, -5.666916e-001, -5.667691e-001, -5.668465e-001, -5.669238e-001, -5.670012e-001, -5.670785e-001, -5.671558e-001, -5.672330e-001, -5.673103e-001, -5.673875e-001, -5.674646e-001, -5.675418e-001, -5.676189e-001, -5.676959e-001, -5.677730e-001, 
-5.678500e-001, -5.679270e-001, -5.680039e-001, -5.680809e-001, -5.681578e-001, -5.682346e-001, -5.683115e-001, -5.683883e-001, -5.684650e-001, -5.685418e-001, -5.686185e-001, -5.686952e-001, -5.687718e-001, -5.688485e-001, -5.689251e-001, -5.690016e-001, -5.690782e-001, -5.691547e-001, -5.692311e-001, -5.693076e-001, -5.693840e-001, -5.694604e-001, -5.695367e-001, -5.696131e-001, -5.696894e-001, -5.697656e-001, -5.698419e-001, -5.699181e-001, -5.699942e-001, -5.700704e-001, -5.701465e-001, -5.702226e-001, -5.702986e-001, -5.703747e-001, -5.704507e-001, -5.705266e-001, -5.706026e-001, -5.706785e-001, -5.707543e-001, -5.708302e-001, -5.709060e-001, -5.709818e-001, -5.710575e-001, -5.711333e-001, -5.712090e-001, -5.712846e-001, -5.713603e-001, -5.714359e-001, -5.715114e-001, -5.715870e-001, -5.716625e-001, -5.717380e-001, -5.718134e-001, -5.718889e-001, -5.719643e-001, -5.720396e-001, -5.721150e-001, -5.721903e-001, -5.722655e-001, -5.723408e-001, -5.724160e-001, -5.724912e-001, -5.725663e-001, -5.726415e-001, -5.727166e-001, -5.727916e-001, -5.728667e-001, -5.729417e-001, -5.730166e-001, -5.730916e-001, -5.731665e-001, -5.732414e-001, -5.733162e-001, -5.733911e-001, -5.734659e-001, -5.735406e-001, -5.736154e-001, -5.736901e-001, -5.737647e-001, -5.738394e-001, -5.739140e-001, -5.739886e-001, -5.740631e-001, -5.741377e-001, -5.742122e-001, -5.742866e-001, -5.743611e-001, -5.744355e-001, -5.745098e-001, -5.745842e-001, -5.746585e-001, -5.747328e-001, -5.748070e-001, -5.748813e-001, -5.749555e-001, -5.750296e-001, -5.751038e-001, -5.751779e-001, -5.752519e-001, -5.753260e-001, 
-5.754000e-001, -5.754740e-001, -5.755479e-001, -5.756219e-001, -5.756958e-001, -5.757696e-001, -5.758435e-001, -5.759173e-001, -5.759910e-001, -5.760648e-001, -5.761385e-001, -5.762122e-001, -5.762858e-001, -5.763595e-001, -5.764331e-001, -5.765066e-001, -5.765802e-001, -5.766537e-001, -5.767271e-001, -5.768006e-001, -5.768740e-001, -5.769474e-001, -5.770207e-001, -5.770941e-001, -5.771674e-001, -5.772406e-001, -5.773139e-001, -5.773871e-001, -5.774602e-001, -5.775334e-001, -5.776065e-001, -5.776796e-001, -5.777526e-001, -5.778257e-001, -5.778987e-001, -5.779716e-001, -5.780446e-001, -5.781175e-001, -5.781903e-001, -5.782632e-001, -5.783360e-001, -5.784088e-001, -5.784815e-001, -5.785543e-001, -5.786270e-001, -5.786996e-001, -5.787723e-001, -5.788449e-001, -5.789174e-001, -5.789900e-001, -5.790625e-001, -5.791350e-001, -5.792074e-001, -5.792799e-001, -5.793523e-001, -5.794246e-001, -5.794970e-001, -5.795693e-001, -5.796415e-001, -5.797138e-001, -5.797860e-001, -5.798582e-001, -5.799303e-001, -5.800025e-001, -5.800746e-001, -5.801466e-001, -5.802187e-001, -5.802907e-001, -5.803626e-001, -5.804346e-001, -5.805065e-001, -5.805784e-001, -5.806502e-001, -5.807221e-001, -5.807939e-001, -5.808656e-001, -5.809374e-001, -5.810091e-001, -5.810807e-001, -5.811524e-001, -5.812240e-001, -5.812956e-001, -5.813671e-001, -5.814387e-001, -5.815102e-001, -5.815816e-001, -5.816531e-001, -5.817245e-001, -5.817958e-001, -5.818672e-001, -5.819385e-001, -5.820098e-001, -5.820810e-001, -5.821523e-001, -5.822235e-001, -5.822946e-001, -5.823658e-001, -5.824369e-001, -5.825079e-001, -5.825790e-001, 
-5.826500e-001, -5.827210e-001, -5.827919e-001, -5.828629e-001, -5.829338e-001, -5.830046e-001, -5.830755e-001, -5.831463e-001, -5.832170e-001, -5.832878e-001, -5.833585e-001, -5.834292e-001, -5.834998e-001, -5.835705e-001, -5.836411e-001, -5.837116e-001, -5.837822e-001, -5.838527e-001, -5.839231e-001, -5.839936e-001, -5.840640e-001, -5.841344e-001, -5.842047e-001, -5.842751e-001, -5.843454e-001, -5.844156e-001, -5.844859e-001, -5.845561e-001, -5.846262e-001, -5.846964e-001, -5.847665e-001, -5.848366e-001, -5.849066e-001, -5.849767e-001, -5.850467e-001, -5.851166e-001, -5.851866e-001, -5.852565e-001, -5.853263e-001, -5.853962e-001, -5.854660e-001, -5.855358e-001, -5.856055e-001, -5.856753e-001, -5.857450e-001, -5.858146e-001, -5.858843e-001, -5.859539e-001, -5.860234e-001, -5.860930e-001, -5.861625e-001, -5.862320e-001, -5.863014e-001, -5.863709e-001, -5.864403e-001, -5.865096e-001, -5.865790e-001, -5.866483e-001, -5.867175e-001, -5.867868e-001, -5.868560e-001, -5.869252e-001, -5.869943e-001, -5.870635e-001, -5.871326e-001, -5.872016e-001, -5.872707e-001, -5.873397e-001, -5.874086e-001, -5.874776e-001, -5.875465e-001, -5.876154e-001, -5.876842e-001, -5.877531e-001, -5.878219e-001, -5.878906e-001, -5.879594e-001, -5.880281e-001, -5.880967e-001, -5.881654e-001, -5.882340e-001, -5.883026e-001, -5.883711e-001, -5.884397e-001, -5.885082e-001, -5.885766e-001, -5.886451e-001, -5.887135e-001, -5.887818e-001, -5.888502e-001, -5.889185e-001, -5.889868e-001, -5.890550e-001, -5.891233e-001, -5.891915e-001, -5.892596e-001, -5.893278e-001, -5.893959e-001, -5.894639e-001, -5.895320e-001, 
-5.896000e-001, -5.896680e-001, -5.897359e-001, -5.898039e-001, -5.898718e-001, -5.899396e-001, -5.900075e-001, -5.900753e-001, -5.901430e-001, -5.902108e-001, -5.902785e-001, -5.903462e-001, -5.904138e-001, -5.904815e-001, -5.905491e-001, -5.906166e-001, -5.906842e-001, -5.907517e-001, -5.908191e-001, -5.908866e-001, -5.909540e-001, -5.910214e-001, -5.910887e-001, -5.911561e-001, -5.912234e-001, -5.912906e-001, -5.913579e-001, -5.914251e-001, -5.914922e-001, -5.915594e-001, -5.916265e-001, -5.916936e-001, -5.917606e-001, -5.918277e-001, -5.918947e-001, -5.919616e-001, -5.920286e-001, -5.920955e-001, -5.921623e-001, -5.922292e-001, -5.922960e-001, -5.923628e-001, -5.924295e-001, -5.924963e-001, -5.925630e-001, -5.926296e-001, -5.926963e-001, -5.927629e-001, -5.928294e-001, -5.928960e-001, -5.929625e-001, -5.930290e-001, -5.930954e-001, -5.931619e-001, -5.932283e-001, -5.932946e-001, -5.933610e-001, -5.934273e-001, -5.934935e-001, -5.935598e-001, -5.936260e-001, -5.936922e-001, -5.937583e-001, -5.938245e-001, -5.938906e-001, -5.939566e-001, -5.940227e-001, -5.940887e-001, -5.941546e-001, -5.942206e-001, -5.942865e-001, -5.943524e-001, -5.944182e-001, -5.944841e-001, -5.945499e-001, -5.946156e-001, -5.946814e-001, -5.947471e-001, -5.948127e-001, -5.948784e-001, -5.949440e-001, -5.950096e-001, -5.950751e-001, -5.951407e-001, -5.952062e-001, -5.952716e-001, -5.953371e-001, -5.954025e-001, -5.954678e-001, -5.955332e-001, -5.955985e-001, -5.956638e-001, -5.957290e-001, -5.957943e-001, -5.958595e-001, -5.959246e-001, -5.959898e-001, -5.960549e-001, -5.961199e-001, -5.961850e-001, 
-5.962500e-001, -5.963150e-001, -5.963799e-001, -5.964449e-001, -5.965098e-001, -5.965746e-001, -5.966395e-001, -5.967043e-001, -5.967690e-001, -5.968338e-001, -5.968985e-001, -5.969632e-001, -5.970278e-001, -5.970925e-001, -5.971571e-001, -5.972216e-001, -5.972862e-001, -5.973507e-001, -5.974151e-001, -5.974796e-001, -5.975440e-001, -5.976084e-001, -5.976727e-001, -5.977371e-001, -5.978014e-001, -5.978656e-001, -5.979299e-001, -5.979941e-001, -5.980582e-001, -5.981224e-001, -5.981865e-001, -5.982506e-001, -5.983146e-001, -5.983787e-001, -5.984427e-001, -5.985066e-001, -5.985706e-001, -5.986345e-001, -5.986983e-001, -5.987622e-001, -5.988260e-001, -5.988898e-001, -5.989535e-001, -5.990173e-001, -5.990810e-001, -5.991446e-001, -5.992083e-001, -5.992719e-001, -5.993354e-001, -5.993990e-001, -5.994625e-001, -5.995260e-001, -5.995894e-001, -5.996529e-001, -5.997163e-001, -5.997796e-001, -5.998430e-001, -5.999063e-001, -5.999695e-001, -6.000328e-001, -6.000960e-001, -6.001592e-001, -6.002223e-001, -6.002855e-001, -6.003486e-001, -6.004116e-001, -6.004747e-001, -6.005377e-001, -6.006006e-001, -6.006636e-001, -6.007265e-001, -6.007894e-001, -6.008522e-001, -6.009151e-001, -6.009779e-001, -6.010406e-001, -6.011034e-001, -6.011661e-001, -6.012287e-001, -6.012914e-001, -6.013540e-001, -6.014166e-001, -6.014791e-001, -6.015417e-001, -6.016042e-001, -6.016666e-001, -6.017291e-001, -6.017915e-001, -6.018538e-001, -6.019162e-001, -6.019785e-001, -6.020408e-001, -6.021030e-001, -6.021653e-001, -6.022275e-001, -6.022896e-001, -6.023518e-001, -6.024139e-001, -6.024759e-001, -6.025380e-001, 
-6.026000e-001, -6.026620e-001, -6.027239e-001, -6.027859e-001, -6.028478e-001, -6.029096e-001, -6.029715e-001, -6.030333e-001, -6.030950e-001, -6.031568e-001, -6.032185e-001, -6.032802e-001, -6.033418e-001, -6.034035e-001, -6.034651e-001, -6.035266e-001, -6.035882e-001, -6.036497e-001, -6.037111e-001, -6.037726e-001, -6.038340e-001, -6.038954e-001, -6.039567e-001, -6.040181e-001, -6.040794e-001, -6.041406e-001, -6.042019e-001, -6.042631e-001, -6.043242e-001, -6.043854e-001, -6.044465e-001, -6.045076e-001, -6.045686e-001, -6.046297e-001, -6.046907e-001, -6.047516e-001, -6.048126e-001, -6.048735e-001, -6.049343e-001, -6.049952e-001, -6.050560e-001, -6.051168e-001, -6.051775e-001, -6.052383e-001, -6.052990e-001, -6.053596e-001, -6.054203e-001, -6.054809e-001, -6.055414e-001, -6.056020e-001, -6.056625e-001, -6.057230e-001, -6.057834e-001, -6.058439e-001, -6.059043e-001, -6.059646e-001, -6.060250e-001, -6.060853e-001, -6.061455e-001, -6.062058e-001, -6.062660e-001, -6.063262e-001, -6.063863e-001, -6.064465e-001, -6.065066e-001, -6.065666e-001, -6.066267e-001, -6.066867e-001, -6.067466e-001, -6.068066e-001, -6.068665e-001, -6.069264e-001, -6.069862e-001, -6.070461e-001, -6.071059e-001, -6.071656e-001, -6.072254e-001, -6.072851e-001, -6.073447e-001, -6.074044e-001, -6.074640e-001, -6.075236e-001, -6.075831e-001, -6.076427e-001, -6.077022e-001, -6.077616e-001, -6.078211e-001, -6.078805e-001, -6.079398e-001, -6.079992e-001, -6.080585e-001, -6.081178e-001, -6.081770e-001, -6.082363e-001, -6.082955e-001, -6.083546e-001, -6.084138e-001, -6.084729e-001, -6.085319e-001, -6.085910e-001, 
-6.086500e-001, -6.087090e-001, -6.087679e-001, -6.088269e-001, -6.088858e-001, -6.089446e-001, -6.090035e-001, -6.090623e-001, -6.091210e-001, -6.091798e-001, -6.092385e-001, -6.092972e-001, -6.093558e-001, -6.094145e-001, -6.094731e-001, -6.095316e-001, -6.095902e-001, -6.096487e-001, -6.097071e-001, -6.097656e-001, -6.098240e-001, -6.098824e-001, -6.099407e-001, -6.099991e-001, -6.100574e-001, -6.101156e-001, -6.101739e-001, -6.102321e-001, -6.102902e-001, -6.103484e-001, -6.104065e-001, -6.104646e-001, -6.105226e-001, -6.105807e-001, -6.106387e-001, -6.106966e-001, -6.107546e-001, -6.108125e-001, -6.108703e-001, -6.109282e-001, -6.109860e-001, -6.110438e-001, -6.111015e-001, -6.111593e-001, -6.112170e-001, -6.112746e-001, -6.113323e-001, -6.113899e-001, -6.114474e-001, -6.115050e-001, -6.115625e-001, -6.116200e-001, -6.116774e-001, -6.117349e-001, -6.117923e-001, -6.118496e-001, -6.119070e-001, -6.119643e-001, -6.120215e-001, -6.120788e-001, -6.121360e-001, -6.121932e-001, -6.122503e-001, -6.123075e-001, -6.123646e-001, -6.124216e-001, -6.124787e-001, -6.125357e-001, -6.125926e-001, -6.126496e-001, -6.127065e-001, -6.127634e-001, -6.128202e-001, -6.128771e-001, -6.129339e-001, -6.129906e-001, -6.130474e-001, -6.131041e-001, -6.131607e-001, -6.132174e-001, -6.132740e-001, -6.133306e-001, -6.133871e-001, -6.134437e-001, -6.135002e-001, -6.135566e-001, -6.136131e-001, -6.136695e-001, -6.137258e-001, -6.137822e-001, -6.138385e-001, -6.138948e-001, -6.139510e-001, -6.140073e-001, -6.140635e-001, -6.141196e-001, -6.141758e-001, -6.142319e-001, -6.142879e-001, -6.143440e-001, 
-6.144000e-001, -6.144560e-001, -6.145119e-001, -6.145679e-001, -6.146238e-001, -6.146796e-001, -6.147355e-001, -6.147913e-001, -6.148470e-001, -6.149028e-001, -6.149585e-001, -6.150142e-001, -6.150698e-001, -6.151255e-001, -6.151811e-001, -6.152366e-001, -6.152922e-001, -6.153477e-001, -6.154031e-001, -6.154586e-001, -6.155140e-001, -6.155694e-001, -6.156247e-001, -6.156801e-001, -6.157354e-001, -6.157906e-001, -6.158459e-001, -6.159011e-001, -6.159562e-001, -6.160114e-001, -6.160665e-001, -6.161216e-001, -6.161766e-001, -6.162317e-001, -6.162867e-001, -6.163416e-001, -6.163966e-001, -6.164515e-001, -6.165063e-001, -6.165612e-001, -6.166160e-001, -6.166708e-001, -6.167255e-001, -6.167803e-001, -6.168350e-001, -6.168896e-001, -6.169443e-001, -6.169989e-001, -6.170534e-001, -6.171080e-001, -6.171625e-001, -6.172170e-001, -6.172714e-001, -6.173259e-001, -6.173803e-001, -6.174346e-001, -6.174890e-001, -6.175433e-001, -6.175975e-001, -6.176518e-001, -6.177060e-001, -6.177602e-001, -6.178143e-001, -6.178685e-001, -6.179226e-001, -6.179766e-001, -6.180307e-001, -6.180847e-001, -6.181386e-001, -6.181926e-001, -6.182465e-001, -6.183004e-001, -6.183542e-001, -6.184081e-001, -6.184619e-001, -6.185156e-001, -6.185694e-001, -6.186231e-001, -6.186767e-001, -6.187304e-001, -6.187840e-001, -6.188376e-001, -6.188911e-001, -6.189447e-001, -6.189982e-001, -6.190516e-001, -6.191051e-001, -6.191585e-001, -6.192118e-001, -6.192652e-001, -6.193185e-001, -6.193718e-001, -6.194250e-001, -6.194783e-001, -6.195315e-001, -6.195846e-001, -6.196378e-001, -6.196909e-001, -6.197439e-001, -6.197970e-001, 
-6.198500e-001, -6.199030e-001, -6.199559e-001, -6.200089e-001, -6.200618e-001, -6.201146e-001, -6.201675e-001, -6.202203e-001, -6.202730e-001, -6.203258e-001, -6.203785e-001, -6.204312e-001, -6.204838e-001, -6.205365e-001, -6.205891e-001, -6.206416e-001, -6.206942e-001, -6.207467e-001, -6.207991e-001, -6.208516e-001, -6.209040e-001, -6.209564e-001, -6.210087e-001, -6.210611e-001, -6.211134e-001, -6.211656e-001, -6.212179e-001, -6.212701e-001, -6.213222e-001, -6.213744e-001, -6.214265e-001, -6.214786e-001, -6.215306e-001, -6.215827e-001, -6.216347e-001, -6.216866e-001, -6.217386e-001, -6.217905e-001, -6.218423e-001, -6.218942e-001, -6.219460e-001, -6.219978e-001, -6.220495e-001, -6.221013e-001, -6.221530e-001, -6.222046e-001, -6.222563e-001, -6.223079e-001, -6.223594e-001, -6.224110e-001, -6.224625e-001, -6.225140e-001, -6.225654e-001, -6.226169e-001, -6.226683e-001, -6.227196e-001, -6.227710e-001, -6.228223e-001, -6.228735e-001, -6.229248e-001, -6.229760e-001, -6.230272e-001, -6.230783e-001, -6.231295e-001, -6.231806e-001, -6.232316e-001, -6.232827e-001, -6.233337e-001, -6.233846e-001, -6.234356e-001, -6.234865e-001, -6.235374e-001, -6.235882e-001, -6.236391e-001, -6.236899e-001, -6.237406e-001, -6.237914e-001, -6.238421e-001, -6.238927e-001, -6.239434e-001, -6.239940e-001, -6.240446e-001, -6.240951e-001, -6.241457e-001, -6.241962e-001, -6.242466e-001, -6.242971e-001, -6.243475e-001, -6.243978e-001, -6.244482e-001, -6.244985e-001, -6.245488e-001, -6.245990e-001, -6.246493e-001, -6.246995e-001, -6.247496e-001, -6.247998e-001, -6.248499e-001, -6.248999e-001, -6.249500e-001, 
-6.250000e-001, -6.250500e-001, -6.250999e-001, -6.251499e-001, -6.251998e-001, -6.252496e-001, -6.252995e-001, -6.253493e-001, -6.253990e-001, -6.254488e-001, -6.254985e-001, -6.255482e-001, -6.255978e-001, -6.256475e-001, -6.256971e-001, -6.257466e-001, -6.257962e-001, -6.258457e-001, -6.258951e-001, -6.259446e-001, -6.259940e-001, -6.260434e-001, -6.260927e-001, -6.261421e-001, -6.261914e-001, -6.262406e-001, -6.262899e-001, -6.263391e-001, -6.263882e-001, -6.264374e-001, -6.264865e-001, -6.265356e-001, -6.265846e-001, -6.266337e-001, -6.266827e-001, -6.267316e-001, -6.267806e-001, -6.268295e-001, -6.268783e-001, -6.269272e-001, -6.269760e-001, -6.270248e-001, -6.270735e-001, -6.271223e-001, -6.271710e-001, -6.272196e-001, -6.272683e-001, -6.273169e-001, -6.273654e-001, -6.274140e-001, -6.274625e-001, -6.275110e-001, -6.275594e-001, -6.276079e-001, -6.276563e-001, -6.277046e-001, -6.277530e-001, -6.278013e-001, -6.278495e-001, -6.278978e-001, -6.279460e-001, -6.279942e-001, -6.280423e-001, -6.280905e-001, -6.281386e-001, -6.281866e-001, -6.282347e-001, -6.282827e-001, -6.283306e-001, -6.283786e-001, -6.284265e-001, -6.284744e-001, -6.285222e-001, -6.285701e-001, -6.286179e-001, -6.286656e-001, -6.287134e-001, -6.287611e-001, -6.288087e-001, -6.288564e-001, -6.289040e-001, -6.289516e-001, -6.289991e-001, -6.290467e-001, -6.290942e-001, -6.291416e-001, -6.291891e-001, -6.292365e-001, -6.292838e-001, -6.293312e-001, -6.293785e-001, -6.294258e-001, -6.294730e-001, -6.295203e-001, -6.295675e-001, -6.296146e-001, -6.296618e-001, -6.297089e-001, -6.297559e-001, -6.298030e-001, 
-6.298500e-001, -6.298970e-001, -6.299439e-001, -6.299909e-001, -6.300378e-001, -6.300846e-001, -6.301315e-001, -6.301783e-001, -6.302250e-001, -6.302718e-001, -6.303185e-001, -6.303652e-001, -6.304118e-001, -6.304585e-001, -6.305051e-001, -6.305516e-001, -6.305982e-001, -6.306447e-001, -6.306911e-001, -6.307376e-001, -6.307840e-001, -6.308304e-001, -6.308767e-001, -6.309231e-001, -6.309694e-001, -6.310156e-001, -6.310619e-001, -6.311081e-001, -6.311542e-001, -6.312004e-001, -6.312465e-001, -6.312926e-001, -6.313386e-001, -6.313847e-001, -6.314307e-001, -6.314766e-001, -6.315226e-001, -6.315685e-001, -6.316143e-001, -6.316602e-001, -6.317060e-001, -6.317518e-001, -6.317975e-001, -6.318433e-001, -6.318890e-001, -6.319346e-001, -6.319803e-001, -6.320259e-001, -6.320714e-001, -6.321170e-001, -6.321625e-001, -6.322080e-001, -6.322534e-001, -6.322989e-001, -6.323443e-001, -6.323896e-001, -6.324350e-001, -6.324803e-001, -6.325255e-001, -6.325708e-001, -6.326160e-001, -6.326612e-001, -6.327063e-001, -6.327515e-001, -6.327966e-001, -6.328416e-001, -6.328867e-001, -6.329317e-001, -6.329766e-001, -6.330216e-001, -6.330665e-001, -6.331114e-001, -6.331562e-001, -6.332011e-001, -6.332459e-001, -6.332906e-001, -6.333354e-001, -6.333801e-001, -6.334247e-001, -6.334694e-001, -6.335140e-001, -6.335586e-001, -6.336031e-001, -6.336477e-001, -6.336922e-001, -6.337366e-001, -6.337811e-001, -6.338255e-001, -6.338698e-001, -6.339142e-001, -6.339585e-001, -6.340028e-001, -6.340470e-001, -6.340913e-001, -6.341355e-001, -6.341796e-001, -6.342238e-001, -6.342679e-001, -6.343119e-001, -6.343560e-001, 
-6.344000e-001, -6.344440e-001, -6.344879e-001, -6.345319e-001, -6.345758e-001, -6.346196e-001, -6.346635e-001, -6.347073e-001, -6.347510e-001, -6.347948e-001, -6.348385e-001, -6.348822e-001, -6.349258e-001, -6.349695e-001, -6.350131e-001, -6.350566e-001, -6.351002e-001, -6.351437e-001, -6.351871e-001, -6.352306e-001, -6.352740e-001, -6.353174e-001, -6.353607e-001, -6.354041e-001, -6.354474e-001, -6.354906e-001, -6.355339e-001, -6.355771e-001, -6.356202e-001, -6.356634e-001, -6.357065e-001, -6.357496e-001, -6.357926e-001, -6.358357e-001, -6.358787e-001, -6.359216e-001, -6.359646e-001, -6.360075e-001, -6.360503e-001, -6.360932e-001, -6.361360e-001, -6.361788e-001, -6.362215e-001, -6.362643e-001, -6.363070e-001, -6.363496e-001, -6.363923e-001, -6.364349e-001, -6.364774e-001, -6.365200e-001, -6.365625e-001, -6.366050e-001, -6.366474e-001, -6.366899e-001, -6.367323e-001, -6.367746e-001, -6.368170e-001, -6.368593e-001, -6.369015e-001, -6.369438e-001, -6.369860e-001, -6.370282e-001, -6.370703e-001, -6.371125e-001, -6.371546e-001, -6.371966e-001, -6.372387e-001, -6.372807e-001, -6.373226e-001, -6.373646e-001, -6.374065e-001, -6.374484e-001, -6.374902e-001, -6.375321e-001, -6.375739e-001, -6.376156e-001, -6.376574e-001, -6.376991e-001, -6.377407e-001, -6.377824e-001, -6.378240e-001, -6.378656e-001, -6.379071e-001, -6.379487e-001, -6.379902e-001, -6.380316e-001, -6.380731e-001, -6.381145e-001, -6.381558e-001, -6.381972e-001, -6.382385e-001, -6.382798e-001, -6.383210e-001, -6.383623e-001, -6.384035e-001, -6.384446e-001, -6.384858e-001, -6.385269e-001, -6.385679e-001, -6.386090e-001, 
-6.386500e-001, -6.386910e-001, -6.387319e-001, -6.387729e-001, -6.388138e-001, -6.388546e-001, -6.388955e-001, -6.389363e-001, -6.389770e-001, -6.390178e-001, -6.390585e-001, -6.390992e-001, -6.391398e-001, -6.391805e-001, -6.392211e-001, -6.392616e-001, -6.393022e-001, -6.393427e-001, -6.393831e-001, -6.394236e-001, -6.394640e-001, -6.395044e-001, -6.395447e-001, -6.395851e-001, -6.396254e-001, -6.396656e-001, -6.397059e-001, -6.397461e-001, -6.397862e-001, -6.398264e-001, -6.398665e-001, -6.399066e-001, -6.399466e-001, -6.399867e-001, -6.400267e-001, -6.400666e-001, -6.401066e-001, -6.401465e-001, -6.401863e-001, -6.402262e-001, -6.402660e-001, -6.403058e-001, -6.403455e-001, -6.403853e-001, -6.404250e-001, -6.404646e-001, -6.405043e-001, -6.405439e-001, -6.405834e-001, -6.406230e-001, -6.406625e-001, -6.407020e-001, -6.407414e-001, -6.407809e-001, -6.408203e-001, -6.408596e-001, -6.408990e-001, -6.409383e-001, -6.409775e-001, -6.410168e-001, -6.410560e-001, -6.410952e-001, -6.411343e-001, -6.411735e-001, -6.412126e-001, -6.412516e-001, -6.412907e-001, -6.413297e-001, -6.413686e-001, -6.414076e-001, -6.414465e-001, -6.414854e-001, -6.415242e-001, -6.415631e-001, -6.416019e-001, -6.416406e-001, -6.416794e-001, -6.417181e-001, -6.417567e-001, -6.417954e-001, -6.418340e-001, -6.418726e-001, -6.419111e-001, -6.419497e-001, -6.419882e-001, -6.420266e-001, -6.420651e-001, -6.421035e-001, -6.421418e-001, -6.421802e-001, -6.422185e-001, -6.422568e-001, -6.422950e-001, -6.423333e-001, -6.423715e-001, -6.424096e-001, -6.424478e-001, -6.424859e-001, -6.425239e-001, -6.425620e-001, 
-6.426000e-001, -6.426380e-001, -6.426759e-001, -6.427139e-001, -6.427518e-001, -6.427896e-001, -6.428275e-001, -6.428653e-001, -6.429030e-001, -6.429408e-001, -6.429785e-001, -6.430162e-001, -6.430538e-001, -6.430915e-001, -6.431291e-001, -6.431666e-001, -6.432042e-001, -6.432417e-001, -6.432791e-001, -6.433166e-001, -6.433540e-001, -6.433914e-001, -6.434287e-001, -6.434661e-001, -6.435034e-001, -6.435406e-001, -6.435779e-001, -6.436151e-001, -6.436522e-001, -6.436894e-001, -6.437265e-001, -6.437636e-001, -6.438006e-001, -6.438377e-001, -6.438747e-001, -6.439116e-001, -6.439486e-001, -6.439855e-001, -6.440223e-001, -6.440592e-001, -6.440960e-001, -6.441328e-001, -6.441695e-001, -6.442063e-001, -6.442430e-001, -6.442796e-001, -6.443163e-001, -6.443529e-001, -6.443894e-001, -6.444260e-001, -6.444625e-001, -6.444990e-001, -6.445354e-001, -6.445719e-001, -6.446083e-001, -6.446446e-001, -6.446810e-001, -6.447173e-001, -6.447535e-001, -6.447898e-001, -6.448260e-001, -6.448622e-001, -6.448983e-001, -6.449345e-001, -6.449706e-001, -6.450066e-001, -6.450427e-001, -6.450787e-001, -6.451146e-001, -6.451506e-001, -6.451865e-001, -6.452224e-001, -6.452582e-001, -6.452941e-001, -6.453299e-001, -6.453656e-001, -6.454014e-001, -6.454371e-001, -6.454727e-001, -6.455084e-001, -6.455440e-001, -6.455796e-001, -6.456151e-001, -6.456507e-001, -6.456862e-001, -6.457216e-001, -6.457571e-001, -6.457925e-001, -6.458278e-001, -6.458632e-001, -6.458985e-001, -6.459338e-001, -6.459690e-001, -6.460043e-001, -6.460395e-001, -6.460746e-001, -6.461098e-001, -6.461449e-001, -6.461799e-001, -6.462150e-001, 
-6.462500e-001, -6.462850e-001, -6.463199e-001, -6.463549e-001, -6.463898e-001, -6.464246e-001, -6.464595e-001, -6.464943e-001, -6.465290e-001, -6.465638e-001, -6.465985e-001, -6.466332e-001, -6.466678e-001, -6.467025e-001, -6.467371e-001, -6.467716e-001, -6.468062e-001, -6.468407e-001, -6.468751e-001, -6.469096e-001, -6.469440e-001, -6.469784e-001, -6.470127e-001, -6.470471e-001, -6.470814e-001, -6.471156e-001, -6.471499e-001, -6.471841e-001, -6.472182e-001, -6.472524e-001, -6.472865e-001, -6.473206e-001, -6.473546e-001, -6.473887e-001, -6.474227e-001, -6.474566e-001, -6.474906e-001, -6.475245e-001, -6.475583e-001, -6.475922e-001, -6.476260e-001, -6.476598e-001, -6.476935e-001, -6.477273e-001, -6.477610e-001, -6.477946e-001, -6.478283e-001, -6.478619e-001, -6.478954e-001, -6.479290e-001, -6.479625e-001, -6.479960e-001, -6.480294e-001, -6.480629e-001, -6.480963e-001, -6.481296e-001, -6.481630e-001, -6.481963e-001, -6.482295e-001, -6.482628e-001, -6.482960e-001, -6.483292e-001, -6.483623e-001, -6.483955e-001, -6.484286e-001, -6.484616e-001, -6.484947e-001, -6.485277e-001, -6.485606e-001, -6.485936e-001, -6.486265e-001, -6.486594e-001, -6.486922e-001, -6.487251e-001, -6.487579e-001, -6.487906e-001, -6.488234e-001, -6.488561e-001, -6.488887e-001, -6.489214e-001, -6.489540e-001, -6.489866e-001, -6.490191e-001, -6.490517e-001, -6.490842e-001, -6.491166e-001, -6.491491e-001, -6.491815e-001, -6.492138e-001, -6.492462e-001, -6.492785e-001, -6.493108e-001, -6.493430e-001, -6.493753e-001, -6.494075e-001, -6.494396e-001, -6.494718e-001, -6.495039e-001, -6.495359e-001, -6.495680e-001, 
-6.496000e-001, -6.496320e-001, -6.496639e-001, -6.496959e-001, -6.497278e-001, -6.497596e-001, -6.497915e-001, -6.498233e-001, -6.498550e-001, -6.498868e-001, -6.499185e-001, -6.499502e-001, -6.499818e-001, -6.500135e-001, -6.500451e-001, -6.500766e-001, -6.501082e-001, -6.501397e-001, -6.501711e-001, -6.502026e-001, -6.502340e-001, -6.502654e-001, -6.502967e-001, -6.503281e-001, -6.503594e-001, -6.503906e-001, -6.504219e-001, -6.504531e-001, -6.504842e-001, -6.505154e-001, -6.505465e-001, -6.505776e-001, -6.506086e-001, -6.506397e-001, -6.506707e-001, -6.507016e-001, -6.507326e-001, -6.507635e-001, -6.507943e-001, -6.508252e-001, -6.508560e-001, -6.508868e-001, -6.509175e-001, -6.509483e-001, -6.509790e-001, -6.510096e-001, -6.510403e-001, -6.510709e-001, -6.511014e-001, -6.511320e-001, -6.511625e-001, -6.511930e-001, -6.512234e-001, -6.512539e-001, -6.512843e-001, -6.513146e-001, -6.513450e-001, -6.513753e-001, -6.514055e-001, -6.514358e-001, -6.514660e-001, -6.514962e-001, -6.515263e-001, -6.515565e-001, -6.515866e-001, -6.516166e-001, -6.516467e-001, -6.516767e-001, -6.517066e-001, -6.517366e-001, -6.517665e-001, -6.517964e-001, -6.518262e-001, -6.518561e-001, -6.518859e-001, -6.519156e-001, -6.519454e-001, -6.519751e-001, -6.520047e-001, -6.520344e-001, -6.520640e-001, -6.520936e-001, -6.521231e-001, -6.521527e-001, -6.521822e-001, -6.522116e-001, -6.522411e-001, -6.522705e-001, -6.522998e-001, -6.523292e-001, -6.523585e-001, -6.523878e-001, -6.524170e-001, -6.524463e-001, -6.524755e-001, -6.525046e-001, -6.525338e-001, -6.525629e-001, -6.525919e-001, -6.526210e-001, 
-6.526500e-001, -6.526790e-001, -6.527079e-001, -6.527369e-001, -6.527658e-001, -6.527946e-001, -6.528235e-001, -6.528523e-001, -6.528810e-001, -6.529098e-001, -6.529385e-001, -6.529672e-001, -6.529958e-001, -6.530245e-001, -6.530531e-001, -6.530816e-001, -6.531102e-001, -6.531387e-001, -6.531671e-001, -6.531956e-001, -6.532240e-001, -6.532524e-001, -6.532807e-001, -6.533091e-001, -6.533374e-001, -6.533656e-001, -6.533939e-001, -6.534221e-001, -6.534502e-001, -6.534784e-001, -6.535065e-001, -6.535346e-001, -6.535626e-001, -6.535907e-001, -6.536187e-001, -6.536466e-001, -6.536746e-001, -6.537025e-001, -6.537303e-001, -6.537582e-001, -6.537860e-001, -6.538138e-001, -6.538415e-001, -6.538693e-001, -6.538970e-001, -6.539246e-001, -6.539523e-001, -6.539799e-001, -6.540074e-001, -6.540350e-001, -6.540625e-001, -6.540900e-001, -6.541174e-001, -6.541449e-001, -6.541723e-001, -6.541996e-001, -6.542270e-001, -6.542543e-001, -6.542815e-001, -6.543088e-001, -6.543360e-001, -6.543632e-001, -6.543903e-001, -6.544175e-001, -6.544446e-001, -6.544716e-001, -6.544987e-001, -6.545257e-001, -6.545526e-001, -6.545796e-001, -6.546065e-001, -6.546334e-001, -6.546602e-001, -6.546871e-001, -6.547139e-001, -6.547406e-001, -6.547674e-001, -6.547941e-001, -6.548207e-001, -6.548474e-001, -6.548740e-001, -6.549006e-001, -6.549271e-001, -6.549537e-001, -6.549802e-001, -6.550066e-001, -6.550331e-001, -6.550595e-001, -6.550858e-001, -6.551122e-001, -6.551385e-001, -6.551648e-001, -6.551910e-001, -6.552173e-001, -6.552435e-001, -6.552696e-001, -6.552958e-001, -6.553219e-001, -6.553479e-001, -6.553740e-001, 
-6.554000e-001, -6.554260e-001, -6.554519e-001, -6.554779e-001, -6.555038e-001, -6.555296e-001, -6.555555e-001, -6.555813e-001, -6.556070e-001, -6.556328e-001, -6.556585e-001, -6.556842e-001, -6.557098e-001, -6.557355e-001, -6.557611e-001, -6.557866e-001, -6.558122e-001, -6.558377e-001, -6.558631e-001, -6.558886e-001, -6.559140e-001, -6.559394e-001, -6.559647e-001, -6.559901e-001, -6.560154e-001, -6.560406e-001, -6.560659e-001, -6.560911e-001, -6.561162e-001, -6.561414e-001, -6.561665e-001, -6.561916e-001, -6.562166e-001, -6.562417e-001, -6.562667e-001, -6.562916e-001, -6.563166e-001, -6.563415e-001, -6.563663e-001, -6.563912e-001, -6.564160e-001, -6.564408e-001, -6.564655e-001, -6.564903e-001, -6.565150e-001, -6.565396e-001, -6.565643e-001, -6.565889e-001, -6.566134e-001, -6.566380e-001, -6.566625e-001, -6.566870e-001, -6.567114e-001, -6.567359e-001, -6.567603e-001, -6.567846e-001, -6.568090e-001, -6.568333e-001, -6.568575e-001, -6.568818e-001, -6.569060e-001, -6.569302e-001, -6.569543e-001, -6.569785e-001, -6.570026e-001, -6.570266e-001, -6.570507e-001, -6.570747e-001, -6.570986e-001, -6.571226e-001, -6.571465e-001, -6.571704e-001, -6.571942e-001, -6.572181e-001, -6.572419e-001, -6.572656e-001, -6.572894e-001, -6.573131e-001, -6.573367e-001, -6.573604e-001, -6.573840e-001, -6.574076e-001, -6.574311e-001, -6.574547e-001, -6.574782e-001, -6.575016e-001, -6.575251e-001, -6.575485e-001, -6.575718e-001, -6.575952e-001, -6.576185e-001, -6.576418e-001, -6.576650e-001, -6.576883e-001, -6.577115e-001, -6.577346e-001, -6.577578e-001, -6.577809e-001, -6.578039e-001, -6.578270e-001, 
-6.578500e-001, -6.578730e-001, -6.578959e-001, -6.579189e-001, -6.579418e-001, -6.579646e-001, -6.579875e-001, -6.580103e-001, -6.580330e-001, -6.580558e-001, -6.580785e-001, -6.581012e-001, -6.581238e-001, -6.581465e-001, -6.581691e-001, -6.581916e-001, -6.582142e-001, -6.582367e-001, -6.582591e-001, -6.582816e-001, -6.583040e-001, -6.583264e-001, -6.583487e-001, -6.583711e-001, -6.583934e-001, -6.584156e-001, -6.584379e-001, -6.584601e-001, -6.584822e-001, -6.585044e-001, -6.585265e-001, -6.585486e-001, -6.585706e-001, -6.585927e-001, -6.586147e-001, -6.586366e-001, -6.586586e-001, -6.586805e-001, -6.587023e-001, -6.587242e-001, -6.587460e-001, -6.587678e-001, -6.587895e-001, -6.588113e-001, -6.588330e-001, -6.588546e-001, -6.588763e-001, -6.588979e-001, -6.589194e-001, -6.589410e-001, -6.589625e-001, -6.589840e-001, -6.590054e-001, -6.590269e-001, -6.590483e-001, -6.590696e-001, -6.590910e-001, -6.591123e-001, -6.591335e-001, -6.591548e-001, -6.591760e-001, -6.591972e-001, -6.592183e-001, -6.592395e-001, -6.592606e-001, -6.592816e-001, -6.593027e-001, -6.593237e-001, -6.593446e-001, -6.593656e-001, -6.593865e-001, -6.594074e-001, -6.594282e-001, -6.594491e-001, -6.594699e-001, -6.594906e-001, -6.595114e-001, -6.595321e-001, -6.595527e-001, -6.595734e-001, -6.595940e-001, -6.596146e-001, -6.596351e-001, -6.596557e-001, -6.596762e-001, -6.596966e-001, -6.597171e-001, -6.597375e-001, -6.597578e-001, -6.597782e-001, -6.597985e-001, -6.598188e-001, -6.598390e-001, -6.598593e-001, -6.598795e-001, -6.598996e-001, -6.599198e-001, -6.599399e-001, -6.599599e-001, -6.599800e-001, 
-6.600000e-001, -6.600200e-001, -6.600399e-001, -6.600599e-001, -6.600798e-001, -6.600996e-001, -6.601195e-001, -6.601393e-001, -6.601590e-001, -6.601788e-001, -6.601985e-001, -6.602182e-001, -6.602378e-001, -6.602575e-001, -6.602771e-001, -6.602966e-001, -6.603162e-001, -6.603357e-001, -6.603551e-001, -6.603746e-001, -6.603940e-001, -6.604134e-001, -6.604327e-001, -6.604521e-001, -6.604714e-001, -6.604906e-001, -6.605099e-001, -6.605291e-001, -6.605482e-001, -6.605674e-001, -6.605865e-001, -6.606056e-001, -6.606246e-001, -6.606437e-001, -6.606627e-001, -6.606816e-001, -6.607006e-001, -6.607195e-001, -6.607383e-001, -6.607572e-001, -6.607760e-001, -6.607948e-001, -6.608135e-001, -6.608323e-001, -6.608510e-001, -6.608696e-001, -6.608883e-001, -6.609069e-001, -6.609254e-001, -6.609440e-001, -6.609625e-001, -6.609810e-001, -6.609994e-001, -6.610179e-001, -6.610363e-001, -6.610546e-001, -6.610730e-001, -6.610913e-001, -6.611095e-001, -6.611278e-001, -6.611460e-001, -6.611642e-001, -6.611823e-001, -6.612005e-001, -6.612186e-001, -6.612366e-001, -6.612547e-001, -6.612727e-001, -6.612906e-001, -6.613086e-001, -6.613265e-001, -6.613444e-001, -6.613622e-001, -6.613801e-001, -6.613979e-001, -6.614156e-001, -6.614334e-001, -6.614511e-001, -6.614687e-001, -6.614864e-001, -6.615040e-001, -6.615216e-001, -6.615391e-001, -6.615567e-001, -6.615742e-001, -6.615916e-001, -6.616091e-001, -6.616265e-001, -6.616438e-001, -6.616612e-001, -6.616785e-001, -6.616958e-001, -6.617130e-001, -6.617303e-001, -6.617475e-001, -6.617646e-001, -6.617818e-001, -6.617989e-001, -6.618159e-001, -6.618330e-001, 
-6.618500e-001, -6.618670e-001, -6.618839e-001, -6.619009e-001, -6.619178e-001, -6.619346e-001, -6.619515e-001, -6.619683e-001, -6.619850e-001, -6.620018e-001, -6.620185e-001, -6.620352e-001, -6.620518e-001, -6.620685e-001, -6.620851e-001, -6.621016e-001, -6.621182e-001, -6.621347e-001, -6.621511e-001, -6.621676e-001, -6.621840e-001, -6.622004e-001, -6.622167e-001, -6.622331e-001, -6.622494e-001, -6.622656e-001, -6.622819e-001, -6.622981e-001, -6.623142e-001, -6.623304e-001, -6.623465e-001, -6.623626e-001, -6.623786e-001, -6.623947e-001, -6.624107e-001, -6.624266e-001, -6.624426e-001, -6.624585e-001, -6.624743e-001, -6.624902e-001, -6.625060e-001, -6.625218e-001, -6.625375e-001, -6.625533e-001, -6.625690e-001, -6.625846e-001, -6.626003e-001, -6.626159e-001, -6.626314e-001, -6.626470e-001, -6.626625e-001, -6.626780e-001, -6.626934e-001, -6.627089e-001, -6.627243e-001, -6.627396e-001, -6.627550e-001, -6.627703e-001, -6.627855e-001, -6.628008e-001, -6.628160e-001, -6.628312e-001, -6.628463e-001, -6.628615e-001, -6.628766e-001, -6.628916e-001, -6.629067e-001, -6.629217e-001, -6.629366e-001, -6.629516e-001, -6.629665e-001, -6.629814e-001, -6.629962e-001, -6.630111e-001, -6.630259e-001, -6.630406e-001, -6.630554e-001, -6.630701e-001, -6.630847e-001, -6.630994e-001, -6.631140e-001, -6.631286e-001, -6.631431e-001, -6.631577e-001, -6.631722e-001, -6.631866e-001, -6.632011e-001, -6.632155e-001, -6.632298e-001, -6.632442e-001, -6.632585e-001, -6.632728e-001, -6.632870e-001, -6.633013e-001, -6.633155e-001, -6.633296e-001, -6.633438e-001, -6.633579e-001, -6.633719e-001, -6.633860e-001, 
-6.634000e-001, -6.634140e-001, -6.634279e-001, -6.634419e-001, -6.634558e-001, -6.634696e-001, -6.634835e-001, -6.634973e-001, -6.635110e-001, -6.635248e-001, -6.635385e-001, -6.635522e-001, -6.635658e-001, -6.635795e-001, -6.635931e-001, -6.636066e-001, -6.636202e-001, -6.636337e-001, -6.636471e-001, -6.636606e-001, -6.636740e-001, -6.636874e-001, -6.637007e-001, -6.637141e-001, -6.637274e-001, -6.637406e-001, -6.637539e-001, -6.637671e-001, -6.637802e-001, -6.637934e-001, -6.638065e-001, -6.638196e-001, -6.638326e-001, -6.638457e-001, -6.638587e-001, -6.638716e-001, -6.638846e-001, -6.638975e-001, -6.639103e-001, -6.639232e-001, -6.639360e-001, -6.639488e-001, -6.639615e-001, -6.639743e-001, -6.639870e-001, -6.639996e-001, -6.640123e-001, -6.640249e-001, -6.640374e-001, -6.640500e-001, -6.640625e-001, -6.640750e-001, -6.640874e-001, -6.640999e-001, -6.641123e-001, -6.641246e-001, -6.641370e-001, -6.641493e-001, -6.641615e-001, -6.641738e-001, -6.641860e-001, -6.641982e-001, -6.642103e-001, -6.642225e-001, -6.642346e-001, -6.642466e-001, -6.642587e-001, -6.642707e-001, -6.642826e-001, -6.642946e-001, -6.643065e-001, -6.643184e-001, -6.643302e-001, -6.643421e-001, -6.643539e-001, -6.643656e-001, -6.643774e-001, -6.643891e-001, -6.644007e-001, -6.644124e-001, -6.644240e-001, -6.644356e-001, -6.644471e-001, -6.644587e-001, -6.644702e-001, -6.644816e-001, -6.644931e-001, -6.645045e-001, -6.645158e-001, -6.645272e-001, -6.645385e-001, -6.645498e-001, -6.645610e-001, -6.645723e-001, -6.645835e-001, -6.645946e-001, -6.646058e-001, -6.646169e-001, -6.646279e-001, -6.646390e-001, 
-6.646500e-001, -6.646610e-001, -6.646719e-001, -6.646829e-001, -6.646938e-001, -6.647046e-001, -6.647155e-001, -6.647263e-001, -6.647370e-001, -6.647478e-001, -6.647585e-001, -6.647692e-001, -6.647798e-001, -6.647905e-001, -6.648011e-001, -6.648116e-001, -6.648222e-001, -6.648327e-001, -6.648431e-001, -6.648536e-001, -6.648640e-001, -6.648744e-001, -6.648847e-001, -6.648951e-001, -6.649054e-001, -6.649156e-001, -6.649259e-001, -6.649361e-001, -6.649462e-001, -6.649564e-001, -6.649665e-001, -6.649766e-001, -6.649866e-001, -6.649967e-001, -6.650067e-001, -6.650166e-001, -6.650266e-001, -6.650365e-001, -6.650463e-001, -6.650562e-001, -6.650660e-001, -6.650758e-001, -6.650855e-001, -6.650953e-001, -6.651050e-001, -6.651146e-001, -6.651243e-001, -6.651339e-001, -6.651434e-001, -6.651530e-001, -6.651625e-001, -6.651720e-001, -6.651814e-001, -6.651909e-001, -6.652003e-001, -6.652096e-001, -6.652190e-001, -6.652283e-001, -6.652375e-001, -6.652468e-001, -6.652560e-001, -6.652652e-001, -6.652743e-001, -6.652835e-001, -6.652926e-001, -6.653016e-001, -6.653107e-001, -6.653197e-001, -6.653286e-001, -6.653376e-001, -6.653465e-001, -6.653554e-001, -6.653642e-001, -6.653731e-001, -6.653819e-001, -6.653906e-001, -6.653994e-001, -6.654081e-001, -6.654167e-001, -6.654254e-001, -6.654340e-001, -6.654426e-001, -6.654511e-001, -6.654597e-001, -6.654682e-001, -6.654766e-001, -6.654851e-001, -6.654935e-001, -6.655018e-001, -6.655102e-001, -6.655185e-001, -6.655268e-001, -6.655350e-001, -6.655433e-001, -6.655515e-001, -6.655596e-001, -6.655678e-001, -6.655759e-001, -6.655839e-001, -6.655920e-001, 
-6.656000e-001, -6.656080e-001, -6.656159e-001, -6.656239e-001, -6.656318e-001, -6.656396e-001, -6.656475e-001, -6.656553e-001, -6.656630e-001, -6.656708e-001, -6.656785e-001, -6.656862e-001, -6.656938e-001, -6.657015e-001, -6.657091e-001, -6.657166e-001, -6.657242e-001, -6.657317e-001, -6.657391e-001, -6.657466e-001, -6.657540e-001, -6.657614e-001, -6.657687e-001, -6.657761e-001, -6.657834e-001, -6.657906e-001, -6.657979e-001, -6.658051e-001, -6.658122e-001, -6.658194e-001, -6.658265e-001, -6.658336e-001, -6.658406e-001, -6.658477e-001, -6.658547e-001, -6.658616e-001, -6.658686e-001, -6.658755e-001, -6.658823e-001, -6.658892e-001, -6.658960e-001, -6.659028e-001, -6.659095e-001, -6.659163e-001, -6.659230e-001, -6.659296e-001, -6.659363e-001, -6.659429e-001, -6.659494e-001, -6.659560e-001, -6.659625e-001, -6.659690e-001, -6.659754e-001, -6.659819e-001, -6.659883e-001, -6.659946e-001, -6.660010e-001, -6.660073e-001, -6.660135e-001, -6.660198e-001, -6.660260e-001, -6.660322e-001, -6.660383e-001, -6.660445e-001, -6.660506e-001, -6.660566e-001, -6.660627e-001, -6.660687e-001, -6.660746e-001, -6.660806e-001, -6.660865e-001, -6.660924e-001, -6.660982e-001, -6.661041e-001, -6.661099e-001, -6.661156e-001, -6.661214e-001, -6.661271e-001, -6.661327e-001, -6.661384e-001, -6.661440e-001, -6.661496e-001, -6.661551e-001, -6.661607e-001, -6.661662e-001, -6.661716e-001, -6.661771e-001, -6.661825e-001, -6.661878e-001, -6.661932e-001, -6.661985e-001, -6.662038e-001, -6.662090e-001, -6.662143e-001, -6.662195e-001, -6.662246e-001, -6.662298e-001, -6.662349e-001, -6.662399e-001, -6.662450e-001, 
-6.662500e-001, -6.662550e-001, -6.662599e-001, -6.662649e-001, -6.662698e-001, -6.662746e-001, -6.662795e-001, -6.662843e-001, -6.662890e-001, -6.662938e-001, -6.662985e-001, -6.663032e-001, -6.663078e-001, -6.663125e-001, -6.663171e-001, -6.663216e-001, -6.663262e-001, -6.663307e-001, -6.663351e-001, -6.663396e-001, -6.663440e-001, -6.663484e-001, -6.663527e-001, -6.663571e-001, -6.663614e-001, -6.663656e-001, -6.663699e-001, -6.663741e-001, -6.663782e-001, -6.663824e-001, -6.663865e-001, -6.663906e-001, -6.663946e-001, -6.663987e-001, -6.664027e-001, -6.664066e-001, -6.664106e-001, -6.664145e-001, -6.664183e-001, -6.664222e-001, -6.664260e-001, -6.664298e-001, -6.664335e-001, -6.664373e-001, -6.664410e-001, -6.664446e-001, -6.664483e-001, -6.664519e-001, -6.664554e-001, -6.664590e-001, -6.664625e-001, -6.664660e-001, -6.664694e-001, -6.664729e-001, -6.664763e-001, -6.664796e-001, -6.664830e-001, -6.664863e-001, -6.664895e-001, -6.664928e-001, -6.664960e-001, -6.664992e-001, -6.665023e-001, -6.665055e-001, -6.665086e-001, -6.665116e-001, -6.665147e-001, -6.665177e-001, -6.665206e-001, -6.665236e-001, -6.665265e-001, -6.665294e-001, -6.665322e-001, -6.665351e-001, -6.665379e-001, -6.665406e-001, -6.665434e-001, -6.665461e-001, -6.665487e-001, -6.665514e-001, -6.665540e-001, -6.665566e-001, -6.665591e-001, -6.665617e-001, -6.665642e-001, -6.665666e-001, -6.665691e-001, -6.665715e-001, -6.665738e-001, -6.665762e-001, -6.665785e-001, -6.665808e-001, -6.665830e-001, -6.665853e-001, -6.665875e-001, -6.665896e-001, -6.665918e-001, -6.665939e-001, -6.665959e-001, -6.665980e-001, 
-6.666000e-001, -6.666020e-001, -6.666039e-001, -6.666059e-001, -6.666078e-001, -6.666096e-001, -6.666115e-001, -6.666133e-001, -6.666150e-001, -6.666168e-001, -6.666185e-001, -6.666202e-001, -6.666218e-001, -6.666235e-001, -6.666251e-001, -6.666266e-001, -6.666282e-001, -6.666297e-001, -6.666311e-001, -6.666326e-001, -6.666340e-001, -6.666354e-001, -6.666367e-001, -6.666381e-001, -6.666394e-001, -6.666406e-001, -6.666419e-001, -6.666431e-001, -6.666442e-001, -6.666454e-001, -6.666465e-001, -6.666476e-001, -6.666486e-001, -6.666497e-001, -6.666507e-001, -6.666516e-001, -6.666526e-001, -6.666535e-001, -6.666543e-001, -6.666552e-001, -6.666560e-001, -6.666568e-001, -6.666575e-001, -6.666583e-001, -6.666590e-001, -6.666596e-001, -6.666603e-001, -6.666609e-001, -6.666614e-001, -6.666620e-001, -6.666625e-001, -6.666630e-001, -6.666634e-001, -6.666639e-001, -6.666643e-001, -6.666646e-001, -6.666650e-001, -6.666653e-001, -6.666655e-001, -6.666658e-001, -6.666660e-001, -6.666662e-001, -6.666663e-001, -6.666665e-001, -6.666666e-001, -6.666666e-001, -6.666667e-001, -6.666667e-001, -6.666666e-001, -6.666666e-001, -6.666665e-001, -6.666664e-001, -6.666662e-001, -6.666661e-001, -6.666659e-001, -6.666656e-001, -6.666654e-001, -6.666651e-001, -6.666647e-001, -6.666644e-001, -6.666640e-001, -6.666636e-001, -6.666631e-001, -6.666627e-001, -6.666622e-001, -6.666616e-001, -6.666611e-001, -6.666605e-001, -6.666598e-001, -6.666592e-001, -6.666585e-001, -6.666578e-001, -6.666570e-001, -6.666563e-001, -6.666555e-001, -6.666546e-001, -6.666538e-001, -6.666529e-001, -6.666519e-001, -6.666510e-001, 
-6.666500e-001, -6.666490e-001, -6.666479e-001, -6.666469e-001, -6.666458e-001, -6.666446e-001, -6.666435e-001, -6.666423e-001, -6.666410e-001, -6.666398e-001, -6.666385e-001, -6.666372e-001, -6.666358e-001, -6.666345e-001, -6.666331e-001, -6.666316e-001, -6.666302e-001, -6.666287e-001, -6.666271e-001, -6.666256e-001, -6.666240e-001, -6.666224e-001, -6.666207e-001, -6.666191e-001, -6.666174e-001, -6.666156e-001, -6.666139e-001, -6.666121e-001, -6.666102e-001, -6.666084e-001, -6.666065e-001, -6.666046e-001, -6.666026e-001, -6.666007e-001, -6.665987e-001, -6.665966e-001, -6.665946e-001, -6.665925e-001, -6.665903e-001, -6.665882e-001, -6.665860e-001, -6.665838e-001, -6.665815e-001, -6.665793e-001, -6.665770e-001, -6.665746e-001, -6.665723e-001, -6.665699e-001, -6.665674e-001, -6.665650e-001, -6.665625e-001, -6.665600e-001, -6.665574e-001, -6.665549e-001, -6.665523e-001, -6.665496e-001, -6.665470e-001, -6.665443e-001, -6.665415e-001, -6.665388e-001, -6.665360e-001, -6.665332e-001, -6.665303e-001, -6.665275e-001, -6.665246e-001, -6.665216e-001, -6.665187e-001, -6.665157e-001, -6.665126e-001, -6.665096e-001, -6.665065e-001, -6.665034e-001, -6.665002e-001, -6.664971e-001, -6.664939e-001, -6.664906e-001, -6.664874e-001, -6.664841e-001, -6.664807e-001, -6.664774e-001, -6.664740e-001, -6.664706e-001, -6.664671e-001, -6.664637e-001, -6.664602e-001, -6.664566e-001, -6.664531e-001, -6.664495e-001, -6.664458e-001, -6.664422e-001, -6.664385e-001, -6.664348e-001, -6.664310e-001, -6.664273e-001, -6.664235e-001, -6.664196e-001, -6.664158e-001, -6.664119e-001, -6.664079e-001, -6.664040e-001, 
-6.664000e-001, -6.663960e-001, -6.663919e-001, -6.663879e-001, -6.663838e-001, -6.663796e-001, -6.663755e-001, -6.663713e-001, -6.663670e-001, -6.663628e-001, -6.663585e-001, -6.663542e-001, -6.663498e-001, -6.663455e-001, -6.663411e-001, -6.663366e-001, -6.663322e-001, -6.663277e-001, -6.663231e-001, -6.663186e-001, -6.663140e-001, -6.663094e-001, -6.663047e-001, -6.663001e-001, -6.662954e-001, -6.662906e-001, -6.662859e-001, -6.662811e-001, -6.662762e-001, -6.662714e-001, -6.662665e-001, -6.662616e-001, -6.662566e-001, -6.662517e-001, -6.662467e-001, -6.662416e-001, -6.662366e-001, -6.662315e-001, -6.662263e-001, -6.662212e-001, -6.662160e-001, -6.662108e-001, -6.662055e-001, -6.662003e-001, -6.661950e-001, -6.661896e-001, -6.661843e-001, -6.661789e-001, -6.661734e-001, -6.661680e-001, -6.661625e-001, -6.661570e-001, -6.661514e-001, -6.661459e-001, -6.661403e-001, -6.661346e-001, -6.661290e-001, -6.661233e-001, -6.661175e-001, -6.661118e-001, -6.661060e-001, -6.661002e-001, -6.660943e-001, -6.660885e-001, -6.660826e-001, -6.660766e-001, -6.660707e-001, -6.660647e-001, -6.660586e-001, -6.660526e-001, -6.660465e-001, -6.660404e-001, -6.660342e-001, -6.660281e-001, -6.660219e-001, -6.660156e-001, -6.660094e-001, -6.660031e-001, -6.659967e-001, -6.659904e-001, -6.659840e-001, -6.659776e-001, -6.659711e-001, -6.659647e-001, -6.659582e-001, -6.659516e-001, -6.659451e-001, -6.659385e-001, -6.659318e-001, -6.659252e-001, -6.659185e-001, -6.659118e-001, -6.659050e-001, -6.658983e-001, -6.658915e-001, -6.658846e-001, -6.658778e-001, -6.658709e-001, -6.658639e-001, -6.658570e-001, 
-6.658500e-001, -6.658430e-001, -6.658359e-001, -6.658289e-001, -6.658218e-001, -6.658146e-001, -6.658075e-001, -6.658003e-001, -6.657930e-001, -6.657858e-001, -6.657785e-001, -6.657712e-001, -6.657638e-001, -6.657565e-001, -6.657491e-001, -6.657416e-001, -6.657342e-001, -6.657267e-001, -6.657191e-001, -6.657116e-001, -6.657040e-001, -6.656964e-001, -6.656887e-001, -6.656811e-001, -6.656734e-001, -6.656656e-001, -6.656579e-001, -6.656501e-001, -6.656422e-001, -6.656344e-001, -6.656265e-001, -6.656186e-001, -6.656106e-001, -6.656027e-001, -6.655947e-001, -6.655866e-001, -6.655786e-001, -6.655705e-001, -6.655623e-001, -6.655542e-001, -6.655460e-001, -6.655378e-001, -6.655295e-001, -6.655213e-001, -6.655130e-001, -6.655046e-001, -6.654963e-001, -6.654879e-001, -6.654794e-001, -6.654710e-001, -6.654625e-001, -6.654540e-001, -6.654454e-001, -6.654369e-001, -6.654283e-001, -6.654196e-001, -6.654110e-001, -6.654023e-001, -6.653935e-001, -6.653848e-001, -6.653760e-001, -6.653672e-001, -6.653583e-001, -6.653495e-001, -6.653406e-001, -6.653316e-001, -6.653227e-001, -6.653137e-001, -6.653046e-001, -6.652956e-001, -6.652865e-001, -6.652774e-001, -6.652682e-001, -6.652591e-001, -6.652499e-001, -6.652406e-001, -6.652314e-001, -6.652221e-001, -6.652127e-001, -6.652034e-001, -6.651940e-001, -6.651846e-001, -6.651751e-001, -6.651657e-001, -6.651562e-001, -6.651466e-001, -6.651371e-001, -6.651275e-001, -6.651178e-001, -6.651082e-001, -6.650985e-001, -6.650888e-001, -6.650790e-001, -6.650693e-001, -6.650595e-001, -6.650496e-001, -6.650398e-001, -6.650299e-001, -6.650199e-001, -6.650100e-001, 
-6.650000e-001, -6.649900e-001, -6.649799e-001, -6.649699e-001, -6.649598e-001, -6.649496e-001, -6.649395e-001, -6.649293e-001, -6.649190e-001, -6.649088e-001, -6.648985e-001, -6.648882e-001, -6.648778e-001, -6.648675e-001, -6.648571e-001, -6.648466e-001, -6.648362e-001, -6.648257e-001, -6.648151e-001, -6.648046e-001, -6.647940e-001, -6.647834e-001, -6.647727e-001, -6.647621e-001, -6.647514e-001, -6.647406e-001, -6.647299e-001, -6.647191e-001, -6.647082e-001, -6.646974e-001, -6.646865e-001, -6.646756e-001, -6.646646e-001, -6.646537e-001, -6.646427e-001, -6.646316e-001, -6.646206e-001, -6.646095e-001, -6.645983e-001, -6.645872e-001, -6.645760e-001, -6.645648e-001, -6.645535e-001, -6.645423e-001, -6.645310e-001, -6.645196e-001, -6.645083e-001, -6.644969e-001, -6.644854e-001, -6.644740e-001, -6.644625e-001, -6.644510e-001, -6.644394e-001, -6.644279e-001, -6.644163e-001, -6.644046e-001, -6.643930e-001, -6.643813e-001, -6.643695e-001, -6.643578e-001, -6.643460e-001, -6.643342e-001, -6.643223e-001, -6.643105e-001, -6.642986e-001, -6.642866e-001, -6.642747e-001, -6.642627e-001, -6.642506e-001, -6.642386e-001, -6.642265e-001, -6.642144e-001, -6.642022e-001, -6.641901e-001, -6.641779e-001, -6.641656e-001, -6.641534e-001, -6.641411e-001, -6.641287e-001, -6.641164e-001, -6.641040e-001, -6.640916e-001, -6.640791e-001, -6.640667e-001, -6.640542e-001, -6.640416e-001, -6.640291e-001, -6.640165e-001, -6.640038e-001, -6.639912e-001, -6.639785e-001, -6.639658e-001, -6.639530e-001, -6.639403e-001, -6.639275e-001, -6.639146e-001, -6.639018e-001, -6.638889e-001, -6.638759e-001, -6.638630e-001, 
-6.638500e-001, -6.638370e-001, -6.638239e-001, -6.638109e-001, -6.637978e-001, -6.637846e-001, -6.637715e-001, -6.637583e-001, -6.637450e-001, -6.637318e-001, -6.637185e-001, -6.637052e-001, -6.636918e-001, -6.636785e-001, -6.636651e-001, -6.636516e-001, -6.636382e-001, -6.636247e-001, -6.636111e-001, -6.635976e-001, -6.635840e-001, -6.635704e-001, -6.635567e-001, -6.635431e-001, -6.635294e-001, -6.635156e-001, -6.635019e-001, -6.634881e-001, -6.634742e-001, -6.634604e-001, -6.634465e-001, -6.634326e-001, -6.634186e-001, -6.634047e-001, -6.633907e-001, -6.633766e-001, -6.633626e-001, -6.633485e-001, -6.633343e-001, -6.633202e-001, -6.633060e-001, -6.632918e-001, -6.632775e-001, -6.632633e-001, -6.632490e-001, -6.632346e-001, -6.632203e-001, -6.632059e-001, -6.631914e-001, -6.631770e-001, -6.631625e-001, -6.631480e-001, -6.631334e-001, -6.631189e-001, -6.631043e-001, -6.630896e-001, -6.630750e-001, -6.630603e-001, -6.630455e-001, -6.630308e-001, -6.630160e-001, -6.630012e-001, -6.629863e-001, -6.629715e-001, -6.629566e-001, -6.629416e-001, -6.629267e-001, -6.629117e-001, -6.628966e-001, -6.628816e-001, -6.628665e-001, -6.628514e-001, -6.628362e-001, -6.628211e-001, -6.628059e-001, -6.627906e-001, -6.627754e-001, -6.627601e-001, -6.627447e-001, -6.627294e-001, -6.627140e-001, -6.626986e-001, -6.626831e-001, -6.626677e-001, -6.626522e-001, -6.626366e-001, -6.626211e-001, -6.626055e-001, -6.625898e-001, -6.625742e-001, -6.625585e-001, -6.625428e-001, -6.625270e-001, -6.625113e-001, -6.624955e-001, -6.624796e-001, -6.624638e-001, -6.624479e-001, -6.624319e-001, -6.624160e-001, 
-6.624000e-001, -6.623840e-001, -6.623679e-001, -6.623519e-001, -6.623358e-001, -6.623196e-001, -6.623035e-001, -6.622873e-001, -6.622710e-001, -6.622548e-001, -6.622385e-001, -6.622222e-001, -6.622058e-001, -6.621895e-001, -6.621731e-001, -6.621566e-001, -6.621402e-001, -6.621237e-001, -6.621071e-001, -6.620906e-001, -6.620740e-001, -6.620574e-001, -6.620407e-001, -6.620241e-001, -6.620074e-001, -6.619906e-001, -6.619739e-001, -6.619571e-001, -6.619402e-001, -6.619234e-001, -6.619065e-001, -6.618896e-001, -6.618726e-001, -6.618557e-001, -6.618387e-001, -6.618216e-001, -6.618046e-001, -6.617875e-001, -6.617703e-001, -6.617532e-001, -6.617360e-001, -6.617188e-001, -6.617015e-001, -6.616843e-001, -6.616670e-001, -6.616496e-001, -6.616323e-001, -6.616149e-001, -6.615974e-001, -6.615800e-001, -6.615625e-001, -6.615450e-001, -6.615274e-001, -6.615099e-001, -6.614923e-001, -6.614746e-001, -6.614570e-001, -6.614393e-001, -6.614215e-001, -6.614038e-001, -6.613860e-001, -6.613682e-001, -6.613503e-001, -6.613325e-001, -6.613146e-001, -6.612966e-001, -6.612787e-001, -6.612607e-001, -6.612426e-001, -6.612246e-001, -6.612065e-001, -6.611884e-001, -6.611702e-001, -6.611521e-001, -6.611339e-001, -6.611156e-001, -6.610974e-001, -6.610791e-001, -6.610607e-001, -6.610424e-001, -6.610240e-001, -6.610056e-001, -6.609871e-001, -6.609687e-001, -6.609502e-001, -6.609316e-001, -6.609131e-001, -6.608945e-001, -6.608758e-001, -6.608572e-001, -6.608385e-001, -6.608198e-001, -6.608010e-001, -6.607823e-001, -6.607635e-001, -6.607446e-001, -6.607258e-001, -6.607069e-001, -6.606879e-001, -6.606690e-001, 
-6.606500e-001, -6.606310e-001, -6.606119e-001, -6.605929e-001, -6.605738e-001, -6.605546e-001, -6.605355e-001, -6.605163e-001, -6.604970e-001, -6.604778e-001, -6.604585e-001, -6.604392e-001, -6.604198e-001, -6.604005e-001, -6.603811e-001, -6.603616e-001, -6.603422e-001, -6.603227e-001, -6.603031e-001, -6.602836e-001, -6.602640e-001, -6.602444e-001, -6.602247e-001, -6.602051e-001, -6.601854e-001, -6.601656e-001, -6.601459e-001, -6.601261e-001, -6.601062e-001, -6.600864e-001, -6.600665e-001, -6.600466e-001, -6.600266e-001, -6.600067e-001, -6.599867e-001, -6.599666e-001, -6.599466e-001, -6.599265e-001, -6.599063e-001, -6.598862e-001, -6.598660e-001, -6.598458e-001, -6.598255e-001, -6.598053e-001, -6.597850e-001, -6.597646e-001, -6.597443e-001, -6.597239e-001, -6.597034e-001, -6.596830e-001, -6.596625e-001, -6.596420e-001, -6.596214e-001, -6.596009e-001, -6.595803e-001, -6.595596e-001, -6.595390e-001, -6.595183e-001, -6.594975e-001, -6.594768e-001, -6.594560e-001, -6.594352e-001, -6.594143e-001, -6.593935e-001, -6.593726e-001, -6.593516e-001, -6.593307e-001, -6.593097e-001, -6.592886e-001, -6.592676e-001, -6.592465e-001, -6.592254e-001, -6.592042e-001, -6.591831e-001, -6.591619e-001, -6.591406e-001, -6.591194e-001, -6.590981e-001, -6.590767e-001, -6.590554e-001, -6.590340e-001, -6.590126e-001, -6.589911e-001, -6.589697e-001, -6.589482e-001, -6.589266e-001, -6.589051e-001, -6.588835e-001, -6.588618e-001, -6.588402e-001, -6.588185e-001, -6.587968e-001, -6.587750e-001, -6.587533e-001, -6.587315e-001, -6.587096e-001, -6.586878e-001, -6.586659e-001, -6.586439e-001, -6.586220e-001, 
-6.586000e-001, -6.585780e-001, -6.585559e-001, -6.585339e-001, -6.585118e-001, -6.584896e-001, -6.584675e-001, -6.584453e-001, -6.584230e-001, -6.584008e-001, -6.583785e-001, -6.583562e-001, -6.583338e-001, -6.583115e-001, -6.582891e-001, -6.582666e-001, -6.582442e-001, -6.582217e-001, -6.581991e-001, -6.581766e-001, -6.581540e-001, -6.581314e-001, -6.581087e-001, -6.580861e-001, -6.580634e-001, -6.580406e-001, -6.580179e-001, -6.579951e-001, -6.579722e-001, -6.579494e-001, -6.579265e-001, -6.579036e-001, -6.578806e-001, -6.578577e-001, -6.578347e-001, -6.578116e-001, -6.577886e-001, -6.577655e-001, -6.577423e-001, -6.577192e-001, -6.576960e-001, -6.576728e-001, -6.576495e-001, -6.576263e-001, -6.576030e-001, -6.575796e-001, -6.575563e-001, -6.575329e-001, -6.575094e-001, -6.574860e-001, -6.574625e-001, -6.574390e-001, -6.574154e-001, -6.573919e-001, -6.573683e-001, -6.573446e-001, -6.573210e-001, -6.572973e-001, -6.572735e-001, -6.572498e-001, -6.572260e-001, -6.572022e-001, -6.571783e-001, -6.571545e-001, -6.571306e-001, -6.571066e-001, -6.570827e-001, -6.570587e-001, -6.570346e-001, -6.570106e-001, -6.569865e-001, -6.569624e-001, -6.569382e-001, -6.569141e-001, -6.568899e-001, -6.568656e-001, -6.568414e-001, -6.568171e-001, -6.567927e-001, -6.567684e-001, -6.567440e-001, -6.567196e-001, -6.566951e-001, -6.566707e-001, -6.566462e-001, -6.566216e-001, -6.565971e-001, -6.565725e-001, -6.565478e-001, -6.565232e-001, -6.564985e-001, -6.564738e-001, -6.564490e-001, -6.564243e-001, -6.563995e-001, -6.563746e-001, -6.563498e-001, -6.563249e-001, -6.562999e-001, -6.562750e-001, 
-6.562500e-001, -6.562250e-001, -6.561999e-001, -6.561749e-001, -6.561498e-001, -6.561246e-001, -6.560995e-001, -6.560743e-001, -6.560490e-001, -6.560238e-001, -6.559985e-001, -6.559732e-001, -6.559478e-001, -6.559225e-001, -6.558971e-001, -6.558716e-001, -6.558462e-001, -6.558207e-001, -6.557951e-001, -6.557696e-001, -6.557440e-001, -6.557184e-001, -6.556927e-001, -6.556671e-001, -6.556414e-001, -6.556156e-001, -6.555899e-001, -6.555641e-001, -6.555382e-001, -6.555124e-001, -6.554865e-001, -6.554606e-001, -6.554346e-001, -6.554087e-001, -6.553827e-001, -6.553566e-001, -6.553306e-001, -6.553045e-001, -6.552783e-001, -6.552522e-001, -6.552260e-001, -6.551998e-001, -6.551735e-001, -6.551473e-001, -6.551210e-001, -6.550946e-001, -6.550683e-001, -6.550419e-001, -6.550154e-001, -6.549890e-001, -6.549625e-001, -6.549360e-001, -6.549094e-001, -6.548829e-001, -6.548563e-001, -6.548296e-001, -6.548030e-001, -6.547763e-001, -6.547495e-001, -6.547228e-001, -6.546960e-001, -6.546692e-001, -6.546423e-001, -6.546155e-001, -6.545886e-001, -6.545616e-001, -6.545347e-001, -6.545077e-001, -6.544806e-001, -6.544536e-001, -6.544265e-001, -6.543994e-001, -6.543722e-001, -6.543451e-001, -6.543179e-001, -6.542906e-001, -6.542634e-001, -6.542361e-001, -6.542087e-001, -6.541814e-001, -6.541540e-001, -6.541266e-001, -6.540991e-001, -6.540717e-001, -6.540442e-001, -6.540166e-001, -6.539891e-001, -6.539615e-001, -6.539338e-001, -6.539062e-001, -6.538785e-001, -6.538508e-001, -6.538230e-001, -6.537953e-001, -6.537675e-001, -6.537396e-001, -6.537118e-001, -6.536839e-001, -6.536559e-001, -6.536280e-001, 
-6.536000e-001, -6.535720e-001, -6.535439e-001, -6.535159e-001, -6.534878e-001, -6.534596e-001, -6.534315e-001, -6.534033e-001, -6.533750e-001, -6.533468e-001, -6.533185e-001, -6.532902e-001, -6.532618e-001, -6.532335e-001, -6.532051e-001, -6.531766e-001, -6.531482e-001, -6.531197e-001, -6.530911e-001, -6.530626e-001, -6.530340e-001, -6.530054e-001, -6.529767e-001, -6.529481e-001, -6.529194e-001, -6.528906e-001, -6.528619e-001, -6.528331e-001, -6.528042e-001, -6.527754e-001, -6.527465e-001, -6.527176e-001, -6.526886e-001, -6.526597e-001, -6.526307e-001, -6.526016e-001, -6.525726e-001, -6.525435e-001, -6.525143e-001, -6.524852e-001, -6.524560e-001, -6.524268e-001, -6.523975e-001, -6.523683e-001, -6.523390e-001, -6.523096e-001, -6.522803e-001, -6.522509e-001, -6.522214e-001, -6.521920e-001, -6.521625e-001, -6.521330e-001, -6.521034e-001, -6.520739e-001, -6.520443e-001, -6.520146e-001, -6.519850e-001, -6.519553e-001, -6.519255e-001, -6.518958e-001, -6.518660e-001, -6.518362e-001, -6.518063e-001, -6.517765e-001, -6.517466e-001, -6.517166e-001, -6.516867e-001, -6.516567e-001, -6.516266e-001, -6.515966e-001, -6.515665e-001, -6.515364e-001, -6.515062e-001, -6.514761e-001, -6.514459e-001, -6.514156e-001, -6.513854e-001, -6.513551e-001, -6.513247e-001, -6.512944e-001, -6.512640e-001, -6.512336e-001, -6.512031e-001, -6.511727e-001, -6.511422e-001, -6.511116e-001, -6.510811e-001, -6.510505e-001, -6.510198e-001, -6.509892e-001, -6.509585e-001, -6.509278e-001, -6.508970e-001, -6.508663e-001, -6.508355e-001, -6.508046e-001, -6.507738e-001, -6.507429e-001, -6.507119e-001, -6.506810e-001, 
-6.506500e-001, -6.506190e-001, -6.505879e-001, -6.505569e-001, -6.505258e-001, -6.504946e-001, -6.504635e-001, -6.504323e-001, -6.504010e-001, -6.503698e-001, -6.503385e-001, -6.503072e-001, -6.502758e-001, -6.502445e-001, -6.502131e-001, -6.501816e-001, -6.501502e-001, -6.501187e-001, -6.500871e-001, -6.500556e-001, -6.500240e-001, -6.499924e-001, -6.499607e-001, -6.499291e-001, -6.498974e-001, -6.498656e-001, -6.498339e-001, -6.498021e-001, -6.497702e-001, -6.497384e-001, -6.497065e-001, -6.496746e-001, -6.496426e-001, -6.496107e-001, -6.495787e-001, -6.495466e-001, -6.495146e-001, -6.494825e-001, -6.494503e-001, -6.494182e-001, -6.493860e-001, -6.493538e-001, -6.493215e-001, -6.492893e-001, -6.492570e-001, -6.492246e-001, -6.491923e-001, -6.491599e-001, -6.491274e-001, -6.490950e-001, -6.490625e-001, -6.490300e-001, -6.489974e-001, -6.489649e-001, -6.489323e-001, -6.488996e-001, -6.488670e-001, -6.488343e-001, -6.488015e-001, -6.487688e-001, -6.487360e-001, -6.487032e-001, -6.486703e-001, -6.486375e-001, -6.486046e-001, -6.485716e-001, -6.485387e-001, -6.485057e-001, -6.484726e-001, -6.484396e-001, -6.484065e-001, -6.483734e-001, -6.483402e-001, -6.483071e-001, -6.482739e-001, -6.482406e-001, -6.482074e-001, -6.481741e-001, -6.481407e-001, -6.481074e-001, -6.480740e-001, -6.480406e-001, -6.480071e-001, -6.479737e-001, -6.479402e-001, -6.479066e-001, -6.478731e-001, -6.478395e-001, -6.478058e-001, -6.477722e-001, -6.477385e-001, -6.477048e-001, -6.476710e-001, -6.476373e-001, -6.476035e-001, -6.475696e-001, -6.475358e-001, -6.475019e-001, -6.474679e-001, -6.474340e-001, 
-6.474000e-001, -6.473660e-001, -6.473319e-001, -6.472979e-001, -6.472638e-001, -6.472296e-001, -6.471955e-001, -6.471613e-001, -6.471270e-001, -6.470928e-001, -6.470585e-001, -6.470242e-001, -6.469898e-001, -6.469555e-001, -6.469211e-001, -6.468866e-001, -6.468522e-001, -6.468177e-001, -6.467831e-001, -6.467486e-001, -6.467140e-001, -6.466794e-001, -6.466447e-001, -6.466101e-001, -6.465754e-001, -6.465406e-001, -6.465059e-001, -6.464711e-001, -6.464362e-001, -6.464014e-001, -6.463665e-001, -6.463316e-001, -6.462966e-001, -6.462617e-001, -6.462267e-001, -6.461916e-001, -6.461566e-001, -6.461215e-001, -6.460863e-001, -6.460512e-001, -6.460160e-001, -6.459808e-001, -6.459455e-001, -6.459103e-001, -6.458750e-001, -6.458396e-001, -6.458043e-001, -6.457689e-001, -6.457334e-001, -6.456980e-001, -6.456625e-001, -6.456270e-001, -6.455914e-001, -6.455559e-001, -6.455203e-001, -6.454846e-001, -6.454490e-001, -6.454133e-001, -6.453775e-001, -6.453418e-001, -6.453060e-001, -6.452702e-001, -6.452343e-001, -6.451985e-001, -6.451626e-001, -6.451266e-001, -6.450907e-001, -6.450547e-001, -6.450186e-001, -6.449826e-001, -6.449465e-001, -6.449104e-001, -6.448742e-001, -6.448381e-001, -6.448019e-001, -6.447656e-001, -6.447294e-001, -6.446931e-001, -6.446567e-001, -6.446204e-001, -6.445840e-001, -6.445476e-001, -6.445111e-001, -6.444747e-001, -6.444382e-001, -6.444016e-001, -6.443651e-001, -6.443285e-001, -6.442918e-001, -6.442552e-001, -6.442185e-001, -6.441818e-001, -6.441450e-001, -6.441083e-001, -6.440715e-001, -6.440346e-001, -6.439978e-001, -6.439609e-001, -6.439239e-001, -6.438870e-001, 
-6.438500e-001, -6.438130e-001, -6.437759e-001, -6.437389e-001, -6.437018e-001, -6.436646e-001, -6.436275e-001, -6.435903e-001, -6.435530e-001, -6.435158e-001, -6.434785e-001, -6.434412e-001, -6.434038e-001, -6.433665e-001, -6.433291e-001, -6.432916e-001, -6.432542e-001, -6.432167e-001, -6.431791e-001, -6.431416e-001, -6.431040e-001, -6.430664e-001, -6.430287e-001, -6.429911e-001, -6.429534e-001, -6.429156e-001, -6.428779e-001, -6.428401e-001, -6.428022e-001, -6.427644e-001, -6.427265e-001, -6.426886e-001, -6.426506e-001, -6.426127e-001, -6.425747e-001, -6.425366e-001, -6.424986e-001, -6.424605e-001, -6.424223e-001, -6.423842e-001, -6.423460e-001, -6.423078e-001, -6.422695e-001, -6.422313e-001, -6.421930e-001, -6.421546e-001, -6.421163e-001, -6.420779e-001, -6.420394e-001, -6.420010e-001, -6.419625e-001, -6.419240e-001, -6.418854e-001, -6.418469e-001, -6.418083e-001, -6.417696e-001, -6.417310e-001, -6.416923e-001, -6.416535e-001, -6.416148e-001, -6.415760e-001, -6.415372e-001, -6.414983e-001, -6.414595e-001, -6.414206e-001, -6.413816e-001, -6.413427e-001, -6.413037e-001, -6.412646e-001, -6.412256e-001, -6.411865e-001, -6.411474e-001, -6.411082e-001, -6.410691e-001, -6.410299e-001, -6.409906e-001, -6.409514e-001, -6.409121e-001, -6.408727e-001, -6.408334e-001, -6.407940e-001, -6.407546e-001, -6.407151e-001, -6.406757e-001, -6.406362e-001, -6.405966e-001, -6.405571e-001, -6.405175e-001, -6.404778e-001, -6.404382e-001, -6.403985e-001, -6.403588e-001, -6.403190e-001, -6.402793e-001, -6.402395e-001, -6.401996e-001, -6.401598e-001, -6.401199e-001, -6.400799e-001, -6.400400e-001, 
-6.400000e-001, -6.399600e-001, -6.399199e-001, -6.398799e-001, -6.398398e-001, -6.397996e-001, -6.397595e-001, -6.397193e-001, -6.396790e-001, -6.396388e-001, -6.395985e-001, -6.395582e-001, -6.395178e-001, -6.394775e-001, -6.394371e-001, -6.393966e-001, -6.393562e-001, -6.393157e-001, -6.392751e-001, -6.392346e-001, -6.391940e-001, -6.391534e-001, -6.391127e-001, -6.390721e-001, -6.390314e-001, -6.389906e-001, -6.389499e-001, -6.389091e-001, -6.388682e-001, -6.388274e-001, -6.387865e-001, -6.387456e-001, -6.387046e-001, -6.386637e-001, -6.386227e-001, -6.385816e-001, -6.385406e-001, -6.384995e-001, -6.384583e-001, -6.384172e-001, -6.383760e-001, -6.383348e-001, -6.382935e-001, -6.382523e-001, -6.382110e-001, -6.381696e-001, -6.381283e-001, -6.380869e-001, -6.380454e-001, -6.380040e-001, -6.379625e-001, -6.379210e-001, -6.378794e-001, -6.378379e-001, -6.377963e-001, -6.377546e-001, -6.377130e-001, -6.376713e-001, -6.376295e-001, -6.375878e-001, -6.375460e-001, -6.375042e-001, -6.374623e-001, -6.374205e-001, -6.373786e-001, -6.373366e-001, -6.372947e-001, -6.372527e-001, -6.372106e-001, -6.371686e-001, -6.371265e-001, -6.370844e-001, -6.370422e-001, -6.370001e-001, -6.369579e-001, -6.369156e-001, -6.368734e-001, -6.368311e-001, -6.367887e-001, -6.367464e-001, -6.367040e-001, -6.366616e-001, -6.366191e-001, -6.365767e-001, -6.365342e-001, -6.364916e-001, -6.364491e-001, -6.364065e-001, -6.363638e-001, -6.363212e-001, -6.362785e-001, -6.362358e-001, -6.361930e-001, -6.361503e-001, -6.361075e-001, -6.360646e-001, -6.360218e-001, -6.359789e-001, -6.359359e-001, -6.358930e-001, 
-6.358500e-001, -6.358070e-001, -6.357639e-001, -6.357209e-001, -6.356778e-001, -6.356346e-001, -6.355915e-001, -6.355483e-001, -6.355050e-001, -6.354618e-001, -6.354185e-001, -6.353752e-001, -6.353318e-001, -6.352885e-001, -6.352451e-001, -6.352016e-001, -6.351582e-001, -6.351147e-001, -6.350711e-001, -6.350276e-001, -6.349840e-001, -6.349404e-001, -6.348967e-001, -6.348531e-001, -6.348094e-001, -6.347656e-001, -6.347219e-001, -6.346781e-001, -6.346342e-001, -6.345904e-001, -6.345465e-001, -6.345026e-001, -6.344586e-001, -6.344147e-001, -6.343707e-001, -6.343266e-001, -6.342826e-001, -6.342385e-001, -6.341943e-001, -6.341502e-001, -6.341060e-001, -6.340618e-001, -6.340175e-001, -6.339733e-001, -6.339290e-001, -6.338846e-001, -6.338403e-001, -6.337959e-001, -6.337514e-001, -6.337070e-001, -6.336625e-001, -6.336180e-001, -6.335734e-001, -6.335289e-001, -6.334843e-001, -6.334396e-001, -6.333950e-001, -6.333503e-001, -6.333055e-001, -6.332608e-001, -6.332160e-001, -6.331712e-001, -6.331263e-001, -6.330815e-001, -6.330366e-001, -6.329916e-001, -6.329467e-001, -6.329017e-001, -6.328566e-001, -6.328116e-001, -6.327665e-001, -6.327214e-001, -6.326762e-001, -6.326311e-001, -6.325859e-001, -6.325406e-001, -6.324954e-001, -6.324501e-001, -6.324047e-001, -6.323594e-001, -6.323140e-001, -6.322686e-001, -6.322231e-001, -6.321777e-001, -6.321322e-001, -6.320866e-001, -6.320411e-001, -6.319955e-001, -6.319498e-001, -6.319042e-001, -6.318585e-001, -6.318128e-001, -6.317670e-001, -6.317213e-001, -6.316755e-001, -6.316296e-001, -6.315838e-001, -6.315379e-001, -6.314919e-001, -6.314460e-001, 
-6.314000e-001, -6.313540e-001, -6.313079e-001, -6.312619e-001, -6.312158e-001, -6.311696e-001, -6.311235e-001, -6.310773e-001, -6.310310e-001, -6.309848e-001, -6.309385e-001, -6.308922e-001, -6.308458e-001, -6.307995e-001, -6.307531e-001, -6.307066e-001, -6.306602e-001, -6.306137e-001, -6.305671e-001, -6.305206e-001, -6.304740e-001, -6.304274e-001, -6.303807e-001, -6.303341e-001, -6.302874e-001, -6.302406e-001, -6.301939e-001, -6.301471e-001, -6.301002e-001, -6.300534e-001, -6.300065e-001, -6.299596e-001, -6.299126e-001, -6.298657e-001, -6.298187e-001, -6.297716e-001, -6.297246e-001, -6.296775e-001, -6.296303e-001, -6.295832e-001, -6.295360e-001, -6.294888e-001, -6.294415e-001, -6.293943e-001, -6.293470e-001, -6.292996e-001, -6.292523e-001, -6.292049e-001, -6.291574e-001, -6.291100e-001, -6.290625e-001, -6.290150e-001, -6.289674e-001, -6.289199e-001, -6.288723e-001, -6.288246e-001, -6.287770e-001, -6.287293e-001, -6.286815e-001, -6.286338e-001, -6.285860e-001, -6.285382e-001, -6.284903e-001, -6.284425e-001, -6.283946e-001, -6.283466e-001, -6.282987e-001, -6.282507e-001, -6.282026e-001, -6.281546e-001, -6.281065e-001, -6.280584e-001, -6.280102e-001, -6.279621e-001, -6.279139e-001, -6.278656e-001, -6.278174e-001, -6.277691e-001, -6.277207e-001, -6.276724e-001, -6.276240e-001, -6.275756e-001, -6.275271e-001, -6.274787e-001, -6.274302e-001, -6.273816e-001, -6.273331e-001, -6.272845e-001, -6.272358e-001, -6.271872e-001, -6.271385e-001, -6.270898e-001, -6.270410e-001, -6.269923e-001, -6.269435e-001, -6.268946e-001, -6.268458e-001, -6.267969e-001, -6.267479e-001, -6.266990e-001, 
-6.266500e-001, -6.266010e-001, -6.265519e-001, -6.265029e-001, -6.264538e-001, -6.264046e-001, -6.263555e-001, -6.263063e-001, -6.262570e-001, -6.262078e-001, -6.261585e-001, -6.261092e-001, -6.260598e-001, -6.260105e-001, -6.259611e-001, -6.259116e-001, -6.258622e-001, -6.258127e-001, -6.257631e-001, -6.257136e-001, -6.256640e-001, -6.256144e-001, -6.255647e-001, -6.255151e-001, -6.254654e-001, -6.254156e-001, -6.253659e-001, -6.253161e-001, -6.252662e-001, -6.252164e-001, -6.251665e-001, -6.251166e-001, -6.250666e-001, -6.250167e-001, -6.249667e-001, -6.249166e-001, -6.248666e-001, -6.248165e-001, -6.247663e-001, -6.247162e-001, -6.246660e-001, -6.246158e-001, -6.245655e-001, -6.245153e-001, -6.244650e-001, -6.244146e-001, -6.243643e-001, -6.243139e-001, -6.242634e-001, -6.242130e-001, -6.241625e-001, -6.241120e-001, -6.240614e-001, -6.240109e-001, -6.239603e-001, -6.239096e-001, -6.238590e-001, -6.238083e-001, -6.237575e-001, -6.237068e-001, -6.236560e-001, -6.236052e-001, -6.235543e-001, -6.235035e-001, -6.234526e-001, -6.234016e-001, -6.233507e-001, -6.232997e-001, -6.232486e-001, -6.231976e-001, -6.231465e-001, -6.230954e-001, -6.230442e-001, -6.229931e-001, -6.229419e-001, -6.228906e-001, -6.228394e-001, -6.227881e-001, -6.227367e-001, -6.226854e-001, -6.226340e-001, -6.225826e-001, -6.225311e-001, -6.224797e-001, -6.224282e-001, -6.223766e-001, -6.223251e-001, -6.222735e-001, -6.222218e-001, -6.221702e-001, -6.221185e-001, -6.220668e-001, -6.220150e-001, -6.219633e-001, -6.219115e-001, -6.218596e-001, -6.218078e-001, -6.217559e-001, -6.217039e-001, -6.216520e-001, 
-6.216000e-001, -6.215480e-001, -6.214959e-001, -6.214439e-001, -6.213918e-001, -6.213396e-001, -6.212875e-001, -6.212353e-001, -6.211830e-001, -6.211308e-001, -6.210785e-001, -6.210262e-001, -6.209738e-001, -6.209215e-001, -6.208691e-001, -6.208166e-001, -6.207642e-001, -6.207117e-001, -6.206591e-001, -6.206066e-001, -6.205540e-001, -6.205014e-001, -6.204487e-001, -6.203961e-001, -6.203434e-001, -6.202906e-001, -6.202379e-001, -6.201851e-001, -6.201322e-001, -6.200794e-001, -6.200265e-001, -6.199736e-001, -6.199206e-001, -6.198677e-001, -6.198147e-001, -6.197616e-001, -6.197086e-001, -6.196555e-001, -6.196023e-001, -6.195492e-001, -6.194960e-001, -6.194428e-001, -6.193895e-001, -6.193363e-001, -6.192830e-001, -6.192296e-001, -6.191763e-001, -6.191229e-001, -6.190694e-001, -6.190160e-001, -6.189625e-001, -6.189090e-001, -6.188554e-001, -6.188019e-001, -6.187483e-001, -6.186946e-001, -6.186410e-001, -6.185873e-001, -6.185335e-001, -6.184798e-001, -6.184260e-001, -6.183722e-001, -6.183183e-001, -6.182645e-001, -6.182106e-001, -6.181566e-001, -6.181027e-001, -6.180487e-001, -6.179946e-001, -6.179406e-001, -6.178865e-001, -6.178324e-001, -6.177782e-001, -6.177241e-001, -6.176699e-001, -6.176156e-001, -6.175614e-001, -6.175071e-001, -6.174527e-001, -6.173984e-001, -6.173440e-001, -6.172896e-001, -6.172351e-001, -6.171807e-001, -6.171262e-001, -6.170716e-001, -6.170171e-001, -6.169625e-001, -6.169078e-001, -6.168532e-001, -6.167985e-001, -6.167438e-001, -6.166890e-001, -6.166343e-001, -6.165795e-001, -6.165246e-001, -6.164698e-001, -6.164149e-001, -6.163599e-001, -6.163050e-001, 
-6.162500e-001, -6.161950e-001, -6.161399e-001, -6.160849e-001, -6.160298e-001, -6.159746e-001, -6.159195e-001, -6.158643e-001, -6.158090e-001, -6.157538e-001, -6.156985e-001, -6.156432e-001, -6.155878e-001, -6.155325e-001, -6.154771e-001, -6.154216e-001, -6.153662e-001, -6.153107e-001, -6.152551e-001, -6.151996e-001, -6.151440e-001, -6.150884e-001, -6.150327e-001, -6.149771e-001, -6.149214e-001, -6.148656e-001, -6.148099e-001, -6.147541e-001, -6.146982e-001, -6.146424e-001, -6.145865e-001, -6.145306e-001, -6.144746e-001, -6.144187e-001, -6.143627e-001, -6.143066e-001, -6.142506e-001, -6.141945e-001, -6.141383e-001, -6.140822e-001, -6.140260e-001, -6.139698e-001, -6.139135e-001, -6.138573e-001, -6.138010e-001, -6.137446e-001, -6.136883e-001, -6.136319e-001, -6.135754e-001, -6.135190e-001, -6.134625e-001, -6.134060e-001, -6.133494e-001, -6.132929e-001, -6.132363e-001, -6.131796e-001, -6.131230e-001, -6.130663e-001, -6.130095e-001, -6.129528e-001, -6.128960e-001, -6.128392e-001, -6.127823e-001, -6.127255e-001, -6.126686e-001, -6.126116e-001, -6.125547e-001, -6.124977e-001, -6.124406e-001, -6.123836e-001, -6.123265e-001, -6.122694e-001, -6.122122e-001, -6.121551e-001, -6.120979e-001, -6.120406e-001, -6.119834e-001, -6.119261e-001, -6.118687e-001, -6.118114e-001, -6.117540e-001, -6.116966e-001, -6.116391e-001, -6.115817e-001, -6.115242e-001, -6.114666e-001, -6.114091e-001, -6.113515e-001, -6.112938e-001, -6.112362e-001, -6.111785e-001, -6.111208e-001, -6.110630e-001, -6.110053e-001, -6.109475e-001, -6.108896e-001, -6.108318e-001, -6.107739e-001, -6.107159e-001, -6.106580e-001, 
-6.106000e-001, -6.105420e-001, -6.104839e-001, -6.104259e-001, -6.103678e-001, -6.103096e-001, -6.102515e-001, -6.101933e-001, -6.101350e-001, -6.100768e-001, -6.100185e-001, -6.099602e-001, -6.099018e-001, -6.098435e-001, -6.097851e-001, -6.097266e-001, -6.096682e-001, -6.096097e-001, -6.095511e-001, -6.094926e-001, -6.094340e-001, -6.093754e-001, -6.093167e-001, -6.092581e-001, -6.091994e-001, -6.091406e-001, -6.090819e-001, -6.090231e-001, -6.089642e-001, -6.089054e-001, -6.088465e-001, -6.087876e-001, -6.087286e-001, -6.086697e-001, -6.086107e-001, -6.085516e-001, -6.084926e-001, -6.084335e-001, -6.083743e-001, -6.083152e-001, -6.082560e-001, -6.081968e-001, -6.081375e-001, -6.080783e-001, -6.080190e-001, -6.079596e-001, -6.079003e-001, -6.078409e-001, -6.077814e-001, -6.077220e-001, -6.076625e-001, -6.076030e-001, -6.075434e-001, -6.074839e-001, -6.074243e-001, -6.073646e-001, -6.073050e-001, -6.072453e-001, -6.071855e-001, -6.071258e-001, -6.070660e-001, -6.070062e-001, -6.069463e-001, -6.068865e-001, -6.068266e-001, -6.067666e-001, -6.067067e-001, -6.066467e-001, -6.065866e-001, -6.065266e-001, -6.064665e-001, -6.064064e-001, -6.063462e-001, -6.062861e-001, -6.062259e-001, -6.061656e-001, -6.061054e-001, -6.060451e-001, -6.059847e-001, -6.059244e-001, -6.058640e-001, -6.058036e-001, -6.057431e-001, -6.056827e-001, -6.056222e-001, -6.055616e-001, -6.055011e-001, -6.054405e-001, -6.053798e-001, -6.053192e-001, -6.052585e-001, -6.051978e-001, -6.051370e-001, -6.050763e-001, -6.050155e-001, -6.049546e-001, -6.048938e-001, -6.048329e-001, -6.047719e-001, -6.047110e-001, 
-6.046500e-001, -6.045890e-001, -6.045279e-001, -6.044669e-001, -6.044058e-001, -6.043446e-001, -6.042835e-001, -6.042223e-001, -6.041610e-001, -6.040998e-001, -6.040385e-001, -6.039772e-001, -6.039158e-001, -6.038545e-001, -6.037931e-001, -6.037316e-001, -6.036702e-001, -6.036087e-001, -6.035471e-001, -6.034856e-001, -6.034240e-001, -6.033624e-001, -6.033007e-001, -6.032391e-001, -6.031774e-001, -6.031156e-001, -6.030539e-001, -6.029921e-001, -6.029302e-001, -6.028684e-001, -6.028065e-001, -6.027446e-001, -6.026826e-001, -6.026207e-001, -6.025587e-001, -6.024966e-001, -6.024346e-001, -6.023725e-001, -6.023103e-001, -6.022482e-001, -6.021860e-001, -6.021238e-001, -6.020615e-001, -6.019993e-001, -6.019370e-001, -6.018746e-001, -6.018123e-001, -6.017499e-001, -6.016874e-001, -6.016250e-001, -6.015625e-001, -6.015000e-001, -6.014374e-001, -6.013749e-001, -6.013123e-001, -6.012496e-001, -6.011870e-001, -6.011243e-001, -6.010615e-001, -6.009988e-001, -6.009360e-001, -6.008732e-001, -6.008103e-001, -6.007475e-001, -6.006846e-001, -6.006216e-001, -6.005587e-001, -6.004957e-001, -6.004326e-001, -6.003696e-001, -6.003065e-001, -6.002434e-001, -6.001802e-001, -6.001171e-001, -6.000539e-001, -5.999906e-001, -5.999274e-001, -5.998641e-001, -5.998007e-001, -5.997374e-001, -5.996740e-001, -5.996106e-001, -5.995471e-001, -5.994837e-001, -5.994202e-001, -5.993566e-001, -5.992931e-001, -5.992295e-001, -5.991658e-001, -5.991022e-001, -5.990385e-001, -5.989748e-001, -5.989110e-001, -5.988473e-001, -5.987835e-001, -5.987196e-001, -5.986558e-001, -5.985919e-001, -5.985279e-001, -5.984640e-001, 
-5.984000e-001, -5.983360e-001, -5.982719e-001, -5.982079e-001, -5.981438e-001, -5.980796e-001, -5.980155e-001, -5.979513e-001, -5.978870e-001, -5.978228e-001, -5.977585e-001, -5.976942e-001, -5.976298e-001, -5.975655e-001, -5.975011e-001, -5.974366e-001, -5.973722e-001, -5.973077e-001, -5.972431e-001, -5.971786e-001, -5.971140e-001, -5.970494e-001, -5.969847e-001, -5.969201e-001, -5.968554e-001, -5.967906e-001, -5.967259e-001, -5.966611e-001, -5.965962e-001, -5.965314e-001, -5.964665e-001, -5.964016e-001, -5.963366e-001, -5.962717e-001, -5.962067e-001, -5.961416e-001, -5.960766e-001, -5.960115e-001, -5.959463e-001, -5.958812e-001, -5.958160e-001, -5.957508e-001, -5.956855e-001, -5.956203e-001, -5.955550e-001, -5.954896e-001, -5.954243e-001, -5.953589e-001, -5.952934e-001, -5.952280e-001, -5.951625e-001, -5.950970e-001, -5.950314e-001, -5.949659e-001, -5.949003e-001, -5.948346e-001, -5.947690e-001, -5.947033e-001, -5.946375e-001, -5.945718e-001, -5.945060e-001, -5.944402e-001, -5.943743e-001, -5.943085e-001, -5.942426e-001, -5.941766e-001, -5.941107e-001, -5.940447e-001, -5.939786e-001, -5.939126e-001, -5.938465e-001, -5.937804e-001, -5.937142e-001, -5.936481e-001, -5.935819e-001, -5.935156e-001, -5.934494e-001, -5.933831e-001, -5.933167e-001, -5.932504e-001, -5.931840e-001, -5.931176e-001, -5.930511e-001, -5.929847e-001, -5.929182e-001, -5.928516e-001, -5.927851e-001, -5.927185e-001, -5.926518e-001, -5.925852e-001, -5.925185e-001, -5.924518e-001, -5.923850e-001, -5.923183e-001, -5.922515e-001, -5.921846e-001, -5.921178e-001, -5.920509e-001, -5.919839e-001, -5.919170e-001, 
-5.918500e-001, -5.917830e-001, -5.917159e-001, -5.916489e-001, -5.915818e-001, -5.915146e-001, -5.914475e-001, -5.913803e-001, -5.913130e-001, -5.912458e-001, -5.911785e-001, -5.911112e-001, -5.910438e-001, -5.909765e-001, -5.909091e-001, -5.908416e-001, -5.907742e-001, -5.907067e-001, -5.906391e-001, -5.905716e-001, -5.905040e-001, -5.904364e-001, -5.903687e-001, -5.903011e-001, -5.902334e-001, -5.901656e-001, -5.900979e-001, -5.900301e-001, -5.899622e-001, -5.898944e-001, -5.898265e-001, -5.897586e-001, -5.896906e-001, -5.896227e-001, -5.895547e-001, -5.894866e-001, -5.894186e-001, -5.893505e-001, -5.892823e-001, -5.892142e-001, -5.891460e-001, -5.890778e-001, -5.890095e-001, -5.889413e-001, -5.888730e-001, -5.888046e-001, -5.887363e-001, -5.886679e-001, -5.885994e-001, -5.885310e-001, -5.884625e-001, -5.883940e-001, -5.883254e-001, -5.882569e-001, -5.881883e-001, -5.881196e-001, -5.880510e-001, -5.879823e-001, -5.879135e-001, -5.878448e-001, -5.877760e-001, -5.877072e-001, -5.876383e-001, -5.875695e-001, -5.875006e-001, -5.874316e-001, -5.873627e-001, -5.872937e-001, -5.872246e-001, -5.871556e-001, -5.870865e-001, -5.870174e-001, -5.869482e-001, -5.868791e-001, -5.868099e-001, -5.867406e-001, -5.866714e-001, -5.866021e-001, -5.865327e-001, -5.864634e-001, -5.863940e-001, -5.863246e-001, -5.862551e-001, -5.861857e-001, -5.861162e-001, -5.860466e-001, -5.859771e-001, -5.859075e-001, -5.858378e-001, -5.857682e-001, -5.856985e-001, -5.856288e-001, -5.855590e-001, -5.854893e-001, -5.854195e-001, -5.853496e-001, -5.852798e-001, -5.852099e-001, -5.851399e-001, -5.850700e-001, 
-5.850000e-001, -5.849300e-001, -5.848599e-001, -5.847899e-001, -5.847198e-001, -5.846496e-001, -5.845795e-001, -5.845093e-001, -5.844390e-001, -5.843688e-001, -5.842985e-001, -5.842282e-001, -5.841578e-001, -5.840875e-001, -5.840171e-001, -5.839466e-001, -5.838762e-001, -5.838057e-001, -5.837351e-001, -5.836646e-001, -5.835940e-001, -5.835234e-001, -5.834527e-001, -5.833821e-001, -5.833114e-001, -5.832406e-001, -5.831699e-001, -5.830991e-001, -5.830282e-001, -5.829574e-001, -5.828865e-001, -5.828156e-001, -5.827446e-001, -5.826737e-001, -5.826027e-001, -5.825316e-001, -5.824606e-001, -5.823895e-001, -5.823183e-001, -5.822472e-001, -5.821760e-001, -5.821048e-001, -5.820335e-001, -5.819623e-001, -5.818910e-001, -5.818196e-001, -5.817483e-001, -5.816769e-001, -5.816054e-001, -5.815340e-001, -5.814625e-001, -5.813910e-001, -5.813194e-001, -5.812479e-001, -5.811763e-001, -5.811046e-001, -5.810330e-001, -5.809613e-001, -5.808895e-001, -5.808178e-001, -5.807460e-001, -5.806742e-001, -5.806023e-001, -5.805305e-001, -5.804586e-001, -5.803866e-001, -5.803147e-001, -5.802427e-001, -5.801706e-001, -5.800986e-001, -5.800265e-001, -5.799544e-001, -5.798822e-001, -5.798101e-001, -5.797379e-001, -5.796656e-001, -5.795934e-001, -5.795211e-001, -5.794487e-001, -5.793764e-001, -5.793040e-001, -5.792316e-001, -5.791591e-001, -5.790867e-001, -5.790142e-001, -5.789416e-001, -5.788691e-001, -5.787965e-001, -5.787238e-001, -5.786512e-001, -5.785785e-001, -5.785058e-001, -5.784330e-001, -5.783603e-001, -5.782875e-001, -5.782146e-001, -5.781418e-001, -5.780689e-001, -5.779959e-001, -5.779230e-001, 
-5.778500e-001, -5.777770e-001, -5.777039e-001, -5.776309e-001, -5.775578e-001, -5.774846e-001, -5.774115e-001, -5.773383e-001, -5.772650e-001, -5.771918e-001, -5.771185e-001, -5.770452e-001, -5.769718e-001, -5.768985e-001, -5.768251e-001, -5.767516e-001, -5.766782e-001, -5.766047e-001, -5.765311e-001, -5.764576e-001, -5.763840e-001, -5.763104e-001, -5.762367e-001, -5.761631e-001, -5.760894e-001, -5.760156e-001, -5.759419e-001, -5.758681e-001, -5.757942e-001, -5.757204e-001, -5.756465e-001, -5.755726e-001, -5.754986e-001, -5.754247e-001, -5.753507e-001, -5.752766e-001, -5.752026e-001, -5.751285e-001, -5.750543e-001, -5.749802e-001, -5.749060e-001, -5.748318e-001, -5.747575e-001, -5.746833e-001, -5.746090e-001, -5.745346e-001, -5.744603e-001, -5.743859e-001, -5.743114e-001, -5.742370e-001, -5.741625e-001, -5.740880e-001, -5.740134e-001, -5.739389e-001, -5.738643e-001, -5.737896e-001, -5.737150e-001, -5.736403e-001, -5.735655e-001, -5.734908e-001, -5.734160e-001, -5.733412e-001, -5.732663e-001, -5.731915e-001, -5.731166e-001, -5.730416e-001, -5.729667e-001, -5.728917e-001, -5.728166e-001, -5.727416e-001, -5.726665e-001, -5.725914e-001, -5.725162e-001, -5.724411e-001, -5.723659e-001, -5.722906e-001, -5.722154e-001, -5.721401e-001, -5.720647e-001, -5.719894e-001, -5.719140e-001, -5.718386e-001, -5.717631e-001, -5.716877e-001, -5.716122e-001, -5.715366e-001, -5.714611e-001, -5.713855e-001, -5.713098e-001, -5.712342e-001, -5.711585e-001, -5.710828e-001, -5.710070e-001, -5.709313e-001, -5.708555e-001, -5.707796e-001, -5.707038e-001, -5.706279e-001, -5.705519e-001, -5.704760e-001, 
-5.704000e-001, -5.703240e-001, -5.702479e-001, -5.701719e-001, -5.700958e-001, -5.700196e-001, -5.699435e-001, -5.698673e-001, -5.697910e-001, -5.697148e-001, -5.696385e-001, -5.695622e-001, -5.694858e-001, -5.694095e-001, -5.693331e-001, -5.692566e-001, -5.691802e-001, -5.691037e-001, -5.690271e-001, -5.689506e-001, -5.688740e-001, -5.687974e-001, -5.687207e-001, -5.686441e-001, -5.685674e-001, -5.684906e-001, -5.684139e-001, -5.683371e-001, -5.682602e-001, -5.681834e-001, -5.681065e-001, -5.680296e-001, -5.679526e-001, -5.678757e-001, -5.677987e-001, -5.677216e-001, -5.676446e-001, -5.675675e-001, -5.674903e-001, -5.674132e-001, -5.673360e-001, -5.672588e-001, -5.671815e-001, -5.671043e-001, -5.670270e-001, -5.669496e-001, -5.668723e-001, -5.667949e-001, -5.667174e-001, -5.666400e-001, -5.665625e-001, -5.664850e-001, -5.664074e-001, -5.663299e-001, -5.662523e-001, -5.661746e-001, -5.660970e-001, -5.660193e-001, -5.659415e-001, -5.658638e-001, -5.657860e-001, -5.657082e-001, -5.656303e-001, -5.655525e-001, -5.654746e-001, -5.653966e-001, -5.653187e-001, -5.652407e-001, -5.651626e-001, -5.650846e-001, -5.650065e-001, -5.649284e-001, -5.648502e-001, -5.647721e-001, -5.646939e-001, -5.646156e-001, -5.645374e-001, -5.644591e-001, -5.643807e-001, -5.643024e-001, -5.642240e-001, -5.641456e-001, -5.640671e-001, -5.639887e-001, -5.639102e-001, -5.638316e-001, -5.637531e-001, -5.636745e-001, -5.635958e-001, -5.635172e-001, -5.634385e-001, -5.633598e-001, -5.632810e-001, -5.632023e-001, -5.631235e-001, -5.630446e-001, -5.629658e-001, -5.628869e-001, -5.628079e-001, -5.627290e-001, 
-5.626500e-001, -5.625710e-001, -5.624919e-001, -5.624129e-001, -5.623338e-001, -5.622546e-001, -5.621755e-001, -5.620963e-001, -5.620170e-001, -5.619378e-001, -5.618585e-001, -5.617792e-001, -5.616998e-001, -5.616205e-001, -5.615411e-001, -5.614616e-001, -5.613822e-001, -5.613027e-001, -5.612231e-001, -5.611436e-001, -5.610640e-001, -5.609844e-001, -5.609047e-001, -5.608251e-001, -5.607454e-001, -5.606656e-001, -5.605859e-001, -5.605061e-001, -5.604262e-001, -5.603464e-001, -5.602665e-001, -5.601866e-001, -5.601066e-001, -5.600267e-001, -5.599467e-001, -5.598666e-001, -5.597866e-001, -5.597065e-001, -5.596263e-001, -5.595462e-001, -5.594660e-001, -5.593858e-001, -5.593055e-001, -5.592253e-001, -5.591450e-001, -5.590646e-001, -5.589843e-001, -5.589039e-001, -5.588234e-001, -5.587430e-001, -5.586625e-001, -5.585820e-001, -5.585014e-001, -5.584209e-001, -5.583403e-001, -5.582596e-001, -5.581790e-001, -5.580983e-001, -5.580175e-001, -5.579368e-001, -5.578560e-001, -5.577752e-001, -5.576943e-001, -5.576135e-001, -5.575326e-001, -5.574516e-001, -5.573707e-001, -5.572897e-001, -5.572086e-001, -5.571276e-001, -5.570465e-001, -5.569654e-001, -5.568842e-001, -5.568031e-001, -5.567219e-001, -5.566406e-001, -5.565594e-001, -5.564781e-001, -5.563967e-001, -5.563154e-001, -5.562340e-001, -5.561526e-001, -5.560711e-001, -5.559897e-001, -5.559082e-001, -5.558266e-001, -5.557451e-001, -5.556635e-001, -5.555818e-001, -5.555002e-001, -5.554185e-001, -5.553368e-001, -5.552550e-001, -5.551733e-001, -5.550915e-001, -5.550096e-001, -5.549278e-001, -5.548459e-001, -5.547639e-001, -5.546820e-001, 
-5.546000e-001, -5.545180e-001, -5.544359e-001, -5.543539e-001, -5.542718e-001, -5.541896e-001, -5.541075e-001, -5.540253e-001, -5.539430e-001, -5.538608e-001, -5.537785e-001, -5.536962e-001, -5.536138e-001, -5.535315e-001, -5.534491e-001, -5.533666e-001, -5.532842e-001, -5.532017e-001, -5.531191e-001, -5.530366e-001, -5.529540e-001, -5.528714e-001, -5.527887e-001, -5.527061e-001, -5.526234e-001, -5.525406e-001, -5.524579e-001, -5.523751e-001, -5.522922e-001, -5.522094e-001, -5.521265e-001, -5.520436e-001, -5.519606e-001, -5.518777e-001, -5.517947e-001, -5.517116e-001, -5.516286e-001, -5.515455e-001, -5.514623e-001, -5.513792e-001, -5.512960e-001, -5.512128e-001, -5.511295e-001, -5.510463e-001, -5.509630e-001, -5.508796e-001, -5.507963e-001, -5.507129e-001, -5.506294e-001, -5.505460e-001, -5.504625e-001, -5.503790e-001, -5.502954e-001, -5.502119e-001, -5.501283e-001, -5.500446e-001, -5.499610e-001, -5.498773e-001, -5.497935e-001, -5.497098e-001, -5.496260e-001, -5.495422e-001, -5.494583e-001, -5.493745e-001, -5.492906e-001, -5.492066e-001, -5.491227e-001, -5.490387e-001, -5.489546e-001, -5.488706e-001, -5.487865e-001, -5.487024e-001, -5.486182e-001, -5.485341e-001, -5.484499e-001, -5.483656e-001, -5.482814e-001, -5.481971e-001, -5.481127e-001, -5.480284e-001, -5.479440e-001, -5.478596e-001, -5.477751e-001, -5.476907e-001, -5.476062e-001, -5.475216e-001, -5.474371e-001, -5.473525e-001, -5.472678e-001, -5.471832e-001, -5.470985e-001, -5.470138e-001, -5.469290e-001, -5.468443e-001, -5.467595e-001, -5.466746e-001, -5.465898e-001, -5.465049e-001, -5.464199e-001, -5.463350e-001, 
-5.462500e-001, -5.461650e-001, -5.460799e-001, -5.459949e-001, -5.459098e-001, -5.458246e-001, -5.457395e-001, -5.456543e-001, -5.455690e-001, -5.454838e-001, -5.453985e-001, -5.453132e-001, -5.452278e-001, -5.451425e-001, -5.450571e-001, -5.449716e-001, -5.448862e-001, -5.448007e-001, -5.447151e-001, -5.446296e-001, -5.445440e-001, -5.444584e-001, -5.443727e-001, -5.442871e-001, -5.442014e-001, -5.441156e-001, -5.440299e-001, -5.439441e-001, -5.438582e-001, -5.437724e-001, -5.436865e-001, -5.436006e-001, -5.435146e-001, -5.434287e-001, -5.433427e-001, -5.432566e-001, -5.431706e-001, -5.430845e-001, -5.429983e-001, -5.429122e-001, -5.428260e-001, -5.427398e-001, -5.426535e-001, -5.425673e-001, -5.424810e-001, -5.423946e-001, -5.423083e-001, -5.422219e-001, -5.421354e-001, -5.420490e-001, -5.419625e-001, -5.418760e-001, -5.417894e-001, -5.417029e-001, -5.416163e-001, -5.415296e-001, -5.414430e-001, -5.413563e-001, -5.412695e-001, -5.411828e-001, -5.410960e-001, -5.410092e-001, -5.409223e-001, -5.408355e-001, -5.407486e-001, -5.406616e-001, -5.405747e-001, -5.404877e-001, -5.404006e-001, -5.403136e-001, -5.402265e-001, -5.401394e-001, -5.400522e-001, -5.399651e-001, -5.398779e-001, -5.397906e-001, -5.397034e-001, -5.396161e-001, -5.395287e-001, -5.394414e-001, -5.393540e-001, -5.392666e-001, -5.391791e-001, -5.390917e-001, -5.390042e-001, -5.389166e-001, -5.388291e-001, -5.387415e-001, -5.386538e-001, -5.385662e-001, -5.384785e-001, -5.383908e-001, -5.383030e-001, -5.382153e-001, -5.381275e-001, -5.380396e-001, -5.379518e-001, -5.378639e-001, -5.377759e-001, -5.376880e-001, 
-5.376000e-001, -5.375120e-001, -5.374239e-001, -5.373359e-001, -5.372478e-001, -5.371596e-001, -5.370715e-001, -5.369833e-001, -5.368950e-001, -5.368068e-001, -5.367185e-001, -5.366302e-001, -5.365418e-001, -5.364535e-001, -5.363651e-001, -5.362766e-001, -5.361882e-001, -5.360997e-001, -5.360111e-001, -5.359226e-001, -5.358340e-001, -5.357454e-001, -5.356567e-001, -5.355681e-001, -5.354794e-001, -5.353906e-001, -5.353019e-001, -5.352131e-001, -5.351242e-001, -5.350354e-001, -5.349465e-001, -5.348576e-001, -5.347686e-001, -5.346797e-001, -5.345907e-001, -5.345016e-001, -5.344126e-001, -5.343235e-001, -5.342343e-001, -5.341452e-001, -5.340560e-001, -5.339668e-001, -5.338775e-001, -5.337883e-001, -5.336990e-001, -5.336096e-001, -5.335203e-001, -5.334309e-001, -5.333414e-001, -5.332520e-001, -5.331625e-001, -5.330730e-001, -5.329834e-001, -5.328939e-001, -5.328043e-001, -5.327146e-001, -5.326250e-001, -5.325353e-001, -5.324455e-001, -5.323558e-001, -5.322660e-001, -5.321762e-001, -5.320863e-001, -5.319965e-001, -5.319066e-001, -5.318166e-001, -5.317267e-001, -5.316367e-001, -5.315466e-001, -5.314566e-001, -5.313665e-001, -5.312764e-001, -5.311862e-001, -5.310961e-001, -5.310059e-001, -5.309156e-001, -5.308254e-001, -5.307351e-001, -5.306447e-001, -5.305544e-001, -5.304640e-001, -5.303736e-001, -5.302831e-001, -5.301927e-001, -5.301022e-001, -5.300116e-001, -5.299211e-001, -5.298305e-001, -5.297398e-001, -5.296492e-001, -5.295585e-001, -5.294678e-001, -5.293770e-001, -5.292863e-001, -5.291955e-001, -5.291046e-001, -5.290138e-001, -5.289229e-001, -5.288319e-001, -5.287410e-001, 
-5.286500e-001, -5.285590e-001, -5.284679e-001, -5.283769e-001, -5.282858e-001, -5.281946e-001, -5.281035e-001, -5.280123e-001, -5.279210e-001, -5.278298e-001, -5.277385e-001, -5.276472e-001, -5.275558e-001, -5.274645e-001, -5.273731e-001, -5.272816e-001, -5.271902e-001, -5.270987e-001, -5.270071e-001, -5.269156e-001, -5.268240e-001, -5.267324e-001, -5.266407e-001, -5.265491e-001, -5.264574e-001, -5.263656e-001, -5.262739e-001, -5.261821e-001, -5.260902e-001, -5.259984e-001, -5.259065e-001, -5.258146e-001, -5.257226e-001, -5.256307e-001, -5.255387e-001, -5.254466e-001, -5.253546e-001, -5.252625e-001, -5.251703e-001, -5.250782e-001, -5.249860e-001, -5.248938e-001, -5.248015e-001, -5.247093e-001, -5.246170e-001, -5.245246e-001, -5.244323e-001, -5.243399e-001, -5.242474e-001, -5.241550e-001, -5.240625e-001, -5.239700e-001, -5.238774e-001, -5.237849e-001, -5.236923e-001, -5.235996e-001, -5.235070e-001, -5.234143e-001, -5.233215e-001, -5.232288e-001, -5.231360e-001, -5.230432e-001, -5.229503e-001, -5.228575e-001, -5.227646e-001, -5.226716e-001, -5.225787e-001, -5.224857e-001, -5.223926e-001, -5.222996e-001, -5.222065e-001, -5.221134e-001, -5.220202e-001, -5.219271e-001, -5.218339e-001, -5.217406e-001, -5.216474e-001, -5.215541e-001, -5.214607e-001, -5.213674e-001, -5.212740e-001, -5.211806e-001, -5.210871e-001, -5.209937e-001, -5.209002e-001, -5.208066e-001, -5.207131e-001, -5.206195e-001, -5.205258e-001, -5.204322e-001, -5.203385e-001, -5.202448e-001, -5.201510e-001, -5.200573e-001, -5.199635e-001, -5.198696e-001, -5.197758e-001, -5.196819e-001, -5.195879e-001, -5.194940e-001, 
-5.194000e-001, -5.193060e-001, -5.192119e-001, -5.191179e-001, -5.190238e-001, -5.189296e-001, -5.188355e-001, -5.187413e-001, -5.186470e-001, -5.185528e-001, -5.184585e-001, -5.183642e-001, -5.182698e-001, -5.181755e-001, -5.180811e-001, -5.179866e-001, -5.178922e-001, -5.177977e-001, -5.177031e-001, -5.176086e-001, -5.175140e-001, -5.174194e-001, -5.173247e-001, -5.172301e-001, -5.171354e-001, -5.170406e-001, -5.169459e-001, -5.168511e-001, -5.167562e-001, -5.166614e-001, -5.165665e-001, -5.164716e-001, -5.163766e-001, -5.162817e-001, -5.161867e-001, -5.160916e-001, -5.159966e-001, -5.159015e-001, -5.158063e-001, -5.157112e-001, -5.156160e-001, -5.155208e-001, -5.154255e-001, -5.153303e-001, -5.152350e-001, -5.151396e-001, -5.150443e-001, -5.149489e-001, -5.148534e-001, -5.147580e-001, -5.146625e-001, -5.145670e-001, -5.144714e-001, -5.143759e-001, -5.142803e-001, -5.141846e-001, -5.140890e-001, -5.139933e-001, -5.138975e-001, -5.138018e-001, -5.137060e-001, -5.136102e-001, -5.135143e-001, -5.134185e-001, -5.133226e-001, -5.132266e-001, -5.131307e-001, -5.130347e-001, -5.129386e-001, -5.128426e-001, -5.127465e-001, -5.126504e-001, -5.125542e-001, -5.124581e-001, -5.123619e-001, -5.122656e-001, -5.121694e-001, -5.120731e-001, -5.119767e-001, -5.118804e-001, -5.117840e-001, -5.116876e-001, -5.115911e-001, -5.114947e-001, -5.113982e-001, -5.113016e-001, -5.112051e-001, -5.111085e-001, -5.110118e-001, -5.109152e-001, -5.108185e-001, -5.107218e-001, -5.106250e-001, -5.105283e-001, -5.104315e-001, -5.103346e-001, -5.102378e-001, -5.101409e-001, -5.100439e-001, -5.099470e-001, 
-5.098500e-001, -5.097530e-001, -5.096559e-001, -5.095589e-001, -5.094618e-001, -5.093646e-001, -5.092675e-001, -5.091703e-001, -5.090730e-001, -5.089758e-001, -5.088785e-001, -5.087812e-001, -5.086838e-001, -5.085865e-001, -5.084891e-001, -5.083916e-001, -5.082942e-001, -5.081967e-001, -5.080991e-001, -5.080016e-001, -5.079040e-001, -5.078064e-001, -5.077087e-001, -5.076111e-001, -5.075134e-001, -5.074156e-001, -5.073179e-001, -5.072201e-001, -5.071222e-001, -5.070244e-001, -5.069265e-001, -5.068286e-001, -5.067306e-001, -5.066327e-001, -5.065347e-001, -5.064366e-001, -5.063386e-001, -5.062405e-001, -5.061423e-001, -5.060442e-001, -5.059460e-001, -5.058478e-001, -5.057495e-001, -5.056513e-001, -5.055530e-001, -5.054546e-001, -5.053563e-001, -5.052579e-001, -5.051594e-001, -5.050610e-001, -5.049625e-001, -5.048640e-001, -5.047654e-001, -5.046669e-001, -5.045683e-001, -5.044696e-001, -5.043710e-001, -5.042723e-001, -5.041735e-001, -5.040748e-001, -5.039760e-001, -5.038772e-001, -5.037783e-001, -5.036795e-001, -5.035806e-001, -5.034816e-001, -5.033827e-001, -5.032837e-001, -5.031846e-001, -5.030856e-001, -5.029865e-001, -5.028874e-001, -5.027882e-001, -5.026891e-001, -5.025899e-001, -5.024906e-001, -5.023914e-001, -5.022921e-001, -5.021927e-001, -5.020934e-001, -5.019940e-001, -5.018946e-001, -5.017951e-001, -5.016957e-001, -5.015962e-001, -5.014966e-001, -5.013971e-001, -5.012975e-001, -5.011978e-001, -5.010982e-001, -5.009985e-001, -5.008988e-001, -5.007990e-001, -5.006993e-001, -5.005995e-001, -5.004996e-001, -5.003998e-001, -5.002999e-001, -5.001999e-001, -5.001000e-001, 
-5.000000e-001, -5.000000e-001
},
{
5.000000e-001, 5.001000e-001, 5.001999e-001, 5.002999e-001, 5.003998e-001, 5.004996e-001, 5.005995e-001, 5.006993e-001, 5.007990e-001, 5.008988e-001, 5.009985e-001, 5.010982e-001, 5.011978e-001, 5.012975e-001, 5.013971e-001, 5.014966e-001, 5.015962e-001, 5.016957e-001, 5.017951e-001, 5.018946e-001, 5.019940e-001, 5.020934e-001, 5.021927e-001, 5.022921e-001, 5.023914e-001, 5.024906e-001, 5.025899e-001, 5.026891e-001, 5.027882e-001, 5.028874e-001, 5.029865e-001, 5.030856e-001, 5.031846e-001, 5.032837e-001, 5.033827e-001, 5.034816e-001, 5.035806e-001, 5.036795e-001, 5.037783e-001, 5.038772e-001, 5.039760e-001, 5.040748e-001, 5.041735e-001, 5.042723e-001, 5.043710e-001, 5.044696e-001, 5.045683e-001, 5.046669e-001, 5.047654e-001, 5.048640e-001, 5.049625e-001, 5.050610e-001, 5.051594e-001, 5.052579e-001, 5.053563e-001, 5.054546e-001, 5.055530e-001, 5.056513e-001, 5.057495e-001, 5.058478e-001, 5.059460e-001, 5.060442e-001, 5.061423e-001, 5.062405e-001, 5.063386e-001, 5.064366e-001, 5.065347e-001, 5.066327e-001, 5.067306e-001, 5.068286e-001, 5.069265e-001, 5.070244e-001, 5.071222e-001, 5.072201e-001, 5.073179e-001, 5.074156e-001, 5.075134e-001, 5.076111e-001, 5.077087e-001, 5.078064e-001, 5.079040e-001, 5.080016e-001, 5.080991e-001, 5.081967e-001, 5.082942e-001, 5.083916e-001, 5.084891e-001, 5.085865e-001, 5.086838e-001, 5.087812e-001, 5.088785e-001, 5.089758e-001, 5.090730e-001, 5.091703e-001, 5.092675e-001, 5.093646e-001, 5.094618e-001, 5.095589e-001, 5.096559e-001, 5.097530e-001, 
5.098500e-001, 5.099470e-001, 5.100439e-001, 5.101409e-001, 5.102378e-001, 5.103346e-001, 5.104315e-001, 5.105283e-001, 5.106250e-001, 5.107218e-001, 5.108185e-001, 5.109152e-001, 5.110118e-001, 5.111085e-001, 5.112051e-001, 5.113016e-001, 5.113982e-001, 5.114947e-001, 5.115911e-001, 5.116876e-001, 5.117840e-001, 5.118804e-001, 5.119767e-001, 5.120731e-001, 5.121694e-001, 5.122656e-001, 5.123619e-001, 5.124581e-001, 5.125542e-001, 5.126504e-001, 5.127465e-001, 5.128426e-001, 5.129386e-001, 5.130347e-001, 5.131307e-001, 5.132266e-001, 5.133226e-001, 5.134185e-001, 5.135143e-001, 5.136102e-001, 5.137060e-001, 5.138018e-001, 5.138975e-001, 5.139933e-001, 5.140890e-001, 5.141846e-001, 5.142803e-001, 5.143759e-001, 5.144714e-001, 5.145670e-001, 5.146625e-001, 5.147580e-001, 5.148534e-001, 5.149489e-001, 5.150443e-001, 5.151396e-001, 5.152350e-001, 5.153303e-001, 5.154255e-001, 5.155208e-001, 5.156160e-001, 5.157112e-001, 5.158063e-001, 5.159015e-001, 5.159966e-001, 5.160916e-001, 5.161867e-001, 5.162817e-001, 5.163766e-001, 5.164716e-001, 5.165665e-001, 5.166614e-001, 5.167562e-001, 5.168511e-001, 5.169459e-001, 5.170406e-001, 5.171354e-001, 5.172301e-001, 5.173247e-001, 5.174194e-001, 5.175140e-001, 5.176086e-001, 5.177031e-001, 5.177977e-001, 5.178922e-001, 5.179866e-001, 5.180811e-001, 5.181755e-001, 5.182698e-001, 5.183642e-001, 5.184585e-001, 5.185528e-001, 5.186470e-001, 5.187413e-001, 5.188355e-001, 5.189296e-001, 5.190238e-001, 5.191179e-001, 5.192119e-001, 5.193060e-001, 
5.194000e-001, 5.194940e-001, 5.195879e-001, 5.196819e-001, 5.197758e-001, 5.198696e-001, 5.199635e-001, 5.200573e-001, 5.201510e-001, 5.202448e-001, 5.203385e-001, 5.204322e-001, 5.205258e-001, 5.206195e-001, 5.207131e-001, 5.208066e-001, 5.209002e-001, 5.209937e-001, 5.210871e-001, 5.211806e-001, 5.212740e-001, 5.213674e-001, 5.214607e-001, 5.215541e-001, 5.216474e-001, 5.217406e-001, 5.218339e-001, 5.219271e-001, 5.220202e-001, 5.221134e-001, 5.222065e-001, 5.222996e-001, 5.223926e-001, 5.224857e-001, 5.225787e-001, 5.226716e-001, 5.227646e-001, 5.228575e-001, 5.229503e-001, 5.230432e-001, 5.231360e-001, 5.232288e-001, 5.233215e-001, 5.234143e-001, 5.235070e-001, 5.235996e-001, 5.236923e-001, 5.237849e-001, 5.238774e-001, 5.239700e-001, 5.240625e-001, 5.241550e-001, 5.242474e-001, 5.243399e-001, 5.244323e-001, 5.245246e-001, 5.246170e-001, 5.247093e-001, 5.248015e-001, 5.248938e-001, 5.249860e-001, 5.250782e-001, 5.251703e-001, 5.252625e-001, 5.253546e-001, 5.254466e-001, 5.255387e-001, 5.256307e-001, 5.257226e-001, 5.258146e-001, 5.259065e-001, 5.259984e-001, 5.260902e-001, 5.261821e-001, 5.262739e-001, 5.263656e-001, 5.264574e-001, 5.265491e-001, 5.266407e-001, 5.267324e-001, 5.268240e-001, 5.269156e-001, 5.270071e-001, 5.270987e-001, 5.271902e-001, 5.272816e-001, 5.273731e-001, 5.274645e-001, 5.275558e-001, 5.276472e-001, 5.277385e-001, 5.278298e-001, 5.279210e-001, 5.280123e-001, 5.281035e-001, 5.281946e-001, 5.282858e-001, 5.283769e-001, 5.284679e-001, 5.285590e-001, 
5.286500e-001, 5.287410e-001, 5.288319e-001, 5.289229e-001, 5.290138e-001, 5.291046e-001, 5.291955e-001, 5.292863e-001, 5.293770e-001, 5.294678e-001, 5.295585e-001, 5.296492e-001, 5.297398e-001, 5.298305e-001, 5.299211e-001, 5.300116e-001, 5.301022e-001, 5.301927e-001, 5.302831e-001, 5.303736e-001, 5.304640e-001, 5.305544e-001, 5.306447e-001, 5.307351e-001, 5.308254e-001, 5.309156e-001, 5.310059e-001, 5.310961e-001, 5.311862e-001, 5.312764e-001, 5.313665e-001, 5.314566e-001, 5.315466e-001, 5.316367e-001, 5.317267e-001, 5.318166e-001, 5.319066e-001, 5.319965e-001, 5.320863e-001, 5.321762e-001, 5.322660e-001, 5.323558e-001, 5.324455e-001, 5.325353e-001, 5.326250e-001, 5.327146e-001, 5.328043e-001, 5.328939e-001, 5.329834e-001, 5.330730e-001, 5.331625e-001, 5.332520e-001, 5.333414e-001, 5.334309e-001, 5.335203e-001, 5.336096e-001, 5.336990e-001, 5.337883e-001, 5.338775e-001, 5.339668e-001, 5.340560e-001, 5.341452e-001, 5.342343e-001, 5.343235e-001, 5.344126e-001, 5.345016e-001, 5.345907e-001, 5.346797e-001, 5.347686e-001, 5.348576e-001, 5.349465e-001, 5.350354e-001, 5.351242e-001, 5.352131e-001, 5.353019e-001, 5.353906e-001, 5.354794e-001, 5.355681e-001, 5.356567e-001, 5.357454e-001, 5.358340e-001, 5.359226e-001, 5.360111e-001, 5.360997e-001, 5.361882e-001, 5.362766e-001, 5.363651e-001, 5.364535e-001, 5.365418e-001, 5.366302e-001, 5.367185e-001, 5.368068e-001, 5.368950e-001, 5.369833e-001, 5.370715e-001, 5.371596e-001, 5.372478e-001, 5.373359e-001, 5.374239e-001, 5.375120e-001, 
5.376000e-001, 5.376880e-001, 5.377759e-001, 5.378639e-001, 5.379518e-001, 5.380396e-001, 5.381275e-001, 5.382153e-001, 5.383030e-001, 5.383908e-001, 5.384785e-001, 5.385662e-001, 5.386538e-001, 5.387415e-001, 5.388291e-001, 5.389166e-001, 5.390042e-001, 5.390917e-001, 5.391791e-001, 5.392666e-001, 5.393540e-001, 5.394414e-001, 5.395287e-001, 5.396161e-001, 5.397034e-001, 5.397906e-001, 5.398779e-001, 5.399651e-001, 5.400522e-001, 5.401394e-001, 5.402265e-001, 5.403136e-001, 5.404006e-001, 5.404877e-001, 5.405747e-001, 5.406616e-001, 5.407486e-001, 5.408355e-001, 5.409223e-001, 5.410092e-001, 5.410960e-001, 5.411828e-001, 5.412695e-001, 5.413563e-001, 5.414430e-001, 5.415296e-001, 5.416163e-001, 5.417029e-001, 5.417894e-001, 5.418760e-001, 5.419625e-001, 5.420490e-001, 5.421354e-001, 5.422219e-001, 5.423083e-001, 5.423946e-001, 5.424810e-001, 5.425673e-001, 5.426535e-001, 5.427398e-001, 5.428260e-001, 5.429122e-001, 5.429983e-001, 5.430845e-001, 5.431706e-001, 5.432566e-001, 5.433427e-001, 5.434287e-001, 5.435146e-001, 5.436006e-001, 5.436865e-001, 5.437724e-001, 5.438582e-001, 5.439441e-001, 5.440299e-001, 5.441156e-001, 5.442014e-001, 5.442871e-001, 5.443727e-001, 5.444584e-001, 5.445440e-001, 5.446296e-001, 5.447151e-001, 5.448007e-001, 5.448862e-001, 5.449716e-001, 5.450571e-001, 5.451425e-001, 5.452278e-001, 5.453132e-001, 5.453985e-001, 5.454838e-001, 5.455690e-001, 5.456543e-001, 5.457395e-001, 5.458246e-001, 5.459098e-001, 5.459949e-001, 5.460799e-001, 5.461650e-001, 
5.462500e-001, 5.463350e-001, 5.464199e-001, 5.465049e-001, 5.465898e-001, 5.466746e-001, 5.467595e-001, 5.468443e-001, 5.469290e-001, 5.470138e-001, 5.470985e-001, 5.471832e-001, 5.472678e-001, 5.473525e-001, 5.474371e-001, 5.475216e-001, 5.476062e-001, 5.476907e-001, 5.477751e-001, 5.478596e-001, 5.479440e-001, 5.480284e-001, 5.481127e-001, 5.481971e-001, 5.482814e-001, 5.483656e-001, 5.484499e-001, 5.485341e-001, 5.486182e-001, 5.487024e-001, 5.487865e-001, 5.488706e-001, 5.489546e-001, 5.490387e-001, 5.491227e-001, 5.492066e-001, 5.492906e-001, 5.493745e-001, 5.494583e-001, 5.495422e-001, 5.496260e-001, 5.497098e-001, 5.497935e-001, 5.498773e-001, 5.499610e-001, 5.500446e-001, 5.501283e-001, 5.502119e-001, 5.502954e-001, 5.503790e-001, 5.504625e-001, 5.505460e-001, 5.506294e-001, 5.507129e-001, 5.507963e-001, 5.508796e-001, 5.509630e-001, 5.510463e-001, 5.511295e-001, 5.512128e-001, 5.512960e-001, 5.513792e-001, 5.514623e-001, 5.515455e-001, 5.516286e-001, 5.517116e-001, 5.517947e-001, 5.518777e-001, 5.519606e-001, 5.520436e-001, 5.521265e-001, 5.522094e-001, 5.522922e-001, 5.523751e-001, 5.524579e-001, 5.525406e-001, 5.526234e-001, 5.527061e-001, 5.527887e-001, 5.528714e-001, 5.529540e-001, 5.530366e-001, 5.531191e-001, 5.532017e-001, 5.532842e-001, 5.533666e-001, 5.534491e-001, 5.535315e-001, 5.536138e-001, 5.536962e-001, 5.537785e-001, 5.538608e-001, 5.539430e-001, 5.540253e-001, 5.541075e-001, 5.541896e-001, 5.542718e-001, 5.543539e-001, 5.544359e-001, 5.545180e-001, 
5.546000e-001, 5.546820e-001, 5.547639e-001, 5.548459e-001, 5.549278e-001, 5.550096e-001, 5.550915e-001, 5.551733e-001, 5.552550e-001, 5.553368e-001, 5.554185e-001, 5.555002e-001, 5.555818e-001, 5.556635e-001, 5.557451e-001, 5.558266e-001, 5.559082e-001, 5.559897e-001, 5.560711e-001, 5.561526e-001, 5.562340e-001, 5.563154e-001, 5.563967e-001, 5.564781e-001, 5.565594e-001, 5.566406e-001, 5.567219e-001, 5.568031e-001, 5.568842e-001, 5.569654e-001, 5.570465e-001, 5.571276e-001, 5.572086e-001, 5.572897e-001, 5.573707e-001, 5.574516e-001, 5.575326e-001, 5.576135e-001, 5.576943e-001, 5.577752e-001, 5.578560e-001, 5.579368e-001, 5.580175e-001, 5.580983e-001, 5.581790e-001, 5.582596e-001, 5.583403e-001, 5.584209e-001, 5.585014e-001, 5.585820e-001, 5.586625e-001, 5.587430e-001, 5.588234e-001, 5.589039e-001, 5.589843e-001, 5.590646e-001, 5.591450e-001, 5.592253e-001, 5.593055e-001, 5.593858e-001, 5.594660e-001, 5.595462e-001, 5.596263e-001, 5.597065e-001, 5.597866e-001, 5.598666e-001, 5.599467e-001, 5.600267e-001, 5.601066e-001, 5.601866e-001, 5.602665e-001, 5.603464e-001, 5.604262e-001, 5.605061e-001, 5.605859e-001, 5.606656e-001, 5.607454e-001, 5.608251e-001, 5.609047e-001, 5.609844e-001, 5.610640e-001, 5.611436e-001, 5.612231e-001, 5.613027e-001, 5.613822e-001, 5.614616e-001, 5.615411e-001, 5.616205e-001, 5.616998e-001, 5.617792e-001, 5.618585e-001, 5.619378e-001, 5.620170e-001, 5.620963e-001, 5.621755e-001, 5.622546e-001, 5.623338e-001, 5.624129e-001, 5.624919e-001, 5.625710e-001, 
5.626500e-001, 5.627290e-001, 5.628079e-001, 5.628869e-001, 5.629658e-001, 5.630446e-001, 5.631235e-001, 5.632023e-001, 5.632810e-001, 5.633598e-001, 5.634385e-001, 5.635172e-001, 5.635958e-001, 5.636745e-001, 5.637531e-001, 5.638316e-001, 5.639102e-001, 5.639887e-001, 5.640671e-001, 5.641456e-001, 5.642240e-001, 5.643024e-001, 5.643807e-001, 5.644591e-001, 5.645374e-001, 5.646156e-001, 5.646939e-001, 5.647721e-001, 5.648502e-001, 5.649284e-001, 5.650065e-001, 5.650846e-001, 5.651626e-001, 5.652407e-001, 5.653187e-001, 5.653966e-001, 5.654746e-001, 5.655525e-001, 5.656303e-001, 5.657082e-001, 5.657860e-001, 5.658638e-001, 5.659415e-001, 5.660193e-001, 5.660970e-001, 5.661746e-001, 5.662523e-001, 5.663299e-001, 5.664074e-001, 5.664850e-001, 5.665625e-001, 5.666400e-001, 5.667174e-001, 5.667949e-001, 5.668723e-001, 5.669496e-001, 5.670270e-001, 5.671043e-001, 5.671815e-001, 5.672588e-001, 5.673360e-001, 5.674132e-001, 5.674903e-001, 5.675675e-001, 5.676446e-001, 5.677216e-001, 5.677987e-001, 5.678757e-001, 5.679526e-001, 5.680296e-001, 5.681065e-001, 5.681834e-001, 5.682602e-001, 5.683371e-001, 5.684139e-001, 5.684906e-001, 5.685674e-001, 5.686441e-001, 5.687207e-001, 5.687974e-001, 5.688740e-001, 5.689506e-001, 5.690271e-001, 5.691037e-001, 5.691802e-001, 5.692566e-001, 5.693331e-001, 5.694095e-001, 5.694858e-001, 5.695622e-001, 5.696385e-001, 5.697148e-001, 5.697910e-001, 5.698673e-001, 5.699435e-001, 5.700196e-001, 5.700958e-001, 5.701719e-001, 5.702479e-001, 5.703240e-001, 
5.704000e-001, 5.704760e-001, 5.705519e-001, 5.706279e-001, 5.707038e-001, 5.707796e-001, 5.708555e-001, 5.709313e-001, 5.710070e-001, 5.710828e-001, 5.711585e-001, 5.712342e-001, 5.713098e-001, 5.713855e-001, 5.714611e-001, 5.715366e-001, 5.716122e-001, 5.716877e-001, 5.717631e-001, 5.718386e-001, 5.719140e-001, 5.719894e-001, 5.720647e-001, 5.721401e-001, 5.722154e-001, 5.722906e-001, 5.723659e-001, 5.724411e-001, 5.725162e-001, 5.725914e-001, 5.726665e-001, 5.727416e-001, 5.728166e-001, 5.728917e-001, 5.729667e-001, 5.730416e-001, 5.731166e-001, 5.731915e-001, 5.732663e-001, 5.733412e-001, 5.734160e-001, 5.734908e-001, 5.735655e-001, 5.736403e-001, 5.737150e-001, 5.737896e-001, 5.738643e-001, 5.739389e-001, 5.740134e-001, 5.740880e-001, 5.741625e-001, 5.742370e-001, 5.743114e-001, 5.743859e-001, 5.744603e-001, 5.745346e-001, 5.746090e-001, 5.746833e-001, 5.747575e-001, 5.748318e-001, 5.749060e-001, 5.749802e-001, 5.750543e-001, 5.751285e-001, 5.752026e-001, 5.752766e-001, 5.753507e-001, 5.754247e-001, 5.754986e-001, 5.755726e-001, 5.756465e-001, 5.757204e-001, 5.757942e-001, 5.758681e-001, 5.759419e-001, 5.760156e-001, 5.760894e-001, 5.761631e-001, 5.762367e-001, 5.763104e-001, 5.763840e-001, 5.764576e-001, 5.765311e-001, 5.766047e-001, 5.766782e-001, 5.767516e-001, 5.768251e-001, 5.768985e-001, 5.769718e-001, 5.770452e-001, 5.771185e-001, 5.771918e-001, 5.772650e-001, 5.773383e-001, 5.774115e-001, 5.774846e-001, 5.775578e-001, 5.776309e-001, 5.777039e-001, 5.777770e-001, 
5.778500e-001, 5.779230e-001, 5.779959e-001, 5.780689e-001, 5.781418e-001, 5.782146e-001, 5.782875e-001, 5.783603e-001, 5.784330e-001, 5.785058e-001, 5.785785e-001, 5.786512e-001, 5.787238e-001, 5.787965e-001, 5.788691e-001, 5.789416e-001, 5.790142e-001, 5.790867e-001, 5.791591e-001, 5.792316e-001, 5.793040e-001, 5.793764e-001, 5.794487e-001, 5.795211e-001, 5.795934e-001, 5.796656e-001, 5.797379e-001, 5.798101e-001, 5.798822e-001, 5.799544e-001, 5.800265e-001, 5.800986e-001, 5.801706e-001, 5.802427e-001, 5.803147e-001, 5.803866e-001, 5.804586e-001, 5.805305e-001, 5.806023e-001, 5.806742e-001, 5.807460e-001, 5.808178e-001, 5.808895e-001, 5.809613e-001, 5.810330e-001, 5.811046e-001, 5.811763e-001, 5.812479e-001, 5.813194e-001, 5.813910e-001, 5.814625e-001, 5.815340e-001, 5.816054e-001, 5.816769e-001, 5.817483e-001, 5.818196e-001, 5.818910e-001, 5.819623e-001, 5.820335e-001, 5.821048e-001, 5.821760e-001, 5.822472e-001, 5.823183e-001, 5.823895e-001, 5.824606e-001, 5.825316e-001, 5.826027e-001, 5.826737e-001, 5.827446e-001, 5.828156e-001, 5.828865e-001, 5.829574e-001, 5.830282e-001, 5.830991e-001, 5.831699e-001, 5.832406e-001, 5.833114e-001, 5.833821e-001, 5.834527e-001, 5.835234e-001, 5.835940e-001, 5.836646e-001, 5.837351e-001, 5.838057e-001, 5.838762e-001, 5.839466e-001, 5.840171e-001, 5.840875e-001, 5.841578e-001, 5.842282e-001, 5.842985e-001, 5.843688e-001, 5.844390e-001, 5.845093e-001, 5.845795e-001, 5.846496e-001, 5.847198e-001, 5.847899e-001, 5.848599e-001, 5.849300e-001, 
5.850000e-001, 5.850700e-001, 5.851399e-001, 5.852099e-001, 5.852798e-001, 5.853496e-001, 5.854195e-001, 5.854893e-001, 5.855590e-001, 5.856288e-001, 5.856985e-001, 5.857682e-001, 5.858378e-001, 5.859075e-001, 5.859771e-001, 5.860466e-001, 5.861162e-001, 5.861857e-001, 5.862551e-001, 5.863246e-001, 5.863940e-001, 5.864634e-001, 5.865327e-001, 5.866021e-001, 5.866714e-001, 5.867406e-001, 5.868099e-001, 5.868791e-001, 5.869482e-001, 5.870174e-001, 5.870865e-001, 5.871556e-001, 5.872246e-001, 5.872937e-001, 5.873627e-001, 5.874316e-001, 5.875006e-001, 5.875695e-001, 5.876383e-001, 5.877072e-001, 5.877760e-001, 5.878448e-001, 5.879135e-001, 5.879823e-001, 5.880510e-001, 5.881196e-001, 5.881883e-001, 5.882569e-001, 5.883254e-001, 5.883940e-001, 5.884625e-001, 5.885310e-001, 5.885994e-001, 5.886679e-001, 5.887363e-001, 5.888046e-001, 5.888730e-001, 5.889413e-001, 5.890095e-001, 5.890778e-001, 5.891460e-001, 5.892142e-001, 5.892823e-001, 5.893505e-001, 5.894186e-001, 5.894866e-001, 5.895547e-001, 5.896227e-001, 5.896906e-001, 5.897586e-001, 5.898265e-001, 5.898944e-001, 5.899622e-001, 5.900301e-001, 5.900979e-001, 5.901656e-001, 5.902334e-001, 5.903011e-001, 5.903687e-001, 5.904364e-001, 5.905040e-001, 5.905716e-001, 5.906391e-001, 5.907067e-001, 5.907742e-001, 5.908416e-001, 5.909091e-001, 5.909765e-001, 5.910438e-001, 5.911112e-001, 5.911785e-001, 5.912458e-001, 5.913130e-001, 5.913803e-001, 5.914475e-001, 5.915146e-001, 5.915818e-001, 5.916489e-001, 5.917159e-001, 5.917830e-001, 
5.918500e-001, 5.919170e-001, 5.919839e-001, 5.920509e-001, 5.921178e-001, 5.921846e-001, 5.922515e-001, 5.923183e-001, 5.923850e-001, 5.924518e-001, 5.925185e-001, 5.925852e-001, 5.926518e-001, 5.927185e-001, 5.927851e-001, 5.928516e-001, 5.929182e-001, 5.929847e-001, 5.930511e-001, 5.931176e-001, 5.931840e-001, 5.932504e-001, 5.933167e-001, 5.933831e-001, 5.934494e-001, 5.935156e-001, 5.935819e-001, 5.936481e-001, 5.937142e-001, 5.937804e-001, 5.938465e-001, 5.939126e-001, 5.939786e-001, 5.940447e-001, 5.941107e-001, 5.941766e-001, 5.942426e-001, 5.943085e-001, 5.943743e-001, 5.944402e-001, 5.945060e-001, 5.945718e-001, 5.946375e-001, 5.947033e-001, 5.947690e-001, 5.948346e-001, 5.949003e-001, 5.949659e-001, 5.950314e-001, 5.950970e-001, 5.951625e-001, 5.952280e-001, 5.952934e-001, 5.953589e-001, 5.954243e-001, 5.954896e-001, 5.955550e-001, 5.956203e-001, 5.956855e-001, 5.957508e-001, 5.958160e-001, 5.958812e-001, 5.959463e-001, 5.960115e-001, 5.960766e-001, 5.961416e-001, 5.962067e-001, 5.962717e-001, 5.963366e-001, 5.964016e-001, 5.964665e-001, 5.965314e-001, 5.965962e-001, 5.966611e-001, 5.967259e-001, 5.967906e-001, 5.968554e-001, 5.969201e-001, 5.969847e-001, 5.970494e-001, 5.971140e-001, 5.971786e-001, 5.972431e-001, 5.973077e-001, 5.973722e-001, 5.974366e-001, 5.975011e-001, 5.975655e-001, 5.976298e-001, 5.976942e-001, 5.977585e-001, 5.978228e-001, 5.978870e-001, 5.979513e-001, 5.980155e-001, 5.980796e-001, 5.981438e-001, 5.982079e-001, 5.982719e-001, 5.983360e-001, 
5.984000e-001, 5.984640e-001, 5.985279e-001, 5.985919e-001, 5.986558e-001, 5.987196e-001, 5.987835e-001, 5.988473e-001, 5.989110e-001, 5.989748e-001, 5.990385e-001, 5.991022e-001, 5.991658e-001, 5.992295e-001, 5.992931e-001, 5.993566e-001, 5.994202e-001, 5.994837e-001, 5.995471e-001, 5.996106e-001, 5.996740e-001, 5.997374e-001, 5.998007e-001, 5.998641e-001, 5.999274e-001, 5.999906e-001, 6.000539e-001, 6.001171e-001, 6.001802e-001, 6.002434e-001, 6.003065e-001, 6.003696e-001, 6.004326e-001, 6.004957e-001, 6.005587e-001, 6.006216e-001, 6.006846e-001, 6.007475e-001, 6.008103e-001, 6.008732e-001, 6.009360e-001, 6.009988e-001, 6.010615e-001, 6.011243e-001, 6.011870e-001, 6.012496e-001, 6.013123e-001, 6.013749e-001, 6.014374e-001, 6.015000e-001, 6.015625e-001, 6.016250e-001, 6.016874e-001, 6.017499e-001, 6.018123e-001, 6.018746e-001, 6.019370e-001, 6.019993e-001, 6.020615e-001, 6.021238e-001, 6.021860e-001, 6.022482e-001, 6.023103e-001, 6.023725e-001, 6.024346e-001, 6.024966e-001, 6.025587e-001, 6.026207e-001, 6.026826e-001, 6.027446e-001, 6.028065e-001, 6.028684e-001, 6.029302e-001, 6.029921e-001, 6.030539e-001, 6.031156e-001, 6.031774e-001, 6.032391e-001, 6.033007e-001, 6.033624e-001, 6.034240e-001, 6.034856e-001, 6.035471e-001, 6.036087e-001, 6.036702e-001, 6.037316e-001, 6.037931e-001, 6.038545e-001, 6.039158e-001, 6.039772e-001, 6.040385e-001, 6.040998e-001, 6.041610e-001, 6.042223e-001, 6.042835e-001, 6.043446e-001, 6.044058e-001, 6.044669e-001, 6.045279e-001, 6.045890e-001, 
6.046500e-001, 6.047110e-001, 6.047719e-001, 6.048329e-001, 6.048938e-001, 6.049546e-001, 6.050155e-001, 6.050763e-001, 6.051370e-001, 6.051978e-001, 6.052585e-001, 6.053192e-001, 6.053798e-001, 6.054405e-001, 6.055011e-001, 6.055616e-001, 6.056222e-001, 6.056827e-001, 6.057431e-001, 6.058036e-001, 6.058640e-001, 6.059244e-001, 6.059847e-001, 6.060451e-001, 6.061054e-001, 6.061656e-001, 6.062259e-001, 6.062861e-001, 6.063462e-001, 6.064064e-001, 6.064665e-001, 6.065266e-001, 6.065866e-001, 6.066467e-001, 6.067067e-001, 6.067666e-001, 6.068266e-001, 6.068865e-001, 6.069463e-001, 6.070062e-001, 6.070660e-001, 6.071258e-001, 6.071855e-001, 6.072453e-001, 6.073050e-001, 6.073646e-001, 6.074243e-001, 6.074839e-001, 6.075434e-001, 6.076030e-001, 6.076625e-001, 6.077220e-001, 6.077814e-001, 6.078409e-001, 6.079003e-001, 6.079596e-001, 6.080190e-001, 6.080783e-001, 6.081375e-001, 6.081968e-001, 6.082560e-001, 6.083152e-001, 6.083743e-001, 6.084335e-001, 6.084926e-001, 6.085516e-001, 6.086107e-001, 6.086697e-001, 6.087286e-001, 6.087876e-001, 6.088465e-001, 6.089054e-001, 6.089642e-001, 6.090231e-001, 6.090819e-001, 6.091406e-001, 6.091994e-001, 6.092581e-001, 6.093167e-001, 6.093754e-001, 6.094340e-001, 6.094926e-001, 6.095511e-001, 6.096097e-001, 6.096682e-001, 6.097266e-001, 6.097851e-001, 6.098435e-001, 6.099018e-001, 6.099602e-001, 6.100185e-001, 6.100768e-001, 6.101350e-001, 6.101933e-001, 6.102515e-001, 6.103096e-001, 6.103678e-001, 6.104259e-001, 6.104839e-001, 6.105420e-001, 
6.106000e-001, 6.106580e-001, 6.107159e-001, 6.107739e-001, 6.108318e-001, 6.108896e-001, 6.109475e-001, 6.110053e-001, 6.110630e-001, 6.111208e-001, 6.111785e-001, 6.112362e-001, 6.112938e-001, 6.113515e-001, 6.114091e-001, 6.114666e-001, 6.115242e-001, 6.115817e-001, 6.116391e-001, 6.116966e-001, 6.117540e-001, 6.118114e-001, 6.118687e-001, 6.119261e-001, 6.119834e-001, 6.120406e-001, 6.120979e-001, 6.121551e-001, 6.122122e-001, 6.122694e-001, 6.123265e-001, 6.123836e-001, 6.124406e-001, 6.124977e-001, 6.125547e-001, 6.126116e-001, 6.126686e-001, 6.127255e-001, 6.127823e-001, 6.128392e-001, 6.128960e-001, 6.129528e-001, 6.130095e-001, 6.130663e-001, 6.131230e-001, 6.131796e-001, 6.132363e-001, 6.132929e-001, 6.133494e-001, 6.134060e-001, 6.134625e-001, 6.135190e-001, 6.135754e-001, 6.136319e-001, 6.136883e-001, 6.137446e-001, 6.138010e-001, 6.138573e-001, 6.139135e-001, 6.139698e-001, 6.140260e-001, 6.140822e-001, 6.141383e-001, 6.141945e-001, 6.142506e-001, 6.143066e-001, 6.143627e-001, 6.144187e-001, 6.144746e-001, 6.145306e-001, 6.145865e-001, 6.146424e-001, 6.146982e-001, 6.147541e-001, 6.148099e-001, 6.148656e-001, 6.149214e-001, 6.149771e-001, 6.150327e-001, 6.150884e-001, 6.151440e-001, 6.151996e-001, 6.152551e-001, 6.153107e-001, 6.153662e-001, 6.154216e-001, 6.154771e-001, 6.155325e-001, 6.155878e-001, 6.156432e-001, 6.156985e-001, 6.157538e-001, 6.158090e-001, 6.158643e-001, 6.159195e-001, 6.159746e-001, 6.160298e-001, 6.160849e-001, 6.161399e-001, 6.161950e-001, 
6.162500e-001, 6.163050e-001, 6.163599e-001, 6.164149e-001, 6.164698e-001, 6.165246e-001, 6.165795e-001, 6.166343e-001, 6.166890e-001, 6.167438e-001, 6.167985e-001, 6.168532e-001, 6.169078e-001, 6.169625e-001, 6.170171e-001, 6.170716e-001, 6.171262e-001, 6.171807e-001, 6.172351e-001, 6.172896e-001, 6.173440e-001, 6.173984e-001, 6.174527e-001, 6.175071e-001, 6.175614e-001, 6.176156e-001, 6.176699e-001, 6.177241e-001, 6.177782e-001, 6.178324e-001, 6.178865e-001, 6.179406e-001, 6.179946e-001, 6.180487e-001, 6.181027e-001, 6.181566e-001, 6.182106e-001, 6.182645e-001, 6.183183e-001, 6.183722e-001, 6.184260e-001, 6.184798e-001, 6.185335e-001, 6.185873e-001, 6.186410e-001, 6.186946e-001, 6.187483e-001, 6.188019e-001, 6.188554e-001, 6.189090e-001, 6.189625e-001, 6.190160e-001, 6.190694e-001, 6.191229e-001, 6.191763e-001, 6.192296e-001, 6.192830e-001, 6.193363e-001, 6.193895e-001, 6.194428e-001, 6.194960e-001, 6.195492e-001, 6.196023e-001, 6.196555e-001, 6.197086e-001, 6.197616e-001, 6.198147e-001, 6.198677e-001, 6.199206e-001, 6.199736e-001, 6.200265e-001, 6.200794e-001, 6.201322e-001, 6.201851e-001, 6.202379e-001, 6.202906e-001, 6.203434e-001, 6.203961e-001, 6.204487e-001, 6.205014e-001, 6.205540e-001, 6.206066e-001, 6.206591e-001, 6.207117e-001, 6.207642e-001, 6.208166e-001, 6.208691e-001, 6.209215e-001, 6.209738e-001, 6.210262e-001, 6.210785e-001, 6.211308e-001, 6.211830e-001, 6.212353e-001, 6.212875e-001, 6.213396e-001, 6.213918e-001, 6.214439e-001, 6.214959e-001, 6.215480e-001, 
6.216000e-001, 6.216520e-001, 6.217039e-001, 6.217559e-001, 6.218078e-001, 6.218596e-001, 6.219115e-001, 6.219633e-001, 6.220150e-001, 6.220668e-001, 6.221185e-001, 6.221702e-001, 6.222218e-001, 6.222735e-001, 6.223251e-001, 6.223766e-001, 6.224282e-001, 6.224797e-001, 6.225311e-001, 6.225826e-001, 6.226340e-001, 6.226854e-001, 6.227367e-001, 6.227881e-001, 6.228394e-001, 6.228906e-001, 6.229419e-001, 6.229931e-001, 6.230442e-001, 6.230954e-001, 6.231465e-001, 6.231976e-001, 6.232486e-001, 6.232997e-001, 6.233507e-001, 6.234016e-001, 6.234526e-001, 6.235035e-001, 6.235543e-001, 6.236052e-001, 6.236560e-001, 6.237068e-001, 6.237575e-001, 6.238083e-001, 6.238590e-001, 6.239096e-001, 6.239603e-001, 6.240109e-001, 6.240614e-001, 6.241120e-001, 6.241625e-001, 6.242130e-001, 6.242634e-001, 6.243139e-001, 6.243643e-001, 6.244146e-001, 6.244650e-001, 6.245153e-001, 6.245655e-001, 6.246158e-001, 6.246660e-001, 6.247162e-001, 6.247663e-001, 6.248165e-001, 6.248666e-001, 6.249166e-001, 6.249667e-001, 6.250167e-001, 6.250666e-001, 6.251166e-001, 6.251665e-001, 6.252164e-001, 6.252662e-001, 6.253161e-001, 6.253659e-001, 6.254156e-001, 6.254654e-001, 6.255151e-001, 6.255647e-001, 6.256144e-001, 6.256640e-001, 6.257136e-001, 6.257631e-001, 6.258127e-001, 6.258622e-001, 6.259116e-001, 6.259611e-001, 6.260105e-001, 6.260598e-001, 6.261092e-001, 6.261585e-001, 6.262078e-001, 6.262570e-001, 6.263063e-001, 6.263555e-001, 6.264046e-001, 6.264538e-001, 6.265029e-001, 6.265519e-001, 6.266010e-001, 
6.266500e-001, 6.266990e-001, 6.267479e-001, 6.267969e-001, 6.268458e-001, 6.268946e-001, 6.269435e-001, 6.269923e-001, 6.270410e-001, 6.270898e-001, 6.271385e-001, 6.271872e-001, 6.272358e-001, 6.272845e-001, 6.273331e-001, 6.273816e-001, 6.274302e-001, 6.274787e-001, 6.275271e-001, 6.275756e-001, 6.276240e-001, 6.276724e-001, 6.277207e-001, 6.277691e-001, 6.278174e-001, 6.278656e-001, 6.279139e-001, 6.279621e-001, 6.280102e-001, 6.280584e-001, 6.281065e-001, 6.281546e-001, 6.282026e-001, 6.282507e-001, 6.282987e-001, 6.283466e-001, 6.283946e-001, 6.284425e-001, 6.284903e-001, 6.285382e-001, 6.285860e-001, 6.286338e-001, 6.286815e-001, 6.287293e-001, 6.287770e-001, 6.288246e-001, 6.288723e-001, 6.289199e-001, 6.289674e-001, 6.290150e-001, 6.290625e-001, 6.291100e-001, 6.291574e-001, 6.292049e-001, 6.292523e-001, 6.292996e-001, 6.293470e-001, 6.293943e-001, 6.294415e-001, 6.294888e-001, 6.295360e-001, 6.295832e-001, 6.296303e-001, 6.296775e-001, 6.297246e-001, 6.297716e-001, 6.298187e-001, 6.298657e-001, 6.299126e-001, 6.299596e-001, 6.300065e-001, 6.300534e-001, 6.301002e-001, 6.301471e-001, 6.301939e-001, 6.302406e-001, 6.302874e-001, 6.303341e-001, 6.303807e-001, 6.304274e-001, 6.304740e-001, 6.305206e-001, 6.305671e-001, 6.306137e-001, 6.306602e-001, 6.307066e-001, 6.307531e-001, 6.307995e-001, 6.308458e-001, 6.308922e-001, 6.309385e-001, 6.309848e-001, 6.310310e-001, 6.310773e-001, 6.311235e-001, 6.311696e-001, 6.312158e-001, 6.312619e-001, 6.313079e-001, 6.313540e-001, 
6.314000e-001, 6.314460e-001, 6.314919e-001, 6.315379e-001, 6.315838e-001, 6.316296e-001, 6.316755e-001, 6.317213e-001, 6.317670e-001, 6.318128e-001, 6.318585e-001, 6.319042e-001, 6.319498e-001, 6.319955e-001, 6.320411e-001, 6.320866e-001, 6.321322e-001, 6.321777e-001, 6.322231e-001, 6.322686e-001, 6.323140e-001, 6.323594e-001, 6.324047e-001, 6.324501e-001, 6.324954e-001, 6.325406e-001, 6.325859e-001, 6.326311e-001, 6.326762e-001, 6.327214e-001, 6.327665e-001, 6.328116e-001, 6.328566e-001, 6.329017e-001, 6.329467e-001, 6.329916e-001, 6.330366e-001, 6.330815e-001, 6.331263e-001, 6.331712e-001, 6.332160e-001, 6.332608e-001, 6.333055e-001, 6.333503e-001, 6.333950e-001, 6.334396e-001, 6.334843e-001, 6.335289e-001, 6.335734e-001, 6.336180e-001, 6.336625e-001, 6.337070e-001, 6.337514e-001, 6.337959e-001, 6.338403e-001, 6.338846e-001, 6.339290e-001, 6.339733e-001, 6.340175e-001, 6.340618e-001, 6.341060e-001, 6.341502e-001, 6.341943e-001, 6.342385e-001, 6.342826e-001, 6.343266e-001, 6.343707e-001, 6.344147e-001, 6.344586e-001, 6.345026e-001, 6.345465e-001, 6.345904e-001, 6.346342e-001, 6.346781e-001, 6.347219e-001, 6.347656e-001, 6.348094e-001, 6.348531e-001, 6.348967e-001, 6.349404e-001, 6.349840e-001, 6.350276e-001, 6.350711e-001, 6.351147e-001, 6.351582e-001, 6.352016e-001, 6.352451e-001, 6.352885e-001, 6.353318e-001, 6.353752e-001, 6.354185e-001, 6.354618e-001, 6.355050e-001, 6.355483e-001, 6.355915e-001, 6.356346e-001, 6.356778e-001, 6.357209e-001, 6.357639e-001, 6.358070e-001, 
6.358500e-001, 6.358930e-001, 6.359359e-001, 6.359789e-001, 6.360218e-001, 6.360646e-001, 6.361075e-001, 6.361503e-001, 6.361930e-001, 6.362358e-001, 6.362785e-001, 6.363212e-001, 6.363638e-001, 6.364065e-001, 6.364491e-001, 6.364916e-001, 6.365342e-001, 6.365767e-001, 6.366191e-001, 6.366616e-001, 6.367040e-001, 6.367464e-001, 6.367887e-001, 6.368311e-001, 6.368734e-001, 6.369156e-001, 6.369579e-001, 6.370001e-001, 6.370422e-001, 6.370844e-001, 6.371265e-001, 6.371686e-001, 6.372106e-001, 6.372527e-001, 6.372947e-001, 6.373366e-001, 6.373786e-001, 6.374205e-001, 6.374623e-001, 6.375042e-001, 6.375460e-001, 6.375878e-001, 6.376295e-001, 6.376713e-001, 6.377130e-001, 6.377546e-001, 6.377963e-001, 6.378379e-001, 6.378794e-001, 6.379210e-001, 6.379625e-001, 6.380040e-001, 6.380454e-001, 6.380869e-001, 6.381283e-001, 6.381696e-001, 6.382110e-001, 6.382523e-001, 6.382935e-001, 6.383348e-001, 6.383760e-001, 6.384172e-001, 6.384583e-001, 6.384995e-001, 6.385406e-001, 6.385816e-001, 6.386227e-001, 6.386637e-001, 6.387046e-001, 6.387456e-001, 6.387865e-001, 6.388274e-001, 6.388682e-001, 6.389091e-001, 6.389499e-001, 6.389906e-001, 6.390314e-001, 6.390721e-001, 6.391127e-001, 6.391534e-001, 6.391940e-001, 6.392346e-001, 6.392751e-001, 6.393157e-001, 6.393562e-001, 6.393966e-001, 6.394371e-001, 6.394775e-001, 6.395178e-001, 6.395582e-001, 6.395985e-001, 6.396388e-001, 6.396790e-001, 6.397193e-001, 6.397595e-001, 6.397996e-001, 6.398398e-001, 6.398799e-001, 6.399199e-001, 6.399600e-001, 
6.400000e-001, 6.400400e-001, 6.400799e-001, 6.401199e-001, 6.401598e-001, 6.401996e-001, 6.402395e-001, 6.402793e-001, 6.403190e-001, 6.403588e-001, 6.403985e-001, 6.404382e-001, 6.404778e-001, 6.405175e-001, 6.405571e-001, 6.405966e-001, 6.406362e-001, 6.406757e-001, 6.407151e-001, 6.407546e-001, 6.407940e-001, 6.408334e-001, 6.408727e-001, 6.409121e-001, 6.409514e-001, 6.409906e-001, 6.410299e-001, 6.410691e-001, 6.411082e-001, 6.411474e-001, 6.411865e-001, 6.412256e-001, 6.412646e-001, 6.413037e-001, 6.413427e-001, 6.413816e-001, 6.414206e-001, 6.414595e-001, 6.414983e-001, 6.415372e-001, 6.415760e-001, 6.416148e-001, 6.416535e-001, 6.416923e-001, 6.417310e-001, 6.417696e-001, 6.418083e-001, 6.418469e-001, 6.418854e-001, 6.419240e-001, 6.419625e-001, 6.420010e-001, 6.420394e-001, 6.420779e-001, 6.421163e-001, 6.421546e-001, 6.421930e-001, 6.422313e-001, 6.422695e-001, 6.423078e-001, 6.423460e-001, 6.423842e-001, 6.424223e-001, 6.424605e-001, 6.424986e-001, 6.425366e-001, 6.425747e-001, 6.426127e-001, 6.426506e-001, 6.426886e-001, 6.427265e-001, 6.427644e-001, 6.428022e-001, 6.428401e-001, 6.428779e-001, 6.429156e-001, 6.429534e-001, 6.429911e-001, 6.430287e-001, 6.430664e-001, 6.431040e-001, 6.431416e-001, 6.431791e-001, 6.432167e-001, 6.432542e-001, 6.432916e-001, 6.433291e-001, 6.433665e-001, 6.434038e-001, 6.434412e-001, 6.434785e-001, 6.435158e-001, 6.435530e-001, 6.435903e-001, 6.436275e-001, 6.436646e-001, 6.437018e-001, 6.437389e-001, 6.437759e-001, 6.438130e-001, 
6.438500e-001, 6.438870e-001, 6.439239e-001, 6.439609e-001, 6.439978e-001, 6.440346e-001, 6.440715e-001, 6.441083e-001, 6.441450e-001, 6.441818e-001, 6.442185e-001, 6.442552e-001, 6.442918e-001, 6.443285e-001, 6.443651e-001, 6.444016e-001, 6.444382e-001, 6.444747e-001, 6.445111e-001, 6.445476e-001, 6.445840e-001, 6.446204e-001, 6.446567e-001, 6.446931e-001, 6.447294e-001, 6.447656e-001, 6.448019e-001, 6.448381e-001, 6.448742e-001, 6.449104e-001, 6.449465e-001, 6.449826e-001, 6.450186e-001, 6.450547e-001, 6.450907e-001, 6.451266e-001, 6.451626e-001, 6.451985e-001, 6.452343e-001, 6.452702e-001, 6.453060e-001, 6.453418e-001, 6.453775e-001, 6.454133e-001, 6.454490e-001, 6.454846e-001, 6.455203e-001, 6.455559e-001, 6.455914e-001, 6.456270e-001, 6.456625e-001, 6.456980e-001, 6.457334e-001, 6.457689e-001, 6.458043e-001, 6.458396e-001, 6.458750e-001, 6.459103e-001, 6.459455e-001, 6.459808e-001, 6.460160e-001, 6.460512e-001, 6.460863e-001, 6.461215e-001, 6.461566e-001, 6.461916e-001, 6.462267e-001, 6.462617e-001, 6.462966e-001, 6.463316e-001, 6.463665e-001, 6.464014e-001, 6.464362e-001, 6.464711e-001, 6.465059e-001, 6.465406e-001, 6.465754e-001, 6.466101e-001, 6.466447e-001, 6.466794e-001, 6.467140e-001, 6.467486e-001, 6.467831e-001, 6.468177e-001, 6.468522e-001, 6.468866e-001, 6.469211e-001, 6.469555e-001, 6.469898e-001, 6.470242e-001, 6.470585e-001, 6.470928e-001, 6.471270e-001, 6.471613e-001, 6.471955e-001, 6.472296e-001, 6.472638e-001, 6.472979e-001, 6.473319e-001, 6.473660e-001, 
6.474000e-001, 6.474340e-001, 6.474679e-001, 6.475019e-001, 6.475358e-001, 6.475696e-001, 6.476035e-001, 6.476373e-001, 6.476710e-001, 6.477048e-001, 6.477385e-001, 6.477722e-001, 6.478058e-001, 6.478395e-001, 6.478731e-001, 6.479066e-001, 6.479402e-001, 6.479737e-001, 6.480071e-001, 6.480406e-001, 6.480740e-001, 6.481074e-001, 6.481407e-001, 6.481741e-001, 6.482074e-001, 6.482406e-001, 6.482739e-001, 6.483071e-001, 6.483402e-001, 6.483734e-001, 6.484065e-001, 6.484396e-001, 6.484726e-001, 6.485057e-001, 6.485387e-001, 6.485716e-001, 6.486046e-001, 6.486375e-001, 6.486703e-001, 6.487032e-001, 6.487360e-001, 6.487688e-001, 6.488015e-001, 6.488343e-001, 6.488670e-001, 6.488996e-001, 6.489323e-001, 6.489649e-001, 6.489974e-001, 6.490300e-001, 6.490625e-001, 6.490950e-001, 6.491274e-001, 6.491599e-001, 6.491923e-001, 6.492246e-001, 6.492570e-001, 6.492893e-001, 6.493215e-001, 6.493538e-001, 6.493860e-001, 6.494182e-001, 6.494503e-001, 6.494825e-001, 6.495146e-001, 6.495466e-001, 6.495787e-001, 6.496107e-001, 6.496426e-001, 6.496746e-001, 6.497065e-001, 6.497384e-001, 6.497702e-001, 6.498021e-001, 6.498339e-001, 6.498656e-001, 6.498974e-001, 6.499291e-001, 6.499607e-001, 6.499924e-001, 6.500240e-001, 6.500556e-001, 6.500871e-001, 6.501187e-001, 6.501502e-001, 6.501816e-001, 6.502131e-001, 6.502445e-001, 6.502758e-001, 6.503072e-001, 6.503385e-001, 6.503698e-001, 6.504010e-001, 6.504323e-001, 6.504635e-001, 6.504946e-001, 6.505258e-001, 6.505569e-001, 6.505879e-001, 6.506190e-001, 
6.506500e-001, 6.506810e-001, 6.507119e-001, 6.507429e-001, 6.507738e-001, 6.508046e-001, 6.508355e-001, 6.508663e-001, 6.508970e-001, 6.509278e-001, 6.509585e-001, 6.509892e-001, 6.510198e-001, 6.510505e-001, 6.510811e-001, 6.511116e-001, 6.511422e-001, 6.511727e-001, 6.512031e-001, 6.512336e-001, 6.512640e-001, 6.512944e-001, 6.513247e-001, 6.513551e-001, 6.513854e-001, 6.514156e-001, 6.514459e-001, 6.514761e-001, 6.515062e-001, 6.515364e-001, 6.515665e-001, 6.515966e-001, 6.516266e-001, 6.516567e-001, 6.516867e-001, 6.517166e-001, 6.517466e-001, 6.517765e-001, 6.518063e-001, 6.518362e-001, 6.518660e-001, 6.518958e-001, 6.519255e-001, 6.519553e-001, 6.519850e-001, 6.520146e-001, 6.520443e-001, 6.520739e-001, 6.521034e-001, 6.521330e-001, 6.521625e-001, 6.521920e-001, 6.522214e-001, 6.522509e-001, 6.522803e-001, 6.523096e-001, 6.523390e-001, 6.523683e-001, 6.523975e-001, 6.524268e-001, 6.524560e-001, 6.524852e-001, 6.525143e-001, 6.525435e-001, 6.525726e-001, 6.526016e-001, 6.526307e-001, 6.526597e-001, 6.526886e-001, 6.527176e-001, 6.527465e-001, 6.527754e-001, 6.528042e-001, 6.528331e-001, 6.528619e-001, 6.528906e-001, 6.529194e-001, 6.529481e-001, 6.529767e-001, 6.530054e-001, 6.530340e-001, 6.530626e-001, 6.530911e-001, 6.531197e-001, 6.531482e-001, 6.531766e-001, 6.532051e-001, 6.532335e-001, 6.532618e-001, 6.532902e-001, 6.533185e-001, 6.533468e-001, 6.533750e-001, 6.534033e-001, 6.534315e-001, 6.534596e-001, 6.534878e-001, 6.535159e-001, 6.535439e-001, 6.535720e-001, 
6.536000e-001, 6.536280e-001, 6.536559e-001, 6.536839e-001, 6.537118e-001, 6.537396e-001, 6.537675e-001, 6.537953e-001, 6.538230e-001, 6.538508e-001, 6.538785e-001, 6.539062e-001, 6.539338e-001, 6.539615e-001, 6.539891e-001, 6.540166e-001, 6.540442e-001, 6.540717e-001, 6.540991e-001, 6.541266e-001, 6.541540e-001, 6.541814e-001, 6.542087e-001, 6.542361e-001, 6.542634e-001, 6.542906e-001, 6.543179e-001, 6.543451e-001, 6.543722e-001, 6.543994e-001, 6.544265e-001, 6.544536e-001, 6.544806e-001, 6.545077e-001, 6.545347e-001, 6.545616e-001, 6.545886e-001, 6.546155e-001, 6.546423e-001, 6.546692e-001, 6.546960e-001, 6.547228e-001, 6.547495e-001, 6.547763e-001, 6.548030e-001, 6.548296e-001, 6.548563e-001, 6.548829e-001, 6.549094e-001, 6.549360e-001, 6.549625e-001, 6.549890e-001, 6.550154e-001, 6.550419e-001, 6.550683e-001, 6.550946e-001, 6.551210e-001, 6.551473e-001, 6.551735e-001, 6.551998e-001, 6.552260e-001, 6.552522e-001, 6.552783e-001, 6.553045e-001, 6.553306e-001, 6.553566e-001, 6.553827e-001, 6.554087e-001, 6.554346e-001, 6.554606e-001, 6.554865e-001, 6.555124e-001, 6.555382e-001, 6.555641e-001, 6.555899e-001, 6.556156e-001, 6.556414e-001, 6.556671e-001, 6.556927e-001, 6.557184e-001, 6.557440e-001, 6.557696e-001, 6.557951e-001, 6.558207e-001, 6.558462e-001, 6.558716e-001, 6.558971e-001, 6.559225e-001, 6.559478e-001, 6.559732e-001, 6.559985e-001, 6.560238e-001, 6.560490e-001, 6.560743e-001, 6.560995e-001, 6.561246e-001, 6.561498e-001, 6.561749e-001, 6.561999e-001, 6.562250e-001, 
6.562500e-001, 6.562750e-001, 6.562999e-001, 6.563249e-001, 6.563498e-001, 6.563746e-001, 6.563995e-001, 6.564243e-001, 6.564490e-001, 6.564738e-001, 6.564985e-001, 6.565232e-001, 6.565478e-001, 6.565725e-001, 6.565971e-001, 6.566216e-001, 6.566462e-001, 6.566707e-001, 6.566951e-001, 6.567196e-001, 6.567440e-001, 6.567684e-001, 6.567927e-001, 6.568171e-001, 6.568414e-001, 6.568656e-001, 6.568899e-001, 6.569141e-001, 6.569382e-001, 6.569624e-001, 6.569865e-001, 6.570106e-001, 6.570346e-001, 6.570587e-001, 6.570827e-001, 6.571066e-001, 6.571306e-001, 6.571545e-001, 6.571783e-001, 6.572022e-001, 6.572260e-001, 6.572498e-001, 6.572735e-001, 6.572973e-001, 6.573210e-001, 6.573446e-001, 6.573683e-001, 6.573919e-001, 6.574154e-001, 6.574390e-001, 6.574625e-001, 6.574860e-001, 6.575094e-001, 6.575329e-001, 6.575563e-001, 6.575796e-001, 6.576030e-001, 6.576263e-001, 6.576495e-001, 6.576728e-001, 6.576960e-001, 6.577192e-001, 6.577423e-001, 6.577655e-001, 6.577886e-001, 6.578116e-001, 6.578347e-001, 6.578577e-001, 6.578806e-001, 6.579036e-001, 6.579265e-001, 6.579494e-001, 6.579722e-001, 6.579951e-001, 6.580179e-001, 6.580406e-001, 6.580634e-001, 6.580861e-001, 6.581087e-001, 6.581314e-001, 6.581540e-001, 6.581766e-001, 6.581991e-001, 6.582217e-001, 6.582442e-001, 6.582666e-001, 6.582891e-001, 6.583115e-001, 6.583338e-001, 6.583562e-001, 6.583785e-001, 6.584008e-001, 6.584230e-001, 6.584453e-001, 6.584675e-001, 6.584896e-001, 6.585118e-001, 6.585339e-001, 6.585559e-001, 6.585780e-001, 
6.586000e-001, 6.586220e-001, 6.586439e-001, 6.586659e-001, 6.586878e-001, 6.587096e-001, 6.587315e-001, 6.587533e-001, 6.587750e-001, 6.587968e-001, 6.588185e-001, 6.588402e-001, 6.588618e-001, 6.588835e-001, 6.589051e-001, 6.589266e-001, 6.589482e-001, 6.589697e-001, 6.589911e-001, 6.590126e-001, 6.590340e-001, 6.590554e-001, 6.590767e-001, 6.590981e-001, 6.591194e-001, 6.591406e-001, 6.591619e-001, 6.591831e-001, 6.592042e-001, 6.592254e-001, 6.592465e-001, 6.592676e-001, 6.592886e-001, 6.593097e-001, 6.593307e-001, 6.593516e-001, 6.593726e-001, 6.593935e-001, 6.594143e-001, 6.594352e-001, 6.594560e-001, 6.594768e-001, 6.594975e-001, 6.595183e-001, 6.595390e-001, 6.595596e-001, 6.595803e-001, 6.596009e-001, 6.596214e-001, 6.596420e-001, 6.596625e-001, 6.596830e-001, 6.597034e-001, 6.597239e-001, 6.597443e-001, 6.597646e-001, 6.597850e-001, 6.598053e-001, 6.598255e-001, 6.598458e-001, 6.598660e-001, 6.598862e-001, 6.599063e-001, 6.599265e-001, 6.599466e-001, 6.599666e-001, 6.599867e-001, 6.600067e-001, 6.600266e-001, 6.600466e-001, 6.600665e-001, 6.600864e-001, 6.601062e-001, 6.601261e-001, 6.601459e-001, 6.601656e-001, 6.601854e-001, 6.602051e-001, 6.602247e-001, 6.602444e-001, 6.602640e-001, 6.602836e-001, 6.603031e-001, 6.603227e-001, 6.603422e-001, 6.603616e-001, 6.603811e-001, 6.604005e-001, 6.604198e-001, 6.604392e-001, 6.604585e-001, 6.604778e-001, 6.604970e-001, 6.605163e-001, 6.605355e-001, 6.605546e-001, 6.605738e-001, 6.605929e-001, 6.606119e-001, 6.606310e-001, 
6.606500e-001, 6.606690e-001, 6.606879e-001, 6.607069e-001, 6.607258e-001, 6.607446e-001, 6.607635e-001, 6.607823e-001, 6.608010e-001, 6.608198e-001, 6.608385e-001, 6.608572e-001, 6.608758e-001, 6.608945e-001, 6.609131e-001, 6.609316e-001, 6.609502e-001, 6.609687e-001, 6.609871e-001, 6.610056e-001, 6.610240e-001, 6.610424e-001, 6.610607e-001, 6.610791e-001, 6.610974e-001, 6.611156e-001, 6.611339e-001, 6.611521e-001, 6.611702e-001, 6.611884e-001, 6.612065e-001, 6.612246e-001, 6.612426e-001, 6.612607e-001, 6.612787e-001, 6.612966e-001, 6.613146e-001, 6.613325e-001, 6.613503e-001, 6.613682e-001, 6.613860e-001, 6.614038e-001, 6.614215e-001, 6.614393e-001, 6.614570e-001, 6.614746e-001, 6.614923e-001, 6.615099e-001, 6.615274e-001, 6.615450e-001, 6.615625e-001, 6.615800e-001, 6.615974e-001, 6.616149e-001, 6.616323e-001, 6.616496e-001, 6.616670e-001, 6.616843e-001, 6.617015e-001, 6.617188e-001, 6.617360e-001, 6.617532e-001, 6.617703e-001, 6.617875e-001, 6.618046e-001, 6.618216e-001, 6.618387e-001, 6.618557e-001, 6.618726e-001, 6.618896e-001, 6.619065e-001, 6.619234e-001, 6.619402e-001, 6.619571e-001, 6.619739e-001, 6.619906e-001, 6.620074e-001, 6.620241e-001, 6.620407e-001, 6.620574e-001, 6.620740e-001, 6.620906e-001, 6.621071e-001, 6.621237e-001, 6.621402e-001, 6.621566e-001, 6.621731e-001, 6.621895e-001, 6.622058e-001, 6.622222e-001, 6.622385e-001, 6.622548e-001, 6.622710e-001, 6.622873e-001, 6.623035e-001, 6.623196e-001, 6.623358e-001, 6.623519e-001, 6.623679e-001, 6.623840e-001, 
6.624000e-001, 6.624160e-001, 6.624319e-001, 6.624479e-001, 6.624638e-001, 6.624796e-001, 6.624955e-001, 6.625113e-001, 6.625270e-001, 6.625428e-001, 6.625585e-001, 6.625742e-001, 6.625898e-001, 6.626055e-001, 6.626211e-001, 6.626366e-001, 6.626522e-001, 6.626677e-001, 6.626831e-001, 6.626986e-001, 6.627140e-001, 6.627294e-001, 6.627447e-001, 6.627601e-001, 6.627754e-001, 6.627906e-001, 6.628059e-001, 6.628211e-001, 6.628362e-001, 6.628514e-001, 6.628665e-001, 6.628816e-001, 6.628966e-001, 6.629117e-001, 6.629267e-001, 6.629416e-001, 6.629566e-001, 6.629715e-001, 6.629863e-001, 6.630012e-001, 6.630160e-001, 6.630308e-001, 6.630455e-001, 6.630603e-001, 6.630750e-001, 6.630896e-001, 6.631043e-001, 6.631189e-001, 6.631334e-001, 6.631480e-001, 6.631625e-001, 6.631770e-001, 6.631914e-001, 6.632059e-001, 6.632203e-001, 6.632346e-001, 6.632490e-001, 6.632633e-001, 6.632775e-001, 6.632918e-001, 6.633060e-001, 6.633202e-001, 6.633343e-001, 6.633485e-001, 6.633626e-001, 6.633766e-001, 6.633907e-001, 6.634047e-001, 6.634186e-001, 6.634326e-001, 6.634465e-001, 6.634604e-001, 6.634742e-001, 6.634881e-001, 6.635019e-001, 6.635156e-001, 6.635294e-001, 6.635431e-001, 6.635567e-001, 6.635704e-001, 6.635840e-001, 6.635976e-001, 6.636111e-001, 6.636247e-001, 6.636382e-001, 6.636516e-001, 6.636651e-001, 6.636785e-001, 6.636918e-001, 6.637052e-001, 6.637185e-001, 6.637318e-001, 6.637450e-001, 6.637583e-001, 6.637715e-001, 6.637846e-001, 6.637978e-001, 6.638109e-001, 6.638239e-001, 6.638370e-001, 
6.638500e-001, 6.638630e-001, 6.638759e-001, 6.638889e-001, 6.639018e-001, 6.639146e-001, 6.639275e-001, 6.639403e-001, 6.639530e-001, 6.639658e-001, 6.639785e-001, 6.639912e-001, 6.640038e-001, 6.640165e-001, 6.640291e-001, 6.640416e-001, 6.640542e-001, 6.640667e-001, 6.640791e-001, 6.640916e-001, 6.641040e-001, 6.641164e-001, 6.641287e-001, 6.641411e-001, 6.641534e-001, 6.641656e-001, 6.641779e-001, 6.641901e-001, 6.642022e-001, 6.642144e-001, 6.642265e-001, 6.642386e-001, 6.642506e-001, 6.642627e-001, 6.642747e-001, 6.642866e-001, 6.642986e-001, 6.643105e-001, 6.643223e-001, 6.643342e-001, 6.643460e-001, 6.643578e-001, 6.643695e-001, 6.643813e-001, 6.643930e-001, 6.644046e-001, 6.644163e-001, 6.644279e-001, 6.644394e-001, 6.644510e-001, 6.644625e-001, 6.644740e-001, 6.644854e-001, 6.644969e-001, 6.645083e-001, 6.645196e-001, 6.645310e-001, 6.645423e-001, 6.645535e-001, 6.645648e-001, 6.645760e-001, 6.645872e-001, 6.645983e-001, 6.646095e-001, 6.646206e-001, 6.646316e-001, 6.646427e-001, 6.646537e-001, 6.646646e-001, 6.646756e-001, 6.646865e-001, 6.646974e-001, 6.647082e-001, 6.647191e-001, 6.647299e-001, 6.647406e-001, 6.647514e-001, 6.647621e-001, 6.647727e-001, 6.647834e-001, 6.647940e-001, 6.648046e-001, 6.648151e-001, 6.648257e-001, 6.648362e-001, 6.648466e-001, 6.648571e-001, 6.648675e-001, 6.648778e-001, 6.648882e-001, 6.648985e-001, 6.649088e-001, 6.649190e-001, 6.649293e-001, 6.649395e-001, 6.649496e-001, 6.649598e-001, 6.649699e-001, 6.649799e-001, 6.649900e-001, 
6.650000e-001, 6.650100e-001, 6.650199e-001, 6.650299e-001, 6.650398e-001, 6.650496e-001, 6.650595e-001, 6.650693e-001, 6.650790e-001, 6.650888e-001, 6.650985e-001, 6.651082e-001, 6.651178e-001, 6.651275e-001, 6.651371e-001, 6.651466e-001, 6.651562e-001, 6.651657e-001, 6.651751e-001, 6.651846e-001, 6.651940e-001, 6.652034e-001, 6.652127e-001, 6.652221e-001, 6.652314e-001, 6.652406e-001, 6.652499e-001, 6.652591e-001, 6.652682e-001, 6.652774e-001, 6.652865e-001, 6.652956e-001, 6.653046e-001, 6.653137e-001, 6.653227e-001, 6.653316e-001, 6.653406e-001, 6.653495e-001, 6.653583e-001, 6.653672e-001, 6.653760e-001, 6.653848e-001, 6.653935e-001, 6.654023e-001, 6.654110e-001, 6.654196e-001, 6.654283e-001, 6.654369e-001, 6.654454e-001, 6.654540e-001, 6.654625e-001, 6.654710e-001, 6.654794e-001, 6.654879e-001, 6.654963e-001, 6.655046e-001, 6.655130e-001, 6.655213e-001, 6.655295e-001, 6.655378e-001, 6.655460e-001, 6.655542e-001, 6.655623e-001, 6.655705e-001, 6.655786e-001, 6.655866e-001, 6.655947e-001, 6.656027e-001, 6.656106e-001, 6.656186e-001, 6.656265e-001, 6.656344e-001, 6.656422e-001, 6.656501e-001, 6.656579e-001, 6.656656e-001, 6.656734e-001, 6.656811e-001, 6.656887e-001, 6.656964e-001, 6.657040e-001, 6.657116e-001, 6.657191e-001, 6.657267e-001, 6.657342e-001, 6.657416e-001, 6.657491e-001, 6.657565e-001, 6.657638e-001, 6.657712e-001, 6.657785e-001, 6.657858e-001, 6.657930e-001, 6.658003e-001, 6.658075e-001, 6.658146e-001, 6.658218e-001, 6.658289e-001, 6.658359e-001, 6.658430e-001, 
6.658500e-001, 6.658570e-001, 6.658639e-001, 6.658709e-001, 6.658778e-001, 6.658846e-001, 6.658915e-001, 6.658983e-001, 6.659050e-001, 6.659118e-001, 6.659185e-001, 6.659252e-001, 6.659318e-001, 6.659385e-001, 6.659451e-001, 6.659516e-001, 6.659582e-001, 6.659647e-001, 6.659711e-001, 6.659776e-001, 6.659840e-001, 6.659904e-001, 6.659967e-001, 6.660031e-001, 6.660094e-001, 6.660156e-001, 6.660219e-001, 6.660281e-001, 6.660342e-001, 6.660404e-001, 6.660465e-001, 6.660526e-001, 6.660586e-001, 6.660647e-001, 6.660707e-001, 6.660766e-001, 6.660826e-001, 6.660885e-001, 6.660943e-001, 6.661002e-001, 6.661060e-001, 6.661118e-001, 6.661175e-001, 6.661233e-001, 6.661290e-001, 6.661346e-001, 6.661403e-001, 6.661459e-001, 6.661514e-001, 6.661570e-001, 6.661625e-001, 6.661680e-001, 6.661734e-001, 6.661789e-001, 6.661843e-001, 6.661896e-001, 6.661950e-001, 6.662003e-001, 6.662055e-001, 6.662108e-001, 6.662160e-001, 6.662212e-001, 6.662263e-001, 6.662315e-001, 6.662366e-001, 6.662416e-001, 6.662467e-001, 6.662517e-001, 6.662566e-001, 6.662616e-001, 6.662665e-001, 6.662714e-001, 6.662762e-001, 6.662811e-001, 6.662859e-001, 6.662906e-001, 6.662954e-001, 6.663001e-001, 6.663047e-001, 6.663094e-001, 6.663140e-001, 6.663186e-001, 6.663231e-001, 6.663277e-001, 6.663322e-001, 6.663366e-001, 6.663411e-001, 6.663455e-001, 6.663498e-001, 6.663542e-001, 6.663585e-001, 6.663628e-001, 6.663670e-001, 6.663713e-001, 6.663755e-001, 6.663796e-001, 6.663838e-001, 6.663879e-001, 6.663919e-001, 6.663960e-001, 
6.664000e-001, 6.664040e-001, 6.664079e-001, 6.664119e-001, 6.664158e-001, 6.664196e-001, 6.664235e-001, 6.664273e-001, 6.664310e-001, 6.664348e-001, 6.664385e-001, 6.664422e-001, 6.664458e-001, 6.664495e-001, 6.664531e-001, 6.664566e-001, 6.664602e-001, 6.664637e-001, 6.664671e-001, 6.664706e-001, 6.664740e-001, 6.664774e-001, 6.664807e-001, 6.664841e-001, 6.664874e-001, 6.664906e-001, 6.664939e-001, 6.664971e-001, 6.665002e-001, 6.665034e-001, 6.665065e-001, 6.665096e-001, 6.665126e-001, 6.665157e-001, 6.665187e-001, 6.665216e-001, 6.665246e-001, 6.665275e-001, 6.665303e-001, 6.665332e-001, 6.665360e-001, 6.665388e-001, 6.665415e-001, 6.665443e-001, 6.665470e-001, 6.665496e-001, 6.665523e-001, 6.665549e-001, 6.665574e-001, 6.665600e-001, 6.665625e-001, 6.665650e-001, 6.665674e-001, 6.665699e-001, 6.665723e-001, 6.665746e-001, 6.665770e-001, 6.665793e-001, 6.665815e-001, 6.665838e-001, 6.665860e-001, 6.665882e-001, 6.665903e-001, 6.665925e-001, 6.665946e-001, 6.665966e-001, 6.665987e-001, 6.666007e-001, 6.666026e-001, 6.666046e-001, 6.666065e-001, 6.666084e-001, 6.666102e-001, 6.666121e-001, 6.666139e-001, 6.666156e-001, 6.666174e-001, 6.666191e-001, 6.666207e-001, 6.666224e-001, 6.666240e-001, 6.666256e-001, 6.666271e-001, 6.666287e-001, 6.666302e-001, 6.666316e-001, 6.666331e-001, 6.666345e-001, 6.666358e-001, 6.666372e-001, 6.666385e-001, 6.666398e-001, 6.666410e-001, 6.666423e-001, 6.666435e-001, 6.666446e-001, 6.666458e-001, 6.666469e-001, 6.666479e-001, 6.666490e-001, 
6.666500e-001, 6.666510e-001, 6.666519e-001, 6.666529e-001, 6.666538e-001, 6.666546e-001, 6.666555e-001, 6.666563e-001, 6.666570e-001, 6.666578e-001, 6.666585e-001, 6.666592e-001, 6.666598e-001, 6.666605e-001, 6.666611e-001, 6.666616e-001, 6.666622e-001, 6.666627e-001, 6.666631e-001, 6.666636e-001, 6.666640e-001, 6.666644e-001, 6.666647e-001, 6.666651e-001, 6.666654e-001, 6.666656e-001, 6.666659e-001, 6.666661e-001, 6.666662e-001, 6.666664e-001, 6.666665e-001, 6.666666e-001, 6.666666e-001, 6.666667e-001, 6.666667e-001, 6.666666e-001, 6.666666e-001, 6.666665e-001, 6.666663e-001, 6.666662e-001, 6.666660e-001, 6.666658e-001, 6.666655e-001, 6.666653e-001, 6.666650e-001, 6.666646e-001, 6.666643e-001, 6.666639e-001, 6.666634e-001, 6.666630e-001, 6.666625e-001, 6.666620e-001, 6.666614e-001, 6.666609e-001, 6.666603e-001, 6.666596e-001, 6.666590e-001, 6.666583e-001, 6.666575e-001, 6.666568e-001, 6.666560e-001, 6.666552e-001, 6.666543e-001, 6.666535e-001, 6.666526e-001, 6.666516e-001, 6.666507e-001, 6.666497e-001, 6.666486e-001, 6.666476e-001, 6.666465e-001, 6.666454e-001, 6.666442e-001, 6.666431e-001, 6.666419e-001, 6.666406e-001, 6.666394e-001, 6.666381e-001, 6.666367e-001, 6.666354e-001, 6.666340e-001, 6.666326e-001, 6.666311e-001, 6.666297e-001, 6.666282e-001, 6.666266e-001, 6.666251e-001, 6.666235e-001, 6.666218e-001, 6.666202e-001, 6.666185e-001, 6.666168e-001, 6.666150e-001, 6.666133e-001, 6.666115e-001, 6.666096e-001, 6.666078e-001, 6.666059e-001, 6.666039e-001, 6.666020e-001, 
6.666000e-001, 6.665980e-001, 6.665959e-001, 6.665939e-001, 6.665918e-001, 6.665896e-001, 6.665875e-001, 6.665853e-001, 6.665830e-001, 6.665808e-001, 6.665785e-001, 6.665762e-001, 6.665738e-001, 6.665715e-001, 6.665691e-001, 6.665666e-001, 6.665642e-001, 6.665617e-001, 6.665591e-001, 6.665566e-001, 6.665540e-001, 6.665514e-001, 6.665487e-001, 6.665461e-001, 6.665434e-001, 6.665406e-001, 6.665379e-001, 6.665351e-001, 6.665322e-001, 6.665294e-001, 6.665265e-001, 6.665236e-001, 6.665206e-001, 6.665177e-001, 6.665147e-001, 6.665116e-001, 6.665086e-001, 6.665055e-001, 6.665023e-001, 6.664992e-001, 6.664960e-001, 6.664928e-001, 6.664895e-001, 6.664863e-001, 6.664830e-001, 6.664796e-001, 6.664763e-001, 6.664729e-001, 6.664694e-001, 6.664660e-001, 6.664625e-001, 6.664590e-001, 6.664554e-001, 6.664519e-001, 6.664483e-001, 6.664446e-001, 6.664410e-001, 6.664373e-001, 6.664335e-001, 6.664298e-001, 6.664260e-001, 6.664222e-001, 6.664183e-001, 6.664145e-001, 6.664106e-001, 6.664066e-001, 6.664027e-001, 6.663987e-001, 6.663946e-001, 6.663906e-001, 6.663865e-001, 6.663824e-001, 6.663782e-001, 6.663741e-001, 6.663699e-001, 6.663656e-001, 6.663614e-001, 6.663571e-001, 6.663527e-001, 6.663484e-001, 6.663440e-001, 6.663396e-001, 6.663351e-001, 6.663307e-001, 6.663262e-001, 6.663216e-001, 6.663171e-001, 6.663125e-001, 6.663078e-001, 6.663032e-001, 6.662985e-001, 6.662938e-001, 6.662890e-001, 6.662843e-001, 6.662795e-001, 6.662746e-001, 6.662698e-001, 6.662649e-001, 6.662599e-001, 6.662550e-001, 
6.662500e-001, 6.662450e-001, 6.662399e-001, 6.662349e-001, 6.662298e-001, 6.662246e-001, 6.662195e-001, 6.662143e-001, 6.662090e-001, 6.662038e-001, 6.661985e-001, 6.661932e-001, 6.661878e-001, 6.661825e-001, 6.661771e-001, 6.661716e-001, 6.661662e-001, 6.661607e-001, 6.661551e-001, 6.661496e-001, 6.661440e-001, 6.661384e-001, 6.661327e-001, 6.661271e-001, 6.661214e-001, 6.661156e-001, 6.661099e-001, 6.661041e-001, 6.660982e-001, 6.660924e-001, 6.660865e-001, 6.660806e-001, 6.660746e-001, 6.660687e-001, 6.660627e-001, 6.660566e-001, 6.660506e-001, 6.660445e-001, 6.660383e-001, 6.660322e-001, 6.660260e-001, 6.660198e-001, 6.660135e-001, 6.660073e-001, 6.660010e-001, 6.659946e-001, 6.659883e-001, 6.659819e-001, 6.659754e-001, 6.659690e-001, 6.659625e-001, 6.659560e-001, 6.659494e-001, 6.659429e-001, 6.659363e-001, 6.659296e-001, 6.659230e-001, 6.659163e-001, 6.659095e-001, 6.659028e-001, 6.658960e-001, 6.658892e-001, 6.658823e-001, 6.658755e-001, 6.658686e-001, 6.658616e-001, 6.658547e-001, 6.658477e-001, 6.658406e-001, 6.658336e-001, 6.658265e-001, 6.658194e-001, 6.658122e-001, 6.658051e-001, 6.657979e-001, 6.657906e-001, 6.657834e-001, 6.657761e-001, 6.657687e-001, 6.657614e-001, 6.657540e-001, 6.657466e-001, 6.657391e-001, 6.657317e-001, 6.657242e-001, 6.657166e-001, 6.657091e-001, 6.657015e-001, 6.656938e-001, 6.656862e-001, 6.656785e-001, 6.656708e-001, 6.656630e-001, 6.656553e-001, 6.656475e-001, 6.656396e-001, 6.656318e-001, 6.656239e-001, 6.656159e-001, 6.656080e-001, 
6.656000e-001, 6.655920e-001, 6.655839e-001, 6.655759e-001, 6.655678e-001, 6.655596e-001, 6.655515e-001, 6.655433e-001, 6.655350e-001, 6.655268e-001, 6.655185e-001, 6.655102e-001, 6.655018e-001, 6.654935e-001, 6.654851e-001, 6.654766e-001, 6.654682e-001, 6.654597e-001, 6.654511e-001, 6.654426e-001, 6.654340e-001, 6.654254e-001, 6.654167e-001, 6.654081e-001, 6.653994e-001, 6.653906e-001, 6.653819e-001, 6.653731e-001, 6.653642e-001, 6.653554e-001, 6.653465e-001, 6.653376e-001, 6.653286e-001, 6.653197e-001, 6.653107e-001, 6.653016e-001, 6.652926e-001, 6.652835e-001, 6.652743e-001, 6.652652e-001, 6.652560e-001, 6.652468e-001, 6.652375e-001, 6.652283e-001, 6.652190e-001, 6.652096e-001, 6.652003e-001, 6.651909e-001, 6.651814e-001, 6.651720e-001, 6.651625e-001, 6.651530e-001, 6.651434e-001, 6.651339e-001, 6.651243e-001, 6.651146e-001, 6.651050e-001, 6.650953e-001, 6.650855e-001, 6.650758e-001, 6.650660e-001, 6.650562e-001, 6.650463e-001, 6.650365e-001, 6.650266e-001, 6.650166e-001, 6.650067e-001, 6.649967e-001, 6.649866e-001, 6.649766e-001, 6.649665e-001, 6.649564e-001, 6.649462e-001, 6.649361e-001, 6.649259e-001, 6.649156e-001, 6.649054e-001, 6.648951e-001, 6.648847e-001, 6.648744e-001, 6.648640e-001, 6.648536e-001, 6.648431e-001, 6.648327e-001, 6.648222e-001, 6.648116e-001, 6.648011e-001, 6.647905e-001, 6.647798e-001, 6.647692e-001, 6.647585e-001, 6.647478e-001, 6.647370e-001, 6.647263e-001, 6.647155e-001, 6.647046e-001, 6.646938e-001, 6.646829e-001, 6.646719e-001, 6.646610e-001, 
6.646500e-001, 6.646390e-001, 6.646279e-001, 6.646169e-001, 6.646058e-001, 6.645946e-001, 6.645835e-001, 6.645723e-001, 6.645610e-001, 6.645498e-001, 6.645385e-001, 6.645272e-001, 6.645158e-001, 6.645045e-001, 6.644931e-001, 6.644816e-001, 6.644702e-001, 6.644587e-001, 6.644471e-001, 6.644356e-001, 6.644240e-001, 6.644124e-001, 6.644007e-001, 6.643891e-001, 6.643774e-001, 6.643656e-001, 6.643539e-001, 6.643421e-001, 6.643302e-001, 6.643184e-001, 6.643065e-001, 6.642946e-001, 6.642826e-001, 6.642707e-001, 6.642587e-001, 6.642466e-001, 6.642346e-001, 6.642225e-001, 6.642103e-001, 6.641982e-001, 6.641860e-001, 6.641738e-001, 6.641615e-001, 6.641493e-001, 6.641370e-001, 6.641246e-001, 6.641123e-001, 6.640999e-001, 6.640874e-001, 6.640750e-001, 6.640625e-001, 6.640500e-001, 6.640374e-001, 6.640249e-001, 6.640123e-001, 6.639996e-001, 6.639870e-001, 6.639743e-001, 6.639615e-001, 6.639488e-001, 6.639360e-001, 6.639232e-001, 6.639103e-001, 6.638975e-001, 6.638846e-001, 6.638716e-001, 6.638587e-001, 6.638457e-001, 6.638326e-001, 6.638196e-001, 6.638065e-001, 6.637934e-001, 6.637802e-001, 6.637671e-001, 6.637539e-001, 6.637406e-001, 6.637274e-001, 6.637141e-001, 6.637007e-001, 6.636874e-001, 6.636740e-001, 6.636606e-001, 6.636471e-001, 6.636337e-001, 6.636202e-001, 6.636066e-001, 6.635931e-001, 6.635795e-001, 6.635658e-001, 6.635522e-001, 6.635385e-001, 6.635248e-001, 6.635110e-001, 6.634973e-001, 6.634835e-001, 6.634696e-001, 6.634558e-001, 6.634419e-001, 6.634279e-001, 6.634140e-001, 
6.634000e-001, 6.633860e-001, 6.633719e-001, 6.633579e-001, 6.633438e-001, 6.633296e-001, 6.633155e-001, 6.633013e-001, 6.632870e-001, 6.632728e-001, 6.632585e-001, 6.632442e-001, 6.632298e-001, 6.632155e-001, 6.632011e-001, 6.631866e-001, 6.631722e-001, 6.631577e-001, 6.631431e-001, 6.631286e-001, 6.631140e-001, 6.630994e-001, 6.630847e-001, 6.630701e-001, 6.630554e-001, 6.630406e-001, 6.630259e-001, 6.630111e-001, 6.629962e-001, 6.629814e-001, 6.629665e-001, 6.629516e-001, 6.629366e-001, 6.629217e-001, 6.629067e-001, 6.628916e-001, 6.628766e-001, 6.628615e-001, 6.628463e-001, 6.628312e-001, 6.628160e-001, 6.628008e-001, 6.627855e-001, 6.627703e-001, 6.627550e-001, 6.627396e-001, 6.627243e-001, 6.627089e-001, 6.626934e-001, 6.626780e-001, 6.626625e-001, 6.626470e-001, 6.626314e-001, 6.626159e-001, 6.626003e-001, 6.625846e-001, 6.625690e-001, 6.625533e-001, 6.625375e-001, 6.625218e-001, 6.625060e-001, 6.624902e-001, 6.624743e-001, 6.624585e-001, 6.624426e-001, 6.624266e-001, 6.624107e-001, 6.623947e-001, 6.623786e-001, 6.623626e-001, 6.623465e-001, 6.623304e-001, 6.623142e-001, 6.622981e-001, 6.622819e-001, 6.622656e-001, 6.622494e-001, 6.622331e-001, 6.622167e-001, 6.622004e-001, 6.621840e-001, 6.621676e-001, 6.621511e-001, 6.621347e-001, 6.621182e-001, 6.621016e-001, 6.620851e-001, 6.620685e-001, 6.620518e-001, 6.620352e-001, 6.620185e-001, 6.620018e-001, 6.619850e-001, 6.619683e-001, 6.619515e-001, 6.619346e-001, 6.619178e-001, 6.619009e-001, 6.618839e-001, 6.618670e-001, 
6.618500e-001, 6.618330e-001, 6.618159e-001, 6.617989e-001, 6.617818e-001, 6.617646e-001, 6.617475e-001, 6.617303e-001, 6.617130e-001, 6.616958e-001, 6.616785e-001, 6.616612e-001, 6.616438e-001, 6.616265e-001, 6.616091e-001, 6.615916e-001, 6.615742e-001, 6.615567e-001, 6.615391e-001, 6.615216e-001, 6.615040e-001, 6.614864e-001, 6.614687e-001, 6.614511e-001, 6.614334e-001, 6.614156e-001, 6.613979e-001, 6.613801e-001, 6.613622e-001, 6.613444e-001, 6.613265e-001, 6.613086e-001, 6.612906e-001, 6.612727e-001, 6.612547e-001, 6.612366e-001, 6.612186e-001, 6.612005e-001, 6.611823e-001, 6.611642e-001, 6.611460e-001, 6.611278e-001, 6.611095e-001, 6.610913e-001, 6.610730e-001, 6.610546e-001, 6.610363e-001, 6.610179e-001, 6.609994e-001, 6.609810e-001, 6.609625e-001, 6.609440e-001, 6.609254e-001, 6.609069e-001, 6.608883e-001, 6.608696e-001, 6.608510e-001, 6.608323e-001, 6.608135e-001, 6.607948e-001, 6.607760e-001, 6.607572e-001, 6.607383e-001, 6.607195e-001, 6.607006e-001, 6.606816e-001, 6.606627e-001, 6.606437e-001, 6.606246e-001, 6.606056e-001, 6.605865e-001, 6.605674e-001, 6.605482e-001, 6.605291e-001, 6.605099e-001, 6.604906e-001, 6.604714e-001, 6.604521e-001, 6.604327e-001, 6.604134e-001, 6.603940e-001, 6.603746e-001, 6.603551e-001, 6.603357e-001, 6.603162e-001, 6.602966e-001, 6.602771e-001, 6.602575e-001, 6.602378e-001, 6.602182e-001, 6.601985e-001, 6.601788e-001, 6.601590e-001, 6.601393e-001, 6.601195e-001, 6.600996e-001, 6.600798e-001, 6.600599e-001, 6.600399e-001, 6.600200e-001, 
6.600000e-001, 6.599800e-001, 6.599599e-001, 6.599399e-001, 6.599198e-001, 6.598996e-001, 6.598795e-001, 6.598593e-001, 6.598390e-001, 6.598188e-001, 6.597985e-001, 6.597782e-001, 6.597578e-001, 6.597375e-001, 6.597171e-001, 6.596966e-001, 6.596762e-001, 6.596557e-001, 6.596351e-001, 6.596146e-001, 6.595940e-001, 6.595734e-001, 6.595527e-001, 6.595321e-001, 6.595114e-001, 6.594906e-001, 6.594699e-001, 6.594491e-001, 6.594282e-001, 6.594074e-001, 6.593865e-001, 6.593656e-001, 6.593446e-001, 6.593237e-001, 6.593027e-001, 6.592816e-001, 6.592606e-001, 6.592395e-001, 6.592183e-001, 6.591972e-001, 6.591760e-001, 6.591548e-001, 6.591335e-001, 6.591123e-001, 6.590910e-001, 6.590696e-001, 6.590483e-001, 6.590269e-001, 6.590054e-001, 6.589840e-001, 6.589625e-001, 6.589410e-001, 6.589194e-001, 6.588979e-001, 6.588763e-001, 6.588546e-001, 6.588330e-001, 6.588113e-001, 6.587895e-001, 6.587678e-001, 6.587460e-001, 6.587242e-001, 6.587023e-001, 6.586805e-001, 6.586586e-001, 6.586366e-001, 6.586147e-001, 6.585927e-001, 6.585706e-001, 6.585486e-001, 6.585265e-001, 6.585044e-001, 6.584822e-001, 6.584601e-001, 6.584379e-001, 6.584156e-001, 6.583934e-001, 6.583711e-001, 6.583487e-001, 6.583264e-001, 6.583040e-001, 6.582816e-001, 6.582591e-001, 6.582367e-001, 6.582142e-001, 6.581916e-001, 6.581691e-001, 6.581465e-001, 6.581238e-001, 6.581012e-001, 6.580785e-001, 6.580558e-001, 6.580330e-001, 6.580103e-001, 6.579875e-001, 6.579646e-001, 6.579418e-001, 6.579189e-001, 6.578959e-001, 6.578730e-001, 
6.578500e-001, 6.578270e-001, 6.578039e-001, 6.577809e-001, 6.577578e-001, 6.577346e-001, 6.577115e-001, 6.576883e-001, 6.576650e-001, 6.576418e-001, 6.576185e-001, 6.575952e-001, 6.575718e-001, 6.575485e-001, 6.575251e-001, 6.575016e-001, 6.574782e-001, 6.574547e-001, 6.574311e-001, 6.574076e-001, 6.573840e-001, 6.573604e-001, 6.573367e-001, 6.573131e-001, 6.572894e-001, 6.572656e-001, 6.572419e-001, 6.572181e-001, 6.571942e-001, 6.571704e-001, 6.571465e-001, 6.571226e-001, 6.570986e-001, 6.570747e-001, 6.570507e-001, 6.570266e-001, 6.570026e-001, 6.569785e-001, 6.569543e-001, 6.569302e-001, 6.569060e-001, 6.568818e-001, 6.568575e-001, 6.568333e-001, 6.568090e-001, 6.567846e-001, 6.567603e-001, 6.567359e-001, 6.567114e-001, 6.566870e-001, 6.566625e-001, 6.566380e-001, 6.566134e-001, 6.565889e-001, 6.565643e-001, 6.565396e-001, 6.565150e-001, 6.564903e-001, 6.564655e-001, 6.564408e-001, 6.564160e-001, 6.563912e-001, 6.563663e-001, 6.563415e-001, 6.563166e-001, 6.562916e-001, 6.562667e-001, 6.562417e-001, 6.562166e-001, 6.561916e-001, 6.561665e-001, 6.561414e-001, 6.561162e-001, 6.560911e-001, 6.560659e-001, 6.560406e-001, 6.560154e-001, 6.559901e-001, 6.559647e-001, 6.559394e-001, 6.559140e-001, 6.558886e-001, 6.558631e-001, 6.558377e-001, 6.558122e-001, 6.557866e-001, 6.557611e-001, 6.557355e-001, 6.557098e-001, 6.556842e-001, 6.556585e-001, 6.556328e-001, 6.556070e-001, 6.555813e-001, 6.555555e-001, 6.555296e-001, 6.555038e-001, 6.554779e-001, 6.554519e-001, 6.554260e-001, 
6.554000e-001, 6.553740e-001, 6.553479e-001, 6.553219e-001, 6.552958e-001, 6.552696e-001, 6.552435e-001, 6.552173e-001, 6.551910e-001, 6.551648e-001, 6.551385e-001, 6.551122e-001, 6.550858e-001, 6.550595e-001, 6.550331e-001, 6.550066e-001, 6.549802e-001, 6.549537e-001, 6.549271e-001, 6.549006e-001, 6.548740e-001, 6.548474e-001, 6.548207e-001, 6.547941e-001, 6.547674e-001, 6.547406e-001, 6.547139e-001, 6.546871e-001, 6.546602e-001, 6.546334e-001, 6.546065e-001, 6.545796e-001, 6.545526e-001, 6.545257e-001, 6.544987e-001, 6.544716e-001, 6.544446e-001, 6.544175e-001, 6.543903e-001, 6.543632e-001, 6.543360e-001, 6.543088e-001, 6.542815e-001, 6.542543e-001, 6.542270e-001, 6.541996e-001, 6.541723e-001, 6.541449e-001, 6.541174e-001, 6.540900e-001, 6.540625e-001, 6.540350e-001, 6.540074e-001, 6.539799e-001, 6.539523e-001, 6.539246e-001, 6.538970e-001, 6.538693e-001, 6.538415e-001, 6.538138e-001, 6.537860e-001, 6.537582e-001, 6.537303e-001, 6.537025e-001, 6.536746e-001, 6.536466e-001, 6.536187e-001, 6.535907e-001, 6.535626e-001, 6.535346e-001, 6.535065e-001, 6.534784e-001, 6.534502e-001, 6.534221e-001, 6.533939e-001, 6.533656e-001, 6.533374e-001, 6.533091e-001, 6.532807e-001, 6.532524e-001, 6.532240e-001, 6.531956e-001, 6.531671e-001, 6.531387e-001, 6.531102e-001, 6.530816e-001, 6.530531e-001, 6.530245e-001, 6.529958e-001, 6.529672e-001, 6.529385e-001, 6.529098e-001, 6.528810e-001, 6.528523e-001, 6.528235e-001, 6.527946e-001, 6.527658e-001, 6.527369e-001, 6.527079e-001, 6.526790e-001, 
6.526500e-001, 6.526210e-001, 6.525919e-001, 6.525629e-001, 6.525338e-001, 6.525046e-001, 6.524755e-001, 6.524463e-001, 6.524170e-001, 6.523878e-001, 6.523585e-001, 6.523292e-001, 6.522998e-001, 6.522705e-001, 6.522411e-001, 6.522116e-001, 6.521822e-001, 6.521527e-001, 6.521231e-001, 6.520936e-001, 6.520640e-001, 6.520344e-001, 6.520047e-001, 6.519751e-001, 6.519454e-001, 6.519156e-001, 6.518859e-001, 6.518561e-001, 6.518262e-001, 6.517964e-001, 6.517665e-001, 6.517366e-001, 6.517066e-001, 6.516767e-001, 6.516467e-001, 6.516166e-001, 6.515866e-001, 6.515565e-001, 6.515263e-001, 6.514962e-001, 6.514660e-001, 6.514358e-001, 6.514055e-001, 6.513753e-001, 6.513450e-001, 6.513146e-001, 6.512843e-001, 6.512539e-001, 6.512234e-001, 6.511930e-001, 6.511625e-001, 6.511320e-001, 6.511014e-001, 6.510709e-001, 6.510403e-001, 6.510096e-001, 6.509790e-001, 6.509483e-001, 6.509175e-001, 6.508868e-001, 6.508560e-001, 6.508252e-001, 6.507943e-001, 6.507635e-001, 6.507326e-001, 6.507016e-001, 6.506707e-001, 6.506397e-001, 6.506086e-001, 6.505776e-001, 6.505465e-001, 6.505154e-001, 6.504842e-001, 6.504531e-001, 6.504219e-001, 6.503906e-001, 6.503594e-001, 6.503281e-001, 6.502967e-001, 6.502654e-001, 6.502340e-001, 6.502026e-001, 6.501711e-001, 6.501397e-001, 6.501082e-001, 6.500766e-001, 6.500451e-001, 6.500135e-001, 6.499818e-001, 6.499502e-001, 6.499185e-001, 6.498868e-001, 6.498550e-001, 6.498233e-001, 6.497915e-001, 6.497596e-001, 6.497278e-001, 6.496959e-001, 6.496639e-001, 6.496320e-001, 
6.496000e-001, 6.495680e-001, 6.495359e-001, 6.495039e-001, 6.494718e-001, 6.494396e-001, 6.494075e-001, 6.493753e-001, 6.493430e-001, 6.493108e-001, 6.492785e-001, 6.492462e-001, 6.492138e-001, 6.491815e-001, 6.491491e-001, 6.491166e-001, 6.490842e-001, 6.490517e-001, 6.490191e-001, 6.489866e-001, 6.489540e-001, 6.489214e-001, 6.488887e-001, 6.488561e-001, 6.488234e-001, 6.487906e-001, 6.487579e-001, 6.487251e-001, 6.486922e-001, 6.486594e-001, 6.486265e-001, 6.485936e-001, 6.485606e-001, 6.485277e-001, 6.484947e-001, 6.484616e-001, 6.484286e-001, 6.483955e-001, 6.483623e-001, 6.483292e-001, 6.482960e-001, 6.482628e-001, 6.482295e-001, 6.481963e-001, 6.481630e-001, 6.481296e-001, 6.480963e-001, 6.480629e-001, 6.480294e-001, 6.479960e-001, 6.479625e-001, 6.479290e-001, 6.478954e-001, 6.478619e-001, 6.478283e-001, 6.477946e-001, 6.477610e-001, 6.477273e-001, 6.476935e-001, 6.476598e-001, 6.476260e-001, 6.475922e-001, 6.475583e-001, 6.475245e-001, 6.474906e-001, 6.474566e-001, 6.474227e-001, 6.473887e-001, 6.473546e-001, 6.473206e-001, 6.472865e-001, 6.472524e-001, 6.472182e-001, 6.471841e-001, 6.471499e-001, 6.471156e-001, 6.470814e-001, 6.470471e-001, 6.470127e-001, 6.469784e-001, 6.469440e-001, 6.469096e-001, 6.468751e-001, 6.468407e-001, 6.468062e-001, 6.467716e-001, 6.467371e-001, 6.467025e-001, 6.466678e-001, 6.466332e-001, 6.465985e-001, 6.465638e-001, 6.465290e-001, 6.464943e-001, 6.464595e-001, 6.464246e-001, 6.463898e-001, 6.463549e-001, 6.463199e-001, 6.462850e-001, 
6.462500e-001, 6.462150e-001, 6.461799e-001, 6.461449e-001, 6.461098e-001, 6.460746e-001, 6.460395e-001, 6.460043e-001, 6.459690e-001, 6.459338e-001, 6.458985e-001, 6.458632e-001, 6.458278e-001, 6.457925e-001, 6.457571e-001, 6.457216e-001, 6.456862e-001, 6.456507e-001, 6.456151e-001, 6.455796e-001, 6.455440e-001, 6.455084e-001, 6.454727e-001, 6.454371e-001, 6.454014e-001, 6.453656e-001, 6.453299e-001, 6.452941e-001, 6.452582e-001, 6.452224e-001, 6.451865e-001, 6.451506e-001, 6.451146e-001, 6.450787e-001, 6.450427e-001, 6.450066e-001, 6.449706e-001, 6.449345e-001, 6.448983e-001, 6.448622e-001, 6.448260e-001, 6.447898e-001, 6.447535e-001, 6.447173e-001, 6.446810e-001, 6.446446e-001, 6.446083e-001, 6.445719e-001, 6.445354e-001, 6.444990e-001, 6.444625e-001, 6.444260e-001, 6.443894e-001, 6.443529e-001, 6.443163e-001, 6.442796e-001, 6.442430e-001, 6.442063e-001, 6.441695e-001, 6.441328e-001, 6.440960e-001, 6.440592e-001, 6.440223e-001, 6.439855e-001, 6.439486e-001, 6.439116e-001, 6.438747e-001, 6.438377e-001, 6.438006e-001, 6.437636e-001, 6.437265e-001, 6.436894e-001, 6.436522e-001, 6.436151e-001, 6.435779e-001, 6.435406e-001, 6.435034e-001, 6.434661e-001, 6.434287e-001, 6.433914e-001, 6.433540e-001, 6.433166e-001, 6.432791e-001, 6.432417e-001, 6.432042e-001, 6.431666e-001, 6.431291e-001, 6.430915e-001, 6.430538e-001, 6.430162e-001, 6.429785e-001, 6.429408e-001, 6.429030e-001, 6.428653e-001, 6.428275e-001, 6.427896e-001, 6.427518e-001, 6.427139e-001, 6.426759e-001, 6.426380e-001, 
6.426000e-001, 6.425620e-001, 6.425239e-001, 6.424859e-001, 6.424478e-001, 6.424096e-001, 6.423715e-001, 6.423333e-001, 6.422950e-001, 6.422568e-001, 6.422185e-001, 6.421802e-001, 6.421418e-001, 6.421035e-001, 6.420651e-001, 6.420266e-001, 6.419882e-001, 6.419497e-001, 6.419111e-001, 6.418726e-001, 6.418340e-001, 6.417954e-001, 6.417567e-001, 6.417181e-001, 6.416794e-001, 6.416406e-001, 6.416019e-001, 6.415631e-001, 6.415242e-001, 6.414854e-001, 6.414465e-001, 6.414076e-001, 6.413686e-001, 6.413297e-001, 6.412907e-001, 6.412516e-001, 6.412126e-001, 6.411735e-001, 6.411343e-001, 6.410952e-001, 6.410560e-001, 6.410168e-001, 6.409775e-001, 6.409383e-001, 6.408990e-001, 6.408596e-001, 6.408203e-001, 6.407809e-001, 6.407414e-001, 6.407020e-001, 6.406625e-001, 6.406230e-001, 6.405834e-001, 6.405439e-001, 6.405043e-001, 6.404646e-001, 6.404250e-001, 6.403853e-001, 6.403455e-001, 6.403058e-001, 6.402660e-001, 6.402262e-001, 6.401863e-001, 6.401465e-001, 6.401066e-001, 6.400666e-001, 6.400267e-001, 6.399867e-001, 6.399466e-001, 6.399066e-001, 6.398665e-001, 6.398264e-001, 6.397862e-001, 6.397461e-001, 6.397059e-001, 6.396656e-001, 6.396254e-001, 6.395851e-001, 6.395447e-001, 6.395044e-001, 6.394640e-001, 6.394236e-001, 6.393831e-001, 6.393427e-001, 6.393022e-001, 6.392616e-001, 6.392211e-001, 6.391805e-001, 6.391398e-001, 6.390992e-001, 6.390585e-001, 6.390178e-001, 6.389770e-001, 6.389363e-001, 6.388955e-001, 6.388546e-001, 6.388138e-001, 6.387729e-001, 6.387319e-001, 6.386910e-001, 
6.386500e-001, 6.386090e-001, 6.385679e-001, 6.385269e-001, 6.384858e-001, 6.384446e-001, 6.384035e-001, 6.383623e-001, 6.383210e-001, 6.382798e-001, 6.382385e-001, 6.381972e-001, 6.381558e-001, 6.381145e-001, 6.380731e-001, 6.380316e-001, 6.379902e-001, 6.379487e-001, 6.379071e-001, 6.378656e-001, 6.378240e-001, 6.377824e-001, 6.377407e-001, 6.376991e-001, 6.376574e-001, 6.376156e-001, 6.375739e-001, 6.375321e-001, 6.374902e-001, 6.374484e-001, 6.374065e-001, 6.373646e-001, 6.373226e-001, 6.372807e-001, 6.372387e-001, 6.371966e-001, 6.371546e-001, 6.371125e-001, 6.370703e-001, 6.370282e-001, 6.369860e-001, 6.369438e-001, 6.369015e-001, 6.368593e-001, 6.368170e-001, 6.367746e-001, 6.367323e-001, 6.366899e-001, 6.366474e-001, 6.366050e-001, 6.365625e-001, 6.365200e-001, 6.364774e-001, 6.364349e-001, 6.363923e-001, 6.363496e-001, 6.363070e-001, 6.362643e-001, 6.362215e-001, 6.361788e-001, 6.361360e-001, 6.360932e-001, 6.360503e-001, 6.360075e-001, 6.359646e-001, 6.359216e-001, 6.358787e-001, 6.358357e-001, 6.357926e-001, 6.357496e-001, 6.357065e-001, 6.356634e-001, 6.356202e-001, 6.355771e-001, 6.355339e-001, 6.354906e-001, 6.354474e-001, 6.354041e-001, 6.353607e-001, 6.353174e-001, 6.352740e-001, 6.352306e-001, 6.351871e-001, 6.351437e-001, 6.351002e-001, 6.350566e-001, 6.350131e-001, 6.349695e-001, 6.349258e-001, 6.348822e-001, 6.348385e-001, 6.347948e-001, 6.347510e-001, 6.347073e-001, 6.346635e-001, 6.346196e-001, 6.345758e-001, 6.345319e-001, 6.344879e-001, 6.344440e-001, 
6.344000e-001, 6.343560e-001, 6.343119e-001, 6.342679e-001, 6.342238e-001, 6.341796e-001, 6.341355e-001, 6.340913e-001, 6.340470e-001, 6.340028e-001, 6.339585e-001, 6.339142e-001, 6.338698e-001, 6.338255e-001, 6.337811e-001, 6.337366e-001, 6.336922e-001, 6.336477e-001, 6.336031e-001, 6.335586e-001, 6.335140e-001, 6.334694e-001, 6.334247e-001, 6.333801e-001, 6.333354e-001, 6.332906e-001, 6.332459e-001, 6.332011e-001, 6.331562e-001, 6.331114e-001, 6.330665e-001, 6.330216e-001, 6.329766e-001, 6.329317e-001, 6.328867e-001, 6.328416e-001, 6.327966e-001, 6.327515e-001, 6.327063e-001, 6.326612e-001, 6.326160e-001, 6.325708e-001, 6.325255e-001, 6.324803e-001, 6.324350e-001, 6.323896e-001, 6.323443e-001, 6.322989e-001, 6.322534e-001, 6.322080e-001, 6.321625e-001, 6.321170e-001, 6.320714e-001, 6.320259e-001, 6.319803e-001, 6.319346e-001, 6.318890e-001, 6.318433e-001, 6.317975e-001, 6.317518e-001, 6.317060e-001, 6.316602e-001, 6.316143e-001, 6.315685e-001, 6.315226e-001, 6.314766e-001, 6.314307e-001, 6.313847e-001, 6.313386e-001, 6.312926e-001, 6.312465e-001, 6.312004e-001, 6.311542e-001, 6.311081e-001, 6.310619e-001, 6.310156e-001, 6.309694e-001, 6.309231e-001, 6.308767e-001, 6.308304e-001, 6.307840e-001, 6.307376e-001, 6.306911e-001, 6.306447e-001, 6.305982e-001, 6.305516e-001, 6.305051e-001, 6.304585e-001, 6.304118e-001, 6.303652e-001, 6.303185e-001, 6.302718e-001, 6.302250e-001, 6.301783e-001, 6.301315e-001, 6.300846e-001, 6.300378e-001, 6.299909e-001, 6.299439e-001, 6.298970e-001, 
6.298500e-001, 6.298030e-001, 6.297559e-001, 6.297089e-001, 6.296618e-001, 6.296146e-001, 6.295675e-001, 6.295203e-001, 6.294730e-001, 6.294258e-001, 6.293785e-001, 6.293312e-001, 6.292838e-001, 6.292365e-001, 6.291891e-001, 6.291416e-001, 6.290942e-001, 6.290467e-001, 6.289991e-001, 6.289516e-001, 6.289040e-001, 6.288564e-001, 6.288087e-001, 6.287611e-001, 6.287134e-001, 6.286656e-001, 6.286179e-001, 6.285701e-001, 6.285222e-001, 6.284744e-001, 6.284265e-001, 6.283786e-001, 6.283306e-001, 6.282827e-001, 6.282347e-001, 6.281866e-001, 6.281386e-001, 6.280905e-001, 6.280423e-001, 6.279942e-001, 6.279460e-001, 6.278978e-001, 6.278495e-001, 6.278013e-001, 6.277530e-001, 6.277046e-001, 6.276563e-001, 6.276079e-001, 6.275594e-001, 6.275110e-001, 6.274625e-001, 6.274140e-001, 6.273654e-001, 6.273169e-001, 6.272683e-001, 6.272196e-001, 6.271710e-001, 6.271223e-001, 6.270735e-001, 6.270248e-001, 6.269760e-001, 6.269272e-001, 6.268783e-001, 6.268295e-001, 6.267806e-001, 6.267316e-001, 6.266827e-001, 6.266337e-001, 6.265846e-001, 6.265356e-001, 6.264865e-001, 6.264374e-001, 6.263882e-001, 6.263391e-001, 6.262899e-001, 6.262406e-001, 6.261914e-001, 6.261421e-001, 6.260927e-001, 6.260434e-001, 6.259940e-001, 6.259446e-001, 6.258951e-001, 6.258457e-001, 6.257962e-001, 6.257466e-001, 6.256971e-001, 6.256475e-001, 6.255978e-001, 6.255482e-001, 6.254985e-001, 6.254488e-001, 6.253990e-001, 6.253493e-001, 6.252995e-001, 6.252496e-001, 6.251998e-001, 6.251499e-001, 6.250999e-001, 6.250500e-001, 
6.250000e-001, 6.249500e-001, 6.248999e-001, 6.248499e-001, 6.247998e-001, 6.247496e-001, 6.246995e-001, 6.246493e-001, 6.245990e-001, 6.245488e-001, 6.244985e-001, 6.244482e-001, 6.243978e-001, 6.243475e-001, 6.242971e-001, 6.242466e-001, 6.241962e-001, 6.241457e-001, 6.240951e-001, 6.240446e-001, 6.239940e-001, 6.239434e-001, 6.238927e-001, 6.238421e-001, 6.237914e-001, 6.237406e-001, 6.236899e-001, 6.236391e-001, 6.235882e-001, 6.235374e-001, 6.234865e-001, 6.234356e-001, 6.233846e-001, 6.233337e-001, 6.232827e-001, 6.232316e-001, 6.231806e-001, 6.231295e-001, 6.230783e-001, 6.230272e-001, 6.229760e-001, 6.229248e-001, 6.228735e-001, 6.228223e-001, 6.227710e-001, 6.227196e-001, 6.226683e-001, 6.226169e-001, 6.225654e-001, 6.225140e-001, 6.224625e-001, 6.224110e-001, 6.223594e-001, 6.223079e-001, 6.222563e-001, 6.222046e-001, 6.221530e-001, 6.221013e-001, 6.220495e-001, 6.219978e-001, 6.219460e-001, 6.218942e-001, 6.218423e-001, 6.217905e-001, 6.217386e-001, 6.216866e-001, 6.216347e-001, 6.215827e-001, 6.215306e-001, 6.214786e-001, 6.214265e-001, 6.213744e-001, 6.213222e-001, 6.212701e-001, 6.212179e-001, 6.211656e-001, 6.211134e-001, 6.210611e-001, 6.210087e-001, 6.209564e-001, 6.209040e-001, 6.208516e-001, 6.207991e-001, 6.207467e-001, 6.206942e-001, 6.206416e-001, 6.205891e-001, 6.205365e-001, 6.204838e-001, 6.204312e-001, 6.203785e-001, 6.203258e-001, 6.202730e-001, 6.202203e-001, 6.201675e-001, 6.201146e-001, 6.200618e-001, 6.200089e-001, 6.199559e-001, 6.199030e-001, 
6.198500e-001, 6.197970e-001, 6.197439e-001, 6.196909e-001, 6.196378e-001, 6.195846e-001, 6.195315e-001, 6.194783e-001, 6.194250e-001, 6.193718e-001, 6.193185e-001, 6.192652e-001, 6.192118e-001, 6.191585e-001, 6.191051e-001, 6.190516e-001, 6.189982e-001, 6.189447e-001, 6.188911e-001, 6.188376e-001, 6.187840e-001, 6.187304e-001, 6.186767e-001, 6.186231e-001, 6.185694e-001, 6.185156e-001, 6.184619e-001, 6.184081e-001, 6.183542e-001, 6.183004e-001, 6.182465e-001, 6.181926e-001, 6.181386e-001, 6.180847e-001, 6.180307e-001, 6.179766e-001, 6.179226e-001, 6.178685e-001, 6.178143e-001, 6.177602e-001, 6.177060e-001, 6.176518e-001, 6.175975e-001, 6.175433e-001, 6.174890e-001, 6.174346e-001, 6.173803e-001, 6.173259e-001, 6.172714e-001, 6.1721