///////////////////////////////////////////////////////////////////////////////////////
// ENT_table.h
// Developed by Dongjin Kwon
///////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011-2014 Dongjin Kwon
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
///////////////////////////////////////////////////////////////////////////////////////

#if !defined(ENT_TABLE_H)
#define ENT_TABLE_H


// For the round up purpose, we multiply 100001 instead of 100000
// -t*log(t)
#define ENT(t)			(T_ENT[(int)((t)*100001)])
// -t*log(t)/log(2)-(1-t)*log(1-t)/log(2)
#define ENT2(t)			(T_ENT2[(int)((t)*100001)])
// -log(t/(1-t))/log(2)
#define ENT2D(t)		(T_ENT2D[(int)((t)*100001)])

#define MAX_ENT 100002


static double T_ENT[MAX_ENT] = {
0.000000e+000, 1.151293e-004, 2.163956e-004, 3.124294e-004, 4.050652e-004, 4.951744e-004, 5.832700e-004, 6.696911e-004, 7.546787e-004, 8.384131e-004, 9.210340e-004, 1.002653e-003, 1.083362e-003, 1.163237e-003, 1.242342e-003, 1.320731e-003, 1.398454e-003, 1.475551e-003, 1.552060e-003, 1.628012e-003, 1.703439e-003, 1.778365e-003, 1.852814e-003, 1.926809e-003, 2.000369e-003, 2.073512e-003, 2.146256e-003, 2.218614e-003, 2.290602e-003, 2.362233e-003, 2.433518e-003, 2.504471e-003, 2.575101e-003, 2.645418e-003, 2.715432e-003, 2.785152e-003, 2.854586e-003, 2.923743e-003, 2.992629e-003, 3.061252e-003, 3.129618e-003, 3.197735e-003, 3.265607e-003, 3.333242e-003, 3.400644e-003, 3.467818e-003, 3.534771e-003, 3.601506e-003, 3.668028e-003, 3.734342e-003, 3.800451e-003, 3.866361e-003, 3.932075e-003, 3.997596e-003, 4.062928e-003, 4.128076e-003, 4.193041e-003, 4.257828e-003, 4.322440e-003, 4.386879e-003, 4.451149e-003, 4.515251e-003, 4.579190e-003, 4.642968e-003, 4.706587e-003, 4.770050e-003, 4.833359e-003, 4.896516e-003, 4.959524e-003, 5.022385e-003, 5.085101e-003, 5.147674e-003, 5.210107e-003, 5.272400e-003, 5.334557e-003, 5.396578e-003, 5.458466e-003, 5.520222e-003, 5.581849e-003, 5.643347e-003, 5.704719e-003, 5.765966e-003, 5.827089e-003, 5.888090e-003, 5.948971e-003, 6.009733e-003, 6.070377e-003, 6.130905e-003, 6.191318e-003, 6.251617e-003, 6.311804e-003, 6.371880e-003, 6.431846e-003, 6.491703e-003, 6.551453e-003, 6.611096e-003, 6.670634e-003, 6.730068e-003, 6.789399e-003, 6.848628e-003, 
6.907755e-003, 6.966783e-003, 7.025712e-003, 7.084542e-003, 7.143276e-003, 7.201913e-003, 7.260456e-003, 7.318903e-003, 7.377258e-003, 7.435520e-003, 7.493690e-003, 7.551769e-003, 7.609758e-003, 7.667658e-003, 7.725469e-003, 7.783192e-003, 7.840829e-003, 7.898379e-003, 7.955844e-003, 8.013224e-003, 8.070520e-003, 8.127733e-003, 8.184863e-003, 8.241912e-003, 8.298878e-003, 8.355765e-003, 8.412571e-003, 8.469298e-003, 8.525946e-003, 8.582516e-003, 8.639008e-003, 8.695424e-003, 8.751763e-003, 8.808027e-003, 8.864215e-003, 8.920328e-003, 8.976368e-003, 9.032334e-003, 9.088227e-003, 9.144048e-003, 9.199796e-003, 9.255473e-003, 9.311080e-003, 9.366616e-003, 9.422082e-003, 9.477478e-003, 9.532806e-003, 9.588065e-003, 9.643256e-003, 9.698379e-003, 9.753435e-003, 9.808425e-003, 9.863348e-003, 9.918206e-003, 9.972998e-003, 1.002773e-002, 1.008239e-002, 1.013699e-002, 1.019152e-002, 1.024599e-002, 1.030040e-002, 1.035475e-002, 1.040903e-002, 1.046326e-002, 1.051742e-002, 1.057152e-002, 1.062556e-002, 1.067954e-002, 1.073346e-002, 1.078732e-002, 1.084112e-002, 1.089486e-002, 1.094854e-002, 1.100217e-002, 1.105573e-002, 1.110924e-002, 1.116270e-002, 1.121609e-002, 1.126943e-002, 1.132272e-002, 1.137594e-002, 1.142912e-002, 1.148223e-002, 1.153529e-002, 1.158830e-002, 1.164125e-002, 1.169415e-002, 1.174700e-002, 1.179979e-002, 1.185253e-002, 1.190521e-002, 1.195785e-002, 1.201043e-002, 1.206295e-002, 1.211543e-002, 1.216786e-002, 1.222023e-002, 1.227255e-002, 1.232482e-002, 1.237705e-002, 
1.242922e-002, 1.248134e-002, 1.253341e-002, 1.258543e-002, 1.263740e-002, 1.268933e-002, 1.274120e-002, 1.279303e-002, 1.284481e-002, 1.289654e-002, 1.294822e-002, 1.299985e-002, 1.305144e-002, 1.310298e-002, 1.315447e-002, 1.320592e-002, 1.325732e-002, 1.330867e-002, 1.335998e-002, 1.341124e-002, 1.346246e-002, 1.351363e-002, 1.356475e-002, 1.361583e-002, 1.366687e-002, 1.371786e-002, 1.376880e-002, 1.381970e-002, 1.387056e-002, 1.392138e-002, 1.397215e-002, 1.402287e-002, 1.407356e-002, 1.412420e-002, 1.417479e-002, 1.422535e-002, 1.427586e-002, 1.432633e-002, 1.437676e-002, 1.442714e-002, 1.447749e-002, 1.452779e-002, 1.457805e-002, 1.462827e-002, 1.467845e-002, 1.472858e-002, 1.477868e-002, 1.482874e-002, 1.487875e-002, 1.492873e-002, 1.497866e-002, 1.502856e-002, 1.507841e-002, 1.512823e-002, 1.517800e-002, 1.522774e-002, 1.527743e-002, 1.532709e-002, 1.537671e-002, 1.542629e-002, 1.547583e-002, 1.552534e-002, 1.557480e-002, 1.562423e-002, 1.567362e-002, 1.572297e-002, 1.577228e-002, 1.582156e-002, 1.587080e-002, 1.592000e-002, 1.596916e-002, 1.601829e-002, 1.606738e-002, 1.611643e-002, 1.616544e-002, 1.621442e-002, 1.626337e-002, 1.631228e-002, 1.636115e-002, 1.640998e-002, 1.645878e-002, 1.650754e-002, 1.655627e-002, 1.660496e-002, 1.665362e-002, 1.670224e-002, 1.675083e-002, 1.679938e-002, 1.684790e-002, 1.689638e-002, 1.694483e-002, 1.699324e-002, 1.704162e-002, 1.708997e-002, 1.713828e-002, 1.718655e-002, 1.723480e-002, 1.728300e-002, 1.733118e-002, 1.737932e-002, 
1.742743e-002, 1.747550e-002, 1.752355e-002, 1.757155e-002, 1.761953e-002, 1.766747e-002, 1.771538e-002, 1.776326e-002, 1.781110e-002, 1.785892e-002, 1.790669e-002, 1.795444e-002, 1.800216e-002, 1.804984e-002, 1.809749e-002, 1.814511e-002, 1.819270e-002, 1.824026e-002, 1.828778e-002, 1.833527e-002, 1.838273e-002, 1.843016e-002, 1.847756e-002, 1.852493e-002, 1.857227e-002, 1.861958e-002, 1.866685e-002, 1.871410e-002, 1.876131e-002, 1.880849e-002, 1.885565e-002, 1.890277e-002, 1.894986e-002, 1.899693e-002, 1.904396e-002, 1.909096e-002, 1.913794e-002, 1.918488e-002, 1.923179e-002, 1.927868e-002, 1.932553e-002, 1.937236e-002, 1.941915e-002, 1.946592e-002, 1.951266e-002, 1.955936e-002, 1.960604e-002, 1.965269e-002, 1.969932e-002, 1.974591e-002, 1.979247e-002, 1.983901e-002, 1.988552e-002, 1.993199e-002, 1.997845e-002, 2.002487e-002, 2.007126e-002, 2.011763e-002, 2.016397e-002, 2.021028e-002, 2.025656e-002, 2.030281e-002, 2.034904e-002, 2.039524e-002, 2.044141e-002, 2.048755e-002, 2.053367e-002, 2.057976e-002, 2.062582e-002, 2.067186e-002, 2.071786e-002, 2.076384e-002, 2.080980e-002, 2.085572e-002, 2.090162e-002, 2.094750e-002, 2.099334e-002, 2.103916e-002, 2.108496e-002, 2.113073e-002, 2.117647e-002, 2.122218e-002, 2.126787e-002, 2.131353e-002, 2.135917e-002, 2.140478e-002, 2.145036e-002, 2.149592e-002, 2.154145e-002, 2.158696e-002, 2.163244e-002, 2.167789e-002, 2.172332e-002, 2.176873e-002, 2.181410e-002, 2.185946e-002, 2.190478e-002, 2.195009e-002, 2.199536e-002, 2.204062e-002, 
2.208584e-002, 2.213105e-002, 2.217622e-002, 2.222138e-002, 2.226650e-002, 2.231161e-002, 2.235668e-002, 2.240174e-002, 2.244677e-002, 2.249177e-002, 2.253675e-002, 2.258171e-002, 2.262664e-002, 2.267154e-002, 2.271643e-002, 2.276128e-002, 2.280612e-002, 2.285093e-002, 2.289572e-002, 2.294048e-002, 2.298522e-002, 2.302993e-002, 2.307462e-002, 2.311929e-002, 2.316393e-002, 2.320855e-002, 2.325315e-002, 2.329772e-002, 2.334227e-002, 2.338680e-002, 2.343130e-002, 2.347578e-002, 2.352024e-002, 2.356467e-002, 2.360908e-002, 2.365347e-002, 2.369783e-002, 2.374218e-002, 2.378649e-002, 2.383079e-002, 2.387506e-002, 2.391931e-002, 2.396354e-002, 2.400775e-002, 2.405193e-002, 2.409609e-002, 2.414023e-002, 2.418434e-002, 2.422843e-002, 2.427250e-002, 2.431655e-002, 2.436058e-002, 2.440458e-002, 2.444856e-002, 2.449252e-002, 2.453646e-002, 2.458037e-002, 2.462427e-002, 2.466814e-002, 2.471199e-002, 2.475582e-002, 2.479962e-002, 2.484341e-002, 2.488717e-002, 2.493091e-002, 2.497463e-002, 2.501833e-002, 2.506200e-002, 2.510566e-002, 2.514929e-002, 2.519291e-002, 2.523650e-002, 2.528007e-002, 2.532362e-002, 2.536714e-002, 2.541065e-002, 2.545414e-002, 2.549760e-002, 2.554104e-002, 2.558447e-002, 2.562787e-002, 2.567125e-002, 2.571461e-002, 2.575795e-002, 2.580127e-002, 2.584457e-002, 2.588784e-002, 2.593110e-002, 2.597434e-002, 2.601755e-002, 2.606075e-002, 2.610392e-002, 2.614708e-002, 2.619021e-002, 2.623333e-002, 2.627642e-002, 2.631949e-002, 2.636255e-002, 2.640558e-002, 2.644859e-002, 
2.649159e-002, 2.653456e-002, 2.657751e-002, 2.662045e-002, 2.666336e-002, 2.670625e-002, 2.674913e-002, 2.679198e-002, 2.683482e-002, 2.687763e-002, 2.692043e-002, 2.696320e-002, 2.700596e-002, 2.704869e-002, 2.709141e-002, 2.713411e-002, 2.717678e-002, 2.721944e-002, 2.726208e-002, 2.730470e-002, 2.734730e-002, 2.738988e-002, 2.743245e-002, 2.747499e-002, 2.751751e-002, 2.756002e-002, 2.760250e-002, 2.764497e-002, 2.768742e-002, 2.772985e-002, 2.777226e-002, 2.781465e-002, 2.785702e-002, 2.789937e-002, 2.794171e-002, 2.798402e-002, 2.802632e-002, 2.806860e-002, 2.811086e-002, 2.815310e-002, 2.819532e-002, 2.823753e-002, 2.827971e-002, 2.832188e-002, 2.836403e-002, 2.840616e-002, 2.844827e-002, 2.849037e-002, 2.853244e-002, 2.857450e-002, 2.861654e-002, 2.865856e-002, 2.870056e-002, 2.874255e-002, 2.878451e-002, 2.882646e-002, 2.886839e-002, 2.891031e-002, 2.895220e-002, 2.899408e-002, 2.903594e-002, 2.907778e-002, 2.911960e-002, 2.916141e-002, 2.920319e-002, 2.924496e-002, 2.928672e-002, 2.932845e-002, 2.937017e-002, 2.941187e-002, 2.945355e-002, 2.949521e-002, 2.953686e-002, 2.957849e-002, 2.962010e-002, 2.966169e-002, 2.970327e-002, 2.974483e-002, 2.978637e-002, 2.982790e-002, 2.986940e-002, 2.991090e-002, 2.995237e-002, 2.999382e-002, 3.003526e-002, 3.007668e-002, 3.011809e-002, 3.015948e-002, 3.020085e-002, 3.024220e-002, 3.028354e-002, 3.032486e-002, 3.036616e-002, 3.040745e-002, 3.044871e-002, 3.048997e-002, 3.053120e-002, 3.057242e-002, 3.061362e-002, 3.065481e-002, 
3.069597e-002, 3.073713e-002, 3.077826e-002, 3.081938e-002, 3.086048e-002, 3.090157e-002, 3.094264e-002, 3.098369e-002, 3.102472e-002, 3.106574e-002, 3.110675e-002, 3.114773e-002, 3.118870e-002, 3.122966e-002, 3.127059e-002, 3.131151e-002, 3.135242e-002, 3.139331e-002, 3.143418e-002, 3.147504e-002, 3.151588e-002, 3.155670e-002, 3.159751e-002, 3.163830e-002, 3.167908e-002, 3.171984e-002, 3.176058e-002, 3.180131e-002, 3.184202e-002, 3.188272e-002, 3.192340e-002, 3.196406e-002, 3.200471e-002, 3.204534e-002, 3.208596e-002, 3.212656e-002, 3.216714e-002, 3.220771e-002, 3.224827e-002, 3.228880e-002, 3.232933e-002, 3.236983e-002, 3.241032e-002, 3.245080e-002, 3.249126e-002, 3.253170e-002, 3.257213e-002, 3.261255e-002, 3.265295e-002, 3.269333e-002, 3.273370e-002, 3.277405e-002, 3.281438e-002, 3.285470e-002, 3.289501e-002, 3.293530e-002, 3.297558e-002, 3.301584e-002, 3.305608e-002, 3.309631e-002, 3.313653e-002, 3.317672e-002, 3.321691e-002, 3.325708e-002, 3.329723e-002, 3.333737e-002, 3.337749e-002, 3.341760e-002, 3.345770e-002, 3.349778e-002, 3.353784e-002, 3.357789e-002, 3.361792e-002, 3.365794e-002, 3.369795e-002, 3.373794e-002, 3.377791e-002, 3.381787e-002, 3.385782e-002, 3.389775e-002, 3.393766e-002, 3.397756e-002, 3.401745e-002, 3.405732e-002, 3.409718e-002, 3.413702e-002, 3.417685e-002, 3.421666e-002, 3.425646e-002, 3.429624e-002, 3.433601e-002, 3.437577e-002, 3.441551e-002, 3.445524e-002, 3.449495e-002, 3.453464e-002, 3.457433e-002, 3.461400e-002, 3.465365e-002, 3.469329e-002, 
3.473292e-002, 3.477253e-002, 3.481212e-002, 3.485171e-002, 3.489128e-002, 3.493083e-002, 3.497037e-002, 3.500990e-002, 3.504941e-002, 3.508891e-002, 3.512839e-002, 3.516786e-002, 3.520731e-002, 3.524676e-002, 3.528618e-002, 3.532560e-002, 3.536500e-002, 3.540438e-002, 3.544375e-002, 3.548311e-002, 3.552245e-002, 3.556178e-002, 3.560110e-002, 3.564040e-002, 3.567969e-002, 3.571897e-002, 3.575823e-002, 3.579747e-002, 3.583671e-002, 3.587593e-002, 3.591513e-002, 3.595432e-002, 3.599350e-002, 3.603267e-002, 3.607182e-002, 3.611095e-002, 3.615008e-002, 3.618919e-002, 3.622828e-002, 3.626737e-002, 3.630644e-002, 3.634549e-002, 3.638454e-002, 3.642356e-002, 3.646258e-002, 3.650158e-002, 3.654057e-002, 3.657955e-002, 3.661851e-002, 3.665746e-002, 3.669639e-002, 3.673531e-002, 3.677422e-002, 3.681312e-002, 3.685200e-002, 3.689087e-002, 3.692972e-002, 3.696857e-002, 3.700739e-002, 3.704621e-002, 3.708501e-002, 3.712380e-002, 3.716258e-002, 3.720134e-002, 3.724009e-002, 3.727883e-002, 3.731755e-002, 3.735626e-002, 3.739496e-002, 3.743365e-002, 3.747232e-002, 3.751098e-002, 3.754962e-002, 3.758826e-002, 3.762688e-002, 3.766548e-002, 3.770408e-002, 3.774266e-002, 3.778123e-002, 3.781978e-002, 3.785833e-002, 3.789686e-002, 3.793537e-002, 3.797388e-002, 3.801237e-002, 3.805085e-002, 3.808931e-002, 3.812777e-002, 3.816621e-002, 3.820464e-002, 3.824305e-002, 3.828145e-002, 3.831984e-002, 3.835822e-002, 3.839659e-002, 3.843494e-002, 3.847328e-002, 3.851160e-002, 3.854992e-002, 3.858822e-002, 
3.862651e-002, 3.866479e-002, 3.870305e-002, 3.874130e-002, 3.877954e-002, 3.881777e-002, 3.885598e-002, 3.889419e-002, 3.893238e-002, 3.897055e-002, 3.900872e-002, 3.904687e-002, 3.908501e-002, 3.912314e-002, 3.916126e-002, 3.919936e-002, 3.923745e-002, 3.927553e-002, 3.931360e-002, 3.935165e-002, 3.938969e-002, 3.942772e-002, 3.946574e-002, 3.950375e-002, 3.954174e-002, 3.957972e-002, 3.961769e-002, 3.965565e-002, 3.969359e-002, 3.973153e-002, 3.976945e-002, 3.980736e-002, 3.984525e-002, 3.988314e-002, 3.992101e-002, 3.995887e-002, 3.999672e-002, 4.003456e-002, 4.007238e-002, 4.011020e-002, 4.014800e-002, 4.018579e-002, 4.022356e-002, 4.026133e-002, 4.029908e-002, 4.033683e-002, 4.037456e-002, 4.041227e-002, 4.044998e-002, 4.048767e-002, 4.052536e-002, 4.056303e-002, 4.060069e-002, 4.063834e-002, 4.067597e-002, 4.071360e-002, 4.075121e-002, 4.078881e-002, 4.082640e-002, 4.086397e-002, 4.090154e-002, 4.093909e-002, 4.097664e-002, 4.101417e-002, 4.105169e-002, 4.108920e-002, 4.112669e-002, 4.116418e-002, 4.120165e-002, 4.123911e-002, 4.127656e-002, 4.131400e-002, 4.135143e-002, 4.138884e-002, 4.142625e-002, 4.146364e-002, 4.150102e-002, 4.153839e-002, 4.157575e-002, 4.161310e-002, 4.165043e-002, 4.168776e-002, 4.172507e-002, 4.176237e-002, 4.179966e-002, 4.183694e-002, 4.187421e-002, 4.191146e-002, 4.194871e-002, 4.198594e-002, 4.202317e-002, 4.206038e-002, 4.209758e-002, 4.213477e-002, 4.217194e-002, 4.220911e-002, 4.224627e-002, 4.228341e-002, 4.232054e-002, 4.235767e-002, 
4.239478e-002, 4.243188e-002, 4.246896e-002, 4.250604e-002, 4.254311e-002, 4.258016e-002, 4.261721e-002, 4.265424e-002, 4.269126e-002, 4.272828e-002, 4.276528e-002, 4.280227e-002, 4.283924e-002, 4.287621e-002, 4.291317e-002, 4.295011e-002, 4.298705e-002, 4.302397e-002, 4.306088e-002, 4.309779e-002, 4.313468e-002, 4.317156e-002, 4.320843e-002, 4.324528e-002, 4.328213e-002, 4.331897e-002, 4.335579e-002, 4.339261e-002, 4.342941e-002, 4.346621e-002, 4.350299e-002, 4.353976e-002, 4.357652e-002, 4.361327e-002, 4.365001e-002, 4.368674e-002, 4.372346e-002, 4.376017e-002, 4.379687e-002, 4.383355e-002, 4.387023e-002, 4.390689e-002, 4.394355e-002, 4.398019e-002, 4.401683e-002, 4.405345e-002, 4.409006e-002, 4.412666e-002, 4.416325e-002, 4.419983e-002, 4.423640e-002, 4.427296e-002, 4.430951e-002, 4.434605e-002, 4.438258e-002, 4.441909e-002, 4.445560e-002, 4.449210e-002, 4.452858e-002, 4.456506e-002, 4.460152e-002, 4.463798e-002, 4.467442e-002, 4.471086e-002, 4.474728e-002, 4.478369e-002, 4.482010e-002, 4.485649e-002, 4.489287e-002, 4.492924e-002, 4.496561e-002, 4.500196e-002, 4.503830e-002, 4.507463e-002, 4.511095e-002, 4.514726e-002, 4.518356e-002, 4.521985e-002, 4.525613e-002, 4.529240e-002, 4.532865e-002, 4.536490e-002, 4.540114e-002, 4.543737e-002, 4.547359e-002, 4.550980e-002, 4.554599e-002, 4.558218e-002, 4.561836e-002, 4.565453e-002, 4.569068e-002, 4.572683e-002, 4.576297e-002, 4.579909e-002, 4.583521e-002, 4.587132e-002, 4.590741e-002, 4.594350e-002, 4.597958e-002, 4.601565e-002, 
4.605170e-002, 4.608775e-002, 4.612379e-002, 4.615981e-002, 4.619583e-002, 4.623184e-002, 4.626783e-002, 4.630382e-002, 4.633980e-002, 4.637576e-002, 4.641172e-002, 4.644767e-002, 4.648361e-002, 4.651953e-002, 4.655545e-002, 4.659136e-002, 4.662726e-002, 4.666314e-002, 4.669902e-002, 4.673489e-002, 4.677075e-002, 4.680660e-002, 4.684244e-002, 4.687827e-002, 4.691409e-002, 4.694990e-002, 4.698570e-002, 4.702149e-002, 4.705727e-002, 4.709304e-002, 4.712880e-002, 4.716455e-002, 4.720029e-002, 4.723602e-002, 4.727174e-002, 4.730746e-002, 4.734316e-002, 4.737885e-002, 4.741454e-002, 4.745021e-002, 4.748587e-002, 4.752153e-002, 4.755717e-002, 4.759281e-002, 4.762844e-002, 4.766405e-002, 4.769966e-002, 4.773526e-002, 4.777084e-002, 4.780642e-002, 4.784199e-002, 4.787755e-002, 4.791310e-002, 4.794864e-002, 4.798417e-002, 4.801969e-002, 4.805520e-002, 4.809070e-002, 4.812620e-002, 4.816168e-002, 4.819715e-002, 4.823262e-002, 4.826807e-002, 4.830352e-002, 4.833895e-002, 4.837438e-002, 4.840980e-002, 4.844521e-002, 4.848060e-002, 4.851599e-002, 4.855137e-002, 4.858674e-002, 4.862211e-002, 4.865746e-002, 4.869280e-002, 4.872813e-002, 4.876346e-002, 4.879877e-002, 4.883408e-002, 4.886937e-002, 4.890466e-002, 4.893994e-002, 4.897520e-002, 4.901046e-002, 4.904571e-002, 4.908095e-002, 4.911618e-002, 4.915141e-002, 4.918662e-002, 4.922182e-002, 4.925702e-002, 4.929220e-002, 4.932738e-002, 4.936255e-002, 4.939770e-002, 4.943285e-002, 4.946799e-002, 4.950312e-002, 4.953824e-002, 4.957336e-002, 
4.960846e-002, 4.964355e-002, 4.967864e-002, 4.971371e-002, 4.974878e-002, 4.978384e-002, 4.981889e-002, 4.985393e-002, 4.988896e-002, 4.992398e-002, 4.995899e-002, 4.999400e-002, 5.002899e-002, 5.006398e-002, 5.009895e-002, 5.013392e-002, 5.016888e-002, 5.020383e-002, 5.023877e-002, 5.027370e-002, 5.030862e-002, 5.034354e-002, 5.037844e-002, 5.041334e-002, 5.044823e-002, 5.048311e-002, 5.051797e-002, 5.055284e-002, 5.058769e-002, 5.062253e-002, 5.065736e-002, 5.069219e-002, 5.072701e-002, 5.076181e-002, 5.079661e-002, 5.083140e-002, 5.086618e-002, 5.090095e-002, 5.093572e-002, 5.097047e-002, 5.100522e-002, 5.103995e-002, 5.107468e-002, 5.110940e-002, 5.114411e-002, 5.117882e-002, 5.121351e-002, 5.124819e-002, 5.128287e-002, 5.131754e-002, 5.135219e-002, 5.138684e-002, 5.142149e-002, 5.145612e-002, 5.149074e-002, 5.152536e-002, 5.155996e-002, 5.159456e-002, 5.162915e-002, 5.166373e-002, 5.169830e-002, 5.173287e-002, 5.176742e-002, 5.180197e-002, 5.183650e-002, 5.187103e-002, 5.190555e-002, 5.194006e-002, 5.197457e-002, 5.200906e-002, 5.204355e-002, 5.207802e-002, 5.211249e-002, 5.214695e-002, 5.218141e-002, 5.221585e-002, 5.225028e-002, 5.228471e-002, 5.231913e-002, 5.235354e-002, 5.238794e-002, 5.242233e-002, 5.245671e-002, 5.249109e-002, 5.252546e-002, 5.255981e-002, 5.259416e-002, 5.262851e-002, 5.266284e-002, 5.269716e-002, 5.273148e-002, 5.276579e-002, 5.280009e-002, 5.283438e-002, 5.286866e-002, 5.290294e-002, 5.293720e-002, 5.297146e-002, 5.300571e-002, 5.303995e-002, 
5.307418e-002, 5.310841e-002, 5.314262e-002, 5.317683e-002, 5.321103e-002, 5.324522e-002, 5.327940e-002, 5.331358e-002, 5.334775e-002, 5.338190e-002, 5.341605e-002, 5.345019e-002, 5.348433e-002, 5.351845e-002, 5.355257e-002, 5.358668e-002, 5.362078e-002, 5.365487e-002, 5.368895e-002, 5.372303e-002, 5.375710e-002, 5.379115e-002, 5.382521e-002, 5.385925e-002, 5.389328e-002, 5.392731e-002, 5.396133e-002, 5.399534e-002, 5.402934e-002, 5.406333e-002, 5.409732e-002, 5.413130e-002, 5.416527e-002, 5.419923e-002, 5.423318e-002, 5.426713e-002, 5.430106e-002, 5.433499e-002, 5.436891e-002, 5.440282e-002, 5.443673e-002, 5.447063e-002, 5.450451e-002, 5.453839e-002, 5.457227e-002, 5.460613e-002, 5.463999e-002, 5.467384e-002, 5.470768e-002, 5.474151e-002, 5.477533e-002, 5.480915e-002, 5.484296e-002, 5.487676e-002, 5.491055e-002, 5.494433e-002, 5.497811e-002, 5.501188e-002, 5.504564e-002, 5.507939e-002, 5.511314e-002, 5.514687e-002, 5.518060e-002, 5.521432e-002, 5.524804e-002, 5.528174e-002, 5.531544e-002, 5.534913e-002, 5.538281e-002, 5.541648e-002, 5.545015e-002, 5.548380e-002, 5.551745e-002, 5.555110e-002, 5.558473e-002, 5.561836e-002, 5.565197e-002, 5.568558e-002, 5.571919e-002, 5.575278e-002, 5.578637e-002, 5.581995e-002, 5.585352e-002, 5.588708e-002, 5.592064e-002, 5.595419e-002, 5.598773e-002, 5.602126e-002, 5.605478e-002, 5.608830e-002, 5.612181e-002, 5.615531e-002, 5.618881e-002, 5.622229e-002, 5.625577e-002, 5.628924e-002, 5.632270e-002, 5.635616e-002, 5.638961e-002, 5.642305e-002, 
5.645648e-002, 5.648990e-002, 5.652332e-002, 5.655673e-002, 5.659013e-002, 5.662352e-002, 5.665691e-002, 5.669029e-002, 5.672366e-002, 5.675702e-002, 5.679037e-002, 5.682372e-002, 5.685706e-002, 5.689039e-002, 5.692372e-002, 5.695704e-002, 5.699035e-002, 5.702365e-002, 5.705694e-002, 5.709023e-002, 5.712351e-002, 5.715678e-002, 5.719004e-002, 5.722330e-002, 5.725655e-002, 5.728979e-002, 5.732302e-002, 5.735625e-002, 5.738947e-002, 5.742268e-002, 5.745588e-002, 5.748908e-002, 5.752227e-002, 5.755545e-002, 5.758862e-002, 5.762179e-002, 5.765495e-002, 5.768810e-002, 5.772124e-002, 5.775438e-002, 5.778751e-002, 5.782063e-002, 5.785374e-002, 5.788685e-002, 5.791995e-002, 5.795304e-002, 5.798612e-002, 5.801920e-002, 5.805227e-002, 5.808533e-002, 5.811839e-002, 5.815143e-002, 5.818447e-002, 5.821750e-002, 5.825053e-002, 5.828355e-002, 5.831656e-002, 5.834956e-002, 5.838255e-002, 5.841554e-002, 5.844852e-002, 5.848150e-002, 5.851446e-002, 5.854742e-002, 5.858037e-002, 5.861332e-002, 5.864625e-002, 5.867918e-002, 5.871210e-002, 5.874502e-002, 5.877792e-002, 5.881082e-002, 5.884372e-002, 5.887660e-002, 5.890948e-002, 5.894235e-002, 5.897521e-002, 5.900807e-002, 5.904092e-002, 5.907376e-002, 5.910660e-002, 5.913942e-002, 5.917224e-002, 5.920506e-002, 5.923786e-002, 5.927066e-002, 5.930345e-002, 5.933624e-002, 5.936901e-002, 5.940178e-002, 5.943454e-002, 5.946730e-002, 5.950005e-002, 5.953279e-002, 5.956552e-002, 5.959825e-002, 5.963097e-002, 5.966368e-002, 5.969638e-002, 5.972908e-002, 
5.976177e-002, 5.979445e-002, 5.982713e-002, 5.985980e-002, 5.989246e-002, 5.992512e-002, 5.995776e-002, 5.999041e-002, 6.002304e-002, 6.005567e-002, 6.008828e-002, 6.012090e-002, 6.015350e-002, 6.018610e-002, 6.021869e-002, 6.025128e-002, 6.028385e-002, 6.031642e-002, 6.034898e-002, 6.038154e-002, 6.041409e-002, 6.044663e-002, 6.047917e-002, 6.051169e-002, 6.054421e-002, 6.057673e-002, 6.060923e-002, 6.064173e-002, 6.067423e-002, 6.070671e-002, 6.073919e-002, 6.077166e-002, 6.080413e-002, 6.083658e-002, 6.086903e-002, 6.090148e-002, 6.093391e-002, 6.096634e-002, 6.099877e-002, 6.103118e-002, 6.106359e-002, 6.109599e-002, 6.112839e-002, 6.116077e-002, 6.119316e-002, 6.122553e-002, 6.125790e-002, 6.129026e-002, 6.132261e-002, 6.135496e-002, 6.138730e-002, 6.141963e-002, 6.145195e-002, 6.148427e-002, 6.151659e-002, 6.154889e-002, 6.158119e-002, 6.161348e-002, 6.164576e-002, 6.167804e-002, 6.171031e-002, 6.174258e-002, 6.177483e-002, 6.180708e-002, 6.183933e-002, 6.187156e-002, 6.190379e-002, 6.193602e-002, 6.196823e-002, 6.200044e-002, 6.203264e-002, 6.206484e-002, 6.209703e-002, 6.212921e-002, 6.216139e-002, 6.219355e-002, 6.222572e-002, 6.225787e-002, 6.229002e-002, 6.232216e-002, 6.235430e-002, 6.238642e-002, 6.241854e-002, 6.245066e-002, 6.248277e-002, 6.251487e-002, 6.254696e-002, 6.257905e-002, 6.261113e-002, 6.264320e-002, 6.267527e-002, 6.270733e-002, 6.273939e-002, 6.277143e-002, 6.280347e-002, 6.283551e-002, 6.286753e-002, 6.289955e-002, 6.293157e-002, 6.296358e-002, 
6.299558e-002, 6.302757e-002, 6.305956e-002, 6.309154e-002, 6.312351e-002, 6.315548e-002, 6.318744e-002, 6.321939e-002, 6.325134e-002, 6.328328e-002, 6.331521e-002, 6.334714e-002, 6.337906e-002, 6.341098e-002, 6.344288e-002, 6.347478e-002, 6.350668e-002, 6.353857e-002, 6.357045e-002, 6.360232e-002, 6.363419e-002, 6.366605e-002, 6.369791e-002, 6.372975e-002, 6.376160e-002, 6.379343e-002, 6.382526e-002, 6.385708e-002, 6.388890e-002, 6.392071e-002, 6.395251e-002, 6.398430e-002, 6.401609e-002, 6.404788e-002, 6.407965e-002, 6.411142e-002, 6.414318e-002, 6.417494e-002, 6.420669e-002, 6.423843e-002, 6.427017e-002, 6.430190e-002, 6.433363e-002, 6.436534e-002, 6.439706e-002, 6.442876e-002, 6.446046e-002, 6.449215e-002, 6.452384e-002, 6.455551e-002, 6.458719e-002, 6.461885e-002, 6.465051e-002, 6.468216e-002, 6.471381e-002, 6.474545e-002, 6.477709e-002, 6.480871e-002, 6.484033e-002, 6.487195e-002, 6.490356e-002, 6.493516e-002, 6.496675e-002, 6.499834e-002, 6.502992e-002, 6.506150e-002, 6.509307e-002, 6.512463e-002, 6.515619e-002, 6.518774e-002, 6.521928e-002, 6.525082e-002, 6.528235e-002, 6.531388e-002, 6.534540e-002, 6.537691e-002, 6.540842e-002, 6.543992e-002, 6.547141e-002, 6.550290e-002, 6.553438e-002, 6.556585e-002, 6.559732e-002, 6.562878e-002, 6.566024e-002, 6.569168e-002, 6.572313e-002, 6.575456e-002, 6.578599e-002, 6.581742e-002, 6.584884e-002, 6.588025e-002, 6.591165e-002, 6.594305e-002, 6.597444e-002, 6.600583e-002, 6.603721e-002, 6.606858e-002, 6.609995e-002, 6.613131e-002, 
6.616266e-002, 6.619401e-002, 6.622536e-002, 6.625669e-002, 6.628802e-002, 6.631935e-002, 6.635066e-002, 6.638197e-002, 6.641328e-002, 6.644458e-002, 6.647587e-002, 6.650716e-002, 6.653844e-002, 6.656971e-002, 6.660098e-002, 6.663224e-002, 6.666349e-002, 6.669474e-002, 6.672599e-002, 6.675722e-002, 6.678845e-002, 6.681968e-002, 6.685090e-002, 6.688211e-002, 6.691331e-002, 6.694451e-002, 6.697571e-002, 6.700689e-002, 6.703808e-002, 6.706925e-002, 6.710042e-002, 6.713158e-002, 6.716274e-002, 6.719389e-002, 6.722503e-002, 6.725617e-002, 6.728730e-002, 6.731843e-002, 6.734955e-002, 6.738066e-002, 6.741177e-002, 6.744287e-002, 6.747397e-002, 6.750506e-002, 6.753614e-002, 6.756722e-002, 6.759829e-002, 6.762936e-002, 6.766042e-002, 6.769147e-002, 6.772252e-002, 6.775356e-002, 6.778459e-002, 6.781562e-002, 6.784664e-002, 6.787766e-002, 6.790867e-002, 6.793968e-002, 6.797067e-002, 6.800167e-002, 6.803265e-002, 6.806363e-002, 6.809461e-002, 6.812558e-002, 6.815654e-002, 6.818750e-002, 6.821845e-002, 6.824939e-002, 6.828033e-002, 6.831126e-002, 6.834219e-002, 6.837311e-002, 6.840402e-002, 6.843493e-002, 6.846583e-002, 6.849673e-002, 6.852762e-002, 6.855851e-002, 6.858938e-002, 6.862026e-002, 6.865112e-002, 6.868198e-002, 6.871284e-002, 6.874369e-002, 6.877453e-002, 6.880537e-002, 6.883620e-002, 6.886702e-002, 6.889784e-002, 6.892866e-002, 6.895946e-002, 6.899027e-002, 6.902106e-002, 6.905185e-002, 6.908263e-002, 6.911341e-002, 6.914418e-002, 6.917495e-002, 6.920571e-002, 6.923646e-002, 
6.926721e-002, 6.929796e-002, 6.932869e-002, 6.935942e-002, 6.939015e-002, 6.942087e-002, 6.945158e-002, 6.948229e-002, 6.951299e-002, 6.954368e-002, 6.957437e-002, 6.960506e-002, 6.963574e-002, 6.966641e-002, 6.969707e-002, 6.972773e-002, 6.975839e-002, 6.978904e-002, 6.981968e-002, 6.985032e-002, 6.988095e-002, 6.991157e-002, 6.994219e-002, 6.997281e-002, 7.000342e-002, 7.003402e-002, 7.006462e-002, 7.009521e-002, 7.012579e-002, 7.015637e-002, 7.018694e-002, 7.021751e-002, 7.024807e-002, 7.027863e-002, 7.030918e-002, 7.033972e-002, 7.037026e-002, 7.040080e-002, 7.043132e-002, 7.046184e-002, 7.049236e-002, 7.052287e-002, 7.055337e-002, 7.058387e-002, 7.061437e-002, 7.064485e-002, 7.067533e-002, 7.070581e-002, 7.073628e-002, 7.076674e-002, 7.079720e-002, 7.082765e-002, 7.085810e-002, 7.088854e-002, 7.091898e-002, 7.094941e-002, 7.097983e-002, 7.101025e-002, 7.104066e-002, 7.107107e-002, 7.110147e-002, 7.113187e-002, 7.116226e-002, 7.119264e-002, 7.122302e-002, 7.125339e-002, 7.128376e-002, 7.131412e-002, 7.134448e-002, 7.137483e-002, 7.140517e-002, 7.143551e-002, 7.146585e-002, 7.149617e-002, 7.152650e-002, 7.155681e-002, 7.158712e-002, 7.161743e-002, 7.164773e-002, 7.167802e-002, 7.170831e-002, 7.173859e-002, 7.176887e-002, 7.179914e-002, 7.182941e-002, 7.185967e-002, 7.188992e-002, 7.192017e-002, 7.195042e-002, 7.198065e-002, 7.201089e-002, 7.204111e-002, 7.207133e-002, 7.210155e-002, 7.213176e-002, 7.216196e-002, 7.219216e-002, 7.222236e-002, 7.225254e-002, 7.228273e-002, 
7.231290e-002, 7.234307e-002, 7.237324e-002, 7.240340e-002, 7.243355e-002, 7.246370e-002, 7.249385e-002, 7.252398e-002, 7.255412e-002, 7.258424e-002, 7.261436e-002, 7.264448e-002, 7.267459e-002, 7.270469e-002, 7.273479e-002, 7.276489e-002, 7.279498e-002, 7.282506e-002, 7.285514e-002, 7.288521e-002, 7.291527e-002, 7.294533e-002, 7.297539e-002, 7.300544e-002, 7.303548e-002, 7.306552e-002, 7.309555e-002, 7.312558e-002, 7.315560e-002, 7.318562e-002, 7.321563e-002, 7.324564e-002, 7.327564e-002, 7.330563e-002, 7.333562e-002, 7.336561e-002, 7.339559e-002, 7.342556e-002, 7.345553e-002, 7.348549e-002, 7.351544e-002, 7.354540e-002, 7.357534e-002, 7.360528e-002, 7.363522e-002, 7.366515e-002, 7.369507e-002, 7.372499e-002, 7.375490e-002, 7.378481e-002, 7.381471e-002, 7.384461e-002, 7.387450e-002, 7.390439e-002, 7.393427e-002, 7.396415e-002, 7.399402e-002, 7.402388e-002, 7.405374e-002, 7.408359e-002, 7.411344e-002, 7.414329e-002, 7.417312e-002, 7.420296e-002, 7.423278e-002, 7.426261e-002, 7.429242e-002, 7.432223e-002, 7.435204e-002, 7.438184e-002, 7.441163e-002, 7.444142e-002, 7.447121e-002, 7.450099e-002, 7.453076e-002, 7.456053e-002, 7.459029e-002, 7.462005e-002, 7.464980e-002, 7.467955e-002, 7.470929e-002, 7.473903e-002, 7.476876e-002, 7.479848e-002, 7.482820e-002, 7.485792e-002, 7.488763e-002, 7.491733e-002, 7.494703e-002, 7.497673e-002, 7.500641e-002, 7.503610e-002, 7.506578e-002, 7.509545e-002, 7.512512e-002, 7.515478e-002, 7.518443e-002, 7.521409e-002, 7.524373e-002, 7.527337e-002, 
7.530301e-002, 7.533264e-002, 7.536227e-002, 7.539189e-002, 7.542150e-002, 7.545111e-002, 7.548071e-002, 7.551031e-002, 7.553991e-002, 7.556950e-002, 7.559908e-002, 7.562866e-002, 7.565823e-002, 7.568780e-002, 7.571736e-002, 7.574692e-002, 7.577647e-002, 7.580602e-002, 7.583556e-002, 7.586509e-002, 7.589462e-002, 7.592415e-002, 7.595367e-002, 7.598319e-002, 7.601270e-002, 7.604220e-002, 7.607170e-002, 7.610120e-002, 7.613069e-002, 7.616017e-002, 7.618965e-002, 7.621912e-002, 7.624859e-002, 7.627805e-002, 7.630751e-002, 7.633697e-002, 7.636641e-002, 7.639586e-002, 7.642529e-002, 7.645473e-002, 7.648415e-002, 7.651358e-002, 7.654299e-002, 7.657241e-002, 7.660181e-002, 7.663121e-002, 7.666061e-002, 7.669000e-002, 7.671939e-002, 7.674877e-002, 7.677815e-002, 7.680752e-002, 7.683688e-002, 7.686624e-002, 7.689560e-002, 7.692495e-002, 7.695429e-002, 7.698363e-002, 7.701297e-002, 7.704230e-002, 7.707162e-002, 7.710094e-002, 7.713026e-002, 7.715957e-002, 7.718887e-002, 7.721817e-002, 7.724747e-002, 7.727675e-002, 7.730604e-002, 7.733532e-002, 7.736459e-002, 7.739386e-002, 7.742312e-002, 7.745238e-002, 7.748164e-002, 7.751089e-002, 7.754013e-002, 7.756937e-002, 7.759860e-002, 7.762783e-002, 7.765705e-002, 7.768627e-002, 7.771548e-002, 7.774469e-002, 7.777389e-002, 7.780309e-002, 7.783229e-002, 7.786147e-002, 7.789066e-002, 7.791983e-002, 7.794901e-002, 7.797818e-002, 7.800734e-002, 7.803650e-002, 7.806565e-002, 7.809480e-002, 7.812394e-002, 7.815308e-002, 7.818221e-002, 7.821134e-002, 
7.824046e-002, 7.826958e-002, 7.829869e-002, 7.832780e-002, 7.835690e-002, 7.838600e-002, 7.841509e-002, 7.844418e-002, 7.847326e-002, 7.850234e-002, 7.853141e-002, 7.856048e-002, 7.858954e-002, 7.861860e-002, 7.864765e-002, 7.867670e-002, 7.870575e-002, 7.873478e-002, 7.876382e-002, 7.879284e-002, 7.882187e-002, 7.885089e-002, 7.887990e-002, 7.890891e-002, 7.893791e-002, 7.896691e-002, 7.899590e-002, 7.902489e-002, 7.905388e-002, 7.908285e-002, 7.911183e-002, 7.914080e-002, 7.916976e-002, 7.919872e-002, 7.922767e-002, 7.925662e-002, 7.928557e-002, 7.931451e-002, 7.934344e-002, 7.937237e-002, 7.940130e-002, 7.943022e-002, 7.945913e-002, 7.948804e-002, 7.951695e-002, 7.954585e-002, 7.957474e-002, 7.960363e-002, 7.963252e-002, 7.966140e-002, 7.969027e-002, 7.971914e-002, 7.974801e-002, 7.977687e-002, 7.980573e-002, 7.983458e-002, 7.986343e-002, 7.989227e-002, 7.992110e-002, 7.994994e-002, 7.997876e-002, 8.000758e-002, 8.003640e-002, 8.006521e-002, 8.009402e-002, 8.012283e-002, 8.015162e-002, 8.018042e-002, 8.020920e-002, 8.023799e-002, 8.026677e-002, 8.029554e-002, 8.032431e-002, 8.035307e-002, 8.038183e-002, 8.041059e-002, 8.043934e-002, 8.046808e-002, 8.049682e-002, 8.052556e-002, 8.055429e-002, 8.058301e-002, 8.061173e-002, 8.064045e-002, 8.066916e-002, 8.069787e-002, 8.072657e-002, 8.075527e-002, 8.078396e-002, 8.081265e-002, 8.084133e-002, 8.087001e-002, 8.089868e-002, 8.092735e-002, 8.095601e-002, 8.098467e-002, 8.101332e-002, 8.104197e-002, 8.107062e-002, 8.109925e-002, 
8.112789e-002, 8.115652e-002, 8.118514e-002, 8.121377e-002, 8.124238e-002, 8.127099e-002, 8.129960e-002, 8.132820e-002, 8.135680e-002, 8.138539e-002, 8.141398e-002, 8.144256e-002, 8.147114e-002, 8.149971e-002, 8.152828e-002, 8.155684e-002, 8.158540e-002, 8.161395e-002, 8.164250e-002, 8.167105e-002, 8.169959e-002, 8.172812e-002, 8.175665e-002, 8.178518e-002, 8.181370e-002, 8.184222e-002, 8.187073e-002, 8.189923e-002, 8.192774e-002, 8.195623e-002, 8.198473e-002, 8.201321e-002, 8.204170e-002, 8.207018e-002, 8.209865e-002, 8.212712e-002, 8.215559e-002, 8.218405e-002, 8.221250e-002, 8.224095e-002, 8.226940e-002, 8.229784e-002, 8.232628e-002, 8.235471e-002, 8.238313e-002, 8.241156e-002, 8.243998e-002, 8.246839e-002, 8.249680e-002, 8.252520e-002, 8.255360e-002, 8.258200e-002, 8.261039e-002, 8.263877e-002, 8.266715e-002, 8.269553e-002, 8.272390e-002, 8.275227e-002, 8.278063e-002, 8.280899e-002, 8.283734e-002, 8.286569e-002, 8.289403e-002, 8.292237e-002, 8.295070e-002, 8.297903e-002, 8.300736e-002, 8.303568e-002, 8.306400e-002, 8.309231e-002, 8.312061e-002, 8.314892e-002, 8.317721e-002, 8.320551e-002, 8.323379e-002, 8.326208e-002, 8.329036e-002, 8.331863e-002, 8.334690e-002, 8.337517e-002, 8.340343e-002, 8.343168e-002, 8.345994e-002, 8.348818e-002, 8.351642e-002, 8.354466e-002, 8.357290e-002, 8.360112e-002, 8.362935e-002, 8.365757e-002, 8.368578e-002, 8.371399e-002, 8.374220e-002, 8.377040e-002, 8.379860e-002, 8.382679e-002, 8.385498e-002, 8.388316e-002, 8.391134e-002, 8.393951e-002, 
8.396768e-002, 8.399585e-002, 8.402401e-002, 8.405216e-002, 8.408031e-002, 8.410846e-002, 8.413660e-002, 8.416474e-002, 8.419287e-002, 8.422100e-002, 8.424913e-002, 8.427725e-002, 8.430536e-002, 8.433347e-002, 8.436158e-002, 8.438968e-002, 8.441778e-002, 8.444587e-002, 8.447396e-002, 8.450204e-002, 8.453012e-002, 8.455819e-002, 8.458626e-002, 8.461433e-002, 8.464239e-002, 8.467045e-002, 8.469850e-002, 8.472654e-002, 8.475459e-002, 8.478263e-002, 8.481066e-002, 8.483869e-002, 8.486671e-002, 8.489473e-002, 8.492275e-002, 8.495076e-002, 8.497877e-002, 8.500677e-002, 8.503477e-002, 8.506276e-002, 8.509075e-002, 8.511874e-002, 8.514672e-002, 8.517469e-002, 8.520266e-002, 8.523063e-002, 8.525859e-002, 8.528655e-002, 8.531451e-002, 8.534245e-002, 8.537040e-002, 8.539834e-002, 8.542628e-002, 8.545421e-002, 8.548213e-002, 8.551006e-002, 8.553797e-002, 8.556589e-002, 8.559380e-002, 8.562170e-002, 8.564960e-002, 8.567750e-002, 8.570539e-002, 8.573328e-002, 8.576116e-002, 8.578904e-002, 8.581691e-002, 8.584478e-002, 8.587264e-002, 8.590050e-002, 8.592836e-002, 8.595621e-002, 8.598406e-002, 8.601190e-002, 8.603974e-002, 8.606758e-002, 8.609541e-002, 8.612323e-002, 8.615105e-002, 8.617887e-002, 8.620668e-002, 8.623449e-002, 8.626229e-002, 8.629009e-002, 8.631788e-002, 8.634568e-002, 8.637346e-002, 8.640124e-002, 8.642902e-002, 8.645679e-002, 8.648456e-002, 8.651232e-002, 8.654008e-002, 8.656784e-002, 8.659559e-002, 8.662334e-002, 8.665108e-002, 8.667882e-002, 8.670655e-002, 8.673428e-002, 
8.676200e-002, 8.678972e-002, 8.681744e-002, 8.684515e-002, 8.687286e-002, 8.690056e-002, 8.692826e-002, 8.695596e-002, 8.698365e-002, 8.701133e-002, 8.703901e-002, 8.706669e-002, 8.709436e-002, 8.712203e-002, 8.714970e-002, 8.717736e-002, 8.720501e-002, 8.723266e-002, 8.726031e-002, 8.728795e-002, 8.731559e-002, 8.734322e-002, 8.737085e-002, 8.739848e-002, 8.742610e-002, 8.745372e-002, 8.748133e-002, 8.750894e-002, 8.753654e-002, 8.756414e-002, 8.759173e-002, 8.761933e-002, 8.764691e-002, 8.767449e-002, 8.770207e-002, 8.772965e-002, 8.775722e-002, 8.778478e-002, 8.781234e-002, 8.783990e-002, 8.786745e-002, 8.789500e-002, 8.792254e-002, 8.795008e-002, 8.797762e-002, 8.800515e-002, 8.803267e-002, 8.806020e-002, 8.808772e-002, 8.811523e-002, 8.814274e-002, 8.817024e-002, 8.819775e-002, 8.822524e-002, 8.825274e-002, 8.828022e-002, 8.830771e-002, 8.833519e-002, 8.836266e-002, 8.839013e-002, 8.841760e-002, 8.844507e-002, 8.847252e-002, 8.849998e-002, 8.852743e-002, 8.855487e-002, 8.858232e-002, 8.860975e-002, 8.863719e-002, 8.866462e-002, 8.869204e-002, 8.871946e-002, 8.874688e-002, 8.877429e-002, 8.880170e-002, 8.882910e-002, 8.885650e-002, 8.888390e-002, 8.891129e-002, 8.893868e-002, 8.896606e-002, 8.899344e-002, 8.902081e-002, 8.904818e-002, 8.907555e-002, 8.910291e-002, 8.913027e-002, 8.915762e-002, 8.918497e-002, 8.921232e-002, 8.923966e-002, 8.926699e-002, 8.929433e-002, 8.932165e-002, 8.934898e-002, 8.937630e-002, 8.940361e-002, 8.943092e-002, 8.945823e-002, 8.948554e-002, 
8.951283e-002, 8.954013e-002, 8.956742e-002, 8.959471e-002, 8.962199e-002, 8.964927e-002, 8.967654e-002, 8.970381e-002, 8.973108e-002, 8.975834e-002, 8.978560e-002, 8.981285e-002, 8.984010e-002, 8.986734e-002, 8.989459e-002, 8.992182e-002, 8.994905e-002, 8.997628e-002, 9.000351e-002, 9.003073e-002, 9.005794e-002, 9.008516e-002, 9.011236e-002, 9.013957e-002, 9.016677e-002, 9.019396e-002, 9.022115e-002, 9.024834e-002, 9.027552e-002, 9.030270e-002, 9.032988e-002, 9.035705e-002, 9.038422e-002, 9.041138e-002, 9.043854e-002, 9.046569e-002, 9.049284e-002, 9.051999e-002, 9.054713e-002, 9.057427e-002, 9.060140e-002, 9.062853e-002, 9.065566e-002, 9.068278e-002, 9.070989e-002, 9.073701e-002, 9.076412e-002, 9.079122e-002, 9.081832e-002, 9.084542e-002, 9.087251e-002, 9.089960e-002, 9.092669e-002, 9.095377e-002, 9.098084e-002, 9.100792e-002, 9.103498e-002, 9.106205e-002, 9.108911e-002, 9.111617e-002, 9.114322e-002, 9.117027e-002, 9.119731e-002, 9.122435e-002, 9.125139e-002, 9.127842e-002, 9.130544e-002, 9.133247e-002, 9.135949e-002, 9.138650e-002, 9.141352e-002, 9.144052e-002, 9.146753e-002, 9.149453e-002, 9.152152e-002, 9.154851e-002, 9.157550e-002, 9.160248e-002, 9.162946e-002, 9.165644e-002, 9.168341e-002, 9.171038e-002, 9.173734e-002, 9.176430e-002, 9.179125e-002, 9.181820e-002, 9.184515e-002, 9.187209e-002, 9.189903e-002, 9.192597e-002, 9.195290e-002, 9.197983e-002, 9.200675e-002, 9.203367e-002, 9.206058e-002, 9.208749e-002, 9.211440e-002, 9.214130e-002, 9.216820e-002, 9.219510e-002, 
9.222199e-002, 9.224887e-002, 9.227576e-002, 9.230263e-002, 9.232951e-002, 9.235638e-002, 9.238325e-002, 9.241011e-002, 9.243697e-002, 9.246382e-002, 9.249067e-002, 9.251752e-002, 9.254436e-002, 9.257120e-002, 9.259804e-002, 9.262487e-002, 9.265170e-002, 9.267852e-002, 9.270534e-002, 9.273215e-002, 9.275896e-002, 9.278577e-002, 9.281257e-002, 9.283937e-002, 9.286617e-002, 9.289296e-002, 9.291975e-002, 9.294653e-002, 9.297331e-002, 9.300009e-002, 9.302686e-002, 9.305362e-002, 9.308039e-002, 9.310715e-002, 9.313390e-002, 9.316066e-002, 9.318740e-002, 9.321415e-002, 9.324089e-002, 9.326762e-002, 9.329436e-002, 9.332108e-002, 9.334781e-002, 9.337453e-002, 9.340124e-002, 9.342796e-002, 9.345466e-002, 9.348137e-002, 9.350807e-002, 9.353477e-002, 9.356146e-002, 9.358815e-002, 9.361483e-002, 9.364151e-002, 9.366819e-002, 9.369486e-002, 9.372153e-002, 9.374820e-002, 9.377486e-002, 9.380152e-002, 9.382817e-002, 9.385482e-002, 9.388147e-002, 9.390811e-002, 9.393475e-002, 9.396138e-002, 9.398801e-002, 9.401464e-002, 9.404126e-002, 9.406788e-002, 9.409449e-002, 9.412110e-002, 9.414771e-002, 9.417431e-002, 9.420091e-002, 9.422751e-002, 9.425410e-002, 9.428069e-002, 9.430727e-002, 9.433385e-002, 9.436042e-002, 9.438700e-002, 9.441356e-002, 9.444013e-002, 9.446669e-002, 9.449324e-002, 9.451980e-002, 9.454635e-002, 9.457289e-002, 9.459943e-002, 9.462597e-002, 9.465250e-002, 9.467903e-002, 9.470556e-002, 9.473208e-002, 9.475860e-002, 9.478511e-002, 9.481162e-002, 9.483813e-002, 9.486463e-002, 
9.489113e-002, 9.491762e-002, 9.494411e-002, 9.497060e-002, 9.499708e-002, 9.502356e-002, 9.505004e-002, 9.507651e-002, 9.510298e-002, 9.512944e-002, 9.515590e-002, 9.518236e-002, 9.520881e-002, 9.523526e-002, 9.526170e-002, 9.528814e-002, 9.531458e-002, 9.534101e-002, 9.536744e-002, 9.539387e-002, 9.542029e-002, 9.544671e-002, 9.547312e-002, 9.549953e-002, 9.552594e-002, 9.555234e-002, 9.557874e-002, 9.560514e-002, 9.563153e-002, 9.565792e-002, 9.568430e-002, 9.571068e-002, 9.573706e-002, 9.576343e-002, 9.578980e-002, 9.581616e-002, 9.584252e-002, 9.586888e-002, 9.589523e-002, 9.592158e-002, 9.594793e-002, 9.597427e-002, 9.600061e-002, 9.602694e-002, 9.605327e-002, 9.607960e-002, 9.610592e-002, 9.613224e-002, 9.615856e-002, 9.618487e-002, 9.621118e-002, 9.623748e-002, 9.626378e-002, 9.629008e-002, 9.631637e-002, 9.634266e-002, 9.636895e-002, 9.639523e-002, 9.642151e-002, 9.644778e-002, 9.647405e-002, 9.650032e-002, 9.652658e-002, 9.655284e-002, 9.657910e-002, 9.660535e-002, 9.663160e-002, 9.665784e-002, 9.668408e-002, 9.671032e-002, 9.673655e-002, 9.676278e-002, 9.678900e-002, 9.681522e-002, 9.684144e-002, 9.686766e-002, 9.689387e-002, 9.692007e-002, 9.694628e-002, 9.697248e-002, 9.699867e-002, 9.702486e-002, 9.705105e-002, 9.707723e-002, 9.710342e-002, 9.712959e-002, 9.715576e-002, 9.718193e-002, 9.720810e-002, 9.723426e-002, 9.726042e-002, 9.728657e-002, 9.731273e-002, 9.733887e-002, 9.736502e-002, 9.739115e-002, 9.741729e-002, 9.744342e-002, 9.746955e-002, 9.749568e-002, 
9.752180e-002, 9.754791e-002, 9.757403e-002, 9.760014e-002, 9.762624e-002, 9.765235e-002, 9.767845e-002, 9.770454e-002, 9.773063e-002, 9.775672e-002, 9.778280e-002, 9.780888e-002, 9.783496e-002, 9.786103e-002, 9.788710e-002, 9.791317e-002, 9.793923e-002, 9.796529e-002, 9.799134e-002, 9.801739e-002, 9.804344e-002, 9.806949e-002, 9.809553e-002, 9.812156e-002, 9.814759e-002, 9.817362e-002, 9.819965e-002, 9.822567e-002, 9.825169e-002, 9.827770e-002, 9.830371e-002, 9.832972e-002, 9.835572e-002, 9.838172e-002, 9.840772e-002, 9.843371e-002, 9.845970e-002, 9.848568e-002, 9.851166e-002, 9.853764e-002, 9.856362e-002, 9.858959e-002, 9.861555e-002, 9.864152e-002, 9.866748e-002, 9.869343e-002, 9.871938e-002, 9.874533e-002, 9.877128e-002, 9.879722e-002, 9.882316e-002, 9.884909e-002, 9.887502e-002, 9.890095e-002, 9.892687e-002, 9.895279e-002, 9.897870e-002, 9.900462e-002, 9.903052e-002, 9.905643e-002, 9.908233e-002, 9.910823e-002, 9.913412e-002, 9.916001e-002, 9.918590e-002, 9.921178e-002, 9.923766e-002, 9.926354e-002, 9.928941e-002, 9.931528e-002, 9.934114e-002, 9.936700e-002, 9.939286e-002, 9.941872e-002, 9.944457e-002, 9.947041e-002, 9.949626e-002, 9.952210e-002, 9.954793e-002, 9.957377e-002, 9.959960e-002, 9.962542e-002, 9.965124e-002, 9.967706e-002, 9.970288e-002, 9.972869e-002, 9.975449e-002, 9.978030e-002, 9.980610e-002, 9.983189e-002, 9.985769e-002, 9.988348e-002, 9.990926e-002, 9.993505e-002, 9.996082e-002, 9.998660e-002, 1.000124e-001, 1.000381e-001, 1.000639e-001, 1.000897e-001, 
1.001154e-001, 1.001412e-001, 1.001669e-001, 1.001927e-001, 1.002184e-001, 1.002442e-001, 1.002699e-001, 1.002956e-001, 1.003214e-001, 1.003471e-001, 1.003728e-001, 1.003985e-001, 1.004242e-001, 1.004499e-001, 1.004756e-001, 1.005014e-001, 1.005271e-001, 1.005528e-001, 1.005784e-001, 1.006041e-001, 1.006298e-001, 1.006555e-001, 1.006812e-001, 1.007069e-001, 1.007325e-001, 1.007582e-001, 1.007839e-001, 1.008095e-001, 1.008352e-001, 1.008608e-001, 1.008865e-001, 1.009121e-001, 1.009378e-001, 1.009634e-001, 1.009891e-001, 1.010147e-001, 1.010403e-001, 1.010659e-001, 1.010916e-001, 1.011172e-001, 1.011428e-001, 1.011684e-001, 1.011940e-001, 1.012196e-001, 1.012452e-001, 1.012708e-001, 1.012964e-001, 1.013220e-001, 1.013476e-001, 1.013732e-001, 1.013988e-001, 1.014243e-001, 1.014499e-001, 1.014755e-001, 1.015010e-001, 1.015266e-001, 1.015522e-001, 1.015777e-001, 1.016033e-001, 1.016288e-001, 1.016544e-001, 1.016799e-001, 1.017054e-001, 1.017310e-001, 1.017565e-001, 1.017820e-001, 1.018076e-001, 1.018331e-001, 1.018586e-001, 1.018841e-001, 1.019096e-001, 1.019351e-001, 1.019606e-001, 1.019861e-001, 1.020116e-001, 1.020371e-001, 1.020626e-001, 1.020881e-001, 1.021136e-001, 1.021391e-001, 1.021645e-001, 1.021900e-001, 1.022155e-001, 1.022409e-001, 1.022664e-001, 1.022919e-001, 1.023173e-001, 1.023428e-001, 1.023682e-001, 1.023937e-001, 1.024191e-001, 1.024445e-001, 1.024700e-001, 1.024954e-001, 1.025208e-001, 1.025463e-001, 1.025717e-001, 1.025971e-001, 1.026225e-001, 1.026479e-001, 
1.026733e-001, 1.026987e-001, 1.027241e-001, 1.027495e-001, 1.027749e-001, 1.028003e-001, 1.028257e-001, 1.028511e-001, 1.028765e-001, 1.029018e-001, 1.029272e-001, 1.029526e-001, 1.029779e-001, 1.030033e-001, 1.030287e-001, 1.030540e-001, 1.030794e-001, 1.031047e-001, 1.031300e-001, 1.031554e-001, 1.031807e-001, 1.032061e-001, 1.032314e-001, 1.032567e-001, 1.032820e-001, 1.033074e-001, 1.033327e-001, 1.033580e-001, 1.033833e-001, 1.034086e-001, 1.034339e-001, 1.034592e-001, 1.034845e-001, 1.035098e-001, 1.035351e-001, 1.035604e-001, 1.035857e-001, 1.036109e-001, 1.036362e-001, 1.036615e-001, 1.036868e-001, 1.037120e-001, 1.037373e-001, 1.037625e-001, 1.037878e-001, 1.038131e-001, 1.038383e-001, 1.038636e-001, 1.038888e-001, 1.039140e-001, 1.039393e-001, 1.039645e-001, 1.039897e-001, 1.040150e-001, 1.040402e-001, 1.040654e-001, 1.040906e-001, 1.041158e-001, 1.041410e-001, 1.041662e-001, 1.041914e-001, 1.042166e-001, 1.042418e-001, 1.042670e-001, 1.042922e-001, 1.043174e-001, 1.043426e-001, 1.043678e-001, 1.043929e-001, 1.044181e-001, 1.044433e-001, 1.044684e-001, 1.044936e-001, 1.045187e-001, 1.045439e-001, 1.045691e-001, 1.045942e-001, 1.046193e-001, 1.046445e-001, 1.046696e-001, 1.046948e-001, 1.047199e-001, 1.047450e-001, 1.047701e-001, 1.047953e-001, 1.048204e-001, 1.048455e-001, 1.048706e-001, 1.048957e-001, 1.049208e-001, 1.049459e-001, 1.049710e-001, 1.049961e-001, 1.050212e-001, 1.050463e-001, 1.050714e-001, 1.050964e-001, 1.051215e-001, 1.051466e-001, 1.051717e-001, 
1.051967e-001, 1.052218e-001, 1.052469e-001, 1.052719e-001, 1.052970e-001, 1.053220e-001, 1.053471e-001, 1.053721e-001, 1.053972e-001, 1.054222e-001, 1.054472e-001, 1.054723e-001, 1.054973e-001, 1.055223e-001, 1.055473e-001, 1.055723e-001, 1.055974e-001, 1.056224e-001, 1.056474e-001, 1.056724e-001, 1.056974e-001, 1.057224e-001, 1.057474e-001, 1.057724e-001, 1.057974e-001, 1.058223e-001, 1.058473e-001, 1.058723e-001, 1.058973e-001, 1.059222e-001, 1.059472e-001, 1.059722e-001, 1.059971e-001, 1.060221e-001, 1.060470e-001, 1.060720e-001, 1.060969e-001, 1.061219e-001, 1.061468e-001, 1.061718e-001, 1.061967e-001, 1.062216e-001, 1.062466e-001, 1.062715e-001, 1.062964e-001, 1.063213e-001, 1.063462e-001, 1.063712e-001, 1.063961e-001, 1.064210e-001, 1.064459e-001, 1.064708e-001, 1.064957e-001, 1.065206e-001, 1.065454e-001, 1.065703e-001, 1.065952e-001, 1.066201e-001, 1.066450e-001, 1.066698e-001, 1.066947e-001, 1.067196e-001, 1.067444e-001, 1.067693e-001, 1.067942e-001, 1.068190e-001, 1.068439e-001, 1.068687e-001, 1.068935e-001, 1.069184e-001, 1.069432e-001, 1.069681e-001, 1.069929e-001, 1.070177e-001, 1.070425e-001, 1.070674e-001, 1.070922e-001, 1.071170e-001, 1.071418e-001, 1.071666e-001, 1.071914e-001, 1.072162e-001, 1.072410e-001, 1.072658e-001, 1.072906e-001, 1.073154e-001, 1.073402e-001, 1.073649e-001, 1.073897e-001, 1.074145e-001, 1.074393e-001, 1.074640e-001, 1.074888e-001, 1.075136e-001, 1.075383e-001, 1.075631e-001, 1.075878e-001, 1.076126e-001, 1.076373e-001, 1.076621e-001, 
1.076868e-001, 1.077115e-001, 1.077363e-001, 1.077610e-001, 1.077857e-001, 1.078105e-001, 1.078352e-001, 1.078599e-001, 1.078846e-001, 1.079093e-001, 1.079340e-001, 1.079587e-001, 1.079834e-001, 1.080081e-001, 1.080328e-001, 1.080575e-001, 1.080822e-001, 1.081069e-001, 1.081316e-001, 1.081562e-001, 1.081809e-001, 1.082056e-001, 1.082303e-001, 1.082549e-001, 1.082796e-001, 1.083042e-001, 1.083289e-001, 1.083536e-001, 1.083782e-001, 1.084029e-001, 1.084275e-001, 1.084521e-001, 1.084768e-001, 1.085014e-001, 1.085260e-001, 1.085507e-001, 1.085753e-001, 1.085999e-001, 1.086245e-001, 1.086491e-001, 1.086737e-001, 1.086984e-001, 1.087230e-001, 1.087476e-001, 1.087722e-001, 1.087968e-001, 1.088213e-001, 1.088459e-001, 1.088705e-001, 1.088951e-001, 1.089197e-001, 1.089443e-001, 1.089688e-001, 1.089934e-001, 1.090180e-001, 1.090425e-001, 1.090671e-001, 1.090916e-001, 1.091162e-001, 1.091408e-001, 1.091653e-001, 1.091898e-001, 1.092144e-001, 1.092389e-001, 1.092635e-001, 1.092880e-001, 1.093125e-001, 1.093370e-001, 1.093616e-001, 1.093861e-001, 1.094106e-001, 1.094351e-001, 1.094596e-001, 1.094841e-001, 1.095086e-001, 1.095331e-001, 1.095576e-001, 1.095821e-001, 1.096066e-001, 1.096311e-001, 1.096556e-001, 1.096801e-001, 1.097045e-001, 1.097290e-001, 1.097535e-001, 1.097780e-001, 1.098024e-001, 1.098269e-001, 1.098514e-001, 1.098758e-001, 1.099003e-001, 1.099247e-001, 1.099492e-001, 1.099736e-001, 1.099980e-001, 1.100225e-001, 1.100469e-001, 1.100713e-001, 1.100958e-001, 1.101202e-001, 
1.101446e-001, 1.101690e-001, 1.101935e-001, 1.102179e-001, 1.102423e-001, 1.102667e-001, 1.102911e-001, 1.103155e-001, 1.103399e-001, 1.103643e-001, 1.103887e-001, 1.104131e-001, 1.104374e-001, 1.104618e-001, 1.104862e-001, 1.105106e-001, 1.105349e-001, 1.105593e-001, 1.105837e-001, 1.106080e-001, 1.106324e-001, 1.106568e-001, 1.106811e-001, 1.107055e-001, 1.107298e-001, 1.107542e-001, 1.107785e-001, 1.108028e-001, 1.108272e-001, 1.108515e-001, 1.108758e-001, 1.109001e-001, 1.109245e-001, 1.109488e-001, 1.109731e-001, 1.109974e-001, 1.110217e-001, 1.110460e-001, 1.110703e-001, 1.110946e-001, 1.111189e-001, 1.111432e-001, 1.111675e-001, 1.111918e-001, 1.112161e-001, 1.112404e-001, 1.112647e-001, 1.112889e-001, 1.113132e-001, 1.113375e-001, 1.113617e-001, 1.113860e-001, 1.114103e-001, 1.114345e-001, 1.114588e-001, 1.114830e-001, 1.115073e-001, 1.115315e-001, 1.115558e-001, 1.115800e-001, 1.116042e-001, 1.116285e-001, 1.116527e-001, 1.116769e-001, 1.117012e-001, 1.117254e-001, 1.117496e-001, 1.117738e-001, 1.117980e-001, 1.118222e-001, 1.118464e-001, 1.118706e-001, 1.118948e-001, 1.119190e-001, 1.119432e-001, 1.119674e-001, 1.119916e-001, 1.120158e-001, 1.120400e-001, 1.120641e-001, 1.120883e-001, 1.121125e-001, 1.121367e-001, 1.121608e-001, 1.121850e-001, 1.122091e-001, 1.122333e-001, 1.122575e-001, 1.122816e-001, 1.123058e-001, 1.123299e-001, 1.123540e-001, 1.123782e-001, 1.124023e-001, 1.124264e-001, 1.124506e-001, 1.124747e-001, 1.124988e-001, 1.125229e-001, 1.125471e-001, 
1.125712e-001, 1.125953e-001, 1.126194e-001, 1.126435e-001, 1.126676e-001, 1.126917e-001, 1.127158e-001, 1.127399e-001, 1.127640e-001, 1.127881e-001, 1.128121e-001, 1.128362e-001, 1.128603e-001, 1.128844e-001, 1.129085e-001, 1.129325e-001, 1.129566e-001, 1.129806e-001, 1.130047e-001, 1.130288e-001, 1.130528e-001, 1.130769e-001, 1.131009e-001, 1.131250e-001, 1.131490e-001, 1.131730e-001, 1.131971e-001, 1.132211e-001, 1.132451e-001, 1.132692e-001, 1.132932e-001, 1.133172e-001, 1.133412e-001, 1.133652e-001, 1.133893e-001, 1.134133e-001, 1.134373e-001, 1.134613e-001, 1.134853e-001, 1.135093e-001, 1.135333e-001, 1.135572e-001, 1.135812e-001, 1.136052e-001, 1.136292e-001, 1.136532e-001, 1.136772e-001, 1.137011e-001, 1.137251e-001, 1.137491e-001, 1.137730e-001, 1.137970e-001, 1.138209e-001, 1.138449e-001, 1.138689e-001, 1.138928e-001, 1.139167e-001, 1.139407e-001, 1.139646e-001, 1.139886e-001, 1.140125e-001, 1.140364e-001, 1.140604e-001, 1.140843e-001, 1.141082e-001, 1.141321e-001, 1.141560e-001, 1.141800e-001, 1.142039e-001, 1.142278e-001, 1.142517e-001, 1.142756e-001, 1.142995e-001, 1.143234e-001, 1.143473e-001, 1.143712e-001, 1.143950e-001, 1.144189e-001, 1.144428e-001, 1.144667e-001, 1.144906e-001, 1.145144e-001, 1.145383e-001, 1.145622e-001, 1.145860e-001, 1.146099e-001, 1.146337e-001, 1.146576e-001, 1.146814e-001, 1.147053e-001, 1.147291e-001, 1.147530e-001, 1.147768e-001, 1.148007e-001, 1.148245e-001, 1.148483e-001, 1.148721e-001, 1.148960e-001, 1.149198e-001, 1.149436e-001, 
1.149674e-001, 1.149912e-001, 1.150150e-001, 1.150389e-001, 1.150627e-001, 1.150865e-001, 1.151103e-001, 1.151340e-001, 1.151578e-001, 1.151816e-001, 1.152054e-001, 1.152292e-001, 1.152530e-001, 1.152768e-001, 1.153005e-001, 1.153243e-001, 1.153481e-001, 1.153718e-001, 1.153956e-001, 1.154194e-001, 1.154431e-001, 1.154669e-001, 1.154906e-001, 1.155144e-001, 1.155381e-001, 1.155619e-001, 1.155856e-001, 1.156093e-001, 1.156331e-001, 1.156568e-001, 1.156805e-001, 1.157042e-001, 1.157280e-001, 1.157517e-001, 1.157754e-001, 1.157991e-001, 1.158228e-001, 1.158465e-001, 1.158702e-001, 1.158939e-001, 1.159176e-001, 1.159413e-001, 1.159650e-001, 1.159887e-001, 1.160124e-001, 1.160361e-001, 1.160598e-001, 1.160834e-001, 1.161071e-001, 1.161308e-001, 1.161545e-001, 1.161781e-001, 1.162018e-001, 1.162255e-001, 1.162491e-001, 1.162728e-001, 1.162964e-001, 1.163201e-001, 1.163437e-001, 1.163674e-001, 1.163910e-001, 1.164146e-001, 1.164383e-001, 1.164619e-001, 1.164855e-001, 1.165092e-001, 1.165328e-001, 1.165564e-001, 1.165800e-001, 1.166036e-001, 1.166272e-001, 1.166508e-001, 1.166745e-001, 1.166981e-001, 1.167217e-001, 1.167453e-001, 1.167689e-001, 1.167924e-001, 1.168160e-001, 1.168396e-001, 1.168632e-001, 1.168868e-001, 1.169104e-001, 1.169339e-001, 1.169575e-001, 1.169811e-001, 1.170046e-001, 1.170282e-001, 1.170518e-001, 1.170753e-001, 1.170989e-001, 1.171224e-001, 1.171460e-001, 1.171695e-001, 1.171931e-001, 1.172166e-001, 1.172401e-001, 1.172637e-001, 1.172872e-001, 1.173107e-001, 
1.173343e-001, 1.173578e-001, 1.173813e-001, 1.174048e-001, 1.174283e-001, 1.174518e-001, 1.174753e-001, 1.174989e-001, 1.175224e-001, 1.175459e-001, 1.175694e-001, 1.175928e-001, 1.176163e-001, 1.176398e-001, 1.176633e-001, 1.176868e-001, 1.177103e-001, 1.177337e-001, 1.177572e-001, 1.177807e-001, 1.178042e-001, 1.178276e-001, 1.178511e-001, 1.178746e-001, 1.178980e-001, 1.179215e-001, 1.179449e-001, 1.179684e-001, 1.179918e-001, 1.180153e-001, 1.180387e-001, 1.180621e-001, 1.180856e-001, 1.181090e-001, 1.181324e-001, 1.181559e-001, 1.181793e-001, 1.182027e-001, 1.182261e-001, 1.182495e-001, 1.182729e-001, 1.182963e-001, 1.183198e-001, 1.183432e-001, 1.183666e-001, 1.183900e-001, 1.184134e-001, 1.184367e-001, 1.184601e-001, 1.184835e-001, 1.185069e-001, 1.185303e-001, 1.185537e-001, 1.185770e-001, 1.186004e-001, 1.186238e-001, 1.186471e-001, 1.186705e-001, 1.186939e-001, 1.187172e-001, 1.187406e-001, 1.187639e-001, 1.187873e-001, 1.188106e-001, 1.188340e-001, 1.188573e-001, 1.188807e-001, 1.189040e-001, 1.189273e-001, 1.189507e-001, 1.189740e-001, 1.189973e-001, 1.190206e-001, 1.190439e-001, 1.190673e-001, 1.190906e-001, 1.191139e-001, 1.191372e-001, 1.191605e-001, 1.191838e-001, 1.192071e-001, 1.192304e-001, 1.192537e-001, 1.192770e-001, 1.193003e-001, 1.193236e-001, 1.193468e-001, 1.193701e-001, 1.193934e-001, 1.194167e-001, 1.194399e-001, 1.194632e-001, 1.194865e-001, 1.195097e-001, 1.195330e-001, 1.195563e-001, 1.195795e-001, 1.196028e-001, 1.196260e-001, 1.196493e-001, 
1.196725e-001, 1.196957e-001, 1.197190e-001, 1.197422e-001, 1.197655e-001, 1.197887e-001, 1.198119e-001, 1.198351e-001, 1.198584e-001, 1.198816e-001, 1.199048e-001, 1.199280e-001, 1.199512e-001, 1.199744e-001, 1.199976e-001, 1.200208e-001, 1.200440e-001, 1.200672e-001, 1.200904e-001, 1.201136e-001, 1.201368e-001, 1.201600e-001, 1.201832e-001, 1.202063e-001, 1.202295e-001, 1.202527e-001, 1.202759e-001, 1.202990e-001, 1.203222e-001, 1.203454e-001, 1.203685e-001, 1.203917e-001, 1.204148e-001, 1.204380e-001, 1.204611e-001, 1.204843e-001, 1.205074e-001, 1.205306e-001, 1.205537e-001, 1.205769e-001, 1.206000e-001, 1.206231e-001, 1.206462e-001, 1.206694e-001, 1.206925e-001, 1.207156e-001, 1.207387e-001, 1.207618e-001, 1.207850e-001, 1.208081e-001, 1.208312e-001, 1.208543e-001, 1.208774e-001, 1.209005e-001, 1.209236e-001, 1.209467e-001, 1.209697e-001, 1.209928e-001, 1.210159e-001, 1.210390e-001, 1.210621e-001, 1.210852e-001, 1.211082e-001, 1.211313e-001, 1.211544e-001, 1.211774e-001, 1.212005e-001, 1.212236e-001, 1.212466e-001, 1.212697e-001, 1.212927e-001, 1.213158e-001, 1.213388e-001, 1.213618e-001, 1.213849e-001, 1.214079e-001, 1.214310e-001, 1.214540e-001, 1.214770e-001, 1.215000e-001, 1.215231e-001, 1.215461e-001, 1.215691e-001, 1.215921e-001, 1.216151e-001, 1.216382e-001, 1.216612e-001, 1.216842e-001, 1.217072e-001, 1.217302e-001, 1.217532e-001, 1.217762e-001, 1.217991e-001, 1.218221e-001, 1.218451e-001, 1.218681e-001, 1.218911e-001, 1.219141e-001, 1.219370e-001, 1.219600e-001, 
1.219830e-001, 1.220059e-001, 1.220289e-001, 1.220519e-001, 1.220748e-001, 1.220978e-001, 1.221207e-001, 1.221437e-001, 1.221666e-001, 1.221896e-001, 1.222125e-001, 1.222355e-001, 1.222584e-001, 1.222813e-001, 1.223043e-001, 1.223272e-001, 1.223501e-001, 1.223731e-001, 1.223960e-001, 1.224189e-001, 1.224418e-001, 1.224647e-001, 1.224876e-001, 1.225105e-001, 1.225334e-001, 1.225563e-001, 1.225792e-001, 1.226021e-001, 1.226250e-001, 1.226479e-001, 1.226708e-001, 1.226937e-001, 1.227166e-001, 1.227395e-001, 1.227623e-001, 1.227852e-001, 1.228081e-001, 1.228310e-001, 1.228538e-001, 1.228767e-001, 1.228996e-001, 1.229224e-001, 1.229453e-001, 1.229681e-001, 1.229910e-001, 1.230138e-001, 1.230367e-001, 1.230595e-001, 1.230824e-001, 1.231052e-001, 1.231280e-001, 1.231509e-001, 1.231737e-001, 1.231965e-001, 1.232194e-001, 1.232422e-001, 1.232650e-001, 1.232878e-001, 1.233106e-001, 1.233334e-001, 1.233562e-001, 1.233791e-001, 1.234019e-001, 1.234247e-001, 1.234475e-001, 1.234703e-001, 1.234930e-001, 1.235158e-001, 1.235386e-001, 1.235614e-001, 1.235842e-001, 1.236070e-001, 1.236297e-001, 1.236525e-001, 1.236753e-001, 1.236981e-001, 1.237208e-001, 1.237436e-001, 1.237664e-001, 1.237891e-001, 1.238119e-001, 1.238346e-001, 1.238574e-001, 1.238801e-001, 1.239029e-001, 1.239256e-001, 1.239483e-001, 1.239711e-001, 1.239938e-001, 1.240165e-001, 1.240393e-001, 1.240620e-001, 1.240847e-001, 1.241075e-001, 1.241302e-001, 1.241529e-001, 1.241756e-001, 1.241983e-001, 1.242210e-001, 1.242437e-001, 
1.242664e-001, 1.242891e-001, 1.243118e-001, 1.243345e-001, 1.243572e-001, 1.243799e-001, 1.244026e-001, 1.244253e-001, 1.244480e-001, 1.244706e-001, 1.244933e-001, 1.245160e-001, 1.245387e-001, 1.245613e-001, 1.245840e-001, 1.246067e-001, 1.246293e-001, 1.246520e-001, 1.246746e-001, 1.246973e-001, 1.247199e-001, 1.247426e-001, 1.247652e-001, 1.247879e-001, 1.248105e-001, 1.248331e-001, 1.248558e-001, 1.248784e-001, 1.249010e-001, 1.249237e-001, 1.249463e-001, 1.249689e-001, 1.249915e-001, 1.250142e-001, 1.250368e-001, 1.250594e-001, 1.250820e-001, 1.251046e-001, 1.251272e-001, 1.251498e-001, 1.251724e-001, 1.251950e-001, 1.252176e-001, 1.252402e-001, 1.252628e-001, 1.252853e-001, 1.253079e-001, 1.253305e-001, 1.253531e-001, 1.253757e-001, 1.253982e-001, 1.254208e-001, 1.254434e-001, 1.254659e-001, 1.254885e-001, 1.255111e-001, 1.255336e-001, 1.255562e-001, 1.255787e-001, 1.256013e-001, 1.256238e-001, 1.256464e-001, 1.256689e-001, 1.256914e-001, 1.257140e-001, 1.257365e-001, 1.257590e-001, 1.257816e-001, 1.258041e-001, 1.258266e-001, 1.258491e-001, 1.258717e-001, 1.258942e-001, 1.259167e-001, 1.259392e-001, 1.259617e-001, 1.259842e-001, 1.260067e-001, 1.260292e-001, 1.260517e-001, 1.260742e-001, 1.260967e-001, 1.261192e-001, 1.261417e-001, 1.261642e-001, 1.261866e-001, 1.262091e-001, 1.262316e-001, 1.262541e-001, 1.262765e-001, 1.262990e-001, 1.263215e-001, 1.263439e-001, 1.263664e-001, 1.263889e-001, 1.264113e-001, 1.264338e-001, 1.264562e-001, 1.264787e-001, 1.265011e-001, 
1.265236e-001, 1.265460e-001, 1.265684e-001, 1.265909e-001, 1.266133e-001, 1.266357e-001, 1.266582e-001, 1.266806e-001, 1.267030e-001, 1.267254e-001, 1.267478e-001, 1.267703e-001, 1.267927e-001, 1.268151e-001, 1.268375e-001, 1.268599e-001, 1.268823e-001, 1.269047e-001, 1.269271e-001, 1.269495e-001, 1.269719e-001, 1.269943e-001, 1.270167e-001, 1.270390e-001, 1.270614e-001, 1.270838e-001, 1.271062e-001, 1.271286e-001, 1.271509e-001, 1.271733e-001, 1.271957e-001, 1.272180e-001, 1.272404e-001, 1.272627e-001, 1.272851e-001, 1.273075e-001, 1.273298e-001, 1.273522e-001, 1.273745e-001, 1.273968e-001, 1.274192e-001, 1.274415e-001, 1.274639e-001, 1.274862e-001, 1.275085e-001, 1.275309e-001, 1.275532e-001, 1.275755e-001, 1.275978e-001, 1.276201e-001, 1.276425e-001, 1.276648e-001, 1.276871e-001, 1.277094e-001, 1.277317e-001, 1.277540e-001, 1.277763e-001, 1.277986e-001, 1.278209e-001, 1.278432e-001, 1.278655e-001, 1.278878e-001, 1.279100e-001, 1.279323e-001, 1.279546e-001, 1.279769e-001, 1.279992e-001, 1.280214e-001, 1.280437e-001, 1.280660e-001, 1.280882e-001, 1.281105e-001, 1.281328e-001, 1.281550e-001, 1.281773e-001, 1.281995e-001, 1.282218e-001, 1.282440e-001, 1.282663e-001, 1.282885e-001, 1.283108e-001, 1.283330e-001, 1.283552e-001, 1.283775e-001, 1.283997e-001, 1.284219e-001, 1.284441e-001, 1.284664e-001, 1.284886e-001, 1.285108e-001, 1.285330e-001, 1.285552e-001, 1.285774e-001, 1.285997e-001, 1.286219e-001, 1.286441e-001, 1.286663e-001, 1.286885e-001, 1.287107e-001, 1.287328e-001, 
1.287550e-001, 1.287772e-001, 1.287994e-001, 1.288216e-001, 1.288438e-001, 1.288659e-001, 1.288881e-001, 1.289103e-001, 1.289325e-001, 1.289546e-001, 1.289768e-001, 1.289990e-001, 1.290211e-001, 1.290433e-001, 1.290654e-001, 1.290876e-001, 1.291097e-001, 1.291319e-001, 1.291540e-001, 1.291762e-001, 1.291983e-001, 1.292204e-001, 1.292426e-001, 1.292647e-001, 1.292868e-001, 1.293090e-001, 1.293311e-001, 1.293532e-001, 1.293753e-001, 1.293975e-001, 1.294196e-001, 1.294417e-001, 1.294638e-001, 1.294859e-001, 1.295080e-001, 1.295301e-001, 1.295522e-001, 1.295743e-001, 1.295964e-001, 1.296185e-001, 1.296406e-001, 1.296627e-001, 1.296848e-001, 1.297068e-001, 1.297289e-001, 1.297510e-001, 1.297731e-001, 1.297952e-001, 1.298172e-001, 1.298393e-001, 1.298614e-001, 1.298834e-001, 1.299055e-001, 1.299275e-001, 1.299496e-001, 1.299717e-001, 1.299937e-001, 1.300158e-001, 1.300378e-001, 1.300598e-001, 1.300819e-001, 1.301039e-001, 1.301260e-001, 1.301480e-001, 1.301700e-001, 1.301920e-001, 1.302141e-001, 1.302361e-001, 1.302581e-001, 1.302801e-001, 1.303022e-001, 1.303242e-001, 1.303462e-001, 1.303682e-001, 1.303902e-001, 1.304122e-001, 1.304342e-001, 1.304562e-001, 1.304782e-001, 1.305002e-001, 1.305222e-001, 1.305442e-001, 1.305662e-001, 1.305881e-001, 1.306101e-001, 1.306321e-001, 1.306541e-001, 1.306761e-001, 1.306980e-001, 1.307200e-001, 1.307420e-001, 1.307639e-001, 1.307859e-001, 1.308079e-001, 1.308298e-001, 1.308518e-001, 1.308737e-001, 1.308957e-001, 1.309176e-001, 1.309396e-001, 
1.309615e-001, 1.309835e-001, 1.310054e-001, 1.310273e-001, 1.310493e-001, 1.310712e-001, 1.310931e-001, 1.311150e-001, 1.311370e-001, 1.311589e-001, 1.311808e-001, 1.312027e-001, 1.312246e-001, 1.312465e-001, 1.312685e-001, 1.312904e-001, 1.313123e-001, 1.313342e-001, 1.313561e-001, 1.313780e-001, 1.313999e-001, 1.314218e-001, 1.314436e-001, 1.314655e-001, 1.314874e-001, 1.315093e-001, 1.315312e-001, 1.315531e-001, 1.315749e-001, 1.315968e-001, 1.316187e-001, 1.316405e-001, 1.316624e-001, 1.316843e-001, 1.317061e-001, 1.317280e-001, 1.317498e-001, 1.317717e-001, 1.317935e-001, 1.318154e-001, 1.318372e-001, 1.318591e-001, 1.318809e-001, 1.319028e-001, 1.319246e-001, 1.319464e-001, 1.319683e-001, 1.319901e-001, 1.320119e-001, 1.320337e-001, 1.320556e-001, 1.320774e-001, 1.320992e-001, 1.321210e-001, 1.321428e-001, 1.321646e-001, 1.321864e-001, 1.322083e-001, 1.322301e-001, 1.322519e-001, 1.322737e-001, 1.322954e-001, 1.323172e-001, 1.323390e-001, 1.323608e-001, 1.323826e-001, 1.324044e-001, 1.324262e-001, 1.324479e-001, 1.324697e-001, 1.324915e-001, 1.325133e-001, 1.325350e-001, 1.325568e-001, 1.325786e-001, 1.326003e-001, 1.326221e-001, 1.326438e-001, 1.326656e-001, 1.326874e-001, 1.327091e-001, 1.327309e-001, 1.327526e-001, 1.327743e-001, 1.327961e-001, 1.328178e-001, 1.328396e-001, 1.328613e-001, 1.328830e-001, 1.329047e-001, 1.329265e-001, 1.329482e-001, 1.329699e-001, 1.329916e-001, 1.330133e-001, 1.330351e-001, 1.330568e-001, 1.330785e-001, 1.331002e-001, 1.331219e-001, 
1.331436e-001, 1.331653e-001, 1.331870e-001, 1.332087e-001, 1.332304e-001, 1.332521e-001, 1.332738e-001, 1.332954e-001, 1.333171e-001, 1.333388e-001, 1.333605e-001, 1.333822e-001, 1.334038e-001, 1.334255e-001, 1.334472e-001, 1.334688e-001, 1.334905e-001, 1.335122e-001, 1.335338e-001, 1.335555e-001, 1.335771e-001, 1.335988e-001, 1.336204e-001, 1.336421e-001, 1.336637e-001, 1.336854e-001, 1.337070e-001, 1.337287e-001, 1.337503e-001, 1.337719e-001, 1.337936e-001, 1.338152e-001, 1.338368e-001, 1.338584e-001, 1.338801e-001, 1.339017e-001, 1.339233e-001, 1.339449e-001, 1.339665e-001, 1.339881e-001, 1.340097e-001, 1.340313e-001, 1.340529e-001, 1.340745e-001, 1.340961e-001, 1.341177e-001, 1.341393e-001, 1.341609e-001, 1.341825e-001, 1.342041e-001, 1.342257e-001, 1.342473e-001, 1.342688e-001, 1.342904e-001, 1.343120e-001, 1.343336e-001, 1.343551e-001, 1.343767e-001, 1.343983e-001, 1.344198e-001, 1.344414e-001, 1.344629e-001, 1.344845e-001, 1.345061e-001, 1.345276e-001, 1.345491e-001, 1.345707e-001, 1.345922e-001, 1.346138e-001, 1.346353e-001, 1.346569e-001, 1.346784e-001, 1.346999e-001, 1.347215e-001, 1.347430e-001, 1.347645e-001, 1.347860e-001, 1.348075e-001, 1.348291e-001, 1.348506e-001, 1.348721e-001, 1.348936e-001, 1.349151e-001, 1.349366e-001, 1.349581e-001, 1.349796e-001, 1.350011e-001, 1.350226e-001, 1.350441e-001, 1.350656e-001, 1.350871e-001, 1.351086e-001, 1.351301e-001, 1.351516e-001, 1.351730e-001, 1.351945e-001, 1.352160e-001, 1.352375e-001, 1.352589e-001, 1.352804e-001, 
1.353019e-001, 1.353233e-001, 1.353448e-001, 1.353663e-001, 1.353877e-001, 1.354092e-001, 1.354306e-001, 1.354521e-001, 1.354735e-001, 1.354950e-001, 1.355164e-001, 1.355379e-001, 1.355593e-001, 1.355807e-001, 1.356022e-001, 1.356236e-001, 1.356450e-001, 1.356665e-001, 1.356879e-001, 1.357093e-001, 1.357307e-001, 1.357521e-001, 1.357736e-001, 1.357950e-001, 1.358164e-001, 1.358378e-001, 1.358592e-001, 1.358806e-001, 1.359020e-001, 1.359234e-001, 1.359448e-001, 1.359662e-001, 1.359876e-001, 1.360090e-001, 1.360304e-001, 1.360517e-001, 1.360731e-001, 1.360945e-001, 1.361159e-001, 1.361373e-001, 1.361586e-001, 1.361800e-001, 1.362014e-001, 1.362227e-001, 1.362441e-001, 1.362655e-001, 1.362868e-001, 1.363082e-001, 1.363295e-001, 1.363509e-001, 1.363723e-001, 1.363936e-001, 1.364149e-001, 1.364363e-001, 1.364576e-001, 1.364790e-001, 1.365003e-001, 1.365216e-001, 1.365430e-001, 1.365643e-001, 1.365856e-001, 1.366070e-001, 1.366283e-001, 1.366496e-001, 1.366709e-001, 1.366922e-001, 1.367136e-001, 1.367349e-001, 1.367562e-001, 1.367775e-001, 1.367988e-001, 1.368201e-001, 1.368414e-001, 1.368627e-001, 1.368840e-001, 1.369053e-001, 1.369266e-001, 1.369479e-001, 1.369692e-001, 1.369904e-001, 1.370117e-001, 1.370330e-001, 1.370543e-001, 1.370756e-001, 1.370968e-001, 1.371181e-001, 1.371394e-001, 1.371606e-001, 1.371819e-001, 1.372032e-001, 1.372244e-001, 1.372457e-001, 1.372669e-001, 1.372882e-001, 1.373094e-001, 1.373307e-001, 1.373519e-001, 1.373732e-001, 1.373944e-001, 1.374157e-001, 
1.374369e-001, 1.374581e-001, 1.374794e-001, 1.375006e-001, 1.375218e-001, 1.375430e-001, 1.375643e-001, 1.375855e-001, 1.376067e-001, 1.376279e-001, 1.376491e-001, 1.376703e-001, 1.376916e-001, 1.377128e-001, 1.377340e-001, 1.377552e-001, 1.377764e-001, 1.377976e-001, 1.378188e-001, 1.378400e-001, 1.378611e-001, 1.378823e-001, 1.379035e-001, 1.379247e-001, 1.379459e-001, 1.379671e-001, 1.379882e-001, 1.380094e-001, 1.380306e-001, 1.380518e-001, 1.380729e-001, 1.380941e-001, 1.381153e-001, 1.381364e-001, 1.381576e-001, 1.381787e-001, 1.381999e-001, 1.382211e-001, 1.382422e-001, 1.382634e-001, 1.382845e-001, 1.383056e-001, 1.383268e-001, 1.383479e-001, 1.383691e-001, 1.383902e-001, 1.384113e-001, 1.384325e-001, 1.384536e-001, 1.384747e-001, 1.384958e-001, 1.385170e-001, 1.385381e-001, 1.385592e-001, 1.385803e-001, 1.386014e-001, 1.386225e-001, 1.386436e-001, 1.386648e-001, 1.386859e-001, 1.387070e-001, 1.387281e-001, 1.387492e-001, 1.387702e-001, 1.387913e-001, 1.388124e-001, 1.388335e-001, 1.388546e-001, 1.388757e-001, 1.388968e-001, 1.389178e-001, 1.389389e-001, 1.389600e-001, 1.389811e-001, 1.390021e-001, 1.390232e-001, 1.390443e-001, 1.390653e-001, 1.390864e-001, 1.391075e-001, 1.391285e-001, 1.391496e-001, 1.391706e-001, 1.391917e-001, 1.392127e-001, 1.392338e-001, 1.392548e-001, 1.392758e-001, 1.392969e-001, 1.393179e-001, 1.393390e-001, 1.393600e-001, 1.393810e-001, 1.394020e-001, 1.394231e-001, 1.394441e-001, 1.394651e-001, 1.394861e-001, 1.395071e-001, 1.395282e-001, 
1.395492e-001, 1.395702e-001, 1.395912e-001, 1.396122e-001, 1.396332e-001, 1.396542e-001, 1.396752e-001, 1.396962e-001, 1.397172e-001, 1.397382e-001, 1.397592e-001, 1.397802e-001, 1.398011e-001, 1.398221e-001, 1.398431e-001, 1.398641e-001, 1.398851e-001, 1.399060e-001, 1.399270e-001, 1.399480e-001, 1.399690e-001, 1.399899e-001, 1.400109e-001, 1.400318e-001, 1.400528e-001, 1.400738e-001, 1.400947e-001, 1.401157e-001, 1.401366e-001, 1.401576e-001, 1.401785e-001, 1.401994e-001, 1.402204e-001, 1.402413e-001, 1.402623e-001, 1.402832e-001, 1.403041e-001, 1.403251e-001, 1.403460e-001, 1.403669e-001, 1.403878e-001, 1.404088e-001, 1.404297e-001, 1.404506e-001, 1.404715e-001, 1.404924e-001, 1.405133e-001, 1.405342e-001, 1.405551e-001, 1.405761e-001, 1.405970e-001, 1.406179e-001, 1.406388e-001, 1.406596e-001, 1.406805e-001, 1.407014e-001, 1.407223e-001, 1.407432e-001, 1.407641e-001, 1.407850e-001, 1.408058e-001, 1.408267e-001, 1.408476e-001, 1.408685e-001, 1.408893e-001, 1.409102e-001, 1.409311e-001, 1.409519e-001, 1.409728e-001, 1.409937e-001, 1.410145e-001, 1.410354e-001, 1.410562e-001, 1.410771e-001, 1.410979e-001, 1.411188e-001, 1.411396e-001, 1.411605e-001, 1.411813e-001, 1.412021e-001, 1.412230e-001, 1.412438e-001, 1.412646e-001, 1.412855e-001, 1.413063e-001, 1.413271e-001, 1.413479e-001, 1.413688e-001, 1.413896e-001, 1.414104e-001, 1.414312e-001, 1.414520e-001, 1.414728e-001, 1.414936e-001, 1.415145e-001, 1.415353e-001, 1.415561e-001, 1.415769e-001, 1.415977e-001, 1.416184e-001, 
1.416392e-001, 1.416600e-001, 1.416808e-001, 1.417016e-001, 1.417224e-001, 1.417432e-001, 1.417639e-001, 1.417847e-001, 1.418055e-001, 1.418263e-001, 1.418470e-001, 1.418678e-001, 1.418886e-001, 1.419093e-001, 1.419301e-001, 1.419509e-001, 1.419716e-001, 1.419924e-001, 1.420131e-001, 1.420339e-001, 1.420546e-001, 1.420754e-001, 1.420961e-001, 1.421169e-001, 1.421376e-001, 1.421583e-001, 1.421791e-001, 1.421998e-001, 1.422205e-001, 1.422413e-001, 1.422620e-001, 1.422827e-001, 1.423034e-001, 1.423242e-001, 1.423449e-001, 1.423656e-001, 1.423863e-001, 1.424070e-001, 1.424277e-001, 1.424484e-001, 1.424692e-001, 1.424899e-001, 1.425106e-001, 1.425313e-001, 1.425520e-001, 1.425726e-001, 1.425933e-001, 1.426140e-001, 1.426347e-001, 1.426554e-001, 1.426761e-001, 1.426968e-001, 1.427174e-001, 1.427381e-001, 1.427588e-001, 1.427795e-001, 1.428001e-001, 1.428208e-001, 1.428415e-001, 1.428621e-001, 1.428828e-001, 1.429035e-001, 1.429241e-001, 1.429448e-001, 1.429654e-001, 1.429861e-001, 1.430067e-001, 1.430274e-001, 1.430480e-001, 1.430687e-001, 1.430893e-001, 1.431100e-001, 1.431306e-001, 1.431512e-001, 1.431719e-001, 1.431925e-001, 1.432131e-001, 1.432337e-001, 1.432544e-001, 1.432750e-001, 1.432956e-001, 1.433162e-001, 1.433368e-001, 1.433575e-001, 1.433781e-001, 1.433987e-001, 1.434193e-001, 1.434399e-001, 1.434605e-001, 1.434811e-001, 1.435017e-001, 1.435223e-001, 1.435429e-001, 1.435635e-001, 1.435841e-001, 1.436047e-001, 1.436252e-001, 1.436458e-001, 1.436664e-001, 1.436870e-001, 
1.437076e-001, 1.437281e-001, 1.437487e-001, 1.437693e-001, 1.437898e-001, 1.438104e-001, 1.438310e-001, 1.438515e-001, 1.438721e-001, 1.438927e-001, 1.439132e-001, 1.439338e-001, 1.439543e-001, 1.439749e-001, 1.439954e-001, 1.440160e-001, 1.440365e-001, 1.440570e-001, 1.440776e-001, 1.440981e-001, 1.441187e-001, 1.441392e-001, 1.441597e-001, 1.441802e-001, 1.442008e-001, 1.442213e-001, 1.442418e-001, 1.442623e-001, 1.442829e-001, 1.443034e-001, 1.443239e-001, 1.443444e-001, 1.443649e-001, 1.443854e-001, 1.444059e-001, 1.444264e-001, 1.444469e-001, 1.444674e-001, 1.444879e-001, 1.445084e-001, 1.445289e-001, 1.445494e-001, 1.445699e-001, 1.445904e-001, 1.446109e-001, 1.446313e-001, 1.446518e-001, 1.446723e-001, 1.446928e-001, 1.447132e-001, 1.447337e-001, 1.447542e-001, 1.447747e-001, 1.447951e-001, 1.448156e-001, 1.448360e-001, 1.448565e-001, 1.448770e-001, 1.448974e-001, 1.449179e-001, 1.449383e-001, 1.449588e-001, 1.449792e-001, 1.449997e-001, 1.450201e-001, 1.450405e-001, 1.450610e-001, 1.450814e-001, 1.451018e-001, 1.451223e-001, 1.451427e-001, 1.451631e-001, 1.451836e-001, 1.452040e-001, 1.452244e-001, 1.452448e-001, 1.452652e-001, 1.452856e-001, 1.453061e-001, 1.453265e-001, 1.453469e-001, 1.453673e-001, 1.453877e-001, 1.454081e-001, 1.454285e-001, 1.454489e-001, 1.454693e-001, 1.454897e-001, 1.455101e-001, 1.455305e-001, 1.455508e-001, 1.455712e-001, 1.455916e-001, 1.456120e-001, 1.456324e-001, 1.456528e-001, 1.456731e-001, 1.456935e-001, 1.457139e-001, 1.457342e-001, 
1.457546e-001, 1.457750e-001, 1.457953e-001, 1.458157e-001, 1.458361e-001, 1.458564e-001, 1.458768e-001, 1.458971e-001, 1.459175e-001, 1.459378e-001, 1.459582e-001, 1.459785e-001, 1.459988e-001, 1.460192e-001, 1.460395e-001, 1.460599e-001, 1.460802e-001, 1.461005e-001, 1.461208e-001, 1.461412e-001, 1.461615e-001, 1.461818e-001, 1.462021e-001, 1.462225e-001, 1.462428e-001, 1.462631e-001, 1.462834e-001, 1.463037e-001, 1.463240e-001, 1.463443e-001, 1.463646e-001, 1.463849e-001, 1.464052e-001, 1.464255e-001, 1.464458e-001, 1.464661e-001, 1.464864e-001, 1.465067e-001, 1.465270e-001, 1.465473e-001, 1.465676e-001, 1.465878e-001, 1.466081e-001, 1.466284e-001, 1.466487e-001, 1.466690e-001, 1.466892e-001, 1.467095e-001, 1.467298e-001, 1.467500e-001, 1.467703e-001, 1.467905e-001, 1.468108e-001, 1.468311e-001, 1.468513e-001, 1.468716e-001, 1.468918e-001, 1.469121e-001, 1.469323e-001, 1.469526e-001, 1.469728e-001, 1.469930e-001, 1.470133e-001, 1.470335e-001, 1.470538e-001, 1.470740e-001, 1.470942e-001, 1.471144e-001, 1.471347e-001, 1.471549e-001, 1.471751e-001, 1.471953e-001, 1.472156e-001, 1.472358e-001, 1.472560e-001, 1.472762e-001, 1.472964e-001, 1.473166e-001, 1.473368e-001, 1.473570e-001, 1.473772e-001, 1.473974e-001, 1.474176e-001, 1.474378e-001, 1.474580e-001, 1.474782e-001, 1.474984e-001, 1.475186e-001, 1.475388e-001, 1.475589e-001, 1.475791e-001, 1.475993e-001, 1.476195e-001, 1.476396e-001, 1.476598e-001, 1.476800e-001, 1.477002e-001, 1.477203e-001, 1.477405e-001, 1.477607e-001, 
1.477808e-001, 1.478010e-001, 1.478211e-001, 1.478413e-001, 1.478614e-001, 1.478816e-001, 1.479017e-001, 1.479219e-001, 1.479420e-001, 1.479622e-001, 1.479823e-001, 1.480024e-001, 1.480226e-001, 1.480427e-001, 1.480628e-001, 1.480830e-001, 1.481031e-001, 1.481232e-001, 1.481434e-001, 1.481635e-001, 1.481836e-001, 1.482037e-001, 1.482238e-001, 1.482439e-001, 1.482641e-001, 1.482842e-001, 1.483043e-001, 1.483244e-001, 1.483445e-001, 1.483646e-001, 1.483847e-001, 1.484048e-001, 1.484249e-001, 1.484450e-001, 1.484651e-001, 1.484851e-001, 1.485052e-001, 1.485253e-001, 1.485454e-001, 1.485655e-001, 1.485856e-001, 1.486056e-001, 1.486257e-001, 1.486458e-001, 1.486659e-001, 1.486859e-001, 1.487060e-001, 1.487261e-001, 1.487461e-001, 1.487662e-001, 1.487862e-001, 1.488063e-001, 1.488264e-001, 1.488464e-001, 1.488665e-001, 1.488865e-001, 1.489065e-001, 1.489266e-001, 1.489466e-001, 1.489667e-001, 1.489867e-001, 1.490068e-001, 1.490268e-001, 1.490468e-001, 1.490669e-001, 1.490869e-001, 1.491069e-001, 1.491269e-001, 1.491470e-001, 1.491670e-001, 1.491870e-001, 1.492070e-001, 1.492270e-001, 1.492470e-001, 1.492670e-001, 1.492871e-001, 1.493071e-001, 1.493271e-001, 1.493471e-001, 1.493671e-001, 1.493871e-001, 1.494071e-001, 1.494271e-001, 1.494470e-001, 1.494670e-001, 1.494870e-001, 1.495070e-001, 1.495270e-001, 1.495470e-001, 1.495670e-001, 1.495869e-001, 1.496069e-001, 1.496269e-001, 1.496469e-001, 1.496668e-001, 1.496868e-001, 1.497068e-001, 1.497267e-001, 1.497467e-001, 1.497667e-001, 
1.497866e-001, 1.498066e-001, 1.498265e-001, 1.498465e-001, 1.498664e-001, 1.498864e-001, 1.499063e-001, 1.499263e-001, 1.499462e-001, 1.499661e-001, 1.499861e-001, 1.500060e-001, 1.500260e-001, 1.500459e-001, 1.500658e-001, 1.500857e-001, 1.501057e-001, 1.501256e-001, 1.501455e-001, 1.501654e-001, 1.501854e-001, 1.502053e-001, 1.502252e-001, 1.502451e-001, 1.502650e-001, 1.502849e-001, 1.503048e-001, 1.503247e-001, 1.503446e-001, 1.503645e-001, 1.503844e-001, 1.504043e-001, 1.504242e-001, 1.504441e-001, 1.504640e-001, 1.504839e-001, 1.505038e-001, 1.505237e-001, 1.505436e-001, 1.505634e-001, 1.505833e-001, 1.506032e-001, 1.506231e-001, 1.506429e-001, 1.506628e-001, 1.506827e-001, 1.507025e-001, 1.507224e-001, 1.507423e-001, 1.507621e-001, 1.507820e-001, 1.508018e-001, 1.508217e-001, 1.508416e-001, 1.508614e-001, 1.508813e-001, 1.509011e-001, 1.509209e-001, 1.509408e-001, 1.509606e-001, 1.509805e-001, 1.510003e-001, 1.510201e-001, 1.510400e-001, 1.510598e-001, 1.510796e-001, 1.510995e-001, 1.511193e-001, 1.511391e-001, 1.511589e-001, 1.511787e-001, 1.511986e-001, 1.512184e-001, 1.512382e-001, 1.512580e-001, 1.512778e-001, 1.512976e-001, 1.513174e-001, 1.513372e-001, 1.513570e-001, 1.513768e-001, 1.513966e-001, 1.514164e-001, 1.514362e-001, 1.514560e-001, 1.514758e-001, 1.514956e-001, 1.515154e-001, 1.515352e-001, 1.515549e-001, 1.515747e-001, 1.515945e-001, 1.516143e-001, 1.516340e-001, 1.516538e-001, 1.516736e-001, 1.516934e-001, 1.517131e-001, 1.517329e-001, 1.517527e-001, 
1.517724e-001, 1.517922e-001, 1.518119e-001, 1.518317e-001, 1.518514e-001, 1.518712e-001, 1.518909e-001, 1.519107e-001, 1.519304e-001, 1.519502e-001, 1.519699e-001, 1.519896e-001, 1.520094e-001, 1.520291e-001, 1.520489e-001, 1.520686e-001, 1.520883e-001, 1.521080e-001, 1.521278e-001, 1.521475e-001, 1.521672e-001, 1.521869e-001, 1.522066e-001, 1.522264e-001, 1.522461e-001, 1.522658e-001, 1.522855e-001, 1.523052e-001, 1.523249e-001, 1.523446e-001, 1.523643e-001, 1.523840e-001, 1.524037e-001, 1.524234e-001, 1.524431e-001, 1.524628e-001, 1.524825e-001, 1.525022e-001, 1.525219e-001, 1.525415e-001, 1.525612e-001, 1.525809e-001, 1.526006e-001, 1.526203e-001, 1.526399e-001, 1.526596e-001, 1.526793e-001, 1.526989e-001, 1.527186e-001, 1.527383e-001, 1.527579e-001, 1.527776e-001, 1.527973e-001, 1.528169e-001, 1.528366e-001, 1.528562e-001, 1.528759e-001, 1.528955e-001, 1.529152e-001, 1.529348e-001, 1.529545e-001, 1.529741e-001, 1.529937e-001, 1.530134e-001, 1.530330e-001, 1.530526e-001, 1.530723e-001, 1.530919e-001, 1.531115e-001, 1.531312e-001, 1.531508e-001, 1.531704e-001, 1.531900e-001, 1.532096e-001, 1.532293e-001, 1.532489e-001, 1.532685e-001, 1.532881e-001, 1.533077e-001, 1.533273e-001, 1.533469e-001, 1.533665e-001, 1.533861e-001, 1.534057e-001, 1.534253e-001, 1.534449e-001, 1.534645e-001, 1.534841e-001, 1.535037e-001, 1.535233e-001, 1.535429e-001, 1.535624e-001, 1.535820e-001, 1.536016e-001, 1.536212e-001, 1.536408e-001, 1.536603e-001, 1.536799e-001, 1.536995e-001, 1.537190e-001, 
1.537386e-001, 1.537582e-001, 1.537777e-001, 1.537973e-001, 1.538168e-001, 1.538364e-001, 1.538560e-001, 1.538755e-001, 1.538951e-001, 1.539146e-001, 1.539342e-001, 1.539537e-001, 1.539732e-001, 1.539928e-001, 1.540123e-001, 1.540319e-001, 1.540514e-001, 1.540709e-001, 1.540905e-001, 1.541100e-001, 1.541295e-001, 1.541490e-001, 1.541686e-001, 1.541881e-001, 1.542076e-001, 1.542271e-001, 1.542466e-001, 1.542662e-001, 1.542857e-001, 1.543052e-001, 1.543247e-001, 1.543442e-001, 1.543637e-001, 1.543832e-001, 1.544027e-001, 1.544222e-001, 1.544417e-001, 1.544612e-001, 1.544807e-001, 1.545002e-001, 1.545197e-001, 1.545392e-001, 1.545586e-001, 1.545781e-001, 1.545976e-001, 1.546171e-001, 1.546366e-001, 1.546560e-001, 1.546755e-001, 1.546950e-001, 1.547145e-001, 1.547339e-001, 1.547534e-001, 1.547729e-001, 1.547923e-001, 1.548118e-001, 1.548312e-001, 1.548507e-001, 1.548702e-001, 1.548896e-001, 1.549091e-001, 1.549285e-001, 1.549480e-001, 1.549674e-001, 1.549868e-001, 1.550063e-001, 1.550257e-001, 1.550452e-001, 1.550646e-001, 1.550840e-001, 1.551035e-001, 1.551229e-001, 1.551423e-001, 1.551618e-001, 1.551812e-001, 1.552006e-001, 1.552200e-001, 1.552394e-001, 1.552589e-001, 1.552783e-001, 1.552977e-001, 1.553171e-001, 1.553365e-001, 1.553559e-001, 1.553753e-001, 1.553947e-001, 1.554141e-001, 1.554335e-001, 1.554529e-001, 1.554723e-001, 1.554917e-001, 1.555111e-001, 1.555305e-001, 1.555499e-001, 1.555693e-001, 1.555887e-001, 1.556080e-001, 1.556274e-001, 1.556468e-001, 1.556662e-001, 
1.556856e-001, 1.557049e-001, 1.557243e-001, 1.557437e-001, 1.557630e-001, 1.557824e-001, 1.558018e-001, 1.558211e-001, 1.558405e-001, 1.558599e-001, 1.558792e-001, 1.558986e-001, 1.559179e-001, 1.559373e-001, 1.559566e-001, 1.559760e-001, 1.559953e-001, 1.560147e-001, 1.560340e-001, 1.560533e-001, 1.560727e-001, 1.560920e-001, 1.561113e-001, 1.561307e-001, 1.561500e-001, 1.561693e-001, 1.561887e-001, 1.562080e-001, 1.562273e-001, 1.562466e-001, 1.562659e-001, 1.562853e-001, 1.563046e-001, 1.563239e-001, 1.563432e-001, 1.563625e-001, 1.563818e-001, 1.564011e-001, 1.564204e-001, 1.564397e-001, 1.564590e-001, 1.564783e-001, 1.564976e-001, 1.565169e-001, 1.565362e-001, 1.565555e-001, 1.565748e-001, 1.565941e-001, 1.566134e-001, 1.566327e-001, 1.566519e-001, 1.566712e-001, 1.566905e-001, 1.567098e-001, 1.567290e-001, 1.567483e-001, 1.567676e-001, 1.567869e-001, 1.568061e-001, 1.568254e-001, 1.568447e-001, 1.568639e-001, 1.568832e-001, 1.569024e-001, 1.569217e-001, 1.569409e-001, 1.569602e-001, 1.569794e-001, 1.569987e-001, 1.570179e-001, 1.570372e-001, 1.570564e-001, 1.570757e-001, 1.570949e-001, 1.571141e-001, 1.571334e-001, 1.571526e-001, 1.571718e-001, 1.571911e-001, 1.572103e-001, 1.572295e-001, 1.572487e-001, 1.572680e-001, 1.572872e-001, 1.573064e-001, 1.573256e-001, 1.573448e-001, 1.573640e-001, 1.573833e-001, 1.574025e-001, 1.574217e-001, 1.574409e-001, 1.574601e-001, 1.574793e-001, 1.574985e-001, 1.575177e-001, 1.575369e-001, 1.575561e-001, 1.575753e-001, 1.575945e-001, 
1.576136e-001, 1.576328e-001, 1.576520e-001, 1.576712e-001, 1.576904e-001, 1.577096e-001, 1.577287e-001, 1.577479e-001, 1.577671e-001, 1.577863e-001, 1.578054e-001, 1.578246e-001, 1.578438e-001, 1.578629e-001, 1.578821e-001, 1.579013e-001, 1.579204e-001, 1.579396e-001, 1.579587e-001, 1.579779e-001, 1.579970e-001, 1.580162e-001, 1.580353e-001, 1.580545e-001, 1.580736e-001, 1.580928e-001, 1.581119e-001, 1.581310e-001, 1.581502e-001, 1.581693e-001, 1.581884e-001, 1.582076e-001, 1.582267e-001, 1.582458e-001, 1.582650e-001, 1.582841e-001, 1.583032e-001, 1.583223e-001, 1.583414e-001, 1.583606e-001, 1.583797e-001, 1.583988e-001, 1.584179e-001, 1.584370e-001, 1.584561e-001, 1.584752e-001, 1.584943e-001, 1.585134e-001, 1.585325e-001, 1.585516e-001, 1.585707e-001, 1.585898e-001, 1.586089e-001, 1.586280e-001, 1.586471e-001, 1.586662e-001, 1.586853e-001, 1.587043e-001, 1.587234e-001, 1.587425e-001, 1.587616e-001, 1.587807e-001, 1.587997e-001, 1.588188e-001, 1.588379e-001, 1.588570e-001, 1.588760e-001, 1.588951e-001, 1.589141e-001, 1.589332e-001, 1.589523e-001, 1.589713e-001, 1.589904e-001, 1.590094e-001, 1.590285e-001, 1.590475e-001, 1.590666e-001, 1.590856e-001, 1.591047e-001, 1.591237e-001, 1.591428e-001, 1.591618e-001, 1.591808e-001, 1.591999e-001, 1.592189e-001, 1.592379e-001, 1.592570e-001, 1.592760e-001, 1.592950e-001, 1.593141e-001, 1.593331e-001, 1.593521e-001, 1.593711e-001, 1.593901e-001, 1.594092e-001, 1.594282e-001, 1.594472e-001, 1.594662e-001, 1.594852e-001, 1.595042e-001, 
1.595232e-001, 1.595422e-001, 1.595612e-001, 1.595802e-001, 1.595992e-001, 1.596182e-001, 1.596372e-001, 1.596562e-001, 1.596752e-001, 1.596942e-001, 1.597132e-001, 1.597322e-001, 1.597511e-001, 1.597701e-001, 1.597891e-001, 1.598081e-001, 1.598271e-001, 1.598460e-001, 1.598650e-001, 1.598840e-001, 1.599029e-001, 1.599219e-001, 1.599409e-001, 1.599598e-001, 1.599788e-001, 1.599978e-001, 1.600167e-001, 1.600357e-001, 1.600546e-001, 1.600736e-001, 1.600925e-001, 1.601115e-001, 1.601304e-001, 1.601494e-001, 1.601683e-001, 1.601873e-001, 1.602062e-001, 1.602251e-001, 1.602441e-001, 1.602630e-001, 1.602819e-001, 1.603009e-001, 1.603198e-001, 1.603387e-001, 1.603576e-001, 1.603766e-001, 1.603955e-001, 1.604144e-001, 1.604333e-001, 1.604522e-001, 1.604712e-001, 1.604901e-001, 1.605090e-001, 1.605279e-001, 1.605468e-001, 1.605657e-001, 1.605846e-001, 1.606035e-001, 1.606224e-001, 1.606413e-001, 1.606602e-001, 1.606791e-001, 1.606980e-001, 1.607169e-001, 1.607358e-001, 1.607547e-001, 1.607735e-001, 1.607924e-001, 1.608113e-001, 1.608302e-001, 1.608491e-001, 1.608680e-001, 1.608868e-001, 1.609057e-001, 1.609246e-001, 1.609434e-001, 1.609623e-001, 1.609812e-001, 1.610000e-001, 1.610189e-001, 1.610378e-001, 1.610566e-001, 1.610755e-001, 1.610943e-001, 1.611132e-001, 1.611320e-001, 1.611509e-001, 1.611697e-001, 1.611886e-001, 1.612074e-001, 1.612263e-001, 1.612451e-001, 1.612640e-001, 1.612828e-001, 1.613016e-001, 1.613205e-001, 1.613393e-001, 1.613581e-001, 1.613769e-001, 1.613958e-001, 
1.614146e-001, 1.614334e-001, 1.614522e-001, 1.614711e-001, 1.614899e-001, 1.615087e-001, 1.615275e-001, 1.615463e-001, 1.615651e-001, 1.615839e-001, 1.616028e-001, 1.616216e-001, 1.616404e-001, 1.616592e-001, 1.616780e-001, 1.616968e-001, 1.617156e-001, 1.617344e-001, 1.617531e-001, 1.617719e-001, 1.617907e-001, 1.618095e-001, 1.618283e-001, 1.618471e-001, 1.618659e-001, 1.618846e-001, 1.619034e-001, 1.619222e-001, 1.619410e-001, 1.619597e-001, 1.619785e-001, 1.619973e-001, 1.620161e-001, 1.620348e-001, 1.620536e-001, 1.620724e-001, 1.620911e-001, 1.621099e-001, 1.621286e-001, 1.621474e-001, 1.621661e-001, 1.621849e-001, 1.622036e-001, 1.622224e-001, 1.622411e-001, 1.622599e-001, 1.622786e-001, 1.622974e-001, 1.623161e-001, 1.623348e-001, 1.623536e-001, 1.623723e-001, 1.623910e-001, 1.624098e-001, 1.624285e-001, 1.624472e-001, 1.624660e-001, 1.624847e-001, 1.625034e-001, 1.625221e-001, 1.625408e-001, 1.625596e-001, 1.625783e-001, 1.625970e-001, 1.626157e-001, 1.626344e-001, 1.626531e-001, 1.626718e-001, 1.626905e-001, 1.627092e-001, 1.627279e-001, 1.627466e-001, 1.627653e-001, 1.627840e-001, 1.628027e-001, 1.628214e-001, 1.628401e-001, 1.628588e-001, 1.628775e-001, 1.628962e-001, 1.629148e-001, 1.629335e-001, 1.629522e-001, 1.629709e-001, 1.629896e-001, 1.630082e-001, 1.630269e-001, 1.630456e-001, 1.630642e-001, 1.630829e-001, 1.631016e-001, 1.631202e-001, 1.631389e-001, 1.631576e-001, 1.631762e-001, 1.631949e-001, 1.632135e-001, 1.632322e-001, 1.632508e-001, 1.632695e-001, 
1.632881e-001, 1.633068e-001, 1.633254e-001, 1.633441e-001, 1.633627e-001, 1.633813e-001, 1.634000e-001, 1.634186e-001, 1.634372e-001, 1.634559e-001, 1.634745e-001, 1.634931e-001, 1.635118e-001, 1.635304e-001, 1.635490e-001, 1.635676e-001, 1.635863e-001, 1.636049e-001, 1.636235e-001, 1.636421e-001, 1.636607e-001, 1.636793e-001, 1.636979e-001, 1.637165e-001, 1.637352e-001, 1.637538e-001, 1.637724e-001, 1.637910e-001, 1.638096e-001, 1.638282e-001, 1.638468e-001, 1.638653e-001, 1.638839e-001, 1.639025e-001, 1.639211e-001, 1.639397e-001, 1.639583e-001, 1.639769e-001, 1.639955e-001, 1.640140e-001, 1.640326e-001, 1.640512e-001, 1.640698e-001, 1.640883e-001, 1.641069e-001, 1.641255e-001, 1.641440e-001, 1.641626e-001, 1.641812e-001, 1.641997e-001, 1.642183e-001, 1.642369e-001, 1.642554e-001, 1.642740e-001, 1.642925e-001, 1.643111e-001, 1.643296e-001, 1.643482e-001, 1.643667e-001, 1.643853e-001, 1.644038e-001, 1.644223e-001, 1.644409e-001, 1.644594e-001, 1.644780e-001, 1.644965e-001, 1.645150e-001, 1.645336e-001, 1.645521e-001, 1.645706e-001, 1.645891e-001, 1.646077e-001, 1.646262e-001, 1.646447e-001, 1.646632e-001, 1.646817e-001, 1.647003e-001, 1.647188e-001, 1.647373e-001, 1.647558e-001, 1.647743e-001, 1.647928e-001, 1.648113e-001, 1.648298e-001, 1.648483e-001, 1.648668e-001, 1.648853e-001, 1.649038e-001, 1.649223e-001, 1.649408e-001, 1.649593e-001, 1.649778e-001, 1.649963e-001, 1.650148e-001, 1.650332e-001, 1.650517e-001, 1.650702e-001, 1.650887e-001, 1.651072e-001, 1.651256e-001, 
1.651441e-001, 1.651626e-001, 1.651811e-001, 1.651995e-001, 1.652180e-001, 1.652365e-001, 1.652549e-001, 1.652734e-001, 1.652918e-001, 1.653103e-001, 1.653288e-001, 1.653472e-001, 1.653657e-001, 1.653841e-001, 1.654026e-001, 1.654210e-001, 1.654395e-001, 1.654579e-001, 1.654763e-001, 1.654948e-001, 1.655132e-001, 1.655317e-001, 1.655501e-001, 1.655685e-001, 1.655870e-001, 1.656054e-001, 1.656238e-001, 1.656423e-001, 1.656607e-001, 1.656791e-001, 1.656975e-001, 1.657160e-001, 1.657344e-001, 1.657528e-001, 1.657712e-001, 1.657896e-001, 1.658080e-001, 1.658264e-001, 1.658448e-001, 1.658633e-001, 1.658817e-001, 1.659001e-001, 1.659185e-001, 1.659369e-001, 1.659553e-001, 1.659737e-001, 1.659921e-001, 1.660104e-001, 1.660288e-001, 1.660472e-001, 1.660656e-001, 1.660840e-001, 1.661024e-001, 1.661208e-001, 1.661392e-001, 1.661575e-001, 1.661759e-001, 1.661943e-001, 1.662127e-001, 1.662310e-001, 1.662494e-001, 1.662678e-001, 1.662861e-001, 1.663045e-001, 1.663229e-001, 1.663412e-001, 1.663596e-001, 1.663780e-001, 1.663963e-001, 1.664147e-001, 1.664330e-001, 1.664514e-001, 1.664697e-001, 1.664881e-001, 1.665064e-001, 1.665248e-001, 1.665431e-001, 1.665615e-001, 1.665798e-001, 1.665981e-001, 1.666165e-001, 1.666348e-001, 1.666531e-001, 1.666715e-001, 1.666898e-001, 1.667081e-001, 1.667265e-001, 1.667448e-001, 1.667631e-001, 1.667814e-001, 1.667997e-001, 1.668181e-001, 1.668364e-001, 1.668547e-001, 1.668730e-001, 1.668913e-001, 1.669096e-001, 1.669279e-001, 1.669462e-001, 1.669645e-001, 
1.669829e-001, 1.670012e-001, 1.670195e-001, 1.670378e-001, 1.670560e-001, 1.670743e-001, 1.670926e-001, 1.671109e-001, 1.671292e-001, 1.671475e-001, 1.671658e-001, 1.671841e-001, 1.672024e-001, 1.672206e-001, 1.672389e-001, 1.672572e-001, 1.672755e-001, 1.672937e-001, 1.673120e-001, 1.673303e-001, 1.673486e-001, 1.673668e-001, 1.673851e-001, 1.674034e-001, 1.674216e-001, 1.674399e-001, 1.674581e-001, 1.674764e-001, 1.674946e-001, 1.675129e-001, 1.675312e-001, 1.675494e-001, 1.675677e-001, 1.675859e-001, 1.676041e-001, 1.676224e-001, 1.676406e-001, 1.676589e-001, 1.676771e-001, 1.676954e-001, 1.677136e-001, 1.677318e-001, 1.677501e-001, 1.677683e-001, 1.677865e-001, 1.678047e-001, 1.678230e-001, 1.678412e-001, 1.678594e-001, 1.678776e-001, 1.678958e-001, 1.679141e-001, 1.679323e-001, 1.679505e-001, 1.679687e-001, 1.679869e-001, 1.680051e-001, 1.680233e-001, 1.680415e-001, 1.680597e-001, 1.680779e-001, 1.680961e-001, 1.681143e-001, 1.681325e-001, 1.681507e-001, 1.681689e-001, 1.681871e-001, 1.682053e-001, 1.682235e-001, 1.682417e-001, 1.682599e-001, 1.682781e-001, 1.682962e-001, 1.683144e-001, 1.683326e-001, 1.683508e-001, 1.683689e-001, 1.683871e-001, 1.684053e-001, 1.684235e-001, 1.684416e-001, 1.684598e-001, 1.684780e-001, 1.684961e-001, 1.685143e-001, 1.685324e-001, 1.685506e-001, 1.685688e-001, 1.685869e-001, 1.686051e-001, 1.686232e-001, 1.686414e-001, 1.686595e-001, 1.686777e-001, 1.686958e-001, 1.687140e-001, 1.687321e-001, 1.687502e-001, 1.687684e-001, 1.687865e-001, 
1.688046e-001, 1.688228e-001, 1.688409e-001, 1.688590e-001, 1.688772e-001, 1.688953e-001, 1.689134e-001, 1.689315e-001, 1.689497e-001, 1.689678e-001, 1.689859e-001, 1.690040e-001, 1.690221e-001, 1.690402e-001, 1.690584e-001, 1.690765e-001, 1.690946e-001, 1.691127e-001, 1.691308e-001, 1.691489e-001, 1.691670e-001, 1.691851e-001, 1.692032e-001, 1.692213e-001, 1.692394e-001, 1.692575e-001, 1.692756e-001, 1.692937e-001, 1.693117e-001, 1.693298e-001, 1.693479e-001, 1.693660e-001, 1.693841e-001, 1.694022e-001, 1.694202e-001, 1.694383e-001, 1.694564e-001, 1.694745e-001, 1.694925e-001, 1.695106e-001, 1.695287e-001, 1.695467e-001, 1.695648e-001, 1.695829e-001, 1.696009e-001, 1.696190e-001, 1.696371e-001, 1.696551e-001, 1.696732e-001, 1.696912e-001, 1.697093e-001, 1.697273e-001, 1.697454e-001, 1.697634e-001, 1.697815e-001, 1.697995e-001, 1.698175e-001, 1.698356e-001, 1.698536e-001, 1.698717e-001, 1.698897e-001, 1.699077e-001, 1.699258e-001, 1.699438e-001, 1.699618e-001, 1.699799e-001, 1.699979e-001, 1.700159e-001, 1.700339e-001, 1.700519e-001, 1.700700e-001, 1.700880e-001, 1.701060e-001, 1.701240e-001, 1.701420e-001, 1.701600e-001, 1.701780e-001, 1.701960e-001, 1.702141e-001, 1.702321e-001, 1.702501e-001, 1.702681e-001, 1.702861e-001, 1.703041e-001, 1.703221e-001, 1.703400e-001, 1.703580e-001, 1.703760e-001, 1.703940e-001, 1.704120e-001, 1.704300e-001, 1.704480e-001, 1.704660e-001, 1.704839e-001, 1.705019e-001, 1.705199e-001, 1.705379e-001, 1.705559e-001, 1.705738e-001, 1.705918e-001, 
1.706098e-001, 1.706277e-001, 1.706457e-001, 1.706637e-001, 1.706816e-001, 1.706996e-001, 1.707175e-001, 1.707355e-001, 1.707535e-001, 1.707714e-001, 1.707894e-001, 1.708073e-001, 1.708253e-001, 1.708432e-001, 1.708612e-001, 1.708791e-001, 1.708971e-001, 1.709150e-001, 1.709329e-001, 1.709509e-001, 1.709688e-001, 1.709868e-001, 1.710047e-001, 1.710226e-001, 1.710405e-001, 1.710585e-001, 1.710764e-001, 1.710943e-001, 1.711123e-001, 1.711302e-001, 1.711481e-001, 1.711660e-001, 1.711839e-001, 1.712018e-001, 1.712198e-001, 1.712377e-001, 1.712556e-001, 1.712735e-001, 1.712914e-001, 1.713093e-001, 1.713272e-001, 1.713451e-001, 1.713630e-001, 1.713809e-001, 1.713988e-001, 1.714167e-001, 1.714346e-001, 1.714525e-001, 1.714704e-001, 1.714883e-001, 1.715062e-001, 1.715240e-001, 1.715419e-001, 1.715598e-001, 1.715777e-001, 1.715956e-001, 1.716135e-001, 1.716313e-001, 1.716492e-001, 1.716671e-001, 1.716850e-001, 1.717028e-001, 1.717207e-001, 1.717386e-001, 1.717564e-001, 1.717743e-001, 1.717922e-001, 1.718100e-001, 1.718279e-001, 1.718457e-001, 1.718636e-001, 1.718814e-001, 1.718993e-001, 1.719171e-001, 1.719350e-001, 1.719528e-001, 1.719707e-001, 1.719885e-001, 1.720064e-001, 1.720242e-001, 1.720420e-001, 1.720599e-001, 1.720777e-001, 1.720956e-001, 1.721134e-001, 1.721312e-001, 1.721491e-001, 1.721669e-001, 1.721847e-001, 1.722025e-001, 1.722204e-001, 1.722382e-001, 1.722560e-001, 1.722738e-001, 1.722916e-001, 1.723094e-001, 1.723273e-001, 1.723451e-001, 1.723629e-001, 1.723807e-001, 
1.723985e-001, 1.724163e-001, 1.724341e-001, 1.724519e-001, 1.724697e-001, 1.724875e-001, 1.725053e-001, 1.725231e-001, 1.725409e-001, 1.725587e-001, 1.725765e-001, 1.725943e-001, 1.726121e-001, 1.726298e-001, 1.726476e-001, 1.726654e-001, 1.726832e-001, 1.727010e-001, 1.727187e-001, 1.727365e-001, 1.727543e-001, 1.727721e-001, 1.727898e-001, 1.728076e-001, 1.728254e-001, 1.728431e-001, 1.728609e-001, 1.728787e-001, 1.728964e-001, 1.729142e-001, 1.729320e-001, 1.729497e-001, 1.729675e-001, 1.729852e-001, 1.730030e-001, 1.730207e-001, 1.730385e-001, 1.730562e-001, 1.730740e-001, 1.730917e-001, 1.731095e-001, 1.731272e-001, 1.731449e-001, 1.731627e-001, 1.731804e-001, 1.731981e-001, 1.732159e-001, 1.732336e-001, 1.732513e-001, 1.732691e-001, 1.732868e-001, 1.733045e-001, 1.733222e-001, 1.733400e-001, 1.733577e-001, 1.733754e-001, 1.733931e-001, 1.734108e-001, 1.734286e-001, 1.734463e-001, 1.734640e-001, 1.734817e-001, 1.734994e-001, 1.735171e-001, 1.735348e-001, 1.735525e-001, 1.735702e-001, 1.735879e-001, 1.736056e-001, 1.736233e-001, 1.736410e-001, 1.736587e-001, 1.736764e-001, 1.736941e-001, 1.737118e-001, 1.737294e-001, 1.737471e-001, 1.737648e-001, 1.737825e-001, 1.738002e-001, 1.738179e-001, 1.738355e-001, 1.738532e-001, 1.738709e-001, 1.738886e-001, 1.739062e-001, 1.739239e-001, 1.739416e-001, 1.739592e-001, 1.739769e-001, 1.739946e-001, 1.740122e-001, 1.740299e-001, 1.740475e-001, 1.740652e-001, 1.740828e-001, 1.741005e-001, 1.741181e-001, 1.741358e-001, 1.741534e-001, 
1.741711e-001, 1.741887e-001, 1.742064e-001, 1.742240e-001, 1.742417e-001, 1.742593e-001, 1.742769e-001, 1.742946e-001, 1.743122e-001, 1.743298e-001, 1.743475e-001, 1.743651e-001, 1.743827e-001, 1.744004e-001, 1.744180e-001, 1.744356e-001, 1.744532e-001, 1.744709e-001, 1.744885e-001, 1.745061e-001, 1.745237e-001, 1.745413e-001, 1.745589e-001, 1.745765e-001, 1.745941e-001, 1.746118e-001, 1.746294e-001, 1.746470e-001, 1.746646e-001, 1.746822e-001, 1.746998e-001, 1.747174e-001, 1.747350e-001, 1.747526e-001, 1.747701e-001, 1.747877e-001, 1.748053e-001, 1.748229e-001, 1.748405e-001, 1.748581e-001, 1.748757e-001, 1.748933e-001, 1.749108e-001, 1.749284e-001, 1.749460e-001, 1.749636e-001, 1.749811e-001, 1.749987e-001, 1.750163e-001, 1.750339e-001, 1.750514e-001, 1.750690e-001, 1.750866e-001, 1.751041e-001, 1.751217e-001, 1.751392e-001, 1.751568e-001, 1.751744e-001, 1.751919e-001, 1.752095e-001, 1.752270e-001, 1.752446e-001, 1.752621e-001, 1.752797e-001, 1.752972e-001, 1.753148e-001, 1.753323e-001, 1.753498e-001, 1.753674e-001, 1.753849e-001, 1.754025e-001, 1.754200e-001, 1.754375e-001, 1.754551e-001, 1.754726e-001, 1.754901e-001, 1.755076e-001, 1.755252e-001, 1.755427e-001, 1.755602e-001, 1.755777e-001, 1.755953e-001, 1.756128e-001, 1.756303e-001, 1.756478e-001, 1.756653e-001, 1.756828e-001, 1.757003e-001, 1.757178e-001, 1.757353e-001, 1.757529e-001, 1.757704e-001, 1.757879e-001, 1.758054e-001, 1.758229e-001, 1.758404e-001, 1.758579e-001, 1.758753e-001, 1.758928e-001, 1.759103e-001, 
1.759278e-001, 1.759453e-001, 1.759628e-001, 1.759803e-001, 1.759978e-001, 1.760152e-001, 1.760327e-001, 1.760502e-001, 1.760677e-001, 1.760852e-001, 1.761026e-001, 1.761201e-001, 1.761376e-001, 1.761550e-001, 1.761725e-001, 1.761900e-001, 1.762074e-001, 1.762249e-001, 1.762424e-001, 1.762598e-001, 1.762773e-001, 1.762947e-001, 1.763122e-001, 1.763296e-001, 1.763471e-001, 1.763646e-001, 1.763820e-001, 1.763994e-001, 1.764169e-001, 1.764343e-001, 1.764518e-001, 1.764692e-001, 1.764867e-001, 1.765041e-001, 1.765215e-001, 1.765390e-001, 1.765564e-001, 1.765738e-001, 1.765913e-001, 1.766087e-001, 1.766261e-001, 1.766435e-001, 1.766610e-001, 1.766784e-001, 1.766958e-001, 1.767132e-001, 1.767307e-001, 1.767481e-001, 1.767655e-001, 1.767829e-001, 1.768003e-001, 1.768177e-001, 1.768351e-001, 1.768525e-001, 1.768699e-001, 1.768873e-001, 1.769047e-001, 1.769221e-001, 1.769395e-001, 1.769569e-001, 1.769743e-001, 1.769917e-001, 1.770091e-001, 1.770265e-001, 1.770439e-001, 1.770613e-001, 1.770787e-001, 1.770961e-001, 1.771135e-001, 1.771308e-001, 1.771482e-001, 1.771656e-001, 1.771830e-001, 1.772003e-001, 1.772177e-001, 1.772351e-001, 1.772525e-001, 1.772698e-001, 1.772872e-001, 1.773046e-001, 1.773219e-001, 1.773393e-001, 1.773567e-001, 1.773740e-001, 1.773914e-001, 1.774087e-001, 1.774261e-001, 1.774435e-001, 1.774608e-001, 1.774782e-001, 1.774955e-001, 1.775129e-001, 1.775302e-001, 1.775475e-001, 1.775649e-001, 1.775822e-001, 1.775996e-001, 1.776169e-001, 1.776343e-001, 1.776516e-001, 
1.776689e-001, 1.776863e-001, 1.777036e-001, 1.777209e-001, 1.777382e-001, 1.777556e-001, 1.777729e-001, 1.777902e-001, 1.778075e-001, 1.778249e-001, 1.778422e-001, 1.778595e-001, 1.778768e-001, 1.778941e-001, 1.779114e-001, 1.779288e-001, 1.779461e-001, 1.779634e-001, 1.779807e-001, 1.779980e-001, 1.780153e-001, 1.780326e-001, 1.780499e-001, 1.780672e-001, 1.780845e-001, 1.781018e-001, 1.781191e-001, 1.781364e-001, 1.781537e-001, 1.781710e-001, 1.781882e-001, 1.782055e-001, 1.782228e-001, 1.782401e-001, 1.782574e-001, 1.782747e-001, 1.782919e-001, 1.783092e-001, 1.783265e-001, 1.783438e-001, 1.783610e-001, 1.783783e-001, 1.783956e-001, 1.784128e-001, 1.784301e-001, 1.784474e-001, 1.784646e-001, 1.784819e-001, 1.784992e-001, 1.785164e-001, 1.785337e-001, 1.785509e-001, 1.785682e-001, 1.785855e-001, 1.786027e-001, 1.786200e-001, 1.786372e-001, 1.786544e-001, 1.786717e-001, 1.786889e-001, 1.787062e-001, 1.787234e-001, 1.787407e-001, 1.787579e-001, 1.787751e-001, 1.787924e-001, 1.788096e-001, 1.788268e-001, 1.788441e-001, 1.788613e-001, 1.788785e-001, 1.788957e-001, 1.789130e-001, 1.789302e-001, 1.789474e-001, 1.789646e-001, 1.789819e-001, 1.789991e-001, 1.790163e-001, 1.790335e-001, 1.790507e-001, 1.790679e-001, 1.790851e-001, 1.791023e-001, 1.791195e-001, 1.791367e-001, 1.791540e-001, 1.791712e-001, 1.791884e-001, 1.792056e-001, 1.792227e-001, 1.792399e-001, 1.792571e-001, 1.792743e-001, 1.792915e-001, 1.793087e-001, 1.793259e-001, 1.793431e-001, 1.793603e-001, 1.793775e-001, 
1.793946e-001, 1.794118e-001, 1.794290e-001, 1.794462e-001, 1.794633e-001, 1.794805e-001, 1.794977e-001, 1.795149e-001, 1.795320e-001, 1.795492e-001, 1.795664e-001, 1.795835e-001, 1.796007e-001, 1.796179e-001, 1.796350e-001, 1.796522e-001, 1.796693e-001, 1.796865e-001, 1.797036e-001, 1.797208e-001, 1.797380e-001, 1.797551e-001, 1.797723e-001, 1.797894e-001, 1.798065e-001, 1.798237e-001, 1.798408e-001, 1.798580e-001, 1.798751e-001, 1.798922e-001, 1.799094e-001, 1.799265e-001, 1.799437e-001, 1.799608e-001, 1.799779e-001, 1.799950e-001, 1.800122e-001, 1.800293e-001, 1.800464e-001, 1.800635e-001, 1.800807e-001, 1.800978e-001, 1.801149e-001, 1.801320e-001, 1.801491e-001, 1.801663e-001, 1.801834e-001, 1.802005e-001, 1.802176e-001, 1.802347e-001, 1.802518e-001, 1.802689e-001, 1.802860e-001, 1.803031e-001, 1.803202e-001, 1.803373e-001, 1.803544e-001, 1.803715e-001, 1.803886e-001, 1.804057e-001, 1.804228e-001, 1.804399e-001, 1.804570e-001, 1.804740e-001, 1.804911e-001, 1.805082e-001, 1.805253e-001, 1.805424e-001, 1.805595e-001, 1.805765e-001, 1.805936e-001, 1.806107e-001, 1.806278e-001, 1.806448e-001, 1.806619e-001, 1.806790e-001, 1.806960e-001, 1.807131e-001, 1.807302e-001, 1.807472e-001, 1.807643e-001, 1.807813e-001, 1.807984e-001, 1.808155e-001, 1.808325e-001, 1.808496e-001, 1.808666e-001, 1.808837e-001, 1.809007e-001, 1.809178e-001, 1.809348e-001, 1.809519e-001, 1.809689e-001, 1.809859e-001, 1.810030e-001, 1.810200e-001, 1.810371e-001, 1.810541e-001, 1.810711e-001, 1.810882e-001, 
1.811052e-001, 1.811222e-001, 1.811393e-001, 1.811563e-001, 1.811733e-001, 1.811903e-001, 1.812074e-001, 1.812244e-001, 1.812414e-001, 1.812584e-001, 1.812754e-001, 1.812924e-001, 1.813095e-001, 1.813265e-001, 1.813435e-001, 1.813605e-001, 1.813775e-001, 1.813945e-001, 1.814115e-001, 1.814285e-001, 1.814455e-001, 1.814625e-001, 1.814795e-001, 1.814965e-001, 1.815135e-001, 1.815305e-001, 1.815475e-001, 1.815645e-001, 1.815815e-001, 1.815985e-001, 1.816154e-001, 1.816324e-001, 1.816494e-001, 1.816664e-001, 1.816834e-001, 1.817004e-001, 1.817173e-001, 1.817343e-001, 1.817513e-001, 1.817683e-001, 1.817852e-001, 1.818022e-001, 1.818192e-001, 1.818361e-001, 1.818531e-001, 1.818701e-001, 1.818870e-001, 1.819040e-001, 1.819210e-001, 1.819379e-001, 1.819549e-001, 1.819718e-001, 1.819888e-001, 1.820057e-001, 1.820227e-001, 1.820396e-001, 1.820566e-001, 1.820735e-001, 1.820905e-001, 1.821074e-001, 1.821244e-001, 1.821413e-001, 1.821582e-001, 1.821752e-001, 1.821921e-001, 1.822090e-001, 1.822260e-001, 1.822429e-001, 1.822598e-001, 1.822768e-001, 1.822937e-001, 1.823106e-001, 1.823275e-001, 1.823445e-001, 1.823614e-001, 1.823783e-001, 1.823952e-001, 1.824121e-001, 1.824291e-001, 1.824460e-001, 1.824629e-001, 1.824798e-001, 1.824967e-001, 1.825136e-001, 1.825305e-001, 1.825474e-001, 1.825643e-001, 1.825812e-001, 1.825981e-001, 1.826150e-001, 1.826319e-001, 1.826488e-001, 1.826657e-001, 1.826826e-001, 1.826995e-001, 1.827164e-001, 1.827333e-001, 1.827502e-001, 1.827671e-001, 1.827840e-001, 
1.828008e-001, 1.828177e-001, 1.828346e-001, 1.828515e-001, 1.828684e-001, 1.828852e-001, 1.829021e-001, 1.829190e-001, 1.829358e-001, 1.829527e-001, 1.829696e-001, 1.829865e-001, 1.830033e-001, 1.830202e-001, 1.830370e-001, 1.830539e-001, 1.830708e-001, 1.830876e-001, 1.831045e-001, 1.831213e-001, 1.831382e-001, 1.831550e-001, 1.831719e-001, 1.831887e-001, 1.832056e-001, 1.832224e-001, 1.832393e-001, 1.832561e-001, 1.832730e-001, 1.832898e-001, 1.833066e-001, 1.833235e-001, 1.833403e-001, 1.833572e-001, 1.833740e-001, 1.833908e-001, 1.834077e-001, 1.834245e-001, 1.834413e-001, 1.834581e-001, 1.834750e-001, 1.834918e-001, 1.835086e-001, 1.835254e-001, 1.835422e-001, 1.835591e-001, 1.835759e-001, 1.835927e-001, 1.836095e-001, 1.836263e-001, 1.836431e-001, 1.836599e-001, 1.836767e-001, 1.836935e-001, 1.837104e-001, 1.837272e-001, 1.837440e-001, 1.837608e-001, 1.837776e-001, 1.837943e-001, 1.838111e-001, 1.838279e-001, 1.838447e-001, 1.838615e-001, 1.838783e-001, 1.838951e-001, 1.839119e-001, 1.839287e-001, 1.839455e-001, 1.839622e-001, 1.839790e-001, 1.839958e-001, 1.840126e-001, 1.840294e-001, 1.840461e-001, 1.840629e-001, 1.840797e-001, 1.840964e-001, 1.841132e-001, 1.841300e-001, 1.841467e-001, 1.841635e-001, 1.841803e-001, 1.841970e-001, 1.842138e-001, 1.842306e-001, 1.842473e-001, 1.842641e-001, 1.842808e-001, 1.842976e-001, 1.843143e-001, 1.843311e-001, 1.843478e-001, 1.843646e-001, 1.843813e-001, 1.843981e-001, 1.844148e-001, 1.844315e-001, 1.844483e-001, 1.844650e-001, 
1.844818e-001, 1.844985e-001, 1.845152e-001, 1.845320e-001, 1.845487e-001, 1.845654e-001, 1.845822e-001, 1.845989e-001, 1.846156e-001, 1.846323e-001, 1.846491e-001, 1.846658e-001, 1.846825e-001, 1.846992e-001, 1.847159e-001, 1.847326e-001, 1.847494e-001, 1.847661e-001, 1.847828e-001, 1.847995e-001, 1.848162e-001, 1.848329e-001, 1.848496e-001, 1.848663e-001, 1.848830e-001, 1.848997e-001, 1.849164e-001, 1.849331e-001, 1.849498e-001, 1.849665e-001, 1.849832e-001, 1.849999e-001, 1.850166e-001, 1.850333e-001, 1.850500e-001, 1.850667e-001, 1.850833e-001, 1.851000e-001, 1.851167e-001, 1.851334e-001, 1.851501e-001, 1.851667e-001, 1.851834e-001, 1.852001e-001, 1.852168e-001, 1.852334e-001, 1.852501e-001, 1.852668e-001, 1.852835e-001, 1.853001e-001, 1.853168e-001, 1.853334e-001, 1.853501e-001, 1.853668e-001, 1.853834e-001, 1.854001e-001, 1.854167e-001, 1.854334e-001, 1.854501e-001, 1.854667e-001, 1.854834e-001, 1.855000e-001, 1.855167e-001, 1.855333e-001, 1.855499e-001, 1.855666e-001, 1.855832e-001, 1.855999e-001, 1.856165e-001, 1.856331e-001, 1.856498e-001, 1.856664e-001, 1.856830e-001, 1.856997e-001, 1.857163e-001, 1.857329e-001, 1.857496e-001, 1.857662e-001, 1.857828e-001, 1.857994e-001, 1.858161e-001, 1.858327e-001, 1.858493e-001, 1.858659e-001, 1.858825e-001, 1.858992e-001, 1.859158e-001, 1.859324e-001, 1.859490e-001, 1.859656e-001, 1.859822e-001, 1.859988e-001, 1.860154e-001, 1.860320e-001, 1.860486e-001, 1.860652e-001, 1.860818e-001, 1.860984e-001, 1.861150e-001, 1.861316e-001, 
1.861482e-001, 1.861648e-001, 1.861814e-001, 1.861980e-001, 1.862146e-001, 1.862311e-001, 1.862477e-001, 1.862643e-001, 1.862809e-001, 1.862975e-001, 1.863141e-001, 1.863306e-001, 1.863472e-001, 1.863638e-001, 1.863804e-001, 1.863969e-001, 1.864135e-001, 1.864301e-001, 1.864466e-001, 1.864632e-001, 1.864798e-001, 1.864963e-001, 1.865129e-001, 1.865295e-001, 1.865460e-001, 1.865626e-001, 1.865791e-001, 1.865957e-001, 1.866122e-001, 1.866288e-001, 1.866453e-001, 1.866619e-001, 1.866784e-001, 1.866950e-001, 1.867115e-001, 1.867281e-001, 1.867446e-001, 1.867612e-001, 1.867777e-001, 1.867942e-001, 1.868108e-001, 1.868273e-001, 1.868438e-001, 1.868604e-001, 1.868769e-001, 1.868934e-001, 1.869100e-001, 1.869265e-001, 1.869430e-001, 1.869595e-001, 1.869761e-001, 1.869926e-001, 1.870091e-001, 1.870256e-001, 1.870421e-001, 1.870586e-001, 1.870752e-001, 1.870917e-001, 1.871082e-001, 1.871247e-001, 1.871412e-001, 1.871577e-001, 1.871742e-001, 1.871907e-001, 1.872072e-001, 1.872237e-001, 1.872402e-001, 1.872567e-001, 1.872732e-001, 1.872897e-001, 1.873062e-001, 1.873227e-001, 1.873392e-001, 1.873557e-001, 1.873722e-001, 1.873886e-001, 1.874051e-001, 1.874216e-001, 1.874381e-001, 1.874546e-001, 1.874711e-001, 1.874875e-001, 1.875040e-001, 1.875205e-001, 1.875370e-001, 1.875534e-001, 1.875699e-001, 1.875864e-001, 1.876028e-001, 1.876193e-001, 1.876358e-001, 1.876522e-001, 1.876687e-001, 1.876852e-001, 1.877016e-001, 1.877181e-001, 1.877345e-001, 1.877510e-001, 1.877674e-001, 1.877839e-001, 
1.878004e-001, 1.878168e-001, 1.878333e-001, 1.878497e-001, 1.878661e-001, 1.878826e-001, 1.878990e-001, 1.879155e-001, 1.879319e-001, 1.879484e-001, 1.879648e-001, 1.879812e-001, 1.879977e-001, 1.880141e-001, 1.880305e-001, 1.880470e-001, 1.880634e-001, 1.880798e-001, 1.880962e-001, 1.881127e-001, 1.881291e-001, 1.881455e-001, 1.881619e-001, 1.881783e-001, 1.881948e-001, 1.882112e-001, 1.882276e-001, 1.882440e-001, 1.882604e-001, 1.882768e-001, 1.882932e-001, 1.883097e-001, 1.883261e-001, 1.883425e-001, 1.883589e-001, 1.883753e-001, 1.883917e-001, 1.884081e-001, 1.884245e-001, 1.884409e-001, 1.884573e-001, 1.884737e-001, 1.884900e-001, 1.885064e-001, 1.885228e-001, 1.885392e-001, 1.885556e-001, 1.885720e-001, 1.885884e-001, 1.886048e-001, 1.886211e-001, 1.886375e-001, 1.886539e-001, 1.886703e-001, 1.886866e-001, 1.887030e-001, 1.887194e-001, 1.887358e-001, 1.887521e-001, 1.887685e-001, 1.887849e-001, 1.888012e-001, 1.888176e-001, 1.888340e-001, 1.888503e-001, 1.888667e-001, 1.888830e-001, 1.888994e-001, 1.889158e-001, 1.889321e-001, 1.889485e-001, 1.889648e-001, 1.889812e-001, 1.889975e-001, 1.890139e-001, 1.890302e-001, 1.890466e-001, 1.890629e-001, 1.890792e-001, 1.890956e-001, 1.891119e-001, 1.891283e-001, 1.891446e-001, 1.891609e-001, 1.891773e-001, 1.891936e-001, 1.892099e-001, 1.892263e-001, 1.892426e-001, 1.892589e-001, 1.892752e-001, 1.892916e-001, 1.893079e-001, 1.893242e-001, 1.893405e-001, 1.893568e-001, 1.893732e-001, 1.893895e-001, 1.894058e-001, 1.894221e-001, 
1.894384e-001, 1.894547e-001, 1.894710e-001, 1.894873e-001, 1.895037e-001, 1.895200e-001, 1.895363e-001, 1.895526e-001, 1.895689e-001, 1.895852e-001, 1.896015e-001, 1.896178e-001, 1.896341e-001, 1.896503e-001, 1.896666e-001, 1.896829e-001, 1.896992e-001, 1.897155e-001, 1.897318e-001, 1.897481e-001, 1.897644e-001, 1.897806e-001, 1.897969e-001, 1.898132e-001, 1.898295e-001, 1.898458e-001, 1.898620e-001, 1.898783e-001, 1.898946e-001, 1.899109e-001, 1.899271e-001, 1.899434e-001, 1.899597e-001, 1.899759e-001, 1.899922e-001, 1.900085e-001, 1.900247e-001, 1.900410e-001, 1.900572e-001, 1.900735e-001, 1.900897e-001, 1.901060e-001, 1.901223e-001, 1.901385e-001, 1.901548e-001, 1.901710e-001, 1.901873e-001, 1.902035e-001, 1.902197e-001, 1.902360e-001, 1.902522e-001, 1.902685e-001, 1.902847e-001, 1.903010e-001, 1.903172e-001, 1.903334e-001, 1.903497e-001, 1.903659e-001, 1.903821e-001, 1.903984e-001, 1.904146e-001, 1.904308e-001, 1.904470e-001, 1.904633e-001, 1.904795e-001, 1.904957e-001, 1.905119e-001, 1.905281e-001, 1.905444e-001, 1.905606e-001, 1.905768e-001, 1.905930e-001, 1.906092e-001, 1.906254e-001, 1.906416e-001, 1.906578e-001, 1.906741e-001, 1.906903e-001, 1.907065e-001, 1.907227e-001, 1.907389e-001, 1.907551e-001, 1.907713e-001, 1.907875e-001, 1.908037e-001, 1.908198e-001, 1.908360e-001, 1.908522e-001, 1.908684e-001, 1.908846e-001, 1.909008e-001, 1.909170e-001, 1.909332e-001, 1.909494e-001, 1.909655e-001, 1.909817e-001, 1.909979e-001, 1.910141e-001, 1.910302e-001, 1.910464e-001, 
1.910626e-001, 1.910788e-001, 1.910949e-001, 1.911111e-001, 1.911273e-001, 1.911434e-001, 1.911596e-001, 1.911758e-001, 1.911919e-001, 1.912081e-001, 1.912243e-001, 1.912404e-001, 1.912566e-001, 1.912727e-001, 1.912889e-001, 1.913050e-001, 1.913212e-001, 1.913373e-001, 1.913535e-001, 1.913696e-001, 1.913858e-001, 1.914019e-001, 1.914181e-001, 1.914342e-001, 1.914504e-001, 1.914665e-001, 1.914826e-001, 1.914988e-001, 1.915149e-001, 1.915310e-001, 1.915472e-001, 1.915633e-001, 1.915794e-001, 1.915956e-001, 1.916117e-001, 1.916278e-001, 1.916439e-001, 1.916601e-001, 1.916762e-001, 1.916923e-001, 1.917084e-001, 1.917245e-001, 1.917407e-001, 1.917568e-001, 1.917729e-001, 1.917890e-001, 1.918051e-001, 1.918212e-001, 1.918373e-001, 1.918534e-001, 1.918695e-001, 1.918856e-001, 1.919017e-001, 1.919178e-001, 1.919339e-001, 1.919500e-001, 1.919661e-001, 1.919822e-001, 1.919983e-001, 1.920144e-001, 1.920305e-001, 1.920466e-001, 1.920627e-001, 1.920788e-001, 1.920949e-001, 1.921110e-001, 1.921270e-001, 1.921431e-001, 1.921592e-001, 1.921753e-001, 1.921914e-001, 1.922074e-001, 1.922235e-001, 1.922396e-001, 1.922557e-001, 1.922717e-001, 1.922878e-001, 1.923039e-001, 1.923199e-001, 1.923360e-001, 1.923521e-001, 1.923681e-001, 1.923842e-001, 1.924003e-001, 1.924163e-001, 1.924324e-001, 1.924484e-001, 1.924645e-001, 1.924805e-001, 1.924966e-001, 1.925126e-001, 1.925287e-001, 1.925447e-001, 1.925608e-001, 1.925768e-001, 1.925929e-001, 1.926089e-001, 1.926250e-001, 1.926410e-001, 1.926570e-001, 
1.926731e-001, 1.926891e-001, 1.927051e-001, 1.927212e-001, 1.927372e-001, 1.927532e-001, 1.927693e-001, 1.927853e-001, 1.928013e-001, 1.928174e-001, 1.928334e-001, 1.928494e-001, 1.928654e-001, 1.928814e-001, 1.928975e-001, 1.929135e-001, 1.929295e-001, 1.929455e-001, 1.929615e-001, 1.929775e-001, 1.929935e-001, 1.930096e-001, 1.930256e-001, 1.930416e-001, 1.930576e-001, 1.930736e-001, 1.930896e-001, 1.931056e-001, 1.931216e-001, 1.931376e-001, 1.931536e-001, 1.931696e-001, 1.931856e-001, 1.932016e-001, 1.932175e-001, 1.932335e-001, 1.932495e-001, 1.932655e-001, 1.932815e-001, 1.932975e-001, 1.933135e-001, 1.933295e-001, 1.933454e-001, 1.933614e-001, 1.933774e-001, 1.933934e-001, 1.934093e-001, 1.934253e-001, 1.934413e-001, 1.934573e-001, 1.934732e-001, 1.934892e-001, 1.935052e-001, 1.935211e-001, 1.935371e-001, 1.935531e-001, 1.935690e-001, 1.935850e-001, 1.936009e-001, 1.936169e-001, 1.936329e-001, 1.936488e-001, 1.936648e-001, 1.936807e-001, 1.936967e-001, 1.937126e-001, 1.937286e-001, 1.937445e-001, 1.937605e-001, 1.937764e-001, 1.937924e-001, 1.938083e-001, 1.938242e-001, 1.938402e-001, 1.938561e-001, 1.938721e-001, 1.938880e-001, 1.939039e-001, 1.939199e-001, 1.939358e-001, 1.939517e-001, 1.939676e-001, 1.939836e-001, 1.939995e-001, 1.940154e-001, 1.940313e-001, 1.940473e-001, 1.940632e-001, 1.940791e-001, 1.940950e-001, 1.941109e-001, 1.941269e-001, 1.941428e-001, 1.941587e-001, 1.941746e-001, 1.941905e-001, 1.942064e-001, 1.942223e-001, 1.942382e-001, 1.942541e-001, 
1.942700e-001, 1.942859e-001, 1.943018e-001, 1.943177e-001, 1.943336e-001, 1.943495e-001, 1.943654e-001, 1.943813e-001, 1.943972e-001, 1.944131e-001, 1.944290e-001, 1.944449e-001, 1.944608e-001, 1.944767e-001, 1.944925e-001, 1.945084e-001, 1.945243e-001, 1.945402e-001, 1.945561e-001, 1.945719e-001, 1.945878e-001, 1.946037e-001, 1.946196e-001, 1.946354e-001, 1.946513e-001, 1.946672e-001, 1.946831e-001, 1.946989e-001, 1.947148e-001, 1.947307e-001, 1.947465e-001, 1.947624e-001, 1.947782e-001, 1.947941e-001, 1.948100e-001, 1.948258e-001, 1.948417e-001, 1.948575e-001, 1.948734e-001, 1.948892e-001, 1.949051e-001, 1.949209e-001, 1.949368e-001, 1.949526e-001, 1.949685e-001, 1.949843e-001, 1.950002e-001, 1.950160e-001, 1.950318e-001, 1.950477e-001, 1.950635e-001, 1.950793e-001, 1.950952e-001, 1.951110e-001, 1.951268e-001, 1.951427e-001, 1.951585e-001, 1.951743e-001, 1.951902e-001, 1.952060e-001, 1.952218e-001, 1.952376e-001, 1.952534e-001, 1.952693e-001, 1.952851e-001, 1.953009e-001, 1.953167e-001, 1.953325e-001, 1.953483e-001, 1.953642e-001, 1.953800e-001, 1.953958e-001, 1.954116e-001, 1.954274e-001, 1.954432e-001, 1.954590e-001, 1.954748e-001, 1.954906e-001, 1.955064e-001, 1.955222e-001, 1.955380e-001, 1.955538e-001, 1.955696e-001, 1.955854e-001, 1.956012e-001, 1.956170e-001, 1.956328e-001, 1.956485e-001, 1.956643e-001, 1.956801e-001, 1.956959e-001, 1.957117e-001, 1.957275e-001, 1.957432e-001, 1.957590e-001, 1.957748e-001, 1.957906e-001, 1.958064e-001, 1.958221e-001, 1.958379e-001, 
1.958537e-001, 1.958694e-001, 1.958852e-001, 1.959010e-001, 1.959167e-001, 1.959325e-001, 1.959483e-001, 1.959640e-001, 1.959798e-001, 1.959955e-001, 1.960113e-001, 1.960271e-001, 1.960428e-001, 1.960586e-001, 1.960743e-001, 1.960901e-001, 1.961058e-001, 1.961216e-001, 1.961373e-001, 1.961531e-001, 1.961688e-001, 1.961846e-001, 1.962003e-001, 1.962160e-001, 1.962318e-001, 1.962475e-001, 1.962632e-001, 1.962790e-001, 1.962947e-001, 1.963105e-001, 1.963262e-001, 1.963419e-001, 1.963576e-001, 1.963734e-001, 1.963891e-001, 1.964048e-001, 1.964205e-001, 1.964363e-001, 1.964520e-001, 1.964677e-001, 1.964834e-001, 1.964991e-001, 1.965149e-001, 1.965306e-001, 1.965463e-001, 1.965620e-001, 1.965777e-001, 1.965934e-001, 1.966091e-001, 1.966248e-001, 1.966405e-001, 1.966562e-001, 1.966719e-001, 1.966876e-001, 1.967033e-001, 1.967190e-001, 1.967347e-001, 1.967504e-001, 1.967661e-001, 1.967818e-001, 1.967975e-001, 1.968132e-001, 1.968289e-001, 1.968446e-001, 1.968603e-001, 1.968760e-001, 1.968916e-001, 1.969073e-001, 1.969230e-001, 1.969387e-001, 1.969544e-001, 1.969700e-001, 1.969857e-001, 1.970014e-001, 1.970171e-001, 1.970327e-001, 1.970484e-001, 1.970641e-001, 1.970798e-001, 1.970954e-001, 1.971111e-001, 1.971268e-001, 1.971424e-001, 1.971581e-001, 1.971737e-001, 1.971894e-001, 1.972051e-001, 1.972207e-001, 1.972364e-001, 1.972520e-001, 1.972677e-001, 1.972833e-001, 1.972990e-001, 1.973146e-001, 1.973303e-001, 1.973459e-001, 1.973616e-001, 1.973772e-001, 1.973929e-001, 1.974085e-001, 
1.974241e-001, 1.974398e-001, 1.974554e-001, 1.974711e-001, 1.974867e-001, 1.975023e-001, 1.975180e-001, 1.975336e-001, 1.975492e-001, 1.975648e-001, 1.975805e-001, 1.975961e-001, 1.976117e-001, 1.976273e-001, 1.976430e-001, 1.976586e-001, 1.976742e-001, 1.976898e-001, 1.977054e-001, 1.977211e-001, 1.977367e-001, 1.977523e-001, 1.977679e-001, 1.977835e-001, 1.977991e-001, 1.978147e-001, 1.978303e-001, 1.978459e-001, 1.978615e-001, 1.978771e-001, 1.978927e-001, 1.979083e-001, 1.979239e-001, 1.979395e-001, 1.979551e-001, 1.979707e-001, 1.979863e-001, 1.980019e-001, 1.980175e-001, 1.980331e-001, 1.980487e-001, 1.980643e-001, 1.980799e-001, 1.980954e-001, 1.981110e-001, 1.981266e-001, 1.981422e-001, 1.981578e-001, 1.981733e-001, 1.981889e-001, 1.982045e-001, 1.982201e-001, 1.982356e-001, 1.982512e-001, 1.982668e-001, 1.982824e-001, 1.982979e-001, 1.983135e-001, 1.983291e-001, 1.983446e-001, 1.983602e-001, 1.983757e-001, 1.983913e-001, 1.984069e-001, 1.984224e-001, 1.984380e-001, 1.984535e-001, 1.984691e-001, 1.984846e-001, 1.985002e-001, 1.985157e-001, 1.985313e-001, 1.985468e-001, 1.985624e-001, 1.985779e-001, 1.985935e-001, 1.986090e-001, 1.986245e-001, 1.986401e-001, 1.986556e-001, 1.986712e-001, 1.986867e-001, 1.987022e-001, 1.987178e-001, 1.987333e-001, 1.987488e-001, 1.987644e-001, 1.987799e-001, 1.987954e-001, 1.988109e-001, 1.988265e-001, 1.988420e-001, 1.988575e-001, 1.988730e-001, 1.988885e-001, 1.989041e-001, 1.989196e-001, 1.989351e-001, 1.989506e-001, 1.989661e-001, 
1.989816e-001, 1.989971e-001, 1.990126e-001, 1.990281e-001, 1.990437e-001, 1.990592e-001, 1.990747e-001, 1.990902e-001, 1.991057e-001, 1.991212e-001, 1.991367e-001, 1.991522e-001, 1.991677e-001, 1.991832e-001, 1.991986e-001, 1.992141e-001, 1.992296e-001, 1.992451e-001, 1.992606e-001, 1.992761e-001, 1.992916e-001, 1.993071e-001, 1.993225e-001, 1.993380e-001, 1.993535e-001, 1.993690e-001, 1.993845e-001, 1.993999e-001, 1.994154e-001, 1.994309e-001, 1.994464e-001, 1.994618e-001, 1.994773e-001, 1.994928e-001, 1.995082e-001, 1.995237e-001, 1.995392e-001, 1.995546e-001, 1.995701e-001, 1.995856e-001, 1.996010e-001, 1.996165e-001, 1.996319e-001, 1.996474e-001, 1.996628e-001, 1.996783e-001, 1.996938e-001, 1.997092e-001, 1.997247e-001, 1.997401e-001, 1.997555e-001, 1.997710e-001, 1.997864e-001, 1.998019e-001, 1.998173e-001, 1.998328e-001, 1.998482e-001, 1.998636e-001, 1.998791e-001, 1.998945e-001, 1.999099e-001, 1.999254e-001, 1.999408e-001, 1.999562e-001, 1.999717e-001, 1.999871e-001, 2.000025e-001, 2.000180e-001, 2.000334e-001, 2.000488e-001, 2.000642e-001, 2.000796e-001, 2.000951e-001, 2.001105e-001, 2.001259e-001, 2.001413e-001, 2.001567e-001, 2.001721e-001, 2.001876e-001, 2.002030e-001, 2.002184e-001, 2.002338e-001, 2.002492e-001, 2.002646e-001, 2.002800e-001, 2.002954e-001, 2.003108e-001, 2.003262e-001, 2.003416e-001, 2.003570e-001, 2.003724e-001, 2.003878e-001, 2.004032e-001, 2.004186e-001, 2.004340e-001, 2.004494e-001, 2.004647e-001, 2.004801e-001, 2.004955e-001, 2.005109e-001, 
2.005263e-001, 2.005417e-001, 2.005571e-001, 2.005724e-001, 2.005878e-001, 2.006032e-001, 2.006186e-001, 2.006339e-001, 2.006493e-001, 2.006647e-001, 2.006801e-001, 2.006954e-001, 2.007108e-001, 2.007262e-001, 2.007415e-001, 2.007569e-001, 2.007723e-001, 2.007876e-001, 2.008030e-001, 2.008183e-001, 2.008337e-001, 2.008491e-001, 2.008644e-001, 2.008798e-001, 2.008951e-001, 2.009105e-001, 2.009258e-001, 2.009412e-001, 2.009565e-001, 2.009719e-001, 2.009872e-001, 2.010026e-001, 2.010179e-001, 2.010332e-001, 2.010486e-001, 2.010639e-001, 2.010793e-001, 2.010946e-001, 2.011099e-001, 2.011253e-001, 2.011406e-001, 2.011559e-001, 2.011713e-001, 2.011866e-001, 2.012019e-001, 2.012172e-001, 2.012326e-001, 2.012479e-001, 2.012632e-001, 2.012785e-001, 2.012939e-001, 2.013092e-001, 2.013245e-001, 2.013398e-001, 2.013551e-001, 2.013704e-001, 2.013858e-001, 2.014011e-001, 2.014164e-001, 2.014317e-001, 2.014470e-001, 2.014623e-001, 2.014776e-001, 2.014929e-001, 2.015082e-001, 2.015235e-001, 2.015388e-001, 2.015541e-001, 2.015694e-001, 2.015847e-001, 2.016000e-001, 2.016153e-001, 2.016306e-001, 2.016459e-001, 2.016612e-001, 2.016765e-001, 2.016918e-001, 2.017070e-001, 2.017223e-001, 2.017376e-001, 2.017529e-001, 2.017682e-001, 2.017835e-001, 2.017987e-001, 2.018140e-001, 2.018293e-001, 2.018446e-001, 2.018598e-001, 2.018751e-001, 2.018904e-001, 2.019057e-001, 2.019209e-001, 2.019362e-001, 2.019515e-001, 2.019667e-001, 2.019820e-001, 2.019973e-001, 2.020125e-001, 2.020278e-001, 2.020430e-001, 
2.020583e-001, 2.020735e-001, 2.020888e-001, 2.021041e-001, 2.021193e-001, 2.021346e-001, 2.021498e-001, 2.021651e-001, 2.021803e-001, 2.021956e-001, 2.022108e-001, 2.022260e-001, 2.022413e-001, 2.022565e-001, 2.022718e-001, 2.022870e-001, 2.023022e-001, 2.023175e-001, 2.023327e-001, 2.023480e-001, 2.023632e-001, 2.023784e-001, 2.023936e-001, 2.024089e-001, 2.024241e-001, 2.024393e-001, 2.024546e-001, 2.024698e-001, 2.024850e-001, 2.025002e-001, 2.025154e-001, 2.025307e-001, 2.025459e-001, 2.025611e-001, 2.025763e-001, 2.025915e-001, 2.026067e-001, 2.026220e-001, 2.026372e-001, 2.026524e-001, 2.026676e-001, 2.026828e-001, 2.026980e-001, 2.027132e-001, 2.027284e-001, 2.027436e-001, 2.027588e-001, 2.027740e-001, 2.027892e-001, 2.028044e-001, 2.028196e-001, 2.028348e-001, 2.028500e-001, 2.028652e-001, 2.028804e-001, 2.028956e-001, 2.029107e-001, 2.029259e-001, 2.029411e-001, 2.029563e-001, 2.029715e-001, 2.029867e-001, 2.030018e-001, 2.030170e-001, 2.030322e-001, 2.030474e-001, 2.030626e-001, 2.030777e-001, 2.030929e-001, 2.031081e-001, 2.031232e-001, 2.031384e-001, 2.031536e-001, 2.031688e-001, 2.031839e-001, 2.031991e-001, 2.032142e-001, 2.032294e-001, 2.032446e-001, 2.032597e-001, 2.032749e-001, 2.032900e-001, 2.033052e-001, 2.033204e-001, 2.033355e-001, 2.033507e-001, 2.033658e-001, 2.033810e-001, 2.033961e-001, 2.034113e-001, 2.034264e-001, 2.034415e-001, 2.034567e-001, 2.034718e-001, 2.034870e-001, 2.035021e-001, 2.035173e-001, 2.035324e-001, 2.035475e-001, 2.035627e-001, 
2.035778e-001, 2.035929e-001, 2.036081e-001, 2.036232e-001, 2.036383e-001, 2.036534e-001, 2.036686e-001, 2.036837e-001, 2.036988e-001, 2.037139e-001, 2.037291e-001, 2.037442e-001, 2.037593e-001, 2.037744e-001, 2.037895e-001, 2.038047e-001, 2.038198e-001, 2.038349e-001, 2.038500e-001, 2.038651e-001, 2.038802e-001, 2.038953e-001, 2.039104e-001, 2.039255e-001, 2.039406e-001, 2.039557e-001, 2.039708e-001, 2.039859e-001, 2.040010e-001, 2.040161e-001, 2.040312e-001, 2.040463e-001, 2.040614e-001, 2.040765e-001, 2.040916e-001, 2.041067e-001, 2.041218e-001, 2.041369e-001, 2.041520e-001, 2.041670e-001, 2.041821e-001, 2.041972e-001, 2.042123e-001, 2.042274e-001, 2.042425e-001, 2.042575e-001, 2.042726e-001, 2.042877e-001, 2.043028e-001, 2.043178e-001, 2.043329e-001, 2.043480e-001, 2.043630e-001, 2.043781e-001, 2.043932e-001, 2.044083e-001, 2.044233e-001, 2.044384e-001, 2.044534e-001, 2.044685e-001, 2.044836e-001, 2.044986e-001, 2.045137e-001, 2.045287e-001, 2.045438e-001, 2.045588e-001, 2.045739e-001, 2.045889e-001, 2.046040e-001, 2.046190e-001, 2.046341e-001, 2.046491e-001, 2.046642e-001, 2.046792e-001, 2.046943e-001, 2.047093e-001, 2.047244e-001, 2.047394e-001, 2.047544e-001, 2.047695e-001, 2.047845e-001, 2.047995e-001, 2.048146e-001, 2.048296e-001, 2.048446e-001, 2.048597e-001, 2.048747e-001, 2.048897e-001, 2.049047e-001, 2.049198e-001, 2.049348e-001, 2.049498e-001, 2.049648e-001, 2.049799e-001, 2.049949e-001, 2.050099e-001, 2.050249e-001, 2.050399e-001, 2.050549e-001, 2.050699e-001, 
2.050850e-001, 2.051000e-001, 2.051150e-001, 2.051300e-001, 2.051450e-001, 2.051600e-001, 2.051750e-001, 2.051900e-001, 2.052050e-001, 2.052200e-001, 2.052350e-001, 2.052500e-001, 2.052650e-001, 2.052800e-001, 2.052950e-001, 2.053100e-001, 2.053250e-001, 2.053400e-001, 2.053549e-001, 2.053699e-001, 2.053849e-001, 2.053999e-001, 2.054149e-001, 2.054299e-001, 2.054449e-001, 2.054598e-001, 2.054748e-001, 2.054898e-001, 2.055048e-001, 2.055197e-001, 2.055347e-001, 2.055497e-001, 2.055647e-001, 2.055796e-001, 2.055946e-001, 2.056096e-001, 2.056245e-001, 2.056395e-001, 2.056545e-001, 2.056694e-001, 2.056844e-001, 2.056994e-001, 2.057143e-001, 2.057293e-001, 2.057442e-001, 2.057592e-001, 2.057741e-001, 2.057891e-001, 2.058040e-001, 2.058190e-001, 2.058340e-001, 2.058489e-001, 2.058638e-001, 2.058788e-001, 2.058937e-001, 2.059087e-001, 2.059236e-001, 2.059386e-001, 2.059535e-001, 2.059684e-001, 2.059834e-001, 2.059983e-001, 2.060133e-001, 2.060282e-001, 2.060431e-001, 2.060581e-001, 2.060730e-001, 2.060879e-001, 2.061028e-001, 2.061178e-001, 2.061327e-001, 2.061476e-001, 2.061625e-001, 2.061775e-001, 2.061924e-001, 2.062073e-001, 2.062222e-001, 2.062371e-001, 2.062521e-001, 2.062670e-001, 2.062819e-001, 2.062968e-001, 2.063117e-001, 2.063266e-001, 2.063415e-001, 2.063564e-001, 2.063714e-001, 2.063863e-001, 2.064012e-001, 2.064161e-001, 2.064310e-001, 2.064459e-001, 2.064608e-001, 2.064757e-001, 2.064906e-001, 2.065055e-001, 2.065204e-001, 2.065352e-001, 2.065501e-001, 2.065650e-001, 
2.065799e-001, 2.065948e-001, 2.066097e-001, 2.066246e-001, 2.066395e-001, 2.066543e-001, 2.066692e-001, 2.066841e-001, 2.066990e-001, 2.067139e-001, 2.067287e-001, 2.067436e-001, 2.067585e-001, 2.067734e-001, 2.067882e-001, 2.068031e-001, 2.068180e-001, 2.068329e-001, 2.068477e-001, 2.068626e-001, 2.068775e-001, 2.068923e-001, 2.069072e-001, 2.069220e-001, 2.069369e-001, 2.069518e-001, 2.069666e-001, 2.069815e-001, 2.069963e-001, 2.070112e-001, 2.070261e-001, 2.070409e-001, 2.070558e-001, 2.070706e-001, 2.070855e-001, 2.071003e-001, 2.071151e-001, 2.071300e-001, 2.071448e-001, 2.071597e-001, 2.071745e-001, 2.071894e-001, 2.072042e-001, 2.072190e-001, 2.072339e-001, 2.072487e-001, 2.072635e-001, 2.072784e-001, 2.072932e-001, 2.073080e-001, 2.073229e-001, 2.073377e-001, 2.073525e-001, 2.073674e-001, 2.073822e-001, 2.073970e-001, 2.074118e-001, 2.074266e-001, 2.074415e-001, 2.074563e-001, 2.074711e-001, 2.074859e-001, 2.075007e-001, 2.075155e-001, 2.075304e-001, 2.075452e-001, 2.075600e-001, 2.075748e-001, 2.075896e-001, 2.076044e-001, 2.076192e-001, 2.076340e-001, 2.076488e-001, 2.076636e-001, 2.076784e-001, 2.076932e-001, 2.077080e-001, 2.077228e-001, 2.077376e-001, 2.077524e-001, 2.077672e-001, 2.077820e-001, 2.077968e-001, 2.078116e-001, 2.078264e-001, 2.078412e-001, 2.078559e-001, 2.078707e-001, 2.078855e-001, 2.079003e-001, 2.079151e-001, 2.079299e-001, 2.079446e-001, 2.079594e-001, 2.079742e-001, 2.079890e-001, 2.080037e-001, 2.080185e-001, 2.080333e-001, 2.080481e-001, 
2.080628e-001, 2.080776e-001, 2.080924e-001, 2.081071e-001, 2.081219e-001, 2.081367e-001, 2.081514e-001, 2.081662e-001, 2.081809e-001, 2.081957e-001, 2.082105e-001, 2.082252e-001, 2.082400e-001, 2.082547e-001, 2.082695e-001, 2.082842e-001, 2.082990e-001, 2.083137e-001, 2.083285e-001, 2.083432e-001, 2.083580e-001, 2.083727e-001, 2.083875e-001, 2.084022e-001, 2.084170e-001, 2.084317e-001, 2.084464e-001, 2.084612e-001, 2.084759e-001, 2.084906e-001, 2.085054e-001, 2.085201e-001, 2.085348e-001, 2.085496e-001, 2.085643e-001, 2.085790e-001, 2.085938e-001, 2.086085e-001, 2.086232e-001, 2.086379e-001, 2.086527e-001, 2.086674e-001, 2.086821e-001, 2.086968e-001, 2.087115e-001, 2.087263e-001, 2.087410e-001, 2.087557e-001, 2.087704e-001, 2.087851e-001, 2.087998e-001, 2.088145e-001, 2.088292e-001, 2.088439e-001, 2.088586e-001, 2.088734e-001, 2.088881e-001, 2.089028e-001, 2.089175e-001, 2.089322e-001, 2.089469e-001, 2.089616e-001, 2.089763e-001, 2.089909e-001, 2.090056e-001, 2.090203e-001, 2.090350e-001, 2.090497e-001, 2.090644e-001, 2.090791e-001, 2.090938e-001, 2.091085e-001, 2.091232e-001, 2.091378e-001, 2.091525e-001, 2.091672e-001, 2.091819e-001, 2.091966e-001, 2.092112e-001, 2.092259e-001, 2.092406e-001, 2.092553e-001, 2.092699e-001, 2.092846e-001, 2.092993e-001, 2.093139e-001, 2.093286e-001, 2.093433e-001, 2.093579e-001, 2.093726e-001, 2.093873e-001, 2.094019e-001, 2.094166e-001, 2.094313e-001, 2.094459e-001, 2.094606e-001, 2.094752e-001, 2.094899e-001, 2.095045e-001, 2.095192e-001, 
2.095338e-001, 2.095485e-001, 2.095631e-001, 2.095778e-001, 2.095924e-001, 2.096071e-001, 2.096217e-001, 2.096364e-001, 2.096510e-001, 2.096657e-001, 2.096803e-001, 2.096949e-001, 2.097096e-001, 2.097242e-001, 2.097388e-001, 2.097535e-001, 2.097681e-001, 2.097827e-001, 2.097974e-001, 2.098120e-001, 2.098266e-001, 2.098413e-001, 2.098559e-001, 2.098705e-001, 2.098851e-001, 2.098998e-001, 2.099144e-001, 2.099290e-001, 2.099436e-001, 2.099582e-001, 2.099728e-001, 2.099875e-001, 2.100021e-001, 2.100167e-001, 2.100313e-001, 2.100459e-001, 2.100605e-001, 2.100751e-001, 2.100897e-001, 2.101043e-001, 2.101189e-001, 2.101335e-001, 2.101481e-001, 2.101628e-001, 2.101774e-001, 2.101919e-001, 2.102065e-001, 2.102211e-001, 2.102357e-001, 2.102503e-001, 2.102649e-001, 2.102795e-001, 2.102941e-001, 2.103087e-001, 2.103233e-001, 2.103379e-001, 2.103525e-001, 2.103670e-001, 2.103816e-001, 2.103962e-001, 2.104108e-001, 2.104254e-001, 2.104400e-001, 2.104545e-001, 2.104691e-001, 2.104837e-001, 2.104983e-001, 2.105128e-001, 2.105274e-001, 2.105420e-001, 2.105565e-001, 2.105711e-001, 2.105857e-001, 2.106002e-001, 2.106148e-001, 2.106294e-001, 2.106439e-001, 2.106585e-001, 2.106731e-001, 2.106876e-001, 2.107022e-001, 2.107167e-001, 2.107313e-001, 2.107458e-001, 2.107604e-001, 2.107749e-001, 2.107895e-001, 2.108040e-001, 2.108186e-001, 2.108331e-001, 2.108477e-001, 2.108622e-001, 2.108768e-001, 2.108913e-001, 2.109059e-001, 2.109204e-001, 2.109349e-001, 2.109495e-001, 2.109640e-001, 2.109786e-001, 
2.109931e-001, 2.110076e-001, 2.110222e-001, 2.110367e-001, 2.110512e-001, 2.110657e-001, 2.110803e-001, 2.110948e-001, 2.111093e-001, 2.111238e-001, 2.111384e-001, 2.111529e-001, 2.111674e-001, 2.111819e-001, 2.111964e-001, 2.112110e-001, 2.112255e-001, 2.112400e-001, 2.112545e-001, 2.112690e-001, 2.112835e-001, 2.112980e-001, 2.113126e-001, 2.113271e-001, 2.113416e-001, 2.113561e-001, 2.113706e-001, 2.113851e-001, 2.113996e-001, 2.114141e-001, 2.114286e-001, 2.114431e-001, 2.114576e-001, 2.114721e-001, 2.114866e-001, 2.115011e-001, 2.115156e-001, 2.115301e-001, 2.115445e-001, 2.115590e-001, 2.115735e-001, 2.115880e-001, 2.116025e-001, 2.116170e-001, 2.116315e-001, 2.116459e-001, 2.116604e-001, 2.116749e-001, 2.116894e-001, 2.117039e-001, 2.117183e-001, 2.117328e-001, 2.117473e-001, 2.117618e-001, 2.117762e-001, 2.117907e-001, 2.118052e-001, 2.118196e-001, 2.118341e-001, 2.118486e-001, 2.118630e-001, 2.118775e-001, 2.118920e-001, 2.119064e-001, 2.119209e-001, 2.119354e-001, 2.119498e-001, 2.119643e-001, 2.119787e-001, 2.119932e-001, 2.120076e-001, 2.120221e-001, 2.120365e-001, 2.120510e-001, 2.120654e-001, 2.120799e-001, 2.120943e-001, 2.121088e-001, 2.121232e-001, 2.121377e-001, 2.121521e-001, 2.121665e-001, 2.121810e-001, 2.121954e-001, 2.122099e-001, 2.122243e-001, 2.122387e-001, 2.122532e-001, 2.122676e-001, 2.122820e-001, 2.122965e-001, 2.123109e-001, 2.123253e-001, 2.123397e-001, 2.123542e-001, 2.123686e-001, 2.123830e-001, 2.123974e-001, 2.124119e-001, 2.124263e-001, 
2.124407e-001, 2.124551e-001, 2.124695e-001, 2.124840e-001, 2.124984e-001, 2.125128e-001, 2.125272e-001, 2.125416e-001, 2.125560e-001, 2.125704e-001, 2.125848e-001, 2.125992e-001, 2.126136e-001, 2.126280e-001, 2.126424e-001, 2.126569e-001, 2.126713e-001, 2.126857e-001, 2.127000e-001, 2.127144e-001, 2.127288e-001, 2.127432e-001, 2.127576e-001, 2.127720e-001, 2.127864e-001, 2.128008e-001, 2.128152e-001, 2.128296e-001, 2.128440e-001, 2.128584e-001, 2.128727e-001, 2.128871e-001, 2.129015e-001, 2.129159e-001, 2.129303e-001, 2.129446e-001, 2.129590e-001, 2.129734e-001, 2.129878e-001, 2.130022e-001, 2.130165e-001, 2.130309e-001, 2.130453e-001, 2.130596e-001, 2.130740e-001, 2.130884e-001, 2.131027e-001, 2.131171e-001, 2.131315e-001, 2.131458e-001, 2.131602e-001, 2.131746e-001, 2.131889e-001, 2.132033e-001, 2.132176e-001, 2.132320e-001, 2.132463e-001, 2.132607e-001, 2.132750e-001, 2.132894e-001, 2.133037e-001, 2.133181e-001, 2.133324e-001, 2.133468e-001, 2.133611e-001, 2.133755e-001, 2.133898e-001, 2.134042e-001, 2.134185e-001, 2.134328e-001, 2.134472e-001, 2.134615e-001, 2.134759e-001, 2.134902e-001, 2.135045e-001, 2.135189e-001, 2.135332e-001, 2.135475e-001, 2.135619e-001, 2.135762e-001, 2.135905e-001, 2.136048e-001, 2.136192e-001, 2.136335e-001, 2.136478e-001, 2.136621e-001, 2.136765e-001, 2.136908e-001, 2.137051e-001, 2.137194e-001, 2.137337e-001, 2.137480e-001, 2.137624e-001, 2.137767e-001, 2.137910e-001, 2.138053e-001, 2.138196e-001, 2.138339e-001, 2.138482e-001, 2.138625e-001, 
2.138768e-001, 2.138911e-001, 2.139054e-001, 2.139197e-001, 2.139340e-001, 2.139483e-001, 2.139626e-001, 2.139769e-001, 2.139912e-001, 2.140055e-001, 2.140198e-001, 2.140341e-001, 2.140484e-001, 2.140627e-001, 2.140770e-001, 2.140913e-001, 2.141055e-001, 2.141198e-001, 2.141341e-001, 2.141484e-001, 2.141627e-001, 2.141770e-001, 2.141912e-001, 2.142055e-001, 2.142198e-001, 2.142341e-001, 2.142483e-001, 2.142626e-001, 2.142769e-001, 2.142912e-001, 2.143054e-001, 2.143197e-001, 2.143340e-001, 2.143482e-001, 2.143625e-001, 2.143768e-001, 2.143910e-001, 2.144053e-001, 2.144196e-001, 2.144338e-001, 2.144481e-001, 2.144623e-001, 2.144766e-001, 2.144909e-001, 2.145051e-001, 2.145194e-001, 2.145336e-001, 2.145479e-001, 2.145621e-001, 2.145764e-001, 2.145906e-001, 2.146049e-001, 2.146191e-001, 2.146334e-001, 2.146476e-001, 2.146618e-001, 2.146761e-001, 2.146903e-001, 2.147046e-001, 2.147188e-001, 2.147330e-001, 2.147473e-001, 2.147615e-001, 2.147757e-001, 2.147900e-001, 2.148042e-001, 2.148184e-001, 2.148327e-001, 2.148469e-001, 2.148611e-001, 2.148753e-001, 2.148896e-001, 2.149038e-001, 2.149180e-001, 2.149322e-001, 2.149465e-001, 2.149607e-001, 2.149749e-001, 2.149891e-001, 2.150033e-001, 2.150175e-001, 2.150317e-001, 2.150460e-001, 2.150602e-001, 2.150744e-001, 2.150886e-001, 2.151028e-001, 2.151170e-001, 2.151312e-001, 2.151454e-001, 2.151596e-001, 2.151738e-001, 2.151880e-001, 2.152022e-001, 2.152164e-001, 2.152306e-001, 2.152448e-001, 2.152590e-001, 2.152732e-001, 2.152874e-001, 
2.153016e-001, 2.153158e-001, 2.153300e-001, 2.153442e-001, 2.153583e-001, 2.153725e-001, 2.153867e-001, 2.154009e-001, 2.154151e-001, 2.154293e-001, 2.154434e-001, 2.154576e-001, 2.154718e-001, 2.154860e-001, 2.155001e-001, 2.155143e-001, 2.155285e-001, 2.155427e-001, 2.155568e-001, 2.155710e-001, 2.155852e-001, 2.155994e-001, 2.156135e-001, 2.156277e-001, 2.156418e-001, 2.156560e-001, 2.156702e-001, 2.156843e-001, 2.156985e-001, 2.157127e-001, 2.157268e-001, 2.157410e-001, 2.157551e-001, 2.157693e-001, 2.157834e-001, 2.157976e-001, 2.158117e-001, 2.158259e-001, 2.158400e-001, 2.158542e-001, 2.158683e-001, 2.158825e-001, 2.158966e-001, 2.159108e-001, 2.159249e-001, 2.159391e-001, 2.159532e-001, 2.159673e-001, 2.159815e-001, 2.159956e-001, 2.160097e-001, 2.160239e-001, 2.160380e-001, 2.160521e-001, 2.160663e-001, 2.160804e-001, 2.160945e-001, 2.161087e-001, 2.161228e-001, 2.161369e-001, 2.161510e-001, 2.161652e-001, 2.161793e-001, 2.161934e-001, 2.162075e-001, 2.162216e-001, 2.162358e-001, 2.162499e-001, 2.162640e-001, 2.162781e-001, 2.162922e-001, 2.163063e-001, 2.163204e-001, 2.163346e-001, 2.163487e-001, 2.163628e-001, 2.163769e-001, 2.163910e-001, 2.164051e-001, 2.164192e-001, 2.164333e-001, 2.164474e-001, 2.164615e-001, 2.164756e-001, 2.164897e-001, 2.165038e-001, 2.165179e-001, 2.165320e-001, 2.165461e-001, 2.165602e-001, 2.165743e-001, 2.165883e-001, 2.166024e-001, 2.166165e-001, 2.166306e-001, 2.166447e-001, 2.166588e-001, 2.166729e-001, 2.166869e-001, 2.167010e-001, 
2.167151e-001, 2.167292e-001, 2.167433e-001, 2.167573e-001, 2.167714e-001, 2.167855e-001, 2.167996e-001, 2.168136e-001, 2.168277e-001, 2.168418e-001, 2.168558e-001, 2.168699e-001, 2.168840e-001, 2.168980e-001, 2.169121e-001, 2.169262e-001, 2.169402e-001, 2.169543e-001, 2.169684e-001, 2.169824e-001, 2.169965e-001, 2.170105e-001, 2.170246e-001, 2.170386e-001, 2.170527e-001, 2.170667e-001, 2.170808e-001, 2.170948e-001, 2.171089e-001, 2.171229e-001, 2.171370e-001, 2.171510e-001, 2.171651e-001, 2.171791e-001, 2.171932e-001, 2.172072e-001, 2.172212e-001, 2.172353e-001, 2.172493e-001, 2.172634e-001, 2.172774e-001, 2.172914e-001, 2.173055e-001, 2.173195e-001, 2.173335e-001, 2.173476e-001, 2.173616e-001, 2.173756e-001, 2.173896e-001, 2.174037e-001, 2.174177e-001, 2.174317e-001, 2.174457e-001, 2.174598e-001, 2.174738e-001, 2.174878e-001, 2.175018e-001, 2.175158e-001, 2.175298e-001, 2.175439e-001, 2.175579e-001, 2.175719e-001, 2.175859e-001, 2.175999e-001, 2.176139e-001, 2.176279e-001, 2.176419e-001, 2.176559e-001, 2.176699e-001, 2.176839e-001, 2.176980e-001, 2.177120e-001, 2.177260e-001, 2.177400e-001, 2.177540e-001, 2.177679e-001, 2.177819e-001, 2.177959e-001, 2.178099e-001, 2.178239e-001, 2.178379e-001, 2.178519e-001, 2.178659e-001, 2.178799e-001, 2.178939e-001, 2.179079e-001, 2.179218e-001, 2.179358e-001, 2.179498e-001, 2.179638e-001, 2.179778e-001, 2.179918e-001, 2.180057e-001, 2.180197e-001, 2.180337e-001, 2.180477e-001, 2.180616e-001, 2.180756e-001, 2.180896e-001, 2.181035e-001, 
2.181175e-001, 2.181315e-001, 2.181455e-001, 2.181594e-001, 2.181734e-001, 2.181873e-001, 2.182013e-001, 2.182153e-001, 2.182292e-001, 2.182432e-001, 2.182571e-001, 2.182711e-001, 2.182851e-001, 2.182990e-001, 2.183130e-001, 2.183269e-001, 2.183409e-001, 2.183548e-001, 2.183688e-001, 2.183827e-001, 2.183967e-001, 2.184106e-001, 2.184246e-001, 2.184385e-001, 2.184525e-001, 2.184664e-001, 2.184803e-001, 2.184943e-001, 2.185082e-001, 2.185222e-001, 2.185361e-001, 2.185500e-001, 2.185640e-001, 2.185779e-001, 2.185918e-001, 2.186058e-001, 2.186197e-001, 2.186336e-001, 2.186475e-001, 2.186615e-001, 2.186754e-001, 2.186893e-001, 2.187032e-001, 2.187172e-001, 2.187311e-001, 2.187450e-001, 2.187589e-001, 2.187728e-001, 2.187868e-001, 2.188007e-001, 2.188146e-001, 2.188285e-001, 2.188424e-001, 2.188563e-001, 2.188702e-001, 2.188841e-001, 2.188981e-001, 2.189120e-001, 2.189259e-001, 2.189398e-001, 2.189537e-001, 2.189676e-001, 2.189815e-001, 2.189954e-001, 2.190093e-001, 2.190232e-001, 2.190371e-001, 2.190510e-001, 2.190649e-001, 2.190788e-001, 2.190927e-001, 2.191065e-001, 2.191204e-001, 2.191343e-001, 2.191482e-001, 2.191621e-001, 2.191760e-001, 2.191899e-001, 2.192038e-001, 2.192176e-001, 2.192315e-001, 2.192454e-001, 2.192593e-001, 2.192732e-001, 2.192870e-001, 2.193009e-001, 2.193148e-001, 2.193287e-001, 2.193425e-001, 2.193564e-001, 2.193703e-001, 2.193842e-001, 2.193980e-001, 2.194119e-001, 2.194258e-001, 2.194396e-001, 2.194535e-001, 2.194674e-001, 2.194812e-001, 2.194951e-001, 
2.195089e-001, 2.195228e-001, 2.195367e-001, 2.195505e-001, 2.195644e-001, 2.195782e-001, 2.195921e-001, 2.196059e-001, 2.196198e-001, 2.196336e-001, 2.196475e-001, 2.196613e-001, 2.196752e-001, 2.196890e-001, 2.197029e-001, 2.197167e-001, 2.197306e-001, 2.197444e-001, 2.197582e-001, 2.197721e-001, 2.197859e-001, 2.197998e-001, 2.198136e-001, 2.198274e-001, 2.198413e-001, 2.198551e-001, 2.198689e-001, 2.198828e-001, 2.198966e-001, 2.199104e-001, 2.199242e-001, 2.199381e-001, 2.199519e-001, 2.199657e-001, 2.199795e-001, 2.199934e-001, 2.200072e-001, 2.200210e-001, 2.200348e-001, 2.200486e-001, 2.200625e-001, 2.200763e-001, 2.200901e-001, 2.201039e-001, 2.201177e-001, 2.201315e-001, 2.201453e-001, 2.201591e-001, 2.201730e-001, 2.201868e-001, 2.202006e-001, 2.202144e-001, 2.202282e-001, 2.202420e-001, 2.202558e-001, 2.202696e-001, 2.202834e-001, 2.202972e-001, 2.203110e-001, 2.203248e-001, 2.203386e-001, 2.203524e-001, 2.203662e-001, 2.203799e-001, 2.203937e-001, 2.204075e-001, 2.204213e-001, 2.204351e-001, 2.204489e-001, 2.204627e-001, 2.204765e-001, 2.204902e-001, 2.205040e-001, 2.205178e-001, 2.205316e-001, 2.205454e-001, 2.205591e-001, 2.205729e-001, 2.205867e-001, 2.206005e-001, 2.206142e-001, 2.206280e-001, 2.206418e-001, 2.206556e-001, 2.206693e-001, 2.206831e-001, 2.206969e-001, 2.207106e-001, 2.207244e-001, 2.207382e-001, 2.207519e-001, 2.207657e-001, 2.207794e-001, 2.207932e-001, 2.208070e-001, 2.208207e-001, 2.208345e-001, 2.208482e-001, 2.208620e-001, 2.208757e-001, 
2.208895e-001, 2.209032e-001, 2.209170e-001, 2.209307e-001, 2.209445e-001, 2.209582e-001, 2.209720e-001, 2.209857e-001, 2.209995e-001, 2.210132e-001, 2.210269e-001, 2.210407e-001, 2.210544e-001, 2.210682e-001, 2.210819e-001, 2.210956e-001, 2.211094e-001, 2.211231e-001, 2.211368e-001, 2.211506e-001, 2.211643e-001, 2.211780e-001, 2.211918e-001, 2.212055e-001, 2.212192e-001, 2.212329e-001, 2.212467e-001, 2.212604e-001, 2.212741e-001, 2.212878e-001, 2.213016e-001, 2.213153e-001, 2.213290e-001, 2.213427e-001, 2.213564e-001, 2.213701e-001, 2.213838e-001, 2.213976e-001, 2.214113e-001, 2.214250e-001, 2.214387e-001, 2.214524e-001, 2.214661e-001, 2.214798e-001, 2.214935e-001, 2.215072e-001, 2.215209e-001, 2.215346e-001, 2.215483e-001, 2.215620e-001, 2.215757e-001, 2.215894e-001, 2.216031e-001, 2.216168e-001, 2.216305e-001, 2.216442e-001, 2.216579e-001, 2.216716e-001, 2.216853e-001, 2.216990e-001, 2.217127e-001, 2.217263e-001, 2.217400e-001, 2.217537e-001, 2.217674e-001, 2.217811e-001, 2.217948e-001, 2.218084e-001, 2.218221e-001, 2.218358e-001, 2.218495e-001, 2.218631e-001, 2.218768e-001, 2.218905e-001, 2.219042e-001, 2.219178e-001, 2.219315e-001, 2.219452e-001, 2.219588e-001, 2.219725e-001, 2.219862e-001, 2.219998e-001, 2.220135e-001, 2.220272e-001, 2.220408e-001, 2.220545e-001, 2.220682e-001, 2.220818e-001, 2.220955e-001, 2.221091e-001, 2.221228e-001, 2.221364e-001, 2.221501e-001, 2.221637e-001, 2.221774e-001, 2.221911e-001, 2.222047e-001, 2.222183e-001, 2.222320e-001, 2.222456e-001, 
2.222593e-001, 2.222729e-001, 2.222866e-001, 2.223002e-001, 2.223139e-001, 2.223275e-001, 2.223411e-001, 2.223548e-001, 2.223684e-001, 2.223820e-001, 2.223957e-001, 2.224093e-001, 2.224229e-001, 2.224366e-001, 2.224502e-001, 2.224638e-001, 2.224775e-001, 2.224911e-001, 2.225047e-001, 2.225183e-001, 2.225320e-001, 2.225456e-001, 2.225592e-001, 2.225728e-001, 2.225865e-001, 2.226001e-001, 2.226137e-001, 2.226273e-001, 2.226409e-001, 2.226545e-001, 2.226681e-001, 2.226818e-001, 2.226954e-001, 2.227090e-001, 2.227226e-001, 2.227362e-001, 2.227498e-001, 2.227634e-001, 2.227770e-001, 2.227906e-001, 2.228042e-001, 2.228178e-001, 2.228314e-001, 2.228450e-001, 2.228586e-001, 2.228722e-001, 2.228858e-001, 2.228994e-001, 2.229130e-001, 2.229266e-001, 2.229402e-001, 2.229538e-001, 2.229674e-001, 2.229810e-001, 2.229945e-001, 2.230081e-001, 2.230217e-001, 2.230353e-001, 2.230489e-001, 2.230625e-001, 2.230761e-001, 2.230896e-001, 2.231032e-001, 2.231168e-001, 2.231304e-001, 2.231439e-001, 2.231575e-001, 2.231711e-001, 2.231847e-001, 2.231982e-001, 2.232118e-001, 2.232254e-001, 2.232389e-001, 2.232525e-001, 2.232661e-001, 2.232796e-001, 2.232932e-001, 2.233068e-001, 2.233203e-001, 2.233339e-001, 2.233475e-001, 2.233610e-001, 2.233746e-001, 2.233881e-001, 2.234017e-001, 2.234152e-001, 2.234288e-001, 2.234424e-001, 2.234559e-001, 2.234695e-001, 2.234830e-001, 2.234966e-001, 2.235101e-001, 2.235236e-001, 2.235372e-001, 2.235507e-001, 2.235643e-001, 2.235778e-001, 2.235914e-001, 2.236049e-001, 
2.236184e-001, 2.236320e-001, 2.236455e-001, 2.236591e-001, 2.236726e-001, 2.236861e-001, 2.236997e-001, 2.237132e-001, 2.237267e-001, 2.237403e-001, 2.237538e-001, 2.237673e-001, 2.237808e-001, 2.237944e-001, 2.238079e-001, 2.238214e-001, 2.238349e-001, 2.238485e-001, 2.238620e-001, 2.238755e-001, 2.238890e-001, 2.239025e-001, 2.239160e-001, 2.239296e-001, 2.239431e-001, 2.239566e-001, 2.239701e-001, 2.239836e-001, 2.239971e-001, 2.240106e-001, 2.240241e-001, 2.240376e-001, 2.240511e-001, 2.240647e-001, 2.240782e-001, 2.240917e-001, 2.241052e-001, 2.241187e-001, 2.241322e-001, 2.241457e-001, 2.241592e-001, 2.241727e-001, 2.241861e-001, 2.241996e-001, 2.242131e-001, 2.242266e-001, 2.242401e-001, 2.242536e-001, 2.242671e-001, 2.242806e-001, 2.242941e-001, 2.243076e-001, 2.243210e-001, 2.243345e-001, 2.243480e-001, 2.243615e-001, 2.243750e-001, 2.243885e-001, 2.244019e-001, 2.244154e-001, 2.244289e-001, 2.244424e-001, 2.244558e-001, 2.244693e-001, 2.244828e-001, 2.244962e-001, 2.245097e-001, 2.245232e-001, 2.245367e-001, 2.245501e-001, 2.245636e-001, 2.245771e-001, 2.245905e-001, 2.246040e-001, 2.246174e-001, 2.246309e-001, 2.246444e-001, 2.246578e-001, 2.246713e-001, 2.246847e-001, 2.246982e-001, 2.247116e-001, 2.247251e-001, 2.247386e-001, 2.247520e-001, 2.247655e-001, 2.247789e-001, 2.247923e-001, 2.248058e-001, 2.248192e-001, 2.248327e-001, 2.248461e-001, 2.248596e-001, 2.248730e-001, 2.248865e-001, 2.248999e-001, 2.249133e-001, 2.249268e-001, 2.249402e-001, 2.249536e-001, 
2.249671e-001, 2.249805e-001, 2.249939e-001, 2.250074e-001, 2.250208e-001, 2.250342e-001, 2.250477e-001, 2.250611e-001, 2.250745e-001, 2.250879e-001, 2.251014e-001, 2.251148e-001, 2.251282e-001, 2.251416e-001, 2.251551e-001, 2.251685e-001, 2.251819e-001, 2.251953e-001, 2.252087e-001, 2.252221e-001, 2.252356e-001, 2.252490e-001, 2.252624e-001, 2.252758e-001, 2.252892e-001, 2.253026e-001, 2.253160e-001, 2.253294e-001, 2.253428e-001, 2.253562e-001, 2.253696e-001, 2.253830e-001, 2.253964e-001, 2.254098e-001, 2.254232e-001, 2.254366e-001, 2.254500e-001, 2.254634e-001, 2.254768e-001, 2.254902e-001, 2.255036e-001, 2.255170e-001, 2.255304e-001, 2.255438e-001, 2.255572e-001, 2.255706e-001, 2.255839e-001, 2.255973e-001, 2.256107e-001, 2.256241e-001, 2.256375e-001, 2.256509e-001, 2.256642e-001, 2.256776e-001, 2.256910e-001, 2.257044e-001, 2.257178e-001, 2.257311e-001, 2.257445e-001, 2.257579e-001, 2.257713e-001, 2.257846e-001, 2.257980e-001, 2.258114e-001, 2.258247e-001, 2.258381e-001, 2.258515e-001, 2.258648e-001, 2.258782e-001, 2.258916e-001, 2.259049e-001, 2.259183e-001, 2.259316e-001, 2.259450e-001, 2.259584e-001, 2.259717e-001, 2.259851e-001, 2.259984e-001, 2.260118e-001, 2.260251e-001, 2.260385e-001, 2.260518e-001, 2.260652e-001, 2.260785e-001, 2.260919e-001, 2.261052e-001, 2.261186e-001, 2.261319e-001, 2.261453e-001, 2.261586e-001, 2.261719e-001, 2.261853e-001, 2.261986e-001, 2.262120e-001, 2.262253e-001, 2.262386e-001, 2.262520e-001, 2.262653e-001, 2.262786e-001, 2.262920e-001, 
2.263053e-001, 2.263186e-001, 2.263320e-001, 2.263453e-001, 2.263586e-001, 2.263719e-001, 2.263853e-001, 2.263986e-001, 2.264119e-001, 2.264252e-001, 2.264386e-001, 2.264519e-001, 2.264652e-001, 2.264785e-001, 2.264918e-001, 2.265051e-001, 2.265185e-001, 2.265318e-001, 2.265451e-001, 2.265584e-001, 2.265717e-001, 2.265850e-001, 2.265983e-001, 2.266116e-001, 2.266249e-001, 2.266382e-001, 2.266515e-001, 2.266648e-001, 2.266781e-001, 2.266914e-001, 2.267047e-001, 2.267180e-001, 2.267313e-001, 2.267446e-001, 2.267579e-001, 2.267712e-001, 2.267845e-001, 2.267978e-001, 2.268111e-001, 2.268244e-001, 2.268377e-001, 2.268510e-001, 2.268643e-001, 2.268776e-001, 2.268908e-001, 2.269041e-001, 2.269174e-001, 2.269307e-001, 2.269440e-001, 2.269573e-001, 2.269705e-001, 2.269838e-001, 2.269971e-001, 2.270104e-001, 2.270236e-001, 2.270369e-001, 2.270502e-001, 2.270635e-001, 2.270767e-001, 2.270900e-001, 2.271033e-001, 2.271165e-001, 2.271298e-001, 2.271431e-001, 2.271563e-001, 2.271696e-001, 2.271829e-001, 2.271961e-001, 2.272094e-001, 2.272226e-001, 2.272359e-001, 2.272492e-001, 2.272624e-001, 2.272757e-001, 2.272889e-001, 2.273022e-001, 2.273154e-001, 2.273287e-001, 2.273419e-001, 2.273552e-001, 2.273684e-001, 2.273817e-001, 2.273949e-001, 2.274082e-001, 2.274214e-001, 2.274347e-001, 2.274479e-001, 2.274612e-001, 2.274744e-001, 2.274876e-001, 2.275009e-001, 2.275141e-001, 2.275273e-001, 2.275406e-001, 2.275538e-001, 2.275671e-001, 2.275803e-001, 2.275935e-001, 2.276067e-001, 2.276200e-001, 
2.276332e-001, 2.276464e-001, 2.276597e-001, 2.276729e-001, 2.276861e-001, 2.276993e-001, 2.277126e-001, 2.277258e-001, 2.277390e-001, 2.277522e-001, 2.277654e-001, 2.277786e-001, 2.277919e-001, 2.278051e-001, 2.278183e-001, 2.278315e-001, 2.278447e-001, 2.278579e-001, 2.278711e-001, 2.278844e-001, 2.278976e-001, 2.279108e-001, 2.279240e-001, 2.279372e-001, 2.279504e-001, 2.279636e-001, 2.279768e-001, 2.279900e-001, 2.280032e-001, 2.280164e-001, 2.280296e-001, 2.280428e-001, 2.280560e-001, 2.280692e-001, 2.280824e-001, 2.280956e-001, 2.281087e-001, 2.281219e-001, 2.281351e-001, 2.281483e-001, 2.281615e-001, 2.281747e-001, 2.281879e-001, 2.282011e-001, 2.282142e-001, 2.282274e-001, 2.282406e-001, 2.282538e-001, 2.282670e-001, 2.282801e-001, 2.282933e-001, 2.283065e-001, 2.283197e-001, 2.283329e-001, 2.283460e-001, 2.283592e-001, 2.283724e-001, 2.283855e-001, 2.283987e-001, 2.284119e-001, 2.284250e-001, 2.284382e-001, 2.284514e-001, 2.284645e-001, 2.284777e-001, 2.284909e-001, 2.285040e-001, 2.285172e-001, 2.285303e-001, 2.285435e-001, 2.285567e-001, 2.285698e-001, 2.285830e-001, 2.285961e-001, 2.286093e-001, 2.286224e-001, 2.286356e-001, 2.286487e-001, 2.286619e-001, 2.286750e-001, 2.286882e-001, 2.287013e-001, 2.287145e-001, 2.287276e-001, 2.287408e-001, 2.287539e-001, 2.287670e-001, 2.287802e-001, 2.287933e-001, 2.288065e-001, 2.288196e-001, 2.288327e-001, 2.288459e-001, 2.288590e-001, 2.288721e-001, 2.288853e-001, 2.288984e-001, 2.289115e-001, 2.289247e-001, 2.289378e-001, 
2.289509e-001, 2.289640e-001, 2.289772e-001, 2.289903e-001, 2.290034e-001, 2.290165e-001, 2.290296e-001, 2.290428e-001, 2.290559e-001, 2.290690e-001, 2.290821e-001, 2.290952e-001, 2.291084e-001, 2.291215e-001, 2.291346e-001, 2.291477e-001, 2.291608e-001, 2.291739e-001, 2.291870e-001, 2.292001e-001, 2.292132e-001, 2.292263e-001, 2.292394e-001, 2.292525e-001, 2.292656e-001, 2.292788e-001, 2.292919e-001, 2.293050e-001, 2.293180e-001, 2.293311e-001, 2.293442e-001, 2.293573e-001, 2.293704e-001, 2.293835e-001, 2.293966e-001, 2.294097e-001, 2.294228e-001, 2.294359e-001, 2.294490e-001, 2.294621e-001, 2.294752e-001, 2.294882e-001, 2.295013e-001, 2.295144e-001, 2.295275e-001, 2.295406e-001, 2.295537e-001, 2.295667e-001, 2.295798e-001, 2.295929e-001, 2.296060e-001, 2.296190e-001, 2.296321e-001, 2.296452e-001, 2.296583e-001, 2.296713e-001, 2.296844e-001, 2.296975e-001, 2.297105e-001, 2.297236e-001, 2.297367e-001, 2.297497e-001, 2.297628e-001, 2.297759e-001, 2.297889e-001, 2.298020e-001, 2.298151e-001, 2.298281e-001, 2.298412e-001, 2.298542e-001, 2.298673e-001, 2.298803e-001, 2.298934e-001, 2.299064e-001, 2.299195e-001, 2.299326e-001, 2.299456e-001, 2.299587e-001, 2.299717e-001, 2.299847e-001, 2.299978e-001, 2.300108e-001, 2.300239e-001, 2.300369e-001, 2.300500e-001, 2.300630e-001, 2.300760e-001, 2.300891e-001, 2.301021e-001, 2.301152e-001, 2.301282e-001, 2.301412e-001, 2.301543e-001, 2.301673e-001, 2.301803e-001, 2.301934e-001, 2.302064e-001, 2.302194e-001, 2.302325e-001, 2.302455e-001, 
2.302585e-001, 2.302715e-001, 2.302846e-001, 2.302976e-001, 2.303106e-001, 2.303236e-001, 2.303366e-001, 2.303497e-001, 2.303627e-001, 2.303757e-001, 2.303887e-001, 2.304017e-001, 2.304147e-001, 2.304278e-001, 2.304408e-001, 2.304538e-001, 2.304668e-001, 2.304798e-001, 2.304928e-001, 2.305058e-001, 2.305188e-001, 2.305318e-001, 2.305448e-001, 2.305578e-001, 2.305708e-001, 2.305838e-001, 2.305968e-001, 2.306098e-001, 2.306228e-001, 2.306358e-001, 2.306488e-001, 2.306618e-001, 2.306748e-001, 2.306878e-001, 2.307008e-001, 2.307138e-001, 2.307268e-001, 2.307398e-001, 2.307528e-001, 2.307658e-001, 2.307787e-001, 2.307917e-001, 2.308047e-001, 2.308177e-001, 2.308307e-001, 2.308437e-001, 2.308566e-001, 2.308696e-001, 2.308826e-001, 2.308956e-001, 2.309086e-001, 2.309215e-001, 2.309345e-001, 2.309475e-001, 2.309604e-001, 2.309734e-001, 2.309864e-001, 2.309994e-001, 2.310123e-001, 2.310253e-001, 2.310383e-001, 2.310512e-001, 2.310642e-001, 2.310772e-001, 2.310901e-001, 2.311031e-001, 2.311160e-001, 2.311290e-001, 2.311420e-001, 2.311549e-001, 2.311679e-001, 2.311808e-001, 2.311938e-001, 2.312067e-001, 2.312197e-001, 2.312326e-001, 2.312456e-001, 2.312585e-001, 2.312715e-001, 2.312844e-001, 2.312974e-001, 2.313103e-001, 2.313233e-001, 2.313362e-001, 2.313492e-001, 2.313621e-001, 2.313750e-001, 2.313880e-001, 2.314009e-001, 2.314139e-001, 2.314268e-001, 2.314397e-001, 2.314527e-001, 2.314656e-001, 2.314785e-001, 2.314915e-001, 2.315044e-001, 2.315173e-001, 2.315303e-001, 2.315432e-001, 
2.315561e-001, 2.315690e-001, 2.315820e-001, 2.315949e-001, 2.316078e-001, 2.316207e-001, 2.316337e-001, 2.316466e-001, 2.316595e-001, 2.316724e-001, 2.316853e-001, 2.316982e-001, 2.317112e-001, 2.317241e-001, 2.317370e-001, 2.317499e-001, 2.317628e-001, 2.317757e-001, 2.317886e-001, 2.318015e-001, 2.318144e-001, 2.318273e-001, 2.318403e-001, 2.318532e-001, 2.318661e-001, 2.318790e-001, 2.318919e-001, 2.319048e-001, 2.319177e-001, 2.319306e-001, 2.319435e-001, 2.319564e-001, 2.319692e-001, 2.319821e-001, 2.319950e-001, 2.320079e-001, 2.320208e-001, 2.320337e-001, 2.320466e-001, 2.320595e-001, 2.320724e-001, 2.320853e-001, 2.320981e-001, 2.321110e-001, 2.321239e-001, 2.321368e-001, 2.321497e-001, 2.321626e-001, 2.321754e-001, 2.321883e-001, 2.322012e-001, 2.322141e-001, 2.322269e-001, 2.322398e-001, 2.322527e-001, 2.322656e-001, 2.322784e-001, 2.322913e-001, 2.323042e-001, 2.323170e-001, 2.323299e-001, 2.323428e-001, 2.323556e-001, 2.323685e-001, 2.323814e-001, 2.323942e-001, 2.324071e-001, 2.324200e-001, 2.324328e-001, 2.324457e-001, 2.324585e-001, 2.324714e-001, 2.324842e-001, 2.324971e-001, 2.325100e-001, 2.325228e-001, 2.325357e-001, 2.325485e-001, 2.325614e-001, 2.325742e-001, 2.325871e-001, 2.325999e-001, 2.326128e-001, 2.326256e-001, 2.326384e-001, 2.326513e-001, 2.326641e-001, 2.326770e-001, 2.326898e-001, 2.327026e-001, 2.327155e-001, 2.327283e-001, 2.327412e-001, 2.327540e-001, 2.327668e-001, 2.327797e-001, 2.327925e-001, 2.328053e-001, 2.328182e-001, 2.328310e-001, 
2.328438e-001, 2.328566e-001, 2.328695e-001, 2.328823e-001, 2.328951e-001, 2.329079e-001, 2.329208e-001, 2.329336e-001, 2.329464e-001, 2.329592e-001, 2.329720e-001, 2.329849e-001, 2.329977e-001, 2.330105e-001, 2.330233e-001, 2.330361e-001, 2.330489e-001, 2.330617e-001, 2.330746e-001, 2.330874e-001, 2.331002e-001, 2.331130e-001, 2.331258e-001, 2.331386e-001, 2.331514e-001, 2.331642e-001, 2.331770e-001, 2.331898e-001, 2.332026e-001, 2.332154e-001, 2.332282e-001, 2.332410e-001, 2.332538e-001, 2.332666e-001, 2.332794e-001, 2.332922e-001, 2.333050e-001, 2.333178e-001, 2.333306e-001, 2.333434e-001, 2.333561e-001, 2.333689e-001, 2.333817e-001, 2.333945e-001, 2.334073e-001, 2.334201e-001, 2.334329e-001, 2.334456e-001, 2.334584e-001, 2.334712e-001, 2.334840e-001, 2.334968e-001, 2.335095e-001, 2.335223e-001, 2.335351e-001, 2.335479e-001, 2.335606e-001, 2.335734e-001, 2.335862e-001, 2.335990e-001, 2.336117e-001, 2.336245e-001, 2.336373e-001, 2.336500e-001, 2.336628e-001, 2.336756e-001, 2.336883e-001, 2.337011e-001, 2.337138e-001, 2.337266e-001, 2.337394e-001, 2.337521e-001, 2.337649e-001, 2.337776e-001, 2.337904e-001, 2.338031e-001, 2.338159e-001, 2.338287e-001, 2.338414e-001, 2.338542e-001, 2.338669e-001, 2.338797e-001, 2.338924e-001, 2.339052e-001, 2.339179e-001, 2.339306e-001, 2.339434e-001, 2.339561e-001, 2.339689e-001, 2.339816e-001, 2.339944e-001, 2.340071e-001, 2.340198e-001, 2.340326e-001, 2.340453e-001, 2.340580e-001, 2.340708e-001, 2.340835e-001, 2.340962e-001, 2.341090e-001, 
2.341217e-001, 2.341344e-001, 2.341472e-001, 2.341599e-001, 2.341726e-001, 2.341853e-001, 2.341981e-001, 2.342108e-001, 2.342235e-001, 2.342362e-001, 2.342490e-001, 2.342617e-001, 2.342744e-001, 2.342871e-001, 2.342998e-001, 2.343126e-001, 2.343253e-001, 2.343380e-001, 2.343507e-001, 2.343634e-001, 2.343761e-001, 2.343888e-001, 2.344015e-001, 2.344142e-001, 2.344270e-001, 2.344397e-001, 2.344524e-001, 2.344651e-001, 2.344778e-001, 2.344905e-001, 2.345032e-001, 2.345159e-001, 2.345286e-001, 2.345413e-001, 2.345540e-001, 2.345667e-001, 2.345794e-001, 2.345921e-001, 2.346048e-001, 2.346175e-001, 2.346301e-001, 2.346428e-001, 2.346555e-001, 2.346682e-001, 2.346809e-001, 2.346936e-001, 2.347063e-001, 2.347190e-001, 2.347316e-001, 2.347443e-001, 2.347570e-001, 2.347697e-001, 2.347824e-001, 2.347951e-001, 2.348077e-001, 2.348204e-001, 2.348331e-001, 2.348458e-001, 2.348584e-001, 2.348711e-001, 2.348838e-001, 2.348965e-001, 2.349091e-001, 2.349218e-001, 2.349345e-001, 2.349471e-001, 2.349598e-001, 2.349725e-001, 2.349851e-001, 2.349978e-001, 2.350105e-001, 2.350231e-001, 2.350358e-001, 2.350484e-001, 2.350611e-001, 2.350738e-001, 2.350864e-001, 2.350991e-001, 2.351117e-001, 2.351244e-001, 2.351370e-001, 2.351497e-001, 2.351623e-001, 2.351750e-001, 2.351876e-001, 2.352003e-001, 2.352129e-001, 2.352256e-001, 2.352382e-001, 2.352509e-001, 2.352635e-001, 2.352762e-001, 2.352888e-001, 2.353014e-001, 2.353141e-001, 2.353267e-001, 2.353394e-001, 2.353520e-001, 2.353646e-001, 2.353773e-001, 
2.353899e-001, 2.354025e-001, 2.354152e-001, 2.354278e-001, 2.354404e-001, 2.354531e-001, 2.354657e-001, 2.354783e-001, 2.354909e-001, 2.355036e-001, 2.355162e-001, 2.355288e-001, 2.355414e-001, 2.355541e-001, 2.355667e-001, 2.355793e-001, 2.355919e-001, 2.356045e-001, 2.356171e-001, 2.356298e-001, 2.356424e-001, 2.356550e-001, 2.356676e-001, 2.356802e-001, 2.356928e-001, 2.357054e-001, 2.357180e-001, 2.357307e-001, 2.357433e-001, 2.357559e-001, 2.357685e-001, 2.357811e-001, 2.357937e-001, 2.358063e-001, 2.358189e-001, 2.358315e-001, 2.358441e-001, 2.358567e-001, 2.358693e-001, 2.358819e-001, 2.358945e-001, 2.359071e-001, 2.359197e-001, 2.359323e-001, 2.359448e-001, 2.359574e-001, 2.359700e-001, 2.359826e-001, 2.359952e-001, 2.360078e-001, 2.360204e-001, 2.360330e-001, 2.360455e-001, 2.360581e-001, 2.360707e-001, 2.360833e-001, 2.360959e-001, 2.361085e-001, 2.361210e-001, 2.361336e-001, 2.361462e-001, 2.361588e-001, 2.361713e-001, 2.361839e-001, 2.361965e-001, 2.362091e-001, 2.362216e-001, 2.362342e-001, 2.362468e-001, 2.362593e-001, 2.362719e-001, 2.362845e-001, 2.362970e-001, 2.363096e-001, 2.363222e-001, 2.363347e-001, 2.363473e-001, 2.363598e-001, 2.363724e-001, 2.363850e-001, 2.363975e-001, 2.364101e-001, 2.364226e-001, 2.364352e-001, 2.364477e-001, 2.364603e-001, 2.364728e-001, 2.364854e-001, 2.364979e-001, 2.365105e-001, 2.365230e-001, 2.365356e-001, 2.365481e-001, 2.365607e-001, 2.365732e-001, 2.365858e-001, 2.365983e-001, 2.366108e-001, 2.366234e-001, 2.366359e-001, 
2.366485e-001, 2.366610e-001, 2.366735e-001, 2.366861e-001, 2.366986e-001, 2.367111e-001, 2.367237e-001, 2.367362e-001, 2.367487e-001, 2.367613e-001, 2.367738e-001, 2.367863e-001, 2.367989e-001, 2.368114e-001, 2.368239e-001, 2.368364e-001, 2.368490e-001, 2.368615e-001, 2.368740e-001, 2.368865e-001, 2.368990e-001, 2.369116e-001, 2.369241e-001, 2.369366e-001, 2.369491e-001, 2.369616e-001, 2.369741e-001, 2.369866e-001, 2.369992e-001, 2.370117e-001, 2.370242e-001, 2.370367e-001, 2.370492e-001, 2.370617e-001, 2.370742e-001, 2.370867e-001, 2.370992e-001, 2.371117e-001, 2.371242e-001, 2.371367e-001, 2.371492e-001, 2.371617e-001, 2.371742e-001, 2.371867e-001, 2.371992e-001, 2.372117e-001, 2.372242e-001, 2.372367e-001, 2.372492e-001, 2.372617e-001, 2.372742e-001, 2.372867e-001, 2.372992e-001, 2.373116e-001, 2.373241e-001, 2.373366e-001, 2.373491e-001, 2.373616e-001, 2.373741e-001, 2.373866e-001, 2.373990e-001, 2.374115e-001, 2.374240e-001, 2.374365e-001, 2.374489e-001, 2.374614e-001, 2.374739e-001, 2.374864e-001, 2.374989e-001, 2.375113e-001, 2.375238e-001, 2.375363e-001, 2.375487e-001, 2.375612e-001, 2.375737e-001, 2.375861e-001, 2.375986e-001, 2.376111e-001, 2.376235e-001, 2.376360e-001, 2.376485e-001, 2.376609e-001, 2.376734e-001, 2.376858e-001, 2.376983e-001, 2.377108e-001, 2.377232e-001, 2.377357e-001, 2.377481e-001, 2.377606e-001, 2.377730e-001, 2.377855e-001, 2.377979e-001, 2.378104e-001, 2.378228e-001, 2.378353e-001, 2.378477e-001, 2.378602e-001, 2.378726e-001, 2.378851e-001, 
2.378975e-001, 2.379100e-001, 2.379224e-001, 2.379348e-001, 2.379473e-001, 2.379597e-001, 2.379722e-001, 2.379846e-001, 2.379970e-001, 2.380095e-001, 2.380219e-001, 2.380343e-001, 2.380468e-001, 2.380592e-001, 2.380716e-001, 2.380841e-001, 2.380965e-001, 2.381089e-001, 2.381213e-001, 2.381338e-001, 2.381462e-001, 2.381586e-001, 2.381710e-001, 2.381835e-001, 2.381959e-001, 2.382083e-001, 2.382207e-001, 2.382331e-001, 2.382456e-001, 2.382580e-001, 2.382704e-001, 2.382828e-001, 2.382952e-001, 2.383076e-001, 2.383200e-001, 2.383324e-001, 2.383449e-001, 2.383573e-001, 2.383697e-001, 2.383821e-001, 2.383945e-001, 2.384069e-001, 2.384193e-001, 2.384317e-001, 2.384441e-001, 2.384565e-001, 2.384689e-001, 2.384813e-001, 2.384937e-001, 2.385061e-001, 2.385185e-001, 2.385309e-001, 2.385433e-001, 2.385557e-001, 2.385681e-001, 2.385805e-001, 2.385929e-001, 2.386052e-001, 2.386176e-001, 2.386300e-001, 2.386424e-001, 2.386548e-001, 2.386672e-001, 2.386796e-001, 2.386919e-001, 2.387043e-001, 2.387167e-001, 2.387291e-001, 2.387415e-001, 2.387539e-001, 2.387662e-001, 2.387786e-001, 2.387910e-001, 2.388034e-001, 2.388157e-001, 2.388281e-001, 2.388405e-001, 2.388528e-001, 2.388652e-001, 2.388776e-001, 2.388900e-001, 2.389023e-001, 2.389147e-001, 2.389271e-001, 2.389394e-001, 2.389518e-001, 2.389641e-001, 2.389765e-001, 2.389889e-001, 2.390012e-001, 2.390136e-001, 2.390259e-001, 2.390383e-001, 2.390507e-001, 2.390630e-001, 2.390754e-001, 2.390877e-001, 2.391001e-001, 2.391124e-001, 2.391248e-001, 
2.391371e-001, 2.391495e-001, 2.391618e-001, 2.391742e-001, 2.391865e-001, 2.391989e-001, 2.392112e-001, 2.392236e-001, 2.392359e-001, 2.392482e-001, 2.392606e-001, 2.392729e-001, 2.392853e-001, 2.392976e-001, 2.393099e-001, 2.393223e-001, 2.393346e-001, 2.393469e-001, 2.393593e-001, 2.393716e-001, 2.393839e-001, 2.393963e-001, 2.394086e-001, 2.394209e-001, 2.394332e-001, 2.394456e-001, 2.394579e-001, 2.394702e-001, 2.394825e-001, 2.394949e-001, 2.395072e-001, 2.395195e-001, 2.395318e-001, 2.395441e-001, 2.395565e-001, 2.395688e-001, 2.395811e-001, 2.395934e-001, 2.396057e-001, 2.396180e-001, 2.396304e-001, 2.396427e-001, 2.396550e-001, 2.396673e-001, 2.396796e-001, 2.396919e-001, 2.397042e-001, 2.397165e-001, 2.397288e-001, 2.397411e-001, 2.397534e-001, 2.397657e-001, 2.397780e-001, 2.397903e-001, 2.398026e-001, 2.398149e-001, 2.398272e-001, 2.398395e-001, 2.398518e-001, 2.398641e-001, 2.398764e-001, 2.398887e-001, 2.399010e-001, 2.399133e-001, 2.399256e-001, 2.399379e-001, 2.399501e-001, 2.399624e-001, 2.399747e-001, 2.399870e-001, 2.399993e-001, 2.400116e-001, 2.400239e-001, 2.400361e-001, 2.400484e-001, 2.400607e-001, 2.400730e-001, 2.400853e-001, 2.400975e-001, 2.401098e-001, 2.401221e-001, 2.401344e-001, 2.401466e-001, 2.401589e-001, 2.401712e-001, 2.401834e-001, 2.401957e-001, 2.402080e-001, 2.402203e-001, 2.402325e-001, 2.402448e-001, 2.402571e-001, 2.402693e-001, 2.402816e-001, 2.402938e-001, 2.403061e-001, 2.403184e-001, 2.403306e-001, 2.403429e-001, 2.403551e-001, 
2.403674e-001, 2.403797e-001, 2.403919e-001, 2.404042e-001, 2.404164e-001, 2.404287e-001, 2.404409e-001, 2.404532e-001, 2.404654e-001, 2.404777e-001, 2.404899e-001, 2.405022e-001, 2.405144e-001, 2.405267e-001, 2.405389e-001, 2.405511e-001, 2.405634e-001, 2.405756e-001, 2.405879e-001, 2.406001e-001, 2.406123e-001, 2.406246e-001, 2.406368e-001, 2.406490e-001, 2.406613e-001, 2.406735e-001, 2.406857e-001, 2.406980e-001, 2.407102e-001, 2.407224e-001, 2.407347e-001, 2.407469e-001, 2.407591e-001, 2.407713e-001, 2.407836e-001, 2.407958e-001, 2.408080e-001, 2.408202e-001, 2.408325e-001, 2.408447e-001, 2.408569e-001, 2.408691e-001, 2.408813e-001, 2.408936e-001, 2.409058e-001, 2.409180e-001, 2.409302e-001, 2.409424e-001, 2.409546e-001, 2.409668e-001, 2.409791e-001, 2.409913e-001, 2.410035e-001, 2.410157e-001, 2.410279e-001, 2.410401e-001, 2.410523e-001, 2.410645e-001, 2.410767e-001, 2.410889e-001, 2.411011e-001, 2.411133e-001, 2.411255e-001, 2.411377e-001, 2.411499e-001, 2.411621e-001, 2.411743e-001, 2.411865e-001, 2.411987e-001, 2.412109e-001, 2.412231e-001, 2.412353e-001, 2.412475e-001, 2.412596e-001, 2.412718e-001, 2.412840e-001, 2.412962e-001, 2.413084e-001, 2.413206e-001, 2.413328e-001, 2.413449e-001, 2.413571e-001, 2.413693e-001, 2.413815e-001, 2.413937e-001, 2.414058e-001, 2.414180e-001, 2.414302e-001, 2.414424e-001, 2.414545e-001, 2.414667e-001, 2.414789e-001, 2.414911e-001, 2.415032e-001, 2.415154e-001, 2.415276e-001, 2.415397e-001, 2.415519e-001, 2.415641e-001, 2.415762e-001, 
2.415884e-001, 2.416006e-001, 2.416127e-001, 2.416249e-001, 2.416371e-001, 2.416492e-001, 2.416614e-001, 2.416735e-001, 2.416857e-001, 2.416978e-001, 2.417100e-001, 2.417222e-001, 2.417343e-001, 2.417465e-001, 2.417586e-001, 2.417708e-001, 2.417829e-001, 2.417951e-001, 2.418072e-001, 2.418194e-001, 2.418315e-001, 2.418436e-001, 2.418558e-001, 2.418679e-001, 2.418801e-001, 2.418922e-001, 2.419044e-001, 2.419165e-001, 2.419286e-001, 2.419408e-001, 2.419529e-001, 2.419651e-001, 2.419772e-001, 2.419893e-001, 2.420015e-001, 2.420136e-001, 2.420257e-001, 2.420378e-001, 2.420500e-001, 2.420621e-001, 2.420742e-001, 2.420864e-001, 2.420985e-001, 2.421106e-001, 2.421227e-001, 2.421349e-001, 2.421470e-001, 2.421591e-001, 2.421712e-001, 2.421833e-001, 2.421955e-001, 2.422076e-001, 2.422197e-001, 2.422318e-001, 2.422439e-001, 2.422560e-001, 2.422682e-001, 2.422803e-001, 2.422924e-001, 2.423045e-001, 2.423166e-001, 2.423287e-001, 2.423408e-001, 2.423529e-001, 2.423650e-001, 2.423771e-001, 2.423892e-001, 2.424013e-001, 2.424134e-001, 2.424255e-001, 2.424376e-001, 2.424497e-001, 2.424618e-001, 2.424739e-001, 2.424860e-001, 2.424981e-001, 2.425102e-001, 2.425223e-001, 2.425344e-001, 2.425465e-001, 2.425586e-001, 2.425707e-001, 2.425828e-001, 2.425949e-001, 2.426070e-001, 2.426190e-001, 2.426311e-001, 2.426432e-001, 2.426553e-001, 2.426674e-001, 2.426795e-001, 2.426915e-001, 2.427036e-001, 2.427157e-001, 2.427278e-001, 2.427399e-001, 2.427519e-001, 2.427640e-001, 2.427761e-001, 2.427882e-001, 
2.428002e-001, 2.428123e-001, 2.428244e-001, 2.428365e-001, 2.428485e-001, 2.428606e-001, 2.428727e-001, 2.428847e-001, 2.428968e-001, 2.429089e-001, 2.429209e-001, 2.429330e-001, 2.429450e-001, 2.429571e-001, 2.429692e-001, 2.429812e-001, 2.429933e-001, 2.430053e-001, 2.430174e-001, 2.430295e-001, 2.430415e-001, 2.430536e-001, 2.430656e-001, 2.430777e-001, 2.430897e-001, 2.431018e-001, 2.431138e-001, 2.431259e-001, 2.431379e-001, 2.431500e-001, 2.431620e-001, 2.431741e-001, 2.431861e-001, 2.431981e-001, 2.432102e-001, 2.432222e-001, 2.432343e-001, 2.432463e-001, 2.432583e-001, 2.432704e-001, 2.432824e-001, 2.432945e-001, 2.433065e-001, 2.433185e-001, 2.433306e-001, 2.433426e-001, 2.433546e-001, 2.433667e-001, 2.433787e-001, 2.433907e-001, 2.434027e-001, 2.434148e-001, 2.434268e-001, 2.434388e-001, 2.434508e-001, 2.434629e-001, 2.434749e-001, 2.434869e-001, 2.434989e-001, 2.435110e-001, 2.435230e-001, 2.435350e-001, 2.435470e-001, 2.435590e-001, 2.435710e-001, 2.435831e-001, 2.435951e-001, 2.436071e-001, 2.436191e-001, 2.436311e-001, 2.436431e-001, 2.436551e-001, 2.436671e-001, 2.436791e-001, 2.436911e-001, 2.437031e-001, 2.437151e-001, 2.437272e-001, 2.437392e-001, 2.437512e-001, 2.437632e-001, 2.437752e-001, 2.437872e-001, 2.437992e-001, 2.438112e-001, 2.438231e-001, 2.438351e-001, 2.438471e-001, 2.438591e-001, 2.438711e-001, 2.438831e-001, 2.438951e-001, 2.439071e-001, 2.439191e-001, 2.439311e-001, 2.439431e-001, 2.439550e-001, 2.439670e-001, 2.439790e-001, 2.439910e-001, 
2.440030e-001, 2.440150e-001, 2.440269e-001, 2.440389e-001, 2.440509e-001, 2.440629e-001, 2.440749e-001, 2.440868e-001, 2.440988e-001, 2.441108e-001, 2.441228e-001, 2.441347e-001, 2.441467e-001, 2.441587e-001, 2.441706e-001, 2.441826e-001, 2.441946e-001, 2.442066e-001, 2.442185e-001, 2.442305e-001, 2.442424e-001, 2.442544e-001, 2.442664e-001, 2.442783e-001, 2.442903e-001, 2.443023e-001, 2.443142e-001, 2.443262e-001, 2.443381e-001, 2.443501e-001, 2.443620e-001, 2.443740e-001, 2.443860e-001, 2.443979e-001, 2.444099e-001, 2.444218e-001, 2.444338e-001, 2.444457e-001, 2.444577e-001, 2.444696e-001, 2.444816e-001, 2.444935e-001, 2.445054e-001, 2.445174e-001, 2.445293e-001, 2.445413e-001, 2.445532e-001, 2.445652e-001, 2.445771e-001, 2.445890e-001, 2.446010e-001, 2.446129e-001, 2.446248e-001, 2.446368e-001, 2.446487e-001, 2.446606e-001, 2.446726e-001, 2.446845e-001, 2.446964e-001, 2.447084e-001, 2.447203e-001, 2.447322e-001, 2.447442e-001, 2.447561e-001, 2.447680e-001, 2.447799e-001, 2.447919e-001, 2.448038e-001, 2.448157e-001, 2.448276e-001, 2.448395e-001, 2.448515e-001, 2.448634e-001, 2.448753e-001, 2.448872e-001, 2.448991e-001, 2.449110e-001, 2.449230e-001, 2.449349e-001, 2.449468e-001, 2.449587e-001, 2.449706e-001, 2.449825e-001, 2.449944e-001, 2.450063e-001, 2.450182e-001, 2.450301e-001, 2.450420e-001, 2.450539e-001, 2.450658e-001, 2.450777e-001, 2.450896e-001, 2.451015e-001, 2.451134e-001, 2.451253e-001, 2.451372e-001, 2.451491e-001, 2.451610e-001, 2.451729e-001, 2.451848e-001, 
2.451967e-001, 2.452086e-001, 2.452205e-001, 2.452324e-001, 2.452443e-001, 2.452562e-001, 2.452681e-001, 2.452799e-001, 2.452918e-001, 2.453037e-001, 2.453156e-001, 2.453275e-001, 2.453394e-001, 2.453512e-001, 2.453631e-001, 2.453750e-001, 2.453869e-001, 2.453988e-001, 2.454106e-001, 2.454225e-001, 2.454344e-001, 2.454463e-001, 2.454581e-001, 2.454700e-001, 2.454819e-001, 2.454938e-001, 2.455056e-001, 2.455175e-001, 2.455294e-001, 2.455412e-001, 2.455531e-001, 2.455650e-001, 2.455768e-001, 2.455887e-001, 2.456005e-001, 2.456124e-001, 2.456243e-001, 2.456361e-001, 2.456480e-001, 2.456598e-001, 2.456717e-001, 2.456836e-001, 2.456954e-001, 2.457073e-001, 2.457191e-001, 2.457310e-001, 2.457428e-001, 2.457547e-001, 2.457665e-001, 2.457784e-001, 2.457902e-001, 2.458021e-001, 2.458139e-001, 2.458258e-001, 2.458376e-001, 2.458495e-001, 2.458613e-001, 2.458731e-001, 2.458850e-001, 2.458968e-001, 2.459087e-001, 2.459205e-001, 2.459323e-001, 2.459442e-001, 2.459560e-001, 2.459679e-001, 2.459797e-001, 2.459915e-001, 2.460034e-001, 2.460152e-001, 2.460270e-001, 2.460388e-001, 2.460507e-001, 2.460625e-001, 2.460743e-001, 2.460862e-001, 2.460980e-001, 2.461098e-001, 2.461216e-001, 2.461335e-001, 2.461453e-001, 2.461571e-001, 2.461689e-001, 2.461807e-001, 2.461926e-001, 2.462044e-001, 2.462162e-001, 2.462280e-001, 2.462398e-001, 2.462516e-001, 2.462634e-001, 2.462753e-001, 2.462871e-001, 2.462989e-001, 2.463107e-001, 2.463225e-001, 2.463343e-001, 2.463461e-001, 2.463579e-001, 2.463697e-001, 
2.463815e-001, 2.463933e-001, 2.464051e-001, 2.464169e-001, 2.464287e-001, 2.464405e-001, 2.464523e-001, 2.464641e-001, 2.464759e-001, 2.464877e-001, 2.464995e-001, 2.465113e-001, 2.465231e-001, 2.465349e-001, 2.465467e-001, 2.465585e-001, 2.465703e-001, 2.465821e-001, 2.465938e-001, 2.466056e-001, 2.466174e-001, 2.466292e-001, 2.466410e-001, 2.466528e-001, 2.466646e-001, 2.466763e-001, 2.466881e-001, 2.466999e-001, 2.467117e-001, 2.467235e-001, 2.467352e-001, 2.467470e-001, 2.467588e-001, 2.467706e-001, 2.467823e-001, 2.467941e-001, 2.468059e-001, 2.468177e-001, 2.468294e-001, 2.468412e-001, 2.468530e-001, 2.468647e-001, 2.468765e-001, 2.468883e-001, 2.469000e-001, 2.469118e-001, 2.469236e-001, 2.469353e-001, 2.469471e-001, 2.469588e-001, 2.469706e-001, 2.469824e-001, 2.469941e-001, 2.470059e-001, 2.470176e-001, 2.470294e-001, 2.470411e-001, 2.470529e-001, 2.470647e-001, 2.470764e-001, 2.470882e-001, 2.470999e-001, 2.471117e-001, 2.471234e-001, 2.471351e-001, 2.471469e-001, 2.471586e-001, 2.471704e-001, 2.471821e-001, 2.471939e-001, 2.472056e-001, 2.472174e-001, 2.472291e-001, 2.472408e-001, 2.472526e-001, 2.472643e-001, 2.472761e-001, 2.472878e-001, 2.472995e-001, 2.473113e-001, 2.473230e-001, 2.473347e-001, 2.473465e-001, 2.473582e-001, 2.473699e-001, 2.473816e-001, 2.473934e-001, 2.474051e-001, 2.474168e-001, 2.474286e-001, 2.474403e-001, 2.474520e-001, 2.474637e-001, 2.474754e-001, 2.474872e-001, 2.474989e-001, 2.475106e-001, 2.475223e-001, 2.475340e-001, 2.475458e-001, 
2.475575e-001, 2.475692e-001, 2.475809e-001, 2.475926e-001, 2.476043e-001, 2.476160e-001, 2.476278e-001, 2.476395e-001, 2.476512e-001, 2.476629e-001, 2.476746e-001, 2.476863e-001, 2.476980e-001, 2.477097e-001, 2.477214e-001, 2.477331e-001, 2.477448e-001, 2.477565e-001, 2.477682e-001, 2.477799e-001, 2.477916e-001, 2.478033e-001, 2.478150e-001, 2.478267e-001, 2.478384e-001, 2.478501e-001, 2.478618e-001, 2.478735e-001, 2.478852e-001, 2.478969e-001, 2.479086e-001, 2.479202e-001, 2.479319e-001, 2.479436e-001, 2.479553e-001, 2.479670e-001, 2.479787e-001, 2.479904e-001, 2.480020e-001, 2.480137e-001, 2.480254e-001, 2.480371e-001, 2.480488e-001, 2.480604e-001, 2.480721e-001, 2.480838e-001, 2.480955e-001, 2.481071e-001, 2.481188e-001, 2.481305e-001, 2.481422e-001, 2.481538e-001, 2.481655e-001, 2.481772e-001, 2.481888e-001, 2.482005e-001, 2.482122e-001, 2.482238e-001, 2.482355e-001, 2.482472e-001, 2.482588e-001, 2.482705e-001, 2.482822e-001, 2.482938e-001, 2.483055e-001, 2.483171e-001, 2.483288e-001, 2.483405e-001, 2.483521e-001, 2.483638e-001, 2.483754e-001, 2.483871e-001, 2.483987e-001, 2.484104e-001, 2.484220e-001, 2.484337e-001, 2.484453e-001, 2.484570e-001, 2.484686e-001, 2.484803e-001, 2.484919e-001, 2.485036e-001, 2.485152e-001, 2.485269e-001, 2.485385e-001, 2.485501e-001, 2.485618e-001, 2.485734e-001, 2.485851e-001, 2.485967e-001, 2.486083e-001, 2.486200e-001, 2.486316e-001, 2.486432e-001, 2.486549e-001, 2.486665e-001, 2.486781e-001, 2.486898e-001, 2.487014e-001, 2.487130e-001, 
2.487247e-001, 2.487363e-001, 2.487479e-001, 2.487595e-001, 2.487712e-001, 2.487828e-001, 2.487944e-001, 2.488060e-001, 2.488177e-001, 2.488293e-001, 2.488409e-001, 2.488525e-001, 2.488641e-001, 2.488758e-001, 2.488874e-001, 2.488990e-001, 2.489106e-001, 2.489222e-001, 2.489338e-001, 2.489454e-001, 2.489571e-001, 2.489687e-001, 2.489803e-001, 2.489919e-001, 2.490035e-001, 2.490151e-001, 2.490267e-001, 2.490383e-001, 2.490499e-001, 2.490615e-001, 2.490731e-001, 2.490847e-001, 2.490963e-001, 2.491079e-001, 2.491195e-001, 2.491311e-001, 2.491427e-001, 2.491543e-001, 2.491659e-001, 2.491775e-001, 2.491891e-001, 2.492007e-001, 2.492123e-001, 2.492239e-001, 2.492355e-001, 2.492471e-001, 2.492586e-001, 2.492702e-001, 2.492818e-001, 2.492934e-001, 2.493050e-001, 2.493166e-001, 2.493282e-001, 2.493397e-001, 2.493513e-001, 2.493629e-001, 2.493745e-001, 2.493861e-001, 2.493976e-001, 2.494092e-001, 2.494208e-001, 2.494324e-001, 2.494439e-001, 2.494555e-001, 2.494671e-001, 2.494787e-001, 2.494902e-001, 2.495018e-001, 2.495134e-001, 2.495249e-001, 2.495365e-001, 2.495481e-001, 2.495596e-001, 2.495712e-001, 2.495828e-001, 2.495943e-001, 2.496059e-001, 2.496175e-001, 2.496290e-001, 2.496406e-001, 2.496521e-001, 2.496637e-001, 2.496753e-001, 2.496868e-001, 2.496984e-001, 2.497099e-001, 2.497215e-001, 2.497330e-001, 2.497446e-001, 2.497561e-001, 2.497677e-001, 2.497792e-001, 2.497908e-001, 2.498023e-001, 2.498139e-001, 2.498254e-001, 2.498370e-001, 2.498485e-001, 2.498601e-001, 2.498716e-001, 
2.498832e-001, 2.498947e-001, 2.499062e-001, 2.499178e-001, 2.499293e-001, 2.499408e-001, 2.499524e-001, 2.499639e-001, 2.499755e-001, 2.499870e-001, 2.499985e-001, 2.500101e-001, 2.500216e-001, 2.500331e-001, 2.500446e-001, 2.500562e-001, 2.500677e-001, 2.500792e-001, 2.500908e-001, 2.501023e-001, 2.501138e-001, 2.501253e-001, 2.501369e-001, 2.501484e-001, 2.501599e-001, 2.501714e-001, 2.501829e-001, 2.501945e-001, 2.502060e-001, 2.502175e-001, 2.502290e-001, 2.502405e-001, 2.502520e-001, 2.502636e-001, 2.502751e-001, 2.502866e-001, 2.502981e-001, 2.503096e-001, 2.503211e-001, 2.503326e-001, 2.503441e-001, 2.503556e-001, 2.503671e-001, 2.503786e-001, 2.503901e-001, 2.504017e-001, 2.504132e-001, 2.504247e-001, 2.504362e-001, 2.504477e-001, 2.504592e-001, 2.504707e-001, 2.504822e-001, 2.504936e-001, 2.505051e-001, 2.505166e-001, 2.505281e-001, 2.505396e-001, 2.505511e-001, 2.505626e-001, 2.505741e-001, 2.505856e-001, 2.505971e-001, 2.506086e-001, 2.506201e-001, 2.506315e-001, 2.506430e-001, 2.506545e-001, 2.506660e-001, 2.506775e-001, 2.506890e-001, 2.507004e-001, 2.507119e-001, 2.507234e-001, 2.507349e-001, 2.507464e-001, 2.507578e-001, 2.507693e-001, 2.507808e-001, 2.507923e-001, 2.508037e-001, 2.508152e-001, 2.508267e-001, 2.508381e-001, 2.508496e-001, 2.508611e-001, 2.508726e-001, 2.508840e-001, 2.508955e-001, 2.509070e-001, 2.509184e-001, 2.509299e-001, 2.509413e-001, 2.509528e-001, 2.509643e-001, 2.509757e-001, 2.509872e-001, 2.509986e-001, 2.510101e-001, 2.510216e-001, 
2.510330e-001, 2.510445e-001, 2.510559e-001, 2.510674e-001, 2.510788e-001, 2.510903e-001, 2.511017e-001, 2.511132e-001, 2.511246e-001, 2.511361e-001, 2.511475e-001, 2.511590e-001, 2.511704e-001, 2.511819e-001, 2.511933e-001, 2.512048e-001, 2.512162e-001, 2.512276e-001, 2.512391e-001, 2.512505e-001, 2.512620e-001, 2.512734e-001, 2.512848e-001, 2.512963e-001, 2.513077e-001, 2.513191e-001, 2.513306e-001, 2.513420e-001, 2.513534e-001, 2.513649e-001, 2.513763e-001, 2.513877e-001, 2.513992e-001, 2.514106e-001, 2.514220e-001, 2.514334e-001, 2.514449e-001, 2.514563e-001, 2.514677e-001, 2.514791e-001, 2.514906e-001, 2.515020e-001, 2.515134e-001, 2.515248e-001, 2.515362e-001, 2.515477e-001, 2.515591e-001, 2.515705e-001, 2.515819e-001, 2.515933e-001, 2.516047e-001, 2.516162e-001, 2.516276e-001, 2.516390e-001, 2.516504e-001, 2.516618e-001, 2.516732e-001, 2.516846e-001, 2.516960e-001, 2.517074e-001, 2.517188e-001, 2.517302e-001, 2.517416e-001, 2.517530e-001, 2.517644e-001, 2.517758e-001, 2.517872e-001, 2.517986e-001, 2.518100e-001, 2.518214e-001, 2.518328e-001, 2.518442e-001, 2.518556e-001, 2.518670e-001, 2.518784e-001, 2.518898e-001, 2.519012e-001, 2.519126e-001, 2.519240e-001, 2.519354e-001, 2.519468e-001, 2.519581e-001, 2.519695e-001, 2.519809e-001, 2.519923e-001, 2.520037e-001, 2.520151e-001, 2.520264e-001, 2.520378e-001, 2.520492e-001, 2.520606e-001, 2.520720e-001, 2.520833e-001, 2.520947e-001, 2.521061e-001, 2.521175e-001, 2.521288e-001, 2.521402e-001, 2.521516e-001, 2.521630e-001, 
2.521743e-001, 2.521857e-001, 2.521971e-001, 2.522084e-001, 2.522198e-001, 2.522312e-001, 2.522425e-001, 2.522539e-001, 2.522653e-001, 2.522766e-001, 2.522880e-001, 2.522994e-001, 2.523107e-001, 2.523221e-001, 2.523334e-001, 2.523448e-001, 2.523562e-001, 2.523675e-001, 2.523789e-001, 2.523902e-001, 2.524016e-001, 2.524129e-001, 2.524243e-001, 2.524356e-001, 2.524470e-001, 2.524583e-001, 2.524697e-001, 2.524810e-001, 2.524924e-001, 2.525037e-001, 2.525151e-001, 2.525264e-001, 2.525378e-001, 2.525491e-001, 2.525605e-001, 2.525718e-001, 2.525831e-001, 2.525945e-001, 2.526058e-001, 2.526172e-001, 2.526285e-001, 2.526398e-001, 2.526512e-001, 2.526625e-001, 2.526738e-001, 2.526852e-001, 2.526965e-001, 2.527078e-001, 2.527192e-001, 2.527305e-001, 2.527418e-001, 2.527531e-001, 2.527645e-001, 2.527758e-001, 2.527871e-001, 2.527984e-001, 2.528098e-001, 2.528211e-001, 2.528324e-001, 2.528437e-001, 2.528551e-001, 2.528664e-001, 2.528777e-001, 2.528890e-001, 2.529003e-001, 2.529116e-001, 2.529230e-001, 2.529343e-001, 2.529456e-001, 2.529569e-001, 2.529682e-001, 2.529795e-001, 2.529908e-001, 2.530021e-001, 2.530135e-001, 2.530248e-001, 2.530361e-001, 2.530474e-001, 2.530587e-001, 2.530700e-001, 2.530813e-001, 2.530926e-001, 2.531039e-001, 2.531152e-001, 2.531265e-001, 2.531378e-001, 2.531491e-001, 2.531604e-001, 2.531717e-001, 2.531830e-001, 2.531943e-001, 2.532056e-001, 2.532169e-001, 2.532282e-001, 2.532394e-001, 2.532507e-001, 2.532620e-001, 2.532733e-001, 2.532846e-001, 2.532959e-001, 
2.533072e-001, 2.533185e-001, 2.533298e-001, 2.533410e-001, 2.533523e-001, 2.533636e-001, 2.533749e-001, 2.533862e-001, 2.533974e-001, 2.534087e-001, 2.534200e-001, 2.534313e-001, 2.534426e-001, 2.534538e-001, 2.534651e-001, 2.534764e-001, 2.534877e-001, 2.534989e-001, 2.535102e-001, 2.535215e-001, 2.535327e-001, 2.535440e-001, 2.535553e-001, 2.535665e-001, 2.535778e-001, 2.535891e-001, 2.536003e-001, 2.536116e-001, 2.536229e-001, 2.536341e-001, 2.536454e-001, 2.536567e-001, 2.536679e-001, 2.536792e-001, 2.536904e-001, 2.537017e-001, 2.537129e-001, 2.537242e-001, 2.537355e-001, 2.537467e-001, 2.537580e-001, 2.537692e-001, 2.537805e-001, 2.537917e-001, 2.538030e-001, 2.538142e-001, 2.538255e-001, 2.538367e-001, 2.538480e-001, 2.538592e-001, 2.538704e-001, 2.538817e-001, 2.538929e-001, 2.539042e-001, 2.539154e-001, 2.539267e-001, 2.539379e-001, 2.539491e-001, 2.539604e-001, 2.539716e-001, 2.539829e-001, 2.539941e-001, 2.540053e-001, 2.540166e-001, 2.540278e-001, 2.540390e-001, 2.540503e-001, 2.540615e-001, 2.540727e-001, 2.540839e-001, 2.540952e-001, 2.541064e-001, 2.541176e-001, 2.541288e-001, 2.541401e-001, 2.541513e-001, 2.541625e-001, 2.541737e-001, 2.541850e-001, 2.541962e-001, 2.542074e-001, 2.542186e-001, 2.542298e-001, 2.542411e-001, 2.542523e-001, 2.542635e-001, 2.542747e-001, 2.542859e-001, 2.542971e-001, 2.543083e-001, 2.543196e-001, 2.543308e-001, 2.543420e-001, 2.543532e-001, 2.543644e-001, 2.543756e-001, 2.543868e-001, 2.543980e-001, 2.544092e-001, 2.544204e-001, 
2.544316e-001, 2.544428e-001, 2.544540e-001, 2.544652e-001, 2.544764e-001, 2.544876e-001, 2.544988e-001, 2.545100e-001, 2.545212e-001, 2.545324e-001, 2.545436e-001, 2.545548e-001, 2.545660e-001, 2.545772e-001, 2.545884e-001, 2.545996e-001, 2.546108e-001, 2.546219e-001, 2.546331e-001, 2.546443e-001, 2.546555e-001, 2.546667e-001, 2.546779e-001, 2.546891e-001, 2.547002e-001, 2.547114e-001, 2.547226e-001, 2.547338e-001, 2.547450e-001, 2.547562e-001, 2.547673e-001, 2.547785e-001, 2.547897e-001, 2.548009e-001, 2.548120e-001, 2.548232e-001, 2.548344e-001, 2.548456e-001, 2.548567e-001, 2.548679e-001, 2.548791e-001, 2.548902e-001, 2.549014e-001, 2.549126e-001, 2.549237e-001, 2.549349e-001, 2.549461e-001, 2.549572e-001, 2.549684e-001, 2.549796e-001, 2.549907e-001, 2.550019e-001, 2.550130e-001, 2.550242e-001, 2.550354e-001, 2.550465e-001, 2.550577e-001, 2.550688e-001, 2.550800e-001, 2.550911e-001, 2.551023e-001, 2.551134e-001, 2.551246e-001, 2.551357e-001, 2.551469e-001, 2.551580e-001, 2.551692e-001, 2.551803e-001, 2.551915e-001, 2.552026e-001, 2.552138e-001, 2.552249e-001, 2.552361e-001, 2.552472e-001, 2.552583e-001, 2.552695e-001, 2.552806e-001, 2.552918e-001, 2.553029e-001, 2.553140e-001, 2.553252e-001, 2.553363e-001, 2.553474e-001, 2.553586e-001, 2.553697e-001, 2.553808e-001, 2.553920e-001, 2.554031e-001, 2.554142e-001, 2.554254e-001, 2.554365e-001, 2.554476e-001, 2.554587e-001, 2.554699e-001, 2.554810e-001, 2.554921e-001, 2.555032e-001, 2.555144e-001, 2.555255e-001, 2.555366e-001, 
2.555477e-001, 2.555589e-001, 2.555700e-001, 2.555811e-001, 2.555922e-001, 2.556033e-001, 2.556144e-001, 2.556256e-001, 2.556367e-001, 2.556478e-001, 2.556589e-001, 2.556700e-001, 2.556811e-001, 2.556922e-001, 2.557033e-001, 2.557144e-001, 2.557255e-001, 2.557366e-001, 2.557478e-001, 2.557589e-001, 2.557700e-001, 2.557811e-001, 2.557922e-001, 2.558033e-001, 2.558144e-001, 2.558255e-001, 2.558366e-001, 2.558477e-001, 2.558588e-001, 2.558699e-001, 2.558810e-001, 2.558920e-001, 2.559031e-001, 2.559142e-001, 2.559253e-001, 2.559364e-001, 2.559475e-001, 2.559586e-001, 2.559697e-001, 2.559808e-001, 2.559919e-001, 2.560029e-001, 2.560140e-001, 2.560251e-001, 2.560362e-001, 2.560473e-001, 2.560584e-001, 2.560694e-001, 2.560805e-001, 2.560916e-001, 2.561027e-001, 2.561138e-001, 2.561248e-001, 2.561359e-001, 2.561470e-001, 2.561581e-001, 2.561691e-001, 2.561802e-001, 2.561913e-001, 2.562024e-001, 2.562134e-001, 2.562245e-001, 2.562356e-001, 2.562466e-001, 2.562577e-001, 2.562688e-001, 2.562798e-001, 2.562909e-001, 2.563020e-001, 2.563130e-001, 2.563241e-001, 2.563351e-001, 2.563462e-001, 2.563573e-001, 2.563683e-001, 2.563794e-001, 2.563904e-001, 2.564015e-001, 2.564126e-001, 2.564236e-001, 2.564347e-001, 2.564457e-001, 2.564568e-001, 2.564678e-001, 2.564789e-001, 2.564899e-001, 2.565010e-001, 2.565120e-001, 2.565231e-001, 2.565341e-001, 2.565452e-001, 2.565562e-001, 2.565673e-001, 2.565783e-001, 2.565893e-001, 2.566004e-001, 2.566114e-001, 2.566225e-001, 2.566335e-001, 2.566445e-001, 
2.566556e-001, 2.566666e-001, 2.566776e-001, 2.566887e-001, 2.566997e-001, 2.567108e-001, 2.567218e-001, 2.567328e-001, 2.567438e-001, 2.567549e-001, 2.567659e-001, 2.567769e-001, 2.567880e-001, 2.567990e-001, 2.568100e-001, 2.568210e-001, 2.568321e-001, 2.568431e-001, 2.568541e-001, 2.568651e-001, 2.568762e-001, 2.568872e-001, 2.568982e-001, 2.569092e-001, 2.569202e-001, 2.569313e-001, 2.569423e-001, 2.569533e-001, 2.569643e-001, 2.569753e-001, 2.569863e-001, 2.569973e-001, 2.570084e-001, 2.570194e-001, 2.570304e-001, 2.570414e-001, 2.570524e-001, 2.570634e-001, 2.570744e-001, 2.570854e-001, 2.570964e-001, 2.571074e-001, 2.571184e-001, 2.571294e-001, 2.571404e-001, 2.571514e-001, 2.571624e-001, 2.571734e-001, 2.571844e-001, 2.571954e-001, 2.572064e-001, 2.572174e-001, 2.572284e-001, 2.572394e-001, 2.572504e-001, 2.572614e-001, 2.572724e-001, 2.572834e-001, 2.572944e-001, 2.573054e-001, 2.573163e-001, 2.573273e-001, 2.573383e-001, 2.573493e-001, 2.573603e-001, 2.573713e-001, 2.573823e-001, 2.573932e-001, 2.574042e-001, 2.574152e-001, 2.574262e-001, 2.574372e-001, 2.574481e-001, 2.574591e-001, 2.574701e-001, 2.574811e-001, 2.574921e-001, 2.575030e-001, 2.575140e-001, 2.575250e-001, 2.575359e-001, 2.575469e-001, 2.575579e-001, 2.575689e-001, 2.575798e-001, 2.575908e-001, 2.576018e-001, 2.576127e-001, 2.576237e-001, 2.576347e-001, 2.576456e-001, 2.576566e-001, 2.576676e-001, 2.576785e-001, 2.576895e-001, 2.577004e-001, 2.577114e-001, 2.577224e-001, 2.577333e-001, 2.577443e-001, 
2.577552e-001, 2.577662e-001, 2.577771e-001, 2.577881e-001, 2.577990e-001, 2.578100e-001, 2.578209e-001, 2.578319e-001, 2.578428e-001, 2.578538e-001, 2.578647e-001, 2.578757e-001, 2.578866e-001, 2.578976e-001, 2.579085e-001, 2.579195e-001, 2.579304e-001, 2.579414e-001, 2.579523e-001, 2.579632e-001, 2.579742e-001, 2.579851e-001, 2.579961e-001, 2.580070e-001, 2.580179e-001, 2.580289e-001, 2.580398e-001, 2.580507e-001, 2.580617e-001, 2.580726e-001, 2.580835e-001, 2.580945e-001, 2.581054e-001, 2.581163e-001, 2.581272e-001, 2.581382e-001, 2.581491e-001, 2.581600e-001, 2.581710e-001, 2.581819e-001, 2.581928e-001, 2.582037e-001, 2.582146e-001, 2.582256e-001, 2.582365e-001, 2.582474e-001, 2.582583e-001, 2.582692e-001, 2.582802e-001, 2.582911e-001, 2.583020e-001, 2.583129e-001, 2.583238e-001, 2.583347e-001, 2.583456e-001, 2.583566e-001, 2.583675e-001, 2.583784e-001, 2.583893e-001, 2.584002e-001, 2.584111e-001, 2.584220e-001, 2.584329e-001, 2.584438e-001, 2.584547e-001, 2.584656e-001, 2.584765e-001, 2.584874e-001, 2.584983e-001, 2.585092e-001, 2.585201e-001, 2.585310e-001, 2.585419e-001, 2.585528e-001, 2.585637e-001, 2.585746e-001, 2.585855e-001, 2.585964e-001, 2.586073e-001, 2.586182e-001, 2.586291e-001, 2.586400e-001, 2.586509e-001, 2.586618e-001, 2.586726e-001, 2.586835e-001, 2.586944e-001, 2.587053e-001, 2.587162e-001, 2.587271e-001, 2.587380e-001, 2.587488e-001, 2.587597e-001, 2.587706e-001, 2.587815e-001, 2.587924e-001, 2.588032e-001, 2.588141e-001, 2.588250e-001, 2.588359e-001, 
2.588467e-001, 2.588576e-001, 2.588685e-001, 2.588794e-001, 2.588902e-001, 2.589011e-001, 2.589120e-001, 2.589228e-001, 2.589337e-001, 2.589446e-001, 2.589554e-001, 2.589663e-001, 2.589772e-001, 2.589880e-001, 2.589989e-001, 2.590098e-001, 2.590206e-001, 2.590315e-001, 2.590424e-001, 2.590532e-001, 2.590641e-001, 2.590749e-001, 2.590858e-001, 2.590966e-001, 2.591075e-001, 2.591184e-001, 2.591292e-001, 2.591401e-001, 2.591509e-001, 2.591618e-001, 2.591726e-001, 2.591835e-001, 2.591943e-001, 2.592052e-001, 2.592160e-001, 2.592269e-001, 2.592377e-001, 2.592486e-001, 2.592594e-001, 2.592702e-001, 2.592811e-001, 2.592919e-001, 2.593028e-001, 2.593136e-001, 2.593244e-001, 2.593353e-001, 2.593461e-001, 2.593570e-001, 2.593678e-001, 2.593786e-001, 2.593895e-001, 2.594003e-001, 2.594111e-001, 2.594220e-001, 2.594328e-001, 2.594436e-001, 2.594545e-001, 2.594653e-001, 2.594761e-001, 2.594869e-001, 2.594978e-001, 2.595086e-001, 2.595194e-001, 2.595303e-001, 2.595411e-001, 2.595519e-001, 2.595627e-001, 2.595735e-001, 2.595844e-001, 2.595952e-001, 2.596060e-001, 2.596168e-001, 2.596276e-001, 2.596385e-001, 2.596493e-001, 2.596601e-001, 2.596709e-001, 2.596817e-001, 2.596925e-001, 2.597033e-001, 2.597141e-001, 2.597250e-001, 2.597358e-001, 2.597466e-001, 2.597574e-001, 2.597682e-001, 2.597790e-001, 2.597898e-001, 2.598006e-001, 2.598114e-001, 2.598222e-001, 2.598330e-001, 2.598438e-001, 2.598546e-001, 2.598654e-001, 2.598762e-001, 2.598870e-001, 2.598978e-001, 2.599086e-001, 2.599194e-001, 
2.599302e-001, 2.599410e-001, 2.599518e-001, 2.599626e-001, 2.599734e-001, 2.599842e-001, 2.599949e-001, 2.600057e-001, 2.600165e-001, 2.600273e-001, 2.600381e-001, 2.600489e-001, 2.600597e-001, 2.600705e-001, 2.600812e-001, 2.600920e-001, 2.601028e-001, 2.601136e-001, 2.601244e-001, 2.601351e-001, 2.601459e-001, 2.601567e-001, 2.601675e-001, 2.601783e-001, 2.601890e-001, 2.601998e-001, 2.602106e-001, 2.602214e-001, 2.602321e-001, 2.602429e-001, 2.602537e-001, 2.602644e-001, 2.602752e-001, 2.602860e-001, 2.602967e-001, 2.603075e-001, 2.603183e-001, 2.603290e-001, 2.603398e-001, 2.603506e-001, 2.603613e-001, 2.603721e-001, 2.603829e-001, 2.603936e-001, 2.604044e-001, 2.604151e-001, 2.604259e-001, 2.604366e-001, 2.604474e-001, 2.604582e-001, 2.604689e-001, 2.604797e-001, 2.604904e-001, 2.605012e-001, 2.605119e-001, 2.605227e-001, 2.605334e-001, 2.605442e-001, 2.605549e-001, 2.605657e-001, 2.605764e-001, 2.605872e-001, 2.605979e-001, 2.606087e-001, 2.606194e-001, 2.606301e-001, 2.606409e-001, 2.606516e-001, 2.606624e-001, 2.606731e-001, 2.606838e-001, 2.606946e-001, 2.607053e-001, 2.607161e-001, 2.607268e-001, 2.607375e-001, 2.607483e-001, 2.607590e-001, 2.607697e-001, 2.607805e-001, 2.607912e-001, 2.608019e-001, 2.608127e-001, 2.608234e-001, 2.608341e-001, 2.608448e-001, 2.608556e-001, 2.608663e-001, 2.608770e-001, 2.608877e-001, 2.608985e-001, 2.609092e-001, 2.609199e-001, 2.609306e-001, 2.609413e-001, 2.609521e-001, 2.609628e-001, 2.609735e-001, 2.609842e-001, 2.609949e-001, 
2.610056e-001, 2.610164e-001, 2.610271e-001, 2.610378e-001, 2.610485e-001, 2.610592e-001, 2.610699e-001, 2.610806e-001, 2.610913e-001, 2.611020e-001, 2.611128e-001, 2.611235e-001, 2.611342e-001, 2.611449e-001, 2.611556e-001, 2.611663e-001, 2.611770e-001, 2.611877e-001, 2.611984e-001, 2.612091e-001, 2.612198e-001, 2.612305e-001, 2.612412e-001, 2.612519e-001, 2.612626e-001, 2.612733e-001, 2.612840e-001, 2.612947e-001, 2.613053e-001, 2.613160e-001, 2.613267e-001, 2.613374e-001, 2.613481e-001, 2.613588e-001, 2.613695e-001, 2.613802e-001, 2.613909e-001, 2.614015e-001, 2.614122e-001, 2.614229e-001, 2.614336e-001, 2.614443e-001, 2.614550e-001, 2.614656e-001, 2.614763e-001, 2.614870e-001, 2.614977e-001, 2.615084e-001, 2.615190e-001, 2.615297e-001, 2.615404e-001, 2.615511e-001, 2.615617e-001, 2.615724e-001, 2.615831e-001, 2.615938e-001, 2.616044e-001, 2.616151e-001, 2.616258e-001, 2.616364e-001, 2.616471e-001, 2.616578e-001, 2.616684e-001, 2.616791e-001, 2.616898e-001, 2.617004e-001, 2.617111e-001, 2.617218e-001, 2.617324e-001, 2.617431e-001, 2.617537e-001, 2.617644e-001, 2.617751e-001, 2.617857e-001, 2.617964e-001, 2.618070e-001, 2.618177e-001, 2.618283e-001, 2.618390e-001, 2.618496e-001, 2.618603e-001, 2.618709e-001, 2.618816e-001, 2.618922e-001, 2.619029e-001, 2.619135e-001, 2.619242e-001, 2.619348e-001, 2.619455e-001, 2.619561e-001, 2.619668e-001, 2.619774e-001, 2.619880e-001, 2.619987e-001, 2.620093e-001, 2.620200e-001, 2.620306e-001, 2.620412e-001, 2.620519e-001, 2.620625e-001, 
2.620732e-001, 2.620838e-001, 2.620944e-001, 2.621051e-001, 2.621157e-001, 2.621263e-001, 2.621370e-001, 2.621476e-001, 2.621582e-001, 2.621688e-001, 2.621795e-001, 2.621901e-001, 2.622007e-001, 2.622114e-001, 2.622220e-001, 2.622326e-001, 2.622432e-001, 2.622539e-001, 2.622645e-001, 2.622751e-001, 2.622857e-001, 2.622963e-001, 2.623070e-001, 2.623176e-001, 2.623282e-001, 2.623388e-001, 2.623494e-001, 2.623600e-001, 2.623707e-001, 2.623813e-001, 2.623919e-001, 2.624025e-001, 2.624131e-001, 2.624237e-001, 2.624343e-001, 2.624449e-001, 2.624555e-001, 2.624661e-001, 2.624767e-001, 2.624874e-001, 2.624980e-001, 2.625086e-001, 2.625192e-001, 2.625298e-001, 2.625404e-001, 2.625510e-001, 2.625616e-001, 2.625722e-001, 2.625828e-001, 2.625934e-001, 2.626040e-001, 2.626146e-001, 2.626252e-001, 2.626357e-001, 2.626463e-001, 2.626569e-001, 2.626675e-001, 2.626781e-001, 2.626887e-001, 2.626993e-001, 2.627099e-001, 2.627205e-001, 2.627311e-001, 2.627416e-001, 2.627522e-001, 2.627628e-001, 2.627734e-001, 2.627840e-001, 2.627946e-001, 2.628052e-001, 2.628157e-001, 2.628263e-001, 2.628369e-001, 2.628475e-001, 2.628580e-001, 2.628686e-001, 2.628792e-001, 2.628898e-001, 2.629004e-001, 2.629109e-001, 2.629215e-001, 2.629321e-001, 2.629426e-001, 2.629532e-001, 2.629638e-001, 2.629744e-001, 2.629849e-001, 2.629955e-001, 2.630061e-001, 2.630166e-001, 2.630272e-001, 2.630378e-001, 2.630483e-001, 2.630589e-001, 2.630694e-001, 2.630800e-001, 2.630906e-001, 2.631011e-001, 2.631117e-001, 2.631222e-001, 
2.631328e-001, 2.631434e-001, 2.631539e-001, 2.631645e-001, 2.631750e-001, 2.631856e-001, 2.631961e-001, 2.632067e-001, 2.632172e-001, 2.632278e-001, 2.632383e-001, 2.632489e-001, 2.632594e-001, 2.632700e-001, 2.632805e-001, 2.632911e-001, 2.633016e-001, 2.633122e-001, 2.633227e-001, 2.633332e-001, 2.633438e-001, 2.633543e-001, 2.633649e-001, 2.633754e-001, 2.633860e-001, 2.633965e-001, 2.634070e-001, 2.634176e-001, 2.634281e-001, 2.634386e-001, 2.634492e-001, 2.634597e-001, 2.634702e-001, 2.634808e-001, 2.634913e-001, 2.635018e-001, 2.635124e-001, 2.635229e-001, 2.635334e-001, 2.635439e-001, 2.635545e-001, 2.635650e-001, 2.635755e-001, 2.635860e-001, 2.635966e-001, 2.636071e-001, 2.636176e-001, 2.636281e-001, 2.636387e-001, 2.636492e-001, 2.636597e-001, 2.636702e-001, 2.636807e-001, 2.636912e-001, 2.637018e-001, 2.637123e-001, 2.637228e-001, 2.637333e-001, 2.637438e-001, 2.637543e-001, 2.637648e-001, 2.637753e-001, 2.637859e-001, 2.637964e-001, 2.638069e-001, 2.638174e-001, 2.638279e-001, 2.638384e-001, 2.638489e-001, 2.638594e-001, 2.638699e-001, 2.638804e-001, 2.638909e-001, 2.639014e-001, 2.639119e-001, 2.639224e-001, 2.639329e-001, 2.639434e-001, 2.639539e-001, 2.639644e-001, 2.639749e-001, 2.639854e-001, 2.639959e-001, 2.640064e-001, 2.640169e-001, 2.640274e-001, 2.640378e-001, 2.640483e-001, 2.640588e-001, 2.640693e-001, 2.640798e-001, 2.640903e-001, 2.641008e-001, 2.641113e-001, 2.641217e-001, 2.641322e-001, 2.641427e-001, 2.641532e-001, 2.641637e-001, 2.641742e-001, 
2.641846e-001, 2.641951e-001, 2.642056e-001, 2.642161e-001, 2.642265e-001, 2.642370e-001, 2.642475e-001, 2.642580e-001, 2.642684e-001, 2.642789e-001, 2.642894e-001, 2.642999e-001, 2.643103e-001, 2.643208e-001, 2.643313e-001, 2.643417e-001, 2.643522e-001, 2.643627e-001, 2.643731e-001, 2.643836e-001, 2.643941e-001, 2.644045e-001, 2.644150e-001, 2.644255e-001, 2.644359e-001, 2.644464e-001, 2.644568e-001, 2.644673e-001, 2.644778e-001, 2.644882e-001, 2.644987e-001, 2.645091e-001, 2.645196e-001, 2.645300e-001, 2.645405e-001, 2.645509e-001, 2.645614e-001, 2.645718e-001, 2.645823e-001, 2.645927e-001, 2.646032e-001, 2.646136e-001, 2.646241e-001, 2.646345e-001, 2.646450e-001, 2.646554e-001, 2.646659e-001, 2.646763e-001, 2.646868e-001, 2.646972e-001, 2.647076e-001, 2.647181e-001, 2.647285e-001, 2.647390e-001, 2.647494e-001, 2.647598e-001, 2.647703e-001, 2.647807e-001, 2.647911e-001, 2.648016e-001, 2.648120e-001, 2.648224e-001, 2.648329e-001, 2.648433e-001, 2.648537e-001, 2.648642e-001, 2.648746e-001, 2.648850e-001, 2.648954e-001, 2.649059e-001, 2.649163e-001, 2.649267e-001, 2.649371e-001, 2.649476e-001, 2.649580e-001, 2.649684e-001, 2.649788e-001, 2.649893e-001, 2.649997e-001, 2.650101e-001, 2.650205e-001, 2.650309e-001, 2.650413e-001, 2.650518e-001, 2.650622e-001, 2.650726e-001, 2.650830e-001, 2.650934e-001, 2.651038e-001, 2.651142e-001, 2.651246e-001, 2.651351e-001, 2.651455e-001, 2.651559e-001, 2.651663e-001, 2.651767e-001, 2.651871e-001, 2.651975e-001, 2.652079e-001, 2.652183e-001, 
2.652287e-001, 2.652391e-001, 2.652495e-001, 2.652599e-001, 2.652703e-001, 2.652807e-001, 2.652911e-001, 2.653015e-001, 2.653119e-001, 2.653223e-001, 2.653327e-001, 2.653431e-001, 2.653535e-001, 2.653639e-001, 2.653743e-001, 2.653847e-001, 2.653950e-001, 2.654054e-001, 2.654158e-001, 2.654262e-001, 2.654366e-001, 2.654470e-001, 2.654574e-001, 2.654678e-001, 2.654781e-001, 2.654885e-001, 2.654989e-001, 2.655093e-001, 2.655197e-001, 2.655300e-001, 2.655404e-001, 2.655508e-001, 2.655612e-001, 2.655716e-001, 2.655819e-001, 2.655923e-001, 2.656027e-001, 2.656131e-001, 2.656234e-001, 2.656338e-001, 2.656442e-001, 2.656546e-001, 2.656649e-001, 2.656753e-001, 2.656857e-001, 2.656960e-001, 2.657064e-001, 2.657168e-001, 2.657271e-001, 2.657375e-001, 2.657479e-001, 2.657582e-001, 2.657686e-001, 2.657789e-001, 2.657893e-001, 2.657997e-001, 2.658100e-001, 2.658204e-001, 2.658307e-001, 2.658411e-001, 2.658515e-001, 2.658618e-001, 2.658722e-001, 2.658825e-001, 2.658929e-001, 2.659032e-001, 2.659136e-001, 2.659239e-001, 2.659343e-001, 2.659446e-001, 2.659550e-001, 2.659653e-001, 2.659757e-001, 2.659860e-001, 2.659964e-001, 2.660067e-001, 2.660171e-001, 2.660274e-001, 2.660377e-001, 2.660481e-001, 2.660584e-001, 2.660688e-001, 2.660791e-001, 2.660894e-001, 2.660998e-001, 2.661101e-001, 2.661205e-001, 2.661308e-001, 2.661411e-001, 2.661515e-001, 2.661618e-001, 2.661721e-001, 2.661825e-001, 2.661928e-001, 2.662031e-001, 2.662135e-001, 2.662238e-001, 2.662341e-001, 2.662444e-001, 2.662548e-001, 
2.662651e-001, 2.662754e-001, 2.662857e-001, 2.662961e-001, 2.663064e-001, 2.663167e-001, 2.663270e-001, 2.663374e-001, 2.663477e-001, 2.663580e-001, 2.663683e-001, 2.663786e-001, 2.663889e-001, 2.663993e-001, 2.664096e-001, 2.664199e-001, 2.664302e-001, 2.664405e-001, 2.664508e-001, 2.664611e-001, 2.664715e-001, 2.664818e-001, 2.664921e-001, 2.665024e-001, 2.665127e-001, 2.665230e-001, 2.665333e-001, 2.665436e-001, 2.665539e-001, 2.665642e-001, 2.665745e-001, 2.665848e-001, 2.665951e-001, 2.666054e-001, 2.666157e-001, 2.666260e-001, 2.666363e-001, 2.666466e-001, 2.666569e-001, 2.666672e-001, 2.666775e-001, 2.666878e-001, 2.666981e-001, 2.667084e-001, 2.667187e-001, 2.667290e-001, 2.667393e-001, 2.667496e-001, 2.667598e-001, 2.667701e-001, 2.667804e-001, 2.667907e-001, 2.668010e-001, 2.668113e-001, 2.668216e-001, 2.668318e-001, 2.668421e-001, 2.668524e-001, 2.668627e-001, 2.668730e-001, 2.668833e-001, 2.668935e-001, 2.669038e-001, 2.669141e-001, 2.669244e-001, 2.669346e-001, 2.669449e-001, 2.669552e-001, 2.669655e-001, 2.669757e-001, 2.669860e-001, 2.669963e-001, 2.670066e-001, 2.670168e-001, 2.670271e-001, 2.670374e-001, 2.670476e-001, 2.670579e-001, 2.670682e-001, 2.670784e-001, 2.670887e-001, 2.670990e-001, 2.671092e-001, 2.671195e-001, 2.671298e-001, 2.671400e-001, 2.671503e-001, 2.671605e-001, 2.671708e-001, 2.671811e-001, 2.671913e-001, 2.672016e-001, 2.672118e-001, 2.672221e-001, 2.672323e-001, 2.672426e-001, 2.672528e-001, 2.672631e-001, 2.672733e-001, 2.672836e-001, 
2.672938e-001, 2.673041e-001, 2.673143e-001, 2.673246e-001, 2.673348e-001, 2.673451e-001, 2.673553e-001, 2.673656e-001, 2.673758e-001, 2.673861e-001, 2.673963e-001, 2.674065e-001, 2.674168e-001, 2.674270e-001, 2.674373e-001, 2.674475e-001, 2.674577e-001, 2.674680e-001, 2.674782e-001, 2.674884e-001, 2.674987e-001, 2.675089e-001, 2.675191e-001, 2.675294e-001, 2.675396e-001, 2.675498e-001, 2.675601e-001, 2.675703e-001, 2.675805e-001, 2.675908e-001, 2.676010e-001, 2.676112e-001, 2.676214e-001, 2.676317e-001, 2.676419e-001, 2.676521e-001, 2.676623e-001, 2.676726e-001, 2.676828e-001, 2.676930e-001, 2.677032e-001, 2.677134e-001, 2.677237e-001, 2.677339e-001, 2.677441e-001, 2.677543e-001, 2.677645e-001, 2.677747e-001, 2.677849e-001, 2.677952e-001, 2.678054e-001, 2.678156e-001, 2.678258e-001, 2.678360e-001, 2.678462e-001, 2.678564e-001, 2.678666e-001, 2.678768e-001, 2.678870e-001, 2.678972e-001, 2.679075e-001, 2.679177e-001, 2.679279e-001, 2.679381e-001, 2.679483e-001, 2.679585e-001, 2.679687e-001, 2.679789e-001, 2.679891e-001, 2.679993e-001, 2.680095e-001, 2.680197e-001, 2.680298e-001, 2.680400e-001, 2.680502e-001, 2.680604e-001, 2.680706e-001, 2.680808e-001, 2.680910e-001, 2.681012e-001, 2.681114e-001, 2.681216e-001, 2.681318e-001, 2.681420e-001, 2.681521e-001, 2.681623e-001, 2.681725e-001, 2.681827e-001, 2.681929e-001, 2.682031e-001, 2.682132e-001, 2.682234e-001, 2.682336e-001, 2.682438e-001, 2.682540e-001, 2.682641e-001, 2.682743e-001, 2.682845e-001, 2.682947e-001, 2.683048e-001, 
2.683150e-001, 2.683252e-001, 2.683354e-001, 2.683455e-001, 2.683557e-001, 2.683659e-001, 2.683760e-001, 2.683862e-001, 2.683964e-001, 2.684066e-001, 2.684167e-001, 2.684269e-001, 2.684371e-001, 2.684472e-001, 2.684574e-001, 2.684675e-001, 2.684777e-001, 2.684879e-001, 2.684980e-001, 2.685082e-001, 2.685183e-001, 2.685285e-001, 2.685387e-001, 2.685488e-001, 2.685590e-001, 2.685691e-001, 2.685793e-001, 2.685894e-001, 2.685996e-001, 2.686097e-001, 2.686199e-001, 2.686301e-001, 2.686402e-001, 2.686504e-001, 2.686605e-001, 2.686707e-001, 2.686808e-001, 2.686909e-001, 2.687011e-001, 2.687112e-001, 2.687214e-001, 2.687315e-001, 2.687417e-001, 2.687518e-001, 2.687619e-001, 2.687721e-001, 2.687822e-001, 2.687924e-001, 2.688025e-001, 2.688126e-001, 2.688228e-001, 2.688329e-001, 2.688431e-001, 2.688532e-001, 2.688633e-001, 2.688735e-001, 2.688836e-001, 2.688937e-001, 2.689039e-001, 2.689140e-001, 2.689241e-001, 2.689342e-001, 2.689444e-001, 2.689545e-001, 2.689646e-001, 2.689747e-001, 2.689849e-001, 2.689950e-001, 2.690051e-001, 2.690152e-001, 2.690254e-001, 2.690355e-001, 2.690456e-001, 2.690557e-001, 2.690658e-001, 2.690760e-001, 2.690861e-001, 2.690962e-001, 2.691063e-001, 2.691164e-001, 2.691265e-001, 2.691367e-001, 2.691468e-001, 2.691569e-001, 2.691670e-001, 2.691771e-001, 2.691872e-001, 2.691973e-001, 2.692074e-001, 2.692175e-001, 2.692276e-001, 2.692378e-001, 2.692479e-001, 2.692580e-001, 2.692681e-001, 2.692782e-001, 2.692883e-001, 2.692984e-001, 2.693085e-001, 2.693186e-001, 
2.693287e-001, 2.693388e-001, 2.693489e-001, 2.693590e-001, 2.693691e-001, 2.693792e-001, 2.693893e-001, 2.693993e-001, 2.694094e-001, 2.694195e-001, 2.694296e-001, 2.694397e-001, 2.694498e-001, 2.694599e-001, 2.694700e-001, 2.694801e-001, 2.694902e-001, 2.695003e-001, 2.695103e-001, 2.695204e-001, 2.695305e-001, 2.695406e-001, 2.695507e-001, 2.695608e-001, 2.695708e-001, 2.695809e-001, 2.695910e-001, 2.696011e-001, 2.696112e-001, 2.696212e-001, 2.696313e-001, 2.696414e-001, 2.696515e-001, 2.696615e-001, 2.696716e-001, 2.696817e-001, 2.696918e-001, 2.697018e-001, 2.697119e-001, 2.697220e-001, 2.697320e-001, 2.697421e-001, 2.697522e-001, 2.697622e-001, 2.697723e-001, 2.697824e-001, 2.697924e-001, 2.698025e-001, 2.698126e-001, 2.698226e-001, 2.698327e-001, 2.698428e-001, 2.698528e-001, 2.698629e-001, 2.698729e-001, 2.698830e-001, 2.698931e-001, 2.699031e-001, 2.699132e-001, 2.699232e-001, 2.699333e-001, 2.699433e-001, 2.699534e-001, 2.699634e-001, 2.699735e-001, 2.699835e-001, 2.699936e-001, 2.700036e-001, 2.700137e-001, 2.700237e-001, 2.700338e-001, 2.700438e-001, 2.700539e-001, 2.700639e-001, 2.700740e-001, 2.700840e-001, 2.700941e-001, 2.701041e-001, 2.701141e-001, 2.701242e-001, 2.701342e-001, 2.701443e-001, 2.701543e-001, 2.701643e-001, 2.701744e-001, 2.701844e-001, 2.701944e-001, 2.702045e-001, 2.702145e-001, 2.702245e-001, 2.702346e-001, 2.702446e-001, 2.702546e-001, 2.702647e-001, 2.702747e-001, 2.702847e-001, 2.702948e-001, 2.703048e-001, 2.703148e-001, 2.703248e-001, 
2.703349e-001, 2.703449e-001, 2.703549e-001, 2.703649e-001, 2.703750e-001, 2.703850e-001, 2.703950e-001, 2.704050e-001, 2.704150e-001, 2.704251e-001, 2.704351e-001, 2.704451e-001, 2.704551e-001, 2.704651e-001, 2.704751e-001, 2.704852e-001, 2.704952e-001, 2.705052e-001, 2.705152e-001, 2.705252e-001, 2.705352e-001, 2.705452e-001, 2.705552e-001, 2.705652e-001, 2.705752e-001, 2.705853e-001, 2.705953e-001, 2.706053e-001, 2.706153e-001, 2.706253e-001, 2.706353e-001, 2.706453e-001, 2.706553e-001, 2.706653e-001, 2.706753e-001, 2.706853e-001, 2.706953e-001, 2.707053e-001, 2.707153e-001, 2.707253e-001, 2.707353e-001, 2.707453e-001, 2.707553e-001, 2.707653e-001, 2.707752e-001, 2.707852e-001, 2.707952e-001, 2.708052e-001, 2.708152e-001, 2.708252e-001, 2.708352e-001, 2.708452e-001, 2.708552e-001, 2.708651e-001, 2.708751e-001, 2.708851e-001, 2.708951e-001, 2.709051e-001, 2.709151e-001, 2.709250e-001, 2.709350e-001, 2.709450e-001, 2.709550e-001, 2.709650e-001, 2.709749e-001, 2.709849e-001, 2.709949e-001, 2.710049e-001, 2.710148e-001, 2.710248e-001, 2.710348e-001, 2.710448e-001, 2.710547e-001, 2.710647e-001, 2.710747e-001, 2.710846e-001, 2.710946e-001, 2.711046e-001, 2.711146e-001, 2.711245e-001, 2.711345e-001, 2.711445e-001, 2.711544e-001, 2.711644e-001, 2.711743e-001, 2.711843e-001, 2.711943e-001, 2.712042e-001, 2.712142e-001, 2.712241e-001, 2.712341e-001, 2.712441e-001, 2.712540e-001, 2.712640e-001, 2.712739e-001, 2.712839e-001, 2.712938e-001, 2.713038e-001, 2.713138e-001, 2.713237e-001, 
2.713337e-001, 2.713436e-001, 2.713536e-001, 2.713635e-001, 2.713735e-001, 2.713834e-001, 2.713933e-001, 2.714033e-001, 2.714132e-001, 2.714232e-001, 2.714331e-001, 2.714431e-001, 2.714530e-001, 2.714630e-001, 2.714729e-001, 2.714828e-001, 2.714928e-001, 2.715027e-001, 2.715127e-001, 2.715226e-001, 2.715325e-001, 2.715425e-001, 2.715524e-001, 2.715623e-001, 2.715723e-001, 2.715822e-001, 2.715921e-001, 2.716021e-001, 2.716120e-001, 2.716219e-001, 2.716319e-001, 2.716418e-001, 2.716517e-001, 2.716616e-001, 2.716716e-001, 2.716815e-001, 2.716914e-001, 2.717013e-001, 2.717113e-001, 2.717212e-001, 2.717311e-001, 2.717410e-001, 2.717509e-001, 2.717609e-001, 2.717708e-001, 2.717807e-001, 2.717906e-001, 2.718005e-001, 2.718105e-001, 2.718204e-001, 2.718303e-001, 2.718402e-001, 2.718501e-001, 2.718600e-001, 2.718699e-001, 2.718798e-001, 2.718898e-001, 2.718997e-001, 2.719096e-001, 2.719195e-001, 2.719294e-001, 2.719393e-001, 2.719492e-001, 2.719591e-001, 2.719690e-001, 2.719789e-001, 2.719888e-001, 2.719987e-001, 2.720086e-001, 2.720185e-001, 2.720284e-001, 2.720383e-001, 2.720482e-001, 2.720581e-001, 2.720680e-001, 2.720779e-001, 2.720878e-001, 2.720977e-001, 2.721076e-001, 2.721175e-001, 2.721274e-001, 2.721373e-001, 2.721472e-001, 2.721571e-001, 2.721669e-001, 2.721768e-001, 2.721867e-001, 2.721966e-001, 2.722065e-001, 2.722164e-001, 2.722263e-001, 2.722362e-001, 2.722460e-001, 2.722559e-001, 2.722658e-001, 2.722757e-001, 2.722856e-001, 2.722954e-001, 2.723053e-001, 2.723152e-001, 
2.723251e-001, 2.723350e-001, 2.723448e-001, 2.723547e-001, 2.723646e-001, 2.723745e-001, 2.723843e-001, 2.723942e-001, 2.724041e-001, 2.724140e-001, 2.724238e-001, 2.724337e-001, 2.724436e-001, 2.724534e-001, 2.724633e-001, 2.724732e-001, 2.724830e-001, 2.724929e-001, 2.725028e-001, 2.725126e-001, 2.725225e-001, 2.725324e-001, 2.725422e-001, 2.725521e-001, 2.725619e-001, 2.725718e-001, 2.725817e-001, 2.725915e-001, 2.726014e-001, 2.726112e-001, 2.726211e-001, 2.726309e-001, 2.726408e-001, 2.726507e-001, 2.726605e-001, 2.726704e-001, 2.726802e-001, 2.726901e-001, 2.726999e-001, 2.727098e-001, 2.727196e-001, 2.727295e-001, 2.727393e-001, 2.727492e-001, 2.727590e-001, 2.727688e-001, 2.727787e-001, 2.727885e-001, 2.727984e-001, 2.728082e-001, 2.728181e-001, 2.728279e-001, 2.728377e-001, 2.728476e-001, 2.728574e-001, 2.728673e-001, 2.728771e-001, 2.728869e-001, 2.728968e-001, 2.729066e-001, 2.729164e-001, 2.729263e-001, 2.729361e-001, 2.729459e-001, 2.729558e-001, 2.729656e-001, 2.729754e-001, 2.729853e-001, 2.729951e-001, 2.730049e-001, 2.730147e-001, 2.730246e-001, 2.730344e-001, 2.730442e-001, 2.730540e-001, 2.730639e-001, 2.730737e-001, 2.730835e-001, 2.730933e-001, 2.731032e-001, 2.731130e-001, 2.731228e-001, 2.731326e-001, 2.731424e-001, 2.731522e-001, 2.731621e-001, 2.731719e-001, 2.731817e-001, 2.731915e-001, 2.732013e-001, 2.732111e-001, 2.732209e-001, 2.732308e-001, 2.732406e-001, 2.732504e-001, 2.732602e-001, 2.732700e-001, 2.732798e-001, 2.732896e-001, 2.732994e-001, 
2.733092e-001, 2.733190e-001, 2.733288e-001, 2.733386e-001, 2.733484e-001, 2.733582e-001, 2.733680e-001, 2.733778e-001, 2.733876e-001, 2.733974e-001, 2.734072e-001, 2.734170e-001, 2.734268e-001, 2.734366e-001, 2.734464e-001, 2.734562e-001, 2.734660e-001, 2.734758e-001, 2.734856e-001, 2.734954e-001, 2.735052e-001, 2.735150e-001, 2.735248e-001, 2.735345e-001, 2.735443e-001, 2.735541e-001, 2.735639e-001, 2.735737e-001, 2.735835e-001, 2.735933e-001, 2.736030e-001, 2.736128e-001, 2.736226e-001, 2.736324e-001, 2.736422e-001, 2.736520e-001, 2.736617e-001, 2.736715e-001, 2.736813e-001, 2.736911e-001, 2.737008e-001, 2.737106e-001, 2.737204e-001, 2.737302e-001, 2.737399e-001, 2.737497e-001, 2.737595e-001, 2.737693e-001, 2.737790e-001, 2.737888e-001, 2.737986e-001, 2.738083e-001, 2.738181e-001, 2.738279e-001, 2.738376e-001, 2.738474e-001, 2.738572e-001, 2.738669e-001, 2.738767e-001, 2.738865e-001, 2.738962e-001, 2.739060e-001, 2.739157e-001, 2.739255e-001, 2.739353e-001, 2.739450e-001, 2.739548e-001, 2.739645e-001, 2.739743e-001, 2.739840e-001, 2.739938e-001, 2.740036e-001, 2.740133e-001, 2.740231e-001, 2.740328e-001, 2.740426e-001, 2.740523e-001, 2.740621e-001, 2.740718e-001, 2.740816e-001, 2.740913e-001, 2.741011e-001, 2.741108e-001, 2.741205e-001, 2.741303e-001, 2.741400e-001, 2.741498e-001, 2.741595e-001, 2.741693e-001, 2.741790e-001, 2.741887e-001, 2.741985e-001, 2.742082e-001, 2.742180e-001, 2.742277e-001, 2.742374e-001, 2.742472e-001, 2.742569e-001, 2.742666e-001, 2.742764e-001, 
2.742861e-001, 2.742958e-001, 2.743056e-001, 2.743153e-001, 2.743250e-001, 2.743348e-001, 2.743445e-001, 2.743542e-001, 2.743639e-001, 2.743737e-001, 2.743834e-001, 2.743931e-001, 2.744028e-001, 2.744126e-001, 2.744223e-001, 2.744320e-001, 2.744417e-001, 2.744515e-001, 2.744612e-001, 2.744709e-001, 2.744806e-001, 2.744903e-001, 2.745001e-001, 2.745098e-001, 2.745195e-001, 2.745292e-001, 2.745389e-001, 2.745486e-001, 2.745583e-001, 2.745681e-001, 2.745778e-001, 2.745875e-001, 2.745972e-001, 2.746069e-001, 2.746166e-001, 2.746263e-001, 2.746360e-001, 2.746457e-001, 2.746554e-001, 2.746651e-001, 2.746748e-001, 2.746845e-001, 2.746943e-001, 2.747040e-001, 2.747137e-001, 2.747234e-001, 2.747331e-001, 2.747428e-001, 2.747525e-001, 2.747622e-001, 2.747718e-001, 2.747815e-001, 2.747912e-001, 2.748009e-001, 2.748106e-001, 2.748203e-001, 2.748300e-001, 2.748397e-001, 2.748494e-001, 2.748591e-001, 2.748688e-001, 2.748785e-001, 2.748882e-001, 2.748978e-001, 2.749075e-001, 2.749172e-001, 2.749269e-001, 2.749366e-001, 2.749463e-001, 2.749560e-001, 2.749656e-001, 2.749753e-001, 2.749850e-001, 2.749947e-001, 2.750044e-001, 2.750140e-001, 2.750237e-001, 2.750334e-001, 2.750431e-001, 2.750528e-001, 2.750624e-001, 2.750721e-001, 2.750818e-001, 2.750915e-001, 2.751011e-001, 2.751108e-001, 2.751205e-001, 2.751301e-001, 2.751398e-001, 2.751495e-001, 2.751592e-001, 2.751688e-001, 2.751785e-001, 2.751882e-001, 2.751978e-001, 2.752075e-001, 2.752171e-001, 2.752268e-001, 2.752365e-001, 2.752461e-001, 
2.752558e-001, 2.752655e-001, 2.752751e-001, 2.752848e-001, 2.752944e-001, 2.753041e-001, 2.753138e-001, 2.753234e-001, 2.753331e-001, 2.753427e-001, 2.753524e-001, 2.753620e-001, 2.753717e-001, 2.753813e-001, 2.753910e-001, 2.754006e-001, 2.754103e-001, 2.754199e-001, 2.754296e-001, 2.754392e-001, 2.754489e-001, 2.754585e-001, 2.754682e-001, 2.754778e-001, 2.754875e-001, 2.754971e-001, 2.755067e-001, 2.755164e-001, 2.755260e-001, 2.755357e-001, 2.755453e-001, 2.755550e-001, 2.755646e-001, 2.755742e-001, 2.755839e-001, 2.755935e-001, 2.756031e-001, 2.756128e-001, 2.756224e-001, 2.756320e-001, 2.756417e-001, 2.756513e-001, 2.756609e-001, 2.756706e-001, 2.756802e-001, 2.756898e-001, 2.756995e-001, 2.757091e-001, 2.757187e-001, 2.757283e-001, 2.757380e-001, 2.757476e-001, 2.757572e-001, 2.757668e-001, 2.757765e-001, 2.757861e-001, 2.757957e-001, 2.758053e-001, 2.758149e-001, 2.758246e-001, 2.758342e-001, 2.758438e-001, 2.758534e-001, 2.758630e-001, 2.758727e-001, 2.758823e-001, 2.758919e-001, 2.759015e-001, 2.759111e-001, 2.759207e-001, 2.759303e-001, 2.759399e-001, 2.759496e-001, 2.759592e-001, 2.759688e-001, 2.759784e-001, 2.759880e-001, 2.759976e-001, 2.760072e-001, 2.760168e-001, 2.760264e-001, 2.760360e-001, 2.760456e-001, 2.760552e-001, 2.760648e-001, 2.760744e-001, 2.760840e-001, 2.760936e-001, 2.761032e-001, 2.761128e-001, 2.761224e-001, 2.761320e-001, 2.761416e-001, 2.761512e-001, 2.761608e-001, 2.761704e-001, 2.761800e-001, 2.761896e-001, 2.761992e-001, 2.762088e-001, 
2.762183e-001, 2.762279e-001, 2.762375e-001, 2.762471e-001, 2.762567e-001, 2.762663e-001, 2.762759e-001, 2.762855e-001, 2.762950e-001, 2.763046e-001, 2.763142e-001, 2.763238e-001, 2.763334e-001, 2.763430e-001, 2.763525e-001, 2.763621e-001, 2.763717e-001, 2.763813e-001, 2.763909e-001, 2.764004e-001, 2.764100e-001, 2.764196e-001, 2.764292e-001, 2.764387e-001, 2.764483e-001, 2.764579e-001, 2.764674e-001, 2.764770e-001, 2.764866e-001, 2.764962e-001, 2.765057e-001, 2.765153e-001, 2.765249e-001, 2.765344e-001, 2.765440e-001, 2.765536e-001, 2.765631e-001, 2.765727e-001, 2.765823e-001, 2.765918e-001, 2.766014e-001, 2.766109e-001, 2.766205e-001, 2.766301e-001, 2.766396e-001, 2.766492e-001, 2.766587e-001, 2.766683e-001, 2.766779e-001, 2.766874e-001, 2.766970e-001, 2.767065e-001, 2.767161e-001, 2.767256e-001, 2.767352e-001, 2.767447e-001, 2.767543e-001, 2.767638e-001, 2.767734e-001, 2.767829e-001, 2.767925e-001, 2.768020e-001, 2.768116e-001, 2.768211e-001, 2.768307e-001, 2.768402e-001, 2.768497e-001, 2.768593e-001, 2.768688e-001, 2.768784e-001, 2.768879e-001, 2.768975e-001, 2.769070e-001, 2.769165e-001, 2.769261e-001, 2.769356e-001, 2.769451e-001, 2.769547e-001, 2.769642e-001, 2.769737e-001, 2.769833e-001, 2.769928e-001, 2.770023e-001, 2.770119e-001, 2.770214e-001, 2.770309e-001, 2.770405e-001, 2.770500e-001, 2.770595e-001, 2.770691e-001, 2.770786e-001, 2.770881e-001, 2.770976e-001, 2.771072e-001, 2.771167e-001, 2.771262e-001, 2.771357e-001, 2.771452e-001, 2.771548e-001, 2.771643e-001, 
2.771738e-001, 2.771833e-001, 2.771928e-001, 2.772024e-001, 2.772119e-001, 2.772214e-001, 2.772309e-001, 2.772404e-001, 2.772499e-001, 2.772595e-001, 2.772690e-001, 2.772785e-001, 2.772880e-001, 2.772975e-001, 2.773070e-001, 2.773165e-001, 2.773260e-001, 2.773355e-001, 2.773450e-001, 2.773545e-001, 2.773641e-001, 2.773736e-001, 2.773831e-001, 2.773926e-001, 2.774021e-001, 2.774116e-001, 2.774211e-001, 2.774306e-001, 2.774401e-001, 2.774496e-001, 2.774591e-001, 2.774686e-001, 2.774781e-001, 2.774876e-001, 2.774971e-001, 2.775066e-001, 2.775160e-001, 2.775255e-001, 2.775350e-001, 2.775445e-001, 2.775540e-001, 2.775635e-001, 2.775730e-001, 2.775825e-001, 2.775920e-001, 2.776015e-001, 2.776110e-001, 2.776204e-001, 2.776299e-001, 2.776394e-001, 2.776489e-001, 2.776584e-001, 2.776679e-001, 2.776773e-001, 2.776868e-001, 2.776963e-001, 2.777058e-001, 2.777153e-001, 2.777247e-001, 2.777342e-001, 2.777437e-001, 2.777532e-001, 2.777627e-001, 2.777721e-001, 2.777816e-001, 2.777911e-001, 2.778005e-001, 2.778100e-001, 2.778195e-001, 2.778290e-001, 2.778384e-001, 2.778479e-001, 2.778574e-001, 2.778668e-001, 2.778763e-001, 2.778858e-001, 2.778952e-001, 2.779047e-001, 2.779142e-001, 2.779236e-001, 2.779331e-001, 2.779426e-001, 2.779520e-001, 2.779615e-001, 2.779709e-001, 2.779804e-001, 2.779899e-001, 2.779993e-001, 2.780088e-001, 2.780182e-001, 2.780277e-001, 2.780372e-001, 2.780466e-001, 2.780561e-001, 2.780655e-001, 2.780750e-001, 2.780844e-001, 2.780939e-001, 2.781033e-001, 2.781128e-001, 
2.781222e-001, 2.781317e-001, 2.781411e-001, 2.781506e-001, 2.781600e-001, 2.781695e-001, 2.781789e-001, 2.781883e-001, 2.781978e-001, 2.782072e-001, 2.782167e-001, 2.782261e-001, 2.782356e-001, 2.782450e-001, 2.782544e-001, 2.782639e-001, 2.782733e-001, 2.782828e-001, 2.782922e-001, 2.783016e-001, 2.783111e-001, 2.783205e-001, 2.783299e-001, 2.783394e-001, 2.783488e-001, 2.783582e-001, 2.783677e-001, 2.783771e-001, 2.783865e-001, 2.783960e-001, 2.784054e-001, 2.784148e-001, 2.784242e-001, 2.784337e-001, 2.784431e-001, 2.784525e-001, 2.784619e-001, 2.784714e-001, 2.784808e-001, 2.784902e-001, 2.784996e-001, 2.785090e-001, 2.785185e-001, 2.785279e-001, 2.785373e-001, 2.785467e-001, 2.785561e-001, 2.785656e-001, 2.785750e-001, 2.785844e-001, 2.785938e-001, 2.786032e-001, 2.786126e-001, 2.786220e-001, 2.786315e-001, 2.786409e-001, 2.786503e-001, 2.786597e-001, 2.786691e-001, 2.786785e-001, 2.786879e-001, 2.786973e-001, 2.787067e-001, 2.787161e-001, 2.787255e-001, 2.787349e-001, 2.787443e-001, 2.787537e-001, 2.787631e-001, 2.787725e-001, 2.787819e-001, 2.787913e-001, 2.788007e-001, 2.788101e-001, 2.788195e-001, 2.788289e-001, 2.788383e-001, 2.788477e-001, 2.788571e-001, 2.788665e-001, 2.788759e-001, 2.788853e-001, 2.788947e-001, 2.789041e-001, 2.789135e-001, 2.789229e-001, 2.789323e-001, 2.789417e-001, 2.789510e-001, 2.789604e-001, 2.789698e-001, 2.789792e-001, 2.789886e-001, 2.789980e-001, 2.790074e-001, 2.790167e-001, 2.790261e-001, 2.790355e-001, 2.790449e-001, 2.790543e-001, 
2.790636e-001, 2.790730e-001, 2.790824e-001, 2.790918e-001, 2.791012e-001, 2.791105e-001, 2.791199e-001, 2.791293e-001, 2.791387e-001, 2.791480e-001, 2.791574e-001, 2.791668e-001, 2.791761e-001, 2.791855e-001, 2.791949e-001, 2.792043e-001, 2.792136e-001, 2.792230e-001, 2.792324e-001, 2.792417e-001, 2.792511e-001, 2.792605e-001, 2.792698e-001, 2.792792e-001, 2.792886e-001, 2.792979e-001, 2.793073e-001, 2.793166e-001, 2.793260e-001, 2.793354e-001, 2.793447e-001, 2.793541e-001, 2.793634e-001, 2.793728e-001, 2.793821e-001, 2.793915e-001, 2.794009e-001, 2.794102e-001, 2.794196e-001, 2.794289e-001, 2.794383e-001, 2.794476e-001, 2.794570e-001, 2.794663e-001, 2.794757e-001, 2.794850e-001, 2.794944e-001, 2.795037e-001, 2.795131e-001, 2.795224e-001, 2.795317e-001, 2.795411e-001, 2.795504e-001, 2.795598e-001, 2.795691e-001, 2.795785e-001, 2.795878e-001, 2.795971e-001, 2.796065e-001, 2.796158e-001, 2.796252e-001, 2.796345e-001, 2.796438e-001, 2.796532e-001, 2.796625e-001, 2.796718e-001, 2.796812e-001, 2.796905e-001, 2.796998e-001, 2.797092e-001, 2.797185e-001, 2.797278e-001, 2.797372e-001, 2.797465e-001, 2.797558e-001, 2.797652e-001, 2.797745e-001, 2.797838e-001, 2.797931e-001, 2.798025e-001, 2.798118e-001, 2.798211e-001, 2.798304e-001, 2.798397e-001, 2.798491e-001, 2.798584e-001, 2.798677e-001, 2.798770e-001, 2.798864e-001, 2.798957e-001, 2.799050e-001, 2.799143e-001, 2.799236e-001, 2.799329e-001, 2.799422e-001, 2.799516e-001, 2.799609e-001, 2.799702e-001, 2.799795e-001, 2.799888e-001, 
2.799981e-001, 2.800074e-001, 2.800167e-001, 2.800261e-001, 2.800354e-001, 2.800447e-001, 2.800540e-001, 2.800633e-001, 2.800726e-001, 2.800819e-001, 2.800912e-001, 2.801005e-001, 2.801098e-001, 2.801191e-001, 2.801284e-001, 2.801377e-001, 2.801470e-001, 2.801563e-001, 2.801656e-001, 2.801749e-001, 2.801842e-001, 2.801935e-001, 2.802028e-001, 2.802121e-001, 2.802214e-001, 2.802307e-001, 2.802400e-001, 2.802492e-001, 2.802585e-001, 2.802678e-001, 2.802771e-001, 2.802864e-001, 2.802957e-001, 2.803050e-001, 2.803143e-001, 2.803236e-001, 2.803328e-001, 2.803421e-001, 2.803514e-001, 2.803607e-001, 2.803700e-001, 2.803793e-001, 2.803885e-001, 2.803978e-001, 2.804071e-001, 2.804164e-001, 2.804257e-001, 2.804349e-001, 2.804442e-001, 2.804535e-001, 2.804628e-001, 2.804720e-001, 2.804813e-001, 2.804906e-001, 2.804999e-001, 2.805091e-001, 2.805184e-001, 2.805277e-001, 2.805370e-001, 2.805462e-001, 2.805555e-001, 2.805648e-001, 2.805740e-001, 2.805833e-001, 2.805926e-001, 2.806018e-001, 2.806111e-001, 2.806204e-001, 2.806296e-001, 2.806389e-001, 2.806482e-001, 2.806574e-001, 2.806667e-001, 2.806759e-001, 2.806852e-001, 2.806945e-001, 2.807037e-001, 2.807130e-001, 2.807222e-001, 2.807315e-001, 2.807407e-001, 2.807500e-001, 2.807592e-001, 2.807685e-001, 2.807778e-001, 2.807870e-001, 2.807963e-001, 2.808055e-001, 2.808148e-001, 2.808240e-001, 2.808333e-001, 2.808425e-001, 2.808518e-001, 2.808610e-001, 2.808702e-001, 2.808795e-001, 2.808887e-001, 2.808980e-001, 2.809072e-001, 2.809165e-001, 
2.809257e-001, 2.809349e-001, 2.809442e-001, 2.809534e-001, 2.809627e-001, 2.809719e-001, 2.809811e-001, 2.809904e-001, 2.809996e-001, 2.810088e-001, 2.810181e-001, 2.810273e-001, 2.810366e-001, 2.810458e-001, 2.810550e-001, 2.810642e-001, 2.810735e-001, 2.810827e-001, 2.810919e-001, 2.811012e-001, 2.811104e-001, 2.811196e-001, 2.811289e-001, 2.811381e-001, 2.811473e-001, 2.811565e-001, 2.811658e-001, 2.811750e-001, 2.811842e-001, 2.811934e-001, 2.812026e-001, 2.812119e-001, 2.812211e-001, 2.812303e-001, 2.812395e-001, 2.812487e-001, 2.812580e-001, 2.812672e-001, 2.812764e-001, 2.812856e-001, 2.812948e-001, 2.813040e-001, 2.813132e-001, 2.813225e-001, 2.813317e-001, 2.813409e-001, 2.813501e-001, 2.813593e-001, 2.813685e-001, 2.813777e-001, 2.813869e-001, 2.813961e-001, 2.814053e-001, 2.814145e-001, 2.814237e-001, 2.814330e-001, 2.814422e-001, 2.814514e-001, 2.814606e-001, 2.814698e-001, 2.814790e-001, 2.814882e-001, 2.814974e-001, 2.815066e-001, 2.815158e-001, 2.815250e-001, 2.815342e-001, 2.815433e-001, 2.815525e-001, 2.815617e-001, 2.815709e-001, 2.815801e-001, 2.815893e-001, 2.815985e-001, 2.816077e-001, 2.816169e-001, 2.816261e-001, 2.816353e-001, 2.816445e-001, 2.816536e-001, 2.816628e-001, 2.816720e-001, 2.816812e-001, 2.816904e-001, 2.816996e-001, 2.817088e-001, 2.817179e-001, 2.817271e-001, 2.817363e-001, 2.817455e-001, 2.817547e-001, 2.817638e-001, 2.817730e-001, 2.817822e-001, 2.817914e-001, 2.818006e-001, 2.818097e-001, 2.818189e-001, 2.818281e-001, 2.818373e-001, 
2.818464e-001, 2.818556e-001, 2.818648e-001, 2.818740e-001, 2.818831e-001, 2.818923e-001, 2.819015e-001, 2.819106e-001, 2.819198e-001, 2.819290e-001, 2.819381e-001, 2.819473e-001, 2.819565e-001, 2.819656e-001, 2.819748e-001, 2.819840e-001, 2.819931e-001, 2.820023e-001, 2.820114e-001, 2.820206e-001, 2.820298e-001, 2.820389e-001, 2.820481e-001, 2.820572e-001, 2.820664e-001, 2.820756e-001, 2.820847e-001, 2.820939e-001, 2.821030e-001, 2.821122e-001, 2.821213e-001, 2.821305e-001, 2.821396e-001, 2.821488e-001, 2.821579e-001, 2.821671e-001, 2.821762e-001, 2.821854e-001, 2.821945e-001, 2.822037e-001, 2.822128e-001, 2.822220e-001, 2.822311e-001, 2.822403e-001, 2.822494e-001, 2.822585e-001, 2.822677e-001, 2.822768e-001, 2.822860e-001, 2.822951e-001, 2.823042e-001, 2.823134e-001, 2.823225e-001, 2.823317e-001, 2.823408e-001, 2.823499e-001, 2.823591e-001, 2.823682e-001, 2.823773e-001, 2.823865e-001, 2.823956e-001, 2.824047e-001, 2.824139e-001, 2.824230e-001, 2.824321e-001, 2.824413e-001, 2.824504e-001, 2.824595e-001, 2.824686e-001, 2.824778e-001, 2.824869e-001, 2.824960e-001, 2.825051e-001, 2.825143e-001, 2.825234e-001, 2.825325e-001, 2.825416e-001, 2.825508e-001, 2.825599e-001, 2.825690e-001, 2.825781e-001, 2.825872e-001, 2.825964e-001, 2.826055e-001, 2.826146e-001, 2.826237e-001, 2.826328e-001, 2.826419e-001, 2.826511e-001, 2.826602e-001, 2.826693e-001, 2.826784e-001, 2.826875e-001, 2.826966e-001, 2.827057e-001, 2.827148e-001, 2.827239e-001, 2.827330e-001, 2.827422e-001, 2.827513e-001, 
2.827604e-001, 2.827695e-001, 2.827786e-001, 2.827877e-001, 2.827968e-001, 2.828059e-001, 2.828150e-001, 2.828241e-001, 2.828332e-001, 2.828423e-001, 2.828514e-001, 2.828605e-001, 2.828696e-001, 2.828787e-001, 2.828878e-001, 2.828969e-001, 2.829060e-001, 2.829151e-001, 2.829242e-001, 2.829332e-001, 2.829423e-001, 2.829514e-001, 2.829605e-001, 2.829696e-001, 2.829787e-001, 2.829878e-001, 2.829969e-001, 2.830060e-001, 2.830151e-001, 2.830241e-001, 2.830332e-001, 2.830423e-001, 2.830514e-001, 2.830605e-001, 2.830696e-001, 2.830786e-001, 2.830877e-001, 2.830968e-001, 2.831059e-001, 2.831150e-001, 2.831240e-001, 2.831331e-001, 2.831422e-001, 2.831513e-001, 2.831604e-001, 2.831694e-001, 2.831785e-001, 2.831876e-001, 2.831966e-001, 2.832057e-001, 2.832148e-001, 2.832239e-001, 2.832329e-001, 2.832420e-001, 2.832511e-001, 2.832601e-001, 2.832692e-001, 2.832783e-001, 2.832873e-001, 2.832964e-001, 2.833055e-001, 2.833145e-001, 2.833236e-001, 2.833327e-001, 2.833417e-001, 2.833508e-001, 2.833599e-001, 2.833689e-001, 2.833780e-001, 2.833870e-001, 2.833961e-001, 2.834051e-001, 2.834142e-001, 2.834233e-001, 2.834323e-001, 2.834414e-001, 2.834504e-001, 2.834595e-001, 2.834685e-001, 2.834776e-001, 2.834866e-001, 2.834957e-001, 2.835047e-001, 2.835138e-001, 2.835228e-001, 2.835319e-001, 2.835409e-001, 2.835500e-001, 2.835590e-001, 2.835681e-001, 2.835771e-001, 2.835862e-001, 2.835952e-001, 2.836043e-001, 2.836133e-001, 2.836223e-001, 2.836314e-001, 2.836404e-001, 2.836495e-001, 2.836585e-001, 
2.836675e-001, 2.836766e-001, 2.836856e-001, 2.836946e-001, 2.837037e-001, 2.837127e-001, 2.837218e-001, 2.837308e-001, 2.837398e-001, 2.837489e-001, 2.837579e-001, 2.837669e-001, 2.837759e-001, 2.837850e-001, 2.837940e-001, 2.838030e-001, 2.838121e-001, 2.838211e-001, 2.838301e-001, 2.838391e-001, 2.838482e-001, 2.838572e-001, 2.838662e-001, 2.838752e-001, 2.838843e-001, 2.838933e-001, 2.839023e-001, 2.839113e-001, 2.839203e-001, 2.839294e-001, 2.839384e-001, 2.839474e-001, 2.839564e-001, 2.839654e-001, 2.839744e-001, 2.839835e-001, 2.839925e-001, 2.840015e-001, 2.840105e-001, 2.840195e-001, 2.840285e-001, 2.840375e-001, 2.840465e-001, 2.840556e-001, 2.840646e-001, 2.840736e-001, 2.840826e-001, 2.840916e-001, 2.841006e-001, 2.841096e-001, 2.841186e-001, 2.841276e-001, 2.841366e-001, 2.841456e-001, 2.841546e-001, 2.841636e-001, 2.841726e-001, 2.841816e-001, 2.841906e-001, 2.841996e-001, 2.842086e-001, 2.842176e-001, 2.842266e-001, 2.842356e-001, 2.842446e-001, 2.842536e-001, 2.842626e-001, 2.842716e-001, 2.842806e-001, 2.842896e-001, 2.842986e-001, 2.843076e-001, 2.843165e-001, 2.843255e-001, 2.843345e-001, 2.843435e-001, 2.843525e-001, 2.843615e-001, 2.843705e-001, 2.843795e-001, 2.843884e-001, 2.843974e-001, 2.844064e-001, 2.844154e-001, 2.844244e-001, 2.844334e-001, 2.844423e-001, 2.844513e-001, 2.844603e-001, 2.844693e-001, 2.844783e-001, 2.844872e-001, 2.844962e-001, 2.845052e-001, 2.845142e-001, 2.845231e-001, 2.845321e-001, 2.845411e-001, 2.845501e-001, 2.845590e-001, 
2.845680e-001, 2.845770e-001, 2.845859e-001, 2.845949e-001, 2.846039e-001, 2.846128e-001, 2.846218e-001, 2.846308e-001, 2.846397e-001, 2.846487e-001, 2.846577e-001, 2.846666e-001, 2.846756e-001, 2.846846e-001, 2.846935e-001, 2.847025e-001, 2.847115e-001, 2.847204e-001, 2.847294e-001, 2.847383e-001, 2.847473e-001, 2.847562e-001, 2.847652e-001, 2.847742e-001, 2.847831e-001, 2.847921e-001, 2.848010e-001, 2.848100e-001, 2.848189e-001, 2.848279e-001, 2.848368e-001, 2.848458e-001, 2.848547e-001, 2.848637e-001, 2.848726e-001, 2.848816e-001, 2.848905e-001, 2.848995e-001, 2.849084e-001, 2.849174e-001, 2.849263e-001, 2.849353e-001, 2.849442e-001, 2.849531e-001, 2.849621e-001, 2.849710e-001, 2.849800e-001, 2.849889e-001, 2.849978e-001, 2.850068e-001, 2.850157e-001, 2.850247e-001, 2.850336e-001, 2.850425e-001, 2.850515e-001, 2.850604e-001, 2.850693e-001, 2.850783e-001, 2.850872e-001, 2.850961e-001, 2.851051e-001, 2.851140e-001, 2.851229e-001, 2.851319e-001, 2.851408e-001, 2.851497e-001, 2.851586e-001, 2.851676e-001, 2.851765e-001, 2.851854e-001, 2.851944e-001, 2.852033e-001, 2.852122e-001, 2.852211e-001, 2.852300e-001, 2.852390e-001, 2.852479e-001, 2.852568e-001, 2.852657e-001, 2.852746e-001, 2.852836e-001, 2.852925e-001, 2.853014e-001, 2.853103e-001, 2.853192e-001, 2.853281e-001, 2.853371e-001, 2.853460e-001, 2.853549e-001, 2.853638e-001, 2.853727e-001, 2.853816e-001, 2.853905e-001, 2.853994e-001, 2.854084e-001, 2.854173e-001, 2.854262e-001, 2.854351e-001, 2.854440e-001, 2.854529e-001, 
2.854618e-001, 2.854707e-001, 2.854796e-001, 2.854885e-001, 2.854974e-001, 2.855063e-001, 2.855152e-001, 2.855241e-001, 2.855330e-001, 2.855419e-001, 2.855508e-001, 2.855597e-001, 2.855686e-001, 2.855775e-001, 2.855864e-001, 2.855953e-001, 2.856042e-001, 2.856131e-001, 2.856220e-001, 2.856309e-001, 2.856398e-001, 2.856486e-001, 2.856575e-001, 2.856664e-001, 2.856753e-001, 2.856842e-001, 2.856931e-001, 2.857020e-001, 2.857109e-001, 2.857198e-001, 2.857286e-001, 2.857375e-001, 2.857464e-001, 2.857553e-001, 2.857642e-001, 2.857731e-001, 2.857819e-001, 2.857908e-001, 2.857997e-001, 2.858086e-001, 2.858175e-001, 2.858263e-001, 2.858352e-001, 2.858441e-001, 2.858530e-001, 2.858618e-001, 2.858707e-001, 2.858796e-001, 2.858885e-001, 2.858973e-001, 2.859062e-001, 2.859151e-001, 2.859239e-001, 2.859328e-001, 2.859417e-001, 2.859506e-001, 2.859594e-001, 2.859683e-001, 2.859772e-001, 2.859860e-001, 2.859949e-001, 2.860038e-001, 2.860126e-001, 2.860215e-001, 2.860303e-001, 2.860392e-001, 2.860481e-001, 2.860569e-001, 2.860658e-001, 2.860746e-001, 2.860835e-001, 2.860924e-001, 2.861012e-001, 2.861101e-001, 2.861189e-001, 2.861278e-001, 2.861366e-001, 2.861455e-001, 2.861544e-001, 2.861632e-001, 2.861721e-001, 2.861809e-001, 2.861898e-001, 2.861986e-001, 2.862075e-001, 2.862163e-001, 2.862252e-001, 2.862340e-001, 2.862429e-001, 2.862517e-001, 2.862605e-001, 2.862694e-001, 2.862782e-001, 2.862871e-001, 2.862959e-001, 2.863048e-001, 2.863136e-001, 2.863224e-001, 2.863313e-001, 2.863401e-001, 
2.863490e-001, 2.863578e-001, 2.863666e-001, 2.863755e-001, 2.863843e-001, 2.863931e-001, 2.864020e-001, 2.864108e-001, 2.864197e-001, 2.864285e-001, 2.864373e-001, 2.864461e-001, 2.864550e-001, 2.864638e-001, 2.864726e-001, 2.864815e-001, 2.864903e-001, 2.864991e-001, 2.865080e-001, 2.865168e-001, 2.865256e-001, 2.865344e-001, 2.865433e-001, 2.865521e-001, 2.865609e-001, 2.865697e-001, 2.865785e-001, 2.865874e-001, 2.865962e-001, 2.866050e-001, 2.866138e-001, 2.866226e-001, 2.866315e-001, 2.866403e-001, 2.866491e-001, 2.866579e-001, 2.866667e-001, 2.866755e-001, 2.866844e-001, 2.866932e-001, 2.867020e-001, 2.867108e-001, 2.867196e-001, 2.867284e-001, 2.867372e-001, 2.867460e-001, 2.867549e-001, 2.867637e-001, 2.867725e-001, 2.867813e-001, 2.867901e-001, 2.867989e-001, 2.868077e-001, 2.868165e-001, 2.868253e-001, 2.868341e-001, 2.868429e-001, 2.868517e-001, 2.868605e-001, 2.868693e-001, 2.868781e-001, 2.868869e-001, 2.868957e-001, 2.869045e-001, 2.869133e-001, 2.869221e-001, 2.869309e-001, 2.869397e-001, 2.869485e-001, 2.869573e-001, 2.869661e-001, 2.869749e-001, 2.869837e-001, 2.869924e-001, 2.870012e-001, 2.870100e-001, 2.870188e-001, 2.870276e-001, 2.870364e-001, 2.870452e-001, 2.870540e-001, 2.870627e-001, 2.870715e-001, 2.870803e-001, 2.870891e-001, 2.870979e-001, 2.871067e-001, 2.871154e-001, 2.871242e-001, 2.871330e-001, 2.871418e-001, 2.871506e-001, 2.871593e-001, 2.871681e-001, 2.871769e-001, 2.871857e-001, 2.871945e-001, 2.872032e-001, 2.872120e-001, 2.872208e-001, 
2.872296e-001, 2.872383e-001, 2.872471e-001, 2.872559e-001, 2.872646e-001, 2.872734e-001, 2.872822e-001, 2.872910e-001, 2.872997e-001, 2.873085e-001, 2.873173e-001, 2.873260e-001, 2.873348e-001, 2.873436e-001, 2.873523e-001, 2.873611e-001, 2.873698e-001, 2.873786e-001, 2.873874e-001, 2.873961e-001, 2.874049e-001, 2.874136e-001, 2.874224e-001, 2.874312e-001, 2.874399e-001, 2.874487e-001, 2.874574e-001, 2.874662e-001, 2.874749e-001, 2.874837e-001, 2.874925e-001, 2.875012e-001, 2.875100e-001, 2.875187e-001, 2.875275e-001, 2.875362e-001, 2.875450e-001, 2.875537e-001, 2.875625e-001, 2.875712e-001, 2.875800e-001, 2.875887e-001, 2.875975e-001, 2.876062e-001, 2.876149e-001, 2.876237e-001, 2.876324e-001, 2.876412e-001, 2.876499e-001, 2.876587e-001, 2.876674e-001, 2.876761e-001, 2.876849e-001, 2.876936e-001, 2.877024e-001, 2.877111e-001, 2.877198e-001, 2.877286e-001, 2.877373e-001, 2.877460e-001, 2.877548e-001, 2.877635e-001, 2.877722e-001, 2.877810e-001, 2.877897e-001, 2.877984e-001, 2.878072e-001, 2.878159e-001, 2.878246e-001, 2.878334e-001, 2.878421e-001, 2.878508e-001, 2.878595e-001, 2.878683e-001, 2.878770e-001, 2.878857e-001, 2.878944e-001, 2.879032e-001, 2.879119e-001, 2.879206e-001, 2.879293e-001, 2.879380e-001, 2.879468e-001, 2.879555e-001, 2.879642e-001, 2.879729e-001, 2.879816e-001, 2.879904e-001, 2.879991e-001, 2.880078e-001, 2.880165e-001, 2.880252e-001, 2.880339e-001, 2.880426e-001, 2.880514e-001, 2.880601e-001, 2.880688e-001, 2.880775e-001, 2.880862e-001, 2.880949e-001, 
2.881036e-001, 2.881123e-001, 2.881210e-001, 2.881297e-001, 2.881384e-001, 2.881471e-001, 2.881558e-001, 2.881646e-001, 2.881733e-001, 2.881820e-001, 2.881907e-001, 2.881994e-001, 2.882081e-001, 2.882168e-001, 2.882255e-001, 2.882342e-001, 2.882429e-001, 2.882516e-001, 2.882603e-001, 2.882689e-001, 2.882776e-001, 2.882863e-001, 2.882950e-001, 2.883037e-001, 2.883124e-001, 2.883211e-001, 2.883298e-001, 2.883385e-001, 2.883472e-001, 2.883559e-001, 2.883646e-001, 2.883732e-001, 2.883819e-001, 2.883906e-001, 2.883993e-001, 2.884080e-001, 2.884167e-001, 2.884254e-001, 2.884340e-001, 2.884427e-001, 2.884514e-001, 2.884601e-001, 2.884688e-001, 2.884775e-001, 2.884861e-001, 2.884948e-001, 2.885035e-001, 2.885122e-001, 2.885209e-001, 2.885295e-001, 2.885382e-001, 2.885469e-001, 2.885556e-001, 2.885642e-001, 2.885729e-001, 2.885816e-001, 2.885902e-001, 2.885989e-001, 2.886076e-001, 2.886163e-001, 2.886249e-001, 2.886336e-001, 2.886423e-001, 2.886509e-001, 2.886596e-001, 2.886683e-001, 2.886769e-001, 2.886856e-001, 2.886943e-001, 2.887029e-001, 2.887116e-001, 2.887202e-001, 2.887289e-001, 2.887376e-001, 2.887462e-001, 2.887549e-001, 2.887635e-001, 2.887722e-001, 2.887809e-001, 2.887895e-001, 2.887982e-001, 2.888068e-001, 2.888155e-001, 2.888241e-001, 2.888328e-001, 2.888415e-001, 2.888501e-001, 2.888588e-001, 2.888674e-001, 2.888761e-001, 2.888847e-001, 2.888934e-001, 2.889020e-001, 2.889107e-001, 2.889193e-001, 2.889280e-001, 2.889366e-001, 2.889452e-001, 2.889539e-001, 2.889625e-001, 
2.889712e-001, 2.889798e-001, 2.889885e-001, 2.889971e-001, 2.890057e-001, 2.890144e-001, 2.890230e-001, 2.890317e-001, 2.890403e-001, 2.890489e-001, 2.890576e-001, 2.890662e-001, 2.890748e-001, 2.890835e-001, 2.890921e-001, 2.891008e-001, 2.891094e-001, 2.891180e-001, 2.891267e-001, 2.891353e-001, 2.891439e-001, 2.891525e-001, 2.891612e-001, 2.891698e-001, 2.891784e-001, 2.891871e-001, 2.891957e-001, 2.892043e-001, 2.892129e-001, 2.892216e-001, 2.892302e-001, 2.892388e-001, 2.892474e-001, 2.892561e-001, 2.892647e-001, 2.892733e-001, 2.892819e-001, 2.892905e-001, 2.892992e-001, 2.893078e-001, 2.893164e-001, 2.893250e-001, 2.893336e-001, 2.893422e-001, 2.893509e-001, 2.893595e-001, 2.893681e-001, 2.893767e-001, 2.893853e-001, 2.893939e-001, 2.894025e-001, 2.894111e-001, 2.894198e-001, 2.894284e-001, 2.894370e-001, 2.894456e-001, 2.894542e-001, 2.894628e-001, 2.894714e-001, 2.894800e-001, 2.894886e-001, 2.894972e-001, 2.895058e-001, 2.895144e-001, 2.895230e-001, 2.895316e-001, 2.895402e-001, 2.895488e-001, 2.895574e-001, 2.895660e-001, 2.895746e-001, 2.895832e-001, 2.895918e-001, 2.896004e-001, 2.896090e-001, 2.896176e-001, 2.896262e-001, 2.896348e-001, 2.896434e-001, 2.896520e-001, 2.896606e-001, 2.896692e-001, 2.896778e-001, 2.896864e-001, 2.896949e-001, 2.897035e-001, 2.897121e-001, 2.897207e-001, 2.897293e-001, 2.897379e-001, 2.897465e-001, 2.897550e-001, 2.897636e-001, 2.897722e-001, 2.897808e-001, 2.897894e-001, 2.897980e-001, 2.898065e-001, 2.898151e-001, 2.898237e-001, 
2.898323e-001, 2.898409e-001, 2.898494e-001, 2.898580e-001, 2.898666e-001, 2.898752e-001, 2.898837e-001, 2.898923e-001, 2.899009e-001, 2.899095e-001, 2.899180e-001, 2.899266e-001, 2.899352e-001, 2.899438e-001, 2.899523e-001, 2.899609e-001, 2.899695e-001, 2.899780e-001, 2.899866e-001, 2.899952e-001, 2.900037e-001, 2.900123e-001, 2.900209e-001, 2.900294e-001, 2.900380e-001, 2.900466e-001, 2.900551e-001, 2.900637e-001, 2.900722e-001, 2.900808e-001, 2.900894e-001, 2.900979e-001, 2.901065e-001, 2.901150e-001, 2.901236e-001, 2.901322e-001, 2.901407e-001, 2.901493e-001, 2.901578e-001, 2.901664e-001, 2.901749e-001, 2.901835e-001, 2.901920e-001, 2.902006e-001, 2.902091e-001, 2.902177e-001, 2.902262e-001, 2.902348e-001, 2.902433e-001, 2.902519e-001, 2.902604e-001, 2.902690e-001, 2.902775e-001, 2.902861e-001, 2.902946e-001, 2.903032e-001, 2.903117e-001, 2.903202e-001, 2.903288e-001, 2.903373e-001, 2.903459e-001, 2.903544e-001, 2.903630e-001, 2.903715e-001, 2.903800e-001, 2.903886e-001, 2.903971e-001, 2.904056e-001, 2.904142e-001, 2.904227e-001, 2.904312e-001, 2.904398e-001, 2.904483e-001, 2.904568e-001, 2.904654e-001, 2.904739e-001, 2.904824e-001, 2.904910e-001, 2.904995e-001, 2.905080e-001, 2.905166e-001, 2.905251e-001, 2.905336e-001, 2.905421e-001, 2.905507e-001, 2.905592e-001, 2.905677e-001, 2.905762e-001, 2.905848e-001, 2.905933e-001, 2.906018e-001, 2.906103e-001, 2.906188e-001, 2.906274e-001, 2.906359e-001, 2.906444e-001, 2.906529e-001, 2.906614e-001, 2.906700e-001, 2.906785e-001, 
2.906870e-001, 2.906955e-001, 2.907040e-001, 2.907125e-001, 2.907210e-001, 2.907296e-001, 2.907381e-001, 2.907466e-001, 2.907551e-001, 2.907636e-001, 2.907721e-001, 2.907806e-001, 2.907891e-001, 2.907976e-001, 2.908061e-001, 2.908146e-001, 2.908231e-001, 2.908317e-001, 2.908402e-001, 2.908487e-001, 2.908572e-001, 2.908657e-001, 2.908742e-001, 2.908827e-001, 2.908912e-001, 2.908997e-001, 2.909082e-001, 2.909167e-001, 2.909252e-001, 2.909337e-001, 2.909422e-001, 2.909506e-001, 2.909591e-001, 2.909676e-001, 2.909761e-001, 2.909846e-001, 2.909931e-001, 2.910016e-001, 2.910101e-001, 2.910186e-001, 2.910271e-001, 2.910356e-001, 2.910441e-001, 2.910525e-001, 2.910610e-001, 2.910695e-001, 2.910780e-001, 2.910865e-001, 2.910950e-001, 2.911035e-001, 2.911119e-001, 2.911204e-001, 2.911289e-001, 2.911374e-001, 2.911459e-001, 2.911544e-001, 2.911628e-001, 2.911713e-001, 2.911798e-001, 2.911883e-001, 2.911967e-001, 2.912052e-001, 2.912137e-001, 2.912222e-001, 2.912307e-001, 2.912391e-001, 2.912476e-001, 2.912561e-001, 2.912645e-001, 2.912730e-001, 2.912815e-001, 2.912900e-001, 2.912984e-001, 2.913069e-001, 2.913154e-001, 2.913238e-001, 2.913323e-001, 2.913408e-001, 2.913492e-001, 2.913577e-001, 2.913662e-001, 2.913746e-001, 2.913831e-001, 2.913916e-001, 2.914000e-001, 2.914085e-001, 2.914169e-001, 2.914254e-001, 2.914339e-001, 2.914423e-001, 2.914508e-001, 2.914592e-001, 2.914677e-001, 2.914761e-001, 2.914846e-001, 2.914931e-001, 2.915015e-001, 2.915100e-001, 2.915184e-001, 2.915269e-001, 
2.915353e-001, 2.915438e-001, 2.915522e-001, 2.915607e-001, 2.915691e-001, 2.915776e-001, 2.915860e-001, 2.915945e-001, 2.916029e-001, 2.916114e-001, 2.916198e-001, 2.916282e-001, 2.916367e-001, 2.916451e-001, 2.916536e-001, 2.916620e-001, 2.916705e-001, 2.916789e-001, 2.916873e-001, 2.916958e-001, 2.917042e-001, 2.917127e-001, 2.917211e-001, 2.917295e-001, 2.917380e-001, 2.917464e-001, 2.917548e-001, 2.917633e-001, 2.917717e-001, 2.917801e-001, 2.917886e-001, 2.917970e-001, 2.918054e-001, 2.918139e-001, 2.918223e-001, 2.918307e-001, 2.918392e-001, 2.918476e-001, 2.918560e-001, 2.918645e-001, 2.918729e-001, 2.918813e-001, 2.918897e-001, 2.918982e-001, 2.919066e-001, 2.919150e-001, 2.919234e-001, 2.919318e-001, 2.919403e-001, 2.919487e-001, 2.919571e-001, 2.919655e-001, 2.919739e-001, 2.919824e-001, 2.919908e-001, 2.919992e-001, 2.920076e-001, 2.920160e-001, 2.920244e-001, 2.920329e-001, 2.920413e-001, 2.920497e-001, 2.920581e-001, 2.920665e-001, 2.920749e-001, 2.920833e-001, 2.920917e-001, 2.921002e-001, 2.921086e-001, 2.921170e-001, 2.921254e-001, 2.921338e-001, 2.921422e-001, 2.921506e-001, 2.921590e-001, 2.921674e-001, 2.921758e-001, 2.921842e-001, 2.921926e-001, 2.922010e-001, 2.922094e-001, 2.922178e-001, 2.922262e-001, 2.922346e-001, 2.922430e-001, 2.922514e-001, 2.922598e-001, 2.922682e-001, 2.922766e-001, 2.922850e-001, 2.922934e-001, 2.923018e-001, 2.923102e-001, 2.923186e-001, 2.923270e-001, 2.923354e-001, 2.923438e-001, 2.923522e-001, 2.923605e-001, 2.923689e-001, 
2.923773e-001, 2.923857e-001, 2.923941e-001, 2.924025e-001, 2.924109e-001, 2.924193e-001, 2.924276e-001, 2.924360e-001, 2.924444e-001, 2.924528e-001, 2.924612e-001, 2.924696e-001, 2.924779e-001, 2.924863e-001, 2.924947e-001, 2.925031e-001, 2.925115e-001, 2.925198e-001, 2.925282e-001, 2.925366e-001, 2.925450e-001, 2.925533e-001, 2.925617e-001, 2.925701e-001, 2.925785e-001, 2.925868e-001, 2.925952e-001, 2.926036e-001, 2.926120e-001, 2.926203e-001, 2.926287e-001, 2.926371e-001, 2.926454e-001, 2.926538e-001, 2.926622e-001, 2.926705e-001, 2.926789e-001, 2.926873e-001, 2.926956e-001, 2.927040e-001, 2.927124e-001, 2.927207e-001, 2.927291e-001, 2.927374e-001, 2.927458e-001, 2.927542e-001, 2.927625e-001, 2.927709e-001, 2.927792e-001, 2.927876e-001, 2.927960e-001, 2.928043e-001, 2.928127e-001, 2.928210e-001, 2.928294e-001, 2.928377e-001, 2.928461e-001, 2.928544e-001, 2.928628e-001, 2.928712e-001, 2.928795e-001, 2.928879e-001, 2.928962e-001, 2.929046e-001, 2.929129e-001, 2.929212e-001, 2.929296e-001, 2.929379e-001, 2.929463e-001, 2.929546e-001, 2.929630e-001, 2.929713e-001, 2.929797e-001, 2.929880e-001, 2.929964e-001, 2.930047e-001, 2.930130e-001, 2.930214e-001, 2.930297e-001, 2.930381e-001, 2.930464e-001, 2.930547e-001, 2.930631e-001, 2.930714e-001, 2.930797e-001, 2.930881e-001, 2.930964e-001, 2.931047e-001, 2.931131e-001, 2.931214e-001, 2.931297e-001, 2.931381e-001, 2.931464e-001, 2.931547e-001, 2.931631e-001, 2.931714e-001, 2.931797e-001, 2.931881e-001, 2.931964e-001, 2.932047e-001, 
2.932130e-001, 2.932214e-001, 2.932297e-001, 2.932380e-001, 2.932463e-001, 2.932547e-001, 2.932630e-001, 2.932713e-001, 2.932796e-001, 2.932879e-001, 2.932963e-001, 2.933046e-001, 2.933129e-001, 2.933212e-001, 2.933295e-001, 2.933379e-001, 2.933462e-001, 2.933545e-001, 2.933628e-001, 2.933711e-001, 2.933794e-001, 2.933877e-001, 2.933961e-001, 2.934044e-001, 2.934127e-001, 2.934210e-001, 2.934293e-001, 2.934376e-001, 2.934459e-001, 2.934542e-001, 2.934625e-001, 2.934708e-001, 2.934791e-001, 2.934874e-001, 2.934958e-001, 2.935041e-001, 2.935124e-001, 2.935207e-001, 2.935290e-001, 2.935373e-001, 2.935456e-001, 2.935539e-001, 2.935622e-001, 2.935705e-001, 2.935788e-001, 2.935871e-001, 2.935954e-001, 2.936037e-001, 2.936120e-001, 2.936202e-001, 2.936285e-001, 2.936368e-001, 2.936451e-001, 2.936534e-001, 2.936617e-001, 2.936700e-001, 2.936783e-001, 2.936866e-001, 2.936949e-001, 2.937032e-001, 2.937115e-001, 2.937197e-001, 2.937280e-001, 2.937363e-001, 2.937446e-001, 2.937529e-001, 2.937612e-001, 2.937695e-001, 2.937777e-001, 2.937860e-001, 2.937943e-001, 2.938026e-001, 2.938109e-001, 2.938192e-001, 2.938274e-001, 2.938357e-001, 2.938440e-001, 2.938523e-001, 2.938605e-001, 2.938688e-001, 2.938771e-001, 2.938854e-001, 2.938937e-001, 2.939019e-001, 2.939102e-001, 2.939185e-001, 2.939267e-001, 2.939350e-001, 2.939433e-001, 2.939516e-001, 2.939598e-001, 2.939681e-001, 2.939764e-001, 2.939846e-001, 2.939929e-001, 2.940012e-001, 2.940094e-001, 2.940177e-001, 2.940260e-001, 2.940342e-001, 
2.940425e-001, 2.940508e-001, 2.940590e-001, 2.940673e-001, 2.940755e-001, 2.940838e-001, 2.940921e-001, 2.941003e-001, 2.941086e-001, 2.941168e-001, 2.941251e-001, 2.941334e-001, 2.941416e-001, 2.941499e-001, 2.941581e-001, 2.941664e-001, 2.941746e-001, 2.941829e-001, 2.941911e-001, 2.941994e-001, 2.942076e-001, 2.942159e-001, 2.942241e-001, 2.942324e-001, 2.942406e-001, 2.942489e-001, 2.942571e-001, 2.942654e-001, 2.942736e-001, 2.942819e-001, 2.942901e-001, 2.942984e-001, 2.943066e-001, 2.943149e-001, 2.943231e-001, 2.943313e-001, 2.943396e-001, 2.943478e-001, 2.943561e-001, 2.943643e-001, 2.943725e-001, 2.943808e-001, 2.943890e-001, 2.943973e-001, 2.944055e-001, 2.944137e-001, 2.944220e-001, 2.944302e-001, 2.944384e-001, 2.944467e-001, 2.944549e-001, 2.944631e-001, 2.944714e-001, 2.944796e-001, 2.944878e-001, 2.944961e-001, 2.945043e-001, 2.945125e-001, 2.945207e-001, 2.945290e-001, 2.945372e-001, 2.945454e-001, 2.945536e-001, 2.945619e-001, 2.945701e-001, 2.945783e-001, 2.945865e-001, 2.945948e-001, 2.946030e-001, 2.946112e-001, 2.946194e-001, 2.946276e-001, 2.946359e-001, 2.946441e-001, 2.946523e-001, 2.946605e-001, 2.946687e-001, 2.946769e-001, 2.946852e-001, 2.946934e-001, 2.947016e-001, 2.947098e-001, 2.947180e-001, 2.947262e-001, 2.947344e-001, 2.947427e-001, 2.947509e-001, 2.947591e-001, 2.947673e-001, 2.947755e-001, 2.947837e-001, 2.947919e-001, 2.948001e-001, 2.948083e-001, 2.948165e-001, 2.948247e-001, 2.948329e-001, 2.948411e-001, 2.948493e-001, 2.948575e-001, 
2.948657e-001, 2.948740e-001, 2.948822e-001, 2.948904e-001, 2.948986e-001, 2.949067e-001, 2.949149e-001, 2.949231e-001, 2.949313e-001, 2.949395e-001, 2.949477e-001, 2.949559e-001, 2.949641e-001, 2.949723e-001, 2.949805e-001, 2.949887e-001, 2.949969e-001, 2.950051e-001, 2.950133e-001, 2.950215e-001, 2.950297e-001, 2.950378e-001, 2.950460e-001, 2.950542e-001, 2.950624e-001, 2.950706e-001, 2.950788e-001, 2.950870e-001, 2.950952e-001, 2.951033e-001, 2.951115e-001, 2.951197e-001, 2.951279e-001, 2.951361e-001, 2.951442e-001, 2.951524e-001, 2.951606e-001, 2.951688e-001, 2.951770e-001, 2.951851e-001, 2.951933e-001, 2.952015e-001, 2.952097e-001, 2.952178e-001, 2.952260e-001, 2.952342e-001, 2.952424e-001, 2.952505e-001, 2.952587e-001, 2.952669e-001, 2.952751e-001, 2.952832e-001, 2.952914e-001, 2.952996e-001, 2.953077e-001, 2.953159e-001, 2.953241e-001, 2.953322e-001, 2.953404e-001, 2.953486e-001, 2.953567e-001, 2.953649e-001, 2.953731e-001, 2.953812e-001, 2.953894e-001, 2.953975e-001, 2.954057e-001, 2.954139e-001, 2.954220e-001, 2.954302e-001, 2.954383e-001, 2.954465e-001, 2.954547e-001, 2.954628e-001, 2.954710e-001, 2.954791e-001, 2.954873e-001, 2.954954e-001, 2.955036e-001, 2.955118e-001, 2.955199e-001, 2.955281e-001, 2.955362e-001, 2.955444e-001, 2.955525e-001, 2.955607e-001, 2.955688e-001, 2.955770e-001, 2.955851e-001, 2.955933e-001, 2.956014e-001, 2.956095e-001, 2.956177e-001, 2.956258e-001, 2.956340e-001, 2.956421e-001, 2.956503e-001, 2.956584e-001, 2.956665e-001, 2.956747e-001, 
2.956828e-001, 2.956910e-001, 2.956991e-001, 2.957072e-001, 2.957154e-001, 2.957235e-001, 2.957317e-001, 2.957398e-001, 2.957479e-001, 2.957561e-001, 2.957642e-001, 2.957723e-001, 2.957805e-001, 2.957886e-001, 2.957967e-001, 2.958049e-001, 2.958130e-001, 2.958211e-001, 2.958292e-001, 2.958374e-001, 2.958455e-001, 2.958536e-001, 2.958618e-001, 2.958699e-001, 2.958780e-001, 2.958861e-001, 2.958943e-001, 2.959024e-001, 2.959105e-001, 2.959186e-001, 2.959268e-001, 2.959349e-001, 2.959430e-001, 2.959511e-001, 2.959592e-001, 2.959674e-001, 2.959755e-001, 2.959836e-001, 2.959917e-001, 2.959998e-001, 2.960079e-001, 2.960161e-001, 2.960242e-001, 2.960323e-001, 2.960404e-001, 2.960485e-001, 2.960566e-001, 2.960647e-001, 2.960728e-001, 2.960810e-001, 2.960891e-001, 2.960972e-001, 2.961053e-001, 2.961134e-001, 2.961215e-001, 2.961296e-001, 2.961377e-001, 2.961458e-001, 2.961539e-001, 2.961620e-001, 2.961701e-001, 2.961782e-001, 2.961863e-001, 2.961944e-001, 2.962025e-001, 2.962106e-001, 2.962187e-001, 2.962268e-001, 2.962349e-001, 2.962430e-001, 2.962511e-001, 2.962592e-001, 2.962673e-001, 2.962754e-001, 2.962835e-001, 2.962916e-001, 2.962997e-001, 2.963078e-001, 2.963159e-001, 2.963240e-001, 2.963321e-001, 2.963402e-001, 2.963483e-001, 2.963563e-001, 2.963644e-001, 2.963725e-001, 2.963806e-001, 2.963887e-001, 2.963968e-001, 2.964049e-001, 2.964130e-001, 2.964210e-001, 2.964291e-001, 2.964372e-001, 2.964453e-001, 2.964534e-001, 2.964615e-001, 2.964695e-001, 2.964776e-001, 2.964857e-001, 
2.964938e-001, 2.965019e-001, 2.965099e-001, 2.965180e-001, 2.965261e-001, 2.965342e-001, 2.965422e-001, 2.965503e-001, 2.965584e-001, 2.965665e-001, 2.965745e-001, 2.965826e-001, 2.965907e-001, 2.965987e-001, 2.966068e-001, 2.966149e-001, 2.966230e-001, 2.966310e-001, 2.966391e-001, 2.966472e-001, 2.966552e-001, 2.966633e-001, 2.966714e-001, 2.966794e-001, 2.966875e-001, 2.966956e-001, 2.967036e-001, 2.967117e-001, 2.967197e-001, 2.967278e-001, 2.967359e-001, 2.967439e-001, 2.967520e-001, 2.967600e-001, 2.967681e-001, 2.967762e-001, 2.967842e-001, 2.967923e-001, 2.968003e-001, 2.968084e-001, 2.968164e-001, 2.968245e-001, 2.968325e-001, 2.968406e-001, 2.968487e-001, 2.968567e-001, 2.968648e-001, 2.968728e-001, 2.968809e-001, 2.968889e-001, 2.968970e-001, 2.969050e-001, 2.969131e-001, 2.969211e-001, 2.969291e-001, 2.969372e-001, 2.969452e-001, 2.969533e-001, 2.969613e-001, 2.969694e-001, 2.969774e-001, 2.969855e-001, 2.969935e-001, 2.970015e-001, 2.970096e-001, 2.970176e-001, 2.970257e-001, 2.970337e-001, 2.970417e-001, 2.970498e-001, 2.970578e-001, 2.970658e-001, 2.970739e-001, 2.970819e-001, 2.970899e-001, 2.970980e-001, 2.971060e-001, 2.971140e-001, 2.971221e-001, 2.971301e-001, 2.971381e-001, 2.971462e-001, 2.971542e-001, 2.971622e-001, 2.971703e-001, 2.971783e-001, 2.971863e-001, 2.971943e-001, 2.972024e-001, 2.972104e-001, 2.972184e-001, 2.972264e-001, 2.972345e-001, 2.972425e-001, 2.972505e-001, 2.972585e-001, 2.972665e-001, 2.972746e-001, 2.972826e-001, 2.972906e-001, 
2.972986e-001, 2.973066e-001, 2.973147e-001, 2.973227e-001, 2.973307e-001, 2.973387e-001, 2.973467e-001, 2.973547e-001, 2.973627e-001, 2.973708e-001, 2.973788e-001, 2.973868e-001, 2.973948e-001, 2.974028e-001, 2.974108e-001, 2.974188e-001, 2.974268e-001, 2.974348e-001, 2.974428e-001, 2.974509e-001, 2.974589e-001, 2.974669e-001, 2.974749e-001, 2.974829e-001, 2.974909e-001, 2.974989e-001, 2.975069e-001, 2.975149e-001, 2.975229e-001, 2.975309e-001, 2.975389e-001, 2.975469e-001, 2.975549e-001, 2.975629e-001, 2.975709e-001, 2.975789e-001, 2.975869e-001, 2.975949e-001, 2.976029e-001, 2.976109e-001, 2.976189e-001, 2.976269e-001, 2.976348e-001, 2.976428e-001, 2.976508e-001, 2.976588e-001, 2.976668e-001, 2.976748e-001, 2.976828e-001, 2.976908e-001, 2.976988e-001, 2.977068e-001, 2.977147e-001, 2.977227e-001, 2.977307e-001, 2.977387e-001, 2.977467e-001, 2.977547e-001, 2.977626e-001, 2.977706e-001, 2.977786e-001, 2.977866e-001, 2.977946e-001, 2.978026e-001, 2.978105e-001, 2.978185e-001, 2.978265e-001, 2.978345e-001, 2.978424e-001, 2.978504e-001, 2.978584e-001, 2.978664e-001, 2.978744e-001, 2.978823e-001, 2.978903e-001, 2.978983e-001, 2.979062e-001, 2.979142e-001, 2.979222e-001, 2.979302e-001, 2.979381e-001, 2.979461e-001, 2.979541e-001, 2.979620e-001, 2.979700e-001, 2.979780e-001, 2.979859e-001, 2.979939e-001, 2.980019e-001, 2.980098e-001, 2.980178e-001, 2.980258e-001, 2.980337e-001, 2.980417e-001, 2.980496e-001, 2.980576e-001, 2.980656e-001, 2.980735e-001, 2.980815e-001, 2.980894e-001, 
2.980974e-001, 2.981054e-001, 2.981133e-001, 2.981213e-001, 2.981292e-001, 2.981372e-001, 2.981451e-001, 2.981531e-001, 2.981610e-001, 2.981690e-001, 2.981770e-001, 2.981849e-001, 2.981929e-001, 2.982008e-001, 2.982088e-001, 2.982167e-001, 2.982246e-001, 2.982326e-001, 2.982405e-001, 2.982485e-001, 2.982564e-001, 2.982644e-001, 2.982723e-001, 2.982803e-001, 2.982882e-001, 2.982962e-001, 2.983041e-001, 2.983120e-001, 2.983200e-001, 2.983279e-001, 2.983359e-001, 2.983438e-001, 2.983517e-001, 2.983597e-001, 2.983676e-001, 2.983756e-001, 2.983835e-001, 2.983914e-001, 2.983994e-001, 2.984073e-001, 2.984152e-001, 2.984232e-001, 2.984311e-001, 2.984390e-001, 2.984470e-001, 2.984549e-001, 2.984628e-001, 2.984707e-001, 2.984787e-001, 2.984866e-001, 2.984945e-001, 2.985025e-001, 2.985104e-001, 2.985183e-001, 2.985262e-001, 2.985342e-001, 2.985421e-001, 2.985500e-001, 2.985579e-001, 2.985659e-001, 2.985738e-001, 2.985817e-001, 2.985896e-001, 2.985975e-001, 2.986055e-001, 2.986134e-001, 2.986213e-001, 2.986292e-001, 2.986371e-001, 2.986451e-001, 2.986530e-001, 2.986609e-001, 2.986688e-001, 2.986767e-001, 2.986846e-001, 2.986925e-001, 2.987004e-001, 2.987084e-001, 2.987163e-001, 2.987242e-001, 2.987321e-001, 2.987400e-001, 2.987479e-001, 2.987558e-001, 2.987637e-001, 2.987716e-001, 2.987795e-001, 2.987874e-001, 2.987954e-001, 2.988033e-001, 2.988112e-001, 2.988191e-001, 2.988270e-001, 2.988349e-001, 2.988428e-001, 2.988507e-001, 2.988586e-001, 2.988665e-001, 2.988744e-001, 2.988823e-001, 
2.988902e-001, 2.988981e-001, 2.989060e-001, 2.989139e-001, 2.989218e-001, 2.989296e-001, 2.989375e-001, 2.989454e-001, 2.989533e-001, 2.989612e-001, 2.989691e-001, 2.989770e-001, 2.989849e-001, 2.989928e-001, 2.990007e-001, 2.990086e-001, 2.990165e-001, 2.990243e-001, 2.990322e-001, 2.990401e-001, 2.990480e-001, 2.990559e-001, 2.990638e-001, 2.990717e-001, 2.990795e-001, 2.990874e-001, 2.990953e-001, 2.991032e-001, 2.991111e-001, 2.991189e-001, 2.991268e-001, 2.991347e-001, 2.991426e-001, 2.991505e-001, 2.991583e-001, 2.991662e-001, 2.991741e-001, 2.991820e-001, 2.991898e-001, 2.991977e-001, 2.992056e-001, 2.992135e-001, 2.992213e-001, 2.992292e-001, 2.992371e-001, 2.992450e-001, 2.992528e-001, 2.992607e-001, 2.992686e-001, 2.992764e-001, 2.992843e-001, 2.992922e-001, 2.993000e-001, 2.993079e-001, 2.993158e-001, 2.993236e-001, 2.993315e-001, 2.993394e-001, 2.993472e-001, 2.993551e-001, 2.993629e-001, 2.993708e-001, 2.993787e-001, 2.993865e-001, 2.993944e-001, 2.994022e-001, 2.994101e-001, 2.994180e-001, 2.994258e-001, 2.994337e-001, 2.994415e-001, 2.994494e-001, 2.994572e-001, 2.994651e-001, 2.994730e-001, 2.994808e-001, 2.994887e-001, 2.994965e-001, 2.995044e-001, 2.995122e-001, 2.995201e-001, 2.995279e-001, 2.995358e-001, 2.995436e-001, 2.995515e-001, 2.995593e-001, 2.995671e-001, 2.995750e-001, 2.995828e-001, 2.995907e-001, 2.995985e-001, 2.996064e-001, 2.996142e-001, 2.996221e-001, 2.996299e-001, 2.996377e-001, 2.996456e-001, 2.996534e-001, 2.996613e-001, 2.996691e-001, 
2.996769e-001, 2.996848e-001, 2.996926e-001, 2.997004e-001, 2.997083e-001, 2.997161e-001, 2.997240e-001, 2.997318e-001, 2.997396e-001, 2.997475e-001, 2.997553e-001, 2.997631e-001, 2.997710e-001, 2.997788e-001, 2.997866e-001, 2.997944e-001, 2.998023e-001, 2.998101e-001, 2.998179e-001, 2.998258e-001, 2.998336e-001, 2.998414e-001, 2.998492e-001, 2.998571e-001, 2.998649e-001, 2.998727e-001, 2.998805e-001, 2.998883e-001, 2.998962e-001, 2.999040e-001, 2.999118e-001, 2.999196e-001, 2.999274e-001, 2.999353e-001, 2.999431e-001, 2.999509e-001, 2.999587e-001, 2.999665e-001, 2.999743e-001, 2.999822e-001, 2.999900e-001, 2.999978e-001, 3.000056e-001, 3.000134e-001, 3.000212e-001, 3.000290e-001, 3.000369e-001, 3.000447e-001, 3.000525e-001, 3.000603e-001, 3.000681e-001, 3.000759e-001, 3.000837e-001, 3.000915e-001, 3.000993e-001, 3.001071e-001, 3.001149e-001, 3.001227e-001, 3.001305e-001, 3.001383e-001, 3.001461e-001, 3.001539e-001, 3.001617e-001, 3.001695e-001, 3.001773e-001, 3.001851e-001, 3.001929e-001, 3.002007e-001, 3.002085e-001, 3.002163e-001, 3.002241e-001, 3.002319e-001, 3.002397e-001, 3.002475e-001, 3.002553e-001, 3.002631e-001, 3.002709e-001, 3.002787e-001, 3.002865e-001, 3.002943e-001, 3.003021e-001, 3.003099e-001, 3.003176e-001, 3.003254e-001, 3.003332e-001, 3.003410e-001, 3.003488e-001, 3.003566e-001, 3.003644e-001, 3.003722e-001, 3.003799e-001, 3.003877e-001, 3.003955e-001, 3.004033e-001, 3.004111e-001, 3.004189e-001, 3.004266e-001, 3.004344e-001, 3.004422e-001, 3.004500e-001, 
3.004578e-001, 3.004655e-001, 3.004733e-001, 3.004811e-001, 3.004889e-001, 3.004966e-001, 3.005044e-001, 3.005122e-001, 3.005200e-001, 3.005277e-001, 3.005355e-001, 3.005433e-001, 3.005511e-001, 3.005588e-001, 3.005666e-001, 3.005744e-001, 3.005821e-001, 3.005899e-001, 3.005977e-001, 3.006054e-001, 3.006132e-001, 3.006210e-001, 3.006287e-001, 3.006365e-001, 3.006443e-001, 3.006520e-001, 3.006598e-001, 3.006676e-001, 3.006753e-001, 3.006831e-001, 3.006909e-001, 3.006986e-001, 3.007064e-001, 3.007141e-001, 3.007219e-001, 3.007296e-001, 3.007374e-001, 3.007452e-001, 3.007529e-001, 3.007607e-001, 3.007684e-001, 3.007762e-001, 3.007839e-001, 3.007917e-001, 3.007994e-001, 3.008072e-001, 3.008149e-001, 3.008227e-001, 3.008304e-001, 3.008382e-001, 3.008459e-001, 3.008537e-001, 3.008614e-001, 3.008692e-001, 3.008769e-001, 3.008847e-001, 3.008924e-001, 3.009002e-001, 3.009079e-001, 3.009157e-001, 3.009234e-001, 3.009312e-001, 3.009389e-001, 3.009466e-001, 3.009544e-001, 3.009621e-001, 3.009699e-001, 3.009776e-001, 3.009853e-001, 3.009931e-001, 3.010008e-001, 3.010085e-001, 3.010163e-001, 3.010240e-001, 3.010318e-001, 3.010395e-001, 3.010472e-001, 3.010550e-001, 3.010627e-001, 3.010704e-001, 3.010782e-001, 3.010859e-001, 3.010936e-001, 3.011013e-001, 3.011091e-001, 3.011168e-001, 3.011245e-001, 3.011323e-001, 3.011400e-001, 3.011477e-001, 3.011554e-001, 3.011632e-001, 3.011709e-001, 3.011786e-001, 3.011863e-001, 3.011941e-001, 3.012018e-001, 3.012095e-001, 3.012172e-001, 3.012249e-001, 
3.012327e-001, 3.012404e-001, 3.012481e-001, 3.012558e-001, 3.012635e-001, 3.012713e-001, 3.012790e-001, 3.012867e-001, 3.012944e-001, 3.013021e-001, 3.013098e-001, 3.013175e-001, 3.013253e-001, 3.013330e-001, 3.013407e-001, 3.013484e-001, 3.013561e-001, 3.013638e-001, 3.013715e-001, 3.013792e-001, 3.013869e-001, 3.013946e-001, 3.014024e-001, 3.014101e-001, 3.014178e-001, 3.014255e-001, 3.014332e-001, 3.014409e-001, 3.014486e-001, 3.014563e-001, 3.014640e-001, 3.014717e-001, 3.014794e-001, 3.014871e-001, 3.014948e-001, 3.015025e-001, 3.015102e-001, 3.015179e-001, 3.015256e-001, 3.015333e-001, 3.015410e-001, 3.015487e-001, 3.015564e-001, 3.015641e-001, 3.015718e-001, 3.015794e-001, 3.015871e-001, 3.015948e-001, 3.016025e-001, 3.016102e-001, 3.016179e-001, 3.016256e-001, 3.016333e-001, 3.016410e-001, 3.016487e-001, 3.016564e-001, 3.016640e-001, 3.016717e-001, 3.016794e-001, 3.016871e-001, 3.016948e-001, 3.017025e-001, 3.017101e-001, 3.017178e-001, 3.017255e-001, 3.017332e-001, 3.017409e-001, 3.017486e-001, 3.017562e-001, 3.017639e-001, 3.017716e-001, 3.017793e-001, 3.017869e-001, 3.017946e-001, 3.018023e-001, 3.018100e-001, 3.018177e-001, 3.018253e-001, 3.018330e-001, 3.018407e-001, 3.018483e-001, 3.018560e-001, 3.018637e-001, 3.018714e-001, 3.018790e-001, 3.018867e-001, 3.018944e-001, 3.019020e-001, 3.019097e-001, 3.019174e-001, 3.019250e-001, 3.019327e-001, 3.019404e-001, 3.019480e-001, 3.019557e-001, 3.019634e-001, 3.019710e-001, 3.019787e-001, 3.019864e-001, 3.019940e-001, 
3.020017e-001, 3.020093e-001, 3.020170e-001, 3.020247e-001, 3.020323e-001, 3.020400e-001, 3.020476e-001, 3.020553e-001, 3.020630e-001, 3.020706e-001, 3.020783e-001, 3.020859e-001, 3.020936e-001, 3.021012e-001, 3.021089e-001, 3.021165e-001, 3.021242e-001, 3.021318e-001, 3.021395e-001, 3.021471e-001, 3.021548e-001, 3.021624e-001, 3.021701e-001, 3.021777e-001, 3.021854e-001, 3.021930e-001, 3.022007e-001, 3.022083e-001, 3.022160e-001, 3.022236e-001, 3.022312e-001, 3.022389e-001, 3.022465e-001, 3.022542e-001, 3.022618e-001, 3.022695e-001, 3.022771e-001, 3.022847e-001, 3.022924e-001, 3.023000e-001, 3.023077e-001, 3.023153e-001, 3.023229e-001, 3.023306e-001, 3.023382e-001, 3.023458e-001, 3.023535e-001, 3.023611e-001, 3.023687e-001, 3.023764e-001, 3.023840e-001, 3.023916e-001, 3.023993e-001, 3.024069e-001, 3.024145e-001, 3.024222e-001, 3.024298e-001, 3.024374e-001, 3.024450e-001, 3.024527e-001, 3.024603e-001, 3.024679e-001, 3.024755e-001, 3.024832e-001, 3.024908e-001, 3.024984e-001, 3.025060e-001, 3.025137e-001, 3.025213e-001, 3.025289e-001, 3.025365e-001, 3.025441e-001, 3.025518e-001, 3.025594e-001, 3.025670e-001, 3.025746e-001, 3.025822e-001, 3.025898e-001, 3.025975e-001, 3.026051e-001, 3.026127e-001, 3.026203e-001, 3.026279e-001, 3.026355e-001, 3.026431e-001, 3.026508e-001, 3.026584e-001, 3.026660e-001, 3.026736e-001, 3.026812e-001, 3.026888e-001, 3.026964e-001, 3.027040e-001, 3.027116e-001, 3.027192e-001, 3.027268e-001, 3.027344e-001, 3.027420e-001, 3.027497e-001, 3.027573e-001, 
3.027649e-001, 3.027725e-001, 3.027801e-001, 3.027877e-001, 3.027953e-001, 3.028029e-001, 3.028105e-001, 3.028181e-001, 3.028257e-001, 3.028333e-001, 3.028409e-001, 3.028485e-001, 3.028560e-001, 3.028636e-001, 3.028712e-001, 3.028788e-001, 3.028864e-001, 3.028940e-001, 3.029016e-001, 3.029092e-001, 3.029168e-001, 3.029244e-001, 3.029320e-001, 3.029396e-001, 3.029472e-001, 3.029547e-001, 3.029623e-001, 3.029699e-001, 3.029775e-001, 3.029851e-001, 3.029927e-001, 3.030003e-001, 3.030078e-001, 3.030154e-001, 3.030230e-001, 3.030306e-001, 3.030382e-001, 3.030458e-001, 3.030533e-001, 3.030609e-001, 3.030685e-001, 3.030761e-001, 3.030837e-001, 3.030912e-001, 3.030988e-001, 3.031064e-001, 3.031140e-001, 3.031215e-001, 3.031291e-001, 3.031367e-001, 3.031443e-001, 3.031518e-001, 3.031594e-001, 3.031670e-001, 3.031746e-001, 3.031821e-001, 3.031897e-001, 3.031973e-001, 3.032048e-001, 3.032124e-001, 3.032200e-001, 3.032275e-001, 3.032351e-001, 3.032427e-001, 3.032502e-001, 3.032578e-001, 3.032654e-001, 3.032729e-001, 3.032805e-001, 3.032881e-001, 3.032956e-001, 3.033032e-001, 3.033107e-001, 3.033183e-001, 3.033259e-001, 3.033334e-001, 3.033410e-001, 3.033485e-001, 3.033561e-001, 3.033637e-001, 3.033712e-001, 3.033788e-001, 3.033863e-001, 3.033939e-001, 3.034014e-001, 3.034090e-001, 3.034165e-001, 3.034241e-001, 3.034316e-001, 3.034392e-001, 3.034467e-001, 3.034543e-001, 3.034618e-001, 3.034694e-001, 3.034769e-001, 3.034845e-001, 3.034920e-001, 3.034996e-001, 3.035071e-001, 3.035147e-001, 
3.035222e-001, 3.035298e-001, 3.035373e-001, 3.035448e-001, 3.035524e-001, 3.035599e-001, 3.035675e-001, 3.035750e-001, 3.035826e-001, 3.035901e-001, 3.035976e-001, 3.036052e-001, 3.036127e-001, 3.036202e-001, 3.036278e-001, 3.036353e-001, 3.036429e-001, 3.036504e-001, 3.036579e-001, 3.036655e-001, 3.036730e-001, 3.036805e-001, 3.036881e-001, 3.036956e-001, 3.037031e-001, 3.037107e-001, 3.037182e-001, 3.037257e-001, 3.037332e-001, 3.037408e-001, 3.037483e-001, 3.037558e-001, 3.037634e-001, 3.037709e-001, 3.037784e-001, 3.037859e-001, 3.037935e-001, 3.038010e-001, 3.038085e-001, 3.038160e-001, 3.038235e-001, 3.038311e-001, 3.038386e-001, 3.038461e-001, 3.038536e-001, 3.038611e-001, 3.038687e-001, 3.038762e-001, 3.038837e-001, 3.038912e-001, 3.038987e-001, 3.039062e-001, 3.039138e-001, 3.039213e-001, 3.039288e-001, 3.039363e-001, 3.039438e-001, 3.039513e-001, 3.039588e-001, 3.039663e-001, 3.039739e-001, 3.039814e-001, 3.039889e-001, 3.039964e-001, 3.040039e-001, 3.040114e-001, 3.040189e-001, 3.040264e-001, 3.040339e-001, 3.040414e-001, 3.040489e-001, 3.040564e-001, 3.040639e-001, 3.040714e-001, 3.040789e-001, 3.040864e-001, 3.040939e-001, 3.041014e-001, 3.041089e-001, 3.041164e-001, 3.041239e-001, 3.041314e-001, 3.041389e-001, 3.041464e-001, 3.041539e-001, 3.041614e-001, 3.041689e-001, 3.041764e-001, 3.041839e-001, 3.041914e-001, 3.041989e-001, 3.042064e-001, 3.042139e-001, 3.042214e-001, 3.042289e-001, 3.042364e-001, 3.042438e-001, 3.042513e-001, 3.042588e-001, 3.042663e-001, 
3.042738e-001, 3.042813e-001, 3.042888e-001, 3.042963e-001, 3.043037e-001, 3.043112e-001, 3.043187e-001, 3.043262e-001, 3.043337e-001, 3.043412e-001, 3.043486e-001, 3.043561e-001, 3.043636e-001, 3.043711e-001, 3.043786e-001, 3.043860e-001, 3.043935e-001, 3.044010e-001, 3.044085e-001, 3.044159e-001, 3.044234e-001, 3.044309e-001, 3.044384e-001, 3.044458e-001, 3.044533e-001, 3.044608e-001, 3.044683e-001, 3.044757e-001, 3.044832e-001, 3.044907e-001, 3.044981e-001, 3.045056e-001, 3.045131e-001, 3.045206e-001, 3.045280e-001, 3.045355e-001, 3.045430e-001, 3.045504e-001, 3.045579e-001, 3.045654e-001, 3.045728e-001, 3.045803e-001, 3.045877e-001, 3.045952e-001, 3.046027e-001, 3.046101e-001, 3.046176e-001, 3.046251e-001, 3.046325e-001, 3.046400e-001, 3.046474e-001, 3.046549e-001, 3.046623e-001, 3.046698e-001, 3.046773e-001, 3.046847e-001, 3.046922e-001, 3.046996e-001, 3.047071e-001, 3.047145e-001, 3.047220e-001, 3.047294e-001, 3.047369e-001, 3.047443e-001, 3.047518e-001, 3.047592e-001, 3.047667e-001, 3.047741e-001, 3.047816e-001, 3.047890e-001, 3.047965e-001, 3.048039e-001, 3.048114e-001, 3.048188e-001, 3.048263e-001, 3.048337e-001, 3.048412e-001, 3.048486e-001, 3.048560e-001, 3.048635e-001, 3.048709e-001, 3.048784e-001, 3.048858e-001, 3.048932e-001, 3.049007e-001, 3.049081e-001, 3.049156e-001, 3.049230e-001, 3.049304e-001, 3.049379e-001, 3.049453e-001, 3.049527e-001, 3.049602e-001, 3.049676e-001, 3.049750e-001, 3.049825e-001, 3.049899e-001, 3.049973e-001, 3.050048e-001, 3.050122e-001, 
3.050196e-001, 3.050271e-001, 3.050345e-001, 3.050419e-001, 3.050493e-001, 3.050568e-001, 3.050642e-001, 3.050716e-001, 3.050790e-001, 3.050865e-001, 3.050939e-001, 3.051013e-001, 3.051087e-001, 3.051162e-001, 3.051236e-001, 3.051310e-001, 3.051384e-001, 3.051459e-001, 3.051533e-001, 3.051607e-001, 3.051681e-001, 3.051755e-001, 3.051829e-001, 3.051904e-001, 3.051978e-001, 3.052052e-001, 3.052126e-001, 3.052200e-001, 3.052274e-001, 3.052348e-001, 3.052423e-001, 3.052497e-001, 3.052571e-001, 3.052645e-001, 3.052719e-001, 3.052793e-001, 3.052867e-001, 3.052941e-001, 3.053015e-001, 3.053090e-001, 3.053164e-001, 3.053238e-001, 3.053312e-001, 3.053386e-001, 3.053460e-001, 3.053534e-001, 3.053608e-001, 3.053682e-001, 3.053756e-001, 3.053830e-001, 3.053904e-001, 3.053978e-001, 3.054052e-001, 3.054126e-001, 3.054200e-001, 3.054274e-001, 3.054348e-001, 3.054422e-001, 3.054496e-001, 3.054570e-001, 3.054644e-001, 3.054718e-001, 3.054792e-001, 3.054866e-001, 3.054940e-001, 3.055014e-001, 3.055087e-001, 3.055161e-001, 3.055235e-001, 3.055309e-001, 3.055383e-001, 3.055457e-001, 3.055531e-001, 3.055605e-001, 3.055679e-001, 3.055753e-001, 3.055826e-001, 3.055900e-001, 3.055974e-001, 3.056048e-001, 3.056122e-001, 3.056196e-001, 3.056269e-001, 3.056343e-001, 3.056417e-001, 3.056491e-001, 3.056565e-001, 3.056639e-001, 3.056712e-001, 3.056786e-001, 3.056860e-001, 3.056934e-001, 3.057007e-001, 3.057081e-001, 3.057155e-001, 3.057229e-001, 3.057303e-001, 3.057376e-001, 3.057450e-001, 3.057524e-001, 
3.057597e-001, 3.057671e-001, 3.057745e-001, 3.057819e-001, 3.057892e-001, 3.057966e-001, 3.058040e-001, 3.058113e-001, 3.058187e-001, 3.058261e-001, 3.058334e-001, 3.058408e-001, 3.058482e-001, 3.058555e-001, 3.058629e-001, 3.058703e-001, 3.058776e-001, 3.058850e-001, 3.058924e-001, 3.058997e-001, 3.059071e-001, 3.059144e-001, 3.059218e-001, 3.059292e-001, 3.059365e-001, 3.059439e-001, 3.059512e-001, 3.059586e-001, 3.059660e-001, 3.059733e-001, 3.059807e-001, 3.059880e-001, 3.059954e-001, 3.060027e-001, 3.060101e-001, 3.060174e-001, 3.060248e-001, 3.060321e-001, 3.060395e-001, 3.060468e-001, 3.060542e-001, 3.060616e-001, 3.060689e-001, 3.060762e-001, 3.060836e-001, 3.060909e-001, 3.060983e-001, 3.061056e-001, 3.061130e-001, 3.061203e-001, 3.061277e-001, 3.061350e-001, 3.061424e-001, 3.061497e-001, 3.061570e-001, 3.061644e-001, 3.061717e-001, 3.061791e-001, 3.061864e-001, 3.061937e-001, 3.062011e-001, 3.062084e-001, 3.062158e-001, 3.062231e-001, 3.062304e-001, 3.062378e-001, 3.062451e-001, 3.062524e-001, 3.062598e-001, 3.062671e-001, 3.062744e-001, 3.062818e-001, 3.062891e-001, 3.062964e-001, 3.063038e-001, 3.063111e-001, 3.063184e-001, 3.063258e-001, 3.063331e-001, 3.063404e-001, 3.063477e-001, 3.063551e-001, 3.063624e-001, 3.063697e-001, 3.063771e-001, 3.063844e-001, 3.063917e-001, 3.063990e-001, 3.064063e-001, 3.064137e-001, 3.064210e-001, 3.064283e-001, 3.064356e-001, 3.064430e-001, 3.064503e-001, 3.064576e-001, 3.064649e-001, 3.064722e-001, 3.064795e-001, 3.064869e-001, 
3.064942e-001, 3.065015e-001, 3.065088e-001, 3.065161e-001, 3.065234e-001, 3.065308e-001, 3.065381e-001, 3.065454e-001, 3.065527e-001, 3.065600e-001, 3.065673e-001, 3.065746e-001, 3.065819e-001, 3.065892e-001, 3.065966e-001, 3.066039e-001, 3.066112e-001, 3.066185e-001, 3.066258e-001, 3.066331e-001, 3.066404e-001, 3.066477e-001, 3.066550e-001, 3.066623e-001, 3.066696e-001, 3.066769e-001, 3.066842e-001, 3.066915e-001, 3.066988e-001, 3.067061e-001, 3.067134e-001, 3.067207e-001, 3.067280e-001, 3.067353e-001, 3.067426e-001, 3.067499e-001, 3.067572e-001, 3.067645e-001, 3.067718e-001, 3.067791e-001, 3.067864e-001, 3.067937e-001, 3.068010e-001, 3.068083e-001, 3.068155e-001, 3.068228e-001, 3.068301e-001, 3.068374e-001, 3.068447e-001, 3.068520e-001, 3.068593e-001, 3.068666e-001, 3.068739e-001, 3.068811e-001, 3.068884e-001, 3.068957e-001, 3.069030e-001, 3.069103e-001, 3.069176e-001, 3.069248e-001, 3.069321e-001, 3.069394e-001, 3.069467e-001, 3.069540e-001, 3.069613e-001, 3.069685e-001, 3.069758e-001, 3.069831e-001, 3.069904e-001, 3.069976e-001, 3.070049e-001, 3.070122e-001, 3.070195e-001, 3.070268e-001, 3.070340e-001, 3.070413e-001, 3.070486e-001, 3.070558e-001, 3.070631e-001, 3.070704e-001, 3.070777e-001, 3.070849e-001, 3.070922e-001, 3.070995e-001, 3.071067e-001, 3.071140e-001, 3.071213e-001, 3.071285e-001, 3.071358e-001, 3.071431e-001, 3.071503e-001, 3.071576e-001, 3.071649e-001, 3.071721e-001, 3.071794e-001, 3.071867e-001, 3.071939e-001, 3.072012e-001, 3.072084e-001, 3.072157e-001, 
3.072230e-001, 3.072302e-001, 3.072375e-001, 3.072447e-001, 3.072520e-001, 3.072593e-001, 3.072665e-001, 3.072738e-001, 3.072810e-001, 3.072883e-001, 3.072955e-001, 3.073028e-001, 3.073100e-001, 3.073173e-001, 3.073245e-001, 3.073318e-001, 3.073391e-001, 3.073463e-001, 3.073536e-001, 3.073608e-001, 3.073680e-001, 3.073753e-001, 3.073825e-001, 3.073898e-001, 3.073970e-001, 3.074043e-001, 3.074115e-001, 3.074188e-001, 3.074260e-001, 3.074333e-001, 3.074405e-001, 3.074477e-001, 3.074550e-001, 3.074622e-001, 3.074695e-001, 3.074767e-001, 3.074840e-001, 3.074912e-001, 3.074984e-001, 3.075057e-001, 3.075129e-001, 3.075201e-001, 3.075274e-001, 3.075346e-001, 3.075419e-001, 3.075491e-001, 3.075563e-001, 3.075636e-001, 3.075708e-001, 3.075780e-001, 3.075853e-001, 3.075925e-001, 3.075997e-001, 3.076069e-001, 3.076142e-001, 3.076214e-001, 3.076286e-001, 3.076359e-001, 3.076431e-001, 3.076503e-001, 3.076575e-001, 3.076648e-001, 3.076720e-001, 3.076792e-001, 3.076864e-001, 3.076937e-001, 3.077009e-001, 3.077081e-001, 3.077153e-001, 3.077226e-001, 3.077298e-001, 3.077370e-001, 3.077442e-001, 3.077514e-001, 3.077587e-001, 3.077659e-001, 3.077731e-001, 3.077803e-001, 3.077875e-001, 3.077947e-001, 3.078020e-001, 3.078092e-001, 3.078164e-001, 3.078236e-001, 3.078308e-001, 3.078380e-001, 3.078452e-001, 3.078524e-001, 3.078597e-001, 3.078669e-001, 3.078741e-001, 3.078813e-001, 3.078885e-001, 3.078957e-001, 3.079029e-001, 3.079101e-001, 3.079173e-001, 3.079245e-001, 3.079317e-001, 3.079389e-001, 
3.079461e-001, 3.079533e-001, 3.079605e-001, 3.079677e-001, 3.079749e-001, 3.079821e-001, 3.079893e-001, 3.079965e-001, 3.080037e-001, 3.080109e-001, 3.080181e-001, 3.080253e-001, 3.080325e-001, 3.080397e-001, 3.080469e-001, 3.080541e-001, 3.080613e-001, 3.080685e-001, 3.080757e-001, 3.080829e-001, 3.080901e-001, 3.080973e-001, 3.081045e-001, 3.081117e-001, 3.081189e-001, 3.081261e-001, 3.081332e-001, 3.081404e-001, 3.081476e-001, 3.081548e-001, 3.081620e-001, 3.081692e-001, 3.081764e-001, 3.081836e-001, 3.081907e-001, 3.081979e-001, 3.082051e-001, 3.082123e-001, 3.082195e-001, 3.082267e-001, 3.082338e-001, 3.082410e-001, 3.082482e-001, 3.082554e-001, 3.082626e-001, 3.082697e-001, 3.082769e-001, 3.082841e-001, 3.082913e-001, 3.082984e-001, 3.083056e-001, 3.083128e-001, 3.083200e-001, 3.083271e-001, 3.083343e-001, 3.083415e-001, 3.083487e-001, 3.083558e-001, 3.083630e-001, 3.083702e-001, 3.083774e-001, 3.083845e-001, 3.083917e-001, 3.083989e-001, 3.084060e-001, 3.084132e-001, 3.084204e-001, 3.084275e-001, 3.084347e-001, 3.084419e-001, 3.084490e-001, 3.084562e-001, 3.084634e-001, 3.084705e-001, 3.084777e-001, 3.084848e-001, 3.084920e-001, 3.084992e-001, 3.085063e-001, 3.085135e-001, 3.085206e-001, 3.085278e-001, 3.085350e-001, 3.085421e-001, 3.085493e-001, 3.085564e-001, 3.085636e-001, 3.085707e-001, 3.085779e-001, 3.085851e-001, 3.085922e-001, 3.085994e-001, 3.086065e-001, 3.086137e-001, 3.086208e-001, 3.086280e-001, 3.086351e-001, 3.086423e-001, 3.086494e-001, 3.086566e-001, 
3.086637e-001, 3.086709e-001, 3.086780e-001, 3.086852e-001, 3.086923e-001, 3.086995e-001, 3.087066e-001, 3.087137e-001, 3.087209e-001, 3.087280e-001, 3.087352e-001, 3.087423e-001, 3.087495e-001, 3.087566e-001, 3.087637e-001, 3.087709e-001, 3.087780e-001, 3.087852e-001, 3.087923e-001, 3.087994e-001, 3.088066e-001, 3.088137e-001, 3.088208e-001, 3.088280e-001, 3.088351e-001, 3.088422e-001, 3.088494e-001, 3.088565e-001, 3.088636e-001, 3.088708e-001, 3.088779e-001, 3.088850e-001, 3.088922e-001, 3.088993e-001, 3.089064e-001, 3.089136e-001, 3.089207e-001, 3.089278e-001, 3.089349e-001, 3.089421e-001, 3.089492e-001, 3.089563e-001, 3.089634e-001, 3.089706e-001, 3.089777e-001, 3.089848e-001, 3.089919e-001, 3.089991e-001, 3.090062e-001, 3.090133e-001, 3.090204e-001, 3.090275e-001, 3.090347e-001, 3.090418e-001, 3.090489e-001, 3.090560e-001, 3.090631e-001, 3.090703e-001, 3.090774e-001, 3.090845e-001, 3.090916e-001, 3.090987e-001, 3.091058e-001, 3.091129e-001, 3.091201e-001, 3.091272e-001, 3.091343e-001, 3.091414e-001, 3.091485e-001, 3.091556e-001, 3.091627e-001, 3.091698e-001, 3.091769e-001, 3.091840e-001, 3.091911e-001, 3.091983e-001, 3.092054e-001, 3.092125e-001, 3.092196e-001, 3.092267e-001, 3.092338e-001, 3.092409e-001, 3.092480e-001, 3.092551e-001, 3.092622e-001, 3.092693e-001, 3.092764e-001, 3.092835e-001, 3.092906e-001, 3.092977e-001, 3.093048e-001, 3.093119e-001, 3.093190e-001, 3.093261e-001, 3.093332e-001, 3.093403e-001, 3.093474e-001, 3.093545e-001, 3.093616e-001, 3.093686e-001, 
3.093757e-001, 3.093828e-001, 3.093899e-001, 3.093970e-001, 3.094041e-001, 3.094112e-001, 3.094183e-001, 3.094254e-001, 3.094325e-001, 3.094396e-001, 3.094466e-001, 3.094537e-001, 3.094608e-001, 3.094679e-001, 3.094750e-001, 3.094821e-001, 3.094892e-001, 3.094962e-001, 3.095033e-001, 3.095104e-001, 3.095175e-001, 3.095246e-001, 3.095316e-001, 3.095387e-001, 3.095458e-001, 3.095529e-001, 3.095600e-001, 3.095670e-001, 3.095741e-001, 3.095812e-001, 3.095883e-001, 3.095953e-001, 3.096024e-001, 3.096095e-001, 3.096166e-001, 3.096236e-001, 3.096307e-001, 3.096378e-001, 3.096449e-001, 3.096519e-001, 3.096590e-001, 3.096661e-001, 3.096731e-001, 3.096802e-001, 3.096873e-001, 3.096944e-001, 3.097014e-001, 3.097085e-001, 3.097156e-001, 3.097226e-001, 3.097297e-001, 3.097367e-001, 3.097438e-001, 3.097509e-001, 3.097579e-001, 3.097650e-001, 3.097721e-001, 3.097791e-001, 3.097862e-001, 3.097932e-001, 3.098003e-001, 3.098074e-001, 3.098144e-001, 3.098215e-001, 3.098285e-001, 3.098356e-001, 3.098427e-001, 3.098497e-001, 3.098568e-001, 3.098638e-001, 3.098709e-001, 3.098779e-001, 3.098850e-001, 3.098920e-001, 3.098991e-001, 3.099061e-001, 3.099132e-001, 3.099202e-001, 3.099273e-001, 3.099343e-001, 3.099414e-001, 3.099484e-001, 3.099555e-001, 3.099625e-001, 3.099696e-001, 3.099766e-001, 3.099837e-001, 3.099907e-001, 3.099978e-001, 3.100048e-001, 3.100118e-001, 3.100189e-001, 3.100259e-001, 3.100330e-001, 3.100400e-001, 3.100470e-001, 3.100541e-001, 3.100611e-001, 3.100682e-001, 3.100752e-001, 
3.100822e-001, 3.100893e-001, 3.100963e-001, 3.101034e-001, 3.101104e-001, 3.101174e-001, 3.101245e-001, 3.101315e-001, 3.101385e-001, 3.101456e-001, 3.101526e-001, 3.101596e-001, 3.101667e-001, 3.101737e-001, 3.101807e-001, 3.101877e-001, 3.101948e-001, 3.102018e-001, 3.102088e-001, 3.102159e-001, 3.102229e-001, 3.102299e-001, 3.102369e-001, 3.102440e-001, 3.102510e-001, 3.102580e-001, 3.102650e-001, 3.102721e-001, 3.102791e-001, 3.102861e-001, 3.102931e-001, 3.103001e-001, 3.103072e-001, 3.103142e-001, 3.103212e-001, 3.103282e-001, 3.103352e-001, 3.103423e-001, 3.103493e-001, 3.103563e-001, 3.103633e-001, 3.103703e-001, 3.103773e-001, 3.103843e-001, 3.103914e-001, 3.103984e-001, 3.104054e-001, 3.104124e-001, 3.104194e-001, 3.104264e-001, 3.104334e-001, 3.104404e-001, 3.104475e-001, 3.104545e-001, 3.104615e-001, 3.104685e-001, 3.104755e-001, 3.104825e-001, 3.104895e-001, 3.104965e-001, 3.105035e-001, 3.105105e-001, 3.105175e-001, 3.105245e-001, 3.105315e-001, 3.105385e-001, 3.105455e-001, 3.105525e-001, 3.105595e-001, 3.105665e-001, 3.105735e-001, 3.105805e-001, 3.105875e-001, 3.105945e-001, 3.106015e-001, 3.106085e-001, 3.106155e-001, 3.106225e-001, 3.106295e-001, 3.106365e-001, 3.106435e-001, 3.106505e-001, 3.106575e-001, 3.106645e-001, 3.106715e-001, 3.106784e-001, 3.106854e-001, 3.106924e-001, 3.106994e-001, 3.107064e-001, 3.107134e-001, 3.107204e-001, 3.107274e-001, 3.107344e-001, 3.107413e-001, 3.107483e-001, 3.107553e-001, 3.107623e-001, 3.107693e-001, 3.107763e-001, 
3.107833e-001, 3.107902e-001, 3.107972e-001, 3.108042e-001, 3.108112e-001, 3.108182e-001, 3.108251e-001, 3.108321e-001, 3.108391e-001, 3.108461e-001, 3.108530e-001, 3.108600e-001, 3.108670e-001, 3.108740e-001, 3.108810e-001, 3.108879e-001, 3.108949e-001, 3.109019e-001, 3.109089e-001, 3.109158e-001, 3.109228e-001, 3.109298e-001, 3.109367e-001, 3.109437e-001, 3.109507e-001, 3.109576e-001, 3.109646e-001, 3.109716e-001, 3.109786e-001, 3.109855e-001, 3.109925e-001, 3.109995e-001, 3.110064e-001, 3.110134e-001, 3.110203e-001, 3.110273e-001, 3.110343e-001, 3.110412e-001, 3.110482e-001, 3.110552e-001, 3.110621e-001, 3.110691e-001, 3.110760e-001, 3.110830e-001, 3.110900e-001, 3.110969e-001, 3.111039e-001, 3.111108e-001, 3.111178e-001, 3.111247e-001, 3.111317e-001, 3.111387e-001, 3.111456e-001, 3.111526e-001, 3.111595e-001, 3.111665e-001, 3.111734e-001, 3.111804e-001, 3.111873e-001, 3.111943e-001, 3.112012e-001, 3.112082e-001, 3.112151e-001, 3.112221e-001, 3.112290e-001, 3.112360e-001, 3.112429e-001, 3.112499e-001, 3.112568e-001, 3.112638e-001, 3.112707e-001, 3.112776e-001, 3.112846e-001, 3.112915e-001, 3.112985e-001, 3.113054e-001, 3.113124e-001, 3.113193e-001, 3.113262e-001, 3.113332e-001, 3.113401e-001, 3.113471e-001, 3.113540e-001, 3.113609e-001, 3.113679e-001, 3.113748e-001, 3.113817e-001, 3.113887e-001, 3.113956e-001, 3.114025e-001, 3.114095e-001, 3.114164e-001, 3.114233e-001, 3.114303e-001, 3.114372e-001, 3.114441e-001, 3.114511e-001, 3.114580e-001, 3.114649e-001, 3.114719e-001, 
3.114788e-001, 3.114857e-001, 3.114926e-001, 3.114996e-001, 3.115065e-001, 3.115134e-001, 3.115204e-001, 3.115273e-001, 3.115342e-001, 3.115411e-001, 3.115480e-001, 3.115550e-001, 3.115619e-001, 3.115688e-001, 3.115757e-001, 3.115827e-001, 3.115896e-001, 3.115965e-001, 3.116034e-001, 3.116103e-001, 3.116172e-001, 3.116242e-001, 3.116311e-001, 3.116380e-001, 3.116449e-001, 3.116518e-001, 3.116587e-001, 3.116657e-001, 3.116726e-001, 3.116795e-001, 3.116864e-001, 3.116933e-001, 3.117002e-001, 3.117071e-001, 3.117140e-001, 3.117209e-001, 3.117279e-001, 3.117348e-001, 3.117417e-001, 3.117486e-001, 3.117555e-001, 3.117624e-001, 3.117693e-001, 3.117762e-001, 3.117831e-001, 3.117900e-001, 3.117969e-001, 3.118038e-001, 3.118107e-001, 3.118176e-001, 3.118245e-001, 3.118314e-001, 3.118383e-001, 3.118452e-001, 3.118521e-001, 3.118590e-001, 3.118659e-001, 3.118728e-001, 3.118797e-001, 3.118866e-001, 3.118935e-001, 3.119004e-001, 3.119073e-001, 3.119142e-001, 3.119211e-001, 3.119280e-001, 3.119349e-001, 3.119418e-001, 3.119487e-001, 3.119555e-001, 3.119624e-001, 3.119693e-001, 3.119762e-001, 3.119831e-001, 3.119900e-001, 3.119969e-001, 3.120038e-001, 3.120107e-001, 3.120175e-001, 3.120244e-001, 3.120313e-001, 3.120382e-001, 3.120451e-001, 3.120520e-001, 3.120588e-001, 3.120657e-001, 3.120726e-001, 3.120795e-001, 3.120864e-001, 3.120933e-001, 3.121001e-001, 3.121070e-001, 3.121139e-001, 3.121208e-001, 3.121276e-001, 3.121345e-001, 3.121414e-001, 3.121483e-001, 3.121551e-001, 3.121620e-001, 
3.121689e-001, 3.121758e-001, 3.121826e-001, 3.121895e-001, 3.121964e-001, 3.122033e-001, 3.122101e-001, 3.122170e-001, 3.122239e-001, 3.122307e-001, 3.122376e-001, 3.122445e-001, 3.122513e-001, 3.122582e-001, 3.122651e-001, 3.122719e-001, 3.122788e-001, 3.122857e-001, 3.122925e-001, 3.122994e-001, 3.123063e-001, 3.123131e-001, 3.123200e-001, 3.123269e-001, 3.123337e-001, 3.123406e-001, 3.123474e-001, 3.123543e-001, 3.123612e-001, 3.123680e-001, 3.123749e-001, 3.123817e-001, 3.123886e-001, 3.123954e-001, 3.124023e-001, 3.124092e-001, 3.124160e-001, 3.124229e-001, 3.124297e-001, 3.124366e-001, 3.124434e-001, 3.124503e-001, 3.124571e-001, 3.124640e-001, 3.124708e-001, 3.124777e-001, 3.124845e-001, 3.124914e-001, 3.124982e-001, 3.125051e-001, 3.125119e-001, 3.125188e-001, 3.125256e-001, 3.125325e-001, 3.125393e-001, 3.125462e-001, 3.125530e-001, 3.125598e-001, 3.125667e-001, 3.125735e-001, 3.125804e-001, 3.125872e-001, 3.125940e-001, 3.126009e-001, 3.126077e-001, 3.126146e-001, 3.126214e-001, 3.126282e-001, 3.126351e-001, 3.126419e-001, 3.126488e-001, 3.126556e-001, 3.126624e-001, 3.126693e-001, 3.126761e-001, 3.126829e-001, 3.126898e-001, 3.126966e-001, 3.127034e-001, 3.127103e-001, 3.127171e-001, 3.127239e-001, 3.127308e-001, 3.127376e-001, 3.127444e-001, 3.127512e-001, 3.127581e-001, 3.127649e-001, 3.127717e-001, 3.127785e-001, 3.127854e-001, 3.127922e-001, 3.127990e-001, 3.128058e-001, 3.128127e-001, 3.128195e-001, 3.128263e-001, 3.128331e-001, 3.128400e-001, 3.128468e-001, 
3.128536e-001, 3.128604e-001, 3.128672e-001, 3.128741e-001, 3.128809e-001, 3.128877e-001, 3.128945e-001, 3.129013e-001, 3.129081e-001, 3.129150e-001, 3.129218e-001, 3.129286e-001, 3.129354e-001, 3.129422e-001, 3.129490e-001, 3.129558e-001, 3.129627e-001, 3.129695e-001, 3.129763e-001, 3.129831e-001, 3.129899e-001, 3.129967e-001, 3.130035e-001, 3.130103e-001, 3.130171e-001, 3.130239e-001, 3.130307e-001, 3.130375e-001, 3.130444e-001, 3.130512e-001, 3.130580e-001, 3.130648e-001, 3.130716e-001, 3.130784e-001, 3.130852e-001, 3.130920e-001, 3.130988e-001, 3.131056e-001, 3.131124e-001, 3.131192e-001, 3.131260e-001, 3.131328e-001, 3.131396e-001, 3.131464e-001, 3.131532e-001, 3.131600e-001, 3.131668e-001, 3.131736e-001, 3.131803e-001, 3.131871e-001, 3.131939e-001, 3.132007e-001, 3.132075e-001, 3.132143e-001, 3.132211e-001, 3.132279e-001, 3.132347e-001, 3.132415e-001, 3.132483e-001, 3.132551e-001, 3.132618e-001, 3.132686e-001, 3.132754e-001, 3.132822e-001, 3.132890e-001, 3.132958e-001, 3.133026e-001, 3.133093e-001, 3.133161e-001, 3.133229e-001, 3.133297e-001, 3.133365e-001, 3.133433e-001, 3.133500e-001, 3.133568e-001, 3.133636e-001, 3.133704e-001, 3.133772e-001, 3.133839e-001, 3.133907e-001, 3.133975e-001, 3.134043e-001, 3.134110e-001, 3.134178e-001, 3.134246e-001, 3.134314e-001, 3.134381e-001, 3.134449e-001, 3.134517e-001, 3.134585e-001, 3.134652e-001, 3.134720e-001, 3.134788e-001, 3.134855e-001, 3.134923e-001, 3.134991e-001, 3.135059e-001, 3.135126e-001, 3.135194e-001, 3.135262e-001, 
3.135329e-001, 3.135397e-001, 3.135465e-001, 3.135532e-001, 3.135600e-001, 3.135668e-001, 3.135735e-001, 3.135803e-001, 3.135870e-001, 3.135938e-001, 3.136006e-001, 3.136073e-001, 3.136141e-001, 3.136208e-001, 3.136276e-001, 3.136344e-001, 3.136411e-001, 3.136479e-001, 3.136546e-001, 3.136614e-001, 3.136681e-001, 3.136749e-001, 3.136817e-001, 3.136884e-001, 3.136952e-001, 3.137019e-001, 3.137087e-001, 3.137154e-001, 3.137222e-001, 3.137289e-001, 3.137357e-001, 3.137424e-001, 3.137492e-001, 3.137559e-001, 3.137627e-001, 3.137694e-001, 3.137762e-001, 3.137829e-001, 3.137897e-001, 3.137964e-001, 3.138032e-001, 3.138099e-001, 3.138166e-001, 3.138234e-001, 3.138301e-001, 3.138369e-001, 3.138436e-001, 3.138504e-001, 3.138571e-001, 3.138638e-001, 3.138706e-001, 3.138773e-001, 3.138841e-001, 3.138908e-001, 3.138975e-001, 3.139043e-001, 3.139110e-001, 3.139177e-001, 3.139245e-001, 3.139312e-001, 3.139380e-001, 3.139447e-001, 3.139514e-001, 3.139582e-001, 3.139649e-001, 3.139716e-001, 3.139783e-001, 3.139851e-001, 3.139918e-001, 3.139985e-001, 3.140053e-001, 3.140120e-001, 3.140187e-001, 3.140255e-001, 3.140322e-001, 3.140389e-001, 3.140456e-001, 3.140524e-001, 3.140591e-001, 3.140658e-001, 3.140725e-001, 3.140793e-001, 3.140860e-001, 3.140927e-001, 3.140994e-001, 3.141061e-001, 3.141129e-001, 3.141196e-001, 3.141263e-001, 3.141330e-001, 3.141397e-001, 3.141465e-001, 3.141532e-001, 3.141599e-001, 3.141666e-001, 3.141733e-001, 3.141800e-001, 3.141868e-001, 3.141935e-001, 3.142002e-001, 
3.142069e-001, 3.142136e-001, 3.142203e-001, 3.142270e-001, 3.142338e-001, 3.142405e-001, 3.142472e-001, 3.142539e-001, 3.142606e-001, 3.142673e-001, 3.142740e-001, 3.142807e-001, 3.142874e-001, 3.142941e-001, 3.143008e-001, 3.143075e-001, 3.143142e-001, 3.143209e-001, 3.143277e-001, 3.143344e-001, 3.143411e-001, 3.143478e-001, 3.143545e-001, 3.143612e-001, 3.143679e-001, 3.143746e-001, 3.143813e-001, 3.143880e-001, 3.143947e-001, 3.144014e-001, 3.144081e-001, 3.144148e-001, 3.144215e-001, 3.144281e-001, 3.144348e-001, 3.144415e-001, 3.144482e-001, 3.144549e-001, 3.144616e-001, 3.144683e-001, 3.144750e-001, 3.144817e-001, 3.144884e-001, 3.144951e-001, 3.145018e-001, 3.145085e-001, 3.145151e-001, 3.145218e-001, 3.145285e-001, 3.145352e-001, 3.145419e-001, 3.145486e-001, 3.145553e-001, 3.145620e-001, 3.145686e-001, 3.145753e-001, 3.145820e-001, 3.145887e-001, 3.145954e-001, 3.146021e-001, 3.146087e-001, 3.146154e-001, 3.146221e-001, 3.146288e-001, 3.146355e-001, 3.146421e-001, 3.146488e-001, 3.146555e-001, 3.146622e-001, 3.146688e-001, 3.146755e-001, 3.146822e-001, 3.146889e-001, 3.146955e-001, 3.147022e-001, 3.147089e-001, 3.147156e-001, 3.147222e-001, 3.147289e-001, 3.147356e-001, 3.147423e-001, 3.147489e-001, 3.147556e-001, 3.147623e-001, 3.147689e-001, 3.147756e-001, 3.147823e-001, 3.147889e-001, 3.147956e-001, 3.148023e-001, 3.148089e-001, 3.148156e-001, 3.148223e-001, 3.148289e-001, 3.148356e-001, 3.148423e-001, 3.148489e-001, 3.148556e-001, 3.148622e-001, 3.148689e-001, 
3.148756e-001, 3.148822e-001, 3.148889e-001, 3.148955e-001, 3.149022e-001, 3.149089e-001, 3.149155e-001, 3.149222e-001, 3.149288e-001, 3.149355e-001, 3.149421e-001, 3.149488e-001, 3.149554e-001, 3.149621e-001, 3.149688e-001, 3.149754e-001, 3.149821e-001, 3.149887e-001, 3.149954e-001, 3.150020e-001, 3.150087e-001, 3.150153e-001, 3.150220e-001, 3.150286e-001, 3.150353e-001, 3.150419e-001, 3.150485e-001, 3.150552e-001, 3.150618e-001, 3.150685e-001, 3.150751e-001, 3.150818e-001, 3.150884e-001, 3.150951e-001, 3.151017e-001, 3.151083e-001, 3.151150e-001, 3.151216e-001, 3.151283e-001, 3.151349e-001, 3.151415e-001, 3.151482e-001, 3.151548e-001, 3.151615e-001, 3.151681e-001, 3.151747e-001, 3.151814e-001, 3.151880e-001, 3.151946e-001, 3.152013e-001, 3.152079e-001, 3.152145e-001, 3.152212e-001, 3.152278e-001, 3.152344e-001, 3.152411e-001, 3.152477e-001, 3.152543e-001, 3.152610e-001, 3.152676e-001, 3.152742e-001, 3.152808e-001, 3.152875e-001, 3.152941e-001, 3.153007e-001, 3.153074e-001, 3.153140e-001, 3.153206e-001, 3.153272e-001, 3.153338e-001, 3.153405e-001, 3.153471e-001, 3.153537e-001, 3.153603e-001, 3.153670e-001, 3.153736e-001, 3.153802e-001, 3.153868e-001, 3.153934e-001, 3.154001e-001, 3.154067e-001, 3.154133e-001, 3.154199e-001, 3.154265e-001, 3.154331e-001, 3.154398e-001, 3.154464e-001, 3.154530e-001, 3.154596e-001, 3.154662e-001, 3.154728e-001, 3.154794e-001, 3.154861e-001, 3.154927e-001, 3.154993e-001, 3.155059e-001, 3.155125e-001, 3.155191e-001, 3.155257e-001, 3.155323e-001, 
3.155389e-001, 3.155455e-001, 3.155521e-001, 3.155587e-001, 3.155654e-001, 3.155720e-001, 3.155786e-001, 3.155852e-001, 3.155918e-001, 3.155984e-001, 3.156050e-001, 3.156116e-001, 3.156182e-001, 3.156248e-001, 3.156314e-001, 3.156380e-001, 3.156446e-001, 3.156512e-001, 3.156578e-001, 3.156644e-001, 3.156710e-001, 3.156776e-001, 3.156842e-001, 3.156908e-001, 3.156974e-001, 3.157039e-001, 3.157105e-001, 3.157171e-001, 3.157237e-001, 3.157303e-001, 3.157369e-001, 3.157435e-001, 3.157501e-001, 3.157567e-001, 3.157633e-001, 3.157699e-001, 3.157765e-001, 3.157830e-001, 3.157896e-001, 3.157962e-001, 3.158028e-001, 3.158094e-001, 3.158160e-001, 3.158226e-001, 3.158291e-001, 3.158357e-001, 3.158423e-001, 3.158489e-001, 3.158555e-001, 3.158621e-001, 3.158686e-001, 3.158752e-001, 3.158818e-001, 3.158884e-001, 3.158950e-001, 3.159015e-001, 3.159081e-001, 3.159147e-001, 3.159213e-001, 3.159278e-001, 3.159344e-001, 3.159410e-001, 3.159476e-001, 3.159541e-001, 3.159607e-001, 3.159673e-001, 3.159739e-001, 3.159804e-001, 3.159870e-001, 3.159936e-001, 3.160002e-001, 3.160067e-001, 3.160133e-001, 3.160199e-001, 3.160264e-001, 3.160330e-001, 3.160396e-001, 3.160461e-001, 3.160527e-001, 3.160593e-001, 3.160658e-001, 3.160724e-001, 3.160790e-001, 3.160855e-001, 3.160921e-001, 3.160987e-001, 3.161052e-001, 3.161118e-001, 3.161183e-001, 3.161249e-001, 3.161315e-001, 3.161380e-001, 3.161446e-001, 3.161511e-001, 3.161577e-001, 3.161643e-001, 3.161708e-001, 3.161774e-001, 3.161839e-001, 3.161905e-001, 
3.161970e-001, 3.162036e-001, 3.162101e-001, 3.162167e-001, 3.162232e-001, 3.162298e-001, 3.162364e-001, 3.162429e-001, 3.162495e-001, 3.162560e-001, 3.162626e-001, 3.162691e-001, 3.162757e-001, 3.162822e-001, 3.162887e-001, 3.162953e-001, 3.163018e-001, 3.163084e-001, 3.163149e-001, 3.163215e-001, 3.163280e-001, 3.163346e-001, 3.163411e-001, 3.163477e-001, 3.163542e-001, 3.163607e-001, 3.163673e-001, 3.163738e-001, 3.163804e-001, 3.163869e-001, 3.163934e-001, 3.164000e-001, 3.164065e-001, 3.164131e-001, 3.164196e-001, 3.164261e-001, 3.164327e-001, 3.164392e-001, 3.164457e-001, 3.164523e-001, 3.164588e-001, 3.164653e-001, 3.164719e-001, 3.164784e-001, 3.164849e-001, 3.164915e-001, 3.164980e-001, 3.165045e-001, 3.165111e-001, 3.165176e-001, 3.165241e-001, 3.165306e-001, 3.165372e-001, 3.165437e-001, 3.165502e-001, 3.165568e-001, 3.165633e-001, 3.165698e-001, 3.165763e-001, 3.165829e-001, 3.165894e-001, 3.165959e-001, 3.166024e-001, 3.166089e-001, 3.166155e-001, 3.166220e-001, 3.166285e-001, 3.166350e-001, 3.166416e-001, 3.166481e-001, 3.166546e-001, 3.166611e-001, 3.166676e-001, 3.166741e-001, 3.166807e-001, 3.166872e-001, 3.166937e-001, 3.167002e-001, 3.167067e-001, 3.167132e-001, 3.167197e-001, 3.167263e-001, 3.167328e-001, 3.167393e-001, 3.167458e-001, 3.167523e-001, 3.167588e-001, 3.167653e-001, 3.167718e-001, 3.167783e-001, 3.167849e-001, 3.167914e-001, 3.167979e-001, 3.168044e-001, 3.168109e-001, 3.168174e-001, 3.168239e-001, 3.168304e-001, 3.168369e-001, 3.168434e-001, 
3.168499e-001, 3.168564e-001, 3.168629e-001, 3.168694e-001, 3.168759e-001, 3.168824e-001, 3.168889e-001, 3.168954e-001, 3.169019e-001, 3.169084e-001, 3.169149e-001, 3.169214e-001, 3.169279e-001, 3.169344e-001, 3.169409e-001, 3.169474e-001, 3.169539e-001, 3.169604e-001, 3.169669e-001, 3.169734e-001, 3.169798e-001, 3.169863e-001, 3.169928e-001, 3.169993e-001, 3.170058e-001, 3.170123e-001, 3.170188e-001, 3.170253e-001, 3.170318e-001, 3.170383e-001, 3.170447e-001, 3.170512e-001, 3.170577e-001, 3.170642e-001, 3.170707e-001, 3.170772e-001, 3.170837e-001, 3.170901e-001, 3.170966e-001, 3.171031e-001, 3.171096e-001, 3.171161e-001, 3.171226e-001, 3.171290e-001, 3.171355e-001, 3.171420e-001, 3.171485e-001, 3.171549e-001, 3.171614e-001, 3.171679e-001, 3.171744e-001, 3.171809e-001, 3.171873e-001, 3.171938e-001, 3.172003e-001, 3.172068e-001, 3.172132e-001, 3.172197e-001, 3.172262e-001, 3.172326e-001, 3.172391e-001, 3.172456e-001, 3.172521e-001, 3.172585e-001, 3.172650e-001, 3.172715e-001, 3.172779e-001, 3.172844e-001, 3.172909e-001, 3.172973e-001, 3.173038e-001, 3.173103e-001, 3.173167e-001, 3.173232e-001, 3.173297e-001, 3.173361e-001, 3.173426e-001, 3.173491e-001, 3.173555e-001, 3.173620e-001, 3.173684e-001, 3.173749e-001, 3.173814e-001, 3.173878e-001, 3.173943e-001, 3.174007e-001, 3.174072e-001, 3.174137e-001, 3.174201e-001, 3.174266e-001, 3.174330e-001, 3.174395e-001, 3.174459e-001, 3.174524e-001, 3.174588e-001, 3.174653e-001, 3.174718e-001, 3.174782e-001, 3.174847e-001, 3.174911e-001, 
3.174976e-001, 3.175040e-001, 3.175105e-001, 3.175169e-001, 3.175234e-001, 3.175298e-001, 3.175363e-001, 3.175427e-001, 3.175492e-001, 3.175556e-001, 3.175620e-001, 3.175685e-001, 3.175749e-001, 3.175814e-001, 3.175878e-001, 3.175943e-001, 3.176007e-001, 3.176071e-001, 3.176136e-001, 3.176200e-001, 3.176265e-001, 3.176329e-001, 3.176394e-001, 3.176458e-001, 3.176522e-001, 3.176587e-001, 3.176651e-001, 3.176715e-001, 3.176780e-001, 3.176844e-001, 3.176908e-001, 3.176973e-001, 3.177037e-001, 3.177102e-001, 3.177166e-001, 3.177230e-001, 3.177295e-001, 3.177359e-001, 3.177423e-001, 3.177487e-001, 3.177552e-001, 3.177616e-001, 3.177680e-001, 3.177745e-001, 3.177809e-001, 3.177873e-001, 3.177937e-001, 3.178002e-001, 3.178066e-001, 3.178130e-001, 3.178194e-001, 3.178259e-001, 3.178323e-001, 3.178387e-001, 3.178451e-001, 3.178516e-001, 3.178580e-001, 3.178644e-001, 3.178708e-001, 3.178772e-001, 3.178837e-001, 3.178901e-001, 3.178965e-001, 3.179029e-001, 3.179093e-001, 3.179158e-001, 3.179222e-001, 3.179286e-001, 3.179350e-001, 3.179414e-001, 3.179478e-001, 3.179543e-001, 3.179607e-001, 3.179671e-001, 3.179735e-001, 3.179799e-001, 3.179863e-001, 3.179927e-001, 3.179991e-001, 3.180055e-001, 3.180120e-001, 3.180184e-001, 3.180248e-001, 3.180312e-001, 3.180376e-001, 3.180440e-001, 3.180504e-001, 3.180568e-001, 3.180632e-001, 3.180696e-001, 3.180760e-001, 3.180824e-001, 3.180888e-001, 3.180952e-001, 3.181016e-001, 3.181080e-001, 3.181144e-001, 3.181208e-001, 3.181272e-001, 3.181336e-001, 
3.181400e-001, 3.181464e-001, 3.181528e-001, 3.181592e-001, 3.181656e-001, 3.181720e-001, 3.181784e-001, 3.181848e-001, 3.181912e-001, 3.181976e-001, 3.182040e-001, 3.182104e-001, 3.182168e-001, 3.182232e-001, 3.182296e-001, 3.182360e-001, 3.182424e-001, 3.182487e-001, 3.182551e-001, 3.182615e-001, 3.182679e-001, 3.182743e-001, 3.182807e-001, 3.182871e-001, 3.182935e-001, 3.182999e-001, 3.183062e-001, 3.183126e-001, 3.183190e-001, 3.183254e-001, 3.183318e-001, 3.183382e-001, 3.183445e-001, 3.183509e-001, 3.183573e-001, 3.183637e-001, 3.183701e-001, 3.183765e-001, 3.183828e-001, 3.183892e-001, 3.183956e-001, 3.184020e-001, 3.184083e-001, 3.184147e-001, 3.184211e-001, 3.184275e-001, 3.184338e-001, 3.184402e-001, 3.184466e-001, 3.184530e-001, 3.184593e-001, 3.184657e-001, 3.184721e-001, 3.184785e-001, 3.184848e-001, 3.184912e-001, 3.184976e-001, 3.185039e-001, 3.185103e-001, 3.185167e-001, 3.185231e-001, 3.185294e-001, 3.185358e-001, 3.185422e-001, 3.185485e-001, 3.185549e-001, 3.185613e-001, 3.185676e-001, 3.185740e-001, 3.185803e-001, 3.185867e-001, 3.185931e-001, 3.185994e-001, 3.186058e-001, 3.186122e-001, 3.186185e-001, 3.186249e-001, 3.186312e-001, 3.186376e-001, 3.186440e-001, 3.186503e-001, 3.186567e-001, 3.186630e-001, 3.186694e-001, 3.186757e-001, 3.186821e-001, 3.186884e-001, 3.186948e-001, 3.187012e-001, 3.187075e-001, 3.187139e-001, 3.187202e-001, 3.187266e-001, 3.187329e-001, 3.187393e-001, 3.187456e-001, 3.187520e-001, 3.187583e-001, 3.187647e-001, 3.187710e-001, 
3.187774e-001, 3.187837e-001, 3.187901e-001, 3.187964e-001, 3.188028e-001, 3.188091e-001, 3.188154e-001, 3.188218e-001, 3.188281e-001, 3.188345e-001, 3.188408e-001, 3.188472e-001, 3.188535e-001, 3.188598e-001, 3.188662e-001, 3.188725e-001, 3.188789e-001, 3.188852e-001, 3.188915e-001, 3.188979e-001, 3.189042e-001, 3.189106e-001, 3.189169e-001, 3.189232e-001, 3.189296e-001, 3.189359e-001, 3.189422e-001, 3.189486e-001, 3.189549e-001, 3.189612e-001, 3.189676e-001, 3.189739e-001, 3.189802e-001, 3.189866e-001, 3.189929e-001, 3.189992e-001, 3.190055e-001, 3.190119e-001, 3.190182e-001, 3.190245e-001, 3.190309e-001, 3.190372e-001, 3.190435e-001, 3.190498e-001, 3.190562e-001, 3.190625e-001, 3.190688e-001, 3.190751e-001, 3.190815e-001, 3.190878e-001, 3.190941e-001, 3.191004e-001, 3.191067e-001, 3.191131e-001, 3.191194e-001, 3.191257e-001, 3.191320e-001, 3.191383e-001, 3.191447e-001, 3.191510e-001, 3.191573e-001, 3.191636e-001, 3.191699e-001, 3.191762e-001, 3.191826e-001, 3.191889e-001, 3.191952e-001, 3.192015e-001, 3.192078e-001, 3.192141e-001, 3.192204e-001, 3.192268e-001, 3.192331e-001, 3.192394e-001, 3.192457e-001, 3.192520e-001, 3.192583e-001, 3.192646e-001, 3.192709e-001, 3.192772e-001, 3.192835e-001, 3.192898e-001, 3.192961e-001, 3.193024e-001, 3.193088e-001, 3.193151e-001, 3.193214e-001, 3.193277e-001, 3.193340e-001, 3.193403e-001, 3.193466e-001, 3.193529e-001, 3.193592e-001, 3.193655e-001, 3.193718e-001, 3.193781e-001, 3.193844e-001, 3.193907e-001, 3.193970e-001, 3.194033e-001, 
3.194096e-001, 3.194159e-001, 3.194222e-001, 3.194284e-001, 3.194347e-001, 3.194410e-001, 3.194473e-001, 3.194536e-001, 3.194599e-001, 3.194662e-001, 3.194725e-001, 3.194788e-001, 3.194851e-001, 3.194914e-001, 3.194977e-001, 3.195040e-001, 3.195102e-001, 3.195165e-001, 3.195228e-001, 3.195291e-001, 3.195354e-001, 3.195417e-001, 3.195480e-001, 3.195542e-001, 3.195605e-001, 3.195668e-001, 3.195731e-001, 3.195794e-001, 3.195857e-001, 3.195919e-001, 3.195982e-001, 3.196045e-001, 3.196108e-001, 3.196171e-001, 3.196233e-001, 3.196296e-001, 3.196359e-001, 3.196422e-001, 3.196485e-001, 3.196547e-001, 3.196610e-001, 3.196673e-001, 3.196736e-001, 3.196798e-001, 3.196861e-001, 3.196924e-001, 3.196987e-001, 3.197049e-001, 3.197112e-001, 3.197175e-001, 3.197237e-001, 3.197300e-001, 3.197363e-001, 3.197426e-001, 3.197488e-001, 3.197551e-001, 3.197614e-001, 3.197676e-001, 3.197739e-001, 3.197802e-001, 3.197864e-001, 3.197927e-001, 3.197990e-001, 3.198052e-001, 3.198115e-001, 3.198178e-001, 3.198240e-001, 3.198303e-001, 3.198365e-001, 3.198428e-001, 3.198491e-001, 3.198553e-001, 3.198616e-001, 3.198678e-001, 3.198741e-001, 3.198804e-001, 3.198866e-001, 3.198929e-001, 3.198991e-001, 3.199054e-001, 3.199116e-001, 3.199179e-001, 3.199242e-001, 3.199304e-001, 3.199367e-001, 3.199429e-001, 3.199492e-001, 3.199554e-001, 3.199617e-001, 3.199679e-001, 3.199742e-001, 3.199804e-001, 3.199867e-001, 3.199929e-001, 3.199992e-001, 3.200054e-001, 3.200117e-001, 3.200179e-001, 3.200242e-001, 3.200304e-001, 
3.200367e-001, 3.200429e-001, 3.200491e-001, 3.200554e-001, 3.200616e-001, 3.200679e-001, 3.200741e-001, 3.200804e-001, 3.200866e-001, 3.200928e-001, 3.200991e-001, 3.201053e-001, 3.201116e-001, 3.201178e-001, 3.201240e-001, 3.201303e-001, 3.201365e-001, 3.201428e-001, 3.201490e-001, 3.201552e-001, 3.201615e-001, 3.201677e-001, 3.201739e-001, 3.201802e-001, 3.201864e-001, 3.201926e-001, 3.201989e-001, 3.202051e-001, 3.202113e-001, 3.202176e-001, 3.202238e-001, 3.202300e-001, 3.202363e-001, 3.202425e-001, 3.202487e-001, 3.202549e-001, 3.202612e-001, 3.202674e-001, 3.202736e-001, 3.202798e-001, 3.202861e-001, 3.202923e-001, 3.202985e-001, 3.203047e-001, 3.203110e-001, 3.203172e-001, 3.203234e-001, 3.203296e-001, 3.203359e-001, 3.203421e-001, 3.203483e-001, 3.203545e-001, 3.203607e-001, 3.203670e-001, 3.203732e-001, 3.203794e-001, 3.203856e-001, 3.203918e-001, 3.203980e-001, 3.204043e-001, 3.204105e-001, 3.204167e-001, 3.204229e-001, 3.204291e-001, 3.204353e-001, 3.204415e-001, 3.204478e-001, 3.204540e-001, 3.204602e-001, 3.204664e-001, 3.204726e-001, 3.204788e-001, 3.204850e-001, 3.204912e-001, 3.204974e-001, 3.205036e-001, 3.205099e-001, 3.205161e-001, 3.205223e-001, 3.205285e-001, 3.205347e-001, 3.205409e-001, 3.205471e-001, 3.205533e-001, 3.205595e-001, 3.205657e-001, 3.205719e-001, 3.205781e-001, 3.205843e-001, 3.205905e-001, 3.205967e-001, 3.206029e-001, 3.206091e-001, 3.206153e-001, 3.206215e-001, 3.206277e-001, 3.206339e-001, 3.206401e-001, 3.206463e-001, 3.206525e-001, 
3.206587e-001, 3.206649e-001, 3.206711e-001, 3.206773e-001, 3.206834e-001, 3.206896e-001, 3.206958e-001, 3.207020e-001, 3.207082e-001, 3.207144e-001, 3.207206e-001, 3.207268e-001, 3.207330e-001, 3.207392e-001, 3.207454e-001, 3.207515e-001, 3.207577e-001, 3.207639e-001, 3.207701e-001, 3.207763e-001, 3.207825e-001, 3.207887e-001, 3.207948e-001, 3.208010e-001, 3.208072e-001, 3.208134e-001, 3.208196e-001, 3.208258e-001, 3.208319e-001, 3.208381e-001, 3.208443e-001, 3.208505e-001, 3.208567e-001, 3.208628e-001, 3.208690e-001, 3.208752e-001, 3.208814e-001, 3.208875e-001, 3.208937e-001, 3.208999e-001, 3.209061e-001, 3.209122e-001, 3.209184e-001, 3.209246e-001, 3.209308e-001, 3.209369e-001, 3.209431e-001, 3.209493e-001, 3.209554e-001, 3.209616e-001, 3.209678e-001, 3.209740e-001, 3.209801e-001, 3.209863e-001, 3.209925e-001, 3.209986e-001, 3.210048e-001, 3.210110e-001, 3.210171e-001, 3.210233e-001, 3.210295e-001, 3.210356e-001, 3.210418e-001, 3.210479e-001, 3.210541e-001, 3.210603e-001, 3.210664e-001, 3.210726e-001, 3.210788e-001, 3.210849e-001, 3.210911e-001, 3.210972e-001, 3.211034e-001, 3.211096e-001, 3.211157e-001, 3.211219e-001, 3.211280e-001, 3.211342e-001, 3.211403e-001, 3.211465e-001, 3.211526e-001, 3.211588e-001, 3.211650e-001, 3.211711e-001, 3.211773e-001, 3.211834e-001, 3.211896e-001, 3.211957e-001, 3.212019e-001, 3.212080e-001, 3.212142e-001, 3.212203e-001, 3.212265e-001, 3.212326e-001, 3.212388e-001, 3.212449e-001, 3.212511e-001, 3.212572e-001, 3.212634e-001, 3.212695e-001, 
3.212756e-001, 3.212818e-001, 3.212879e-001, 3.212941e-001, 3.213002e-001, 3.213064e-001, 3.213125e-001, 3.213186e-001, 3.213248e-001, 3.213309e-001, 3.213371e-001, 3.213432e-001, 3.213493e-001, 3.213555e-001, 3.213616e-001, 3.213678e-001, 3.213739e-001, 3.213800e-001, 3.213862e-001, 3.213923e-001, 3.213984e-001, 3.214046e-001, 3.214107e-001, 3.214168e-001, 3.214230e-001, 3.214291e-001, 3.214352e-001, 3.214414e-001, 3.214475e-001, 3.214536e-001, 3.214597e-001, 3.214659e-001, 3.214720e-001, 3.214781e-001, 3.214843e-001, 3.214904e-001, 3.214965e-001, 3.215026e-001, 3.215088e-001, 3.215149e-001, 3.215210e-001, 3.215271e-001, 3.215333e-001, 3.215394e-001, 3.215455e-001, 3.215516e-001, 3.215578e-001, 3.215639e-001, 3.215700e-001, 3.215761e-001, 3.215822e-001, 3.215884e-001, 3.215945e-001, 3.216006e-001, 3.216067e-001, 3.216128e-001, 3.216189e-001, 3.216251e-001, 3.216312e-001, 3.216373e-001, 3.216434e-001, 3.216495e-001, 3.216556e-001, 3.216617e-001, 3.216679e-001, 3.216740e-001, 3.216801e-001, 3.216862e-001, 3.216923e-001, 3.216984e-001, 3.217045e-001, 3.217106e-001, 3.217167e-001, 3.217229e-001, 3.217290e-001, 3.217351e-001, 3.217412e-001, 3.217473e-001, 3.217534e-001, 3.217595e-001, 3.217656e-001, 3.217717e-001, 3.217778e-001, 3.217839e-001, 3.217900e-001, 3.217961e-001, 3.218022e-001, 3.218083e-001, 3.218144e-001, 3.218205e-001, 3.218266e-001, 3.218327e-001, 3.218388e-001, 3.218449e-001, 3.218510e-001, 3.218571e-001, 3.218632e-001, 3.218693e-001, 3.218754e-001, 3.218815e-001, 
3.218876e-001, 3.218937e-001, 3.218998e-001, 3.219059e-001, 3.219120e-001, 3.219180e-001, 3.219241e-001, 3.219302e-001, 3.219363e-001, 3.219424e-001, 3.219485e-001, 3.219546e-001, 3.219607e-001, 3.219668e-001, 3.219729e-001, 3.219789e-001, 3.219850e-001, 3.219911e-001, 3.219972e-001, 3.220033e-001, 3.220094e-001, 3.220155e-001, 3.220215e-001, 3.220276e-001, 3.220337e-001, 3.220398e-001, 3.220459e-001, 3.220519e-001, 3.220580e-001, 3.220641e-001, 3.220702e-001, 3.220763e-001, 3.220823e-001, 3.220884e-001, 3.220945e-001, 3.221006e-001, 3.221067e-001, 3.221127e-001, 3.221188e-001, 3.221249e-001, 3.221310e-001, 3.221370e-001, 3.221431e-001, 3.221492e-001, 3.221553e-001, 3.221613e-001, 3.221674e-001, 3.221735e-001, 3.221795e-001, 3.221856e-001, 3.221917e-001, 3.221977e-001, 3.222038e-001, 3.222099e-001, 3.222160e-001, 3.222220e-001, 3.222281e-001, 3.222342e-001, 3.222402e-001, 3.222463e-001, 3.222523e-001, 3.222584e-001, 3.222645e-001, 3.222705e-001, 3.222766e-001, 3.222827e-001, 3.222887e-001, 3.222948e-001, 3.223008e-001, 3.223069e-001, 3.223130e-001, 3.223190e-001, 3.223251e-001, 3.223311e-001, 3.223372e-001, 3.223433e-001, 3.223493e-001, 3.223554e-001, 3.223614e-001, 3.223675e-001, 3.223735e-001, 3.223796e-001, 3.223856e-001, 3.223917e-001, 3.223977e-001, 3.224038e-001, 3.224099e-001, 3.224159e-001, 3.224220e-001, 3.224280e-001, 3.224341e-001, 3.224401e-001, 3.224462e-001, 3.224522e-001, 3.224582e-001, 3.224643e-001, 3.224703e-001, 3.224764e-001, 3.224824e-001, 3.224885e-001, 
3.224945e-001, 3.225006e-001, 3.225066e-001, 3.225127e-001, 3.225187e-001, 3.225247e-001, 3.225308e-001, 3.225368e-001, 3.225429e-001, 3.225489e-001, 3.225549e-001, 3.225610e-001, 3.225670e-001, 3.225731e-001, 3.225791e-001, 3.225851e-001, 3.225912e-001, 3.225972e-001, 3.226032e-001, 3.226093e-001, 3.226153e-001, 3.226213e-001, 3.226274e-001, 3.226334e-001, 3.226394e-001, 3.226455e-001, 3.226515e-001, 3.226575e-001, 3.226636e-001, 3.226696e-001, 3.226756e-001, 3.226817e-001, 3.226877e-001, 3.226937e-001, 3.226998e-001, 3.227058e-001, 3.227118e-001, 3.227178e-001, 3.227239e-001, 3.227299e-001, 3.227359e-001, 3.227419e-001, 3.227480e-001, 3.227540e-001, 3.227600e-001, 3.227660e-001, 3.227720e-001, 3.227781e-001, 3.227841e-001, 3.227901e-001, 3.227961e-001, 3.228021e-001, 3.228082e-001, 3.228142e-001, 3.228202e-001, 3.228262e-001, 3.228322e-001, 3.228383e-001, 3.228443e-001, 3.228503e-001, 3.228563e-001, 3.228623e-001, 3.228683e-001, 3.228743e-001, 3.228804e-001, 3.228864e-001, 3.228924e-001, 3.228984e-001, 3.229044e-001, 3.229104e-001, 3.229164e-001, 3.229224e-001, 3.229284e-001, 3.229344e-001, 3.229405e-001, 3.229465e-001, 3.229525e-001, 3.229585e-001, 3.229645e-001, 3.229705e-001, 3.229765e-001, 3.229825e-001, 3.229885e-001, 3.229945e-001, 3.230005e-001, 3.230065e-001, 3.230125e-001, 3.230185e-001, 3.230245e-001, 3.230305e-001, 3.230365e-001, 3.230425e-001, 3.230485e-001, 3.230545e-001, 3.230605e-001, 3.230665e-001, 3.230725e-001, 3.230785e-001, 3.230845e-001, 3.230905e-001, 
3.230965e-001, 3.231025e-001, 3.231085e-001, 3.231145e-001, 3.231205e-001, 3.231265e-001, 3.231325e-001, 3.231384e-001, 3.231444e-001, 3.231504e-001, 3.231564e-001, 3.231624e-001, 3.231684e-001, 3.231744e-001, 3.231804e-001, 3.231864e-001, 3.231923e-001, 3.231983e-001, 3.232043e-001, 3.232103e-001, 3.232163e-001, 3.232223e-001, 3.232283e-001, 3.232342e-001, 3.232402e-001, 3.232462e-001, 3.232522e-001, 3.232582e-001, 3.232642e-001, 3.232701e-001, 3.232761e-001, 3.232821e-001, 3.232881e-001, 3.232941e-001, 3.233000e-001, 3.233060e-001, 3.233120e-001, 3.233180e-001, 3.233239e-001, 3.233299e-001, 3.233359e-001, 3.233419e-001, 3.233478e-001, 3.233538e-001, 3.233598e-001, 3.233658e-001, 3.233717e-001, 3.233777e-001, 3.233837e-001, 3.233896e-001, 3.233956e-001, 3.234016e-001, 3.234076e-001, 3.234135e-001, 3.234195e-001, 3.234255e-001, 3.234314e-001, 3.234374e-001, 3.234434e-001, 3.234493e-001, 3.234553e-001, 3.234613e-001, 3.234672e-001, 3.234732e-001, 3.234792e-001, 3.234851e-001, 3.234911e-001, 3.234970e-001, 3.235030e-001, 3.235090e-001, 3.235149e-001, 3.235209e-001, 3.235268e-001, 3.235328e-001, 3.235388e-001, 3.235447e-001, 3.235507e-001, 3.235566e-001, 3.235626e-001, 3.235685e-001, 3.235745e-001, 3.235805e-001, 3.235864e-001, 3.235924e-001, 3.235983e-001, 3.236043e-001, 3.236102e-001, 3.236162e-001, 3.236221e-001, 3.236281e-001, 3.236340e-001, 3.236400e-001, 3.236459e-001, 3.236519e-001, 3.236578e-001, 3.236638e-001, 3.236697e-001, 3.236757e-001, 3.236816e-001, 3.236876e-001, 
3.236935e-001, 3.236995e-001, 3.237054e-001, 3.237113e-001, 3.237173e-001, 3.237232e-001, 3.237292e-001, 3.237351e-001, 3.237411e-001, 3.237470e-001, 3.237529e-001, 3.237589e-001, 3.237648e-001, 3.237708e-001, 3.237767e-001, 3.237826e-001, 3.237886e-001, 3.237945e-001, 3.238004e-001, 3.238064e-001, 3.238123e-001, 3.238183e-001, 3.238242e-001, 3.238301e-001, 3.238361e-001, 3.238420e-001, 3.238479e-001, 3.238539e-001, 3.238598e-001, 3.238657e-001, 3.238717e-001, 3.238776e-001, 3.238835e-001, 3.238894e-001, 3.238954e-001, 3.239013e-001, 3.239072e-001, 3.239132e-001, 3.239191e-001, 3.239250e-001, 3.239309e-001, 3.239369e-001, 3.239428e-001, 3.239487e-001, 3.239546e-001, 3.239606e-001, 3.239665e-001, 3.239724e-001, 3.239783e-001, 3.239842e-001, 3.239902e-001, 3.239961e-001, 3.240020e-001, 3.240079e-001, 3.240138e-001, 3.240198e-001, 3.240257e-001, 3.240316e-001, 3.240375e-001, 3.240434e-001, 3.240494e-001, 3.240553e-001, 3.240612e-001, 3.240671e-001, 3.240730e-001, 3.240789e-001, 3.240848e-001, 3.240908e-001, 3.240967e-001, 3.241026e-001, 3.241085e-001, 3.241144e-001, 3.241203e-001, 3.241262e-001, 3.241321e-001, 3.241380e-001, 3.241439e-001, 3.241499e-001, 3.241558e-001, 3.241617e-001, 3.241676e-001, 3.241735e-001, 3.241794e-001, 3.241853e-001, 3.241912e-001, 3.241971e-001, 3.242030e-001, 3.242089e-001, 3.242148e-001, 3.242207e-001, 3.242266e-001, 3.242325e-001, 3.242384e-001, 3.242443e-001, 3.242502e-001, 3.242561e-001, 3.242620e-001, 3.242679e-001, 3.242738e-001, 3.242797e-001, 
3.242856e-001, 3.242915e-001, 3.242974e-001, 3.243033e-001, 3.243092e-001, 3.243151e-001, 3.243210e-001, 3.243269e-001, 3.243328e-001, 3.243386e-001, 3.243445e-001, 3.243504e-001, 3.243563e-001, 3.243622e-001, 3.243681e-001, 3.243740e-001, 3.243799e-001, 3.243858e-001, 3.243917e-001, 3.243975e-001, 3.244034e-001, 3.244093e-001, 3.244152e-001, 3.244211e-001, 3.244270e-001, 3.244329e-001, 3.244387e-001, 3.244446e-001, 3.244505e-001, 3.244564e-001, 3.244623e-001, 3.244681e-001, 3.244740e-001, 3.244799e-001, 3.244858e-001, 3.244917e-001, 3.244975e-001, 3.245034e-001, 3.245093e-001, 3.245152e-001, 3.245211e-001, 3.245269e-001, 3.245328e-001, 3.245387e-001, 3.245446e-001, 3.245504e-001, 3.245563e-001, 3.245622e-001, 3.245681e-001, 3.245739e-001, 3.245798e-001, 3.245857e-001, 3.245915e-001, 3.245974e-001, 3.246033e-001, 3.246092e-001, 3.246150e-001, 3.246209e-001, 3.246268e-001, 3.246326e-001, 3.246385e-001, 3.246444e-001, 3.246502e-001, 3.246561e-001, 3.246620e-001, 3.246678e-001, 3.246737e-001, 3.246796e-001, 3.246854e-001, 3.246913e-001, 3.246971e-001, 3.247030e-001, 3.247089e-001, 3.247147e-001, 3.247206e-001, 3.247264e-001, 3.247323e-001, 3.247382e-001, 3.247440e-001, 3.247499e-001, 3.247557e-001, 3.247616e-001, 3.247675e-001, 3.247733e-001, 3.247792e-001, 3.247850e-001, 3.247909e-001, 3.247967e-001, 3.248026e-001, 3.248084e-001, 3.248143e-001, 3.248201e-001, 3.248260e-001, 3.248318e-001, 3.248377e-001, 3.248435e-001, 3.248494e-001, 3.248552e-001, 3.248611e-001, 3.248669e-001, 
3.248728e-001, 3.248786e-001, 3.248845e-001, 3.248903e-001, 3.248962e-001, 3.249020e-001, 3.249079e-001, 3.249137e-001, 3.249196e-001, 3.249254e-001, 3.249312e-001, 3.249371e-001, 3.249429e-001, 3.249488e-001, 3.249546e-001, 3.249604e-001, 3.249663e-001, 3.249721e-001, 3.249780e-001, 3.249838e-001, 3.249896e-001, 3.249955e-001, 3.250013e-001, 3.250071e-001, 3.250130e-001, 3.250188e-001, 3.250247e-001, 3.250305e-001, 3.250363e-001, 3.250422e-001, 3.250480e-001, 3.250538e-001, 3.250597e-001, 3.250655e-001, 3.250713e-001, 3.250771e-001, 3.250830e-001, 3.250888e-001, 3.250946e-001, 3.251005e-001, 3.251063e-001, 3.251121e-001, 3.251179e-001, 3.251238e-001, 3.251296e-001, 3.251354e-001, 3.251413e-001, 3.251471e-001, 3.251529e-001, 3.251587e-001, 3.251645e-001, 3.251704e-001, 3.251762e-001, 3.251820e-001, 3.251878e-001, 3.251937e-001, 3.251995e-001, 3.252053e-001, 3.252111e-001, 3.252169e-001, 3.252228e-001, 3.252286e-001, 3.252344e-001, 3.252402e-001, 3.252460e-001, 3.252518e-001, 3.252577e-001, 3.252635e-001, 3.252693e-001, 3.252751e-001, 3.252809e-001, 3.252867e-001, 3.252925e-001, 3.252984e-001, 3.253042e-001, 3.253100e-001, 3.253158e-001, 3.253216e-001, 3.253274e-001, 3.253332e-001, 3.253390e-001, 3.253448e-001, 3.253506e-001, 3.253564e-001, 3.253623e-001, 3.253681e-001, 3.253739e-001, 3.253797e-001, 3.253855e-001, 3.253913e-001, 3.253971e-001, 3.254029e-001, 3.254087e-001, 3.254145e-001, 3.254203e-001, 3.254261e-001, 3.254319e-001, 3.254377e-001, 3.254435e-001, 3.254493e-001, 
3.254551e-001, 3.254609e-001, 3.254667e-001, 3.254725e-001, 3.254783e-001, 3.254841e-001, 3.254899e-001, 3.254957e-001, 3.255015e-001, 3.255073e-001, 3.255131e-001, 3.255189e-001, 3.255246e-001, 3.255304e-001, 3.255362e-001, 3.255420e-001, 3.255478e-001, 3.255536e-001, 3.255594e-001, 3.255652e-001, 3.255710e-001, 3.255768e-001, 3.255826e-001, 3.255883e-001, 3.255941e-001, 3.255999e-001, 3.256057e-001, 3.256115e-001, 3.256173e-001, 3.256231e-001, 3.256288e-001, 3.256346e-001, 3.256404e-001, 3.256462e-001, 3.256520e-001, 3.256578e-001, 3.256635e-001, 3.256693e-001, 3.256751e-001, 3.256809e-001, 3.256867e-001, 3.256924e-001, 3.256982e-001, 3.257040e-001, 3.257098e-001, 3.257156e-001, 3.257213e-001, 3.257271e-001, 3.257329e-001, 3.257387e-001, 3.257444e-001, 3.257502e-001, 3.257560e-001, 3.257618e-001, 3.257675e-001, 3.257733e-001, 3.257791e-001, 3.257848e-001, 3.257906e-001, 3.257964e-001, 3.258022e-001, 3.258079e-001, 3.258137e-001, 3.258195e-001, 3.258252e-001, 3.258310e-001, 3.258368e-001, 3.258425e-001, 3.258483e-001, 3.258541e-001, 3.258598e-001, 3.258656e-001, 3.258714e-001, 3.258771e-001, 3.258829e-001, 3.258886e-001, 3.258944e-001, 3.259002e-001, 3.259059e-001, 3.259117e-001, 3.259174e-001, 3.259232e-001, 3.259290e-001, 3.259347e-001, 3.259405e-001, 3.259462e-001, 3.259520e-001, 3.259578e-001, 3.259635e-001, 3.259693e-001, 3.259750e-001, 3.259808e-001, 3.259865e-001, 3.259923e-001, 3.259980e-001, 3.260038e-001, 3.260095e-001, 3.260153e-001, 3.260211e-001, 3.260268e-001, 
3.260326e-001, 3.260383e-001, 3.260441e-001, 3.260498e-001, 3.260556e-001, 3.260613e-001, 3.260670e-001, 3.260728e-001, 3.260785e-001, 3.260843e-001, 3.260900e-001, 3.260958e-001, 3.261015e-001, 3.261073e-001, 3.261130e-001, 3.261188e-001, 3.261245e-001, 3.261302e-001, 3.261360e-001, 3.261417e-001, 3.261475e-001, 3.261532e-001, 3.261589e-001, 3.261647e-001, 3.261704e-001, 3.261762e-001, 3.261819e-001, 3.261876e-001, 3.261934e-001, 3.261991e-001, 3.262048e-001, 3.262106e-001, 3.262163e-001, 3.262221e-001, 3.262278e-001, 3.262335e-001, 3.262393e-001, 3.262450e-001, 3.262507e-001, 3.262564e-001, 3.262622e-001, 3.262679e-001, 3.262736e-001, 3.262794e-001, 3.262851e-001, 3.262908e-001, 3.262966e-001, 3.263023e-001, 3.263080e-001, 3.263137e-001, 3.263195e-001, 3.263252e-001, 3.263309e-001, 3.263366e-001, 3.263424e-001, 3.263481e-001, 3.263538e-001, 3.263595e-001, 3.263653e-001, 3.263710e-001, 3.263767e-001, 3.263824e-001, 3.263881e-001, 3.263939e-001, 3.263996e-001, 3.264053e-001, 3.264110e-001, 3.264167e-001, 3.264225e-001, 3.264282e-001, 3.264339e-001, 3.264396e-001, 3.264453e-001, 3.264510e-001, 3.264568e-001, 3.264625e-001, 3.264682e-001, 3.264739e-001, 3.264796e-001, 3.264853e-001, 3.264910e-001, 3.264967e-001, 3.265025e-001, 3.265082e-001, 3.265139e-001, 3.265196e-001, 3.265253e-001, 3.265310e-001, 3.265367e-001, 3.265424e-001, 3.265481e-001, 3.265538e-001, 3.265595e-001, 3.265653e-001, 3.265710e-001, 3.265767e-001, 3.265824e-001, 3.265881e-001, 3.265938e-001, 3.265995e-001, 
3.266052e-001, 3.266109e-001, 3.266166e-001, 3.266223e-001, 3.266280e-001, 3.266337e-001, 3.266394e-001, 3.266451e-001, 3.266508e-001, 3.266565e-001, 3.266622e-001, 3.266679e-001, 3.266736e-001, 3.266793e-001, 3.266850e-001, 3.266907e-001, 3.266964e-001, 3.267020e-001, 3.267077e-001, 3.267134e-001, 3.267191e-001, 3.267248e-001, 3.267305e-001, 3.267362e-001, 3.267419e-001, 3.267476e-001, 3.267533e-001, 3.267590e-001, 3.267646e-001, 3.267703e-001, 3.267760e-001, 3.267817e-001, 3.267874e-001, 3.267931e-001, 3.267988e-001, 3.268045e-001, 3.268101e-001, 3.268158e-001, 3.268215e-001, 3.268272e-001, 3.268329e-001, 3.268386e-001, 3.268442e-001, 3.268499e-001, 3.268556e-001, 3.268613e-001, 3.268670e-001, 3.268726e-001, 3.268783e-001, 3.268840e-001, 3.268897e-001, 3.268954e-001, 3.269010e-001, 3.269067e-001, 3.269124e-001, 3.269181e-001, 3.269237e-001, 3.269294e-001, 3.269351e-001, 3.269408e-001, 3.269464e-001, 3.269521e-001, 3.269578e-001, 3.269635e-001, 3.269691e-001, 3.269748e-001, 3.269805e-001, 3.269861e-001, 3.269918e-001, 3.269975e-001, 3.270032e-001, 3.270088e-001, 3.270145e-001, 3.270202e-001, 3.270258e-001, 3.270315e-001, 3.270372e-001, 3.270428e-001, 3.270485e-001, 3.270542e-001, 3.270598e-001, 3.270655e-001, 3.270711e-001, 3.270768e-001, 3.270825e-001, 3.270881e-001, 3.270938e-001, 3.270994e-001, 3.271051e-001, 3.271108e-001, 3.271164e-001, 3.271221e-001, 3.271277e-001, 3.271334e-001, 3.271391e-001, 3.271447e-001, 3.271504e-001, 3.271560e-001, 3.271617e-001, 3.271673e-001, 
3.271730e-001, 3.271786e-001, 3.271843e-001, 3.271900e-001, 3.271956e-001, 3.272013e-001, 3.272069e-001, 3.272126e-001, 3.272182e-001, 3.272239e-001, 3.272295e-001, 3.272352e-001, 3.272408e-001, 3.272465e-001, 3.272521e-001, 3.272578e-001, 3.272634e-001, 3.272690e-001, 3.272747e-001, 3.272803e-001, 3.272860e-001, 3.272916e-001, 3.272973e-001, 3.273029e-001, 3.273086e-001, 3.273142e-001, 3.273198e-001, 3.273255e-001, 3.273311e-001, 3.273368e-001, 3.273424e-001, 3.273480e-001, 3.273537e-001, 3.273593e-001, 3.273650e-001, 3.273706e-001, 3.273762e-001, 3.273819e-001, 3.273875e-001, 3.273931e-001, 3.273988e-001, 3.274044e-001, 3.274100e-001, 3.274157e-001, 3.274213e-001, 3.274270e-001, 3.274326e-001, 3.274382e-001, 3.274438e-001, 3.274495e-001, 3.274551e-001, 3.274607e-001, 3.274664e-001, 3.274720e-001, 3.274776e-001, 3.274833e-001, 3.274889e-001, 3.274945e-001, 3.275001e-001, 3.275058e-001, 3.275114e-001, 3.275170e-001, 3.275226e-001, 3.275283e-001, 3.275339e-001, 3.275395e-001, 3.275451e-001, 3.275508e-001, 3.275564e-001, 3.275620e-001, 3.275676e-001, 3.275732e-001, 3.275789e-001, 3.275845e-001, 3.275901e-001, 3.275957e-001, 3.276013e-001, 3.276070e-001, 3.276126e-001, 3.276182e-001, 3.276238e-001, 3.276294e-001, 3.276350e-001, 3.276406e-001, 3.276463e-001, 3.276519e-001, 3.276575e-001, 3.276631e-001, 3.276687e-001, 3.276743e-001, 3.276799e-001, 3.276855e-001, 3.276912e-001, 3.276968e-001, 3.277024e-001, 3.277080e-001, 3.277136e-001, 3.277192e-001, 3.277248e-001, 3.277304e-001, 
3.277360e-001, 3.277416e-001, 3.277472e-001, 3.277528e-001, 3.277584e-001, 3.277641e-001, 3.277697e-001, 3.277753e-001, 3.277809e-001, 3.277865e-001, 3.277921e-001, 3.277977e-001, 3.278033e-001, 3.278089e-001, 3.278145e-001, 3.278201e-001, 3.278257e-001, 3.278313e-001, 3.278369e-001, 3.278425e-001, 3.278481e-001, 3.278537e-001, 3.278593e-001, 3.278649e-001, 3.278704e-001, 3.278760e-001, 3.278816e-001, 3.278872e-001, 3.278928e-001, 3.278984e-001, 3.279040e-001, 3.279096e-001, 3.279152e-001, 3.279208e-001, 3.279264e-001, 3.279320e-001, 3.279376e-001, 3.279431e-001, 3.279487e-001, 3.279543e-001, 3.279599e-001, 3.279655e-001, 3.279711e-001, 3.279767e-001, 3.279823e-001, 3.279878e-001, 3.279934e-001, 3.279990e-001, 3.280046e-001, 3.280102e-001, 3.280158e-001, 3.280213e-001, 3.280269e-001, 3.280325e-001, 3.280381e-001, 3.280437e-001, 3.280492e-001, 3.280548e-001, 3.280604e-001, 3.280660e-001, 3.280716e-001, 3.280771e-001, 3.280827e-001, 3.280883e-001, 3.280939e-001, 3.280994e-001, 3.281050e-001, 3.281106e-001, 3.281162e-001, 3.281217e-001, 3.281273e-001, 3.281329e-001, 3.281385e-001, 3.281440e-001, 3.281496e-001, 3.281552e-001, 3.281607e-001, 3.281663e-001, 3.281719e-001, 3.281775e-001, 3.281830e-001, 3.281886e-001, 3.281942e-001, 3.281997e-001, 3.282053e-001, 3.282109e-001, 3.282164e-001, 3.282220e-001, 3.282276e-001, 3.282331e-001, 3.282387e-001, 3.282442e-001, 3.282498e-001, 3.282554e-001, 3.282609e-001, 3.282665e-001, 3.282721e-001, 3.282776e-001, 3.282832e-001, 3.282887e-001, 
3.282943e-001, 3.282999e-001, 3.283054e-001, 3.283110e-001, 3.283165e-001, 3.283221e-001, 3.283276e-001, 3.283332e-001, 3.283388e-001, 3.283443e-001, 3.283499e-001, 3.283554e-001, 3.283610e-001, 3.283665e-001, 3.283721e-001, 3.283776e-001, 3.283832e-001, 3.283887e-001, 3.283943e-001, 3.283998e-001, 3.284054e-001, 3.284109e-001, 3.284165e-001, 3.284220e-001, 3.284276e-001, 3.284331e-001, 3.284387e-001, 3.284442e-001, 3.284498e-001, 3.284553e-001, 3.284609e-001, 3.284664e-001, 3.284719e-001, 3.284775e-001, 3.284830e-001, 3.284886e-001, 3.284941e-001, 3.284997e-001, 3.285052e-001, 3.285107e-001, 3.285163e-001, 3.285218e-001, 3.285274e-001, 3.285329e-001, 3.285384e-001, 3.285440e-001, 3.285495e-001, 3.285550e-001, 3.285606e-001, 3.285661e-001, 3.285717e-001, 3.285772e-001, 3.285827e-001, 3.285883e-001, 3.285938e-001, 3.285993e-001, 3.286049e-001, 3.286104e-001, 3.286159e-001, 3.286215e-001, 3.286270e-001, 3.286325e-001, 3.286380e-001, 3.286436e-001, 3.286491e-001, 3.286546e-001, 3.286602e-001, 3.286657e-001, 3.286712e-001, 3.286767e-001, 3.286823e-001, 3.286878e-001, 3.286933e-001, 3.286988e-001, 3.287044e-001, 3.287099e-001, 3.287154e-001, 3.287209e-001, 3.287265e-001, 3.287320e-001, 3.287375e-001, 3.287430e-001, 3.287485e-001, 3.287541e-001, 3.287596e-001, 3.287651e-001, 3.287706e-001, 3.287761e-001, 3.287817e-001, 3.287872e-001, 3.287927e-001, 3.287982e-001, 3.288037e-001, 3.288092e-001, 3.288148e-001, 3.288203e-001, 3.288258e-001, 3.288313e-001, 3.288368e-001, 3.288423e-001, 
3.288478e-001, 3.288533e-001, 3.288589e-001, 3.288644e-001, 3.288699e-001, 3.288754e-001, 3.288809e-001, 3.288864e-001, 3.288919e-001, 3.288974e-001, 3.289029e-001, 3.289084e-001, 3.289139e-001, 3.289194e-001, 3.289249e-001, 3.289305e-001, 3.289360e-001, 3.289415e-001, 3.289470e-001, 3.289525e-001, 3.289580e-001, 3.289635e-001, 3.289690e-001, 3.289745e-001, 3.289800e-001, 3.289855e-001, 3.289910e-001, 3.289965e-001, 3.290020e-001, 3.290075e-001, 3.290130e-001, 3.290185e-001, 3.290240e-001, 3.290295e-001, 3.290350e-001, 3.290404e-001, 3.290459e-001, 3.290514e-001, 3.290569e-001, 3.290624e-001, 3.290679e-001, 3.290734e-001, 3.290789e-001, 3.290844e-001, 3.290899e-001, 3.290954e-001, 3.291009e-001, 3.291064e-001, 3.291118e-001, 3.291173e-001, 3.291228e-001, 3.291283e-001, 3.291338e-001, 3.291393e-001, 3.291448e-001, 3.291503e-001, 3.291557e-001, 3.291612e-001, 3.291667e-001, 3.291722e-001, 3.291777e-001, 3.291832e-001, 3.291886e-001, 3.291941e-001, 3.291996e-001, 3.292051e-001, 3.292106e-001, 3.292161e-001, 3.292215e-001, 3.292270e-001, 3.292325e-001, 3.292380e-001, 3.292434e-001, 3.292489e-001, 3.292544e-001, 3.292599e-001, 3.292654e-001, 3.292708e-001, 3.292763e-001, 3.292818e-001, 3.292873e-001, 3.292927e-001, 3.292982e-001, 3.293037e-001, 3.293091e-001, 3.293146e-001, 3.293201e-001, 3.293256e-001, 3.293310e-001, 3.293365e-001, 3.293420e-001, 3.293474e-001, 3.293529e-001, 3.293584e-001, 3.293638e-001, 3.293693e-001, 3.293748e-001, 3.293802e-001, 3.293857e-001, 3.293912e-001, 
3.293966e-001, 3.294021e-001, 3.294076e-001, 3.294130e-001, 3.294185e-001, 3.294240e-001, 3.294294e-001, 3.294349e-001, 3.294403e-001, 3.294458e-001, 3.294513e-001, 3.294567e-001, 3.294622e-001, 3.294676e-001, 3.294731e-001, 3.294786e-001, 3.294840e-001, 3.294895e-001, 3.294949e-001, 3.295004e-001, 3.295058e-001, 3.295113e-001, 3.295168e-001, 3.295222e-001, 3.295277e-001, 3.295331e-001, 3.295386e-001, 3.295440e-001, 3.295495e-001, 3.295549e-001, 3.295604e-001, 3.295658e-001, 3.295713e-001, 3.295767e-001, 3.295822e-001, 3.295876e-001, 3.295931e-001, 3.295985e-001, 3.296040e-001, 3.296094e-001, 3.296149e-001, 3.296203e-001, 3.296257e-001, 3.296312e-001, 3.296366e-001, 3.296421e-001, 3.296475e-001, 3.296530e-001, 3.296584e-001, 3.296638e-001, 3.296693e-001, 3.296747e-001, 3.296802e-001, 3.296856e-001, 3.296910e-001, 3.296965e-001, 3.297019e-001, 3.297074e-001, 3.297128e-001, 3.297182e-001, 3.297237e-001, 3.297291e-001, 3.297345e-001, 3.297400e-001, 3.297454e-001, 3.297509e-001, 3.297563e-001, 3.297617e-001, 3.297672e-001, 3.297726e-001, 3.297780e-001, 3.297834e-001, 3.297889e-001, 3.297943e-001, 3.297997e-001, 3.298052e-001, 3.298106e-001, 3.298160e-001, 3.298215e-001, 3.298269e-001, 3.298323e-001, 3.298377e-001, 3.298432e-001, 3.298486e-001, 3.298540e-001, 3.298594e-001, 3.298649e-001, 3.298703e-001, 3.298757e-001, 3.298811e-001, 3.298866e-001, 3.298920e-001, 3.298974e-001, 3.299028e-001, 3.299082e-001, 3.299137e-001, 3.299191e-001, 3.299245e-001, 3.299299e-001, 3.299353e-001, 
3.299408e-001, 3.299462e-001, 3.299516e-001, 3.299570e-001, 3.299624e-001, 3.299678e-001, 3.299733e-001, 3.299787e-001, 3.299841e-001, 3.299895e-001, 3.299949e-001, 3.300003e-001, 3.300057e-001, 3.300112e-001, 3.300166e-001, 3.300220e-001, 3.300274e-001, 3.300328e-001, 3.300382e-001, 3.300436e-001, 3.300490e-001, 3.300544e-001, 3.300598e-001, 3.300652e-001, 3.300707e-001, 3.300761e-001, 3.300815e-001, 3.300869e-001, 3.300923e-001, 3.300977e-001, 3.301031e-001, 3.301085e-001, 3.301139e-001, 3.301193e-001, 3.301247e-001, 3.301301e-001, 3.301355e-001, 3.301409e-001, 3.301463e-001, 3.301517e-001, 3.301571e-001, 3.301625e-001, 3.301679e-001, 3.301733e-001, 3.301787e-001, 3.301841e-001, 3.301895e-001, 3.301949e-001, 3.302003e-001, 3.302057e-001, 3.302111e-001, 3.302165e-001, 3.302219e-001, 3.302272e-001, 3.302326e-001, 3.302380e-001, 3.302434e-001, 3.302488e-001, 3.302542e-001, 3.302596e-001, 3.302650e-001, 3.302704e-001, 3.302758e-001, 3.302812e-001, 3.302865e-001, 3.302919e-001, 3.302973e-001, 3.303027e-001, 3.303081e-001, 3.303135e-001, 3.303189e-001, 3.303242e-001, 3.303296e-001, 3.303350e-001, 3.303404e-001, 3.303458e-001, 3.303512e-001, 3.303565e-001, 3.303619e-001, 3.303673e-001, 3.303727e-001, 3.303781e-001, 3.303835e-001, 3.303888e-001, 3.303942e-001, 3.303996e-001, 3.304050e-001, 3.304103e-001, 3.304157e-001, 3.304211e-001, 3.304265e-001, 3.304318e-001, 3.304372e-001, 3.304426e-001, 3.304480e-001, 3.304533e-001, 3.304587e-001, 3.304641e-001, 3.304695e-001, 3.304748e-001, 
3.304802e-001, 3.304856e-001, 3.304910e-001, 3.304963e-001, 3.305017e-001, 3.305071e-001, 3.305124e-001, 3.305178e-001, 3.305232e-001, 3.305285e-001, 3.305339e-001, 3.305393e-001, 3.305446e-001, 3.305500e-001, 3.305554e-001, 3.305607e-001, 3.305661e-001, 3.305715e-001, 3.305768e-001, 3.305822e-001, 3.305875e-001, 3.305929e-001, 3.305983e-001, 3.306036e-001, 3.306090e-001, 3.306143e-001, 3.306197e-001, 3.306251e-001, 3.306304e-001, 3.306358e-001, 3.306411e-001, 3.306465e-001, 3.306518e-001, 3.306572e-001, 3.306626e-001, 3.306679e-001, 3.306733e-001, 3.306786e-001, 3.306840e-001, 3.306893e-001, 3.306947e-001, 3.307000e-001, 3.307054e-001, 3.307107e-001, 3.307161e-001, 3.307214e-001, 3.307268e-001, 3.307321e-001, 3.307375e-001, 3.307428e-001, 3.307482e-001, 3.307535e-001, 3.307589e-001, 3.307642e-001, 3.307696e-001, 3.307749e-001, 3.307803e-001, 3.307856e-001, 3.307910e-001, 3.307963e-001, 3.308016e-001, 3.308070e-001, 3.308123e-001, 3.308177e-001, 3.308230e-001, 3.308284e-001, 3.308337e-001, 3.308390e-001, 3.308444e-001, 3.308497e-001, 3.308551e-001, 3.308604e-001, 3.308657e-001, 3.308711e-001, 3.308764e-001, 3.308817e-001, 3.308871e-001, 3.308924e-001, 3.308977e-001, 3.309031e-001, 3.309084e-001, 3.309138e-001, 3.309191e-001, 3.309244e-001, 3.309297e-001, 3.309351e-001, 3.309404e-001, 3.309457e-001, 3.309511e-001, 3.309564e-001, 3.309617e-001, 3.309671e-001, 3.309724e-001, 3.309777e-001, 3.309830e-001, 3.309884e-001, 3.309937e-001, 3.309990e-001, 3.310044e-001, 3.310097e-001, 
3.310150e-001, 3.310203e-001, 3.310257e-001, 3.310310e-001, 3.310363e-001, 3.310416e-001, 3.310469e-001, 3.310523e-001, 3.310576e-001, 3.310629e-001, 3.310682e-001, 3.310735e-001, 3.310789e-001, 3.310842e-001, 3.310895e-001, 3.310948e-001, 3.311001e-001, 3.311055e-001, 3.311108e-001, 3.311161e-001, 3.311214e-001, 3.311267e-001, 3.311320e-001, 3.311374e-001, 3.311427e-001, 3.311480e-001, 3.311533e-001, 3.311586e-001, 3.311639e-001, 3.311692e-001, 3.311745e-001, 3.311798e-001, 3.311852e-001, 3.311905e-001, 3.311958e-001, 3.312011e-001, 3.312064e-001, 3.312117e-001, 3.312170e-001, 3.312223e-001, 3.312276e-001, 3.312329e-001, 3.312382e-001, 3.312435e-001, 3.312488e-001, 3.312542e-001, 3.312595e-001, 3.312648e-001, 3.312701e-001, 3.312754e-001, 3.312807e-001, 3.312860e-001, 3.312913e-001, 3.312966e-001, 3.313019e-001, 3.313072e-001, 3.313125e-001, 3.313178e-001, 3.313231e-001, 3.313284e-001, 3.313337e-001, 3.313390e-001, 3.313443e-001, 3.313495e-001, 3.313548e-001, 3.313601e-001, 3.313654e-001, 3.313707e-001, 3.313760e-001, 3.313813e-001, 3.313866e-001, 3.313919e-001, 3.313972e-001, 3.314025e-001, 3.314078e-001, 3.314131e-001, 3.314184e-001, 3.314236e-001, 3.314289e-001, 3.314342e-001, 3.314395e-001, 3.314448e-001, 3.314501e-001, 3.314554e-001, 3.314607e-001, 3.314659e-001, 3.314712e-001, 3.314765e-001, 3.314818e-001, 3.314871e-001, 3.314924e-001, 3.314976e-001, 3.315029e-001, 3.315082e-001, 3.315135e-001, 3.315188e-001, 3.315241e-001, 3.315293e-001, 3.315346e-001, 3.315399e-001, 
3.315452e-001, 3.315504e-001, 3.315557e-001, 3.315610e-001, 3.315663e-001, 3.315716e-001, 3.315768e-001, 3.315821e-001, 3.315874e-001, 3.315927e-001, 3.315979e-001, 3.316032e-001, 3.316085e-001, 3.316138e-001, 3.316190e-001, 3.316243e-001, 3.316296e-001, 3.316348e-001, 3.316401e-001, 3.316454e-001, 3.316506e-001, 3.316559e-001, 3.316612e-001, 3.316665e-001, 3.316717e-001, 3.316770e-001, 3.316823e-001, 3.316875e-001, 3.316928e-001, 3.316981e-001, 3.317033e-001, 3.317086e-001, 3.317138e-001, 3.317191e-001, 3.317244e-001, 3.317296e-001, 3.317349e-001, 3.317402e-001, 3.317454e-001, 3.317507e-001, 3.317559e-001, 3.317612e-001, 3.317665e-001, 3.317717e-001, 3.317770e-001, 3.317822e-001, 3.317875e-001, 3.317928e-001, 3.317980e-001, 3.318033e-001, 3.318085e-001, 3.318138e-001, 3.318190e-001, 3.318243e-001, 3.318295e-001, 3.318348e-001, 3.318400e-001, 3.318453e-001, 3.318506e-001, 3.318558e-001, 3.318611e-001, 3.318663e-001, 3.318716e-001, 3.318768e-001, 3.318821e-001, 3.318873e-001, 3.318926e-001, 3.318978e-001, 3.319030e-001, 3.319083e-001, 3.319135e-001, 3.319188e-001, 3.319240e-001, 3.319293e-001, 3.319345e-001, 3.319398e-001, 3.319450e-001, 3.319503e-001, 3.319555e-001, 3.319607e-001, 3.319660e-001, 3.319712e-001, 3.319765e-001, 3.319817e-001, 3.319869e-001, 3.319922e-001, 3.319974e-001, 3.320027e-001, 3.320079e-001, 3.320131e-001, 3.320184e-001, 3.320236e-001, 3.320289e-001, 3.320341e-001, 3.320393e-001, 3.320446e-001, 3.320498e-001, 3.320550e-001, 3.320603e-001, 3.320655e-001, 
3.320707e-001, 3.320760e-001, 3.320812e-001, 3.320864e-001, 3.320917e-001, 3.320969e-001, 3.321021e-001, 3.321073e-001, 3.321126e-001, 3.321178e-001, 3.321230e-001, 3.321283e-001, 3.321335e-001, 3.321387e-001, 3.321439e-001, 3.321492e-001, 3.321544e-001, 3.321596e-001, 3.321648e-001, 3.321701e-001, 3.321753e-001, 3.321805e-001, 3.321857e-001, 3.321910e-001, 3.321962e-001, 3.322014e-001, 3.322066e-001, 3.322118e-001, 3.322171e-001, 3.322223e-001, 3.322275e-001, 3.322327e-001, 3.322379e-001, 3.322432e-001, 3.322484e-001, 3.322536e-001, 3.322588e-001, 3.322640e-001, 3.322692e-001, 3.322744e-001, 3.322797e-001, 3.322849e-001, 3.322901e-001, 3.322953e-001, 3.323005e-001, 3.323057e-001, 3.323109e-001, 3.323162e-001, 3.323214e-001, 3.323266e-001, 3.323318e-001, 3.323370e-001, 3.323422e-001, 3.323474e-001, 3.323526e-001, 3.323578e-001, 3.323630e-001, 3.323682e-001, 3.323734e-001, 3.323787e-001, 3.323839e-001, 3.323891e-001, 3.323943e-001, 3.323995e-001, 3.324047e-001, 3.324099e-001, 3.324151e-001, 3.324203e-001, 3.324255e-001, 3.324307e-001, 3.324359e-001, 3.324411e-001, 3.324463e-001, 3.324515e-001, 3.324567e-001, 3.324619e-001, 3.324671e-001, 3.324723e-001, 3.324775e-001, 3.324827e-001, 3.324879e-001, 3.324931e-001, 3.324983e-001, 3.325035e-001, 3.325086e-001, 3.325138e-001, 3.325190e-001, 3.325242e-001, 3.325294e-001, 3.325346e-001, 3.325398e-001, 3.325450e-001, 3.325502e-001, 3.325554e-001, 3.325606e-001, 3.325658e-001, 3.325709e-001, 3.325761e-001, 3.325813e-001, 3.325865e-001, 
3.325917e-001, 3.325969e-001, 3.326021e-001, 3.326073e-001, 3.326124e-001, 3.326176e-001, 3.326228e-001, 3.326280e-001, 3.326332e-001, 3.326384e-001, 3.326435e-001, 3.326487e-001, 3.326539e-001, 3.326591e-001, 3.326643e-001, 3.326694e-001, 3.326746e-001, 3.326798e-001, 3.326850e-001, 3.326902e-001, 3.326953e-001, 3.327005e-001, 3.327057e-001, 3.327109e-001, 3.327160e-001, 3.327212e-001, 3.327264e-001, 3.327316e-001, 3.327367e-001, 3.327419e-001, 3.327471e-001, 3.327523e-001, 3.327574e-001, 3.327626e-001, 3.327678e-001, 3.327730e-001, 3.327781e-001, 3.327833e-001, 3.327885e-001, 3.327936e-001, 3.327988e-001, 3.328040e-001, 3.328091e-001, 3.328143e-001, 3.328195e-001, 3.328246e-001, 3.328298e-001, 3.328350e-001, 3.328401e-001, 3.328453e-001, 3.328505e-001, 3.328556e-001, 3.328608e-001, 3.328660e-001, 3.328711e-001, 3.328763e-001, 3.328814e-001, 3.328866e-001, 3.328918e-001, 3.328969e-001, 3.329021e-001, 3.329072e-001, 3.329124e-001, 3.329176e-001, 3.329227e-001, 3.329279e-001, 3.329330e-001, 3.329382e-001, 3.329433e-001, 3.329485e-001, 3.329537e-001, 3.329588e-001, 3.329640e-001, 3.329691e-001, 3.329743e-001, 3.329794e-001, 3.329846e-001, 3.329897e-001, 3.329949e-001, 3.330000e-001, 3.330052e-001, 3.330103e-001, 3.330155e-001, 3.330206e-001, 3.330258e-001, 3.330309e-001, 3.330361e-001, 3.330412e-001, 3.330464e-001, 3.330515e-001, 3.330567e-001, 3.330618e-001, 3.330670e-001, 3.330721e-001, 3.330772e-001, 3.330824e-001, 3.330875e-001, 3.330927e-001, 3.330978e-001, 3.331030e-001, 
3.331081e-001, 3.331132e-001, 3.331184e-001, 3.331235e-001, 3.331287e-001, 3.331338e-001, 3.331389e-001, 3.331441e-001, 3.331492e-001, 3.331544e-001, 3.331595e-001, 3.331646e-001, 3.331698e-001, 3.331749e-001, 3.331800e-001, 3.331852e-001, 3.331903e-001, 3.331954e-001, 3.332006e-001, 3.332057e-001, 3.332108e-001, 3.332160e-001, 3.332211e-001, 3.332262e-001, 3.332314e-001, 3.332365e-001, 3.332416e-001, 3.332468e-001, 3.332519e-001, 3.332570e-001, 3.332621e-001, 3.332673e-001, 3.332724e-001, 3.332775e-001, 3.332826e-001, 3.332878e-001, 3.332929e-001, 3.332980e-001, 3.333031e-001, 3.333083e-001, 3.333134e-001, 3.333185e-001, 3.333236e-001, 3.333288e-001, 3.333339e-001, 3.333390e-001, 3.333441e-001, 3.333492e-001, 3.333544e-001, 3.333595e-001, 3.333646e-001, 3.333697e-001, 3.333748e-001, 3.333800e-001, 3.333851e-001, 3.333902e-001, 3.333953e-001, 3.334004e-001, 3.334055e-001, 3.334106e-001, 3.334158e-001, 3.334209e-001, 3.334260e-001, 3.334311e-001, 3.334362e-001, 3.334413e-001, 3.334464e-001, 3.334515e-001, 3.334567e-001, 3.334618e-001, 3.334669e-001, 3.334720e-001, 3.334771e-001, 3.334822e-001, 3.334873e-001, 3.334924e-001, 3.334975e-001, 3.335026e-001, 3.335077e-001, 3.335128e-001, 3.335180e-001, 3.335231e-001, 3.335282e-001, 3.335333e-001, 3.335384e-001, 3.335435e-001, 3.335486e-001, 3.335537e-001, 3.335588e-001, 3.335639e-001, 3.335690e-001, 3.335741e-001, 3.335792e-001, 3.335843e-001, 3.335894e-001, 3.335945e-001, 3.335996e-001, 3.336047e-001, 3.336098e-001, 3.336149e-001, 
3.336200e-001, 3.336251e-001, 3.336302e-001, 3.336352e-001, 3.336403e-001, 3.336454e-001, 3.336505e-001, 3.336556e-001, 3.336607e-001, 3.336658e-001, 3.336709e-001, 3.336760e-001, 3.336811e-001, 3.336862e-001, 3.336913e-001, 3.336963e-001, 3.337014e-001, 3.337065e-001, 3.337116e-001, 3.337167e-001, 3.337218e-001, 3.337269e-001, 3.337320e-001, 3.337370e-001, 3.337421e-001, 3.337472e-001, 3.337523e-001, 3.337574e-001, 3.337625e-001, 3.337676e-001, 3.337726e-001, 3.337777e-001, 3.337828e-001, 3.337879e-001, 3.337930e-001, 3.337980e-001, 3.338031e-001, 3.338082e-001, 3.338133e-001, 3.338184e-001, 3.338234e-001, 3.338285e-001, 3.338336e-001, 3.338387e-001, 3.338437e-001, 3.338488e-001, 3.338539e-001, 3.338590e-001, 3.338640e-001, 3.338691e-001, 3.338742e-001, 3.338793e-001, 3.338843e-001, 3.338894e-001, 3.338945e-001, 3.338996e-001, 3.339046e-001, 3.339097e-001, 3.339148e-001, 3.339198e-001, 3.339249e-001, 3.339300e-001, 3.339350e-001, 3.339401e-001, 3.339452e-001, 3.339502e-001, 3.339553e-001, 3.339604e-001, 3.339654e-001, 3.339705e-001, 3.339756e-001, 3.339806e-001, 3.339857e-001, 3.339908e-001, 3.339958e-001, 3.340009e-001, 3.340059e-001, 3.340110e-001, 3.340161e-001, 3.340211e-001, 3.340262e-001, 3.340312e-001, 3.340363e-001, 3.340414e-001, 3.340464e-001, 3.340515e-001, 3.340565e-001, 3.340616e-001, 3.340667e-001, 3.340717e-001, 3.340768e-001, 3.340818e-001, 3.340869e-001, 3.340919e-001, 3.340970e-001, 3.341020e-001, 3.341071e-001, 3.341121e-001, 3.341172e-001, 3.341222e-001, 
3.341273e-001, 3.341323e-001, 3.341374e-001, 3.341424e-001, 3.341475e-001, 3.341525e-001, 3.341576e-001, 3.341626e-001, 3.341677e-001, 3.341727e-001, 3.341778e-001, 3.341828e-001, 3.341879e-001, 3.341929e-001, 3.341980e-001, 3.342030e-001, 3.342080e-001, 3.342131e-001, 3.342181e-001, 3.342232e-001, 3.342282e-001, 3.342333e-001, 3.342383e-001, 3.342433e-001, 3.342484e-001, 3.342534e-001, 3.342585e-001, 3.342635e-001, 3.342685e-001, 3.342736e-001, 3.342786e-001, 3.342837e-001, 3.342887e-001, 3.342937e-001, 3.342988e-001, 3.343038e-001, 3.343088e-001, 3.343139e-001, 3.343189e-001, 3.343239e-001, 3.343290e-001, 3.343340e-001, 3.343390e-001, 3.343441e-001, 3.343491e-001, 3.343541e-001, 3.343592e-001, 3.343642e-001, 3.343692e-001, 3.343742e-001, 3.343793e-001, 3.343843e-001, 3.343893e-001, 3.343944e-001, 3.343994e-001, 3.344044e-001, 3.344094e-001, 3.344145e-001, 3.344195e-001, 3.344245e-001, 3.344295e-001, 3.344346e-001, 3.344396e-001, 3.344446e-001, 3.344496e-001, 3.344546e-001, 3.344597e-001, 3.344647e-001, 3.344697e-001, 3.344747e-001, 3.344797e-001, 3.344848e-001, 3.344898e-001, 3.344948e-001, 3.344998e-001, 3.345048e-001, 3.345099e-001, 3.345149e-001, 3.345199e-001, 3.345249e-001, 3.345299e-001, 3.345349e-001, 3.345399e-001, 3.345450e-001, 3.345500e-001, 3.345550e-001, 3.345600e-001, 3.345650e-001, 3.345700e-001, 3.345750e-001, 3.345800e-001, 3.345851e-001, 3.345901e-001, 3.345951e-001, 3.346001e-001, 3.346051e-001, 3.346101e-001, 3.346151e-001, 3.346201e-001, 3.346251e-001, 
3.346301e-001, 3.346351e-001, 3.346401e-001, 3.346451e-001, 3.346501e-001, 3.346551e-001, 3.346601e-001, 3.346652e-001, 3.346702e-001, 3.346752e-001, 3.346802e-001, 3.346852e-001, 3.346902e-001, 3.346952e-001, 3.347002e-001, 3.347052e-001, 3.347102e-001, 3.347152e-001, 3.347202e-001, 3.347252e-001, 3.347301e-001, 3.347351e-001, 3.347401e-001, 3.347451e-001, 3.347501e-001, 3.347551e-001, 3.347601e-001, 3.347651e-001, 3.347701e-001, 3.347751e-001, 3.347801e-001, 3.347851e-001, 3.347901e-001, 3.347951e-001, 3.348001e-001, 3.348051e-001, 3.348100e-001, 3.348150e-001, 3.348200e-001, 3.348250e-001, 3.348300e-001, 3.348350e-001, 3.348400e-001, 3.348450e-001, 3.348499e-001, 3.348549e-001, 3.348599e-001, 3.348649e-001, 3.348699e-001, 3.348749e-001, 3.348799e-001, 3.348848e-001, 3.348898e-001, 3.348948e-001, 3.348998e-001, 3.349048e-001, 3.349097e-001, 3.349147e-001, 3.349197e-001, 3.349247e-001, 3.349297e-001, 3.349346e-001, 3.349396e-001, 3.349446e-001, 3.349496e-001, 3.349546e-001, 3.349595e-001, 3.349645e-001, 3.349695e-001, 3.349745e-001, 3.349794e-001, 3.349844e-001, 3.349894e-001, 3.349944e-001, 3.349993e-001, 3.350043e-001, 3.350093e-001, 3.350142e-001, 3.350192e-001, 3.350242e-001, 3.350292e-001, 3.350341e-001, 3.350391e-001, 3.350441e-001, 3.350490e-001, 3.350540e-001, 3.350590e-001, 3.350639e-001, 3.350689e-001, 3.350739e-001, 3.350788e-001, 3.350838e-001, 3.350888e-001, 3.350937e-001, 3.350987e-001, 3.351037e-001, 3.351086e-001, 3.351136e-001, 3.351185e-001, 3.351235e-001, 
3.351285e-001, 3.351334e-001, 3.351384e-001, 3.351433e-001, 3.351483e-001, 3.351533e-001, 3.351582e-001, 3.351632e-001, 3.351681e-001, 3.351731e-001, 3.351781e-001, 3.351830e-001, 3.351880e-001, 3.351929e-001, 3.351979e-001, 3.352028e-001, 3.352078e-001, 3.352127e-001, 3.352177e-001, 3.352226e-001, 3.352276e-001, 3.352326e-001, 3.352375e-001, 3.352425e-001, 3.352474e-001, 3.352524e-001, 3.352573e-001, 3.352623e-001, 3.352672e-001, 3.352722e-001, 3.352771e-001, 3.352820e-001, 3.352870e-001, 3.352919e-001, 3.352969e-001, 3.353018e-001, 3.353068e-001, 3.353117e-001, 3.353167e-001, 3.353216e-001, 3.353266e-001, 3.353315e-001, 3.353364e-001, 3.353414e-001, 3.353463e-001, 3.353513e-001, 3.353562e-001, 3.353611e-001, 3.353661e-001, 3.353710e-001, 3.353760e-001, 3.353809e-001, 3.353858e-001, 3.353908e-001, 3.353957e-001, 3.354007e-001, 3.354056e-001, 3.354105e-001, 3.354155e-001, 3.354204e-001, 3.354253e-001, 3.354303e-001, 3.354352e-001, 3.354401e-001, 3.354451e-001, 3.354500e-001, 3.354549e-001, 3.354599e-001, 3.354648e-001, 3.354697e-001, 3.354747e-001, 3.354796e-001, 3.354845e-001, 3.354894e-001, 3.354944e-001, 3.354993e-001, 3.355042e-001, 3.355091e-001, 3.355141e-001, 3.355190e-001, 3.355239e-001, 3.355289e-001, 3.355338e-001, 3.355387e-001, 3.355436e-001, 3.355485e-001, 3.355535e-001, 3.355584e-001, 3.355633e-001, 3.355682e-001, 3.355732e-001, 3.355781e-001, 3.355830e-001, 3.355879e-001, 3.355928e-001, 3.355978e-001, 3.356027e-001, 3.356076e-001, 3.356125e-001, 3.356174e-001, 
3.356223e-001, 3.356273e-001, 3.356322e-001, 3.356371e-001, 3.356420e-001, 3.356469e-001, 3.356518e-001, 3.356568e-001, 3.356617e-001, 3.356666e-001, 3.356715e-001, 3.356764e-001, 3.356813e-001, 3.356862e-001, 3.356911e-001, 3.356960e-001, 3.357010e-001, 3.357059e-001, 3.357108e-001, 3.357157e-001, 3.357206e-001, 3.357255e-001, 3.357304e-001, 3.357353e-001, 3.357402e-001, 3.357451e-001, 3.357500e-001, 3.357549e-001, 3.357598e-001, 3.357647e-001, 3.357696e-001, 3.357745e-001, 3.357794e-001, 3.357844e-001, 3.357893e-001, 3.357942e-001, 3.357991e-001, 3.358040e-001, 3.358089e-001, 3.358138e-001, 3.358187e-001, 3.358236e-001, 3.358285e-001, 3.358333e-001, 3.358382e-001, 3.358431e-001, 3.358480e-001, 3.358529e-001, 3.358578e-001, 3.358627e-001, 3.358676e-001, 3.358725e-001, 3.358774e-001, 3.358823e-001, 3.358872e-001, 3.358921e-001, 3.358970e-001, 3.359019e-001, 3.359068e-001, 3.359117e-001, 3.359165e-001, 3.359214e-001, 3.359263e-001, 3.359312e-001, 3.359361e-001, 3.359410e-001, 3.359459e-001, 3.359508e-001, 3.359556e-001, 3.359605e-001, 3.359654e-001, 3.359703e-001, 3.359752e-001, 3.359801e-001, 3.359850e-001, 3.359898e-001, 3.359947e-001, 3.359996e-001, 3.360045e-001, 3.360094e-001, 3.360143e-001, 3.360191e-001, 3.360240e-001, 3.360289e-001, 3.360338e-001, 3.360387e-001, 3.360435e-001, 3.360484e-001, 3.360533e-001, 3.360582e-001, 3.360630e-001, 3.360679e-001, 3.360728e-001, 3.360777e-001, 3.360825e-001, 3.360874e-001, 3.360923e-001, 3.360972e-001, 3.361020e-001, 3.361069e-001, 
3.361118e-001, 3.361167e-001, 3.361215e-001, 3.361264e-001, 3.361313e-001, 3.361361e-001, 3.361410e-001, 3.361459e-001, 3.361507e-001, 3.361556e-001, 3.361605e-001, 3.361654e-001, 3.361702e-001, 3.361751e-001, 3.361800e-001, 3.361848e-001, 3.361897e-001, 3.361945e-001, 3.361994e-001, 3.362043e-001, 3.362091e-001, 3.362140e-001, 3.362189e-001, 3.362237e-001, 3.362286e-001, 3.362335e-001, 3.362383e-001, 3.362432e-001, 3.362480e-001, 3.362529e-001, 3.362578e-001, 3.362626e-001, 3.362675e-001, 3.362723e-001, 3.362772e-001, 3.362820e-001, 3.362869e-001, 3.362918e-001, 3.362966e-001, 3.363015e-001, 3.363063e-001, 3.363112e-001, 3.363160e-001, 3.363209e-001, 3.363257e-001, 3.363306e-001, 3.363354e-001, 3.363403e-001, 3.363451e-001, 3.363500e-001, 3.363548e-001, 3.363597e-001, 3.363645e-001, 3.363694e-001, 3.363742e-001, 3.363791e-001, 3.363839e-001, 3.363888e-001, 3.363936e-001, 3.363985e-001, 3.364033e-001, 3.364082e-001, 3.364130e-001, 3.364179e-001, 3.364227e-001, 3.364275e-001, 3.364324e-001, 3.364372e-001, 3.364421e-001, 3.364469e-001, 3.364518e-001, 3.364566e-001, 3.364614e-001, 3.364663e-001, 3.364711e-001, 3.364760e-001, 3.364808e-001, 3.364856e-001, 3.364905e-001, 3.364953e-001, 3.365001e-001, 3.365050e-001, 3.365098e-001, 3.365147e-001, 3.365195e-001, 3.365243e-001, 3.365292e-001, 3.365340e-001, 3.365388e-001, 3.365437e-001, 3.365485e-001, 3.365533e-001, 3.365582e-001, 3.365630e-001, 3.365678e-001, 3.365726e-001, 3.365775e-001, 3.365823e-001, 3.365871e-001, 3.365920e-001, 
3.365968e-001, 3.366016e-001, 3.366064e-001, 3.366113e-001, 3.366161e-001, 3.366209e-001, 3.366258e-001, 3.366306e-001, 3.366354e-001, 3.366402e-001, 3.366451e-001, 3.366499e-001, 3.366547e-001, 3.366595e-001, 3.366643e-001, 3.366692e-001, 3.366740e-001, 3.366788e-001, 3.366836e-001, 3.366884e-001, 3.366933e-001, 3.366981e-001, 3.367029e-001, 3.367077e-001, 3.367125e-001, 3.367174e-001, 3.367222e-001, 3.367270e-001, 3.367318e-001, 3.367366e-001, 3.367414e-001, 3.367463e-001, 3.367511e-001, 3.367559e-001, 3.367607e-001, 3.367655e-001, 3.367703e-001, 3.367751e-001, 3.367799e-001, 3.367848e-001, 3.367896e-001, 3.367944e-001, 3.367992e-001, 3.368040e-001, 3.368088e-001, 3.368136e-001, 3.368184e-001, 3.368232e-001, 3.368280e-001, 3.368328e-001, 3.368376e-001, 3.368425e-001, 3.368473e-001, 3.368521e-001, 3.368569e-001, 3.368617e-001, 3.368665e-001, 3.368713e-001, 3.368761e-001, 3.368809e-001, 3.368857e-001, 3.368905e-001, 3.368953e-001, 3.369001e-001, 3.369049e-001, 3.369097e-001, 3.369145e-001, 3.369193e-001, 3.369241e-001, 3.369289e-001, 3.369337e-001, 3.369385e-001, 3.369433e-001, 3.369481e-001, 3.369529e-001, 3.369577e-001, 3.369625e-001, 3.369672e-001, 3.369720e-001, 3.369768e-001, 3.369816e-001, 3.369864e-001, 3.369912e-001, 3.369960e-001, 3.370008e-001, 3.370056e-001, 3.370104e-001, 3.370152e-001, 3.370200e-001, 3.370247e-001, 3.370295e-001, 3.370343e-001, 3.370391e-001, 3.370439e-001, 3.370487e-001, 3.370535e-001, 3.370583e-001, 3.370630e-001, 3.370678e-001, 3.370726e-001, 
3.370774e-001, 3.370822e-001, 3.370870e-001, 3.370918e-001, 3.370965e-001, 3.371013e-001, 3.371061e-001, 3.371109e-001, 3.371157e-001, 3.371204e-001, 3.371252e-001, 3.371300e-001, 3.371348e-001, 3.371396e-001, 3.371443e-001, 3.371491e-001, 3.371539e-001, 3.371587e-001, 3.371634e-001, 3.371682e-001, 3.371730e-001, 3.371778e-001, 3.371825e-001, 3.371873e-001, 3.371921e-001, 3.371969e-001, 3.372016e-001, 3.372064e-001, 3.372112e-001, 3.372160e-001, 3.372207e-001, 3.372255e-001, 3.372303e-001, 3.372350e-001, 3.372398e-001, 3.372446e-001, 3.372493e-001, 3.372541e-001, 3.372589e-001, 3.372636e-001, 3.372684e-001, 3.372732e-001, 3.372779e-001, 3.372827e-001, 3.372875e-001, 3.372922e-001, 3.372970e-001, 3.373018e-001, 3.373065e-001, 3.373113e-001, 3.373161e-001, 3.373208e-001, 3.373256e-001, 3.373303e-001, 3.373351e-001, 3.373399e-001, 3.373446e-001, 3.373494e-001, 3.373541e-001, 3.373589e-001, 3.373637e-001, 3.373684e-001, 3.373732e-001, 3.373779e-001, 3.373827e-001, 3.373874e-001, 3.373922e-001, 3.373970e-001, 3.374017e-001, 3.374065e-001, 3.374112e-001, 3.374160e-001, 3.374207e-001, 3.374255e-001, 3.374302e-001, 3.374350e-001, 3.374397e-001, 3.374445e-001, 3.374492e-001, 3.374540e-001, 3.374587e-001, 3.374635e-001, 3.374682e-001, 3.374730e-001, 3.374777e-001, 3.374825e-001, 3.374872e-001, 3.374920e-001, 3.374967e-001, 3.375014e-001, 3.375062e-001, 3.375109e-001, 3.375157e-001, 3.375204e-001, 3.375252e-001, 3.375299e-001, 3.375347e-001, 3.375394e-001, 3.375441e-001, 3.375489e-001, 
3.375536e-001, 3.375584e-001, 3.375631e-001, 3.375678e-001, 3.375726e-001, 3.375773e-001, 3.375821e-001, 3.375868e-001, 3.375915e-001, 3.375963e-001, 3.376010e-001, 3.376057e-001, 3.376105e-001, 3.376152e-001, 3.376199e-001, 3.376247e-001, 3.376294e-001, 3.376341e-001, 3.376389e-001, 3.376436e-001, 3.376483e-001, 3.376531e-001, 3.376578e-001, 3.376625e-001, 3.376673e-001, 3.376720e-001, 3.376767e-001, 3.376814e-001, 3.376862e-001, 3.376909e-001, 3.376956e-001, 3.377004e-001, 3.377051e-001, 3.377098e-001, 3.377145e-001, 3.377193e-001, 3.377240e-001, 3.377287e-001, 3.377334e-001, 3.377382e-001, 3.377429e-001, 3.377476e-001, 3.377523e-001, 3.377571e-001, 3.377618e-001, 3.377665e-001, 3.377712e-001, 3.377759e-001, 3.377807e-001, 3.377854e-001, 3.377901e-001, 3.377948e-001, 3.377995e-001, 3.378042e-001, 3.378090e-001, 3.378137e-001, 3.378184e-001, 3.378231e-001, 3.378278e-001, 3.378325e-001, 3.378373e-001, 3.378420e-001, 3.378467e-001, 3.378514e-001, 3.378561e-001, 3.378608e-001, 3.378655e-001, 3.378702e-001, 3.378750e-001, 3.378797e-001, 3.378844e-001, 3.378891e-001, 3.378938e-001, 3.378985e-001, 3.379032e-001, 3.379079e-001, 3.379126e-001, 3.379173e-001, 3.379220e-001, 3.379267e-001, 3.379315e-001, 3.379362e-001, 3.379409e-001, 3.379456e-001, 3.379503e-001, 3.379550e-001, 3.379597e-001, 3.379644e-001, 3.379691e-001, 3.379738e-001, 3.379785e-001, 3.379832e-001, 3.379879e-001, 3.379926e-001, 3.379973e-001, 3.380020e-001, 3.380067e-001, 3.380114e-001, 3.380161e-001, 3.380208e-001, 
3.380255e-001, 3.380302e-001, 3.380349e-001, 3.380396e-001, 3.380443e-001, 3.380490e-001, 3.380536e-001, 3.380583e-001, 3.380630e-001, 3.380677e-001, 3.380724e-001, 3.380771e-001, 3.380818e-001, 3.380865e-001, 3.380912e-001, 3.380959e-001, 3.381006e-001, 3.381053e-001, 3.381099e-001, 3.381146e-001, 3.381193e-001, 3.381240e-001, 3.381287e-001, 3.381334e-001, 3.381381e-001, 3.381428e-001, 3.381474e-001, 3.381521e-001, 3.381568e-001, 3.381615e-001, 3.381662e-001, 3.381709e-001, 3.381755e-001, 3.381802e-001, 3.381849e-001, 3.381896e-001, 3.381943e-001, 3.381990e-001, 3.382036e-001, 3.382083e-001, 3.382130e-001, 3.382177e-001, 3.382224e-001, 3.382270e-001, 3.382317e-001, 3.382364e-001, 3.382411e-001, 3.382457e-001, 3.382504e-001, 3.382551e-001, 3.382598e-001, 3.382644e-001, 3.382691e-001, 3.382738e-001, 3.382785e-001, 3.382831e-001, 3.382878e-001, 3.382925e-001, 3.382972e-001, 3.383018e-001, 3.383065e-001, 3.383112e-001, 3.383158e-001, 3.383205e-001, 3.383252e-001, 3.383298e-001, 3.383345e-001, 3.383392e-001, 3.383438e-001, 3.383485e-001, 3.383532e-001, 3.383578e-001, 3.383625e-001, 3.383672e-001, 3.383718e-001, 3.383765e-001, 3.383812e-001, 3.383858e-001, 3.383905e-001, 3.383952e-001, 3.383998e-001, 3.384045e-001, 3.384091e-001, 3.384138e-001, 3.384185e-001, 3.384231e-001, 3.384278e-001, 3.384324e-001, 3.384371e-001, 3.384418e-001, 3.384464e-001, 3.384511e-001, 3.384557e-001, 3.384604e-001, 3.384651e-001, 3.384697e-001, 3.384744e-001, 3.384790e-001, 3.384837e-001, 3.384883e-001, 
3.384930e-001, 3.384976e-001, 3.385023e-001, 3.385069e-001, 3.385116e-001, 3.385162e-001, 3.385209e-001, 3.385255e-001, 3.385302e-001, 3.385348e-001, 3.385395e-001, 3.385441e-001, 3.385488e-001, 3.385534e-001, 3.385581e-001, 3.385627e-001, 3.385674e-001, 3.385720e-001, 3.385767e-001, 3.385813e-001, 3.385860e-001, 3.385906e-001, 3.385952e-001, 3.385999e-001, 3.386045e-001, 3.386092e-001, 3.386138e-001, 3.386185e-001, 3.386231e-001, 3.386277e-001, 3.386324e-001, 3.386370e-001, 3.386417e-001, 3.386463e-001, 3.386509e-001, 3.386556e-001, 3.386602e-001, 3.386649e-001, 3.386695e-001, 3.386741e-001, 3.386788e-001, 3.386834e-001, 3.386880e-001, 3.386927e-001, 3.386973e-001, 3.387019e-001, 3.387066e-001, 3.387112e-001, 3.387158e-001, 3.387205e-001, 3.387251e-001, 3.387297e-001, 3.387344e-001, 3.387390e-001, 3.387436e-001, 3.387483e-001, 3.387529e-001, 3.387575e-001, 3.387621e-001, 3.387668e-001, 3.387714e-001, 3.387760e-001, 3.387807e-001, 3.387853e-001, 3.387899e-001, 3.387945e-001, 3.387992e-001, 3.388038e-001, 3.388084e-001, 3.388130e-001, 3.388177e-001, 3.388223e-001, 3.388269e-001, 3.388315e-001, 3.388361e-001, 3.388408e-001, 3.388454e-001, 3.388500e-001, 3.388546e-001, 3.388592e-001, 3.388639e-001, 3.388685e-001, 3.388731e-001, 3.388777e-001, 3.388823e-001, 3.388870e-001, 3.388916e-001, 3.388962e-001, 3.389008e-001, 3.389054e-001, 3.389100e-001, 3.389146e-001, 3.389193e-001, 3.389239e-001, 3.389285e-001, 3.389331e-001, 3.389377e-001, 3.389423e-001, 3.389469e-001, 3.389515e-001, 
3.389562e-001, 3.389608e-001, 3.389654e-001, 3.389700e-001, 3.389746e-001, 3.389792e-001, 3.389838e-001, 3.389884e-001, 3.389930e-001, 3.389976e-001, 3.390022e-001, 3.390068e-001, 3.390114e-001, 3.390161e-001, 3.390207e-001, 3.390253e-001, 3.390299e-001, 3.390345e-001, 3.390391e-001, 3.390437e-001, 3.390483e-001, 3.390529e-001, 3.390575e-001, 3.390621e-001, 3.390667e-001, 3.390713e-001, 3.390759e-001, 3.390805e-001, 3.390851e-001, 3.390897e-001, 3.390943e-001, 3.390989e-001, 3.391035e-001, 3.391081e-001, 3.391127e-001, 3.391172e-001, 3.391218e-001, 3.391264e-001, 3.391310e-001, 3.391356e-001, 3.391402e-001, 3.391448e-001, 3.391494e-001, 3.391540e-001, 3.391586e-001, 3.391632e-001, 3.391678e-001, 3.391724e-001, 3.391769e-001, 3.391815e-001, 3.391861e-001, 3.391907e-001, 3.391953e-001, 3.391999e-001, 3.392045e-001, 3.392091e-001, 3.392136e-001, 3.392182e-001, 3.392228e-001, 3.392274e-001, 3.392320e-001, 3.392366e-001, 3.392412e-001, 3.392457e-001, 3.392503e-001, 3.392549e-001, 3.392595e-001, 3.392641e-001, 3.392687e-001, 3.392732e-001, 3.392778e-001, 3.392824e-001, 3.392870e-001, 3.392916e-001, 3.392961e-001, 3.393007e-001, 3.393053e-001, 3.393099e-001, 3.393144e-001, 3.393190e-001, 3.393236e-001, 3.393282e-001, 3.393327e-001, 3.393373e-001, 3.393419e-001, 3.393465e-001, 3.393510e-001, 3.393556e-001, 3.393602e-001, 3.393648e-001, 3.393693e-001, 3.393739e-001, 3.393785e-001, 3.393830e-001, 3.393876e-001, 3.393922e-001, 3.393967e-001, 3.394013e-001, 3.394059e-001, 3.394105e-001, 
3.394150e-001, 3.394196e-001, 3.394242e-001, 3.394287e-001, 3.394333e-001, 3.394379e-001, 3.394424e-001, 3.394470e-001, 3.394515e-001, 3.394561e-001, 3.394607e-001, 3.394652e-001, 3.394698e-001, 3.394744e-001, 3.394789e-001, 3.394835e-001, 3.394880e-001, 3.394926e-001, 3.394972e-001, 3.395017e-001, 3.395063e-001, 3.395108e-001, 3.395154e-001, 3.395200e-001, 3.395245e-001, 3.395291e-001, 3.395336e-001, 3.395382e-001, 3.395427e-001, 3.395473e-001, 3.395518e-001, 3.395564e-001, 3.395610e-001, 3.395655e-001, 3.395701e-001, 3.395746e-001, 3.395792e-001, 3.395837e-001, 3.395883e-001, 3.395928e-001, 3.395974e-001, 3.396019e-001, 3.396065e-001, 3.396110e-001, 3.396156e-001, 3.396201e-001, 3.396247e-001, 3.396292e-001, 3.396338e-001, 3.396383e-001, 3.396428e-001, 3.396474e-001, 3.396519e-001, 3.396565e-001, 3.396610e-001, 3.396656e-001, 3.396701e-001, 3.396747e-001, 3.396792e-001, 3.396837e-001, 3.396883e-001, 3.396928e-001, 3.396974e-001, 3.397019e-001, 3.397064e-001, 3.397110e-001, 3.397155e-001, 3.397201e-001, 3.397246e-001, 3.397291e-001, 3.397337e-001, 3.397382e-001, 3.397427e-001, 3.397473e-001, 3.397518e-001, 3.397564e-001, 3.397609e-001, 3.397654e-001, 3.397700e-001, 3.397745e-001, 3.397790e-001, 3.397836e-001, 3.397881e-001, 3.397926e-001, 3.397972e-001, 3.398017e-001, 3.398062e-001, 3.398107e-001, 3.398153e-001, 3.398198e-001, 3.398243e-001, 3.398289e-001, 3.398334e-001, 3.398379e-001, 3.398424e-001, 3.398470e-001, 3.398515e-001, 3.398560e-001, 3.398605e-001, 3.398651e-001, 
3.398696e-001, 3.398741e-001, 3.398786e-001, 3.398832e-001, 3.398877e-001, 3.398922e-001, 3.398967e-001, 3.399013e-001, 3.399058e-001, 3.399103e-001, 3.399148e-001, 3.399193e-001, 3.399239e-001, 3.399284e-001, 3.399329e-001, 3.399374e-001, 3.399419e-001, 3.399464e-001, 3.399510e-001, 3.399555e-001, 3.399600e-001, 3.399645e-001, 3.399690e-001, 3.399735e-001, 3.399781e-001, 3.399826e-001, 3.399871e-001, 3.399916e-001, 3.399961e-001, 3.400006e-001, 3.400051e-001, 3.400096e-001, 3.400142e-001, 3.400187e-001, 3.400232e-001, 3.400277e-001, 3.400322e-001, 3.400367e-001, 3.400412e-001, 3.400457e-001, 3.400502e-001, 3.400547e-001, 3.400592e-001, 3.400637e-001, 3.400683e-001, 3.400728e-001, 3.400773e-001, 3.400818e-001, 3.400863e-001, 3.400908e-001, 3.400953e-001, 3.400998e-001, 3.401043e-001, 3.401088e-001, 3.401133e-001, 3.401178e-001, 3.401223e-001, 3.401268e-001, 3.401313e-001, 3.401358e-001, 3.401403e-001, 3.401448e-001, 3.401493e-001, 3.401538e-001, 3.401583e-001, 3.401628e-001, 3.401673e-001, 3.401718e-001, 3.401763e-001, 3.401808e-001, 3.401853e-001, 3.401897e-001, 3.401942e-001, 3.401987e-001, 3.402032e-001, 3.402077e-001, 3.402122e-001, 3.402167e-001, 3.402212e-001, 3.402257e-001, 3.402302e-001, 3.402347e-001, 3.402392e-001, 3.402436e-001, 3.402481e-001, 3.402526e-001, 3.402571e-001, 3.402616e-001, 3.402661e-001, 3.402706e-001, 3.402751e-001, 3.402795e-001, 3.402840e-001, 3.402885e-001, 3.402930e-001, 3.402975e-001, 3.403020e-001, 3.403064e-001, 3.403109e-001, 3.403154e-001, 
3.403199e-001, 3.403244e-001, 3.403289e-001, 3.403333e-001, 3.403378e-001, 3.403423e-001, 3.403468e-001, 3.403513e-001, 3.403557e-001, 3.403602e-001, 3.403647e-001, 3.403692e-001, 3.403736e-001, 3.403781e-001, 3.403826e-001, 3.403871e-001, 3.403915e-001, 3.403960e-001, 3.404005e-001, 3.404050e-001, 3.404094e-001, 3.404139e-001, 3.404184e-001, 3.404229e-001, 3.404273e-001, 3.404318e-001, 3.404363e-001, 3.404407e-001, 3.404452e-001, 3.404497e-001, 3.404542e-001, 3.404586e-001, 3.404631e-001, 3.404676e-001, 3.404720e-001, 3.404765e-001, 3.404810e-001, 3.404854e-001, 3.404899e-001, 3.404944e-001, 3.404988e-001, 3.405033e-001, 3.405078e-001, 3.405122e-001, 3.405167e-001, 3.405211e-001, 3.405256e-001, 3.405301e-001, 3.405345e-001, 3.405390e-001, 3.405434e-001, 3.405479e-001, 3.405524e-001, 3.405568e-001, 3.405613e-001, 3.405657e-001, 3.405702e-001, 3.405747e-001, 3.405791e-001, 3.405836e-001, 3.405880e-001, 3.405925e-001, 3.405969e-001, 3.406014e-001, 3.406059e-001, 3.406103e-001, 3.406148e-001, 3.406192e-001, 3.406237e-001, 3.406281e-001, 3.406326e-001, 3.406370e-001, 3.406415e-001, 3.406459e-001, 3.406504e-001, 3.406548e-001, 3.406593e-001, 3.406637e-001, 3.406682e-001, 3.406726e-001, 3.406771e-001, 3.406815e-001, 3.406860e-001, 3.406904e-001, 3.406949e-001, 3.406993e-001, 3.407037e-001, 3.407082e-001, 3.407126e-001, 3.407171e-001, 3.407215e-001, 3.407260e-001, 3.407304e-001, 3.407349e-001, 3.407393e-001, 3.407437e-001, 3.407482e-001, 3.407526e-001, 3.407571e-001, 3.407615e-001, 
3.407659e-001, 3.407704e-001, 3.407748e-001, 3.407793e-001, 3.407837e-001, 3.407881e-001, 3.407926e-001, 3.407970e-001, 3.408014e-001, 3.408059e-001, 3.408103e-001, 3.408147e-001, 3.408192e-001, 3.408236e-001, 3.408280e-001, 3.408325e-001, 3.408369e-001, 3.408413e-001, 3.408458e-001, 3.408502e-001, 3.408546e-001, 3.408591e-001, 3.408635e-001, 3.408679e-001, 3.408724e-001, 3.408768e-001, 3.408812e-001, 3.408856e-001, 3.408901e-001, 3.408945e-001, 3.408989e-001, 3.409034e-001, 3.409078e-001, 3.409122e-001, 3.409166e-001, 3.409211e-001, 3.409255e-001, 3.409299e-001, 3.409343e-001, 3.409387e-001, 3.409432e-001, 3.409476e-001, 3.409520e-001, 3.409564e-001, 3.409609e-001, 3.409653e-001, 3.409697e-001, 3.409741e-001, 3.409785e-001, 3.409830e-001, 3.409874e-001, 3.409918e-001, 3.409962e-001, 3.410006e-001, 3.410050e-001, 3.410095e-001, 3.410139e-001, 3.410183e-001, 3.410227e-001, 3.410271e-001, 3.410315e-001, 3.410359e-001, 3.410404e-001, 3.410448e-001, 3.410492e-001, 3.410536e-001, 3.410580e-001, 3.410624e-001, 3.410668e-001, 3.410712e-001, 3.410756e-001, 3.410801e-001, 3.410845e-001, 3.410889e-001, 3.410933e-001, 3.410977e-001, 3.411021e-001, 3.411065e-001, 3.411109e-001, 3.411153e-001, 3.411197e-001, 3.411241e-001, 3.411285e-001, 3.411329e-001, 3.411373e-001, 3.411417e-001, 3.411461e-001, 3.411506e-001, 3.411550e-001, 3.411594e-001, 3.411638e-001, 3.411682e-001, 3.411726e-001, 3.411770e-001, 3.411814e-001, 3.411858e-001, 3.411902e-001, 3.411946e-001, 3.411990e-001, 3.412034e-001, 
3.412077e-001, 3.412121e-001, 3.412165e-001, 3.412209e-001, 3.412253e-001, 3.412297e-001, 3.412341e-001, 3.412385e-001, 3.412429e-001, 3.412473e-001, 3.412517e-001, 3.412561e-001, 3.412605e-001, 3.412649e-001, 3.412693e-001, 3.412737e-001, 3.412780e-001, 3.412824e-001, 3.412868e-001, 3.412912e-001, 3.412956e-001, 3.413000e-001, 3.413044e-001, 3.413088e-001, 3.413132e-001, 3.413175e-001, 3.413219e-001, 3.413263e-001, 3.413307e-001, 3.413351e-001, 3.413395e-001, 3.413439e-001, 3.413482e-001, 3.413526e-001, 3.413570e-001, 3.413614e-001, 3.413658e-001, 3.413701e-001, 3.413745e-001, 3.413789e-001, 3.413833e-001, 3.413877e-001, 3.413920e-001, 3.413964e-001, 3.414008e-001, 3.414052e-001, 3.414096e-001, 3.414139e-001, 3.414183e-001, 3.414227e-001, 3.414271e-001, 3.414314e-001, 3.414358e-001, 3.414402e-001, 3.414446e-001, 3.414489e-001, 3.414533e-001, 3.414577e-001, 3.414621e-001, 3.414664e-001, 3.414708e-001, 3.414752e-001, 3.414795e-001, 3.414839e-001, 3.414883e-001, 3.414927e-001, 3.414970e-001, 3.415014e-001, 3.415058e-001, 3.415101e-001, 3.415145e-001, 3.415189e-001, 3.415232e-001, 3.415276e-001, 3.415320e-001, 3.415363e-001, 3.415407e-001, 3.415451e-001, 3.415494e-001, 3.415538e-001, 3.415582e-001, 3.415625e-001, 3.415669e-001, 3.415712e-001, 3.415756e-001, 3.415800e-001, 3.415843e-001, 3.415887e-001, 3.415930e-001, 3.415974e-001, 3.416018e-001, 3.416061e-001, 3.416105e-001, 3.416148e-001, 3.416192e-001, 3.416236e-001, 3.416279e-001, 3.416323e-001, 3.416366e-001, 3.416410e-001, 
3.416453e-001, 3.416497e-001, 3.416540e-001, 3.416584e-001, 3.416628e-001, 3.416671e-001, 3.416715e-001, 3.416758e-001, 3.416802e-001, 3.416845e-001, 3.416889e-001, 3.416932e-001, 3.416976e-001, 3.417019e-001, 3.417063e-001, 3.417106e-001, 3.417150e-001, 3.417193e-001, 3.417237e-001, 3.417280e-001, 3.417323e-001, 3.417367e-001, 3.417410e-001, 3.417454e-001, 3.417497e-001, 3.417541e-001, 3.417584e-001, 3.417628e-001, 3.417671e-001, 3.417714e-001, 3.417758e-001, 3.417801e-001, 3.417845e-001, 3.417888e-001, 3.417932e-001, 3.417975e-001, 3.418018e-001, 3.418062e-001, 3.418105e-001, 3.418149e-001, 3.418192e-001, 3.418235e-001, 3.418279e-001, 3.418322e-001, 3.418365e-001, 3.418409e-001, 3.418452e-001, 3.418496e-001, 3.418539e-001, 3.418582e-001, 3.418626e-001, 3.418669e-001, 3.418712e-001, 3.418756e-001, 3.418799e-001, 3.418842e-001, 3.418885e-001, 3.418929e-001, 3.418972e-001, 3.419015e-001, 3.419059e-001, 3.419102e-001, 3.419145e-001, 3.419189e-001, 3.419232e-001, 3.419275e-001, 3.419318e-001, 3.419362e-001, 3.419405e-001, 3.419448e-001, 3.419491e-001, 3.419535e-001, 3.419578e-001, 3.419621e-001, 3.419664e-001, 3.419708e-001, 3.419751e-001, 3.419794e-001, 3.419837e-001, 3.419881e-001, 3.419924e-001, 3.419967e-001, 3.420010e-001, 3.420053e-001, 3.420097e-001, 3.420140e-001, 3.420183e-001, 3.420226e-001, 3.420269e-001, 3.420313e-001, 3.420356e-001, 3.420399e-001, 3.420442e-001, 3.420485e-001, 3.420528e-001, 3.420572e-001, 3.420615e-001, 3.420658e-001, 3.420701e-001, 3.420744e-001, 
3.420787e-001, 3.420830e-001, 3.420873e-001, 3.420917e-001, 3.420960e-001, 3.421003e-001, 3.421046e-001, 3.421089e-001, 3.421132e-001, 3.421175e-001, 3.421218e-001, 3.421261e-001, 3.421304e-001, 3.421348e-001, 3.421391e-001, 3.421434e-001, 3.421477e-001, 3.421520e-001, 3.421563e-001, 3.421606e-001, 3.421649e-001, 3.421692e-001, 3.421735e-001, 3.421778e-001, 3.421821e-001, 3.421864e-001, 3.421907e-001, 3.421950e-001, 3.421993e-001, 3.422036e-001, 3.422079e-001, 3.422122e-001, 3.422165e-001, 3.422208e-001, 3.422251e-001, 3.422294e-001, 3.422337e-001, 3.422380e-001, 3.422423e-001, 3.422466e-001, 3.422509e-001, 3.422552e-001, 3.422595e-001, 3.422638e-001, 3.422681e-001, 3.422724e-001, 3.422767e-001, 3.422810e-001, 3.422853e-001, 3.422896e-001, 3.422938e-001, 3.422981e-001, 3.423024e-001, 3.423067e-001, 3.423110e-001, 3.423153e-001, 3.423196e-001, 3.423239e-001, 3.423282e-001, 3.423325e-001, 3.423367e-001, 3.423410e-001, 3.423453e-001, 3.423496e-001, 3.423539e-001, 3.423582e-001, 3.423625e-001, 3.423667e-001, 3.423710e-001, 3.423753e-001, 3.423796e-001, 3.423839e-001, 3.423882e-001, 3.423925e-001, 3.423967e-001, 3.424010e-001, 3.424053e-001, 3.424096e-001, 3.424139e-001, 3.424181e-001, 3.424224e-001, 3.424267e-001, 3.424310e-001, 3.424353e-001, 3.424395e-001, 3.424438e-001, 3.424481e-001, 3.424524e-001, 3.424566e-001, 3.424609e-001, 3.424652e-001, 3.424695e-001, 3.424737e-001, 3.424780e-001, 3.424823e-001, 3.424866e-001, 3.424908e-001, 3.424951e-001, 3.424994e-001, 3.425037e-001, 
3.425079e-001, 3.425122e-001, 3.425165e-001, 3.425207e-001, 3.425250e-001, 3.425293e-001, 3.425335e-001, 3.425378e-001, 3.425421e-001, 3.425463e-001, 3.425506e-001, 3.425549e-001, 3.425591e-001, 3.425634e-001, 3.425677e-001, 3.425719e-001, 3.425762e-001, 3.425805e-001, 3.425847e-001, 3.425890e-001, 3.425933e-001, 3.425975e-001, 3.426018e-001, 3.426061e-001, 3.426103e-001, 3.426146e-001, 3.426188e-001, 3.426231e-001, 3.426274e-001, 3.426316e-001, 3.426359e-001, 3.426401e-001, 3.426444e-001, 3.426486e-001, 3.426529e-001, 3.426572e-001, 3.426614e-001, 3.426657e-001, 3.426699e-001, 3.426742e-001, 3.426784e-001, 3.426827e-001, 3.426869e-001, 3.426912e-001, 3.426955e-001, 3.426997e-001, 3.427040e-001, 3.427082e-001, 3.427125e-001, 3.427167e-001, 3.427210e-001, 3.427252e-001, 3.427295e-001, 3.427337e-001, 3.427380e-001, 3.427422e-001, 3.427465e-001, 3.427507e-001, 3.427550e-001, 3.427592e-001, 3.427634e-001, 3.427677e-001, 3.427719e-001, 3.427762e-001, 3.427804e-001, 3.427847e-001, 3.427889e-001, 3.427932e-001, 3.427974e-001, 3.428016e-001, 3.428059e-001, 3.428101e-001, 3.428144e-001, 3.428186e-001, 3.428229e-001, 3.428271e-001, 3.428313e-001, 3.428356e-001, 3.428398e-001, 3.428440e-001, 3.428483e-001, 3.428525e-001, 3.428568e-001, 3.428610e-001, 3.428652e-001, 3.428695e-001, 3.428737e-001, 3.428779e-001, 3.428822e-001, 3.428864e-001, 3.428906e-001, 3.428949e-001, 3.428991e-001, 3.429033e-001, 3.429076e-001, 3.429118e-001, 3.429160e-001, 3.429203e-001, 3.429245e-001, 3.429287e-001, 
3.429330e-001, 3.429372e-001, 3.429414e-001, 3.429456e-001, 3.429499e-001, 3.429541e-001, 3.429583e-001, 3.429626e-001, 3.429668e-001, 3.429710e-001, 3.429752e-001, 3.429795e-001, 3.429837e-001, 3.429879e-001, 3.429921e-001, 3.429964e-001, 3.430006e-001, 3.430048e-001, 3.430090e-001, 3.430132e-001, 3.430175e-001, 3.430217e-001, 3.430259e-001, 3.430301e-001, 3.430344e-001, 3.430386e-001, 3.430428e-001, 3.430470e-001, 3.430512e-001, 3.430554e-001, 3.430597e-001, 3.430639e-001, 3.430681e-001, 3.430723e-001, 3.430765e-001, 3.430807e-001, 3.430850e-001, 3.430892e-001, 3.430934e-001, 3.430976e-001, 3.431018e-001, 3.431060e-001, 3.431102e-001, 3.431144e-001, 3.431187e-001, 3.431229e-001, 3.431271e-001, 3.431313e-001, 3.431355e-001, 3.431397e-001, 3.431439e-001, 3.431481e-001, 3.431523e-001, 3.431565e-001, 3.431608e-001, 3.431650e-001, 3.431692e-001, 3.431734e-001, 3.431776e-001, 3.431818e-001, 3.431860e-001, 3.431902e-001, 3.431944e-001, 3.431986e-001, 3.432028e-001, 3.432070e-001, 3.432112e-001, 3.432154e-001, 3.432196e-001, 3.432238e-001, 3.432280e-001, 3.432322e-001, 3.432364e-001, 3.432406e-001, 3.432448e-001, 3.432490e-001, 3.432532e-001, 3.432574e-001, 3.432616e-001, 3.432658e-001, 3.432700e-001, 3.432742e-001, 3.432784e-001, 3.432826e-001, 3.432868e-001, 3.432910e-001, 3.432952e-001, 3.432994e-001, 3.433036e-001, 3.433078e-001, 3.433119e-001, 3.433161e-001, 3.433203e-001, 3.433245e-001, 3.433287e-001, 3.433329e-001, 3.433371e-001, 3.433413e-001, 3.433455e-001, 3.433497e-001, 
3.433538e-001, 3.433580e-001, 3.433622e-001, 3.433664e-001, 3.433706e-001, 3.433748e-001, 3.433790e-001, 3.433832e-001, 3.433873e-001, 3.433915e-001, 3.433957e-001, 3.433999e-001, 3.434041e-001, 3.434083e-001, 3.434124e-001, 3.434166e-001, 3.434208e-001, 3.434250e-001, 3.434292e-001, 3.434333e-001, 3.434375e-001, 3.434417e-001, 3.434459e-001, 3.434501e-001, 3.434542e-001, 3.434584e-001, 3.434626e-001, 3.434668e-001, 3.434710e-001, 3.434751e-001, 3.434793e-001, 3.434835e-001, 3.434877e-001, 3.434918e-001, 3.434960e-001, 3.435002e-001, 3.435044e-001, 3.435085e-001, 3.435127e-001, 3.435169e-001, 3.435210e-001, 3.435252e-001, 3.435294e-001, 3.435336e-001, 3.435377e-001, 3.435419e-001, 3.435461e-001, 3.435502e-001, 3.435544e-001, 3.435586e-001, 3.435627e-001, 3.435669e-001, 3.435711e-001, 3.435752e-001, 3.435794e-001, 3.435836e-001, 3.435877e-001, 3.435919e-001, 3.435961e-001, 3.436002e-001, 3.436044e-001, 3.436086e-001, 3.436127e-001, 3.436169e-001, 3.436210e-001, 3.436252e-001, 3.436294e-001, 3.436335e-001, 3.436377e-001, 3.436418e-001, 3.436460e-001, 3.436502e-001, 3.436543e-001, 3.436585e-001, 3.436626e-001, 3.436668e-001, 3.436710e-001, 3.436751e-001, 3.436793e-001, 3.436834e-001, 3.436876e-001, 3.436917e-001, 3.436959e-001, 3.437000e-001, 3.437042e-001, 3.437084e-001, 3.437125e-001, 3.437167e-001, 3.437208e-001, 3.437250e-001, 3.437291e-001, 3.437333e-001, 3.437374e-001, 3.437416e-001, 3.437457e-001, 3.437499e-001, 3.437540e-001, 3.437582e-001, 3.437623e-001, 3.437665e-001, 
3.437706e-001, 3.437747e-001, 3.437789e-001, 3.437830e-001, 3.437872e-001, 3.437913e-001, 3.437955e-001, 3.437996e-001, 3.438038e-001, 3.438079e-001, 3.438121e-001, 3.438162e-001, 3.438203e-001, 3.438245e-001, 3.438286e-001, 3.438328e-001, 3.438369e-001, 3.438410e-001, 3.438452e-001, 3.438493e-001, 3.438535e-001, 3.438576e-001, 3.438617e-001, 3.438659e-001, 3.438700e-001, 3.438741e-001, 3.438783e-001, 3.438824e-001, 3.438866e-001, 3.438907e-001, 3.438948e-001, 3.438990e-001, 3.439031e-001, 3.439072e-001, 3.439114e-001, 3.439155e-001, 3.439196e-001, 3.439238e-001, 3.439279e-001, 3.439320e-001, 3.439362e-001, 3.439403e-001, 3.439444e-001, 3.439485e-001, 3.439527e-001, 3.439568e-001, 3.439609e-001, 3.439651e-001, 3.439692e-001, 3.439733e-001, 3.439774e-001, 3.439816e-001, 3.439857e-001, 3.439898e-001, 3.439939e-001, 3.439981e-001, 3.440022e-001, 3.440063e-001, 3.440104e-001, 3.440146e-001, 3.440187e-001, 3.440228e-001, 3.440269e-001, 3.440310e-001, 3.440352e-001, 3.440393e-001, 3.440434e-001, 3.440475e-001, 3.440516e-001, 3.440558e-001, 3.440599e-001, 3.440640e-001, 3.440681e-001, 3.440722e-001, 3.440763e-001, 3.440805e-001, 3.440846e-001, 3.440887e-001, 3.440928e-001, 3.440969e-001, 3.441010e-001, 3.441052e-001, 3.441093e-001, 3.441134e-001, 3.441175e-001, 3.441216e-001, 3.441257e-001, 3.441298e-001, 3.441339e-001, 3.441381e-001, 3.441422e-001, 3.441463e-001, 3.441504e-001, 3.441545e-001, 3.441586e-001, 3.441627e-001, 3.441668e-001, 3.441709e-001, 3.441750e-001, 3.441791e-001, 
3.441832e-001, 3.441873e-001, 3.441915e-001, 3.441956e-001, 3.441997e-001, 3.442038e-001, 3.442079e-001, 3.442120e-001, 3.442161e-001, 3.442202e-001, 3.442243e-001, 3.442284e-001, 3.442325e-001, 3.442366e-001, 3.442407e-001, 3.442448e-001, 3.442489e-001, 3.442530e-001, 3.442571e-001, 3.442612e-001, 3.442653e-001, 3.442694e-001, 3.442735e-001, 3.442776e-001, 3.442817e-001, 3.442858e-001, 3.442899e-001, 3.442940e-001, 3.442980e-001, 3.443021e-001, 3.443062e-001, 3.443103e-001, 3.443144e-001, 3.443185e-001, 3.443226e-001, 3.443267e-001, 3.443308e-001, 3.443349e-001, 3.443390e-001, 3.443431e-001, 3.443471e-001, 3.443512e-001, 3.443553e-001, 3.443594e-001, 3.443635e-001, 3.443676e-001, 3.443717e-001, 3.443758e-001, 3.443799e-001, 3.443839e-001, 3.443880e-001, 3.443921e-001, 3.443962e-001, 3.444003e-001, 3.444044e-001, 3.444084e-001, 3.444125e-001, 3.444166e-001, 3.444207e-001, 3.444248e-001, 3.444289e-001, 3.444329e-001, 3.444370e-001, 3.444411e-001, 3.444452e-001, 3.444493e-001, 3.444533e-001, 3.444574e-001, 3.444615e-001, 3.444656e-001, 3.444696e-001, 3.444737e-001, 3.444778e-001, 3.444819e-001, 3.444860e-001, 3.444900e-001, 3.444941e-001, 3.444982e-001, 3.445023e-001, 3.445063e-001, 3.445104e-001, 3.445145e-001, 3.445185e-001, 3.445226e-001, 3.445267e-001, 3.445308e-001, 3.445348e-001, 3.445389e-001, 3.445430e-001, 3.445470e-001, 3.445511e-001, 3.445552e-001, 3.445592e-001, 3.445633e-001, 3.445674e-001, 3.445715e-001, 3.445755e-001, 3.445796e-001, 3.445837e-001, 3.445877e-001, 
3.445918e-001, 3.445958e-001, 3.445999e-001, 3.446040e-001, 3.446080e-001, 3.446121e-001, 3.446162e-001, 3.446202e-001, 3.446243e-001, 3.446283e-001, 3.446324e-001, 3.446365e-001, 3.446405e-001, 3.446446e-001, 3.446487e-001, 3.446527e-001, 3.446568e-001, 3.446608e-001, 3.446649e-001, 3.446689e-001, 3.446730e-001, 3.446771e-001, 3.446811e-001, 3.446852e-001, 3.446892e-001, 3.446933e-001, 3.446973e-001, 3.447014e-001, 3.447054e-001, 3.447095e-001, 3.447135e-001, 3.447176e-001, 3.447217e-001, 3.447257e-001, 3.447298e-001, 3.447338e-001, 3.447379e-001, 3.447419e-001, 3.447460e-001, 3.447500e-001, 3.447541e-001, 3.447581e-001, 3.447622e-001, 3.447662e-001, 3.447702e-001, 3.447743e-001, 3.447783e-001, 3.447824e-001, 3.447864e-001, 3.447905e-001, 3.447945e-001, 3.447986e-001, 3.448026e-001, 3.448067e-001, 3.448107e-001, 3.448147e-001, 3.448188e-001, 3.448228e-001, 3.448269e-001, 3.448309e-001, 3.448349e-001, 3.448390e-001, 3.448430e-001, 3.448471e-001, 3.448511e-001, 3.448551e-001, 3.448592e-001, 3.448632e-001, 3.448673e-001, 3.448713e-001, 3.448753e-001, 3.448794e-001, 3.448834e-001, 3.448874e-001, 3.448915e-001, 3.448955e-001, 3.448995e-001, 3.449036e-001, 3.449076e-001, 3.449116e-001, 3.449157e-001, 3.449197e-001, 3.449237e-001, 3.449278e-001, 3.449318e-001, 3.449358e-001, 3.449399e-001, 3.449439e-001, 3.449479e-001, 3.449519e-001, 3.449560e-001, 3.449600e-001, 3.449640e-001, 3.449681e-001, 3.449721e-001, 3.449761e-001, 3.449801e-001, 3.449842e-001, 3.449882e-001, 3.449922e-001, 
3.449962e-001, 3.450003e-001, 3.450043e-001, 3.450083e-001, 3.450123e-001, 3.450164e-001, 3.450204e-001, 3.450244e-001, 3.450284e-001, 3.450324e-001, 3.450365e-001, 3.450405e-001, 3.450445e-001, 3.450485e-001, 3.450525e-001, 3.450566e-001, 3.450606e-001, 3.450646e-001, 3.450686e-001, 3.450726e-001, 3.450766e-001, 3.450807e-001, 3.450847e-001, 3.450887e-001, 3.450927e-001, 3.450967e-001, 3.451007e-001, 3.451047e-001, 3.451088e-001, 3.451128e-001, 3.451168e-001, 3.451208e-001, 3.451248e-001, 3.451288e-001, 3.451328e-001, 3.451368e-001, 3.451409e-001, 3.451449e-001, 3.451489e-001, 3.451529e-001, 3.451569e-001, 3.451609e-001, 3.451649e-001, 3.451689e-001, 3.451729e-001, 3.451769e-001, 3.451809e-001, 3.451849e-001, 3.451889e-001, 3.451929e-001, 3.451969e-001, 3.452009e-001, 3.452050e-001, 3.452090e-001, 3.452130e-001, 3.452170e-001, 3.452210e-001, 3.452250e-001, 3.452290e-001, 3.452330e-001, 3.452370e-001, 3.452410e-001, 3.452450e-001, 3.452490e-001, 3.452530e-001, 3.452570e-001, 3.452610e-001, 3.452650e-001, 3.452689e-001, 3.452729e-001, 3.452769e-001, 3.452809e-001, 3.452849e-001, 3.452889e-001, 3.452929e-001, 3.452969e-001, 3.453009e-001, 3.453049e-001, 3.453089e-001, 3.453129e-001, 3.453169e-001, 3.453209e-001, 3.453249e-001, 3.453289e-001, 3.453328e-001, 3.453368e-001, 3.453408e-001, 3.453448e-001, 3.453488e-001, 3.453528e-001, 3.453568e-001, 3.453608e-001, 3.453648e-001, 3.453687e-001, 3.453727e-001, 3.453767e-001, 3.453807e-001, 3.453847e-001, 3.453887e-001, 3.453927e-001, 
3.453966e-001, 3.454006e-001, 3.454046e-001, 3.454086e-001, 3.454126e-001, 3.454165e-001, 3.454205e-001, 3.454245e-001, 3.454285e-001, 3.454325e-001, 3.454365e-001, 3.454404e-001, 3.454444e-001, 3.454484e-001, 3.454524e-001, 3.454563e-001, 3.454603e-001, 3.454643e-001, 3.454683e-001, 3.454723e-001, 3.454762e-001, 3.454802e-001, 3.454842e-001, 3.454882e-001, 3.454921e-001, 3.454961e-001, 3.455001e-001, 3.455040e-001, 3.455080e-001, 3.455120e-001, 3.455160e-001, 3.455199e-001, 3.455239e-001, 3.455279e-001, 3.455318e-001, 3.455358e-001, 3.455398e-001, 3.455438e-001, 3.455477e-001, 3.455517e-001, 3.455557e-001, 3.455596e-001, 3.455636e-001, 3.455676e-001, 3.455715e-001, 3.455755e-001, 3.455795e-001, 3.455834e-001, 3.455874e-001, 3.455913e-001, 3.455953e-001, 3.455993e-001, 3.456032e-001, 3.456072e-001, 3.456112e-001, 3.456151e-001, 3.456191e-001, 3.456230e-001, 3.456270e-001, 3.456310e-001, 3.456349e-001, 3.456389e-001, 3.456428e-001, 3.456468e-001, 3.456508e-001, 3.456547e-001, 3.456587e-001, 3.456626e-001, 3.456666e-001, 3.456705e-001, 3.456745e-001, 3.456785e-001, 3.456824e-001, 3.456864e-001, 3.456903e-001, 3.456943e-001, 3.456982e-001, 3.457022e-001, 3.457061e-001, 3.457101e-001, 3.457140e-001, 3.457180e-001, 3.457219e-001, 3.457259e-001, 3.457298e-001, 3.457338e-001, 3.457377e-001, 3.457417e-001, 3.457456e-001, 3.457496e-001, 3.457535e-001, 3.457575e-001, 3.457614e-001, 3.457654e-001, 3.457693e-001, 3.457733e-001, 3.457772e-001, 3.457811e-001, 3.457851e-001, 3.457890e-001, 
3.457930e-001, 3.457969e-001, 3.458009e-001, 3.458048e-001, 3.458087e-001, 3.458127e-001, 3.458166e-001, 3.458206e-001, 3.458245e-001, 3.458285e-001, 3.458324e-001, 3.458363e-001, 3.458403e-001, 3.458442e-001, 3.458481e-001, 3.458521e-001, 3.458560e-001, 3.458600e-001, 3.458639e-001, 3.458678e-001, 3.458718e-001, 3.458757e-001, 3.458796e-001, 3.458836e-001, 3.458875e-001, 3.458914e-001, 3.458954e-001, 3.458993e-001, 3.459032e-001, 3.459072e-001, 3.459111e-001, 3.459150e-001, 3.459190e-001, 3.459229e-001, 3.459268e-001, 3.459307e-001, 3.459347e-001, 3.459386e-001, 3.459425e-001, 3.459465e-001, 3.459504e-001, 3.459543e-001, 3.459582e-001, 3.459622e-001, 3.459661e-001, 3.459700e-001, 3.459739e-001, 3.459779e-001, 3.459818e-001, 3.459857e-001, 3.459896e-001, 3.459936e-001, 3.459975e-001, 3.460014e-001, 3.460053e-001, 3.460093e-001, 3.460132e-001, 3.460171e-001, 3.460210e-001, 3.460249e-001, 3.460289e-001, 3.460328e-001, 3.460367e-001, 3.460406e-001, 3.460445e-001, 3.460484e-001, 3.460524e-001, 3.460563e-001, 3.460602e-001, 3.460641e-001, 3.460680e-001, 3.460719e-001, 3.460759e-001, 3.460798e-001, 3.460837e-001, 3.460876e-001, 3.460915e-001, 3.460954e-001, 3.460993e-001, 3.461032e-001, 3.461072e-001, 3.461111e-001, 3.461150e-001, 3.461189e-001, 3.461228e-001, 3.461267e-001, 3.461306e-001, 3.461345e-001, 3.461384e-001, 3.461423e-001, 3.461462e-001, 3.461501e-001, 3.461541e-001, 3.461580e-001, 3.461619e-001, 3.461658e-001, 3.461697e-001, 3.461736e-001, 3.461775e-001, 3.461814e-001, 
3.461853e-001, 3.461892e-001, 3.461931e-001, 3.461970e-001, 3.462009e-001, 3.462048e-001, 3.462087e-001, 3.462126e-001, 3.462165e-001, 3.462204e-001, 3.462243e-001, 3.462282e-001, 3.462321e-001, 3.462360e-001, 3.462399e-001, 3.462438e-001, 3.462477e-001, 3.462516e-001, 3.462555e-001, 3.462594e-001, 3.462633e-001, 3.462672e-001, 3.462711e-001, 3.462750e-001, 3.462789e-001, 3.462827e-001, 3.462866e-001, 3.462905e-001, 3.462944e-001, 3.462983e-001, 3.463022e-001, 3.463061e-001, 3.463100e-001, 3.463139e-001, 3.463178e-001, 3.463217e-001, 3.463255e-001, 3.463294e-001, 3.463333e-001, 3.463372e-001, 3.463411e-001, 3.463450e-001, 3.463489e-001, 3.463528e-001, 3.463566e-001, 3.463605e-001, 3.463644e-001, 3.463683e-001, 3.463722e-001, 3.463761e-001, 3.463799e-001, 3.463838e-001, 3.463877e-001, 3.463916e-001, 3.463955e-001, 3.463994e-001, 3.464032e-001, 3.464071e-001, 3.464110e-001, 3.464149e-001, 3.464188e-001, 3.464226e-001, 3.464265e-001, 3.464304e-001, 3.464343e-001, 3.464381e-001, 3.464420e-001, 3.464459e-001, 3.464498e-001, 3.464536e-001, 3.464575e-001, 3.464614e-001, 3.464653e-001, 3.464691e-001, 3.464730e-001, 3.464769e-001, 3.464808e-001, 3.464846e-001, 3.464885e-001, 3.464924e-001, 3.464963e-001, 3.465001e-001, 3.465040e-001, 3.465079e-001, 3.465117e-001, 3.465156e-001, 3.465195e-001, 3.465233e-001, 3.465272e-001, 3.465311e-001, 3.465349e-001, 3.465388e-001, 3.465427e-001, 3.465465e-001, 3.465504e-001, 3.465543e-001, 3.465581e-001, 3.465620e-001, 3.465659e-001, 3.465697e-001, 
3.465736e-001, 3.465775e-001, 3.465813e-001, 3.465852e-001, 3.465890e-001, 3.465929e-001, 3.465968e-001, 3.466006e-001, 3.466045e-001, 3.466083e-001, 3.466122e-001, 3.466161e-001, 3.466199e-001, 3.466238e-001, 3.466276e-001, 3.466315e-001, 3.466353e-001, 3.466392e-001, 3.466431e-001, 3.466469e-001, 3.466508e-001, 3.466546e-001, 3.466585e-001, 3.466623e-001, 3.466662e-001, 3.466700e-001, 3.466739e-001, 3.466777e-001, 3.466816e-001, 3.466854e-001, 3.466893e-001, 3.466931e-001, 3.466970e-001, 3.467008e-001, 3.467047e-001, 3.467085e-001, 3.467124e-001, 3.467162e-001, 3.467201e-001, 3.467239e-001, 3.467278e-001, 3.467316e-001, 3.467355e-001, 3.467393e-001, 3.467432e-001, 3.467470e-001, 3.467509e-001, 3.467547e-001, 3.467586e-001, 3.467624e-001, 3.467662e-001, 3.467701e-001, 3.467739e-001, 3.467778e-001, 3.467816e-001, 3.467854e-001, 3.467893e-001, 3.467931e-001, 3.467970e-001, 3.468008e-001, 3.468046e-001, 3.468085e-001, 3.468123e-001, 3.468162e-001, 3.468200e-001, 3.468238e-001, 3.468277e-001, 3.468315e-001, 3.468353e-001, 3.468392e-001, 3.468430e-001, 3.468469e-001, 3.468507e-001, 3.468545e-001, 3.468584e-001, 3.468622e-001, 3.468660e-001, 3.468699e-001, 3.468737e-001, 3.468775e-001, 3.468813e-001, 3.468852e-001, 3.468890e-001, 3.468928e-001, 3.468967e-001, 3.469005e-001, 3.469043e-001, 3.469082e-001, 3.469120e-001, 3.469158e-001, 3.469196e-001, 3.469235e-001, 3.469273e-001, 3.469311e-001, 3.469349e-001, 3.469388e-001, 3.469426e-001, 3.469464e-001, 3.469502e-001, 3.469541e-001, 
3.469579e-001, 3.469617e-001, 3.469655e-001, 3.469694e-001, 3.469732e-001, 3.469770e-001, 3.469808e-001, 3.469846e-001, 3.469885e-001, 3.469923e-001, 3.469961e-001, 3.469999e-001, 3.470037e-001, 3.470076e-001, 3.470114e-001, 3.470152e-001, 3.470190e-001, 3.470228e-001, 3.470266e-001, 3.470305e-001, 3.470343e-001, 3.470381e-001, 3.470419e-001, 3.470457e-001, 3.470495e-001, 3.470533e-001, 3.470572e-001, 3.470610e-001, 3.470648e-001, 3.470686e-001, 3.470724e-001, 3.470762e-001, 3.470800e-001, 3.470838e-001, 3.470876e-001, 3.470914e-001, 3.470953e-001, 3.470991e-001, 3.471029e-001, 3.471067e-001, 3.471105e-001, 3.471143e-001, 3.471181e-001, 3.471219e-001, 3.471257e-001, 3.471295e-001, 3.471333e-001, 3.471371e-001, 3.471409e-001, 3.471447e-001, 3.471485e-001, 3.471523e-001, 3.471561e-001, 3.471599e-001, 3.471638e-001, 3.471676e-001, 3.471714e-001, 3.471752e-001, 3.471790e-001, 3.471828e-001, 3.471866e-001, 3.471904e-001, 3.471941e-001, 3.471979e-001, 3.472017e-001, 3.472055e-001, 3.472093e-001, 3.472131e-001, 3.472169e-001, 3.472207e-001, 3.472245e-001, 3.472283e-001, 3.472321e-001, 3.472359e-001, 3.472397e-001, 3.472435e-001, 3.472473e-001, 3.472511e-001, 3.472549e-001, 3.472587e-001, 3.472625e-001, 3.472662e-001, 3.472700e-001, 3.472738e-001, 3.472776e-001, 3.472814e-001, 3.472852e-001, 3.472890e-001, 3.472928e-001, 3.472966e-001, 3.473003e-001, 3.473041e-001, 3.473079e-001, 3.473117e-001, 3.473155e-001, 3.473193e-001, 3.473231e-001, 3.473268e-001, 3.473306e-001, 3.473344e-001, 
3.473382e-001, 3.473420e-001, 3.473458e-001, 3.473495e-001, 3.473533e-001, 3.473571e-001, 3.473609e-001, 3.473647e-001, 3.473685e-001, 3.473722e-001, 3.473760e-001, 3.473798e-001, 3.473836e-001, 3.473873e-001, 3.473911e-001, 3.473949e-001, 3.473987e-001, 3.474025e-001, 3.474062e-001, 3.474100e-001, 3.474138e-001, 3.474176e-001, 3.474213e-001, 3.474251e-001, 3.474289e-001, 3.474327e-001, 3.474364e-001, 3.474402e-001, 3.474440e-001, 3.474477e-001, 3.474515e-001, 3.474553e-001, 3.474591e-001, 3.474628e-001, 3.474666e-001, 3.474704e-001, 3.474741e-001, 3.474779e-001, 3.474817e-001, 3.474854e-001, 3.474892e-001, 3.474930e-001, 3.474967e-001, 3.475005e-001, 3.475043e-001, 3.475080e-001, 3.475118e-001, 3.475156e-001, 3.475193e-001, 3.475231e-001, 3.475269e-001, 3.475306e-001, 3.475344e-001, 3.475382e-001, 3.475419e-001, 3.475457e-001, 3.475494e-001, 3.475532e-001, 3.475570e-001, 3.475607e-001, 3.475645e-001, 3.475682e-001, 3.475720e-001, 3.475758e-001, 3.475795e-001, 3.475833e-001, 3.475870e-001, 3.475908e-001, 3.475945e-001, 3.475983e-001, 3.476021e-001, 3.476058e-001, 3.476096e-001, 3.476133e-001, 3.476171e-001, 3.476208e-001, 3.476246e-001, 3.476283e-001, 3.476321e-001, 3.476358e-001, 3.476396e-001, 3.476433e-001, 3.476471e-001, 3.476508e-001, 3.476546e-001, 3.476583e-001, 3.476621e-001, 3.476658e-001, 3.476696e-001, 3.476733e-001, 3.476771e-001, 3.476808e-001, 3.476846e-001, 3.476883e-001, 3.476921e-001, 3.476958e-001, 3.476996e-001, 3.477033e-001, 3.477071e-001, 3.477108e-001, 
3.477145e-001, 3.477183e-001, 3.477220e-001, 3.477258e-001, 3.477295e-001, 3.477333e-001, 3.477370e-001, 3.477407e-001, 3.477445e-001, 3.477482e-001, 3.477520e-001, 3.477557e-001, 3.477594e-001, 3.477632e-001, 3.477669e-001, 3.477707e-001, 3.477744e-001, 3.477781e-001, 3.477819e-001, 3.477856e-001, 3.477893e-001, 3.477931e-001, 3.477968e-001, 3.478005e-001, 3.478043e-001, 3.478080e-001, 3.478117e-001, 3.478155e-001, 3.478192e-001, 3.478229e-001, 3.478267e-001, 3.478304e-001, 3.478341e-001, 3.478379e-001, 3.478416e-001, 3.478453e-001, 3.478491e-001, 3.478528e-001, 3.478565e-001, 3.478602e-001, 3.478640e-001, 3.478677e-001, 3.478714e-001, 3.478752e-001, 3.478789e-001, 3.478826e-001, 3.478863e-001, 3.478901e-001, 3.478938e-001, 3.478975e-001, 3.479012e-001, 3.479050e-001, 3.479087e-001, 3.479124e-001, 3.479161e-001, 3.479198e-001, 3.479236e-001, 3.479273e-001, 3.479310e-001, 3.479347e-001, 3.479385e-001, 3.479422e-001, 3.479459e-001, 3.479496e-001, 3.479533e-001, 3.479570e-001, 3.479608e-001, 3.479645e-001, 3.479682e-001, 3.479719e-001, 3.479756e-001, 3.479793e-001, 3.479831e-001, 3.479868e-001, 3.479905e-001, 3.479942e-001, 3.479979e-001, 3.480016e-001, 3.480053e-001, 3.480091e-001, 3.480128e-001, 3.480165e-001, 3.480202e-001, 3.480239e-001, 3.480276e-001, 3.480313e-001, 3.480350e-001, 3.480387e-001, 3.480425e-001, 3.480462e-001, 3.480499e-001, 3.480536e-001, 3.480573e-001, 3.480610e-001, 3.480647e-001, 3.480684e-001, 3.480721e-001, 3.480758e-001, 3.480795e-001, 3.480832e-001, 
3.480869e-001, 3.480906e-001, 3.480943e-001, 3.480980e-001, 3.481018e-001, 3.481055e-001, 3.481092e-001, 3.481129e-001, 3.481166e-001, 3.481203e-001, 3.481240e-001, 3.481277e-001, 3.481314e-001, 3.481351e-001, 3.481388e-001, 3.481425e-001, 3.481462e-001, 3.481499e-001, 3.481535e-001, 3.481572e-001, 3.481609e-001, 3.481646e-001, 3.481683e-001, 3.481720e-001, 3.481757e-001, 3.481794e-001, 3.481831e-001, 3.481868e-001, 3.481905e-001, 3.481942e-001, 3.481979e-001, 3.482016e-001, 3.482053e-001, 3.482090e-001, 3.482127e-001, 3.482163e-001, 3.482200e-001, 3.482237e-001, 3.482274e-001, 3.482311e-001, 3.482348e-001, 3.482385e-001, 3.482422e-001, 3.482459e-001, 3.482495e-001, 3.482532e-001, 3.482569e-001, 3.482606e-001, 3.482643e-001, 3.482680e-001, 3.482717e-001, 3.482753e-001, 3.482790e-001, 3.482827e-001, 3.482864e-001, 3.482901e-001, 3.482938e-001, 3.482974e-001, 3.483011e-001, 3.483048e-001, 3.483085e-001, 3.483122e-001, 3.483158e-001, 3.483195e-001, 3.483232e-001, 3.483269e-001, 3.483306e-001, 3.483342e-001, 3.483379e-001, 3.483416e-001, 3.483453e-001, 3.483489e-001, 3.483526e-001, 3.483563e-001, 3.483600e-001, 3.483636e-001, 3.483673e-001, 3.483710e-001, 3.483747e-001, 3.483783e-001, 3.483820e-001, 3.483857e-001, 3.483894e-001, 3.483930e-001, 3.483967e-001, 3.484004e-001, 3.484040e-001, 3.484077e-001, 3.484114e-001, 3.484151e-001, 3.484187e-001, 3.484224e-001, 3.484261e-001, 3.484297e-001, 3.484334e-001, 3.484371e-001, 3.484407e-001, 3.484444e-001, 3.484481e-001, 3.484517e-001, 
3.484554e-001, 3.484591e-001, 3.484627e-001, 3.484664e-001, 3.484700e-001, 3.484737e-001, 3.484774e-001, 3.484810e-001, 3.484847e-001, 3.484884e-001, 3.484920e-001, 3.484957e-001, 3.484993e-001, 3.485030e-001, 3.485067e-001, 3.485103e-001, 3.485140e-001, 3.485176e-001, 3.485213e-001, 3.485250e-001, 3.485286e-001, 3.485323e-001, 3.485359e-001, 3.485396e-001, 3.485432e-001, 3.485469e-001, 3.485505e-001, 3.485542e-001, 3.485579e-001, 3.485615e-001, 3.485652e-001, 3.485688e-001, 3.485725e-001, 3.485761e-001, 3.485798e-001, 3.485834e-001, 3.485871e-001, 3.485907e-001, 3.485944e-001, 3.485980e-001, 3.486017e-001, 3.486053e-001, 3.486090e-001, 3.486126e-001, 3.486163e-001, 3.486199e-001, 3.486236e-001, 3.486272e-001, 3.486309e-001, 3.486345e-001, 3.486381e-001, 3.486418e-001, 3.486454e-001, 3.486491e-001, 3.486527e-001, 3.486564e-001, 3.486600e-001, 3.486637e-001, 3.486673e-001, 3.486709e-001, 3.486746e-001, 3.486782e-001, 3.486819e-001, 3.486855e-001, 3.486891e-001, 3.486928e-001, 3.486964e-001, 3.487001e-001, 3.487037e-001, 3.487073e-001, 3.487110e-001, 3.487146e-001, 3.487183e-001, 3.487219e-001, 3.487255e-001, 3.487292e-001, 3.487328e-001, 3.487364e-001, 3.487401e-001, 3.487437e-001, 3.487473e-001, 3.487510e-001, 3.487546e-001, 3.487582e-001, 3.487619e-001, 3.487655e-001, 3.487691e-001, 3.487728e-001, 3.487764e-001, 3.487800e-001, 3.487836e-001, 3.487873e-001, 3.487909e-001, 3.487945e-001, 3.487982e-001, 3.488018e-001, 3.488054e-001, 3.488090e-001, 3.488127e-001, 3.488163e-001, 
3.488199e-001, 3.488236e-001, 3.488272e-001, 3.488308e-001, 3.488344e-001, 3.488380e-001, 3.488417e-001, 3.488453e-001, 3.488489e-001, 3.488525e-001, 3.488562e-001, 3.488598e-001, 3.488634e-001, 3.488670e-001, 3.488706e-001, 3.488743e-001, 3.488779e-001, 3.488815e-001, 3.488851e-001, 3.488887e-001, 3.488924e-001, 3.488960e-001, 3.488996e-001, 3.489032e-001, 3.489068e-001, 3.489104e-001, 3.489141e-001, 3.489177e-001, 3.489213e-001, 3.489249e-001, 3.489285e-001, 3.489321e-001, 3.489358e-001, 3.489394e-001, 3.489430e-001, 3.489466e-001, 3.489502e-001, 3.489538e-001, 3.489574e-001, 3.489610e-001, 3.489646e-001, 3.489683e-001, 3.489719e-001, 3.489755e-001, 3.489791e-001, 3.489827e-001, 3.489863e-001, 3.489899e-001, 3.489935e-001, 3.489971e-001, 3.490007e-001, 3.490043e-001, 3.490079e-001, 3.490115e-001, 3.490151e-001, 3.490188e-001, 3.490224e-001, 3.490260e-001, 3.490296e-001, 3.490332e-001, 3.490368e-001, 3.490404e-001, 3.490440e-001, 3.490476e-001, 3.490512e-001, 3.490548e-001, 3.490584e-001, 3.490620e-001, 3.490656e-001, 3.490692e-001, 3.490728e-001, 3.490764e-001, 3.490800e-001, 3.490836e-001, 3.490872e-001, 3.490908e-001, 3.490944e-001, 3.490980e-001, 3.491015e-001, 3.491051e-001, 3.491087e-001, 3.491123e-001, 3.491159e-001, 3.491195e-001, 3.491231e-001, 3.491267e-001, 3.491303e-001, 3.491339e-001, 3.491375e-001, 3.491411e-001, 3.491447e-001, 3.491483e-001, 3.491518e-001, 3.491554e-001, 3.491590e-001, 3.491626e-001, 3.491662e-001, 3.491698e-001, 3.491734e-001, 3.491770e-001, 
3.491806e-001, 3.491841e-001, 3.491877e-001, 3.491913e-001, 3.491949e-001, 3.491985e-001, 3.492021e-001, 3.492057e-001, 3.492092e-001, 3.492128e-001, 3.492164e-001, 3.492200e-001, 3.492236e-001, 3.492271e-001, 3.492307e-001, 3.492343e-001, 3.492379e-001, 3.492415e-001, 3.492451e-001, 3.492486e-001, 3.492522e-001, 3.492558e-001, 3.492594e-001, 3.492629e-001, 3.492665e-001, 3.492701e-001, 3.492737e-001, 3.492773e-001, 3.492808e-001, 3.492844e-001, 3.492880e-001, 3.492916e-001, 3.492951e-001, 3.492987e-001, 3.493023e-001, 3.493059e-001, 3.493094e-001, 3.493130e-001, 3.493166e-001, 3.493201e-001, 3.493237e-001, 3.493273e-001, 3.493309e-001, 3.493344e-001, 3.493380e-001, 3.493416e-001, 3.493451e-001, 3.493487e-001, 3.493523e-001, 3.493558e-001, 3.493594e-001, 3.493630e-001, 3.493665e-001, 3.493701e-001, 3.493737e-001, 3.493772e-001, 3.493808e-001, 3.493844e-001, 3.493879e-001, 3.493915e-001, 3.493951e-001, 3.493986e-001, 3.494022e-001, 3.494057e-001, 3.494093e-001, 3.494129e-001, 3.494164e-001, 3.494200e-001, 3.494236e-001, 3.494271e-001, 3.494307e-001, 3.494342e-001, 3.494378e-001, 3.494414e-001, 3.494449e-001, 3.494485e-001, 3.494520e-001, 3.494556e-001, 3.494591e-001, 3.494627e-001, 3.494663e-001, 3.494698e-001, 3.494734e-001, 3.494769e-001, 3.494805e-001, 3.494840e-001, 3.494876e-001, 3.494911e-001, 3.494947e-001, 3.494982e-001, 3.495018e-001, 3.495053e-001, 3.495089e-001, 3.495124e-001, 3.495160e-001, 3.495195e-001, 3.495231e-001, 3.495266e-001, 3.495302e-001, 3.495337e-001, 
3.495373e-001, 3.495408e-001, 3.495444e-001, 3.495479e-001, 3.495515e-001, 3.495550e-001, 3.495586e-001, 3.495621e-001, 3.495657e-001, 3.495692e-001, 3.495727e-001, 3.495763e-001, 3.495798e-001, 3.495834e-001, 3.495869e-001, 3.495905e-001, 3.495940e-001, 3.495975e-001, 3.496011e-001, 3.496046e-001, 3.496082e-001, 3.496117e-001, 3.496153e-001, 3.496188e-001, 3.496223e-001, 3.496259e-001, 3.496294e-001, 3.496329e-001, 3.496365e-001, 3.496400e-001, 3.496436e-001, 3.496471e-001, 3.496506e-001, 3.496542e-001, 3.496577e-001, 3.496612e-001, 3.496648e-001, 3.496683e-001, 3.496718e-001, 3.496754e-001, 3.496789e-001, 3.496824e-001, 3.496860e-001, 3.496895e-001, 3.496930e-001, 3.496966e-001, 3.497001e-001, 3.497036e-001, 3.497071e-001, 3.497107e-001, 3.497142e-001, 3.497177e-001, 3.497213e-001, 3.497248e-001, 3.497283e-001, 3.497318e-001, 3.497354e-001, 3.497389e-001, 3.497424e-001, 3.497459e-001, 3.497495e-001, 3.497530e-001, 3.497565e-001, 3.497600e-001, 3.497636e-001, 3.497671e-001, 3.497706e-001, 3.497741e-001, 3.497777e-001, 3.497812e-001, 3.497847e-001, 3.497882e-001, 3.497917e-001, 3.497953e-001, 3.497988e-001, 3.498023e-001, 3.498058e-001, 3.498093e-001, 3.498129e-001, 3.498164e-001, 3.498199e-001, 3.498234e-001, 3.498269e-001, 3.498304e-001, 3.498340e-001, 3.498375e-001, 3.498410e-001, 3.498445e-001, 3.498480e-001, 3.498515e-001, 3.498550e-001, 3.498586e-001, 3.498621e-001, 3.498656e-001, 3.498691e-001, 3.498726e-001, 3.498761e-001, 3.498796e-001, 3.498831e-001, 3.498866e-001, 
3.498901e-001, 3.498937e-001, 3.498972e-001, 3.499007e-001, 3.499042e-001, 3.499077e-001, 3.499112e-001, 3.499147e-001, 3.499182e-001, 3.499217e-001, 3.499252e-001, 3.499287e-001, 3.499322e-001, 3.499357e-001, 3.499392e-001, 3.499427e-001, 3.499462e-001, 3.499498e-001, 3.499533e-001, 3.499568e-001, 3.499603e-001, 3.499638e-001, 3.499673e-001, 3.499708e-001, 3.499743e-001, 3.499778e-001, 3.499813e-001, 3.499848e-001, 3.499883e-001, 3.499918e-001, 3.499953e-001, 3.499988e-001, 3.500022e-001, 3.500057e-001, 3.500092e-001, 3.500127e-001, 3.500162e-001, 3.500197e-001, 3.500232e-001, 3.500267e-001, 3.500302e-001, 3.500337e-001, 3.500372e-001, 3.500407e-001, 3.500442e-001, 3.500477e-001, 3.500512e-001, 3.500547e-001, 3.500581e-001, 3.500616e-001, 3.500651e-001, 3.500686e-001, 3.500721e-001, 3.500756e-001, 3.500791e-001, 3.500826e-001, 3.500861e-001, 3.500896e-001, 3.500930e-001, 3.500965e-001, 3.501000e-001, 3.501035e-001, 3.501070e-001, 3.501105e-001, 3.501140e-001, 3.501174e-001, 3.501209e-001, 3.501244e-001, 3.501279e-001, 3.501314e-001, 3.501349e-001, 3.501383e-001, 3.501418e-001, 3.501453e-001, 3.501488e-001, 3.501523e-001, 3.501557e-001, 3.501592e-001, 3.501627e-001, 3.501662e-001, 3.501697e-001, 3.501731e-001, 3.501766e-001, 3.501801e-001, 3.501836e-001, 3.501870e-001, 3.501905e-001, 3.501940e-001, 3.501975e-001, 3.502009e-001, 3.502044e-001, 3.502079e-001, 3.502114e-001, 3.502148e-001, 3.502183e-001, 3.502218e-001, 3.502253e-001, 3.502287e-001, 3.502322e-001, 3.502357e-001, 
3.502391e-001, 3.502426e-001, 3.502461e-001, 3.502496e-001, 3.502530e-001, 3.502565e-001, 3.502600e-001, 3.502634e-001, 3.502669e-001, 3.502704e-001, 3.502738e-001, 3.502773e-001, 3.502808e-001, 3.502842e-001, 3.502877e-001, 3.502912e-001, 3.502946e-001, 3.502981e-001, 3.503016e-001, 3.503050e-001, 3.503085e-001, 3.503119e-001, 3.503154e-001, 3.503189e-001, 3.503223e-001, 3.503258e-001, 3.503293e-001, 3.503327e-001, 3.503362e-001, 3.503396e-001, 3.503431e-001, 3.503466e-001, 3.503500e-001, 3.503535e-001, 3.503569e-001, 3.503604e-001, 3.503638e-001, 3.503673e-001, 3.503708e-001, 3.503742e-001, 3.503777e-001, 3.503811e-001, 3.503846e-001, 3.503880e-001, 3.503915e-001, 3.503949e-001, 3.503984e-001, 3.504018e-001, 3.504053e-001, 3.504088e-001, 3.504122e-001, 3.504157e-001, 3.504191e-001, 3.504226e-001, 3.504260e-001, 3.504295e-001, 3.504329e-001, 3.504364e-001, 3.504398e-001, 3.504433e-001, 3.504467e-001, 3.504501e-001, 3.504536e-001, 3.504570e-001, 3.504605e-001, 3.504639e-001, 3.504674e-001, 3.504708e-001, 3.504743e-001, 3.504777e-001, 3.504812e-001, 3.504846e-001, 3.504880e-001, 3.504915e-001, 3.504949e-001, 3.504984e-001, 3.505018e-001, 3.505053e-001, 3.505087e-001, 3.505121e-001, 3.505156e-001, 3.505190e-001, 3.505225e-001, 3.505259e-001, 3.505293e-001, 3.505328e-001, 3.505362e-001, 3.505396e-001, 3.505431e-001, 3.505465e-001, 3.505500e-001, 3.505534e-001, 3.505568e-001, 3.505603e-001, 3.505637e-001, 3.505671e-001, 3.505706e-001, 3.505740e-001, 3.505774e-001, 3.505809e-001, 
3.505843e-001, 3.505877e-001, 3.505912e-001, 3.505946e-001, 3.505980e-001, 3.506015e-001, 3.506049e-001, 3.506083e-001, 3.506117e-001, 3.506152e-001, 3.506186e-001, 3.506220e-001, 3.506255e-001, 3.506289e-001, 3.506323e-001, 3.506357e-001, 3.506392e-001, 3.506426e-001, 3.506460e-001, 3.506494e-001, 3.506529e-001, 3.506563e-001, 3.506597e-001, 3.506631e-001, 3.506666e-001, 3.506700e-001, 3.506734e-001, 3.506768e-001, 3.506803e-001, 3.506837e-001, 3.506871e-001, 3.506905e-001, 3.506939e-001, 3.506974e-001, 3.507008e-001, 3.507042e-001, 3.507076e-001, 3.507110e-001, 3.507145e-001, 3.507179e-001, 3.507213e-001, 3.507247e-001, 3.507281e-001, 3.507315e-001, 3.507350e-001, 3.507384e-001, 3.507418e-001, 3.507452e-001, 3.507486e-001, 3.507520e-001, 3.507554e-001, 3.507589e-001, 3.507623e-001, 3.507657e-001, 3.507691e-001, 3.507725e-001, 3.507759e-001, 3.507793e-001, 3.507827e-001, 3.507861e-001, 3.507896e-001, 3.507930e-001, 3.507964e-001, 3.507998e-001, 3.508032e-001, 3.508066e-001, 3.508100e-001, 3.508134e-001, 3.508168e-001, 3.508202e-001, 3.508236e-001, 3.508270e-001, 3.508304e-001, 3.508338e-001, 3.508372e-001, 3.508407e-001, 3.508441e-001, 3.508475e-001, 3.508509e-001, 3.508543e-001, 3.508577e-001, 3.508611e-001, 3.508645e-001, 3.508679e-001, 3.508713e-001, 3.508747e-001, 3.508781e-001, 3.508815e-001, 3.508849e-001, 3.508883e-001, 3.508917e-001, 3.508951e-001, 3.508985e-001, 3.509019e-001, 3.509053e-001, 3.509086e-001, 3.509120e-001, 3.509154e-001, 3.509188e-001, 3.509222e-001, 
3.509256e-001, 3.509290e-001, 3.509324e-001, 3.509358e-001, 3.509392e-001, 3.509426e-001, 3.509460e-001, 3.509494e-001, 3.509528e-001, 3.509562e-001, 3.509595e-001, 3.509629e-001, 3.509663e-001, 3.509697e-001, 3.509731e-001, 3.509765e-001, 3.509799e-001, 3.509833e-001, 3.509867e-001, 3.509900e-001, 3.509934e-001, 3.509968e-001, 3.510002e-001, 3.510036e-001, 3.510070e-001, 3.510104e-001, 3.510137e-001, 3.510171e-001, 3.510205e-001, 3.510239e-001, 3.510273e-001, 3.510307e-001, 3.510340e-001, 3.510374e-001, 3.510408e-001, 3.510442e-001, 3.510476e-001, 3.510509e-001, 3.510543e-001, 3.510577e-001, 3.510611e-001, 3.510645e-001, 3.510678e-001, 3.510712e-001, 3.510746e-001, 3.510780e-001, 3.510813e-001, 3.510847e-001, 3.510881e-001, 3.510915e-001, 3.510949e-001, 3.510982e-001, 3.511016e-001, 3.511050e-001, 3.511083e-001, 3.511117e-001, 3.511151e-001, 3.511185e-001, 3.511218e-001, 3.511252e-001, 3.511286e-001, 3.511320e-001, 3.511353e-001, 3.511387e-001, 3.511421e-001, 3.511454e-001, 3.511488e-001, 3.511522e-001, 3.511555e-001, 3.511589e-001, 3.511623e-001, 3.511656e-001, 3.511690e-001, 3.511724e-001, 3.511757e-001, 3.511791e-001, 3.511825e-001, 3.511858e-001, 3.511892e-001, 3.511926e-001, 3.511959e-001, 3.511993e-001, 3.512027e-001, 3.512060e-001, 3.512094e-001, 3.512127e-001, 3.512161e-001, 3.512195e-001, 3.512228e-001, 3.512262e-001, 3.512295e-001, 3.512329e-001, 3.512363e-001, 3.512396e-001, 3.512430e-001, 3.512463e-001, 3.512497e-001, 3.512531e-001, 3.512564e-001, 3.512598e-001, 
3.512631e-001, 3.512665e-001, 3.512698e-001, 3.512732e-001, 3.512765e-001, 3.512799e-001, 3.512833e-001, 3.512866e-001, 3.512900e-001, 3.512933e-001, 3.512967e-001, 3.513000e-001, 3.513034e-001, 3.513067e-001, 3.513101e-001, 3.513134e-001, 3.513168e-001, 3.513201e-001, 3.513235e-001, 3.513268e-001, 3.513302e-001, 3.513335e-001, 3.513369e-001, 3.513402e-001, 3.513436e-001, 3.513469e-001, 3.513503e-001, 3.513536e-001, 3.513569e-001, 3.513603e-001, 3.513636e-001, 3.513670e-001, 3.513703e-001, 3.513737e-001, 3.513770e-001, 3.513804e-001, 3.513837e-001, 3.513870e-001, 3.513904e-001, 3.513937e-001, 3.513971e-001, 3.514004e-001, 3.514037e-001, 3.514071e-001, 3.514104e-001, 3.514138e-001, 3.514171e-001, 3.514204e-001, 3.514238e-001, 3.514271e-001, 3.514305e-001, 3.514338e-001, 3.514371e-001, 3.514405e-001, 3.514438e-001, 3.514471e-001, 3.514505e-001, 3.514538e-001, 3.514571e-001, 3.514605e-001, 3.514638e-001, 3.514671e-001, 3.514705e-001, 3.514738e-001, 3.514771e-001, 3.514805e-001, 3.514838e-001, 3.514871e-001, 3.514905e-001, 3.514938e-001, 3.514971e-001, 3.515004e-001, 3.515038e-001, 3.515071e-001, 3.515104e-001, 3.515138e-001, 3.515171e-001, 3.515204e-001, 3.515237e-001, 3.515271e-001, 3.515304e-001, 3.515337e-001, 3.515370e-001, 3.515404e-001, 3.515437e-001, 3.515470e-001, 3.515503e-001, 3.515537e-001, 3.515570e-001, 3.515603e-001, 3.515636e-001, 3.515670e-001, 3.515703e-001, 3.515736e-001, 3.515769e-001, 3.515802e-001, 3.515836e-001, 3.515869e-001, 3.515902e-001, 3.515935e-001, 
3.515968e-001, 3.516001e-001, 3.516035e-001, 3.516068e-001, 3.516101e-001, 3.516134e-001, 3.516167e-001, 3.516200e-001, 3.516234e-001, 3.516267e-001, 3.516300e-001, 3.516333e-001, 3.516366e-001, 3.516399e-001, 3.516432e-001, 3.516466e-001, 3.516499e-001, 3.516532e-001, 3.516565e-001, 3.516598e-001, 3.516631e-001, 3.516664e-001, 3.516697e-001, 3.516730e-001, 3.516764e-001, 3.516797e-001, 3.516830e-001, 3.516863e-001, 3.516896e-001, 3.516929e-001, 3.516962e-001, 3.516995e-001, 3.517028e-001, 3.517061e-001, 3.517094e-001, 3.517127e-001, 3.517160e-001, 3.517193e-001, 3.517226e-001, 3.517259e-001, 3.517293e-001, 3.517326e-001, 3.517359e-001, 3.517392e-001, 3.517425e-001, 3.517458e-001, 3.517491e-001, 3.517524e-001, 3.517557e-001, 3.517590e-001, 3.517623e-001, 3.517656e-001, 3.517689e-001, 3.517722e-001, 3.517755e-001, 3.517788e-001, 3.517820e-001, 3.517853e-001, 3.517886e-001, 3.517919e-001, 3.517952e-001, 3.517985e-001, 3.518018e-001, 3.518051e-001, 3.518084e-001, 3.518117e-001, 3.518150e-001, 3.518183e-001, 3.518216e-001, 3.518249e-001, 3.518282e-001, 3.518315e-001, 3.518347e-001, 3.518380e-001, 3.518413e-001, 3.518446e-001, 3.518479e-001, 3.518512e-001, 3.518545e-001, 3.518578e-001, 3.518611e-001, 3.518644e-001, 3.518676e-001, 3.518709e-001, 3.518742e-001, 3.518775e-001, 3.518808e-001, 3.518841e-001, 3.518874e-001, 3.518906e-001, 3.518939e-001, 3.518972e-001, 3.519005e-001, 3.519038e-001, 3.519071e-001, 3.519103e-001, 3.519136e-001, 3.519169e-001, 3.519202e-001, 3.519235e-001, 
3.519267e-001, 3.519300e-001, 3.519333e-001, 3.519366e-001, 3.519399e-001, 3.519431e-001, 3.519464e-001, 3.519497e-001, 3.519530e-001, 3.519563e-001, 3.519595e-001, 3.519628e-001, 3.519661e-001, 3.519694e-001, 3.519726e-001, 3.519759e-001, 3.519792e-001, 3.519825e-001, 3.519857e-001, 3.519890e-001, 3.519923e-001, 3.519955e-001, 3.519988e-001, 3.520021e-001, 3.520054e-001, 3.520086e-001, 3.520119e-001, 3.520152e-001, 3.520184e-001, 3.520217e-001, 3.520250e-001, 3.520283e-001, 3.520315e-001, 3.520348e-001, 3.520381e-001, 3.520413e-001, 3.520446e-001, 3.520479e-001, 3.520511e-001, 3.520544e-001, 3.520577e-001, 3.520609e-001, 3.520642e-001, 3.520674e-001, 3.520707e-001, 3.520740e-001, 3.520772e-001, 3.520805e-001, 3.520838e-001, 3.520870e-001, 3.520903e-001, 3.520935e-001, 3.520968e-001, 3.521001e-001, 3.521033e-001, 3.521066e-001, 3.521098e-001, 3.521131e-001, 3.521164e-001, 3.521196e-001, 3.521229e-001, 3.521261e-001, 3.521294e-001, 3.521327e-001, 3.521359e-001, 3.521392e-001, 3.521424e-001, 3.521457e-001, 3.521489e-001, 3.521522e-001, 3.521554e-001, 3.521587e-001, 3.521619e-001, 3.521652e-001, 3.521685e-001, 3.521717e-001, 3.521750e-001, 3.521782e-001, 3.521815e-001, 3.521847e-001, 3.521880e-001, 3.521912e-001, 3.521945e-001, 3.521977e-001, 3.522010e-001, 3.522042e-001, 3.522075e-001, 3.522107e-001, 3.522139e-001, 3.522172e-001, 3.522204e-001, 3.522237e-001, 3.522269e-001, 3.522302e-001, 3.522334e-001, 3.522367e-001, 3.522399e-001, 3.522432e-001, 3.522464e-001, 3.522496e-001, 
3.522529e-001, 3.522561e-001, 3.522594e-001, 3.522626e-001, 3.522659e-001, 3.522691e-001, 3.522723e-001, 3.522756e-001, 3.522788e-001, 3.522821e-001, 3.522853e-001, 3.522885e-001, 3.522918e-001, 3.522950e-001, 3.522982e-001, 3.523015e-001, 3.523047e-001, 3.523080e-001, 3.523112e-001, 3.523144e-001, 3.523177e-001, 3.523209e-001, 3.523241e-001, 3.523274e-001, 3.523306e-001, 3.523338e-001, 3.523371e-001, 3.523403e-001, 3.523435e-001, 3.523468e-001, 3.523500e-001, 3.523532e-001, 3.523565e-001, 3.523597e-001, 3.523629e-001, 3.523661e-001, 3.523694e-001, 3.523726e-001, 3.523758e-001, 3.523791e-001, 3.523823e-001, 3.523855e-001, 3.523887e-001, 3.523920e-001, 3.523952e-001, 3.523984e-001, 3.524016e-001, 3.524049e-001, 3.524081e-001, 3.524113e-001, 3.524145e-001, 3.524178e-001, 3.524210e-001, 3.524242e-001, 3.524274e-001, 3.524307e-001, 3.524339e-001, 3.524371e-001, 3.524403e-001, 3.524435e-001, 3.524468e-001, 3.524500e-001, 3.524532e-001, 3.524564e-001, 3.524596e-001, 3.524629e-001, 3.524661e-001, 3.524693e-001, 3.524725e-001, 3.524757e-001, 3.524789e-001, 3.524822e-001, 3.524854e-001, 3.524886e-001, 3.524918e-001, 3.524950e-001, 3.524982e-001, 3.525015e-001, 3.525047e-001, 3.525079e-001, 3.525111e-001, 3.525143e-001, 3.525175e-001, 3.525207e-001, 3.525239e-001, 3.525271e-001, 3.525304e-001, 3.525336e-001, 3.525368e-001, 3.525400e-001, 3.525432e-001, 3.525464e-001, 3.525496e-001, 3.525528e-001, 3.525560e-001, 3.525592e-001, 3.525624e-001, 3.525657e-001, 3.525689e-001, 3.525721e-001, 
3.525753e-001, 3.525785e-001, 3.525817e-001, 3.525849e-001, 3.525881e-001, 3.525913e-001, 3.525945e-001, 3.525977e-001, 3.526009e-001, 3.526041e-001, 3.526073e-001, 3.526105e-001, 3.526137e-001, 3.526169e-001, 3.526201e-001, 3.526233e-001, 3.526265e-001, 3.526297e-001, 3.526329e-001, 3.526361e-001, 3.526393e-001, 3.526425e-001, 3.526457e-001, 3.526489e-001, 3.526521e-001, 3.526553e-001, 3.526585e-001, 3.526617e-001, 3.526649e-001, 3.526681e-001, 3.526713e-001, 3.526744e-001, 3.526776e-001, 3.526808e-001, 3.526840e-001, 3.526872e-001, 3.526904e-001, 3.526936e-001, 3.526968e-001, 3.527000e-001, 3.527032e-001, 3.527064e-001, 3.527096e-001, 3.527127e-001, 3.527159e-001, 3.527191e-001, 3.527223e-001, 3.527255e-001, 3.527287e-001, 3.527319e-001, 3.527351e-001, 3.527382e-001, 3.527414e-001, 3.527446e-001, 3.527478e-001, 3.527510e-001, 3.527542e-001, 3.527573e-001, 3.527605e-001, 3.527637e-001, 3.527669e-001, 3.527701e-001, 3.527733e-001, 3.527764e-001, 3.527796e-001, 3.527828e-001, 3.527860e-001, 3.527892e-001, 3.527923e-001, 3.527955e-001, 3.527987e-001, 3.528019e-001, 3.528051e-001, 3.528082e-001, 3.528114e-001, 3.528146e-001, 3.528178e-001, 3.528209e-001, 3.528241e-001, 3.528273e-001, 3.528305e-001, 3.528337e-001, 3.528368e-001, 3.528400e-001, 3.528432e-001, 3.528463e-001, 3.528495e-001, 3.528527e-001, 3.528559e-001, 3.528590e-001, 3.528622e-001, 3.528654e-001, 3.528686e-001, 3.528717e-001, 3.528749e-001, 3.528781e-001, 3.528812e-001, 3.528844e-001, 3.528876e-001, 3.528907e-001, 
3.528939e-001, 3.528971e-001, 3.529002e-001, 3.529034e-001, 3.529066e-001, 3.529097e-001, 3.529129e-001, 3.529161e-001, 3.529192e-001, 3.529224e-001, 3.529256e-001, 3.529287e-001, 3.529319e-001, 3.529351e-001, 3.529382e-001, 3.529414e-001, 3.529445e-001, 3.529477e-001, 3.529509e-001, 3.529540e-001, 3.529572e-001, 3.529603e-001, 3.529635e-001, 3.529667e-001, 3.529698e-001, 3.529730e-001, 3.529761e-001, 3.529793e-001, 3.529825e-001, 3.529856e-001, 3.529888e-001, 3.529919e-001, 3.529951e-001, 3.529982e-001, 3.530014e-001, 3.530045e-001, 3.530077e-001, 3.530109e-001, 3.530140e-001, 3.530172e-001, 3.530203e-001, 3.530235e-001, 3.530266e-001, 3.530298e-001, 3.530329e-001, 3.530361e-001, 3.530392e-001, 3.530424e-001, 3.530455e-001, 3.530487e-001, 3.530518e-001, 3.530550e-001, 3.530581e-001, 3.530613e-001, 3.530644e-001, 3.530676e-001, 3.530707e-001, 3.530739e-001, 3.530770e-001, 3.530801e-001, 3.530833e-001, 3.530864e-001, 3.530896e-001, 3.530927e-001, 3.530959e-001, 3.530990e-001, 3.531022e-001, 3.531053e-001, 3.531084e-001, 3.531116e-001, 3.531147e-001, 3.531179e-001, 3.531210e-001, 3.531242e-001, 3.531273e-001, 3.531304e-001, 3.531336e-001, 3.531367e-001, 3.531398e-001, 3.531430e-001, 3.531461e-001, 3.531493e-001, 3.531524e-001, 3.531555e-001, 3.531587e-001, 3.531618e-001, 3.531649e-001, 3.531681e-001, 3.531712e-001, 3.531744e-001, 3.531775e-001, 3.531806e-001, 3.531838e-001, 3.531869e-001, 3.531900e-001, 3.531932e-001, 3.531963e-001, 3.531994e-001, 3.532025e-001, 3.532057e-001, 
3.532088e-001, 3.532119e-001, 3.532151e-001, 3.532182e-001, 3.532213e-001, 3.532245e-001, 3.532276e-001, 3.532307e-001, 3.532338e-001, 3.532370e-001, 3.532401e-001, 3.532432e-001, 3.532463e-001, 3.532495e-001, 3.532526e-001, 3.532557e-001, 3.532588e-001, 3.532620e-001, 3.532651e-001, 3.532682e-001, 3.532713e-001, 3.532745e-001, 3.532776e-001, 3.532807e-001, 3.532838e-001, 3.532870e-001, 3.532901e-001, 3.532932e-001, 3.532963e-001, 3.532994e-001, 3.533026e-001, 3.533057e-001, 3.533088e-001, 3.533119e-001, 3.533150e-001, 3.533181e-001, 3.533213e-001, 3.533244e-001, 3.533275e-001, 3.533306e-001, 3.533337e-001, 3.533368e-001, 3.533400e-001, 3.533431e-001, 3.533462e-001, 3.533493e-001, 3.533524e-001, 3.533555e-001, 3.533586e-001, 3.533618e-001, 3.533649e-001, 3.533680e-001, 3.533711e-001, 3.533742e-001, 3.533773e-001, 3.533804e-001, 3.533835e-001, 3.533866e-001, 3.533897e-001, 3.533929e-001, 3.533960e-001, 3.533991e-001, 3.534022e-001, 3.534053e-001, 3.534084e-001, 3.534115e-001, 3.534146e-001, 3.534177e-001, 3.534208e-001, 3.534239e-001, 3.534270e-001, 3.534301e-001, 3.534332e-001, 3.534363e-001, 3.534394e-001, 3.534425e-001, 3.534456e-001, 3.534488e-001, 3.534519e-001, 3.534550e-001, 3.534581e-001, 3.534612e-001, 3.534643e-001, 3.534674e-001, 3.534705e-001, 3.534736e-001, 3.534767e-001, 3.534798e-001, 3.534828e-001, 3.534859e-001, 3.534890e-001, 3.534921e-001, 3.534952e-001, 3.534983e-001, 3.535014e-001, 3.535045e-001, 3.535076e-001, 3.535107e-001, 3.535138e-001, 3.535169e-001, 
3.535200e-001, 3.535231e-001, 3.535262e-001, 3.535293e-001, 3.535324e-001, 3.535355e-001, 3.535385e-001, 3.535416e-001, 3.535447e-001, 3.535478e-001, 3.535509e-001, 3.535540e-001, 3.535571e-001, 3.535602e-001, 3.535633e-001, 3.535664e-001, 3.535694e-001, 3.535725e-001, 3.535756e-001, 3.535787e-001, 3.535818e-001, 3.535849e-001, 3.535880e-001, 3.535910e-001, 3.535941e-001, 3.535972e-001, 3.536003e-001, 3.536034e-001, 3.536065e-001, 3.536095e-001, 3.536126e-001, 3.536157e-001, 3.536188e-001, 3.536219e-001, 3.536250e-001, 3.536280e-001, 3.536311e-001, 3.536342e-001, 3.536373e-001, 3.536404e-001, 3.536434e-001, 3.536465e-001, 3.536496e-001, 3.536527e-001, 3.536557e-001, 3.536588e-001, 3.536619e-001, 3.536650e-001, 3.536680e-001, 3.536711e-001, 3.536742e-001, 3.536773e-001, 3.536803e-001, 3.536834e-001, 3.536865e-001, 3.536896e-001, 3.536926e-001, 3.536957e-001, 3.536988e-001, 3.537019e-001, 3.537049e-001, 3.537080e-001, 3.537111e-001, 3.537141e-001, 3.537172e-001, 3.537203e-001, 3.537234e-001, 3.537264e-001, 3.537295e-001, 3.537326e-001, 3.537356e-001, 3.537387e-001, 3.537418e-001, 3.537448e-001, 3.537479e-001, 3.537510e-001, 3.537540e-001, 3.537571e-001, 3.537602e-001, 3.537632e-001, 3.537663e-001, 3.537693e-001, 3.537724e-001, 3.537755e-001, 3.537785e-001, 3.537816e-001, 3.537847e-001, 3.537877e-001, 3.537908e-001, 3.537938e-001, 3.537969e-001, 3.538000e-001, 3.538030e-001, 3.538061e-001, 3.538091e-001, 3.538122e-001, 3.538153e-001, 3.538183e-001, 3.538214e-001, 3.538244e-001, 
3.538275e-001, 3.538305e-001, 3.538336e-001, 3.538366e-001, 3.538397e-001, 3.538428e-001, 3.538458e-001, 3.538489e-001, 3.538519e-001, 3.538550e-001, 3.538580e-001, 3.538611e-001, 3.538641e-001, 3.538672e-001, 3.538702e-001, 3.538733e-001, 3.538763e-001, 3.538794e-001, 3.538824e-001, 3.538855e-001, 3.538885e-001, 3.538916e-001, 3.538946e-001, 3.538977e-001, 3.539007e-001, 3.539038e-001, 3.539068e-001, 3.539099e-001, 3.539129e-001, 3.539160e-001, 3.539190e-001, 3.539221e-001, 3.539251e-001, 3.539281e-001, 3.539312e-001, 3.539342e-001, 3.539373e-001, 3.539403e-001, 3.539434e-001, 3.539464e-001, 3.539494e-001, 3.539525e-001, 3.539555e-001, 3.539586e-001, 3.539616e-001, 3.539646e-001, 3.539677e-001, 3.539707e-001, 3.539738e-001, 3.539768e-001, 3.539798e-001, 3.539829e-001, 3.539859e-001, 3.539889e-001, 3.539920e-001, 3.539950e-001, 3.539981e-001, 3.540011e-001, 3.540041e-001, 3.540072e-001, 3.540102e-001, 3.540132e-001, 3.540163e-001, 3.540193e-001, 3.540223e-001, 3.540254e-001, 3.540284e-001, 3.540314e-001, 3.540345e-001, 3.540375e-001, 3.540405e-001, 3.540436e-001, 3.540466e-001, 3.540496e-001, 3.540526e-001, 3.540557e-001, 3.540587e-001, 3.540617e-001, 3.540648e-001, 3.540678e-001, 3.540708e-001, 3.540738e-001, 3.540769e-001, 3.540799e-001, 3.540829e-001, 3.540859e-001, 3.540890e-001, 3.540920e-001, 3.540950e-001, 3.540980e-001, 3.541011e-001, 3.541041e-001, 3.541071e-001, 3.541101e-001, 3.541132e-001, 3.541162e-001, 3.541192e-001, 3.541222e-001, 3.541252e-001, 3.541283e-001, 
3.541313e-001, 3.541343e-001, 3.541373e-001, 3.541403e-001, 3.541433e-001, 3.541464e-001, 3.541494e-001, 3.541524e-001, 3.541554e-001, 3.541584e-001, 3.541615e-001, 3.541645e-001, 3.541675e-001, 3.541705e-001, 3.541735e-001, 3.541765e-001, 3.541795e-001, 3.541826e-001, 3.541856e-001, 3.541886e-001, 3.541916e-001, 3.541946e-001, 3.541976e-001, 3.542006e-001, 3.542036e-001, 3.542066e-001, 3.542097e-001, 3.542127e-001, 3.542157e-001, 3.542187e-001, 3.542217e-001, 3.542247e-001, 3.542277e-001, 3.542307e-001, 3.542337e-001, 3.542367e-001, 3.542397e-001, 3.542427e-001, 3.542458e-001, 3.542488e-001, 3.542518e-001, 3.542548e-001, 3.542578e-001, 3.542608e-001, 3.542638e-001, 3.542668e-001, 3.542698e-001, 3.542728e-001, 3.542758e-001, 3.542788e-001, 3.542818e-001, 3.542848e-001, 3.542878e-001, 3.542908e-001, 3.542938e-001, 3.542968e-001, 3.542998e-001, 3.543028e-001, 3.543058e-001, 3.543088e-001, 3.543118e-001, 3.543148e-001, 3.543178e-001, 3.543208e-001, 3.543238e-001, 3.543268e-001, 3.543298e-001, 3.543328e-001, 3.543358e-001, 3.543387e-001, 3.543417e-001, 3.543447e-001, 3.543477e-001, 3.543507e-001, 3.543537e-001, 3.543567e-001, 3.543597e-001, 3.543627e-001, 3.543657e-001, 3.543687e-001, 3.543717e-001, 3.543747e-001, 3.543776e-001, 3.543806e-001, 3.543836e-001, 3.543866e-001, 3.543896e-001, 3.543926e-001, 3.543956e-001, 3.543986e-001, 3.544015e-001, 3.544045e-001, 3.544075e-001, 3.544105e-001, 3.544135e-001, 3.544165e-001, 3.544195e-001, 3.544224e-001, 3.544254e-001, 3.544284e-001, 
3.544314e-001, 3.544344e-001, 3.544374e-001, 3.544403e-001, 3.544433e-001, 3.544463e-001, 3.544493e-001, 3.544523e-001, 3.544552e-001, 3.544582e-001, 3.544612e-001, 3.544642e-001, 3.544672e-001, 3.544701e-001, 3.544731e-001, 3.544761e-001, 3.544791e-001, 3.544820e-001, 3.544850e-001, 3.544880e-001, 3.544910e-001, 3.544939e-001, 3.544969e-001, 3.544999e-001, 3.545029e-001, 3.545058e-001, 3.545088e-001, 3.545118e-001, 3.545148e-001, 3.545177e-001, 3.545207e-001, 3.545237e-001, 3.545267e-001, 3.545296e-001, 3.545326e-001, 3.545356e-001, 3.545385e-001, 3.545415e-001, 3.545445e-001, 3.545474e-001, 3.545504e-001, 3.545534e-001, 3.545563e-001, 3.545593e-001, 3.545623e-001, 3.545652e-001, 3.545682e-001, 3.545712e-001, 3.545741e-001, 3.545771e-001, 3.545801e-001, 3.545830e-001, 3.545860e-001, 3.545890e-001, 3.545919e-001, 3.545949e-001, 3.545979e-001, 3.546008e-001, 3.546038e-001, 3.546067e-001, 3.546097e-001, 3.546127e-001, 3.546156e-001, 3.546186e-001, 3.546215e-001, 3.546245e-001, 3.546275e-001, 3.546304e-001, 3.546334e-001, 3.546363e-001, 3.546393e-001, 3.546422e-001, 3.546452e-001, 3.546482e-001, 3.546511e-001, 3.546541e-001, 3.546570e-001, 3.546600e-001, 3.546629e-001, 3.546659e-001, 3.546688e-001, 3.546718e-001, 3.546748e-001, 3.546777e-001, 3.546807e-001, 3.546836e-001, 3.546866e-001, 3.546895e-001, 3.546925e-001, 3.546954e-001, 3.546984e-001, 3.547013e-001, 3.547043e-001, 3.547072e-001, 3.547102e-001, 3.547131e-001, 3.547161e-001, 3.547190e-001, 3.547220e-001, 3.547249e-001, 
3.547278e-001, 3.547308e-001, 3.547337e-001, 3.547367e-001, 3.547396e-001, 3.547426e-001, 3.547455e-001, 3.547485e-001, 3.547514e-001, 3.547543e-001, 3.547573e-001, 3.547602e-001, 3.547632e-001, 3.547661e-001, 3.547691e-001, 3.547720e-001, 3.547749e-001, 3.547779e-001, 3.547808e-001, 3.547838e-001, 3.547867e-001, 3.547896e-001, 3.547926e-001, 3.547955e-001, 3.547985e-001, 3.548014e-001, 3.548043e-001, 3.548073e-001, 3.548102e-001, 3.548131e-001, 3.548161e-001, 3.548190e-001, 3.548219e-001, 3.548249e-001, 3.548278e-001, 3.548307e-001, 3.548337e-001, 3.548366e-001, 3.548395e-001, 3.548425e-001, 3.548454e-001, 3.548483e-001, 3.548513e-001, 3.548542e-001, 3.548571e-001, 3.548601e-001, 3.548630e-001, 3.548659e-001, 3.548688e-001, 3.548718e-001, 3.548747e-001, 3.548776e-001, 3.548806e-001, 3.548835e-001, 3.548864e-001, 3.548893e-001, 3.548923e-001, 3.548952e-001, 3.548981e-001, 3.549010e-001, 3.549040e-001, 3.549069e-001, 3.549098e-001, 3.549127e-001, 3.549157e-001, 3.549186e-001, 3.549215e-001, 3.549244e-001, 3.549273e-001, 3.549303e-001, 3.549332e-001, 3.549361e-001, 3.549390e-001, 3.549420e-001, 3.549449e-001, 3.549478e-001, 3.549507e-001, 3.549536e-001, 3.549565e-001, 3.549595e-001, 3.549624e-001, 3.549653e-001, 3.549682e-001, 3.549711e-001, 3.549740e-001, 3.549770e-001, 3.549799e-001, 3.549828e-001, 3.549857e-001, 3.549886e-001, 3.549915e-001, 3.549944e-001, 3.549974e-001, 3.550003e-001, 3.550032e-001, 3.550061e-001, 3.550090e-001, 3.550119e-001, 3.550148e-001, 3.550177e-001, 
3.550206e-001, 3.550236e-001, 3.550265e-001, 3.550294e-001, 3.550323e-001, 3.550352e-001, 3.550381e-001, 3.550410e-001, 3.550439e-001, 3.550468e-001, 3.550497e-001, 3.550526e-001, 3.550555e-001, 3.550584e-001, 3.550614e-001, 3.550643e-001, 3.550672e-001, 3.550701e-001, 3.550730e-001, 3.550759e-001, 3.550788e-001, 3.550817e-001, 3.550846e-001, 3.550875e-001, 3.550904e-001, 3.550933e-001, 3.550962e-001, 3.550991e-001, 3.551020e-001, 3.551049e-001, 3.551078e-001, 3.551107e-001, 3.551136e-001, 3.551165e-001, 3.551194e-001, 3.551223e-001, 3.551252e-001, 3.551281e-001, 3.551310e-001, 3.551339e-001, 3.551368e-001, 3.551396e-001, 3.551425e-001, 3.551454e-001, 3.551483e-001, 3.551512e-001, 3.551541e-001, 3.551570e-001, 3.551599e-001, 3.551628e-001, 3.551657e-001, 3.551686e-001, 3.551715e-001, 3.551744e-001, 3.551773e-001, 3.551801e-001, 3.551830e-001, 3.551859e-001, 3.551888e-001, 3.551917e-001, 3.551946e-001, 3.551975e-001, 3.552004e-001, 3.552032e-001, 3.552061e-001, 3.552090e-001, 3.552119e-001, 3.552148e-001, 3.552177e-001, 3.552206e-001, 3.552234e-001, 3.552263e-001, 3.552292e-001, 3.552321e-001, 3.552350e-001, 3.552379e-001, 3.552407e-001, 3.552436e-001, 3.552465e-001, 3.552494e-001, 3.552523e-001, 3.552552e-001, 3.552580e-001, 3.552609e-001, 3.552638e-001, 3.552667e-001, 3.552696e-001, 3.552724e-001, 3.552753e-001, 3.552782e-001, 3.552811e-001, 3.552839e-001, 3.552868e-001, 3.552897e-001, 3.552926e-001, 3.552954e-001, 3.552983e-001, 3.553012e-001, 3.553041e-001, 3.553069e-001, 
3.553098e-001, 3.553127e-001, 3.553156e-001, 3.553184e-001, 3.553213e-001, 3.553242e-001, 3.553271e-001, 3.553299e-001, 3.553328e-001, 3.553357e-001, 3.553385e-001, 3.553414e-001, 3.553443e-001, 3.553471e-001, 3.553500e-001, 3.553529e-001, 3.553557e-001, 3.553586e-001, 3.553615e-001, 3.553644e-001, 3.553672e-001, 3.553701e-001, 3.553729e-001, 3.553758e-001, 3.553787e-001, 3.553815e-001, 3.553844e-001, 3.553873e-001, 3.553901e-001, 3.553930e-001, 3.553959e-001, 3.553987e-001, 3.554016e-001, 3.554044e-001, 3.554073e-001, 3.554102e-001, 3.554130e-001, 3.554159e-001, 3.554188e-001, 3.554216e-001, 3.554245e-001, 3.554273e-001, 3.554302e-001, 3.554330e-001, 3.554359e-001, 3.554388e-001, 3.554416e-001, 3.554445e-001, 3.554473e-001, 3.554502e-001, 3.554530e-001, 3.554559e-001, 3.554588e-001, 3.554616e-001, 3.554645e-001, 3.554673e-001, 3.554702e-001, 3.554730e-001, 3.554759e-001, 3.554787e-001, 3.554816e-001, 3.554844e-001, 3.554873e-001, 3.554901e-001, 3.554930e-001, 3.554958e-001, 3.554987e-001, 3.555015e-001, 3.555044e-001, 3.555072e-001, 3.555101e-001, 3.555129e-001, 3.555158e-001, 3.555186e-001, 3.555215e-001, 3.555243e-001, 3.555272e-001, 3.555300e-001, 3.555329e-001, 3.555357e-001, 3.555385e-001, 3.555414e-001, 3.555442e-001, 3.555471e-001, 3.555499e-001, 3.555528e-001, 3.555556e-001, 3.555584e-001, 3.555613e-001, 3.555641e-001, 3.555670e-001, 3.555698e-001, 3.555727e-001, 3.555755e-001, 3.555783e-001, 3.555812e-001, 3.555840e-001, 3.555868e-001, 3.555897e-001, 3.555925e-001, 
3.555954e-001, 3.555982e-001, 3.556010e-001, 3.556039e-001, 3.556067e-001, 3.556095e-001, 3.556124e-001, 3.556152e-001, 3.556181e-001, 3.556209e-001, 3.556237e-001, 3.556266e-001, 3.556294e-001, 3.556322e-001, 3.556351e-001, 3.556379e-001, 3.556407e-001, 3.556435e-001, 3.556464e-001, 3.556492e-001, 3.556520e-001, 3.556549e-001, 3.556577e-001, 3.556605e-001, 3.556634e-001, 3.556662e-001, 3.556690e-001, 3.556718e-001, 3.556747e-001, 3.556775e-001, 3.556803e-001, 3.556831e-001, 3.556860e-001, 3.556888e-001, 3.556916e-001, 3.556945e-001, 3.556973e-001, 3.557001e-001, 3.557029e-001, 3.557057e-001, 3.557086e-001, 3.557114e-001, 3.557142e-001, 3.557170e-001, 3.557199e-001, 3.557227e-001, 3.557255e-001, 3.557283e-001, 3.557311e-001, 3.557340e-001, 3.557368e-001, 3.557396e-001, 3.557424e-001, 3.557452e-001, 3.557481e-001, 3.557509e-001, 3.557537e-001, 3.557565e-001, 3.557593e-001, 3.557621e-001, 3.557650e-001, 3.557678e-001, 3.557706e-001, 3.557734e-001, 3.557762e-001, 3.557790e-001, 3.557818e-001, 3.557847e-001, 3.557875e-001, 3.557903e-001, 3.557931e-001, 3.557959e-001, 3.557987e-001, 3.558015e-001, 3.558043e-001, 3.558072e-001, 3.558100e-001, 3.558128e-001, 3.558156e-001, 3.558184e-001, 3.558212e-001, 3.558240e-001, 3.558268e-001, 3.558296e-001, 3.558324e-001, 3.558352e-001, 3.558380e-001, 3.558409e-001, 3.558437e-001, 3.558465e-001, 3.558493e-001, 3.558521e-001, 3.558549e-001, 3.558577e-001, 3.558605e-001, 3.558633e-001, 3.558661e-001, 3.558689e-001, 3.558717e-001, 3.558745e-001, 
3.558773e-001, 3.558801e-001, 3.558829e-001, 3.558857e-001, 3.558885e-001, 3.558913e-001, 3.558941e-001, 3.558969e-001, 3.558997e-001, 3.559025e-001, 3.559053e-001, 3.559081e-001, 3.559109e-001, 3.559137e-001, 3.559165e-001, 3.559193e-001, 3.559221e-001, 3.559249e-001, 3.559277e-001, 3.559305e-001, 3.559333e-001, 3.559360e-001, 3.559388e-001, 3.559416e-001, 3.559444e-001, 3.559472e-001, 3.559500e-001, 3.559528e-001, 3.559556e-001, 3.559584e-001, 3.559612e-001, 3.559640e-001, 3.559668e-001, 3.559695e-001, 3.559723e-001, 3.559751e-001, 3.559779e-001, 3.559807e-001, 3.559835e-001, 3.559863e-001, 3.559891e-001, 3.559919e-001, 3.559946e-001, 3.559974e-001, 3.560002e-001, 3.560030e-001, 3.560058e-001, 3.560086e-001, 3.560113e-001, 3.560141e-001, 3.560169e-001, 3.560197e-001, 3.560225e-001, 3.560253e-001, 3.560280e-001, 3.560308e-001, 3.560336e-001, 3.560364e-001, 3.560392e-001, 3.560420e-001, 3.560447e-001, 3.560475e-001, 3.560503e-001, 3.560531e-001, 3.560558e-001, 3.560586e-001, 3.560614e-001, 3.560642e-001, 3.560670e-001, 3.560697e-001, 3.560725e-001, 3.560753e-001, 3.560781e-001, 3.560808e-001, 3.560836e-001, 3.560864e-001, 3.560892e-001, 3.560919e-001, 3.560947e-001, 3.560975e-001, 3.561003e-001, 3.561030e-001, 3.561058e-001, 3.561086e-001, 3.561113e-001, 3.561141e-001, 3.561169e-001, 3.561197e-001, 3.561224e-001, 3.561252e-001, 3.561280e-001, 3.561307e-001, 3.561335e-001, 3.561363e-001, 3.561390e-001, 3.561418e-001, 3.561446e-001, 3.561473e-001, 3.561501e-001, 3.561529e-001, 
3.561556e-001, 3.561584e-001, 3.561612e-001, 3.561639e-001, 3.561667e-001, 3.561695e-001, 3.561722e-001, 3.561750e-001, 3.561777e-001, 3.561805e-001, 3.561833e-001, 3.561860e-001, 3.561888e-001, 3.561916e-001, 3.561943e-001, 3.561971e-001, 3.561998e-001, 3.562026e-001, 3.562054e-001, 3.562081e-001, 3.562109e-001, 3.562136e-001, 3.562164e-001, 3.562191e-001, 3.562219e-001, 3.562247e-001, 3.562274e-001, 3.562302e-001, 3.562329e-001, 3.562357e-001, 3.562384e-001, 3.562412e-001, 3.562439e-001, 3.562467e-001, 3.562495e-001, 3.562522e-001, 3.562550e-001, 3.562577e-001, 3.562605e-001, 3.562632e-001, 3.562660e-001, 3.562687e-001, 3.562715e-001, 3.562742e-001, 3.562770e-001, 3.562797e-001, 3.562825e-001, 3.562852e-001, 3.562880e-001, 3.562907e-001, 3.562935e-001, 3.562962e-001, 3.562990e-001, 3.563017e-001, 3.563044e-001, 3.563072e-001, 3.563099e-001, 3.563127e-001, 3.563154e-001, 3.563182e-001, 3.563209e-001, 3.563237e-001, 3.563264e-001, 3.563291e-001, 3.563319e-001, 3.563346e-001, 3.563374e-001, 3.563401e-001, 3.563429e-001, 3.563456e-001, 3.563483e-001, 3.563511e-001, 3.563538e-001, 3.563566e-001, 3.563593e-001, 3.563620e-001, 3.563648e-001, 3.563675e-001, 3.563703e-001, 3.563730e-001, 3.563757e-001, 3.563785e-001, 3.563812e-001, 3.563839e-001, 3.563867e-001, 3.563894e-001, 3.563921e-001, 3.563949e-001, 3.563976e-001, 3.564003e-001, 3.564031e-001, 3.564058e-001, 3.564085e-001, 3.564113e-001, 3.564140e-001, 3.564167e-001, 3.564195e-001, 3.564222e-001, 3.564249e-001, 3.564277e-001, 
3.564304e-001, 3.564331e-001, 3.564358e-001, 3.564386e-001, 3.564413e-001, 3.564440e-001, 3.564468e-001, 3.564495e-001, 3.564522e-001, 3.564549e-001, 3.564577e-001, 3.564604e-001, 3.564631e-001, 3.564658e-001, 3.564686e-001, 3.564713e-001, 3.564740e-001, 3.564767e-001, 3.564795e-001, 3.564822e-001, 3.564849e-001, 3.564876e-001, 3.564904e-001, 3.564931e-001, 3.564958e-001, 3.564985e-001, 3.565012e-001, 3.565040e-001, 3.565067e-001, 3.565094e-001, 3.565121e-001, 3.565148e-001, 3.565176e-001, 3.565203e-001, 3.565230e-001, 3.565257e-001, 3.565284e-001, 3.565311e-001, 3.565339e-001, 3.565366e-001, 3.565393e-001, 3.565420e-001, 3.565447e-001, 3.565474e-001, 3.565501e-001, 3.565529e-001, 3.565556e-001, 3.565583e-001, 3.565610e-001, 3.565637e-001, 3.565664e-001, 3.565691e-001, 3.565718e-001, 3.565746e-001, 3.565773e-001, 3.565800e-001, 3.565827e-001, 3.565854e-001, 3.565881e-001, 3.565908e-001, 3.565935e-001, 3.565962e-001, 3.565989e-001, 3.566016e-001, 3.566044e-001, 3.566071e-001, 3.566098e-001, 3.566125e-001, 3.566152e-001, 3.566179e-001, 3.566206e-001, 3.566233e-001, 3.566260e-001, 3.566287e-001, 3.566314e-001, 3.566341e-001, 3.566368e-001, 3.566395e-001, 3.566422e-001, 3.566449e-001, 3.566476e-001, 3.566503e-001, 3.566530e-001, 3.566557e-001, 3.566584e-001, 3.566611e-001, 3.566638e-001, 3.566665e-001, 3.566692e-001, 3.566719e-001, 3.566746e-001, 3.566773e-001, 3.566800e-001, 3.566827e-001, 3.566854e-001, 3.566881e-001, 3.566908e-001, 3.566935e-001, 3.566962e-001, 3.566989e-001, 
3.567016e-001, 3.567043e-001, 3.567070e-001, 3.567097e-001, 3.567123e-001, 3.567150e-001, 3.567177e-001, 3.567204e-001, 3.567231e-001, 3.567258e-001, 3.567285e-001, 3.567312e-001, 3.567339e-001, 3.567366e-001, 3.567393e-001, 3.567419e-001, 3.567446e-001, 3.567473e-001, 3.567500e-001, 3.567527e-001, 3.567554e-001, 3.567581e-001, 3.567608e-001, 3.567634e-001, 3.567661e-001, 3.567688e-001, 3.567715e-001, 3.567742e-001, 3.567769e-001, 3.567795e-001, 3.567822e-001, 3.567849e-001, 3.567876e-001, 3.567903e-001, 3.567930e-001, 3.567956e-001, 3.567983e-001, 3.568010e-001, 3.568037e-001, 3.568064e-001, 3.568090e-001, 3.568117e-001, 3.568144e-001, 3.568171e-001, 3.568198e-001, 3.568224e-001, 3.568251e-001, 3.568278e-001, 3.568305e-001, 3.568332e-001, 3.568358e-001, 3.568385e-001, 3.568412e-001, 3.568439e-001, 3.568465e-001, 3.568492e-001, 3.568519e-001, 3.568546e-001, 3.568572e-001, 3.568599e-001, 3.568626e-001, 3.568652e-001, 3.568679e-001, 3.568706e-001, 3.568733e-001, 3.568759e-001, 3.568786e-001, 3.568813e-001, 3.568839e-001, 3.568866e-001, 3.568893e-001, 3.568919e-001, 3.568946e-001, 3.568973e-001, 3.569000e-001, 3.569026e-001, 3.569053e-001, 3.569080e-001, 3.569106e-001, 3.569133e-001, 3.569160e-001, 3.569186e-001, 3.569213e-001, 3.569239e-001, 3.569266e-001, 3.569293e-001, 3.569319e-001, 3.569346e-001, 3.569373e-001, 3.569399e-001, 3.569426e-001, 3.569453e-001, 3.569479e-001, 3.569506e-001, 3.569532e-001, 3.569559e-001, 3.569586e-001, 3.569612e-001, 3.569639e-001, 3.569665e-001, 
3.569692e-001, 3.569719e-001, 3.569745e-001, 3.569772e-001, 3.569798e-001, 3.569825e-001, 3.569851e-001, 3.569878e-001, 3.569905e-001, 3.569931e-001, 3.569958e-001, 3.569984e-001, 3.570011e-001, 3.570037e-001, 3.570064e-001, 3.570090e-001, 3.570117e-001, 3.570143e-001, 3.570170e-001, 3.570196e-001, 3.570223e-001, 3.570249e-001, 3.570276e-001, 3.570302e-001, 3.570329e-001, 3.570355e-001, 3.570382e-001, 3.570408e-001, 3.570435e-001, 3.570461e-001, 3.570488e-001, 3.570514e-001, 3.570541e-001, 3.570567e-001, 3.570594e-001, 3.570620e-001, 3.570647e-001, 3.570673e-001, 3.570700e-001, 3.570726e-001, 3.570753e-001, 3.570779e-001, 3.570805e-001, 3.570832e-001, 3.570858e-001, 3.570885e-001, 3.570911e-001, 3.570938e-001, 3.570964e-001, 3.570990e-001, 3.571017e-001, 3.571043e-001, 3.571070e-001, 3.571096e-001, 3.571122e-001, 3.571149e-001, 3.571175e-001, 3.571202e-001, 3.571228e-001, 3.571254e-001, 3.571281e-001, 3.571307e-001, 3.571333e-001, 3.571360e-001, 3.571386e-001, 3.571412e-001, 3.571439e-001, 3.571465e-001, 3.571492e-001, 3.571518e-001, 3.571544e-001, 3.571571e-001, 3.571597e-001, 3.571623e-001, 3.571650e-001, 3.571676e-001, 3.571702e-001, 3.571728e-001, 3.571755e-001, 3.571781e-001, 3.571807e-001, 3.571834e-001, 3.571860e-001, 3.571886e-001, 3.571913e-001, 3.571939e-001, 3.571965e-001, 3.571991e-001, 3.572018e-001, 3.572044e-001, 3.572070e-001, 3.572096e-001, 3.572123e-001, 3.572149e-001, 3.572175e-001, 3.572202e-001, 3.572228e-001, 3.572254e-001, 3.572280e-001, 3.572306e-001, 
3.572333e-001, 3.572359e-001, 3.572385e-001, 3.572411e-001, 3.572438e-001, 3.572464e-001, 3.572490e-001, 3.572516e-001, 3.572542e-001, 3.572569e-001, 3.572595e-001, 3.572621e-001, 3.572647e-001, 3.572673e-001, 3.572700e-001, 3.572726e-001, 3.572752e-001, 3.572778e-001, 3.572804e-001, 3.572830e-001, 3.572857e-001, 3.572883e-001, 3.572909e-001, 3.572935e-001, 3.572961e-001, 3.572987e-001, 3.573014e-001, 3.573040e-001, 3.573066e-001, 3.573092e-001, 3.573118e-001, 3.573144e-001, 3.573170e-001, 3.573196e-001, 3.573223e-001, 3.573249e-001, 3.573275e-001, 3.573301e-001, 3.573327e-001, 3.573353e-001, 3.573379e-001, 3.573405e-001, 3.573431e-001, 3.573457e-001, 3.573483e-001, 3.573510e-001, 3.573536e-001, 3.573562e-001, 3.573588e-001, 3.573614e-001, 3.573640e-001, 3.573666e-001, 3.573692e-001, 3.573718e-001, 3.573744e-001, 3.573770e-001, 3.573796e-001, 3.573822e-001, 3.573848e-001, 3.573874e-001, 3.573900e-001, 3.573926e-001, 3.573952e-001, 3.573978e-001, 3.574004e-001, 3.574030e-001, 3.574056e-001, 3.574082e-001, 3.574108e-001, 3.574134e-001, 3.574160e-001, 3.574186e-001, 3.574212e-001, 3.574238e-001, 3.574264e-001, 3.574290e-001, 3.574316e-001, 3.574342e-001, 3.574368e-001, 3.574394e-001, 3.574420e-001, 3.574446e-001, 3.574472e-001, 3.574498e-001, 3.574524e-001, 3.574550e-001, 3.574576e-001, 3.574601e-001, 3.574627e-001, 3.574653e-001, 3.574679e-001, 3.574705e-001, 3.574731e-001, 3.574757e-001, 3.574783e-001, 3.574809e-001, 3.574835e-001, 3.574861e-001, 3.574886e-001, 3.574912e-001, 
3.574938e-001, 3.574964e-001, 3.574990e-001, 3.575016e-001, 3.575042e-001, 3.575068e-001, 3.575093e-001, 3.575119e-001, 3.575145e-001, 3.575171e-001, 3.575197e-001, 3.575223e-001, 3.575248e-001, 3.575274e-001, 3.575300e-001, 3.575326e-001, 3.575352e-001, 3.575378e-001, 3.575403e-001, 3.575429e-001, 3.575455e-001, 3.575481e-001, 3.575507e-001, 3.575532e-001, 3.575558e-001, 3.575584e-001, 3.575610e-001, 3.575636e-001, 3.575661e-001, 3.575687e-001, 3.575713e-001, 3.575739e-001, 3.575764e-001, 3.575790e-001, 3.575816e-001, 3.575842e-001, 3.575867e-001, 3.575893e-001, 3.575919e-001, 3.575945e-001, 3.575970e-001, 3.575996e-001, 3.576022e-001, 3.576048e-001, 3.576073e-001, 3.576099e-001, 3.576125e-001, 3.576151e-001, 3.576176e-001, 3.576202e-001, 3.576228e-001, 3.576253e-001, 3.576279e-001, 3.576305e-001, 3.576330e-001, 3.576356e-001, 3.576382e-001, 3.576407e-001, 3.576433e-001, 3.576459e-001, 3.576485e-001, 3.576510e-001, 3.576536e-001, 3.576561e-001, 3.576587e-001, 3.576613e-001, 3.576638e-001, 3.576664e-001, 3.576690e-001, 3.576715e-001, 3.576741e-001, 3.576767e-001, 3.576792e-001, 3.576818e-001, 3.576844e-001, 3.576869e-001, 3.576895e-001, 3.576920e-001, 3.576946e-001, 3.576972e-001, 3.576997e-001, 3.577023e-001, 3.577048e-001, 3.577074e-001, 3.577100e-001, 3.577125e-001, 3.577151e-001, 3.577176e-001, 3.577202e-001, 3.577227e-001, 3.577253e-001, 3.577278e-001, 3.577304e-001, 3.577330e-001, 3.577355e-001, 3.577381e-001, 3.577406e-001, 3.577432e-001, 3.577457e-001, 3.577483e-001, 
3.577508e-001, 3.577534e-001, 3.577559e-001, 3.577585e-001, 3.577610e-001, 3.577636e-001, 3.577661e-001, 3.577687e-001, 3.577712e-001, 3.577738e-001, 3.577763e-001, 3.577789e-001, 3.577814e-001, 3.577840e-001, 3.577865e-001, 3.577891e-001, 3.577916e-001, 3.577942e-001, 3.577967e-001, 3.577993e-001, 3.578018e-001, 3.578044e-001, 3.578069e-001, 3.578095e-001, 3.578120e-001, 3.578145e-001, 3.578171e-001, 3.578196e-001, 3.578222e-001, 3.578247e-001, 3.578273e-001, 3.578298e-001, 3.578323e-001, 3.578349e-001, 3.578374e-001, 3.578400e-001, 3.578425e-001, 3.578450e-001, 3.578476e-001, 3.578501e-001, 3.578527e-001, 3.578552e-001, 3.578577e-001, 3.578603e-001, 3.578628e-001, 3.578654e-001, 3.578679e-001, 3.578704e-001, 3.578730e-001, 3.578755e-001, 3.578780e-001, 3.578806e-001, 3.578831e-001, 3.578856e-001, 3.578882e-001, 3.578907e-001, 3.578932e-001, 3.578958e-001, 3.578983e-001, 3.579008e-001, 3.579034e-001, 3.579059e-001, 3.579084e-001, 3.579110e-001, 3.579135e-001, 3.579160e-001, 3.579186e-001, 3.579211e-001, 3.579236e-001, 3.579261e-001, 3.579287e-001, 3.579312e-001, 3.579337e-001, 3.579362e-001, 3.579388e-001, 3.579413e-001, 3.579438e-001, 3.579464e-001, 3.579489e-001, 3.579514e-001, 3.579539e-001, 3.579565e-001, 3.579590e-001, 3.579615e-001, 3.579640e-001, 3.579665e-001, 3.579691e-001, 3.579716e-001, 3.579741e-001, 3.579766e-001, 3.579792e-001, 3.579817e-001, 3.579842e-001, 3.579867e-001, 3.579892e-001, 3.579918e-001, 3.579943e-001, 3.579968e-001, 3.579993e-001, 3.580018e-001, 
3.580044e-001, 3.580069e-001, 3.580094e-001, 3.580119e-001, 3.580144e-001, 3.580169e-001, 3.580195e-001, 3.580220e-001, 3.580245e-001, 3.580270e-001, 3.580295e-001, 3.580320e-001, 3.580345e-001, 3.580371e-001, 3.580396e-001, 3.580421e-001, 3.580446e-001, 3.580471e-001, 3.580496e-001, 3.580521e-001, 3.580546e-001, 3.580571e-001, 3.580597e-001, 3.580622e-001, 3.580647e-001, 3.580672e-001, 3.580697e-001, 3.580722e-001, 3.580747e-001, 3.580772e-001, 3.580797e-001, 3.580822e-001, 3.580847e-001, 3.580872e-001, 3.580897e-001, 3.580923e-001, 3.580948e-001, 3.580973e-001, 3.580998e-001, 3.581023e-001, 3.581048e-001, 3.581073e-001, 3.581098e-001, 3.581123e-001, 3.581148e-001, 3.581173e-001, 3.581198e-001, 3.581223e-001, 3.581248e-001, 3.581273e-001, 3.581298e-001, 3.581323e-001, 3.581348e-001, 3.581373e-001, 3.581398e-001, 3.581423e-001, 3.581448e-001, 3.581473e-001, 3.581498e-001, 3.581523e-001, 3.581548e-001, 3.581573e-001, 3.581598e-001, 3.581623e-001, 3.581648e-001, 3.581673e-001, 3.581698e-001, 3.581722e-001, 3.581747e-001, 3.581772e-001, 3.581797e-001, 3.581822e-001, 3.581847e-001, 3.581872e-001, 3.581897e-001, 3.581922e-001, 3.581947e-001, 3.581972e-001, 3.581997e-001, 3.582022e-001, 3.582046e-001, 3.582071e-001, 3.582096e-001, 3.582121e-001, 3.582146e-001, 3.582171e-001, 3.582196e-001, 3.582221e-001, 3.582246e-001, 3.582270e-001, 3.582295e-001, 3.582320e-001, 3.582345e-001, 3.582370e-001, 3.582395e-001, 3.582420e-001, 3.582444e-001, 3.582469e-001, 3.582494e-001, 3.582519e-001, 
3.582544e-001, 3.582569e-001, 3.582593e-001, 3.582618e-001, 3.582643e-001, 3.582668e-001, 3.582693e-001, 3.582717e-001, 3.582742e-001, 3.582767e-001, 3.582792e-001, 3.582817e-001, 3.582841e-001, 3.582866e-001, 3.582891e-001, 3.582916e-001, 3.582940e-001, 3.582965e-001, 3.582990e-001, 3.583015e-001, 3.583040e-001, 3.583064e-001, 3.583089e-001, 3.583114e-001, 3.583139e-001, 3.583163e-001, 3.583188e-001, 3.583213e-001, 3.583237e-001, 3.583262e-001, 3.583287e-001, 3.583312e-001, 3.583336e-001, 3.583361e-001, 3.583386e-001, 3.583411e-001, 3.583435e-001, 3.583460e-001, 3.583485e-001, 3.583509e-001, 3.583534e-001, 3.583559e-001, 3.583583e-001, 3.583608e-001, 3.583633e-001, 3.583657e-001, 3.583682e-001, 3.583707e-001, 3.583731e-001, 3.583756e-001, 3.583781e-001, 3.583805e-001, 3.583830e-001, 3.583855e-001, 3.583879e-001, 3.583904e-001, 3.583929e-001, 3.583953e-001, 3.583978e-001, 3.584002e-001, 3.584027e-001, 3.584052e-001, 3.584076e-001, 3.584101e-001, 3.584126e-001, 3.584150e-001, 3.584175e-001, 3.584199e-001, 3.584224e-001, 3.584248e-001, 3.584273e-001, 3.584298e-001, 3.584322e-001, 3.584347e-001, 3.584371e-001, 3.584396e-001, 3.584421e-001, 3.584445e-001, 3.584470e-001, 3.584494e-001, 3.584519e-001, 3.584543e-001, 3.584568e-001, 3.584592e-001, 3.584617e-001, 3.584641e-001, 3.584666e-001, 3.584690e-001, 3.584715e-001, 3.584740e-001, 3.584764e-001, 3.584789e-001, 3.584813e-001, 3.584838e-001, 3.584862e-001, 3.584887e-001, 3.584911e-001, 3.584936e-001, 3.584960e-001, 3.584985e-001, 
3.585009e-001, 3.585033e-001, 3.585058e-001, 3.585082e-001, 3.585107e-001, 3.585131e-001, 3.585156e-001, 3.585180e-001, 3.585205e-001, 3.585229e-001, 3.585254e-001, 3.585278e-001, 3.585303e-001, 3.585327e-001, 3.585351e-001, 3.585376e-001, 3.585400e-001, 3.585425e-001, 3.585449e-001, 3.585474e-001, 3.585498e-001, 3.585522e-001, 3.585547e-001, 3.585571e-001, 3.585596e-001, 3.585620e-001, 3.585644e-001, 3.585669e-001, 3.585693e-001, 3.585717e-001, 3.585742e-001, 3.585766e-001, 3.585791e-001, 3.585815e-001, 3.585839e-001, 3.585864e-001, 3.585888e-001, 3.585912e-001, 3.585937e-001, 3.585961e-001, 3.585985e-001, 3.586010e-001, 3.586034e-001, 3.586058e-001, 3.586083e-001, 3.586107e-001, 3.586131e-001, 3.586156e-001, 3.586180e-001, 3.586204e-001, 3.586229e-001, 3.586253e-001, 3.586277e-001, 3.586302e-001, 3.586326e-001, 3.586350e-001, 3.586374e-001, 3.586399e-001, 3.586423e-001, 3.586447e-001, 3.586472e-001, 3.586496e-001, 3.586520e-001, 3.586544e-001, 3.586569e-001, 3.586593e-001, 3.586617e-001, 3.586641e-001, 3.586666e-001, 3.586690e-001, 3.586714e-001, 3.586738e-001, 3.586763e-001, 3.586787e-001, 3.586811e-001, 3.586835e-001, 3.586859e-001, 3.586884e-001, 3.586908e-001, 3.586932e-001, 3.586956e-001, 3.586980e-001, 3.587005e-001, 3.587029e-001, 3.587053e-001, 3.587077e-001, 3.587101e-001, 3.587126e-001, 3.587150e-001, 3.587174e-001, 3.587198e-001, 3.587222e-001, 3.587246e-001, 3.587271e-001, 3.587295e-001, 3.587319e-001, 3.587343e-001, 3.587367e-001, 3.587391e-001, 3.587415e-001, 
3.587440e-001, 3.587464e-001, 3.587488e-001, 3.587512e-001, 3.587536e-001, 3.587560e-001, 3.587584e-001, 3.587608e-001, 3.587633e-001, 3.587657e-001, 3.587681e-001, 3.587705e-001, 3.587729e-001, 3.587753e-001, 3.587777e-001, 3.587801e-001, 3.587825e-001, 3.587849e-001, 3.587873e-001, 3.587898e-001, 3.587922e-001, 3.587946e-001, 3.587970e-001, 3.587994e-001, 3.588018e-001, 3.588042e-001, 3.588066e-001, 3.588090e-001, 3.588114e-001, 3.588138e-001, 3.588162e-001, 3.588186e-001, 3.588210e-001, 3.588234e-001, 3.588258e-001, 3.588282e-001, 3.588306e-001, 3.588330e-001, 3.588354e-001, 3.588378e-001, 3.588402e-001, 3.588426e-001, 3.588450e-001, 3.588474e-001, 3.588498e-001, 3.588522e-001, 3.588546e-001, 3.588570e-001, 3.588594e-001, 3.588618e-001, 3.588642e-001, 3.588666e-001, 3.588690e-001, 3.588714e-001, 3.588738e-001, 3.588762e-001, 3.588786e-001, 3.588810e-001, 3.588834e-001, 3.588857e-001, 3.588881e-001, 3.588905e-001, 3.588929e-001, 3.588953e-001, 3.588977e-001, 3.589001e-001, 3.589025e-001, 3.589049e-001, 3.589073e-001, 3.589097e-001, 3.589120e-001, 3.589144e-001, 3.589168e-001, 3.589192e-001, 3.589216e-001, 3.589240e-001, 3.589264e-001, 3.589288e-001, 3.589311e-001, 3.589335e-001, 3.589359e-001, 3.589383e-001, 3.589407e-001, 3.589431e-001, 3.589455e-001, 3.589478e-001, 3.589502e-001, 3.589526e-001, 3.589550e-001, 3.589574e-001, 3.589598e-001, 3.589621e-001, 3.589645e-001, 3.589669e-001, 3.589693e-001, 3.589717e-001, 3.589740e-001, 3.589764e-001, 3.589788e-001, 3.589812e-001, 
3.589836e-001, 3.589859e-001, 3.589883e-001, 3.589907e-001, 3.589931e-001, 3.589955e-001, 3.589978e-001, 3.590002e-001, 3.590026e-001, 3.590050e-001, 3.590073e-001, 3.590097e-001, 3.590121e-001, 3.590145e-001, 3.590168e-001, 3.590192e-001, 3.590216e-001, 3.590240e-001, 3.590263e-001, 3.590287e-001, 3.590311e-001, 3.590334e-001, 3.590358e-001, 3.590382e-001, 3.590406e-001, 3.590429e-001, 3.590453e-001, 3.590477e-001, 3.590500e-001, 3.590524e-001, 3.590548e-001, 3.590571e-001, 3.590595e-001, 3.590619e-001, 3.590642e-001, 3.590666e-001, 3.590690e-001, 3.590713e-001, 3.590737e-001, 3.590761e-001, 3.590784e-001, 3.590808e-001, 3.590832e-001, 3.590855e-001, 3.590879e-001, 3.590903e-001, 3.590926e-001, 3.590950e-001, 3.590973e-001, 3.590997e-001, 3.591021e-001, 3.591044e-001, 3.591068e-001, 3.591092e-001, 3.591115e-001, 3.591139e-001, 3.591162e-001, 3.591186e-001, 3.591210e-001, 3.591233e-001, 3.591257e-001, 3.591280e-001, 3.591304e-001, 3.591327e-001, 3.591351e-001, 3.591375e-001, 3.591398e-001, 3.591422e-001, 3.591445e-001, 3.591469e-001, 3.591492e-001, 3.591516e-001, 3.591539e-001, 3.591563e-001, 3.591586e-001, 3.591610e-001, 3.591634e-001, 3.591657e-001, 3.591681e-001, 3.591704e-001, 3.591728e-001, 3.591751e-001, 3.591775e-001, 3.591798e-001, 3.591822e-001, 3.591845e-001, 3.591869e-001, 3.591892e-001, 3.591916e-001, 3.591939e-001, 3.591963e-001, 3.591986e-001, 3.592009e-001, 3.592033e-001, 3.592056e-001, 3.592080e-001, 3.592103e-001, 3.592127e-001, 3.592150e-001, 3.592174e-001, 
3.592197e-001, 3.592221e-001, 3.592244e-001, 3.592267e-001, 3.592291e-001, 3.592314e-001, 3.592338e-001, 3.592361e-001, 3.592385e-001, 3.592408e-001, 3.592431e-001, 3.592455e-001, 3.592478e-001, 3.592502e-001, 3.592525e-001, 3.592548e-001, 3.592572e-001, 3.592595e-001, 3.592619e-001, 3.592642e-001, 3.592665e-001, 3.592689e-001, 3.592712e-001, 3.592735e-001, 3.592759e-001, 3.592782e-001, 3.592806e-001, 3.592829e-001, 3.592852e-001, 3.592876e-001, 3.592899e-001, 3.592922e-001, 3.592946e-001, 3.592969e-001, 3.592992e-001, 3.593016e-001, 3.593039e-001, 3.593062e-001, 3.593086e-001, 3.593109e-001, 3.593132e-001, 3.593155e-001, 3.593179e-001, 3.593202e-001, 3.593225e-001, 3.593249e-001, 3.593272e-001, 3.593295e-001, 3.593318e-001, 3.593342e-001, 3.593365e-001, 3.593388e-001, 3.593412e-001, 3.593435e-001, 3.593458e-001, 3.593481e-001, 3.593505e-001, 3.593528e-001, 3.593551e-001, 3.593574e-001, 3.593598e-001, 3.593621e-001, 3.593644e-001, 3.593667e-001, 3.593690e-001, 3.593714e-001, 3.593737e-001, 3.593760e-001, 3.593783e-001, 3.593807e-001, 3.593830e-001, 3.593853e-001, 3.593876e-001, 3.593899e-001, 3.593923e-001, 3.593946e-001, 3.593969e-001, 3.593992e-001, 3.594015e-001, 3.594038e-001, 3.594062e-001, 3.594085e-001, 3.594108e-001, 3.594131e-001, 3.594154e-001, 3.594177e-001, 3.594201e-001, 3.594224e-001, 3.594247e-001, 3.594270e-001, 3.594293e-001, 3.594316e-001, 3.594339e-001, 3.594363e-001, 3.594386e-001, 3.594409e-001, 3.594432e-001, 3.594455e-001, 3.594478e-001, 3.594501e-001, 
3.594524e-001, 3.594547e-001, 3.594571e-001, 3.594594e-001, 3.594617e-001, 3.594640e-001, 3.594663e-001, 3.594686e-001, 3.594709e-001, 3.594732e-001, 3.594755e-001, 3.594778e-001, 3.594801e-001, 3.594824e-001, 3.594847e-001, 3.594870e-001, 3.594893e-001, 3.594917e-001, 3.594940e-001, 3.594963e-001, 3.594986e-001, 3.595009e-001, 3.595032e-001, 3.595055e-001, 3.595078e-001, 3.595101e-001, 3.595124e-001, 3.595147e-001, 3.595170e-001, 3.595193e-001, 3.595216e-001, 3.595239e-001, 3.595262e-001, 3.595285e-001, 3.595308e-001, 3.595331e-001, 3.595354e-001, 3.595377e-001, 3.595400e-001, 3.595423e-001, 3.595446e-001, 3.595469e-001, 3.595491e-001, 3.595514e-001, 3.595537e-001, 3.595560e-001, 3.595583e-001, 3.595606e-001, 3.595629e-001, 3.595652e-001, 3.595675e-001, 3.595698e-001, 3.595721e-001, 3.595744e-001, 3.595767e-001, 3.595790e-001, 3.595813e-001, 3.595835e-001, 3.595858e-001, 3.595881e-001, 3.595904e-001, 3.595927e-001, 3.595950e-001, 3.595973e-001, 3.595996e-001, 3.596019e-001, 3.596041e-001, 3.596064e-001, 3.596087e-001, 3.596110e-001, 3.596133e-001, 3.596156e-001, 3.596179e-001, 3.596202e-001, 3.596224e-001, 3.596247e-001, 3.596270e-001, 3.596293e-001, 3.596316e-001, 3.596339e-001, 3.596361e-001, 3.596384e-001, 3.596407e-001, 3.596430e-001, 3.596453e-001, 3.596475e-001, 3.596498e-001, 3.596521e-001, 3.596544e-001, 3.596567e-001, 3.596589e-001, 3.596612e-001, 3.596635e-001, 3.596658e-001, 3.596681e-001, 3.596703e-001, 3.596726e-001, 3.596749e-001, 3.596772e-001, 3.596794e-001, 
3.596817e-001, 3.596840e-001, 3.596863e-001, 3.596885e-001, 3.596908e-001, 3.596931e-001, 3.596954e-001, 3.596976e-001, 3.596999e-001, 3.597022e-001, 3.597045e-001, 3.597067e-001, 3.597090e-001, 3.597113e-001, 3.597136e-001, 3.597158e-001, 3.597181e-001, 3.597204e-001, 3.597226e-001, 3.597249e-001, 3.597272e-001, 3.597294e-001, 3.597317e-001, 3.597340e-001, 3.597362e-001, 3.597385e-001, 3.597408e-001, 3.597430e-001, 3.597453e-001, 3.597476e-001, 3.597498e-001, 3.597521e-001, 3.597544e-001, 3.597566e-001, 3.597589e-001, 3.597612e-001, 3.597634e-001, 3.597657e-001, 3.597680e-001, 3.597702e-001, 3.597725e-001, 3.597747e-001, 3.597770e-001, 3.597793e-001, 3.597815e-001, 3.597838e-001, 3.597860e-001, 3.597883e-001, 3.597906e-001, 3.597928e-001, 3.597951e-001, 3.597973e-001, 3.597996e-001, 3.598019e-001, 3.598041e-001, 3.598064e-001, 3.598086e-001, 3.598109e-001, 3.598131e-001, 3.598154e-001, 3.598177e-001, 3.598199e-001, 3.598222e-001, 3.598244e-001, 3.598267e-001, 3.598289e-001, 3.598312e-001, 3.598334e-001, 3.598357e-001, 3.598379e-001, 3.598402e-001, 3.598424e-001, 3.598447e-001, 3.598469e-001, 3.598492e-001, 3.598515e-001, 3.598537e-001, 3.598560e-001, 3.598582e-001, 3.598604e-001, 3.598627e-001, 3.598649e-001, 3.598672e-001, 3.598694e-001, 3.598717e-001, 3.598739e-001, 3.598762e-001, 3.598784e-001, 3.598807e-001, 3.598829e-001, 3.598852e-001, 3.598874e-001, 3.598897e-001, 3.598919e-001, 3.598941e-001, 3.598964e-001, 3.598986e-001, 3.599009e-001, 3.599031e-001, 3.599054e-001, 
3.599076e-001, 3.599098e-001, 3.599121e-001, 3.599143e-001, 3.599166e-001, 3.599188e-001, 3.599210e-001, 3.599233e-001, 3.599255e-001, 3.599278e-001, 3.599300e-001, 3.599322e-001, 3.599345e-001, 3.599367e-001, 3.599390e-001, 3.599412e-001, 3.599434e-001, 3.599457e-001, 3.599479e-001, 3.599501e-001, 3.599524e-001, 3.599546e-001, 3.599568e-001, 3.599591e-001, 3.599613e-001, 3.599635e-001, 3.599658e-001, 3.599680e-001, 3.599702e-001, 3.599725e-001, 3.599747e-001, 3.599769e-001, 3.599792e-001, 3.599814e-001, 3.599836e-001, 3.599859e-001, 3.599881e-001, 3.599903e-001, 3.599925e-001, 3.599948e-001, 3.599970e-001, 3.599992e-001, 3.600015e-001, 3.600037e-001, 3.600059e-001, 3.600081e-001, 3.600104e-001, 3.600126e-001, 3.600148e-001, 3.600170e-001, 3.600193e-001, 3.600215e-001, 3.600237e-001, 3.600259e-001, 3.600282e-001, 3.600304e-001, 3.600326e-001, 3.600348e-001, 3.600371e-001, 3.600393e-001, 3.600415e-001, 3.600437e-001, 3.600459e-001, 3.600482e-001, 3.600504e-001, 3.600526e-001, 3.600548e-001, 3.600570e-001, 3.600593e-001, 3.600615e-001, 3.600637e-001, 3.600659e-001, 3.600681e-001, 3.600703e-001, 3.600726e-001, 3.600748e-001, 3.600770e-001, 3.600792e-001, 3.600814e-001, 3.600836e-001, 3.600859e-001, 3.600881e-001, 3.600903e-001, 3.600925e-001, 3.600947e-001, 3.600969e-001, 3.600991e-001, 3.601013e-001, 3.601036e-001, 3.601058e-001, 3.601080e-001, 3.601102e-001, 3.601124e-001, 3.601146e-001, 3.601168e-001, 3.601190e-001, 3.601212e-001, 3.601235e-001, 3.601257e-001, 3.601279e-001, 
3.601301e-001, 3.601323e-001, 3.601345e-001, 3.601367e-001, 3.601389e-001, 3.601411e-001, 3.601433e-001, 3.601455e-001, 3.601477e-001, 3.601499e-001, 3.601521e-001, 3.601543e-001, 3.601565e-001, 3.601587e-001, 3.601610e-001, 3.601632e-001, 3.601654e-001, 3.601676e-001, 3.601698e-001, 3.601720e-001, 3.601742e-001, 3.601764e-001, 3.601786e-001, 3.601808e-001, 3.601830e-001, 3.601852e-001, 3.601874e-001, 3.601896e-001, 3.601918e-001, 3.601940e-001, 3.601962e-001, 3.601984e-001, 3.602006e-001, 3.602028e-001, 3.602049e-001, 3.602071e-001, 3.602093e-001, 3.602115e-001, 3.602137e-001, 3.602159e-001, 3.602181e-001, 3.602203e-001, 3.602225e-001, 3.602247e-001, 3.602269e-001, 3.602291e-001, 3.602313e-001, 3.602335e-001, 3.602357e-001, 3.602379e-001, 3.602400e-001, 3.602422e-001, 3.602444e-001, 3.602466e-001, 3.602488e-001, 3.602510e-001, 3.602532e-001, 3.602554e-001, 3.602576e-001, 3.602597e-001, 3.602619e-001, 3.602641e-001, 3.602663e-001, 3.602685e-001, 3.602707e-001, 3.602729e-001, 3.602751e-001, 3.602772e-001, 3.602794e-001, 3.602816e-001, 3.602838e-001, 3.602860e-001, 3.602882e-001, 3.602903e-001, 3.602925e-001, 3.602947e-001, 3.602969e-001, 3.602991e-001, 3.603013e-001, 3.603034e-001, 3.603056e-001, 3.603078e-001, 3.603100e-001, 3.603122e-001, 3.603143e-001, 3.603165e-001, 3.603187e-001, 3.603209e-001, 3.603231e-001, 3.603252e-001, 3.603274e-001, 3.603296e-001, 3.603318e-001, 3.603339e-001, 3.603361e-001, 3.603383e-001, 3.603405e-001, 3.603426e-001, 3.603448e-001, 3.603470e-001, 
3.603492e-001, 3.603513e-001, 3.603535e-001, 3.603557e-001, 3.603579e-001, 3.603600e-001, 3.603622e-001, 3.603644e-001, 3.603665e-001, 3.603687e-001, 3.603709e-001, 3.603731e-001, 3.603752e-001, 3.603774e-001, 3.603796e-001, 3.603817e-001, 3.603839e-001, 3.603861e-001, 3.603882e-001, 3.603904e-001, 3.603926e-001, 3.603947e-001, 3.603969e-001, 3.603991e-001, 3.604012e-001, 3.604034e-001, 3.604056e-001, 3.604077e-001, 3.604099e-001, 3.604121e-001, 3.604142e-001, 3.604164e-001, 3.604186e-001, 3.604207e-001, 3.604229e-001, 3.604250e-001, 3.604272e-001, 3.604294e-001, 3.604315e-001, 3.604337e-001, 3.604359e-001, 3.604380e-001, 3.604402e-001, 3.604423e-001, 3.604445e-001, 3.604467e-001, 3.604488e-001, 3.604510e-001, 3.604531e-001, 3.604553e-001, 3.604574e-001, 3.604596e-001, 3.604618e-001, 3.604639e-001, 3.604661e-001, 3.604682e-001, 3.604704e-001, 3.604725e-001, 3.604747e-001, 3.604768e-001, 3.604790e-001, 3.604811e-001, 3.604833e-001, 3.604855e-001, 3.604876e-001, 3.604898e-001, 3.604919e-001, 3.604941e-001, 3.604962e-001, 3.604984e-001, 3.605005e-001, 3.605027e-001, 3.605048e-001, 3.605070e-001, 3.605091e-001, 3.605113e-001, 3.605134e-001, 3.605156e-001, 3.605177e-001, 3.605199e-001, 3.605220e-001, 3.605241e-001, 3.605263e-001, 3.605284e-001, 3.605306e-001, 3.605327e-001, 3.605349e-001, 3.605370e-001, 3.605392e-001, 3.605413e-001, 3.605435e-001, 3.605456e-001, 3.605477e-001, 3.605499e-001, 3.605520e-001, 3.605542e-001, 3.605563e-001, 3.605585e-001, 3.605606e-001, 3.605627e-001, 
3.605649e-001, 3.605670e-001, 3.605692e-001, 3.605713e-001, 3.605734e-001, 3.605756e-001, 3.605777e-001, 3.605798e-001, 3.605820e-001, 3.605841e-001, 3.605863e-001, 3.605884e-001, 3.605905e-001, 3.605927e-001, 3.605948e-001, 3.605969e-001, 3.605991e-001, 3.606012e-001, 3.606033e-001, 3.606055e-001, 3.606076e-001, 3.606097e-001, 3.606119e-001, 3.606140e-001, 3.606161e-001, 3.606183e-001, 3.606204e-001, 3.606225e-001, 3.606247e-001, 3.606268e-001, 3.606289e-001, 3.606311e-001, 3.606332e-001, 3.606353e-001, 3.606374e-001, 3.606396e-001, 3.606417e-001, 3.606438e-001, 3.606460e-001, 3.606481e-001, 3.606502e-001, 3.606523e-001, 3.606545e-001, 3.606566e-001, 3.606587e-001, 3.606608e-001, 3.606630e-001, 3.606651e-001, 3.606672e-001, 3.606693e-001, 3.606715e-001, 3.606736e-001, 3.606757e-001, 3.606778e-001, 3.606800e-001, 3.606821e-001, 3.606842e-001, 3.606863e-001, 3.606884e-001, 3.606906e-001, 3.606927e-001, 3.606948e-001, 3.606969e-001, 3.606990e-001, 3.607012e-001, 3.607033e-001, 3.607054e-001, 3.607075e-001, 3.607096e-001, 3.607117e-001, 3.607139e-001, 3.607160e-001, 3.607181e-001, 3.607202e-001, 3.607223e-001, 3.607244e-001, 3.607266e-001, 3.607287e-001, 3.607308e-001, 3.607329e-001, 3.607350e-001, 3.607371e-001, 3.607392e-001, 3.607414e-001, 3.607435e-001, 3.607456e-001, 3.607477e-001, 3.607498e-001, 3.607519e-001, 3.607540e-001, 3.607561e-001, 3.607582e-001, 3.607604e-001, 3.607625e-001, 3.607646e-001, 3.607667e-001, 3.607688e-001, 3.607709e-001, 3.607730e-001, 3.607751e-001, 
3.607772e-001, 3.607793e-001, 3.607814e-001, 3.607835e-001, 3.607856e-001, 3.607877e-001, 3.607898e-001, 3.607920e-001, 3.607941e-001, 3.607962e-001, 3.607983e-001, 3.608004e-001, 3.608025e-001, 3.608046e-001, 3.608067e-001, 3.608088e-001, 3.608109e-001, 3.608130e-001, 3.608151e-001, 3.608172e-001, 3.608193e-001, 3.608214e-001, 3.608235e-001, 3.608256e-001, 3.608277e-001, 3.608298e-001, 3.608319e-001, 3.608340e-001, 3.608361e-001, 3.608382e-001, 3.608403e-001, 3.608424e-001, 3.608445e-001, 3.608465e-001, 3.608486e-001, 3.608507e-001, 3.608528e-001, 3.608549e-001, 3.608570e-001, 3.608591e-001, 3.608612e-001, 3.608633e-001, 3.608654e-001, 3.608675e-001, 3.608696e-001, 3.608717e-001, 3.608738e-001, 3.608759e-001, 3.608779e-001, 3.608800e-001, 3.608821e-001, 3.608842e-001, 3.608863e-001, 3.608884e-001, 3.608905e-001, 3.608926e-001, 3.608947e-001, 3.608967e-001, 3.608988e-001, 3.609009e-001, 3.609030e-001, 3.609051e-001, 3.609072e-001, 3.609093e-001, 3.609114e-001, 3.609134e-001, 3.609155e-001, 3.609176e-001, 3.609197e-001, 3.609218e-001, 3.609239e-001, 3.609259e-001, 3.609280e-001, 3.609301e-001, 3.609322e-001, 3.609343e-001, 3.609363e-001, 3.609384e-001, 3.609405e-001, 3.609426e-001, 3.609447e-001, 3.609468e-001, 3.609488e-001, 3.609509e-001, 3.609530e-001, 3.609551e-001, 3.609571e-001, 3.609592e-001, 3.609613e-001, 3.609634e-001, 3.609655e-001, 3.609675e-001, 3.609696e-001, 3.609717e-001, 3.609738e-001, 3.609758e-001, 3.609779e-001, 3.609800e-001, 3.609821e-001, 3.609841e-001, 
3.609862e-001, 3.609883e-001, 3.609903e-001, 3.609924e-001, 3.609945e-001, 3.609966e-001, 3.609986e-001, 3.610007e-001, 3.610028e-001, 3.610048e-001, 3.610069e-001, 3.610090e-001, 3.610111e-001, 3.610131e-001, 3.610152e-001, 3.610173e-001, 3.610193e-001, 3.610214e-001, 3.610235e-001, 3.610255e-001, 3.610276e-001, 3.610297e-001, 3.610317e-001, 3.610338e-001, 3.610359e-001, 3.610379e-001, 3.610400e-001, 3.610421e-001, 3.610441e-001, 3.610462e-001, 3.610482e-001, 3.610503e-001, 3.610524e-001, 3.610544e-001, 3.610565e-001, 3.610586e-001, 3.610606e-001, 3.610627e-001, 3.610647e-001, 3.610668e-001, 3.610689e-001, 3.610709e-001, 3.610730e-001, 3.610750e-001, 3.610771e-001, 3.610792e-001, 3.610812e-001, 3.610833e-001, 3.610853e-001, 3.610874e-001, 3.610894e-001, 3.610915e-001, 3.610936e-001, 3.610956e-001, 3.610977e-001, 3.610997e-001, 3.611018e-001, 3.611038e-001, 3.611059e-001, 3.611079e-001, 3.611100e-001, 3.611120e-001, 3.611141e-001, 3.611161e-001, 3.611182e-001, 3.611202e-001, 3.611223e-001, 3.611243e-001, 3.611264e-001, 3.611284e-001, 3.611305e-001, 3.611325e-001, 3.611346e-001, 3.611366e-001, 3.611387e-001, 3.611407e-001, 3.611428e-001, 3.611448e-001, 3.611469e-001, 3.611489e-001, 3.611510e-001, 3.611530e-001, 3.611551e-001, 3.611571e-001, 3.611592e-001, 3.611612e-001, 3.611633e-001, 3.611653e-001, 3.611673e-001, 3.611694e-001, 3.611714e-001, 3.611735e-001, 3.611755e-001, 3.611776e-001, 3.611796e-001, 3.611816e-001, 3.611837e-001, 3.611857e-001, 3.611878e-001, 3.611898e-001, 
3.611918e-001, 3.611939e-001, 3.611959e-001, 3.611980e-001, 3.612000e-001, 3.612020e-001, 3.612041e-001, 3.612061e-001, 3.612081e-001, 3.612102e-001, 3.612122e-001, 3.612143e-001, 3.612163e-001, 3.612183e-001, 3.612204e-001, 3.612224e-001, 3.612244e-001, 3.612265e-001, 3.612285e-001, 3.612305e-001, 3.612326e-001, 3.612346e-001, 3.612366e-001, 3.612387e-001, 3.612407e-001, 3.612427e-001, 3.612448e-001, 3.612468e-001, 3.612488e-001, 3.612509e-001, 3.612529e-001, 3.612549e-001, 3.612569e-001, 3.612590e-001, 3.612610e-001, 3.612630e-001, 3.612651e-001, 3.612671e-001, 3.612691e-001, 3.612711e-001, 3.612732e-001, 3.612752e-001, 3.612772e-001, 3.612792e-001, 3.612813e-001, 3.612833e-001, 3.612853e-001, 3.612873e-001, 3.612894e-001, 3.612914e-001, 3.612934e-001, 3.612954e-001, 3.612975e-001, 3.612995e-001, 3.613015e-001, 3.613035e-001, 3.613055e-001, 3.613076e-001, 3.613096e-001, 3.613116e-001, 3.613136e-001, 3.613156e-001, 3.613177e-001, 3.613197e-001, 3.613217e-001, 3.613237e-001, 3.613257e-001, 3.613278e-001, 3.613298e-001, 3.613318e-001, 3.613338e-001, 3.613358e-001, 3.613378e-001, 3.613399e-001, 3.613419e-001, 3.613439e-001, 3.613459e-001, 3.613479e-001, 3.613499e-001, 3.613519e-001, 3.613540e-001, 3.613560e-001, 3.613580e-001, 3.613600e-001, 3.613620e-001, 3.613640e-001, 3.613660e-001, 3.613680e-001, 3.613700e-001, 3.613721e-001, 3.613741e-001, 3.613761e-001, 3.613781e-001, 3.613801e-001, 3.613821e-001, 3.613841e-001, 3.613861e-001, 3.613881e-001, 3.613901e-001, 3.613921e-001, 
3.613941e-001, 3.613962e-001, 3.613982e-001, 3.614002e-001, 3.614022e-001, 3.614042e-001, 3.614062e-001, 3.614082e-001, 3.614102e-001, 3.614122e-001, 3.614142e-001, 3.614162e-001, 3.614182e-001, 3.614202e-001, 3.614222e-001, 3.614242e-001, 3.614262e-001, 3.614282e-001, 3.614302e-001, 3.614322e-001, 3.614342e-001, 3.614362e-001, 3.614382e-001, 3.614402e-001, 3.614422e-001, 3.614442e-001, 3.614462e-001, 3.614482e-001, 3.614502e-001, 3.614522e-001, 3.614542e-001, 3.614562e-001, 3.614582e-001, 3.614602e-001, 3.614622e-001, 3.614642e-001, 3.614662e-001, 3.614682e-001, 3.614702e-001, 3.614721e-001, 3.614741e-001, 3.614761e-001, 3.614781e-001, 3.614801e-001, 3.614821e-001, 3.614841e-001, 3.614861e-001, 3.614881e-001, 3.614901e-001, 3.614921e-001, 3.614941e-001, 3.614960e-001, 3.614980e-001, 3.615000e-001, 3.615020e-001, 3.615040e-001, 3.615060e-001, 3.615080e-001, 3.615100e-001, 3.615120e-001, 3.615139e-001, 3.615159e-001, 3.615179e-001, 3.615199e-001, 3.615219e-001, 3.615239e-001, 3.615259e-001, 3.615278e-001, 3.615298e-001, 3.615318e-001, 3.615338e-001, 3.615358e-001, 3.615378e-001, 3.615397e-001, 3.615417e-001, 3.615437e-001, 3.615457e-001, 3.615477e-001, 3.615496e-001, 3.615516e-001, 3.615536e-001, 3.615556e-001, 3.615576e-001, 3.615595e-001, 3.615615e-001, 3.615635e-001, 3.615655e-001, 3.615675e-001, 3.615694e-001, 3.615714e-001, 3.615734e-001, 3.615754e-001, 3.615773e-001, 3.615793e-001, 3.615813e-001, 3.615833e-001, 3.615852e-001, 3.615872e-001, 3.615892e-001, 3.615912e-001, 
3.615931e-001, 3.615951e-001, 3.615971e-001, 3.615991e-001, 3.616010e-001, 3.616030e-001, 3.616050e-001, 3.616069e-001, 3.616089e-001, 3.616109e-001, 3.616129e-001, 3.616148e-001, 3.616168e-001, 3.616188e-001, 3.616207e-001, 3.616227e-001, 3.616247e-001, 3.616266e-001, 3.616286e-001, 3.616306e-001, 3.616325e-001, 3.616345e-001, 3.616365e-001, 3.616384e-001, 3.616404e-001, 3.616424e-001, 3.616443e-001, 3.616463e-001, 3.616483e-001, 3.616502e-001, 3.616522e-001, 3.616541e-001, 3.616561e-001, 3.616581e-001, 3.616600e-001, 3.616620e-001, 3.616640e-001, 3.616659e-001, 3.616679e-001, 3.616698e-001, 3.616718e-001, 3.616738e-001, 3.616757e-001, 3.616777e-001, 3.616796e-001, 3.616816e-001, 3.616836e-001, 3.616855e-001, 3.616875e-001, 3.616894e-001, 3.616914e-001, 3.616933e-001, 3.616953e-001, 3.616973e-001, 3.616992e-001, 3.617012e-001, 3.617031e-001, 3.617051e-001, 3.617070e-001, 3.617090e-001, 3.617109e-001, 3.617129e-001, 3.617148e-001, 3.617168e-001, 3.617187e-001, 3.617207e-001, 3.617227e-001, 3.617246e-001, 3.617266e-001, 3.617285e-001, 3.617305e-001, 3.617324e-001, 3.617344e-001, 3.617363e-001, 3.617383e-001, 3.617402e-001, 3.617421e-001, 3.617441e-001, 3.617460e-001, 3.617480e-001, 3.617499e-001, 3.617519e-001, 3.617538e-001, 3.617558e-001, 3.617577e-001, 3.617597e-001, 3.617616e-001, 3.617636e-001, 3.617655e-001, 3.617674e-001, 3.617694e-001, 3.617713e-001, 3.617733e-001, 3.617752e-001, 3.617772e-001, 3.617791e-001, 3.617810e-001, 3.617830e-001, 3.617849e-001, 3.617869e-001, 
3.617888e-001, 3.617907e-001, 3.617927e-001, 3.617946e-001, 3.617966e-001, 3.617985e-001, 3.618004e-001, 3.618024e-001, 3.618043e-001, 3.618063e-001, 3.618082e-001, 3.618101e-001, 3.618121e-001, 3.618140e-001, 3.618159e-001, 3.618179e-001, 3.618198e-001, 3.618217e-001, 3.618237e-001, 3.618256e-001, 3.618275e-001, 3.618295e-001, 3.618314e-001, 3.618333e-001, 3.618353e-001, 3.618372e-001, 3.618391e-001, 3.618411e-001, 3.618430e-001, 3.618449e-001, 3.618469e-001, 3.618488e-001, 3.618507e-001, 3.618527e-001, 3.618546e-001, 3.618565e-001, 3.618584e-001, 3.618604e-001, 3.618623e-001, 3.618642e-001, 3.618662e-001, 3.618681e-001, 3.618700e-001, 3.618719e-001, 3.618739e-001, 3.618758e-001, 3.618777e-001, 3.618796e-001, 3.618816e-001, 3.618835e-001, 3.618854e-001, 3.618873e-001, 3.618893e-001, 3.618912e-001, 3.618931e-001, 3.618950e-001, 3.618969e-001, 3.618989e-001, 3.619008e-001, 3.619027e-001, 3.619046e-001, 3.619065e-001, 3.619085e-001, 3.619104e-001, 3.619123e-001, 3.619142e-001, 3.619161e-001, 3.619181e-001, 3.619200e-001, 3.619219e-001, 3.619238e-001, 3.619257e-001, 3.619277e-001, 3.619296e-001, 3.619315e-001, 3.619334e-001, 3.619353e-001, 3.619372e-001, 3.619391e-001, 3.619411e-001, 3.619430e-001, 3.619449e-001, 3.619468e-001, 3.619487e-001, 3.619506e-001, 3.619525e-001, 3.619544e-001, 3.619564e-001, 3.619583e-001, 3.619602e-001, 3.619621e-001, 3.619640e-001, 3.619659e-001, 3.619678e-001, 3.619697e-001, 3.619716e-001, 3.619736e-001, 3.619755e-001, 3.619774e-001, 3.619793e-001, 
3.619812e-001, 3.619831e-001, 3.619850e-001, 3.619869e-001, 3.619888e-001, 3.619907e-001, 3.619926e-001, 3.619945e-001, 3.619964e-001, 3.619983e-001, 3.620002e-001, 3.620021e-001, 3.620040e-001, 3.620060e-001, 3.620079e-001, 3.620098e-001, 3.620117e-001, 3.620136e-001, 3.620155e-001, 3.620174e-001, 3.620193e-001, 3.620212e-001, 3.620231e-001, 3.620250e-001, 3.620269e-001, 3.620288e-001, 3.620307e-001, 3.620326e-001, 3.620345e-001, 3.620364e-001, 3.620383e-001, 3.620402e-001, 3.620420e-001, 3.620439e-001, 3.620458e-001, 3.620477e-001, 3.620496e-001, 3.620515e-001, 3.620534e-001, 3.620553e-001, 3.620572e-001, 3.620591e-001, 3.620610e-001, 3.620629e-001, 3.620648e-001, 3.620667e-001, 3.620686e-001, 3.620705e-001, 3.620724e-001, 3.620742e-001, 3.620761e-001, 3.620780e-001, 3.620799e-001, 3.620818e-001, 3.620837e-001, 3.620856e-001, 3.620875e-001, 3.620894e-001, 3.620913e-001, 3.620931e-001, 3.620950e-001, 3.620969e-001, 3.620988e-001, 3.621007e-001, 3.621026e-001, 3.621045e-001, 3.621063e-001, 3.621082e-001, 3.621101e-001, 3.621120e-001, 3.621139e-001, 3.621158e-001, 3.621177e-001, 3.621195e-001, 3.621214e-001, 3.621233e-001, 3.621252e-001, 3.621271e-001, 3.621290e-001, 3.621308e-001, 3.621327e-001, 3.621346e-001, 3.621365e-001, 3.621384e-001, 3.621402e-001, 3.621421e-001, 3.621440e-001, 3.621459e-001, 3.621478e-001, 3.621496e-001, 3.621515e-001, 3.621534e-001, 3.621553e-001, 3.621571e-001, 3.621590e-001, 3.621609e-001, 3.621628e-001, 3.621646e-001, 3.621665e-001, 3.621684e-001, 
3.621703e-001, 3.621721e-001, 3.621740e-001, 3.621759e-001, 3.621778e-001, 3.621796e-001, 3.621815e-001, 3.621834e-001, 3.621853e-001, 3.621871e-001, 3.621890e-001, 3.621909e-001, 3.621927e-001, 3.621946e-001, 3.621965e-001, 3.621983e-001, 3.622002e-001, 3.622021e-001, 3.622040e-001, 3.622058e-001, 3.622077e-001, 3.622096e-001, 3.622114e-001, 3.622133e-001, 3.622152e-001, 3.622170e-001, 3.622189e-001, 3.622208e-001, 3.622226e-001, 3.622245e-001, 3.622264e-001, 3.622282e-001, 3.622301e-001, 3.622319e-001, 3.622338e-001, 3.622357e-001, 3.622375e-001, 3.622394e-001, 3.622413e-001, 3.622431e-001, 3.622450e-001, 3.622468e-001, 3.622487e-001, 3.622506e-001, 3.622524e-001, 3.622543e-001, 3.622561e-001, 3.622580e-001, 3.622599e-001, 3.622617e-001, 3.622636e-001, 3.622654e-001, 3.622673e-001, 3.622692e-001, 3.622710e-001, 3.622729e-001, 3.622747e-001, 3.622766e-001, 3.622784e-001, 3.622803e-001, 3.622821e-001, 3.622840e-001, 3.622859e-001, 3.622877e-001, 3.622896e-001, 3.622914e-001, 3.622933e-001, 3.622951e-001, 3.622970e-001, 3.622988e-001, 3.623007e-001, 3.623025e-001, 3.623044e-001, 3.623062e-001, 3.623081e-001, 3.623099e-001, 3.623118e-001, 3.623136e-001, 3.623155e-001, 3.623173e-001, 3.623192e-001, 3.623210e-001, 3.623229e-001, 3.623247e-001, 3.623266e-001, 3.623284e-001, 3.623303e-001, 3.623321e-001, 3.623340e-001, 3.623358e-001, 3.623376e-001, 3.623395e-001, 3.623413e-001, 3.623432e-001, 3.623450e-001, 3.623469e-001, 3.623487e-001, 3.623505e-001, 3.623524e-001, 3.623542e-001, 
3.623561e-001, 3.623579e-001, 3.623598e-001, 3.623616e-001, 3.623634e-001, 3.623653e-001, 3.623671e-001, 3.623690e-001, 3.623708e-001, 3.623726e-001, 3.623745e-001, 3.623763e-001, 3.623782e-001, 3.623800e-001, 3.623818e-001, 3.623837e-001, 3.623855e-001, 3.623873e-001, 3.623892e-001, 3.623910e-001, 3.623928e-001, 3.623947e-001, 3.623965e-001, 3.623983e-001, 3.624002e-001, 3.624020e-001, 3.624038e-001, 3.624057e-001, 3.624075e-001, 3.624093e-001, 3.624112e-001, 3.624130e-001, 3.624148e-001, 3.624167e-001, 3.624185e-001, 3.624203e-001, 3.624222e-001, 3.624240e-001, 3.624258e-001, 3.624277e-001, 3.624295e-001, 3.624313e-001, 3.624331e-001, 3.624350e-001, 3.624368e-001, 3.624386e-001, 3.624404e-001, 3.624423e-001, 3.624441e-001, 3.624459e-001, 3.624478e-001, 3.624496e-001, 3.624514e-001, 3.624532e-001, 3.624550e-001, 3.624569e-001, 3.624587e-001, 3.624605e-001, 3.624623e-001, 3.624642e-001, 3.624660e-001, 3.624678e-001, 3.624696e-001, 3.624715e-001, 3.624733e-001, 3.624751e-001, 3.624769e-001, 3.624787e-001, 3.624806e-001, 3.624824e-001, 3.624842e-001, 3.624860e-001, 3.624878e-001, 3.624896e-001, 3.624915e-001, 3.624933e-001, 3.624951e-001, 3.624969e-001, 3.624987e-001, 3.625005e-001, 3.625024e-001, 3.625042e-001, 3.625060e-001, 3.625078e-001, 3.625096e-001, 3.625114e-001, 3.625133e-001, 3.625151e-001, 3.625169e-001, 3.625187e-001, 3.625205e-001, 3.625223e-001, 3.625241e-001, 3.625259e-001, 3.625278e-001, 3.625296e-001, 3.625314e-001, 3.625332e-001, 3.625350e-001, 3.625368e-001, 
3.625386e-001, 3.625404e-001, 3.625422e-001, 3.625440e-001, 3.625458e-001, 3.625477e-001, 3.625495e-001, 3.625513e-001, 3.625531e-001, 3.625549e-001, 3.625567e-001, 3.625585e-001, 3.625603e-001, 3.625621e-001, 3.625639e-001, 3.625657e-001, 3.625675e-001, 3.625693e-001, 3.625711e-001, 3.625729e-001, 3.625747e-001, 3.625765e-001, 3.625783e-001, 3.625801e-001, 3.625819e-001, 3.625837e-001, 3.625855e-001, 3.625873e-001, 3.625891e-001, 3.625909e-001, 3.625927e-001, 3.625945e-001, 3.625963e-001, 3.625981e-001, 3.625999e-001, 3.626017e-001, 3.626035e-001, 3.626053e-001, 3.626071e-001, 3.626089e-001, 3.626107e-001, 3.626125e-001, 3.626143e-001, 3.626161e-001, 3.626179e-001, 3.626197e-001, 3.626215e-001, 3.626233e-001, 3.626251e-001, 3.626269e-001, 3.626287e-001, 3.626305e-001, 3.626322e-001, 3.626340e-001, 3.626358e-001, 3.626376e-001, 3.626394e-001, 3.626412e-001, 3.626430e-001, 3.626448e-001, 3.626466e-001, 3.626484e-001, 3.626501e-001, 3.626519e-001, 3.626537e-001, 3.626555e-001, 3.626573e-001, 3.626591e-001, 3.626609e-001, 3.626627e-001, 3.626644e-001, 3.626662e-001, 3.626680e-001, 3.626698e-001, 3.626716e-001, 3.626734e-001, 3.626752e-001, 3.626769e-001, 3.626787e-001, 3.626805e-001, 3.626823e-001, 3.626841e-001, 3.626859e-001, 3.626876e-001, 3.626894e-001, 3.626912e-001, 3.626930e-001, 3.626948e-001, 3.626966e-001, 3.626983e-001, 3.627001e-001, 3.627019e-001, 3.627037e-001, 3.627054e-001, 3.627072e-001, 3.627090e-001, 3.627108e-001, 3.627126e-001, 3.627143e-001, 3.627161e-001, 
3.627179e-001, 3.627197e-001, 3.627214e-001, 3.627232e-001, 3.627250e-001, 3.627268e-001, 3.627285e-001, 3.627303e-001, 3.627321e-001, 3.627339e-001, 3.627356e-001, 3.627374e-001, 3.627392e-001, 3.627410e-001, 3.627427e-001, 3.627445e-001, 3.627463e-001, 3.627480e-001, 3.627498e-001, 3.627516e-001, 3.627534e-001, 3.627551e-001, 3.627569e-001, 3.627587e-001, 3.627604e-001, 3.627622e-001, 3.627640e-001, 3.627657e-001, 3.627675e-001, 3.627693e-001, 3.627710e-001, 3.627728e-001, 3.627746e-001, 3.627763e-001, 3.627781e-001, 3.627799e-001, 3.627816e-001, 3.627834e-001, 3.627852e-001, 3.627869e-001, 3.627887e-001, 3.627905e-001, 3.627922e-001, 3.627940e-001, 3.627957e-001, 3.627975e-001, 3.627993e-001, 3.628010e-001, 3.628028e-001, 3.628046e-001, 3.628063e-001, 3.628081e-001, 3.628098e-001, 3.628116e-001, 3.628134e-001, 3.628151e-001, 3.628169e-001, 3.628186e-001, 3.628204e-001, 3.628221e-001, 3.628239e-001, 3.628257e-001, 3.628274e-001, 3.628292e-001, 3.628309e-001, 3.628327e-001, 3.628344e-001, 3.628362e-001, 3.628379e-001, 3.628397e-001, 3.628415e-001, 3.628432e-001, 3.628450e-001, 3.628467e-001, 3.628485e-001, 3.628502e-001, 3.628520e-001, 3.628537e-001, 3.628555e-001, 3.628572e-001, 3.628590e-001, 3.628607e-001, 3.628625e-001, 3.628642e-001, 3.628660e-001, 3.628677e-001, 3.628695e-001, 3.628712e-001, 3.628730e-001, 3.628747e-001, 3.628765e-001, 3.628782e-001, 3.628800e-001, 3.628817e-001, 3.628835e-001, 3.628852e-001, 3.628869e-001, 3.628887e-001, 3.628904e-001, 3.628922e-001, 
3.628939e-001, 3.628957e-001, 3.628974e-001, 3.628992e-001, 3.629009e-001, 3.629026e-001, 3.629044e-001, 3.629061e-001, 3.629079e-001, 3.629096e-001, 3.629114e-001, 3.629131e-001, 3.629148e-001, 3.629166e-001, 3.629183e-001, 3.629201e-001, 3.629218e-001, 3.629235e-001, 3.629253e-001, 3.629270e-001, 3.629287e-001, 3.629305e-001, 3.629322e-001, 3.629340e-001, 3.629357e-001, 3.629374e-001, 3.629392e-001, 3.629409e-001, 3.629426e-001, 3.629444e-001, 3.629461e-001, 3.629478e-001, 3.629496e-001, 3.629513e-001, 3.629530e-001, 3.629548e-001, 3.629565e-001, 3.629582e-001, 3.629600e-001, 3.629617e-001, 3.629634e-001, 3.629652e-001, 3.629669e-001, 3.629686e-001, 3.629704e-001, 3.629721e-001, 3.629738e-001, 3.629755e-001, 3.629773e-001, 3.629790e-001, 3.629807e-001, 3.629825e-001, 3.629842e-001, 3.629859e-001, 3.629876e-001, 3.629894e-001, 3.629911e-001, 3.629928e-001, 3.629945e-001, 3.629963e-001, 3.629980e-001, 3.629997e-001, 3.630014e-001, 3.630032e-001, 3.630049e-001, 3.630066e-001, 3.630083e-001, 3.630101e-001, 3.630118e-001, 3.630135e-001, 3.630152e-001, 3.630169e-001, 3.630187e-001, 3.630204e-001, 3.630221e-001, 3.630238e-001, 3.630255e-001, 3.630273e-001, 3.630290e-001, 3.630307e-001, 3.630324e-001, 3.630341e-001, 3.630359e-001, 3.630376e-001, 3.630393e-001, 3.630410e-001, 3.630427e-001, 3.630444e-001, 3.630462e-001, 3.630479e-001, 3.630496e-001, 3.630513e-001, 3.630530e-001, 3.630547e-001, 3.630564e-001, 3.630582e-001, 3.630599e-001, 3.630616e-001, 3.630633e-001, 3.630650e-001, 
3.630667e-001, 3.630684e-001, 3.630701e-001, 3.630719e-001, 3.630736e-001, 3.630753e-001, 3.630770e-001, 3.630787e-001, 3.630804e-001, 3.630821e-001, 3.630838e-001, 3.630855e-001, 3.630872e-001, 3.630890e-001, 3.630907e-001, 3.630924e-001, 3.630941e-001, 3.630958e-001, 3.630975e-001, 3.630992e-001, 3.631009e-001, 3.631026e-001, 3.631043e-001, 3.631060e-001, 3.631077e-001, 3.631094e-001, 3.631111e-001, 3.631128e-001, 3.631145e-001, 3.631162e-001, 3.631179e-001, 3.631196e-001, 3.631213e-001, 3.631230e-001, 3.631247e-001, 3.631264e-001, 3.631281e-001, 3.631298e-001, 3.631315e-001, 3.631332e-001, 3.631349e-001, 3.631366e-001, 3.631383e-001, 3.631400e-001, 3.631417e-001, 3.631434e-001, 3.631451e-001, 3.631468e-001, 3.631485e-001, 3.631502e-001, 3.631519e-001, 3.631536e-001, 3.631553e-001, 3.631570e-001, 3.631587e-001, 3.631604e-001, 3.631621e-001, 3.631638e-001, 3.631655e-001, 3.631672e-001, 3.631689e-001, 3.631705e-001, 3.631722e-001, 3.631739e-001, 3.631756e-001, 3.631773e-001, 3.631790e-001, 3.631807e-001, 3.631824e-001, 3.631841e-001, 3.631858e-001, 3.631875e-001, 3.631891e-001, 3.631908e-001, 3.631925e-001, 3.631942e-001, 3.631959e-001, 3.631976e-001, 3.631993e-001, 3.632010e-001, 3.632026e-001, 3.632043e-001, 3.632060e-001, 3.632077e-001, 3.632094e-001, 3.632111e-001, 3.632127e-001, 3.632144e-001, 3.632161e-001, 3.632178e-001, 3.632195e-001, 3.632212e-001, 3.632228e-001, 3.632245e-001, 3.632262e-001, 3.632279e-001, 3.632296e-001, 3.632313e-001, 3.632329e-001, 3.632346e-001, 
3.632363e-001, 3.632380e-001, 3.632397e-001, 3.632413e-001, 3.632430e-001, 3.632447e-001, 3.632464e-001, 3.632480e-001, 3.632497e-001, 3.632514e-001, 3.632531e-001, 3.632548e-001, 3.632564e-001, 3.632581e-001, 3.632598e-001, 3.632615e-001, 3.632631e-001, 3.632648e-001, 3.632665e-001, 3.632682e-001, 3.632698e-001, 3.632715e-001, 3.632732e-001, 3.632748e-001, 3.632765e-001, 3.632782e-001, 3.632799e-001, 3.632815e-001, 3.632832e-001, 3.632849e-001, 3.632865e-001, 3.632882e-001, 3.632899e-001, 3.632915e-001, 3.632932e-001, 3.632949e-001, 3.632966e-001, 3.632982e-001, 3.632999e-001, 3.633016e-001, 3.633032e-001, 3.633049e-001, 3.633066e-001, 3.633082e-001, 3.633099e-001, 3.633116e-001, 3.633132e-001, 3.633149e-001, 3.633165e-001, 3.633182e-001, 3.633199e-001, 3.633215e-001, 3.633232e-001, 3.633249e-001, 3.633265e-001, 3.633282e-001, 3.633299e-001, 3.633315e-001, 3.633332e-001, 3.633348e-001, 3.633365e-001, 3.633382e-001, 3.633398e-001, 3.633415e-001, 3.633431e-001, 3.633448e-001, 3.633465e-001, 3.633481e-001, 3.633498e-001, 3.633514e-001, 3.633531e-001, 3.633547e-001, 3.633564e-001, 3.633581e-001, 3.633597e-001, 3.633614e-001, 3.633630e-001, 3.633647e-001, 3.633663e-001, 3.633680e-001, 3.633696e-001, 3.633713e-001, 3.633729e-001, 3.633746e-001, 3.633763e-001, 3.633779e-001, 3.633796e-001, 3.633812e-001, 3.633829e-001, 3.633845e-001, 3.633862e-001, 3.633878e-001, 3.633895e-001, 3.633911e-001, 3.633928e-001, 3.633944e-001, 3.633961e-001, 3.633977e-001, 3.633994e-001, 3.634010e-001, 
3.634027e-001, 3.634043e-001, 3.634059e-001, 3.634076e-001, 3.634092e-001, 3.634109e-001, 3.634125e-001, 3.634142e-001, 3.634158e-001, 3.634175e-001, 3.634191e-001, 3.634208e-001, 3.634224e-001, 3.634240e-001, 3.634257e-001, 3.634273e-001, 3.634290e-001, 3.634306e-001, 3.634323e-001, 3.634339e-001, 3.634355e-001, 3.634372e-001, 3.634388e-001, 3.634405e-001, 3.634421e-001, 3.634437e-001, 3.634454e-001, 3.634470e-001, 3.634487e-001, 3.634503e-001, 3.634519e-001, 3.634536e-001, 3.634552e-001, 3.634568e-001, 3.634585e-001, 3.634601e-001, 3.634618e-001, 3.634634e-001, 3.634650e-001, 3.634667e-001, 3.634683e-001, 3.634699e-001, 3.634716e-001, 3.634732e-001, 3.634748e-001, 3.634765e-001, 3.634781e-001, 3.634797e-001, 3.634814e-001, 3.634830e-001, 3.634846e-001, 3.634863e-001, 3.634879e-001, 3.634895e-001, 3.634912e-001, 3.634928e-001, 3.634944e-001, 3.634960e-001, 3.634977e-001, 3.634993e-001, 3.635009e-001, 3.635026e-001, 3.635042e-001, 3.635058e-001, 3.635074e-001, 3.635091e-001, 3.635107e-001, 3.635123e-001, 3.635139e-001, 3.635156e-001, 3.635172e-001, 3.635188e-001, 3.635204e-001, 3.635221e-001, 3.635237e-001, 3.635253e-001, 3.635269e-001, 3.635286e-001, 3.635302e-001, 3.635318e-001, 3.635334e-001, 3.635351e-001, 3.635367e-001, 3.635383e-001, 3.635399e-001, 3.635415e-001, 3.635432e-001, 3.635448e-001, 3.635464e-001, 3.635480e-001, 3.635496e-001, 3.635513e-001, 3.635529e-001, 3.635545e-001, 3.635561e-001, 3.635577e-001, 3.635593e-001, 3.635610e-001, 3.635626e-001, 3.635642e-001, 
3.635658e-001, 3.635674e-001, 3.635690e-001, 3.635706e-001, 3.635723e-001, 3.635739e-001, 3.635755e-001, 3.635771e-001, 3.635787e-001, 3.635803e-001, 3.635819e-001, 3.635836e-001, 3.635852e-001, 3.635868e-001, 3.635884e-001, 3.635900e-001, 3.635916e-001, 3.635932e-001, 3.635948e-001, 3.635964e-001, 3.635981e-001, 3.635997e-001, 3.636013e-001, 3.636029e-001, 3.636045e-001, 3.636061e-001, 3.636077e-001, 3.636093e-001, 3.636109e-001, 3.636125e-001, 3.636141e-001, 3.636157e-001, 3.636173e-001, 3.636189e-001, 3.636205e-001, 3.636222e-001, 3.636238e-001, 3.636254e-001, 3.636270e-001, 3.636286e-001, 3.636302e-001, 3.636318e-001, 3.636334e-001, 3.636350e-001, 3.636366e-001, 3.636382e-001, 3.636398e-001, 3.636414e-001, 3.636430e-001, 3.636446e-001, 3.636462e-001, 3.636478e-001, 3.636494e-001, 3.636510e-001, 3.636526e-001, 3.636542e-001, 3.636558e-001, 3.636574e-001, 3.636590e-001, 3.636606e-001, 3.636622e-001, 3.636638e-001, 3.636654e-001, 3.636669e-001, 3.636685e-001, 3.636701e-001, 3.636717e-001, 3.636733e-001, 3.636749e-001, 3.636765e-001, 3.636781e-001, 3.636797e-001, 3.636813e-001, 3.636829e-001, 3.636845e-001, 3.636861e-001, 3.636877e-001, 3.636893e-001, 3.636908e-001, 3.636924e-001, 3.636940e-001, 3.636956e-001, 3.636972e-001, 3.636988e-001, 3.637004e-001, 3.637020e-001, 3.637036e-001, 3.637051e-001, 3.637067e-001, 3.637083e-001, 3.637099e-001, 3.637115e-001, 3.637131e-001, 3.637147e-001, 3.637163e-001, 3.637178e-001, 3.637194e-001, 3.637210e-001, 3.637226e-001, 3.637242e-001, 
3.637258e-001, 3.637273e-001, 3.637289e-001, 3.637305e-001, 3.637321e-001, 3.637337e-001, 3.637353e-001, 3.637368e-001, 3.637384e-001, 3.637400e-001, 3.637416e-001, 3.637432e-001, 3.637447e-001, 3.637463e-001, 3.637479e-001, 3.637495e-001, 3.637511e-001, 3.637526e-001, 3.637542e-001, 3.637558e-001, 3.637574e-001, 3.637589e-001, 3.637605e-001, 3.637621e-001, 3.637637e-001, 3.637653e-001, 3.637668e-001, 3.637684e-001, 3.637700e-001, 3.637716e-001, 3.637731e-001, 3.637747e-001, 3.637763e-001, 3.637778e-001, 3.637794e-001, 3.637810e-001, 3.637826e-001, 3.637841e-001, 3.637857e-001, 3.637873e-001, 3.637889e-001, 3.637904e-001, 3.637920e-001, 3.637936e-001, 3.637951e-001, 3.637967e-001, 3.637983e-001, 3.637998e-001, 3.638014e-001, 3.638030e-001, 3.638045e-001, 3.638061e-001, 3.638077e-001, 3.638092e-001, 3.638108e-001, 3.638124e-001, 3.638139e-001, 3.638155e-001, 3.638171e-001, 3.638186e-001, 3.638202e-001, 3.638218e-001, 3.638233e-001, 3.638249e-001, 3.638265e-001, 3.638280e-001, 3.638296e-001, 3.638311e-001, 3.638327e-001, 3.638343e-001, 3.638358e-001, 3.638374e-001, 3.638390e-001, 3.638405e-001, 3.638421e-001, 3.638436e-001, 3.638452e-001, 3.638468e-001, 3.638483e-001, 3.638499e-001, 3.638514e-001, 3.638530e-001, 3.638545e-001, 3.638561e-001, 3.638577e-001, 3.638592e-001, 3.638608e-001, 3.638623e-001, 3.638639e-001, 3.638654e-001, 3.638670e-001, 3.638686e-001, 3.638701e-001, 3.638717e-001, 3.638732e-001, 3.638748e-001, 3.638763e-001, 3.638779e-001, 3.638794e-001, 3.638810e-001, 
3.638825e-001, 3.638841e-001, 3.638856e-001, 3.638872e-001, 3.638887e-001, 3.638903e-001, 3.638918e-001, 3.638934e-001, 3.638949e-001, 3.638965e-001, 3.638980e-001, 3.638996e-001, 3.639011e-001, 3.639027e-001, 3.639042e-001, 3.639058e-001, 3.639073e-001, 3.639089e-001, 3.639104e-001, 3.639120e-001, 3.639135e-001, 3.639151e-001, 3.639166e-001, 3.639181e-001, 3.639197e-001, 3.639212e-001, 3.639228e-001, 3.639243e-001, 3.639259e-001, 3.639274e-001, 3.639289e-001, 3.639305e-001, 3.639320e-001, 3.639336e-001, 3.639351e-001, 3.639367e-001, 3.639382e-001, 3.639397e-001, 3.639413e-001, 3.639428e-001, 3.639444e-001, 3.639459e-001, 3.639474e-001, 3.639490e-001, 3.639505e-001, 3.639520e-001, 3.639536e-001, 3.639551e-001, 3.639567e-001, 3.639582e-001, 3.639597e-001, 3.639613e-001, 3.639628e-001, 3.639643e-001, 3.639659e-001, 3.639674e-001, 3.639689e-001, 3.639705e-001, 3.639720e-001, 3.639735e-001, 3.639751e-001, 3.639766e-001, 3.639781e-001, 3.639797e-001, 3.639812e-001, 3.639827e-001, 3.639843e-001, 3.639858e-001, 3.639873e-001, 3.639889e-001, 3.639904e-001, 3.639919e-001, 3.639934e-001, 3.639950e-001, 3.639965e-001, 3.639980e-001, 3.639996e-001, 3.640011e-001, 3.640026e-001, 3.640041e-001, 3.640057e-001, 3.640072e-001, 3.640087e-001, 3.640102e-001, 3.640118e-001, 3.640133e-001, 3.640148e-001, 3.640163e-001, 3.640179e-001, 3.640194e-001, 3.640209e-001, 3.640224e-001, 3.640240e-001, 3.640255e-001, 3.640270e-001, 3.640285e-001, 3.640300e-001, 3.640316e-001, 3.640331e-001, 3.640346e-001, 
3.640361e-001, 3.640376e-001, 3.640392e-001, 3.640407e-001, 3.640422e-001, 3.640437e-001, 3.640452e-001, 3.640468e-001, 3.640483e-001, 3.640498e-001, 3.640513e-001, 3.640528e-001, 3.640543e-001, 3.640559e-001, 3.640574e-001, 3.640589e-001, 3.640604e-001, 3.640619e-001, 3.640634e-001, 3.640650e-001, 3.640665e-001, 3.640680e-001, 3.640695e-001, 3.640710e-001, 3.640725e-001, 3.640740e-001, 3.640755e-001, 3.640771e-001, 3.640786e-001, 3.640801e-001, 3.640816e-001, 3.640831e-001, 3.640846e-001, 3.640861e-001, 3.640876e-001, 3.640891e-001, 3.640906e-001, 3.640922e-001, 3.640937e-001, 3.640952e-001, 3.640967e-001, 3.640982e-001, 3.640997e-001, 3.641012e-001, 3.641027e-001, 3.641042e-001, 3.641057e-001, 3.641072e-001, 3.641087e-001, 3.641102e-001, 3.641117e-001, 3.641132e-001, 3.641147e-001, 3.641163e-001, 3.641178e-001, 3.641193e-001, 3.641208e-001, 3.641223e-001, 3.641238e-001, 3.641253e-001, 3.641268e-001, 3.641283e-001, 3.641298e-001, 3.641313e-001, 3.641328e-001, 3.641343e-001, 3.641358e-001, 3.641373e-001, 3.641388e-001, 3.641403e-001, 3.641418e-001, 3.641433e-001, 3.641448e-001, 3.641463e-001, 3.641478e-001, 3.641492e-001, 3.641507e-001, 3.641522e-001, 3.641537e-001, 3.641552e-001, 3.641567e-001, 3.641582e-001, 3.641597e-001, 3.641612e-001, 3.641627e-001, 3.641642e-001, 3.641657e-001, 3.641672e-001, 3.641687e-001, 3.641702e-001, 3.641717e-001, 3.641732e-001, 3.641746e-001, 3.641761e-001, 3.641776e-001, 3.641791e-001, 3.641806e-001, 3.641821e-001, 3.641836e-001, 3.641851e-001, 
3.641866e-001, 3.641880e-001, 3.641895e-001, 3.641910e-001, 3.641925e-001, 3.641940e-001, 3.641955e-001, 3.641970e-001, 3.641985e-001, 3.641999e-001, 3.642014e-001, 3.642029e-001, 3.642044e-001, 3.642059e-001, 3.642074e-001, 3.642089e-001, 3.642103e-001, 3.642118e-001, 3.642133e-001, 3.642148e-001, 3.642163e-001, 3.642178e-001, 3.642192e-001, 3.642207e-001, 3.642222e-001, 3.642237e-001, 3.642252e-001, 3.642266e-001, 3.642281e-001, 3.642296e-001, 3.642311e-001, 3.642326e-001, 3.642340e-001, 3.642355e-001, 3.642370e-001, 3.642385e-001, 3.642399e-001, 3.642414e-001, 3.642429e-001, 3.642444e-001, 3.642459e-001, 3.642473e-001, 3.642488e-001, 3.642503e-001, 3.642518e-001, 3.642532e-001, 3.642547e-001, 3.642562e-001, 3.642576e-001, 3.642591e-001, 3.642606e-001, 3.642621e-001, 3.642635e-001, 3.642650e-001, 3.642665e-001, 3.642680e-001, 3.642694e-001, 3.642709e-001, 3.642724e-001, 3.642738e-001, 3.642753e-001, 3.642768e-001, 3.642782e-001, 3.642797e-001, 3.642812e-001, 3.642826e-001, 3.642841e-001, 3.642856e-001, 3.642871e-001, 3.642885e-001, 3.642900e-001, 3.642915e-001, 3.642929e-001, 3.642944e-001, 3.642958e-001, 3.642973e-001, 3.642988e-001, 3.643002e-001, 3.643017e-001, 3.643032e-001, 3.643046e-001, 3.643061e-001, 3.643076e-001, 3.643090e-001, 3.643105e-001, 3.643119e-001, 3.643134e-001, 3.643149e-001, 3.643163e-001, 3.643178e-001, 3.643193e-001, 3.643207e-001, 3.643222e-001, 3.643236e-001, 3.643251e-001, 3.643265e-001, 3.643280e-001, 3.643295e-001, 3.643309e-001, 3.643324e-001, 
3.643338e-001, 3.643353e-001, 3.643368e-001, 3.643382e-001, 3.643397e-001, 3.643411e-001, 3.643426e-001, 3.643440e-001, 3.643455e-001, 3.643469e-001, 3.643484e-001, 3.643498e-001, 3.643513e-001, 3.643528e-001, 3.643542e-001, 3.643557e-001, 3.643571e-001, 3.643586e-001, 3.643600e-001, 3.643615e-001, 3.643629e-001, 3.643644e-001, 3.643658e-001, 3.643673e-001, 3.643687e-001, 3.643702e-001, 3.643716e-001, 3.643731e-001, 3.643745e-001, 3.643760e-001, 3.643774e-001, 3.643789e-001, 3.643803e-001, 3.643818e-001, 3.643832e-001, 3.643846e-001, 3.643861e-001, 3.643875e-001, 3.643890e-001, 3.643904e-001, 3.643919e-001, 3.643933e-001, 3.643948e-001, 3.643962e-001, 3.643976e-001, 3.643991e-001, 3.644005e-001, 3.644020e-001, 3.644034e-001, 3.644049e-001, 3.644063e-001, 3.644077e-001, 3.644092e-001, 3.644106e-001, 3.644121e-001, 3.644135e-001, 3.644149e-001, 3.644164e-001, 3.644178e-001, 3.644193e-001, 3.644207e-001, 3.644221e-001, 3.644236e-001, 3.644250e-001, 3.644264e-001, 3.644279e-001, 3.644293e-001, 3.644308e-001, 3.644322e-001, 3.644336e-001, 3.644351e-001, 3.644365e-001, 3.644379e-001, 3.644394e-001, 3.644408e-001, 3.644422e-001, 3.644437e-001, 3.644451e-001, 3.644465e-001, 3.644480e-001, 3.644494e-001, 3.644508e-001, 3.644523e-001, 3.644537e-001, 3.644551e-001, 3.644566e-001, 3.644580e-001, 3.644594e-001, 3.644608e-001, 3.644623e-001, 3.644637e-001, 3.644651e-001, 3.644666e-001, 3.644680e-001, 3.644694e-001, 3.644708e-001, 3.644723e-001, 3.644737e-001, 3.644751e-001, 3.644765e-001, 
3.644780e-001, 3.644794e-001, 3.644808e-001, 3.644822e-001, 3.644837e-001, 3.644851e-001, 3.644865e-001, 3.644879e-001, 3.644894e-001, 3.644908e-001, 3.644922e-001, 3.644936e-001, 3.644951e-001, 3.644965e-001, 3.644979e-001, 3.644993e-001, 3.645007e-001, 3.645022e-001, 3.645036e-001, 3.645050e-001, 3.645064e-001, 3.645078e-001, 3.645093e-001, 3.645107e-001, 3.645121e-001, 3.645135e-001, 3.645149e-001, 3.645164e-001, 3.645178e-001, 3.645192e-001, 3.645206e-001, 3.645220e-001, 3.645234e-001, 3.645248e-001, 3.645263e-001, 3.645277e-001, 3.645291e-001, 3.645305e-001, 3.645319e-001, 3.645333e-001, 3.645347e-001, 3.645362e-001, 3.645376e-001, 3.645390e-001, 3.645404e-001, 3.645418e-001, 3.645432e-001, 3.645446e-001, 3.645460e-001, 3.645475e-001, 3.645489e-001, 3.645503e-001, 3.645517e-001, 3.645531e-001, 3.645545e-001, 3.645559e-001, 3.645573e-001, 3.645587e-001, 3.645601e-001, 3.645615e-001, 3.645629e-001, 3.645644e-001, 3.645658e-001, 3.645672e-001, 3.645686e-001, 3.645700e-001, 3.645714e-001, 3.645728e-001, 3.645742e-001, 3.645756e-001, 3.645770e-001, 3.645784e-001, 3.645798e-001, 3.645812e-001, 3.645826e-001, 3.645840e-001, 3.645854e-001, 3.645868e-001, 3.645882e-001, 3.645896e-001, 3.645910e-001, 3.645924e-001, 3.645938e-001, 3.645952e-001, 3.645966e-001, 3.645980e-001, 3.645994e-001, 3.646008e-001, 3.646022e-001, 3.646036e-001, 3.646050e-001, 3.646064e-001, 3.646078e-001, 3.646092e-001, 3.646106e-001, 3.646120e-001, 3.646134e-001, 3.646148e-001, 3.646162e-001, 3.646176e-001, 
3.646190e-001, 3.646204e-001, 3.646218e-001, 3.646232e-001, 3.646245e-001, 3.646259e-001, 3.646273e-001, 3.646287e-001, 3.646301e-001, 3.646315e-001, 3.646329e-001, 3.646343e-001, 3.646357e-001, 3.646371e-001, 3.646385e-001, 3.646399e-001, 3.646412e-001, 3.646426e-001, 3.646440e-001, 3.646454e-001, 3.646468e-001, 3.646482e-001, 3.646496e-001, 3.646510e-001, 3.646523e-001, 3.646537e-001, 3.646551e-001, 3.646565e-001, 3.646579e-001, 3.646593e-001, 3.646607e-001, 3.646620e-001, 3.646634e-001, 3.646648e-001, 3.646662e-001, 3.646676e-001, 3.646690e-001, 3.646703e-001, 3.646717e-001, 3.646731e-001, 3.646745e-001, 3.646759e-001, 3.646773e-001, 3.646786e-001, 3.646800e-001, 3.646814e-001, 3.646828e-001, 3.646842e-001, 3.646855e-001, 3.646869e-001, 3.646883e-001, 3.646897e-001, 3.646911e-001, 3.646924e-001, 3.646938e-001, 3.646952e-001, 3.646966e-001, 3.646979e-001, 3.646993e-001, 3.647007e-001, 3.647021e-001, 3.647034e-001, 3.647048e-001, 3.647062e-001, 3.647076e-001, 3.647089e-001, 3.647103e-001, 3.647117e-001, 3.647131e-001, 3.647144e-001, 3.647158e-001, 3.647172e-001, 3.647186e-001, 3.647199e-001, 3.647213e-001, 3.647227e-001, 3.647240e-001, 3.647254e-001, 3.647268e-001, 3.647281e-001, 3.647295e-001, 3.647309e-001, 3.647323e-001, 3.647336e-001, 3.647350e-001, 3.647364e-001, 3.647377e-001, 3.647391e-001, 3.647405e-001, 3.647418e-001, 3.647432e-001, 3.647446e-001, 3.647459e-001, 3.647473e-001, 3.647487e-001, 3.647500e-001, 3.647514e-001, 3.647528e-001, 3.647541e-001, 3.647555e-001, 
3.647568e-001, 3.647582e-001, 3.647596e-001, 3.647609e-001, 3.647623e-001, 3.647637e-001, 3.647650e-001, 3.647664e-001, 3.647677e-001, 3.647691e-001, 3.647705e-001, 3.647718e-001, 3.647732e-001, 3.647745e-001, 3.647759e-001, 3.647773e-001, 3.647786e-001, 3.647800e-001, 3.647813e-001, 3.647827e-001, 3.647840e-001, 3.647854e-001, 3.647868e-001, 3.647881e-001, 3.647895e-001, 3.647908e-001, 3.647922e-001, 3.647935e-001, 3.647949e-001, 3.647962e-001, 3.647976e-001, 3.647990e-001, 3.648003e-001, 3.648017e-001, 3.648030e-001, 3.648044e-001, 3.648057e-001, 3.648071e-001, 3.648084e-001, 3.648098e-001, 3.648111e-001, 3.648125e-001, 3.648138e-001, 3.648152e-001, 3.648165e-001, 3.648179e-001, 3.648192e-001, 3.648206e-001, 3.648219e-001, 3.648233e-001, 3.648246e-001, 3.648260e-001, 3.648273e-001, 3.648287e-001, 3.648300e-001, 3.648313e-001, 3.648327e-001, 3.648340e-001, 3.648354e-001, 3.648367e-001, 3.648381e-001, 3.648394e-001, 3.648408e-001, 3.648421e-001, 3.648434e-001, 3.648448e-001, 3.648461e-001, 3.648475e-001, 3.648488e-001, 3.648502e-001, 3.648515e-001, 3.648528e-001, 3.648542e-001, 3.648555e-001, 3.648569e-001, 3.648582e-001, 3.648595e-001, 3.648609e-001, 3.648622e-001, 3.648636e-001, 3.648649e-001, 3.648662e-001, 3.648676e-001, 3.648689e-001, 3.648702e-001, 3.648716e-001, 3.648729e-001, 3.648743e-001, 3.648756e-001, 3.648769e-001, 3.648783e-001, 3.648796e-001, 3.648809e-001, 3.648823e-001, 3.648836e-001, 3.648849e-001, 3.648863e-001, 3.648876e-001, 3.648889e-001, 3.648903e-001, 
3.648916e-001, 3.648929e-001, 3.648943e-001, 3.648956e-001, 3.648969e-001, 3.648983e-001, 3.648996e-001, 3.649009e-001, 3.649022e-001, 3.649036e-001, 3.649049e-001, 3.649062e-001, 3.649076e-001, 3.649089e-001, 3.649102e-001, 3.649115e-001, 3.649129e-001, 3.649142e-001, 3.649155e-001, 3.649169e-001, 3.649182e-001, 3.649195e-001, 3.649208e-001, 3.649222e-001, 3.649235e-001, 3.649248e-001, 3.649261e-001, 3.649275e-001, 3.649288e-001, 3.649301e-001, 3.649314e-001, 3.649327e-001, 3.649341e-001, 3.649354e-001, 3.649367e-001, 3.649380e-001, 3.649394e-001, 3.649407e-001, 3.649420e-001, 3.649433e-001, 3.649446e-001, 3.649460e-001, 3.649473e-001, 3.649486e-001, 3.649499e-001, 3.649512e-001, 3.649525e-001, 3.649539e-001, 3.649552e-001, 3.649565e-001, 3.649578e-001, 3.649591e-001, 3.649604e-001, 3.649618e-001, 3.649631e-001, 3.649644e-001, 3.649657e-001, 3.649670e-001, 3.649683e-001, 3.649697e-001, 3.649710e-001, 3.649723e-001, 3.649736e-001, 3.649749e-001, 3.649762e-001, 3.649775e-001, 3.649788e-001, 3.649802e-001, 3.649815e-001, 3.649828e-001, 3.649841e-001, 3.649854e-001, 3.649867e-001, 3.649880e-001, 3.649893e-001, 3.649906e-001, 3.649919e-001, 3.649932e-001, 3.649946e-001, 3.649959e-001, 3.649972e-001, 3.649985e-001, 3.649998e-001, 3.650011e-001, 3.650024e-001, 3.650037e-001, 3.650050e-001, 3.650063e-001, 3.650076e-001, 3.650089e-001, 3.650102e-001, 3.650115e-001, 3.650128e-001, 3.650141e-001, 3.650154e-001, 3.650167e-001, 3.650180e-001, 3.650194e-001, 3.650207e-001, 3.650220e-001, 
3.650233e-001, 3.650246e-001, 3.650259e-001, 3.650272e-001, 3.650285e-001, 3.650298e-001, 3.650311e-001, 3.650324e-001, 3.650337e-001, 3.650350e-001, 3.650362e-001, 3.650375e-001, 3.650388e-001, 3.650401e-001, 3.650414e-001, 3.650427e-001, 3.650440e-001, 3.650453e-001, 3.650466e-001, 3.650479e-001, 3.650492e-001, 3.650505e-001, 3.650518e-001, 3.650531e-001, 3.650544e-001, 3.650557e-001, 3.650570e-001, 3.650583e-001, 3.650596e-001, 3.650609e-001, 3.650621e-001, 3.650634e-001, 3.650647e-001, 3.650660e-001, 3.650673e-001, 3.650686e-001, 3.650699e-001, 3.650712e-001, 3.650725e-001, 3.650738e-001, 3.650750e-001, 3.650763e-001, 3.650776e-001, 3.650789e-001, 3.650802e-001, 3.650815e-001, 3.650828e-001, 3.650841e-001, 3.650853e-001, 3.650866e-001, 3.650879e-001, 3.650892e-001, 3.650905e-001, 3.650918e-001, 3.650931e-001, 3.650943e-001, 3.650956e-001, 3.650969e-001, 3.650982e-001, 3.650995e-001, 3.651008e-001, 3.651020e-001, 3.651033e-001, 3.651046e-001, 3.651059e-001, 3.651072e-001, 3.651084e-001, 3.651097e-001, 3.651110e-001, 3.651123e-001, 3.651136e-001, 3.651148e-001, 3.651161e-001, 3.651174e-001, 3.651187e-001, 3.651200e-001, 3.651212e-001, 3.651225e-001, 3.651238e-001, 3.651251e-001, 3.651263e-001, 3.651276e-001, 3.651289e-001, 3.651302e-001, 3.651314e-001, 3.651327e-001, 3.651340e-001, 3.651353e-001, 3.651365e-001, 3.651378e-001, 3.651391e-001, 3.651404e-001, 3.651416e-001, 3.651429e-001, 3.651442e-001, 3.651455e-001, 3.651467e-001, 3.651480e-001, 3.651493e-001, 3.651505e-001, 
3.651518e-001, 3.651531e-001, 3.651544e-001, 3.651556e-001, 3.651569e-001, 3.651582e-001, 3.651594e-001, 3.651607e-001, 3.651620e-001, 3.651632e-001, 3.651645e-001, 3.651658e-001, 3.651670e-001, 3.651683e-001, 3.651696e-001, 3.651708e-001, 3.651721e-001, 3.651734e-001, 3.651746e-001, 3.651759e-001, 3.651772e-001, 3.651784e-001, 3.651797e-001, 3.651809e-001, 3.651822e-001, 3.651835e-001, 3.651847e-001, 3.651860e-001, 3.651873e-001, 3.651885e-001, 3.651898e-001, 3.651910e-001, 3.651923e-001, 3.651936e-001, 3.651948e-001, 3.651961e-001, 3.651973e-001, 3.651986e-001, 3.651999e-001, 3.652011e-001, 3.652024e-001, 3.652036e-001, 3.652049e-001, 3.652061e-001, 3.652074e-001, 3.652087e-001, 3.652099e-001, 3.652112e-001, 3.652124e-001, 3.652137e-001, 3.652149e-001, 3.652162e-001, 3.652174e-001, 3.652187e-001, 3.652199e-001, 3.652212e-001, 3.652225e-001, 3.652237e-001, 3.652250e-001, 3.652262e-001, 3.652275e-001, 3.652287e-001, 3.652300e-001, 3.652312e-001, 3.652325e-001, 3.652337e-001, 3.652350e-001, 3.652362e-001, 3.652375e-001, 3.652387e-001, 3.652400e-001, 3.652412e-001, 3.652425e-001, 3.652437e-001, 3.652450e-001, 3.652462e-001, 3.652474e-001, 3.652487e-001, 3.652499e-001, 3.652512e-001, 3.652524e-001, 3.652537e-001, 3.652549e-001, 3.652562e-001, 3.652574e-001, 3.652587e-001, 3.652599e-001, 3.652611e-001, 3.652624e-001, 3.652636e-001, 3.652649e-001, 3.652661e-001, 3.652674e-001, 3.652686e-001, 3.652698e-001, 3.652711e-001, 3.652723e-001, 3.652736e-001, 3.652748e-001, 3.652760e-001, 
3.652773e-001, 3.652785e-001, 3.652798e-001, 3.652810e-001, 3.652822e-001, 3.652835e-001, 3.652847e-001, 3.652859e-001, 3.652872e-001, 3.652884e-001, 3.652897e-001, 3.652909e-001, 3.652921e-001, 3.652934e-001, 3.652946e-001, 3.652958e-001, 3.652971e-001, 3.652983e-001, 3.652995e-001, 3.653008e-001, 3.653020e-001, 3.653032e-001, 3.653045e-001, 3.653057e-001, 3.653069e-001, 3.653082e-001, 3.653094e-001, 3.653106e-001, 3.653119e-001, 3.653131e-001, 3.653143e-001, 3.653156e-001, 3.653168e-001, 3.653180e-001, 3.653192e-001, 3.653205e-001, 3.653217e-001, 3.653229e-001, 3.653242e-001, 3.653254e-001, 3.653266e-001, 3.653278e-001, 3.653291e-001, 3.653303e-001, 3.653315e-001, 3.653327e-001, 3.653340e-001, 3.653352e-001, 3.653364e-001, 3.653376e-001, 3.653389e-001, 3.653401e-001, 3.653413e-001, 3.653425e-001, 3.653438e-001, 3.653450e-001, 3.653462e-001, 3.653474e-001, 3.653486e-001, 3.653499e-001, 3.653511e-001, 3.653523e-001, 3.653535e-001, 3.653547e-001, 3.653560e-001, 3.653572e-001, 3.653584e-001, 3.653596e-001, 3.653608e-001, 3.653621e-001, 3.653633e-001, 3.653645e-001, 3.653657e-001, 3.653669e-001, 3.653681e-001, 3.653694e-001, 3.653706e-001, 3.653718e-001, 3.653730e-001, 3.653742e-001, 3.653754e-001, 3.653767e-001, 3.653779e-001, 3.653791e-001, 3.653803e-001, 3.653815e-001, 3.653827e-001, 3.653839e-001, 3.653851e-001, 3.653864e-001, 3.653876e-001, 3.653888e-001, 3.653900e-001, 3.653912e-001, 3.653924e-001, 3.653936e-001, 3.653948e-001, 3.653960e-001, 3.653973e-001, 3.653985e-001, 
3.653997e-001, 3.654009e-001, 3.654021e-001, 3.654033e-001, 3.654045e-001, 3.654057e-001, 3.654069e-001, 3.654081e-001, 3.654093e-001, 3.654105e-001, 3.654117e-001, 3.654130e-001, 3.654142e-001, 3.654154e-001, 3.654166e-001, 3.654178e-001, 3.654190e-001, 3.654202e-001, 3.654214e-001, 3.654226e-001, 3.654238e-001, 3.654250e-001, 3.654262e-001, 3.654274e-001, 3.654286e-001, 3.654298e-001, 3.654310e-001, 3.654322e-001, 3.654334e-001, 3.654346e-001, 3.654358e-001, 3.654370e-001, 3.654382e-001, 3.654394e-001, 3.654406e-001, 3.654418e-001, 3.654430e-001, 3.654442e-001, 3.654454e-001, 3.654466e-001, 3.654478e-001, 3.654490e-001, 3.654502e-001, 3.654514e-001, 3.654526e-001, 3.654538e-001, 3.654549e-001, 3.654561e-001, 3.654573e-001, 3.654585e-001, 3.654597e-001, 3.654609e-001, 3.654621e-001, 3.654633e-001, 3.654645e-001, 3.654657e-001, 3.654669e-001, 3.654681e-001, 3.654693e-001, 3.654704e-001, 3.654716e-001, 3.654728e-001, 3.654740e-001, 3.654752e-001, 3.654764e-001, 3.654776e-001, 3.654788e-001, 3.654800e-001, 3.654811e-001, 3.654823e-001, 3.654835e-001, 3.654847e-001, 3.654859e-001, 3.654871e-001, 3.654883e-001, 3.654895e-001, 3.654906e-001, 3.654918e-001, 3.654930e-001, 3.654942e-001, 3.654954e-001, 3.654966e-001, 3.654977e-001, 3.654989e-001, 3.655001e-001, 3.655013e-001, 3.655025e-001, 3.655037e-001, 3.655048e-001, 3.655060e-001, 3.655072e-001, 3.655084e-001, 3.655096e-001, 3.655107e-001, 3.655119e-001, 3.655131e-001, 3.655143e-001, 3.655155e-001, 3.655166e-001, 3.655178e-001, 
3.655190e-001, 3.655202e-001, 3.655214e-001, 3.655225e-001, 3.655237e-001, 3.655249e-001, 3.655261e-001, 3.655272e-001, 3.655284e-001, 3.655296e-001, 3.655308e-001, 3.655319e-001, 3.655331e-001, 3.655343e-001, 3.655355e-001, 3.655366e-001, 3.655378e-001, 3.655390e-001, 3.655402e-001, 3.655413e-001, 3.655425e-001, 3.655437e-001, 3.655448e-001, 3.655460e-001, 3.655472e-001, 3.655484e-001, 3.655495e-001, 3.655507e-001, 3.655519e-001, 3.655530e-001, 3.655542e-001, 3.655554e-001, 3.655565e-001, 3.655577e-001, 3.655589e-001, 3.655600e-001, 3.655612e-001, 3.655624e-001, 3.655635e-001, 3.655647e-001, 3.655659e-001, 3.655670e-001, 3.655682e-001, 3.655694e-001, 3.655705e-001, 3.655717e-001, 3.655729e-001, 3.655740e-001, 3.655752e-001, 3.655764e-001, 3.655775e-001, 3.655787e-001, 3.655798e-001, 3.655810e-001, 3.655822e-001, 3.655833e-001, 3.655845e-001, 3.655856e-001, 3.655868e-001, 3.655880e-001, 3.655891e-001, 3.655903e-001, 3.655914e-001, 3.655926e-001, 3.655938e-001, 3.655949e-001, 3.655961e-001, 3.655972e-001, 3.655984e-001, 3.655996e-001, 3.656007e-001, 3.656019e-001, 3.656030e-001, 3.656042e-001, 3.656053e-001, 3.656065e-001, 3.656076e-001, 3.656088e-001, 3.656100e-001, 3.656111e-001, 3.656123e-001, 3.656134e-001, 3.656146e-001, 3.656157e-001, 3.656169e-001, 3.656180e-001, 3.656192e-001, 3.656203e-001, 3.656215e-001, 3.656226e-001, 3.656238e-001, 3.656249e-001, 3.656261e-001, 3.656272e-001, 3.656284e-001, 3.656295e-001, 3.656307e-001, 3.656318e-001, 3.656330e-001, 3.656341e-001, 
3.656353e-001, 3.656364e-001, 3.656376e-001, 3.656387e-001, 3.656399e-001, 3.656410e-001, 3.656421e-001, 3.656433e-001, 3.656444e-001, 3.656456e-001, 3.656467e-001, 3.656479e-001, 3.656490e-001, 3.656502e-001, 3.656513e-001, 3.656524e-001, 3.656536e-001, 3.656547e-001, 3.656559e-001, 3.656570e-001, 3.656582e-001, 3.656593e-001, 3.656604e-001, 3.656616e-001, 3.656627e-001, 3.656639e-001, 3.656650e-001, 3.656661e-001, 3.656673e-001, 3.656684e-001, 3.656696e-001, 3.656707e-001, 3.656718e-001, 3.656730e-001, 3.656741e-001, 3.656752e-001, 3.656764e-001, 3.656775e-001, 3.656786e-001, 3.656798e-001, 3.656809e-001, 3.656821e-001, 3.656832e-001, 3.656843e-001, 3.656855e-001, 3.656866e-001, 3.656877e-001, 3.656889e-001, 3.656900e-001, 3.656911e-001, 3.656923e-001, 3.656934e-001, 3.656945e-001, 3.656957e-001, 3.656968e-001, 3.656979e-001, 3.656990e-001, 3.657002e-001, 3.657013e-001, 3.657024e-001, 3.657036e-001, 3.657047e-001, 3.657058e-001, 3.657070e-001, 3.657081e-001, 3.657092e-001, 3.657103e-001, 3.657115e-001, 3.657126e-001, 3.657137e-001, 3.657148e-001, 3.657160e-001, 3.657171e-001, 3.657182e-001, 3.657193e-001, 3.657205e-001, 3.657216e-001, 3.657227e-001, 3.657238e-001, 3.657250e-001, 3.657261e-001, 3.657272e-001, 3.657283e-001, 3.657295e-001, 3.657306e-001, 3.657317e-001, 3.657328e-001, 3.657339e-001, 3.657351e-001, 3.657362e-001, 3.657373e-001, 3.657384e-001, 3.657395e-001, 3.657407e-001, 3.657418e-001, 3.657429e-001, 3.657440e-001, 3.657451e-001, 3.657463e-001, 3.657474e-001, 
3.657485e-001, 3.657496e-001, 3.657507e-001, 3.657518e-001, 3.657530e-001, 3.657541e-001, 3.657552e-001, 3.657563e-001, 3.657574e-001, 3.657585e-001, 3.657596e-001, 3.657608e-001, 3.657619e-001, 3.657630e-001, 3.657641e-001, 3.657652e-001, 3.657663e-001, 3.657674e-001, 3.657685e-001, 3.657697e-001, 3.657708e-001, 3.657719e-001, 3.657730e-001, 3.657741e-001, 3.657752e-001, 3.657763e-001, 3.657774e-001, 3.657785e-001, 3.657796e-001, 3.657808e-001, 3.657819e-001, 3.657830e-001, 3.657841e-001, 3.657852e-001, 3.657863e-001, 3.657874e-001, 3.657885e-001, 3.657896e-001, 3.657907e-001, 3.657918e-001, 3.657929e-001, 3.657940e-001, 3.657951e-001, 3.657962e-001, 3.657973e-001, 3.657984e-001, 3.657995e-001, 3.658006e-001, 3.658018e-001, 3.658029e-001, 3.658040e-001, 3.658051e-001, 3.658062e-001, 3.658073e-001, 3.658084e-001, 3.658095e-001, 3.658106e-001, 3.658117e-001, 3.658128e-001, 3.658139e-001, 3.658150e-001, 3.658161e-001, 3.658172e-001, 3.658183e-001, 3.658194e-001, 3.658204e-001, 3.658215e-001, 3.658226e-001, 3.658237e-001, 3.658248e-001, 3.658259e-001, 3.658270e-001, 3.658281e-001, 3.658292e-001, 3.658303e-001, 3.658314e-001, 3.658325e-001, 3.658336e-001, 3.658347e-001, 3.658358e-001, 3.658369e-001, 3.658380e-001, 3.658391e-001, 3.658401e-001, 3.658412e-001, 3.658423e-001, 3.658434e-001, 3.658445e-001, 3.658456e-001, 3.658467e-001, 3.658478e-001, 3.658489e-001, 3.658500e-001, 3.658511e-001, 3.658521e-001, 3.658532e-001, 3.658543e-001, 3.658554e-001, 3.658565e-001, 3.658576e-001, 
3.658587e-001, 3.658598e-001, 3.658608e-001, 3.658619e-001, 3.658630e-001, 3.658641e-001, 3.658652e-001, 3.658663e-001, 3.658673e-001, 3.658684e-001, 3.658695e-001, 3.658706e-001, 3.658717e-001, 3.658728e-001, 3.658738e-001, 3.658749e-001, 3.658760e-001, 3.658771e-001, 3.658782e-001, 3.658793e-001, 3.658803e-001, 3.658814e-001, 3.658825e-001, 3.658836e-001, 3.658847e-001, 3.658857e-001, 3.658868e-001, 3.658879e-001, 3.658890e-001, 3.658901e-001, 3.658911e-001, 3.658922e-001, 3.658933e-001, 3.658944e-001, 3.658954e-001, 3.658965e-001, 3.658976e-001, 3.658987e-001, 3.658997e-001, 3.659008e-001, 3.659019e-001, 3.659030e-001, 3.659040e-001, 3.659051e-001, 3.659062e-001, 3.659073e-001, 3.659083e-001, 3.659094e-001, 3.659105e-001, 3.659115e-001, 3.659126e-001, 3.659137e-001, 3.659148e-001, 3.659158e-001, 3.659169e-001, 3.659180e-001, 3.659190e-001, 3.659201e-001, 3.659212e-001, 3.659222e-001, 3.659233e-001, 3.659244e-001, 3.659255e-001, 3.659265e-001, 3.659276e-001, 3.659287e-001, 3.659297e-001, 3.659308e-001, 3.659319e-001, 3.659329e-001, 3.659340e-001, 3.659351e-001, 3.659361e-001, 3.659372e-001, 3.659382e-001, 3.659393e-001, 3.659404e-001, 3.659414e-001, 3.659425e-001, 3.659436e-001, 3.659446e-001, 3.659457e-001, 3.659468e-001, 3.659478e-001, 3.659489e-001, 3.659499e-001, 3.659510e-001, 3.659521e-001, 3.659531e-001, 3.659542e-001, 3.659552e-001, 3.659563e-001, 3.659574e-001, 3.659584e-001, 3.659595e-001, 3.659605e-001, 3.659616e-001, 3.659626e-001, 3.659637e-001, 3.659648e-001, 
3.659658e-001, 3.659669e-001, 3.659679e-001, 3.659690e-001, 3.659700e-001, 3.659711e-001, 3.659721e-001, 3.659732e-001, 3.659743e-001, 3.659753e-001, 3.659764e-001, 3.659774e-001, 3.659785e-001, 3.659795e-001, 3.659806e-001, 3.659816e-001, 3.659827e-001, 3.659837e-001, 3.659848e-001, 3.659858e-001, 3.659869e-001, 3.659879e-001, 3.659890e-001, 3.659900e-001, 3.659911e-001, 3.659921e-001, 3.659932e-001, 3.659942e-001, 3.659953e-001, 3.659963e-001, 3.659974e-001, 3.659984e-001, 3.659995e-001, 3.660005e-001, 3.660016e-001, 3.660026e-001, 3.660036e-001, 3.660047e-001, 3.660057e-001, 3.660068e-001, 3.660078e-001, 3.660089e-001, 3.660099e-001, 3.660110e-001, 3.660120e-001, 3.660130e-001, 3.660141e-001, 3.660151e-001, 3.660162e-001, 3.660172e-001, 3.660183e-001, 3.660193e-001, 3.660203e-001, 3.660214e-001, 3.660224e-001, 3.660235e-001, 3.660245e-001, 3.660255e-001, 3.660266e-001, 3.660276e-001, 3.660287e-001, 3.660297e-001, 3.660307e-001, 3.660318e-001, 3.660328e-001, 3.660338e-001, 3.660349e-001, 3.660359e-001, 3.660370e-001, 3.660380e-001, 3.660390e-001, 3.660401e-001, 3.660411e-001, 3.660421e-001, 3.660432e-001, 3.660442e-001, 3.660452e-001, 3.660463e-001, 3.660473e-001, 3.660483e-001, 3.660494e-001, 3.660504e-001, 3.660514e-001, 3.660525e-001, 3.660535e-001, 3.660545e-001, 3.660555e-001, 3.660566e-001, 3.660576e-001, 3.660586e-001, 3.660597e-001, 3.660607e-001, 3.660617e-001, 3.660628e-001, 3.660638e-001, 3.660648e-001, 3.660658e-001, 3.660669e-001, 3.660679e-001, 3.660689e-001, 
3.660699e-001, 3.660710e-001, 3.660720e-001, 3.660730e-001, 3.660740e-001, 3.660751e-001, 3.660761e-001, 3.660771e-001, 3.660781e-001, 3.660792e-001, 3.660802e-001, 3.660812e-001, 3.660822e-001, 3.660833e-001, 3.660843e-001, 3.660853e-001, 3.660863e-001, 3.660873e-001, 3.660884e-001, 3.660894e-001, 3.660904e-001, 3.660914e-001, 3.660924e-001, 3.660935e-001, 3.660945e-001, 3.660955e-001, 3.660965e-001, 3.660975e-001, 3.660986e-001, 3.660996e-001, 3.661006e-001, 3.661016e-001, 3.661026e-001, 3.661036e-001, 3.661047e-001, 3.661057e-001, 3.661067e-001, 3.661077e-001, 3.661087e-001, 3.661097e-001, 3.661108e-001, 3.661118e-001, 3.661128e-001, 3.661138e-001, 3.661148e-001, 3.661158e-001, 3.661168e-001, 3.661178e-001, 3.661189e-001, 3.661199e-001, 3.661209e-001, 3.661219e-001, 3.661229e-001, 3.661239e-001, 3.661249e-001, 3.661259e-001, 3.661269e-001, 3.661279e-001, 3.661290e-001, 3.661300e-001, 3.661310e-001, 3.661320e-001, 3.661330e-001, 3.661340e-001, 3.661350e-001, 3.661360e-001, 3.661370e-001, 3.661380e-001, 3.661390e-001, 3.661400e-001, 3.661410e-001, 3.661420e-001, 3.661430e-001, 3.661441e-001, 3.661451e-001, 3.661461e-001, 3.661471e-001, 3.661481e-001, 3.661491e-001, 3.661501e-001, 3.661511e-001, 3.661521e-001, 3.661531e-001, 3.661541e-001, 3.661551e-001, 3.661561e-001, 3.661571e-001, 3.661581e-001, 3.661591e-001, 3.661601e-001, 3.661611e-001, 3.661621e-001, 3.661631e-001, 3.661641e-001, 3.661651e-001, 3.661661e-001, 3.661671e-001, 3.661681e-001, 3.661691e-001, 3.661701e-001, 
3.661711e-001, 3.661721e-001, 3.661731e-001, 3.661740e-001, 3.661750e-001, 3.661760e-001, 3.661770e-001, 3.661780e-001, 3.661790e-001, 3.661800e-001, 3.661810e-001, 3.661820e-001, 3.661830e-001, 3.661840e-001, 3.661850e-001, 3.661860e-001, 3.661870e-001, 3.661879e-001, 3.661889e-001, 3.661899e-001, 3.661909e-001, 3.661919e-001, 3.661929e-001, 3.661939e-001, 3.661949e-001, 3.661959e-001, 3.661969e-001, 3.661978e-001, 3.661988e-001, 3.661998e-001, 3.662008e-001, 3.662018e-001, 3.662028e-001, 3.662038e-001, 3.662048e-001, 3.662057e-001, 3.662067e-001, 3.662077e-001, 3.662087e-001, 3.662097e-001, 3.662107e-001, 3.662116e-001, 3.662126e-001, 3.662136e-001, 3.662146e-001, 3.662156e-001, 3.662166e-001, 3.662175e-001, 3.662185e-001, 3.662195e-001, 3.662205e-001, 3.662215e-001, 3.662225e-001, 3.662234e-001, 3.662244e-001, 3.662254e-001, 3.662264e-001, 3.662274e-001, 3.662283e-001, 3.662293e-001, 3.662303e-001, 3.662313e-001, 3.662322e-001, 3.662332e-001, 3.662342e-001, 3.662352e-001, 3.662361e-001, 3.662371e-001, 3.662381e-001, 3.662391e-001, 3.662401e-001, 3.662410e-001, 3.662420e-001, 3.662430e-001, 3.662440e-001, 3.662449e-001, 3.662459e-001, 3.662469e-001, 3.662478e-001, 3.662488e-001, 3.662498e-001, 3.662508e-001, 3.662517e-001, 3.662527e-001, 3.662537e-001, 3.662546e-001, 3.662556e-001, 3.662566e-001, 3.662576e-001, 3.662585e-001, 3.662595e-001, 3.662605e-001, 3.662614e-001, 3.662624e-001, 3.662634e-001, 3.662643e-001, 3.662653e-001, 3.662663e-001, 3.662672e-001, 3.662682e-001, 
3.662692e-001, 3.662701e-001, 3.662711e-001, 3.662721e-001, 3.662730e-001, 3.662740e-001, 3.662750e-001, 3.662759e-001, 3.662769e-001, 3.662779e-001, 3.662788e-001, 3.662798e-001, 3.662807e-001, 3.662817e-001, 3.662827e-001, 3.662836e-001, 3.662846e-001, 3.662856e-001, 3.662865e-001, 3.662875e-001, 3.662884e-001, 3.662894e-001, 3.662904e-001, 3.662913e-001, 3.662923e-001, 3.662932e-001, 3.662942e-001, 3.662951e-001, 3.662961e-001, 3.662971e-001, 3.662980e-001, 3.662990e-001, 3.662999e-001, 3.663009e-001, 3.663018e-001, 3.663028e-001, 3.663038e-001, 3.663047e-001, 3.663057e-001, 3.663066e-001, 3.663076e-001, 3.663085e-001, 3.663095e-001, 3.663104e-001, 3.663114e-001, 3.663123e-001, 3.663133e-001, 3.663142e-001, 3.663152e-001, 3.663162e-001, 3.663171e-001, 3.663181e-001, 3.663190e-001, 3.663200e-001, 3.663209e-001, 3.663219e-001, 3.663228e-001, 3.663238e-001, 3.663247e-001, 3.663257e-001, 3.663266e-001, 3.663275e-001, 3.663285e-001, 3.663294e-001, 3.663304e-001, 3.663313e-001, 3.663323e-001, 3.663332e-001, 3.663342e-001, 3.663351e-001, 3.663361e-001, 3.663370e-001, 3.663380e-001, 3.663389e-001, 3.663398e-001, 3.663408e-001, 3.663417e-001, 3.663427e-001, 3.663436e-001, 3.663446e-001, 3.663455e-001, 3.663464e-001, 3.663474e-001, 3.663483e-001, 3.663493e-001, 3.663502e-001, 3.663512e-001, 3.663521e-001, 3.663530e-001, 3.663540e-001, 3.663549e-001, 3.663559e-001, 3.663568e-001, 3.663577e-001, 3.663587e-001, 3.663596e-001, 3.663605e-001, 3.663615e-001, 3.663624e-001, 3.663634e-001, 
3.663643e-001, 3.663652e-001, 3.663662e-001, 3.663671e-001, 3.663680e-001, 3.663690e-001, 3.663699e-001, 3.663708e-001, 3.663718e-001, 3.663727e-001, 3.663736e-001, 3.663746e-001, 3.663755e-001, 3.663764e-001, 3.663774e-001, 3.663783e-001, 3.663792e-001, 3.663802e-001, 3.663811e-001, 3.663820e-001, 3.663830e-001, 3.663839e-001, 3.663848e-001, 3.663857e-001, 3.663867e-001, 3.663876e-001, 3.663885e-001, 3.663895e-001, 3.663904e-001, 3.663913e-001, 3.663922e-001, 3.663932e-001, 3.663941e-001, 3.663950e-001, 3.663960e-001, 3.663969e-001, 3.663978e-001, 3.663987e-001, 3.663997e-001, 3.664006e-001, 3.664015e-001, 3.664024e-001, 3.664033e-001, 3.664043e-001, 3.664052e-001, 3.664061e-001, 3.664070e-001, 3.664080e-001, 3.664089e-001, 3.664098e-001, 3.664107e-001, 3.664117e-001, 3.664126e-001, 3.664135e-001, 3.664144e-001, 3.664153e-001, 3.664163e-001, 3.664172e-001, 3.664181e-001, 3.664190e-001, 3.664199e-001, 3.664208e-001, 3.664218e-001, 3.664227e-001, 3.664236e-001, 3.664245e-001, 3.664254e-001, 3.664263e-001, 3.664273e-001, 3.664282e-001, 3.664291e-001, 3.664300e-001, 3.664309e-001, 3.664318e-001, 3.664328e-001, 3.664337e-001, 3.664346e-001, 3.664355e-001, 3.664364e-001, 3.664373e-001, 3.664382e-001, 3.664391e-001, 3.664401e-001, 3.664410e-001, 3.664419e-001, 3.664428e-001, 3.664437e-001, 3.664446e-001, 3.664455e-001, 3.664464e-001, 3.664473e-001, 3.664483e-001, 3.664492e-001, 3.664501e-001, 3.664510e-001, 3.664519e-001, 3.664528e-001, 3.664537e-001, 3.664546e-001, 3.664555e-001, 
3.664564e-001, 3.664573e-001, 3.664582e-001, 3.664591e-001, 3.664600e-001, 3.664610e-001, 3.664619e-001, 3.664628e-001, 3.664637e-001, 3.664646e-001, 3.664655e-001, 3.664664e-001, 3.664673e-001, 3.664682e-001, 3.664691e-001, 3.664700e-001, 3.664709e-001, 3.664718e-001, 3.664727e-001, 3.664736e-001, 3.664745e-001, 3.664754e-001, 3.664763e-001, 3.664772e-001, 3.664781e-001, 3.664790e-001, 3.664799e-001, 3.664808e-001, 3.664817e-001, 3.664826e-001, 3.664835e-001, 3.664844e-001, 3.664853e-001, 3.664862e-001, 3.664871e-001, 3.664880e-001, 3.664889e-001, 3.664898e-001, 3.664907e-001, 3.664915e-001, 3.664924e-001, 3.664933e-001, 3.664942e-001, 3.664951e-001, 3.664960e-001, 3.664969e-001, 3.664978e-001, 3.664987e-001, 3.664996e-001, 3.665005e-001, 3.665014e-001, 3.665023e-001, 3.665032e-001, 3.665040e-001, 3.665049e-001, 3.665058e-001, 3.665067e-001, 3.665076e-001, 3.665085e-001, 3.665094e-001, 3.665103e-001, 3.665112e-001, 3.665121e-001, 3.665129e-001, 3.665138e-001, 3.665147e-001, 3.665156e-001, 3.665165e-001, 3.665174e-001, 3.665183e-001, 3.665191e-001, 3.665200e-001, 3.665209e-001, 3.665218e-001, 3.665227e-001, 3.665236e-001, 3.665245e-001, 3.665253e-001, 3.665262e-001, 3.665271e-001, 3.665280e-001, 3.665289e-001, 3.665298e-001, 3.665306e-001, 3.665315e-001, 3.665324e-001, 3.665333e-001, 3.665342e-001, 3.665350e-001, 3.665359e-001, 3.665368e-001, 3.665377e-001, 3.665386e-001, 3.665394e-001, 3.665403e-001, 3.665412e-001, 3.665421e-001, 3.665429e-001, 3.665438e-001, 3.665447e-001, 
3.665456e-001, 3.665465e-001, 3.665473e-001, 3.665482e-001, 3.665491e-001, 3.665500e-001, 3.665508e-001, 3.665517e-001, 3.665526e-001, 3.665535e-001, 3.665543e-001, 3.665552e-001, 3.665561e-001, 3.665570e-001, 3.665578e-001, 3.665587e-001, 3.665596e-001, 3.665604e-001, 3.665613e-001, 3.665622e-001, 3.665631e-001, 3.665639e-001, 3.665648e-001, 3.665657e-001, 3.665665e-001, 3.665674e-001, 3.665683e-001, 3.665691e-001, 3.665700e-001, 3.665709e-001, 3.665717e-001, 3.665726e-001, 3.665735e-001, 3.665744e-001, 3.665752e-001, 3.665761e-001, 3.665770e-001, 3.665778e-001, 3.665787e-001, 3.665795e-001, 3.665804e-001, 3.665813e-001, 3.665821e-001, 3.665830e-001, 3.665839e-001, 3.665847e-001, 3.665856e-001, 3.665865e-001, 3.665873e-001, 3.665882e-001, 3.665890e-001, 3.665899e-001, 3.665908e-001, 3.665916e-001, 3.665925e-001, 3.665934e-001, 3.665942e-001, 3.665951e-001, 3.665959e-001, 3.665968e-001, 3.665977e-001, 3.665985e-001, 3.665994e-001, 3.666002e-001, 3.666011e-001, 3.666019e-001, 3.666028e-001, 3.666037e-001, 3.666045e-001, 3.666054e-001, 3.666062e-001, 3.666071e-001, 3.666079e-001, 3.666088e-001, 3.666096e-001, 3.666105e-001, 3.666114e-001, 3.666122e-001, 3.666131e-001, 3.666139e-001, 3.666148e-001, 3.666156e-001, 3.666165e-001, 3.666173e-001, 3.666182e-001, 3.666190e-001, 3.666199e-001, 3.666207e-001, 3.666216e-001, 3.666224e-001, 3.666233e-001, 3.666241e-001, 3.666250e-001, 3.666258e-001, 3.666267e-001, 3.666275e-001, 3.666284e-001, 3.666292e-001, 3.666301e-001, 3.666309e-001, 
3.666318e-001, 3.666326e-001, 3.666335e-001, 3.666343e-001, 3.666352e-001, 3.666360e-001, 3.666368e-001, 3.666377e-001, 3.666385e-001, 3.666394e-001, 3.666402e-001, 3.666411e-001, 3.666419e-001, 3.666428e-001, 3.666436e-001, 3.666444e-001, 3.666453e-001, 3.666461e-001, 3.666470e-001, 3.666478e-001, 3.666487e-001, 3.666495e-001, 3.666503e-001, 3.666512e-001, 3.666520e-001, 3.666529e-001, 3.666537e-001, 3.666545e-001, 3.666554e-001, 3.666562e-001, 3.666571e-001, 3.666579e-001, 3.666587e-001, 3.666596e-001, 3.666604e-001, 3.666612e-001, 3.666621e-001, 3.666629e-001, 3.666637e-001, 3.666646e-001, 3.666654e-001, 3.666663e-001, 3.666671e-001, 3.666679e-001, 3.666688e-001, 3.666696e-001, 3.666704e-001, 3.666713e-001, 3.666721e-001, 3.666729e-001, 3.666738e-001, 3.666746e-001, 3.666754e-001, 3.666763e-001, 3.666771e-001, 3.666779e-001, 3.666787e-001, 3.666796e-001, 3.666804e-001, 3.666812e-001, 3.666821e-001, 3.666829e-001, 3.666837e-001, 3.666846e-001, 3.666854e-001, 3.666862e-001, 3.666870e-001, 3.666879e-001, 3.666887e-001, 3.666895e-001, 3.666903e-001, 3.666912e-001, 3.666920e-001, 3.666928e-001, 3.666936e-001, 3.666945e-001, 3.666953e-001, 3.666961e-001, 3.666969e-001, 3.666978e-001, 3.666986e-001, 3.666994e-001, 3.667002e-001, 3.667011e-001, 3.667019e-001, 3.667027e-001, 3.667035e-001, 3.667044e-001, 3.667052e-001, 3.667060e-001, 3.667068e-001, 3.667076e-001, 3.667085e-001, 3.667093e-001, 3.667101e-001, 3.667109e-001, 3.667117e-001, 3.667125e-001, 3.667134e-001, 3.667142e-001, 
3.667150e-001, 3.667158e-001, 3.667166e-001, 3.667175e-001, 3.667183e-001, 3.667191e-001, 3.667199e-001, 3.667207e-001, 3.667215e-001, 3.667223e-001, 3.667232e-001, 3.667240e-001, 3.667248e-001, 3.667256e-001, 3.667264e-001, 3.667272e-001, 3.667280e-001, 3.667289e-001, 3.667297e-001, 3.667305e-001, 3.667313e-001, 3.667321e-001, 3.667329e-001, 3.667337e-001, 3.667345e-001, 3.667353e-001, 3.667362e-001, 3.667370e-001, 3.667378e-001, 3.667386e-001, 3.667394e-001, 3.667402e-001, 3.667410e-001, 3.667418e-001, 3.667426e-001, 3.667434e-001, 3.667442e-001, 3.667451e-001, 3.667459e-001, 3.667467e-001, 3.667475e-001, 3.667483e-001, 3.667491e-001, 3.667499e-001, 3.667507e-001, 3.667515e-001, 3.667523e-001, 3.667531e-001, 3.667539e-001, 3.667547e-001, 3.667555e-001, 3.667563e-001, 3.667571e-001, 3.667579e-001, 3.667587e-001, 3.667595e-001, 3.667603e-001, 3.667611e-001, 3.667619e-001, 3.667627e-001, 3.667635e-001, 3.667643e-001, 3.667651e-001, 3.667659e-001, 3.667667e-001, 3.667675e-001, 3.667683e-001, 3.667691e-001, 3.667699e-001, 3.667707e-001, 3.667715e-001, 3.667723e-001, 3.667731e-001, 3.667739e-001, 3.667747e-001, 3.667755e-001, 3.667763e-001, 3.667771e-001, 3.667779e-001, 3.667787e-001, 3.667795e-001, 3.667803e-001, 3.667811e-001, 3.667818e-001, 3.667826e-001, 3.667834e-001, 3.667842e-001, 3.667850e-001, 3.667858e-001, 3.667866e-001, 3.667874e-001, 3.667882e-001, 3.667890e-001, 3.667898e-001, 3.667906e-001, 3.667913e-001, 3.667921e-001, 3.667929e-001, 3.667937e-001, 3.667945e-001, 
3.667953e-001, 3.667961e-001, 3.667969e-001, 3.667976e-001, 3.667984e-001, 3.667992e-001, 3.668000e-001, 3.668008e-001, 3.668016e-001, 3.668024e-001, 3.668032e-001, 3.668039e-001, 3.668047e-001, 3.668055e-001, 3.668063e-001, 3.668071e-001, 3.668079e-001, 3.668086e-001, 3.668094e-001, 3.668102e-001, 3.668110e-001, 3.668118e-001, 3.668126e-001, 3.668133e-001, 3.668141e-001, 3.668149e-001, 3.668157e-001, 3.668165e-001, 3.668172e-001, 3.668180e-001, 3.668188e-001, 3.668196e-001, 3.668204e-001, 3.668211e-001, 3.668219e-001, 3.668227e-001, 3.668235e-001, 3.668242e-001, 3.668250e-001, 3.668258e-001, 3.668266e-001, 3.668273e-001, 3.668281e-001, 3.668289e-001, 3.668297e-001, 3.668305e-001, 3.668312e-001, 3.668320e-001, 3.668328e-001, 3.668335e-001, 3.668343e-001, 3.668351e-001, 3.668359e-001, 3.668366e-001, 3.668374e-001, 3.668382e-001, 3.668390e-001, 3.668397e-001, 3.668405e-001, 3.668413e-001, 3.668420e-001, 3.668428e-001, 3.668436e-001, 3.668444e-001, 3.668451e-001, 3.668459e-001, 3.668467e-001, 3.668474e-001, 3.668482e-001, 3.668490e-001, 3.668497e-001, 3.668505e-001, 3.668513e-001, 3.668520e-001, 3.668528e-001, 3.668536e-001, 3.668543e-001, 3.668551e-001, 3.668559e-001, 3.668566e-001, 3.668574e-001, 3.668582e-001, 3.668589e-001, 3.668597e-001, 3.668604e-001, 3.668612e-001, 3.668620e-001, 3.668627e-001, 3.668635e-001, 3.668643e-001, 3.668650e-001, 3.668658e-001, 3.668665e-001, 3.668673e-001, 3.668681e-001, 3.668688e-001, 3.668696e-001, 3.668703e-001, 3.668711e-001, 3.668719e-001, 
3.668726e-001, 3.668734e-001, 3.668741e-001, 3.668749e-001, 3.668757e-001, 3.668764e-001, 3.668772e-001, 3.668779e-001, 3.668787e-001, 3.668794e-001, 3.668802e-001, 3.668810e-001, 3.668817e-001, 3.668825e-001, 3.668832e-001, 3.668840e-001, 3.668847e-001, 3.668855e-001, 3.668862e-001, 3.668870e-001, 3.668877e-001, 3.668885e-001, 3.668892e-001, 3.668900e-001, 3.668908e-001, 3.668915e-001, 3.668923e-001, 3.668930e-001, 3.668938e-001, 3.668945e-001, 3.668953e-001, 3.668960e-001, 3.668968e-001, 3.668975e-001, 3.668983e-001, 3.668990e-001, 3.668997e-001, 3.669005e-001, 3.669012e-001, 3.669020e-001, 3.669027e-001, 3.669035e-001, 3.669042e-001, 3.669050e-001, 3.669057e-001, 3.669065e-001, 3.669072e-001, 3.669080e-001, 3.669087e-001, 3.669095e-001, 3.669102e-001, 3.669109e-001, 3.669117e-001, 3.669124e-001, 3.669132e-001, 3.669139e-001, 3.669147e-001, 3.669154e-001, 3.669161e-001, 3.669169e-001, 3.669176e-001, 3.669184e-001, 3.669191e-001, 3.669198e-001, 3.669206e-001, 3.669213e-001, 3.669221e-001, 3.669228e-001, 3.669235e-001, 3.669243e-001, 3.669250e-001, 3.669258e-001, 3.669265e-001, 3.669272e-001, 3.669280e-001, 3.669287e-001, 3.669294e-001, 3.669302e-001, 3.669309e-001, 3.669317e-001, 3.669324e-001, 3.669331e-001, 3.669339e-001, 3.669346e-001, 3.669353e-001, 3.669361e-001, 3.669368e-001, 3.669375e-001, 3.669383e-001, 3.669390e-001, 3.669397e-001, 3.669405e-001, 3.669412e-001, 3.669419e-001, 3.669427e-001, 3.669434e-001, 3.669441e-001, 3.669448e-001, 3.669456e-001, 3.669463e-001, 
3.669470e-001, 3.669478e-001, 3.669485e-001, 3.669492e-001, 3.669499e-001, 3.669507e-001, 3.669514e-001, 3.669521e-001, 3.669529e-001, 3.669536e-001, 3.669543e-001, 3.669550e-001, 3.669558e-001, 3.669565e-001, 3.669572e-001, 3.669579e-001, 3.669587e-001, 3.669594e-001, 3.669601e-001, 3.669608e-001, 3.669616e-001, 3.669623e-001, 3.669630e-001, 3.669637e-001, 3.669645e-001, 3.669652e-001, 3.669659e-001, 3.669666e-001, 3.669673e-001, 3.669681e-001, 3.669688e-001, 3.669695e-001, 3.669702e-001, 3.669709e-001, 3.669717e-001, 3.669724e-001, 3.669731e-001, 3.669738e-001, 3.669745e-001, 3.669753e-001, 3.669760e-001, 3.669767e-001, 3.669774e-001, 3.669781e-001, 3.669788e-001, 3.669796e-001, 3.669803e-001, 3.669810e-001, 3.669817e-001, 3.669824e-001, 3.669831e-001, 3.669839e-001, 3.669846e-001, 3.669853e-001, 3.669860e-001, 3.669867e-001, 3.669874e-001, 3.669881e-001, 3.669888e-001, 3.669896e-001, 3.669903e-001, 3.669910e-001, 3.669917e-001, 3.669924e-001, 3.669931e-001, 3.669938e-001, 3.669945e-001, 3.669953e-001, 3.669960e-001, 3.669967e-001, 3.669974e-001, 3.669981e-001, 3.669988e-001, 3.669995e-001, 3.670002e-001, 3.670009e-001, 3.670016e-001, 3.670023e-001, 3.670030e-001, 3.670037e-001, 3.670045e-001, 3.670052e-001, 3.670059e-001, 3.670066e-001, 3.670073e-001, 3.670080e-001, 3.670087e-001, 3.670094e-001, 3.670101e-001, 3.670108e-001, 3.670115e-001, 3.670122e-001, 3.670129e-001, 3.670136e-001, 3.670143e-001, 3.670150e-001, 3.670157e-001, 3.670164e-001, 3.670171e-001, 3.670178e-001, 
3.670185e-001, 3.670192e-001, 3.670199e-001, 3.670206e-001, 3.670213e-001, 3.670220e-001, 3.670227e-001, 3.670234e-001, 3.670241e-001, 3.670248e-001, 3.670255e-001, 3.670262e-001, 3.670269e-001, 3.670276e-001, 3.670283e-001, 3.670290e-001, 3.670297e-001, 3.670304e-001, 3.670311e-001, 3.670318e-001, 3.670325e-001, 3.670332e-001, 3.670339e-001, 3.670345e-001, 3.670352e-001, 3.670359e-001, 3.670366e-001, 3.670373e-001, 3.670380e-001, 3.670387e-001, 3.670394e-001, 3.670401e-001, 3.670408e-001, 3.670415e-001, 3.670422e-001, 3.670428e-001, 3.670435e-001, 3.670442e-001, 3.670449e-001, 3.670456e-001, 3.670463e-001, 3.670470e-001, 3.670477e-001, 3.670484e-001, 3.670490e-001, 3.670497e-001, 3.670504e-001, 3.670511e-001, 3.670518e-001, 3.670525e-001, 3.670532e-001, 3.670539e-001, 3.670545e-001, 3.670552e-001, 3.670559e-001, 3.670566e-001, 3.670573e-001, 3.670580e-001, 3.670586e-001, 3.670593e-001, 3.670600e-001, 3.670607e-001, 3.670614e-001, 3.670621e-001, 3.670627e-001, 3.670634e-001, 3.670641e-001, 3.670648e-001, 3.670655e-001, 3.670661e-001, 3.670668e-001, 3.670675e-001, 3.670682e-001, 3.670689e-001, 3.670695e-001, 3.670702e-001, 3.670709e-001, 3.670716e-001, 3.670723e-001, 3.670729e-001, 3.670736e-001, 3.670743e-001, 3.670750e-001, 3.670756e-001, 3.670763e-001, 3.670770e-001, 3.670777e-001, 3.670783e-001, 3.670790e-001, 3.670797e-001, 3.670804e-001, 3.670810e-001, 3.670817e-001, 3.670824e-001, 3.670831e-001, 3.670837e-001, 3.670844e-001, 3.670851e-001, 3.670857e-001, 3.670864e-001, 
3.670871e-001, 3.670878e-001, 3.670884e-001, 3.670891e-001, 3.670898e-001, 3.670904e-001, 3.670911e-001, 3.670918e-001, 3.670924e-001, 3.670931e-001, 3.670938e-001, 3.670945e-001, 3.670951e-001, 3.670958e-001, 3.670965e-001, 3.670971e-001, 3.670978e-001, 3.670985e-001, 3.670991e-001, 3.670998e-001, 3.671005e-001, 3.671011e-001, 3.671018e-001, 3.671024e-001, 3.671031e-001, 3.671038e-001, 3.671044e-001, 3.671051e-001, 3.671058e-001, 3.671064e-001, 3.671071e-001, 3.671078e-001, 3.671084e-001, 3.671091e-001, 3.671097e-001, 3.671104e-001, 3.671111e-001, 3.671117e-001, 3.671124e-001, 3.671130e-001, 3.671137e-001, 3.671144e-001, 3.671150e-001, 3.671157e-001, 3.671163e-001, 3.671170e-001, 3.671177e-001, 3.671183e-001, 3.671190e-001, 3.671196e-001, 3.671203e-001, 3.671209e-001, 3.671216e-001, 3.671222e-001, 3.671229e-001, 3.671236e-001, 3.671242e-001, 3.671249e-001, 3.671255e-001, 3.671262e-001, 3.671268e-001, 3.671275e-001, 3.671281e-001, 3.671288e-001, 3.671294e-001, 3.671301e-001, 3.671307e-001, 3.671314e-001, 3.671321e-001, 3.671327e-001, 3.671334e-001, 3.671340e-001, 3.671347e-001, 3.671353e-001, 3.671360e-001, 3.671366e-001, 3.671373e-001, 3.671379e-001, 3.671386e-001, 3.671392e-001, 3.671398e-001, 3.671405e-001, 3.671411e-001, 3.671418e-001, 3.671424e-001, 3.671431e-001, 3.671437e-001, 3.671444e-001, 3.671450e-001, 3.671457e-001, 3.671463e-001, 3.671470e-001, 3.671476e-001, 3.671482e-001, 3.671489e-001, 3.671495e-001, 3.671502e-001, 3.671508e-001, 3.671515e-001, 3.671521e-001, 
3.671527e-001, 3.671534e-001, 3.671540e-001, 3.671547e-001, 3.671553e-001, 3.671560e-001, 3.671566e-001, 3.671572e-001, 3.671579e-001, 3.671585e-001, 3.671592e-001, 3.671598e-001, 3.671604e-001, 3.671611e-001, 3.671617e-001, 3.671623e-001, 3.671630e-001, 3.671636e-001, 3.671643e-001, 3.671649e-001, 3.671655e-001, 3.671662e-001, 3.671668e-001, 3.671674e-001, 3.671681e-001, 3.671687e-001, 3.671693e-001, 3.671700e-001, 3.671706e-001, 3.671712e-001, 3.671719e-001, 3.671725e-001, 3.671731e-001, 3.671738e-001, 3.671744e-001, 3.671750e-001, 3.671757e-001, 3.671763e-001, 3.671769e-001, 3.671776e-001, 3.671782e-001, 3.671788e-001, 3.671795e-001, 3.671801e-001, 3.671807e-001, 3.671813e-001, 3.671820e-001, 3.671826e-001, 3.671832e-001, 3.671839e-001, 3.671845e-001, 3.671851e-001, 3.671857e-001, 3.671864e-001, 3.671870e-001, 3.671876e-001, 3.671883e-001, 3.671889e-001, 3.671895e-001, 3.671901e-001, 3.671908e-001, 3.671914e-001, 3.671920e-001, 3.671926e-001, 3.671932e-001, 3.671939e-001, 3.671945e-001, 3.671951e-001, 3.671957e-001, 3.671964e-001, 3.671970e-001, 3.671976e-001, 3.671982e-001, 3.671988e-001, 3.671995e-001, 3.672001e-001, 3.672007e-001, 3.672013e-001, 3.672020e-001, 3.672026e-001, 3.672032e-001, 3.672038e-001, 3.672044e-001, 3.672050e-001, 3.672057e-001, 3.672063e-001, 3.672069e-001, 3.672075e-001, 3.672081e-001, 3.672087e-001, 3.672094e-001, 3.672100e-001, 3.672106e-001, 3.672112e-001, 3.672118e-001, 3.672124e-001, 3.672131e-001, 3.672137e-001, 3.672143e-001, 3.672149e-001, 
3.672155e-001, 3.672161e-001, 3.672167e-001, 3.672173e-001, 3.672180e-001, 3.672186e-001, 3.672192e-001, 3.672198e-001, 3.672204e-001, 3.672210e-001, 3.672216e-001, 3.672222e-001, 3.672228e-001, 3.672235e-001, 3.672241e-001, 3.672247e-001, 3.672253e-001, 3.672259e-001, 3.672265e-001, 3.672271e-001, 3.672277e-001, 3.672283e-001, 3.672289e-001, 3.672295e-001, 3.672301e-001, 3.672307e-001, 3.672314e-001, 3.672320e-001, 3.672326e-001, 3.672332e-001, 3.672338e-001, 3.672344e-001, 3.672350e-001, 3.672356e-001, 3.672362e-001, 3.672368e-001, 3.672374e-001, 3.672380e-001, 3.672386e-001, 3.672392e-001, 3.672398e-001, 3.672404e-001, 3.672410e-001, 3.672416e-001, 3.672422e-001, 3.672428e-001, 3.672434e-001, 3.672440e-001, 3.672446e-001, 3.672452e-001, 3.672458e-001, 3.672464e-001, 3.672470e-001, 3.672476e-001, 3.672482e-001, 3.672488e-001, 3.672494e-001, 3.672500e-001, 3.672506e-001, 3.672512e-001, 3.672518e-001, 3.672524e-001, 3.672530e-001, 3.672536e-001, 3.672542e-001, 3.672548e-001, 3.672554e-001, 3.672559e-001, 3.672565e-001, 3.672571e-001, 3.672577e-001, 3.672583e-001, 3.672589e-001, 3.672595e-001, 3.672601e-001, 3.672607e-001, 3.672613e-001, 3.672619e-001, 3.672625e-001, 3.672630e-001, 3.672636e-001, 3.672642e-001, 3.672648e-001, 3.672654e-001, 3.672660e-001, 3.672666e-001, 3.672672e-001, 3.672678e-001, 3.672684e-001, 3.672689e-001, 3.672695e-001, 3.672701e-001, 3.672707e-001, 3.672713e-001, 3.672719e-001, 3.672725e-001, 3.672730e-001, 3.672736e-001, 3.672742e-001, 3.672748e-001, 
3.672754e-001, 3.672760e-001, 3.672766e-001, 3.672771e-001, 3.672777e-001, 3.672783e-001, 3.672789e-001, 3.672795e-001, 3.672800e-001, 3.672806e-001, 3.672812e-001, 3.672818e-001, 3.672824e-001, 3.672830e-001, 3.672835e-001, 3.672841e-001, 3.672847e-001, 3.672853e-001, 3.672859e-001, 3.672864e-001, 3.672870e-001, 3.672876e-001, 3.672882e-001, 3.672887e-001, 3.672893e-001, 3.672899e-001, 3.672905e-001, 3.672911e-001, 3.672916e-001, 3.672922e-001, 3.672928e-001, 3.672934e-001, 3.672939e-001, 3.672945e-001, 3.672951e-001, 3.672957e-001, 3.672962e-001, 3.672968e-001, 3.672974e-001, 3.672980e-001, 3.672985e-001, 3.672991e-001, 3.672997e-001, 3.673002e-001, 3.673008e-001, 3.673014e-001, 3.673020e-001, 3.673025e-001, 3.673031e-001, 3.673037e-001, 3.673042e-001, 3.673048e-001, 3.673054e-001, 3.673059e-001, 3.673065e-001, 3.673071e-001, 3.673077e-001, 3.673082e-001, 3.673088e-001, 3.673094e-001, 3.673099e-001, 3.673105e-001, 3.673111e-001, 3.673116e-001, 3.673122e-001, 3.673128e-001, 3.673133e-001, 3.673139e-001, 3.673145e-001, 3.673150e-001, 3.673156e-001, 3.673161e-001, 3.673167e-001, 3.673173e-001, 3.673178e-001, 3.673184e-001, 3.673190e-001, 3.673195e-001, 3.673201e-001, 3.673206e-001, 3.673212e-001, 3.673218e-001, 3.673223e-001, 3.673229e-001, 3.673234e-001, 3.673240e-001, 3.673246e-001, 3.673251e-001, 3.673257e-001, 3.673262e-001, 3.673268e-001, 3.673274e-001, 3.673279e-001, 3.673285e-001, 3.673290e-001, 3.673296e-001, 3.673301e-001, 3.673307e-001, 3.673313e-001, 3.673318e-001, 
3.673324e-001, 3.673329e-001, 3.673335e-001, 3.673340e-001, 3.673346e-001, 3.673351e-001, 3.673357e-001, 3.673363e-001, 3.673368e-001, 3.673374e-001, 3.673379e-001, 3.673385e-001, 3.673390e-001, 3.673396e-001, 3.673401e-001, 3.673407e-001, 3.673412e-001, 3.673418e-001, 3.673423e-001, 3.673429e-001, 3.673434e-001, 3.673440e-001, 3.673445e-001, 3.673451e-001, 3.673456e-001, 3.673462e-001, 3.673467e-001, 3.673473e-001, 3.673478e-001, 3.673484e-001, 3.673489e-001, 3.673495e-001, 3.673500e-001, 3.673506e-001, 3.673511e-001, 3.673516e-001, 3.673522e-001, 3.673527e-001, 3.673533e-001, 3.673538e-001, 3.673544e-001, 3.673549e-001, 3.673555e-001, 3.673560e-001, 3.673565e-001, 3.673571e-001, 3.673576e-001, 3.673582e-001, 3.673587e-001, 3.673593e-001, 3.673598e-001, 3.673603e-001, 3.673609e-001, 3.673614e-001, 3.673620e-001, 3.673625e-001, 3.673630e-001, 3.673636e-001, 3.673641e-001, 3.673647e-001, 3.673652e-001, 3.673657e-001, 3.673663e-001, 3.673668e-001, 3.673673e-001, 3.673679e-001, 3.673684e-001, 3.673689e-001, 3.673695e-001, 3.673700e-001, 3.673706e-001, 3.673711e-001, 3.673716e-001, 3.673722e-001, 3.673727e-001, 3.673732e-001, 3.673738e-001, 3.673743e-001, 3.673748e-001, 3.673754e-001, 3.673759e-001, 3.673764e-001, 3.673770e-001, 3.673775e-001, 3.673780e-001, 3.673786e-001, 3.673791e-001, 3.673796e-001, 3.673801e-001, 3.673807e-001, 3.673812e-001, 3.673817e-001, 3.673823e-001, 3.673828e-001, 3.673833e-001, 3.673839e-001, 3.673844e-001, 3.673849e-001, 3.673854e-001, 3.673860e-001, 
3.673865e-001, 3.673870e-001, 3.673875e-001, 3.673881e-001, 3.673886e-001, 3.673891e-001, 3.673896e-001, 3.673902e-001, 3.673907e-001, 3.673912e-001, 3.673917e-001, 3.673923e-001, 3.673928e-001, 3.673933e-001, 3.673938e-001, 3.673944e-001, 3.673949e-001, 3.673954e-001, 3.673959e-001, 3.673964e-001, 3.673970e-001, 3.673975e-001, 3.673980e-001, 3.673985e-001, 3.673991e-001, 3.673996e-001, 3.674001e-001, 3.674006e-001, 3.674011e-001, 3.674016e-001, 3.674022e-001, 3.674027e-001, 3.674032e-001, 3.674037e-001, 3.674042e-001, 3.674048e-001, 3.674053e-001, 3.674058e-001, 3.674063e-001, 3.674068e-001, 3.674073e-001, 3.674079e-001, 3.674084e-001, 3.674089e-001, 3.674094e-001, 3.674099e-001, 3.674104e-001, 3.674109e-001, 3.674114e-001, 3.674120e-001, 3.674125e-001, 3.674130e-001, 3.674135e-001, 3.674140e-001, 3.674145e-001, 3.674150e-001, 3.674155e-001, 3.674161e-001, 3.674166e-001, 3.674171e-001, 3.674176e-001, 3.674181e-001, 3.674186e-001, 3.674191e-001, 3.674196e-001, 3.674201e-001, 3.674206e-001, 3.674211e-001, 3.674217e-001, 3.674222e-001, 3.674227e-001, 3.674232e-001, 3.674237e-001, 3.674242e-001, 3.674247e-001, 3.674252e-001, 3.674257e-001, 3.674262e-001, 3.674267e-001, 3.674272e-001, 3.674277e-001, 3.674282e-001, 3.674287e-001, 3.674292e-001, 3.674297e-001, 3.674302e-001, 3.674307e-001, 3.674312e-001, 3.674317e-001, 3.674322e-001, 3.674327e-001, 3.674332e-001, 3.674337e-001, 3.674342e-001, 3.674347e-001, 3.674352e-001, 3.674357e-001, 3.674362e-001, 3.674367e-001, 3.674372e-001, 
3.674377e-001, 3.674382e-001, 3.674387e-001, 3.674392e-001, 3.674397e-001, 3.674402e-001, 3.674407e-001, 3.674412e-001, 3.674417e-001, 3.674422e-001, 3.674427e-001, 3.674432e-001, 3.674437e-001, 3.674442e-001, 3.674447e-001, 3.674452e-001, 3.674457e-001, 3.674462e-001, 3.674467e-001, 3.674472e-001, 3.674477e-001, 3.674481e-001, 3.674486e-001, 3.674491e-001, 3.674496e-001, 3.674501e-001, 3.674506e-001, 3.674511e-001, 3.674516e-001, 3.674521e-001, 3.674526e-001, 3.674531e-001, 3.674535e-001, 3.674540e-001, 3.674545e-001, 3.674550e-001, 3.674555e-001, 3.674560e-001, 3.674565e-001, 3.674570e-001, 3.674574e-001, 3.674579e-001, 3.674584e-001, 3.674589e-001, 3.674594e-001, 3.674599e-001, 3.674604e-001, 3.674608e-001, 3.674613e-001, 3.674618e-001, 3.674623e-001, 3.674628e-001, 3.674633e-001, 3.674637e-001, 3.674642e-001, 3.674647e-001, 3.674652e-001, 3.674657e-001, 3.674662e-001, 3.674666e-001, 3.674671e-001, 3.674676e-001, 3.674681e-001, 3.674686e-001, 3.674690e-001, 3.674695e-001, 3.674700e-001, 3.674705e-001, 3.674710e-001, 3.674714e-001, 3.674719e-001, 3.674724e-001, 3.674729e-001, 3.674734e-001, 3.674738e-001, 3.674743e-001, 3.674748e-001, 3.674753e-001, 3.674757e-001, 3.674762e-001, 3.674767e-001, 3.674772e-001, 3.674776e-001, 3.674781e-001, 3.674786e-001, 3.674791e-001, 3.674795e-001, 3.674800e-001, 3.674805e-001, 3.674810e-001, 3.674814e-001, 3.674819e-001, 3.674824e-001, 3.674828e-001, 3.674833e-001, 3.674838e-001, 3.674843e-001, 3.674847e-001, 3.674852e-001, 3.674857e-001, 
3.674861e-001, 3.674866e-001, 3.674871e-001, 3.674875e-001, 3.674880e-001, 3.674885e-001, 3.674890e-001, 3.674894e-001, 3.674899e-001, 3.674904e-001, 3.674908e-001, 3.674913e-001, 3.674918e-001, 3.674922e-001, 3.674927e-001, 3.674932e-001, 3.674936e-001, 3.674941e-001, 3.674945e-001, 3.674950e-001, 3.674955e-001, 3.674959e-001, 3.674964e-001, 3.674969e-001, 3.674973e-001, 3.674978e-001, 3.674983e-001, 3.674987e-001, 3.674992e-001, 3.674996e-001, 3.675001e-001, 3.675006e-001, 3.675010e-001, 3.675015e-001, 3.675019e-001, 3.675024e-001, 3.675029e-001, 3.675033e-001, 3.675038e-001, 3.675042e-001, 3.675047e-001, 3.675052e-001, 3.675056e-001, 3.675061e-001, 3.675065e-001, 3.675070e-001, 3.675074e-001, 3.675079e-001, 3.675084e-001, 3.675088e-001, 3.675093e-001, 3.675097e-001, 3.675102e-001, 3.675106e-001, 3.675111e-001, 3.675115e-001, 3.675120e-001, 3.675124e-001, 3.675129e-001, 3.675134e-001, 3.675138e-001, 3.675143e-001, 3.675147e-001, 3.675152e-001, 3.675156e-001, 3.675161e-001, 3.675165e-001, 3.675170e-001, 3.675174e-001, 3.675179e-001, 3.675183e-001, 3.675188e-001, 3.675192e-001, 3.675197e-001, 3.675201e-001, 3.675206e-001, 3.675210e-001, 3.675215e-001, 3.675219e-001, 3.675224e-001, 3.675228e-001, 3.675232e-001, 3.675237e-001, 3.675241e-001, 3.675246e-001, 3.675250e-001, 3.675255e-001, 3.675259e-001, 3.675264e-001, 3.675268e-001, 3.675273e-001, 3.675277e-001, 3.675281e-001, 3.675286e-001, 3.675290e-001, 3.675295e-001, 3.675299e-001, 3.675304e-001, 3.675308e-001, 3.675312e-001, 
3.675317e-001, 3.675321e-001, 3.675326e-001, 3.675330e-001, 3.675334e-001, 3.675339e-001, 3.675343e-001, 3.675348e-001, 3.675352e-001, 3.675356e-001, 3.675361e-001, 3.675365e-001, 3.675370e-001, 3.675374e-001, 3.675378e-001, 3.675383e-001, 3.675387e-001, 3.675391e-001, 3.675396e-001, 3.675400e-001, 3.675405e-001, 3.675409e-001, 3.675413e-001, 3.675418e-001, 3.675422e-001, 3.675426e-001, 3.675431e-001, 3.675435e-001, 3.675439e-001, 3.675444e-001, 3.675448e-001, 3.675452e-001, 3.675457e-001, 3.675461e-001, 3.675465e-001, 3.675470e-001, 3.675474e-001, 3.675478e-001, 3.675482e-001, 3.675487e-001, 3.675491e-001, 3.675495e-001, 3.675500e-001, 3.675504e-001, 3.675508e-001, 3.675513e-001, 3.675517e-001, 3.675521e-001, 3.675525e-001, 3.675530e-001, 3.675534e-001, 3.675538e-001, 3.675542e-001, 3.675547e-001, 3.675551e-001, 3.675555e-001, 3.675559e-001, 3.675564e-001, 3.675568e-001, 3.675572e-001, 3.675576e-001, 3.675581e-001, 3.675585e-001, 3.675589e-001, 3.675593e-001, 3.675598e-001, 3.675602e-001, 3.675606e-001, 3.675610e-001, 3.675615e-001, 3.675619e-001, 3.675623e-001, 3.675627e-001, 3.675631e-001, 3.675636e-001, 3.675640e-001, 3.675644e-001, 3.675648e-001, 3.675652e-001, 3.675657e-001, 3.675661e-001, 3.675665e-001, 3.675669e-001, 3.675673e-001, 3.675677e-001, 3.675682e-001, 3.675686e-001, 3.675690e-001, 3.675694e-001, 3.675698e-001, 3.675702e-001, 3.675707e-001, 3.675711e-001, 3.675715e-001, 3.675719e-001, 3.675723e-001, 3.675727e-001, 3.675731e-001, 3.675736e-001, 3.675740e-001, 
3.675744e-001, 3.675748e-001, 3.675752e-001, 3.675756e-001, 3.675760e-001, 3.675765e-001, 3.675769e-001, 3.675773e-001, 3.675777e-001, 3.675781e-001, 3.675785e-001, 3.675789e-001, 3.675793e-001, 3.675797e-001, 3.675801e-001, 3.675806e-001, 3.675810e-001, 3.675814e-001, 3.675818e-001, 3.675822e-001, 3.675826e-001, 3.675830e-001, 3.675834e-001, 3.675838e-001, 3.675842e-001, 3.675846e-001, 3.675850e-001, 3.675854e-001, 3.675858e-001, 3.675862e-001, 3.675866e-001, 3.675871e-001, 3.675875e-001, 3.675879e-001, 3.675883e-001, 3.675887e-001, 3.675891e-001, 3.675895e-001, 3.675899e-001, 3.675903e-001, 3.675907e-001, 3.675911e-001, 3.675915e-001, 3.675919e-001, 3.675923e-001, 3.675927e-001, 3.675931e-001, 3.675935e-001, 3.675939e-001, 3.675943e-001, 3.675947e-001, 3.675951e-001, 3.675955e-001, 3.675959e-001, 3.675963e-001, 3.675967e-001, 3.675971e-001, 3.675975e-001, 3.675979e-001, 3.675983e-001, 3.675987e-001, 3.675990e-001, 3.675994e-001, 3.675998e-001, 3.676002e-001, 3.676006e-001, 3.676010e-001, 3.676014e-001, 3.676018e-001, 3.676022e-001, 3.676026e-001, 3.676030e-001, 3.676034e-001, 3.676038e-001, 3.676042e-001, 3.676046e-001, 3.676050e-001, 3.676053e-001, 3.676057e-001, 3.676061e-001, 3.676065e-001, 3.676069e-001, 3.676073e-001, 3.676077e-001, 3.676081e-001, 3.676085e-001, 3.676088e-001, 3.676092e-001, 3.676096e-001, 3.676100e-001, 3.676104e-001, 3.676108e-001, 3.676112e-001, 3.676116e-001, 3.676119e-001, 3.676123e-001, 3.676127e-001, 3.676131e-001, 3.676135e-001, 3.676139e-001, 
3.676143e-001, 3.676146e-001, 3.676150e-001, 3.676154e-001, 3.676158e-001, 3.676162e-001, 3.676166e-001, 3.676169e-001, 3.676173e-001, 3.676177e-001, 3.676181e-001, 3.676185e-001, 3.676189e-001, 3.676192e-001, 3.676196e-001, 3.676200e-001, 3.676204e-001, 3.676208e-001, 3.676211e-001, 3.676215e-001, 3.676219e-001, 3.676223e-001, 3.676227e-001, 3.676230e-001, 3.676234e-001, 3.676238e-001, 3.676242e-001, 3.676245e-001, 3.676249e-001, 3.676253e-001, 3.676257e-001, 3.676260e-001, 3.676264e-001, 3.676268e-001, 3.676272e-001, 3.676275e-001, 3.676279e-001, 3.676283e-001, 3.676287e-001, 3.676290e-001, 3.676294e-001, 3.676298e-001, 3.676302e-001, 3.676305e-001, 3.676309e-001, 3.676313e-001, 3.676317e-001, 3.676320e-001, 3.676324e-001, 3.676328e-001, 3.676331e-001, 3.676335e-001, 3.676339e-001, 3.676342e-001, 3.676346e-001, 3.676350e-001, 3.676354e-001, 3.676357e-001, 3.676361e-001, 3.676365e-001, 3.676368e-001, 3.676372e-001, 3.676376e-001, 3.676379e-001, 3.676383e-001, 3.676387e-001, 3.676390e-001, 3.676394e-001, 3.676398e-001, 3.676401e-001, 3.676405e-001, 3.676409e-001, 3.676412e-001, 3.676416e-001, 3.676419e-001, 3.676423e-001, 3.676427e-001, 3.676430e-001, 3.676434e-001, 3.676438e-001, 3.676441e-001, 3.676445e-001, 3.676448e-001, 3.676452e-001, 3.676456e-001, 3.676459e-001, 3.676463e-001, 3.676467e-001, 3.676470e-001, 3.676474e-001, 3.676477e-001, 3.676481e-001, 3.676484e-001, 3.676488e-001, 3.676492e-001, 3.676495e-001, 3.676499e-001, 3.676502e-001, 3.676506e-001, 3.676510e-001, 
3.676513e-001, 3.676517e-001, 3.676520e-001, 3.676524e-001, 3.676527e-001, 3.676531e-001, 3.676534e-001, 3.676538e-001, 3.676542e-001, 3.676545e-001, 3.676549e-001, 3.676552e-001, 3.676556e-001, 3.676559e-001, 3.676563e-001, 3.676566e-001, 3.676570e-001, 3.676573e-001, 3.676577e-001, 3.676580e-001, 3.676584e-001, 3.676587e-001, 3.676591e-001, 3.676594e-001, 3.676598e-001, 3.676601e-001, 3.676605e-001, 3.676608e-001, 3.676612e-001, 3.676615e-001, 3.676619e-001, 3.676622e-001, 3.676626e-001, 3.676629e-001, 3.676633e-001, 3.676636e-001, 3.676640e-001, 3.676643e-001, 3.676646e-001, 3.676650e-001, 3.676653e-001, 3.676657e-001, 3.676660e-001, 3.676664e-001, 3.676667e-001, 3.676671e-001, 3.676674e-001, 3.676677e-001, 3.676681e-001, 3.676684e-001, 3.676688e-001, 3.676691e-001, 3.676695e-001, 3.676698e-001, 3.676701e-001, 3.676705e-001, 3.676708e-001, 3.676712e-001, 3.676715e-001, 3.676718e-001, 3.676722e-001, 3.676725e-001, 3.676729e-001, 3.676732e-001, 3.676735e-001, 3.676739e-001, 3.676742e-001, 3.676746e-001, 3.676749e-001, 3.676752e-001, 3.676756e-001, 3.676759e-001, 3.676762e-001, 3.676766e-001, 3.676769e-001, 3.676772e-001, 3.676776e-001, 3.676779e-001, 3.676782e-001, 3.676786e-001, 3.676789e-001, 3.676793e-001, 3.676796e-001, 3.676799e-001, 3.676803e-001, 3.676806e-001, 3.676809e-001, 3.676812e-001, 3.676816e-001, 3.676819e-001, 3.676822e-001, 3.676826e-001, 3.676829e-001, 3.676832e-001, 3.676836e-001, 3.676839e-001, 3.676842e-001, 3.676846e-001, 3.676849e-001, 3.676852e-001, 
3.676855e-001, 3.676859e-001, 3.676862e-001, 3.676865e-001, 3.676868e-001, 3.676872e-001, 3.676875e-001, 3.676878e-001, 3.676882e-001, 3.676885e-001, 3.676888e-001, 3.676891e-001, 3.676895e-001, 3.676898e-001, 3.676901e-001, 3.676904e-001, 3.676908e-001, 3.676911e-001, 3.676914e-001, 3.676917e-001, 3.676920e-001, 3.676924e-001, 3.676927e-001, 3.676930e-001, 3.676933e-001, 3.676937e-001, 3.676940e-001, 3.676943e-001, 3.676946e-001, 3.676949e-001, 3.676953e-001, 3.676956e-001, 3.676959e-001, 3.676962e-001, 3.676965e-001, 3.676969e-001, 3.676972e-001, 3.676975e-001, 3.676978e-001, 3.676981e-001, 3.676984e-001, 3.676988e-001, 3.676991e-001, 3.676994e-001, 3.676997e-001, 3.677000e-001, 3.677003e-001, 3.677007e-001, 3.677010e-001, 3.677013e-001, 3.677016e-001, 3.677019e-001, 3.677022e-001, 3.677025e-001, 3.677029e-001, 3.677032e-001, 3.677035e-001, 3.677038e-001, 3.677041e-001, 3.677044e-001, 3.677047e-001, 3.677050e-001, 3.677054e-001, 3.677057e-001, 3.677060e-001, 3.677063e-001, 3.677066e-001, 3.677069e-001, 3.677072e-001, 3.677075e-001, 3.677078e-001, 3.677081e-001, 3.677084e-001, 3.677088e-001, 3.677091e-001, 3.677094e-001, 3.677097e-001, 3.677100e-001, 3.677103e-001, 3.677106e-001, 3.677109e-001, 3.677112e-001, 3.677115e-001, 3.677118e-001, 3.677121e-001, 3.677124e-001, 3.677127e-001, 3.677130e-001, 3.677133e-001, 3.677136e-001, 3.677139e-001, 3.677142e-001, 3.677145e-001, 3.677149e-001, 3.677152e-001, 3.677155e-001, 3.677158e-001, 3.677161e-001, 3.677164e-001, 3.677167e-001, 
3.677170e-001, 3.677173e-001, 3.677176e-001, 3.677179e-001, 3.677182e-001, 3.677185e-001, 3.677188e-001, 3.677191e-001, 3.677194e-001, 3.677197e-001, 3.677199e-001, 3.677202e-001, 3.677205e-001, 3.677208e-001, 3.677211e-001, 3.677214e-001, 3.677217e-001, 3.677220e-001, 3.677223e-001, 3.677226e-001, 3.677229e-001, 3.677232e-001, 3.677235e-001, 3.677238e-001, 3.677241e-001, 3.677244e-001, 3.677247e-001, 3.677250e-001, 3.677253e-001, 3.677255e-001, 3.677258e-001, 3.677261e-001, 3.677264e-001, 3.677267e-001, 3.677270e-001, 3.677273e-001, 3.677276e-001, 3.677279e-001, 3.677282e-001, 3.677285e-001, 3.677287e-001, 3.677290e-001, 3.677293e-001, 3.677296e-001, 3.677299e-001, 3.677302e-001, 3.677305e-001, 3.677308e-001, 3.677310e-001, 3.677313e-001, 3.677316e-001, 3.677319e-001, 3.677322e-001, 3.677325e-001, 3.677328e-001, 3.677330e-001, 3.677333e-001, 3.677336e-001, 3.677339e-001, 3.677342e-001, 3.677345e-001, 3.677348e-001, 3.677350e-001, 3.677353e-001, 3.677356e-001, 3.677359e-001, 3.677362e-001, 3.677364e-001, 3.677367e-001, 3.677370e-001, 3.677373e-001, 3.677376e-001, 3.677378e-001, 3.677381e-001, 3.677384e-001, 3.677387e-001, 3.677390e-001, 3.677392e-001, 3.677395e-001, 3.677398e-001, 3.677401e-001, 3.677404e-001, 3.677406e-001, 3.677409e-001, 3.677412e-001, 3.677415e-001, 3.677417e-001, 3.677420e-001, 3.677423e-001, 3.677426e-001, 3.677428e-001, 3.677431e-001, 3.677434e-001, 3.677437e-001, 3.677439e-001, 3.677442e-001, 3.677445e-001, 3.677448e-001, 3.677450e-001, 3.677453e-001, 
3.677456e-001, 3.677459e-001, 3.677461e-001, 3.677464e-001, 3.677467e-001, 3.677469e-001, 3.677472e-001, 3.677475e-001, 3.677477e-001, 3.677480e-001, 3.677483e-001, 3.677486e-001, 3.677488e-001, 3.677491e-001, 3.677494e-001, 3.677496e-001, 3.677499e-001, 3.677502e-001, 3.677504e-001, 3.677507e-001, 3.677510e-001, 3.677512e-001, 3.677515e-001, 3.677518e-001, 3.677520e-001, 3.677523e-001, 3.677526e-001, 3.677528e-001, 3.677531e-001, 3.677534e-001, 3.677536e-001, 3.677539e-001, 3.677541e-001, 3.677544e-001, 3.677547e-001, 3.677549e-001, 3.677552e-001, 3.677555e-001, 3.677557e-001, 3.677560e-001, 3.677562e-001, 3.677565e-001, 3.677568e-001, 3.677570e-001, 3.677573e-001, 3.677575e-001, 3.677578e-001, 3.677581e-001, 3.677583e-001, 3.677586e-001, 3.677588e-001, 3.677591e-001, 3.677594e-001, 3.677596e-001, 3.677599e-001, 3.677601e-001, 3.677604e-001, 3.677606e-001, 3.677609e-001, 3.677612e-001, 3.677614e-001, 3.677617e-001, 3.677619e-001, 3.677622e-001, 3.677624e-001, 3.677627e-001, 3.677629e-001, 3.677632e-001, 3.677634e-001, 3.677637e-001, 3.677640e-001, 3.677642e-001, 3.677645e-001, 3.677647e-001, 3.677650e-001, 3.677652e-001, 3.677655e-001, 3.677657e-001, 3.677660e-001, 3.677662e-001, 3.677665e-001, 3.677667e-001, 3.677670e-001, 3.677672e-001, 3.677675e-001, 3.677677e-001, 3.677680e-001, 3.677682e-001, 3.677685e-001, 3.677687e-001, 3.677690e-001, 3.677692e-001, 3.677694e-001, 3.677697e-001, 3.677699e-001, 3.677702e-001, 3.677704e-001, 3.677707e-001, 3.677709e-001, 3.677712e-001, 
3.677714e-001, 3.677717e-001, 3.677719e-001, 3.677721e-001, 3.677724e-001, 3.677726e-001, 3.677729e-001, 3.677731e-001, 3.677734e-001, 3.677736e-001, 3.677738e-001, 3.677741e-001, 3.677743e-001, 3.677746e-001, 3.677748e-001, 3.677750e-001, 3.677753e-001, 3.677755e-001, 3.677758e-001, 3.677760e-001, 3.677762e-001, 3.677765e-001, 3.677767e-001, 3.677770e-001, 3.677772e-001, 3.677774e-001, 3.677777e-001, 3.677779e-001, 3.677781e-001, 3.677784e-001, 3.677786e-001, 3.677788e-001, 3.677791e-001, 3.677793e-001, 3.677796e-001, 3.677798e-001, 3.677800e-001, 3.677803e-001, 3.677805e-001, 3.677807e-001, 3.677810e-001, 3.677812e-001, 3.677814e-001, 3.677817e-001, 3.677819e-001, 3.677821e-001, 3.677824e-001, 3.677826e-001, 3.677828e-001, 3.677830e-001, 3.677833e-001, 3.677835e-001, 3.677837e-001, 3.677840e-001, 3.677842e-001, 3.677844e-001, 3.677847e-001, 3.677849e-001, 3.677851e-001, 3.677853e-001, 3.677856e-001, 3.677858e-001, 3.677860e-001, 3.677862e-001, 3.677865e-001, 3.677867e-001, 3.677869e-001, 3.677872e-001, 3.677874e-001, 3.677876e-001, 3.677878e-001, 3.677881e-001, 3.677883e-001, 3.677885e-001, 3.677887e-001, 3.677889e-001, 3.677892e-001, 3.677894e-001, 3.677896e-001, 3.677898e-001, 3.677901e-001, 3.677903e-001, 3.677905e-001, 3.677907e-001, 3.677909e-001, 3.677912e-001, 3.677914e-001, 3.677916e-001, 3.677918e-001, 3.677921e-001, 3.677923e-001, 3.677925e-001, 3.677927e-001, 3.677929e-001, 3.677931e-001, 3.677934e-001, 3.677936e-001, 3.677938e-001, 3.677940e-001, 3.677942e-001, 
3.677944e-001, 3.677947e-001, 3.677949e-001, 3.677951e-001, 3.677953e-001, 3.677955e-001, 3.677957e-001, 3.677960e-001, 3.677962e-001, 3.677964e-001, 3.677966e-001, 3.677968e-001, 3.677970e-001, 3.677972e-001, 3.677975e-001, 3.677977e-001, 3.677979e-001, 3.677981e-001, 3.677983e-001, 3.677985e-001, 3.677987e-001, 3.677989e-001, 3.677991e-001, 3.677994e-001, 3.677996e-001, 3.677998e-001, 3.678000e-001, 3.678002e-001, 3.678004e-001, 3.678006e-001, 3.678008e-001, 3.678010e-001, 3.678012e-001, 3.678014e-001, 3.678017e-001, 3.678019e-001, 3.678021e-001, 3.678023e-001, 3.678025e-001, 3.678027e-001, 3.678029e-001, 3.678031e-001, 3.678033e-001, 3.678035e-001, 3.678037e-001, 3.678039e-001, 3.678041e-001, 3.678043e-001, 3.678045e-001, 3.678047e-001, 3.678049e-001, 3.678051e-001, 3.678053e-001, 3.678055e-001, 3.678057e-001, 3.678059e-001, 3.678061e-001, 3.678063e-001, 3.678065e-001, 3.678067e-001, 3.678069e-001, 3.678071e-001, 3.678073e-001, 3.678075e-001, 3.678077e-001, 3.678079e-001, 3.678081e-001, 3.678083e-001, 3.678085e-001, 3.678087e-001, 3.678089e-001, 3.678091e-001, 3.678093e-001, 3.678095e-001, 3.678097e-001, 3.678099e-001, 3.678101e-001, 3.678103e-001, 3.678105e-001, 3.678107e-001, 3.678109e-001, 3.678111e-001, 3.678113e-001, 3.678115e-001, 3.678117e-001, 3.678118e-001, 3.678120e-001, 3.678122e-001, 3.678124e-001, 3.678126e-001, 3.678128e-001, 3.678130e-001, 3.678132e-001, 3.678134e-001, 3.678136e-001, 3.678138e-001, 3.678140e-001, 3.678141e-001, 3.678143e-001, 3.678145e-001, 
3.678147e-001, 3.678149e-001, 3.678151e-001, 3.678153e-001, 3.678155e-001, 3.678157e-001, 3.678158e-001, 3.678160e-001, 3.678162e-001, 3.678164e-001, 3.678166e-001, 3.678168e-001, 3.678170e-001, 3.678171e-001, 3.678173e-001, 3.678175e-001, 3.678177e-001, 3.678179e-001, 3.678181e-001, 3.678182e-001, 3.678184e-001, 3.678186e-001, 3.678188e-001, 3.678190e-001, 3.678192e-001, 3.678193e-001, 3.678195e-001, 3.678197e-001, 3.678199e-001, 3.678201e-001, 3.678203e-001, 3.678204e-001, 3.678206e-001, 3.678208e-001, 3.678210e-001, 3.678212e-001, 3.678213e-001, 3.678215e-001, 3.678217e-001, 3.678219e-001, 3.678220e-001, 3.678222e-001, 3.678224e-001, 3.678226e-001, 3.678228e-001, 3.678229e-001, 3.678231e-001, 3.678233e-001, 3.678235e-001, 3.678236e-001, 3.678238e-001, 3.678240e-001, 3.678242e-001, 3.678243e-001, 3.678245e-001, 3.678247e-001, 3.678248e-001, 3.678250e-001, 3.678252e-001, 3.678254e-001, 3.678255e-001, 3.678257e-001, 3.678259e-001, 3.678261e-001, 3.678262e-001, 3.678264e-001, 3.678266e-001, 3.678267e-001, 3.678269e-001, 3.678271e-001, 3.678272e-001, 3.678274e-001, 3.678276e-001, 3.678278e-001, 3.678279e-001, 3.678281e-001, 3.678283e-001, 3.678284e-001, 3.678286e-001, 3.678288e-001, 3.678289e-001, 3.678291e-001, 3.678293e-001, 3.678294e-001, 3.678296e-001, 3.678298e-001, 3.678299e-001, 3.678301e-001, 3.678303e-001, 3.678304e-001, 3.678306e-001, 3.678307e-001, 3.678309e-001, 3.678311e-001, 3.678312e-001, 3.678314e-001, 3.678316e-001, 3.678317e-001, 3.678319e-001, 3.678320e-001, 
3.678322e-001, 3.678324e-001, 3.678325e-001, 3.678327e-001, 3.678328e-001, 3.678330e-001, 3.678332e-001, 3.678333e-001, 3.678335e-001, 3.678336e-001, 3.678338e-001, 3.678340e-001, 3.678341e-001, 3.678343e-001, 3.678344e-001, 3.678346e-001, 3.678347e-001, 3.678349e-001, 3.678351e-001, 3.678352e-001, 3.678354e-001, 3.678355e-001, 3.678357e-001, 3.678358e-001, 3.678360e-001, 3.678361e-001, 3.678363e-001, 3.678365e-001, 3.678366e-001, 3.678368e-001, 3.678369e-001, 3.678371e-001, 3.678372e-001, 3.678374e-001, 3.678375e-001, 3.678377e-001, 3.678378e-001, 3.678380e-001, 3.678381e-001, 3.678383e-001, 3.678384e-001, 3.678386e-001, 3.678387e-001, 3.678389e-001, 3.678390e-001, 3.678392e-001, 3.678393e-001, 3.678395e-001, 3.678396e-001, 3.678398e-001, 3.678399e-001, 3.678401e-001, 3.678402e-001, 3.678404e-001, 3.678405e-001, 3.678406e-001, 3.678408e-001, 3.678409e-001, 3.678411e-001, 3.678412e-001, 3.678414e-001, 3.678415e-001, 3.678417e-001, 3.678418e-001, 3.678420e-001, 3.678421e-001, 3.678422e-001, 3.678424e-001, 3.678425e-001, 3.678427e-001, 3.678428e-001, 3.678429e-001, 3.678431e-001, 3.678432e-001, 3.678434e-001, 3.678435e-001, 3.678437e-001, 3.678438e-001, 3.678439e-001, 3.678441e-001, 3.678442e-001, 3.678444e-001, 3.678445e-001, 3.678446e-001, 3.678448e-001, 3.678449e-001, 3.678450e-001, 3.678452e-001, 3.678453e-001, 3.678455e-001, 3.678456e-001, 3.678457e-001, 3.678459e-001, 3.678460e-001, 3.678461e-001, 3.678463e-001, 3.678464e-001, 3.678465e-001, 3.678467e-001, 3.678468e-001, 
3.678469e-001, 3.678471e-001, 3.678472e-001, 3.678473e-001, 3.678475e-001, 3.678476e-001, 3.678477e-001, 3.678479e-001, 3.678480e-001, 3.678481e-001, 3.678483e-001, 3.678484e-001, 3.678485e-001, 3.678486e-001, 3.678488e-001, 3.678489e-001, 3.678490e-001, 3.678492e-001, 3.678493e-001, 3.678494e-001, 3.678496e-001, 3.678497e-001, 3.678498e-001, 3.678499e-001, 3.678501e-001, 3.678502e-001, 3.678503e-001, 3.678504e-001, 3.678506e-001, 3.678507e-001, 3.678508e-001, 3.678509e-001, 3.678511e-001, 3.678512e-001, 3.678513e-001, 3.678514e-001, 3.678516e-001, 3.678517e-001, 3.678518e-001, 3.678519e-001, 3.678521e-001, 3.678522e-001, 3.678523e-001, 3.678524e-001, 3.678525e-001, 3.678527e-001, 3.678528e-001, 3.678529e-001, 3.678530e-001, 3.678531e-001, 3.678533e-001, 3.678534e-001, 3.678535e-001, 3.678536e-001, 3.678537e-001, 3.678539e-001, 3.678540e-001, 3.678541e-001, 3.678542e-001, 3.678543e-001, 3.678545e-001, 3.678546e-001, 3.678547e-001, 3.678548e-001, 3.678549e-001, 3.678550e-001, 3.678552e-001, 3.678553e-001, 3.678554e-001, 3.678555e-001, 3.678556e-001, 3.678557e-001, 3.678558e-001, 3.678560e-001, 3.678561e-001, 3.678562e-001, 3.678563e-001, 3.678564e-001, 3.678565e-001, 3.678566e-001, 3.678567e-001, 3.678568e-001, 3.678570e-001, 3.678571e-001, 3.678572e-001, 3.678573e-001, 3.678574e-001, 3.678575e-001, 3.678576e-001, 3.678577e-001, 3.678578e-001, 3.678579e-001, 3.678581e-001, 3.678582e-001, 3.678583e-001, 3.678584e-001, 3.678585e-001, 3.678586e-001, 3.678587e-001, 3.678588e-001, 
3.678589e-001, 3.678590e-001, 3.678591e-001, 3.678592e-001, 3.678593e-001, 3.678594e-001, 3.678595e-001, 3.678596e-001, 3.678598e-001, 3.678599e-001, 3.678600e-001, 3.678601e-001, 3.678602e-001, 3.678603e-001, 3.678604e-001, 3.678605e-001, 3.678606e-001, 3.678607e-001, 3.678608e-001, 3.678609e-001, 3.678610e-001, 3.678611e-001, 3.678612e-001, 3.678613e-001, 3.678614e-001, 3.678615e-001, 3.678616e-001, 3.678617e-001, 3.678618e-001, 3.678619e-001, 3.678620e-001, 3.678621e-001, 3.678622e-001, 3.678623e-001, 3.678624e-001, 3.678625e-001, 3.678626e-001, 3.678626e-001, 3.678627e-001, 3.678628e-001, 3.678629e-001, 3.678630e-001, 3.678631e-001, 3.678632e-001, 3.678633e-001, 3.678634e-001, 3.678635e-001, 3.678636e-001, 3.678637e-001, 3.678638e-001, 3.678639e-001, 3.678640e-001, 3.678641e-001, 3.678641e-001, 3.678642e-001, 3.678643e-001, 3.678644e-001, 3.678645e-001, 3.678646e-001, 3.678647e-001, 3.678648e-001, 3.678649e-001, 3.678650e-001, 3.678650e-001, 3.678651e-001, 3.678652e-001, 3.678653e-001, 3.678654e-001, 3.678655e-001, 3.678656e-001, 3.678657e-001, 3.678657e-001, 3.678658e-001, 3.678659e-001, 3.678660e-001, 3.678661e-001, 3.678662e-001, 3.678663e-001, 3.678663e-001, 3.678664e-001, 3.678665e-001, 3.678666e-001, 3.678667e-001, 3.678668e-001, 3.678669e-001, 3.678669e-001, 3.678670e-001, 3.678671e-001, 3.678672e-001, 3.678673e-001, 3.678673e-001, 3.678674e-001, 3.678675e-001, 3.678676e-001, 3.678677e-001, 3.678677e-001, 3.678678e-001, 3.678679e-001, 3.678680e-001, 3.678681e-001, 
3.678681e-001, 3.678682e-001, 3.678683e-001, 3.678684e-001, 3.678685e-001, 3.678685e-001, 3.678686e-001, 3.678687e-001, 3.678688e-001, 3.678688e-001, 3.678689e-001, 3.678690e-001, 3.678691e-001, 3.678691e-001, 3.678692e-001, 3.678693e-001, 3.678694e-001, 3.678694e-001, 3.678695e-001, 3.678696e-001, 3.678697e-001, 3.678697e-001, 3.678698e-001, 3.678699e-001, 3.678699e-001, 3.678700e-001, 3.678701e-001, 3.678702e-001, 3.678702e-001, 3.678703e-001, 3.678704e-001, 3.678704e-001, 3.678705e-001, 3.678706e-001, 3.678707e-001, 3.678707e-001, 3.678708e-001, 3.678709e-001, 3.678709e-001, 3.678710e-001, 3.678711e-001, 3.678711e-001, 3.678712e-001, 3.678713e-001, 3.678713e-001, 3.678714e-001, 3.678715e-001, 3.678715e-001, 3.678716e-001, 3.678717e-001, 3.678717e-001, 3.678718e-001, 3.678719e-001, 3.678719e-001, 3.678720e-001, 3.678721e-001, 3.678721e-001, 3.678722e-001, 3.678722e-001, 3.678723e-001, 3.678724e-001, 3.678724e-001, 3.678725e-001, 3.678725e-001, 3.678726e-001, 3.678727e-001, 3.678727e-001, 3.678728e-001, 3.678729e-001, 3.678729e-001, 3.678730e-001, 3.678730e-001, 3.678731e-001, 3.678731e-001, 3.678732e-001, 3.678733e-001, 3.678733e-001, 3.678734e-001, 3.678734e-001, 3.678735e-001, 3.678736e-001, 3.678736e-001, 3.678737e-001, 3.678737e-001, 3.678738e-001, 3.678738e-001, 3.678739e-001, 3.678739e-001, 3.678740e-001, 3.678741e-001, 3.678741e-001, 3.678742e-001, 3.678742e-001, 3.678743e-001, 3.678743e-001, 3.678744e-001, 3.678744e-001, 3.678745e-001, 3.678745e-001, 3.678746e-001, 
3.678746e-001, 3.678747e-001, 3.678747e-001, 3.678748e-001, 3.678748e-001, 3.678749e-001, 3.678749e-001, 3.678750e-001, 3.678750e-001, 3.678751e-001, 3.678751e-001, 3.678752e-001, 3.678752e-001, 3.678753e-001, 3.678753e-001, 3.678754e-001, 3.678754e-001, 3.678755e-001, 3.678755e-001, 3.678756e-001, 3.678756e-001, 3.678756e-001, 3.678757e-001, 3.678757e-001, 3.678758e-001, 3.678758e-001, 3.678759e-001, 3.678759e-001, 3.678760e-001, 3.678760e-001, 3.678760e-001, 3.678761e-001, 3.678761e-001, 3.678762e-001, 3.678762e-001, 3.678763e-001, 3.678763e-001, 3.678763e-001, 3.678764e-001, 3.678764e-001, 3.678765e-001, 3.678765e-001, 3.678765e-001, 3.678766e-001, 3.678766e-001, 3.678767e-001, 3.678767e-001, 3.678767e-001, 3.678768e-001, 3.678768e-001, 3.678769e-001, 3.678769e-001, 3.678769e-001, 3.678770e-001, 3.678770e-001, 3.678770e-001, 3.678771e-001, 3.678771e-001, 3.678771e-001, 3.678772e-001, 3.678772e-001, 3.678772e-001, 3.678773e-001, 3.678773e-001, 3.678774e-001, 3.678774e-001, 3.678774e-001, 3.678775e-001, 3.678775e-001, 3.678775e-001, 3.678775e-001, 3.678776e-001, 3.678776e-001, 3.678776e-001, 3.678777e-001, 3.678777e-001, 3.678777e-001, 3.678778e-001, 3.678778e-001, 3.678778e-001, 3.678779e-001, 3.678779e-001, 3.678779e-001, 3.678779e-001, 3.678780e-001, 3.678780e-001, 3.678780e-001, 3.678781e-001, 3.678781e-001, 3.678781e-001, 3.678781e-001, 3.678782e-001, 3.678782e-001, 3.678782e-001, 3.678782e-001, 3.678783e-001, 3.678783e-001, 3.678783e-001, 3.678783e-001, 3.678784e-001, 
3.678784e-001, 3.678784e-001, 3.678784e-001, 3.678785e-001, 3.678785e-001, 3.678785e-001, 3.678785e-001, 3.678786e-001, 3.678786e-001, 3.678786e-001, 3.678786e-001, 3.678786e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 
3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678794e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678793e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678792e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678791e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678790e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678789e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678788e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678787e-001, 3.678786e-001, 3.678786e-001, 3.678786e-001, 3.678786e-001, 3.678785e-001, 3.678785e-001, 3.678785e-001, 3.678785e-001, 3.678785e-001, 3.678784e-001, 3.678784e-001, 3.678784e-001, 3.678784e-001, 3.678783e-001, 3.678783e-001, 3.678783e-001, 3.678783e-001, 3.678782e-001, 3.678782e-001, 3.678782e-001, 3.678782e-001, 3.678781e-001, 3.678781e-001, 3.678781e-001, 3.678781e-001, 3.678780e-001, 3.678780e-001, 3.678780e-001, 3.678779e-001, 3.678779e-001, 3.678779e-001, 3.678779e-001, 3.678778e-001, 3.678778e-001, 3.678778e-001, 
3.678777e-001, 3.678777e-001, 3.678777e-001, 3.678776e-001, 3.678776e-001, 3.678776e-001, 3.678775e-001, 3.678775e-001, 3.678775e-001, 3.678775e-001, 3.678774e-001, 3.678774e-001, 3.678774e-001, 3.678773e-001, 3.678773e-001, 3.678772e-001, 3.678772e-001, 3.678772e-001, 3.678771e-001, 3.678771e-001, 3.678771e-001, 3.678770e-001, 3.678770e-001, 3.678770e-001, 3.678769e-001, 3.678769e-001, 3.678769e-001, 3.678768e-001, 3.678768e-001, 3.678767e-001, 3.678767e-001, 3.678767e-001, 3.678766e-001, 3.678766e-001, 3.678765e-001, 3.678765e-001, 3.678765e-001, 3.678764e-001, 3.678764e-001, 3.678763e-001, 3.678763e-001, 3.678763e-001, 3.678762e-001, 3.678762e-001, 3.678761e-001, 3.678761e-001, 3.678761e-001, 3.678760e-001, 3.678760e-001, 3.678759e-001, 3.678759e-001, 3.678758e-001, 3.678758e-001, 3.678757e-001, 3.678757e-001, 3.678757e-001, 3.678756e-001, 3.678756e-001, 3.678755e-001, 3.678755e-001, 3.678754e-001, 3.678754e-001, 3.678753e-001, 3.678753e-001, 3.678752e-001, 3.678752e-001, 3.678751e-001, 3.678751e-001, 3.678750e-001, 3.678750e-001, 3.678749e-001, 3.678749e-001, 3.678748e-001, 3.678748e-001, 3.678747e-001, 3.678747e-001, 3.678746e-001, 3.678746e-001, 3.678745e-001, 3.678745e-001, 3.678744e-001, 3.678744e-001, 3.678743e-001, 3.678743e-001, 3.678742e-001, 3.678742e-001, 3.678741e-001, 3.678741e-001, 3.678740e-001, 3.678740e-001, 3.678739e-001, 3.678738e-001, 3.678738e-001, 3.678737e-001, 3.678737e-001, 3.678736e-001, 3.678736e-001, 3.678735e-001, 3.678735e-001, 3.678734e-001, 
3.678733e-001, 3.678733e-001, 3.678732e-001, 3.678732e-001, 3.678731e-001, 3.678731e-001, 3.678730e-001, 3.678729e-001, 3.678729e-001, 3.678728e-001, 3.678728e-001, 3.678727e-001, 3.678726e-001, 3.678726e-001, 3.678725e-001, 3.678724e-001, 3.678724e-001, 3.678723e-001, 3.678723e-001, 3.678722e-001, 3.678721e-001, 3.678721e-001, 3.678720e-001, 3.678719e-001, 3.678719e-001, 3.678718e-001, 3.678718e-001, 3.678717e-001, 3.678716e-001, 3.678716e-001, 3.678715e-001, 3.678714e-001, 3.678714e-001, 3.678713e-001, 3.678712e-001, 3.678712e-001, 3.678711e-001, 3.678710e-001, 3.678710e-001, 3.678709e-001, 3.678708e-001, 3.678708e-001, 3.678707e-001, 3.678706e-001, 3.678706e-001, 3.678705e-001, 3.678704e-001, 3.678703e-001, 3.678703e-001, 3.678702e-001, 3.678701e-001, 3.678701e-001, 3.678700e-001, 3.678699e-001, 3.678698e-001, 3.678698e-001, 3.678697e-001, 3.678696e-001, 3.678696e-001, 3.678695e-001, 3.678694e-001, 3.678693e-001, 3.678693e-001, 3.678692e-001, 3.678691e-001, 3.678690e-001, 3.678690e-001, 3.678689e-001, 3.678688e-001, 3.678687e-001, 3.678687e-001, 3.678686e-001, 3.678685e-001, 3.678684e-001, 3.678683e-001, 3.678683e-001, 3.678682e-001, 3.678681e-001, 3.678680e-001, 3.678680e-001, 3.678679e-001, 3.678678e-001, 3.678677e-001, 3.678676e-001, 3.678676e-001, 3.678675e-001, 3.678674e-001, 3.678673e-001, 3.678672e-001, 3.678672e-001, 3.678671e-001, 3.678670e-001, 3.678669e-001, 3.678668e-001, 3.678667e-001, 3.678667e-001, 3.678666e-001, 3.678665e-001, 3.678664e-001, 3.678663e-001, 
3.678662e-001, 3.678662e-001, 3.678661e-001, 3.678660e-001, 3.678659e-001, 3.678658e-001, 3.678657e-001, 3.678656e-001, 3.678656e-001, 3.678655e-001, 3.678654e-001, 3.678653e-001, 3.678652e-001, 3.678651e-001, 3.678650e-001, 3.678649e-001, 3.678649e-001, 3.678648e-001, 3.678647e-001, 3.678646e-001, 3.678645e-001, 3.678644e-001, 3.678643e-001, 3.678642e-001, 3.678641e-001, 3.678640e-001, 3.678640e-001, 3.678639e-001, 3.678638e-001, 3.678637e-001, 3.678636e-001, 3.678635e-001, 3.678634e-001, 3.678633e-001, 3.678632e-001, 3.678631e-001, 3.678630e-001, 3.678629e-001, 3.678628e-001, 3.678627e-001, 3.678626e-001, 3.678626e-001, 3.678625e-001, 3.678624e-001, 3.678623e-001, 3.678622e-001, 3.678621e-001, 3.678620e-001, 3.678619e-001, 3.678618e-001, 3.678617e-001, 3.678616e-001, 3.678615e-001, 3.678614e-001, 3.678613e-001, 3.678612e-001, 3.678611e-001, 3.678610e-001, 3.678609e-001, 3.678608e-001, 3.678607e-001, 3.678606e-001, 3.678605e-001, 3.678604e-001, 3.678603e-001, 3.678602e-001, 3.678601e-001, 3.678600e-001, 3.678599e-001, 3.678598e-001, 3.678597e-001, 3.678596e-001, 3.678595e-001, 3.678594e-001, 3.678593e-001, 3.678592e-001, 3.678590e-001, 3.678589e-001, 3.678588e-001, 3.678587e-001, 3.678586e-001, 3.678585e-001, 3.678584e-001, 3.678583e-001, 3.678582e-001, 3.678581e-001, 3.678580e-001, 3.678579e-001, 3.678578e-001, 3.678577e-001, 3.678576e-001, 3.678574e-001, 3.678573e-001, 3.678572e-001, 3.678571e-001, 3.678570e-001, 3.678569e-001, 3.678568e-001, 3.678567e-001, 3.678566e-001, 
3.678564e-001, 3.678563e-001, 3.678562e-001, 3.678561e-001, 3.678560e-001, 3.678559e-001, 3.678558e-001, 3.678557e-001, 3.678556e-001, 3.678554e-001, 3.678553e-001, 3.678552e-001, 3.678551e-001, 3.678550e-001, 3.678549e-001, 3.678547e-001, 3.678546e-001, 3.678545e-001, 3.678544e-001, 3.678543e-001, 3.678542e-001, 3.678541e-001, 3.678539e-001, 3.678538e-001, 3.678537e-001, 3.678536e-001, 3.678535e-001, 3.678533e-001, 3.678532e-001, 3.678531e-001, 3.678530e-001, 3.678529e-001, 3.678527e-001, 3.678526e-001, 3.678525e-001, 3.678524e-001, 3.678523e-001, 3.678521e-001, 3.678520e-001, 3.678519e-001, 3.678518e-001, 3.678517e-001, 3.678515e-001, 3.678514e-001, 3.678513e-001, 3.678512e-001, 3.678510e-001, 3.678509e-001, 3.678508e-001, 3.678507e-001, 3.678505e-001, 3.678504e-001, 3.678503e-001, 3.678502e-001, 3.678500e-001, 3.678499e-001, 3.678498e-001, 3.678497e-001, 3.678495e-001, 3.678494e-001, 3.678493e-001, 3.678492e-001, 3.678490e-001, 3.678489e-001, 3.678488e-001, 3.678486e-001, 3.678485e-001, 3.678484e-001, 3.678483e-001, 3.678481e-001, 3.678480e-001, 3.678479e-001, 3.678477e-001, 3.678476e-001, 3.678475e-001, 3.678473e-001, 3.678472e-001, 3.678471e-001, 3.678469e-001, 3.678468e-001, 3.678467e-001, 3.678465e-001, 3.678464e-001, 3.678463e-001, 3.678461e-001, 3.678460e-001, 3.678459e-001, 3.678457e-001, 3.678456e-001, 3.678455e-001, 3.678453e-001, 3.678452e-001, 3.678451e-001, 3.678449e-001, 3.678448e-001, 3.678447e-001, 3.678445e-001, 3.678444e-001, 3.678442e-001, 3.678441e-001, 
3.678440e-001, 3.678438e-001, 3.678437e-001, 3.678436e-001, 3.678434e-001, 3.678433e-001, 3.678431e-001, 3.678430e-001, 3.678429e-001, 3.678427e-001, 3.678426e-001, 3.678424e-001, 3.678423e-001, 3.678421e-001, 3.678420e-001, 3.678419e-001, 3.678417e-001, 3.678416e-001, 3.678414e-001, 3.678413e-001, 3.678412e-001, 3.678410e-001, 3.678409e-001, 3.678407e-001, 3.678406e-001, 3.678404e-001, 3.678403e-001, 3.678401e-001, 3.678400e-001, 3.678398e-001, 3.678397e-001, 3.678396e-001, 3.678394e-001, 3.678393e-001, 3.678391e-001, 3.678390e-001, 3.678388e-001, 3.678387e-001, 3.678385e-001, 3.678384e-001, 3.678382e-001, 3.678381e-001, 3.678379e-001, 3.678378e-001, 3.678376e-001, 3.678375e-001, 3.678373e-001, 3.678372e-001, 3.678370e-001, 3.678369e-001, 3.678367e-001, 3.678366e-001, 3.678364e-001, 3.678363e-001, 3.678361e-001, 3.678360e-001, 3.678358e-001, 3.678357e-001, 3.678355e-001, 3.678353e-001, 3.678352e-001, 3.678350e-001, 3.678349e-001, 3.678347e-001, 3.678346e-001, 3.678344e-001, 3.678343e-001, 3.678341e-001, 3.678339e-001, 3.678338e-001, 3.678336e-001, 3.678335e-001, 3.678333e-001, 3.678332e-001, 3.678330e-001, 3.678328e-001, 3.678327e-001, 3.678325e-001, 3.678324e-001, 3.678322e-001, 3.678321e-001, 3.678319e-001, 3.678317e-001, 3.678316e-001, 3.678314e-001, 3.678313e-001, 3.678311e-001, 3.678309e-001, 3.678308e-001, 3.678306e-001, 3.678304e-001, 3.678303e-001, 3.678301e-001, 3.678300e-001, 3.678298e-001, 3.678296e-001, 3.678295e-001, 3.678293e-001, 3.678291e-001, 3.678290e-001, 
3.678288e-001, 3.678286e-001, 3.678285e-001, 3.678283e-001, 3.678281e-001, 3.678280e-001, 3.678278e-001, 3.678276e-001, 3.678275e-001, 3.678273e-001, 3.678271e-001, 3.678270e-001, 3.678268e-001, 3.678266e-001, 3.678265e-001, 3.678263e-001, 3.678261e-001, 3.678260e-001, 3.678258e-001, 3.678256e-001, 3.678255e-001, 3.678253e-001, 3.678251e-001, 3.678249e-001, 3.678248e-001, 3.678246e-001, 3.678244e-001, 3.678243e-001, 3.678241e-001, 3.678239e-001, 3.678237e-001, 3.678236e-001, 3.678234e-001, 3.678232e-001, 3.678230e-001, 3.678229e-001, 3.678227e-001, 3.678225e-001, 3.678223e-001, 3.678222e-001, 3.678220e-001, 3.678218e-001, 3.678216e-001, 3.678215e-001, 3.678213e-001, 3.678211e-001, 3.678209e-001, 3.678208e-001, 3.678206e-001, 3.678204e-001, 3.678202e-001, 3.678200e-001, 3.678199e-001, 3.678197e-001, 3.678195e-001, 3.678193e-001, 3.678191e-001, 3.678190e-001, 3.678188e-001, 3.678186e-001, 3.678184e-001, 3.678182e-001, 3.678181e-001, 3.678179e-001, 3.678177e-001, 3.678175e-001, 3.678173e-001, 3.678172e-001, 3.678170e-001, 3.678168e-001, 3.678166e-001, 3.678164e-001, 3.678162e-001, 3.678160e-001, 3.678159e-001, 3.678157e-001, 3.678155e-001, 3.678153e-001, 3.678151e-001, 3.678149e-001, 3.678148e-001, 3.678146e-001, 3.678144e-001, 3.678142e-001, 3.678140e-001, 3.678138e-001, 3.678136e-001, 3.678134e-001, 3.678133e-001, 3.678131e-001, 3.678129e-001, 3.678127e-001, 3.678125e-001, 3.678123e-001, 3.678121e-001, 3.678119e-001, 3.678117e-001, 3.678115e-001, 3.678114e-001, 3.678112e-001, 
3.678110e-001, 3.678108e-001, 3.678106e-001, 3.678104e-001, 3.678102e-001, 3.678100e-001, 3.678098e-001, 3.678096e-001, 3.678094e-001, 3.678092e-001, 3.678090e-001, 3.678088e-001, 3.678087e-001, 3.678085e-001, 3.678083e-001, 3.678081e-001, 3.678079e-001, 3.678077e-001, 3.678075e-001, 3.678073e-001, 3.678071e-001, 3.678069e-001, 3.678067e-001, 3.678065e-001, 3.678063e-001, 3.678061e-001, 3.678059e-001, 3.678057e-001, 3.678055e-001, 3.678053e-001, 3.678051e-001, 3.678049e-001, 3.678047e-001, 3.678045e-001, 3.678043e-001, 3.678041e-001, 3.678039e-001, 3.678037e-001, 3.678035e-001, 3.678033e-001, 3.678031e-001, 3.678029e-001, 3.678027e-001, 3.678025e-001, 3.678023e-001, 3.678021e-001, 3.678019e-001, 3.678017e-001, 3.678015e-001, 3.678013e-001, 3.678011e-001, 3.678008e-001, 3.678006e-001, 3.678004e-001, 3.678002e-001, 3.678000e-001, 3.677998e-001, 3.677996e-001, 3.677994e-001, 3.677992e-001, 3.677990e-001, 3.677988e-001, 3.677986e-001, 3.677984e-001, 3.677982e-001, 3.677979e-001, 3.677977e-001, 3.677975e-001, 3.677973e-001, 3.677971e-001, 3.677969e-001, 3.677967e-001, 3.677965e-001, 3.677963e-001, 3.677961e-001, 3.677958e-001, 3.677956e-001, 3.677954e-001, 3.677952e-001, 3.677950e-001, 3.677948e-001, 3.677946e-001, 3.677944e-001, 3.677941e-001, 3.677939e-001, 3.677937e-001, 3.677935e-001, 3.677933e-001, 3.677931e-001, 3.677929e-001, 3.677926e-001, 3.677924e-001, 3.677922e-001, 3.677920e-001, 3.677918e-001, 3.677916e-001, 3.677913e-001, 3.677911e-001, 3.677909e-001, 3.677907e-001, 
3.677905e-001, 3.677902e-001, 3.677900e-001, 3.677898e-001, 3.677896e-001, 3.677894e-001, 3.677892e-001, 3.677889e-001, 3.677887e-001, 3.677885e-001, 3.677883e-001, 3.677880e-001, 3.677878e-001, 3.677876e-001, 3.677874e-001, 3.677872e-001, 3.677869e-001, 3.677867e-001, 3.677865e-001, 3.677863e-001, 3.677860e-001, 3.677858e-001, 3.677856e-001, 3.677854e-001, 3.677852e-001, 3.677849e-001, 3.677847e-001, 3.677845e-001, 3.677842e-001, 3.677840e-001, 3.677838e-001, 3.677836e-001, 3.677833e-001, 3.677831e-001, 3.677829e-001, 3.677827e-001, 3.677824e-001, 3.677822e-001, 3.677820e-001, 3.677817e-001, 3.677815e-001, 3.677813e-001, 3.677811e-001, 3.677808e-001, 3.677806e-001, 3.677804e-001, 3.677801e-001, 3.677799e-001, 3.677797e-001, 3.677794e-001, 3.677792e-001, 3.677790e-001, 3.677788e-001, 3.677785e-001, 3.677783e-001, 3.677781e-001, 3.677778e-001, 3.677776e-001, 3.677774e-001, 3.677771e-001, 3.677769e-001, 3.677767e-001, 3.677764e-001, 3.677762e-001, 3.677759e-001, 3.677757e-001, 3.677755e-001, 3.677752e-001, 3.677750e-001, 3.677748e-001, 3.677745e-001, 3.677743e-001, 3.677741e-001, 3.677738e-001, 3.677736e-001, 3.677733e-001, 3.677731e-001, 3.677729e-001, 3.677726e-001, 3.677724e-001, 3.677721e-001, 3.677719e-001, 3.677717e-001, 3.677714e-001, 3.677712e-001, 3.677709e-001, 3.677707e-001, 3.677705e-001, 3.677702e-001, 3.677700e-001, 3.677697e-001, 3.677695e-001, 3.677693e-001, 3.677690e-001, 3.677688e-001, 3.677685e-001, 3.677683e-001, 3.677680e-001, 3.677678e-001, 3.677675e-001, 
3.677673e-001, 3.677671e-001, 3.677668e-001, 3.677666e-001, 3.677663e-001, 3.677661e-001, 3.677658e-001, 3.677656e-001, 3.677653e-001, 3.677651e-001, 3.677648e-001, 3.677646e-001, 3.677643e-001, 3.677641e-001, 3.677638e-001, 3.677636e-001, 3.677634e-001, 3.677631e-001, 3.677629e-001, 3.677626e-001, 3.677624e-001, 3.677621e-001, 3.677619e-001, 3.677616e-001, 3.677614e-001, 3.677611e-001, 3.677608e-001, 3.677606e-001, 3.677603e-001, 3.677601e-001, 3.677598e-001, 3.677596e-001, 3.677593e-001, 3.677591e-001, 3.677588e-001, 3.677586e-001, 3.677583e-001, 3.677581e-001, 3.677578e-001, 3.677576e-001, 3.677573e-001, 3.677570e-001, 3.677568e-001, 3.677565e-001, 3.677563e-001, 3.677560e-001, 3.677558e-001, 3.677555e-001, 3.677552e-001, 3.677550e-001, 3.677547e-001, 3.677545e-001, 3.677542e-001, 3.677540e-001, 3.677537e-001, 3.677534e-001, 3.677532e-001, 3.677529e-001, 3.677527e-001, 3.677524e-001, 3.677521e-001, 3.677519e-001, 3.677516e-001, 3.677513e-001, 3.677511e-001, 3.677508e-001, 3.677506e-001, 3.677503e-001, 3.677500e-001, 3.677498e-001, 3.677495e-001, 3.677492e-001, 3.677490e-001, 3.677487e-001, 3.677485e-001, 3.677482e-001, 3.677479e-001, 3.677477e-001, 3.677474e-001, 3.677471e-001, 3.677469e-001, 3.677466e-001, 3.677463e-001, 3.677461e-001, 3.677458e-001, 3.677455e-001, 3.677453e-001, 3.677450e-001, 3.677447e-001, 3.677445e-001, 3.677442e-001, 3.677439e-001, 3.677437e-001, 3.677434e-001, 3.677431e-001, 3.677428e-001, 3.677426e-001, 3.677423e-001, 3.677420e-001, 3.677418e-001, 
3.677415e-001, 3.677412e-001, 3.677409e-001, 3.677407e-001, 3.677404e-001, 3.677401e-001, 3.677399e-001, 3.677396e-001, 3.677393e-001, 3.677390e-001, 3.677388e-001, 3.677385e-001, 3.677382e-001, 3.677379e-001, 3.677377e-001, 3.677374e-001, 3.677371e-001, 3.677368e-001, 3.677366e-001, 3.677363e-001, 3.677360e-001, 3.677357e-001, 3.677355e-001, 3.677352e-001, 3.677349e-001, 3.677346e-001, 3.677343e-001, 3.677341e-001, 3.677338e-001, 3.677335e-001, 3.677332e-001, 3.677329e-001, 3.677327e-001, 3.677324e-001, 3.677321e-001, 3.677318e-001, 3.677315e-001, 3.677313e-001, 3.677310e-001, 3.677307e-001, 3.677304e-001, 3.677301e-001, 3.677299e-001, 3.677296e-001, 3.677293e-001, 3.677290e-001, 3.677287e-001, 3.677284e-001, 3.677282e-001, 3.677279e-001, 3.677276e-001, 3.677273e-001, 3.677270e-001, 3.677267e-001, 3.677264e-001, 3.677262e-001, 3.677259e-001, 3.677256e-001, 3.677253e-001, 3.677250e-001, 3.677247e-001, 3.677244e-001, 3.677242e-001, 3.677239e-001, 3.677236e-001, 3.677233e-001, 3.677230e-001, 3.677227e-001, 3.677224e-001, 3.677221e-001, 3.677218e-001, 3.677216e-001, 3.677213e-001, 3.677210e-001, 3.677207e-001, 3.677204e-001, 3.677201e-001, 3.677198e-001, 3.677195e-001, 3.677192e-001, 3.677189e-001, 3.677186e-001, 3.677183e-001, 3.677181e-001, 3.677178e-001, 3.677175e-001, 3.677172e-001, 3.677169e-001, 3.677166e-001, 3.677163e-001, 3.677160e-001, 3.677157e-001, 3.677154e-001, 3.677151e-001, 3.677148e-001, 3.677145e-001, 3.677142e-001, 3.677139e-001, 3.677136e-001, 3.677133e-001, 
3.677130e-001, 3.677127e-001, 3.677124e-001, 3.677121e-001, 3.677118e-001, 3.677115e-001, 3.677112e-001, 3.677109e-001, 3.677106e-001, 3.677103e-001, 3.677100e-001, 3.677097e-001, 3.677094e-001, 3.677091e-001, 3.677088e-001, 3.677085e-001, 3.677082e-001, 3.677079e-001, 3.677076e-001, 3.677073e-001, 3.677070e-001, 3.677067e-001, 3.677064e-001, 3.677061e-001, 3.677058e-001, 3.677055e-001, 3.677052e-001, 3.677049e-001, 3.677046e-001, 3.677043e-001, 3.677040e-001, 3.677037e-001, 3.677034e-001, 3.677031e-001, 3.677028e-001, 3.677024e-001, 3.677021e-001, 3.677018e-001, 3.677015e-001, 3.677012e-001, 3.677009e-001, 3.677006e-001, 3.677003e-001, 3.677000e-001, 3.676997e-001, 3.676994e-001, 3.676991e-001, 3.676987e-001, 3.676984e-001, 3.676981e-001, 3.676978e-001, 3.676975e-001, 3.676972e-001, 3.676969e-001, 3.676966e-001, 3.676963e-001, 3.676959e-001, 3.676956e-001, 3.676953e-001, 3.676950e-001, 3.676947e-001, 3.676944e-001, 3.676941e-001, 3.676937e-001, 3.676934e-001, 3.676931e-001, 3.676928e-001, 3.676925e-001, 3.676922e-001, 3.676919e-001, 3.676915e-001, 3.676912e-001, 3.676909e-001, 3.676906e-001, 3.676903e-001, 3.676900e-001, 3.676896e-001, 3.676893e-001, 3.676890e-001, 3.676887e-001, 3.676884e-001, 3.676880e-001, 3.676877e-001, 3.676874e-001, 3.676871e-001, 3.676868e-001, 3.676864e-001, 3.676861e-001, 3.676858e-001, 3.676855e-001, 3.676852e-001, 3.676848e-001, 3.676845e-001, 3.676842e-001, 3.676839e-001, 3.676835e-001, 3.676832e-001, 3.676829e-001, 3.676826e-001, 3.676823e-001, 
3.676819e-001, 3.676816e-001, 3.676813e-001, 3.676810e-001, 3.676806e-001, 3.676803e-001, 3.676800e-001, 3.676797e-001, 3.676793e-001, 3.676790e-001, 3.676787e-001, 3.676783e-001, 3.676780e-001, 3.676777e-001, 3.676774e-001, 3.676770e-001, 3.676767e-001, 3.676764e-001, 3.676761e-001, 3.676757e-001, 3.676754e-001, 3.676751e-001, 3.676747e-001, 3.676744e-001, 3.676741e-001, 3.676737e-001, 3.676734e-001, 3.676731e-001, 3.676728e-001, 3.676724e-001, 3.676721e-001, 3.676718e-001, 3.676714e-001, 3.676711e-001, 3.676708e-001, 3.676704e-001, 3.676701e-001, 3.676698e-001, 3.676694e-001, 3.676691e-001, 3.676688e-001, 3.676684e-001, 3.676681e-001, 3.676677e-001, 3.676674e-001, 3.676671e-001, 3.676667e-001, 3.676664e-001, 3.676661e-001, 3.676657e-001, 3.676654e-001, 3.676651e-001, 3.676647e-001, 3.676644e-001, 3.676640e-001, 3.676637e-001, 3.676634e-001, 3.676630e-001, 3.676627e-001, 3.676623e-001, 3.676620e-001, 3.676617e-001, 3.676613e-001, 3.676610e-001, 3.676606e-001, 3.676603e-001, 3.676600e-001, 3.676596e-001, 3.676593e-001, 3.676589e-001, 3.676586e-001, 3.676583e-001, 3.676579e-001, 3.676576e-001, 3.676572e-001, 3.676569e-001, 3.676565e-001, 3.676562e-001, 3.676558e-001, 3.676555e-001, 3.676552e-001, 3.676548e-001, 3.676545e-001, 3.676541e-001, 3.676538e-001, 3.676534e-001, 3.676531e-001, 3.676527e-001, 3.676524e-001, 3.676520e-001, 3.676517e-001, 3.676513e-001, 3.676510e-001, 3.676506e-001, 3.676503e-001, 3.676499e-001, 3.676496e-001, 3.676492e-001, 3.676489e-001, 3.676485e-001, 
3.676482e-001, 3.676478e-001, 3.676475e-001, 3.676471e-001, 3.676468e-001, 3.676464e-001, 3.676461e-001, 3.676457e-001, 3.676454e-001, 3.676450e-001, 3.676447e-001, 3.676443e-001, 3.676440e-001, 3.676436e-001, 3.676433e-001, 3.676429e-001, 3.676426e-001, 3.676422e-001, 3.676418e-001, 3.676415e-001, 3.676411e-001, 3.676408e-001, 3.676404e-001, 3.676401e-001, 3.676397e-001, 3.676394e-001, 3.676390e-001, 3.676386e-001, 3.676383e-001, 3.676379e-001, 3.676376e-001, 3.676372e-001, 3.676369e-001, 3.676365e-001, 3.676361e-001, 3.676358e-001, 3.676354e-001, 3.676351e-001, 3.676347e-001, 3.676343e-001, 3.676340e-001, 3.676336e-001, 3.676332e-001, 3.676329e-001, 3.676325e-001, 3.676322e-001, 3.676318e-001, 3.676314e-001, 3.676311e-001, 3.676307e-001, 3.676303e-001, 3.676300e-001, 3.676296e-001, 3.676293e-001, 3.676289e-001, 3.676285e-001, 3.676282e-001, 3.676278e-001, 3.676274e-001, 3.676271e-001, 3.676267e-001, 3.676263e-001, 3.676260e-001, 3.676256e-001, 3.676252e-001, 3.676249e-001, 3.676245e-001, 3.676241e-001, 3.676238e-001, 3.676234e-001, 3.676230e-001, 3.676227e-001, 3.676223e-001, 3.676219e-001, 3.676215e-001, 3.676212e-001, 3.676208e-001, 3.676204e-001, 3.676201e-001, 3.676197e-001, 3.676193e-001, 3.676190e-001, 3.676186e-001, 3.676182e-001, 3.676178e-001, 3.676175e-001, 3.676171e-001, 3.676167e-001, 3.676163e-001, 3.676160e-001, 3.676156e-001, 3.676152e-001, 3.676148e-001, 3.676145e-001, 3.676141e-001, 3.676137e-001, 3.676133e-001, 3.676130e-001, 3.676126e-001, 3.676122e-001, 
3.676118e-001, 3.676115e-001, 3.676111e-001, 3.676107e-001, 3.676103e-001, 3.676100e-001, 3.676096e-001, 3.676092e-001, 3.676088e-001, 3.676084e-001, 3.676081e-001, 3.676077e-001, 3.676073e-001, 3.676069e-001, 3.676065e-001, 3.676062e-001, 3.676058e-001, 3.676054e-001, 3.676050e-001, 3.676046e-001, 3.676043e-001, 3.676039e-001, 3.676035e-001, 3.676031e-001, 3.676027e-001, 3.676023e-001, 3.676020e-001, 3.676016e-001, 3.676012e-001, 3.676008e-001, 3.676004e-001, 3.676000e-001, 3.675997e-001, 3.675993e-001, 3.675989e-001, 3.675985e-001, 3.675981e-001, 3.675977e-001, 3.675973e-001, 3.675970e-001, 3.675966e-001, 3.675962e-001, 3.675958e-001, 3.675954e-001, 3.675950e-001, 3.675946e-001, 3.675942e-001, 3.675939e-001, 3.675935e-001, 3.675931e-001, 3.675927e-001, 3.675923e-001, 3.675919e-001, 3.675915e-001, 3.675911e-001, 3.675907e-001, 3.675903e-001, 3.675899e-001, 3.675896e-001, 3.675892e-001, 3.675888e-001, 3.675884e-001, 3.675880e-001, 3.675876e-001, 3.675872e-001, 3.675868e-001, 3.675864e-001, 3.675860e-001, 3.675856e-001, 3.675852e-001, 3.675848e-001, 3.675844e-001, 3.675840e-001, 3.675837e-001, 3.675833e-001, 3.675829e-001, 3.675825e-001, 3.675821e-001, 3.675817e-001, 3.675813e-001, 3.675809e-001, 3.675805e-001, 3.675801e-001, 3.675797e-001, 3.675793e-001, 3.675789e-001, 3.675785e-001, 3.675781e-001, 3.675777e-001, 3.675773e-001, 3.675769e-001, 3.675765e-001, 3.675761e-001, 3.675757e-001, 3.675753e-001, 3.675749e-001, 3.675745e-001, 3.675741e-001, 3.675737e-001, 3.675733e-001, 
3.675729e-001, 3.675725e-001, 3.675721e-001, 3.675717e-001, 3.675713e-001, 3.675709e-001, 3.675704e-001, 3.675700e-001, 3.675696e-001, 3.675692e-001, 3.675688e-001, 3.675684e-001, 3.675680e-001, 3.675676e-001, 3.675672e-001, 3.675668e-001, 3.675664e-001, 3.675660e-001, 3.675656e-001, 3.675652e-001, 3.675648e-001, 3.675644e-001, 3.675639e-001, 3.675635e-001, 3.675631e-001, 3.675627e-001, 3.675623e-001, 3.675619e-001, 3.675615e-001, 3.675611e-001, 3.675607e-001, 3.675603e-001, 3.675598e-001, 3.675594e-001, 3.675590e-001, 3.675586e-001, 3.675582e-001, 3.675578e-001, 3.675574e-001, 3.675570e-001, 3.675566e-001, 3.675561e-001, 3.675557e-001, 3.675553e-001, 3.675549e-001, 3.675545e-001, 3.675541e-001, 3.675537e-001, 3.675532e-001, 3.675528e-001, 3.675524e-001, 3.675520e-001, 3.675516e-001, 3.675512e-001, 3.675507e-001, 3.675503e-001, 3.675499e-001, 3.675495e-001, 3.675491e-001, 3.675487e-001, 3.675482e-001, 3.675478e-001, 3.675474e-001, 3.675470e-001, 3.675466e-001, 3.675461e-001, 3.675457e-001, 3.675453e-001, 3.675449e-001, 3.675445e-001, 3.675440e-001, 3.675436e-001, 3.675432e-001, 3.675428e-001, 3.675423e-001, 3.675419e-001, 3.675415e-001, 3.675411e-001, 3.675407e-001, 3.675402e-001, 3.675398e-001, 3.675394e-001, 3.675390e-001, 3.675385e-001, 3.675381e-001, 3.675377e-001, 3.675373e-001, 3.675368e-001, 3.675364e-001, 3.675360e-001, 3.675356e-001, 3.675351e-001, 3.675347e-001, 3.675343e-001, 3.675339e-001, 3.675334e-001, 3.675330e-001, 3.675326e-001, 3.675321e-001, 3.675317e-001, 
3.675313e-001, 3.675309e-001, 3.675304e-001, 3.675300e-001, 3.675296e-001, 3.675291e-001, 3.675287e-001, 3.675283e-001, 3.675278e-001, 3.675274e-001, 3.675270e-001, 3.675266e-001, 3.675261e-001, 3.675257e-001, 3.675253e-001, 3.675248e-001, 3.675244e-001, 3.675240e-001, 3.675235e-001, 3.675231e-001, 3.675227e-001, 3.675222e-001, 3.675218e-001, 3.675214e-001, 3.675209e-001, 3.675205e-001, 3.675200e-001, 3.675196e-001, 3.675192e-001, 3.675187e-001, 3.675183e-001, 3.675179e-001, 3.675174e-001, 3.675170e-001, 3.675166e-001, 3.675161e-001, 3.675157e-001, 3.675152e-001, 3.675148e-001, 3.675144e-001, 3.675139e-001, 3.675135e-001, 3.675130e-001, 3.675126e-001, 3.675122e-001, 3.675117e-001, 3.675113e-001, 3.675108e-001, 3.675104e-001, 3.675100e-001, 3.675095e-001, 3.675091e-001, 3.675086e-001, 3.675082e-001, 3.675077e-001, 3.675073e-001, 3.675069e-001, 3.675064e-001, 3.675060e-001, 3.675055e-001, 3.675051e-001, 3.675046e-001, 3.675042e-001, 3.675038e-001, 3.675033e-001, 3.675029e-001, 3.675024e-001, 3.675020e-001, 3.675015e-001, 3.675011e-001, 3.675006e-001, 3.675002e-001, 3.674997e-001, 3.674993e-001, 3.674988e-001, 3.674984e-001, 3.674979e-001, 3.674975e-001, 3.674970e-001, 3.674966e-001, 3.674961e-001, 3.674957e-001, 3.674952e-001, 3.674948e-001, 3.674943e-001, 3.674939e-001, 3.674934e-001, 3.674930e-001, 3.674925e-001, 3.674921e-001, 3.674916e-001, 3.674912e-001, 3.674907e-001, 3.674903e-001, 3.674898e-001, 3.674894e-001, 3.674889e-001, 3.674885e-001, 3.674880e-001, 3.674876e-001, 
3.674871e-001, 3.674866e-001, 3.674862e-001, 3.674857e-001, 3.674853e-001, 3.674848e-001, 3.674844e-001, 3.674839e-001, 3.674835e-001, 3.674830e-001, 3.674825e-001, 3.674821e-001, 3.674816e-001, 3.674812e-001, 3.674807e-001, 3.674802e-001, 3.674798e-001, 3.674793e-001, 3.674789e-001, 3.674784e-001, 3.674779e-001, 3.674775e-001, 3.674770e-001, 3.674766e-001, 3.674761e-001, 3.674756e-001, 3.674752e-001, 3.674747e-001, 3.674743e-001, 3.674738e-001, 3.674733e-001, 3.674729e-001, 3.674724e-001, 3.674719e-001, 3.674715e-001, 3.674710e-001, 3.674706e-001, 3.674701e-001, 3.674696e-001, 3.674692e-001, 3.674687e-001, 3.674682e-001, 3.674678e-001, 3.674673e-001, 3.674668e-001, 3.674664e-001, 3.674659e-001, 3.674654e-001, 3.674650e-001, 3.674645e-001, 3.674640e-001, 3.674636e-001, 3.674631e-001, 3.674626e-001, 3.674622e-001, 3.674617e-001, 3.674612e-001, 3.674607e-001, 3.674603e-001, 3.674598e-001, 3.674593e-001, 3.674589e-001, 3.674584e-001, 3.674579e-001, 3.674575e-001, 3.674570e-001, 3.674565e-001, 3.674560e-001, 3.674556e-001, 3.674551e-001, 3.674546e-001, 3.674541e-001, 3.674537e-001, 3.674532e-001, 3.674527e-001, 3.674523e-001, 3.674518e-001, 3.674513e-001, 3.674508e-001, 3.674504e-001, 3.674499e-001, 3.674494e-001, 3.674489e-001, 3.674484e-001, 3.674480e-001, 3.674475e-001, 3.674470e-001, 3.674465e-001, 3.674461e-001, 3.674456e-001, 3.674451e-001, 3.674446e-001, 3.674442e-001, 3.674437e-001, 3.674432e-001, 3.674427e-001, 3.674422e-001, 3.674418e-001, 3.674413e-001, 3.674408e-001, 
3.674403e-001, 3.674398e-001, 3.674394e-001, 3.674389e-001, 3.674384e-001, 3.674379e-001, 3.674374e-001, 3.674369e-001, 3.674365e-001, 3.674360e-001, 3.674355e-001, 3.674350e-001, 3.674345e-001, 3.674340e-001, 3.674336e-001, 3.674331e-001, 3.674326e-001, 3.674321e-001, 3.674316e-001, 3.674311e-001, 3.674306e-001, 3.674302e-001, 3.674297e-001, 3.674292e-001, 3.674287e-001, 3.674282e-001, 3.674277e-001, 3.674272e-001, 3.674267e-001, 3.674263e-001, 3.674258e-001, 3.674253e-001, 3.674248e-001, 3.674243e-001, 3.674238e-001, 3.674233e-001, 3.674228e-001, 3.674223e-001, 3.674219e-001, 3.674214e-001, 3.674209e-001, 3.674204e-001, 3.674199e-001, 3.674194e-001, 3.674189e-001, 3.674184e-001, 3.674179e-001, 3.674174e-001, 3.674169e-001, 3.674164e-001, 3.674159e-001, 3.674155e-001, 3.674150e-001, 3.674145e-001, 3.674140e-001, 3.674135e-001, 3.674130e-001, 3.674125e-001, 3.674120e-001, 3.674115e-001, 3.674110e-001, 3.674105e-001, 3.674100e-001, 3.674095e-001, 3.674090e-001, 3.674085e-001, 3.674080e-001, 3.674075e-001, 3.674070e-001, 3.674065e-001, 3.674060e-001, 3.674055e-001, 3.674050e-001, 3.674045e-001, 3.674040e-001, 3.674035e-001, 3.674030e-001, 3.674025e-001, 3.674020e-001, 3.674015e-001, 3.674010e-001, 3.674005e-001, 3.674000e-001, 3.673995e-001, 3.673990e-001, 3.673985e-001, 3.673980e-001, 3.673975e-001, 3.673970e-001, 3.673965e-001, 3.673960e-001, 3.673955e-001, 3.673950e-001, 3.673945e-001, 3.673940e-001, 3.673935e-001, 3.673930e-001, 3.673925e-001, 3.673919e-001, 3.673914e-001, 
3.673909e-001, 3.673904e-001, 3.673899e-001, 3.673894e-001, 3.673889e-001, 3.673884e-001, 3.673879e-001, 3.673874e-001, 3.673869e-001, 3.673864e-001, 3.673859e-001, 3.673853e-001, 3.673848e-001, 3.673843e-001, 3.673838e-001, 3.673833e-001, 3.673828e-001, 3.673823e-001, 3.673818e-001, 3.673813e-001, 3.673808e-001, 3.673802e-001, 3.673797e-001, 3.673792e-001, 3.673787e-001, 3.673782e-001, 3.673777e-001, 3.673772e-001, 3.673766e-001, 3.673761e-001, 3.673756e-001, 3.673751e-001, 3.673746e-001, 3.673741e-001, 3.673736e-001, 3.673730e-001, 3.673725e-001, 3.673720e-001, 3.673715e-001, 3.673710e-001, 3.673705e-001, 3.673699e-001, 3.673694e-001, 3.673689e-001, 3.673684e-001, 3.673679e-001, 3.673674e-001, 3.673668e-001, 3.673663e-001, 3.673658e-001, 3.673653e-001, 3.673648e-001, 3.673642e-001, 3.673637e-001, 3.673632e-001, 3.673627e-001, 3.673622e-001, 3.673616e-001, 3.673611e-001, 3.673606e-001, 3.673601e-001, 3.673595e-001, 3.673590e-001, 3.673585e-001, 3.673580e-001, 3.673575e-001, 3.673569e-001, 3.673564e-001, 3.673559e-001, 3.673554e-001, 3.673548e-001, 3.673543e-001, 3.673538e-001, 3.673533e-001, 3.673527e-001, 3.673522e-001, 3.673517e-001, 3.673512e-001, 3.673506e-001, 3.673501e-001, 3.673496e-001, 3.673490e-001, 3.673485e-001, 3.673480e-001, 3.673475e-001, 3.673469e-001, 3.673464e-001, 3.673459e-001, 3.673453e-001, 3.673448e-001, 3.673443e-001, 3.673438e-001, 3.673432e-001, 3.673427e-001, 3.673422e-001, 3.673416e-001, 3.673411e-001, 3.673406e-001, 3.673400e-001, 3.673395e-001, 
3.673390e-001, 3.673384e-001, 3.673379e-001, 3.673374e-001, 3.673368e-001, 3.673363e-001, 3.673358e-001, 3.673352e-001, 3.673347e-001, 3.673342e-001, 3.673336e-001, 3.673331e-001, 3.673326e-001, 3.673320e-001, 3.673315e-001, 3.673310e-001, 3.673304e-001, 3.673299e-001, 3.673293e-001, 3.673288e-001, 3.673283e-001, 3.673277e-001, 3.673272e-001, 3.673267e-001, 3.673261e-001, 3.673256e-001, 3.673250e-001, 3.673245e-001, 3.673240e-001, 3.673234e-001, 3.673229e-001, 3.673223e-001, 3.673218e-001, 3.673213e-001, 3.673207e-001, 3.673202e-001, 3.673196e-001, 3.673191e-001, 3.673186e-001, 3.673180e-001, 3.673175e-001, 3.673169e-001, 3.673164e-001, 3.673158e-001, 3.673153e-001, 3.673148e-001, 3.673142e-001, 3.673137e-001, 3.673131e-001, 3.673126e-001, 3.673120e-001, 3.673115e-001, 3.673109e-001, 3.673104e-001, 3.673098e-001, 3.673093e-001, 3.673088e-001, 3.673082e-001, 3.673077e-001, 3.673071e-001, 3.673066e-001, 3.673060e-001, 3.673055e-001, 3.673049e-001, 3.673044e-001, 3.673038e-001, 3.673033e-001, 3.673027e-001, 3.673022e-001, 3.673016e-001, 3.673011e-001, 3.673005e-001, 3.673000e-001, 3.672994e-001, 3.672989e-001, 3.672983e-001, 3.672978e-001, 3.672972e-001, 3.672967e-001, 3.672961e-001, 3.672956e-001, 3.672950e-001, 3.672944e-001, 3.672939e-001, 3.672933e-001, 3.672928e-001, 3.672922e-001, 3.672917e-001, 3.672911e-001, 3.672906e-001, 3.672900e-001, 3.672895e-001, 3.672889e-001, 3.672883e-001, 3.672878e-001, 3.672872e-001, 3.672867e-001, 3.672861e-001, 3.672856e-001, 3.672850e-001, 
3.672844e-001, 3.672839e-001, 3.672833e-001, 3.672828e-001, 3.672822e-001, 3.672816e-001, 3.672811e-001, 3.672805e-001, 3.672800e-001, 3.672794e-001, 3.672788e-001, 3.672783e-001, 3.672777e-001, 3.672772e-001, 3.672766e-001, 3.672760e-001, 3.672755e-001, 3.672749e-001, 3.672743e-001, 3.672738e-001, 3.672732e-001, 3.672727e-001, 3.672721e-001, 3.672715e-001, 3.672710e-001, 3.672704e-001, 3.672698e-001, 3.672693e-001, 3.672687e-001, 3.672681e-001, 3.672676e-001, 3.672670e-001, 3.672664e-001, 3.672659e-001, 3.672653e-001, 3.672647e-001, 3.672642e-001, 3.672636e-001, 3.672630e-001, 3.672625e-001, 3.672619e-001, 3.672613e-001, 3.672608e-001, 3.672602e-001, 3.672596e-001, 3.672591e-001, 3.672585e-001, 3.672579e-001, 3.672573e-001, 3.672568e-001, 3.672562e-001, 3.672556e-001, 3.672551e-001, 3.672545e-001, 3.672539e-001, 3.672533e-001, 3.672528e-001, 3.672522e-001, 3.672516e-001, 3.672511e-001, 3.672505e-001, 3.672499e-001, 3.672493e-001, 3.672488e-001, 3.672482e-001, 3.672476e-001, 3.672470e-001, 3.672465e-001, 3.672459e-001, 3.672453e-001, 3.672447e-001, 3.672442e-001, 3.672436e-001, 3.672430e-001, 3.672424e-001, 3.672418e-001, 3.672413e-001, 3.672407e-001, 3.672401e-001, 3.672395e-001, 3.672390e-001, 3.672384e-001, 3.672378e-001, 3.672372e-001, 3.672366e-001, 3.672361e-001, 3.672355e-001, 3.672349e-001, 3.672343e-001, 3.672337e-001, 3.672332e-001, 3.672326e-001, 3.672320e-001, 3.672314e-001, 3.672308e-001, 3.672302e-001, 3.672297e-001, 3.672291e-001, 3.672285e-001, 3.672279e-001, 
3.672273e-001, 3.672267e-001, 3.672262e-001, 3.672256e-001, 3.672250e-001, 3.672244e-001, 3.672238e-001, 3.672232e-001, 3.672227e-001, 3.672221e-001, 3.672215e-001, 3.672209e-001, 3.672203e-001, 3.672197e-001, 3.672191e-001, 3.672185e-001, 3.672180e-001, 3.672174e-001, 3.672168e-001, 3.672162e-001, 3.672156e-001, 3.672150e-001, 3.672144e-001, 3.672138e-001, 3.672132e-001, 3.672127e-001, 3.672121e-001, 3.672115e-001, 3.672109e-001, 3.672103e-001, 3.672097e-001, 3.672091e-001, 3.672085e-001, 3.672079e-001, 3.672073e-001, 3.672067e-001, 3.672061e-001, 3.672056e-001, 3.672050e-001, 3.672044e-001, 3.672038e-001, 3.672032e-001, 3.672026e-001, 3.672020e-001, 3.672014e-001, 3.672008e-001, 3.672002e-001, 3.671996e-001, 3.671990e-001, 3.671984e-001, 3.671978e-001, 3.671972e-001, 3.671966e-001, 3.671960e-001, 3.671954e-001, 3.671948e-001, 3.671942e-001, 3.671936e-001, 3.671930e-001, 3.671924e-001, 3.671918e-001, 3.671912e-001, 3.671906e-001, 3.671900e-001, 3.671894e-001, 3.671888e-001, 3.671882e-001, 3.671876e-001, 3.671870e-001, 3.671864e-001, 3.671858e-001, 3.671852e-001, 3.671846e-001, 3.671840e-001, 3.671834e-001, 3.671828e-001, 3.671822e-001, 3.671816e-001, 3.671810e-001, 3.671804e-001, 3.671798e-001, 3.671792e-001, 3.671786e-001, 3.671780e-001, 3.671774e-001, 3.671768e-001, 3.671762e-001, 3.671756e-001, 3.671750e-001, 3.671743e-001, 3.671737e-001, 3.671731e-001, 3.671725e-001, 3.671719e-001, 3.671713e-001, 3.671707e-001, 3.671701e-001, 3.671695e-001, 3.671689e-001, 3.671683e-001, 
3.671677e-001, 3.671670e-001, 3.671664e-001, 3.671658e-001, 3.671652e-001, 3.671646e-001, 3.671640e-001, 3.671634e-001, 3.671628e-001, 3.671622e-001, 3.671616e-001, 3.671609e-001, 3.671603e-001, 3.671597e-001, 3.671591e-001, 3.671585e-001, 3.671579e-001, 3.671573e-001, 3.671566e-001, 3.671560e-001, 3.671554e-001, 3.671548e-001, 3.671542e-001, 3.671536e-001, 3.671530e-001, 3.671523e-001, 3.671517e-001, 3.671511e-001, 3.671505e-001, 3.671499e-001, 3.671493e-001, 3.671486e-001, 3.671480e-001, 3.671474e-001, 3.671468e-001, 3.671462e-001, 3.671455e-001, 3.671449e-001, 3.671443e-001, 3.671437e-001, 3.671431e-001, 3.671425e-001, 3.671418e-001, 3.671412e-001, 3.671406e-001, 3.671400e-001, 3.671393e-001, 3.671387e-001, 3.671381e-001, 3.671375e-001, 3.671369e-001, 3.671362e-001, 3.671356e-001, 3.671350e-001, 3.671344e-001, 3.671337e-001, 3.671331e-001, 3.671325e-001, 3.671319e-001, 3.671313e-001, 3.671306e-001, 3.671300e-001, 3.671294e-001, 3.671288e-001, 3.671281e-001, 3.671275e-001, 3.671269e-001, 3.671262e-001, 3.671256e-001, 3.671250e-001, 3.671244e-001, 3.671237e-001, 3.671231e-001, 3.671225e-001, 3.671219e-001, 3.671212e-001, 3.671206e-001, 3.671200e-001, 3.671193e-001, 3.671187e-001, 3.671181e-001, 3.671174e-001, 3.671168e-001, 3.671162e-001, 3.671156e-001, 3.671149e-001, 3.671143e-001, 3.671137e-001, 3.671130e-001, 3.671124e-001, 3.671118e-001, 3.671111e-001, 3.671105e-001, 3.671099e-001, 3.671092e-001, 3.671086e-001, 3.671080e-001, 3.671073e-001, 3.671067e-001, 3.671061e-001, 
3.671054e-001, 3.671048e-001, 3.671042e-001, 3.671035e-001, 3.671029e-001, 3.671022e-001, 3.671016e-001, 3.671010e-001, 3.671003e-001, 3.670997e-001, 3.670991e-001, 3.670984e-001, 3.670978e-001, 3.670972e-001, 3.670965e-001, 3.670959e-001, 3.670952e-001, 3.670946e-001, 3.670940e-001, 3.670933e-001, 3.670927e-001, 3.670920e-001, 3.670914e-001, 3.670908e-001, 3.670901e-001, 3.670895e-001, 3.670888e-001, 3.670882e-001, 3.670875e-001, 3.670869e-001, 3.670863e-001, 3.670856e-001, 3.670850e-001, 3.670843e-001, 3.670837e-001, 3.670830e-001, 3.670824e-001, 3.670818e-001, 3.670811e-001, 3.670805e-001, 3.670798e-001, 3.670792e-001, 3.670785e-001, 3.670779e-001, 3.670772e-001, 3.670766e-001, 3.670759e-001, 3.670753e-001, 3.670747e-001, 3.670740e-001, 3.670734e-001, 3.670727e-001, 3.670721e-001, 3.670714e-001, 3.670708e-001, 3.670701e-001, 3.670695e-001, 3.670688e-001, 3.670682e-001, 3.670675e-001, 3.670669e-001, 3.670662e-001, 3.670656e-001, 3.670649e-001, 3.670643e-001, 3.670636e-001, 3.670630e-001, 3.670623e-001, 3.670617e-001, 3.670610e-001, 3.670603e-001, 3.670597e-001, 3.670590e-001, 3.670584e-001, 3.670577e-001, 3.670571e-001, 3.670564e-001, 3.670558e-001, 3.670551e-001, 3.670545e-001, 3.670538e-001, 3.670532e-001, 3.670525e-001, 3.670518e-001, 3.670512e-001, 3.670505e-001, 3.670499e-001, 3.670492e-001, 3.670486e-001, 3.670479e-001, 3.670472e-001, 3.670466e-001, 3.670459e-001, 3.670453e-001, 3.670446e-001, 3.670439e-001, 3.670433e-001, 3.670426e-001, 3.670420e-001, 3.670413e-001, 
3.670406e-001, 3.670400e-001, 3.670393e-001, 3.670387e-001, 3.670380e-001, 3.670373e-001, 3.670367e-001, 3.670360e-001, 3.670354e-001, 3.670347e-001, 3.670340e-001, 3.670334e-001, 3.670327e-001, 3.670320e-001, 3.670314e-001, 3.670307e-001, 3.670300e-001, 3.670294e-001, 3.670287e-001, 3.670281e-001, 3.670274e-001, 3.670267e-001, 3.670261e-001, 3.670254e-001, 3.670247e-001, 3.670241e-001, 3.670234e-001, 3.670227e-001, 3.670221e-001, 3.670214e-001, 3.670207e-001, 3.670200e-001, 3.670194e-001, 3.670187e-001, 3.670180e-001, 3.670174e-001, 3.670167e-001, 3.670160e-001, 3.670154e-001, 3.670147e-001, 3.670140e-001, 3.670134e-001, 3.670127e-001, 3.670120e-001, 3.670113e-001, 3.670107e-001, 3.670100e-001, 3.670093e-001, 3.670086e-001, 3.670080e-001, 3.670073e-001, 3.670066e-001, 3.670060e-001, 3.670053e-001, 3.670046e-001, 3.670039e-001, 3.670033e-001, 3.670026e-001, 3.670019e-001, 3.670012e-001, 3.670006e-001, 3.669999e-001, 3.669992e-001, 3.669985e-001, 3.669979e-001, 3.669972e-001, 3.669965e-001, 3.669958e-001, 3.669951e-001, 3.669945e-001, 3.669938e-001, 3.669931e-001, 3.669924e-001, 3.669917e-001, 3.669911e-001, 3.669904e-001, 3.669897e-001, 3.669890e-001, 3.669884e-001, 3.669877e-001, 3.669870e-001, 3.669863e-001, 3.669856e-001, 3.669849e-001, 3.669843e-001, 3.669836e-001, 3.669829e-001, 3.669822e-001, 3.669815e-001, 3.669809e-001, 3.669802e-001, 3.669795e-001, 3.669788e-001, 3.669781e-001, 3.669774e-001, 3.669767e-001, 3.669761e-001, 3.669754e-001, 3.669747e-001, 3.669740e-001, 
3.669733e-001, 3.669726e-001, 3.669719e-001, 3.669713e-001, 3.669706e-001, 3.669699e-001, 3.669692e-001, 3.669685e-001, 3.669678e-001, 3.669671e-001, 3.669664e-001, 3.669658e-001, 3.669651e-001, 3.669644e-001, 3.669637e-001, 3.669630e-001, 3.669623e-001, 3.669616e-001, 3.669609e-001, 3.669602e-001, 3.669596e-001, 3.669589e-001, 3.669582e-001, 3.669575e-001, 3.669568e-001, 3.669561e-001, 3.669554e-001, 3.669547e-001, 3.669540e-001, 3.669533e-001, 3.669526e-001, 3.669519e-001, 3.669512e-001, 3.669505e-001, 3.669499e-001, 3.669492e-001, 3.669485e-001, 3.669478e-001, 3.669471e-001, 3.669464e-001, 3.669457e-001, 3.669450e-001, 3.669443e-001, 3.669436e-001, 3.669429e-001, 3.669422e-001, 3.669415e-001, 3.669408e-001, 3.669401e-001, 3.669394e-001, 3.669387e-001, 3.669380e-001, 3.669373e-001, 3.669366e-001, 3.669359e-001, 3.669352e-001, 3.669345e-001, 3.669338e-001, 3.669331e-001, 3.669324e-001, 3.669317e-001, 3.669310e-001, 3.669303e-001, 3.669296e-001, 3.669289e-001, 3.669282e-001, 3.669275e-001, 3.669268e-001, 3.669261e-001, 3.669254e-001, 3.669247e-001, 3.669240e-001, 3.669233e-001, 3.669226e-001, 3.669219e-001, 3.669212e-001, 3.669205e-001, 3.669198e-001, 3.669190e-001, 3.669183e-001, 3.669176e-001, 3.669169e-001, 3.669162e-001, 3.669155e-001, 3.669148e-001, 3.669141e-001, 3.669134e-001, 3.669127e-001, 3.669120e-001, 3.669113e-001, 3.669106e-001, 3.669098e-001, 3.669091e-001, 3.669084e-001, 3.669077e-001, 3.669070e-001, 3.669063e-001, 3.669056e-001, 3.669049e-001, 3.669042e-001, 
3.669035e-001, 3.669027e-001, 3.669020e-001, 3.669013e-001, 3.669006e-001, 3.668999e-001, 3.668992e-001, 3.668985e-001, 3.668978e-001, 3.668970e-001, 3.668963e-001, 3.668956e-001, 3.668949e-001, 3.668942e-001, 3.668935e-001, 3.668928e-001, 3.668920e-001, 3.668913e-001, 3.668906e-001, 3.668899e-001, 3.668892e-001, 3.668885e-001, 3.668877e-001, 3.668870e-001, 3.668863e-001, 3.668856e-001, 3.668849e-001, 3.668842e-001, 3.668834e-001, 3.668827e-001, 3.668820e-001, 3.668813e-001, 3.668806e-001, 3.668798e-001, 3.668791e-001, 3.668784e-001, 3.668777e-001, 3.668770e-001, 3.668762e-001, 3.668755e-001, 3.668748e-001, 3.668741e-001, 3.668734e-001, 3.668726e-001, 3.668719e-001, 3.668712e-001, 3.668705e-001, 3.668697e-001, 3.668690e-001, 3.668683e-001, 3.668676e-001, 3.668669e-001, 3.668661e-001, 3.668654e-001, 3.668647e-001, 3.668640e-001, 3.668632e-001, 3.668625e-001, 3.668618e-001, 3.668611e-001, 3.668603e-001, 3.668596e-001, 3.668589e-001, 3.668581e-001, 3.668574e-001, 3.668567e-001, 3.668560e-001, 3.668552e-001, 3.668545e-001, 3.668538e-001, 3.668530e-001, 3.668523e-001, 3.668516e-001, 3.668509e-001, 3.668501e-001, 3.668494e-001, 3.668487e-001, 3.668479e-001, 3.668472e-001, 3.668465e-001, 3.668457e-001, 3.668450e-001, 3.668443e-001, 3.668435e-001, 3.668428e-001, 3.668421e-001, 3.668414e-001, 3.668406e-001, 3.668399e-001, 3.668392e-001, 3.668384e-001, 3.668377e-001, 3.668369e-001, 3.668362e-001, 3.668355e-001, 3.668347e-001, 3.668340e-001, 3.668333e-001, 3.668325e-001, 3.668318e-001, 
3.668311e-001, 3.668303e-001, 3.668296e-001, 3.668289e-001, 3.668281e-001, 3.668274e-001, 3.668266e-001, 3.668259e-001, 3.668252e-001, 3.668244e-001, 3.668237e-001, 3.668229e-001, 3.668222e-001, 3.668215e-001, 3.668207e-001, 3.668200e-001, 3.668192e-001, 3.668185e-001, 3.668178e-001, 3.668170e-001, 3.668163e-001, 3.668155e-001, 3.668148e-001, 3.668141e-001, 3.668133e-001, 3.668126e-001, 3.668118e-001, 3.668111e-001, 3.668103e-001, 3.668096e-001, 3.668089e-001, 3.668081e-001, 3.668074e-001, 3.668066e-001, 3.668059e-001, 3.668051e-001, 3.668044e-001, 3.668036e-001, 3.668029e-001, 3.668021e-001, 3.668014e-001, 3.668007e-001, 3.667999e-001, 3.667992e-001, 3.667984e-001, 3.667977e-001, 3.667969e-001, 3.667962e-001, 3.667954e-001, 3.667947e-001, 3.667939e-001, 3.667932e-001, 3.667924e-001, 3.667917e-001, 3.667909e-001, 3.667902e-001, 3.667894e-001, 3.667887e-001, 3.667879e-001, 3.667872e-001, 3.667864e-001, 3.667857e-001, 3.667849e-001, 3.667842e-001, 3.667834e-001, 3.667827e-001, 3.667819e-001, 3.667811e-001, 3.667804e-001, 3.667796e-001, 3.667789e-001, 3.667781e-001, 3.667774e-001, 3.667766e-001, 3.667759e-001, 3.667751e-001, 3.667744e-001, 3.667736e-001, 3.667728e-001, 3.667721e-001, 3.667713e-001, 3.667706e-001, 3.667698e-001, 3.667691e-001, 3.667683e-001, 3.667675e-001, 3.667668e-001, 3.667660e-001, 3.667653e-001, 3.667645e-001, 3.667637e-001, 3.667630e-001, 3.667622e-001, 3.667615e-001, 3.667607e-001, 3.667599e-001, 3.667592e-001, 3.667584e-001, 3.667577e-001, 3.667569e-001, 
3.667561e-001, 3.667554e-001, 3.667546e-001, 3.667539e-001, 3.667531e-001, 3.667523e-001, 3.667516e-001, 3.667508e-001, 3.667500e-001, 3.667493e-001, 3.667485e-001, 3.667477e-001, 3.667470e-001, 3.667462e-001, 3.667455e-001, 3.667447e-001, 3.667439e-001, 3.667432e-001, 3.667424e-001, 3.667416e-001, 3.667409e-001, 3.667401e-001, 3.667393e-001, 3.667386e-001, 3.667378e-001, 3.667370e-001, 3.667363e-001, 3.667355e-001, 3.667347e-001, 3.667339e-001, 3.667332e-001, 3.667324e-001, 3.667316e-001, 3.667309e-001, 3.667301e-001, 3.667293e-001, 3.667286e-001, 3.667278e-001, 3.667270e-001, 3.667262e-001, 3.667255e-001, 3.667247e-001, 3.667239e-001, 3.667232e-001, 3.667224e-001, 3.667216e-001, 3.667208e-001, 3.667201e-001, 3.667193e-001, 3.667185e-001, 3.667177e-001, 3.667170e-001, 3.667162e-001, 3.667154e-001, 3.667146e-001, 3.667139e-001, 3.667131e-001, 3.667123e-001, 3.667115e-001, 3.667108e-001, 3.667100e-001, 3.667092e-001, 3.667084e-001, 3.667076e-001, 3.667069e-001, 3.667061e-001, 3.667053e-001, 3.667045e-001, 3.667038e-001, 3.667030e-001, 3.667022e-001, 3.667014e-001, 3.667006e-001, 3.666999e-001, 3.666991e-001, 3.666983e-001, 3.666975e-001, 3.666967e-001, 3.666960e-001, 3.666952e-001, 3.666944e-001, 3.666936e-001, 3.666928e-001, 3.666920e-001, 3.666913e-001, 3.666905e-001, 3.666897e-001, 3.666889e-001, 3.666881e-001, 3.666873e-001, 3.666866e-001, 3.666858e-001, 3.666850e-001, 3.666842e-001, 3.666834e-001, 3.666826e-001, 3.666818e-001, 3.666811e-001, 3.666803e-001, 3.666795e-001, 
3.666787e-001, 3.666779e-001, 3.666771e-001, 3.666763e-001, 3.666756e-001, 3.666748e-001, 3.666740e-001, 3.666732e-001, 3.666724e-001, 3.666716e-001, 3.666708e-001, 3.666700e-001, 3.666692e-001, 3.666685e-001, 3.666677e-001, 3.666669e-001, 3.666661e-001, 3.666653e-001, 3.666645e-001, 3.666637e-001, 3.666629e-001, 3.666621e-001, 3.666613e-001, 3.666605e-001, 3.666597e-001, 3.666590e-001, 3.666582e-001, 3.666574e-001, 3.666566e-001, 3.666558e-001, 3.666550e-001, 3.666542e-001, 3.666534e-001, 3.666526e-001, 3.666518e-001, 3.666510e-001, 3.666502e-001, 3.666494e-001, 3.666486e-001, 3.666478e-001, 3.666470e-001, 3.666462e-001, 3.666454e-001, 3.666446e-001, 3.666438e-001, 3.666430e-001, 3.666422e-001, 3.666414e-001, 3.666406e-001, 3.666398e-001, 3.666390e-001, 3.666382e-001, 3.666374e-001, 3.666366e-001, 3.666358e-001, 3.666350e-001, 3.666342e-001, 3.666334e-001, 3.666326e-001, 3.666318e-001, 3.666310e-001, 3.666302e-001, 3.666294e-001, 3.666286e-001, 3.666278e-001, 3.666270e-001, 3.666262e-001, 3.666254e-001, 3.666246e-001, 3.666238e-001, 3.666230e-001, 3.666222e-001, 3.666214e-001, 3.666206e-001, 3.666198e-001, 3.666190e-001, 3.666182e-001, 3.666174e-001, 3.666166e-001, 3.666157e-001, 3.666149e-001, 3.666141e-001, 3.666133e-001, 3.666125e-001, 3.666117e-001, 3.666109e-001, 3.666101e-001, 3.666093e-001, 3.666085e-001, 3.666077e-001, 3.666069e-001, 3.666060e-001, 3.666052e-001, 3.666044e-001, 3.666036e-001, 3.666028e-001, 3.666020e-001, 3.666012e-001, 3.666004e-001, 3.665996e-001, 
3.665988e-001, 3.665979e-001, 3.665971e-001, 3.665963e-001, 3.665955e-001, 3.665947e-001, 3.665939e-001, 3.665931e-001, 3.665922e-001, 3.665914e-001, 3.665906e-001, 3.665898e-001, 3.665890e-001, 3.665882e-001, 3.665874e-001, 3.665865e-001, 3.665857e-001, 3.665849e-001, 3.665841e-001, 3.665833e-001, 3.665825e-001, 3.665816e-001, 3.665808e-001, 3.665800e-001, 3.665792e-001, 3.665784e-001, 3.665776e-001, 3.665767e-001, 3.665759e-001, 3.665751e-001, 3.665743e-001, 3.665735e-001, 3.665726e-001, 3.665718e-001, 3.665710e-001, 3.665702e-001, 3.665694e-001, 3.665685e-001, 3.665677e-001, 3.665669e-001, 3.665661e-001, 3.665652e-001, 3.665644e-001, 3.665636e-001, 3.665628e-001, 3.665620e-001, 3.665611e-001, 3.665603e-001, 3.665595e-001, 3.665587e-001, 3.665578e-001, 3.665570e-001, 3.665562e-001, 3.665554e-001, 3.665545e-001, 3.665537e-001, 3.665529e-001, 3.665521e-001, 3.665512e-001, 3.665504e-001, 3.665496e-001, 3.665487e-001, 3.665479e-001, 3.665471e-001, 3.665463e-001, 3.665454e-001, 3.665446e-001, 3.665438e-001, 3.665430e-001, 3.665421e-001, 3.665413e-001, 3.665405e-001, 3.665396e-001, 3.665388e-001, 3.665380e-001, 3.665371e-001, 3.665363e-001, 3.665355e-001, 3.665346e-001, 3.665338e-001, 3.665330e-001, 3.665322e-001, 3.665313e-001, 3.665305e-001, 3.665297e-001, 3.665288e-001, 3.665280e-001, 3.665272e-001, 3.665263e-001, 3.665255e-001, 3.665247e-001, 3.665238e-001, 3.665230e-001, 3.665221e-001, 3.665213e-001, 3.665205e-001, 3.665196e-001, 3.665188e-001, 3.665180e-001, 3.665171e-001, 
3.665163e-001, 3.665155e-001, 3.665146e-001, 3.665138e-001, 3.665129e-001, 3.665121e-001, 3.665113e-001, 3.665104e-001, 3.665096e-001, 3.665087e-001, 3.665079e-001, 3.665071e-001, 3.665062e-001, 3.665054e-001, 3.665045e-001, 3.665037e-001, 3.665029e-001, 3.665020e-001, 3.665012e-001, 3.665003e-001, 3.664995e-001, 3.664987e-001, 3.664978e-001, 3.664970e-001, 3.664961e-001, 3.664953e-001, 3.664944e-001, 3.664936e-001, 3.664928e-001, 3.664919e-001, 3.664911e-001, 3.664902e-001, 3.664894e-001, 3.664885e-001, 3.664877e-001, 3.664868e-001, 3.664860e-001, 3.664851e-001, 3.664843e-001, 3.664835e-001, 3.664826e-001, 3.664818e-001, 3.664809e-001, 3.664801e-001, 3.664792e-001, 3.664784e-001, 3.664775e-001, 3.664767e-001, 3.664758e-001, 3.664750e-001, 3.664741e-001, 3.664733e-001, 3.664724e-001, 3.664716e-001, 3.664707e-001, 3.664699e-001, 3.664690e-001, 3.664682e-001, 3.664673e-001, 3.664665e-001, 3.664656e-001, 3.664648e-001, 3.664639e-001, 3.664631e-001, 3.664622e-001, 3.664614e-001, 3.664605e-001, 3.664596e-001, 3.664588e-001, 3.664579e-001, 3.664571e-001, 3.664562e-001, 3.664554e-001, 3.664545e-001, 3.664537e-001, 3.664528e-001, 3.664520e-001, 3.664511e-001, 3.664502e-001, 3.664494e-001, 3.664485e-001, 3.664477e-001, 3.664468e-001, 3.664460e-001, 3.664451e-001, 3.664442e-001, 3.664434e-001, 3.664425e-001, 3.664417e-001, 3.664408e-001, 3.664399e-001, 3.664391e-001, 3.664382e-001, 3.664374e-001, 3.664365e-001, 3.664356e-001, 3.664348e-001, 3.664339e-001, 3.664331e-001, 3.664322e-001, 
3.664313e-001, 3.664305e-001, 3.664296e-001, 3.664287e-001, 3.664279e-001, 3.664270e-001, 3.664262e-001, 3.664253e-001, 3.664244e-001, 3.664236e-001, 3.664227e-001, 3.664218e-001, 3.664210e-001, 3.664201e-001, 3.664192e-001, 3.664184e-001, 3.664175e-001, 3.664166e-001, 3.664158e-001, 3.664149e-001, 3.664140e-001, 3.664132e-001, 3.664123e-001, 3.664114e-001, 3.664106e-001, 3.664097e-001, 3.664088e-001, 3.664080e-001, 3.664071e-001, 3.664062e-001, 3.664054e-001, 3.664045e-001, 3.664036e-001, 3.664028e-001, 3.664019e-001, 3.664010e-001, 3.664001e-001, 3.663993e-001, 3.663984e-001, 3.663975e-001, 3.663967e-001, 3.663958e-001, 3.663949e-001, 3.663940e-001, 3.663932e-001, 3.663923e-001, 3.663914e-001, 3.663905e-001, 3.663897e-001, 3.663888e-001, 3.663879e-001, 3.663870e-001, 3.663862e-001, 3.663853e-001, 3.663844e-001, 3.663835e-001, 3.663827e-001, 3.663818e-001, 3.663809e-001, 3.663800e-001, 3.663792e-001, 3.663783e-001, 3.663774e-001, 3.663765e-001, 3.663757e-001, 3.663748e-001, 3.663739e-001, 3.663730e-001, 3.663721e-001, 3.663713e-001, 3.663704e-001, 3.663695e-001, 3.663686e-001, 3.663677e-001, 3.663669e-001, 3.663660e-001, 3.663651e-001, 3.663642e-001, 3.663633e-001, 3.663625e-001, 3.663616e-001, 3.663607e-001, 3.663598e-001, 3.663589e-001, 3.663580e-001, 3.663572e-001, 3.663563e-001, 3.663554e-001, 3.663545e-001, 3.663536e-001, 3.663527e-001, 3.663519e-001, 3.663510e-001, 3.663501e-001, 3.663492e-001, 3.663483e-001, 3.663474e-001, 3.663465e-001, 3.663457e-001, 3.663448e-001, 
3.663439e-001, 3.663430e-001, 3.663421e-001, 3.663412e-001, 3.663403e-001, 3.663394e-001, 3.663386e-001, 3.663377e-001, 3.663368e-001, 3.663359e-001, 3.663350e-001, 3.663341e-001, 3.663332e-001, 3.663323e-001, 3.663314e-001, 3.663306e-001, 3.663297e-001, 3.663288e-001, 3.663279e-001, 3.663270e-001, 3.663261e-001, 3.663252e-001, 3.663243e-001, 3.663234e-001, 3.663225e-001, 3.663216e-001, 3.663207e-001, 3.663198e-001, 3.663189e-001, 3.663181e-001, 3.663172e-001, 3.663163e-001, 3.663154e-001, 3.663145e-001, 3.663136e-001, 3.663127e-001, 3.663118e-001, 3.663109e-001, 3.663100e-001, 3.663091e-001, 3.663082e-001, 3.663073e-001, 3.663064e-001, 3.663055e-001, 3.663046e-001, 3.663037e-001, 3.663028e-001, 3.663019e-001, 3.663010e-001, 3.663001e-001, 3.662992e-001, 3.662983e-001, 3.662974e-001, 3.662965e-001, 3.662956e-001, 3.662947e-001, 3.662938e-001, 3.662929e-001, 3.662920e-001, 3.662911e-001, 3.662902e-001, 3.662893e-001, 3.662884e-001, 3.662875e-001, 3.662866e-001, 3.662857e-001, 3.662848e-001, 3.662839e-001, 3.662830e-001, 3.662821e-001, 3.662812e-001, 3.662803e-001, 3.662794e-001, 3.662785e-001, 3.662776e-001, 3.662767e-001, 3.662758e-001, 3.662748e-001, 3.662739e-001, 3.662730e-001, 3.662721e-001, 3.662712e-001, 3.662703e-001, 3.662694e-001, 3.662685e-001, 3.662676e-001, 3.662667e-001, 3.662658e-001, 3.662649e-001, 3.662640e-001, 3.662630e-001, 3.662621e-001, 3.662612e-001, 3.662603e-001, 3.662594e-001, 3.662585e-001, 3.662576e-001, 3.662567e-001, 3.662558e-001, 3.662549e-001, 
3.662539e-001, 3.662530e-001, 3.662521e-001, 3.662512e-001, 3.662503e-001, 3.662494e-001, 3.662485e-001, 3.662476e-001, 3.662466e-001, 3.662457e-001, 3.662448e-001, 3.662439e-001, 3.662430e-001, 3.662421e-001, 3.662412e-001, 3.662402e-001, 3.662393e-001, 3.662384e-001, 3.662375e-001, 3.662366e-001, 3.662357e-001, 3.662347e-001, 3.662338e-001, 3.662329e-001, 3.662320e-001, 3.662311e-001, 3.662302e-001, 3.662292e-001, 3.662283e-001, 3.662274e-001, 3.662265e-001, 3.662256e-001, 3.662246e-001, 3.662237e-001, 3.662228e-001, 3.662219e-001, 3.662210e-001, 3.662200e-001, 3.662191e-001, 3.662182e-001, 3.662173e-001, 3.662164e-001, 3.662154e-001, 3.662145e-001, 3.662136e-001, 3.662127e-001, 3.662117e-001, 3.662108e-001, 3.662099e-001, 3.662090e-001, 3.662080e-001, 3.662071e-001, 3.662062e-001, 3.662053e-001, 3.662043e-001, 3.662034e-001, 3.662025e-001, 3.662016e-001, 3.662006e-001, 3.661997e-001, 3.661988e-001, 3.661979e-001, 3.661969e-001, 3.661960e-001, 3.661951e-001, 3.661942e-001, 3.661932e-001, 3.661923e-001, 3.661914e-001, 3.661904e-001, 3.661895e-001, 3.661886e-001, 3.661876e-001, 3.661867e-001, 3.661858e-001, 3.661849e-001, 3.661839e-001, 3.661830e-001, 3.661821e-001, 3.661811e-001, 3.661802e-001, 3.661793e-001, 3.661783e-001, 3.661774e-001, 3.661765e-001, 3.661755e-001, 3.661746e-001, 3.661737e-001, 3.661727e-001, 3.661718e-001, 3.661709e-001, 3.661699e-001, 3.661690e-001, 3.661681e-001, 3.661671e-001, 3.661662e-001, 3.661653e-001, 3.661643e-001, 3.661634e-001, 3.661625e-001, 
3.661615e-001, 3.661606e-001, 3.661596e-001, 3.661587e-001, 3.661578e-001, 3.661568e-001, 3.661559e-001, 3.661550e-001, 3.661540e-001, 3.661531e-001, 3.661521e-001, 3.661512e-001, 3.661503e-001, 3.661493e-001, 3.661484e-001, 3.661474e-001, 3.661465e-001, 3.661456e-001, 3.661446e-001, 3.661437e-001, 3.661427e-001, 3.661418e-001, 3.661409e-001, 3.661399e-001, 3.661390e-001, 3.661380e-001, 3.661371e-001, 3.661361e-001, 3.661352e-001, 3.661343e-001, 3.661333e-001, 3.661324e-001, 3.661314e-001, 3.661305e-001, 3.661295e-001, 3.661286e-001, 3.661276e-001, 3.661267e-001, 3.661258e-001, 3.661248e-001, 3.661239e-001, 3.661229e-001, 3.661220e-001, 3.661210e-001, 3.661201e-001, 3.661191e-001, 3.661182e-001, 3.661172e-001, 3.661163e-001, 3.661153e-001, 3.661144e-001, 3.661134e-001, 3.661125e-001, 3.661115e-001, 3.661106e-001, 3.661096e-001, 3.661087e-001, 3.661077e-001, 3.661068e-001, 3.661058e-001, 3.661049e-001, 3.661039e-001, 3.661030e-001, 3.661020e-001, 3.661011e-001, 3.661001e-001, 3.660992e-001, 3.660982e-001, 3.660973e-001, 3.660963e-001, 3.660954e-001, 3.660944e-001, 3.660934e-001, 3.660925e-001, 3.660915e-001, 3.660906e-001, 3.660896e-001, 3.660887e-001, 3.660877e-001, 3.660868e-001, 3.660858e-001, 3.660848e-001, 3.660839e-001, 3.660829e-001, 3.660820e-001, 3.660810e-001, 3.660801e-001, 3.660791e-001, 3.660781e-001, 3.660772e-001, 3.660762e-001, 3.660753e-001, 3.660743e-001, 3.660733e-001, 3.660724e-001, 3.660714e-001, 3.660705e-001, 3.660695e-001, 3.660685e-001, 3.660676e-001, 
3.660666e-001, 3.660657e-001, 3.660647e-001, 3.660637e-001, 3.660628e-001, 3.660618e-001, 3.660609e-001, 3.660599e-001, 3.660589e-001, 3.660580e-001, 3.660570e-001, 3.660560e-001, 3.660551e-001, 3.660541e-001, 3.660531e-001, 3.660522e-001, 3.660512e-001, 3.660502e-001, 3.660493e-001, 3.660483e-001, 3.660474e-001, 3.660464e-001, 3.660454e-001, 3.660445e-001, 3.660435e-001, 3.660425e-001, 3.660415e-001, 3.660406e-001, 3.660396e-001, 3.660386e-001, 3.660377e-001, 3.660367e-001, 3.660357e-001, 3.660348e-001, 3.660338e-001, 3.660328e-001, 3.660319e-001, 3.660309e-001, 3.660299e-001, 3.660289e-001, 3.660280e-001, 3.660270e-001, 3.660260e-001, 3.660251e-001, 3.660241e-001, 3.660231e-001, 3.660221e-001, 3.660212e-001, 3.660202e-001, 3.660192e-001, 3.660183e-001, 3.660173e-001, 3.660163e-001, 3.660153e-001, 3.660144e-001, 3.660134e-001, 3.660124e-001, 3.660114e-001, 3.660105e-001, 3.660095e-001, 3.660085e-001, 3.660075e-001, 3.660065e-001, 3.660056e-001, 3.660046e-001, 3.660036e-001, 3.660026e-001, 3.660017e-001, 3.660007e-001, 3.659997e-001, 3.659987e-001, 3.659978e-001, 3.659968e-001, 3.659958e-001, 3.659948e-001, 3.659938e-001, 3.659929e-001, 3.659919e-001, 3.659909e-001, 3.659899e-001, 3.659889e-001, 3.659879e-001, 3.659870e-001, 3.659860e-001, 3.659850e-001, 3.659840e-001, 3.659830e-001, 3.659821e-001, 3.659811e-001, 3.659801e-001, 3.659791e-001, 3.659781e-001, 3.659771e-001, 3.659762e-001, 3.659752e-001, 3.659742e-001, 3.659732e-001, 3.659722e-001, 3.659712e-001, 3.659702e-001, 
3.659693e-001, 3.659683e-001, 3.659673e-001, 3.659663e-001, 3.659653e-001, 3.659643e-001, 3.659633e-001, 3.659624e-001, 3.659614e-001, 3.659604e-001, 3.659594e-001, 3.659584e-001, 3.659574e-001, 3.659564e-001, 3.659554e-001, 3.659544e-001, 3.659535e-001, 3.659525e-001, 3.659515e-001, 3.659505e-001, 3.659495e-001, 3.659485e-001, 3.659475e-001, 3.659465e-001, 3.659455e-001, 3.659445e-001, 3.659435e-001, 3.659425e-001, 3.659416e-001, 3.659406e-001, 3.659396e-001, 3.659386e-001, 3.659376e-001, 3.659366e-001, 3.659356e-001, 3.659346e-001, 3.659336e-001, 3.659326e-001, 3.659316e-001, 3.659306e-001, 3.659296e-001, 3.659286e-001, 3.659276e-001, 3.659266e-001, 3.659256e-001, 3.659246e-001, 3.659236e-001, 3.659226e-001, 3.659216e-001, 3.659207e-001, 3.659197e-001, 3.659187e-001, 3.659177e-001, 3.659167e-001, 3.659157e-001, 3.659147e-001, 3.659137e-001, 3.659127e-001, 3.659117e-001, 3.659107e-001, 3.659097e-001, 3.659087e-001, 3.659077e-001, 3.659067e-001, 3.659057e-001, 3.659047e-001, 3.659036e-001, 3.659026e-001, 3.659016e-001, 3.659006e-001, 3.658996e-001, 3.658986e-001, 3.658976e-001, 3.658966e-001, 3.658956e-001, 3.658946e-001, 3.658936e-001, 3.658926e-001, 3.658916e-001, 3.658906e-001, 3.658896e-001, 3.658886e-001, 3.658876e-001, 3.658866e-001, 3.658856e-001, 3.658846e-001, 3.658836e-001, 3.658825e-001, 3.658815e-001, 3.658805e-001, 3.658795e-001, 3.658785e-001, 3.658775e-001, 3.658765e-001, 3.658755e-001, 3.658745e-001, 3.658735e-001, 3.658725e-001, 3.658715e-001, 3.658704e-001, 
3.658694e-001, 3.658684e-001, 3.658674e-001, 3.658664e-001, 3.658654e-001, 3.658644e-001, 3.658634e-001, 3.658624e-001, 3.658613e-001, 3.658603e-001, 3.658593e-001, 3.658583e-001, 3.658573e-001, 3.658563e-001, 3.658553e-001, 3.658542e-001, 3.658532e-001, 3.658522e-001, 3.658512e-001, 3.658502e-001, 3.658492e-001, 3.658482e-001, 3.658471e-001, 3.658461e-001, 3.658451e-001, 3.658441e-001, 3.658431e-001, 3.658421e-001, 3.658410e-001, 3.658400e-001, 3.658390e-001, 3.658380e-001, 3.658370e-001, 3.658359e-001, 3.658349e-001, 3.658339e-001, 3.658329e-001, 3.658319e-001, 3.658309e-001, 3.658298e-001, 3.658288e-001, 3.658278e-001, 3.658268e-001, 3.658258e-001, 3.658247e-001, 3.658237e-001, 3.658227e-001, 3.658217e-001, 3.658206e-001, 3.658196e-001, 3.658186e-001, 3.658176e-001, 3.658165e-001, 3.658155e-001, 3.658145e-001, 3.658135e-001, 3.658125e-001, 3.658114e-001, 3.658104e-001, 3.658094e-001, 3.658084e-001, 3.658073e-001, 3.658063e-001, 3.658053e-001, 3.658043e-001, 3.658032e-001, 3.658022e-001, 3.658012e-001, 3.658001e-001, 3.657991e-001, 3.657981e-001, 3.657971e-001, 3.657960e-001, 3.657950e-001, 3.657940e-001, 3.657929e-001, 3.657919e-001, 3.657909e-001, 3.657899e-001, 3.657888e-001, 3.657878e-001, 3.657868e-001, 3.657857e-001, 3.657847e-001, 3.657837e-001, 3.657826e-001, 3.657816e-001, 3.657806e-001, 3.657796e-001, 3.657785e-001, 3.657775e-001, 3.657765e-001, 3.657754e-001, 3.657744e-001, 3.657734e-001, 3.657723e-001, 3.657713e-001, 3.657703e-001, 3.657692e-001, 3.657682e-001, 
3.657671e-001, 3.657661e-001, 3.657651e-001, 3.657640e-001, 3.657630e-001, 3.657620e-001, 3.657609e-001, 3.657599e-001, 3.657589e-001, 3.657578e-001, 3.657568e-001, 3.657557e-001, 3.657547e-001, 3.657537e-001, 3.657526e-001, 3.657516e-001, 3.657506e-001, 3.657495e-001, 3.657485e-001, 3.657474e-001, 3.657464e-001, 3.657454e-001, 3.657443e-001, 3.657433e-001, 3.657422e-001, 3.657412e-001, 3.657402e-001, 3.657391e-001, 3.657381e-001, 3.657370e-001, 3.657360e-001, 3.657349e-001, 3.657339e-001, 3.657329e-001, 3.657318e-001, 3.657308e-001, 3.657297e-001, 3.657287e-001, 3.657276e-001, 3.657266e-001, 3.657255e-001, 3.657245e-001, 3.657235e-001, 3.657224e-001, 3.657214e-001, 3.657203e-001, 3.657193e-001, 3.657182e-001, 3.657172e-001, 3.657161e-001, 3.657151e-001, 3.657140e-001, 3.657130e-001, 3.657119e-001, 3.657109e-001, 3.657098e-001, 3.657088e-001, 3.657077e-001, 3.657067e-001, 3.657056e-001, 3.657046e-001, 3.657035e-001, 3.657025e-001, 3.657014e-001, 3.657004e-001, 3.656993e-001, 3.656983e-001, 3.656972e-001, 3.656962e-001, 3.656951e-001, 3.656941e-001, 3.656930e-001, 3.656920e-001, 3.656909e-001, 3.656899e-001, 3.656888e-001, 3.656878e-001, 3.656867e-001, 3.656857e-001, 3.656846e-001, 3.656836e-001, 3.656825e-001, 3.656814e-001, 3.656804e-001, 3.656793e-001, 3.656783e-001, 3.656772e-001, 3.656762e-001, 3.656751e-001, 3.656741e-001, 3.656730e-001, 3.656719e-001, 3.656709e-001, 3.656698e-001, 3.656688e-001, 3.656677e-001, 3.656666e-001, 3.656656e-001, 3.656645e-001, 3.656635e-001, 
3.656624e-001, 3.656614e-001, 3.656603e-001, 3.656592e-001, 3.656582e-001, 3.656571e-001, 3.656560e-001, 3.656550e-001, 3.656539e-001, 3.656529e-001, 3.656518e-001, 3.656507e-001, 3.656497e-001, 3.656486e-001, 3.656476e-001, 3.656465e-001, 3.656454e-001, 3.656444e-001, 3.656433e-001, 3.656422e-001, 3.656412e-001, 3.656401e-001, 3.656390e-001, 3.656380e-001, 3.656369e-001, 3.656358e-001, 3.656348e-001, 3.656337e-001, 3.656326e-001, 3.656316e-001, 3.656305e-001, 3.656294e-001, 3.656284e-001, 3.656273e-001, 3.656262e-001, 3.656252e-001, 3.656241e-001, 3.656230e-001, 3.656220e-001, 3.656209e-001, 3.656198e-001, 3.656188e-001, 3.656177e-001, 3.656166e-001, 3.656156e-001, 3.656145e-001, 3.656134e-001, 3.656123e-001, 3.656113e-001, 3.656102e-001, 3.656091e-001, 3.656081e-001, 3.656070e-001, 3.656059e-001, 3.656048e-001, 3.656038e-001, 3.656027e-001, 3.656016e-001, 3.656005e-001, 3.655995e-001, 3.655984e-001, 3.655973e-001, 3.655962e-001, 3.655952e-001, 3.655941e-001, 3.655930e-001, 3.655919e-001, 3.655909e-001, 3.655898e-001, 3.655887e-001, 3.655876e-001, 3.655866e-001, 3.655855e-001, 3.655844e-001, 3.655833e-001, 3.655823e-001, 3.655812e-001, 3.655801e-001, 3.655790e-001, 3.655779e-001, 3.655769e-001, 3.655758e-001, 3.655747e-001, 3.655736e-001, 3.655725e-001, 3.655715e-001, 3.655704e-001, 3.655693e-001, 3.655682e-001, 3.655671e-001, 3.655661e-001, 3.655650e-001, 3.655639e-001, 3.655628e-001, 3.655617e-001, 3.655606e-001, 3.655596e-001, 3.655585e-001, 3.655574e-001, 3.655563e-001, 
3.655552e-001, 3.655541e-001, 3.655531e-001, 3.655520e-001, 3.655509e-001, 3.655498e-001, 3.655487e-001, 3.655476e-001, 3.655465e-001, 3.655455e-001, 3.655444e-001, 3.655433e-001, 3.655422e-001, 3.655411e-001, 3.655400e-001, 3.655389e-001, 3.655379e-001, 3.655368e-001, 3.655357e-001, 3.655346e-001, 3.655335e-001, 3.655324e-001, 3.655313e-001, 3.655302e-001, 3.655291e-001, 3.655281e-001, 3.655270e-001, 3.655259e-001, 3.655248e-001, 3.655237e-001, 3.655226e-001, 3.655215e-001, 3.655204e-001, 3.655193e-001, 3.655182e-001, 3.655171e-001, 3.655160e-001, 3.655150e-001, 3.655139e-001, 3.655128e-001, 3.655117e-001, 3.655106e-001, 3.655095e-001, 3.655084e-001, 3.655073e-001, 3.655062e-001, 3.655051e-001, 3.655040e-001, 3.655029e-001, 3.655018e-001, 3.655007e-001, 3.654996e-001, 3.654985e-001, 3.654974e-001, 3.654963e-001, 3.654952e-001, 3.654941e-001, 3.654930e-001, 3.654919e-001, 3.654908e-001, 3.654897e-001, 3.654887e-001, 3.654876e-001, 3.654865e-001, 3.654854e-001, 3.654843e-001, 3.654832e-001, 3.654821e-001, 3.654810e-001, 3.654799e-001, 3.654788e-001, 3.654776e-001, 3.654765e-001, 3.654754e-001, 3.654743e-001, 3.654732e-001, 3.654721e-001, 3.654710e-001, 3.654699e-001, 3.654688e-001, 3.654677e-001, 3.654666e-001, 3.654655e-001, 3.654644e-001, 3.654633e-001, 3.654622e-001, 3.654611e-001, 3.654600e-001, 3.654589e-001, 3.654578e-001, 3.654567e-001, 3.654556e-001, 3.654545e-001, 3.654534e-001, 3.654523e-001, 3.654511e-001, 3.654500e-001, 3.654489e-001, 3.654478e-001, 3.654467e-001, 
3.654456e-001, 3.654445e-001, 3.654434e-001, 3.654423e-001, 3.654412e-001, 3.654401e-001, 3.654390e-001, 3.654378e-001, 3.654367e-001, 3.654356e-001, 3.654345e-001, 3.654334e-001, 3.654323e-001, 3.654312e-001, 3.654301e-001, 3.654290e-001, 3.654278e-001, 3.654267e-001, 3.654256e-001, 3.654245e-001, 3.654234e-001, 3.654223e-001, 3.654212e-001, 3.654201e-001, 3.654189e-001, 3.654178e-001, 3.654167e-001, 3.654156e-001, 3.654145e-001, 3.654134e-001, 3.654122e-001, 3.654111e-001, 3.654100e-001, 3.654089e-001, 3.654078e-001, 3.654067e-001, 3.654055e-001, 3.654044e-001, 3.654033e-001, 3.654022e-001, 3.654011e-001, 3.654000e-001, 3.653988e-001, 3.653977e-001, 3.653966e-001, 3.653955e-001, 3.653944e-001, 3.653932e-001, 3.653921e-001, 3.653910e-001, 3.653899e-001, 3.653888e-001, 3.653876e-001, 3.653865e-001, 3.653854e-001, 3.653843e-001, 3.653832e-001, 3.653820e-001, 3.653809e-001, 3.653798e-001, 3.653787e-001, 3.653775e-001, 3.653764e-001, 3.653753e-001, 3.653742e-001, 3.653731e-001, 3.653719e-001, 3.653708e-001, 3.653697e-001, 3.653686e-001, 3.653674e-001, 3.653663e-001, 3.653652e-001, 3.653640e-001, 3.653629e-001, 3.653618e-001, 3.653607e-001, 3.653595e-001, 3.653584e-001, 3.653573e-001, 3.653562e-001, 3.653550e-001, 3.653539e-001, 3.653528e-001, 3.653516e-001, 3.653505e-001, 3.653494e-001, 3.653483e-001, 3.653471e-001, 3.653460e-001, 3.653449e-001, 3.653437e-001, 3.653426e-001, 3.653415e-001, 3.653403e-001, 3.653392e-001, 3.653381e-001, 3.653370e-001, 3.653358e-001, 3.653347e-001, 
3.653336e-001, 3.653324e-001, 3.653313e-001, 3.653302e-001, 3.653290e-001, 3.653279e-001, 3.653268e-001, 3.653256e-001, 3.653245e-001, 3.653234e-001, 3.653222e-001, 3.653211e-001, 3.653199e-001, 3.653188e-001, 3.653177e-001, 3.653165e-001, 3.653154e-001, 3.653143e-001, 3.653131e-001, 3.653120e-001, 3.653109e-001, 3.653097e-001, 3.653086e-001, 3.653074e-001, 3.653063e-001, 3.653052e-001, 3.653040e-001, 3.653029e-001, 3.653017e-001, 3.653006e-001, 3.652995e-001, 3.652983e-001, 3.652972e-001, 3.652960e-001, 3.652949e-001, 3.652938e-001, 3.652926e-001, 3.652915e-001, 3.652903e-001, 3.652892e-001, 3.652881e-001, 3.652869e-001, 3.652858e-001, 3.652846e-001, 3.652835e-001, 3.652823e-001, 3.652812e-001, 3.652801e-001, 3.652789e-001, 3.652778e-001, 3.652766e-001, 3.652755e-001, 3.652743e-001, 3.652732e-001, 3.652720e-001, 3.652709e-001, 3.652697e-001, 3.652686e-001, 3.652675e-001, 3.652663e-001, 3.652652e-001, 3.652640e-001, 3.652629e-001, 3.652617e-001, 3.652606e-001, 3.652594e-001, 3.652583e-001, 3.652571e-001, 3.652560e-001, 3.652548e-001, 3.652537e-001, 3.652525e-001, 3.652514e-001, 3.652502e-001, 3.652491e-001, 3.652479e-001, 3.652468e-001, 3.652456e-001, 3.652445e-001, 3.652433e-001, 3.652422e-001, 3.652410e-001, 3.652399e-001, 3.652387e-001, 3.652376e-001, 3.652364e-001, 3.652352e-001, 3.652341e-001, 3.652329e-001, 3.652318e-001, 3.652306e-001, 3.652295e-001, 3.652283e-001, 3.652272e-001, 3.652260e-001, 3.652249e-001, 3.652237e-001, 3.652225e-001, 3.652214e-001, 3.652202e-001, 
3.652191e-001, 3.652179e-001, 3.652168e-001, 3.652156e-001, 3.652144e-001, 3.652133e-001, 3.652121e-001, 3.652110e-001, 3.652098e-001, 3.652087e-001, 3.652075e-001, 3.652063e-001, 3.652052e-001, 3.652040e-001, 3.652029e-001, 3.652017e-001, 3.652005e-001, 3.651994e-001, 3.651982e-001, 3.651970e-001, 3.651959e-001, 3.651947e-001, 3.651936e-001, 3.651924e-001, 3.651912e-001, 3.651901e-001, 3.651889e-001, 3.651877e-001, 3.651866e-001, 3.651854e-001, 3.651843e-001, 3.651831e-001, 3.651819e-001, 3.651808e-001, 3.651796e-001, 3.651784e-001, 3.651773e-001, 3.651761e-001, 3.651749e-001, 3.651738e-001, 3.651726e-001, 3.651714e-001, 3.651703e-001, 3.651691e-001, 3.651679e-001, 3.651668e-001, 3.651656e-001, 3.651644e-001, 3.651633e-001, 3.651621e-001, 3.651609e-001, 3.651598e-001, 3.651586e-001, 3.651574e-001, 3.651562e-001, 3.651551e-001, 3.651539e-001, 3.651527e-001, 3.651516e-001, 3.651504e-001, 3.651492e-001, 3.651481e-001, 3.651469e-001, 3.651457e-001, 3.651445e-001, 3.651434e-001, 3.651422e-001, 3.651410e-001, 3.651398e-001, 3.651387e-001, 3.651375e-001, 3.651363e-001, 3.651351e-001, 3.651340e-001, 3.651328e-001, 3.651316e-001, 3.651304e-001, 3.651293e-001, 3.651281e-001, 3.651269e-001, 3.651257e-001, 3.651246e-001, 3.651234e-001, 3.651222e-001, 3.651210e-001, 3.651199e-001, 3.651187e-001, 3.651175e-001, 3.651163e-001, 3.651151e-001, 3.651140e-001, 3.651128e-001, 3.651116e-001, 3.651104e-001, 3.651093e-001, 3.651081e-001, 3.651069e-001, 3.651057e-001, 3.651045e-001, 3.651034e-001, 
3.651022e-001, 3.651010e-001, 3.650998e-001, 3.650986e-001, 3.650974e-001, 3.650963e-001, 3.650951e-001, 3.650939e-001, 3.650927e-001, 3.650915e-001, 3.650903e-001, 3.650892e-001, 3.650880e-001, 3.650868e-001, 3.650856e-001, 3.650844e-001, 3.650832e-001, 3.650821e-001, 3.650809e-001, 3.650797e-001, 3.650785e-001, 3.650773e-001, 3.650761e-001, 3.650749e-001, 3.650738e-001, 3.650726e-001, 3.650714e-001, 3.650702e-001, 3.650690e-001, 3.650678e-001, 3.650666e-001, 3.650654e-001, 3.650643e-001, 3.650631e-001, 3.650619e-001, 3.650607e-001, 3.650595e-001, 3.650583e-001, 3.650571e-001, 3.650559e-001, 3.650547e-001, 3.650535e-001, 3.650524e-001, 3.650512e-001, 3.650500e-001, 3.650488e-001, 3.650476e-001, 3.650464e-001, 3.650452e-001, 3.650440e-001, 3.650428e-001, 3.650416e-001, 3.650404e-001, 3.650392e-001, 3.650380e-001, 3.650368e-001, 3.650357e-001, 3.650345e-001, 3.650333e-001, 3.650321e-001, 3.650309e-001, 3.650297e-001, 3.650285e-001, 3.650273e-001, 3.650261e-001, 3.650249e-001, 3.650237e-001, 3.650225e-001, 3.650213e-001, 3.650201e-001, 3.650189e-001, 3.650177e-001, 3.650165e-001, 3.650153e-001, 3.650141e-001, 3.650129e-001, 3.650117e-001, 3.650105e-001, 3.650093e-001, 3.650081e-001, 3.650069e-001, 3.650057e-001, 3.650045e-001, 3.650033e-001, 3.650021e-001, 3.650009e-001, 3.649997e-001, 3.649985e-001, 3.649973e-001, 3.649961e-001, 3.649949e-001, 3.649937e-001, 3.649925e-001, 3.649913e-001, 3.649901e-001, 3.649889e-001, 3.649877e-001, 3.649865e-001, 3.649853e-001, 3.649841e-001, 
3.649829e-001, 3.649816e-001, 3.649804e-001, 3.649792e-001, 3.649780e-001, 3.649768e-001, 3.649756e-001, 3.649744e-001, 3.649732e-001, 3.649720e-001, 3.649708e-001, 3.649696e-001, 3.649684e-001, 3.649672e-001, 3.649660e-001, 3.649647e-001, 3.649635e-001, 3.649623e-001, 3.649611e-001, 3.649599e-001, 3.649587e-001, 3.649575e-001, 3.649563e-001, 3.649551e-001, 3.649539e-001, 3.649526e-001, 3.649514e-001, 3.649502e-001, 3.649490e-001, 3.649478e-001, 3.649466e-001, 3.649454e-001, 3.649442e-001, 3.649430e-001, 3.649417e-001, 3.649405e-001, 3.649393e-001, 3.649381e-001, 3.649369e-001, 3.649357e-001, 3.649345e-001, 3.649332e-001, 3.649320e-001, 3.649308e-001, 3.649296e-001, 3.649284e-001, 3.649272e-001, 3.649259e-001, 3.649247e-001, 3.649235e-001, 3.649223e-001, 3.649211e-001, 3.649199e-001, 3.649186e-001, 3.649174e-001, 3.649162e-001, 3.649150e-001, 3.649138e-001, 3.649125e-001, 3.649113e-001, 3.649101e-001, 3.649089e-001, 3.649077e-001, 3.649064e-001, 3.649052e-001, 3.649040e-001, 3.649028e-001, 3.649016e-001, 3.649003e-001, 3.648991e-001, 3.648979e-001, 3.648967e-001, 3.648955e-001, 3.648942e-001, 3.648930e-001, 3.648918e-001, 3.648906e-001, 3.648893e-001, 3.648881e-001, 3.648869e-001, 3.648857e-001, 3.648844e-001, 3.648832e-001, 3.648820e-001, 3.648808e-001, 3.648795e-001, 3.648783e-001, 3.648771e-001, 3.648759e-001, 3.648746e-001, 3.648734e-001, 3.648722e-001, 3.648710e-001, 3.648697e-001, 3.648685e-001, 3.648673e-001, 3.648660e-001, 3.648648e-001, 3.648636e-001, 3.648624e-001, 
3.648611e-001, 3.648599e-001, 3.648587e-001, 3.648574e-001, 3.648562e-001, 3.648550e-001, 3.648537e-001, 3.648525e-001, 3.648513e-001, 3.648501e-001, 3.648488e-001, 3.648476e-001, 3.648464e-001, 3.648451e-001, 3.648439e-001, 3.648427e-001, 3.648414e-001, 3.648402e-001, 3.648390e-001, 3.648377e-001, 3.648365e-001, 3.648353e-001, 3.648340e-001, 3.648328e-001, 3.648316e-001, 3.648303e-001, 3.648291e-001, 3.648278e-001, 3.648266e-001, 3.648254e-001, 3.648241e-001, 3.648229e-001, 3.648217e-001, 3.648204e-001, 3.648192e-001, 3.648180e-001, 3.648167e-001, 3.648155e-001, 3.648142e-001, 3.648130e-001, 3.648118e-001, 3.648105e-001, 3.648093e-001, 3.648080e-001, 3.648068e-001, 3.648056e-001, 3.648043e-001, 3.648031e-001, 3.648018e-001, 3.648006e-001, 3.647994e-001, 3.647981e-001, 3.647969e-001, 3.647956e-001, 3.647944e-001, 3.647932e-001, 3.647919e-001, 3.647907e-001, 3.647894e-001, 3.647882e-001, 3.647869e-001, 3.647857e-001, 3.647844e-001, 3.647832e-001, 3.647820e-001, 3.647807e-001, 3.647795e-001, 3.647782e-001, 3.647770e-001, 3.647757e-001, 3.647745e-001, 3.647732e-001, 3.647720e-001, 3.647707e-001, 3.647695e-001, 3.647683e-001, 3.647670e-001, 3.647658e-001, 3.647645e-001, 3.647633e-001, 3.647620e-001, 3.647608e-001, 3.647595e-001, 3.647583e-001, 3.647570e-001, 3.647558e-001, 3.647545e-001, 3.647533e-001, 3.647520e-001, 3.647508e-001, 3.647495e-001, 3.647483e-001, 3.647470e-001, 3.647458e-001, 3.647445e-001, 3.647433e-001, 3.647420e-001, 3.647408e-001, 3.647395e-001, 3.647383e-001, 
3.647370e-001, 3.647357e-001, 3.647345e-001, 3.647332e-001, 3.647320e-001, 3.647307e-001, 3.647295e-001, 3.647282e-001, 3.647270e-001, 3.647257e-001, 3.647245e-001, 3.647232e-001, 3.647219e-001, 3.647207e-001, 3.647194e-001, 3.647182e-001, 3.647169e-001, 3.647157e-001, 3.647144e-001, 3.647131e-001, 3.647119e-001, 3.647106e-001, 3.647094e-001, 3.647081e-001, 3.647068e-001, 3.647056e-001, 3.647043e-001, 3.647031e-001, 3.647018e-001, 3.647006e-001, 3.646993e-001, 3.646980e-001, 3.646968e-001, 3.646955e-001, 3.646942e-001, 3.646930e-001, 3.646917e-001, 3.646905e-001, 3.646892e-001, 3.646879e-001, 3.646867e-001, 3.646854e-001, 3.646841e-001, 3.646829e-001, 3.646816e-001, 3.646804e-001, 3.646791e-001, 3.646778e-001, 3.646766e-001, 3.646753e-001, 3.646740e-001, 3.646728e-001, 3.646715e-001, 3.646702e-001, 3.646690e-001, 3.646677e-001, 3.646664e-001, 3.646652e-001, 3.646639e-001, 3.646626e-001, 3.646614e-001, 3.646601e-001, 3.646588e-001, 3.646576e-001, 3.646563e-001, 3.646550e-001, 3.646538e-001, 3.646525e-001, 3.646512e-001, 3.646499e-001, 3.646487e-001, 3.646474e-001, 3.646461e-001, 3.646449e-001, 3.646436e-001, 3.646423e-001, 3.646411e-001, 3.646398e-001, 3.646385e-001, 3.646372e-001, 3.646360e-001, 3.646347e-001, 3.646334e-001, 3.646321e-001, 3.646309e-001, 3.646296e-001, 3.646283e-001, 3.646271e-001, 3.646258e-001, 3.646245e-001, 3.646232e-001, 3.646220e-001, 3.646207e-001, 3.646194e-001, 3.646181e-001, 3.646169e-001, 3.646156e-001, 3.646143e-001, 3.646130e-001, 3.646117e-001, 
3.646105e-001, 3.646092e-001, 3.646079e-001, 3.646066e-001, 3.646054e-001, 3.646041e-001, 3.646028e-001, 3.646015e-001, 3.646002e-001, 3.645990e-001, 3.645977e-001, 3.645964e-001, 3.645951e-001, 3.645938e-001, 3.645926e-001, 3.645913e-001, 3.645900e-001, 3.645887e-001, 3.645874e-001, 3.645862e-001, 3.645849e-001, 3.645836e-001, 3.645823e-001, 3.645810e-001, 3.645797e-001, 3.645785e-001, 3.645772e-001, 3.645759e-001, 3.645746e-001, 3.645733e-001, 3.645720e-001, 3.645708e-001, 3.645695e-001, 3.645682e-001, 3.645669e-001, 3.645656e-001, 3.645643e-001, 3.645630e-001, 3.645618e-001, 3.645605e-001, 3.645592e-001, 3.645579e-001, 3.645566e-001, 3.645553e-001, 3.645540e-001, 3.645527e-001, 3.645515e-001, 3.645502e-001, 3.645489e-001, 3.645476e-001, 3.645463e-001, 3.645450e-001, 3.645437e-001, 3.645424e-001, 3.645411e-001, 3.645399e-001, 3.645386e-001, 3.645373e-001, 3.645360e-001, 3.645347e-001, 3.645334e-001, 3.645321e-001, 3.645308e-001, 3.645295e-001, 3.645282e-001, 3.645269e-001, 3.645256e-001, 3.645244e-001, 3.645231e-001, 3.645218e-001, 3.645205e-001, 3.645192e-001, 3.645179e-001, 3.645166e-001, 3.645153e-001, 3.645140e-001, 3.645127e-001, 3.645114e-001, 3.645101e-001, 3.645088e-001, 3.645075e-001, 3.645062e-001, 3.645049e-001, 3.645036e-001, 3.645023e-001, 3.645010e-001, 3.644997e-001, 3.644984e-001, 3.644971e-001, 3.644958e-001, 3.644945e-001, 3.644932e-001, 3.644919e-001, 3.644906e-001, 3.644893e-001, 3.644880e-001, 3.644867e-001, 3.644854e-001, 3.644841e-001, 3.644828e-001, 
3.644815e-001, 3.644802e-001, 3.644789e-001, 3.644776e-001, 3.644763e-001, 3.644750e-001, 3.644737e-001, 3.644724e-001, 3.644711e-001, 3.644698e-001, 3.644685e-001, 3.644672e-001, 3.644659e-001, 3.644646e-001, 3.644633e-001, 3.644620e-001, 3.644607e-001, 3.644594e-001, 3.644581e-001, 3.644568e-001, 3.644555e-001, 3.644542e-001, 3.644529e-001, 3.644516e-001, 3.644502e-001, 3.644489e-001, 3.644476e-001, 3.644463e-001, 3.644450e-001, 3.644437e-001, 3.644424e-001, 3.644411e-001, 3.644398e-001, 3.644385e-001, 3.644372e-001, 3.644359e-001, 3.644346e-001, 3.644332e-001, 3.644319e-001, 3.644306e-001, 3.644293e-001, 3.644280e-001, 3.644267e-001, 3.644254e-001, 3.644241e-001, 3.644228e-001, 3.644214e-001, 3.644201e-001, 3.644188e-001, 3.644175e-001, 3.644162e-001, 3.644149e-001, 3.644136e-001, 3.644123e-001, 3.644109e-001, 3.644096e-001, 3.644083e-001, 3.644070e-001, 3.644057e-001, 3.644044e-001, 3.644030e-001, 3.644017e-001, 3.644004e-001, 3.643991e-001, 3.643978e-001, 3.643965e-001, 3.643952e-001, 3.643938e-001, 3.643925e-001, 3.643912e-001, 3.643899e-001, 3.643886e-001, 3.643872e-001, 3.643859e-001, 3.643846e-001, 3.643833e-001, 3.643820e-001, 3.643807e-001, 3.643793e-001, 3.643780e-001, 3.643767e-001, 3.643754e-001, 3.643740e-001, 3.643727e-001, 3.643714e-001, 3.643701e-001, 3.643688e-001, 3.643674e-001, 3.643661e-001, 3.643648e-001, 3.643635e-001, 3.643622e-001, 3.643608e-001, 3.643595e-001, 3.643582e-001, 3.643569e-001, 3.643555e-001, 3.643542e-001, 3.643529e-001, 3.643516e-001, 
3.643502e-001, 3.643489e-001, 3.643476e-001, 3.643463e-001, 3.643449e-001, 3.643436e-001, 3.643423e-001, 3.643410e-001, 3.643396e-001, 3.643383e-001, 3.643370e-001, 3.643356e-001, 3.643343e-001, 3.643330e-001, 3.643317e-001, 3.643303e-001, 3.643290e-001, 3.643277e-001, 3.643263e-001, 3.643250e-001, 3.643237e-001, 3.643224e-001, 3.643210e-001, 3.643197e-001, 3.643184e-001, 3.643170e-001, 3.643157e-001, 3.643144e-001, 3.643130e-001, 3.643117e-001, 3.643104e-001, 3.643090e-001, 3.643077e-001, 3.643064e-001, 3.643051e-001, 3.643037e-001, 3.643024e-001, 3.643011e-001, 3.642997e-001, 3.642984e-001, 3.642970e-001, 3.642957e-001, 3.642944e-001, 3.642930e-001, 3.642917e-001, 3.642904e-001, 3.642890e-001, 3.642877e-001, 3.642864e-001, 3.642850e-001, 3.642837e-001, 3.642824e-001, 3.642810e-001, 3.642797e-001, 3.642783e-001, 3.642770e-001, 3.642757e-001, 3.642743e-001, 3.642730e-001, 3.642716e-001, 3.642703e-001, 3.642690e-001, 3.642676e-001, 3.642663e-001, 3.642650e-001, 3.642636e-001, 3.642623e-001, 3.642609e-001, 3.642596e-001, 3.642582e-001, 3.642569e-001, 3.642556e-001, 3.642542e-001, 3.642529e-001, 3.642515e-001, 3.642502e-001, 3.642489e-001, 3.642475e-001, 3.642462e-001, 3.642448e-001, 3.642435e-001, 3.642421e-001, 3.642408e-001, 3.642394e-001, 3.642381e-001, 3.642368e-001, 3.642354e-001, 3.642341e-001, 3.642327e-001, 3.642314e-001, 3.642300e-001, 3.642287e-001, 3.642273e-001, 3.642260e-001, 3.642246e-001, 3.642233e-001, 3.642219e-001, 3.642206e-001, 3.642192e-001, 3.642179e-001, 
3.642165e-001, 3.642152e-001, 3.642139e-001, 3.642125e-001, 3.642112e-001, 3.642098e-001, 3.642085e-001, 3.642071e-001, 3.642058e-001, 3.642044e-001, 3.642030e-001, 3.642017e-001, 3.642003e-001, 3.641990e-001, 3.641976e-001, 3.641963e-001, 3.641949e-001, 3.641936e-001, 3.641922e-001, 3.641909e-001, 3.641895e-001, 3.641882e-001, 3.641868e-001, 3.641855e-001, 3.641841e-001, 3.641828e-001, 3.641814e-001, 3.641800e-001, 3.641787e-001, 3.641773e-001, 3.641760e-001, 3.641746e-001, 3.641733e-001, 3.641719e-001, 3.641706e-001, 3.641692e-001, 3.641678e-001, 3.641665e-001, 3.641651e-001, 3.641638e-001, 3.641624e-001, 3.641611e-001, 3.641597e-001, 3.641583e-001, 3.641570e-001, 3.641556e-001, 3.641543e-001, 3.641529e-001, 3.641515e-001, 3.641502e-001, 3.641488e-001, 3.641475e-001, 3.641461e-001, 3.641447e-001, 3.641434e-001, 3.641420e-001, 3.641406e-001, 3.641393e-001, 3.641379e-001, 3.641366e-001, 3.641352e-001, 3.641338e-001, 3.641325e-001, 3.641311e-001, 3.641297e-001, 3.641284e-001, 3.641270e-001, 3.641256e-001, 3.641243e-001, 3.641229e-001, 3.641216e-001, 3.641202e-001, 3.641188e-001, 3.641175e-001, 3.641161e-001, 3.641147e-001, 3.641134e-001, 3.641120e-001, 3.641106e-001, 3.641093e-001, 3.641079e-001, 3.641065e-001, 3.641052e-001, 3.641038e-001, 3.641024e-001, 3.641010e-001, 3.640997e-001, 3.640983e-001, 3.640969e-001, 3.640956e-001, 3.640942e-001, 3.640928e-001, 3.640915e-001, 3.640901e-001, 3.640887e-001, 3.640873e-001, 3.640860e-001, 3.640846e-001, 3.640832e-001, 3.640819e-001, 
3.640805e-001, 3.640791e-001, 3.640777e-001, 3.640764e-001, 3.640750e-001, 3.640736e-001, 3.640722e-001, 3.640709e-001, 3.640695e-001, 3.640681e-001, 3.640667e-001, 3.640654e-001, 3.640640e-001, 3.640626e-001, 3.640612e-001, 3.640599e-001, 3.640585e-001, 3.640571e-001, 3.640557e-001, 3.640544e-001, 3.640530e-001, 3.640516e-001, 3.640502e-001, 3.640489e-001, 3.640475e-001, 3.640461e-001, 3.640447e-001, 3.640433e-001, 3.640420e-001, 3.640406e-001, 3.640392e-001, 3.640378e-001, 3.640364e-001, 3.640351e-001, 3.640337e-001, 3.640323e-001, 3.640309e-001, 3.640295e-001, 3.640282e-001, 3.640268e-001, 3.640254e-001, 3.640240e-001, 3.640226e-001, 3.640212e-001, 3.640199e-001, 3.640185e-001, 3.640171e-001, 3.640157e-001, 3.640143e-001, 3.640129e-001, 3.640116e-001, 3.640102e-001, 3.640088e-001, 3.640074e-001, 3.640060e-001, 3.640046e-001, 3.640033e-001, 3.640019e-001, 3.640005e-001, 3.639991e-001, 3.639977e-001, 3.639963e-001, 3.639949e-001, 3.639935e-001, 3.639922e-001, 3.639908e-001, 3.639894e-001, 3.639880e-001, 3.639866e-001, 3.639852e-001, 3.639838e-001, 3.639824e-001, 3.639811e-001, 3.639797e-001, 3.639783e-001, 3.639769e-001, 3.639755e-001, 3.639741e-001, 3.639727e-001, 3.639713e-001, 3.639699e-001, 3.639685e-001, 3.639671e-001, 3.639658e-001, 3.639644e-001, 3.639630e-001, 3.639616e-001, 3.639602e-001, 3.639588e-001, 3.639574e-001, 3.639560e-001, 3.639546e-001, 3.639532e-001, 3.639518e-001, 3.639504e-001, 3.639490e-001, 3.639476e-001, 3.639462e-001, 3.639448e-001, 3.639434e-001, 
3.639421e-001, 3.639407e-001, 3.639393e-001, 3.639379e-001, 3.639365e-001, 3.639351e-001, 3.639337e-001, 3.639323e-001, 3.639309e-001, 3.639295e-001, 3.639281e-001, 3.639267e-001, 3.639253e-001, 3.639239e-001, 3.639225e-001, 3.639211e-001, 3.639197e-001, 3.639183e-001, 3.639169e-001, 3.639155e-001, 3.639141e-001, 3.639127e-001, 3.639113e-001, 3.639099e-001, 3.639085e-001, 3.639071e-001, 3.639057e-001, 3.639043e-001, 3.639029e-001, 3.639015e-001, 3.639001e-001, 3.638987e-001, 3.638973e-001, 3.638958e-001, 3.638944e-001, 3.638930e-001, 3.638916e-001, 3.638902e-001, 3.638888e-001, 3.638874e-001, 3.638860e-001, 3.638846e-001, 3.638832e-001, 3.638818e-001, 3.638804e-001, 3.638790e-001, 3.638776e-001, 3.638762e-001, 3.638748e-001, 3.638734e-001, 3.638719e-001, 3.638705e-001, 3.638691e-001, 3.638677e-001, 3.638663e-001, 3.638649e-001, 3.638635e-001, 3.638621e-001, 3.638607e-001, 3.638593e-001, 3.638579e-001, 3.638564e-001, 3.638550e-001, 3.638536e-001, 3.638522e-001, 3.638508e-001, 3.638494e-001, 3.638480e-001, 3.638466e-001, 3.638452e-001, 3.638437e-001, 3.638423e-001, 3.638409e-001, 3.638395e-001, 3.638381e-001, 3.638367e-001, 3.638353e-001, 3.638338e-001, 3.638324e-001, 3.638310e-001, 3.638296e-001, 3.638282e-001, 3.638268e-001, 3.638254e-001, 3.638239e-001, 3.638225e-001, 3.638211e-001, 3.638197e-001, 3.638183e-001, 3.638169e-001, 3.638154e-001, 3.638140e-001, 3.638126e-001, 3.638112e-001, 3.638098e-001, 3.638083e-001, 3.638069e-001, 3.638055e-001, 3.638041e-001, 3.638027e-001, 
3.638013e-001, 3.637998e-001, 3.637984e-001, 3.637970e-001, 3.637956e-001, 3.637942e-001, 3.637927e-001, 3.637913e-001, 3.637899e-001, 3.637885e-001, 3.637870e-001, 3.637856e-001, 3.637842e-001, 3.637828e-001, 3.637814e-001, 3.637799e-001, 3.637785e-001, 3.637771e-001, 3.637757e-001, 3.637742e-001, 3.637728e-001, 3.637714e-001, 3.637700e-001, 3.637685e-001, 3.637671e-001, 3.637657e-001, 3.637643e-001, 3.637628e-001, 3.637614e-001, 3.637600e-001, 3.637586e-001, 3.637571e-001, 3.637557e-001, 3.637543e-001, 3.637528e-001, 3.637514e-001, 3.637500e-001, 3.637486e-001, 3.637471e-001, 3.637457e-001, 3.637443e-001, 3.637428e-001, 3.637414e-001, 3.637400e-001, 3.637386e-001, 3.637371e-001, 3.637357e-001, 3.637343e-001, 3.637328e-001, 3.637314e-001, 3.637300e-001, 3.637285e-001, 3.637271e-001, 3.637257e-001, 3.637242e-001, 3.637228e-001, 3.637214e-001, 3.637199e-001, 3.637185e-001, 3.637171e-001, 3.637156e-001, 3.637142e-001, 3.637128e-001, 3.637113e-001, 3.637099e-001, 3.637085e-001, 3.637070e-001, 3.637056e-001, 3.637042e-001, 3.637027e-001, 3.637013e-001, 3.636999e-001, 3.636984e-001, 3.636970e-001, 3.636955e-001, 3.636941e-001, 3.636927e-001, 3.636912e-001, 3.636898e-001, 3.636884e-001, 3.636869e-001, 3.636855e-001, 3.636840e-001, 3.636826e-001, 3.636812e-001, 3.636797e-001, 3.636783e-001, 3.636768e-001, 3.636754e-001, 3.636740e-001, 3.636725e-001, 3.636711e-001, 3.636696e-001, 3.636682e-001, 3.636668e-001, 3.636653e-001, 3.636639e-001, 3.636624e-001, 3.636610e-001, 3.636595e-001, 
3.636581e-001, 3.636567e-001, 3.636552e-001, 3.636538e-001, 3.636523e-001, 3.636509e-001, 3.636494e-001, 3.636480e-001, 3.636465e-001, 3.636451e-001, 3.636437e-001, 3.636422e-001, 3.636408e-001, 3.636393e-001, 3.636379e-001, 3.636364e-001, 3.636350e-001, 3.636335e-001, 3.636321e-001, 3.636306e-001, 3.636292e-001, 3.636277e-001, 3.636263e-001, 3.636248e-001, 3.636234e-001, 3.636219e-001, 3.636205e-001, 3.636190e-001, 3.636176e-001, 3.636161e-001, 3.636147e-001, 3.636132e-001, 3.636118e-001, 3.636103e-001, 3.636089e-001, 3.636074e-001, 3.636060e-001, 3.636045e-001, 3.636031e-001, 3.636016e-001, 3.636002e-001, 3.635987e-001, 3.635973e-001, 3.635958e-001, 3.635944e-001, 3.635929e-001, 3.635915e-001, 3.635900e-001, 3.635885e-001, 3.635871e-001, 3.635856e-001, 3.635842e-001, 3.635827e-001, 3.635813e-001, 3.635798e-001, 3.635784e-001, 3.635769e-001, 3.635754e-001, 3.635740e-001, 3.635725e-001, 3.635711e-001, 3.635696e-001, 3.635682e-001, 3.635667e-001, 3.635652e-001, 3.635638e-001, 3.635623e-001, 3.635609e-001, 3.635594e-001, 3.635579e-001, 3.635565e-001, 3.635550e-001, 3.635536e-001, 3.635521e-001, 3.635506e-001, 3.635492e-001, 3.635477e-001, 3.635463e-001, 3.635448e-001, 3.635433e-001, 3.635419e-001, 3.635404e-001, 3.635390e-001, 3.635375e-001, 3.635360e-001, 3.635346e-001, 3.635331e-001, 3.635316e-001, 3.635302e-001, 3.635287e-001, 3.635272e-001, 3.635258e-001, 3.635243e-001, 3.635228e-001, 3.635214e-001, 3.635199e-001, 3.635185e-001, 3.635170e-001, 3.635155e-001, 3.635141e-001, 
3.635126e-001, 3.635111e-001, 3.635097e-001, 3.635082e-001, 3.635067e-001, 3.635053e-001, 3.635038e-001, 3.635023e-001, 3.635008e-001, 3.634994e-001, 3.634979e-001, 3.634964e-001, 3.634950e-001, 3.634935e-001, 3.634920e-001, 3.634906e-001, 3.634891e-001, 3.634876e-001, 3.634861e-001, 3.634847e-001, 3.634832e-001, 3.634817e-001, 3.634803e-001, 3.634788e-001, 3.634773e-001, 3.634758e-001, 3.634744e-001, 3.634729e-001, 3.634714e-001, 3.634700e-001, 3.634685e-001, 3.634670e-001, 3.634655e-001, 3.634641e-001, 3.634626e-001, 3.634611e-001, 3.634596e-001, 3.634582e-001, 3.634567e-001, 3.634552e-001, 3.634537e-001, 3.634522e-001, 3.634508e-001, 3.634493e-001, 3.634478e-001, 3.634463e-001, 3.634449e-001, 3.634434e-001, 3.634419e-001, 3.634404e-001, 3.634390e-001, 3.634375e-001, 3.634360e-001, 3.634345e-001, 3.634330e-001, 3.634316e-001, 3.634301e-001, 3.634286e-001, 3.634271e-001, 3.634256e-001, 3.634242e-001, 3.634227e-001, 3.634212e-001, 3.634197e-001, 3.634182e-001, 3.634167e-001, 3.634153e-001, 3.634138e-001, 3.634123e-001, 3.634108e-001, 3.634093e-001, 3.634079e-001, 3.634064e-001, 3.634049e-001, 3.634034e-001, 3.634019e-001, 3.634004e-001, 3.633989e-001, 3.633975e-001, 3.633960e-001, 3.633945e-001, 3.633930e-001, 3.633915e-001, 3.633900e-001, 3.633885e-001, 3.633871e-001, 3.633856e-001, 3.633841e-001, 3.633826e-001, 3.633811e-001, 3.633796e-001, 3.633781e-001, 3.633766e-001, 3.633752e-001, 3.633737e-001, 3.633722e-001, 3.633707e-001, 3.633692e-001, 3.633677e-001, 3.633662e-001, 
3.633647e-001, 3.633632e-001, 3.633617e-001, 3.633603e-001, 3.633588e-001, 3.633573e-001, 3.633558e-001, 3.633543e-001, 3.633528e-001, 3.633513e-001, 3.633498e-001, 3.633483e-001, 3.633468e-001, 3.633453e-001, 3.633438e-001, 3.633423e-001, 3.633409e-001, 3.633394e-001, 3.633379e-001, 3.633364e-001, 3.633349e-001, 3.633334e-001, 3.633319e-001, 3.633304e-001, 3.633289e-001, 3.633274e-001, 3.633259e-001, 3.633244e-001, 3.633229e-001, 3.633214e-001, 3.633199e-001, 3.633184e-001, 3.633169e-001, 3.633154e-001, 3.633139e-001, 3.633124e-001, 3.633109e-001, 3.633094e-001, 3.633079e-001, 3.633064e-001, 3.633049e-001, 3.633034e-001, 3.633019e-001, 3.633004e-001, 3.632989e-001, 3.632974e-001, 3.632959e-001, 3.632944e-001, 3.632929e-001, 3.632914e-001, 3.632899e-001, 3.632884e-001, 3.632869e-001, 3.632854e-001, 3.632839e-001, 3.632824e-001, 3.632809e-001, 3.632794e-001, 3.632779e-001, 3.632764e-001, 3.632749e-001, 3.632734e-001, 3.632719e-001, 3.632704e-001, 3.632689e-001, 3.632674e-001, 3.632659e-001, 3.632644e-001, 3.632628e-001, 3.632613e-001, 3.632598e-001, 3.632583e-001, 3.632568e-001, 3.632553e-001, 3.632538e-001, 3.632523e-001, 3.632508e-001, 3.632493e-001, 3.632478e-001, 3.632463e-001, 3.632448e-001, 3.632432e-001, 3.632417e-001, 3.632402e-001, 3.632387e-001, 3.632372e-001, 3.632357e-001, 3.632342e-001, 3.632327e-001, 3.632312e-001, 3.632297e-001, 3.632281e-001, 3.632266e-001, 3.632251e-001, 3.632236e-001, 3.632221e-001, 3.632206e-001, 3.632191e-001, 3.632176e-001, 3.632160e-001, 
3.632145e-001, 3.632130e-001, 3.632115e-001, 3.632100e-001, 3.632085e-001, 3.632070e-001, 3.632054e-001, 3.632039e-001, 3.632024e-001, 3.632009e-001, 3.631994e-001, 3.631979e-001, 3.631964e-001, 3.631948e-001, 3.631933e-001, 3.631918e-001, 3.631903e-001, 3.631888e-001, 3.631872e-001, 3.631857e-001, 3.631842e-001, 3.631827e-001, 3.631812e-001, 3.631797e-001, 3.631781e-001, 3.631766e-001, 3.631751e-001, 3.631736e-001, 3.631721e-001, 3.631705e-001, 3.631690e-001, 3.631675e-001, 3.631660e-001, 3.631645e-001, 3.631629e-001, 3.631614e-001, 3.631599e-001, 3.631584e-001, 3.631568e-001, 3.631553e-001, 3.631538e-001, 3.631523e-001, 3.631508e-001, 3.631492e-001, 3.631477e-001, 3.631462e-001, 3.631447e-001, 3.631431e-001, 3.631416e-001, 3.631401e-001, 3.631386e-001, 3.631370e-001, 3.631355e-001, 3.631340e-001, 3.631325e-001, 3.631309e-001, 3.631294e-001, 3.631279e-001, 3.631263e-001, 3.631248e-001, 3.631233e-001, 3.631218e-001, 3.631202e-001, 3.631187e-001, 3.631172e-001, 3.631156e-001, 3.631141e-001, 3.631126e-001, 3.631111e-001, 3.631095e-001, 3.631080e-001, 3.631065e-001, 3.631049e-001, 3.631034e-001, 3.631019e-001, 3.631003e-001, 3.630988e-001, 3.630973e-001, 3.630958e-001, 3.630942e-001, 3.630927e-001, 3.630912e-001, 3.630896e-001, 3.630881e-001, 3.630866e-001, 3.630850e-001, 3.630835e-001, 3.630820e-001, 3.630804e-001, 3.630789e-001, 3.630774e-001, 3.630758e-001, 3.630743e-001, 3.630727e-001, 3.630712e-001, 3.630697e-001, 3.630681e-001, 3.630666e-001, 3.630651e-001, 3.630635e-001, 
3.630620e-001, 3.630605e-001, 3.630589e-001, 3.630574e-001, 3.630558e-001, 3.630543e-001, 3.630528e-001, 3.630512e-001, 3.630497e-001, 3.630482e-001, 3.630466e-001, 3.630451e-001, 3.630435e-001, 3.630420e-001, 3.630405e-001, 3.630389e-001, 3.630374e-001, 3.630358e-001, 3.630343e-001, 3.630328e-001, 3.630312e-001, 3.630297e-001, 3.630281e-001, 3.630266e-001, 3.630250e-001, 3.630235e-001, 3.630220e-001, 3.630204e-001, 3.630189e-001, 3.630173e-001, 3.630158e-001, 3.630142e-001, 3.630127e-001, 3.630111e-001, 3.630096e-001, 3.630081e-001, 3.630065e-001, 3.630050e-001, 3.630034e-001, 3.630019e-001, 3.630003e-001, 3.629988e-001, 3.629972e-001, 3.629957e-001, 3.629941e-001, 3.629926e-001, 3.629910e-001, 3.629895e-001, 3.629880e-001, 3.629864e-001, 3.629849e-001, 3.629833e-001, 3.629818e-001, 3.629802e-001, 3.629787e-001, 3.629771e-001, 3.629756e-001, 3.629740e-001, 3.629725e-001, 3.629709e-001, 3.629694e-001, 3.629678e-001, 3.629663e-001, 3.629647e-001, 3.629632e-001, 3.629616e-001, 3.629600e-001, 3.629585e-001, 3.629569e-001, 3.629554e-001, 3.629538e-001, 3.629523e-001, 3.629507e-001, 3.629492e-001, 3.629476e-001, 3.629461e-001, 3.629445e-001, 3.629430e-001, 3.629414e-001, 3.629398e-001, 3.629383e-001, 3.629367e-001, 3.629352e-001, 3.629336e-001, 3.629321e-001, 3.629305e-001, 3.629290e-001, 3.629274e-001, 3.629258e-001, 3.629243e-001, 3.629227e-001, 3.629212e-001, 3.629196e-001, 3.629180e-001, 3.629165e-001, 3.629149e-001, 3.629134e-001, 3.629118e-001, 3.629103e-001, 3.629087e-001, 
3.629071e-001, 3.629056e-001, 3.629040e-001, 3.629024e-001, 3.629009e-001, 3.628993e-001, 3.628978e-001, 3.628962e-001, 3.628946e-001, 3.628931e-001, 3.628915e-001, 3.628900e-001, 3.628884e-001, 3.628868e-001, 3.628853e-001, 3.628837e-001, 3.628821e-001, 3.628806e-001, 3.628790e-001, 3.628774e-001, 3.628759e-001, 3.628743e-001, 3.628727e-001, 3.628712e-001, 3.628696e-001, 3.628681e-001, 3.628665e-001, 3.628649e-001, 3.628634e-001, 3.628618e-001, 3.628602e-001, 3.628586e-001, 3.628571e-001, 3.628555e-001, 3.628539e-001, 3.628524e-001, 3.628508e-001, 3.628492e-001, 3.628477e-001, 3.628461e-001, 3.628445e-001, 3.628430e-001, 3.628414e-001, 3.628398e-001, 3.628383e-001, 3.628367e-001, 3.628351e-001, 3.628335e-001, 3.628320e-001, 3.628304e-001, 3.628288e-001, 3.628273e-001, 3.628257e-001, 3.628241e-001, 3.628225e-001, 3.628210e-001, 3.628194e-001, 3.628178e-001, 3.628162e-001, 3.628147e-001, 3.628131e-001, 3.628115e-001, 3.628099e-001, 3.628084e-001, 3.628068e-001, 3.628052e-001, 3.628036e-001, 3.628021e-001, 3.628005e-001, 3.627989e-001, 3.627973e-001, 3.627958e-001, 3.627942e-001, 3.627926e-001, 3.627910e-001, 3.627895e-001, 3.627879e-001, 3.627863e-001, 3.627847e-001, 3.627831e-001, 3.627816e-001, 3.627800e-001, 3.627784e-001, 3.627768e-001, 3.627752e-001, 3.627737e-001, 3.627721e-001, 3.627705e-001, 3.627689e-001, 3.627673e-001, 3.627658e-001, 3.627642e-001, 3.627626e-001, 3.627610e-001, 3.627594e-001, 3.627579e-001, 3.627563e-001, 3.627547e-001, 3.627531e-001, 3.627515e-001, 
3.627499e-001, 3.627484e-001, 3.627468e-001, 3.627452e-001, 3.627436e-001, 3.627420e-001, 3.627404e-001, 3.627388e-001, 3.627373e-001, 3.627357e-001, 3.627341e-001, 3.627325e-001, 3.627309e-001, 3.627293e-001, 3.627277e-001, 3.627262e-001, 3.627246e-001, 3.627230e-001, 3.627214e-001, 3.627198e-001, 3.627182e-001, 3.627166e-001, 3.627150e-001, 3.627135e-001, 3.627119e-001, 3.627103e-001, 3.627087e-001, 3.627071e-001, 3.627055e-001, 3.627039e-001, 3.627023e-001, 3.627007e-001, 3.626991e-001, 3.626976e-001, 3.626960e-001, 3.626944e-001, 3.626928e-001, 3.626912e-001, 3.626896e-001, 3.626880e-001, 3.626864e-001, 3.626848e-001, 3.626832e-001, 3.626816e-001, 3.626800e-001, 3.626784e-001, 3.626769e-001, 3.626753e-001, 3.626737e-001, 3.626721e-001, 3.626705e-001, 3.626689e-001, 3.626673e-001, 3.626657e-001, 3.626641e-001, 3.626625e-001, 3.626609e-001, 3.626593e-001, 3.626577e-001, 3.626561e-001, 3.626545e-001, 3.626529e-001, 3.626513e-001, 3.626497e-001, 3.626481e-001, 3.626465e-001, 3.626449e-001, 3.626433e-001, 3.626417e-001, 3.626401e-001, 3.626385e-001, 3.626369e-001, 3.626353e-001, 3.626337e-001, 3.626321e-001, 3.626305e-001, 3.626289e-001, 3.626273e-001, 3.626257e-001, 3.626241e-001, 3.626225e-001, 3.626209e-001, 3.626193e-001, 3.626177e-001, 3.626161e-001, 3.626145e-001, 3.626129e-001, 3.626113e-001, 3.626097e-001, 3.626081e-001, 3.626065e-001, 3.626049e-001, 3.626033e-001, 3.626017e-001, 3.626001e-001, 3.625985e-001, 3.625969e-001, 3.625952e-001, 3.625936e-001, 3.625920e-001, 
3.625904e-001, 3.625888e-001, 3.625872e-001, 3.625856e-001, 3.625840e-001, 3.625824e-001, 3.625808e-001, 3.625792e-001, 3.625776e-001, 3.625760e-001, 3.625743e-001, 3.625727e-001, 3.625711e-001, 3.625695e-001, 3.625679e-001, 3.625663e-001, 3.625647e-001, 3.625631e-001, 3.625615e-001, 3.625599e-001, 3.625582e-001, 3.625566e-001, 3.625550e-001, 3.625534e-001, 3.625518e-001, 3.625502e-001, 3.625486e-001, 3.625470e-001, 3.625453e-001, 3.625437e-001, 3.625421e-001, 3.625405e-001, 3.625389e-001, 3.625373e-001, 3.625357e-001, 3.625341e-001, 3.625324e-001, 3.625308e-001, 3.625292e-001, 3.625276e-001, 3.625260e-001, 3.625244e-001, 3.625227e-001, 3.625211e-001, 3.625195e-001, 3.625179e-001, 3.625163e-001, 3.625147e-001, 3.625130e-001, 3.625114e-001, 3.625098e-001, 3.625082e-001, 3.625066e-001, 3.625049e-001, 3.625033e-001, 3.625017e-001, 3.625001e-001, 3.624985e-001, 3.624968e-001, 3.624952e-001, 3.624936e-001, 3.624920e-001, 3.624904e-001, 3.624887e-001, 3.624871e-001, 3.624855e-001, 3.624839e-001, 3.624823e-001, 3.624806e-001, 3.624790e-001, 3.624774e-001, 3.624758e-001, 3.624741e-001, 3.624725e-001, 3.624709e-001, 3.624693e-001, 3.624676e-001, 3.624660e-001, 3.624644e-001, 3.624628e-001, 3.624611e-001, 3.624595e-001, 3.624579e-001, 3.624563e-001, 3.624546e-001, 3.624530e-001, 3.624514e-001, 3.624498e-001, 3.624481e-001, 3.624465e-001, 3.624449e-001, 3.624433e-001, 3.624416e-001, 3.624400e-001, 3.624384e-001, 3.624367e-001, 3.624351e-001, 3.624335e-001, 3.624319e-001, 3.624302e-001, 
3.624286e-001, 3.624270e-001, 3.624253e-001, 3.624237e-001, 3.624221e-001, 3.624204e-001, 3.624188e-001, 3.624172e-001, 3.624156e-001, 3.624139e-001, 3.624123e-001, 3.624107e-001, 3.624090e-001, 3.624074e-001, 3.624058e-001, 3.624041e-001, 3.624025e-001, 3.624009e-001, 3.623992e-001, 3.623976e-001, 3.623960e-001, 3.623943e-001, 3.623927e-001, 3.623911e-001, 3.623894e-001, 3.623878e-001, 3.623861e-001, 3.623845e-001, 3.623829e-001, 3.623812e-001, 3.623796e-001, 3.623780e-001, 3.623763e-001, 3.623747e-001, 3.623731e-001, 3.623714e-001, 3.623698e-001, 3.623681e-001, 3.623665e-001, 3.623649e-001, 3.623632e-001, 3.623616e-001, 3.623599e-001, 3.623583e-001, 3.623567e-001, 3.623550e-001, 3.623534e-001, 3.623517e-001, 3.623501e-001, 3.623485e-001, 3.623468e-001, 3.623452e-001, 3.623435e-001, 3.623419e-001, 3.623403e-001, 3.623386e-001, 3.623370e-001, 3.623353e-001, 3.623337e-001, 3.623320e-001, 3.623304e-001, 3.623288e-001, 3.623271e-001, 3.623255e-001, 3.623238e-001, 3.623222e-001, 3.623205e-001, 3.623189e-001, 3.623172e-001, 3.623156e-001, 3.623139e-001, 3.623123e-001, 3.623107e-001, 3.623090e-001, 3.623074e-001, 3.623057e-001, 3.623041e-001, 3.623024e-001, 3.623008e-001, 3.622991e-001, 3.622975e-001, 3.622958e-001, 3.622942e-001, 3.622925e-001, 3.622909e-001, 3.622892e-001, 3.622876e-001, 3.622859e-001, 3.622843e-001, 3.622826e-001, 3.622810e-001, 3.622793e-001, 3.622777e-001, 3.622760e-001, 3.622744e-001, 3.622727e-001, 3.622711e-001, 3.622694e-001, 3.622678e-001, 3.622661e-001, 
3.622645e-001, 3.622628e-001, 3.622612e-001, 3.622595e-001, 3.622578e-001, 3.622562e-001, 3.622545e-001, 3.622529e-001, 3.622512e-001, 3.622496e-001, 3.622479e-001, 3.622463e-001, 3.622446e-001, 3.622430e-001, 3.622413e-001, 3.622396e-001, 3.622380e-001, 3.622363e-001, 3.622347e-001, 3.622330e-001, 3.622314e-001, 3.622297e-001, 3.622280e-001, 3.622264e-001, 3.622247e-001, 3.622231e-001, 3.622214e-001, 3.622198e-001, 3.622181e-001, 3.622164e-001, 3.622148e-001, 3.622131e-001, 3.622115e-001, 3.622098e-001, 3.622081e-001, 3.622065e-001, 3.622048e-001, 3.622031e-001, 3.622015e-001, 3.621998e-001, 3.621982e-001, 3.621965e-001, 3.621948e-001, 3.621932e-001, 3.621915e-001, 3.621898e-001, 3.621882e-001, 3.621865e-001, 3.621849e-001, 3.621832e-001, 3.621815e-001, 3.621799e-001, 3.621782e-001, 3.621765e-001, 3.621749e-001, 3.621732e-001, 3.621715e-001, 3.621699e-001, 3.621682e-001, 3.621665e-001, 3.621649e-001, 3.621632e-001, 3.621615e-001, 3.621599e-001, 3.621582e-001, 3.621565e-001, 3.621549e-001, 3.621532e-001, 3.621515e-001, 3.621499e-001, 3.621482e-001, 3.621465e-001, 3.621449e-001, 3.621432e-001, 3.621415e-001, 3.621398e-001, 3.621382e-001, 3.621365e-001, 3.621348e-001, 3.621332e-001, 3.621315e-001, 3.621298e-001, 3.621282e-001, 3.621265e-001, 3.621248e-001, 3.621231e-001, 3.621215e-001, 3.621198e-001, 3.621181e-001, 3.621164e-001, 3.621148e-001, 3.621131e-001, 3.621114e-001, 3.621097e-001, 3.621081e-001, 3.621064e-001, 3.621047e-001, 3.621030e-001, 3.621014e-001, 3.620997e-001, 
3.620980e-001, 3.620963e-001, 3.620947e-001, 3.620930e-001, 3.620913e-001, 3.620896e-001, 3.620880e-001, 3.620863e-001, 3.620846e-001, 3.620829e-001, 3.620813e-001, 3.620796e-001, 3.620779e-001, 3.620762e-001, 3.620745e-001, 3.620729e-001, 3.620712e-001, 3.620695e-001, 3.620678e-001, 3.620661e-001, 3.620645e-001, 3.620628e-001, 3.620611e-001, 3.620594e-001, 3.620577e-001, 3.620561e-001, 3.620544e-001, 3.620527e-001, 3.620510e-001, 3.620493e-001, 3.620476e-001, 3.620460e-001, 3.620443e-001, 3.620426e-001, 3.620409e-001, 3.620392e-001, 3.620375e-001, 3.620359e-001, 3.620342e-001, 3.620325e-001, 3.620308e-001, 3.620291e-001, 3.620274e-001, 3.620257e-001, 3.620241e-001, 3.620224e-001, 3.620207e-001, 3.620190e-001, 3.620173e-001, 3.620156e-001, 3.620139e-001, 3.620123e-001, 3.620106e-001, 3.620089e-001, 3.620072e-001, 3.620055e-001, 3.620038e-001, 3.620021e-001, 3.620004e-001, 3.619987e-001, 3.619971e-001, 3.619954e-001, 3.619937e-001, 3.619920e-001, 3.619903e-001, 3.619886e-001, 3.619869e-001, 3.619852e-001, 3.619835e-001, 3.619818e-001, 3.619801e-001, 3.619785e-001, 3.619768e-001, 3.619751e-001, 3.619734e-001, 3.619717e-001, 3.619700e-001, 3.619683e-001, 3.619666e-001, 3.619649e-001, 3.619632e-001, 3.619615e-001, 3.619598e-001, 3.619581e-001, 3.619564e-001, 3.619547e-001, 3.619530e-001, 3.619513e-001, 3.619497e-001, 3.619480e-001, 3.619463e-001, 3.619446e-001, 3.619429e-001, 3.619412e-001, 3.619395e-001, 3.619378e-001, 3.619361e-001, 3.619344e-001, 3.619327e-001, 3.619310e-001, 
3.619293e-001, 3.619276e-001, 3.619259e-001, 3.619242e-001, 3.619225e-001, 3.619208e-001, 3.619191e-001, 3.619174e-001, 3.619157e-001, 3.619140e-001, 3.619123e-001, 3.619106e-001, 3.619089e-001, 3.619072e-001, 3.619055e-001, 3.619038e-001, 3.619021e-001, 3.619004e-001, 3.618987e-001, 3.618970e-001, 3.618953e-001, 3.618936e-001, 3.618919e-001, 3.618901e-001, 3.618884e-001, 3.618867e-001, 3.618850e-001, 3.618833e-001, 3.618816e-001, 3.618799e-001, 3.618782e-001, 3.618765e-001, 3.618748e-001, 3.618731e-001, 3.618714e-001, 3.618697e-001, 3.618680e-001, 3.618663e-001, 3.618646e-001, 3.618629e-001, 3.618611e-001, 3.618594e-001, 3.618577e-001, 3.618560e-001, 3.618543e-001, 3.618526e-001, 3.618509e-001, 3.618492e-001, 3.618475e-001, 3.618458e-001, 3.618441e-001, 3.618423e-001, 3.618406e-001, 3.618389e-001, 3.618372e-001, 3.618355e-001, 3.618338e-001, 3.618321e-001, 3.618304e-001, 3.618287e-001, 3.618269e-001, 3.618252e-001, 3.618235e-001, 3.618218e-001, 3.618201e-001, 3.618184e-001, 3.618167e-001, 3.618149e-001, 3.618132e-001, 3.618115e-001, 3.618098e-001, 3.618081e-001, 3.618064e-001, 3.618047e-001, 3.618029e-001, 3.618012e-001, 3.617995e-001, 3.617978e-001, 3.617961e-001, 3.617944e-001, 3.617926e-001, 3.617909e-001, 3.617892e-001, 3.617875e-001, 3.617858e-001, 3.617841e-001, 3.617823e-001, 3.617806e-001, 3.617789e-001, 3.617772e-001, 3.617755e-001, 3.617737e-001, 3.617720e-001, 3.617703e-001, 3.617686e-001, 3.617669e-001, 3.617651e-001, 3.617634e-001, 3.617617e-001, 3.617600e-001, 
3.617583e-001, 3.617565e-001, 3.617548e-001, 3.617531e-001, 3.617514e-001, 3.617496e-001, 3.617479e-001, 3.617462e-001, 3.617445e-001, 3.617427e-001, 3.617410e-001, 3.617393e-001, 3.617376e-001, 3.617358e-001, 3.617341e-001, 3.617324e-001, 3.617307e-001, 3.617289e-001, 3.617272e-001, 3.617255e-001, 3.617238e-001, 3.617220e-001, 3.617203e-001, 3.617186e-001, 3.617169e-001, 3.617151e-001, 3.617134e-001, 3.617117e-001, 3.617100e-001, 3.617082e-001, 3.617065e-001, 3.617048e-001, 3.617030e-001, 3.617013e-001, 3.616996e-001, 3.616978e-001, 3.616961e-001, 3.616944e-001, 3.616927e-001, 3.616909e-001, 3.616892e-001, 3.616875e-001, 3.616857e-001, 3.616840e-001, 3.616823e-001, 3.616805e-001, 3.616788e-001, 3.616771e-001, 3.616753e-001, 3.616736e-001, 3.616719e-001, 3.616701e-001, 3.616684e-001, 3.616667e-001, 3.616649e-001, 3.616632e-001, 3.616615e-001, 3.616597e-001, 3.616580e-001, 3.616563e-001, 3.616545e-001, 3.616528e-001, 3.616511e-001, 3.616493e-001, 3.616476e-001, 3.616459e-001, 3.616441e-001, 3.616424e-001, 3.616406e-001, 3.616389e-001, 3.616372e-001, 3.616354e-001, 3.616337e-001, 3.616320e-001, 3.616302e-001, 3.616285e-001, 3.616267e-001, 3.616250e-001, 3.616233e-001, 3.616215e-001, 3.616198e-001, 3.616180e-001, 3.616163e-001, 3.616146e-001, 3.616128e-001, 3.616111e-001, 3.616093e-001, 3.616076e-001, 3.616058e-001, 3.616041e-001, 3.616024e-001, 3.616006e-001, 3.615989e-001, 3.615971e-001, 3.615954e-001, 3.615936e-001, 3.615919e-001, 3.615902e-001, 3.615884e-001, 3.615867e-001, 
3.615849e-001, 3.615832e-001, 3.615814e-001, 3.615797e-001, 3.615779e-001, 3.615762e-001, 3.615745e-001, 3.615727e-001, 3.615710e-001, 3.615692e-001, 3.615675e-001, 3.615657e-001, 3.615640e-001, 3.615622e-001, 3.615605e-001, 3.615587e-001, 3.615570e-001, 3.615552e-001, 3.615535e-001, 3.615517e-001, 3.615500e-001, 3.615482e-001, 3.615465e-001, 3.615447e-001, 3.615430e-001, 3.615412e-001, 3.615395e-001, 3.615377e-001, 3.615360e-001, 3.615342e-001, 3.615325e-001, 3.615307e-001, 3.615290e-001, 3.615272e-001, 3.615255e-001, 3.615237e-001, 3.615220e-001, 3.615202e-001, 3.615185e-001, 3.615167e-001, 3.615150e-001, 3.615132e-001, 3.615115e-001, 3.615097e-001, 3.615079e-001, 3.615062e-001, 3.615044e-001, 3.615027e-001, 3.615009e-001, 3.614992e-001, 3.614974e-001, 3.614957e-001, 3.614939e-001, 3.614921e-001, 3.614904e-001, 3.614886e-001, 3.614869e-001, 3.614851e-001, 3.614834e-001, 3.614816e-001, 3.614798e-001, 3.614781e-001, 3.614763e-001, 3.614746e-001, 3.614728e-001, 3.614710e-001, 3.614693e-001, 3.614675e-001, 3.614658e-001, 3.614640e-001, 3.614622e-001, 3.614605e-001, 3.614587e-001, 3.614570e-001, 3.614552e-001, 3.614534e-001, 3.614517e-001, 3.614499e-001, 3.614482e-001, 3.614464e-001, 3.614446e-001, 3.614429e-001, 3.614411e-001, 3.614393e-001, 3.614376e-001, 3.614358e-001, 3.614340e-001, 3.614323e-001, 3.614305e-001, 3.614288e-001, 3.614270e-001, 3.614252e-001, 3.614235e-001, 3.614217e-001, 3.614199e-001, 3.614182e-001, 3.614164e-001, 3.614146e-001, 3.614129e-001, 3.614111e-001, 
3.614093e-001, 3.614076e-001, 3.614058e-001, 3.614040e-001, 3.614023e-001, 3.614005e-001, 3.613987e-001, 3.613969e-001, 3.613952e-001, 3.613934e-001, 3.613916e-001, 3.613899e-001, 3.613881e-001, 3.613863e-001, 3.613846e-001, 3.613828e-001, 3.613810e-001, 3.613792e-001, 3.613775e-001, 3.613757e-001, 3.613739e-001, 3.613722e-001, 3.613704e-001, 3.613686e-001, 3.613668e-001, 3.613651e-001, 3.613633e-001, 3.613615e-001, 3.613597e-001, 3.613580e-001, 3.613562e-001, 3.613544e-001, 3.613527e-001, 3.613509e-001, 3.613491e-001, 3.613473e-001, 3.613455e-001, 3.613438e-001, 3.613420e-001, 3.613402e-001, 3.613384e-001, 3.613367e-001, 3.613349e-001, 3.613331e-001, 3.613313e-001, 3.613296e-001, 3.613278e-001, 3.613260e-001, 3.613242e-001, 3.613224e-001, 3.613207e-001, 3.613189e-001, 3.613171e-001, 3.613153e-001, 3.613136e-001, 3.613118e-001, 3.613100e-001, 3.613082e-001, 3.613064e-001, 3.613046e-001, 3.613029e-001, 3.613011e-001, 3.612993e-001, 3.612975e-001, 3.612957e-001, 3.612940e-001, 3.612922e-001, 3.612904e-001, 3.612886e-001, 3.612868e-001, 3.612850e-001, 3.612833e-001, 3.612815e-001, 3.612797e-001, 3.612779e-001, 3.612761e-001, 3.612743e-001, 3.612726e-001, 3.612708e-001, 3.612690e-001, 3.612672e-001, 3.612654e-001, 3.612636e-001, 3.612618e-001, 3.612601e-001, 3.612583e-001, 3.612565e-001, 3.612547e-001, 3.612529e-001, 3.612511e-001, 3.612493e-001, 3.612475e-001, 3.612458e-001, 3.612440e-001, 3.612422e-001, 3.612404e-001, 3.612386e-001, 3.612368e-001, 3.612350e-001, 3.612332e-001, 
3.612314e-001, 3.612297e-001, 3.612279e-001, 3.612261e-001, 3.612243e-001, 3.612225e-001, 3.612207e-001, 3.612189e-001, 3.612171e-001, 3.612153e-001, 3.612135e-001, 3.612117e-001, 3.612099e-001, 3.612082e-001, 3.612064e-001, 3.612046e-001, 3.612028e-001, 3.612010e-001, 3.611992e-001, 3.611974e-001, 3.611956e-001, 3.611938e-001, 3.611920e-001, 3.611902e-001, 3.611884e-001, 3.611866e-001, 3.611848e-001, 3.611830e-001, 3.611812e-001, 3.611794e-001, 3.611776e-001, 3.611758e-001, 3.611740e-001, 3.611722e-001, 3.611704e-001, 3.611686e-001, 3.611668e-001, 3.611651e-001, 3.611633e-001, 3.611615e-001, 3.611597e-001, 3.611579e-001, 3.611561e-001, 3.611543e-001, 3.611525e-001, 3.611507e-001, 3.611489e-001, 3.611471e-001, 3.611453e-001, 3.611435e-001, 3.611416e-001, 3.611398e-001, 3.611380e-001, 3.611362e-001, 3.611344e-001, 3.611326e-001, 3.611308e-001, 3.611290e-001, 3.611272e-001, 3.611254e-001, 3.611236e-001, 3.611218e-001, 3.611200e-001, 3.611182e-001, 3.611164e-001, 3.611146e-001, 3.611128e-001, 3.611110e-001, 3.611092e-001, 3.611074e-001, 3.611056e-001, 3.611038e-001, 3.611020e-001, 3.611002e-001, 3.610983e-001, 3.610965e-001, 3.610947e-001, 3.610929e-001, 3.610911e-001, 3.610893e-001, 3.610875e-001, 3.610857e-001, 3.610839e-001, 3.610821e-001, 3.610803e-001, 3.610785e-001, 3.610766e-001, 3.610748e-001, 3.610730e-001, 3.610712e-001, 3.610694e-001, 3.610676e-001, 3.610658e-001, 3.610640e-001, 3.610622e-001, 3.610603e-001, 3.610585e-001, 3.610567e-001, 3.610549e-001, 3.610531e-001, 
3.610513e-001, 3.610495e-001, 3.610477e-001, 3.610458e-001, 3.610440e-001, 3.610422e-001, 3.610404e-001, 3.610386e-001, 3.610368e-001, 3.610350e-001, 3.610331e-001, 3.610313e-001, 3.610295e-001, 3.610277e-001, 3.610259e-001, 3.610241e-001, 3.610223e-001, 3.610204e-001, 3.610186e-001, 3.610168e-001, 3.610150e-001, 3.610132e-001, 3.610113e-001, 3.610095e-001, 3.610077e-001, 3.610059e-001, 3.610041e-001, 3.610023e-001, 3.610004e-001, 3.609986e-001, 3.609968e-001, 3.609950e-001, 3.609932e-001, 3.609913e-001, 3.609895e-001, 3.609877e-001, 3.609859e-001, 3.609841e-001, 3.609822e-001, 3.609804e-001, 3.609786e-001, 3.609768e-001, 3.609749e-001, 3.609731e-001, 3.609713e-001, 3.609695e-001, 3.609677e-001, 3.609658e-001, 3.609640e-001, 3.609622e-001, 3.609604e-001, 3.609585e-001, 3.609567e-001, 3.609549e-001, 3.609531e-001, 3.609512e-001, 3.609494e-001, 3.609476e-001, 3.609458e-001, 3.609439e-001, 3.609421e-001, 3.609403e-001, 3.609385e-001, 3.609366e-001, 3.609348e-001, 3.609330e-001, 3.609311e-001, 3.609293e-001, 3.609275e-001, 3.609257e-001, 3.609238e-001, 3.609220e-001, 3.609202e-001, 3.609183e-001, 3.609165e-001, 3.609147e-001, 3.609129e-001, 3.609110e-001, 3.609092e-001, 3.609074e-001, 3.609055e-001, 3.609037e-001, 3.609019e-001, 3.609000e-001, 3.608982e-001, 3.608964e-001, 3.608945e-001, 3.608927e-001, 3.608909e-001, 3.608890e-001, 3.608872e-001, 3.608854e-001, 3.608835e-001, 3.608817e-001, 3.608799e-001, 3.608780e-001, 3.608762e-001, 3.608744e-001, 3.608725e-001, 3.608707e-001, 
3.608689e-001, 3.608670e-001, 3.608652e-001, 3.608634e-001, 3.608615e-001, 3.608597e-001, 3.608578e-001, 3.608560e-001, 3.608542e-001, 3.608523e-001, 3.608505e-001, 3.608487e-001, 3.608468e-001, 3.608450e-001, 3.608431e-001, 3.608413e-001, 3.608395e-001, 3.608376e-001, 3.608358e-001, 3.608339e-001, 3.608321e-001, 3.608303e-001, 3.608284e-001, 3.608266e-001, 3.608247e-001, 3.608229e-001, 3.608211e-001, 3.608192e-001, 3.608174e-001, 3.608155e-001, 3.608137e-001, 3.608119e-001, 3.608100e-001, 3.608082e-001, 3.608063e-001, 3.608045e-001, 3.608026e-001, 3.608008e-001, 3.607990e-001, 3.607971e-001, 3.607953e-001, 3.607934e-001, 3.607916e-001, 3.607897e-001, 3.607879e-001, 3.607860e-001, 3.607842e-001, 3.607823e-001, 3.607805e-001, 3.607787e-001, 3.607768e-001, 3.607750e-001, 3.607731e-001, 3.607713e-001, 3.607694e-001, 3.607676e-001, 3.607657e-001, 3.607639e-001, 3.607620e-001, 3.607602e-001, 3.607583e-001, 3.607565e-001, 3.607546e-001, 3.607528e-001, 3.607509e-001, 3.607491e-001, 3.607472e-001, 3.607454e-001, 3.607435e-001, 3.607417e-001, 3.607398e-001, 3.607380e-001, 3.607361e-001, 3.607343e-001, 3.607324e-001, 3.607306e-001, 3.607287e-001, 3.607269e-001, 3.607250e-001, 3.607232e-001, 3.607213e-001, 3.607194e-001, 3.607176e-001, 3.607157e-001, 3.607139e-001, 3.607120e-001, 3.607102e-001, 3.607083e-001, 3.607065e-001, 3.607046e-001, 3.607028e-001, 3.607009e-001, 3.606990e-001, 3.606972e-001, 3.606953e-001, 3.606935e-001, 3.606916e-001, 3.606898e-001, 3.606879e-001, 3.606860e-001, 
3.606842e-001, 3.606823e-001, 3.606805e-001, 3.606786e-001, 3.606767e-001, 3.606749e-001, 3.606730e-001, 3.606712e-001, 3.606693e-001, 3.606674e-001, 3.606656e-001, 3.606637e-001, 3.606619e-001, 3.606600e-001, 3.606581e-001, 3.606563e-001, 3.606544e-001, 3.606526e-001, 3.606507e-001, 3.606488e-001, 3.606470e-001, 3.606451e-001, 3.606432e-001, 3.606414e-001, 3.606395e-001, 3.606377e-001, 3.606358e-001, 3.606339e-001, 3.606321e-001, 3.606302e-001, 3.606283e-001, 3.606265e-001, 3.606246e-001, 3.606227e-001, 3.606209e-001, 3.606190e-001, 3.606171e-001, 3.606153e-001, 3.606134e-001, 3.606115e-001, 3.606097e-001, 3.606078e-001, 3.606059e-001, 3.606041e-001, 3.606022e-001, 3.606003e-001, 3.605985e-001, 3.605966e-001, 3.605947e-001, 3.605929e-001, 3.605910e-001, 3.605891e-001, 3.605873e-001, 3.605854e-001, 3.605835e-001, 3.605816e-001, 3.605798e-001, 3.605779e-001, 3.605760e-001, 3.605742e-001, 3.605723e-001, 3.605704e-001, 3.605685e-001, 3.605667e-001, 3.605648e-001, 3.605629e-001, 3.605611e-001, 3.605592e-001, 3.605573e-001, 3.605554e-001, 3.605536e-001, 3.605517e-001, 3.605498e-001, 3.605479e-001, 3.605461e-001, 3.605442e-001, 3.605423e-001, 3.605404e-001, 3.605386e-001, 3.605367e-001, 3.605348e-001, 3.605329e-001, 3.605311e-001, 3.605292e-001, 3.605273e-001, 3.605254e-001, 3.605235e-001, 3.605217e-001, 3.605198e-001, 3.605179e-001, 3.605160e-001, 3.605142e-001, 3.605123e-001, 3.605104e-001, 3.605085e-001, 3.605066e-001, 3.605048e-001, 3.605029e-001, 3.605010e-001, 3.604991e-001, 
3.604972e-001, 3.604954e-001, 3.604935e-001, 3.604916e-001, 3.604897e-001, 3.604878e-001, 3.604859e-001, 3.604841e-001, 3.604822e-001, 3.604803e-001, 3.604784e-001, 3.604765e-001, 3.604747e-001, 3.604728e-001, 3.604709e-001, 3.604690e-001, 3.604671e-001, 3.604652e-001, 3.604633e-001, 3.604615e-001, 3.604596e-001, 3.604577e-001, 3.604558e-001, 3.604539e-001, 3.604520e-001, 3.604502e-001, 3.604483e-001, 3.604464e-001, 3.604445e-001, 3.604426e-001, 3.604407e-001, 3.604388e-001, 3.604369e-001, 3.604351e-001, 3.604332e-001, 3.604313e-001, 3.604294e-001, 3.604275e-001, 3.604256e-001, 3.604237e-001, 3.604218e-001, 3.604199e-001, 3.604181e-001, 3.604162e-001, 3.604143e-001, 3.604124e-001, 3.604105e-001, 3.604086e-001, 3.604067e-001, 3.604048e-001, 3.604029e-001, 3.604010e-001, 3.603991e-001, 3.603972e-001, 3.603954e-001, 3.603935e-001, 3.603916e-001, 3.603897e-001, 3.603878e-001, 3.603859e-001, 3.603840e-001, 3.603821e-001, 3.603802e-001, 3.603783e-001, 3.603764e-001, 3.603745e-001, 3.603726e-001, 3.603707e-001, 3.603688e-001, 3.603669e-001, 3.603650e-001, 3.603631e-001, 3.603612e-001, 3.603593e-001, 3.603575e-001, 3.603556e-001, 3.603537e-001, 3.603518e-001, 3.603499e-001, 3.603480e-001, 3.603461e-001, 3.603442e-001, 3.603423e-001, 3.603404e-001, 3.603385e-001, 3.603366e-001, 3.603347e-001, 3.603328e-001, 3.603309e-001, 3.603290e-001, 3.603271e-001, 3.603252e-001, 3.603233e-001, 3.603214e-001, 3.603195e-001, 3.603176e-001, 3.603157e-001, 3.603138e-001, 3.603118e-001, 3.603099e-001, 
3.603080e-001, 3.603061e-001, 3.603042e-001, 3.603023e-001, 3.603004e-001, 3.602985e-001, 3.602966e-001, 3.602947e-001, 3.602928e-001, 3.602909e-001, 3.602890e-001, 3.602871e-001, 3.602852e-001, 3.602833e-001, 3.602814e-001, 3.602795e-001, 3.602776e-001, 3.602757e-001, 3.602737e-001, 3.602718e-001, 3.602699e-001, 3.602680e-001, 3.602661e-001, 3.602642e-001, 3.602623e-001, 3.602604e-001, 3.602585e-001, 3.602566e-001, 3.602547e-001, 3.602528e-001, 3.602508e-001, 3.602489e-001, 3.602470e-001, 3.602451e-001, 3.602432e-001, 3.602413e-001, 3.602394e-001, 3.602375e-001, 3.602356e-001, 3.602336e-001, 3.602317e-001, 3.602298e-001, 3.602279e-001, 3.602260e-001, 3.602241e-001, 3.602222e-001, 3.602203e-001, 3.602183e-001, 3.602164e-001, 3.602145e-001, 3.602126e-001, 3.602107e-001, 3.602088e-001, 3.602069e-001, 3.602049e-001, 3.602030e-001, 3.602011e-001, 3.601992e-001, 3.601973e-001, 3.601954e-001, 3.601934e-001, 3.601915e-001, 3.601896e-001, 3.601877e-001, 3.601858e-001, 3.601839e-001, 3.601819e-001, 3.601800e-001, 3.601781e-001, 3.601762e-001, 3.601743e-001, 3.601724e-001, 3.601704e-001, 3.601685e-001, 3.601666e-001, 3.601647e-001, 3.601628e-001, 3.601608e-001, 3.601589e-001, 3.601570e-001, 3.601551e-001, 3.601531e-001, 3.601512e-001, 3.601493e-001, 3.601474e-001, 3.601455e-001, 3.601435e-001, 3.601416e-001, 3.601397e-001, 3.601378e-001, 3.601358e-001, 3.601339e-001, 3.601320e-001, 3.601301e-001, 3.601282e-001, 3.601262e-001, 3.601243e-001, 3.601224e-001, 3.601205e-001, 3.601185e-001, 
3.601166e-001, 3.601147e-001, 3.601128e-001, 3.601108e-001, 3.601089e-001, 3.601070e-001, 3.601050e-001, 3.601031e-001, 3.601012e-001, 3.600993e-001, 3.600973e-001, 3.600954e-001, 3.600935e-001, 3.600915e-001, 3.600896e-001, 3.600877e-001, 3.600858e-001, 3.600838e-001, 3.600819e-001, 3.600800e-001, 3.600780e-001, 3.600761e-001, 3.600742e-001, 3.600723e-001, 3.600703e-001, 3.600684e-001, 3.600665e-001, 3.600645e-001, 3.600626e-001, 3.600607e-001, 3.600587e-001, 3.600568e-001, 3.600549e-001, 3.600529e-001, 3.600510e-001, 3.600491e-001, 3.600471e-001, 3.600452e-001, 3.600433e-001, 3.600413e-001, 3.600394e-001, 3.600375e-001, 3.600355e-001, 3.600336e-001, 3.600317e-001, 3.600297e-001, 3.600278e-001, 3.600258e-001, 3.600239e-001, 3.600220e-001, 3.600200e-001, 3.600181e-001, 3.600162e-001, 3.600142e-001, 3.600123e-001, 3.600104e-001, 3.600084e-001, 3.600065e-001, 3.600045e-001, 3.600026e-001, 3.600007e-001, 3.599987e-001, 3.599968e-001, 3.599948e-001, 3.599929e-001, 3.599910e-001, 3.599890e-001, 3.599871e-001, 3.599851e-001, 3.599832e-001, 3.599813e-001, 3.599793e-001, 3.599774e-001, 3.599754e-001, 3.599735e-001, 3.599715e-001, 3.599696e-001, 3.599677e-001, 3.599657e-001, 3.599638e-001, 3.599618e-001, 3.599599e-001, 3.599579e-001, 3.599560e-001, 3.599541e-001, 3.599521e-001, 3.599502e-001, 3.599482e-001, 3.599463e-001, 3.599443e-001, 3.599424e-001, 3.599404e-001, 3.599385e-001, 3.599365e-001, 3.599346e-001, 3.599327e-001, 3.599307e-001, 3.599288e-001, 3.599268e-001, 3.599249e-001, 
3.599229e-001, 3.599210e-001, 3.599190e-001, 3.599171e-001, 3.599151e-001, 3.599132e-001, 3.599112e-001, 3.599093e-001, 3.599073e-001, 3.599054e-001, 3.599034e-001, 3.599015e-001, 3.598995e-001, 3.598976e-001, 3.598956e-001, 3.598937e-001, 3.598917e-001, 3.598898e-001, 3.598878e-001, 3.598859e-001, 3.598839e-001, 3.598820e-001, 3.598800e-001, 3.598781e-001, 3.598761e-001, 3.598741e-001, 3.598722e-001, 3.598702e-001, 3.598683e-001, 3.598663e-001, 3.598644e-001, 3.598624e-001, 3.598605e-001, 3.598585e-001, 3.598566e-001, 3.598546e-001, 3.598526e-001, 3.598507e-001, 3.598487e-001, 3.598468e-001, 3.598448e-001, 3.598429e-001, 3.598409e-001, 3.598389e-001, 3.598370e-001, 3.598350e-001, 3.598331e-001, 3.598311e-001, 3.598292e-001, 3.598272e-001, 3.598252e-001, 3.598233e-001, 3.598213e-001, 3.598194e-001, 3.598174e-001, 3.598154e-001, 3.598135e-001, 3.598115e-001, 3.598096e-001, 3.598076e-001, 3.598056e-001, 3.598037e-001, 3.598017e-001, 3.597997e-001, 3.597978e-001, 3.597958e-001, 3.597939e-001, 3.597919e-001, 3.597899e-001, 3.597880e-001, 3.597860e-001, 3.597840e-001, 3.597821e-001, 3.597801e-001, 3.597782e-001, 3.597762e-001, 3.597742e-001, 3.597723e-001, 3.597703e-001, 3.597683e-001, 3.597664e-001, 3.597644e-001, 3.597624e-001, 3.597605e-001, 3.597585e-001, 3.597565e-001, 3.597546e-001, 3.597526e-001, 3.597506e-001, 3.597487e-001, 3.597467e-001, 3.597447e-001, 3.597428e-001, 3.597408e-001, 3.597388e-001, 3.597368e-001, 3.597349e-001, 3.597329e-001, 3.597309e-001, 3.597290e-001, 
3.597270e-001, 3.597250e-001, 3.597231e-001, 3.597211e-001, 3.597191e-001, 3.597171e-001, 3.597152e-001, 3.597132e-001, 3.597112e-001, 3.597093e-001, 3.597073e-001, 3.597053e-001, 3.597033e-001, 3.597014e-001, 3.596994e-001, 3.596974e-001, 3.596954e-001, 3.596935e-001, 3.596915e-001, 3.596895e-001, 3.596875e-001, 3.596856e-001, 3.596836e-001, 3.596816e-001, 3.596796e-001, 3.596777e-001, 3.596757e-001, 3.596737e-001, 3.596717e-001, 3.596698e-001, 3.596678e-001, 3.596658e-001, 3.596638e-001, 3.596619e-001, 3.596599e-001, 3.596579e-001, 3.596559e-001, 3.596539e-001, 3.596520e-001, 3.596500e-001, 3.596480e-001, 3.596460e-001, 3.596440e-001, 3.596421e-001, 3.596401e-001, 3.596381e-001, 3.596361e-001, 3.596341e-001, 3.596322e-001, 3.596302e-001, 3.596282e-001, 3.596262e-001, 3.596242e-001, 3.596223e-001, 3.596203e-001, 3.596183e-001, 3.596163e-001, 3.596143e-001, 3.596123e-001, 3.596104e-001, 3.596084e-001, 3.596064e-001, 3.596044e-001, 3.596024e-001, 3.596004e-001, 3.595985e-001, 3.595965e-001, 3.595945e-001, 3.595925e-001, 3.595905e-001, 3.595885e-001, 3.595865e-001, 3.595846e-001, 3.595826e-001, 3.595806e-001, 3.595786e-001, 3.595766e-001, 3.595746e-001, 3.595726e-001, 3.595706e-001, 3.595687e-001, 3.595667e-001, 3.595647e-001, 3.595627e-001, 3.595607e-001, 3.595587e-001, 3.595567e-001, 3.595547e-001, 3.595527e-001, 3.595507e-001, 3.595488e-001, 3.595468e-001, 3.595448e-001, 3.595428e-001, 3.595408e-001, 3.595388e-001, 3.595368e-001, 3.595348e-001, 3.595328e-001, 3.595308e-001, 
3.595288e-001, 3.595269e-001, 3.595249e-001, 3.595229e-001, 3.595209e-001, 3.595189e-001, 3.595169e-001, 3.595149e-001, 3.595129e-001, 3.595109e-001, 3.595089e-001, 3.595069e-001, 3.595049e-001, 3.595029e-001, 3.595009e-001, 3.594989e-001, 3.594969e-001, 3.594949e-001, 3.594929e-001, 3.594909e-001, 3.594889e-001, 3.594869e-001, 3.594850e-001, 3.594830e-001, 3.594810e-001, 3.594790e-001, 3.594770e-001, 3.594750e-001, 3.594730e-001, 3.594710e-001, 3.594690e-001, 3.594670e-001, 3.594650e-001, 3.594630e-001, 3.594610e-001, 3.594590e-001, 3.594570e-001, 3.594550e-001, 3.594530e-001, 3.594510e-001, 3.594490e-001, 3.594470e-001, 3.594450e-001, 3.594430e-001, 3.594410e-001, 3.594389e-001, 3.594369e-001, 3.594349e-001, 3.594329e-001, 3.594309e-001, 3.594289e-001, 3.594269e-001, 3.594249e-001, 3.594229e-001, 3.594209e-001, 3.594189e-001, 3.594169e-001, 3.594149e-001, 3.594129e-001, 3.594109e-001, 3.594089e-001, 3.594069e-001, 3.594049e-001, 3.594029e-001, 3.594009e-001, 3.593988e-001, 3.593968e-001, 3.593948e-001, 3.593928e-001, 3.593908e-001, 3.593888e-001, 3.593868e-001, 3.593848e-001, 3.593828e-001, 3.593808e-001, 3.593788e-001, 3.593768e-001, 3.593747e-001, 3.593727e-001, 3.593707e-001, 3.593687e-001, 3.593667e-001, 3.593647e-001, 3.593627e-001, 3.593607e-001, 3.593587e-001, 3.593567e-001, 3.593546e-001, 3.593526e-001, 3.593506e-001, 3.593486e-001, 3.593466e-001, 3.593446e-001, 3.593426e-001, 3.593405e-001, 3.593385e-001, 3.593365e-001, 3.593345e-001, 3.593325e-001, 3.593305e-001, 
3.593285e-001, 3.593264e-001, 3.593244e-001, 3.593224e-001, 3.593204e-001, 3.593184e-001, 3.593164e-001, 3.593144e-001, 3.593123e-001, 3.593103e-001, 3.593083e-001, 3.593063e-001, 3.593043e-001, 3.593023e-001, 3.593002e-001, 3.592982e-001, 3.592962e-001, 3.592942e-001, 3.592922e-001, 3.592901e-001, 3.592881e-001, 3.592861e-001, 3.592841e-001, 3.592821e-001, 3.592800e-001, 3.592780e-001, 3.592760e-001, 3.592740e-001, 3.592720e-001, 3.592699e-001, 3.592679e-001, 3.592659e-001, 3.592639e-001, 3.592618e-001, 3.592598e-001, 3.592578e-001, 3.592558e-001, 3.592538e-001, 3.592517e-001, 3.592497e-001, 3.592477e-001, 3.592457e-001, 3.592436e-001, 3.592416e-001, 3.592396e-001, 3.592376e-001, 3.592355e-001, 3.592335e-001, 3.592315e-001, 3.592295e-001, 3.592274e-001, 3.592254e-001, 3.592234e-001, 3.592214e-001, 3.592193e-001, 3.592173e-001, 3.592153e-001, 3.592133e-001, 3.592112e-001, 3.592092e-001, 3.592072e-001, 3.592051e-001, 3.592031e-001, 3.592011e-001, 3.591991e-001, 3.591970e-001, 3.591950e-001, 3.591930e-001, 3.591909e-001, 3.591889e-001, 3.591869e-001, 3.591848e-001, 3.591828e-001, 3.591808e-001, 3.591788e-001, 3.591767e-001, 3.591747e-001, 3.591727e-001, 3.591706e-001, 3.591686e-001, 3.591666e-001, 3.591645e-001, 3.591625e-001, 3.591605e-001, 3.591584e-001, 3.591564e-001, 3.591544e-001, 3.591523e-001, 3.591503e-001, 3.591483e-001, 3.591462e-001, 3.591442e-001, 3.591422e-001, 3.591401e-001, 3.591381e-001, 3.591360e-001, 3.591340e-001, 3.591320e-001, 3.591299e-001, 3.591279e-001, 
3.591259e-001, 3.591238e-001, 3.591218e-001, 3.591197e-001, 3.591177e-001, 3.591157e-001, 3.591136e-001, 3.591116e-001, 3.591096e-001, 3.591075e-001, 3.591055e-001, 3.591034e-001, 3.591014e-001, 3.590994e-001, 3.590973e-001, 3.590953e-001, 3.590932e-001, 3.590912e-001, 3.590892e-001, 3.590871e-001, 3.590851e-001, 3.590830e-001, 3.590810e-001, 3.590789e-001, 3.590769e-001, 3.590749e-001, 3.590728e-001, 3.590708e-001, 3.590687e-001, 3.590667e-001, 3.590646e-001, 3.590626e-001, 3.590606e-001, 3.590585e-001, 3.590565e-001, 3.590544e-001, 3.590524e-001, 3.590503e-001, 3.590483e-001, 3.590462e-001, 3.590442e-001, 3.590422e-001, 3.590401e-001, 3.590381e-001, 3.590360e-001, 3.590340e-001, 3.590319e-001, 3.590299e-001, 3.590278e-001, 3.590258e-001, 3.590237e-001, 3.590217e-001, 3.590196e-001, 3.590176e-001, 3.590155e-001, 3.590135e-001, 3.590114e-001, 3.590094e-001, 3.590073e-001, 3.590053e-001, 3.590032e-001, 3.590012e-001, 3.589991e-001, 3.589971e-001, 3.589950e-001, 3.589930e-001, 3.589909e-001, 3.589889e-001, 3.589868e-001, 3.589848e-001, 3.589827e-001, 3.589807e-001, 3.589786e-001, 3.589766e-001, 3.589745e-001, 3.589725e-001, 3.589704e-001, 3.589683e-001, 3.589663e-001, 3.589642e-001, 3.589622e-001, 3.589601e-001, 3.589581e-001, 3.589560e-001, 3.589540e-001, 3.589519e-001, 3.589498e-001, 3.589478e-001, 3.589457e-001, 3.589437e-001, 3.589416e-001, 3.589396e-001, 3.589375e-001, 3.589355e-001, 3.589334e-001, 3.589313e-001, 3.589293e-001, 3.589272e-001, 3.589252e-001, 3.589231e-001, 
3.589210e-001, 3.589190e-001, 3.589169e-001, 3.589149e-001, 3.589128e-001, 3.589107e-001, 3.589087e-001, 3.589066e-001, 3.589046e-001, 3.589025e-001, 3.589004e-001, 3.588984e-001, 3.588963e-001, 3.588943e-001, 3.588922e-001, 3.588901e-001, 3.588881e-001, 3.588860e-001, 3.588839e-001, 3.588819e-001, 3.588798e-001, 3.588777e-001, 3.588757e-001, 3.588736e-001, 3.588716e-001, 3.588695e-001, 3.588674e-001, 3.588654e-001, 3.588633e-001, 3.588612e-001, 3.588592e-001, 3.588571e-001, 3.588550e-001, 3.588530e-001, 3.588509e-001, 3.588488e-001, 3.588468e-001, 3.588447e-001, 3.588426e-001, 3.588406e-001, 3.588385e-001, 3.588364e-001, 3.588344e-001, 3.588323e-001, 3.588302e-001, 3.588281e-001, 3.588261e-001, 3.588240e-001, 3.588219e-001, 3.588199e-001, 3.588178e-001, 3.588157e-001, 3.588137e-001, 3.588116e-001, 3.588095e-001, 3.588074e-001, 3.588054e-001, 3.588033e-001, 3.588012e-001, 3.587992e-001, 3.587971e-001, 3.587950e-001, 3.587929e-001, 3.587909e-001, 3.587888e-001, 3.587867e-001, 3.587846e-001, 3.587826e-001, 3.587805e-001, 3.587784e-001, 3.587764e-001, 3.587743e-001, 3.587722e-001, 3.587701e-001, 3.587680e-001, 3.587660e-001, 3.587639e-001, 3.587618e-001, 3.587597e-001, 3.587577e-001, 3.587556e-001, 3.587535e-001, 3.587514e-001, 3.587494e-001, 3.587473e-001, 3.587452e-001, 3.587431e-001, 3.587410e-001, 3.587390e-001, 3.587369e-001, 3.587348e-001, 3.587327e-001, 3.587307e-001, 3.587286e-001, 3.587265e-001, 3.587244e-001, 3.587223e-001, 3.587203e-001, 3.587182e-001, 3.587161e-001, 
3.587140e-001, 3.587119e-001, 3.587098e-001, 3.587078e-001, 3.587057e-001, 3.587036e-001, 3.587015e-001, 3.586994e-001, 3.586974e-001, 3.586953e-001, 3.586932e-001, 3.586911e-001, 3.586890e-001, 3.586869e-001, 3.586848e-001, 3.586828e-001, 3.586807e-001, 3.586786e-001, 3.586765e-001, 3.586744e-001, 3.586723e-001, 3.586703e-001, 3.586682e-001, 3.586661e-001, 3.586640e-001, 3.586619e-001, 3.586598e-001, 3.586577e-001, 3.586556e-001, 3.586536e-001, 3.586515e-001, 3.586494e-001, 3.586473e-001, 3.586452e-001, 3.586431e-001, 3.586410e-001, 3.586389e-001, 3.586368e-001, 3.586348e-001, 3.586327e-001, 3.586306e-001, 3.586285e-001, 3.586264e-001, 3.586243e-001, 3.586222e-001, 3.586201e-001, 3.586180e-001, 3.586159e-001, 3.586138e-001, 3.586118e-001, 3.586097e-001, 3.586076e-001, 3.586055e-001, 3.586034e-001, 3.586013e-001, 3.585992e-001, 3.585971e-001, 3.585950e-001, 3.585929e-001, 3.585908e-001, 3.585887e-001, 3.585866e-001, 3.585845e-001, 3.585824e-001, 3.585803e-001, 3.585783e-001, 3.585762e-001, 3.585741e-001, 3.585720e-001, 3.585699e-001, 3.585678e-001, 3.585657e-001, 3.585636e-001, 3.585615e-001, 3.585594e-001, 3.585573e-001, 3.585552e-001, 3.585531e-001, 3.585510e-001, 3.585489e-001, 3.585468e-001, 3.585447e-001, 3.585426e-001, 3.585405e-001, 3.585384e-001, 3.585363e-001, 3.585342e-001, 3.585321e-001, 3.585300e-001, 3.585279e-001, 3.585258e-001, 3.585237e-001, 3.585216e-001, 3.585195e-001, 3.585174e-001, 3.585153e-001, 3.585132e-001, 3.585111e-001, 3.585090e-001, 3.585069e-001, 
3.585048e-001, 3.585027e-001, 3.585006e-001, 3.584985e-001, 3.584964e-001, 3.584942e-001, 3.584921e-001, 3.584900e-001, 3.584879e-001, 3.584858e-001, 3.584837e-001, 3.584816e-001, 3.584795e-001, 3.584774e-001, 3.584753e-001, 3.584732e-001, 3.584711e-001, 3.584690e-001, 3.584669e-001, 3.584648e-001, 3.584627e-001, 3.584605e-001, 3.584584e-001, 3.584563e-001, 3.584542e-001, 3.584521e-001, 3.584500e-001, 3.584479e-001, 3.584458e-001, 3.584437e-001, 3.584416e-001, 3.584395e-001, 3.584373e-001, 3.584352e-001, 3.584331e-001, 3.584310e-001, 3.584289e-001, 3.584268e-001, 3.584247e-001, 3.584226e-001, 3.584205e-001, 3.584183e-001, 3.584162e-001, 3.584141e-001, 3.584120e-001, 3.584099e-001, 3.584078e-001, 3.584057e-001, 3.584036e-001, 3.584014e-001, 3.583993e-001, 3.583972e-001, 3.583951e-001, 3.583930e-001, 3.583909e-001, 3.583887e-001, 3.583866e-001, 3.583845e-001, 3.583824e-001, 3.583803e-001, 3.583782e-001, 3.583761e-001, 3.583739e-001, 3.583718e-001, 3.583697e-001, 3.583676e-001, 3.583655e-001, 3.583633e-001, 3.583612e-001, 3.583591e-001, 3.583570e-001, 3.583549e-001, 3.583528e-001, 3.583506e-001, 3.583485e-001, 3.583464e-001, 3.583443e-001, 3.583422e-001, 3.583400e-001, 3.583379e-001, 3.583358e-001, 3.583337e-001, 3.583315e-001, 3.583294e-001, 3.583273e-001, 3.583252e-001, 3.583231e-001, 3.583209e-001, 3.583188e-001, 3.583167e-001, 3.583146e-001, 3.583124e-001, 3.583103e-001, 3.583082e-001, 3.583061e-001, 3.583040e-001, 3.583018e-001, 3.582997e-001, 3.582976e-001, 3.582955e-001, 
3.582933e-001, 3.582912e-001, 3.582891e-001, 3.582869e-001, 3.582848e-001, 3.582827e-001, 3.582806e-001, 3.582784e-001, 3.582763e-001, 3.582742e-001, 3.582721e-001, 3.582699e-001, 3.582678e-001, 3.582657e-001, 3.582635e-001, 3.582614e-001, 3.582593e-001, 3.582572e-001, 3.582550e-001, 3.582529e-001, 3.582508e-001, 3.582486e-001, 3.582465e-001, 3.582444e-001, 3.582423e-001, 3.582401e-001, 3.582380e-001, 3.582359e-001, 3.582337e-001, 3.582316e-001, 3.582295e-001, 3.582273e-001, 3.582252e-001, 3.582231e-001, 3.582209e-001, 3.582188e-001, 3.582167e-001, 3.582145e-001, 3.582124e-001, 3.582103e-001, 3.582081e-001, 3.582060e-001, 3.582039e-001, 3.582017e-001, 3.581996e-001, 3.581975e-001, 3.581953e-001, 3.581932e-001, 3.581911e-001, 3.581889e-001, 3.581868e-001, 3.581846e-001, 3.581825e-001, 3.581804e-001, 3.581782e-001, 3.581761e-001, 3.581740e-001, 3.581718e-001, 3.581697e-001, 3.581675e-001, 3.581654e-001, 3.581633e-001, 3.581611e-001, 3.581590e-001, 3.581568e-001, 3.581547e-001, 3.581526e-001, 3.581504e-001, 3.581483e-001, 3.581461e-001, 3.581440e-001, 3.581419e-001, 3.581397e-001, 3.581376e-001, 3.581354e-001, 3.581333e-001, 3.581312e-001, 3.581290e-001, 3.581269e-001, 3.581247e-001, 3.581226e-001, 3.581204e-001, 3.581183e-001, 3.581162e-001, 3.581140e-001, 3.581119e-001, 3.581097e-001, 3.581076e-001, 3.581054e-001, 3.581033e-001, 3.581011e-001, 3.580990e-001, 3.580969e-001, 3.580947e-001, 3.580926e-001, 3.580904e-001, 3.580883e-001, 3.580861e-001, 3.580840e-001, 3.580818e-001, 
3.580797e-001, 3.580775e-001, 3.580754e-001, 3.580732e-001, 3.580711e-001, 3.580689e-001, 3.580668e-001, 3.580646e-001, 3.580625e-001, 3.580604e-001, 3.580582e-001, 3.580561e-001, 3.580539e-001, 3.580518e-001, 3.580496e-001, 3.580475e-001, 3.580453e-001, 3.580431e-001, 3.580410e-001, 3.580388e-001, 3.580367e-001, 3.580345e-001, 3.580324e-001, 3.580302e-001, 3.580281e-001, 3.580259e-001, 3.580238e-001, 3.580216e-001, 3.580195e-001, 3.580173e-001, 3.580152e-001, 3.580130e-001, 3.580109e-001, 3.580087e-001, 3.580065e-001, 3.580044e-001, 3.580022e-001, 3.580001e-001, 3.579979e-001, 3.579958e-001, 3.579936e-001, 3.579915e-001, 3.579893e-001, 3.579871e-001, 3.579850e-001, 3.579828e-001, 3.579807e-001, 3.579785e-001, 3.579764e-001, 3.579742e-001, 3.579720e-001, 3.579699e-001, 3.579677e-001, 3.579656e-001, 3.579634e-001, 3.579612e-001, 3.579591e-001, 3.579569e-001, 3.579548e-001, 3.579526e-001, 3.579504e-001, 3.579483e-001, 3.579461e-001, 3.579440e-001, 3.579418e-001, 3.579396e-001, 3.579375e-001, 3.579353e-001, 3.579332e-001, 3.579310e-001, 3.579288e-001, 3.579267e-001, 3.579245e-001, 3.579223e-001, 3.579202e-001, 3.579180e-001, 3.579159e-001, 3.579137e-001, 3.579115e-001, 3.579094e-001, 3.579072e-001, 3.579050e-001, 3.579029e-001, 3.579007e-001, 3.578985e-001, 3.578964e-001, 3.578942e-001, 3.578920e-001, 3.578899e-001, 3.578877e-001, 3.578855e-001, 3.578834e-001, 3.578812e-001, 3.578790e-001, 3.578769e-001, 3.578747e-001, 3.578725e-001, 3.578704e-001, 3.578682e-001, 3.578660e-001, 
3.578639e-001, 3.578617e-001, 3.578595e-001, 3.578573e-001, 3.578552e-001, 3.578530e-001, 3.578508e-001, 3.578487e-001, 3.578465e-001, 3.578443e-001, 3.578421e-001, 3.578400e-001, 3.578378e-001, 3.578356e-001, 3.578335e-001, 3.578313e-001, 3.578291e-001, 3.578269e-001, 3.578248e-001, 3.578226e-001, 3.578204e-001, 3.578182e-001, 3.578161e-001, 3.578139e-001, 3.578117e-001, 3.578096e-001, 3.578074e-001, 3.578052e-001, 3.578030e-001, 3.578009e-001, 3.577987e-001, 3.577965e-001, 3.577943e-001, 3.577921e-001, 3.577900e-001, 3.577878e-001, 3.577856e-001, 3.577834e-001, 3.577813e-001, 3.577791e-001, 3.577769e-001, 3.577747e-001, 3.577726e-001, 3.577704e-001, 3.577682e-001, 3.577660e-001, 3.577638e-001, 3.577617e-001, 3.577595e-001, 3.577573e-001, 3.577551e-001, 3.577529e-001, 3.577508e-001, 3.577486e-001, 3.577464e-001, 3.577442e-001, 3.577420e-001, 3.577398e-001, 3.577377e-001, 3.577355e-001, 3.577333e-001, 3.577311e-001, 3.577289e-001, 3.577268e-001, 3.577246e-001, 3.577224e-001, 3.577202e-001, 3.577180e-001, 3.577158e-001, 3.577137e-001, 3.577115e-001, 3.577093e-001, 3.577071e-001, 3.577049e-001, 3.577027e-001, 3.577005e-001, 3.576984e-001, 3.576962e-001, 3.576940e-001, 3.576918e-001, 3.576896e-001, 3.576874e-001, 3.576852e-001, 3.576830e-001, 3.576809e-001, 3.576787e-001, 3.576765e-001, 3.576743e-001, 3.576721e-001, 3.576699e-001, 3.576677e-001, 3.576655e-001, 3.576634e-001, 3.576612e-001, 3.576590e-001, 3.576568e-001, 3.576546e-001, 3.576524e-001, 3.576502e-001, 3.576480e-001, 
3.576458e-001, 3.576436e-001, 3.576414e-001, 3.576393e-001, 3.576371e-001, 3.576349e-001, 3.576327e-001, 3.576305e-001, 3.576283e-001, 3.576261e-001, 3.576239e-001, 3.576217e-001, 3.576195e-001, 3.576173e-001, 3.576151e-001, 3.576129e-001, 3.576107e-001, 3.576086e-001, 3.576064e-001, 3.576042e-001, 3.576020e-001, 3.575998e-001, 3.575976e-001, 3.575954e-001, 3.575932e-001, 3.575910e-001, 3.575888e-001, 3.575866e-001, 3.575844e-001, 3.575822e-001, 3.575800e-001, 3.575778e-001, 3.575756e-001, 3.575734e-001, 3.575712e-001, 3.575690e-001, 3.575668e-001, 3.575646e-001, 3.575624e-001, 3.575602e-001, 3.575580e-001, 3.575558e-001, 3.575536e-001, 3.575514e-001, 3.575492e-001, 3.575470e-001, 3.575448e-001, 3.575426e-001, 3.575404e-001, 3.575382e-001, 3.575360e-001, 3.575338e-001, 3.575316e-001, 3.575294e-001, 3.575272e-001, 3.575250e-001, 3.575228e-001, 3.575206e-001, 3.575184e-001, 3.575162e-001, 3.575140e-001, 3.575118e-001, 3.575096e-001, 3.575074e-001, 3.575052e-001, 3.575029e-001, 3.575007e-001, 3.574985e-001, 3.574963e-001, 3.574941e-001, 3.574919e-001, 3.574897e-001, 3.574875e-001, 3.574853e-001, 3.574831e-001, 3.574809e-001, 3.574787e-001, 3.574765e-001, 3.574743e-001, 3.574721e-001, 3.574698e-001, 3.574676e-001, 3.574654e-001, 3.574632e-001, 3.574610e-001, 3.574588e-001, 3.574566e-001, 3.574544e-001, 3.574522e-001, 3.574500e-001, 3.574477e-001, 3.574455e-001, 3.574433e-001, 3.574411e-001, 3.574389e-001, 3.574367e-001, 3.574345e-001, 3.574323e-001, 3.574301e-001, 3.574278e-001, 
3.574256e-001, 3.574234e-001, 3.574212e-001, 3.574190e-001, 3.574168e-001, 3.574146e-001, 3.574123e-001, 3.574101e-001, 3.574079e-001, 3.574057e-001, 3.574035e-001, 3.574013e-001, 3.573991e-001, 3.573968e-001, 3.573946e-001, 3.573924e-001, 3.573902e-001, 3.573880e-001, 3.573858e-001, 3.573835e-001, 3.573813e-001, 3.573791e-001, 3.573769e-001, 3.573747e-001, 3.573725e-001, 3.573702e-001, 3.573680e-001, 3.573658e-001, 3.573636e-001, 3.573614e-001, 3.573591e-001, 3.573569e-001, 3.573547e-001, 3.573525e-001, 3.573503e-001, 3.573480e-001, 3.573458e-001, 3.573436e-001, 3.573414e-001, 3.573392e-001, 3.573369e-001, 3.573347e-001, 3.573325e-001, 3.573303e-001, 3.573280e-001, 3.573258e-001, 3.573236e-001, 3.573214e-001, 3.573192e-001, 3.573169e-001, 3.573147e-001, 3.573125e-001, 3.573103e-001, 3.573080e-001, 3.573058e-001, 3.573036e-001, 3.573014e-001, 3.572991e-001, 3.572969e-001, 3.572947e-001, 3.572925e-001, 3.572902e-001, 3.572880e-001, 3.572858e-001, 3.572836e-001, 3.572813e-001, 3.572791e-001, 3.572769e-001, 3.572746e-001, 3.572724e-001, 3.572702e-001, 3.572680e-001, 3.572657e-001, 3.572635e-001, 3.572613e-001, 3.572590e-001, 3.572568e-001, 3.572546e-001, 3.572524e-001, 3.572501e-001, 3.572479e-001, 3.572457e-001, 3.572434e-001, 3.572412e-001, 3.572390e-001, 3.572367e-001, 3.572345e-001, 3.572323e-001, 3.572300e-001, 3.572278e-001, 3.572256e-001, 3.572233e-001, 3.572211e-001, 3.572189e-001, 3.572166e-001, 3.572144e-001, 3.572122e-001, 3.572099e-001, 3.572077e-001, 3.572055e-001, 
3.572032e-001, 3.572010e-001, 3.571988e-001, 3.571965e-001, 3.571943e-001, 3.571921e-001, 3.571898e-001, 3.571876e-001, 3.571854e-001, 3.571831e-001, 3.571809e-001, 3.571786e-001, 3.571764e-001, 3.571742e-001, 3.571719e-001, 3.571697e-001, 3.571675e-001, 3.571652e-001, 3.571630e-001, 3.571607e-001, 3.571585e-001, 3.571563e-001, 3.571540e-001, 3.571518e-001, 3.571495e-001, 3.571473e-001, 3.571451e-001, 3.571428e-001, 3.571406e-001, 3.571383e-001, 3.571361e-001, 3.571339e-001, 3.571316e-001, 3.571294e-001, 3.571271e-001, 3.571249e-001, 3.571227e-001, 3.571204e-001, 3.571182e-001, 3.571159e-001, 3.571137e-001, 3.571114e-001, 3.571092e-001, 3.571069e-001, 3.571047e-001, 3.571025e-001, 3.571002e-001, 3.570980e-001, 3.570957e-001, 3.570935e-001, 3.570912e-001, 3.570890e-001, 3.570867e-001, 3.570845e-001, 3.570823e-001, 3.570800e-001, 3.570778e-001, 3.570755e-001, 3.570733e-001, 3.570710e-001, 3.570688e-001, 3.570665e-001, 3.570643e-001, 3.570620e-001, 3.570598e-001, 3.570575e-001, 3.570553e-001, 3.570530e-001, 3.570508e-001, 3.570485e-001, 3.570463e-001, 3.570440e-001, 3.570418e-001, 3.570395e-001, 3.570373e-001, 3.570350e-001, 3.570328e-001, 3.570305e-001, 3.570283e-001, 3.570260e-001, 3.570238e-001, 3.570215e-001, 3.570193e-001, 3.570170e-001, 3.570148e-001, 3.570125e-001, 3.570103e-001, 3.570080e-001, 3.570057e-001, 3.570035e-001, 3.570012e-001, 3.569990e-001, 3.569967e-001, 3.569945e-001, 3.569922e-001, 3.569900e-001, 3.569877e-001, 3.569855e-001, 3.569832e-001, 3.569809e-001, 
3.569787e-001, 3.569764e-001, 3.569742e-001, 3.569719e-001, 3.569697e-001, 3.569674e-001, 3.569651e-001, 3.569629e-001, 3.569606e-001, 3.569584e-001, 3.569561e-001, 3.569539e-001, 3.569516e-001, 3.569493e-001, 3.569471e-001, 3.569448e-001, 3.569426e-001, 3.569403e-001, 3.569380e-001, 3.569358e-001, 3.569335e-001, 3.569313e-001, 3.569290e-001, 3.569267e-001, 3.569245e-001, 3.569222e-001, 3.569199e-001, 3.569177e-001, 3.569154e-001, 3.569132e-001, 3.569109e-001, 3.569086e-001, 3.569064e-001, 3.569041e-001, 3.569018e-001, 3.568996e-001, 3.568973e-001, 3.568950e-001, 3.568928e-001, 3.568905e-001, 3.568883e-001, 3.568860e-001, 3.568837e-001, 3.568815e-001, 3.568792e-001, 3.568769e-001, 3.568747e-001, 3.568724e-001, 3.568701e-001, 3.568679e-001, 3.568656e-001, 3.568633e-001, 3.568611e-001, 3.568588e-001, 3.568565e-001, 3.568543e-001, 3.568520e-001, 3.568497e-001, 3.568474e-001, 3.568452e-001, 3.568429e-001, 3.568406e-001, 3.568384e-001, 3.568361e-001, 3.568338e-001, 3.568316e-001, 3.568293e-001, 3.568270e-001, 3.568247e-001, 3.568225e-001, 3.568202e-001, 3.568179e-001, 3.568157e-001, 3.568134e-001, 3.568111e-001, 3.568088e-001, 3.568066e-001, 3.568043e-001, 3.568020e-001, 3.567998e-001, 3.567975e-001, 3.567952e-001, 3.567929e-001, 3.567907e-001, 3.567884e-001, 3.567861e-001, 3.567838e-001, 3.567816e-001, 3.567793e-001, 3.567770e-001, 3.567747e-001, 3.567725e-001, 3.567702e-001, 3.567679e-001, 3.567656e-001, 3.567633e-001, 3.567611e-001, 3.567588e-001, 3.567565e-001, 3.567542e-001, 
3.567520e-001, 3.567497e-001, 3.567474e-001, 3.567451e-001, 3.567428e-001, 3.567406e-001, 3.567383e-001, 3.567360e-001, 3.567337e-001, 3.567314e-001, 3.567292e-001, 3.567269e-001, 3.567246e-001, 3.567223e-001, 3.567200e-001, 3.567178e-001, 3.567155e-001, 3.567132e-001, 3.567109e-001, 3.567086e-001, 3.567064e-001, 3.567041e-001, 3.567018e-001, 3.566995e-001, 3.566972e-001, 3.566949e-001, 3.566927e-001, 3.566904e-001, 3.566881e-001, 3.566858e-001, 3.566835e-001, 3.566812e-001, 3.566789e-001, 3.566767e-001, 3.566744e-001, 3.566721e-001, 3.566698e-001, 3.566675e-001, 3.566652e-001, 3.566629e-001, 3.566607e-001, 3.566584e-001, 3.566561e-001, 3.566538e-001, 3.566515e-001, 3.566492e-001, 3.566469e-001, 3.566446e-001, 3.566424e-001, 3.566401e-001, 3.566378e-001, 3.566355e-001, 3.566332e-001, 3.566309e-001, 3.566286e-001, 3.566263e-001, 3.566240e-001, 3.566218e-001, 3.566195e-001, 3.566172e-001, 3.566149e-001, 3.566126e-001, 3.566103e-001, 3.566080e-001, 3.566057e-001, 3.566034e-001, 3.566011e-001, 3.565988e-001, 3.565965e-001, 3.565943e-001, 3.565920e-001, 3.565897e-001, 3.565874e-001, 3.565851e-001, 3.565828e-001, 3.565805e-001, 3.565782e-001, 3.565759e-001, 3.565736e-001, 3.565713e-001, 3.565690e-001, 3.565667e-001, 3.565644e-001, 3.565621e-001, 3.565598e-001, 3.565575e-001, 3.565552e-001, 3.565529e-001, 3.565506e-001, 3.565484e-001, 3.565461e-001, 3.565438e-001, 3.565415e-001, 3.565392e-001, 3.565369e-001, 3.565346e-001, 3.565323e-001, 3.565300e-001, 3.565277e-001, 3.565254e-001, 
3.565231e-001, 3.565208e-001, 3.565185e-001, 3.565162e-001, 3.565139e-001, 3.565116e-001, 3.565093e-001, 3.565070e-001, 3.565047e-001, 3.565024e-001, 3.565001e-001, 3.564978e-001, 3.564955e-001, 3.564932e-001, 3.564909e-001, 3.564885e-001, 3.564862e-001, 3.564839e-001, 3.564816e-001, 3.564793e-001, 3.564770e-001, 3.564747e-001, 3.564724e-001, 3.564701e-001, 3.564678e-001, 3.564655e-001, 3.564632e-001, 3.564609e-001, 3.564586e-001, 3.564563e-001, 3.564540e-001, 3.564517e-001, 3.564494e-001, 3.564471e-001, 3.564448e-001, 3.564424e-001, 3.564401e-001, 3.564378e-001, 3.564355e-001, 3.564332e-001, 3.564309e-001, 3.564286e-001, 3.564263e-001, 3.564240e-001, 3.564217e-001, 3.564194e-001, 3.564171e-001, 3.564147e-001, 3.564124e-001, 3.564101e-001, 3.564078e-001, 3.564055e-001, 3.564032e-001, 3.564009e-001, 3.563986e-001, 3.563963e-001, 3.563939e-001, 3.563916e-001, 3.563893e-001, 3.563870e-001, 3.563847e-001, 3.563824e-001, 3.563801e-001, 3.563778e-001, 3.563754e-001, 3.563731e-001, 3.563708e-001, 3.563685e-001, 3.563662e-001, 3.563639e-001, 3.563616e-001, 3.563592e-001, 3.563569e-001, 3.563546e-001, 3.563523e-001, 3.563500e-001, 3.563477e-001, 3.563453e-001, 3.563430e-001, 3.563407e-001, 3.563384e-001, 3.563361e-001, 3.563338e-001, 3.563314e-001, 3.563291e-001, 3.563268e-001, 3.563245e-001, 3.563222e-001, 3.563199e-001, 3.563175e-001, 3.563152e-001, 3.563129e-001, 3.563106e-001, 3.563083e-001, 3.563059e-001, 3.563036e-001, 3.563013e-001, 3.562990e-001, 3.562967e-001, 3.562943e-001, 
3.562920e-001, 3.562897e-001, 3.562874e-001, 3.562851e-001, 3.562827e-001, 3.562804e-001, 3.562781e-001, 3.562758e-001, 3.562734e-001, 3.562711e-001, 3.562688e-001, 3.562665e-001, 3.562641e-001, 3.562618e-001, 3.562595e-001, 3.562572e-001, 3.562548e-001, 3.562525e-001, 3.562502e-001, 3.562479e-001, 3.562455e-001, 3.562432e-001, 3.562409e-001, 3.562386e-001, 3.562362e-001, 3.562339e-001, 3.562316e-001, 3.562293e-001, 3.562269e-001, 3.562246e-001, 3.562223e-001, 3.562200e-001, 3.562176e-001, 3.562153e-001, 3.562130e-001, 3.562106e-001, 3.562083e-001, 3.562060e-001, 3.562037e-001, 3.562013e-001, 3.561990e-001, 3.561967e-001, 3.561943e-001, 3.561920e-001, 3.561897e-001, 3.561873e-001, 3.561850e-001, 3.561827e-001, 3.561803e-001, 3.561780e-001, 3.561757e-001, 3.561734e-001, 3.561710e-001, 3.561687e-001, 3.561664e-001, 3.561640e-001, 3.561617e-001, 3.561594e-001, 3.561570e-001, 3.561547e-001, 3.561524e-001, 3.561500e-001, 3.561477e-001, 3.561453e-001, 3.561430e-001, 3.561407e-001, 3.561383e-001, 3.561360e-001, 3.561337e-001, 3.561313e-001, 3.561290e-001, 3.561267e-001, 3.561243e-001, 3.561220e-001, 3.561197e-001, 3.561173e-001, 3.561150e-001, 3.561126e-001, 3.561103e-001, 3.561080e-001, 3.561056e-001, 3.561033e-001, 3.561009e-001, 3.560986e-001, 3.560963e-001, 3.560939e-001, 3.560916e-001, 3.560892e-001, 3.560869e-001, 3.560846e-001, 3.560822e-001, 3.560799e-001, 3.560775e-001, 3.560752e-001, 3.560729e-001, 3.560705e-001, 3.560682e-001, 3.560658e-001, 3.560635e-001, 3.560612e-001, 
3.560588e-001, 3.560565e-001, 3.560541e-001, 3.560518e-001, 3.560494e-001, 3.560471e-001, 3.560448e-001, 3.560424e-001, 3.560401e-001, 3.560377e-001, 3.560354e-001, 3.560330e-001, 3.560307e-001, 3.560283e-001, 3.560260e-001, 3.560236e-001, 3.560213e-001, 3.560190e-001, 3.560166e-001, 3.560143e-001, 3.560119e-001, 3.560096e-001, 3.560072e-001, 3.560049e-001, 3.560025e-001, 3.560002e-001, 3.559978e-001, 3.559955e-001, 3.559931e-001, 3.559908e-001, 3.559884e-001, 3.559861e-001, 3.559837e-001, 3.559814e-001, 3.559790e-001, 3.559767e-001, 3.559743e-001, 3.559720e-001, 3.559696e-001, 3.559673e-001, 3.559649e-001, 3.559626e-001, 3.559602e-001, 3.559579e-001, 3.559555e-001, 3.559532e-001, 3.559508e-001, 3.559485e-001, 3.559461e-001, 3.559438e-001, 3.559414e-001, 3.559390e-001, 3.559367e-001, 3.559343e-001, 3.559320e-001, 3.559296e-001, 3.559273e-001, 3.559249e-001, 3.559226e-001, 3.559202e-001, 3.559179e-001, 3.559155e-001, 3.559131e-001, 3.559108e-001, 3.559084e-001, 3.559061e-001, 3.559037e-001, 3.559014e-001, 3.558990e-001, 3.558966e-001, 3.558943e-001, 3.558919e-001, 3.558896e-001, 3.558872e-001, 3.558849e-001, 3.558825e-001, 3.558801e-001, 3.558778e-001, 3.558754e-001, 3.558731e-001, 3.558707e-001, 3.558683e-001, 3.558660e-001, 3.558636e-001, 3.558613e-001, 3.558589e-001, 3.558565e-001, 3.558542e-001, 3.558518e-001, 3.558494e-001, 3.558471e-001, 3.558447e-001, 3.558424e-001, 3.558400e-001, 3.558376e-001, 3.558353e-001, 3.558329e-001, 3.558305e-001, 3.558282e-001, 3.558258e-001, 
3.558235e-001, 3.558211e-001, 3.558187e-001, 3.558164e-001, 3.558140e-001, 3.558116e-001, 3.558093e-001, 3.558069e-001, 3.558045e-001, 3.558022e-001, 3.557998e-001, 3.557974e-001, 3.557951e-001, 3.557927e-001, 3.557903e-001, 3.557880e-001, 3.557856e-001, 3.557832e-001, 3.557809e-001, 3.557785e-001, 3.557761e-001, 3.557738e-001, 3.557714e-001, 3.557690e-001, 3.557666e-001, 3.557643e-001, 3.557619e-001, 3.557595e-001, 3.557572e-001, 3.557548e-001, 3.557524e-001, 3.557501e-001, 3.557477e-001, 3.557453e-001, 3.557429e-001, 3.557406e-001, 3.557382e-001, 3.557358e-001, 3.557335e-001, 3.557311e-001, 3.557287e-001, 3.557263e-001, 3.557240e-001, 3.557216e-001, 3.557192e-001, 3.557168e-001, 3.557145e-001, 3.557121e-001, 3.557097e-001, 3.557073e-001, 3.557050e-001, 3.557026e-001, 3.557002e-001, 3.556978e-001, 3.556955e-001, 3.556931e-001, 3.556907e-001, 3.556883e-001, 3.556860e-001, 3.556836e-001, 3.556812e-001, 3.556788e-001, 3.556765e-001, 3.556741e-001, 3.556717e-001, 3.556693e-001, 3.556669e-001, 3.556646e-001, 3.556622e-001, 3.556598e-001, 3.556574e-001, 3.556550e-001, 3.556527e-001, 3.556503e-001, 3.556479e-001, 3.556455e-001, 3.556431e-001, 3.556408e-001, 3.556384e-001, 3.556360e-001, 3.556336e-001, 3.556312e-001, 3.556289e-001, 3.556265e-001, 3.556241e-001, 3.556217e-001, 3.556193e-001, 3.556169e-001, 3.556146e-001, 3.556122e-001, 3.556098e-001, 3.556074e-001, 3.556050e-001, 3.556026e-001, 3.556003e-001, 3.555979e-001, 3.555955e-001, 3.555931e-001, 3.555907e-001, 3.555883e-001, 
3.555860e-001, 3.555836e-001, 3.555812e-001, 3.555788e-001, 3.555764e-001, 3.555740e-001, 3.555716e-001, 3.555692e-001, 3.555669e-001, 3.555645e-001, 3.555621e-001, 3.555597e-001, 3.555573e-001, 3.555549e-001, 3.555525e-001, 3.555501e-001, 3.555478e-001, 3.555454e-001, 3.555430e-001, 3.555406e-001, 3.555382e-001, 3.555358e-001, 3.555334e-001, 3.555310e-001, 3.555286e-001, 3.555262e-001, 3.555239e-001, 3.555215e-001, 3.555191e-001, 3.555167e-001, 3.555143e-001, 3.555119e-001, 3.555095e-001, 3.555071e-001, 3.555047e-001, 3.555023e-001, 3.554999e-001, 3.554975e-001, 3.554951e-001, 3.554927e-001, 3.554904e-001, 3.554880e-001, 3.554856e-001, 3.554832e-001, 3.554808e-001, 3.554784e-001, 3.554760e-001, 3.554736e-001, 3.554712e-001, 3.554688e-001, 3.554664e-001, 3.554640e-001, 3.554616e-001, 3.554592e-001, 3.554568e-001, 3.554544e-001, 3.554520e-001, 3.554496e-001, 3.554472e-001, 3.554448e-001, 3.554424e-001, 3.554400e-001, 3.554376e-001, 3.554352e-001, 3.554328e-001, 3.554304e-001, 3.554280e-001, 3.554256e-001, 3.554232e-001, 3.554208e-001, 3.554184e-001, 3.554160e-001, 3.554136e-001, 3.554112e-001, 3.554088e-001, 3.554064e-001, 3.554040e-001, 3.554016e-001, 3.553992e-001, 3.553968e-001, 3.553944e-001, 3.553920e-001, 3.553896e-001, 3.553872e-001, 3.553848e-001, 3.553824e-001, 3.553800e-001, 3.553776e-001, 3.553752e-001, 3.553728e-001, 3.553704e-001, 3.553680e-001, 3.553656e-001, 3.553632e-001, 3.553607e-001, 3.553583e-001, 3.553559e-001, 3.553535e-001, 3.553511e-001, 3.553487e-001, 
3.553463e-001, 3.553439e-001, 3.553415e-001, 3.553391e-001, 3.553367e-001, 3.553343e-001, 3.553319e-001, 3.553295e-001, 3.553270e-001, 3.553246e-001, 3.553222e-001, 3.553198e-001, 3.553174e-001, 3.553150e-001, 3.553126e-001, 3.553102e-001, 3.553078e-001, 3.553054e-001, 3.553029e-001, 3.553005e-001, 3.552981e-001, 3.552957e-001, 3.552933e-001, 3.552909e-001, 3.552885e-001, 3.552861e-001, 3.552837e-001, 3.552812e-001, 3.552788e-001, 3.552764e-001, 3.552740e-001, 3.552716e-001, 3.552692e-001, 3.552668e-001, 3.552643e-001, 3.552619e-001, 3.552595e-001, 3.552571e-001, 3.552547e-001, 3.552523e-001, 3.552499e-001, 3.552474e-001, 3.552450e-001, 3.552426e-001, 3.552402e-001, 3.552378e-001, 3.552354e-001, 3.552329e-001, 3.552305e-001, 3.552281e-001, 3.552257e-001, 3.552233e-001, 3.552208e-001, 3.552184e-001, 3.552160e-001, 3.552136e-001, 3.552112e-001, 3.552088e-001, 3.552063e-001, 3.552039e-001, 3.552015e-001, 3.551991e-001, 3.551967e-001, 3.551942e-001, 3.551918e-001, 3.551894e-001, 3.551870e-001, 3.551846e-001, 3.551821e-001, 3.551797e-001, 3.551773e-001, 3.551749e-001, 3.551724e-001, 3.551700e-001, 3.551676e-001, 3.551652e-001, 3.551627e-001, 3.551603e-001, 3.551579e-001, 3.551555e-001, 3.551531e-001, 3.551506e-001, 3.551482e-001, 3.551458e-001, 3.551434e-001, 3.551409e-001, 3.551385e-001, 3.551361e-001, 3.551337e-001, 3.551312e-001, 3.551288e-001, 3.551264e-001, 3.551239e-001, 3.551215e-001, 3.551191e-001, 3.551167e-001, 3.551142e-001, 3.551118e-001, 3.551094e-001, 3.551070e-001, 
3.551045e-001, 3.551021e-001, 3.550997e-001, 3.550972e-001, 3.550948e-001, 3.550924e-001, 3.550900e-001, 3.550875e-001, 3.550851e-001, 3.550827e-001, 3.550802e-001, 3.550778e-001, 3.550754e-001, 3.550729e-001, 3.550705e-001, 3.550681e-001, 3.550656e-001, 3.550632e-001, 3.550608e-001, 3.550583e-001, 3.550559e-001, 3.550535e-001, 3.550510e-001, 3.550486e-001, 3.550462e-001, 3.550437e-001, 3.550413e-001, 3.550389e-001, 3.550364e-001, 3.550340e-001, 3.550316e-001, 3.550291e-001, 3.550267e-001, 3.550243e-001, 3.550218e-001, 3.550194e-001, 3.550170e-001, 3.550145e-001, 3.550121e-001, 3.550097e-001, 3.550072e-001, 3.550048e-001, 3.550023e-001, 3.549999e-001, 3.549975e-001, 3.549950e-001, 3.549926e-001, 3.549902e-001, 3.549877e-001, 3.549853e-001, 3.549828e-001, 3.549804e-001, 3.549780e-001, 3.549755e-001, 3.549731e-001, 3.549706e-001, 3.549682e-001, 3.549658e-001, 3.549633e-001, 3.549609e-001, 3.549584e-001, 3.549560e-001, 3.549536e-001, 3.549511e-001, 3.549487e-001, 3.549462e-001, 3.549438e-001, 3.549413e-001, 3.549389e-001, 3.549365e-001, 3.549340e-001, 3.549316e-001, 3.549291e-001, 3.549267e-001, 3.549242e-001, 3.549218e-001, 3.549193e-001, 3.549169e-001, 3.549145e-001, 3.549120e-001, 3.549096e-001, 3.549071e-001, 3.549047e-001, 3.549022e-001, 3.548998e-001, 3.548973e-001, 3.548949e-001, 3.548924e-001, 3.548900e-001, 3.548875e-001, 3.548851e-001, 3.548827e-001, 3.548802e-001, 3.548778e-001, 3.548753e-001, 3.548729e-001, 3.548704e-001, 3.548680e-001, 3.548655e-001, 3.548631e-001, 
3.548606e-001, 3.548582e-001, 3.548557e-001, 3.548533e-001, 3.548508e-001, 3.548484e-001, 3.548459e-001, 3.548435e-001, 3.548410e-001, 3.548386e-001, 3.548361e-001, 3.548337e-001, 3.548312e-001, 3.548287e-001, 3.548263e-001, 3.548238e-001, 3.548214e-001, 3.548189e-001, 3.548165e-001, 3.548140e-001, 3.548116e-001, 3.548091e-001, 3.548067e-001, 3.548042e-001, 3.548018e-001, 3.547993e-001, 3.547968e-001, 3.547944e-001, 3.547919e-001, 3.547895e-001, 3.547870e-001, 3.547846e-001, 3.547821e-001, 3.547797e-001, 3.547772e-001, 3.547747e-001, 3.547723e-001, 3.547698e-001, 3.547674e-001, 3.547649e-001, 3.547625e-001, 3.547600e-001, 3.547575e-001, 3.547551e-001, 3.547526e-001, 3.547502e-001, 3.547477e-001, 3.547452e-001, 3.547428e-001, 3.547403e-001, 3.547379e-001, 3.547354e-001, 3.547329e-001, 3.547305e-001, 3.547280e-001, 3.547256e-001, 3.547231e-001, 3.547206e-001, 3.547182e-001, 3.547157e-001, 3.547132e-001, 3.547108e-001, 3.547083e-001, 3.547059e-001, 3.547034e-001, 3.547009e-001, 3.546985e-001, 3.546960e-001, 3.546935e-001, 3.546911e-001, 3.546886e-001, 3.546861e-001, 3.546837e-001, 3.546812e-001, 3.546787e-001, 3.546763e-001, 3.546738e-001, 3.546714e-001, 3.546689e-001, 3.546664e-001, 3.546640e-001, 3.546615e-001, 3.546590e-001, 3.546566e-001, 3.546541e-001, 3.546516e-001, 3.546491e-001, 3.546467e-001, 3.546442e-001, 3.546417e-001, 3.546393e-001, 3.546368e-001, 3.546343e-001, 3.546319e-001, 3.546294e-001, 3.546269e-001, 3.546245e-001, 3.546220e-001, 3.546195e-001, 3.546170e-001, 
3.546146e-001, 3.546121e-001, 3.546096e-001, 3.546072e-001, 3.546047e-001, 3.546022e-001, 3.545997e-001, 3.545973e-001, 3.545948e-001, 3.545923e-001, 3.545899e-001, 3.545874e-001, 3.545849e-001, 3.545824e-001, 3.545800e-001, 3.545775e-001, 3.545750e-001, 3.545725e-001, 3.545701e-001, 3.545676e-001, 3.545651e-001, 3.545626e-001, 3.545602e-001, 3.545577e-001, 3.545552e-001, 3.545527e-001, 3.545503e-001, 3.545478e-001, 3.545453e-001, 3.545428e-001, 3.545403e-001, 3.545379e-001, 3.545354e-001, 3.545329e-001, 3.545304e-001, 3.545280e-001, 3.545255e-001, 3.545230e-001, 3.545205e-001, 3.545180e-001, 3.545156e-001, 3.545131e-001, 3.545106e-001, 3.545081e-001, 3.545056e-001, 3.545032e-001, 3.545007e-001, 3.544982e-001, 3.544957e-001, 3.544932e-001, 3.544908e-001, 3.544883e-001, 3.544858e-001, 3.544833e-001, 3.544808e-001, 3.544783e-001, 3.544759e-001, 3.544734e-001, 3.544709e-001, 3.544684e-001, 3.544659e-001, 3.544634e-001, 3.544610e-001, 3.544585e-001, 3.544560e-001, 3.544535e-001, 3.544510e-001, 3.544485e-001, 3.544461e-001, 3.544436e-001, 3.544411e-001, 3.544386e-001, 3.544361e-001, 3.544336e-001, 3.544311e-001, 3.544287e-001, 3.544262e-001, 3.544237e-001, 3.544212e-001, 3.544187e-001, 3.544162e-001, 3.544137e-001, 3.544112e-001, 3.544087e-001, 3.544063e-001, 3.544038e-001, 3.544013e-001, 3.543988e-001, 3.543963e-001, 3.543938e-001, 3.543913e-001, 3.543888e-001, 3.543863e-001, 3.543839e-001, 3.543814e-001, 3.543789e-001, 3.543764e-001, 3.543739e-001, 3.543714e-001, 3.543689e-001, 
3.543664e-001, 3.543639e-001, 3.543614e-001, 3.543589e-001, 3.543564e-001, 3.543539e-001, 3.543515e-001, 3.543490e-001, 3.543465e-001, 3.543440e-001, 3.543415e-001, 3.543390e-001, 3.543365e-001, 3.543340e-001, 3.543315e-001, 3.543290e-001, 3.543265e-001, 3.543240e-001, 3.543215e-001, 3.543190e-001, 3.543165e-001, 3.543140e-001, 3.543115e-001, 3.543090e-001, 3.543065e-001, 3.543040e-001, 3.543015e-001, 3.542990e-001, 3.542965e-001, 3.542940e-001, 3.542915e-001, 3.542890e-001, 3.542866e-001, 3.542841e-001, 3.542816e-001, 3.542791e-001, 3.542766e-001, 3.542741e-001, 3.542716e-001, 3.542691e-001, 3.542666e-001, 3.542641e-001, 3.542615e-001, 3.542590e-001, 3.542565e-001, 3.542540e-001, 3.542515e-001, 3.542490e-001, 3.542465e-001, 3.542440e-001, 3.542415e-001, 3.542390e-001, 3.542365e-001, 3.542340e-001, 3.542315e-001, 3.542290e-001, 3.542265e-001, 3.542240e-001, 3.542215e-001, 3.542190e-001, 3.542165e-001, 3.542140e-001, 3.542115e-001, 3.542090e-001, 3.542065e-001, 3.542040e-001, 3.542015e-001, 3.541990e-001, 3.541964e-001, 3.541939e-001, 3.541914e-001, 3.541889e-001, 3.541864e-001, 3.541839e-001, 3.541814e-001, 3.541789e-001, 3.541764e-001, 3.541739e-001, 3.541714e-001, 3.541689e-001, 3.541664e-001, 3.541638e-001, 3.541613e-001, 3.541588e-001, 3.541563e-001, 3.541538e-001, 3.541513e-001, 3.541488e-001, 3.541463e-001, 3.541438e-001, 3.541413e-001, 3.541387e-001, 3.541362e-001, 3.541337e-001, 3.541312e-001, 3.541287e-001, 3.541262e-001, 3.541237e-001, 3.541212e-001, 3.541186e-001, 
3.541161e-001, 3.541136e-001, 3.541111e-001, 3.541086e-001, 3.541061e-001, 3.541036e-001, 3.541010e-001, 3.540985e-001, 3.540960e-001, 3.540935e-001, 3.540910e-001, 3.540885e-001, 3.540860e-001, 3.540834e-001, 3.540809e-001, 3.540784e-001, 3.540759e-001, 3.540734e-001, 3.540709e-001, 3.540683e-001, 3.540658e-001, 3.540633e-001, 3.540608e-001, 3.540583e-001, 3.540557e-001, 3.540532e-001, 3.540507e-001, 3.540482e-001, 3.540457e-001, 3.540432e-001, 3.540406e-001, 3.540381e-001, 3.540356e-001, 3.540331e-001, 3.540306e-001, 3.540280e-001, 3.540255e-001, 3.540230e-001, 3.540205e-001, 3.540179e-001, 3.540154e-001, 3.540129e-001, 3.540104e-001, 3.540079e-001, 3.540053e-001, 3.540028e-001, 3.540003e-001, 3.539978e-001, 3.539952e-001, 3.539927e-001, 3.539902e-001, 3.539877e-001, 3.539851e-001, 3.539826e-001, 3.539801e-001, 3.539776e-001, 3.539750e-001, 3.539725e-001, 3.539700e-001, 3.539675e-001, 3.539649e-001, 3.539624e-001, 3.539599e-001, 3.539574e-001, 3.539548e-001, 3.539523e-001, 3.539498e-001, 3.539473e-001, 3.539447e-001, 3.539422e-001, 3.539397e-001, 3.539371e-001, 3.539346e-001, 3.539321e-001, 3.539296e-001, 3.539270e-001, 3.539245e-001, 3.539220e-001, 3.539194e-001, 3.539169e-001, 3.539144e-001, 3.539118e-001, 3.539093e-001, 3.539068e-001, 3.539043e-001, 3.539017e-001, 3.538992e-001, 3.538967e-001, 3.538941e-001, 3.538916e-001, 3.538891e-001, 3.538865e-001, 3.538840e-001, 3.538815e-001, 3.538789e-001, 3.538764e-001, 3.538739e-001, 3.538713e-001, 3.538688e-001, 3.538663e-001, 
3.538637e-001, 3.538612e-001, 3.538587e-001, 3.538561e-001, 3.538536e-001, 3.538511e-001, 3.538485e-001, 3.538460e-001, 3.538434e-001, 3.538409e-001, 3.538384e-001, 3.538358e-001, 3.538333e-001, 3.538308e-001, 3.538282e-001, 3.538257e-001, 3.538232e-001, 3.538206e-001, 3.538181e-001, 3.538155e-001, 3.538130e-001, 3.538105e-001, 3.538079e-001, 3.538054e-001, 3.538028e-001, 3.538003e-001, 3.537978e-001, 3.537952e-001, 3.537927e-001, 3.537901e-001, 3.537876e-001, 3.537851e-001, 3.537825e-001, 3.537800e-001, 3.537774e-001, 3.537749e-001, 3.537724e-001, 3.537698e-001, 3.537673e-001, 3.537647e-001, 3.537622e-001, 3.537596e-001, 3.537571e-001, 3.537546e-001, 3.537520e-001, 3.537495e-001, 3.537469e-001, 3.537444e-001, 3.537418e-001, 3.537393e-001, 3.537367e-001, 3.537342e-001, 3.537317e-001, 3.537291e-001, 3.537266e-001, 3.537240e-001, 3.537215e-001, 3.537189e-001, 3.537164e-001, 3.537138e-001, 3.537113e-001, 3.537087e-001, 3.537062e-001, 3.537036e-001, 3.537011e-001, 3.536985e-001, 3.536960e-001, 3.536934e-001, 3.536909e-001, 3.536883e-001, 3.536858e-001, 3.536832e-001, 3.536807e-001, 3.536781e-001, 3.536756e-001, 3.536730e-001, 3.536705e-001, 3.536679e-001, 3.536654e-001, 3.536628e-001, 3.536603e-001, 3.536577e-001, 3.536552e-001, 3.536526e-001, 3.536501e-001, 3.536475e-001, 3.536450e-001, 3.536424e-001, 3.536399e-001, 3.536373e-001, 3.536348e-001, 3.536322e-001, 3.536297e-001, 3.536271e-001, 3.536246e-001, 3.536220e-001, 3.536194e-001, 3.536169e-001, 3.536143e-001, 3.536118e-001, 
3.536092e-001, 3.536067e-001, 3.536041e-001, 3.536016e-001, 3.535990e-001, 3.535964e-001, 3.535939e-001, 3.535913e-001, 3.535888e-001, 3.535862e-001, 3.535837e-001, 3.535811e-001, 3.535785e-001, 3.535760e-001, 3.535734e-001, 3.535709e-001, 3.535683e-001, 3.535658e-001, 3.535632e-001, 3.535606e-001, 3.535581e-001, 3.535555e-001, 3.535530e-001, 3.535504e-001, 3.535478e-001, 3.535453e-001, 3.535427e-001, 3.535401e-001, 3.535376e-001, 3.535350e-001, 3.535325e-001, 3.535299e-001, 3.535273e-001, 3.535248e-001, 3.535222e-001, 3.535197e-001, 3.535171e-001, 3.535145e-001, 3.535120e-001, 3.535094e-001, 3.535068e-001, 3.535043e-001, 3.535017e-001, 3.534991e-001, 3.534966e-001, 3.534940e-001, 3.534914e-001, 3.534889e-001, 3.534863e-001, 3.534837e-001, 3.534812e-001, 3.534786e-001, 3.534761e-001, 3.534735e-001, 3.534709e-001, 3.534683e-001, 3.534658e-001, 3.534632e-001, 3.534606e-001, 3.534581e-001, 3.534555e-001, 3.534529e-001, 3.534504e-001, 3.534478e-001, 3.534452e-001, 3.534427e-001, 3.534401e-001, 3.534375e-001, 3.534350e-001, 3.534324e-001, 3.534298e-001, 3.534272e-001, 3.534247e-001, 3.534221e-001, 3.534195e-001, 3.534170e-001, 3.534144e-001, 3.534118e-001, 3.534092e-001, 3.534067e-001, 3.534041e-001, 3.534015e-001, 3.533990e-001, 3.533964e-001, 3.533938e-001, 3.533912e-001, 3.533887e-001, 3.533861e-001, 3.533835e-001, 3.533809e-001, 3.533784e-001, 3.533758e-001, 3.533732e-001, 3.533706e-001, 3.533681e-001, 3.533655e-001, 3.533629e-001, 3.533603e-001, 3.533578e-001, 3.533552e-001, 
3.533526e-001, 3.533500e-001, 3.533475e-001, 3.533449e-001, 3.533423e-001, 3.533397e-001, 3.533372e-001, 3.533346e-001, 3.533320e-001, 3.533294e-001, 3.533268e-001, 3.533243e-001, 3.533217e-001, 3.533191e-001, 3.533165e-001, 3.533139e-001, 3.533114e-001, 3.533088e-001, 3.533062e-001, 3.533036e-001, 3.533010e-001, 3.532985e-001, 3.532959e-001, 3.532933e-001, 3.532907e-001, 3.532881e-001, 3.532856e-001, 3.532830e-001, 3.532804e-001, 3.532778e-001, 3.532752e-001, 3.532726e-001, 3.532701e-001, 3.532675e-001, 3.532649e-001, 3.532623e-001, 3.532597e-001, 3.532571e-001, 3.532546e-001, 3.532520e-001, 3.532494e-001, 3.532468e-001, 3.532442e-001, 3.532416e-001, 3.532390e-001, 3.532365e-001, 3.532339e-001, 3.532313e-001, 3.532287e-001, 3.532261e-001, 3.532235e-001, 3.532209e-001, 3.532183e-001, 3.532158e-001, 3.532132e-001, 3.532106e-001, 3.532080e-001, 3.532054e-001, 3.532028e-001, 3.532002e-001, 3.531976e-001, 3.531950e-001, 3.531925e-001, 3.531899e-001, 3.531873e-001, 3.531847e-001, 3.531821e-001, 3.531795e-001, 3.531769e-001, 3.531743e-001, 3.531717e-001, 3.531691e-001, 3.531666e-001, 3.531640e-001, 3.531614e-001, 3.531588e-001, 3.531562e-001, 3.531536e-001, 3.531510e-001, 3.531484e-001, 3.531458e-001, 3.531432e-001, 3.531406e-001, 3.531380e-001, 3.531354e-001, 3.531328e-001, 3.531302e-001, 3.531277e-001, 3.531251e-001, 3.531225e-001, 3.531199e-001, 3.531173e-001, 3.531147e-001, 3.531121e-001, 3.531095e-001, 3.531069e-001, 3.531043e-001, 3.531017e-001, 3.530991e-001, 3.530965e-001, 
3.530939e-001, 3.530913e-001, 3.530887e-001, 3.530861e-001, 3.530835e-001, 3.530809e-001, 3.530783e-001, 3.530757e-001, 3.530731e-001, 3.530705e-001, 3.530679e-001, 3.530653e-001, 3.530627e-001, 3.530601e-001, 3.530575e-001, 3.530549e-001, 3.530523e-001, 3.530497e-001, 3.530471e-001, 3.530445e-001, 3.530419e-001, 3.530393e-001, 3.530367e-001, 3.530341e-001, 3.530315e-001, 3.530289e-001, 3.530263e-001, 3.530237e-001, 3.530211e-001, 3.530185e-001, 3.530159e-001, 3.530133e-001, 3.530107e-001, 3.530081e-001, 3.530055e-001, 3.530029e-001, 3.530003e-001, 3.529976e-001, 3.529950e-001, 3.529924e-001, 3.529898e-001, 3.529872e-001, 3.529846e-001, 3.529820e-001, 3.529794e-001, 3.529768e-001, 3.529742e-001, 3.529716e-001, 3.529690e-001, 3.529664e-001, 3.529638e-001, 3.529612e-001, 3.529585e-001, 3.529559e-001, 3.529533e-001, 3.529507e-001, 3.529481e-001, 3.529455e-001, 3.529429e-001, 3.529403e-001, 3.529377e-001, 3.529351e-001, 3.529324e-001, 3.529298e-001, 3.529272e-001, 3.529246e-001, 3.529220e-001, 3.529194e-001, 3.529168e-001, 3.529142e-001, 3.529116e-001, 3.529089e-001, 3.529063e-001, 3.529037e-001, 3.529011e-001, 3.528985e-001, 3.528959e-001, 3.528933e-001, 3.528907e-001, 3.528880e-001, 3.528854e-001, 3.528828e-001, 3.528802e-001, 3.528776e-001, 3.528750e-001, 3.528723e-001, 3.528697e-001, 3.528671e-001, 3.528645e-001, 3.528619e-001, 3.528593e-001, 3.528567e-001, 3.528540e-001, 3.528514e-001, 3.528488e-001, 3.528462e-001, 3.528436e-001, 3.528409e-001, 3.528383e-001, 3.528357e-001, 
3.528331e-001, 3.528305e-001, 3.528279e-001, 3.528252e-001, 3.528226e-001, 3.528200e-001, 3.528174e-001, 3.528148e-001, 3.528121e-001, 3.528095e-001, 3.528069e-001, 3.528043e-001, 3.528017e-001, 3.527990e-001, 3.527964e-001, 3.527938e-001, 3.527912e-001, 3.527885e-001, 3.527859e-001, 3.527833e-001, 3.527807e-001, 3.527781e-001, 3.527754e-001, 3.527728e-001, 3.527702e-001, 3.527676e-001, 3.527649e-001, 3.527623e-001, 3.527597e-001, 3.527571e-001, 3.527544e-001, 3.527518e-001, 3.527492e-001, 3.527466e-001, 3.527439e-001, 3.527413e-001, 3.527387e-001, 3.527361e-001, 3.527334e-001, 3.527308e-001, 3.527282e-001, 3.527256e-001, 3.527229e-001, 3.527203e-001, 3.527177e-001, 3.527150e-001, 3.527124e-001, 3.527098e-001, 3.527072e-001, 3.527045e-001, 3.527019e-001, 3.526993e-001, 3.526966e-001, 3.526940e-001, 3.526914e-001, 3.526888e-001, 3.526861e-001, 3.526835e-001, 3.526809e-001, 3.526782e-001, 3.526756e-001, 3.526730e-001, 3.526703e-001, 3.526677e-001, 3.526651e-001, 3.526624e-001, 3.526598e-001, 3.526572e-001, 3.526545e-001, 3.526519e-001, 3.526493e-001, 3.526466e-001, 3.526440e-001, 3.526414e-001, 3.526387e-001, 3.526361e-001, 3.526335e-001, 3.526308e-001, 3.526282e-001, 3.526256e-001, 3.526229e-001, 3.526203e-001, 3.526177e-001, 3.526150e-001, 3.526124e-001, 3.526098e-001, 3.526071e-001, 3.526045e-001, 3.526019e-001, 3.525992e-001, 3.525966e-001, 3.525939e-001, 3.525913e-001, 3.525887e-001, 3.525860e-001, 3.525834e-001, 3.525807e-001, 3.525781e-001, 3.525755e-001, 3.525728e-001, 
3.525702e-001, 3.525676e-001, 3.525649e-001, 3.525623e-001, 3.525596e-001, 3.525570e-001, 3.525544e-001, 3.525517e-001, 3.525491e-001, 3.525464e-001, 3.525438e-001, 3.525411e-001, 3.525385e-001, 3.525359e-001, 3.525332e-001, 3.525306e-001, 3.525279e-001, 3.525253e-001, 3.525226e-001, 3.525200e-001, 3.525174e-001, 3.525147e-001, 3.525121e-001, 3.525094e-001, 3.525068e-001, 3.525041e-001, 3.525015e-001, 3.524989e-001, 3.524962e-001, 3.524936e-001, 3.524909e-001, 3.524883e-001, 3.524856e-001, 3.524830e-001, 3.524803e-001, 3.524777e-001, 3.524750e-001, 3.524724e-001, 3.524697e-001, 3.524671e-001, 3.524644e-001, 3.524618e-001, 3.524592e-001, 3.524565e-001, 3.524539e-001, 3.524512e-001, 3.524486e-001, 3.524459e-001, 3.524433e-001, 3.524406e-001, 3.524380e-001, 3.524353e-001, 3.524327e-001, 3.524300e-001, 3.524274e-001, 3.524247e-001, 3.524221e-001, 3.524194e-001, 3.524168e-001, 3.524141e-001, 3.524114e-001, 3.524088e-001, 3.524061e-001, 3.524035e-001, 3.524008e-001, 3.523982e-001, 3.523955e-001, 3.523929e-001, 3.523902e-001, 3.523876e-001, 3.523849e-001, 3.523823e-001, 3.523796e-001, 3.523770e-001, 3.523743e-001, 3.523716e-001, 3.523690e-001, 3.523663e-001, 3.523637e-001, 3.523610e-001, 3.523584e-001, 3.523557e-001, 3.523531e-001, 3.523504e-001, 3.523477e-001, 3.523451e-001, 3.523424e-001, 3.523398e-001, 3.523371e-001, 3.523345e-001, 3.523318e-001, 3.523291e-001, 3.523265e-001, 3.523238e-001, 3.523212e-001, 3.523185e-001, 3.523158e-001, 3.523132e-001, 3.523105e-001, 3.523079e-001, 
3.523052e-001, 3.523025e-001, 3.522999e-001, 3.522972e-001, 3.522946e-001, 3.522919e-001, 3.522892e-001, 3.522866e-001, 3.522839e-001, 3.522813e-001, 3.522786e-001, 3.522759e-001, 3.522733e-001, 3.522706e-001, 3.522679e-001, 3.522653e-001, 3.522626e-001, 3.522599e-001, 3.522573e-001, 3.522546e-001, 3.522520e-001, 3.522493e-001, 3.522466e-001, 3.522440e-001, 3.522413e-001, 3.522386e-001, 3.522360e-001, 3.522333e-001, 3.522306e-001, 3.522280e-001, 3.522253e-001, 3.522226e-001, 3.522200e-001, 3.522173e-001, 3.522146e-001, 3.522120e-001, 3.522093e-001, 3.522066e-001, 3.522040e-001, 3.522013e-001, 3.521986e-001, 3.521960e-001, 3.521933e-001, 3.521906e-001, 3.521879e-001, 3.521853e-001, 3.521826e-001, 3.521799e-001, 3.521773e-001, 3.521746e-001, 3.521719e-001, 3.521693e-001, 3.521666e-001, 3.521639e-001, 3.521612e-001, 3.521586e-001, 3.521559e-001, 3.521532e-001, 3.521506e-001, 3.521479e-001, 3.521452e-001, 3.521425e-001, 3.521399e-001, 3.521372e-001, 3.521345e-001, 3.521318e-001, 3.521292e-001, 3.521265e-001, 3.521238e-001, 3.521211e-001, 3.521185e-001, 3.521158e-001, 3.521131e-001, 3.521104e-001, 3.521078e-001, 3.521051e-001, 3.521024e-001, 3.520997e-001, 3.520971e-001, 3.520944e-001, 3.520917e-001, 3.520890e-001, 3.520864e-001, 3.520837e-001, 3.520810e-001, 3.520783e-001, 3.520756e-001, 3.520730e-001, 3.520703e-001, 3.520676e-001, 3.520649e-001, 3.520623e-001, 3.520596e-001, 3.520569e-001, 3.520542e-001, 3.520515e-001, 3.520489e-001, 3.520462e-001, 3.520435e-001, 3.520408e-001, 
3.520381e-001, 3.520355e-001, 3.520328e-001, 3.520301e-001, 3.520274e-001, 3.520247e-001, 3.520220e-001, 3.520194e-001, 3.520167e-001, 3.520140e-001, 3.520113e-001, 3.520086e-001, 3.520059e-001, 3.520033e-001, 3.520006e-001, 3.519979e-001, 3.519952e-001, 3.519925e-001, 3.519898e-001, 3.519872e-001, 3.519845e-001, 3.519818e-001, 3.519791e-001, 3.519764e-001, 3.519737e-001, 3.519710e-001, 3.519684e-001, 3.519657e-001, 3.519630e-001, 3.519603e-001, 3.519576e-001, 3.519549e-001, 3.519522e-001, 3.519495e-001, 3.519469e-001, 3.519442e-001, 3.519415e-001, 3.519388e-001, 3.519361e-001, 3.519334e-001, 3.519307e-001, 3.519280e-001, 3.519253e-001, 3.519227e-001, 3.519200e-001, 3.519173e-001, 3.519146e-001, 3.519119e-001, 3.519092e-001, 3.519065e-001, 3.519038e-001, 3.519011e-001, 3.518984e-001, 3.518957e-001, 3.518930e-001, 3.518904e-001, 3.518877e-001, 3.518850e-001, 3.518823e-001, 3.518796e-001, 3.518769e-001, 3.518742e-001, 3.518715e-001, 3.518688e-001, 3.518661e-001, 3.518634e-001, 3.518607e-001, 3.518580e-001, 3.518553e-001, 3.518526e-001, 3.518499e-001, 3.518472e-001, 3.518446e-001, 3.518419e-001, 3.518392e-001, 3.518365e-001, 3.518338e-001, 3.518311e-001, 3.518284e-001, 3.518257e-001, 3.518230e-001, 3.518203e-001, 3.518176e-001, 3.518149e-001, 3.518122e-001, 3.518095e-001, 3.518068e-001, 3.518041e-001, 3.518014e-001, 3.517987e-001, 3.517960e-001, 3.517933e-001, 3.517906e-001, 3.517879e-001, 3.517852e-001, 3.517825e-001, 3.517798e-001, 3.517771e-001, 3.517744e-001, 3.517717e-001, 
3.517690e-001, 3.517663e-001, 3.517636e-001, 3.517609e-001, 3.517582e-001, 3.517555e-001, 3.517528e-001, 3.517501e-001, 3.517474e-001, 3.517447e-001, 3.517420e-001, 3.517392e-001, 3.517365e-001, 3.517338e-001, 3.517311e-001, 3.517284e-001, 3.517257e-001, 3.517230e-001, 3.517203e-001, 3.517176e-001, 3.517149e-001, 3.517122e-001, 3.517095e-001, 3.517068e-001, 3.517041e-001, 3.517014e-001, 3.516987e-001, 3.516960e-001, 3.516932e-001, 3.516905e-001, 3.516878e-001, 3.516851e-001, 3.516824e-001, 3.516797e-001, 3.516770e-001, 3.516743e-001, 3.516716e-001, 3.516689e-001, 3.516662e-001, 3.516635e-001, 3.516607e-001, 3.516580e-001, 3.516553e-001, 3.516526e-001, 3.516499e-001, 3.516472e-001, 3.516445e-001, 3.516418e-001, 3.516391e-001, 3.516363e-001, 3.516336e-001, 3.516309e-001, 3.516282e-001, 3.516255e-001, 3.516228e-001, 3.516201e-001, 3.516174e-001, 3.516146e-001, 3.516119e-001, 3.516092e-001, 3.516065e-001, 3.516038e-001, 3.516011e-001, 3.515984e-001, 3.515956e-001, 3.515929e-001, 3.515902e-001, 3.515875e-001, 3.515848e-001, 3.515821e-001, 3.515793e-001, 3.515766e-001, 3.515739e-001, 3.515712e-001, 3.515685e-001, 3.515658e-001, 3.515630e-001, 3.515603e-001, 3.515576e-001, 3.515549e-001, 3.515522e-001, 3.515494e-001, 3.515467e-001, 3.515440e-001, 3.515413e-001, 3.515386e-001, 3.515359e-001, 3.515331e-001, 3.515304e-001, 3.515277e-001, 3.515250e-001, 3.515223e-001, 3.515195e-001, 3.515168e-001, 3.515141e-001, 3.515114e-001, 3.515086e-001, 3.515059e-001, 3.515032e-001, 3.515005e-001, 
3.514978e-001, 3.514950e-001, 3.514923e-001, 3.514896e-001, 3.514869e-001, 3.514841e-001, 3.514814e-001, 3.514787e-001, 3.514760e-001, 3.514732e-001, 3.514705e-001, 3.514678e-001, 3.514651e-001, 3.514623e-001, 3.514596e-001, 3.514569e-001, 3.514542e-001, 3.514514e-001, 3.514487e-001, 3.514460e-001, 3.514433e-001, 3.514405e-001, 3.514378e-001, 3.514351e-001, 3.514324e-001, 3.514296e-001, 3.514269e-001, 3.514242e-001, 3.514214e-001, 3.514187e-001, 3.514160e-001, 3.514133e-001, 3.514105e-001, 3.514078e-001, 3.514051e-001, 3.514023e-001, 3.513996e-001, 3.513969e-001, 3.513941e-001, 3.513914e-001, 3.513887e-001, 3.513860e-001, 3.513832e-001, 3.513805e-001, 3.513778e-001, 3.513750e-001, 3.513723e-001, 3.513696e-001, 3.513668e-001, 3.513641e-001, 3.513614e-001, 3.513586e-001, 3.513559e-001, 3.513532e-001, 3.513504e-001, 3.513477e-001, 3.513450e-001, 3.513422e-001, 3.513395e-001, 3.513368e-001, 3.513340e-001, 3.513313e-001, 3.513286e-001, 3.513258e-001, 3.513231e-001, 3.513203e-001, 3.513176e-001, 3.513149e-001, 3.513121e-001, 3.513094e-001, 3.513067e-001, 3.513039e-001, 3.513012e-001, 3.512985e-001, 3.512957e-001, 3.512930e-001, 3.512902e-001, 3.512875e-001, 3.512848e-001, 3.512820e-001, 3.512793e-001, 3.512765e-001, 3.512738e-001, 3.512711e-001, 3.512683e-001, 3.512656e-001, 3.512628e-001, 3.512601e-001, 3.512574e-001, 3.512546e-001, 3.512519e-001, 3.512491e-001, 3.512464e-001, 3.512437e-001, 3.512409e-001, 3.512382e-001, 3.512354e-001, 3.512327e-001, 3.512299e-001, 3.512272e-001, 
3.512245e-001, 3.512217e-001, 3.512190e-001, 3.512162e-001, 3.512135e-001, 3.512107e-001, 3.512080e-001, 3.512053e-001, 3.512025e-001, 3.511998e-001, 3.511970e-001, 3.511943e-001, 3.511915e-001, 3.511888e-001, 3.511860e-001, 3.511833e-001, 3.511805e-001, 3.511778e-001, 3.511750e-001, 3.511723e-001, 3.511696e-001, 3.511668e-001, 3.511641e-001, 3.511613e-001, 3.511586e-001, 3.511558e-001, 3.511531e-001, 3.511503e-001, 3.511476e-001, 3.511448e-001, 3.511421e-001, 3.511393e-001, 3.511366e-001, 3.511338e-001, 3.511311e-001, 3.511283e-001, 3.511256e-001, 3.511228e-001, 3.511201e-001, 3.511173e-001, 3.511146e-001, 3.511118e-001, 3.511091e-001, 3.511063e-001, 3.511036e-001, 3.511008e-001, 3.510981e-001, 3.510953e-001, 3.510925e-001, 3.510898e-001, 3.510870e-001, 3.510843e-001, 3.510815e-001, 3.510788e-001, 3.510760e-001, 3.510733e-001, 3.510705e-001, 3.510678e-001, 3.510650e-001, 3.510622e-001, 3.510595e-001, 3.510567e-001, 3.510540e-001, 3.510512e-001, 3.510485e-001, 3.510457e-001, 3.510430e-001, 3.510402e-001, 3.510374e-001, 3.510347e-001, 3.510319e-001, 3.510292e-001, 3.510264e-001, 3.510236e-001, 3.510209e-001, 3.510181e-001, 3.510154e-001, 3.510126e-001, 3.510099e-001, 3.510071e-001, 3.510043e-001, 3.510016e-001, 3.509988e-001, 3.509961e-001, 3.509933e-001, 3.509905e-001, 3.509878e-001, 3.509850e-001, 3.509823e-001, 3.509795e-001, 3.509767e-001, 3.509740e-001, 3.509712e-001, 3.509684e-001, 3.509657e-001, 3.509629e-001, 3.509602e-001, 3.509574e-001, 3.509546e-001, 3.509519e-001, 
3.509491e-001, 3.509463e-001, 3.509436e-001, 3.509408e-001, 3.509380e-001, 3.509353e-001, 3.509325e-001, 3.509297e-001, 3.509270e-001, 3.509242e-001, 3.509214e-001, 3.509187e-001, 3.509159e-001, 3.509131e-001, 3.509104e-001, 3.509076e-001, 3.509048e-001, 3.509021e-001, 3.508993e-001, 3.508965e-001, 3.508938e-001, 3.508910e-001, 3.508882e-001, 3.508855e-001, 3.508827e-001, 3.508799e-001, 3.508772e-001, 3.508744e-001, 3.508716e-001, 3.508689e-001, 3.508661e-001, 3.508633e-001, 3.508605e-001, 3.508578e-001, 3.508550e-001, 3.508522e-001, 3.508495e-001, 3.508467e-001, 3.508439e-001, 3.508411e-001, 3.508384e-001, 3.508356e-001, 3.508328e-001, 3.508301e-001, 3.508273e-001, 3.508245e-001, 3.508217e-001, 3.508190e-001, 3.508162e-001, 3.508134e-001, 3.508106e-001, 3.508079e-001, 3.508051e-001, 3.508023e-001, 3.507995e-001, 3.507968e-001, 3.507940e-001, 3.507912e-001, 3.507884e-001, 3.507857e-001, 3.507829e-001, 3.507801e-001, 3.507773e-001, 3.507746e-001, 3.507718e-001, 3.507690e-001, 3.507662e-001, 3.507635e-001, 3.507607e-001, 3.507579e-001, 3.507551e-001, 3.507523e-001, 3.507496e-001, 3.507468e-001, 3.507440e-001, 3.507412e-001, 3.507384e-001, 3.507357e-001, 3.507329e-001, 3.507301e-001, 3.507273e-001, 3.507245e-001, 3.507218e-001, 3.507190e-001, 3.507162e-001, 3.507134e-001, 3.507106e-001, 3.507079e-001, 3.507051e-001, 3.507023e-001, 3.506995e-001, 3.506967e-001, 3.506939e-001, 3.506912e-001, 3.506884e-001, 3.506856e-001, 3.506828e-001, 3.506800e-001, 3.506772e-001, 3.506745e-001, 
3.506717e-001, 3.506689e-001, 3.506661e-001, 3.506633e-001, 3.506605e-001, 3.506577e-001, 3.506550e-001, 3.506522e-001, 3.506494e-001, 3.506466e-001, 3.506438e-001, 3.506410e-001, 3.506382e-001, 3.506355e-001, 3.506327e-001, 3.506299e-001, 3.506271e-001, 3.506243e-001, 3.506215e-001, 3.506187e-001, 3.506159e-001, 3.506132e-001, 3.506104e-001, 3.506076e-001, 3.506048e-001, 3.506020e-001, 3.505992e-001, 3.505964e-001, 3.505936e-001, 3.505908e-001, 3.505880e-001, 3.505853e-001, 3.505825e-001, 3.505797e-001, 3.505769e-001, 3.505741e-001, 3.505713e-001, 3.505685e-001, 3.505657e-001, 3.505629e-001, 3.505601e-001, 3.505573e-001, 3.505545e-001, 3.505517e-001, 3.505490e-001, 3.505462e-001, 3.505434e-001, 3.505406e-001, 3.505378e-001, 3.505350e-001, 3.505322e-001, 3.505294e-001, 3.505266e-001, 3.505238e-001, 3.505210e-001, 3.505182e-001, 3.505154e-001, 3.505126e-001, 3.505098e-001, 3.505070e-001, 3.505042e-001, 3.505014e-001, 3.504986e-001, 3.504958e-001, 3.504930e-001, 3.504902e-001, 3.504874e-001, 3.504846e-001, 3.504819e-001, 3.504791e-001, 3.504763e-001, 3.504735e-001, 3.504707e-001, 3.504679e-001, 3.504651e-001, 3.504623e-001, 3.504595e-001, 3.504567e-001, 3.504539e-001, 3.504511e-001, 3.504483e-001, 3.504455e-001, 3.504427e-001, 3.504398e-001, 3.504370e-001, 3.504342e-001, 3.504314e-001, 3.504286e-001, 3.504258e-001, 3.504230e-001, 3.504202e-001, 3.504174e-001, 3.504146e-001, 3.504118e-001, 3.504090e-001, 3.504062e-001, 3.504034e-001, 3.504006e-001, 3.503978e-001, 3.503950e-001, 
3.503922e-001, 3.503894e-001, 3.503866e-001, 3.503838e-001, 3.503810e-001, 3.503782e-001, 3.503754e-001, 3.503726e-001, 3.503697e-001, 3.503669e-001, 3.503641e-001, 3.503613e-001, 3.503585e-001, 3.503557e-001, 3.503529e-001, 3.503501e-001, 3.503473e-001, 3.503445e-001, 3.503417e-001, 3.503389e-001, 3.503361e-001, 3.503332e-001, 3.503304e-001, 3.503276e-001, 3.503248e-001, 3.503220e-001, 3.503192e-001, 3.503164e-001, 3.503136e-001, 3.503108e-001, 3.503079e-001, 3.503051e-001, 3.503023e-001, 3.502995e-001, 3.502967e-001, 3.502939e-001, 3.502911e-001, 3.502883e-001, 3.502855e-001, 3.502826e-001, 3.502798e-001, 3.502770e-001, 3.502742e-001, 3.502714e-001, 3.502686e-001, 3.502658e-001, 3.502629e-001, 3.502601e-001, 3.502573e-001, 3.502545e-001, 3.502517e-001, 3.502489e-001, 3.502461e-001, 3.502432e-001, 3.502404e-001, 3.502376e-001, 3.502348e-001, 3.502320e-001, 3.502292e-001, 3.502263e-001, 3.502235e-001, 3.502207e-001, 3.502179e-001, 3.502151e-001, 3.502122e-001, 3.502094e-001, 3.502066e-001, 3.502038e-001, 3.502010e-001, 3.501982e-001, 3.501953e-001, 3.501925e-001, 3.501897e-001, 3.501869e-001, 3.501841e-001, 3.501812e-001, 3.501784e-001, 3.501756e-001, 3.501728e-001, 3.501700e-001, 3.501671e-001, 3.501643e-001, 3.501615e-001, 3.501587e-001, 3.501558e-001, 3.501530e-001, 3.501502e-001, 3.501474e-001, 3.501446e-001, 3.501417e-001, 3.501389e-001, 3.501361e-001, 3.501333e-001, 3.501304e-001, 3.501276e-001, 3.501248e-001, 3.501220e-001, 3.501191e-001, 3.501163e-001, 3.501135e-001, 
3.501107e-001, 3.501078e-001, 3.501050e-001, 3.501022e-001, 3.500994e-001, 3.500965e-001, 3.500937e-001, 3.500909e-001, 3.500880e-001, 3.500852e-001, 3.500824e-001, 3.500796e-001, 3.500767e-001, 3.500739e-001, 3.500711e-001, 3.500683e-001, 3.500654e-001, 3.500626e-001, 3.500598e-001, 3.500569e-001, 3.500541e-001, 3.500513e-001, 3.500484e-001, 3.500456e-001, 3.500428e-001, 3.500400e-001, 3.500371e-001, 3.500343e-001, 3.500315e-001, 3.500286e-001, 3.500258e-001, 3.500230e-001, 3.500201e-001, 3.500173e-001, 3.500145e-001, 3.500116e-001, 3.500088e-001, 3.500060e-001, 3.500031e-001, 3.500003e-001, 3.499975e-001, 3.499946e-001, 3.499918e-001, 3.499890e-001, 3.499861e-001, 3.499833e-001, 3.499805e-001, 3.499776e-001, 3.499748e-001, 3.499720e-001, 3.499691e-001, 3.499663e-001, 3.499634e-001, 3.499606e-001, 3.499578e-001, 3.499549e-001, 3.499521e-001, 3.499493e-001, 3.499464e-001, 3.499436e-001, 3.499408e-001, 3.499379e-001, 3.499351e-001, 3.499322e-001, 3.499294e-001, 3.499266e-001, 3.499237e-001, 3.499209e-001, 3.499180e-001, 3.499152e-001, 3.499124e-001, 3.499095e-001, 3.499067e-001, 3.499038e-001, 3.499010e-001, 3.498982e-001, 3.498953e-001, 3.498925e-001, 3.498896e-001, 3.498868e-001, 3.498840e-001, 3.498811e-001, 3.498783e-001, 3.498754e-001, 3.498726e-001, 3.498697e-001, 3.498669e-001, 3.498641e-001, 3.498612e-001, 3.498584e-001, 3.498555e-001, 3.498527e-001, 3.498498e-001, 3.498470e-001, 3.498441e-001, 3.498413e-001, 3.498385e-001, 3.498356e-001, 3.498328e-001, 3.498299e-001, 
3.498271e-001, 3.498242e-001, 3.498214e-001, 3.498185e-001, 3.498157e-001, 3.498128e-001, 3.498100e-001, 3.498071e-001, 3.498043e-001, 3.498015e-001, 3.497986e-001, 3.497958e-001, 3.497929e-001, 3.497901e-001, 3.497872e-001, 3.497844e-001, 3.497815e-001, 3.497787e-001, 3.497758e-001, 3.497730e-001, 3.497701e-001, 3.497673e-001, 3.497644e-001, 3.497616e-001, 3.497587e-001, 3.497559e-001, 3.497530e-001, 3.497502e-001, 3.497473e-001, 3.497445e-001, 3.497416e-001, 3.497387e-001, 3.497359e-001, 3.497330e-001, 3.497302e-001, 3.497273e-001, 3.497245e-001, 3.497216e-001, 3.497188e-001, 3.497159e-001, 3.497131e-001, 3.497102e-001, 3.497074e-001, 3.497045e-001, 3.497016e-001, 3.496988e-001, 3.496959e-001, 3.496931e-001, 3.496902e-001, 3.496874e-001, 3.496845e-001, 3.496817e-001, 3.496788e-001, 3.496759e-001, 3.496731e-001, 3.496702e-001, 3.496674e-001, 3.496645e-001, 3.496617e-001, 3.496588e-001, 3.496559e-001, 3.496531e-001, 3.496502e-001, 3.496474e-001, 3.496445e-001, 3.496416e-001, 3.496388e-001, 3.496359e-001, 3.496331e-001, 3.496302e-001, 3.496273e-001, 3.496245e-001, 3.496216e-001, 3.496188e-001, 3.496159e-001, 3.496130e-001, 3.496102e-001, 3.496073e-001, 3.496045e-001, 3.496016e-001, 3.495987e-001, 3.495959e-001, 3.495930e-001, 3.495901e-001, 3.495873e-001, 3.495844e-001, 3.495816e-001, 3.495787e-001, 3.495758e-001, 3.495730e-001, 3.495701e-001, 3.495672e-001, 3.495644e-001, 3.495615e-001, 3.495586e-001, 3.495558e-001, 3.495529e-001, 3.495500e-001, 3.495472e-001, 3.495443e-001, 
3.495414e-001, 3.495386e-001, 3.495357e-001, 3.495328e-001, 3.495300e-001, 3.495271e-001, 3.495242e-001, 3.495214e-001, 3.495185e-001, 3.495156e-001, 3.495128e-001, 3.495099e-001, 3.495070e-001, 3.495042e-001, 3.495013e-001, 3.494984e-001, 3.494956e-001, 3.494927e-001, 3.494898e-001, 3.494869e-001, 3.494841e-001, 3.494812e-001, 3.494783e-001, 3.494755e-001, 3.494726e-001, 3.494697e-001, 3.494668e-001, 3.494640e-001, 3.494611e-001, 3.494582e-001, 3.494554e-001, 3.494525e-001, 3.494496e-001, 3.494467e-001, 3.494439e-001, 3.494410e-001, 3.494381e-001, 3.494352e-001, 3.494324e-001, 3.494295e-001, 3.494266e-001, 3.494237e-001, 3.494209e-001, 3.494180e-001, 3.494151e-001, 3.494122e-001, 3.494094e-001, 3.494065e-001, 3.494036e-001, 3.494007e-001, 3.493979e-001, 3.493950e-001, 3.493921e-001, 3.493892e-001, 3.493864e-001, 3.493835e-001, 3.493806e-001, 3.493777e-001, 3.493748e-001, 3.493720e-001, 3.493691e-001, 3.493662e-001, 3.493633e-001, 3.493605e-001, 3.493576e-001, 3.493547e-001, 3.493518e-001, 3.493489e-001, 3.493461e-001, 3.493432e-001, 3.493403e-001, 3.493374e-001, 3.493345e-001, 3.493316e-001, 3.493288e-001, 3.493259e-001, 3.493230e-001, 3.493201e-001, 3.493172e-001, 3.493144e-001, 3.493115e-001, 3.493086e-001, 3.493057e-001, 3.493028e-001, 3.492999e-001, 3.492971e-001, 3.492942e-001, 3.492913e-001, 3.492884e-001, 3.492855e-001, 3.492826e-001, 3.492797e-001, 3.492769e-001, 3.492740e-001, 3.492711e-001, 3.492682e-001, 3.492653e-001, 3.492624e-001, 3.492595e-001, 3.492567e-001, 
3.492538e-001, 3.492509e-001, 3.492480e-001, 3.492451e-001, 3.492422e-001, 3.492393e-001, 3.492365e-001, 3.492336e-001, 3.492307e-001, 3.492278e-001, 3.492249e-001, 3.492220e-001, 3.492191e-001, 3.492162e-001, 3.492133e-001, 3.492104e-001, 3.492076e-001, 3.492047e-001, 3.492018e-001, 3.491989e-001, 3.491960e-001, 3.491931e-001, 3.491902e-001, 3.491873e-001, 3.491844e-001, 3.491815e-001, 3.491786e-001, 3.491758e-001, 3.491729e-001, 3.491700e-001, 3.491671e-001, 3.491642e-001, 3.491613e-001, 3.491584e-001, 3.491555e-001, 3.491526e-001, 3.491497e-001, 3.491468e-001, 3.491439e-001, 3.491410e-001, 3.491381e-001, 3.491352e-001, 3.491323e-001, 3.491295e-001, 3.491266e-001, 3.491237e-001, 3.491208e-001, 3.491179e-001, 3.491150e-001, 3.491121e-001, 3.491092e-001, 3.491063e-001, 3.491034e-001, 3.491005e-001, 3.490976e-001, 3.490947e-001, 3.490918e-001, 3.490889e-001, 3.490860e-001, 3.490831e-001, 3.490802e-001, 3.490773e-001, 3.490744e-001, 3.490715e-001, 3.490686e-001, 3.490657e-001, 3.490628e-001, 3.490599e-001, 3.490570e-001, 3.490541e-001, 3.490512e-001, 3.490483e-001, 3.490454e-001, 3.490425e-001, 3.490396e-001, 3.490367e-001, 3.490338e-001, 3.490309e-001, 3.490280e-001, 3.490251e-001, 3.490222e-001, 3.490193e-001, 3.490164e-001, 3.490135e-001, 3.490106e-001, 3.490077e-001, 3.490048e-001, 3.490018e-001, 3.489989e-001, 3.489960e-001, 3.489931e-001, 3.489902e-001, 3.489873e-001, 3.489844e-001, 3.489815e-001, 3.489786e-001, 3.489757e-001, 3.489728e-001, 3.489699e-001, 3.489670e-001, 
3.489641e-001, 3.489612e-001, 3.489583e-001, 3.489553e-001, 3.489524e-001, 3.489495e-001, 3.489466e-001, 3.489437e-001, 3.489408e-001, 3.489379e-001, 3.489350e-001, 3.489321e-001, 3.489292e-001, 3.489263e-001, 3.489233e-001, 3.489204e-001, 3.489175e-001, 3.489146e-001, 3.489117e-001, 3.489088e-001, 3.489059e-001, 3.489030e-001, 3.489001e-001, 3.488971e-001, 3.488942e-001, 3.488913e-001, 3.488884e-001, 3.488855e-001, 3.488826e-001, 3.488797e-001, 3.488768e-001, 3.488738e-001, 3.488709e-001, 3.488680e-001, 3.488651e-001, 3.488622e-001, 3.488593e-001, 3.488564e-001, 3.488534e-001, 3.488505e-001, 3.488476e-001, 3.488447e-001, 3.488418e-001, 3.488389e-001, 3.488360e-001, 3.488330e-001, 3.488301e-001, 3.488272e-001, 3.488243e-001, 3.488214e-001, 3.488185e-001, 3.488155e-001, 3.488126e-001, 3.488097e-001, 3.488068e-001, 3.488039e-001, 3.488009e-001, 3.487980e-001, 3.487951e-001, 3.487922e-001, 3.487893e-001, 3.487863e-001, 3.487834e-001, 3.487805e-001, 3.487776e-001, 3.487747e-001, 3.487717e-001, 3.487688e-001, 3.487659e-001, 3.487630e-001, 3.487601e-001, 3.487571e-001, 3.487542e-001, 3.487513e-001, 3.487484e-001, 3.487455e-001, 3.487425e-001, 3.487396e-001, 3.487367e-001, 3.487338e-001, 3.487308e-001, 3.487279e-001, 3.487250e-001, 3.487221e-001, 3.487191e-001, 3.487162e-001, 3.487133e-001, 3.487104e-001, 3.487074e-001, 3.487045e-001, 3.487016e-001, 3.486987e-001, 3.486957e-001, 3.486928e-001, 3.486899e-001, 3.486870e-001, 3.486840e-001, 3.486811e-001, 3.486782e-001, 3.486753e-001, 
3.486723e-001, 3.486694e-001, 3.486665e-001, 3.486635e-001, 3.486606e-001, 3.486577e-001, 3.486548e-001, 3.486518e-001, 3.486489e-001, 3.486460e-001, 3.486430e-001, 3.486401e-001, 3.486372e-001, 3.486343e-001, 3.486313e-001, 3.486284e-001, 3.486255e-001, 3.486225e-001, 3.486196e-001, 3.486167e-001, 3.486137e-001, 3.486108e-001, 3.486079e-001, 3.486049e-001, 3.486020e-001, 3.485991e-001, 3.485961e-001, 3.485932e-001, 3.485903e-001, 3.485873e-001, 3.485844e-001, 3.485815e-001, 3.485785e-001, 3.485756e-001, 3.485727e-001, 3.485697e-001, 3.485668e-001, 3.485639e-001, 3.485609e-001, 3.485580e-001, 3.485551e-001, 3.485521e-001, 3.485492e-001, 3.485463e-001, 3.485433e-001, 3.485404e-001, 3.485374e-001, 3.485345e-001, 3.485316e-001, 3.485286e-001, 3.485257e-001, 3.485228e-001, 3.485198e-001, 3.485169e-001, 3.485139e-001, 3.485110e-001, 3.485081e-001, 3.485051e-001, 3.485022e-001, 3.484993e-001, 3.484963e-001, 3.484934e-001, 3.484904e-001, 3.484875e-001, 3.484846e-001, 3.484816e-001, 3.484787e-001, 3.484757e-001, 3.484728e-001, 3.484698e-001, 3.484669e-001, 3.484640e-001, 3.484610e-001, 3.484581e-001, 3.484551e-001, 3.484522e-001, 3.484493e-001, 3.484463e-001, 3.484434e-001, 3.484404e-001, 3.484375e-001, 3.484345e-001, 3.484316e-001, 3.484286e-001, 3.484257e-001, 3.484228e-001, 3.484198e-001, 3.484169e-001, 3.484139e-001, 3.484110e-001, 3.484080e-001, 3.484051e-001, 3.484021e-001, 3.483992e-001, 3.483962e-001, 3.483933e-001, 3.483904e-001, 3.483874e-001, 3.483845e-001, 3.483815e-001, 
3.483786e-001, 3.483756e-001, 3.483727e-001, 3.483697e-001, 3.483668e-001, 3.483638e-001, 3.483609e-001, 3.483579e-001, 3.483550e-001, 3.483520e-001, 3.483491e-001, 3.483461e-001, 3.483432e-001, 3.483402e-001, 3.483373e-001, 3.483343e-001, 3.483314e-001, 3.483284e-001, 3.483255e-001, 3.483225e-001, 3.483196e-001, 3.483166e-001, 3.483137e-001, 3.483107e-001, 3.483078e-001, 3.483048e-001, 3.483019e-001, 3.482989e-001, 3.482959e-001, 3.482930e-001, 3.482900e-001, 3.482871e-001, 3.482841e-001, 3.482812e-001, 3.482782e-001, 3.482753e-001, 3.482723e-001, 3.482694e-001, 3.482664e-001, 3.482634e-001, 3.482605e-001, 3.482575e-001, 3.482546e-001, 3.482516e-001, 3.482487e-001, 3.482457e-001, 3.482427e-001, 3.482398e-001, 3.482368e-001, 3.482339e-001, 3.482309e-001, 3.482280e-001, 3.482250e-001, 3.482220e-001, 3.482191e-001, 3.482161e-001, 3.482132e-001, 3.482102e-001, 3.482072e-001, 3.482043e-001, 3.482013e-001, 3.481984e-001, 3.481954e-001, 3.481924e-001, 3.481895e-001, 3.481865e-001, 3.481836e-001, 3.481806e-001, 3.481776e-001, 3.481747e-001, 3.481717e-001, 3.481688e-001, 3.481658e-001, 3.481628e-001, 3.481599e-001, 3.481569e-001, 3.481539e-001, 3.481510e-001, 3.481480e-001, 3.481451e-001, 3.481421e-001, 3.481391e-001, 3.481362e-001, 3.481332e-001, 3.481302e-001, 3.481273e-001, 3.481243e-001, 3.481213e-001, 3.481184e-001, 3.481154e-001, 3.481124e-001, 3.481095e-001, 3.481065e-001, 3.481035e-001, 3.481006e-001, 3.480976e-001, 3.480946e-001, 3.480917e-001, 3.480887e-001, 3.480857e-001, 
3.480828e-001, 3.480798e-001, 3.480768e-001, 3.480739e-001, 3.480709e-001, 3.480679e-001, 3.480650e-001, 3.480620e-001, 3.480590e-001, 3.480561e-001, 3.480531e-001, 3.480501e-001, 3.480471e-001, 3.480442e-001, 3.480412e-001, 3.480382e-001, 3.480353e-001, 3.480323e-001, 3.480293e-001, 3.480263e-001, 3.480234e-001, 3.480204e-001, 3.480174e-001, 3.480145e-001, 3.480115e-001, 3.480085e-001, 3.480055e-001, 3.480026e-001, 3.479996e-001, 3.479966e-001, 3.479936e-001, 3.479907e-001, 3.479877e-001, 3.479847e-001, 3.479817e-001, 3.479788e-001, 3.479758e-001, 3.479728e-001, 3.479698e-001, 3.479669e-001, 3.479639e-001, 3.479609e-001, 3.479579e-001, 3.479550e-001, 3.479520e-001, 3.479490e-001, 3.479460e-001, 3.479431e-001, 3.479401e-001, 3.479371e-001, 3.479341e-001, 3.479311e-001, 3.479282e-001, 3.479252e-001, 3.479222e-001, 3.479192e-001, 3.479162e-001, 3.479133e-001, 3.479103e-001, 3.479073e-001, 3.479043e-001, 3.479013e-001, 3.478984e-001, 3.478954e-001, 3.478924e-001, 3.478894e-001, 3.478864e-001, 3.478835e-001, 3.478805e-001, 3.478775e-001, 3.478745e-001, 3.478715e-001, 3.478685e-001, 3.478656e-001, 3.478626e-001, 3.478596e-001, 3.478566e-001, 3.478536e-001, 3.478507e-001, 3.478477e-001, 3.478447e-001, 3.478417e-001, 3.478387e-001, 3.478357e-001, 3.478327e-001, 3.478298e-001, 3.478268e-001, 3.478238e-001, 3.478208e-001, 3.478178e-001, 3.478148e-001, 3.478118e-001, 3.478089e-001, 3.478059e-001, 3.478029e-001, 3.477999e-001, 3.477969e-001, 3.477939e-001, 3.477909e-001, 3.477879e-001, 
3.477850e-001, 3.477820e-001, 3.477790e-001, 3.477760e-001, 3.477730e-001, 3.477700e-001, 3.477670e-001, 3.477640e-001, 3.477610e-001, 3.477581e-001, 3.477551e-001, 3.477521e-001, 3.477491e-001, 3.477461e-001, 3.477431e-001, 3.477401e-001, 3.477371e-001, 3.477341e-001, 3.477311e-001, 3.477281e-001, 3.477252e-001, 3.477222e-001, 3.477192e-001, 3.477162e-001, 3.477132e-001, 3.477102e-001, 3.477072e-001, 3.477042e-001, 3.477012e-001, 3.476982e-001, 3.476952e-001, 3.476922e-001, 3.476892e-001, 3.476862e-001, 3.476832e-001, 3.476802e-001, 3.476773e-001, 3.476743e-001, 3.476713e-001, 3.476683e-001, 3.476653e-001, 3.476623e-001, 3.476593e-001, 3.476563e-001, 3.476533e-001, 3.476503e-001, 3.476473e-001, 3.476443e-001, 3.476413e-001, 3.476383e-001, 3.476353e-001, 3.476323e-001, 3.476293e-001, 3.476263e-001, 3.476233e-001, 3.476203e-001, 3.476173e-001, 3.476143e-001, 3.476113e-001, 3.476083e-001, 3.476053e-001, 3.476023e-001, 3.475993e-001, 3.475963e-001, 3.475933e-001, 3.475903e-001, 3.475873e-001, 3.475843e-001, 3.475813e-001, 3.475783e-001, 3.475753e-001, 3.475723e-001, 3.475693e-001, 3.475663e-001, 3.475633e-001, 3.475603e-001, 3.475573e-001, 3.475543e-001, 3.475513e-001, 3.475483e-001, 3.475453e-001, 3.475423e-001, 3.475392e-001, 3.475362e-001, 3.475332e-001, 3.475302e-001, 3.475272e-001, 3.475242e-001, 3.475212e-001, 3.475182e-001, 3.475152e-001, 3.475122e-001, 3.475092e-001, 3.475062e-001, 3.475032e-001, 3.475002e-001, 3.474972e-001, 3.474942e-001, 3.474911e-001, 3.474881e-001, 
3.474851e-001, 3.474821e-001, 3.474791e-001, 3.474761e-001, 3.474731e-001, 3.474701e-001, 3.474671e-001, 3.474641e-001, 3.474611e-001, 3.474580e-001, 3.474550e-001, 3.474520e-001, 3.474490e-001, 3.474460e-001, 3.474430e-001, 3.474400e-001, 3.474370e-001, 3.474340e-001, 3.474309e-001, 3.474279e-001, 3.474249e-001, 3.474219e-001, 3.474189e-001, 3.474159e-001, 3.474129e-001, 3.474099e-001, 3.474068e-001, 3.474038e-001, 3.474008e-001, 3.473978e-001, 3.473948e-001, 3.473918e-001, 3.473888e-001, 3.473857e-001, 3.473827e-001, 3.473797e-001, 3.473767e-001, 3.473737e-001, 3.473707e-001, 3.473677e-001, 3.473646e-001, 3.473616e-001, 3.473586e-001, 3.473556e-001, 3.473526e-001, 3.473496e-001, 3.473465e-001, 3.473435e-001, 3.473405e-001, 3.473375e-001, 3.473345e-001, 3.473314e-001, 3.473284e-001, 3.473254e-001, 3.473224e-001, 3.473194e-001, 3.473163e-001, 3.473133e-001, 3.473103e-001, 3.473073e-001, 3.473043e-001, 3.473012e-001, 3.472982e-001, 3.472952e-001, 3.472922e-001, 3.472892e-001, 3.472861e-001, 3.472831e-001, 3.472801e-001, 3.472771e-001, 3.472741e-001, 3.472710e-001, 3.472680e-001, 3.472650e-001, 3.472620e-001, 3.472589e-001, 3.472559e-001, 3.472529e-001, 3.472499e-001, 3.472468e-001, 3.472438e-001, 3.472408e-001, 3.472378e-001, 3.472347e-001, 3.472317e-001, 3.472287e-001, 3.472257e-001, 3.472226e-001, 3.472196e-001, 3.472166e-001, 3.472136e-001, 3.472105e-001, 3.472075e-001, 3.472045e-001, 3.472015e-001, 3.471984e-001, 3.471954e-001, 3.471924e-001, 3.471893e-001, 3.471863e-001, 
3.471833e-001, 3.471803e-001, 3.471772e-001, 3.471742e-001, 3.471712e-001, 3.471681e-001, 3.471651e-001, 3.471621e-001, 3.471591e-001, 3.471560e-001, 3.471530e-001, 3.471500e-001, 3.471469e-001, 3.471439e-001, 3.471409e-001, 3.471378e-001, 3.471348e-001, 3.471318e-001, 3.471287e-001, 3.471257e-001, 3.471227e-001, 3.471196e-001, 3.471166e-001, 3.471136e-001, 3.471106e-001, 3.471075e-001, 3.471045e-001, 3.471014e-001, 3.470984e-001, 3.470954e-001, 3.470923e-001, 3.470893e-001, 3.470863e-001, 3.470832e-001, 3.470802e-001, 3.470772e-001, 3.470741e-001, 3.470711e-001, 3.470681e-001, 3.470650e-001, 3.470620e-001, 3.470590e-001, 3.470559e-001, 3.470529e-001, 3.470498e-001, 3.470468e-001, 3.470438e-001, 3.470407e-001, 3.470377e-001, 3.470347e-001, 3.470316e-001, 3.470286e-001, 3.470255e-001, 3.470225e-001, 3.470195e-001, 3.470164e-001, 3.470134e-001, 3.470103e-001, 3.470073e-001, 3.470043e-001, 3.470012e-001, 3.469982e-001, 3.469951e-001, 3.469921e-001, 3.469891e-001, 3.469860e-001, 3.469830e-001, 3.469799e-001, 3.469769e-001, 3.469738e-001, 3.469708e-001, 3.469678e-001, 3.469647e-001, 3.469617e-001, 3.469586e-001, 3.469556e-001, 3.469525e-001, 3.469495e-001, 3.469465e-001, 3.469434e-001, 3.469404e-001, 3.469373e-001, 3.469343e-001, 3.469312e-001, 3.469282e-001, 3.469251e-001, 3.469221e-001, 3.469191e-001, 3.469160e-001, 3.469130e-001, 3.469099e-001, 3.469069e-001, 3.469038e-001, 3.469008e-001, 3.468977e-001, 3.468947e-001, 3.468916e-001, 3.468886e-001, 3.468855e-001, 3.468825e-001, 
3.468794e-001, 3.468764e-001, 3.468733e-001, 3.468703e-001, 3.468672e-001, 3.468642e-001, 3.468611e-001, 3.468581e-001, 3.468550e-001, 3.468520e-001, 3.468489e-001, 3.468459e-001, 3.468428e-001, 3.468398e-001, 3.468367e-001, 3.468337e-001, 3.468306e-001, 3.468276e-001, 3.468245e-001, 3.468215e-001, 3.468184e-001, 3.468154e-001, 3.468123e-001, 3.468093e-001, 3.468062e-001, 3.468032e-001, 3.468001e-001, 3.467971e-001, 3.467940e-001, 3.467910e-001, 3.467879e-001, 3.467848e-001, 3.467818e-001, 3.467787e-001, 3.467757e-001, 3.467726e-001, 3.467696e-001, 3.467665e-001, 3.467635e-001, 3.467604e-001, 3.467573e-001, 3.467543e-001, 3.467512e-001, 3.467482e-001, 3.467451e-001, 3.467421e-001, 3.467390e-001, 3.467359e-001, 3.467329e-001, 3.467298e-001, 3.467268e-001, 3.467237e-001, 3.467206e-001, 3.467176e-001, 3.467145e-001, 3.467115e-001, 3.467084e-001, 3.467054e-001, 3.467023e-001, 3.466992e-001, 3.466962e-001, 3.466931e-001, 3.466900e-001, 3.466870e-001, 3.466839e-001, 3.466809e-001, 3.466778e-001, 3.466747e-001, 3.466717e-001, 3.466686e-001, 3.466656e-001, 3.466625e-001, 3.466594e-001, 3.466564e-001, 3.466533e-001, 3.466502e-001, 3.466472e-001, 3.466441e-001, 3.466410e-001, 3.466380e-001, 3.466349e-001, 3.466319e-001, 3.466288e-001, 3.466257e-001, 3.466227e-001, 3.466196e-001, 3.466165e-001, 3.466135e-001, 3.466104e-001, 3.466073e-001, 3.466043e-001, 3.466012e-001, 3.465981e-001, 3.465951e-001, 3.465920e-001, 3.465889e-001, 3.465859e-001, 3.465828e-001, 3.465797e-001, 3.465767e-001, 
3.465736e-001, 3.465705e-001, 3.465675e-001, 3.465644e-001, 3.465613e-001, 3.465582e-001, 3.465552e-001, 3.465521e-001, 3.465490e-001, 3.465460e-001, 3.465429e-001, 3.465398e-001, 3.465368e-001, 3.465337e-001, 3.465306e-001, 3.465275e-001, 3.465245e-001, 3.465214e-001, 3.465183e-001, 3.465153e-001, 3.465122e-001, 3.465091e-001, 3.465060e-001, 3.465030e-001, 3.464999e-001, 3.464968e-001, 3.464937e-001, 3.464907e-001, 3.464876e-001, 3.464845e-001, 3.464814e-001, 3.464784e-001, 3.464753e-001, 3.464722e-001, 3.464691e-001, 3.464661e-001, 3.464630e-001, 3.464599e-001, 3.464568e-001, 3.464538e-001, 3.464507e-001, 3.464476e-001, 3.464445e-001, 3.464415e-001, 3.464384e-001, 3.464353e-001, 3.464322e-001, 3.464291e-001, 3.464261e-001, 3.464230e-001, 3.464199e-001, 3.464168e-001, 3.464138e-001, 3.464107e-001, 3.464076e-001, 3.464045e-001, 3.464014e-001, 3.463984e-001, 3.463953e-001, 3.463922e-001, 3.463891e-001, 3.463860e-001, 3.463830e-001, 3.463799e-001, 3.463768e-001, 3.463737e-001, 3.463706e-001, 3.463676e-001, 3.463645e-001, 3.463614e-001, 3.463583e-001, 3.463552e-001, 3.463521e-001, 3.463491e-001, 3.463460e-001, 3.463429e-001, 3.463398e-001, 3.463367e-001, 3.463336e-001, 3.463306e-001, 3.463275e-001, 3.463244e-001, 3.463213e-001, 3.463182e-001, 3.463151e-001, 3.463120e-001, 3.463090e-001, 3.463059e-001, 3.463028e-001, 3.462997e-001, 3.462966e-001, 3.462935e-001, 3.462904e-001, 3.462874e-001, 3.462843e-001, 3.462812e-001, 3.462781e-001, 3.462750e-001, 3.462719e-001, 3.462688e-001, 
3.462657e-001, 3.462626e-001, 3.462596e-001, 3.462565e-001, 3.462534e-001, 3.462503e-001, 3.462472e-001, 3.462441e-001, 3.462410e-001, 3.462379e-001, 3.462348e-001, 3.462318e-001, 3.462287e-001, 3.462256e-001, 3.462225e-001, 3.462194e-001, 3.462163e-001, 3.462132e-001, 3.462101e-001, 3.462070e-001, 3.462039e-001, 3.462008e-001, 3.461977e-001, 3.461946e-001, 3.461916e-001, 3.461885e-001, 3.461854e-001, 3.461823e-001, 3.461792e-001, 3.461761e-001, 3.461730e-001, 3.461699e-001, 3.461668e-001, 3.461637e-001, 3.461606e-001, 3.461575e-001, 3.461544e-001, 3.461513e-001, 3.461482e-001, 3.461451e-001, 3.461420e-001, 3.461389e-001, 3.461358e-001, 3.461327e-001, 3.461297e-001, 3.461266e-001, 3.461235e-001, 3.461204e-001, 3.461173e-001, 3.461142e-001, 3.461111e-001, 3.461080e-001, 3.461049e-001, 3.461018e-001, 3.460987e-001, 3.460956e-001, 3.460925e-001, 3.460894e-001, 3.460863e-001, 3.460832e-001, 3.460801e-001, 3.460770e-001, 3.460739e-001, 3.460708e-001, 3.460677e-001, 3.460646e-001, 3.460615e-001, 3.460584e-001, 3.460553e-001, 3.460522e-001, 3.460491e-001, 3.460460e-001, 3.460428e-001, 3.460397e-001, 3.460366e-001, 3.460335e-001, 3.460304e-001, 3.460273e-001, 3.460242e-001, 3.460211e-001, 3.460180e-001, 3.460149e-001, 3.460118e-001, 3.460087e-001, 3.460056e-001, 3.460025e-001, 3.459994e-001, 3.459963e-001, 3.459932e-001, 3.459901e-001, 3.459870e-001, 3.459839e-001, 3.459808e-001, 3.459776e-001, 3.459745e-001, 3.459714e-001, 3.459683e-001, 3.459652e-001, 3.459621e-001, 3.459590e-001, 
3.459559e-001, 3.459528e-001, 3.459497e-001, 3.459466e-001, 3.459435e-001, 3.459403e-001, 3.459372e-001, 3.459341e-001, 3.459310e-001, 3.459279e-001, 3.459248e-001, 3.459217e-001, 3.459186e-001, 3.459155e-001, 3.459124e-001, 3.459092e-001, 3.459061e-001, 3.459030e-001, 3.458999e-001, 3.458968e-001, 3.458937e-001, 3.458906e-001, 3.458875e-001, 3.458843e-001, 3.458812e-001, 3.458781e-001, 3.458750e-001, 3.458719e-001, 3.458688e-001, 3.458657e-001, 3.458625e-001, 3.458594e-001, 3.458563e-001, 3.458532e-001, 3.458501e-001, 3.458470e-001, 3.458439e-001, 3.458407e-001, 3.458376e-001, 3.458345e-001, 3.458314e-001, 3.458283e-001, 3.458252e-001, 3.458220e-001, 3.458189e-001, 3.458158e-001, 3.458127e-001, 3.458096e-001, 3.458065e-001, 3.458033e-001, 3.458002e-001, 3.457971e-001, 3.457940e-001, 3.457909e-001, 3.457877e-001, 3.457846e-001, 3.457815e-001, 3.457784e-001, 3.457753e-001, 3.457721e-001, 3.457690e-001, 3.457659e-001, 3.457628e-001, 3.457597e-001, 3.457565e-001, 3.457534e-001, 3.457503e-001, 3.457472e-001, 3.457441e-001, 3.457409e-001, 3.457378e-001, 3.457347e-001, 3.457316e-001, 3.457284e-001, 3.457253e-001, 3.457222e-001, 3.457191e-001, 3.457159e-001, 3.457128e-001, 3.457097e-001, 3.457066e-001, 3.457035e-001, 3.457003e-001, 3.456972e-001, 3.456941e-001, 3.456910e-001, 3.456878e-001, 3.456847e-001, 3.456816e-001, 3.456784e-001, 3.456753e-001, 3.456722e-001, 3.456691e-001, 3.456659e-001, 3.456628e-001, 3.456597e-001, 3.456566e-001, 3.456534e-001, 3.456503e-001, 3.456472e-001, 
3.456440e-001, 3.456409e-001, 3.456378e-001, 3.456347e-001, 3.456315e-001, 3.456284e-001, 3.456253e-001, 3.456221e-001, 3.456190e-001, 3.456159e-001, 3.456128e-001, 3.456096e-001, 3.456065e-001, 3.456034e-001, 3.456002e-001, 3.455971e-001, 3.455940e-001, 3.455908e-001, 3.455877e-001, 3.455846e-001, 3.455814e-001, 3.455783e-001, 3.455752e-001, 3.455720e-001, 3.455689e-001, 3.455658e-001, 3.455626e-001, 3.455595e-001, 3.455564e-001, 3.455532e-001, 3.455501e-001, 3.455470e-001, 3.455438e-001, 3.455407e-001, 3.455376e-001, 3.455344e-001, 3.455313e-001, 3.455282e-001, 3.455250e-001, 3.455219e-001, 3.455188e-001, 3.455156e-001, 3.455125e-001, 3.455093e-001, 3.455062e-001, 3.455031e-001, 3.454999e-001, 3.454968e-001, 3.454937e-001, 3.454905e-001, 3.454874e-001, 3.454842e-001, 3.454811e-001, 3.454780e-001, 3.454748e-001, 3.454717e-001, 3.454686e-001, 3.454654e-001, 3.454623e-001, 3.454591e-001, 3.454560e-001, 3.454529e-001, 3.454497e-001, 3.454466e-001, 3.454434e-001, 3.454403e-001, 3.454371e-001, 3.454340e-001, 3.454309e-001, 3.454277e-001, 3.454246e-001, 3.454214e-001, 3.454183e-001, 3.454152e-001, 3.454120e-001, 3.454089e-001, 3.454057e-001, 3.454026e-001, 3.453994e-001, 3.453963e-001, 3.453931e-001, 3.453900e-001, 3.453869e-001, 3.453837e-001, 3.453806e-001, 3.453774e-001, 3.453743e-001, 3.453711e-001, 3.453680e-001, 3.453648e-001, 3.453617e-001, 3.453585e-001, 3.453554e-001, 3.453523e-001, 3.453491e-001, 3.453460e-001, 3.453428e-001, 3.453397e-001, 3.453365e-001, 3.453334e-001, 
3.453302e-001, 3.453271e-001, 3.453239e-001, 3.453208e-001, 3.453176e-001, 3.453145e-001, 3.453113e-001, 3.453082e-001, 3.453050e-001, 3.453019e-001, 3.452987e-001, 3.452956e-001, 3.452924e-001, 3.452893e-001, 3.452861e-001, 3.452830e-001, 3.452798e-001, 3.452767e-001, 3.452735e-001, 3.452704e-001, 3.452672e-001, 3.452641e-001, 3.452609e-001, 3.452578e-001, 3.452546e-001, 3.452515e-001, 3.452483e-001, 3.452451e-001, 3.452420e-001, 3.452388e-001, 3.452357e-001, 3.452325e-001, 3.452294e-001, 3.452262e-001, 3.452231e-001, 3.452199e-001, 3.452168e-001, 3.452136e-001, 3.452104e-001, 3.452073e-001, 3.452041e-001, 3.452010e-001, 3.451978e-001, 3.451947e-001, 3.451915e-001, 3.451884e-001, 3.451852e-001, 3.451820e-001, 3.451789e-001, 3.451757e-001, 3.451726e-001, 3.451694e-001, 3.451662e-001, 3.451631e-001, 3.451599e-001, 3.451568e-001, 3.451536e-001, 3.451505e-001, 3.451473e-001, 3.451441e-001, 3.451410e-001, 3.451378e-001, 3.451347e-001, 3.451315e-001, 3.451283e-001, 3.451252e-001, 3.451220e-001, 3.451188e-001, 3.451157e-001, 3.451125e-001, 3.451094e-001, 3.451062e-001, 3.451030e-001, 3.450999e-001, 3.450967e-001, 3.450935e-001, 3.450904e-001, 3.450872e-001, 3.450841e-001, 3.450809e-001, 3.450777e-001, 3.450746e-001, 3.450714e-001, 3.450682e-001, 3.450651e-001, 3.450619e-001, 3.450587e-001, 3.450556e-001, 3.450524e-001, 3.450492e-001, 3.450461e-001, 3.450429e-001, 3.450397e-001, 3.450366e-001, 3.450334e-001, 3.450302e-001, 3.450271e-001, 3.450239e-001, 3.450207e-001, 3.450176e-001, 
3.450144e-001, 3.450112e-001, 3.450081e-001, 3.450049e-001, 3.450017e-001, 3.449986e-001, 3.449954e-001, 3.449922e-001, 3.449891e-001, 3.449859e-001, 3.449827e-001, 3.449795e-001, 3.449764e-001, 3.449732e-001, 3.449700e-001, 3.449669e-001, 3.449637e-001, 3.449605e-001, 3.449574e-001, 3.449542e-001, 3.449510e-001, 3.449478e-001, 3.449447e-001, 3.449415e-001, 3.449383e-001, 3.449351e-001, 3.449320e-001, 3.449288e-001, 3.449256e-001, 3.449225e-001, 3.449193e-001, 3.449161e-001, 3.449129e-001, 3.449098e-001, 3.449066e-001, 3.449034e-001, 3.449002e-001, 3.448971e-001, 3.448939e-001, 3.448907e-001, 3.448875e-001, 3.448844e-001, 3.448812e-001, 3.448780e-001, 3.448748e-001, 3.448716e-001, 3.448685e-001, 3.448653e-001, 3.448621e-001, 3.448589e-001, 3.448558e-001, 3.448526e-001, 3.448494e-001, 3.448462e-001, 3.448430e-001, 3.448399e-001, 3.448367e-001, 3.448335e-001, 3.448303e-001, 3.448272e-001, 3.448240e-001, 3.448208e-001, 3.448176e-001, 3.448144e-001, 3.448112e-001, 3.448081e-001, 3.448049e-001, 3.448017e-001, 3.447985e-001, 3.447953e-001, 3.447922e-001, 3.447890e-001, 3.447858e-001, 3.447826e-001, 3.447794e-001, 3.447763e-001, 3.447731e-001, 3.447699e-001, 3.447667e-001, 3.447635e-001, 3.447603e-001, 3.447571e-001, 3.447540e-001, 3.447508e-001, 3.447476e-001, 3.447444e-001, 3.447412e-001, 3.447380e-001, 3.447349e-001, 3.447317e-001, 3.447285e-001, 3.447253e-001, 3.447221e-001, 3.447189e-001, 3.447157e-001, 3.447126e-001, 3.447094e-001, 3.447062e-001, 3.447030e-001, 3.446998e-001, 
3.446966e-001, 3.446934e-001, 3.446902e-001, 3.446871e-001, 3.446839e-001, 3.446807e-001, 3.446775e-001, 3.446743e-001, 3.446711e-001, 3.446679e-001, 3.446647e-001, 3.446615e-001, 3.446583e-001, 3.446552e-001, 3.446520e-001, 3.446488e-001, 3.446456e-001, 3.446424e-001, 3.446392e-001, 3.446360e-001, 3.446328e-001, 3.446296e-001, 3.446264e-001, 3.446232e-001, 3.446201e-001, 3.446169e-001, 3.446137e-001, 3.446105e-001, 3.446073e-001, 3.446041e-001, 3.446009e-001, 3.445977e-001, 3.445945e-001, 3.445913e-001, 3.445881e-001, 3.445849e-001, 3.445817e-001, 3.445785e-001, 3.445753e-001, 3.445721e-001, 3.445689e-001, 3.445658e-001, 3.445626e-001, 3.445594e-001, 3.445562e-001, 3.445530e-001, 3.445498e-001, 3.445466e-001, 3.445434e-001, 3.445402e-001, 3.445370e-001, 3.445338e-001, 3.445306e-001, 3.445274e-001, 3.445242e-001, 3.445210e-001, 3.445178e-001, 3.445146e-001, 3.445114e-001, 3.445082e-001, 3.445050e-001, 3.445018e-001, 3.444986e-001, 3.444954e-001, 3.444922e-001, 3.444890e-001, 3.444858e-001, 3.444826e-001, 3.444794e-001, 3.444762e-001, 3.444730e-001, 3.444698e-001, 3.444666e-001, 3.444634e-001, 3.444602e-001, 3.444570e-001, 3.444538e-001, 3.444506e-001, 3.444474e-001, 3.444442e-001, 3.444410e-001, 3.444378e-001, 3.444346e-001, 3.444313e-001, 3.444281e-001, 3.444249e-001, 3.444217e-001, 3.444185e-001, 3.444153e-001, 3.444121e-001, 3.444089e-001, 3.444057e-001, 3.444025e-001, 3.443993e-001, 3.443961e-001, 3.443929e-001, 3.443897e-001, 3.443865e-001, 3.443833e-001, 3.443801e-001, 
3.443768e-001, 3.443736e-001, 3.443704e-001, 3.443672e-001, 3.443640e-001, 3.443608e-001, 3.443576e-001, 3.443544e-001, 3.443512e-001, 3.443480e-001, 3.443448e-001, 3.443416e-001, 3.443383e-001, 3.443351e-001, 3.443319e-001, 3.443287e-001, 3.443255e-001, 3.443223e-001, 3.443191e-001, 3.443159e-001, 3.443127e-001, 3.443094e-001, 3.443062e-001, 3.443030e-001, 3.442998e-001, 3.442966e-001, 3.442934e-001, 3.442902e-001, 3.442870e-001, 3.442837e-001, 3.442805e-001, 3.442773e-001, 3.442741e-001, 3.442709e-001, 3.442677e-001, 3.442645e-001, 3.442612e-001, 3.442580e-001, 3.442548e-001, 3.442516e-001, 3.442484e-001, 3.442452e-001, 3.442420e-001, 3.442387e-001, 3.442355e-001, 3.442323e-001, 3.442291e-001, 3.442259e-001, 3.442227e-001, 3.442194e-001, 3.442162e-001, 3.442130e-001, 3.442098e-001, 3.442066e-001, 3.442034e-001, 3.442001e-001, 3.441969e-001, 3.441937e-001, 3.441905e-001, 3.441873e-001, 3.441840e-001, 3.441808e-001, 3.441776e-001, 3.441744e-001, 3.441712e-001, 3.441679e-001, 3.441647e-001, 3.441615e-001, 3.441583e-001, 3.441551e-001, 3.441518e-001, 3.441486e-001, 3.441454e-001, 3.441422e-001, 3.441389e-001, 3.441357e-001, 3.441325e-001, 3.441293e-001, 3.441261e-001, 3.441228e-001, 3.441196e-001, 3.441164e-001, 3.441132e-001, 3.441099e-001, 3.441067e-001, 3.441035e-001, 3.441003e-001, 3.440970e-001, 3.440938e-001, 3.440906e-001, 3.440874e-001, 3.440841e-001, 3.440809e-001, 3.440777e-001, 3.440745e-001, 3.440712e-001, 3.440680e-001, 3.440648e-001, 3.440616e-001, 3.440583e-001, 
3.440551e-001, 3.440519e-001, 3.440487e-001, 3.440454e-001, 3.440422e-001, 3.440390e-001, 3.440357e-001, 3.440325e-001, 3.440293e-001, 3.440261e-001, 3.440228e-001, 3.440196e-001, 3.440164e-001, 3.440131e-001, 3.440099e-001, 3.440067e-001, 3.440034e-001, 3.440002e-001, 3.439970e-001, 3.439938e-001, 3.439905e-001, 3.439873e-001, 3.439841e-001, 3.439808e-001, 3.439776e-001, 3.439744e-001, 3.439711e-001, 3.439679e-001, 3.439647e-001, 3.439614e-001, 3.439582e-001, 3.439550e-001, 3.439517e-001, 3.439485e-001, 3.439453e-001, 3.439420e-001, 3.439388e-001, 3.439356e-001, 3.439323e-001, 3.439291e-001, 3.439259e-001, 3.439226e-001, 3.439194e-001, 3.439162e-001, 3.439129e-001, 3.439097e-001, 3.439064e-001, 3.439032e-001, 3.439000e-001, 3.438967e-001, 3.438935e-001, 3.438903e-001, 3.438870e-001, 3.438838e-001, 3.438805e-001, 3.438773e-001, 3.438741e-001, 3.438708e-001, 3.438676e-001, 3.438644e-001, 3.438611e-001, 3.438579e-001, 3.438546e-001, 3.438514e-001, 3.438482e-001, 3.438449e-001, 3.438417e-001, 3.438384e-001, 3.438352e-001, 3.438320e-001, 3.438287e-001, 3.438255e-001, 3.438222e-001, 3.438190e-001, 3.438158e-001, 3.438125e-001, 3.438093e-001, 3.438060e-001, 3.438028e-001, 3.437995e-001, 3.437963e-001, 3.437931e-001, 3.437898e-001, 3.437866e-001, 3.437833e-001, 3.437801e-001, 3.437768e-001, 3.437736e-001, 3.437703e-001, 3.437671e-001, 3.437639e-001, 3.437606e-001, 3.437574e-001, 3.437541e-001, 3.437509e-001, 3.437476e-001, 3.437444e-001, 3.437411e-001, 3.437379e-001, 3.437346e-001, 
3.437314e-001, 3.437281e-001, 3.437249e-001, 3.437217e-001, 3.437184e-001, 3.437152e-001, 3.437119e-001, 3.437087e-001, 3.437054e-001, 3.437022e-001, 3.436989e-001, 3.436957e-001, 3.436924e-001, 3.436892e-001, 3.436859e-001, 3.436827e-001, 3.436794e-001, 3.436762e-001, 3.436729e-001, 3.436697e-001, 3.436664e-001, 3.436632e-001, 3.436599e-001, 3.436567e-001, 3.436534e-001, 3.436502e-001, 3.436469e-001, 3.436437e-001, 3.436404e-001, 3.436372e-001, 3.436339e-001, 3.436306e-001, 3.436274e-001, 3.436241e-001, 3.436209e-001, 3.436176e-001, 3.436144e-001, 3.436111e-001, 3.436079e-001, 3.436046e-001, 3.436014e-001, 3.435981e-001, 3.435949e-001, 3.435916e-001, 3.435883e-001, 3.435851e-001, 3.435818e-001, 3.435786e-001, 3.435753e-001, 3.435721e-001, 3.435688e-001, 3.435655e-001, 3.435623e-001, 3.435590e-001, 3.435558e-001, 3.435525e-001, 3.435493e-001, 3.435460e-001, 3.435427e-001, 3.435395e-001, 3.435362e-001, 3.435330e-001, 3.435297e-001, 3.435265e-001, 3.435232e-001, 3.435199e-001, 3.435167e-001, 3.435134e-001, 3.435102e-001, 3.435069e-001, 3.435036e-001, 3.435004e-001, 3.434971e-001, 3.434938e-001, 3.434906e-001, 3.434873e-001, 3.434841e-001, 3.434808e-001, 3.434775e-001, 3.434743e-001, 3.434710e-001, 3.434678e-001, 3.434645e-001, 3.434612e-001, 3.434580e-001, 3.434547e-001, 3.434514e-001, 3.434482e-001, 3.434449e-001, 3.434416e-001, 3.434384e-001, 3.434351e-001, 3.434318e-001, 3.434286e-001, 3.434253e-001, 3.434221e-001, 3.434188e-001, 3.434155e-001, 3.434123e-001, 3.434090e-001, 
3.434057e-001, 3.434025e-001, 3.433992e-001, 3.433959e-001, 3.433927e-001, 3.433894e-001, 3.433861e-001, 3.433829e-001, 3.433796e-001, 3.433763e-001, 3.433730e-001, 3.433698e-001, 3.433665e-001, 3.433632e-001, 3.433600e-001, 3.433567e-001, 3.433534e-001, 3.433502e-001, 3.433469e-001, 3.433436e-001, 3.433404e-001, 3.433371e-001, 3.433338e-001, 3.433305e-001, 3.433273e-001, 3.433240e-001, 3.433207e-001, 3.433175e-001, 3.433142e-001, 3.433109e-001, 3.433076e-001, 3.433044e-001, 3.433011e-001, 3.432978e-001, 3.432945e-001, 3.432913e-001, 3.432880e-001, 3.432847e-001, 3.432815e-001, 3.432782e-001, 3.432749e-001, 3.432716e-001, 3.432684e-001, 3.432651e-001, 3.432618e-001, 3.432585e-001, 3.432553e-001, 3.432520e-001, 3.432487e-001, 3.432454e-001, 3.432421e-001, 3.432389e-001, 3.432356e-001, 3.432323e-001, 3.432290e-001, 3.432258e-001, 3.432225e-001, 3.432192e-001, 3.432159e-001, 3.432127e-001, 3.432094e-001, 3.432061e-001, 3.432028e-001, 3.431995e-001, 3.431963e-001, 3.431930e-001, 3.431897e-001, 3.431864e-001, 3.431831e-001, 3.431799e-001, 3.431766e-001, 3.431733e-001, 3.431700e-001, 3.431667e-001, 3.431635e-001, 3.431602e-001, 3.431569e-001, 3.431536e-001, 3.431503e-001, 3.431471e-001, 3.431438e-001, 3.431405e-001, 3.431372e-001, 3.431339e-001, 3.431306e-001, 3.431274e-001, 3.431241e-001, 3.431208e-001, 3.431175e-001, 3.431142e-001, 3.431109e-001, 3.431077e-001, 3.431044e-001, 3.431011e-001, 3.430978e-001, 3.430945e-001, 3.430912e-001, 3.430879e-001, 3.430847e-001, 3.430814e-001, 
3.430781e-001, 3.430748e-001, 3.430715e-001, 3.430682e-001, 3.430649e-001, 3.430617e-001, 3.430584e-001, 3.430551e-001, 3.430518e-001, 3.430485e-001, 3.430452e-001, 3.430419e-001, 3.430386e-001, 3.430354e-001, 3.430321e-001, 3.430288e-001, 3.430255e-001, 3.430222e-001, 3.430189e-001, 3.430156e-001, 3.430123e-001, 3.430090e-001, 3.430057e-001, 3.430025e-001, 3.429992e-001, 3.429959e-001, 3.429926e-001, 3.429893e-001, 3.429860e-001, 3.429827e-001, 3.429794e-001, 3.429761e-001, 3.429728e-001, 3.429695e-001, 3.429662e-001, 3.429630e-001, 3.429597e-001, 3.429564e-001, 3.429531e-001, 3.429498e-001, 3.429465e-001, 3.429432e-001, 3.429399e-001, 3.429366e-001, 3.429333e-001, 3.429300e-001, 3.429267e-001, 3.429234e-001, 3.429201e-001, 3.429168e-001, 3.429135e-001, 3.429102e-001, 3.429069e-001, 3.429036e-001, 3.429004e-001, 3.428971e-001, 3.428938e-001, 3.428905e-001, 3.428872e-001, 3.428839e-001, 3.428806e-001, 3.428773e-001, 3.428740e-001, 3.428707e-001, 3.428674e-001, 3.428641e-001, 3.428608e-001, 3.428575e-001, 3.428542e-001, 3.428509e-001, 3.428476e-001, 3.428443e-001, 3.428410e-001, 3.428377e-001, 3.428344e-001, 3.428311e-001, 3.428278e-001, 3.428245e-001, 3.428212e-001, 3.428179e-001, 3.428146e-001, 3.428113e-001, 3.428080e-001, 3.428047e-001, 3.428014e-001, 3.427981e-001, 3.427948e-001, 3.427915e-001, 3.427881e-001, 3.427848e-001, 3.427815e-001, 3.427782e-001, 3.427749e-001, 3.427716e-001, 3.427683e-001, 3.427650e-001, 3.427617e-001, 3.427584e-001, 3.427551e-001, 3.427518e-001, 
3.427485e-001, 3.427452e-001, 3.427419e-001, 3.427386e-001, 3.427353e-001, 3.427320e-001, 3.427287e-001, 3.427254e-001, 3.427220e-001, 3.427187e-001, 3.427154e-001, 3.427121e-001, 3.427088e-001, 3.427055e-001, 3.427022e-001, 3.426989e-001, 3.426956e-001, 3.426923e-001, 3.426890e-001, 3.426857e-001, 3.426823e-001, 3.426790e-001, 3.426757e-001, 3.426724e-001, 3.426691e-001, 3.426658e-001, 3.426625e-001, 3.426592e-001, 3.426559e-001, 3.426525e-001, 3.426492e-001, 3.426459e-001, 3.426426e-001, 3.426393e-001, 3.426360e-001, 3.426327e-001, 3.426294e-001, 3.426261e-001, 3.426227e-001, 3.426194e-001, 3.426161e-001, 3.426128e-001, 3.426095e-001, 3.426062e-001, 3.426029e-001, 3.425995e-001, 3.425962e-001, 3.425929e-001, 3.425896e-001, 3.425863e-001, 3.425830e-001, 3.425797e-001, 3.425763e-001, 3.425730e-001, 3.425697e-001, 3.425664e-001, 3.425631e-001, 3.425598e-001, 3.425564e-001, 3.425531e-001, 3.425498e-001, 3.425465e-001, 3.425432e-001, 3.425398e-001, 3.425365e-001, 3.425332e-001, 3.425299e-001, 3.425266e-001, 3.425233e-001, 3.425199e-001, 3.425166e-001, 3.425133e-001, 3.425100e-001, 3.425067e-001, 3.425033e-001, 3.425000e-001, 3.424967e-001, 3.424934e-001, 3.424901e-001, 3.424867e-001, 3.424834e-001, 3.424801e-001, 3.424768e-001, 3.424734e-001, 3.424701e-001, 3.424668e-001, 3.424635e-001, 3.424602e-001, 3.424568e-001, 3.424535e-001, 3.424502e-001, 3.424469e-001, 3.424435e-001, 3.424402e-001, 3.424369e-001, 3.424336e-001, 3.424302e-001, 3.424269e-001, 3.424236e-001, 3.424203e-001, 
3.424169e-001, 3.424136e-001, 3.424103e-001, 3.424070e-001, 3.424036e-001, 3.424003e-001, 3.423970e-001, 3.423937e-001, 3.423903e-001, 3.423870e-001, 3.423837e-001, 3.423804e-001, 3.423770e-001, 3.423737e-001, 3.423704e-001, 3.423670e-001, 3.423637e-001, 3.423604e-001, 3.423571e-001, 3.423537e-001, 3.423504e-001, 3.423471e-001, 3.423437e-001, 3.423404e-001, 3.423371e-001, 3.423338e-001, 3.423304e-001, 3.423271e-001, 3.423238e-001, 3.423204e-001, 3.423171e-001, 3.423138e-001, 3.423104e-001, 3.423071e-001, 3.423038e-001, 3.423004e-001, 3.422971e-001, 3.422938e-001, 3.422905e-001, 3.422871e-001, 3.422838e-001, 3.422805e-001, 3.422771e-001, 3.422738e-001, 3.422705e-001, 3.422671e-001, 3.422638e-001, 3.422604e-001, 3.422571e-001, 3.422538e-001, 3.422504e-001, 3.422471e-001, 3.422438e-001, 3.422404e-001, 3.422371e-001, 3.422338e-001, 3.422304e-001, 3.422271e-001, 3.422238e-001, 3.422204e-001, 3.422171e-001, 3.422137e-001, 3.422104e-001, 3.422071e-001, 3.422037e-001, 3.422004e-001, 3.421971e-001, 3.421937e-001, 3.421904e-001, 3.421870e-001, 3.421837e-001, 3.421804e-001, 3.421770e-001, 3.421737e-001, 3.421704e-001, 3.421670e-001, 3.421637e-001, 3.421603e-001, 3.421570e-001, 3.421537e-001, 3.421503e-001, 3.421470e-001, 3.421436e-001, 3.421403e-001, 3.421369e-001, 3.421336e-001, 3.421303e-001, 3.421269e-001, 3.421236e-001, 3.421202e-001, 3.421169e-001, 3.421135e-001, 3.421102e-001, 3.421069e-001, 3.421035e-001, 3.421002e-001, 3.420968e-001, 3.420935e-001, 3.420901e-001, 3.420868e-001, 
3.420835e-001, 3.420801e-001, 3.420768e-001, 3.420734e-001, 3.420701e-001, 3.420667e-001, 3.420634e-001, 3.420600e-001, 3.420567e-001, 3.420533e-001, 3.420500e-001, 3.420467e-001, 3.420433e-001, 3.420400e-001, 3.420366e-001, 3.420333e-001, 3.420299e-001, 3.420266e-001, 3.420232e-001, 3.420199e-001, 3.420165e-001, 3.420132e-001, 3.420098e-001, 3.420065e-001, 3.420031e-001, 3.419998e-001, 3.419964e-001, 3.419931e-001, 3.419897e-001, 3.419864e-001, 3.419830e-001, 3.419797e-001, 3.419763e-001, 3.419730e-001, 3.419696e-001, 3.419663e-001, 3.419629e-001, 3.419596e-001, 3.419562e-001, 3.419529e-001, 3.419495e-001, 3.419462e-001, 3.419428e-001, 3.419395e-001, 3.419361e-001, 3.419327e-001, 3.419294e-001, 3.419260e-001, 3.419227e-001, 3.419193e-001, 3.419160e-001, 3.419126e-001, 3.419093e-001, 3.419059e-001, 3.419026e-001, 3.418992e-001, 3.418958e-001, 3.418925e-001, 3.418891e-001, 3.418858e-001, 3.418824e-001, 3.418791e-001, 3.418757e-001, 3.418724e-001, 3.418690e-001, 3.418656e-001, 3.418623e-001, 3.418589e-001, 3.418556e-001, 3.418522e-001, 3.418489e-001, 3.418455e-001, 3.418421e-001, 3.418388e-001, 3.418354e-001, 3.418321e-001, 3.418287e-001, 3.418253e-001, 3.418220e-001, 3.418186e-001, 3.418153e-001, 3.418119e-001, 3.418085e-001, 3.418052e-001, 3.418018e-001, 3.417985e-001, 3.417951e-001, 3.417917e-001, 3.417884e-001, 3.417850e-001, 3.417816e-001, 3.417783e-001, 3.417749e-001, 3.417716e-001, 3.417682e-001, 3.417648e-001, 3.417615e-001, 3.417581e-001, 3.417547e-001, 3.417514e-001, 
3.417480e-001, 3.417447e-001, 3.417413e-001, 3.417379e-001, 3.417346e-001, 3.417312e-001, 3.417278e-001, 3.417245e-001, 3.417211e-001, 3.417177e-001, 3.417144e-001, 3.417110e-001, 3.417076e-001, 3.417043e-001, 3.417009e-001, 3.416975e-001, 3.416942e-001, 3.416908e-001, 3.416874e-001, 3.416841e-001, 3.416807e-001, 3.416773e-001, 3.416740e-001, 3.416706e-001, 3.416672e-001, 3.416639e-001, 3.416605e-001, 3.416571e-001, 3.416537e-001, 3.416504e-001, 3.416470e-001, 3.416436e-001, 3.416403e-001, 3.416369e-001, 3.416335e-001, 3.416302e-001, 3.416268e-001, 3.416234e-001, 3.416200e-001, 3.416167e-001, 3.416133e-001, 3.416099e-001, 3.416066e-001, 3.416032e-001, 3.415998e-001, 3.415964e-001, 3.415931e-001, 3.415897e-001, 3.415863e-001, 3.415829e-001, 3.415796e-001, 3.415762e-001, 3.415728e-001, 3.415694e-001, 3.415661e-001, 3.415627e-001, 3.415593e-001, 3.415559e-001, 3.415526e-001, 3.415492e-001, 3.415458e-001, 3.415424e-001, 3.415391e-001, 3.415357e-001, 3.415323e-001, 3.415289e-001, 3.415256e-001, 3.415222e-001, 3.415188e-001, 3.415154e-001, 3.415121e-001, 3.415087e-001, 3.415053e-001, 3.415019e-001, 3.414985e-001, 3.414952e-001, 3.414918e-001, 3.414884e-001, 3.414850e-001, 3.414816e-001, 3.414783e-001, 3.414749e-001, 3.414715e-001, 3.414681e-001, 3.414647e-001, 3.414614e-001, 3.414580e-001, 3.414546e-001, 3.414512e-001, 3.414478e-001, 3.414445e-001, 3.414411e-001, 3.414377e-001, 3.414343e-001, 3.414309e-001, 3.414275e-001, 3.414242e-001, 3.414208e-001, 3.414174e-001, 3.414140e-001, 
3.414106e-001, 3.414072e-001, 3.414039e-001, 3.414005e-001, 3.413971e-001, 3.413937e-001, 3.413903e-001, 3.413869e-001, 3.413836e-001, 3.413802e-001, 3.413768e-001, 3.413734e-001, 3.413700e-001, 3.413666e-001, 3.413632e-001, 3.413599e-001, 3.413565e-001, 3.413531e-001, 3.413497e-001, 3.413463e-001, 3.413429e-001, 3.413395e-001, 3.413361e-001, 3.413328e-001, 3.413294e-001, 3.413260e-001, 3.413226e-001, 3.413192e-001, 3.413158e-001, 3.413124e-001, 3.413090e-001, 3.413057e-001, 3.413023e-001, 3.412989e-001, 3.412955e-001, 3.412921e-001, 3.412887e-001, 3.412853e-001, 3.412819e-001, 3.412785e-001, 3.412751e-001, 3.412717e-001, 3.412684e-001, 3.412650e-001, 3.412616e-001, 3.412582e-001, 3.412548e-001, 3.412514e-001, 3.412480e-001, 3.412446e-001, 3.412412e-001, 3.412378e-001, 3.412344e-001, 3.412310e-001, 3.412276e-001, 3.412242e-001, 3.412209e-001, 3.412175e-001, 3.412141e-001, 3.412107e-001, 3.412073e-001, 3.412039e-001, 3.412005e-001, 3.411971e-001, 3.411937e-001, 3.411903e-001, 3.411869e-001, 3.411835e-001, 3.411801e-001, 3.411767e-001, 3.411733e-001, 3.411699e-001, 3.411665e-001, 3.411631e-001, 3.411597e-001, 3.411563e-001, 3.411529e-001, 3.411495e-001, 3.411461e-001, 3.411427e-001, 3.411393e-001, 3.411359e-001, 3.411325e-001, 3.411291e-001, 3.411257e-001, 3.411223e-001, 3.411189e-001, 3.411155e-001, 3.411121e-001, 3.411087e-001, 3.411053e-001, 3.411019e-001, 3.410985e-001, 3.410951e-001, 3.410917e-001, 3.410883e-001, 3.410849e-001, 3.410815e-001, 3.410781e-001, 3.410747e-001, 
3.410713e-001, 3.410679e-001, 3.410645e-001, 3.410611e-001, 3.410577e-001, 3.410543e-001, 3.410509e-001, 3.410475e-001, 3.410441e-001, 3.410407e-001, 3.410373e-001, 3.410339e-001, 3.410305e-001, 3.410271e-001, 3.410237e-001, 3.410202e-001, 3.410168e-001, 3.410134e-001, 3.410100e-001, 3.410066e-001, 3.410032e-001, 3.409998e-001, 3.409964e-001, 3.409930e-001, 3.409896e-001, 3.409862e-001, 3.409828e-001, 3.409794e-001, 3.409760e-001, 3.409725e-001, 3.409691e-001, 3.409657e-001, 3.409623e-001, 3.409589e-001, 3.409555e-001, 3.409521e-001, 3.409487e-001, 3.409453e-001, 3.409419e-001, 3.409385e-001, 3.409350e-001, 3.409316e-001, 3.409282e-001, 3.409248e-001, 3.409214e-001, 3.409180e-001, 3.409146e-001, 3.409112e-001, 3.409078e-001, 3.409043e-001, 3.409009e-001, 3.408975e-001, 3.408941e-001, 3.408907e-001, 3.408873e-001, 3.408839e-001, 3.408804e-001, 3.408770e-001, 3.408736e-001, 3.408702e-001, 3.408668e-001, 3.408634e-001, 3.408600e-001, 3.408565e-001, 3.408531e-001, 3.408497e-001, 3.408463e-001, 3.408429e-001, 3.408395e-001, 3.408361e-001, 3.408326e-001, 3.408292e-001, 3.408258e-001, 3.408224e-001, 3.408190e-001, 3.408156e-001, 3.408121e-001, 3.408087e-001, 3.408053e-001, 3.408019e-001, 3.407985e-001, 3.407950e-001, 3.407916e-001, 3.407882e-001, 3.407848e-001, 3.407814e-001, 3.407780e-001, 3.407745e-001, 3.407711e-001, 3.407677e-001, 3.407643e-001, 3.407609e-001, 3.407574e-001, 3.407540e-001, 3.407506e-001, 3.407472e-001, 3.407437e-001, 3.407403e-001, 3.407369e-001, 3.407335e-001, 
3.407301e-001, 3.407266e-001, 3.407232e-001, 3.407198e-001, 3.407164e-001, 3.407129e-001, 3.407095e-001, 3.407061e-001, 3.407027e-001, 3.406993e-001, 3.406958e-001, 3.406924e-001, 3.406890e-001, 3.406856e-001, 3.406821e-001, 3.406787e-001, 3.406753e-001, 3.406719e-001, 3.406684e-001, 3.406650e-001, 3.406616e-001, 3.406582e-001, 3.406547e-001, 3.406513e-001, 3.406479e-001, 3.406444e-001, 3.406410e-001, 3.406376e-001, 3.406342e-001, 3.406307e-001, 3.406273e-001, 3.406239e-001, 3.406204e-001, 3.406170e-001, 3.406136e-001, 3.406102e-001, 3.406067e-001, 3.406033e-001, 3.405999e-001, 3.405964e-001, 3.405930e-001, 3.405896e-001, 3.405862e-001, 3.405827e-001, 3.405793e-001, 3.405759e-001, 3.405724e-001, 3.405690e-001, 3.405656e-001, 3.405621e-001, 3.405587e-001, 3.405553e-001, 3.405518e-001, 3.405484e-001, 3.405450e-001, 3.405415e-001, 3.405381e-001, 3.405347e-001, 3.405312e-001, 3.405278e-001, 3.405244e-001, 3.405209e-001, 3.405175e-001, 3.405141e-001, 3.405106e-001, 3.405072e-001, 3.405038e-001, 3.405003e-001, 3.404969e-001, 3.404935e-001, 3.404900e-001, 3.404866e-001, 3.404832e-001, 3.404797e-001, 3.404763e-001, 3.404729e-001, 3.404694e-001, 3.404660e-001, 3.404625e-001, 3.404591e-001, 3.404557e-001, 3.404522e-001, 3.404488e-001, 3.404454e-001, 3.404419e-001, 3.404385e-001, 3.404350e-001, 3.404316e-001, 3.404282e-001, 3.404247e-001, 3.404213e-001, 3.404178e-001, 3.404144e-001, 3.404110e-001, 3.404075e-001, 3.404041e-001, 3.404006e-001, 3.403972e-001, 3.403938e-001, 3.403903e-001, 
3.403869e-001, 3.403834e-001, 3.403800e-001, 3.403765e-001, 3.403731e-001, 3.403697e-001, 3.403662e-001, 3.403628e-001, 3.403593e-001, 3.403559e-001, 3.403524e-001, 3.403490e-001, 3.403456e-001, 3.403421e-001, 3.403387e-001, 3.403352e-001, 3.403318e-001, 3.403283e-001, 3.403249e-001, 3.403215e-001, 3.403180e-001, 3.403146e-001, 3.403111e-001, 3.403077e-001, 3.403042e-001, 3.403008e-001, 3.402973e-001, 3.402939e-001, 3.402904e-001, 3.402870e-001, 3.402835e-001, 3.402801e-001, 3.402766e-001, 3.402732e-001, 3.402698e-001, 3.402663e-001, 3.402629e-001, 3.402594e-001, 3.402560e-001, 3.402525e-001, 3.402491e-001, 3.402456e-001, 3.402422e-001, 3.402387e-001, 3.402353e-001, 3.402318e-001, 3.402284e-001, 3.402249e-001, 3.402215e-001, 3.402180e-001, 3.402146e-001, 3.402111e-001, 3.402077e-001, 3.402042e-001, 3.402008e-001, 3.401973e-001, 3.401938e-001, 3.401904e-001, 3.401869e-001, 3.401835e-001, 3.401800e-001, 3.401766e-001, 3.401731e-001, 3.401697e-001, 3.401662e-001, 3.401628e-001, 3.401593e-001, 3.401559e-001, 3.401524e-001, 3.401490e-001, 3.401455e-001, 3.401420e-001, 3.401386e-001, 3.401351e-001, 3.401317e-001, 3.401282e-001, 3.401248e-001, 3.401213e-001, 3.401179e-001, 3.401144e-001, 3.401109e-001, 3.401075e-001, 3.401040e-001, 3.401006e-001, 3.400971e-001, 3.400937e-001, 3.400902e-001, 3.400867e-001, 3.400833e-001, 3.400798e-001, 3.400764e-001, 3.400729e-001, 3.400694e-001, 3.400660e-001, 3.400625e-001, 3.400591e-001, 3.400556e-001, 3.400521e-001, 3.400487e-001, 3.400452e-001, 
3.400418e-001, 3.400383e-001, 3.400348e-001, 3.400314e-001, 3.400279e-001, 3.400245e-001, 3.400210e-001, 3.400175e-001, 3.400141e-001, 3.400106e-001, 3.400071e-001, 3.400037e-001, 3.400002e-001, 3.399968e-001, 3.399933e-001, 3.399898e-001, 3.399864e-001, 3.399829e-001, 3.399794e-001, 3.399760e-001, 3.399725e-001, 3.399690e-001, 3.399656e-001, 3.399621e-001, 3.399587e-001, 3.399552e-001, 3.399517e-001, 3.399483e-001, 3.399448e-001, 3.399413e-001, 3.399379e-001, 3.399344e-001, 3.399309e-001, 3.399275e-001, 3.399240e-001, 3.399205e-001, 3.399171e-001, 3.399136e-001, 3.399101e-001, 3.399066e-001, 3.399032e-001, 3.398997e-001, 3.398962e-001, 3.398928e-001, 3.398893e-001, 3.398858e-001, 3.398824e-001, 3.398789e-001, 3.398754e-001, 3.398720e-001, 3.398685e-001, 3.398650e-001, 3.398615e-001, 3.398581e-001, 3.398546e-001, 3.398511e-001, 3.398477e-001, 3.398442e-001, 3.398407e-001, 3.398372e-001, 3.398338e-001, 3.398303e-001, 3.398268e-001, 3.398234e-001, 3.398199e-001, 3.398164e-001, 3.398129e-001, 3.398095e-001, 3.398060e-001, 3.398025e-001, 3.397990e-001, 3.397956e-001, 3.397921e-001, 3.397886e-001, 3.397851e-001, 3.397817e-001, 3.397782e-001, 3.397747e-001, 3.397712e-001, 3.397678e-001, 3.397643e-001, 3.397608e-001, 3.397573e-001, 3.397539e-001, 3.397504e-001, 3.397469e-001, 3.397434e-001, 3.397400e-001, 3.397365e-001, 3.397330e-001, 3.397295e-001, 3.397260e-001, 3.397226e-001, 3.397191e-001, 3.397156e-001, 3.397121e-001, 3.397086e-001, 3.397052e-001, 3.397017e-001, 3.396982e-001, 
3.396947e-001, 3.396912e-001, 3.396878e-001, 3.396843e-001, 3.396808e-001, 3.396773e-001, 3.396738e-001, 3.396704e-001, 3.396669e-001, 3.396634e-001, 3.396599e-001, 3.396564e-001, 3.396530e-001, 3.396495e-001, 3.396460e-001, 3.396425e-001, 3.396390e-001, 3.396355e-001, 3.396321e-001, 3.396286e-001, 3.396251e-001, 3.396216e-001, 3.396181e-001, 3.396146e-001, 3.396112e-001, 3.396077e-001, 3.396042e-001, 3.396007e-001, 3.395972e-001, 3.395937e-001, 3.395902e-001, 3.395868e-001, 3.395833e-001, 3.395798e-001, 3.395763e-001, 3.395728e-001, 3.395693e-001, 3.395658e-001, 3.395624e-001, 3.395589e-001, 3.395554e-001, 3.395519e-001, 3.395484e-001, 3.395449e-001, 3.395414e-001, 3.395379e-001, 3.395344e-001, 3.395310e-001, 3.395275e-001, 3.395240e-001, 3.395205e-001, 3.395170e-001, 3.395135e-001, 3.395100e-001, 3.395065e-001, 3.395030e-001, 3.394996e-001, 3.394961e-001, 3.394926e-001, 3.394891e-001, 3.394856e-001, 3.394821e-001, 3.394786e-001, 3.394751e-001, 3.394716e-001, 3.394681e-001, 3.394646e-001, 3.394611e-001, 3.394576e-001, 3.394542e-001, 3.394507e-001, 3.394472e-001, 3.394437e-001, 3.394402e-001, 3.394367e-001, 3.394332e-001, 3.394297e-001, 3.394262e-001, 3.394227e-001, 3.394192e-001, 3.394157e-001, 3.394122e-001, 3.394087e-001, 3.394052e-001, 3.394017e-001, 3.393982e-001, 3.393947e-001, 3.393912e-001, 3.393878e-001, 3.393843e-001, 3.393808e-001, 3.393773e-001, 3.393738e-001, 3.393703e-001, 3.393668e-001, 3.393633e-001, 3.393598e-001, 3.393563e-001, 3.393528e-001, 3.393493e-001, 
3.393458e-001, 3.393423e-001, 3.393388e-001, 3.393353e-001, 3.393318e-001, 3.393283e-001, 3.393248e-001, 3.393213e-001, 3.393178e-001, 3.393143e-001, 3.393108e-001, 3.393073e-001, 3.393038e-001, 3.393003e-001, 3.392968e-001, 3.392933e-001, 3.392898e-001, 3.392863e-001, 3.392828e-001, 3.392793e-001, 3.392758e-001, 3.392723e-001, 3.392687e-001, 3.392652e-001, 3.392617e-001, 3.392582e-001, 3.392547e-001, 3.392512e-001, 3.392477e-001, 3.392442e-001, 3.392407e-001, 3.392372e-001, 3.392337e-001, 3.392302e-001, 3.392267e-001, 3.392232e-001, 3.392197e-001, 3.392162e-001, 3.392127e-001, 3.392092e-001, 3.392057e-001, 3.392021e-001, 3.391986e-001, 3.391951e-001, 3.391916e-001, 3.391881e-001, 3.391846e-001, 3.391811e-001, 3.391776e-001, 3.391741e-001, 3.391706e-001, 3.391671e-001, 3.391636e-001, 3.391601e-001, 3.391565e-001, 3.391530e-001, 3.391495e-001, 3.391460e-001, 3.391425e-001, 3.391390e-001, 3.391355e-001, 3.391320e-001, 3.391285e-001, 3.391249e-001, 3.391214e-001, 3.391179e-001, 3.391144e-001, 3.391109e-001, 3.391074e-001, 3.391039e-001, 3.391004e-001, 3.390969e-001, 3.390933e-001, 3.390898e-001, 3.390863e-001, 3.390828e-001, 3.390793e-001, 3.390758e-001, 3.390723e-001, 3.390687e-001, 3.390652e-001, 3.390617e-001, 3.390582e-001, 3.390547e-001, 3.390512e-001, 3.390477e-001, 3.390441e-001, 3.390406e-001, 3.390371e-001, 3.390336e-001, 3.390301e-001, 3.390266e-001, 3.390230e-001, 3.390195e-001, 3.390160e-001, 3.390125e-001, 3.390090e-001, 3.390055e-001, 3.390019e-001, 3.389984e-001, 
3.389949e-001, 3.389914e-001, 3.389879e-001, 3.389843e-001, 3.389808e-001, 3.389773e-001, 3.389738e-001, 3.389703e-001, 3.389668e-001, 3.389632e-001, 3.389597e-001, 3.389562e-001, 3.389527e-001, 3.389492e-001, 3.389456e-001, 3.389421e-001, 3.389386e-001, 3.389351e-001, 3.389315e-001, 3.389280e-001, 3.389245e-001, 3.389210e-001, 3.389175e-001, 3.389139e-001, 3.389104e-001, 3.389069e-001, 3.389034e-001, 3.388998e-001, 3.388963e-001, 3.388928e-001, 3.388893e-001, 3.388857e-001, 3.388822e-001, 3.388787e-001, 3.388752e-001, 3.388716e-001, 3.388681e-001, 3.388646e-001, 3.388611e-001, 3.388575e-001, 3.388540e-001, 3.388505e-001, 3.388470e-001, 3.388434e-001, 3.388399e-001, 3.388364e-001, 3.388329e-001, 3.388293e-001, 3.388258e-001, 3.388223e-001, 3.388188e-001, 3.388152e-001, 3.388117e-001, 3.388082e-001, 3.388046e-001, 3.388011e-001, 3.387976e-001, 3.387941e-001, 3.387905e-001, 3.387870e-001, 3.387835e-001, 3.387799e-001, 3.387764e-001, 3.387729e-001, 3.387693e-001, 3.387658e-001, 3.387623e-001, 3.387588e-001, 3.387552e-001, 3.387517e-001, 3.387482e-001, 3.387446e-001, 3.387411e-001, 3.387376e-001, 3.387340e-001, 3.387305e-001, 3.387270e-001, 3.387234e-001, 3.387199e-001, 3.387164e-001, 3.387128e-001, 3.387093e-001, 3.387058e-001, 3.387022e-001, 3.386987e-001, 3.386952e-001, 3.386916e-001, 3.386881e-001, 3.386846e-001, 3.386810e-001, 3.386775e-001, 3.386740e-001, 3.386704e-001, 3.386669e-001, 3.386633e-001, 3.386598e-001, 3.386563e-001, 3.386527e-001, 3.386492e-001, 3.386457e-001, 
3.386421e-001, 3.386386e-001, 3.386350e-001, 3.386315e-001, 3.386280e-001, 3.386244e-001, 3.386209e-001, 3.386174e-001, 3.386138e-001, 3.386103e-001, 3.386067e-001, 3.386032e-001, 3.385997e-001, 3.385961e-001, 3.385926e-001, 3.385890e-001, 3.385855e-001, 3.385820e-001, 3.385784e-001, 3.385749e-001, 3.385713e-001, 3.385678e-001, 3.385643e-001, 3.385607e-001, 3.385572e-001, 3.385536e-001, 3.385501e-001, 3.385465e-001, 3.385430e-001, 3.385395e-001, 3.385359e-001, 3.385324e-001, 3.385288e-001, 3.385253e-001, 3.385217e-001, 3.385182e-001, 3.385147e-001, 3.385111e-001, 3.385076e-001, 3.385040e-001, 3.385005e-001, 3.384969e-001, 3.384934e-001, 3.384898e-001, 3.384863e-001, 3.384827e-001, 3.384792e-001, 3.384757e-001, 3.384721e-001, 3.384686e-001, 3.384650e-001, 3.384615e-001, 3.384579e-001, 3.384544e-001, 3.384508e-001, 3.384473e-001, 3.384437e-001, 3.384402e-001, 3.384366e-001, 3.384331e-001, 3.384295e-001, 3.384260e-001, 3.384224e-001, 3.384189e-001, 3.384153e-001, 3.384118e-001, 3.384082e-001, 3.384047e-001, 3.384011e-001, 3.383976e-001, 3.383940e-001, 3.383905e-001, 3.383869e-001, 3.383834e-001, 3.383798e-001, 3.383763e-001, 3.383727e-001, 3.383692e-001, 3.383656e-001, 3.383621e-001, 3.383585e-001, 3.383550e-001, 3.383514e-001, 3.383479e-001, 3.383443e-001, 3.383408e-001, 3.383372e-001, 3.383337e-001, 3.383301e-001, 3.383265e-001, 3.383230e-001, 3.383194e-001, 3.383159e-001, 3.383123e-001, 3.383088e-001, 3.383052e-001, 3.383017e-001, 3.382981e-001, 3.382945e-001, 3.382910e-001, 
3.382874e-001, 3.382839e-001, 3.382803e-001, 3.382768e-001, 3.382732e-001, 3.382696e-001, 3.382661e-001, 3.382625e-001, 3.382590e-001, 3.382554e-001, 3.382519e-001, 3.382483e-001, 3.382447e-001, 3.382412e-001, 3.382376e-001, 3.382341e-001, 3.382305e-001, 3.382269e-001, 3.382234e-001, 3.382198e-001, 3.382163e-001, 3.382127e-001, 3.382091e-001, 3.382056e-001, 3.382020e-001, 3.381985e-001, 3.381949e-001, 3.381913e-001, 3.381878e-001, 3.381842e-001, 3.381807e-001, 3.381771e-001, 3.381735e-001, 3.381700e-001, 3.381664e-001, 3.381628e-001, 3.381593e-001, 3.381557e-001, 3.381522e-001, 3.381486e-001, 3.381450e-001, 3.381415e-001, 3.381379e-001, 3.381343e-001, 3.381308e-001, 3.381272e-001, 3.381236e-001, 3.381201e-001, 3.381165e-001, 3.381129e-001, 3.381094e-001, 3.381058e-001, 3.381022e-001, 3.380987e-001, 3.380951e-001, 3.380915e-001, 3.380880e-001, 3.380844e-001, 3.380808e-001, 3.380773e-001, 3.380737e-001, 3.380701e-001, 3.380666e-001, 3.380630e-001, 3.380594e-001, 3.380559e-001, 3.380523e-001, 3.380487e-001, 3.380452e-001, 3.380416e-001, 3.380380e-001, 3.380344e-001, 3.380309e-001, 3.380273e-001, 3.380237e-001, 3.380202e-001, 3.380166e-001, 3.380130e-001, 3.380095e-001, 3.380059e-001, 3.380023e-001, 3.379987e-001, 3.379952e-001, 3.379916e-001, 3.379880e-001, 3.379844e-001, 3.379809e-001, 3.379773e-001, 3.379737e-001, 3.379702e-001, 3.379666e-001, 3.379630e-001, 3.379594e-001, 3.379559e-001, 3.379523e-001, 3.379487e-001, 3.379451e-001, 3.379416e-001, 3.379380e-001, 3.379344e-001, 
3.379308e-001, 3.379273e-001, 3.379237e-001, 3.379201e-001, 3.379165e-001, 3.379130e-001, 3.379094e-001, 3.379058e-001, 3.379022e-001, 3.378987e-001, 3.378951e-001, 3.378915e-001, 3.378879e-001, 3.378843e-001, 3.378808e-001, 3.378772e-001, 3.378736e-001, 3.378700e-001, 3.378664e-001, 3.378629e-001, 3.378593e-001, 3.378557e-001, 3.378521e-001, 3.378486e-001, 3.378450e-001, 3.378414e-001, 3.378378e-001, 3.378342e-001, 3.378307e-001, 3.378271e-001, 3.378235e-001, 3.378199e-001, 3.378163e-001, 3.378127e-001, 3.378092e-001, 3.378056e-001, 3.378020e-001, 3.377984e-001, 3.377948e-001, 3.377913e-001, 3.377877e-001, 3.377841e-001, 3.377805e-001, 3.377769e-001, 3.377733e-001, 3.377698e-001, 3.377662e-001, 3.377626e-001, 3.377590e-001, 3.377554e-001, 3.377518e-001, 3.377482e-001, 3.377447e-001, 3.377411e-001, 3.377375e-001, 3.377339e-001, 3.377303e-001, 3.377267e-001, 3.377231e-001, 3.377196e-001, 3.377160e-001, 3.377124e-001, 3.377088e-001, 3.377052e-001, 3.377016e-001, 3.376980e-001, 3.376944e-001, 3.376909e-001, 3.376873e-001, 3.376837e-001, 3.376801e-001, 3.376765e-001, 3.376729e-001, 3.376693e-001, 3.376657e-001, 3.376621e-001, 3.376586e-001, 3.376550e-001, 3.376514e-001, 3.376478e-001, 3.376442e-001, 3.376406e-001, 3.376370e-001, 3.376334e-001, 3.376298e-001, 3.376262e-001, 3.376226e-001, 3.376191e-001, 3.376155e-001, 3.376119e-001, 3.376083e-001, 3.376047e-001, 3.376011e-001, 3.375975e-001, 3.375939e-001, 3.375903e-001, 3.375867e-001, 3.375831e-001, 3.375795e-001, 3.375759e-001, 
3.375723e-001, 3.375687e-001, 3.375652e-001, 3.375616e-001, 3.375580e-001, 3.375544e-001, 3.375508e-001, 3.375472e-001, 3.375436e-001, 3.375400e-001, 3.375364e-001, 3.375328e-001, 3.375292e-001, 3.375256e-001, 3.375220e-001, 3.375184e-001, 3.375148e-001, 3.375112e-001, 3.375076e-001, 3.375040e-001, 3.375004e-001, 3.374968e-001, 3.374932e-001, 3.374896e-001, 3.374860e-001, 3.374824e-001, 3.374788e-001, 3.374752e-001, 3.374716e-001, 3.374680e-001, 3.374644e-001, 3.374608e-001, 3.374572e-001, 3.374536e-001, 3.374500e-001, 3.374464e-001, 3.374428e-001, 3.374392e-001, 3.374356e-001, 3.374320e-001, 3.374284e-001, 3.374248e-001, 3.374212e-001, 3.374176e-001, 3.374140e-001, 3.374104e-001, 3.374068e-001, 3.374032e-001, 3.373996e-001, 3.373960e-001, 3.373924e-001, 3.373888e-001, 3.373852e-001, 3.373816e-001, 3.373780e-001, 3.373744e-001, 3.373708e-001, 3.373672e-001, 3.373635e-001, 3.373599e-001, 3.373563e-001, 3.373527e-001, 3.373491e-001, 3.373455e-001, 3.373419e-001, 3.373383e-001, 3.373347e-001, 3.373311e-001, 3.373275e-001, 3.373239e-001, 3.373203e-001, 3.373167e-001, 3.373131e-001, 3.373094e-001, 3.373058e-001, 3.373022e-001, 3.372986e-001, 3.372950e-001, 3.372914e-001, 3.372878e-001, 3.372842e-001, 3.372806e-001, 3.372770e-001, 3.372734e-001, 3.372697e-001, 3.372661e-001, 3.372625e-001, 3.372589e-001, 3.372553e-001, 3.372517e-001, 3.372481e-001, 3.372445e-001, 3.372409e-001, 3.372372e-001, 3.372336e-001, 3.372300e-001, 3.372264e-001, 3.372228e-001, 3.372192e-001, 3.372156e-001, 
3.372119e-001, 3.372083e-001, 3.372047e-001, 3.372011e-001, 3.371975e-001, 3.371939e-001, 3.371903e-001, 3.371867e-001, 3.371830e-001, 3.371794e-001, 3.371758e-001, 3.371722e-001, 3.371686e-001, 3.371650e-001, 3.371613e-001, 3.371577e-001, 3.371541e-001, 3.371505e-001, 3.371469e-001, 3.371433e-001, 3.371396e-001, 3.371360e-001, 3.371324e-001, 3.371288e-001, 3.371252e-001, 3.371216e-001, 3.371179e-001, 3.371143e-001, 3.371107e-001, 3.371071e-001, 3.371035e-001, 3.370998e-001, 3.370962e-001, 3.370926e-001, 3.370890e-001, 3.370854e-001, 3.370817e-001, 3.370781e-001, 3.370745e-001, 3.370709e-001, 3.370673e-001, 3.370636e-001, 3.370600e-001, 3.370564e-001, 3.370528e-001, 3.370492e-001, 3.370455e-001, 3.370419e-001, 3.370383e-001, 3.370347e-001, 3.370310e-001, 3.370274e-001, 3.370238e-001, 3.370202e-001, 3.370165e-001, 3.370129e-001, 3.370093e-001, 3.370057e-001, 3.370021e-001, 3.369984e-001, 3.369948e-001, 3.369912e-001, 3.369876e-001, 3.369839e-001, 3.369803e-001, 3.369767e-001, 3.369731e-001, 3.369694e-001, 3.369658e-001, 3.369622e-001, 3.369585e-001, 3.369549e-001, 3.369513e-001, 3.369477e-001, 3.369440e-001, 3.369404e-001, 3.369368e-001, 3.369332e-001, 3.369295e-001, 3.369259e-001, 3.369223e-001, 3.369186e-001, 3.369150e-001, 3.369114e-001, 3.369078e-001, 3.369041e-001, 3.369005e-001, 3.368969e-001, 3.368932e-001, 3.368896e-001, 3.368860e-001, 3.368823e-001, 3.368787e-001, 3.368751e-001, 3.368715e-001, 3.368678e-001, 3.368642e-001, 3.368606e-001, 3.368569e-001, 3.368533e-001, 
3.368497e-001, 3.368460e-001, 3.368424e-001, 3.368388e-001, 3.368351e-001, 3.368315e-001, 3.368279e-001, 3.368242e-001, 3.368206e-001, 3.368170e-001, 3.368133e-001, 3.368097e-001, 3.368061e-001, 3.368024e-001, 3.367988e-001, 3.367952e-001, 3.367915e-001, 3.367879e-001, 3.367842e-001, 3.367806e-001, 3.367770e-001, 3.367733e-001, 3.367697e-001, 3.367661e-001, 3.367624e-001, 3.367588e-001, 3.367552e-001, 3.367515e-001, 3.367479e-001, 3.367442e-001, 3.367406e-001, 3.367370e-001, 3.367333e-001, 3.367297e-001, 3.367261e-001, 3.367224e-001, 3.367188e-001, 3.367151e-001, 3.367115e-001, 3.367079e-001, 3.367042e-001, 3.367006e-001, 3.366969e-001, 3.366933e-001, 3.366897e-001, 3.366860e-001, 3.366824e-001, 3.366787e-001, 3.366751e-001, 3.366715e-001, 3.366678e-001, 3.366642e-001, 3.366605e-001, 3.366569e-001, 3.366532e-001, 3.366496e-001, 3.366460e-001, 3.366423e-001, 3.366387e-001, 3.366350e-001, 3.366314e-001, 3.366277e-001, 3.366241e-001, 3.366205e-001, 3.366168e-001, 3.366132e-001, 3.366095e-001, 3.366059e-001, 3.366022e-001, 3.365986e-001, 3.365949e-001, 3.365913e-001, 3.365876e-001, 3.365840e-001, 3.365804e-001, 3.365767e-001, 3.365731e-001, 3.365694e-001, 3.365658e-001, 3.365621e-001, 3.365585e-001, 3.365548e-001, 3.365512e-001, 3.365475e-001, 3.365439e-001, 3.365402e-001, 3.365366e-001, 3.365329e-001, 3.365293e-001, 3.365256e-001, 3.365220e-001, 3.365183e-001, 3.365147e-001, 3.365110e-001, 3.365074e-001, 3.365037e-001, 3.365001e-001, 3.364964e-001, 3.364928e-001, 3.364891e-001, 
3.364855e-001, 3.364818e-001, 3.364782e-001, 3.364745e-001, 3.364709e-001, 3.364672e-001, 3.364636e-001, 3.364599e-001, 3.364563e-001, 3.364526e-001, 3.364490e-001, 3.364453e-001, 3.364417e-001, 3.364380e-001, 3.364343e-001, 3.364307e-001, 3.364270e-001, 3.364234e-001, 3.364197e-001, 3.364161e-001, 3.364124e-001, 3.364088e-001, 3.364051e-001, 3.364015e-001, 3.363978e-001, 3.363941e-001, 3.363905e-001, 3.363868e-001, 3.363832e-001, 3.363795e-001, 3.363759e-001, 3.363722e-001, 3.363685e-001, 3.363649e-001, 3.363612e-001, 3.363576e-001, 3.363539e-001, 3.363503e-001, 3.363466e-001, 3.363429e-001, 3.363393e-001, 3.363356e-001, 3.363320e-001, 3.363283e-001, 3.363246e-001, 3.363210e-001, 3.363173e-001, 3.363137e-001, 3.363100e-001, 3.363063e-001, 3.363027e-001, 3.362990e-001, 3.362954e-001, 3.362917e-001, 3.362880e-001, 3.362844e-001, 3.362807e-001, 3.362771e-001, 3.362734e-001, 3.362697e-001, 3.362661e-001, 3.362624e-001, 3.362587e-001, 3.362551e-001, 3.362514e-001, 3.362478e-001, 3.362441e-001, 3.362404e-001, 3.362368e-001, 3.362331e-001, 3.362294e-001, 3.362258e-001, 3.362221e-001, 3.362184e-001, 3.362148e-001, 3.362111e-001, 3.362074e-001, 3.362038e-001, 3.362001e-001, 3.361964e-001, 3.361928e-001, 3.361891e-001, 3.361855e-001, 3.361818e-001, 3.361781e-001, 3.361744e-001, 3.361708e-001, 3.361671e-001, 3.361634e-001, 3.361598e-001, 3.361561e-001, 3.361524e-001, 3.361488e-001, 3.361451e-001, 3.361414e-001, 3.361378e-001, 3.361341e-001, 3.361304e-001, 3.361268e-001, 3.361231e-001, 
3.361194e-001, 3.361157e-001, 3.361121e-001, 3.361084e-001, 3.361047e-001, 3.361011e-001, 3.360974e-001, 3.360937e-001, 3.360901e-001, 3.360864e-001, 3.360827e-001, 3.360790e-001, 3.360754e-001, 3.360717e-001, 3.360680e-001, 3.360643e-001, 3.360607e-001, 3.360570e-001, 3.360533e-001, 3.360497e-001, 3.360460e-001, 3.360423e-001, 3.360386e-001, 3.360350e-001, 3.360313e-001, 3.360276e-001, 3.360239e-001, 3.360203e-001, 3.360166e-001, 3.360129e-001, 3.360092e-001, 3.360056e-001, 3.360019e-001, 3.359982e-001, 3.359945e-001, 3.359909e-001, 3.359872e-001, 3.359835e-001, 3.359798e-001, 3.359761e-001, 3.359725e-001, 3.359688e-001, 3.359651e-001, 3.359614e-001, 3.359578e-001, 3.359541e-001, 3.359504e-001, 3.359467e-001, 3.359430e-001, 3.359394e-001, 3.359357e-001, 3.359320e-001, 3.359283e-001, 3.359246e-001, 3.359210e-001, 3.359173e-001, 3.359136e-001, 3.359099e-001, 3.359062e-001, 3.359026e-001, 3.358989e-001, 3.358952e-001, 3.358915e-001, 3.358878e-001, 3.358842e-001, 3.358805e-001, 3.358768e-001, 3.358731e-001, 3.358694e-001, 3.358657e-001, 3.358621e-001, 3.358584e-001, 3.358547e-001, 3.358510e-001, 3.358473e-001, 3.358436e-001, 3.358400e-001, 3.358363e-001, 3.358326e-001, 3.358289e-001, 3.358252e-001, 3.358215e-001, 3.358178e-001, 3.358142e-001, 3.358105e-001, 3.358068e-001, 3.358031e-001, 3.357994e-001, 3.357957e-001, 3.357920e-001, 3.357884e-001, 3.357847e-001, 3.357810e-001, 3.357773e-001, 3.357736e-001, 3.357699e-001, 3.357662e-001, 3.357625e-001, 3.357588e-001, 3.357552e-001, 
3.357515e-001, 3.357478e-001, 3.357441e-001, 3.357404e-001, 3.357367e-001, 3.357330e-001, 3.357293e-001, 3.357256e-001, 3.357220e-001, 3.357183e-001, 3.357146e-001, 3.357109e-001, 3.357072e-001, 3.357035e-001, 3.356998e-001, 3.356961e-001, 3.356924e-001, 3.356887e-001, 3.356850e-001, 3.356813e-001, 3.356777e-001, 3.356740e-001, 3.356703e-001, 3.356666e-001, 3.356629e-001, 3.356592e-001, 3.356555e-001, 3.356518e-001, 3.356481e-001, 3.356444e-001, 3.356407e-001, 3.356370e-001, 3.356333e-001, 3.356296e-001, 3.356259e-001, 3.356222e-001, 3.356186e-001, 3.356149e-001, 3.356112e-001, 3.356075e-001, 3.356038e-001, 3.356001e-001, 3.355964e-001, 3.355927e-001, 3.355890e-001, 3.355853e-001, 3.355816e-001, 3.355779e-001, 3.355742e-001, 3.355705e-001, 3.355668e-001, 3.355631e-001, 3.355594e-001, 3.355557e-001, 3.355520e-001, 3.355483e-001, 3.355446e-001, 3.355409e-001, 3.355372e-001, 3.355335e-001, 3.355298e-001, 3.355261e-001, 3.355224e-001, 3.355187e-001, 3.355150e-001, 3.355113e-001, 3.355076e-001, 3.355039e-001, 3.355002e-001, 3.354965e-001, 3.354928e-001, 3.354891e-001, 3.354854e-001, 3.354817e-001, 3.354780e-001, 3.354743e-001, 3.354706e-001, 3.354669e-001, 3.354632e-001, 3.354595e-001, 3.354558e-001, 3.354521e-001, 3.354484e-001, 3.354446e-001, 3.354409e-001, 3.354372e-001, 3.354335e-001, 3.354298e-001, 3.354261e-001, 3.354224e-001, 3.354187e-001, 3.354150e-001, 3.354113e-001, 3.354076e-001, 3.354039e-001, 3.354002e-001, 3.353965e-001, 3.353928e-001, 3.353891e-001, 3.353854e-001, 
3.353816e-001, 3.353779e-001, 3.353742e-001, 3.353705e-001, 3.353668e-001, 3.353631e-001, 3.353594e-001, 3.353557e-001, 3.353520e-001, 3.353483e-001, 3.353446e-001, 3.353408e-001, 3.353371e-001, 3.353334e-001, 3.353297e-001, 3.353260e-001, 3.353223e-001, 3.353186e-001, 3.353149e-001, 3.353112e-001, 3.353075e-001, 3.353037e-001, 3.353000e-001, 3.352963e-001, 3.352926e-001, 3.352889e-001, 3.352852e-001, 3.352815e-001, 3.352778e-001, 3.352740e-001, 3.352703e-001, 3.352666e-001, 3.352629e-001, 3.352592e-001, 3.352555e-001, 3.352518e-001, 3.352480e-001, 3.352443e-001, 3.352406e-001, 3.352369e-001, 3.352332e-001, 3.352295e-001, 3.352258e-001, 3.352220e-001, 3.352183e-001, 3.352146e-001, 3.352109e-001, 3.352072e-001, 3.352035e-001, 3.351997e-001, 3.351960e-001, 3.351923e-001, 3.351886e-001, 3.351849e-001, 3.351812e-001, 3.351774e-001, 3.351737e-001, 3.351700e-001, 3.351663e-001, 3.351626e-001, 3.351588e-001, 3.351551e-001, 3.351514e-001, 3.351477e-001, 3.351440e-001, 3.351403e-001, 3.351365e-001, 3.351328e-001, 3.351291e-001, 3.351254e-001, 3.351216e-001, 3.351179e-001, 3.351142e-001, 3.351105e-001, 3.351068e-001, 3.351030e-001, 3.350993e-001, 3.350956e-001, 3.350919e-001, 3.350882e-001, 3.350844e-001, 3.350807e-001, 3.350770e-001, 3.350733e-001, 3.350695e-001, 3.350658e-001, 3.350621e-001, 3.350584e-001, 3.350546e-001, 3.350509e-001, 3.350472e-001, 3.350435e-001, 3.350397e-001, 3.350360e-001, 3.350323e-001, 3.350286e-001, 3.350248e-001, 3.350211e-001, 3.350174e-001, 3.350137e-001, 
3.350099e-001, 3.350062e-001, 3.350025e-001, 3.349988e-001, 3.349950e-001, 3.349913e-001, 3.349876e-001, 3.349839e-001, 3.349801e-001, 3.349764e-001, 3.349727e-001, 3.349689e-001, 3.349652e-001, 3.349615e-001, 3.349578e-001, 3.349540e-001, 3.349503e-001, 3.349466e-001, 3.349428e-001, 3.349391e-001, 3.349354e-001, 3.349316e-001, 3.349279e-001, 3.349242e-001, 3.349205e-001, 3.349167e-001, 3.349130e-001, 3.349093e-001, 3.349055e-001, 3.349018e-001, 3.348981e-001, 3.348943e-001, 3.348906e-001, 3.348869e-001, 3.348831e-001, 3.348794e-001, 3.348757e-001, 3.348719e-001, 3.348682e-001, 3.348645e-001, 3.348607e-001, 3.348570e-001, 3.348533e-001, 3.348495e-001, 3.348458e-001, 3.348421e-001, 3.348383e-001, 3.348346e-001, 3.348309e-001, 3.348271e-001, 3.348234e-001, 3.348197e-001, 3.348159e-001, 3.348122e-001, 3.348084e-001, 3.348047e-001, 3.348010e-001, 3.347972e-001, 3.347935e-001, 3.347898e-001, 3.347860e-001, 3.347823e-001, 3.347785e-001, 3.347748e-001, 3.347711e-001, 3.347673e-001, 3.347636e-001, 3.347599e-001, 3.347561e-001, 3.347524e-001, 3.347486e-001, 3.347449e-001, 3.347412e-001, 3.347374e-001, 3.347337e-001, 3.347299e-001, 3.347262e-001, 3.347225e-001, 3.347187e-001, 3.347150e-001, 3.347112e-001, 3.347075e-001, 3.347037e-001, 3.347000e-001, 3.346963e-001, 3.346925e-001, 3.346888e-001, 3.346850e-001, 3.346813e-001, 3.346775e-001, 3.346738e-001, 3.346701e-001, 3.346663e-001, 3.346626e-001, 3.346588e-001, 3.346551e-001, 3.346513e-001, 3.346476e-001, 3.346439e-001, 3.346401e-001, 
3.346364e-001, 3.346326e-001, 3.346289e-001, 3.346251e-001, 3.346214e-001, 3.346176e-001, 3.346139e-001, 3.346101e-001, 3.346064e-001, 3.346027e-001, 3.345989e-001, 3.345952e-001, 3.345914e-001, 3.345877e-001, 3.345839e-001, 3.345802e-001, 3.345764e-001, 3.345727e-001, 3.345689e-001, 3.345652e-001, 3.345614e-001, 3.345577e-001, 3.345539e-001, 3.345502e-001, 3.345464e-001, 3.345427e-001, 3.345389e-001, 3.345352e-001, 3.345314e-001, 3.345277e-001, 3.345239e-001, 3.345202e-001, 3.345164e-001, 3.345127e-001, 3.345089e-001, 3.345052e-001, 3.345014e-001, 3.344977e-001, 3.344939e-001, 3.344902e-001, 3.344864e-001, 3.344827e-001, 3.344789e-001, 3.344752e-001, 3.344714e-001, 3.344676e-001, 3.344639e-001, 3.344601e-001, 3.344564e-001, 3.344526e-001, 3.344489e-001, 3.344451e-001, 3.344414e-001, 3.344376e-001, 3.344339e-001, 3.344301e-001, 3.344263e-001, 3.344226e-001, 3.344188e-001, 3.344151e-001, 3.344113e-001, 3.344076e-001, 3.344038e-001, 3.344001e-001, 3.343963e-001, 3.343925e-001, 3.343888e-001, 3.343850e-001, 3.343813e-001, 3.343775e-001, 3.343737e-001, 3.343700e-001, 3.343662e-001, 3.343625e-001, 3.343587e-001, 3.343550e-001, 3.343512e-001, 3.343474e-001, 3.343437e-001, 3.343399e-001, 3.343362e-001, 3.343324e-001, 3.343286e-001, 3.343249e-001, 3.343211e-001, 3.343174e-001, 3.343136e-001, 3.343098e-001, 3.343061e-001, 3.343023e-001, 3.342985e-001, 3.342948e-001, 3.342910e-001, 3.342873e-001, 3.342835e-001, 3.342797e-001, 3.342760e-001, 3.342722e-001, 3.342684e-001, 3.342647e-001, 
3.342609e-001, 3.342572e-001, 3.342534e-001, 3.342496e-001, 3.342459e-001, 3.342421e-001, 3.342383e-001, 3.342346e-001, 3.342308e-001, 3.342270e-001, 3.342233e-001, 3.342195e-001, 3.342157e-001, 3.342120e-001, 3.342082e-001, 3.342044e-001, 3.342007e-001, 3.341969e-001, 3.341931e-001, 3.341894e-001, 3.341856e-001, 3.341818e-001, 3.341781e-001, 3.341743e-001, 3.341705e-001, 3.341668e-001, 3.341630e-001, 3.341592e-001, 3.341555e-001, 3.341517e-001, 3.341479e-001, 3.341442e-001, 3.341404e-001, 3.341366e-001, 3.341328e-001, 3.341291e-001, 3.341253e-001, 3.341215e-001, 3.341178e-001, 3.341140e-001, 3.341102e-001, 3.341064e-001, 3.341027e-001, 3.340989e-001, 3.340951e-001, 3.340914e-001, 3.340876e-001, 3.340838e-001, 3.340800e-001, 3.340763e-001, 3.340725e-001, 3.340687e-001, 3.340650e-001, 3.340612e-001, 3.340574e-001, 3.340536e-001, 3.340499e-001, 3.340461e-001, 3.340423e-001, 3.340385e-001, 3.340348e-001, 3.340310e-001, 3.340272e-001, 3.340234e-001, 3.340197e-001, 3.340159e-001, 3.340121e-001, 3.340083e-001, 3.340046e-001, 3.340008e-001, 3.339970e-001, 3.339932e-001, 3.339894e-001, 3.339857e-001, 3.339819e-001, 3.339781e-001, 3.339743e-001, 3.339706e-001, 3.339668e-001, 3.339630e-001, 3.339592e-001, 3.339554e-001, 3.339517e-001, 3.339479e-001, 3.339441e-001, 3.339403e-001, 3.339365e-001, 3.339328e-001, 3.339290e-001, 3.339252e-001, 3.339214e-001, 3.339176e-001, 3.339139e-001, 3.339101e-001, 3.339063e-001, 3.339025e-001, 3.338987e-001, 3.338950e-001, 3.338912e-001, 3.338874e-001, 
3.338836e-001, 3.338798e-001, 3.338760e-001, 3.338723e-001, 3.338685e-001, 3.338647e-001, 3.338609e-001, 3.338571e-001, 3.338533e-001, 3.338496e-001, 3.338458e-001, 3.338420e-001, 3.338382e-001, 3.338344e-001, 3.338306e-001, 3.338269e-001, 3.338231e-001, 3.338193e-001, 3.338155e-001, 3.338117e-001, 3.338079e-001, 3.338041e-001, 3.338003e-001, 3.337966e-001, 3.337928e-001, 3.337890e-001, 3.337852e-001, 3.337814e-001, 3.337776e-001, 3.337738e-001, 3.337701e-001, 3.337663e-001, 3.337625e-001, 3.337587e-001, 3.337549e-001, 3.337511e-001, 3.337473e-001, 3.337435e-001, 3.337397e-001, 3.337360e-001, 3.337322e-001, 3.337284e-001, 3.337246e-001, 3.337208e-001, 3.337170e-001, 3.337132e-001, 3.337094e-001, 3.337056e-001, 3.337018e-001, 3.336980e-001, 3.336943e-001, 3.336905e-001, 3.336867e-001, 3.336829e-001, 3.336791e-001, 3.336753e-001, 3.336715e-001, 3.336677e-001, 3.336639e-001, 3.336601e-001, 3.336563e-001, 3.336525e-001, 3.336487e-001, 3.336449e-001, 3.336412e-001, 3.336374e-001, 3.336336e-001, 3.336298e-001, 3.336260e-001, 3.336222e-001, 3.336184e-001, 3.336146e-001, 3.336108e-001, 3.336070e-001, 3.336032e-001, 3.335994e-001, 3.335956e-001, 3.335918e-001, 3.335880e-001, 3.335842e-001, 3.335804e-001, 3.335766e-001, 3.335728e-001, 3.335690e-001, 3.335652e-001, 3.335614e-001, 3.335576e-001, 3.335538e-001, 3.335500e-001, 3.335462e-001, 3.335424e-001, 3.335386e-001, 3.335348e-001, 3.335310e-001, 3.335272e-001, 3.335234e-001, 3.335196e-001, 3.335158e-001, 3.335120e-001, 3.335082e-001, 
3.335044e-001, 3.335006e-001, 3.334968e-001, 3.334930e-001, 3.334892e-001, 3.334854e-001, 3.334816e-001, 3.334778e-001, 3.334740e-001, 3.334702e-001, 3.334664e-001, 3.334626e-001, 3.334588e-001, 3.334550e-001, 3.334512e-001, 3.334474e-001, 3.334436e-001, 3.334398e-001, 3.334360e-001, 3.334322e-001, 3.334284e-001, 3.334246e-001, 3.334208e-001, 3.334170e-001, 3.334132e-001, 3.334094e-001, 3.334055e-001, 3.334017e-001, 3.333979e-001, 3.333941e-001, 3.333903e-001, 3.333865e-001, 3.333827e-001, 3.333789e-001, 3.333751e-001, 3.333713e-001, 3.333675e-001, 3.333637e-001, 3.333599e-001, 3.333561e-001, 3.333522e-001, 3.333484e-001, 3.333446e-001, 3.333408e-001, 3.333370e-001, 3.333332e-001, 3.333294e-001, 3.333256e-001, 3.333218e-001, 3.333180e-001, 3.333142e-001, 3.333103e-001, 3.333065e-001, 3.333027e-001, 3.332989e-001, 3.332951e-001, 3.332913e-001, 3.332875e-001, 3.332837e-001, 3.332799e-001, 3.332760e-001, 3.332722e-001, 3.332684e-001, 3.332646e-001, 3.332608e-001, 3.332570e-001, 3.332532e-001, 3.332493e-001, 3.332455e-001, 3.332417e-001, 3.332379e-001, 3.332341e-001, 3.332303e-001, 3.332265e-001, 3.332226e-001, 3.332188e-001, 3.332150e-001, 3.332112e-001, 3.332074e-001, 3.332036e-001, 3.331998e-001, 3.331959e-001, 3.331921e-001, 3.331883e-001, 3.331845e-001, 3.331807e-001, 3.331769e-001, 3.331730e-001, 3.331692e-001, 3.331654e-001, 3.331616e-001, 3.331578e-001, 3.331540e-001, 3.331501e-001, 3.331463e-001, 3.331425e-001, 3.331387e-001, 3.331349e-001, 3.331310e-001, 3.331272e-001, 
3.331234e-001, 3.331196e-001, 3.331158e-001, 3.331119e-001, 3.331081e-001, 3.331043e-001, 3.331005e-001, 3.330967e-001, 3.330928e-001, 3.330890e-001, 3.330852e-001, 3.330814e-001, 3.330776e-001, 3.330737e-001, 3.330699e-001, 3.330661e-001, 3.330623e-001, 3.330584e-001, 3.330546e-001, 3.330508e-001, 3.330470e-001, 3.330432e-001, 3.330393e-001, 3.330355e-001, 3.330317e-001, 3.330279e-001, 3.330240e-001, 3.330202e-001, 3.330164e-001, 3.330126e-001, 3.330087e-001, 3.330049e-001, 3.330011e-001, 3.329973e-001, 3.329934e-001, 3.329896e-001, 3.329858e-001, 3.329820e-001, 3.329781e-001, 3.329743e-001, 3.329705e-001, 3.329666e-001, 3.329628e-001, 3.329590e-001, 3.329552e-001, 3.329513e-001, 3.329475e-001, 3.329437e-001, 3.329398e-001, 3.329360e-001, 3.329322e-001, 3.329284e-001, 3.329245e-001, 3.329207e-001, 3.329169e-001, 3.329130e-001, 3.329092e-001, 3.329054e-001, 3.329016e-001, 3.328977e-001, 3.328939e-001, 3.328901e-001, 3.328862e-001, 3.328824e-001, 3.328786e-001, 3.328747e-001, 3.328709e-001, 3.328671e-001, 3.328632e-001, 3.328594e-001, 3.328556e-001, 3.328517e-001, 3.328479e-001, 3.328441e-001, 3.328402e-001, 3.328364e-001, 3.328326e-001, 3.328287e-001, 3.328249e-001, 3.328211e-001, 3.328172e-001, 3.328134e-001, 3.328096e-001, 3.328057e-001, 3.328019e-001, 3.327981e-001, 3.327942e-001, 3.327904e-001, 3.327866e-001, 3.327827e-001, 3.327789e-001, 3.327751e-001, 3.327712e-001, 3.327674e-001, 3.327635e-001, 3.327597e-001, 3.327559e-001, 3.327520e-001, 3.327482e-001, 3.327444e-001, 
3.327405e-001, 3.327367e-001, 3.327328e-001, 3.327290e-001, 3.327252e-001, 3.327213e-001, 3.327175e-001, 3.327136e-001, 3.327098e-001, 3.327060e-001, 3.327021e-001, 3.326983e-001, 3.326944e-001, 3.326906e-001, 3.326868e-001, 3.326829e-001, 3.326791e-001, 3.326752e-001, 3.326714e-001, 3.326676e-001, 3.326637e-001, 3.326599e-001, 3.326560e-001, 3.326522e-001, 3.326483e-001, 3.326445e-001, 3.326407e-001, 3.326368e-001, 3.326330e-001, 3.326291e-001, 3.326253e-001, 3.326214e-001, 3.326176e-001, 3.326138e-001, 3.326099e-001, 3.326061e-001, 3.326022e-001, 3.325984e-001, 3.325945e-001, 3.325907e-001, 3.325868e-001, 3.325830e-001, 3.325792e-001, 3.325753e-001, 3.325715e-001, 3.325676e-001, 3.325638e-001, 3.325599e-001, 3.325561e-001, 3.325522e-001, 3.325484e-001, 3.325445e-001, 3.325407e-001, 3.325368e-001, 3.325330e-001, 3.325291e-001, 3.325253e-001, 3.325214e-001, 3.325176e-001, 3.325137e-001, 3.325099e-001, 3.325060e-001, 3.325022e-001, 3.324983e-001, 3.324945e-001, 3.324906e-001, 3.324868e-001, 3.324829e-001, 3.324791e-001, 3.324752e-001, 3.324714e-001, 3.324675e-001, 3.324637e-001, 3.324598e-001, 3.324560e-001, 3.324521e-001, 3.324483e-001, 3.324444e-001, 3.324406e-001, 3.324367e-001, 3.324329e-001, 3.324290e-001, 3.324252e-001, 3.324213e-001, 3.324175e-001, 3.324136e-001, 3.324098e-001, 3.324059e-001, 3.324020e-001, 3.323982e-001, 3.323943e-001, 3.323905e-001, 3.323866e-001, 3.323828e-001, 3.323789e-001, 3.323751e-001, 3.323712e-001, 3.323673e-001, 3.323635e-001, 3.323596e-001, 
3.323558e-001, 3.323519e-001, 3.323481e-001, 3.323442e-001, 3.323403e-001, 3.323365e-001, 3.323326e-001, 3.323288e-001, 3.323249e-001, 3.323211e-001, 3.323172e-001, 3.323133e-001, 3.323095e-001, 3.323056e-001, 3.323018e-001, 3.322979e-001, 3.322940e-001, 3.322902e-001, 3.322863e-001, 3.322825e-001, 3.322786e-001, 3.322747e-001, 3.322709e-001, 3.322670e-001, 3.322632e-001, 3.322593e-001, 3.322554e-001, 3.322516e-001, 3.322477e-001, 3.322439e-001, 3.322400e-001, 3.322361e-001, 3.322323e-001, 3.322284e-001, 3.322245e-001, 3.322207e-001, 3.322168e-001, 3.322130e-001, 3.322091e-001, 3.322052e-001, 3.322014e-001, 3.321975e-001, 3.321936e-001, 3.321898e-001, 3.321859e-001, 3.321820e-001, 3.321782e-001, 3.321743e-001, 3.321704e-001, 3.321666e-001, 3.321627e-001, 3.321588e-001, 3.321550e-001, 3.321511e-001, 3.321472e-001, 3.321434e-001, 3.321395e-001, 3.321356e-001, 3.321318e-001, 3.321279e-001, 3.321240e-001, 3.321202e-001, 3.321163e-001, 3.321124e-001, 3.321086e-001, 3.321047e-001, 3.321008e-001, 3.320970e-001, 3.320931e-001, 3.320892e-001, 3.320854e-001, 3.320815e-001, 3.320776e-001, 3.320737e-001, 3.320699e-001, 3.320660e-001, 3.320621e-001, 3.320583e-001, 3.320544e-001, 3.320505e-001, 3.320467e-001, 3.320428e-001, 3.320389e-001, 3.320350e-001, 3.320312e-001, 3.320273e-001, 3.320234e-001, 3.320195e-001, 3.320157e-001, 3.320118e-001, 3.320079e-001, 3.320041e-001, 3.320002e-001, 3.319963e-001, 3.319924e-001, 3.319886e-001, 3.319847e-001, 3.319808e-001, 3.319769e-001, 3.319731e-001, 
3.319692e-001, 3.319653e-001, 3.319614e-001, 3.319576e-001, 3.319537e-001, 3.319498e-001, 3.319459e-001, 3.319421e-001, 3.319382e-001, 3.319343e-001, 3.319304e-001, 3.319266e-001, 3.319227e-001, 3.319188e-001, 3.319149e-001, 3.319110e-001, 3.319072e-001, 3.319033e-001, 3.318994e-001, 3.318955e-001, 3.318916e-001, 3.318878e-001, 3.318839e-001, 3.318800e-001, 3.318761e-001, 3.318723e-001, 3.318684e-001, 3.318645e-001, 3.318606e-001, 3.318567e-001, 3.318529e-001, 3.318490e-001, 3.318451e-001, 3.318412e-001, 3.318373e-001, 3.318334e-001, 3.318296e-001, 3.318257e-001, 3.318218e-001, 3.318179e-001, 3.318140e-001, 3.318102e-001, 3.318063e-001, 3.318024e-001, 3.317985e-001, 3.317946e-001, 3.317907e-001, 3.317869e-001, 3.317830e-001, 3.317791e-001, 3.317752e-001, 3.317713e-001, 3.317674e-001, 3.317635e-001, 3.317597e-001, 3.317558e-001, 3.317519e-001, 3.317480e-001, 3.317441e-001, 3.317402e-001, 3.317364e-001, 3.317325e-001, 3.317286e-001, 3.317247e-001, 3.317208e-001, 3.317169e-001, 3.317130e-001, 3.317091e-001, 3.317053e-001, 3.317014e-001, 3.316975e-001, 3.316936e-001, 3.316897e-001, 3.316858e-001, 3.316819e-001, 3.316780e-001, 3.316741e-001, 3.316703e-001, 3.316664e-001, 3.316625e-001, 3.316586e-001, 3.316547e-001, 3.316508e-001, 3.316469e-001, 3.316430e-001, 3.316391e-001, 3.316352e-001, 3.316314e-001, 3.316275e-001, 3.316236e-001, 3.316197e-001, 3.316158e-001, 3.316119e-001, 3.316080e-001, 3.316041e-001, 3.316002e-001, 3.315963e-001, 3.315924e-001, 3.315885e-001, 3.315846e-001, 
3.315808e-001, 3.315769e-001, 3.315730e-001, 3.315691e-001, 3.315652e-001, 3.315613e-001, 3.315574e-001, 3.315535e-001, 3.315496e-001, 3.315457e-001, 3.315418e-001, 3.315379e-001, 3.315340e-001, 3.315301e-001, 3.315262e-001, 3.315223e-001, 3.315184e-001, 3.315145e-001, 3.315106e-001, 3.315067e-001, 3.315028e-001, 3.314990e-001, 3.314951e-001, 3.314912e-001, 3.314873e-001, 3.314834e-001, 3.314795e-001, 3.314756e-001, 3.314717e-001, 3.314678e-001, 3.314639e-001, 3.314600e-001, 3.314561e-001, 3.314522e-001, 3.314483e-001, 3.314444e-001, 3.314405e-001, 3.314366e-001, 3.314327e-001, 3.314288e-001, 3.314249e-001, 3.314210e-001, 3.314171e-001, 3.314132e-001, 3.314093e-001, 3.314054e-001, 3.314015e-001, 3.313976e-001, 3.313937e-001, 3.313898e-001, 3.313858e-001, 3.313819e-001, 3.313780e-001, 3.313741e-001, 3.313702e-001, 3.313663e-001, 3.313624e-001, 3.313585e-001, 3.313546e-001, 3.313507e-001, 3.313468e-001, 3.313429e-001, 3.313390e-001, 3.313351e-001, 3.313312e-001, 3.313273e-001, 3.313234e-001, 3.313195e-001, 3.313156e-001, 3.313117e-001, 3.313078e-001, 3.313039e-001, 3.312999e-001, 3.312960e-001, 3.312921e-001, 3.312882e-001, 3.312843e-001, 3.312804e-001, 3.312765e-001, 3.312726e-001, 3.312687e-001, 3.312648e-001, 3.312609e-001, 3.312570e-001, 3.312530e-001, 3.312491e-001, 3.312452e-001, 3.312413e-001, 3.312374e-001, 3.312335e-001, 3.312296e-001, 3.312257e-001, 3.312218e-001, 3.312179e-001, 3.312139e-001, 3.312100e-001, 3.312061e-001, 3.312022e-001, 3.311983e-001, 3.311944e-001, 
3.311905e-001, 3.311866e-001, 3.311827e-001, 3.311787e-001, 3.311748e-001, 3.311709e-001, 3.311670e-001, 3.311631e-001, 3.311592e-001, 3.311553e-001, 3.311514e-001, 3.311474e-001, 3.311435e-001, 3.311396e-001, 3.311357e-001, 3.311318e-001, 3.311279e-001, 3.311240e-001, 3.311200e-001, 3.311161e-001, 3.311122e-001, 3.311083e-001, 3.311044e-001, 3.311005e-001, 3.310965e-001, 3.310926e-001, 3.310887e-001, 3.310848e-001, 3.310809e-001, 3.310770e-001, 3.310730e-001, 3.310691e-001, 3.310652e-001, 3.310613e-001, 3.310574e-001, 3.310535e-001, 3.310495e-001, 3.310456e-001, 3.310417e-001, 3.310378e-001, 3.310339e-001, 3.310299e-001, 3.310260e-001, 3.310221e-001, 3.310182e-001, 3.310143e-001, 3.310103e-001, 3.310064e-001, 3.310025e-001, 3.309986e-001, 3.309947e-001, 3.309907e-001, 3.309868e-001, 3.309829e-001, 3.309790e-001, 3.309750e-001, 3.309711e-001, 3.309672e-001, 3.309633e-001, 3.309594e-001, 3.309554e-001, 3.309515e-001, 3.309476e-001, 3.309437e-001, 3.309397e-001, 3.309358e-001, 3.309319e-001, 3.309280e-001, 3.309240e-001, 3.309201e-001, 3.309162e-001, 3.309123e-001, 3.309083e-001, 3.309044e-001, 3.309005e-001, 3.308966e-001, 3.308926e-001, 3.308887e-001, 3.308848e-001, 3.308809e-001, 3.308769e-001, 3.308730e-001, 3.308691e-001, 3.308652e-001, 3.308612e-001, 3.308573e-001, 3.308534e-001, 3.308494e-001, 3.308455e-001, 3.308416e-001, 3.308377e-001, 3.308337e-001, 3.308298e-001, 3.308259e-001, 3.308219e-001, 3.308180e-001, 3.308141e-001, 3.308102e-001, 3.308062e-001, 3.308023e-001, 
3.307984e-001, 3.307944e-001, 3.307905e-001, 3.307866e-001, 3.307826e-001, 3.307787e-001, 3.307748e-001, 3.307709e-001, 3.307669e-001, 3.307630e-001, 3.307591e-001, 3.307551e-001, 3.307512e-001, 3.307473e-001, 3.307433e-001, 3.307394e-001, 3.307355e-001, 3.307315e-001, 3.307276e-001, 3.307237e-001, 3.307197e-001, 3.307158e-001, 3.307119e-001, 3.307079e-001, 3.307040e-001, 3.307001e-001, 3.306961e-001, 3.306922e-001, 3.306882e-001, 3.306843e-001, 3.306804e-001, 3.306764e-001, 3.306725e-001, 3.306686e-001, 3.306646e-001, 3.306607e-001, 3.306568e-001, 3.306528e-001, 3.306489e-001, 3.306449e-001, 3.306410e-001, 3.306371e-001, 3.306331e-001, 3.306292e-001, 3.306253e-001, 3.306213e-001, 3.306174e-001, 3.306134e-001, 3.306095e-001, 3.306056e-001, 3.306016e-001, 3.305977e-001, 3.305937e-001, 3.305898e-001, 3.305859e-001, 3.305819e-001, 3.305780e-001, 3.305740e-001, 3.305701e-001, 3.305662e-001, 3.305622e-001, 3.305583e-001, 3.305543e-001, 3.305504e-001, 3.305465e-001, 3.305425e-001, 3.305386e-001, 3.305346e-001, 3.305307e-001, 3.305267e-001, 3.305228e-001, 3.305189e-001, 3.305149e-001, 3.305110e-001, 3.305070e-001, 3.305031e-001, 3.304991e-001, 3.304952e-001, 3.304912e-001, 3.304873e-001, 3.304834e-001, 3.304794e-001, 3.304755e-001, 3.304715e-001, 3.304676e-001, 3.304636e-001, 3.304597e-001, 3.304557e-001, 3.304518e-001, 3.304478e-001, 3.304439e-001, 3.304400e-001, 3.304360e-001, 3.304321e-001, 3.304281e-001, 3.304242e-001, 3.304202e-001, 3.304163e-001, 3.304123e-001, 3.304084e-001, 
3.304044e-001, 3.304005e-001, 3.303965e-001, 3.303926e-001, 3.303886e-001, 3.303847e-001, 3.303807e-001, 3.303768e-001, 3.303728e-001, 3.303689e-001, 3.303649e-001, 3.303610e-001, 3.303570e-001, 3.303531e-001, 3.303491e-001, 3.303452e-001, 3.303412e-001, 3.303373e-001, 3.303333e-001, 3.303294e-001, 3.303254e-001, 3.303215e-001, 3.303175e-001, 3.303136e-001, 3.303096e-001, 3.303056e-001, 3.303017e-001, 3.302977e-001, 3.302938e-001, 3.302898e-001, 3.302859e-001, 3.302819e-001, 3.302780e-001, 3.302740e-001, 3.302701e-001, 3.302661e-001, 3.302622e-001, 3.302582e-001, 3.302542e-001, 3.302503e-001, 3.302463e-001, 3.302424e-001, 3.302384e-001, 3.302345e-001, 3.302305e-001, 3.302265e-001, 3.302226e-001, 3.302186e-001, 3.302147e-001, 3.302107e-001, 3.302068e-001, 3.302028e-001, 3.301988e-001, 3.301949e-001, 3.301909e-001, 3.301870e-001, 3.301830e-001, 3.301791e-001, 3.301751e-001, 3.301711e-001, 3.301672e-001, 3.301632e-001, 3.301593e-001, 3.301553e-001, 3.301513e-001, 3.301474e-001, 3.301434e-001, 3.301395e-001, 3.301355e-001, 3.301315e-001, 3.301276e-001, 3.301236e-001, 3.301196e-001, 3.301157e-001, 3.301117e-001, 3.301078e-001, 3.301038e-001, 3.300998e-001, 3.300959e-001, 3.300919e-001, 3.300879e-001, 3.300840e-001, 3.300800e-001, 3.300761e-001, 3.300721e-001, 3.300681e-001, 3.300642e-001, 3.300602e-001, 3.300562e-001, 3.300523e-001, 3.300483e-001, 3.300443e-001, 3.300404e-001, 3.300364e-001, 3.300324e-001, 3.300285e-001, 3.300245e-001, 3.300205e-001, 3.300166e-001, 3.300126e-001, 
3.300086e-001, 3.300047e-001, 3.300007e-001, 3.299967e-001, 3.299928e-001, 3.299888e-001, 3.299848e-001, 3.299809e-001, 3.299769e-001, 3.299729e-001, 3.299690e-001, 3.299650e-001, 3.299610e-001, 3.299571e-001, 3.299531e-001, 3.299491e-001, 3.299451e-001, 3.299412e-001, 3.299372e-001, 3.299332e-001, 3.299293e-001, 3.299253e-001, 3.299213e-001, 3.299174e-001, 3.299134e-001, 3.299094e-001, 3.299054e-001, 3.299015e-001, 3.298975e-001, 3.298935e-001, 3.298896e-001, 3.298856e-001, 3.298816e-001, 3.298776e-001, 3.298737e-001, 3.298697e-001, 3.298657e-001, 3.298617e-001, 3.298578e-001, 3.298538e-001, 3.298498e-001, 3.298458e-001, 3.298419e-001, 3.298379e-001, 3.298339e-001, 3.298299e-001, 3.298260e-001, 3.298220e-001, 3.298180e-001, 3.298140e-001, 3.298101e-001, 3.298061e-001, 3.298021e-001, 3.297981e-001, 3.297942e-001, 3.297902e-001, 3.297862e-001, 3.297822e-001, 3.297783e-001, 3.297743e-001, 3.297703e-001, 3.297663e-001, 3.297623e-001, 3.297584e-001, 3.297544e-001, 3.297504e-001, 3.297464e-001, 3.297424e-001, 3.297385e-001, 3.297345e-001, 3.297305e-001, 3.297265e-001, 3.297225e-001, 3.297186e-001, 3.297146e-001, 3.297106e-001, 3.297066e-001, 3.297026e-001, 3.296987e-001, 3.296947e-001, 3.296907e-001, 3.296867e-001, 3.296827e-001, 3.296788e-001, 3.296748e-001, 3.296708e-001, 3.296668e-001, 3.296628e-001, 3.296588e-001, 3.296549e-001, 3.296509e-001, 3.296469e-001, 3.296429e-001, 3.296389e-001, 3.296349e-001, 3.296310e-001, 3.296270e-001, 3.296230e-001, 3.296190e-001, 3.296150e-001, 
3.296110e-001, 3.296071e-001, 3.296031e-001, 3.295991e-001, 3.295951e-001, 3.295911e-001, 3.295871e-001, 3.295831e-001, 3.295791e-001, 3.295752e-001, 3.295712e-001, 3.295672e-001, 3.295632e-001, 3.295592e-001, 3.295552e-001, 3.295512e-001, 3.295472e-001, 3.295433e-001, 3.295393e-001, 3.295353e-001, 3.295313e-001, 3.295273e-001, 3.295233e-001, 3.295193e-001, 3.295153e-001, 3.295113e-001, 3.295074e-001, 3.295034e-001, 3.294994e-001, 3.294954e-001, 3.294914e-001, 3.294874e-001, 3.294834e-001, 3.294794e-001, 3.294754e-001, 3.294714e-001, 3.294675e-001, 3.294635e-001, 3.294595e-001, 3.294555e-001, 3.294515e-001, 3.294475e-001, 3.294435e-001, 3.294395e-001, 3.294355e-001, 3.294315e-001, 3.294275e-001, 3.294235e-001, 3.294195e-001, 3.294155e-001, 3.294115e-001, 3.294076e-001, 3.294036e-001, 3.293996e-001, 3.293956e-001, 3.293916e-001, 3.293876e-001, 3.293836e-001, 3.293796e-001, 3.293756e-001, 3.293716e-001, 3.293676e-001, 3.293636e-001, 3.293596e-001, 3.293556e-001, 3.293516e-001, 3.293476e-001, 3.293436e-001, 3.293396e-001, 3.293356e-001, 3.293316e-001, 3.293276e-001, 3.293236e-001, 3.293196e-001, 3.293156e-001, 3.293116e-001, 3.293076e-001, 3.293036e-001, 3.292996e-001, 3.292956e-001, 3.292916e-001, 3.292876e-001, 3.292836e-001, 3.292796e-001, 3.292756e-001, 3.292716e-001, 3.292676e-001, 3.292636e-001, 3.292596e-001, 3.292556e-001, 3.292516e-001, 3.292476e-001, 3.292436e-001, 3.292396e-001, 3.292356e-001, 3.292316e-001, 3.292276e-001, 3.292236e-001, 3.292196e-001, 3.292156e-001, 
3.292116e-001, 3.292076e-001, 3.292036e-001, 3.291996e-001, 3.291956e-001, 3.291916e-001, 3.291876e-001, 3.291836e-001, 3.291796e-001, 3.291756e-001, 3.291716e-001, 3.291676e-001, 3.291635e-001, 3.291595e-001, 3.291555e-001, 3.291515e-001, 3.291475e-001, 3.291435e-001, 3.291395e-001, 3.291355e-001, 3.291315e-001, 3.291275e-001, 3.291235e-001, 3.291195e-001, 3.291155e-001, 3.291115e-001, 3.291075e-001, 3.291034e-001, 3.290994e-001, 3.290954e-001, 3.290914e-001, 3.290874e-001, 3.290834e-001, 3.290794e-001, 3.290754e-001, 3.290714e-001, 3.290674e-001, 3.290634e-001, 3.290593e-001, 3.290553e-001, 3.290513e-001, 3.290473e-001, 3.290433e-001, 3.290393e-001, 3.290353e-001, 3.290313e-001, 3.290273e-001, 3.290232e-001, 3.290192e-001, 3.290152e-001, 3.290112e-001, 3.290072e-001, 3.290032e-001, 3.289992e-001, 3.289952e-001, 3.289911e-001, 3.289871e-001, 3.289831e-001, 3.289791e-001, 3.289751e-001, 3.289711e-001, 3.289671e-001, 3.289630e-001, 3.289590e-001, 3.289550e-001, 3.289510e-001, 3.289470e-001, 3.289430e-001, 3.289389e-001, 3.289349e-001, 3.289309e-001, 3.289269e-001, 3.289229e-001, 3.289189e-001, 3.289149e-001, 3.289108e-001, 3.289068e-001, 3.289028e-001, 3.288988e-001, 3.288948e-001, 3.288907e-001, 3.288867e-001, 3.288827e-001, 3.288787e-001, 3.288747e-001, 3.288707e-001, 3.288666e-001, 3.288626e-001, 3.288586e-001, 3.288546e-001, 3.288506e-001, 3.288465e-001, 3.288425e-001, 3.288385e-001, 3.288345e-001, 3.288305e-001, 3.288264e-001, 3.288224e-001, 3.288184e-001, 3.288144e-001, 
3.288104e-001, 3.288063e-001, 3.288023e-001, 3.287983e-001, 3.287943e-001, 3.287902e-001, 3.287862e-001, 3.287822e-001, 3.287782e-001, 3.287741e-001, 3.287701e-001, 3.287661e-001, 3.287621e-001, 3.287581e-001, 3.287540e-001, 3.287500e-001, 3.287460e-001, 3.287420e-001, 3.287379e-001, 3.287339e-001, 3.287299e-001, 3.287259e-001, 3.287218e-001, 3.287178e-001, 3.287138e-001, 3.287098e-001, 3.287057e-001, 3.287017e-001, 3.286977e-001, 3.286936e-001, 3.286896e-001, 3.286856e-001, 3.286816e-001, 3.286775e-001, 3.286735e-001, 3.286695e-001, 3.286655e-001, 3.286614e-001, 3.286574e-001, 3.286534e-001, 3.286493e-001, 3.286453e-001, 3.286413e-001, 3.286373e-001, 3.286332e-001, 3.286292e-001, 3.286252e-001, 3.286211e-001, 3.286171e-001, 3.286131e-001, 3.286090e-001, 3.286050e-001, 3.286010e-001, 3.285969e-001, 3.285929e-001, 3.285889e-001, 3.285849e-001, 3.285808e-001, 3.285768e-001, 3.285728e-001, 3.285687e-001, 3.285647e-001, 3.285607e-001, 3.285566e-001, 3.285526e-001, 3.285486e-001, 3.285445e-001, 3.285405e-001, 3.285365e-001, 3.285324e-001, 3.285284e-001, 3.285244e-001, 3.285203e-001, 3.285163e-001, 3.285123e-001, 3.285082e-001, 3.285042e-001, 3.285001e-001, 3.284961e-001, 3.284921e-001, 3.284880e-001, 3.284840e-001, 3.284800e-001, 3.284759e-001, 3.284719e-001, 3.284679e-001, 3.284638e-001, 3.284598e-001, 3.284557e-001, 3.284517e-001, 3.284477e-001, 3.284436e-001, 3.284396e-001, 3.284356e-001, 3.284315e-001, 3.284275e-001, 3.284234e-001, 3.284194e-001, 3.284154e-001, 3.284113e-001, 
3.284073e-001, 3.284032e-001, 3.283992e-001, 3.283952e-001, 3.283911e-001, 3.283871e-001, 3.283830e-001, 3.283790e-001, 3.283750e-001, 3.283709e-001, 3.283669e-001, 3.283628e-001, 3.283588e-001, 3.283547e-001, 3.283507e-001, 3.283467e-001, 3.283426e-001, 3.283386e-001, 3.283345e-001, 3.283305e-001, 3.283264e-001, 3.283224e-001, 3.283184e-001, 3.283143e-001, 3.283103e-001, 3.283062e-001, 3.283022e-001, 3.282981e-001, 3.282941e-001, 3.282900e-001, 3.282860e-001, 3.282820e-001, 3.282779e-001, 3.282739e-001, 3.282698e-001, 3.282658e-001, 3.282617e-001, 3.282577e-001, 3.282536e-001, 3.282496e-001, 3.282455e-001, 3.282415e-001, 3.282374e-001, 3.282334e-001, 3.282294e-001, 3.282253e-001, 3.282213e-001, 3.282172e-001, 3.282132e-001, 3.282091e-001, 3.282051e-001, 3.282010e-001, 3.281970e-001, 3.281929e-001, 3.281889e-001, 3.281848e-001, 3.281808e-001, 3.281767e-001, 3.281727e-001, 3.281686e-001, 3.281646e-001, 3.281605e-001, 3.281565e-001, 3.281524e-001, 3.281484e-001, 3.281443e-001, 3.281403e-001, 3.281362e-001, 3.281322e-001, 3.281281e-001, 3.281240e-001, 3.281200e-001, 3.281159e-001, 3.281119e-001, 3.281078e-001, 3.281038e-001, 3.280997e-001, 3.280957e-001, 3.280916e-001, 3.280876e-001, 3.280835e-001, 3.280795e-001, 3.280754e-001, 3.280714e-001, 3.280673e-001, 3.280632e-001, 3.280592e-001, 3.280551e-001, 3.280511e-001, 3.280470e-001, 3.280430e-001, 3.280389e-001, 3.280349e-001, 3.280308e-001, 3.280267e-001, 3.280227e-001, 3.280186e-001, 3.280146e-001, 3.280105e-001, 3.280065e-001, 
3.280024e-001, 3.279983e-001, 3.279943e-001, 3.279902e-001, 3.279862e-001, 3.279821e-001, 3.279780e-001, 3.279740e-001, 3.279699e-001, 3.279659e-001, 3.279618e-001, 3.279577e-001, 3.279537e-001, 3.279496e-001, 3.279456e-001, 3.279415e-001, 3.279374e-001, 3.279334e-001, 3.279293e-001, 3.279253e-001, 3.279212e-001, 3.279171e-001, 3.279131e-001, 3.279090e-001, 3.279050e-001, 3.279009e-001, 3.278968e-001, 3.278928e-001, 3.278887e-001, 3.278846e-001, 3.278806e-001, 3.278765e-001, 3.278724e-001, 3.278684e-001, 3.278643e-001, 3.278603e-001, 3.278562e-001, 3.278521e-001, 3.278481e-001, 3.278440e-001, 3.278399e-001, 3.278359e-001, 3.278318e-001, 3.278277e-001, 3.278237e-001, 3.278196e-001, 3.278155e-001, 3.278115e-001, 3.278074e-001, 3.278033e-001, 3.277993e-001, 3.277952e-001, 3.277911e-001, 3.277871e-001, 3.277830e-001, 3.277789e-001, 3.277749e-001, 3.277708e-001, 3.277667e-001, 3.277627e-001, 3.277586e-001, 3.277545e-001, 3.277505e-001, 3.277464e-001, 3.277423e-001, 3.277382e-001, 3.277342e-001, 3.277301e-001, 3.277260e-001, 3.277220e-001, 3.277179e-001, 3.277138e-001, 3.277098e-001, 3.277057e-001, 3.277016e-001, 3.276975e-001, 3.276935e-001, 3.276894e-001, 3.276853e-001, 3.276813e-001, 3.276772e-001, 3.276731e-001, 3.276690e-001, 3.276650e-001, 3.276609e-001, 3.276568e-001, 3.276527e-001, 3.276487e-001, 3.276446e-001, 3.276405e-001, 3.276364e-001, 3.276324e-001, 3.276283e-001, 3.276242e-001, 3.276201e-001, 3.276161e-001, 3.276120e-001, 3.276079e-001, 3.276038e-001, 3.275998e-001, 
3.275957e-001, 3.275916e-001, 3.275875e-001, 3.275835e-001, 3.275794e-001, 3.275753e-001, 3.275712e-001, 3.275672e-001, 3.275631e-001, 3.275590e-001, 3.275549e-001, 3.275508e-001, 3.275468e-001, 3.275427e-001, 3.275386e-001, 3.275345e-001, 3.275305e-001, 3.275264e-001, 3.275223e-001, 3.275182e-001, 3.275141e-001, 3.275101e-001, 3.275060e-001, 3.275019e-001, 3.274978e-001, 3.274937e-001, 3.274897e-001, 3.274856e-001, 3.274815e-001, 3.274774e-001, 3.274733e-001, 3.274693e-001, 3.274652e-001, 3.274611e-001, 3.274570e-001, 3.274529e-001, 3.274488e-001, 3.274448e-001, 3.274407e-001, 3.274366e-001, 3.274325e-001, 3.274284e-001, 3.274243e-001, 3.274203e-001, 3.274162e-001, 3.274121e-001, 3.274080e-001, 3.274039e-001, 3.273998e-001, 3.273958e-001, 3.273917e-001, 3.273876e-001, 3.273835e-001, 3.273794e-001, 3.273753e-001, 3.273712e-001, 3.273672e-001, 3.273631e-001, 3.273590e-001, 3.273549e-001, 3.273508e-001, 3.273467e-001, 3.273426e-001, 3.273385e-001, 3.273345e-001, 3.273304e-001, 3.273263e-001, 3.273222e-001, 3.273181e-001, 3.273140e-001, 3.273099e-001, 3.273058e-001, 3.273018e-001, 3.272977e-001, 3.272936e-001, 3.272895e-001, 3.272854e-001, 3.272813e-001, 3.272772e-001, 3.272731e-001, 3.272690e-001, 3.272649e-001, 3.272609e-001, 3.272568e-001, 3.272527e-001, 3.272486e-001, 3.272445e-001, 3.272404e-001, 3.272363e-001, 3.272322e-001, 3.272281e-001, 3.272240e-001, 3.272199e-001, 3.272158e-001, 3.272117e-001, 3.272077e-001, 3.272036e-001, 3.271995e-001, 3.271954e-001, 3.271913e-001, 
3.271872e-001, 3.271831e-001, 3.271790e-001, 3.271749e-001, 3.271708e-001, 3.271667e-001, 3.271626e-001, 3.271585e-001, 3.271544e-001, 3.271503e-001, 3.271462e-001, 3.271421e-001, 3.271380e-001, 3.271339e-001, 3.271299e-001, 3.271258e-001, 3.271217e-001, 3.271176e-001, 3.271135e-001, 3.271094e-001, 3.271053e-001, 3.271012e-001, 3.270971e-001, 3.270930e-001, 3.270889e-001, 3.270848e-001, 3.270807e-001, 3.270766e-001, 3.270725e-001, 3.270684e-001, 3.270643e-001, 3.270602e-001, 3.270561e-001, 3.270520e-001, 3.270479e-001, 3.270438e-001, 3.270397e-001, 3.270356e-001, 3.270315e-001, 3.270274e-001, 3.270233e-001, 3.270192e-001, 3.270151e-001, 3.270110e-001, 3.270069e-001, 3.270028e-001, 3.269987e-001, 3.269946e-001, 3.269905e-001, 3.269864e-001, 3.269823e-001, 3.269782e-001, 3.269741e-001, 3.269699e-001, 3.269658e-001, 3.269617e-001, 3.269576e-001, 3.269535e-001, 3.269494e-001, 3.269453e-001, 3.269412e-001, 3.269371e-001, 3.269330e-001, 3.269289e-001, 3.269248e-001, 3.269207e-001, 3.269166e-001, 3.269125e-001, 3.269084e-001, 3.269043e-001, 3.269002e-001, 3.268961e-001, 3.268919e-001, 3.268878e-001, 3.268837e-001, 3.268796e-001, 3.268755e-001, 3.268714e-001, 3.268673e-001, 3.268632e-001, 3.268591e-001, 3.268550e-001, 3.268509e-001, 3.268468e-001, 3.268426e-001, 3.268385e-001, 3.268344e-001, 3.268303e-001, 3.268262e-001, 3.268221e-001, 3.268180e-001, 3.268139e-001, 3.268098e-001, 3.268057e-001, 3.268015e-001, 3.267974e-001, 3.267933e-001, 3.267892e-001, 3.267851e-001, 3.267810e-001, 
3.267769e-001, 3.267728e-001, 3.267687e-001, 3.267645e-001, 3.267604e-001, 3.267563e-001, 3.267522e-001, 3.267481e-001, 3.267440e-001, 3.267399e-001, 3.267357e-001, 3.267316e-001, 3.267275e-001, 3.267234e-001, 3.267193e-001, 3.267152e-001, 3.267111e-001, 3.267069e-001, 3.267028e-001, 3.266987e-001, 3.266946e-001, 3.266905e-001, 3.266864e-001, 3.266823e-001, 3.266781e-001, 3.266740e-001, 3.266699e-001, 3.266658e-001, 3.266617e-001, 3.266575e-001, 3.266534e-001, 3.266493e-001, 3.266452e-001, 3.266411e-001, 3.266370e-001, 3.266328e-001, 3.266287e-001, 3.266246e-001, 3.266205e-001, 3.266164e-001, 3.266122e-001, 3.266081e-001, 3.266040e-001, 3.265999e-001, 3.265958e-001, 3.265916e-001, 3.265875e-001, 3.265834e-001, 3.265793e-001, 3.265752e-001, 3.265710e-001, 3.265669e-001, 3.265628e-001, 3.265587e-001, 3.265546e-001, 3.265504e-001, 3.265463e-001, 3.265422e-001, 3.265381e-001, 3.265339e-001, 3.265298e-001, 3.265257e-001, 3.265216e-001, 3.265175e-001, 3.265133e-001, 3.265092e-001, 3.265051e-001, 3.265010e-001, 3.264968e-001, 3.264927e-001, 3.264886e-001, 3.264845e-001, 3.264803e-001, 3.264762e-001, 3.264721e-001, 3.264680e-001, 3.264638e-001, 3.264597e-001, 3.264556e-001, 3.264515e-001, 3.264473e-001, 3.264432e-001, 3.264391e-001, 3.264349e-001, 3.264308e-001, 3.264267e-001, 3.264226e-001, 3.264184e-001, 3.264143e-001, 3.264102e-001, 3.264061e-001, 3.264019e-001, 3.263978e-001, 3.263937e-001, 3.263895e-001, 3.263854e-001, 3.263813e-001, 3.263772e-001, 3.263730e-001, 3.263689e-001, 
3.263648e-001, 3.263606e-001, 3.263565e-001, 3.263524e-001, 3.263482e-001, 3.263441e-001, 3.263400e-001, 3.263358e-001, 3.263317e-001, 3.263276e-001, 3.263235e-001, 3.263193e-001, 3.263152e-001, 3.263111e-001, 3.263069e-001, 3.263028e-001, 3.262987e-001, 3.262945e-001, 3.262904e-001, 3.262863e-001, 3.262821e-001, 3.262780e-001, 3.262739e-001, 3.262697e-001, 3.262656e-001, 3.262615e-001, 3.262573e-001, 3.262532e-001, 3.262490e-001, 3.262449e-001, 3.262408e-001, 3.262366e-001, 3.262325e-001, 3.262284e-001, 3.262242e-001, 3.262201e-001, 3.262160e-001, 3.262118e-001, 3.262077e-001, 3.262036e-001, 3.261994e-001, 3.261953e-001, 3.261911e-001, 3.261870e-001, 3.261829e-001, 3.261787e-001, 3.261746e-001, 3.261704e-001, 3.261663e-001, 3.261622e-001, 3.261580e-001, 3.261539e-001, 3.261498e-001, 3.261456e-001, 3.261415e-001, 3.261373e-001, 3.261332e-001, 3.261291e-001, 3.261249e-001, 3.261208e-001, 3.261166e-001, 3.261125e-001, 3.261083e-001, 3.261042e-001, 3.261001e-001, 3.260959e-001, 3.260918e-001, 3.260876e-001, 3.260835e-001, 3.260794e-001, 3.260752e-001, 3.260711e-001, 3.260669e-001, 3.260628e-001, 3.260586e-001, 3.260545e-001, 3.260504e-001, 3.260462e-001, 3.260421e-001, 3.260379e-001, 3.260338e-001, 3.260296e-001, 3.260255e-001, 3.260213e-001, 3.260172e-001, 3.260131e-001, 3.260089e-001, 3.260048e-001, 3.260006e-001, 3.259965e-001, 3.259923e-001, 3.259882e-001, 3.259840e-001, 3.259799e-001, 3.259757e-001, 3.259716e-001, 3.259674e-001, 3.259633e-001, 3.259591e-001, 3.259550e-001, 
3.259509e-001, 3.259467e-001, 3.259426e-001, 3.259384e-001, 3.259343e-001, 3.259301e-001, 3.259260e-001, 3.259218e-001, 3.259177e-001, 3.259135e-001, 3.259094e-001, 3.259052e-001, 3.259011e-001, 3.258969e-001, 3.258928e-001, 3.258886e-001, 3.258845e-001, 3.258803e-001, 3.258762e-001, 3.258720e-001, 3.258679e-001, 3.258637e-001, 3.258596e-001, 3.258554e-001, 3.258512e-001, 3.258471e-001, 3.258429e-001, 3.258388e-001, 3.258346e-001, 3.258305e-001, 3.258263e-001, 3.258222e-001, 3.258180e-001, 3.258139e-001, 3.258097e-001, 3.258056e-001, 3.258014e-001, 3.257972e-001, 3.257931e-001, 3.257889e-001, 3.257848e-001, 3.257806e-001, 3.257765e-001, 3.257723e-001, 3.257682e-001, 3.257640e-001, 3.257598e-001, 3.257557e-001, 3.257515e-001, 3.257474e-001, 3.257432e-001, 3.257391e-001, 3.257349e-001, 3.257308e-001, 3.257266e-001, 3.257224e-001, 3.257183e-001, 3.257141e-001, 3.257100e-001, 3.257058e-001, 3.257016e-001, 3.256975e-001, 3.256933e-001, 3.256892e-001, 3.256850e-001, 3.256808e-001, 3.256767e-001, 3.256725e-001, 3.256684e-001, 3.256642e-001, 3.256600e-001, 3.256559e-001, 3.256517e-001, 3.256476e-001, 3.256434e-001, 3.256392e-001, 3.256351e-001, 3.256309e-001, 3.256268e-001, 3.256226e-001, 3.256184e-001, 3.256143e-001, 3.256101e-001, 3.256059e-001, 3.256018e-001, 3.255976e-001, 3.255935e-001, 3.255893e-001, 3.255851e-001, 3.255810e-001, 3.255768e-001, 3.255726e-001, 3.255685e-001, 3.255643e-001, 3.255601e-001, 3.255560e-001, 3.255518e-001, 3.255476e-001, 3.255435e-001, 3.255393e-001, 
3.255351e-001, 3.255310e-001, 3.255268e-001, 3.255226e-001, 3.255185e-001, 3.255143e-001, 3.255101e-001, 3.255060e-001, 3.255018e-001, 3.254976e-001, 3.254935e-001, 3.254893e-001, 3.254851e-001, 3.254810e-001, 3.254768e-001, 3.254726e-001, 3.254685e-001, 3.254643e-001, 3.254601e-001, 3.254560e-001, 3.254518e-001, 3.254476e-001, 3.254434e-001, 3.254393e-001, 3.254351e-001, 3.254309e-001, 3.254268e-001, 3.254226e-001, 3.254184e-001, 3.254143e-001, 3.254101e-001, 3.254059e-001, 3.254017e-001, 3.253976e-001, 3.253934e-001, 3.253892e-001, 3.253851e-001, 3.253809e-001, 3.253767e-001, 3.253725e-001, 3.253684e-001, 3.253642e-001, 3.253600e-001, 3.253558e-001, 3.253517e-001, 3.253475e-001, 3.253433e-001, 3.253391e-001, 3.253350e-001, 3.253308e-001, 3.253266e-001, 3.253224e-001, 3.253183e-001, 3.253141e-001, 3.253099e-001, 3.253057e-001, 3.253016e-001, 3.252974e-001, 3.252932e-001, 3.252890e-001, 3.252849e-001, 3.252807e-001, 3.252765e-001, 3.252723e-001, 3.252682e-001, 3.252640e-001, 3.252598e-001, 3.252556e-001, 3.252514e-001, 3.252473e-001, 3.252431e-001, 3.252389e-001, 3.252347e-001, 3.252305e-001, 3.252264e-001, 3.252222e-001, 3.252180e-001, 3.252138e-001, 3.252096e-001, 3.252055e-001, 3.252013e-001, 3.251971e-001, 3.251929e-001, 3.251887e-001, 3.251846e-001, 3.251804e-001, 3.251762e-001, 3.251720e-001, 3.251678e-001, 3.251637e-001, 3.251595e-001, 3.251553e-001, 3.251511e-001, 3.251469e-001, 3.251427e-001, 3.251386e-001, 3.251344e-001, 3.251302e-001, 3.251260e-001, 3.251218e-001, 
3.251176e-001, 3.251135e-001, 3.251093e-001, 3.251051e-001, 3.251009e-001, 3.250967e-001, 3.250925e-001, 3.250884e-001, 3.250842e-001, 3.250800e-001, 3.250758e-001, 3.250716e-001, 3.250674e-001, 3.250632e-001, 3.250591e-001, 3.250549e-001, 3.250507e-001, 3.250465e-001, 3.250423e-001, 3.250381e-001, 3.250339e-001, 3.250297e-001, 3.250256e-001, 3.250214e-001, 3.250172e-001, 3.250130e-001, 3.250088e-001, 3.250046e-001, 3.250004e-001, 3.249962e-001, 3.249920e-001, 3.249879e-001, 3.249837e-001, 3.249795e-001, 3.249753e-001, 3.249711e-001, 3.249669e-001, 3.249627e-001, 3.249585e-001, 3.249543e-001, 3.249501e-001, 3.249460e-001, 3.249418e-001, 3.249376e-001, 3.249334e-001, 3.249292e-001, 3.249250e-001, 3.249208e-001, 3.249166e-001, 3.249124e-001, 3.249082e-001, 3.249040e-001, 3.248998e-001, 3.248956e-001, 3.248915e-001, 3.248873e-001, 3.248831e-001, 3.248789e-001, 3.248747e-001, 3.248705e-001, 3.248663e-001, 3.248621e-001, 3.248579e-001, 3.248537e-001, 3.248495e-001, 3.248453e-001, 3.248411e-001, 3.248369e-001, 3.248327e-001, 3.248285e-001, 3.248243e-001, 3.248201e-001, 3.248159e-001, 3.248117e-001, 3.248075e-001, 3.248033e-001, 3.247991e-001, 3.247950e-001, 3.247908e-001, 3.247866e-001, 3.247824e-001, 3.247782e-001, 3.247740e-001, 3.247698e-001, 3.247656e-001, 3.247614e-001, 3.247572e-001, 3.247530e-001, 3.247488e-001, 3.247446e-001, 3.247404e-001, 3.247362e-001, 3.247320e-001, 3.247278e-001, 3.247236e-001, 3.247194e-001, 3.247152e-001, 3.247110e-001, 3.247068e-001, 3.247026e-001, 
3.246984e-001, 3.246942e-001, 3.246900e-001, 3.246858e-001, 3.246815e-001, 3.246773e-001, 3.246731e-001, 3.246689e-001, 3.246647e-001, 3.246605e-001, 3.246563e-001, 3.246521e-001, 3.246479e-001, 3.246437e-001, 3.246395e-001, 3.246353e-001, 3.246311e-001, 3.246269e-001, 3.246227e-001, 3.246185e-001, 3.246143e-001, 3.246101e-001, 3.246059e-001, 3.246017e-001, 3.245975e-001, 3.245933e-001, 3.245890e-001, 3.245848e-001, 3.245806e-001, 3.245764e-001, 3.245722e-001, 3.245680e-001, 3.245638e-001, 3.245596e-001, 3.245554e-001, 3.245512e-001, 3.245470e-001, 3.245428e-001, 3.245386e-001, 3.245344e-001, 3.245301e-001, 3.245259e-001, 3.245217e-001, 3.245175e-001, 3.245133e-001, 3.245091e-001, 3.245049e-001, 3.245007e-001, 3.244965e-001, 3.244923e-001, 3.244880e-001, 3.244838e-001, 3.244796e-001, 3.244754e-001, 3.244712e-001, 3.244670e-001, 3.244628e-001, 3.244586e-001, 3.244544e-001, 3.244501e-001, 3.244459e-001, 3.244417e-001, 3.244375e-001, 3.244333e-001, 3.244291e-001, 3.244249e-001, 3.244206e-001, 3.244164e-001, 3.244122e-001, 3.244080e-001, 3.244038e-001, 3.243996e-001, 3.243954e-001, 3.243911e-001, 3.243869e-001, 3.243827e-001, 3.243785e-001, 3.243743e-001, 3.243701e-001, 3.243659e-001, 3.243616e-001, 3.243574e-001, 3.243532e-001, 3.243490e-001, 3.243448e-001, 3.243406e-001, 3.243363e-001, 3.243321e-001, 3.243279e-001, 3.243237e-001, 3.243195e-001, 3.243153e-001, 3.243110e-001, 3.243068e-001, 3.243026e-001, 3.242984e-001, 3.242942e-001, 3.242899e-001, 3.242857e-001, 3.242815e-001, 
3.242773e-001, 3.242731e-001, 3.242688e-001, 3.242646e-001, 3.242604e-001, 3.242562e-001, 3.242520e-001, 3.242477e-001, 3.242435e-001, 3.242393e-001, 3.242351e-001, 3.242309e-001, 3.242266e-001, 3.242224e-001, 3.242182e-001, 3.242140e-001, 3.242097e-001, 3.242055e-001, 3.242013e-001, 3.241971e-001, 3.241929e-001, 3.241886e-001, 3.241844e-001, 3.241802e-001, 3.241760e-001, 3.241717e-001, 3.241675e-001, 3.241633e-001, 3.241591e-001, 3.241548e-001, 3.241506e-001, 3.241464e-001, 3.241422e-001, 3.241379e-001, 3.241337e-001, 3.241295e-001, 3.241253e-001, 3.241210e-001, 3.241168e-001, 3.241126e-001, 3.241084e-001, 3.241041e-001, 3.240999e-001, 3.240957e-001, 3.240914e-001, 3.240872e-001, 3.240830e-001, 3.240788e-001, 3.240745e-001, 3.240703e-001, 3.240661e-001, 3.240618e-001, 3.240576e-001, 3.240534e-001, 3.240492e-001, 3.240449e-001, 3.240407e-001, 3.240365e-001, 3.240322e-001, 3.240280e-001, 3.240238e-001, 3.240196e-001, 3.240153e-001, 3.240111e-001, 3.240069e-001, 3.240026e-001, 3.239984e-001, 3.239942e-001, 3.239899e-001, 3.239857e-001, 3.239815e-001, 3.239772e-001, 3.239730e-001, 3.239688e-001, 3.239645e-001, 3.239603e-001, 3.239561e-001, 3.239518e-001, 3.239476e-001, 3.239434e-001, 3.239391e-001, 3.239349e-001, 3.239307e-001, 3.239264e-001, 3.239222e-001, 3.239180e-001, 3.239137e-001, 3.239095e-001, 3.239053e-001, 3.239010e-001, 3.238968e-001, 3.238926e-001, 3.238883e-001, 3.238841e-001, 3.238798e-001, 3.238756e-001, 3.238714e-001, 3.238671e-001, 3.238629e-001, 3.238587e-001, 
3.238544e-001, 3.238502e-001, 3.238460e-001, 3.238417e-001, 3.238375e-001, 3.238332e-001, 3.238290e-001, 3.238248e-001, 3.238205e-001, 3.238163e-001, 3.238120e-001, 3.238078e-001, 3.238036e-001, 3.237993e-001, 3.237951e-001, 3.237908e-001, 3.237866e-001, 3.237824e-001, 3.237781e-001, 3.237739e-001, 3.237696e-001, 3.237654e-001, 3.237612e-001, 3.237569e-001, 3.237527e-001, 3.237484e-001, 3.237442e-001, 3.237400e-001, 3.237357e-001, 3.237315e-001, 3.237272e-001, 3.237230e-001, 3.237187e-001, 3.237145e-001, 3.237103e-001, 3.237060e-001, 3.237018e-001, 3.236975e-001, 3.236933e-001, 3.236890e-001, 3.236848e-001, 3.236805e-001, 3.236763e-001, 3.236721e-001, 3.236678e-001, 3.236636e-001, 3.236593e-001, 3.236551e-001, 3.236508e-001, 3.236466e-001, 3.236423e-001, 3.236381e-001, 3.236338e-001, 3.236296e-001, 3.236253e-001, 3.236211e-001, 3.236169e-001, 3.236126e-001, 3.236084e-001, 3.236041e-001, 3.235999e-001, 3.235956e-001, 3.235914e-001, 3.235871e-001, 3.235829e-001, 3.235786e-001, 3.235744e-001, 3.235701e-001, 3.235659e-001, 3.235616e-001, 3.235574e-001, 3.235531e-001, 3.235489e-001, 3.235446e-001, 3.235404e-001, 3.235361e-001, 3.235319e-001, 3.235276e-001, 3.235234e-001, 3.235191e-001, 3.235149e-001, 3.235106e-001, 3.235064e-001, 3.235021e-001, 3.234979e-001, 3.234936e-001, 3.234893e-001, 3.234851e-001, 3.234808e-001, 3.234766e-001, 3.234723e-001, 3.234681e-001, 3.234638e-001, 3.234596e-001, 3.234553e-001, 3.234511e-001, 3.234468e-001, 3.234426e-001, 3.234383e-001, 3.234340e-001, 
3.234298e-001, 3.234255e-001, 3.234213e-001, 3.234170e-001, 3.234128e-001, 3.234085e-001, 3.234043e-001, 3.234000e-001, 3.233957e-001, 3.233915e-001, 3.233872e-001, 3.233830e-001, 3.233787e-001, 3.233745e-001, 3.233702e-001, 3.233659e-001, 3.233617e-001, 3.233574e-001, 3.233532e-001, 3.233489e-001, 3.233447e-001, 3.233404e-001, 3.233361e-001, 3.233319e-001, 3.233276e-001, 3.233234e-001, 3.233191e-001, 3.233148e-001, 3.233106e-001, 3.233063e-001, 3.233021e-001, 3.232978e-001, 3.232935e-001, 3.232893e-001, 3.232850e-001, 3.232807e-001, 3.232765e-001, 3.232722e-001, 3.232680e-001, 3.232637e-001, 3.232594e-001, 3.232552e-001, 3.232509e-001, 3.232467e-001, 3.232424e-001, 3.232381e-001, 3.232339e-001, 3.232296e-001, 3.232253e-001, 3.232211e-001, 3.232168e-001, 3.232125e-001, 3.232083e-001, 3.232040e-001, 3.231997e-001, 3.231955e-001, 3.231912e-001, 3.231870e-001, 3.231827e-001, 3.231784e-001, 3.231742e-001, 3.231699e-001, 3.231656e-001, 3.231614e-001, 3.231571e-001, 3.231528e-001, 3.231486e-001, 3.231443e-001, 3.231400e-001, 3.231358e-001, 3.231315e-001, 3.231272e-001, 3.231230e-001, 3.231187e-001, 3.231144e-001, 3.231101e-001, 3.231059e-001, 3.231016e-001, 3.230973e-001, 3.230931e-001, 3.230888e-001, 3.230845e-001, 3.230803e-001, 3.230760e-001, 3.230717e-001, 3.230675e-001, 3.230632e-001, 3.230589e-001, 3.230546e-001, 3.230504e-001, 3.230461e-001, 3.230418e-001, 3.230376e-001, 3.230333e-001, 3.230290e-001, 3.230247e-001, 3.230205e-001, 3.230162e-001, 3.230119e-001, 3.230077e-001, 
3.230034e-001, 3.229991e-001, 3.229948e-001, 3.229906e-001, 3.229863e-001, 3.229820e-001, 3.229777e-001, 3.229735e-001, 3.229692e-001, 3.229649e-001, 3.229606e-001, 3.229564e-001, 3.229521e-001, 3.229478e-001, 3.229435e-001, 3.229393e-001, 3.229350e-001, 3.229307e-001, 3.229264e-001, 3.229222e-001, 3.229179e-001, 3.229136e-001, 3.229093e-001, 3.229051e-001, 3.229008e-001, 3.228965e-001, 3.228922e-001, 3.228879e-001, 3.228837e-001, 3.228794e-001, 3.228751e-001, 3.228708e-001, 3.228666e-001, 3.228623e-001, 3.228580e-001, 3.228537e-001, 3.228494e-001, 3.228452e-001, 3.228409e-001, 3.228366e-001, 3.228323e-001, 3.228280e-001, 3.228238e-001, 3.228195e-001, 3.228152e-001, 3.228109e-001, 3.228066e-001, 3.228024e-001, 3.227981e-001, 3.227938e-001, 3.227895e-001, 3.227852e-001, 3.227809e-001, 3.227767e-001, 3.227724e-001, 3.227681e-001, 3.227638e-001, 3.227595e-001, 3.227552e-001, 3.227510e-001, 3.227467e-001, 3.227424e-001, 3.227381e-001, 3.227338e-001, 3.227295e-001, 3.227253e-001, 3.227210e-001, 3.227167e-001, 3.227124e-001, 3.227081e-001, 3.227038e-001, 3.226996e-001, 3.226953e-001, 3.226910e-001, 3.226867e-001, 3.226824e-001, 3.226781e-001, 3.226738e-001, 3.226695e-001, 3.226653e-001, 3.226610e-001, 3.226567e-001, 3.226524e-001, 3.226481e-001, 3.226438e-001, 3.226395e-001, 3.226352e-001, 3.226310e-001, 3.226267e-001, 3.226224e-001, 3.226181e-001, 3.226138e-001, 3.226095e-001, 3.226052e-001, 3.226009e-001, 3.225966e-001, 3.225924e-001, 3.225881e-001, 3.225838e-001, 3.225795e-001, 
3.225752e-001, 3.225709e-001, 3.225666e-001, 3.225623e-001, 3.225580e-001, 3.225537e-001, 3.225494e-001, 3.225452e-001, 3.225409e-001, 3.225366e-001, 3.225323e-001, 3.225280e-001, 3.225237e-001, 3.225194e-001, 3.225151e-001, 3.225108e-001, 3.225065e-001, 3.225022e-001, 3.224979e-001, 3.224936e-001, 3.224893e-001, 3.224851e-001, 3.224808e-001, 3.224765e-001, 3.224722e-001, 3.224679e-001, 3.224636e-001, 3.224593e-001, 3.224550e-001, 3.224507e-001, 3.224464e-001, 3.224421e-001, 3.224378e-001, 3.224335e-001, 3.224292e-001, 3.224249e-001, 3.224206e-001, 3.224163e-001, 3.224120e-001, 3.224077e-001, 3.224034e-001, 3.223991e-001, 3.223948e-001, 3.223905e-001, 3.223862e-001, 3.223819e-001, 3.223776e-001, 3.223733e-001, 3.223690e-001, 3.223647e-001, 3.223604e-001, 3.223561e-001, 3.223518e-001, 3.223475e-001, 3.223432e-001, 3.223389e-001, 3.223346e-001, 3.223303e-001, 3.223260e-001, 3.223217e-001, 3.223174e-001, 3.223131e-001, 3.223088e-001, 3.223045e-001, 3.223002e-001, 3.222959e-001, 3.222916e-001, 3.222873e-001, 3.222830e-001, 3.222787e-001, 3.222744e-001, 3.222701e-001, 3.222658e-001, 3.222615e-001, 3.222572e-001, 3.222529e-001, 3.222486e-001, 3.222443e-001, 3.222400e-001, 3.222357e-001, 3.222314e-001, 3.222271e-001, 3.222228e-001, 3.222185e-001, 3.222142e-001, 3.222098e-001, 3.222055e-001, 3.222012e-001, 3.221969e-001, 3.221926e-001, 3.221883e-001, 3.221840e-001, 3.221797e-001, 3.221754e-001, 3.221711e-001, 3.221668e-001, 3.221625e-001, 3.221582e-001, 3.221539e-001, 3.221495e-001, 
3.221452e-001, 3.221409e-001, 3.221366e-001, 3.221323e-001, 3.221280e-001, 3.221237e-001, 3.221194e-001, 3.221151e-001, 3.221108e-001, 3.221065e-001, 3.221021e-001, 3.220978e-001, 3.220935e-001, 3.220892e-001, 3.220849e-001, 3.220806e-001, 3.220763e-001, 3.220720e-001, 3.220677e-001, 3.220633e-001, 3.220590e-001, 3.220547e-001, 3.220504e-001, 3.220461e-001, 3.220418e-001, 3.220375e-001, 3.220332e-001, 3.220288e-001, 3.220245e-001, 3.220202e-001, 3.220159e-001, 3.220116e-001, 3.220073e-001, 3.220030e-001, 3.219987e-001, 3.219943e-001, 3.219900e-001, 3.219857e-001, 3.219814e-001, 3.219771e-001, 3.219728e-001, 3.219684e-001, 3.219641e-001, 3.219598e-001, 3.219555e-001, 3.219512e-001, 3.219469e-001, 3.219426e-001, 3.219382e-001, 3.219339e-001, 3.219296e-001, 3.219253e-001, 3.219210e-001, 3.219166e-001, 3.219123e-001, 3.219080e-001, 3.219037e-001, 3.218994e-001, 3.218951e-001, 3.218907e-001, 3.218864e-001, 3.218821e-001, 3.218778e-001, 3.218735e-001, 3.218691e-001, 3.218648e-001, 3.218605e-001, 3.218562e-001, 3.218519e-001, 3.218475e-001, 3.218432e-001, 3.218389e-001, 3.218346e-001, 3.218303e-001, 3.218259e-001, 3.218216e-001, 3.218173e-001, 3.218130e-001, 3.218086e-001, 3.218043e-001, 3.218000e-001, 3.217957e-001, 3.217914e-001, 3.217870e-001, 3.217827e-001, 3.217784e-001, 3.217741e-001, 3.217697e-001, 3.217654e-001, 3.217611e-001, 3.217568e-001, 3.217524e-001, 3.217481e-001, 3.217438e-001, 3.217395e-001, 3.217351e-001, 3.217308e-001, 3.217265e-001, 3.217222e-001, 3.217178e-001, 
3.217135e-001, 3.217092e-001, 3.217049e-001, 3.217005e-001, 3.216962e-001, 3.216919e-001, 3.216876e-001, 3.216832e-001, 3.216789e-001, 3.216746e-001, 3.216702e-001, 3.216659e-001, 3.216616e-001, 3.216573e-001, 3.216529e-001, 3.216486e-001, 3.216443e-001, 3.216399e-001, 3.216356e-001, 3.216313e-001, 3.216270e-001, 3.216226e-001, 3.216183e-001, 3.216140e-001, 3.216096e-001, 3.216053e-001, 3.216010e-001, 3.215967e-001, 3.215923e-001, 3.215880e-001, 3.215837e-001, 3.215793e-001, 3.215750e-001, 3.215707e-001, 3.215663e-001, 3.215620e-001, 3.215577e-001, 3.215533e-001, 3.215490e-001, 3.215447e-001, 3.215403e-001, 3.215360e-001, 3.215317e-001, 3.215273e-001, 3.215230e-001, 3.215187e-001, 3.215143e-001, 3.215100e-001, 3.215057e-001, 3.215013e-001, 3.214970e-001, 3.214927e-001, 3.214883e-001, 3.214840e-001, 3.214797e-001, 3.214753e-001, 3.214710e-001, 3.214666e-001, 3.214623e-001, 3.214580e-001, 3.214536e-001, 3.214493e-001, 3.214450e-001, 3.214406e-001, 3.214363e-001, 3.214320e-001, 3.214276e-001, 3.214233e-001, 3.214189e-001, 3.214146e-001, 3.214103e-001, 3.214059e-001, 3.214016e-001, 3.213972e-001, 3.213929e-001, 3.213886e-001, 3.213842e-001, 3.213799e-001, 3.213756e-001, 3.213712e-001, 3.213669e-001, 3.213625e-001, 3.213582e-001, 3.213538e-001, 3.213495e-001, 3.213452e-001, 3.213408e-001, 3.213365e-001, 3.213321e-001, 3.213278e-001, 3.213235e-001, 3.213191e-001, 3.213148e-001, 3.213104e-001, 3.213061e-001, 3.213017e-001, 3.212974e-001, 3.212931e-001, 3.212887e-001, 3.212844e-001, 
3.212800e-001, 3.212757e-001, 3.212713e-001, 3.212670e-001, 3.212627e-001, 3.212583e-001, 3.212540e-001, 3.212496e-001, 3.212453e-001, 3.212409e-001, 3.212366e-001, 3.212322e-001, 3.212279e-001, 3.212236e-001, 3.212192e-001, 3.212149e-001, 3.212105e-001, 3.212062e-001, 3.212018e-001, 3.211975e-001, 3.211931e-001, 3.211888e-001, 3.211844e-001, 3.211801e-001, 3.211757e-001, 3.211714e-001, 3.211670e-001, 3.211627e-001, 3.211583e-001, 3.211540e-001, 3.211496e-001, 3.211453e-001, 3.211409e-001, 3.211366e-001, 3.211322e-001, 3.211279e-001, 3.211235e-001, 3.211192e-001, 3.211148e-001, 3.211105e-001, 3.211061e-001, 3.211018e-001, 3.210974e-001, 3.210931e-001, 3.210887e-001, 3.210844e-001, 3.210800e-001, 3.210757e-001, 3.210713e-001, 3.210670e-001, 3.210626e-001, 3.210583e-001, 3.210539e-001, 3.210496e-001, 3.210452e-001, 3.210409e-001, 3.210365e-001, 3.210322e-001, 3.210278e-001, 3.210235e-001, 3.210191e-001, 3.210147e-001, 3.210104e-001, 3.210060e-001, 3.210017e-001, 3.209973e-001, 3.209930e-001, 3.209886e-001, 3.209843e-001, 3.209799e-001, 3.209755e-001, 3.209712e-001, 3.209668e-001, 3.209625e-001, 3.209581e-001, 3.209538e-001, 3.209494e-001, 3.209450e-001, 3.209407e-001, 3.209363e-001, 3.209320e-001, 3.209276e-001, 3.209233e-001, 3.209189e-001, 3.209145e-001, 3.209102e-001, 3.209058e-001, 3.209015e-001, 3.208971e-001, 3.208927e-001, 3.208884e-001, 3.208840e-001, 3.208797e-001, 3.208753e-001, 3.208710e-001, 3.208666e-001, 3.208622e-001, 3.208579e-001, 3.208535e-001, 3.208491e-001, 
3.208448e-001, 3.208404e-001, 3.208361e-001, 3.208317e-001, 3.208273e-001, 3.208230e-001, 3.208186e-001, 3.208143e-001, 3.208099e-001, 3.208055e-001, 3.208012e-001, 3.207968e-001, 3.207924e-001, 3.207881e-001, 3.207837e-001, 3.207793e-001, 3.207750e-001, 3.207706e-001, 3.207663e-001, 3.207619e-001, 3.207575e-001, 3.207532e-001, 3.207488e-001, 3.207444e-001, 3.207401e-001, 3.207357e-001, 3.207313e-001, 3.207270e-001, 3.207226e-001, 3.207182e-001, 3.207139e-001, 3.207095e-001, 3.207051e-001, 3.207008e-001, 3.206964e-001, 3.206920e-001, 3.206877e-001, 3.206833e-001, 3.206789e-001, 3.206746e-001, 3.206702e-001, 3.206658e-001, 3.206615e-001, 3.206571e-001, 3.206527e-001, 3.206484e-001, 3.206440e-001, 3.206396e-001, 3.206352e-001, 3.206309e-001, 3.206265e-001, 3.206221e-001, 3.206178e-001, 3.206134e-001, 3.206090e-001, 3.206047e-001, 3.206003e-001, 3.205959e-001, 3.205915e-001, 3.205872e-001, 3.205828e-001, 3.205784e-001, 3.205741e-001, 3.205697e-001, 3.205653e-001, 3.205609e-001, 3.205566e-001, 3.205522e-001, 3.205478e-001, 3.205434e-001, 3.205391e-001, 3.205347e-001, 3.205303e-001, 3.205259e-001, 3.205216e-001, 3.205172e-001, 3.205128e-001, 3.205084e-001, 3.205041e-001, 3.204997e-001, 3.204953e-001, 3.204909e-001, 3.204866e-001, 3.204822e-001, 3.204778e-001, 3.204734e-001, 3.204691e-001, 3.204647e-001, 3.204603e-001, 3.204559e-001, 3.204516e-001, 3.204472e-001, 3.204428e-001, 3.204384e-001, 3.204341e-001, 3.204297e-001, 3.204253e-001, 3.204209e-001, 3.204165e-001, 3.204122e-001, 
3.204078e-001, 3.204034e-001, 3.203990e-001, 3.203946e-001, 3.203903e-001, 3.203859e-001, 3.203815e-001, 3.203771e-001, 3.203727e-001, 3.203684e-001, 3.203640e-001, 3.203596e-001, 3.203552e-001, 3.203508e-001, 3.203465e-001, 3.203421e-001, 3.203377e-001, 3.203333e-001, 3.203289e-001, 3.203246e-001, 3.203202e-001, 3.203158e-001, 3.203114e-001, 3.203070e-001, 3.203026e-001, 3.202983e-001, 3.202939e-001, 3.202895e-001, 3.202851e-001, 3.202807e-001, 3.202763e-001, 3.202720e-001, 3.202676e-001, 3.202632e-001, 3.202588e-001, 3.202544e-001, 3.202500e-001, 3.202456e-001, 3.202413e-001, 3.202369e-001, 3.202325e-001, 3.202281e-001, 3.202237e-001, 3.202193e-001, 3.202149e-001, 3.202106e-001, 3.202062e-001, 3.202018e-001, 3.201974e-001, 3.201930e-001, 3.201886e-001, 3.201842e-001, 3.201798e-001, 3.201755e-001, 3.201711e-001, 3.201667e-001, 3.201623e-001, 3.201579e-001, 3.201535e-001, 3.201491e-001, 3.201447e-001, 3.201403e-001, 3.201360e-001, 3.201316e-001, 3.201272e-001, 3.201228e-001, 3.201184e-001, 3.201140e-001, 3.201096e-001, 3.201052e-001, 3.201008e-001, 3.200964e-001, 3.200921e-001, 3.200877e-001, 3.200833e-001, 3.200789e-001, 3.200745e-001, 3.200701e-001, 3.200657e-001, 3.200613e-001, 3.200569e-001, 3.200525e-001, 3.200481e-001, 3.200437e-001, 3.200393e-001, 3.200350e-001, 3.200306e-001, 3.200262e-001, 3.200218e-001, 3.200174e-001, 3.200130e-001, 3.200086e-001, 3.200042e-001, 3.199998e-001, 3.199954e-001, 3.199910e-001, 3.199866e-001, 3.199822e-001, 3.199778e-001, 3.199734e-001, 
3.199690e-001, 3.199646e-001, 3.199602e-001, 3.199558e-001, 3.199514e-001, 3.199470e-001, 3.199426e-001, 3.199382e-001, 3.199338e-001, 3.199295e-001, 3.199251e-001, 3.199207e-001, 3.199163e-001, 3.199119e-001, 3.199075e-001, 3.199031e-001, 3.198987e-001, 3.198943e-001, 3.198899e-001, 3.198855e-001, 3.198811e-001, 3.198767e-001, 3.198723e-001, 3.198679e-001, 3.198635e-001, 3.198591e-001, 3.198547e-001, 3.198503e-001, 3.198459e-001, 3.198415e-001, 3.198371e-001, 3.198327e-001, 3.198283e-001, 3.198239e-001, 3.198194e-001, 3.198150e-001, 3.198106e-001, 3.198062e-001, 3.198018e-001, 3.197974e-001, 3.197930e-001, 3.197886e-001, 3.197842e-001, 3.197798e-001, 3.197754e-001, 3.197710e-001, 3.197666e-001, 3.197622e-001, 3.197578e-001, 3.197534e-001, 3.197490e-001, 3.197446e-001, 3.197402e-001, 3.197358e-001, 3.197314e-001, 3.197270e-001, 3.197226e-001, 3.197181e-001, 3.197137e-001, 3.197093e-001, 3.197049e-001, 3.197005e-001, 3.196961e-001, 3.196917e-001, 3.196873e-001, 3.196829e-001, 3.196785e-001, 3.196741e-001, 3.196697e-001, 3.196653e-001, 3.196609e-001, 3.196564e-001, 3.196520e-001, 3.196476e-001, 3.196432e-001, 3.196388e-001, 3.196344e-001, 3.196300e-001, 3.196256e-001, 3.196212e-001, 3.196168e-001, 3.196123e-001, 3.196079e-001, 3.196035e-001, 3.195991e-001, 3.195947e-001, 3.195903e-001, 3.195859e-001, 3.195815e-001, 3.195771e-001, 3.195726e-001, 3.195682e-001, 3.195638e-001, 3.195594e-001, 3.195550e-001, 3.195506e-001, 3.195462e-001, 3.195418e-001, 3.195373e-001, 3.195329e-001, 
3.195285e-001, 3.195241e-001, 3.195197e-001, 3.195153e-001, 3.195109e-001, 3.195064e-001, 3.195020e-001, 3.194976e-001, 3.194932e-001, 3.194888e-001, 3.194844e-001, 3.194800e-001, 3.194755e-001, 3.194711e-001, 3.194667e-001, 3.194623e-001, 3.194579e-001, 3.194535e-001, 3.194490e-001, 3.194446e-001, 3.194402e-001, 3.194358e-001, 3.194314e-001, 3.194270e-001, 3.194225e-001, 3.194181e-001, 3.194137e-001, 3.194093e-001, 3.194049e-001, 3.194004e-001, 3.193960e-001, 3.193916e-001, 3.193872e-001, 3.193828e-001, 3.193783e-001, 3.193739e-001, 3.193695e-001, 3.193651e-001, 3.193607e-001, 3.193562e-001, 3.193518e-001, 3.193474e-001, 3.193430e-001, 3.193386e-001, 3.193341e-001, 3.193297e-001, 3.193253e-001, 3.193209e-001, 3.193165e-001, 3.193120e-001, 3.193076e-001, 3.193032e-001, 3.192988e-001, 3.192943e-001, 3.192899e-001, 3.192855e-001, 3.192811e-001, 3.192766e-001, 3.192722e-001, 3.192678e-001, 3.192634e-001, 3.192589e-001, 3.192545e-001, 3.192501e-001, 3.192457e-001, 3.192412e-001, 3.192368e-001, 3.192324e-001, 3.192280e-001, 3.192235e-001, 3.192191e-001, 3.192147e-001, 3.192103e-001, 3.192058e-001, 3.192014e-001, 3.191970e-001, 3.191926e-001, 3.191881e-001, 3.191837e-001, 3.191793e-001, 3.191749e-001, 3.191704e-001, 3.191660e-001, 3.191616e-001, 3.191571e-001, 3.191527e-001, 3.191483e-001, 3.191439e-001, 3.191394e-001, 3.191350e-001, 3.191306e-001, 3.191261e-001, 3.191217e-001, 3.191173e-001, 3.191128e-001, 3.191084e-001, 3.191040e-001, 3.190996e-001, 3.190951e-001, 3.190907e-001, 
3.190863e-001, 3.190818e-001, 3.190774e-001, 3.190730e-001, 3.190685e-001, 3.190641e-001, 3.190597e-001, 3.190552e-001, 3.190508e-001, 3.190464e-001, 3.190419e-001, 3.190375e-001, 3.190331e-001, 3.190286e-001, 3.190242e-001, 3.190198e-001, 3.190153e-001, 3.190109e-001, 3.190065e-001, 3.190020e-001, 3.189976e-001, 3.189932e-001, 3.189887e-001, 3.189843e-001, 3.189799e-001, 3.189754e-001, 3.189710e-001, 3.189666e-001, 3.189621e-001, 3.189577e-001, 3.189532e-001, 3.189488e-001, 3.189444e-001, 3.189399e-001, 3.189355e-001, 3.189311e-001, 3.189266e-001, 3.189222e-001, 3.189177e-001, 3.189133e-001, 3.189089e-001, 3.189044e-001, 3.189000e-001, 3.188956e-001, 3.188911e-001, 3.188867e-001, 3.188822e-001, 3.188778e-001, 3.188734e-001, 3.188689e-001, 3.188645e-001, 3.188600e-001, 3.188556e-001, 3.188512e-001, 3.188467e-001, 3.188423e-001, 3.188378e-001, 3.188334e-001, 3.188290e-001, 3.188245e-001, 3.188201e-001, 3.188156e-001, 3.188112e-001, 3.188067e-001, 3.188023e-001, 3.187979e-001, 3.187934e-001, 3.187890e-001, 3.187845e-001, 3.187801e-001, 3.187756e-001, 3.187712e-001, 3.187668e-001, 3.187623e-001, 3.187579e-001, 3.187534e-001, 3.187490e-001, 3.187445e-001, 3.187401e-001, 3.187356e-001, 3.187312e-001, 3.187268e-001, 3.187223e-001, 3.187179e-001, 3.187134e-001, 3.187090e-001, 3.187045e-001, 3.187001e-001, 3.186956e-001, 3.186912e-001, 3.186867e-001, 3.186823e-001, 3.186778e-001, 3.186734e-001, 3.186689e-001, 3.186645e-001, 3.186601e-001, 3.186556e-001, 3.186512e-001, 3.186467e-001, 
3.186423e-001, 3.186378e-001, 3.186334e-001, 3.186289e-001, 3.186245e-001, 3.186200e-001, 3.186156e-001, 3.186111e-001, 3.186067e-001, 3.186022e-001, 3.185978e-001, 3.185933e-001, 3.185889e-001, 3.185844e-001, 3.185800e-001, 3.185755e-001, 3.185711e-001, 3.185666e-001, 3.185622e-001, 3.185577e-001, 3.185532e-001, 3.185488e-001, 3.185443e-001, 3.185399e-001, 3.185354e-001, 3.185310e-001, 3.185265e-001, 3.185221e-001, 3.185176e-001, 3.185132e-001, 3.185087e-001, 3.185043e-001, 3.184998e-001, 3.184954e-001, 3.184909e-001, 3.184864e-001, 3.184820e-001, 3.184775e-001, 3.184731e-001, 3.184686e-001, 3.184642e-001, 3.184597e-001, 3.184553e-001, 3.184508e-001, 3.184463e-001, 3.184419e-001, 3.184374e-001, 3.184330e-001, 3.184285e-001, 3.184241e-001, 3.184196e-001, 3.184151e-001, 3.184107e-001, 3.184062e-001, 3.184018e-001, 3.183973e-001, 3.183929e-001, 3.183884e-001, 3.183839e-001, 3.183795e-001, 3.183750e-001, 3.183706e-001, 3.183661e-001, 3.183616e-001, 3.183572e-001, 3.183527e-001, 3.183483e-001, 3.183438e-001, 3.183393e-001, 3.183349e-001, 3.183304e-001, 3.183260e-001, 3.183215e-001, 3.183170e-001, 3.183126e-001, 3.183081e-001, 3.183036e-001, 3.182992e-001, 3.182947e-001, 3.182903e-001, 3.182858e-001, 3.182813e-001, 3.182769e-001, 3.182724e-001, 3.182679e-001, 3.182635e-001, 3.182590e-001, 3.182546e-001, 3.182501e-001, 3.182456e-001, 3.182412e-001, 3.182367e-001, 3.182322e-001, 3.182278e-001, 3.182233e-001, 3.182188e-001, 3.182144e-001, 3.182099e-001, 3.182054e-001, 3.182010e-001, 
3.181965e-001, 3.181920e-001, 3.181876e-001, 3.181831e-001, 3.181786e-001, 3.181742e-001, 3.181697e-001, 3.181652e-001, 3.181608e-001, 3.181563e-001, 3.181518e-001, 3.181474e-001, 3.181429e-001, 3.181384e-001, 3.181340e-001, 3.181295e-001, 3.181250e-001, 3.181206e-001, 3.181161e-001, 3.181116e-001, 3.181072e-001, 3.181027e-001, 3.180982e-001, 3.180937e-001, 3.180893e-001, 3.180848e-001, 3.180803e-001, 3.180759e-001, 3.180714e-001, 3.180669e-001, 3.180624e-001, 3.180580e-001, 3.180535e-001, 3.180490e-001, 3.180446e-001, 3.180401e-001, 3.180356e-001, 3.180311e-001, 3.180267e-001, 3.180222e-001, 3.180177e-001, 3.180133e-001, 3.180088e-001, 3.180043e-001, 3.179998e-001, 3.179954e-001, 3.179909e-001, 3.179864e-001, 3.179819e-001, 3.179775e-001, 3.179730e-001, 3.179685e-001, 3.179640e-001, 3.179596e-001, 3.179551e-001, 3.179506e-001, 3.179461e-001, 3.179417e-001, 3.179372e-001, 3.179327e-001, 3.179282e-001, 3.179238e-001, 3.179193e-001, 3.179148e-001, 3.179103e-001, 3.179058e-001, 3.179014e-001, 3.178969e-001, 3.178924e-001, 3.178879e-001, 3.178835e-001, 3.178790e-001, 3.178745e-001, 3.178700e-001, 3.178655e-001, 3.178611e-001, 3.178566e-001, 3.178521e-001, 3.178476e-001, 3.178431e-001, 3.178387e-001, 3.178342e-001, 3.178297e-001, 3.178252e-001, 3.178207e-001, 3.178163e-001, 3.178118e-001, 3.178073e-001, 3.178028e-001, 3.177983e-001, 3.177939e-001, 3.177894e-001, 3.177849e-001, 3.177804e-001, 3.177759e-001, 3.177714e-001, 3.177670e-001, 3.177625e-001, 3.177580e-001, 3.177535e-001, 
3.177490e-001, 3.177445e-001, 3.177401e-001, 3.177356e-001, 3.177311e-001, 3.177266e-001, 3.177221e-001, 3.177176e-001, 3.177132e-001, 3.177087e-001, 3.177042e-001, 3.176997e-001, 3.176952e-001, 3.176907e-001, 3.176862e-001, 3.176818e-001, 3.176773e-001, 3.176728e-001, 3.176683e-001, 3.176638e-001, 3.176593e-001, 3.176548e-001, 3.176503e-001, 3.176459e-001, 3.176414e-001, 3.176369e-001, 3.176324e-001, 3.176279e-001, 3.176234e-001, 3.176189e-001, 3.176144e-001, 3.176100e-001, 3.176055e-001, 3.176010e-001, 3.175965e-001, 3.175920e-001, 3.175875e-001, 3.175830e-001, 3.175785e-001, 3.175740e-001, 3.175695e-001, 3.175651e-001, 3.175606e-001, 3.175561e-001, 3.175516e-001, 3.175471e-001, 3.175426e-001, 3.175381e-001, 3.175336e-001, 3.175291e-001, 3.175246e-001, 3.175201e-001, 3.175157e-001, 3.175112e-001, 3.175067e-001, 3.175022e-001, 3.174977e-001, 3.174932e-001, 3.174887e-001, 3.174842e-001, 3.174797e-001, 3.174752e-001, 3.174707e-001, 3.174662e-001, 3.174617e-001, 3.174572e-001, 3.174527e-001, 3.174482e-001, 3.174437e-001, 3.174393e-001, 3.174348e-001, 3.174303e-001, 3.174258e-001, 3.174213e-001, 3.174168e-001, 3.174123e-001, 3.174078e-001, 3.174033e-001, 3.173988e-001, 3.173943e-001, 3.173898e-001, 3.173853e-001, 3.173808e-001, 3.173763e-001, 3.173718e-001, 3.173673e-001, 3.173628e-001, 3.173583e-001, 3.173538e-001, 3.173493e-001, 3.173448e-001, 3.173403e-001, 3.173358e-001, 3.173313e-001, 3.173268e-001, 3.173223e-001, 3.173178e-001, 3.173133e-001, 3.173088e-001, 3.173043e-001, 
3.172998e-001, 3.172953e-001, 3.172908e-001, 3.172863e-001, 3.172818e-001, 3.172773e-001, 3.172728e-001, 3.172683e-001, 3.172638e-001, 3.172593e-001, 3.172548e-001, 3.172503e-001, 3.172458e-001, 3.172413e-001, 3.172368e-001, 3.172323e-001, 3.172278e-001, 3.172233e-001, 3.172188e-001, 3.172143e-001, 3.172098e-001, 3.172053e-001, 3.172007e-001, 3.171962e-001, 3.171917e-001, 3.171872e-001, 3.171827e-001, 3.171782e-001, 3.171737e-001, 3.171692e-001, 3.171647e-001, 3.171602e-001, 3.171557e-001, 3.171512e-001, 3.171467e-001, 3.171422e-001, 3.171377e-001, 3.171332e-001, 3.171287e-001, 3.171241e-001, 3.171196e-001, 3.171151e-001, 3.171106e-001, 3.171061e-001, 3.171016e-001, 3.170971e-001, 3.170926e-001, 3.170881e-001, 3.170836e-001, 3.170791e-001, 3.170745e-001, 3.170700e-001, 3.170655e-001, 3.170610e-001, 3.170565e-001, 3.170520e-001, 3.170475e-001, 3.170430e-001, 3.170385e-001, 3.170340e-001, 3.170294e-001, 3.170249e-001, 3.170204e-001, 3.170159e-001, 3.170114e-001, 3.170069e-001, 3.170024e-001, 3.169979e-001, 3.169933e-001, 3.169888e-001, 3.169843e-001, 3.169798e-001, 3.169753e-001, 3.169708e-001, 3.169663e-001, 3.169618e-001, 3.169572e-001, 3.169527e-001, 3.169482e-001, 3.169437e-001, 3.169392e-001, 3.169347e-001, 3.169302e-001, 3.169256e-001, 3.169211e-001, 3.169166e-001, 3.169121e-001, 3.169076e-001, 3.169031e-001, 3.168985e-001, 3.168940e-001, 3.168895e-001, 3.168850e-001, 3.168805e-001, 3.168760e-001, 3.168714e-001, 3.168669e-001, 3.168624e-001, 3.168579e-001, 3.168534e-001, 
3.168489e-001, 3.168443e-001, 3.168398e-001, 3.168353e-001, 3.168308e-001, 3.168263e-001, 3.168217e-001, 3.168172e-001, 3.168127e-001, 3.168082e-001, 3.168037e-001, 3.167991e-001, 3.167946e-001, 3.167901e-001, 3.167856e-001, 3.167811e-001, 3.167765e-001, 3.167720e-001, 3.167675e-001, 3.167630e-001, 3.167585e-001, 3.167539e-001, 3.167494e-001, 3.167449e-001, 3.167404e-001, 3.167358e-001, 3.167313e-001, 3.167268e-001, 3.167223e-001, 3.167178e-001, 3.167132e-001, 3.167087e-001, 3.167042e-001, 3.166997e-001, 3.166951e-001, 3.166906e-001, 3.166861e-001, 3.166816e-001, 3.166770e-001, 3.166725e-001, 3.166680e-001, 3.166635e-001, 3.166589e-001, 3.166544e-001, 3.166499e-001, 3.166454e-001, 3.166408e-001, 3.166363e-001, 3.166318e-001, 3.166273e-001, 3.166227e-001, 3.166182e-001, 3.166137e-001, 3.166091e-001, 3.166046e-001, 3.166001e-001, 3.165956e-001, 3.165910e-001, 3.165865e-001, 3.165820e-001, 3.165775e-001, 3.165729e-001, 3.165684e-001, 3.165639e-001, 3.165593e-001, 3.165548e-001, 3.165503e-001, 3.165457e-001, 3.165412e-001, 3.165367e-001, 3.165322e-001, 3.165276e-001, 3.165231e-001, 3.165186e-001, 3.165140e-001, 3.165095e-001, 3.165050e-001, 3.165004e-001, 3.164959e-001, 3.164914e-001, 3.164868e-001, 3.164823e-001, 3.164778e-001, 3.164733e-001, 3.164687e-001, 3.164642e-001, 3.164597e-001, 3.164551e-001, 3.164506e-001, 3.164461e-001, 3.164415e-001, 3.164370e-001, 3.164325e-001, 3.164279e-001, 3.164234e-001, 3.164188e-001, 3.164143e-001, 3.164098e-001, 3.164052e-001, 3.164007e-001, 
3.163962e-001, 3.163916e-001, 3.163871e-001, 3.163826e-001, 3.163780e-001, 3.163735e-001, 3.163690e-001, 3.163644e-001, 3.163599e-001, 3.163553e-001, 3.163508e-001, 3.163463e-001, 3.163417e-001, 3.163372e-001, 3.163327e-001, 3.163281e-001, 3.163236e-001, 3.163190e-001, 3.163145e-001, 3.163100e-001, 3.163054e-001, 3.163009e-001, 3.162963e-001, 3.162918e-001, 3.162873e-001, 3.162827e-001, 3.162782e-001, 3.162737e-001, 3.162691e-001, 3.162646e-001, 3.162600e-001, 3.162555e-001, 3.162509e-001, 3.162464e-001, 3.162419e-001, 3.162373e-001, 3.162328e-001, 3.162282e-001, 3.162237e-001, 3.162192e-001, 3.162146e-001, 3.162101e-001, 3.162055e-001, 3.162010e-001, 3.161964e-001, 3.161919e-001, 3.161874e-001, 3.161828e-001, 3.161783e-001, 3.161737e-001, 3.161692e-001, 3.161646e-001, 3.161601e-001, 3.161555e-001, 3.161510e-001, 3.161465e-001, 3.161419e-001, 3.161374e-001, 3.161328e-001, 3.161283e-001, 3.161237e-001, 3.161192e-001, 3.161146e-001, 3.161101e-001, 3.161055e-001, 3.161010e-001, 3.160965e-001, 3.160919e-001, 3.160874e-001, 3.160828e-001, 3.160783e-001, 3.160737e-001, 3.160692e-001, 3.160646e-001, 3.160601e-001, 3.160555e-001, 3.160510e-001, 3.160464e-001, 3.160419e-001, 3.160373e-001, 3.160328e-001, 3.160282e-001, 3.160237e-001, 3.160191e-001, 3.160146e-001, 3.160100e-001, 3.160055e-001, 3.160009e-001, 3.159964e-001, 3.159918e-001, 3.159873e-001, 3.159827e-001, 3.159782e-001, 3.159736e-001, 3.159691e-001, 3.159645e-001, 3.159600e-001, 3.159554e-001, 3.159509e-001, 3.159463e-001, 
3.159418e-001, 3.159372e-001, 3.159327e-001, 3.159281e-001, 3.159235e-001, 3.159190e-001, 3.159144e-001, 3.159099e-001, 3.159053e-001, 3.159008e-001, 3.158962e-001, 3.158917e-001, 3.158871e-001, 3.158826e-001, 3.158780e-001, 3.158735e-001, 3.158689e-001, 3.158643e-001, 3.158598e-001, 3.158552e-001, 3.158507e-001, 3.158461e-001, 3.158416e-001, 3.158370e-001, 3.158324e-001, 3.158279e-001, 3.158233e-001, 3.158188e-001, 3.158142e-001, 3.158097e-001, 3.158051e-001, 3.158005e-001, 3.157960e-001, 3.157914e-001, 3.157869e-001, 3.157823e-001, 3.157778e-001, 3.157732e-001, 3.157686e-001, 3.157641e-001, 3.157595e-001, 3.157550e-001, 3.157504e-001, 3.157458e-001, 3.157413e-001, 3.157367e-001, 3.157322e-001, 3.157276e-001, 3.157230e-001, 3.157185e-001, 3.157139e-001, 3.157093e-001, 3.157048e-001, 3.157002e-001, 3.156957e-001, 3.156911e-001, 3.156865e-001, 3.156820e-001, 3.156774e-001, 3.156729e-001, 3.156683e-001, 3.156637e-001, 3.156592e-001, 3.156546e-001, 3.156500e-001, 3.156455e-001, 3.156409e-001, 3.156363e-001, 3.156318e-001, 3.156272e-001, 3.156226e-001, 3.156181e-001, 3.156135e-001, 3.156090e-001, 3.156044e-001, 3.155998e-001, 3.155953e-001, 3.155907e-001, 3.155861e-001, 3.155816e-001, 3.155770e-001, 3.155724e-001, 3.155679e-001, 3.155633e-001, 3.155587e-001, 3.155542e-001, 3.155496e-001, 3.155450e-001, 3.155405e-001, 3.155359e-001, 3.155313e-001, 3.155267e-001, 3.155222e-001, 3.155176e-001, 3.155130e-001, 3.155085e-001, 3.155039e-001, 3.154993e-001, 3.154948e-001, 3.154902e-001, 
3.154856e-001, 3.154811e-001, 3.154765e-001, 3.154719e-001, 3.154673e-001, 3.154628e-001, 3.154582e-001, 3.154536e-001, 3.154491e-001, 3.154445e-001, 3.154399e-001, 3.154353e-001, 3.154308e-001, 3.154262e-001, 3.154216e-001, 3.154171e-001, 3.154125e-001, 3.154079e-001, 3.154033e-001, 3.153988e-001, 3.153942e-001, 3.153896e-001, 3.153850e-001, 3.153805e-001, 3.153759e-001, 3.153713e-001, 3.153668e-001, 3.153622e-001, 3.153576e-001, 3.153530e-001, 3.153485e-001, 3.153439e-001, 3.153393e-001, 3.153347e-001, 3.153301e-001, 3.153256e-001, 3.153210e-001, 3.153164e-001, 3.153118e-001, 3.153073e-001, 3.153027e-001, 3.152981e-001, 3.152935e-001, 3.152890e-001, 3.152844e-001, 3.152798e-001, 3.152752e-001, 3.152706e-001, 3.152661e-001, 3.152615e-001, 3.152569e-001, 3.152523e-001, 3.152478e-001, 3.152432e-001, 3.152386e-001, 3.152340e-001, 3.152294e-001, 3.152249e-001, 3.152203e-001, 3.152157e-001, 3.152111e-001, 3.152065e-001, 3.152020e-001, 3.151974e-001, 3.151928e-001, 3.151882e-001, 3.151836e-001, 3.151791e-001, 3.151745e-001, 3.151699e-001, 3.151653e-001, 3.151607e-001, 3.151561e-001, 3.151516e-001, 3.151470e-001, 3.151424e-001, 3.151378e-001, 3.151332e-001, 3.151286e-001, 3.151241e-001, 3.151195e-001, 3.151149e-001, 3.151103e-001, 3.151057e-001, 3.151011e-001, 3.150966e-001, 3.150920e-001, 3.150874e-001, 3.150828e-001, 3.150782e-001, 3.150736e-001, 3.150690e-001, 3.150645e-001, 3.150599e-001, 3.150553e-001, 3.150507e-001, 3.150461e-001, 3.150415e-001, 3.150369e-001, 3.150324e-001, 
3.150278e-001, 3.150232e-001, 3.150186e-001, 3.150140e-001, 3.150094e-001, 3.150048e-001, 3.150002e-001, 3.149957e-001, 3.149911e-001, 3.149865e-001, 3.149819e-001, 3.149773e-001, 3.149727e-001, 3.149681e-001, 3.149635e-001, 3.149589e-001, 3.149544e-001, 3.149498e-001, 3.149452e-001, 3.149406e-001, 3.149360e-001, 3.149314e-001, 3.149268e-001, 3.149222e-001, 3.149176e-001, 3.149130e-001, 3.149084e-001, 3.149039e-001, 3.148993e-001, 3.148947e-001, 3.148901e-001, 3.148855e-001, 3.148809e-001, 3.148763e-001, 3.148717e-001, 3.148671e-001, 3.148625e-001, 3.148579e-001, 3.148533e-001, 3.148487e-001, 3.148441e-001, 3.148396e-001, 3.148350e-001, 3.148304e-001, 3.148258e-001, 3.148212e-001, 3.148166e-001, 3.148120e-001, 3.148074e-001, 3.148028e-001, 3.147982e-001, 3.147936e-001, 3.147890e-001, 3.147844e-001, 3.147798e-001, 3.147752e-001, 3.147706e-001, 3.147660e-001, 3.147614e-001, 3.147568e-001, 3.147522e-001, 3.147476e-001, 3.147430e-001, 3.147384e-001, 3.147338e-001, 3.147292e-001, 3.147246e-001, 3.147200e-001, 3.147154e-001, 3.147108e-001, 3.147063e-001, 3.147017e-001, 3.146971e-001, 3.146925e-001, 3.146879e-001, 3.146833e-001, 3.146787e-001, 3.146741e-001, 3.146695e-001, 3.146649e-001, 3.146603e-001, 3.146556e-001, 3.146510e-001, 3.146464e-001, 3.146418e-001, 3.146372e-001, 3.146326e-001, 3.146280e-001, 3.146234e-001, 3.146188e-001, 3.146142e-001, 3.146096e-001, 3.146050e-001, 3.146004e-001, 3.145958e-001, 3.145912e-001, 3.145866e-001, 3.145820e-001, 3.145774e-001, 3.145728e-001, 
3.145682e-001, 3.145636e-001, 3.145590e-001, 3.145544e-001, 3.145498e-001, 3.145452e-001, 3.145406e-001, 3.145360e-001, 3.145314e-001, 3.145268e-001, 3.145221e-001, 3.145175e-001, 3.145129e-001, 3.145083e-001, 3.145037e-001, 3.144991e-001, 3.144945e-001, 3.144899e-001, 3.144853e-001, 3.144807e-001, 3.144761e-001, 3.144715e-001, 3.144669e-001, 3.144623e-001, 3.144576e-001, 3.144530e-001, 3.144484e-001, 3.144438e-001, 3.144392e-001, 3.144346e-001, 3.144300e-001, 3.144254e-001, 3.144208e-001, 3.144162e-001, 3.144116e-001, 3.144069e-001, 3.144023e-001, 3.143977e-001, 3.143931e-001, 3.143885e-001, 3.143839e-001, 3.143793e-001, 3.143747e-001, 3.143701e-001, 3.143654e-001, 3.143608e-001, 3.143562e-001, 3.143516e-001, 3.143470e-001, 3.143424e-001, 3.143378e-001, 3.143332e-001, 3.143285e-001, 3.143239e-001, 3.143193e-001, 3.143147e-001, 3.143101e-001, 3.143055e-001, 3.143009e-001, 3.142962e-001, 3.142916e-001, 3.142870e-001, 3.142824e-001, 3.142778e-001, 3.142732e-001, 3.142686e-001, 3.142639e-001, 3.142593e-001, 3.142547e-001, 3.142501e-001, 3.142455e-001, 3.142409e-001, 3.142362e-001, 3.142316e-001, 3.142270e-001, 3.142224e-001, 3.142178e-001, 3.142132e-001, 3.142085e-001, 3.142039e-001, 3.141993e-001, 3.141947e-001, 3.141901e-001, 3.141854e-001, 3.141808e-001, 3.141762e-001, 3.141716e-001, 3.141670e-001, 3.141624e-001, 3.141577e-001, 3.141531e-001, 3.141485e-001, 3.141439e-001, 3.141393e-001, 3.141346e-001, 3.141300e-001, 3.141254e-001, 3.141208e-001, 3.141162e-001, 3.141115e-001, 
3.141069e-001, 3.141023e-001, 3.140977e-001, 3.140930e-001, 3.140884e-001, 3.140838e-001, 3.140792e-001, 3.140746e-001, 3.140699e-001, 3.140653e-001, 3.140607e-001, 3.140561e-001, 3.140514e-001, 3.140468e-001, 3.140422e-001, 3.140376e-001, 3.140329e-001, 3.140283e-001, 3.140237e-001, 3.140191e-001, 3.140144e-001, 3.140098e-001, 3.140052e-001, 3.140006e-001, 3.139959e-001, 3.139913e-001, 3.139867e-001, 3.139821e-001, 3.139774e-001, 3.139728e-001, 3.139682e-001, 3.139636e-001, 3.139589e-001, 3.139543e-001, 3.139497e-001, 3.139451e-001, 3.139404e-001, 3.139358e-001, 3.139312e-001, 3.139265e-001, 3.139219e-001, 3.139173e-001, 3.139127e-001, 3.139080e-001, 3.139034e-001, 3.138988e-001, 3.138941e-001, 3.138895e-001, 3.138849e-001, 3.138803e-001, 3.138756e-001, 3.138710e-001, 3.138664e-001, 3.138617e-001, 3.138571e-001, 3.138525e-001, 3.138478e-001, 3.138432e-001, 3.138386e-001, 3.138339e-001, 3.138293e-001, 3.138247e-001, 3.138200e-001, 3.138154e-001, 3.138108e-001, 3.138062e-001, 3.138015e-001, 3.137969e-001, 3.137923e-001, 3.137876e-001, 3.137830e-001, 3.137784e-001, 3.137737e-001, 3.137691e-001, 3.137645e-001, 3.137598e-001, 3.137552e-001, 3.137505e-001, 3.137459e-001, 3.137413e-001, 3.137366e-001, 3.137320e-001, 3.137274e-001, 3.137227e-001, 3.137181e-001, 3.137135e-001, 3.137088e-001, 3.137042e-001, 3.136996e-001, 3.136949e-001, 3.136903e-001, 3.136856e-001, 3.136810e-001, 3.136764e-001, 3.136717e-001, 3.136671e-001, 3.136625e-001, 3.136578e-001, 3.136532e-001, 3.136485e-001, 
3.136439e-001, 3.136393e-001, 3.136346e-001, 3.136300e-001, 3.136254e-001, 3.136207e-001, 3.136161e-001, 3.136114e-001, 3.136068e-001, 3.136022e-001, 3.135975e-001, 3.135929e-001, 3.135882e-001, 3.135836e-001, 3.135790e-001, 3.135743e-001, 3.135697e-001, 3.135650e-001, 3.135604e-001, 3.135557e-001, 3.135511e-001, 3.135465e-001, 3.135418e-001, 3.135372e-001, 3.135325e-001, 3.135279e-001, 3.135232e-001, 3.135186e-001, 3.135140e-001, 3.135093e-001, 3.135047e-001, 3.135000e-001, 3.134954e-001, 3.134907e-001, 3.134861e-001, 3.134815e-001, 3.134768e-001, 3.134722e-001, 3.134675e-001, 3.134629e-001, 3.134582e-001, 3.134536e-001, 3.134489e-001, 3.134443e-001, 3.134396e-001, 3.134350e-001, 3.134304e-001, 3.134257e-001, 3.134211e-001, 3.134164e-001, 3.134118e-001, 3.134071e-001, 3.134025e-001, 3.133978e-001, 3.133932e-001, 3.133885e-001, 3.133839e-001, 3.133792e-001, 3.133746e-001, 3.133699e-001, 3.133653e-001, 3.133606e-001, 3.133560e-001, 3.133513e-001, 3.133467e-001, 3.133420e-001, 3.133374e-001, 3.133327e-001, 3.133281e-001, 3.133234e-001, 3.133188e-001, 3.133141e-001, 3.133095e-001, 3.133048e-001, 3.133002e-001, 3.132955e-001, 3.132909e-001, 3.132862e-001, 3.132816e-001, 3.132769e-001, 3.132723e-001, 3.132676e-001, 3.132630e-001, 3.132583e-001, 3.132537e-001, 3.132490e-001, 3.132444e-001, 3.132397e-001, 3.132351e-001, 3.132304e-001, 3.132257e-001, 3.132211e-001, 3.132164e-001, 3.132118e-001, 3.132071e-001, 3.132025e-001, 3.131978e-001, 3.131932e-001, 3.131885e-001, 3.131839e-001, 
3.131792e-001, 3.131745e-001, 3.131699e-001, 3.131652e-001, 3.131606e-001, 3.131559e-001, 3.131513e-001, 3.131466e-001, 3.131419e-001, 3.131373e-001, 3.131326e-001, 3.131280e-001, 3.131233e-001, 3.131187e-001, 3.131140e-001, 3.131093e-001, 3.131047e-001, 3.131000e-001, 3.130954e-001, 3.130907e-001, 3.130860e-001, 3.130814e-001, 3.130767e-001, 3.130721e-001, 3.130674e-001, 3.130628e-001, 3.130581e-001, 3.130534e-001, 3.130488e-001, 3.130441e-001, 3.130395e-001, 3.130348e-001, 3.130301e-001, 3.130255e-001, 3.130208e-001, 3.130161e-001, 3.130115e-001, 3.130068e-001, 3.130022e-001, 3.129975e-001, 3.129928e-001, 3.129882e-001, 3.129835e-001, 3.129788e-001, 3.129742e-001, 3.129695e-001, 3.129649e-001, 3.129602e-001, 3.129555e-001, 3.129509e-001, 3.129462e-001, 3.129415e-001, 3.129369e-001, 3.129322e-001, 3.129275e-001, 3.129229e-001, 3.129182e-001, 3.129135e-001, 3.129089e-001, 3.129042e-001, 3.128996e-001, 3.128949e-001, 3.128902e-001, 3.128856e-001, 3.128809e-001, 3.128762e-001, 3.128716e-001, 3.128669e-001, 3.128622e-001, 3.128576e-001, 3.128529e-001, 3.128482e-001, 3.128435e-001, 3.128389e-001, 3.128342e-001, 3.128295e-001, 3.128249e-001, 3.128202e-001, 3.128155e-001, 3.128109e-001, 3.128062e-001, 3.128015e-001, 3.127969e-001, 3.127922e-001, 3.127875e-001, 3.127829e-001, 3.127782e-001, 3.127735e-001, 3.127688e-001, 3.127642e-001, 3.127595e-001, 3.127548e-001, 3.127502e-001, 3.127455e-001, 3.127408e-001, 3.127361e-001, 3.127315e-001, 3.127268e-001, 3.127221e-001, 3.127175e-001, 
3.127128e-001, 3.127081e-001, 3.127034e-001, 3.126988e-001, 3.126941e-001, 3.126894e-001, 3.126847e-001, 3.126801e-001, 3.126754e-001, 3.126707e-001, 3.126660e-001, 3.126614e-001, 3.126567e-001, 3.126520e-001, 3.126473e-001, 3.126427e-001, 3.126380e-001, 3.126333e-001, 3.126286e-001, 3.126240e-001, 3.126193e-001, 3.126146e-001, 3.126099e-001, 3.126053e-001, 3.126006e-001, 3.125959e-001, 3.125912e-001, 3.125866e-001, 3.125819e-001, 3.125772e-001, 3.125725e-001, 3.125678e-001, 3.125632e-001, 3.125585e-001, 3.125538e-001, 3.125491e-001, 3.125445e-001, 3.125398e-001, 3.125351e-001, 3.125304e-001, 3.125257e-001, 3.125211e-001, 3.125164e-001, 3.125117e-001, 3.125070e-001, 3.125023e-001, 3.124977e-001, 3.124930e-001, 3.124883e-001, 3.124836e-001, 3.124789e-001, 3.124743e-001, 3.124696e-001, 3.124649e-001, 3.124602e-001, 3.124555e-001, 3.124508e-001, 3.124462e-001, 3.124415e-001, 3.124368e-001, 3.124321e-001, 3.124274e-001, 3.124227e-001, 3.124181e-001, 3.124134e-001, 3.124087e-001, 3.124040e-001, 3.123993e-001, 3.123946e-001, 3.123900e-001, 3.123853e-001, 3.123806e-001, 3.123759e-001, 3.123712e-001, 3.123665e-001, 3.123618e-001, 3.123572e-001, 3.123525e-001, 3.123478e-001, 3.123431e-001, 3.123384e-001, 3.123337e-001, 3.123290e-001, 3.123244e-001, 3.123197e-001, 3.123150e-001, 3.123103e-001, 3.123056e-001, 3.123009e-001, 3.122962e-001, 3.122915e-001, 3.122869e-001, 3.122822e-001, 3.122775e-001, 3.122728e-001, 3.122681e-001, 3.122634e-001, 3.122587e-001, 3.122540e-001, 3.122493e-001, 
3.122447e-001, 3.122400e-001, 3.122353e-001, 3.122306e-001, 3.122259e-001, 3.122212e-001, 3.122165e-001, 3.122118e-001, 3.122071e-001, 3.122024e-001, 3.121978e-001, 3.121931e-001, 3.121884e-001, 3.121837e-001, 3.121790e-001, 3.121743e-001, 3.121696e-001, 3.121649e-001, 3.121602e-001, 3.121555e-001, 3.121508e-001, 3.121461e-001, 3.121414e-001, 3.121368e-001, 3.121321e-001, 3.121274e-001, 3.121227e-001, 3.121180e-001, 3.121133e-001, 3.121086e-001, 3.121039e-001, 3.120992e-001, 3.120945e-001, 3.120898e-001, 3.120851e-001, 3.120804e-001, 3.120757e-001, 3.120710e-001, 3.120663e-001, 3.120616e-001, 3.120569e-001, 3.120522e-001, 3.120475e-001, 3.120428e-001, 3.120381e-001, 3.120334e-001, 3.120288e-001, 3.120241e-001, 3.120194e-001, 3.120147e-001, 3.120100e-001, 3.120053e-001, 3.120006e-001, 3.119959e-001, 3.119912e-001, 3.119865e-001, 3.119818e-001, 3.119771e-001, 3.119724e-001, 3.119677e-001, 3.119630e-001, 3.119583e-001, 3.119536e-001, 3.119489e-001, 3.119442e-001, 3.119395e-001, 3.119348e-001, 3.119301e-001, 3.119254e-001, 3.119207e-001, 3.119160e-001, 3.119113e-001, 3.119066e-001, 3.119019e-001, 3.118972e-001, 3.118925e-001, 3.118877e-001, 3.118830e-001, 3.118783e-001, 3.118736e-001, 3.118689e-001, 3.118642e-001, 3.118595e-001, 3.118548e-001, 3.118501e-001, 3.118454e-001, 3.118407e-001, 3.118360e-001, 3.118313e-001, 3.118266e-001, 3.118219e-001, 3.118172e-001, 3.118125e-001, 3.118078e-001, 3.118031e-001, 3.117984e-001, 3.117937e-001, 3.117890e-001, 3.117843e-001, 3.117795e-001, 
3.117748e-001, 3.117701e-001, 3.117654e-001, 3.117607e-001, 3.117560e-001, 3.117513e-001, 3.117466e-001, 3.117419e-001, 3.117372e-001, 3.117325e-001, 3.117278e-001, 3.117231e-001, 3.117183e-001, 3.117136e-001, 3.117089e-001, 3.117042e-001, 3.116995e-001, 3.116948e-001, 3.116901e-001, 3.116854e-001, 3.116807e-001, 3.116760e-001, 3.116712e-001, 3.116665e-001, 3.116618e-001, 3.116571e-001, 3.116524e-001, 3.116477e-001, 3.116430e-001, 3.116383e-001, 3.116336e-001, 3.116288e-001, 3.116241e-001, 3.116194e-001, 3.116147e-001, 3.116100e-001, 3.116053e-001, 3.116006e-001, 3.115959e-001, 3.115911e-001, 3.115864e-001, 3.115817e-001, 3.115770e-001, 3.115723e-001, 3.115676e-001, 3.115629e-001, 3.115581e-001, 3.115534e-001, 3.115487e-001, 3.115440e-001, 3.115393e-001, 3.115346e-001, 3.115299e-001, 3.115251e-001, 3.115204e-001, 3.115157e-001, 3.115110e-001, 3.115063e-001, 3.115016e-001, 3.114968e-001, 3.114921e-001, 3.114874e-001, 3.114827e-001, 3.114780e-001, 3.114733e-001, 3.114685e-001, 3.114638e-001, 3.114591e-001, 3.114544e-001, 3.114497e-001, 3.114450e-001, 3.114402e-001, 3.114355e-001, 3.114308e-001, 3.114261e-001, 3.114214e-001, 3.114166e-001, 3.114119e-001, 3.114072e-001, 3.114025e-001, 3.113978e-001, 3.113930e-001, 3.113883e-001, 3.113836e-001, 3.113789e-001, 3.113742e-001, 3.113694e-001, 3.113647e-001, 3.113600e-001, 3.113553e-001, 3.113505e-001, 3.113458e-001, 3.113411e-001, 3.113364e-001, 3.113317e-001, 3.113269e-001, 3.113222e-001, 3.113175e-001, 3.113128e-001, 3.113080e-001, 
3.113033e-001, 3.112986e-001, 3.112939e-001, 3.112891e-001, 3.112844e-001, 3.112797e-001, 3.112750e-001, 3.112702e-001, 3.112655e-001, 3.112608e-001, 3.112561e-001, 3.112513e-001, 3.112466e-001, 3.112419e-001, 3.112372e-001, 3.112324e-001, 3.112277e-001, 3.112230e-001, 3.112183e-001, 3.112135e-001, 3.112088e-001, 3.112041e-001, 3.111994e-001, 3.111946e-001, 3.111899e-001, 3.111852e-001, 3.111804e-001, 3.111757e-001, 3.111710e-001, 3.111663e-001, 3.111615e-001, 3.111568e-001, 3.111521e-001, 3.111473e-001, 3.111426e-001, 3.111379e-001, 3.111332e-001, 3.111284e-001, 3.111237e-001, 3.111190e-001, 3.111142e-001, 3.111095e-001, 3.111048e-001, 3.111000e-001, 3.110953e-001, 3.110906e-001, 3.110858e-001, 3.110811e-001, 3.110764e-001, 3.110717e-001, 3.110669e-001, 3.110622e-001, 3.110575e-001, 3.110527e-001, 3.110480e-001, 3.110433e-001, 3.110385e-001, 3.110338e-001, 3.110291e-001, 3.110243e-001, 3.110196e-001, 3.110149e-001, 3.110101e-001, 3.110054e-001, 3.110007e-001, 3.109959e-001, 3.109912e-001, 3.109865e-001, 3.109817e-001, 3.109770e-001, 3.109722e-001, 3.109675e-001, 3.109628e-001, 3.109580e-001, 3.109533e-001, 3.109486e-001, 3.109438e-001, 3.109391e-001, 3.109344e-001, 3.109296e-001, 3.109249e-001, 3.109201e-001, 3.109154e-001, 3.109107e-001, 3.109059e-001, 3.109012e-001, 3.108965e-001, 3.108917e-001, 3.108870e-001, 3.108822e-001, 3.108775e-001, 3.108728e-001, 3.108680e-001, 3.108633e-001, 3.108585e-001, 3.108538e-001, 3.108491e-001, 3.108443e-001, 3.108396e-001, 3.108348e-001, 
3.108301e-001, 3.108254e-001, 3.108206e-001, 3.108159e-001, 3.108111e-001, 3.108064e-001, 3.108017e-001, 3.107969e-001, 3.107922e-001, 3.107874e-001, 3.107827e-001, 3.107779e-001, 3.107732e-001, 3.107685e-001, 3.107637e-001, 3.107590e-001, 3.107542e-001, 3.107495e-001, 3.107447e-001, 3.107400e-001, 3.107353e-001, 3.107305e-001, 3.107258e-001, 3.107210e-001, 3.107163e-001, 3.107115e-001, 3.107068e-001, 3.107020e-001, 3.106973e-001, 3.106926e-001, 3.106878e-001, 3.106831e-001, 3.106783e-001, 3.106736e-001, 3.106688e-001, 3.106641e-001, 3.106593e-001, 3.106546e-001, 3.106498e-001, 3.106451e-001, 3.106403e-001, 3.106356e-001, 3.106308e-001, 3.106261e-001, 3.106214e-001, 3.106166e-001, 3.106119e-001, 3.106071e-001, 3.106024e-001, 3.105976e-001, 3.105929e-001, 3.105881e-001, 3.105834e-001, 3.105786e-001, 3.105739e-001, 3.105691e-001, 3.105644e-001, 3.105596e-001, 3.105549e-001, 3.105501e-001, 3.105454e-001, 3.105406e-001, 3.105359e-001, 3.105311e-001, 3.105264e-001, 3.105216e-001, 3.105169e-001, 3.105121e-001, 3.105074e-001, 3.105026e-001, 3.104978e-001, 3.104931e-001, 3.104883e-001, 3.104836e-001, 3.104788e-001, 3.104741e-001, 3.104693e-001, 3.104646e-001, 3.104598e-001, 3.104551e-001, 3.104503e-001, 3.104456e-001, 3.104408e-001, 3.104361e-001, 3.104313e-001, 3.104265e-001, 3.104218e-001, 3.104170e-001, 3.104123e-001, 3.104075e-001, 3.104028e-001, 3.103980e-001, 3.103933e-001, 3.103885e-001, 3.103837e-001, 3.103790e-001, 3.103742e-001, 3.103695e-001, 3.103647e-001, 3.103600e-001, 
3.103552e-001, 3.103504e-001, 3.103457e-001, 3.103409e-001, 3.103362e-001, 3.103314e-001, 3.103266e-001, 3.103219e-001, 3.103171e-001, 3.103124e-001, 3.103076e-001, 3.103029e-001, 3.102981e-001, 3.102933e-001, 3.102886e-001, 3.102838e-001, 3.102791e-001, 3.102743e-001, 3.102695e-001, 3.102648e-001, 3.102600e-001, 3.102553e-001, 3.102505e-001, 3.102457e-001, 3.102410e-001, 3.102362e-001, 3.102314e-001, 3.102267e-001, 3.102219e-001, 3.102172e-001, 3.102124e-001, 3.102076e-001, 3.102029e-001, 3.101981e-001, 3.101933e-001, 3.101886e-001, 3.101838e-001, 3.101791e-001, 3.101743e-001, 3.101695e-001, 3.101648e-001, 3.101600e-001, 3.101552e-001, 3.101505e-001, 3.101457e-001, 3.101409e-001, 3.101362e-001, 3.101314e-001, 3.101266e-001, 3.101219e-001, 3.101171e-001, 3.101123e-001, 3.101076e-001, 3.101028e-001, 3.100980e-001, 3.100933e-001, 3.100885e-001, 3.100837e-001, 3.100790e-001, 3.100742e-001, 3.100694e-001, 3.100647e-001, 3.100599e-001, 3.100551e-001, 3.100504e-001, 3.100456e-001, 3.100408e-001, 3.100361e-001, 3.100313e-001, 3.100265e-001, 3.100218e-001, 3.100170e-001, 3.100122e-001, 3.100074e-001, 3.100027e-001, 3.099979e-001, 3.099931e-001, 3.099884e-001, 3.099836e-001, 3.099788e-001, 3.099741e-001, 3.099693e-001, 3.099645e-001, 3.099597e-001, 3.099550e-001, 3.099502e-001, 3.099454e-001, 3.099407e-001, 3.099359e-001, 3.099311e-001, 3.099263e-001, 3.099216e-001, 3.099168e-001, 3.099120e-001, 3.099072e-001, 3.099025e-001, 3.098977e-001, 3.098929e-001, 3.098882e-001, 3.098834e-001, 
3.098786e-001, 3.098738e-001, 3.098691e-001, 3.098643e-001, 3.098595e-001, 3.098547e-001, 3.098500e-001, 3.098452e-001, 3.098404e-001, 3.098356e-001, 3.098308e-001, 3.098261e-001, 3.098213e-001, 3.098165e-001, 3.098117e-001, 3.098070e-001, 3.098022e-001, 3.097974e-001, 3.097926e-001, 3.097879e-001, 3.097831e-001, 3.097783e-001, 3.097735e-001, 3.097687e-001, 3.097640e-001, 3.097592e-001, 3.097544e-001, 3.097496e-001, 3.097449e-001, 3.097401e-001, 3.097353e-001, 3.097305e-001, 3.097257e-001, 3.097210e-001, 3.097162e-001, 3.097114e-001, 3.097066e-001, 3.097018e-001, 3.096971e-001, 3.096923e-001, 3.096875e-001, 3.096827e-001, 3.096779e-001, 3.096731e-001, 3.096684e-001, 3.096636e-001, 3.096588e-001, 3.096540e-001, 3.096492e-001, 3.096445e-001, 3.096397e-001, 3.096349e-001, 3.096301e-001, 3.096253e-001, 3.096205e-001, 3.096158e-001, 3.096110e-001, 3.096062e-001, 3.096014e-001, 3.095966e-001, 3.095918e-001, 3.095871e-001, 3.095823e-001, 3.095775e-001, 3.095727e-001, 3.095679e-001, 3.095631e-001, 3.095583e-001, 3.095536e-001, 3.095488e-001, 3.095440e-001, 3.095392e-001, 3.095344e-001, 3.095296e-001, 3.095248e-001, 3.095200e-001, 3.095153e-001, 3.095105e-001, 3.095057e-001, 3.095009e-001, 3.094961e-001, 3.094913e-001, 3.094865e-001, 3.094817e-001, 3.094770e-001, 3.094722e-001, 3.094674e-001, 3.094626e-001, 3.094578e-001, 3.094530e-001, 3.094482e-001, 3.094434e-001, 3.094386e-001, 3.094339e-001, 3.094291e-001, 3.094243e-001, 3.094195e-001, 3.094147e-001, 3.094099e-001, 3.094051e-001, 
3.094003e-001, 3.093955e-001, 3.093907e-001, 3.093859e-001, 3.093812e-001, 3.093764e-001, 3.093716e-001, 3.093668e-001, 3.093620e-001, 3.093572e-001, 3.093524e-001, 3.093476e-001, 3.093428e-001, 3.093380e-001, 3.093332e-001, 3.093284e-001, 3.093236e-001, 3.093188e-001, 3.093141e-001, 3.093093e-001, 3.093045e-001, 3.092997e-001, 3.092949e-001, 3.092901e-001, 3.092853e-001, 3.092805e-001, 3.092757e-001, 3.092709e-001, 3.092661e-001, 3.092613e-001, 3.092565e-001, 3.092517e-001, 3.092469e-001, 3.092421e-001, 3.092373e-001, 3.092325e-001, 3.092277e-001, 3.092229e-001, 3.092181e-001, 3.092133e-001, 3.092085e-001, 3.092037e-001, 3.091989e-001, 3.091941e-001, 3.091893e-001, 3.091845e-001, 3.091797e-001, 3.091749e-001, 3.091701e-001, 3.091653e-001, 3.091605e-001, 3.091557e-001, 3.091509e-001, 3.091461e-001, 3.091413e-001, 3.091365e-001, 3.091317e-001, 3.091269e-001, 3.091221e-001, 3.091173e-001, 3.091125e-001, 3.091077e-001, 3.091029e-001, 3.090981e-001, 3.090933e-001, 3.090885e-001, 3.090837e-001, 3.090789e-001, 3.090741e-001, 3.090693e-001, 3.090645e-001, 3.090597e-001, 3.090549e-001, 3.090501e-001, 3.090453e-001, 3.090405e-001, 3.090357e-001, 3.090309e-001, 3.090261e-001, 3.090213e-001, 3.090165e-001, 3.090117e-001, 3.090069e-001, 3.090021e-001, 3.089973e-001, 3.089925e-001, 3.089877e-001, 3.089828e-001, 3.089780e-001, 3.089732e-001, 3.089684e-001, 3.089636e-001, 3.089588e-001, 3.089540e-001, 3.089492e-001, 3.089444e-001, 3.089396e-001, 3.089348e-001, 3.089300e-001, 3.089252e-001, 
3.089204e-001, 3.089155e-001, 3.089107e-001, 3.089059e-001, 3.089011e-001, 3.088963e-001, 3.088915e-001, 3.088867e-001, 3.088819e-001, 3.088771e-001, 3.088723e-001, 3.088675e-001, 3.088626e-001, 3.088578e-001, 3.088530e-001, 3.088482e-001, 3.088434e-001, 3.088386e-001, 3.088338e-001, 3.088290e-001, 3.088242e-001, 3.088193e-001, 3.088145e-001, 3.088097e-001, 3.088049e-001, 3.088001e-001, 3.087953e-001, 3.087905e-001, 3.087857e-001, 3.087809e-001, 3.087760e-001, 3.087712e-001, 3.087664e-001, 3.087616e-001, 3.087568e-001, 3.087520e-001, 3.087472e-001, 3.087423e-001, 3.087375e-001, 3.087327e-001, 3.087279e-001, 3.087231e-001, 3.087183e-001, 3.087135e-001, 3.087086e-001, 3.087038e-001, 3.086990e-001, 3.086942e-001, 3.086894e-001, 3.086846e-001, 3.086797e-001, 3.086749e-001, 3.086701e-001, 3.086653e-001, 3.086605e-001, 3.086557e-001, 3.086508e-001, 3.086460e-001, 3.086412e-001, 3.086364e-001, 3.086316e-001, 3.086268e-001, 3.086219e-001, 3.086171e-001, 3.086123e-001, 3.086075e-001, 3.086027e-001, 3.085978e-001, 3.085930e-001, 3.085882e-001, 3.085834e-001, 3.085786e-001, 3.085737e-001, 3.085689e-001, 3.085641e-001, 3.085593e-001, 3.085545e-001, 3.085496e-001, 3.085448e-001, 3.085400e-001, 3.085352e-001, 3.085304e-001, 3.085255e-001, 3.085207e-001, 3.085159e-001, 3.085111e-001, 3.085062e-001, 3.085014e-001, 3.084966e-001, 3.084918e-001, 3.084869e-001, 3.084821e-001, 3.084773e-001, 3.084725e-001, 3.084677e-001, 3.084628e-001, 3.084580e-001, 3.084532e-001, 3.084484e-001, 3.084435e-001, 
3.084387e-001, 3.084339e-001, 3.084291e-001, 3.084242e-001, 3.084194e-001, 3.084146e-001, 3.084098e-001, 3.084049e-001, 3.084001e-001, 3.083953e-001, 3.083905e-001, 3.083856e-001, 3.083808e-001, 3.083760e-001, 3.083711e-001, 3.083663e-001, 3.083615e-001, 3.083567e-001, 3.083518e-001, 3.083470e-001, 3.083422e-001, 3.083373e-001, 3.083325e-001, 3.083277e-001, 3.083229e-001, 3.083180e-001, 3.083132e-001, 3.083084e-001, 3.083035e-001, 3.082987e-001, 3.082939e-001, 3.082891e-001, 3.082842e-001, 3.082794e-001, 3.082746e-001, 3.082697e-001, 3.082649e-001, 3.082601e-001, 3.082552e-001, 3.082504e-001, 3.082456e-001, 3.082407e-001, 3.082359e-001, 3.082311e-001, 3.082263e-001, 3.082214e-001, 3.082166e-001, 3.082118e-001, 3.082069e-001, 3.082021e-001, 3.081973e-001, 3.081924e-001, 3.081876e-001, 3.081828e-001, 3.081779e-001, 3.081731e-001, 3.081683e-001, 3.081634e-001, 3.081586e-001, 3.081538e-001, 3.081489e-001, 3.081441e-001, 3.081392e-001, 3.081344e-001, 3.081296e-001, 3.081247e-001, 3.081199e-001, 3.081151e-001, 3.081102e-001, 3.081054e-001, 3.081006e-001, 3.080957e-001, 3.080909e-001, 3.080860e-001, 3.080812e-001, 3.080764e-001, 3.080715e-001, 3.080667e-001, 3.080619e-001, 3.080570e-001, 3.080522e-001, 3.080473e-001, 3.080425e-001, 3.080377e-001, 3.080328e-001, 3.080280e-001, 3.080232e-001, 3.080183e-001, 3.080135e-001, 3.080086e-001, 3.080038e-001, 3.079990e-001, 3.079941e-001, 3.079893e-001, 3.079844e-001, 3.079796e-001, 3.079747e-001, 3.079699e-001, 3.079651e-001, 3.079602e-001, 
3.079554e-001, 3.079505e-001, 3.079457e-001, 3.079409e-001, 3.079360e-001, 3.079312e-001, 3.079263e-001, 3.079215e-001, 3.079166e-001, 3.079118e-001, 3.079070e-001, 3.079021e-001, 3.078973e-001, 3.078924e-001, 3.078876e-001, 3.078827e-001, 3.078779e-001, 3.078731e-001, 3.078682e-001, 3.078634e-001, 3.078585e-001, 3.078537e-001, 3.078488e-001, 3.078440e-001, 3.078391e-001, 3.078343e-001, 3.078294e-001, 3.078246e-001, 3.078198e-001, 3.078149e-001, 3.078101e-001, 3.078052e-001, 3.078004e-001, 3.077955e-001, 3.077907e-001, 3.077858e-001, 3.077810e-001, 3.077761e-001, 3.077713e-001, 3.077664e-001, 3.077616e-001, 3.077567e-001, 3.077519e-001, 3.077470e-001, 3.077422e-001, 3.077373e-001, 3.077325e-001, 3.077276e-001, 3.077228e-001, 3.077179e-001, 3.077131e-001, 3.077082e-001, 3.077034e-001, 3.076985e-001, 3.076937e-001, 3.076888e-001, 3.076840e-001, 3.076791e-001, 3.076743e-001, 3.076694e-001, 3.076646e-001, 3.076597e-001, 3.076549e-001, 3.076500e-001, 3.076452e-001, 3.076403e-001, 3.076355e-001, 3.076306e-001, 3.076258e-001, 3.076209e-001, 3.076161e-001, 3.076112e-001, 3.076064e-001, 3.076015e-001, 3.075966e-001, 3.075918e-001, 3.075869e-001, 3.075821e-001, 3.075772e-001, 3.075724e-001, 3.075675e-001, 3.075627e-001, 3.075578e-001, 3.075530e-001, 3.075481e-001, 3.075432e-001, 3.075384e-001, 3.075335e-001, 3.075287e-001, 3.075238e-001, 3.075190e-001, 3.075141e-001, 3.075092e-001, 3.075044e-001, 3.074995e-001, 3.074947e-001, 3.074898e-001, 3.074850e-001, 3.074801e-001, 3.074752e-001, 
3.074704e-001, 3.074655e-001, 3.074607e-001, 3.074558e-001, 3.074510e-001, 3.074461e-001, 3.074412e-001, 3.074364e-001, 3.074315e-001, 3.074267e-001, 3.074218e-001, 3.074169e-001, 3.074121e-001, 3.074072e-001, 3.074024e-001, 3.073975e-001, 3.073926e-001, 3.073878e-001, 3.073829e-001, 3.073780e-001, 3.073732e-001, 3.073683e-001, 3.073635e-001, 3.073586e-001, 3.073537e-001, 3.073489e-001, 3.073440e-001, 3.073391e-001, 3.073343e-001, 3.073294e-001, 3.073246e-001, 3.073197e-001, 3.073148e-001, 3.073100e-001, 3.073051e-001, 3.073002e-001, 3.072954e-001, 3.072905e-001, 3.072856e-001, 3.072808e-001, 3.072759e-001, 3.072711e-001, 3.072662e-001, 3.072613e-001, 3.072565e-001, 3.072516e-001, 3.072467e-001, 3.072419e-001, 3.072370e-001, 3.072321e-001, 3.072273e-001, 3.072224e-001, 3.072175e-001, 3.072127e-001, 3.072078e-001, 3.072029e-001, 3.071981e-001, 3.071932e-001, 3.071883e-001, 3.071835e-001, 3.071786e-001, 3.071737e-001, 3.071688e-001, 3.071640e-001, 3.071591e-001, 3.071542e-001, 3.071494e-001, 3.071445e-001, 3.071396e-001, 3.071348e-001, 3.071299e-001, 3.071250e-001, 3.071202e-001, 3.071153e-001, 3.071104e-001, 3.071055e-001, 3.071007e-001, 3.070958e-001, 3.070909e-001, 3.070861e-001, 3.070812e-001, 3.070763e-001, 3.070714e-001, 3.070666e-001, 3.070617e-001, 3.070568e-001, 3.070519e-001, 3.070471e-001, 3.070422e-001, 3.070373e-001, 3.070325e-001, 3.070276e-001, 3.070227e-001, 3.070178e-001, 3.070130e-001, 3.070081e-001, 3.070032e-001, 3.069983e-001, 3.069935e-001, 3.069886e-001, 
3.069837e-001, 3.069788e-001, 3.069740e-001, 3.069691e-001, 3.069642e-001, 3.069593e-001, 3.069545e-001, 3.069496e-001, 3.069447e-001, 3.069398e-001, 3.069350e-001, 3.069301e-001, 3.069252e-001, 3.069203e-001, 3.069154e-001, 3.069106e-001, 3.069057e-001, 3.069008e-001, 3.068959e-001, 3.068911e-001, 3.068862e-001, 3.068813e-001, 3.068764e-001, 3.068715e-001, 3.068667e-001, 3.068618e-001, 3.068569e-001, 3.068520e-001, 3.068471e-001, 3.068423e-001, 3.068374e-001, 3.068325e-001, 3.068276e-001, 3.068227e-001, 3.068179e-001, 3.068130e-001, 3.068081e-001, 3.068032e-001, 3.067983e-001, 3.067935e-001, 3.067886e-001, 3.067837e-001, 3.067788e-001, 3.067739e-001, 3.067691e-001, 3.067642e-001, 3.067593e-001, 3.067544e-001, 3.067495e-001, 3.067446e-001, 3.067398e-001, 3.067349e-001, 3.067300e-001, 3.067251e-001, 3.067202e-001, 3.067153e-001, 3.067104e-001, 3.067056e-001, 3.067007e-001, 3.066958e-001, 3.066909e-001, 3.066860e-001, 3.066811e-001, 3.066763e-001, 3.066714e-001, 3.066665e-001, 3.066616e-001, 3.066567e-001, 3.066518e-001, 3.066469e-001, 3.066421e-001, 3.066372e-001, 3.066323e-001, 3.066274e-001, 3.066225e-001, 3.066176e-001, 3.066127e-001, 3.066078e-001, 3.066030e-001, 3.065981e-001, 3.065932e-001, 3.065883e-001, 3.065834e-001, 3.065785e-001, 3.065736e-001, 3.065687e-001, 3.065638e-001, 3.065590e-001, 3.065541e-001, 3.065492e-001, 3.065443e-001, 3.065394e-001, 3.065345e-001, 3.065296e-001, 3.065247e-001, 3.065198e-001, 3.065149e-001, 3.065100e-001, 3.065052e-001, 3.065003e-001, 
3.064954e-001, 3.064905e-001, 3.064856e-001, 3.064807e-001, 3.064758e-001, 3.064709e-001, 3.064660e-001, 3.064611e-001, 3.064562e-001, 3.064513e-001, 3.064464e-001, 3.064416e-001, 3.064367e-001, 3.064318e-001, 3.064269e-001, 3.064220e-001, 3.064171e-001, 3.064122e-001, 3.064073e-001, 3.064024e-001, 3.063975e-001, 3.063926e-001, 3.063877e-001, 3.063828e-001, 3.063779e-001, 3.063730e-001, 3.063681e-001, 3.063632e-001, 3.063583e-001, 3.063534e-001, 3.063485e-001, 3.063437e-001, 3.063388e-001, 3.063339e-001, 3.063290e-001, 3.063241e-001, 3.063192e-001, 3.063143e-001, 3.063094e-001, 3.063045e-001, 3.062996e-001, 3.062947e-001, 3.062898e-001, 3.062849e-001, 3.062800e-001, 3.062751e-001, 3.062702e-001, 3.062653e-001, 3.062604e-001, 3.062555e-001, 3.062506e-001, 3.062457e-001, 3.062408e-001, 3.062359e-001, 3.062310e-001, 3.062261e-001, 3.062212e-001, 3.062163e-001, 3.062114e-001, 3.062065e-001, 3.062016e-001, 3.061967e-001, 3.061918e-001, 3.061869e-001, 3.061820e-001, 3.061771e-001, 3.061722e-001, 3.061673e-001, 3.061624e-001, 3.061574e-001, 3.061525e-001, 3.061476e-001, 3.061427e-001, 3.061378e-001, 3.061329e-001, 3.061280e-001, 3.061231e-001, 3.061182e-001, 3.061133e-001, 3.061084e-001, 3.061035e-001, 3.060986e-001, 3.060937e-001, 3.060888e-001, 3.060839e-001, 3.060790e-001, 3.060741e-001, 3.060692e-001, 3.060643e-001, 3.060593e-001, 3.060544e-001, 3.060495e-001, 3.060446e-001, 3.060397e-001, 3.060348e-001, 3.060299e-001, 3.060250e-001, 3.060201e-001, 3.060152e-001, 3.060103e-001, 
3.060054e-001, 3.060005e-001, 3.059955e-001, 3.059906e-001, 3.059857e-001, 3.059808e-001, 3.059759e-001, 3.059710e-001, 3.059661e-001, 3.059612e-001, 3.059563e-001, 3.059514e-001, 3.059465e-001, 3.059415e-001, 3.059366e-001, 3.059317e-001, 3.059268e-001, 3.059219e-001, 3.059170e-001, 3.059121e-001, 3.059072e-001, 3.059023e-001, 3.058973e-001, 3.058924e-001, 3.058875e-001, 3.058826e-001, 3.058777e-001, 3.058728e-001, 3.058679e-001, 3.058630e-001, 3.058580e-001, 3.058531e-001, 3.058482e-001, 3.058433e-001, 3.058384e-001, 3.058335e-001, 3.058286e-001, 3.058236e-001, 3.058187e-001, 3.058138e-001, 3.058089e-001, 3.058040e-001, 3.057991e-001, 3.057942e-001, 3.057892e-001, 3.057843e-001, 3.057794e-001, 3.057745e-001, 3.057696e-001, 3.057647e-001, 3.057597e-001, 3.057548e-001, 3.057499e-001, 3.057450e-001, 3.057401e-001, 3.057352e-001, 3.057302e-001, 3.057253e-001, 3.057204e-001, 3.057155e-001, 3.057106e-001, 3.057056e-001, 3.057007e-001, 3.056958e-001, 3.056909e-001, 3.056860e-001, 3.056811e-001, 3.056761e-001, 3.056712e-001, 3.056663e-001, 3.056614e-001, 3.056565e-001, 3.056515e-001, 3.056466e-001, 3.056417e-001, 3.056368e-001, 3.056318e-001, 3.056269e-001, 3.056220e-001, 3.056171e-001, 3.056122e-001, 3.056072e-001, 3.056023e-001, 3.055974e-001, 3.055925e-001, 3.055876e-001, 3.055826e-001, 3.055777e-001, 3.055728e-001, 3.055679e-001, 3.055629e-001, 3.055580e-001, 3.055531e-001, 3.055482e-001, 3.055432e-001, 3.055383e-001, 3.055334e-001, 3.055285e-001, 3.055235e-001, 3.055186e-001, 
3.055137e-001, 3.055088e-001, 3.055038e-001, 3.054989e-001, 3.054940e-001, 3.054891e-001, 3.054841e-001, 3.054792e-001, 3.054743e-001, 3.054694e-001, 3.054644e-001, 3.054595e-001, 3.054546e-001, 3.054497e-001, 3.054447e-001, 3.054398e-001, 3.054349e-001, 3.054299e-001, 3.054250e-001, 3.054201e-001, 3.054152e-001, 3.054102e-001, 3.054053e-001, 3.054004e-001, 3.053954e-001, 3.053905e-001, 3.053856e-001, 3.053807e-001, 3.053757e-001, 3.053708e-001, 3.053659e-001, 3.053609e-001, 3.053560e-001, 3.053511e-001, 3.053461e-001, 3.053412e-001, 3.053363e-001, 3.053314e-001, 3.053264e-001, 3.053215e-001, 3.053166e-001, 3.053116e-001, 3.053067e-001, 3.053018e-001, 3.052968e-001, 3.052919e-001, 3.052870e-001, 3.052820e-001, 3.052771e-001, 3.052722e-001, 3.052672e-001, 3.052623e-001, 3.052574e-001, 3.052524e-001, 3.052475e-001, 3.052426e-001, 3.052376e-001, 3.052327e-001, 3.052278e-001, 3.052228e-001, 3.052179e-001, 3.052130e-001, 3.052080e-001, 3.052031e-001, 3.051982e-001, 3.051932e-001, 3.051883e-001, 3.051833e-001, 3.051784e-001, 3.051735e-001, 3.051685e-001, 3.051636e-001, 3.051587e-001, 3.051537e-001, 3.051488e-001, 3.051439e-001, 3.051389e-001, 3.051340e-001, 3.051290e-001, 3.051241e-001, 3.051192e-001, 3.051142e-001, 3.051093e-001, 3.051043e-001, 3.050994e-001, 3.050945e-001, 3.050895e-001, 3.050846e-001, 3.050797e-001, 3.050747e-001, 3.050698e-001, 3.050648e-001, 3.050599e-001, 3.050550e-001, 3.050500e-001, 3.050451e-001, 3.050401e-001, 3.050352e-001, 3.050302e-001, 3.050253e-001, 
3.050204e-001, 3.050154e-001, 3.050105e-001, 3.050055e-001, 3.050006e-001, 3.049957e-001, 3.049907e-001, 3.049858e-001, 3.049808e-001, 3.049759e-001, 3.049709e-001, 3.049660e-001, 3.049611e-001, 3.049561e-001, 3.049512e-001, 3.049462e-001, 3.049413e-001, 3.049363e-001, 3.049314e-001, 3.049264e-001, 3.049215e-001, 3.049166e-001, 3.049116e-001, 3.049067e-001, 3.049017e-001, 3.048968e-001, 3.048918e-001, 3.048869e-001, 3.048819e-001, 3.048770e-001, 3.048720e-001, 3.048671e-001, 3.048621e-001, 3.048572e-001, 3.048523e-001, 3.048473e-001, 3.048424e-001, 3.048374e-001, 3.048325e-001, 3.048275e-001, 3.048226e-001, 3.048176e-001, 3.048127e-001, 3.048077e-001, 3.048028e-001, 3.047978e-001, 3.047929e-001, 3.047879e-001, 3.047830e-001, 3.047780e-001, 3.047731e-001, 3.047681e-001, 3.047632e-001, 3.047582e-001, 3.047533e-001, 3.047483e-001, 3.047434e-001, 3.047384e-001, 3.047335e-001, 3.047285e-001, 3.047236e-001, 3.047186e-001, 3.047137e-001, 3.047087e-001, 3.047038e-001, 3.046988e-001, 3.046939e-001, 3.046889e-001, 3.046840e-001, 3.046790e-001, 3.046740e-001, 3.046691e-001, 3.046641e-001, 3.046592e-001, 3.046542e-001, 3.046493e-001, 3.046443e-001, 3.046394e-001, 3.046344e-001, 3.046295e-001, 3.046245e-001, 3.046195e-001, 3.046146e-001, 3.046096e-001, 3.046047e-001, 3.045997e-001, 3.045948e-001, 3.045898e-001, 3.045849e-001, 3.045799e-001, 3.045749e-001, 3.045700e-001, 3.045650e-001, 3.045601e-001, 3.045551e-001, 3.045502e-001, 3.045452e-001, 3.045402e-001, 3.045353e-001, 3.045303e-001, 
3.045254e-001, 3.045204e-001, 3.045155e-001, 3.045105e-001, 3.045055e-001, 3.045006e-001, 3.044956e-001, 3.044907e-001, 3.044857e-001, 3.044807e-001, 3.044758e-001, 3.044708e-001, 3.044659e-001, 3.044609e-001, 3.044559e-001, 3.044510e-001, 3.044460e-001, 3.044411e-001, 3.044361e-001, 3.044311e-001, 3.044262e-001, 3.044212e-001, 3.044163e-001, 3.044113e-001, 3.044063e-001, 3.044014e-001, 3.043964e-001, 3.043914e-001, 3.043865e-001, 3.043815e-001, 3.043766e-001, 3.043716e-001, 3.043666e-001, 3.043617e-001, 3.043567e-001, 3.043517e-001, 3.043468e-001, 3.043418e-001, 3.043368e-001, 3.043319e-001, 3.043269e-001, 3.043219e-001, 3.043170e-001, 3.043120e-001, 3.043071e-001, 3.043021e-001, 3.042971e-001, 3.042922e-001, 3.042872e-001, 3.042822e-001, 3.042773e-001, 3.042723e-001, 3.042673e-001, 3.042624e-001, 3.042574e-001, 3.042524e-001, 3.042475e-001, 3.042425e-001, 3.042375e-001, 3.042326e-001, 3.042276e-001, 3.042226e-001, 3.042176e-001, 3.042127e-001, 3.042077e-001, 3.042027e-001, 3.041978e-001, 3.041928e-001, 3.041878e-001, 3.041829e-001, 3.041779e-001, 3.041729e-001, 3.041680e-001, 3.041630e-001, 3.041580e-001, 3.041530e-001, 3.041481e-001, 3.041431e-001, 3.041381e-001, 3.041332e-001, 3.041282e-001, 3.041232e-001, 3.041182e-001, 3.041133e-001, 3.041083e-001, 3.041033e-001, 3.040984e-001, 3.040934e-001, 3.040884e-001, 3.040834e-001, 3.040785e-001, 3.040735e-001, 3.040685e-001, 3.040635e-001, 3.040586e-001, 3.040536e-001, 3.040486e-001, 3.040437e-001, 3.040387e-001, 3.040337e-001, 
3.040287e-001, 3.040238e-001, 3.040188e-001, 3.040138e-001, 3.040088e-001, 3.040039e-001, 3.039989e-001, 3.039939e-001, 3.039889e-001, 3.039839e-001, 3.039790e-001, 3.039740e-001, 3.039690e-001, 3.039640e-001, 3.039591e-001, 3.039541e-001, 3.039491e-001, 3.039441e-001, 3.039392e-001, 3.039342e-001, 3.039292e-001, 3.039242e-001, 3.039192e-001, 3.039143e-001, 3.039093e-001, 3.039043e-001, 3.038993e-001, 3.038943e-001, 3.038894e-001, 3.038844e-001, 3.038794e-001, 3.038744e-001, 3.038695e-001, 3.038645e-001, 3.038595e-001, 3.038545e-001, 3.038495e-001, 3.038445e-001, 3.038396e-001, 3.038346e-001, 3.038296e-001, 3.038246e-001, 3.038196e-001, 3.038147e-001, 3.038097e-001, 3.038047e-001, 3.037997e-001, 3.037947e-001, 3.037897e-001, 3.037848e-001, 3.037798e-001, 3.037748e-001, 3.037698e-001, 3.037648e-001, 3.037599e-001, 3.037549e-001, 3.037499e-001, 3.037449e-001, 3.037399e-001, 3.037349e-001, 3.037299e-001, 3.037250e-001, 3.037200e-001, 3.037150e-001, 3.037100e-001, 3.037050e-001, 3.037000e-001, 3.036950e-001, 3.036901e-001, 3.036851e-001, 3.036801e-001, 3.036751e-001, 3.036701e-001, 3.036651e-001, 3.036601e-001, 3.036552e-001, 3.036502e-001, 3.036452e-001, 3.036402e-001, 3.036352e-001, 3.036302e-001, 3.036252e-001, 3.036202e-001, 3.036153e-001, 3.036103e-001, 3.036053e-001, 3.036003e-001, 3.035953e-001, 3.035903e-001, 3.035853e-001, 3.035803e-001, 3.035753e-001, 3.035704e-001, 3.035654e-001, 3.035604e-001, 3.035554e-001, 3.035504e-001, 3.035454e-001, 3.035404e-001, 3.035354e-001, 
3.035304e-001, 3.035254e-001, 3.035204e-001, 3.035155e-001, 3.035105e-001, 3.035055e-001, 3.035005e-001, 3.034955e-001, 3.034905e-001, 3.034855e-001, 3.034805e-001, 3.034755e-001, 3.034705e-001, 3.034655e-001, 3.034605e-001, 3.034555e-001, 3.034505e-001, 3.034456e-001, 3.034406e-001, 3.034356e-001, 3.034306e-001, 3.034256e-001, 3.034206e-001, 3.034156e-001, 3.034106e-001, 3.034056e-001, 3.034006e-001, 3.033956e-001, 3.033906e-001, 3.033856e-001, 3.033806e-001, 3.033756e-001, 3.033706e-001, 3.033656e-001, 3.033606e-001, 3.033556e-001, 3.033506e-001, 3.033456e-001, 3.033406e-001, 3.033356e-001, 3.033306e-001, 3.033256e-001, 3.033206e-001, 3.033157e-001, 3.033107e-001, 3.033057e-001, 3.033007e-001, 3.032957e-001, 3.032907e-001, 3.032857e-001, 3.032807e-001, 3.032757e-001, 3.032707e-001, 3.032657e-001, 3.032607e-001, 3.032557e-001, 3.032507e-001, 3.032457e-001, 3.032407e-001, 3.032357e-001, 3.032307e-001, 3.032257e-001, 3.032207e-001, 3.032157e-001, 3.032106e-001, 3.032056e-001, 3.032006e-001, 3.031956e-001, 3.031906e-001, 3.031856e-001, 3.031806e-001, 3.031756e-001, 3.031706e-001, 3.031656e-001, 3.031606e-001, 3.031556e-001, 3.031506e-001, 3.031456e-001, 3.031406e-001, 3.031356e-001, 3.031306e-001, 3.031256e-001, 3.031206e-001, 3.031156e-001, 3.031106e-001, 3.031056e-001, 3.031006e-001, 3.030956e-001, 3.030906e-001, 3.030856e-001, 3.030805e-001, 3.030755e-001, 3.030705e-001, 3.030655e-001, 3.030605e-001, 3.030555e-001, 3.030505e-001, 3.030455e-001, 3.030405e-001, 3.030355e-001, 
3.030305e-001, 3.030255e-001, 3.030205e-001, 3.030155e-001, 3.030104e-001, 3.030054e-001, 3.030004e-001, 3.029954e-001, 3.029904e-001, 3.029854e-001, 3.029804e-001, 3.029754e-001, 3.029704e-001, 3.029654e-001, 3.029604e-001, 3.029553e-001, 3.029503e-001, 3.029453e-001, 3.029403e-001, 3.029353e-001, 3.029303e-001, 3.029253e-001, 3.029203e-001, 3.029153e-001, 3.029102e-001, 3.029052e-001, 3.029002e-001, 3.028952e-001, 3.028902e-001, 3.028852e-001, 3.028802e-001, 3.028752e-001, 3.028701e-001, 3.028651e-001, 3.028601e-001, 3.028551e-001, 3.028501e-001, 3.028451e-001, 3.028401e-001, 3.028351e-001, 3.028300e-001, 3.028250e-001, 3.028200e-001, 3.028150e-001, 3.028100e-001, 3.028050e-001, 3.027999e-001, 3.027949e-001, 3.027899e-001, 3.027849e-001, 3.027799e-001, 3.027749e-001, 3.027699e-001, 3.027648e-001, 3.027598e-001, 3.027548e-001, 3.027498e-001, 3.027448e-001, 3.027398e-001, 3.027347e-001, 3.027297e-001, 3.027247e-001, 3.027197e-001, 3.027147e-001, 3.027096e-001, 3.027046e-001, 3.026996e-001, 3.026946e-001, 3.026896e-001, 3.026846e-001, 3.026795e-001, 3.026745e-001, 3.026695e-001, 3.026645e-001, 3.026595e-001, 3.026544e-001, 3.026494e-001, 3.026444e-001, 3.026394e-001, 3.026344e-001, 3.026293e-001, 3.026243e-001, 3.026193e-001, 3.026143e-001, 3.026092e-001, 3.026042e-001, 3.025992e-001, 3.025942e-001, 3.025892e-001, 3.025841e-001, 3.025791e-001, 3.025741e-001, 3.025691e-001, 3.025640e-001, 3.025590e-001, 3.025540e-001, 3.025490e-001, 3.025440e-001, 3.025389e-001, 3.025339e-001, 
3.025289e-001, 3.025239e-001, 3.025188e-001, 3.025138e-001, 3.025088e-001, 3.025038e-001, 3.024987e-001, 3.024937e-001, 3.024887e-001, 3.024837e-001, 3.024786e-001, 3.024736e-001, 3.024686e-001, 3.024636e-001, 3.024585e-001, 3.024535e-001, 3.024485e-001, 3.024434e-001, 3.024384e-001, 3.024334e-001, 3.024284e-001, 3.024233e-001, 3.024183e-001, 3.024133e-001, 3.024083e-001, 3.024032e-001, 3.023982e-001, 3.023932e-001, 3.023881e-001, 3.023831e-001, 3.023781e-001, 3.023731e-001, 3.023680e-001, 3.023630e-001, 3.023580e-001, 3.023529e-001, 3.023479e-001, 3.023429e-001, 3.023378e-001, 3.023328e-001, 3.023278e-001, 3.023228e-001, 3.023177e-001, 3.023127e-001, 3.023077e-001, 3.023026e-001, 3.022976e-001, 3.022926e-001, 3.022875e-001, 3.022825e-001, 3.022775e-001, 3.022724e-001, 3.022674e-001, 3.022624e-001, 3.022573e-001, 3.022523e-001, 3.022473e-001, 3.022422e-001, 3.022372e-001, 3.022322e-001, 3.022271e-001, 3.022221e-001, 3.022171e-001, 3.022120e-001, 3.022070e-001, 3.022020e-001, 3.021969e-001, 3.021919e-001, 3.021869e-001, 3.021818e-001, 3.021768e-001, 3.021717e-001, 3.021667e-001, 3.021617e-001, 3.021566e-001, 3.021516e-001, 3.021466e-001, 3.021415e-001, 3.021365e-001, 3.021315e-001, 3.021264e-001, 3.021214e-001, 3.021163e-001, 3.021113e-001, 3.021063e-001, 3.021012e-001, 3.020962e-001, 3.020912e-001, 3.020861e-001, 3.020811e-001, 3.020760e-001, 3.020710e-001, 3.020660e-001, 3.020609e-001, 3.020559e-001, 3.020508e-001, 3.020458e-001, 3.020408e-001, 3.020357e-001, 3.020307e-001, 
3.020256e-001, 3.020206e-001, 3.020156e-001, 3.020105e-001, 3.020055e-001, 3.020004e-001, 3.019954e-001, 3.019904e-001, 3.019853e-001, 3.019803e-001, 3.019752e-001, 3.019702e-001, 3.019651e-001, 3.019601e-001, 3.019551e-001, 3.019500e-001, 3.019450e-001, 3.019399e-001, 3.019349e-001, 3.019298e-001, 3.019248e-001, 3.019198e-001, 3.019147e-001, 3.019097e-001, 3.019046e-001, 3.018996e-001, 3.018945e-001, 3.018895e-001, 3.018844e-001, 3.018794e-001, 3.018743e-001, 3.018693e-001, 3.018643e-001, 3.018592e-001, 3.018542e-001, 3.018491e-001, 3.018441e-001, 3.018390e-001, 3.018340e-001, 3.018289e-001, 3.018239e-001, 3.018188e-001, 3.018138e-001, 3.018087e-001, 3.018037e-001, 3.017986e-001, 3.017936e-001, 3.017885e-001, 3.017835e-001, 3.017785e-001, 3.017734e-001, 3.017684e-001, 3.017633e-001, 3.017583e-001, 3.017532e-001, 3.017482e-001, 3.017431e-001, 3.017381e-001, 3.017330e-001, 3.017280e-001, 3.017229e-001, 3.017179e-001, 3.017128e-001, 3.017078e-001, 3.017027e-001, 3.016977e-001, 3.016926e-001, 3.016875e-001, 3.016825e-001, 3.016774e-001, 3.016724e-001, 3.016673e-001, 3.016623e-001, 3.016572e-001, 3.016522e-001, 3.016471e-001, 3.016421e-001, 3.016370e-001, 3.016320e-001, 3.016269e-001, 3.016219e-001, 3.016168e-001, 3.016118e-001, 3.016067e-001, 3.016016e-001, 3.015966e-001, 3.015915e-001, 3.015865e-001, 3.015814e-001, 3.015764e-001, 3.015713e-001, 3.015663e-001, 3.015612e-001, 3.015562e-001, 3.015511e-001, 3.015460e-001, 3.015410e-001, 3.015359e-001, 3.015309e-001, 3.015258e-001, 
3.015208e-001, 3.015157e-001, 3.015106e-001, 3.015056e-001, 3.015005e-001, 3.014955e-001, 3.014904e-001, 3.014854e-001, 3.014803e-001, 3.014752e-001, 3.014702e-001, 3.014651e-001, 3.014601e-001, 3.014550e-001, 3.014499e-001, 3.014449e-001, 3.014398e-001, 3.014348e-001, 3.014297e-001, 3.014246e-001, 3.014196e-001, 3.014145e-001, 3.014095e-001, 3.014044e-001, 3.013993e-001, 3.013943e-001, 3.013892e-001, 3.013842e-001, 3.013791e-001, 3.013740e-001, 3.013690e-001, 3.013639e-001, 3.013588e-001, 3.013538e-001, 3.013487e-001, 3.013437e-001, 3.013386e-001, 3.013335e-001, 3.013285e-001, 3.013234e-001, 3.013183e-001, 3.013133e-001, 3.013082e-001, 3.013032e-001, 3.012981e-001, 3.012930e-001, 3.012880e-001, 3.012829e-001, 3.012778e-001, 3.012728e-001, 3.012677e-001, 3.012626e-001, 3.012576e-001, 3.012525e-001, 3.012474e-001, 3.012424e-001, 3.012373e-001, 3.012322e-001, 3.012272e-001, 3.012221e-001, 3.012170e-001, 3.012120e-001, 3.012069e-001, 3.012018e-001, 3.011968e-001, 3.011917e-001, 3.011866e-001, 3.011816e-001, 3.011765e-001, 3.011714e-001, 3.011664e-001, 3.011613e-001, 3.011562e-001, 3.011512e-001, 3.011461e-001, 3.011410e-001, 3.011359e-001, 3.011309e-001, 3.011258e-001, 3.011207e-001, 3.011157e-001, 3.011106e-001, 3.011055e-001, 3.011005e-001, 3.010954e-001, 3.010903e-001, 3.010852e-001, 3.010802e-001, 3.010751e-001, 3.010700e-001, 3.010650e-001, 3.010599e-001, 3.010548e-001, 3.010497e-001, 3.010447e-001, 3.010396e-001, 3.010345e-001, 3.010295e-001, 3.010244e-001, 3.010193e-001, 
3.010142e-001, 3.010092e-001, 3.010041e-001, 3.009990e-001, 3.009939e-001, 3.009889e-001, 3.009838e-001, 3.009787e-001, 3.009736e-001, 3.009686e-001, 3.009635e-001, 3.009584e-001, 3.009533e-001, 3.009483e-001, 3.009432e-001, 3.009381e-001, 3.009330e-001, 3.009280e-001, 3.009229e-001, 3.009178e-001, 3.009127e-001, 3.009077e-001, 3.009026e-001, 3.008975e-001, 3.008924e-001, 3.008873e-001, 3.008823e-001, 3.008772e-001, 3.008721e-001, 3.008670e-001, 3.008620e-001, 3.008569e-001, 3.008518e-001, 3.008467e-001, 3.008416e-001, 3.008366e-001, 3.008315e-001, 3.008264e-001, 3.008213e-001, 3.008162e-001, 3.008112e-001, 3.008061e-001, 3.008010e-001, 3.007959e-001, 3.007908e-001, 3.007858e-001, 3.007807e-001, 3.007756e-001, 3.007705e-001, 3.007654e-001, 3.007604e-001, 3.007553e-001, 3.007502e-001, 3.007451e-001, 3.007400e-001, 3.007349e-001, 3.007299e-001, 3.007248e-001, 3.007197e-001, 3.007146e-001, 3.007095e-001, 3.007045e-001, 3.006994e-001, 3.006943e-001, 3.006892e-001, 3.006841e-001, 3.006790e-001, 3.006739e-001, 3.006689e-001, 3.006638e-001, 3.006587e-001, 3.006536e-001, 3.006485e-001, 3.006434e-001, 3.006384e-001, 3.006333e-001, 3.006282e-001, 3.006231e-001, 3.006180e-001, 3.006129e-001, 3.006078e-001, 3.006027e-001, 3.005977e-001, 3.005926e-001, 3.005875e-001, 3.005824e-001, 3.005773e-001, 3.005722e-001, 3.005671e-001, 3.005621e-001, 3.005570e-001, 3.005519e-001, 3.005468e-001, 3.005417e-001, 3.005366e-001, 3.005315e-001, 3.005264e-001, 3.005213e-001, 3.005163e-001, 3.005112e-001, 
3.005061e-001, 3.005010e-001, 3.004959e-001, 3.004908e-001, 3.004857e-001, 3.004806e-001, 3.004755e-001, 3.004704e-001, 3.004654e-001, 3.004603e-001, 3.004552e-001, 3.004501e-001, 3.004450e-001, 3.004399e-001, 3.004348e-001, 3.004297e-001, 3.004246e-001, 3.004195e-001, 3.004144e-001, 3.004093e-001, 3.004042e-001, 3.003992e-001, 3.003941e-001, 3.003890e-001, 3.003839e-001, 3.003788e-001, 3.003737e-001, 3.003686e-001, 3.003635e-001, 3.003584e-001, 3.003533e-001, 3.003482e-001, 3.003431e-001, 3.003380e-001, 3.003329e-001, 3.003278e-001, 3.003227e-001, 3.003176e-001, 3.003125e-001, 3.003074e-001, 3.003024e-001, 3.002973e-001, 3.002922e-001, 3.002871e-001, 3.002820e-001, 3.002769e-001, 3.002718e-001, 3.002667e-001, 3.002616e-001, 3.002565e-001, 3.002514e-001, 3.002463e-001, 3.002412e-001, 3.002361e-001, 3.002310e-001, 3.002259e-001, 3.002208e-001, 3.002157e-001, 3.002106e-001, 3.002055e-001, 3.002004e-001, 3.001953e-001, 3.001902e-001, 3.001851e-001, 3.001800e-001, 3.001749e-001, 3.001698e-001, 3.001647e-001, 3.001596e-001, 3.001545e-001, 3.001494e-001, 3.001443e-001, 3.001392e-001, 3.001341e-001, 3.001290e-001, 3.001239e-001, 3.001188e-001, 3.001137e-001, 3.001086e-001, 3.001035e-001, 3.000984e-001, 3.000933e-001, 3.000882e-001, 3.000831e-001, 3.000780e-001, 3.000729e-001, 3.000677e-001, 3.000626e-001, 3.000575e-001, 3.000524e-001, 3.000473e-001, 3.000422e-001, 3.000371e-001, 3.000320e-001, 3.000269e-001, 3.000218e-001, 3.000167e-001, 3.000116e-001, 3.000065e-001, 3.000014e-001, 
2.999963e-001, 2.999912e-001, 2.999861e-001, 2.999810e-001, 2.999759e-001, 2.999707e-001, 2.999656e-001, 2.999605e-001, 2.999554e-001, 2.999503e-001, 2.999452e-001, 2.999401e-001, 2.999350e-001, 2.999299e-001, 2.999248e-001, 2.999197e-001, 2.999146e-001, 2.999095e-001, 2.999043e-001, 2.998992e-001, 2.998941e-001, 2.998890e-001, 2.998839e-001, 2.998788e-001, 2.998737e-001, 2.998686e-001, 2.998635e-001, 2.998584e-001, 2.998532e-001, 2.998481e-001, 2.998430e-001, 2.998379e-001, 2.998328e-001, 2.998277e-001, 2.998226e-001, 2.998175e-001, 2.998124e-001, 2.998072e-001, 2.998021e-001, 2.997970e-001, 2.997919e-001, 2.997868e-001, 2.997817e-001, 2.997766e-001, 2.997715e-001, 2.997663e-001, 2.997612e-001, 2.997561e-001, 2.997510e-001, 2.997459e-001, 2.997408e-001, 2.997357e-001, 2.997305e-001, 2.997254e-001, 2.997203e-001, 2.997152e-001, 2.997101e-001, 2.997050e-001, 2.996999e-001, 2.996947e-001, 2.996896e-001, 2.996845e-001, 2.996794e-001, 2.996743e-001, 2.996692e-001, 2.996640e-001, 2.996589e-001, 2.996538e-001, 2.996487e-001, 2.996436e-001, 2.996385e-001, 2.996333e-001, 2.996282e-001, 2.996231e-001, 2.996180e-001, 2.996129e-001, 2.996077e-001, 2.996026e-001, 2.995975e-001, 2.995924e-001, 2.995873e-001, 2.995822e-001, 2.995770e-001, 2.995719e-001, 2.995668e-001, 2.995617e-001, 2.995566e-001, 2.995514e-001, 2.995463e-001, 2.995412e-001, 2.995361e-001, 2.995310e-001, 2.995258e-001, 2.995207e-001, 2.995156e-001, 2.995105e-001, 2.995053e-001, 2.995002e-001, 2.994951e-001, 2.994900e-001, 
2.994849e-001, 2.994797e-001, 2.994746e-001, 2.994695e-001, 2.994644e-001, 2.994592e-001, 2.994541e-001, 2.994490e-001, 2.994439e-001, 2.994387e-001, 2.994336e-001, 2.994285e-001, 2.994234e-001, 2.994183e-001, 2.994131e-001, 2.994080e-001, 2.994029e-001, 2.993978e-001, 2.993926e-001, 2.993875e-001, 2.993824e-001, 2.993772e-001, 2.993721e-001, 2.993670e-001, 2.993619e-001, 2.993567e-001, 2.993516e-001, 2.993465e-001, 2.993414e-001, 2.993362e-001, 2.993311e-001, 2.993260e-001, 2.993209e-001, 2.993157e-001, 2.993106e-001, 2.993055e-001, 2.993003e-001, 2.992952e-001, 2.992901e-001, 2.992850e-001, 2.992798e-001, 2.992747e-001, 2.992696e-001, 2.992644e-001, 2.992593e-001, 2.992542e-001, 2.992491e-001, 2.992439e-001, 2.992388e-001, 2.992337e-001, 2.992285e-001, 2.992234e-001, 2.992183e-001, 2.992131e-001, 2.992080e-001, 2.992029e-001, 2.991977e-001, 2.991926e-001, 2.991875e-001, 2.991824e-001, 2.991772e-001, 2.991721e-001, 2.991670e-001, 2.991618e-001, 2.991567e-001, 2.991516e-001, 2.991464e-001, 2.991413e-001, 2.991362e-001, 2.991310e-001, 2.991259e-001, 2.991208e-001, 2.991156e-001, 2.991105e-001, 2.991054e-001, 2.991002e-001, 2.990951e-001, 2.990899e-001, 2.990848e-001, 2.990797e-001, 2.990745e-001, 2.990694e-001, 2.990643e-001, 2.990591e-001, 2.990540e-001, 2.990489e-001, 2.990437e-001, 2.990386e-001, 2.990335e-001, 2.990283e-001, 2.990232e-001, 2.990180e-001, 2.990129e-001, 2.990078e-001, 2.990026e-001, 2.989975e-001, 2.989924e-001, 2.989872e-001, 2.989821e-001, 2.989769e-001, 
2.989718e-001, 2.989667e-001, 2.989615e-001, 2.989564e-001, 2.989512e-001, 2.989461e-001, 2.989410e-001, 2.989358e-001, 2.989307e-001, 2.989255e-001, 2.989204e-001, 2.989153e-001, 2.989101e-001, 2.989050e-001, 2.988998e-001, 2.988947e-001, 2.988896e-001, 2.988844e-001, 2.988793e-001, 2.988741e-001, 2.988690e-001, 2.988639e-001, 2.988587e-001, 2.988536e-001, 2.988484e-001, 2.988433e-001, 2.988381e-001, 2.988330e-001, 2.988279e-001, 2.988227e-001, 2.988176e-001, 2.988124e-001, 2.988073e-001, 2.988021e-001, 2.987970e-001, 2.987918e-001, 2.987867e-001, 2.987816e-001, 2.987764e-001, 2.987713e-001, 2.987661e-001, 2.987610e-001, 2.987558e-001, 2.987507e-001, 2.987455e-001, 2.987404e-001, 2.987353e-001, 2.987301e-001, 2.987250e-001, 2.987198e-001, 2.987147e-001, 2.987095e-001, 2.987044e-001, 2.986992e-001, 2.986941e-001, 2.986889e-001, 2.986838e-001, 2.986786e-001, 2.986735e-001, 2.986683e-001, 2.986632e-001, 2.986580e-001, 2.986529e-001, 2.986477e-001, 2.986426e-001, 2.986374e-001, 2.986323e-001, 2.986271e-001, 2.986220e-001, 2.986168e-001, 2.986117e-001, 2.986065e-001, 2.986014e-001, 2.985962e-001, 2.985911e-001, 2.985859e-001, 2.985808e-001, 2.985756e-001, 2.985705e-001, 2.985653e-001, 2.985602e-001, 2.985550e-001, 2.985499e-001, 2.985447e-001, 2.985396e-001, 2.985344e-001, 2.985293e-001, 2.985241e-001, 2.985190e-001, 2.985138e-001, 2.985087e-001, 2.985035e-001, 2.984984e-001, 2.984932e-001, 2.984880e-001, 2.984829e-001, 2.984777e-001, 2.984726e-001, 2.984674e-001, 2.984623e-001, 
2.984571e-001, 2.984520e-001, 2.984468e-001, 2.984417e-001, 2.984365e-001, 2.984313e-001, 2.984262e-001, 2.984210e-001, 2.984159e-001, 2.984107e-001, 2.984056e-001, 2.984004e-001, 2.983953e-001, 2.983901e-001, 2.983849e-001, 2.983798e-001, 2.983746e-001, 2.983695e-001, 2.983643e-001, 2.983591e-001, 2.983540e-001, 2.983488e-001, 2.983437e-001, 2.983385e-001, 2.983334e-001, 2.983282e-001, 2.983230e-001, 2.983179e-001, 2.983127e-001, 2.983076e-001, 2.983024e-001, 2.982972e-001, 2.982921e-001, 2.982869e-001, 2.982818e-001, 2.982766e-001, 2.982714e-001, 2.982663e-001, 2.982611e-001, 2.982560e-001, 2.982508e-001, 2.982456e-001, 2.982405e-001, 2.982353e-001, 2.982301e-001, 2.982250e-001, 2.982198e-001, 2.982147e-001, 2.982095e-001, 2.982043e-001, 2.981992e-001, 2.981940e-001, 2.981888e-001, 2.981837e-001, 2.981785e-001, 2.981734e-001, 2.981682e-001, 2.981630e-001, 2.981579e-001, 2.981527e-001, 2.981475e-001, 2.981424e-001, 2.981372e-001, 2.981320e-001, 2.981269e-001, 2.981217e-001, 2.981165e-001, 2.981114e-001, 2.981062e-001, 2.981010e-001, 2.980959e-001, 2.980907e-001, 2.980855e-001, 2.980804e-001, 2.980752e-001, 2.980700e-001, 2.980649e-001, 2.980597e-001, 2.980545e-001, 2.980494e-001, 2.980442e-001, 2.980390e-001, 2.980339e-001, 2.980287e-001, 2.980235e-001, 2.980184e-001, 2.980132e-001, 2.980080e-001, 2.980029e-001, 2.979977e-001, 2.979925e-001, 2.979874e-001, 2.979822e-001, 2.979770e-001, 2.979718e-001, 2.979667e-001, 2.979615e-001, 2.979563e-001, 2.979512e-001, 2.979460e-001, 
2.979408e-001, 2.979356e-001, 2.979305e-001, 2.979253e-001, 2.979201e-001, 2.979150e-001, 2.979098e-001, 2.979046e-001, 2.978994e-001, 2.978943e-001, 2.978891e-001, 2.978839e-001, 2.978788e-001, 2.978736e-001, 2.978684e-001, 2.978632e-001, 2.978581e-001, 2.978529e-001, 2.978477e-001, 2.978425e-001, 2.978374e-001, 2.978322e-001, 2.978270e-001, 2.978218e-001, 2.978167e-001, 2.978115e-001, 2.978063e-001, 2.978011e-001, 2.977960e-001, 2.977908e-001, 2.977856e-001, 2.977804e-001, 2.977753e-001, 2.977701e-001, 2.977649e-001, 2.977597e-001, 2.977546e-001, 2.977494e-001, 2.977442e-001, 2.977390e-001, 2.977338e-001, 2.977287e-001, 2.977235e-001, 2.977183e-001, 2.977131e-001, 2.977080e-001, 2.977028e-001, 2.976976e-001, 2.976924e-001, 2.976872e-001, 2.976821e-001, 2.976769e-001, 2.976717e-001, 2.976665e-001, 2.976613e-001, 2.976562e-001, 2.976510e-001, 2.976458e-001, 2.976406e-001, 2.976354e-001, 2.976303e-001, 2.976251e-001, 2.976199e-001, 2.976147e-001, 2.976095e-001, 2.976044e-001, 2.975992e-001, 2.975940e-001, 2.975888e-001, 2.975836e-001, 2.975784e-001, 2.975733e-001, 2.975681e-001, 2.975629e-001, 2.975577e-001, 2.975525e-001, 2.975473e-001, 2.975422e-001, 2.975370e-001, 2.975318e-001, 2.975266e-001, 2.975214e-001, 2.975162e-001, 2.975111e-001, 2.975059e-001, 2.975007e-001, 2.974955e-001, 2.974903e-001, 2.974851e-001, 2.974799e-001, 2.974748e-001, 2.974696e-001, 2.974644e-001, 2.974592e-001, 2.974540e-001, 2.974488e-001, 2.974436e-001, 2.974385e-001, 2.974333e-001, 2.974281e-001, 
2.974229e-001, 2.974177e-001, 2.974125e-001, 2.974073e-001, 2.974021e-001, 2.973970e-001, 2.973918e-001, 2.973866e-001, 2.973814e-001, 2.973762e-001, 2.973710e-001, 2.973658e-001, 2.973606e-001, 2.973554e-001, 2.973503e-001, 2.973451e-001, 2.973399e-001, 2.973347e-001, 2.973295e-001, 2.973243e-001, 2.973191e-001, 2.973139e-001, 2.973087e-001, 2.973035e-001, 2.972984e-001, 2.972932e-001, 2.972880e-001, 2.972828e-001, 2.972776e-001, 2.972724e-001, 2.972672e-001, 2.972620e-001, 2.972568e-001, 2.972516e-001, 2.972464e-001, 2.972412e-001, 2.972360e-001, 2.972309e-001, 2.972257e-001, 2.972205e-001, 2.972153e-001, 2.972101e-001, 2.972049e-001, 2.971997e-001, 2.971945e-001, 2.971893e-001, 2.971841e-001, 2.971789e-001, 2.971737e-001, 2.971685e-001, 2.971633e-001, 2.971581e-001, 2.971529e-001, 2.971477e-001, 2.971425e-001, 2.971373e-001, 2.971322e-001, 2.971270e-001, 2.971218e-001, 2.971166e-001, 2.971114e-001, 2.971062e-001, 2.971010e-001, 2.970958e-001, 2.970906e-001, 2.970854e-001, 2.970802e-001, 2.970750e-001, 2.970698e-001, 2.970646e-001, 2.970594e-001, 2.970542e-001, 2.970490e-001, 2.970438e-001, 2.970386e-001, 2.970334e-001, 2.970282e-001, 2.970230e-001, 2.970178e-001, 2.970126e-001, 2.970074e-001, 2.970022e-001, 2.969970e-001, 2.969918e-001, 2.969866e-001, 2.969814e-001, 2.969762e-001, 2.969710e-001, 2.969658e-001, 2.969606e-001, 2.969554e-001, 2.969502e-001, 2.969450e-001, 2.969398e-001, 2.969346e-001, 2.969294e-001, 2.969242e-001, 2.969190e-001, 2.969138e-001, 2.969086e-001, 
2.969034e-001, 2.968982e-001, 2.968929e-001, 2.968877e-001, 2.968825e-001, 2.968773e-001, 2.968721e-001, 2.968669e-001, 2.968617e-001, 2.968565e-001, 2.968513e-001, 2.968461e-001, 2.968409e-001, 2.968357e-001, 2.968305e-001, 2.968253e-001, 2.968201e-001, 2.968149e-001, 2.968097e-001, 2.968045e-001, 2.967993e-001, 2.967940e-001, 2.967888e-001, 2.967836e-001, 2.967784e-001, 2.967732e-001, 2.967680e-001, 2.967628e-001, 2.967576e-001, 2.967524e-001, 2.967472e-001, 2.967420e-001, 2.967368e-001, 2.967316e-001, 2.967263e-001, 2.967211e-001, 2.967159e-001, 2.967107e-001, 2.967055e-001, 2.967003e-001, 2.966951e-001, 2.966899e-001, 2.966847e-001, 2.966795e-001, 2.966742e-001, 2.966690e-001, 2.966638e-001, 2.966586e-001, 2.966534e-001, 2.966482e-001, 2.966430e-001, 2.966378e-001, 2.966326e-001, 2.966273e-001, 2.966221e-001, 2.966169e-001, 2.966117e-001, 2.966065e-001, 2.966013e-001, 2.965961e-001, 2.965909e-001, 2.965856e-001, 2.965804e-001, 2.965752e-001, 2.965700e-001, 2.965648e-001, 2.965596e-001, 2.965544e-001, 2.965491e-001, 2.965439e-001, 2.965387e-001, 2.965335e-001, 2.965283e-001, 2.965231e-001, 2.965179e-001, 2.965126e-001, 2.965074e-001, 2.965022e-001, 2.964970e-001, 2.964918e-001, 2.964866e-001, 2.964813e-001, 2.964761e-001, 2.964709e-001, 2.964657e-001, 2.964605e-001, 2.964553e-001, 2.964500e-001, 2.964448e-001, 2.964396e-001, 2.964344e-001, 2.964292e-001, 2.964239e-001, 2.964187e-001, 2.964135e-001, 2.964083e-001, 2.964031e-001, 2.963979e-001, 2.963926e-001, 2.963874e-001, 
2.963822e-001, 2.963770e-001, 2.963718e-001, 2.963665e-001, 2.963613e-001, 2.963561e-001, 2.963509e-001, 2.963457e-001, 2.963404e-001, 2.963352e-001, 2.963300e-001, 2.963248e-001, 2.963195e-001, 2.963143e-001, 2.963091e-001, 2.963039e-001, 2.962987e-001, 2.962934e-001, 2.962882e-001, 2.962830e-001, 2.962778e-001, 2.962725e-001, 2.962673e-001, 2.962621e-001, 2.962569e-001, 2.962517e-001, 2.962464e-001, 2.962412e-001, 2.962360e-001, 2.962308e-001, 2.962255e-001, 2.962203e-001, 2.962151e-001, 2.962099e-001, 2.962046e-001, 2.961994e-001, 2.961942e-001, 2.961890e-001, 2.961837e-001, 2.961785e-001, 2.961733e-001, 2.961681e-001, 2.961628e-001, 2.961576e-001, 2.961524e-001, 2.961471e-001, 2.961419e-001, 2.961367e-001, 2.961315e-001, 2.961262e-001, 2.961210e-001, 2.961158e-001, 2.961106e-001, 2.961053e-001, 2.961001e-001, 2.960949e-001, 2.960896e-001, 2.960844e-001, 2.960792e-001, 2.960740e-001, 2.960687e-001, 2.960635e-001, 2.960583e-001, 2.960530e-001, 2.960478e-001, 2.960426e-001, 2.960373e-001, 2.960321e-001, 2.960269e-001, 2.960217e-001, 2.960164e-001, 2.960112e-001, 2.960060e-001, 2.960007e-001, 2.959955e-001, 2.959903e-001, 2.959850e-001, 2.959798e-001, 2.959746e-001, 2.959693e-001, 2.959641e-001, 2.959589e-001, 2.959536e-001, 2.959484e-001, 2.959432e-001, 2.959379e-001, 2.959327e-001, 2.959275e-001, 2.959222e-001, 2.959170e-001, 2.959118e-001, 2.959065e-001, 2.959013e-001, 2.958961e-001, 2.958908e-001, 2.958856e-001, 2.958804e-001, 2.958751e-001, 2.958699e-001, 2.958647e-001, 
2.958594e-001, 2.958542e-001, 2.958490e-001, 2.958437e-001, 2.958385e-001, 2.958332e-001, 2.958280e-001, 2.958228e-001, 2.958175e-001, 2.958123e-001, 2.958071e-001, 2.958018e-001, 2.957966e-001, 2.957913e-001, 2.957861e-001, 2.957809e-001, 2.957756e-001, 2.957704e-001, 2.957652e-001, 2.957599e-001, 2.957547e-001, 2.957494e-001, 2.957442e-001, 2.957390e-001, 2.957337e-001, 2.957285e-001, 2.957232e-001, 2.957180e-001, 2.957128e-001, 2.957075e-001, 2.957023e-001, 2.956970e-001, 2.956918e-001, 2.956866e-001, 2.956813e-001, 2.956761e-001, 2.956708e-001, 2.956656e-001, 2.956604e-001, 2.956551e-001, 2.956499e-001, 2.956446e-001, 2.956394e-001, 2.956341e-001, 2.956289e-001, 2.956237e-001, 2.956184e-001, 2.956132e-001, 2.956079e-001, 2.956027e-001, 2.955974e-001, 2.955922e-001, 2.955869e-001, 2.955817e-001, 2.955765e-001, 2.955712e-001, 2.955660e-001, 2.955607e-001, 2.955555e-001, 2.955502e-001, 2.955450e-001, 2.955397e-001, 2.955345e-001, 2.955293e-001, 2.955240e-001, 2.955188e-001, 2.955135e-001, 2.955083e-001, 2.955030e-001, 2.954978e-001, 2.954925e-001, 2.954873e-001, 2.954820e-001, 2.954768e-001, 2.954715e-001, 2.954663e-001, 2.954610e-001, 2.954558e-001, 2.954505e-001, 2.954453e-001, 2.954401e-001, 2.954348e-001, 2.954296e-001, 2.954243e-001, 2.954191e-001, 2.954138e-001, 2.954086e-001, 2.954033e-001, 2.953981e-001, 2.953928e-001, 2.953876e-001, 2.953823e-001, 2.953771e-001, 2.953718e-001, 2.953666e-001, 2.953613e-001, 2.953561e-001, 2.953508e-001, 2.953455e-001, 2.953403e-001, 
2.953350e-001, 2.953298e-001, 2.953245e-001, 2.953193e-001, 2.953140e-001, 2.953088e-001, 2.953035e-001, 2.952983e-001, 2.952930e-001, 2.952878e-001, 2.952825e-001, 2.952773e-001, 2.952720e-001, 2.952668e-001, 2.952615e-001, 2.952563e-001, 2.952510e-001, 2.952457e-001, 2.952405e-001, 2.952352e-001, 2.952300e-001, 2.952247e-001, 2.952195e-001, 2.952142e-001, 2.952090e-001, 2.952037e-001, 2.951984e-001, 2.951932e-001, 2.951879e-001, 2.951827e-001, 2.951774e-001, 2.951722e-001, 2.951669e-001, 2.951616e-001, 2.951564e-001, 2.951511e-001, 2.951459e-001, 2.951406e-001, 2.951354e-001, 2.951301e-001, 2.951248e-001, 2.951196e-001, 2.951143e-001, 2.951091e-001, 2.951038e-001, 2.950985e-001, 2.950933e-001, 2.950880e-001, 2.950828e-001, 2.950775e-001, 2.950723e-001, 2.950670e-001, 2.950617e-001, 2.950565e-001, 2.950512e-001, 2.950460e-001, 2.950407e-001, 2.950354e-001, 2.950302e-001, 2.950249e-001, 2.950196e-001, 2.950144e-001, 2.950091e-001, 2.950039e-001, 2.949986e-001, 2.949933e-001, 2.949881e-001, 2.949828e-001, 2.949775e-001, 2.949723e-001, 2.949670e-001, 2.949618e-001, 2.949565e-001, 2.949512e-001, 2.949460e-001, 2.949407e-001, 2.949354e-001, 2.949302e-001, 2.949249e-001, 2.949196e-001, 2.949144e-001, 2.949091e-001, 2.949039e-001, 2.948986e-001, 2.948933e-001, 2.948881e-001, 2.948828e-001, 2.948775e-001, 2.948723e-001, 2.948670e-001, 2.948617e-001, 2.948565e-001, 2.948512e-001, 2.948459e-001, 2.948407e-001, 2.948354e-001, 2.948301e-001, 2.948249e-001, 2.948196e-001, 2.948143e-001, 
2.948091e-001, 2.948038e-001, 2.947985e-001, 2.947933e-001, 2.947880e-001, 2.947827e-001, 2.947774e-001, 2.947722e-001, 2.947669e-001, 2.947616e-001, 2.947564e-001, 2.947511e-001, 2.947458e-001, 2.947406e-001, 2.947353e-001, 2.947300e-001, 2.947248e-001, 2.947195e-001, 2.947142e-001, 2.947089e-001, 2.947037e-001, 2.946984e-001, 2.946931e-001, 2.946879e-001, 2.946826e-001, 2.946773e-001, 2.946720e-001, 2.946668e-001, 2.946615e-001, 2.946562e-001, 2.946509e-001, 2.946457e-001, 2.946404e-001, 2.946351e-001, 2.946299e-001, 2.946246e-001, 2.946193e-001, 2.946140e-001, 2.946088e-001, 2.946035e-001, 2.945982e-001, 2.945929e-001, 2.945877e-001, 2.945824e-001, 2.945771e-001, 2.945718e-001, 2.945666e-001, 2.945613e-001, 2.945560e-001, 2.945507e-001, 2.945455e-001, 2.945402e-001, 2.945349e-001, 2.945296e-001, 2.945244e-001, 2.945191e-001, 2.945138e-001, 2.945085e-001, 2.945032e-001, 2.944980e-001, 2.944927e-001, 2.944874e-001, 2.944821e-001, 2.944769e-001, 2.944716e-001, 2.944663e-001, 2.944610e-001, 2.944557e-001, 2.944505e-001, 2.944452e-001, 2.944399e-001, 2.944346e-001, 2.944294e-001, 2.944241e-001, 2.944188e-001, 2.944135e-001, 2.944082e-001, 2.944030e-001, 2.943977e-001, 2.943924e-001, 2.943871e-001, 2.943818e-001, 2.943765e-001, 2.943713e-001, 2.943660e-001, 2.943607e-001, 2.943554e-001, 2.943501e-001, 2.943449e-001, 2.943396e-001, 2.943343e-001, 2.943290e-001, 2.943237e-001, 2.943184e-001, 2.943132e-001, 2.943079e-001, 2.943026e-001, 2.942973e-001, 2.942920e-001, 2.942867e-001, 
2.942815e-001, 2.942762e-001, 2.942709e-001, 2.942656e-001, 2.942603e-001, 2.942550e-001, 2.942498e-001, 2.942445e-001, 2.942392e-001, 2.942339e-001, 2.942286e-001, 2.942233e-001, 2.942180e-001, 2.942128e-001, 2.942075e-001, 2.942022e-001, 2.941969e-001, 2.941916e-001, 2.941863e-001, 2.941810e-001, 2.941758e-001, 2.941705e-001, 2.941652e-001, 2.941599e-001, 2.941546e-001, 2.941493e-001, 2.941440e-001, 2.941387e-001, 2.941335e-001, 2.941282e-001, 2.941229e-001, 2.941176e-001, 2.941123e-001, 2.941070e-001, 2.941017e-001, 2.940964e-001, 2.940911e-001, 2.940858e-001, 2.940806e-001, 2.940753e-001, 2.940700e-001, 2.940647e-001, 2.940594e-001, 2.940541e-001, 2.940488e-001, 2.940435e-001, 2.940382e-001, 2.940329e-001, 2.940277e-001, 2.940224e-001, 2.940171e-001, 2.940118e-001, 2.940065e-001, 2.940012e-001, 2.939959e-001, 2.939906e-001, 2.939853e-001, 2.939800e-001, 2.939747e-001, 2.939694e-001, 2.939641e-001, 2.939588e-001, 2.939536e-001, 2.939483e-001, 2.939430e-001, 2.939377e-001, 2.939324e-001, 2.939271e-001, 2.939218e-001, 2.939165e-001, 2.939112e-001, 2.939059e-001, 2.939006e-001, 2.938953e-001, 2.938900e-001, 2.938847e-001, 2.938794e-001, 2.938741e-001, 2.938688e-001, 2.938635e-001, 2.938582e-001, 2.938529e-001, 2.938476e-001, 2.938423e-001, 2.938370e-001, 2.938317e-001, 2.938265e-001, 2.938212e-001, 2.938159e-001, 2.938106e-001, 2.938053e-001, 2.938000e-001, 2.937947e-001, 2.937894e-001, 2.937841e-001, 2.937788e-001, 2.937735e-001, 2.937682e-001, 2.937629e-001, 2.937576e-001, 
2.937523e-001, 2.937470e-001, 2.937417e-001, 2.937364e-001, 2.937311e-001, 2.937258e-001, 2.937205e-001, 2.937152e-001, 2.937099e-001, 2.937046e-001, 2.936993e-001, 2.936940e-001, 2.936887e-001, 2.936834e-001, 2.936781e-001, 2.936728e-001, 2.936674e-001, 2.936621e-001, 2.936568e-001, 2.936515e-001, 2.936462e-001, 2.936409e-001, 2.936356e-001, 2.936303e-001, 2.936250e-001, 2.936197e-001, 2.936144e-001, 2.936091e-001, 2.936038e-001, 2.935985e-001, 2.935932e-001, 2.935879e-001, 2.935826e-001, 2.935773e-001, 2.935720e-001, 2.935667e-001, 2.935614e-001, 2.935561e-001, 2.935508e-001, 2.935454e-001, 2.935401e-001, 2.935348e-001, 2.935295e-001, 2.935242e-001, 2.935189e-001, 2.935136e-001, 2.935083e-001, 2.935030e-001, 2.934977e-001, 2.934924e-001, 2.934871e-001, 2.934818e-001, 2.934765e-001, 2.934711e-001, 2.934658e-001, 2.934605e-001, 2.934552e-001, 2.934499e-001, 2.934446e-001, 2.934393e-001, 2.934340e-001, 2.934287e-001, 2.934234e-001, 2.934181e-001, 2.934127e-001, 2.934074e-001, 2.934021e-001, 2.933968e-001, 2.933915e-001, 2.933862e-001, 2.933809e-001, 2.933756e-001, 2.933703e-001, 2.933649e-001, 2.933596e-001, 2.933543e-001, 2.933490e-001, 2.933437e-001, 2.933384e-001, 2.933331e-001, 2.933278e-001, 2.933224e-001, 2.933171e-001, 2.933118e-001, 2.933065e-001, 2.933012e-001, 2.932959e-001, 2.932906e-001, 2.932853e-001, 2.932799e-001, 2.932746e-001, 2.932693e-001, 2.932640e-001, 2.932587e-001, 2.932534e-001, 2.932481e-001, 2.932427e-001, 2.932374e-001, 2.932321e-001, 2.932268e-001, 
2.932215e-001, 2.932162e-001, 2.932108e-001, 2.932055e-001, 2.932002e-001, 2.931949e-001, 2.931896e-001, 2.931843e-001, 2.931789e-001, 2.931736e-001, 2.931683e-001, 2.931630e-001, 2.931577e-001, 2.931524e-001, 2.931470e-001, 2.931417e-001, 2.931364e-001, 2.931311e-001, 2.931258e-001, 2.931204e-001, 2.931151e-001, 2.931098e-001, 2.931045e-001, 2.930992e-001, 2.930938e-001, 2.930885e-001, 2.930832e-001, 2.930779e-001, 2.930726e-001, 2.930672e-001, 2.930619e-001, 2.930566e-001, 2.930513e-001, 2.930460e-001, 2.930406e-001, 2.930353e-001, 2.930300e-001, 2.930247e-001, 2.930194e-001, 2.930140e-001, 2.930087e-001, 2.930034e-001, 2.929981e-001, 2.929927e-001, 2.929874e-001, 2.929821e-001, 2.929768e-001, 2.929714e-001, 2.929661e-001, 2.929608e-001, 2.929555e-001, 2.929502e-001, 2.929448e-001, 2.929395e-001, 2.929342e-001, 2.929289e-001, 2.929235e-001, 2.929182e-001, 2.929129e-001, 2.929076e-001, 2.929022e-001, 2.928969e-001, 2.928916e-001, 2.928863e-001, 2.928809e-001, 2.928756e-001, 2.928703e-001, 2.928649e-001, 2.928596e-001, 2.928543e-001, 2.928490e-001, 2.928436e-001, 2.928383e-001, 2.928330e-001, 2.928277e-001, 2.928223e-001, 2.928170e-001, 2.928117e-001, 2.928063e-001, 2.928010e-001, 2.927957e-001, 2.927904e-001, 2.927850e-001, 2.927797e-001, 2.927744e-001, 2.927690e-001, 2.927637e-001, 2.927584e-001, 2.927531e-001, 2.927477e-001, 2.927424e-001, 2.927371e-001, 2.927317e-001, 2.927264e-001, 2.927211e-001, 2.927157e-001, 2.927104e-001, 2.927051e-001, 2.926997e-001, 2.926944e-001, 
2.926891e-001, 2.926837e-001, 2.926784e-001, 2.926731e-001, 2.926678e-001, 2.926624e-001, 2.926571e-001, 2.926518e-001, 2.926464e-001, 2.926411e-001, 2.926358e-001, 2.926304e-001, 2.926251e-001, 2.926198e-001, 2.926144e-001, 2.926091e-001, 2.926037e-001, 2.925984e-001, 2.925931e-001, 2.925877e-001, 2.925824e-001, 2.925771e-001, 2.925717e-001, 2.925664e-001, 2.925611e-001, 2.925557e-001, 2.925504e-001, 2.925451e-001, 2.925397e-001, 2.925344e-001, 2.925290e-001, 2.925237e-001, 2.925184e-001, 2.925130e-001, 2.925077e-001, 2.925024e-001, 2.924970e-001, 2.924917e-001, 2.924864e-001, 2.924810e-001, 2.924757e-001, 2.924703e-001, 2.924650e-001, 2.924597e-001, 2.924543e-001, 2.924490e-001, 2.924436e-001, 2.924383e-001, 2.924330e-001, 2.924276e-001, 2.924223e-001, 2.924169e-001, 2.924116e-001, 2.924063e-001, 2.924009e-001, 2.923956e-001, 2.923902e-001, 2.923849e-001, 2.923796e-001, 2.923742e-001, 2.923689e-001, 2.923635e-001, 2.923582e-001, 2.923529e-001, 2.923475e-001, 2.923422e-001, 2.923368e-001, 2.923315e-001, 2.923261e-001, 2.923208e-001, 2.923155e-001, 2.923101e-001, 2.923048e-001, 2.922994e-001, 2.922941e-001, 2.922887e-001, 2.922834e-001, 2.922780e-001, 2.922727e-001, 2.922674e-001, 2.922620e-001, 2.922567e-001, 2.922513e-001, 2.922460e-001, 2.922406e-001, 2.922353e-001, 2.922299e-001, 2.922246e-001, 2.922193e-001, 2.922139e-001, 2.922086e-001, 2.922032e-001, 2.921979e-001, 2.921925e-001, 2.921872e-001, 2.921818e-001, 2.921765e-001, 2.921711e-001, 2.921658e-001, 2.921604e-001, 
2.921551e-001, 2.921497e-001, 2.921444e-001, 2.921390e-001, 2.921337e-001, 2.921283e-001, 2.921230e-001, 2.921177e-001, 2.921123e-001, 2.921070e-001, 2.921016e-001, 2.920963e-001, 2.920909e-001, 2.920856e-001, 2.920802e-001, 2.920749e-001, 2.920695e-001, 2.920642e-001, 2.920588e-001, 2.920535e-001, 2.920481e-001, 2.920428e-001, 2.920374e-001, 2.920320e-001, 2.920267e-001, 2.920213e-001, 2.920160e-001, 2.920106e-001, 2.920053e-001, 2.919999e-001, 2.919946e-001, 2.919892e-001, 2.919839e-001, 2.919785e-001, 2.919732e-001, 2.919678e-001, 2.919625e-001, 2.919571e-001, 2.919518e-001, 2.919464e-001, 2.919410e-001, 2.919357e-001, 2.919303e-001, 2.919250e-001, 2.919196e-001, 2.919143e-001, 2.919089e-001, 2.919036e-001, 2.918982e-001, 2.918929e-001, 2.918875e-001, 2.918821e-001, 2.918768e-001, 2.918714e-001, 2.918661e-001, 2.918607e-001, 2.918554e-001, 2.918500e-001, 2.918446e-001, 2.918393e-001, 2.918339e-001, 2.918286e-001, 2.918232e-001, 2.918179e-001, 2.918125e-001, 2.918071e-001, 2.918018e-001, 2.917964e-001, 2.917911e-001, 2.917857e-001, 2.917804e-001, 2.917750e-001, 2.917696e-001, 2.917643e-001, 2.917589e-001, 2.917536e-001, 2.917482e-001, 2.917428e-001, 2.917375e-001, 2.917321e-001, 2.917268e-001, 2.917214e-001, 2.917160e-001, 2.917107e-001, 2.917053e-001, 2.916999e-001, 2.916946e-001, 2.916892e-001, 2.916839e-001, 2.916785e-001, 2.916731e-001, 2.916678e-001, 2.916624e-001, 2.916571e-001, 2.916517e-001, 2.916463e-001, 2.916410e-001, 2.916356e-001, 2.916302e-001, 2.916249e-001, 
2.916195e-001, 2.916141e-001, 2.916088e-001, 2.916034e-001, 2.915981e-001, 2.915927e-001, 2.915873e-001, 2.915820e-001, 2.915766e-001, 2.915712e-001, 2.915659e-001, 2.915605e-001, 2.915551e-001, 2.915498e-001, 2.915444e-001, 2.915390e-001, 2.915337e-001, 2.915283e-001, 2.915229e-001, 2.915176e-001, 2.915122e-001, 2.915068e-001, 2.915015e-001, 2.914961e-001, 2.914907e-001, 2.914854e-001, 2.914800e-001, 2.914746e-001, 2.914693e-001, 2.914639e-001, 2.914585e-001, 2.914532e-001, 2.914478e-001, 2.914424e-001, 2.914371e-001, 2.914317e-001, 2.914263e-001, 2.914209e-001, 2.914156e-001, 2.914102e-001, 2.914048e-001, 2.913995e-001, 2.913941e-001, 2.913887e-001, 2.913834e-001, 2.913780e-001, 2.913726e-001, 2.913672e-001, 2.913619e-001, 2.913565e-001, 2.913511e-001, 2.913458e-001, 2.913404e-001, 2.913350e-001, 2.913296e-001, 2.913243e-001, 2.913189e-001, 2.913135e-001, 2.913081e-001, 2.913028e-001, 2.912974e-001, 2.912920e-001, 2.912867e-001, 2.912813e-001, 2.912759e-001, 2.912705e-001, 2.912652e-001, 2.912598e-001, 2.912544e-001, 2.912490e-001, 2.912437e-001, 2.912383e-001, 2.912329e-001, 2.912275e-001, 2.912222e-001, 2.912168e-001, 2.912114e-001, 2.912060e-001, 2.912007e-001, 2.911953e-001, 2.911899e-001, 2.911845e-001, 2.911791e-001, 2.911738e-001, 2.911684e-001, 2.911630e-001, 2.911576e-001, 2.911523e-001, 2.911469e-001, 2.911415e-001, 2.911361e-001, 2.911307e-001, 2.911254e-001, 2.911200e-001, 2.911146e-001, 2.911092e-001, 2.911039e-001, 2.910985e-001, 2.910931e-001, 2.910877e-001, 
2.910823e-001, 2.910770e-001, 2.910716e-001, 2.910662e-001, 2.910608e-001, 2.910554e-001, 2.910501e-001, 2.910447e-001, 2.910393e-001, 2.910339e-001, 2.910285e-001, 2.910232e-001, 2.910178e-001, 2.910124e-001, 2.910070e-001, 2.910016e-001, 2.909962e-001, 2.909909e-001, 2.909855e-001, 2.909801e-001, 2.909747e-001, 2.909693e-001, 2.909639e-001, 2.909586e-001, 2.909532e-001, 2.909478e-001, 2.909424e-001, 2.909370e-001, 2.909316e-001, 2.909263e-001, 2.909209e-001, 2.909155e-001, 2.909101e-001, 2.909047e-001, 2.908993e-001, 2.908940e-001, 2.908886e-001, 2.908832e-001, 2.908778e-001, 2.908724e-001, 2.908670e-001, 2.908616e-001, 2.908563e-001, 2.908509e-001, 2.908455e-001, 2.908401e-001, 2.908347e-001, 2.908293e-001, 2.908239e-001, 2.908185e-001, 2.908132e-001, 2.908078e-001, 2.908024e-001, 2.907970e-001, 2.907916e-001, 2.907862e-001, 2.907808e-001, 2.907754e-001, 2.907701e-001, 2.907647e-001, 2.907593e-001, 2.907539e-001, 2.907485e-001, 2.907431e-001, 2.907377e-001, 2.907323e-001, 2.907269e-001, 2.907215e-001, 2.907162e-001, 2.907108e-001, 2.907054e-001, 2.907000e-001, 2.906946e-001, 2.906892e-001, 2.906838e-001, 2.906784e-001, 2.906730e-001, 2.906676e-001, 2.906622e-001, 2.906569e-001, 2.906515e-001, 2.906461e-001, 2.906407e-001, 2.906353e-001, 2.906299e-001, 2.906245e-001, 2.906191e-001, 2.906137e-001, 2.906083e-001, 2.906029e-001, 2.905975e-001, 2.905921e-001, 2.905867e-001, 2.905813e-001, 2.905760e-001, 2.905706e-001, 2.905652e-001, 2.905598e-001, 2.905544e-001, 2.905490e-001, 
2.905436e-001, 2.905382e-001, 2.905328e-001, 2.905274e-001, 2.905220e-001, 2.905166e-001, 2.905112e-001, 2.905058e-001, 2.905004e-001, 2.904950e-001, 2.904896e-001, 2.904842e-001, 2.904788e-001, 2.904734e-001, 2.904680e-001, 2.904626e-001, 2.904572e-001, 2.904518e-001, 2.904464e-001, 2.904410e-001, 2.904356e-001, 2.904302e-001, 2.904248e-001, 2.904194e-001, 2.904140e-001, 2.904086e-001, 2.904032e-001, 2.903978e-001, 2.903924e-001, 2.903870e-001, 2.903816e-001, 2.903762e-001, 2.903708e-001, 2.903654e-001, 2.903600e-001, 2.903546e-001, 2.903492e-001, 2.903438e-001, 2.903384e-001, 2.903330e-001, 2.903276e-001, 2.903222e-001, 2.903168e-001, 2.903114e-001, 2.903060e-001, 2.903006e-001, 2.902952e-001, 2.902898e-001, 2.902844e-001, 2.902790e-001, 2.902736e-001, 2.902682e-001, 2.902628e-001, 2.902574e-001, 2.902520e-001, 2.902466e-001, 2.902412e-001, 2.902358e-001, 2.902304e-001, 2.902250e-001, 2.902196e-001, 2.902142e-001, 2.902088e-001, 2.902034e-001, 2.901979e-001, 2.901925e-001, 2.901871e-001, 2.901817e-001, 2.901763e-001, 2.901709e-001, 2.901655e-001, 2.901601e-001, 2.901547e-001, 2.901493e-001, 2.901439e-001, 2.901385e-001, 2.901331e-001, 2.901277e-001, 2.901223e-001, 2.901168e-001, 2.901114e-001, 2.901060e-001, 2.901006e-001, 2.900952e-001, 2.900898e-001, 2.900844e-001, 2.900790e-001, 2.900736e-001, 2.900682e-001, 2.900628e-001, 2.900573e-001, 2.900519e-001, 2.900465e-001, 2.900411e-001, 2.900357e-001, 2.900303e-001, 2.900249e-001, 2.900195e-001, 2.900141e-001, 2.900087e-001, 
2.900032e-001, 2.899978e-001, 2.899924e-001, 2.899870e-001, 2.899816e-001, 2.899762e-001, 2.899708e-001, 2.899654e-001, 2.899599e-001, 2.899545e-001, 2.899491e-001, 2.899437e-001, 2.899383e-001, 2.899329e-001, 2.899275e-001, 2.899221e-001, 2.899166e-001, 2.899112e-001, 2.899058e-001, 2.899004e-001, 2.898950e-001, 2.898896e-001, 2.898842e-001, 2.898787e-001, 2.898733e-001, 2.898679e-001, 2.898625e-001, 2.898571e-001, 2.898517e-001, 2.898462e-001, 2.898408e-001, 2.898354e-001, 2.898300e-001, 2.898246e-001, 2.898192e-001, 2.898137e-001, 2.898083e-001, 2.898029e-001, 2.897975e-001, 2.897921e-001, 2.897867e-001, 2.897812e-001, 2.897758e-001, 2.897704e-001, 2.897650e-001, 2.897596e-001, 2.897542e-001, 2.897487e-001, 2.897433e-001, 2.897379e-001, 2.897325e-001, 2.897271e-001, 2.897216e-001, 2.897162e-001, 2.897108e-001, 2.897054e-001, 2.897000e-001, 2.896945e-001, 2.896891e-001, 2.896837e-001, 2.896783e-001, 2.896729e-001, 2.896674e-001, 2.896620e-001, 2.896566e-001, 2.896512e-001, 2.896457e-001, 2.896403e-001, 2.896349e-001, 2.896295e-001, 2.896241e-001, 2.896186e-001, 2.896132e-001, 2.896078e-001, 2.896024e-001, 2.895969e-001, 2.895915e-001, 2.895861e-001, 2.895807e-001, 2.895752e-001, 2.895698e-001, 2.895644e-001, 2.895590e-001, 2.895536e-001, 2.895481e-001, 2.895427e-001, 2.895373e-001, 2.895319e-001, 2.895264e-001, 2.895210e-001, 2.895156e-001, 2.895102e-001, 2.895047e-001, 2.894993e-001, 2.894939e-001, 2.894884e-001, 2.894830e-001, 2.894776e-001, 2.894722e-001, 2.894667e-001, 
2.894613e-001, 2.894559e-001, 2.894505e-001, 2.894450e-001, 2.894396e-001, 2.894342e-001, 2.894287e-001, 2.894233e-001, 2.894179e-001, 2.894125e-001, 2.894070e-001, 2.894016e-001, 2.893962e-001, 2.893907e-001, 2.893853e-001, 2.893799e-001, 2.893745e-001, 2.893690e-001, 2.893636e-001, 2.893582e-001, 2.893527e-001, 2.893473e-001, 2.893419e-001, 2.893364e-001, 2.893310e-001, 2.893256e-001, 2.893202e-001, 2.893147e-001, 2.893093e-001, 2.893039e-001, 2.892984e-001, 2.892930e-001, 2.892876e-001, 2.892821e-001, 2.892767e-001, 2.892713e-001, 2.892658e-001, 2.892604e-001, 2.892550e-001, 2.892495e-001, 2.892441e-001, 2.892387e-001, 2.892332e-001, 2.892278e-001, 2.892224e-001, 2.892169e-001, 2.892115e-001, 2.892061e-001, 2.892006e-001, 2.891952e-001, 2.891898e-001, 2.891843e-001, 2.891789e-001, 2.891735e-001, 2.891680e-001, 2.891626e-001, 2.891571e-001, 2.891517e-001, 2.891463e-001, 2.891408e-001, 2.891354e-001, 2.891300e-001, 2.891245e-001, 2.891191e-001, 2.891137e-001, 2.891082e-001, 2.891028e-001, 2.890973e-001, 2.890919e-001, 2.890865e-001, 2.890810e-001, 2.890756e-001, 2.890702e-001, 2.890647e-001, 2.890593e-001, 2.890538e-001, 2.890484e-001, 2.890430e-001, 2.890375e-001, 2.890321e-001, 2.890266e-001, 2.890212e-001, 2.890158e-001, 2.890103e-001, 2.890049e-001, 2.889994e-001, 2.889940e-001, 2.889886e-001, 2.889831e-001, 2.889777e-001, 2.889722e-001, 2.889668e-001, 2.889613e-001, 2.889559e-001, 2.889505e-001, 2.889450e-001, 2.889396e-001, 2.889341e-001, 2.889287e-001, 2.889233e-001, 
2.889178e-001, 2.889124e-001, 2.889069e-001, 2.889015e-001, 2.888960e-001, 2.888906e-001, 2.888851e-001, 2.888797e-001, 2.888743e-001, 2.888688e-001, 2.888634e-001, 2.888579e-001, 2.888525e-001, 2.888470e-001, 2.888416e-001, 2.888361e-001, 2.888307e-001, 2.888253e-001, 2.888198e-001, 2.888144e-001, 2.888089e-001, 2.888035e-001, 2.887980e-001, 2.887926e-001, 2.887871e-001, 2.887817e-001, 2.887762e-001, 2.887708e-001, 2.887653e-001, 2.887599e-001, 2.887545e-001, 2.887490e-001, 2.887436e-001, 2.887381e-001, 2.887327e-001, 2.887272e-001, 2.887218e-001, 2.887163e-001, 2.887109e-001, 2.887054e-001, 2.887000e-001, 2.886945e-001, 2.886891e-001, 2.886836e-001, 2.886782e-001, 2.886727e-001, 2.886673e-001, 2.886618e-001, 2.886564e-001, 2.886509e-001, 2.886455e-001, 2.886400e-001, 2.886346e-001, 2.886291e-001, 2.886237e-001, 2.886182e-001, 2.886128e-001, 2.886073e-001, 2.886019e-001, 2.885964e-001, 2.885909e-001, 2.885855e-001, 2.885800e-001, 2.885746e-001, 2.885691e-001, 2.885637e-001, 2.885582e-001, 2.885528e-001, 2.885473e-001, 2.885419e-001, 2.885364e-001, 2.885310e-001, 2.885255e-001, 2.885201e-001, 2.885146e-001, 2.885091e-001, 2.885037e-001, 2.884982e-001, 2.884928e-001, 2.884873e-001, 2.884819e-001, 2.884764e-001, 2.884710e-001, 2.884655e-001, 2.884600e-001, 2.884546e-001, 2.884491e-001, 2.884437e-001, 2.884382e-001, 2.884328e-001, 2.884273e-001, 2.884218e-001, 2.884164e-001, 2.884109e-001, 2.884055e-001, 2.884000e-001, 2.883946e-001, 2.883891e-001, 2.883836e-001, 2.883782e-001, 
2.883727e-001, 2.883673e-001, 2.883618e-001, 2.883564e-001, 2.883509e-001, 2.883454e-001, 2.883400e-001, 2.883345e-001, 2.883291e-001, 2.883236e-001, 2.883181e-001, 2.883127e-001, 2.883072e-001, 2.883018e-001, 2.882963e-001, 2.882908e-001, 2.882854e-001, 2.882799e-001, 2.882744e-001, 2.882690e-001, 2.882635e-001, 2.882581e-001, 2.882526e-001, 2.882471e-001, 2.882417e-001, 2.882362e-001, 2.882307e-001, 2.882253e-001, 2.882198e-001, 2.882144e-001, 2.882089e-001, 2.882034e-001, 2.881980e-001, 2.881925e-001, 2.881870e-001, 2.881816e-001, 2.881761e-001, 2.881706e-001, 2.881652e-001, 2.881597e-001, 2.881543e-001, 2.881488e-001, 2.881433e-001, 2.881379e-001, 2.881324e-001, 2.881269e-001, 2.881215e-001, 2.881160e-001, 2.881105e-001, 2.881051e-001, 2.880996e-001, 2.880941e-001, 2.880887e-001, 2.880832e-001, 2.880777e-001, 2.880723e-001, 2.880668e-001, 2.880613e-001, 2.880559e-001, 2.880504e-001, 2.880449e-001, 2.880395e-001, 2.880340e-001, 2.880285e-001, 2.880230e-001, 2.880176e-001, 2.880121e-001, 2.880066e-001, 2.880012e-001, 2.879957e-001, 2.879902e-001, 2.879848e-001, 2.879793e-001, 2.879738e-001, 2.879684e-001, 2.879629e-001, 2.879574e-001, 2.879519e-001, 2.879465e-001, 2.879410e-001, 2.879355e-001, 2.879301e-001, 2.879246e-001, 2.879191e-001, 2.879136e-001, 2.879082e-001, 2.879027e-001, 2.878972e-001, 2.878918e-001, 2.878863e-001, 2.878808e-001, 2.878753e-001, 2.878699e-001, 2.878644e-001, 2.878589e-001, 2.878534e-001, 2.878480e-001, 2.878425e-001, 2.878370e-001, 2.878315e-001, 
2.878261e-001, 2.878206e-001, 2.878151e-001, 2.878096e-001, 2.878042e-001, 2.877987e-001, 2.877932e-001, 2.877877e-001, 2.877823e-001, 2.877768e-001, 2.877713e-001, 2.877658e-001, 2.877604e-001, 2.877549e-001, 2.877494e-001, 2.877439e-001, 2.877385e-001, 2.877330e-001, 2.877275e-001, 2.877220e-001, 2.877166e-001, 2.877111e-001, 2.877056e-001, 2.877001e-001, 2.876946e-001, 2.876892e-001, 2.876837e-001, 2.876782e-001, 2.876727e-001, 2.876672e-001, 2.876618e-001, 2.876563e-001, 2.876508e-001, 2.876453e-001, 2.876398e-001, 2.876344e-001, 2.876289e-001, 2.876234e-001, 2.876179e-001, 2.876124e-001, 2.876070e-001, 2.876015e-001, 2.875960e-001, 2.875905e-001, 2.875850e-001, 2.875796e-001, 2.875741e-001, 2.875686e-001, 2.875631e-001, 2.875576e-001, 2.875522e-001, 2.875467e-001, 2.875412e-001, 2.875357e-001, 2.875302e-001, 2.875247e-001, 2.875193e-001, 2.875138e-001, 2.875083e-001, 2.875028e-001, 2.874973e-001, 2.874918e-001, 2.874864e-001, 2.874809e-001, 2.874754e-001, 2.874699e-001, 2.874644e-001, 2.874589e-001, 2.874534e-001, 2.874480e-001, 2.874425e-001, 2.874370e-001, 2.874315e-001, 2.874260e-001, 2.874205e-001, 2.874150e-001, 2.874096e-001, 2.874041e-001, 2.873986e-001, 2.873931e-001, 2.873876e-001, 2.873821e-001, 2.873766e-001, 2.873712e-001, 2.873657e-001, 2.873602e-001, 2.873547e-001, 2.873492e-001, 2.873437e-001, 2.873382e-001, 2.873327e-001, 2.873272e-001, 2.873218e-001, 2.873163e-001, 2.873108e-001, 2.873053e-001, 2.872998e-001, 2.872943e-001, 2.872888e-001, 2.872833e-001, 
2.872778e-001, 2.872724e-001, 2.872669e-001, 2.872614e-001, 2.872559e-001, 2.872504e-001, 2.872449e-001, 2.872394e-001, 2.872339e-001, 2.872284e-001, 2.872229e-001, 2.872174e-001, 2.872119e-001, 2.872065e-001, 2.872010e-001, 2.871955e-001, 2.871900e-001, 2.871845e-001, 2.871790e-001, 2.871735e-001, 2.871680e-001, 2.871625e-001, 2.871570e-001, 2.871515e-001, 2.871460e-001, 2.871405e-001, 2.871350e-001, 2.871296e-001, 2.871241e-001, 2.871186e-001, 2.871131e-001, 2.871076e-001, 2.871021e-001, 2.870966e-001, 2.870911e-001, 2.870856e-001, 2.870801e-001, 2.870746e-001, 2.870691e-001, 2.870636e-001, 2.870581e-001, 2.870526e-001, 2.870471e-001, 2.870416e-001, 2.870361e-001, 2.870306e-001, 2.870251e-001, 2.870196e-001, 2.870141e-001, 2.870086e-001, 2.870031e-001, 2.869976e-001, 2.869921e-001, 2.869866e-001, 2.869811e-001, 2.869756e-001, 2.869701e-001, 2.869646e-001, 2.869591e-001, 2.869537e-001, 2.869482e-001, 2.869427e-001, 2.869372e-001, 2.869317e-001, 2.869262e-001, 2.869207e-001, 2.869152e-001, 2.869097e-001, 2.869041e-001, 2.868986e-001, 2.868931e-001, 2.868876e-001, 2.868821e-001, 2.868766e-001, 2.868711e-001, 2.868656e-001, 2.868601e-001, 2.868546e-001, 2.868491e-001, 2.868436e-001, 2.868381e-001, 2.868326e-001, 2.868271e-001, 2.868216e-001, 2.868161e-001, 2.868106e-001, 2.868051e-001, 2.867996e-001, 2.867941e-001, 2.867886e-001, 2.867831e-001, 2.867776e-001, 2.867721e-001, 2.867666e-001, 2.867611e-001, 2.867556e-001, 2.867501e-001, 2.867446e-001, 2.867391e-001, 2.867335e-001, 
2.867280e-001, 2.867225e-001, 2.867170e-001, 2.867115e-001, 2.867060e-001, 2.867005e-001, 2.866950e-001, 2.866895e-001, 2.866840e-001, 2.866785e-001, 2.866730e-001, 2.866675e-001, 2.866620e-001, 2.866565e-001, 2.866509e-001, 2.866454e-001, 2.866399e-001, 2.866344e-001, 2.866289e-001, 2.866234e-001, 2.866179e-001, 2.866124e-001, 2.866069e-001, 2.866014e-001, 2.865959e-001, 2.865903e-001, 2.865848e-001, 2.865793e-001, 2.865738e-001, 2.865683e-001, 2.865628e-001, 2.865573e-001, 2.865518e-001, 2.865463e-001, 2.865408e-001, 2.865352e-001, 2.865297e-001, 2.865242e-001, 2.865187e-001, 2.865132e-001, 2.865077e-001, 2.865022e-001, 2.864967e-001, 2.864911e-001, 2.864856e-001, 2.864801e-001, 2.864746e-001, 2.864691e-001, 2.864636e-001, 2.864581e-001, 2.864526e-001, 2.864470e-001, 2.864415e-001, 2.864360e-001, 2.864305e-001, 2.864250e-001, 2.864195e-001, 2.864140e-001, 2.864084e-001, 2.864029e-001, 2.863974e-001, 2.863919e-001, 2.863864e-001, 2.863809e-001, 2.863753e-001, 2.863698e-001, 2.863643e-001, 2.863588e-001, 2.863533e-001, 2.863478e-001, 2.863423e-001, 2.863367e-001, 2.863312e-001, 2.863257e-001, 2.863202e-001, 2.863147e-001, 2.863091e-001, 2.863036e-001, 2.862981e-001, 2.862926e-001, 2.862871e-001, 2.862816e-001, 2.862760e-001, 2.862705e-001, 2.862650e-001, 2.862595e-001, 2.862540e-001, 2.862484e-001, 2.862429e-001, 2.862374e-001, 2.862319e-001, 2.862264e-001, 2.862208e-001, 2.862153e-001, 2.862098e-001, 2.862043e-001, 2.861988e-001, 2.861932e-001, 2.861877e-001, 2.861822e-001, 
2.861767e-001, 2.861712e-001, 2.861656e-001, 2.861601e-001, 2.861546e-001, 2.861491e-001, 2.861435e-001, 2.861380e-001, 2.861325e-001, 2.861270e-001, 2.861215e-001, 2.861159e-001, 2.861104e-001, 2.861049e-001, 2.860994e-001, 2.860938e-001, 2.860883e-001, 2.860828e-001, 2.860773e-001, 2.860717e-001, 2.860662e-001, 2.860607e-001, 2.860552e-001, 2.860496e-001, 2.860441e-001, 2.860386e-001, 2.860331e-001, 2.860275e-001, 2.860220e-001, 2.860165e-001, 2.860110e-001, 2.860054e-001, 2.859999e-001, 2.859944e-001, 2.859889e-001, 2.859833e-001, 2.859778e-001, 2.859723e-001, 2.859667e-001, 2.859612e-001, 2.859557e-001, 2.859502e-001, 2.859446e-001, 2.859391e-001, 2.859336e-001, 2.859281e-001, 2.859225e-001, 2.859170e-001, 2.859115e-001, 2.859059e-001, 2.859004e-001, 2.858949e-001, 2.858893e-001, 2.858838e-001, 2.858783e-001, 2.858728e-001, 2.858672e-001, 2.858617e-001, 2.858562e-001, 2.858506e-001, 2.858451e-001, 2.858396e-001, 2.858340e-001, 2.858285e-001, 2.858230e-001, 2.858174e-001, 2.858119e-001, 2.858064e-001, 2.858009e-001, 2.857953e-001, 2.857898e-001, 2.857843e-001, 2.857787e-001, 2.857732e-001, 2.857677e-001, 2.857621e-001, 2.857566e-001, 2.857511e-001, 2.857455e-001, 2.857400e-001, 2.857345e-001, 2.857289e-001, 2.857234e-001, 2.857179e-001, 2.857123e-001, 2.857068e-001, 2.857013e-001, 2.856957e-001, 2.856902e-001, 2.856846e-001, 2.856791e-001, 2.856736e-001, 2.856680e-001, 2.856625e-001, 2.856570e-001, 2.856514e-001, 2.856459e-001, 2.856404e-001, 2.856348e-001, 2.856293e-001, 
2.856237e-001, 2.856182e-001, 2.856127e-001, 2.856071e-001, 2.856016e-001, 2.855961e-001, 2.855905e-001, 2.855850e-001, 2.855794e-001, 2.855739e-001, 2.855684e-001, 2.855628e-001, 2.855573e-001, 2.855517e-001, 2.855462e-001, 2.855407e-001, 2.855351e-001, 2.855296e-001, 2.855241e-001, 2.855185e-001, 2.855130e-001, 2.855074e-001, 2.855019e-001, 2.854964e-001, 2.854908e-001, 2.854853e-001, 2.854797e-001, 2.854742e-001, 2.854686e-001, 2.854631e-001, 2.854576e-001, 2.854520e-001, 2.854465e-001, 2.854409e-001, 2.854354e-001, 2.854299e-001, 2.854243e-001, 2.854188e-001, 2.854132e-001, 2.854077e-001, 2.854021e-001, 2.853966e-001, 2.853910e-001, 2.853855e-001, 2.853800e-001, 2.853744e-001, 2.853689e-001, 2.853633e-001, 2.853578e-001, 2.853522e-001, 2.853467e-001, 2.853411e-001, 2.853356e-001, 2.853301e-001, 2.853245e-001, 2.853190e-001, 2.853134e-001, 2.853079e-001, 2.853023e-001, 2.852968e-001, 2.852912e-001, 2.852857e-001, 2.852801e-001, 2.852746e-001, 2.852690e-001, 2.852635e-001, 2.852580e-001, 2.852524e-001, 2.852469e-001, 2.852413e-001, 2.852358e-001, 2.852302e-001, 2.852247e-001, 2.852191e-001, 2.852136e-001, 2.852080e-001, 2.852025e-001, 2.851969e-001, 2.851914e-001, 2.851858e-001, 2.851803e-001, 2.851747e-001, 2.851692e-001, 2.851636e-001, 2.851581e-001, 2.851525e-001, 2.851470e-001, 2.851414e-001, 2.851359e-001, 2.851303e-001, 2.851248e-001, 2.851192e-001, 2.851137e-001, 2.851081e-001, 2.851026e-001, 2.850970e-001, 2.850915e-001, 2.850859e-001, 2.850804e-001, 2.850748e-001, 
2.850693e-001, 2.850637e-001, 2.850581e-001, 2.850526e-001, 2.850470e-001, 2.850415e-001, 2.850359e-001, 2.850304e-001, 2.850248e-001, 2.850193e-001, 2.850137e-001, 2.850082e-001, 2.850026e-001, 2.849971e-001, 2.849915e-001, 2.849859e-001, 2.849804e-001, 2.849748e-001, 2.849693e-001, 2.849637e-001, 2.849582e-001, 2.849526e-001, 2.849471e-001, 2.849415e-001, 2.849359e-001, 2.849304e-001, 2.849248e-001, 2.849193e-001, 2.849137e-001, 2.849082e-001, 2.849026e-001, 2.848970e-001, 2.848915e-001, 2.848859e-001, 2.848804e-001, 2.848748e-001, 2.848693e-001, 2.848637e-001, 2.848581e-001, 2.848526e-001, 2.848470e-001, 2.848415e-001, 2.848359e-001, 2.848303e-001, 2.848248e-001, 2.848192e-001, 2.848137e-001, 2.848081e-001, 2.848025e-001, 2.847970e-001, 2.847914e-001, 2.847859e-001, 2.847803e-001, 2.847747e-001, 2.847692e-001, 2.847636e-001, 2.847581e-001, 2.847525e-001, 2.847469e-001, 2.847414e-001, 2.847358e-001, 2.847302e-001, 2.847247e-001, 2.847191e-001, 2.847136e-001, 2.847080e-001, 2.847024e-001, 2.846969e-001, 2.846913e-001, 2.846857e-001, 2.846802e-001, 2.846746e-001, 2.846691e-001, 2.846635e-001, 2.846579e-001, 2.846524e-001, 2.846468e-001, 2.846412e-001, 2.846357e-001, 2.846301e-001, 2.846245e-001, 2.846190e-001, 2.846134e-001, 2.846078e-001, 2.846023e-001, 2.845967e-001, 2.845911e-001, 2.845856e-001, 2.845800e-001, 2.845744e-001, 2.845689e-001, 2.845633e-001, 2.845577e-001, 2.845522e-001, 2.845466e-001, 2.845410e-001, 2.845355e-001, 2.845299e-001, 2.845243e-001, 2.845188e-001, 
2.845132e-001, 2.845076e-001, 2.845021e-001, 2.844965e-001, 2.844909e-001, 2.844854e-001, 2.844798e-001, 2.844742e-001, 2.844686e-001, 2.844631e-001, 2.844575e-001, 2.844519e-001, 2.844464e-001, 2.844408e-001, 2.844352e-001, 2.844297e-001, 2.844241e-001, 2.844185e-001, 2.844129e-001, 2.844074e-001, 2.844018e-001, 2.843962e-001, 2.843907e-001, 2.843851e-001, 2.843795e-001, 2.843739e-001, 2.843684e-001, 2.843628e-001, 2.843572e-001, 2.843517e-001, 2.843461e-001, 2.843405e-001, 2.843349e-001, 2.843294e-001, 2.843238e-001, 2.843182e-001, 2.843126e-001, 2.843071e-001, 2.843015e-001, 2.842959e-001, 2.842903e-001, 2.842848e-001, 2.842792e-001, 2.842736e-001, 2.842680e-001, 2.842625e-001, 2.842569e-001, 2.842513e-001, 2.842457e-001, 2.842402e-001, 2.842346e-001, 2.842290e-001, 2.842234e-001, 2.842179e-001, 2.842123e-001, 2.842067e-001, 2.842011e-001, 2.841956e-001, 2.841900e-001, 2.841844e-001, 2.841788e-001, 2.841732e-001, 2.841677e-001, 2.841621e-001, 2.841565e-001, 2.841509e-001, 2.841453e-001, 2.841398e-001, 2.841342e-001, 2.841286e-001, 2.841230e-001, 2.841175e-001, 2.841119e-001, 2.841063e-001, 2.841007e-001, 2.840951e-001, 2.840896e-001, 2.840840e-001, 2.840784e-001, 2.840728e-001, 2.840672e-001, 2.840617e-001, 2.840561e-001, 2.840505e-001, 2.840449e-001, 2.840393e-001, 2.840337e-001, 2.840282e-001, 2.840226e-001, 2.840170e-001, 2.840114e-001, 2.840058e-001, 2.840003e-001, 2.839947e-001, 2.839891e-001, 2.839835e-001, 2.839779e-001, 2.839723e-001, 2.839668e-001, 2.839612e-001, 
2.839556e-001, 2.839500e-001, 2.839444e-001, 2.839388e-001, 2.839332e-001, 2.839277e-001, 2.839221e-001, 2.839165e-001, 2.839109e-001, 2.839053e-001, 2.838997e-001, 2.838942e-001, 2.838886e-001, 2.838830e-001, 2.838774e-001, 2.838718e-001, 2.838662e-001, 2.838606e-001, 2.838551e-001, 2.838495e-001, 2.838439e-001, 2.838383e-001, 2.838327e-001, 2.838271e-001, 2.838215e-001, 2.838159e-001, 2.838104e-001, 2.838048e-001, 2.837992e-001, 2.837936e-001, 2.837880e-001, 2.837824e-001, 2.837768e-001, 2.837712e-001, 2.837656e-001, 2.837601e-001, 2.837545e-001, 2.837489e-001, 2.837433e-001, 2.837377e-001, 2.837321e-001, 2.837265e-001, 2.837209e-001, 2.837153e-001, 2.837097e-001, 2.837042e-001, 2.836986e-001, 2.836930e-001, 2.836874e-001, 2.836818e-001, 2.836762e-001, 2.836706e-001, 2.836650e-001, 2.836594e-001, 2.836538e-001, 2.836482e-001, 2.836426e-001, 2.836371e-001, 2.836315e-001, 2.836259e-001, 2.836203e-001, 2.836147e-001, 2.836091e-001, 2.836035e-001, 2.835979e-001, 2.835923e-001, 2.835867e-001, 2.835811e-001, 2.835755e-001, 2.835699e-001, 2.835643e-001, 2.835587e-001, 2.835531e-001, 2.835475e-001, 2.835420e-001, 2.835364e-001, 2.835308e-001, 2.835252e-001, 2.835196e-001, 2.835140e-001, 2.835084e-001, 2.835028e-001, 2.834972e-001, 2.834916e-001, 2.834860e-001, 2.834804e-001, 2.834748e-001, 2.834692e-001, 2.834636e-001, 2.834580e-001, 2.834524e-001, 2.834468e-001, 2.834412e-001, 2.834356e-001, 2.834300e-001, 2.834244e-001, 2.834188e-001, 2.834132e-001, 2.834076e-001, 2.834020e-001, 
2.833964e-001, 2.833908e-001, 2.833852e-001, 2.833796e-001, 2.833740e-001, 2.833684e-001, 2.833628e-001, 2.833572e-001, 2.833516e-001, 2.833460e-001, 2.833404e-001, 2.833348e-001, 2.833292e-001, 2.833236e-001, 2.833180e-001, 2.833124e-001, 2.833068e-001, 2.833012e-001, 2.832956e-001, 2.832900e-001, 2.832844e-001, 2.832788e-001, 2.832732e-001, 2.832676e-001, 2.832620e-001, 2.832564e-001, 2.832508e-001, 2.832452e-001, 2.832396e-001, 2.832340e-001, 2.832284e-001, 2.832228e-001, 2.832172e-001, 2.832116e-001, 2.832059e-001, 2.832003e-001, 2.831947e-001, 2.831891e-001, 2.831835e-001, 2.831779e-001, 2.831723e-001, 2.831667e-001, 2.831611e-001, 2.831555e-001, 2.831499e-001, 2.831443e-001, 2.831387e-001, 2.831331e-001, 2.831275e-001, 2.831219e-001, 2.831163e-001, 2.831106e-001, 2.831050e-001, 2.830994e-001, 2.830938e-001, 2.830882e-001, 2.830826e-001, 2.830770e-001, 2.830714e-001, 2.830658e-001, 2.830602e-001, 2.830546e-001, 2.830490e-001, 2.830433e-001, 2.830377e-001, 2.830321e-001, 2.830265e-001, 2.830209e-001, 2.830153e-001, 2.830097e-001, 2.830041e-001, 2.829985e-001, 2.829929e-001, 2.829872e-001, 2.829816e-001, 2.829760e-001, 2.829704e-001, 2.829648e-001, 2.829592e-001, 2.829536e-001, 2.829480e-001, 2.829424e-001, 2.829367e-001, 2.829311e-001, 2.829255e-001, 2.829199e-001, 2.829143e-001, 2.829087e-001, 2.829031e-001, 2.828975e-001, 2.828918e-001, 2.828862e-001, 2.828806e-001, 2.828750e-001, 2.828694e-001, 2.828638e-001, 2.828582e-001, 2.828525e-001, 2.828469e-001, 2.828413e-001, 
2.828357e-001, 2.828301e-001, 2.828245e-001, 2.828189e-001, 2.828132e-001, 2.828076e-001, 2.828020e-001, 2.827964e-001, 2.827908e-001, 2.827852e-001, 2.827795e-001, 2.827739e-001, 2.827683e-001, 2.827627e-001, 2.827571e-001, 2.827515e-001, 2.827458e-001, 2.827402e-001, 2.827346e-001, 2.827290e-001, 2.827234e-001, 2.827178e-001, 2.827121e-001, 2.827065e-001, 2.827009e-001, 2.826953e-001, 2.826897e-001, 2.826840e-001, 2.826784e-001, 2.826728e-001, 2.826672e-001, 2.826616e-001, 2.826559e-001, 2.826503e-001, 2.826447e-001, 2.826391e-001, 2.826335e-001, 2.826278e-001, 2.826222e-001, 2.826166e-001, 2.826110e-001, 2.826054e-001, 2.825997e-001, 2.825941e-001, 2.825885e-001, 2.825829e-001, 2.825772e-001, 2.825716e-001, 2.825660e-001, 2.825604e-001, 2.825548e-001, 2.825491e-001, 2.825435e-001, 2.825379e-001, 2.825323e-001, 2.825266e-001, 2.825210e-001, 2.825154e-001, 2.825098e-001, 2.825041e-001, 2.824985e-001, 2.824929e-001, 2.824873e-001, 2.824817e-001, 2.824760e-001, 2.824704e-001, 2.824648e-001, 2.824592e-001, 2.824535e-001, 2.824479e-001, 2.824423e-001, 2.824366e-001, 2.824310e-001, 2.824254e-001, 2.824198e-001, 2.824141e-001, 2.824085e-001, 2.824029e-001, 2.823973e-001, 2.823916e-001, 2.823860e-001, 2.823804e-001, 2.823748e-001, 2.823691e-001, 2.823635e-001, 2.823579e-001, 2.823522e-001, 2.823466e-001, 2.823410e-001, 2.823354e-001, 2.823297e-001, 2.823241e-001, 2.823185e-001, 2.823128e-001, 2.823072e-001, 2.823016e-001, 2.822960e-001, 2.822903e-001, 2.822847e-001, 2.822791e-001, 
2.822734e-001, 2.822678e-001, 2.822622e-001, 2.822565e-001, 2.822509e-001, 2.822453e-001, 2.822396e-001, 2.822340e-001, 2.822284e-001, 2.822228e-001, 2.822171e-001, 2.822115e-001, 2.822059e-001, 2.822002e-001, 2.821946e-001, 2.821890e-001, 2.821833e-001, 2.821777e-001, 2.821721e-001, 2.821664e-001, 2.821608e-001, 2.821552e-001, 2.821495e-001, 2.821439e-001, 2.821383e-001, 2.821326e-001, 2.821270e-001, 2.821214e-001, 2.821157e-001, 2.821101e-001, 2.821044e-001, 2.820988e-001, 2.820932e-001, 2.820875e-001, 2.820819e-001, 2.820763e-001, 2.820706e-001, 2.820650e-001, 2.820594e-001, 2.820537e-001, 2.820481e-001, 2.820425e-001, 2.820368e-001, 2.820312e-001, 2.820255e-001, 2.820199e-001, 2.820143e-001, 2.820086e-001, 2.820030e-001, 2.819974e-001, 2.819917e-001, 2.819861e-001, 2.819804e-001, 2.819748e-001, 2.819692e-001, 2.819635e-001, 2.819579e-001, 2.819522e-001, 2.819466e-001, 2.819410e-001, 2.819353e-001, 2.819297e-001, 2.819240e-001, 2.819184e-001, 2.819128e-001, 2.819071e-001, 2.819015e-001, 2.818958e-001, 2.818902e-001, 2.818846e-001, 2.818789e-001, 2.818733e-001, 2.818676e-001, 2.818620e-001, 2.818564e-001, 2.818507e-001, 2.818451e-001, 2.818394e-001, 2.818338e-001, 2.818281e-001, 2.818225e-001, 2.818169e-001, 2.818112e-001, 2.818056e-001, 2.817999e-001, 2.817943e-001, 2.817886e-001, 2.817830e-001, 2.817774e-001, 2.817717e-001, 2.817661e-001, 2.817604e-001, 2.817548e-001, 2.817491e-001, 2.817435e-001, 2.817378e-001, 2.817322e-001, 2.817265e-001, 2.817209e-001, 2.817153e-001, 
2.817096e-001, 2.817040e-001, 2.816983e-001, 2.816927e-001, 2.816870e-001, 2.816814e-001, 2.816757e-001, 2.816701e-001, 2.816644e-001, 2.816588e-001, 2.816531e-001, 2.816475e-001, 2.816419e-001, 2.816362e-001, 2.816306e-001, 2.816249e-001, 2.816193e-001, 2.816136e-001, 2.816080e-001, 2.816023e-001, 2.815967e-001, 2.815910e-001, 2.815854e-001, 2.815797e-001, 2.815741e-001, 2.815684e-001, 2.815628e-001, 2.815571e-001, 2.815515e-001, 2.815458e-001, 2.815402e-001, 2.815345e-001, 2.815289e-001, 2.815232e-001, 2.815176e-001, 2.815119e-001, 2.815063e-001, 2.815006e-001, 2.814950e-001, 2.814893e-001, 2.814837e-001, 2.814780e-001, 2.814723e-001, 2.814667e-001, 2.814610e-001, 2.814554e-001, 2.814497e-001, 2.814441e-001, 2.814384e-001, 2.814328e-001, 2.814271e-001, 2.814215e-001, 2.814158e-001, 2.814102e-001, 2.814045e-001, 2.813989e-001, 2.813932e-001, 2.813875e-001, 2.813819e-001, 2.813762e-001, 2.813706e-001, 2.813649e-001, 2.813593e-001, 2.813536e-001, 2.813480e-001, 2.813423e-001, 2.813366e-001, 2.813310e-001, 2.813253e-001, 2.813197e-001, 2.813140e-001, 2.813084e-001, 2.813027e-001, 2.812970e-001, 2.812914e-001, 2.812857e-001, 2.812801e-001, 2.812744e-001, 2.812688e-001, 2.812631e-001, 2.812574e-001, 2.812518e-001, 2.812461e-001, 2.812405e-001, 2.812348e-001, 2.812292e-001, 2.812235e-001, 2.812178e-001, 2.812122e-001, 2.812065e-001, 2.812009e-001, 2.811952e-001, 2.811895e-001, 2.811839e-001, 2.811782e-001, 2.811726e-001, 2.811669e-001, 2.811612e-001, 2.811556e-001, 2.811499e-001, 
2.811442e-001, 2.811386e-001, 2.811329e-001, 2.811273e-001, 2.811216e-001, 2.811159e-001, 2.811103e-001, 2.811046e-001, 2.810990e-001, 2.810933e-001, 2.810876e-001, 2.810820e-001, 2.810763e-001, 2.810706e-001, 2.810650e-001, 2.810593e-001, 2.810536e-001, 2.810480e-001, 2.810423e-001, 2.810367e-001, 2.810310e-001, 2.810253e-001, 2.810197e-001, 2.810140e-001, 2.810083e-001, 2.810027e-001, 2.809970e-001, 2.809913e-001, 2.809857e-001, 2.809800e-001, 2.809743e-001, 2.809687e-001, 2.809630e-001, 2.809573e-001, 2.809517e-001, 2.809460e-001, 2.809403e-001, 2.809347e-001, 2.809290e-001, 2.809233e-001, 2.809177e-001, 2.809120e-001, 2.809063e-001, 2.809007e-001, 2.808950e-001, 2.808893e-001, 2.808837e-001, 2.808780e-001, 2.808723e-001, 2.808667e-001, 2.808610e-001, 2.808553e-001, 2.808497e-001, 2.808440e-001, 2.808383e-001, 2.808326e-001, 2.808270e-001, 2.808213e-001, 2.808156e-001, 2.808100e-001, 2.808043e-001, 2.807986e-001, 2.807929e-001, 2.807873e-001, 2.807816e-001, 2.807759e-001, 2.807703e-001, 2.807646e-001, 2.807589e-001, 2.807532e-001, 2.807476e-001, 2.807419e-001, 2.807362e-001, 2.807306e-001, 2.807249e-001, 2.807192e-001, 2.807135e-001, 2.807079e-001, 2.807022e-001, 2.806965e-001, 2.806908e-001, 2.806852e-001, 2.806795e-001, 2.806738e-001, 2.806682e-001, 2.806625e-001, 2.806568e-001, 2.806511e-001, 2.806455e-001, 2.806398e-001, 2.806341e-001, 2.806284e-001, 2.806228e-001, 2.806171e-001, 2.806114e-001, 2.806057e-001, 2.806000e-001, 2.805944e-001, 2.805887e-001, 2.805830e-001, 
2.805773e-001, 2.805717e-001, 2.805660e-001, 2.805603e-001, 2.805546e-001, 2.805490e-001, 2.805433e-001, 2.805376e-001, 2.805319e-001, 2.805262e-001, 2.805206e-001, 2.805149e-001, 2.805092e-001, 2.805035e-001, 2.804979e-001, 2.804922e-001, 2.804865e-001, 2.804808e-001, 2.804751e-001, 2.804695e-001, 2.804638e-001, 2.804581e-001, 2.804524e-001, 2.804467e-001, 2.804411e-001, 2.804354e-001, 2.804297e-001, 2.804240e-001, 2.804183e-001, 2.804127e-001, 2.804070e-001, 2.804013e-001, 2.803956e-001, 2.803899e-001, 2.803842e-001, 2.803786e-001, 2.803729e-001, 2.803672e-001, 2.803615e-001, 2.803558e-001, 2.803501e-001, 2.803445e-001, 2.803388e-001, 2.803331e-001, 2.803274e-001, 2.803217e-001, 2.803160e-001, 2.803104e-001, 2.803047e-001, 2.802990e-001, 2.802933e-001, 2.802876e-001, 2.802819e-001, 2.802763e-001, 2.802706e-001, 2.802649e-001, 2.802592e-001, 2.802535e-001, 2.802478e-001, 2.802421e-001, 2.802365e-001, 2.802308e-001, 2.802251e-001, 2.802194e-001, 2.802137e-001, 2.802080e-001, 2.802023e-001, 2.801967e-001, 2.801910e-001, 2.801853e-001, 2.801796e-001, 2.801739e-001, 2.801682e-001, 2.801625e-001, 2.801568e-001, 2.801512e-001, 2.801455e-001, 2.801398e-001, 2.801341e-001, 2.801284e-001, 2.801227e-001, 2.801170e-001, 2.801113e-001, 2.801056e-001, 2.801000e-001, 2.800943e-001, 2.800886e-001, 2.800829e-001, 2.800772e-001, 2.800715e-001, 2.800658e-001, 2.800601e-001, 2.800544e-001, 2.800487e-001, 2.800430e-001, 2.800374e-001, 2.800317e-001, 2.800260e-001, 2.800203e-001, 2.800146e-001, 
2.800089e-001, 2.800032e-001, 2.799975e-001, 2.799918e-001, 2.799861e-001, 2.799804e-001, 2.799747e-001, 2.799690e-001, 2.799634e-001, 2.799577e-001, 2.799520e-001, 2.799463e-001, 2.799406e-001, 2.799349e-001, 2.799292e-001, 2.799235e-001, 2.799178e-001, 2.799121e-001, 2.799064e-001, 2.799007e-001, 2.798950e-001, 2.798893e-001, 2.798836e-001, 2.798779e-001, 2.798722e-001, 2.798665e-001, 2.798608e-001, 2.798552e-001, 2.798495e-001, 2.798438e-001, 2.798381e-001, 2.798324e-001, 2.798267e-001, 2.798210e-001, 2.798153e-001, 2.798096e-001, 2.798039e-001, 2.797982e-001, 2.797925e-001, 2.797868e-001, 2.797811e-001, 2.797754e-001, 2.797697e-001, 2.797640e-001, 2.797583e-001, 2.797526e-001, 2.797469e-001, 2.797412e-001, 2.797355e-001, 2.797298e-001, 2.797241e-001, 2.797184e-001, 2.797127e-001, 2.797070e-001, 2.797013e-001, 2.796956e-001, 2.796899e-001, 2.796842e-001, 2.796785e-001, 2.796728e-001, 2.796671e-001, 2.796614e-001, 2.796557e-001, 2.796500e-001, 2.796443e-001, 2.796386e-001, 2.796329e-001, 2.796272e-001, 2.796215e-001, 2.796158e-001, 2.796101e-001, 2.796044e-001, 2.795987e-001, 2.795930e-001, 2.795873e-001, 2.795816e-001, 2.795758e-001, 2.795701e-001, 2.795644e-001, 2.795587e-001, 2.795530e-001, 2.795473e-001, 2.795416e-001, 2.795359e-001, 2.795302e-001, 2.795245e-001, 2.795188e-001, 2.795131e-001, 2.795074e-001, 2.795017e-001, 2.794960e-001, 2.794903e-001, 2.794846e-001, 2.794789e-001, 2.794732e-001, 2.794674e-001, 2.794617e-001, 2.794560e-001, 2.794503e-001, 2.794446e-001, 
2.794389e-001, 2.794332e-001, 2.794275e-001, 2.794218e-001, 2.794161e-001, 2.794104e-001, 2.794047e-001, 2.793990e-001, 2.793932e-001, 2.793875e-001, 2.793818e-001, 2.793761e-001, 2.793704e-001, 2.793647e-001, 2.793590e-001, 2.793533e-001, 2.793476e-001, 2.793419e-001, 2.793361e-001, 2.793304e-001, 2.793247e-001, 2.793190e-001, 2.793133e-001, 2.793076e-001, 2.793019e-001, 2.792962e-001, 2.792905e-001, 2.792847e-001, 2.792790e-001, 2.792733e-001, 2.792676e-001, 2.792619e-001, 2.792562e-001, 2.792505e-001, 2.792448e-001, 2.792391e-001, 2.792333e-001, 2.792276e-001, 2.792219e-001, 2.792162e-001, 2.792105e-001, 2.792048e-001, 2.791991e-001, 2.791933e-001, 2.791876e-001, 2.791819e-001, 2.791762e-001, 2.791705e-001, 2.791648e-001, 2.791591e-001, 2.791533e-001, 2.791476e-001, 2.791419e-001, 2.791362e-001, 2.791305e-001, 2.791248e-001, 2.791190e-001, 2.791133e-001, 2.791076e-001, 2.791019e-001, 2.790962e-001, 2.790905e-001, 2.790847e-001, 2.790790e-001, 2.790733e-001, 2.790676e-001, 2.790619e-001, 2.790562e-001, 2.790504e-001, 2.790447e-001, 2.790390e-001, 2.790333e-001, 2.790276e-001, 2.790218e-001, 2.790161e-001, 2.790104e-001, 2.790047e-001, 2.789990e-001, 2.789933e-001, 2.789875e-001, 2.789818e-001, 2.789761e-001, 2.789704e-001, 2.789647e-001, 2.789589e-001, 2.789532e-001, 2.789475e-001, 2.789418e-001, 2.789361e-001, 2.789303e-001, 2.789246e-001, 2.789189e-001, 2.789132e-001, 2.789074e-001, 2.789017e-001, 2.788960e-001, 2.788903e-001, 2.788846e-001, 2.788788e-001, 2.788731e-001, 
2.788674e-001, 2.788617e-001, 2.788559e-001, 2.788502e-001, 2.788445e-001, 2.788388e-001, 2.788330e-001, 2.788273e-001, 2.788216e-001, 2.788159e-001, 2.788102e-001, 2.788044e-001, 2.787987e-001, 2.787930e-001, 2.787873e-001, 2.787815e-001, 2.787758e-001, 2.787701e-001, 2.787644e-001, 2.787586e-001, 2.787529e-001, 2.787472e-001, 2.787414e-001, 2.787357e-001, 2.787300e-001, 2.787243e-001, 2.787185e-001, 2.787128e-001, 2.787071e-001, 2.787014e-001, 2.786956e-001, 2.786899e-001, 2.786842e-001, 2.786784e-001, 2.786727e-001, 2.786670e-001, 2.786613e-001, 2.786555e-001, 2.786498e-001, 2.786441e-001, 2.786383e-001, 2.786326e-001, 2.786269e-001, 2.786212e-001, 2.786154e-001, 2.786097e-001, 2.786040e-001, 2.785982e-001, 2.785925e-001, 2.785868e-001, 2.785811e-001, 2.785753e-001, 2.785696e-001, 2.785639e-001, 2.785581e-001, 2.785524e-001, 2.785467e-001, 2.785409e-001, 2.785352e-001, 2.785295e-001, 2.785237e-001, 2.785180e-001, 2.785123e-001, 2.785065e-001, 2.785008e-001, 2.784951e-001, 2.784893e-001, 2.784836e-001, 2.784779e-001, 2.784721e-001, 2.784664e-001, 2.784607e-001, 2.784549e-001, 2.784492e-001, 2.784435e-001, 2.784377e-001, 2.784320e-001, 2.784263e-001, 2.784205e-001, 2.784148e-001, 2.784091e-001, 2.784033e-001, 2.783976e-001, 2.783919e-001, 2.783861e-001, 2.783804e-001, 2.783747e-001, 2.783689e-001, 2.783632e-001, 2.783574e-001, 2.783517e-001, 2.783460e-001, 2.783402e-001, 2.783345e-001, 2.783288e-001, 2.783230e-001, 2.783173e-001, 2.783115e-001, 2.783058e-001, 2.783001e-001, 
2.782943e-001, 2.782886e-001, 2.782829e-001, 2.782771e-001, 2.782714e-001, 2.782656e-001, 2.782599e-001, 2.782542e-001, 2.782484e-001, 2.782427e-001, 2.782369e-001, 2.782312e-001, 2.782255e-001, 2.782197e-001, 2.782140e-001, 2.782082e-001, 2.782025e-001, 2.781968e-001, 2.781910e-001, 2.781853e-001, 2.781795e-001, 2.781738e-001, 2.781681e-001, 2.781623e-001, 2.781566e-001, 2.781508e-001, 2.781451e-001, 2.781393e-001, 2.781336e-001, 2.781279e-001, 2.781221e-001, 2.781164e-001, 2.781106e-001, 2.781049e-001, 2.780991e-001, 2.780934e-001, 2.780877e-001, 2.780819e-001, 2.780762e-001, 2.780704e-001, 2.780647e-001, 2.780589e-001, 2.780532e-001, 2.780474e-001, 2.780417e-001, 2.780360e-001, 2.780302e-001, 2.780245e-001, 2.780187e-001, 2.780130e-001, 2.780072e-001, 2.780015e-001, 2.779957e-001, 2.779900e-001, 2.779842e-001, 2.779785e-001, 2.779728e-001, 2.779670e-001, 2.779613e-001, 2.779555e-001, 2.779498e-001, 2.779440e-001, 2.779383e-001, 2.779325e-001, 2.779268e-001, 2.779210e-001, 2.779153e-001, 2.779095e-001, 2.779038e-001, 2.778980e-001, 2.778923e-001, 2.778865e-001, 2.778808e-001, 2.778750e-001, 2.778693e-001, 2.778635e-001, 2.778578e-001, 2.778520e-001, 2.778463e-001, 2.778405e-001, 2.778348e-001, 2.778290e-001, 2.778233e-001, 2.778175e-001, 2.778118e-001, 2.778060e-001, 2.778003e-001, 2.777945e-001, 2.777888e-001, 2.777830e-001, 2.777773e-001, 2.777715e-001, 2.777658e-001, 2.777600e-001, 2.777543e-001, 2.777485e-001, 2.777428e-001, 2.777370e-001, 2.777313e-001, 2.777255e-001, 
2.777197e-001, 2.777140e-001, 2.777082e-001, 2.777025e-001, 2.776967e-001, 2.776910e-001, 2.776852e-001, 2.776795e-001, 2.776737e-001, 2.776680e-001, 2.776622e-001, 2.776564e-001, 2.776507e-001, 2.776449e-001, 2.776392e-001, 2.776334e-001, 2.776277e-001, 2.776219e-001, 2.776162e-001, 2.776104e-001, 2.776046e-001, 2.775989e-001, 2.775931e-001, 2.775874e-001, 2.775816e-001, 2.775759e-001, 2.775701e-001, 2.775643e-001, 2.775586e-001, 2.775528e-001, 2.775471e-001, 2.775413e-001, 2.775356e-001, 2.775298e-001, 2.775240e-001, 2.775183e-001, 2.775125e-001, 2.775068e-001, 2.775010e-001, 2.774952e-001, 2.774895e-001, 2.774837e-001, 2.774780e-001, 2.774722e-001, 2.774664e-001, 2.774607e-001, 2.774549e-001, 2.774492e-001, 2.774434e-001, 2.774376e-001, 2.774319e-001, 2.774261e-001, 2.774204e-001, 2.774146e-001, 2.774088e-001, 2.774031e-001, 2.773973e-001, 2.773915e-001, 2.773858e-001, 2.773800e-001, 2.773743e-001, 2.773685e-001, 2.773627e-001, 2.773570e-001, 2.773512e-001, 2.773454e-001, 2.773397e-001, 2.773339e-001, 2.773282e-001, 2.773224e-001, 2.773166e-001, 2.773109e-001, 2.773051e-001, 2.772993e-001, 2.772936e-001, 2.772878e-001, 2.772820e-001, 2.772763e-001, 2.772705e-001, 2.772647e-001, 2.772590e-001, 2.772532e-001, 2.772474e-001, 2.772417e-001, 2.772359e-001, 2.772301e-001, 2.772244e-001, 2.772186e-001, 2.772128e-001, 2.772071e-001, 2.772013e-001, 2.771955e-001, 2.771898e-001, 2.771840e-001, 2.771782e-001, 2.771725e-001, 2.771667e-001, 2.771609e-001, 2.771552e-001, 2.771494e-001, 
2.771436e-001, 2.771379e-001, 2.771321e-001, 2.771263e-001, 2.771206e-001, 2.771148e-001, 2.771090e-001, 2.771032e-001, 2.770975e-001, 2.770917e-001, 2.770859e-001, 2.770802e-001, 2.770744e-001, 2.770686e-001, 2.770629e-001, 2.770571e-001, 2.770513e-001, 2.770455e-001, 2.770398e-001, 2.770340e-001, 2.770282e-001, 2.770224e-001, 2.770167e-001, 2.770109e-001, 2.770051e-001, 2.769994e-001, 2.769936e-001, 2.769878e-001, 2.769820e-001, 2.769763e-001, 2.769705e-001, 2.769647e-001, 2.769589e-001, 2.769532e-001, 2.769474e-001, 2.769416e-001, 2.769359e-001, 2.769301e-001, 2.769243e-001, 2.769185e-001, 2.769128e-001, 2.769070e-001, 2.769012e-001, 2.768954e-001, 2.768897e-001, 2.768839e-001, 2.768781e-001, 2.768723e-001, 2.768666e-001, 2.768608e-001, 2.768550e-001, 2.768492e-001, 2.768434e-001, 2.768377e-001, 2.768319e-001, 2.768261e-001, 2.768203e-001, 2.768146e-001, 2.768088e-001, 2.768030e-001, 2.767972e-001, 2.767914e-001, 2.767857e-001, 2.767799e-001, 2.767741e-001, 2.767683e-001, 2.767626e-001, 2.767568e-001, 2.767510e-001, 2.767452e-001, 2.767394e-001, 2.767337e-001, 2.767279e-001, 2.767221e-001, 2.767163e-001, 2.767105e-001, 2.767048e-001, 2.766990e-001, 2.766932e-001, 2.766874e-001, 2.766816e-001, 2.766759e-001, 2.766701e-001, 2.766643e-001, 2.766585e-001, 2.766527e-001, 2.766469e-001, 2.766412e-001, 2.766354e-001, 2.766296e-001, 2.766238e-001, 2.766180e-001, 2.766123e-001, 2.766065e-001, 2.766007e-001, 2.765949e-001, 2.765891e-001, 2.765833e-001, 2.765776e-001, 2.765718e-001, 
2.765660e-001, 2.765602e-001, 2.765544e-001, 2.765486e-001, 2.765428e-001, 2.765371e-001, 2.765313e-001, 2.765255e-001, 2.765197e-001, 2.765139e-001, 2.765081e-001, 2.765024e-001, 2.764966e-001, 2.764908e-001, 2.764850e-001, 2.764792e-001, 2.764734e-001, 2.764676e-001, 2.764618e-001, 2.764561e-001, 2.764503e-001, 2.764445e-001, 2.764387e-001, 2.764329e-001, 2.764271e-001, 2.764213e-001, 2.764155e-001, 2.764098e-001, 2.764040e-001, 2.763982e-001, 2.763924e-001, 2.763866e-001, 2.763808e-001, 2.763750e-001, 2.763692e-001, 2.763635e-001, 2.763577e-001, 2.763519e-001, 2.763461e-001, 2.763403e-001, 2.763345e-001, 2.763287e-001, 2.763229e-001, 2.763171e-001, 2.763113e-001, 2.763055e-001, 2.762998e-001, 2.762940e-001, 2.762882e-001, 2.762824e-001, 2.762766e-001, 2.762708e-001, 2.762650e-001, 2.762592e-001, 2.762534e-001, 2.762476e-001, 2.762418e-001, 2.762360e-001, 2.762303e-001, 2.762245e-001, 2.762187e-001, 2.762129e-001, 2.762071e-001, 2.762013e-001, 2.761955e-001, 2.761897e-001, 2.761839e-001, 2.761781e-001, 2.761723e-001, 2.761665e-001, 2.761607e-001, 2.761549e-001, 2.761491e-001, 2.761433e-001, 2.761375e-001, 2.761318e-001, 2.761260e-001, 2.761202e-001, 2.761144e-001, 2.761086e-001, 2.761028e-001, 2.760970e-001, 2.760912e-001, 2.760854e-001, 2.760796e-001, 2.760738e-001, 2.760680e-001, 2.760622e-001, 2.760564e-001, 2.760506e-001, 2.760448e-001, 2.760390e-001, 2.760332e-001, 2.760274e-001, 2.760216e-001, 2.760158e-001, 2.760100e-001, 2.760042e-001, 2.759984e-001, 2.759926e-001, 
2.759868e-001, 2.759810e-001, 2.759752e-001, 2.759694e-001, 2.759636e-001, 2.759578e-001, 2.759520e-001, 2.759462e-001, 2.759404e-001, 2.759346e-001, 2.759288e-001, 2.759230e-001, 2.759172e-001, 2.759114e-001, 2.759056e-001, 2.758998e-001, 2.758940e-001, 2.758882e-001, 2.758824e-001, 2.758766e-001, 2.758708e-001, 2.758650e-001, 2.758592e-001, 2.758534e-001, 2.758476e-001, 2.758418e-001, 2.758360e-001, 2.758302e-001, 2.758244e-001, 2.758186e-001, 2.758128e-001, 2.758070e-001, 2.758012e-001, 2.757954e-001, 2.757896e-001, 2.757837e-001, 2.757779e-001, 2.757721e-001, 2.757663e-001, 2.757605e-001, 2.757547e-001, 2.757489e-001, 2.757431e-001, 2.757373e-001, 2.757315e-001, 2.757257e-001, 2.757199e-001, 2.757141e-001, 2.757083e-001, 2.757025e-001, 2.756967e-001, 2.756909e-001, 2.756850e-001, 2.756792e-001, 2.756734e-001, 2.756676e-001, 2.756618e-001, 2.756560e-001, 2.756502e-001, 2.756444e-001, 2.756386e-001, 2.756328e-001, 2.756270e-001, 2.756212e-001, 2.756154e-001, 2.756095e-001, 2.756037e-001, 2.755979e-001, 2.755921e-001, 2.755863e-001, 2.755805e-001, 2.755747e-001, 2.755689e-001, 2.755631e-001, 2.755573e-001, 2.755514e-001, 2.755456e-001, 2.755398e-001, 2.755340e-001, 2.755282e-001, 2.755224e-001, 2.755166e-001, 2.755108e-001, 2.755050e-001, 2.754991e-001, 2.754933e-001, 2.754875e-001, 2.754817e-001, 2.754759e-001, 2.754701e-001, 2.754643e-001, 2.754585e-001, 2.754526e-001, 2.754468e-001, 2.754410e-001, 2.754352e-001, 2.754294e-001, 2.754236e-001, 2.754178e-001, 2.754119e-001, 
2.754061e-001, 2.754003e-001, 2.753945e-001, 2.753887e-001, 2.753829e-001, 2.753771e-001, 2.753712e-001, 2.753654e-001, 2.753596e-001, 2.753538e-001, 2.753480e-001, 2.753422e-001, 2.753363e-001, 2.753305e-001, 2.753247e-001, 2.753189e-001, 2.753131e-001, 2.753073e-001, 2.753014e-001, 2.752956e-001, 2.752898e-001, 2.752840e-001, 2.752782e-001, 2.752724e-001, 2.752665e-001, 2.752607e-001, 2.752549e-001, 2.752491e-001, 2.752433e-001, 2.752374e-001, 2.752316e-001, 2.752258e-001, 2.752200e-001, 2.752142e-001, 2.752083e-001, 2.752025e-001, 2.751967e-001, 2.751909e-001, 2.751851e-001, 2.751792e-001, 2.751734e-001, 2.751676e-001, 2.751618e-001, 2.751560e-001, 2.751501e-001, 2.751443e-001, 2.751385e-001, 2.751327e-001, 2.751269e-001, 2.751210e-001, 2.751152e-001, 2.751094e-001, 2.751036e-001, 2.750977e-001, 2.750919e-001, 2.750861e-001, 2.750803e-001, 2.750745e-001, 2.750686e-001, 2.750628e-001, 2.750570e-001, 2.750512e-001, 2.750453e-001, 2.750395e-001, 2.750337e-001, 2.750279e-001, 2.750220e-001, 2.750162e-001, 2.750104e-001, 2.750046e-001, 2.749987e-001, 2.749929e-001, 2.749871e-001, 2.749813e-001, 2.749754e-001, 2.749696e-001, 2.749638e-001, 2.749580e-001, 2.749521e-001, 2.749463e-001, 2.749405e-001, 2.749347e-001, 2.749288e-001, 2.749230e-001, 2.749172e-001, 2.749113e-001, 2.749055e-001, 2.748997e-001, 2.748939e-001, 2.748880e-001, 2.748822e-001, 2.748764e-001, 2.748706e-001, 2.748647e-001, 2.748589e-001, 2.748531e-001, 2.748472e-001, 2.748414e-001, 2.748356e-001, 2.748297e-001, 
2.748239e-001, 2.748181e-001, 2.748123e-001, 2.748064e-001, 2.748006e-001, 2.747948e-001, 2.747889e-001, 2.747831e-001, 2.747773e-001, 2.747714e-001, 2.747656e-001, 2.747598e-001, 2.747540e-001, 2.747481e-001, 2.747423e-001, 2.747365e-001, 2.747306e-001, 2.747248e-001, 2.747190e-001, 2.747131e-001, 2.747073e-001, 2.747015e-001, 2.746956e-001, 2.746898e-001, 2.746840e-001, 2.746781e-001, 2.746723e-001, 2.746665e-001, 2.746606e-001, 2.746548e-001, 2.746490e-001, 2.746431e-001, 2.746373e-001, 2.746315e-001, 2.746256e-001, 2.746198e-001, 2.746140e-001, 2.746081e-001, 2.746023e-001, 2.745964e-001, 2.745906e-001, 2.745848e-001, 2.745789e-001, 2.745731e-001, 2.745673e-001, 2.745614e-001, 2.745556e-001, 2.745498e-001, 2.745439e-001, 2.745381e-001, 2.745322e-001, 2.745264e-001, 2.745206e-001, 2.745147e-001, 2.745089e-001, 2.745031e-001, 2.744972e-001, 2.744914e-001, 2.744855e-001, 2.744797e-001, 2.744739e-001, 2.744680e-001, 2.744622e-001, 2.744563e-001, 2.744505e-001, 2.744447e-001, 2.744388e-001, 2.744330e-001, 2.744272e-001, 2.744213e-001, 2.744155e-001, 2.744096e-001, 2.744038e-001, 2.743979e-001, 2.743921e-001, 2.743863e-001, 2.743804e-001, 2.743746e-001, 2.743687e-001, 2.743629e-001, 2.743571e-001, 2.743512e-001, 2.743454e-001, 2.743395e-001, 2.743337e-001, 2.743278e-001, 2.743220e-001, 2.743162e-001, 2.743103e-001, 2.743045e-001, 2.742986e-001, 2.742928e-001, 2.742869e-001, 2.742811e-001, 2.742753e-001, 2.742694e-001, 2.742636e-001, 2.742577e-001, 2.742519e-001, 2.742460e-001, 
2.742402e-001, 2.742343e-001, 2.742285e-001, 2.742227e-001, 2.742168e-001, 2.742110e-001, 2.742051e-001, 2.741993e-001, 2.741934e-001, 2.741876e-001, 2.741817e-001, 2.741759e-001, 2.741700e-001, 2.741642e-001, 2.741584e-001, 2.741525e-001, 2.741467e-001, 2.741408e-001, 2.741350e-001, 2.741291e-001, 2.741233e-001, 2.741174e-001, 2.741116e-001, 2.741057e-001, 2.740999e-001, 2.740940e-001, 2.740882e-001, 2.740823e-001, 2.740765e-001, 2.740706e-001, 2.740648e-001, 2.740589e-001, 2.740531e-001, 2.740472e-001, 2.740414e-001, 2.740355e-001, 2.740297e-001, 2.740238e-001, 2.740180e-001, 2.740121e-001, 2.740063e-001, 2.740004e-001, 2.739946e-001, 2.739887e-001, 2.739829e-001, 2.739770e-001, 2.739712e-001, 2.739653e-001, 2.739595e-001, 2.739536e-001, 2.739478e-001, 2.739419e-001, 2.739361e-001, 2.739302e-001, 2.739244e-001, 2.739185e-001, 2.739126e-001, 2.739068e-001, 2.739009e-001, 2.738951e-001, 2.738892e-001, 2.738834e-001, 2.738775e-001, 2.738717e-001, 2.738658e-001, 2.738600e-001, 2.738541e-001, 2.738482e-001, 2.738424e-001, 2.738365e-001, 2.738307e-001, 2.738248e-001, 2.738190e-001, 2.738131e-001, 2.738073e-001, 2.738014e-001, 2.737955e-001, 2.737897e-001, 2.737838e-001, 2.737780e-001, 2.737721e-001, 2.737663e-001, 2.737604e-001, 2.737545e-001, 2.737487e-001, 2.737428e-001, 2.737370e-001, 2.737311e-001, 2.737253e-001, 2.737194e-001, 2.737135e-001, 2.737077e-001, 2.737018e-001, 2.736960e-001, 2.736901e-001, 2.736842e-001, 2.736784e-001, 2.736725e-001, 2.736667e-001, 2.736608e-001, 
2.736550e-001, 2.736491e-001, 2.736432e-001, 2.736374e-001, 2.736315e-001, 2.736256e-001, 2.736198e-001, 2.736139e-001, 2.736081e-001, 2.736022e-001, 2.735963e-001, 2.735905e-001, 2.735846e-001, 2.735788e-001, 2.735729e-001, 2.735670e-001, 2.735612e-001, 2.735553e-001, 2.735494e-001, 2.735436e-001, 2.735377e-001, 2.735319e-001, 2.735260e-001, 2.735201e-001, 2.735143e-001, 2.735084e-001, 2.735025e-001, 2.734967e-001, 2.734908e-001, 2.734849e-001, 2.734791e-001, 2.734732e-001, 2.734674e-001, 2.734615e-001, 2.734556e-001, 2.734498e-001, 2.734439e-001, 2.734380e-001, 2.734322e-001, 2.734263e-001, 2.734204e-001, 2.734146e-001, 2.734087e-001, 2.734028e-001, 2.733970e-001, 2.733911e-001, 2.733852e-001, 2.733794e-001, 2.733735e-001, 2.733676e-001, 2.733618e-001, 2.733559e-001, 2.733500e-001, 2.733442e-001, 2.733383e-001, 2.733324e-001, 2.733266e-001, 2.733207e-001, 2.733148e-001, 2.733089e-001, 2.733031e-001, 2.732972e-001, 2.732913e-001, 2.732855e-001, 2.732796e-001, 2.732737e-001, 2.732679e-001, 2.732620e-001, 2.732561e-001, 2.732503e-001, 2.732444e-001, 2.732385e-001, 2.732326e-001, 2.732268e-001, 2.732209e-001, 2.732150e-001, 2.732092e-001, 2.732033e-001, 2.731974e-001, 2.731915e-001, 2.731857e-001, 2.731798e-001, 2.731739e-001, 2.731681e-001, 2.731622e-001, 2.731563e-001, 2.731504e-001, 2.731446e-001, 2.731387e-001, 2.731328e-001, 2.731269e-001, 2.731211e-001, 2.731152e-001, 2.731093e-001, 2.731034e-001, 2.730976e-001, 2.730917e-001, 2.730858e-001, 2.730799e-001, 2.730741e-001, 
2.730682e-001, 2.730623e-001, 2.730564e-001, 2.730506e-001, 2.730447e-001, 2.730388e-001, 2.730329e-001, 2.730271e-001, 2.730212e-001, 2.730153e-001, 2.730094e-001, 2.730036e-001, 2.729977e-001, 2.729918e-001, 2.729859e-001, 2.729801e-001, 2.729742e-001, 2.729683e-001, 2.729624e-001, 2.729565e-001, 2.729507e-001, 2.729448e-001, 2.729389e-001, 2.729330e-001, 2.729272e-001, 2.729213e-001, 2.729154e-001, 2.729095e-001, 2.729036e-001, 2.728978e-001, 2.728919e-001, 2.728860e-001, 2.728801e-001, 2.728742e-001, 2.728684e-001, 2.728625e-001, 2.728566e-001, 2.728507e-001, 2.728448e-001, 2.728390e-001, 2.728331e-001, 2.728272e-001, 2.728213e-001, 2.728154e-001, 2.728095e-001, 2.728037e-001, 2.727978e-001, 2.727919e-001, 2.727860e-001, 2.727801e-001, 2.727743e-001, 2.727684e-001, 2.727625e-001, 2.727566e-001, 2.727507e-001, 2.727448e-001, 2.727390e-001, 2.727331e-001, 2.727272e-001, 2.727213e-001, 2.727154e-001, 2.727095e-001, 2.727037e-001, 2.726978e-001, 2.726919e-001, 2.726860e-001, 2.726801e-001, 2.726742e-001, 2.726683e-001, 2.726625e-001, 2.726566e-001, 2.726507e-001, 2.726448e-001, 2.726389e-001, 2.726330e-001, 2.726271e-001, 2.726213e-001, 2.726154e-001, 2.726095e-001, 2.726036e-001, 2.725977e-001, 2.725918e-001, 2.725859e-001, 2.725800e-001, 2.725742e-001, 2.725683e-001, 2.725624e-001, 2.725565e-001, 2.725506e-001, 2.725447e-001, 2.725388e-001, 2.725329e-001, 2.725270e-001, 2.725212e-001, 2.725153e-001, 2.725094e-001, 2.725035e-001, 2.724976e-001, 2.724917e-001, 2.724858e-001, 
2.724799e-001, 2.724740e-001, 2.724682e-001, 2.724623e-001, 2.724564e-001, 2.724505e-001, 2.724446e-001, 2.724387e-001, 2.724328e-001, 2.724269e-001, 2.724210e-001, 2.724151e-001, 2.724092e-001, 2.724033e-001, 2.723975e-001, 2.723916e-001, 2.723857e-001, 2.723798e-001, 2.723739e-001, 2.723680e-001, 2.723621e-001, 2.723562e-001, 2.723503e-001, 2.723444e-001, 2.723385e-001, 2.723326e-001, 2.723267e-001, 2.723208e-001, 2.723149e-001, 2.723091e-001, 2.723032e-001, 2.722973e-001, 2.722914e-001, 2.722855e-001, 2.722796e-001, 2.722737e-001, 2.722678e-001, 2.722619e-001, 2.722560e-001, 2.722501e-001, 2.722442e-001, 2.722383e-001, 2.722324e-001, 2.722265e-001, 2.722206e-001, 2.722147e-001, 2.722088e-001, 2.722029e-001, 2.721970e-001, 2.721911e-001, 2.721852e-001, 2.721793e-001, 2.721734e-001, 2.721675e-001, 2.721616e-001, 2.721557e-001, 2.721498e-001, 2.721439e-001, 2.721380e-001, 2.721321e-001, 2.721262e-001, 2.721203e-001, 2.721144e-001, 2.721085e-001, 2.721027e-001, 2.720968e-001, 2.720909e-001, 2.720849e-001, 2.720790e-001, 2.720731e-001, 2.720672e-001, 2.720613e-001, 2.720554e-001, 2.720495e-001, 2.720436e-001, 2.720377e-001, 2.720318e-001, 2.720259e-001, 2.720200e-001, 2.720141e-001, 2.720082e-001, 2.720023e-001, 2.719964e-001, 2.719905e-001, 2.719846e-001, 2.719787e-001, 2.719728e-001, 2.719669e-001, 2.719610e-001, 2.719551e-001, 2.719492e-001, 2.719433e-001, 2.719374e-001, 2.719315e-001, 2.719256e-001, 2.719197e-001, 2.719138e-001, 2.719079e-001, 2.719020e-001, 2.718961e-001, 
2.718902e-001, 2.718843e-001, 2.718783e-001, 2.718724e-001, 2.718665e-001, 2.718606e-001, 2.718547e-001, 2.718488e-001, 2.718429e-001, 2.718370e-001, 2.718311e-001, 2.718252e-001, 2.718193e-001, 2.718134e-001, 2.718075e-001, 2.718016e-001, 2.717957e-001, 2.717897e-001, 2.717838e-001, 2.717779e-001, 2.717720e-001, 2.717661e-001, 2.717602e-001, 2.717543e-001, 2.717484e-001, 2.717425e-001, 2.717366e-001, 2.717307e-001, 2.717248e-001, 2.717188e-001, 2.717129e-001, 2.717070e-001, 2.717011e-001, 2.716952e-001, 2.716893e-001, 2.716834e-001, 2.716775e-001, 2.716716e-001, 2.716656e-001, 2.716597e-001, 2.716538e-001, 2.716479e-001, 2.716420e-001, 2.716361e-001, 2.716302e-001, 2.716243e-001, 2.716184e-001, 2.716124e-001, 2.716065e-001, 2.716006e-001, 2.715947e-001, 2.715888e-001, 2.715829e-001, 2.715770e-001, 2.715711e-001, 2.715651e-001, 2.715592e-001, 2.715533e-001, 2.715474e-001, 2.715415e-001, 2.715356e-001, 2.715297e-001, 2.715237e-001, 2.715178e-001, 2.715119e-001, 2.715060e-001, 2.715001e-001, 2.714942e-001, 2.714883e-001, 2.714823e-001, 2.714764e-001, 2.714705e-001, 2.714646e-001, 2.714587e-001, 2.714528e-001, 2.714468e-001, 2.714409e-001, 2.714350e-001, 2.714291e-001, 2.714232e-001, 2.714173e-001, 2.714113e-001, 2.714054e-001, 2.713995e-001, 2.713936e-001, 2.713877e-001, 2.713817e-001, 2.713758e-001, 2.713699e-001, 2.713640e-001, 2.713581e-001, 2.713522e-001, 2.713462e-001, 2.713403e-001, 2.713344e-001, 2.713285e