/**
 * @file  FloatFA2Byte.cxx
 * @brief Convert float FA image to byte.
 *
 * Copyright (c) 2008, 2009, 2012 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;


int main(int argc, char * argv[])
{
  if (argc != 3)
  {
    cout << "USAGE: FloatFA2Byte <Float FA image> <Byte FA image>" << endl;
    exit(1);
  }
  
  ifstream ifs;
  ifs.open(argv[1], ios::in | ios::binary);
  
  ifs.seekg(0, ios::end);
  int len = ifs.tellg() / sizeof(float);
  ifs.seekg(0, ios::beg);
  
  float * float_dat = new float [len];
  ifs.read((char *)float_dat, len * sizeof(float));
  ifs.close();
  
  unsigned char * byte_dat = new unsigned char [len];
  for (int i=0; i<len; i++)
  {
    byte_dat[i] = (int)(float_dat[i] * 255.0f + 0.5);
  }
  
  ofstream ofs;
  ofs.open(argv[2], ios::out | ios::binary);
  ofs.write((char *)byte_dat, len);
  ofs.close();
  
  return 0;
}

