/**
 * @file  combinetwodeformationfields.cxx
 * @brief Concatenate two deformation fields.
 *
 * Copyright (c) 2008, 2009, 2012, 2013 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <matrixSHENCLASSIC.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage (char *filename)
{
	printf ("This program combines two deformation fields into\n");
	printf ("one, the first input fields is from image A to image B, the second\n");
	printf ("is from image B to image C, and the result is from image A to\n");
	printf ("image C.\n\n");

	printf ("\n");
	printf ("%s inputdeformationfield1 inputdeformationfield2 outputdeformationfield [-d X,Y,Z] [-e X,Y,Z] [-S]\n", filename);

	printf ("\t-d X,Y,Z size of the first deformation field, default is 256,256,124\n");
	printf ("\t-e X,Y,Z size of the second deformation field, default is 256,256,124\n");

	printf ("\t-S, use this option for HAMMER field, optional\n");
	printf ("\ncontact: sbia-software@uphs.upenn.edu\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	char    inputdeformationfield[180], outputdeformationfield[180];
	char    inputdeformationfield1[180];

	Deformation_Field *idf1, *idf2, *odf;

	int     FX1, FX2;
	int     FY1, FY2;
	int     FZ1, FZ2;

	int     hammer_field;
	int c;
	/* int     x, y, z; */
	/* int     px, py, pz; */
	/* int     nx, ny, nz; */
	/* int     nnx, nny, nnz; */
	int     have_point;
	/* int     have_mask, mask_number; */

	/* double  similarity; */

	int     d_option, e_option;

	hammer_field = 0;
	have_point = 0;

	d_option = 0;
	e_option = 0;

	if (argc < 4)
	{
		showUsage (argv[0]);
		exit (1);
	}
	else
	{
		strcpy (inputdeformationfield, argv[1]);
		strcpy (inputdeformationfield1, argv[2]);
		strcpy (outputdeformationfield, argv[3]);

		c = getopt (argc - 3, argv + 3, "d:Se:");
		while (c != -1)
		{
			switch (c)
			{
				case 'd':
					sscanf (optarg, "%d,%d,%d", &FX1, &FY1, &FZ1);
					d_option = 1;
					break;
				case 'e':
					sscanf (optarg, "%d,%d,%d", &FX2, &FY2, &FZ2);
					e_option = 1;
					break;
				case 'S':
					hammer_field = 1;
					break;
				default:
					printf ("option error\n");
					break;
			}
			c = getopt (argc - 3, argv + 3, "d:Se:");
		}
	}

	if ((d_option) && (!e_option))
	{
		FX2 = FX1;
		FY2 = FY1;
		FZ2 = FZ1;
	}

	if ((!d_option) && (e_option))
	{
		FX1 = FX2;
		FY1 = FY2;
		FZ1 = FZ2;
	}

	if ((!d_option) && (!e_option))
	{
		FX1 = 256;
		FY1 = 256;
		FZ1 = 124;
		FX2 = FX1;
		FY2 = FY1;
		FZ2 = FZ1;
	}

	idf1 = new_deformationfield (FX1, FY1, FZ1);
	idf2 = new_deformationfield (FX2, FY2, FZ2);
	odf = new_deformationfield (FX1, FY1, FZ1);

	read_deformationfield_with_switch (idf1, inputdeformationfield, hammer_field);
	read_deformationfield_with_switch (idf2, inputdeformationfield1, hammer_field);
	add_deformationfield (idf1, idf2, odf);
	write_deformationfield_with_switch (odf, outputdeformationfield, hammer_field);

	exit(0);
}
