#!/bin/sh

if [ $# -lt 2 ]; then
echo 'convertSequentToVoxelDT.sh <Sequent DT file> <Voxel DT file> <Size X> <Size Y> <Size Z>'
echo '    <SizeX>,<SizeY>,<SizeZ>: default 256,256,128'
exit
fi

SequentDT=$1
VoxelDT=$2
SizeX=256
SizeY=256
SizeZ=128

if [ $# -ge 5 ]; then
SizeX=$3
SizeY=$4
SizeZ=$5
fi

#extract files
echo extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ
extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ

#compose interleaved DT
echo createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY
createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY

echo rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img
rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img

