#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;


int main(int argc, char * argv[])
{
  if (argc != 3)
  {
    cout << "USAGE: FloatFA2Byte <Float FA image> <Byte FA image>" << endl;
    exit(0);
  }
  
  ifstream ifs;
  ifs.open(argv[1], ios::in | ios::binary);
  
  ifs.seekg(0, ios::end);
  int len = ifs.tellg() / sizeof(float);
  ifs.seekg(0, ios::beg);
  
  float * float_dat = new float [len];
  ifs.read((char *)float_dat, len * sizeof(float));
  ifs.close();
  
  unsigned char * byte_dat = new unsigned char [len];
  for (int i=0; i<len; i++)
  {
    byte_dat[i] = (int)(float_dat[i] * 255.0f + 0.5);
  }
  
  ofstream ofs;
  ofs.open(argv[2], ios::out | ios::binary);
  ofs.write((char *)byte_dat, len);
  ofs.close();
  
  return 0;
}

