#!/usr/bin/env ruby
#
#  Created by Andres Molina on 2007-07-11.
#  Copyright (c) 2007. All rights reserved.
require 'optparse'
require 'digest/md5'

puts "Testing HAMMERNucleus\n"

#This script tests HAMMER
#

class CatArguments < Hash
  attr_reader :bin_dir
  attr_reader :subject_dir
  attr_reader :model_dir
  attr_reader :temp_dir
  def initialize(args)
    super()
    self[:show_ends] = ''
    
    opts = OptionParser.new do |opts|
      opts.banner = "Usage: #$0 [options]"
      
      opts.on('-S STRING', '--sample-dir',
              'the directory where to find the sample dataset to test the HAMMERNucleus') do |string|
        if File.directory?(string)
          @subject_dir = File.expand_path(string) + "/"
          puts "Will read sample from: " + @subject_dir
        end  
      end
      
      opts.on('-M STRING', '--model-dir',
              'the directory where the models will be searched') do |string|
        if File.directory?(string)
          @model_dir = File.expand_path(string) + "/"
          puts "Will read models from: " + @model_dir
        end  
      end
      
      opts.on('-T STRING', '--temp-dir',
              'the directory where the temporary results will be written') do |string|
        if File.directory?(string)
          @temp_dir = File.expand_path(string) + "/"
          puts "Will write temporary results on: " + @temp_dir
        end  
      end
      
      opts.on('-B STRING', '--bin-dir',
              'the directory where the hammer binaries will be searched') do |string|
        if File.directory?(string)
          @bin_dir = File.expand_path(string) + "/"
          puts "Will test the binaries found on: " + @bin_dir
        end  
      end
      
      opts.on_tail('-h', '--help', 'display this help and exit') do
        puts opts
        exit
      end
      
    end

    opts.parse!(args)
  end
end

def check_file(md5sum, fileName)
digest = Digest::MD5.hexdigest(File.read(fileName))
    if (digest == md5sum)
        puts File.basename(fileName) + " OK \n"
    else
        puts File.basename(fileName) + " Failed \n"
    end
end

#SCRIPT BEGINS

#Parse the input dir, the output dir, and the comparison dir

arguments = CatArguments.new(ARGV)
puts "------------------------------------------------------------------"

if(arguments.bin_dir == nil || arguments.subject_dir == nil || arguments.temp_dir == nil || arguments.model_dir == nil) 
  raise "A required argument is missing \nType: #$0 -h\n"
  break
end

#Try to run the tests with the files above
system(arguments.bin_dir + "hammer labelbrain -S " + arguments.subject_dir + "subject_segmented_no_cere.img -M " + arguments.model_dir + "jakob_rad_convention_segmented_no_cere.img -L " + arguments.model_dir + "jakob_rad_convention_labels_no_cere.img -i 10 -d " + arguments.temp_dir)

system(arguments.bin_dir + "hammer normalizebrain -S " + arguments.subject_dir + "subject_segmented_no_cere.img -O " + arguments.subject_dir + "subject_original_with_cere.img -M " + arguments.model_dir + "jakob_rad_convention_segmented_no_cere.img -L " + arguments.model_dir + "jakob_rad_convention_labels_no_cere.img -i 10 -d " + arguments.temp_dir)

system(arguments.bin_dir + "hammer ravens -S " + arguments.subject_dir + "subject_segmented_no_cere.img -M " + arguments.model_dir + "jakob_rad_convention_segmented_no_cere.img -i 10 -d " + arguments.temp_dir);

#Check the results
puts "------------------------------------------------------------------"
#md5sums HAMMER 1.0
#
#Ravens
#c93975920833d8f751155d082e971aea  subject_segmented_no_cere.img.ravens.Field.1.img.Subj2Mdl
#8e221f9acb858c130ab3060186e0c98f  subject_segmented_no_cere.img.ravens.RAVENSmap.GM.hdr
#1f6fa4cf488cb3d1d7ea66b8e43892cd  subject_segmented_no_cere.img.ravens.RAVENSmap.GM.img
#8e221f9acb858c130ab3060186e0c98f  subject_segmented_no_cere.img.ravens.RAVENSmap.VN.hdr
#10f129b7c7e87efc4e02efeade1b999f  subject_segmented_no_cere.img.ravens.RAVENSmap.VN.img
#8e221f9acb858c130ab3060186e0c98f  subject_segmented_no_cere.img.ravens.RAVENSmap.WM.hdr
#ec0c1083cfe3e304e611f62e9308ca5e  subject_segmented_no_cere.img.ravens.RAVENSmap.WM.img
#27991887db901134c181fa1a64da489d  subject_segmented_no_cere.img.ravens.Warped.MdlSeg.hdr
#fc564295ec913c0209e72e56209c257e  subject_segmented_no_cere.img.ravens.Warped.MdlSeg.img
#
#Normalization
#bd227c9aff85c5614d0a84d9206630c3  subject_segmented_no_cere.img.Field.1.img.Mdl2Subj
#8e221f9acb858c130ab3060186e0c98f  subject_segmented_no_cere.img.Warped.SubjOrig.hdr
#2312a959ba3a89379022ee189245d257  subject_segmented_no_cere.img.Warped.SubjOrig.img
#8e221f9acb858c130ab3060186e0c98f  subject_segmented_no_cere.img.Warped.SubjSeg.hdr
#b2a8682be5a0212ee6a261750b038f2e  subject_segmented_no_cere.img.Warped.SubjSeg.img
#
#Labeling
#c93975920833d8f751155d082e971aea  subject_segmented_no_cere.img.Field.1.img.Subj2Mdl
#27991887db901134c181fa1a64da489d  subject_segmented_no_cere.img.Warped.Labels.hdr
#9933cd25079bdfb70cb722d796a40e5e  subject_segmented_no_cere.img.Warped.Labels.img
#27991887db901134c181fa1a64da489d  subject_segmented_no_cere.img.Warped.MdlSeg.hdr
#fc564295ec913c0209e72e56209c257e  subject_segmented_no_cere.img.Warped.MdlSeg.img

#Ravens
check_file("c93975920833d8f751155d082e971aea", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.Field.1.img.Subj2Mdl")
check_file("8e221f9acb858c130ab3060186e0c98f", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.GM.hdr")
check_file("1f6fa4cf488cb3d1d7ea66b8e43892cd", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.GM.img")
check_file("8e221f9acb858c130ab3060186e0c98f", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.VN.hdr")
check_file("10f129b7c7e87efc4e02efeade1b999f", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.VN.img")
check_file("8e221f9acb858c130ab3060186e0c98f", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.WM.hdr")
check_file("ec0c1083cfe3e304e611f62e9308ca5e", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.RAVENSmap.WM.img")
check_file("27991887db901134c181fa1a64da489d", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.Warped.MdlSeg.hdr")
check_file("fc564295ec913c0209e72e56209c257e", arguments.subject_dir + "subject_segmented_no_cere.img.ravens.Warped.MdlSeg.img")
#
#Normalization
check_file("bd227c9aff85c5614d0a84d9206630c3", arguments.subject_dir + "subject_segmented_no_cere.img.Field.1.img.Mdl2Subj")
check_file("8e221f9acb858c130ab3060186e0c98f", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.SubjOrig.hdr")
check_file("2312a959ba3a89379022ee189245d257", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.SubjOrig.img")
check_file("8e221f9acb858c130ab3060186e0c98f", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.SubjSeg.hdr")
check_file("b2a8682be5a0212ee6a261750b038f2e", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.SubjSeg.img")
#
#Labeling
check_file("c93975920833d8f751155d082e971aea", arguments.subject_dir + "subject_segmented_no_cere.img.Field.1.img.Subj2Mdl")
check_file("27991887db901134c181fa1a64da489d", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.Labels.hdr")
check_file("9933cd25079bdfb70cb722d796a40e5e", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.Labels.img")
check_file("27991887db901134c181fa1a64da489d", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.MdlSeg.hdr")
check_file("fc564295ec913c0209e72e56209c257e", arguments.subject_dir + "subject_segmented_no_cere.img.Warped.MdlSeg.img")


#SCRIPT ENDS



