/* This program creates an ANALYZETM database header */
/* Revised by dliu@rad.upenn.edu
*/
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <dbh.h>
void showUsage(char *);
int main(int argc, char **argv)
{
	int i;
	struct dsr hdr;
	FILE *fp;
	static char DataTypes[9][12] = {"UNKNOWN", "BINARY", "CHAR", "SHORT", "INT","FLOAT", "COMPLEX", "DOUBLE", "RGB"};
	static int DataTypeSizes[9] = {0,1,8,16,32,32,64,64,24};
	extern char *optarg;
	int c;
	int verboseFlag = 0; /* verbose output */
	if(argc < 2)
	{
		showUsage(argv[0]);
		exit(EXIT_FAILURE);
	}
	memset(&hdr,0, sizeof(struct dsr));
	for(i=0;i<8;i++)
		hdr.dime.pixdim[i] = 0.0;
	/* set some default value */
	hdr.dime.dim[0] = 4; /* all Analyze images are taken as 4 dimensional */
	hdr.dime.dim[1] = 256;
	hdr.dime.dim[2] = 256;
	hdr.dime.dim[3] = 124;
	hdr.dime.dim[4] = 1;
	hdr.dime.pixdim[1] = 0.9375;
	hdr.dime.pixdim[2] = 0.9375;
	hdr.dime.pixdim[3] = 1.5;
	hdr.dime.datatype = 2;
	hdr.dime.bitpix = 8;
	hdr.dime.glmax = 0; /* maximum voxel value */
	hdr.dime.glmin = 0; /* minimum voxel value */
	hdr.dime.vox_offset = 0.0;
	hdr.dime.funused1 = 0.0;
	hdr.dime.funused2 = 0.0;
	hdr.dime.cal_max = 0.0;
	hdr.dime.cal_min = 0.0;
	hdr.dime.datatype = -1;
	/* input options parsing */
	while ( (c = getopt(argc-1,argv+1,"r:vt:n:d:?")) != EOF)
	{
		switch(c)
		{
			case 'd':
				sscanf(optarg,"%hd,%hd,%hd\n",&hdr.dime.dim[1],&hdr.dime.dim[2],&hdr.dime.dim[3]); /* width,height,slice */
				break;
			case 'r':
				sscanf(optarg,"%f,%f,%f\n",&hdr.dime.pixdim[1],&hdr.dime.pixdim[2],&hdr.dime.pixdim[3]); /* pixel spacing in width, height, slice  0 means no information about the data*/
				break;
			case 't':
				for(i=1;i<=8;i++)
					if(!strcmp(optarg,DataTypes[i])){
						hdr.dime.datatype = (1<<(i-1));
						hdr.dime.bitpix = DataTypeSizes[i];
						break;
					}
				break;
			case 'n':
				hdr.dime.dim[4] = atoi(optarg); /* number of volumes */
				break;
			case 'v':
				verboseFlag=1;
				break;
			case '?':
				showUsage(argv[0]);
				exit(EXIT_FAILURE);
				break;
		}
	}
if(verboseFlag){
	printf(" dimension is %d,%d,%d\n",hdr.dime.dim[1],hdr.dime.dim[2],hdr.dime.dim[3]);	
	printf("resolution is %f,%f,%f\n",hdr.dime.pixdim[1],hdr.dime.pixdim[2],hdr.dime.pixdim[3]);
	printf(" volume number is %d, type is %d\n",hdr.dime.dim[4],hdr.dime.datatype);
}
	if(hdr.dime.datatype <= 0)
	{
		printf("datatype is an unacceptable datatype \n\n");
		showUsage(argv[0]);
		exit(0);
	}
	if( 0 == (fp=fopen(argv[1],"w")))
	{
		printf("unable to create: %s\n",argv[1]);
		exit(0);
	}

	hdr.hk.regular = 'r';
	hdr.hk.sizeof_hdr = sizeof(struct dsr);
		/* Assume zero offset in .img file, byte at which pixel
		   data starts in the image file */
		hdr.dime.vox_offset = 0.0;
		/* Planar Orientation; */
		/* Movie flag OFF: 0 = transverse, 1 = coronal, 2 = sagittal
		   Movie flag ON: 3 = transverse, 4 = coronal, 5 = sagittal */
		hdr.hist.orient = 0;
		/* up to 3 characters for the voxels units label; i.e. mm., um., cm. */ 
		strcpy(hdr.dime.vox_units," ");
		/* up to 7 characters for the calibration units label; i.e. HU */
		strcpy(hdr.dime.cal_units," ");
		/* Calibration maximum and minimum values; values of 0.0 for both fields imply that no calibration max and min values are used */
		hdr.dime.cal_max = 0.0;
		hdr.dime.cal_min = 0.0;
		fwrite(&hdr,sizeof(struct dsr),1,fp);
		fclose(fp);
		return 0;
}
void showUsage(char *progname){
printf("USAGE: \033[40;31m %s hdrFilename [options] \n\
\t  \033[31;32m -d<int>,<int>,<int>          :width,height,slicenumber(256,256,124 default)\n\
\t  \033[31;33m -r<float>,<float>,<float>    :resolution in width,height,depth(0.9375,0.9375,1.5 defautl)\n\
\t  \033[31;34m -t<string>                   :datatype of(BINARY, CHAR(default), SHORT,INT, FLOAT, COMPLEX, DOUBLE, and RGB\n\
\t  \033[31;35m -n<int>                      :number of volumes (1 default)\n\
\033[0m Questions, dliu@rad.upenn.edu\n",progname);
}
