/**
 * @file  cres.h
 * @brief Originally part of HAMMER.
 *
 * Copyright (c) 2001, 2012 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef _SBIA_DTIDROID_HAMMER_CRES_H
#define	_SBIA_DTIDROID_HAMMER_CRES_H

#include "mvcd.h"


#ifdef	__cplusplus
extern "C" {
#endif

#define TINY 1.0e-20;

typedef struct
{
  float H;
  float K;
  float k1;
  float k2;
  float error;
} Skappa;

void nrerror(char []);
double *vector(int,int);
int *ivector(int,int);
double *devecotr(int,int);
double **matrix(int,int,int,int);
double **dmatrix(int,int,int,int);
int **imatrix(int,int,int,int);
double **submatrix(double **,int,int,int,int,int,int);
void free_vector(double *,int,int);
void free_ivector(int *,int,int);
void free_dvector(double *,int,int);
void free_matrix(double **,int,int,int,int);
void free_dmatrix(double **,int,int,int,int);
void free_imatrix(int **,int,int,int,int);
void ludcmp(double **,int,int *,double *);
void lubksb(double **,int,int *,double *);
void matrixInv(double **,double **,int);
void matrixDet(double *,double **,int);
Skappa estimate_kappa(Fvector3d *,int,Fvector3d);
void Fvector3dcurvature2d(int,int,Fvector3d **,float **,int,float);

#ifdef	__cplusplus
}
#endif


#endif	/* _SBIA_DTIDROID_HAMMER_CRES_H */
