/**
 * @file  cropslices.cxx
 * @brief Originally part of HAMMER.
 *
 * Copyright (c) 2001, 2012 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <getopt.h>

#include "cres.h"
#include "mvcd.h"
#include "matrixSHEN.h"

#include "basis.h"


// acceptable in .cxx file
using namespace sbia;


// ===========================================================================
// help
// ===========================================================================

// ---------------------------------------------------------------------------
void show_usage()
{
  basis::print_version("cropslices", "", "");
  printf("\n");
  printf("USAGE: cropslices <input_file> <output_file>\n\
\t -v <int>            : image size for x and y dimenions (default: 256)\n\
\t -c <int>,<int>      : starting slice (can be negative), ending slice (can be bigger than total slice number in the input image)\n\
");
}

// ===========================================================================
// main
// ===========================================================================

// ---------------------------------------------------------------------------
int main(int argc,char *argv[])
{
  if (argc < 3) {
    show_usage();
    exit(1);
  }

  int start      = 0;
  int end        = 0;
  int image_size = 256;

  int c = -1;
  while ((c = getopt(argc - 2, argv + 2, "c:v:")) != -1) {
    switch(c) {
      case 'c':
        sscanf(optarg, "%d,%d", &start, &end) ;
        break;

      case 'v':
        sscanf(optarg, "%d", &image_size) ;
        break;

      default:
        break;
    }
  }

  printf(" start=%d\n end=%d\n", start, end) ;
  printf(" image_size=%d\n", image_size) ;

  unsigned char ***src, ***outp;
  int  i,j,k,ii,jj,kk, z_size, z_size_Output;
  FILE *fp;

  fp=myopen(argv[1],"rb");
  fseek(fp,0,SEEK_END);
  z_size=ftell(fp)/(image_size*image_size);
  rewind(fp);

  /* apply for memory */
  src  = UCalloc3d(image_size,image_size,z_size);
  z_size_Output = end-start+1 ; printf("z_size_Output=%d\n", z_size_Output) ;
  outp = UCalloc3d(image_size,image_size,z_size_Output);

  /* read data */
  for(k=0;k<z_size;k++)
    for(i=0;i<image_size;i++)
      fread(src[k][i],1,image_size,fp);
  fclose(fp);

  /* crop ... */
  if( end>0 )
    {
      for( k=start; k<=end && k<z_size; k++ )
    for( i=0; i<image_size; i++ )
      for( j=0; j<image_size; j++ )
        if( k>=0 )
          outp[k-start][i][j] = src[k][i][j] ;
    }
  else
    printf("Notice: end slice is 0!\n") ;


  /* write the smoothed image */
  printf("Write file!\n") ;
  fp=myopen(argv[2],"wb");
  for(k=0;k<(end-start+1);k++)
    for(i=0;i<image_size;i++)
      fwrite(outp[k][i],1,image_size,fp);
  fclose(fp);

  /* free */
  UCfree3d(outp, z_size_Output, image_size) ;
  UCfree3d(src,  z_size,        image_size) ;

  exit(0);
}
