/**
 * @file  ImgVol.h
 * @brief Represenation of image volume.
 *
 * Copyright (c) 2008, 2009, 2012, 2013 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef _DTIDROID_IMGVOL_H
#define _DTIDROID_IMGVOL_H


#include "Global.h"


//--------------------------------------------------------------------
//  class ImgVol:
//        Image volume
//
//  members:
//     -getVoxel(int xx, int yy, int zz):
//	 get voxel value from *vol at (xx,yy,zz),
// 
//     -int saveData(char* name, char* &voxels):
//	 save voluem *voxels to file <name>, 
//	 return 1 if succeed; return -1 if failed
//
//  
//--------------------------------------------------------------------


class ImgVol {
protected:
   int dimX, dimY, dimZ,voxSize,planSize;
   char *vol;
 
public:
   ImgVol(int ddz, int ddx=256, int ddy=256);
   ImgVol(char* name,int ddx=256, int ddy=256);
  ~ImgVol();

   void  reset(char c);
   int   inVolume(int xx, int yy, int zz); //return 1 if inside;

   char*  getVolume(void);
   char*  setVolume(char * pt); //replace volume with new volume, return old

   void   loadVolume(const char* ff, char* &object, int& sampZ);
   char   getVoxel(int ind); //use index instead of coordinates(x,y,z)
   char   getVoxel(int xx, int yy, int zz);//get voxel from *vol
   void   getDimXYZ(int& aa, int& bb, int& cc);
   int   getDimX(){return dimX;}
   int   getDimY(){return dimY;}
   int   getDimZ(){return dimZ;}

   void   setVoxel(int xx, int yy, int zz, char cc);
   void   setVoxel(int ind,char cc);
   float  smoothness(int xx, int yy, int zz, int nbrSize); 
         // get smoothness value; 0 the smoothest
   void   smooth(int nbrSize); //smooth image with window size "nbrSize"
   float  getVoxelRegionAt(int xx, int yy, int zz, int nbrSize);
   int    getVoxAtAnyPosition(float px, float py, float pz, float & P);
   float  getVoxelf(float vx,float vy,float vz);

   void  getZslice(int n, char* & buf);
   void  getYslice(int n, char* & buf);
   void  getXslice(int n, char* & buf);

   void   sortIntArray(int * arr, int arrLen);
   void   histogram(int * arr, int arrLen);

   int    saveVolume(const char* name);
   int    saveData(const char* name, char* &voxels, int xx, int yy, int zz);
};


#endif // _DTIDROID_IMGVOL_H
