/**
 * @file  RGBAcolorMapDT.h
 * @brief Volume of RGBA (4-byte at each voxel) data.
 *
 * Copyright (c) 2008, 2009, 2012, 2013 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef _DTIDROID_RGBACOLORMAPDT_H
#define _DTIDROID_RGBACOLORMAPDT_H

//--------------------------------------------------------------------
//  class RGBAcolorMap:
//        volume of RGBA (4-byte at each voxel)
//
//  members:
//     -struct byteRGBA getVoxel(int xx, int yy, int zz):
//	 get voxel value from *vol at (xx,yy,zz),
// 
//     -int saveData(char* name, byteRGBA* &voxels):
//	 save voluem *voxels to file <name>, 
//	 return 1 if succeed; return -1 if failed
//
//  
//--------------------------------------------------------------------

//for class RGBAcolorMap 
struct byteRGBA{
  char rgba[4];
}; 


class RGBAcolorMap {
protected:
   int dimX, dimY, dimZ,voxSize,planSize;
   byteRGBA *vol;
 
public:

   RGBAcolorMap(int ddz, int ddx=256, int ddy=256);
   RGBAcolorMap(const char* name,int ddx=256, int ddy=256);

   ~RGBAcolorMap();

   void loadVolume(const char* ff, byteRGBA* &object, int& sampZ);
   void setVoxel(int xx, int yy, int zz,struct byteRGBA cc);
   void setVoxel(int xx, int yy, int zz,char rr, char gg, char bb, char aa);
   void setVoxel(int ind, struct byteRGBA cc);

   struct byteRGBA getVoxel(int xx, int yy, int zz);//use (x,y,z)
   struct byteRGBA getVoxel(int ind); //use index instead of (x,y,z)

   void   getDimXYZ(int& a, int& b, int& c);

   int   getDimX(){return dimX;}
   int   getDimY(){return dimY;}
   int   getDimZ(){return dimZ;}
   void  getZslice(int n, char* & buf);
   void  getYslice(int n, char* & buf);
   void  getXslice(int n, char* & buf);

   int  saveData(const char* name, byteRGBA* &voxels,int xx, int yy, int zz);
   int  saveVolume(const char* name);


};


#endif // _DTIDROID_RGBACOLORMAPDT_H
