#!/bin/sh

if [ $# -lt 2 ]; then
echo 'convertVoxelToSequentDT.sh <Voxel DT file> <Sequent DT file> <Size X> <Size Y> <Size Z>'
echo '    <SizeX>,<SizeY>,<SizeZ>: default 256,256,128'
exit
fi

SequentDT=$2
VoxelDT=$1
SizeX=256
SizeY=256
SizeZ=128

if [ $# -ge 5 ]; then
SizeX=$3
SizeY=$4
SizeZ=$5
fi

#decompose interleaved DT
echo createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY -i
createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY -i

#compose sequent DT files
echo extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ -i
extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ -i

echo rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img
rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img

