#!/usr/bin/env ruby

hammerResultFile = "DeformationField.float.img";

workingDirectory = "/home/andresmf/SoftwareProjects/SBIA/Hammer/cli/ohammer/test/subject1_warped/";

print( "Running hammer on low resolution: \n");
command = "ohammer_dev subject1_warpedFileSegmented.rig MdlFile -R0.05  -D" + workingDirectory + " -i10  -r12 -m0.06 -s4 -c0.5 -OFileOrignal  -E0 -X256"
print( command + " \n");
system(command + " > hammer_low_resolution.log");
print( "Done for the low resolution \n");
system("ls -al " + hammerResultFile);
system("md5sum " + hammerResultFile);
system("cp " + hammerResultFile + " ../deformation_fields/" + hammerResultFile + ".low");

print( "Running hammer on mid resolution: \n");
command = "ohammer_dev subject1_warpedFileSegmented.rig MdlFile -R0.05  -D" + workingDirectory + " -i10 -r10 -m0.06 -s2 -c0.5 -OFileOrignal -F -E0 -X256";
print( command + " \n");
system(command + " > hammer_mid_resolution.log");
print( "Done for the mid resolution \n");
system("ls -al " + hammerResultFile);
system("md5sum " + hammerResultFile);
system("cp " + hammerResultFile + " ../deformation_fields/" + hammerResultFile + ".mid");

print( "Running hammer on high resolution: \n");
command = "ohammer_dev subject1_warpedFileSegmented.rig MdlFile -R0.05  -D" + workingDirectory + " -i10  -r8 -m0.06 -s1 -c0.5 -OFileOrignal -F -E0 -X256";
print( command + " \n");
system(command + " > hammer_high_resolution.log");
print( "Done for the highresolution \n");
system("ls -al " + hammerResultFile);
system("md5sum " + hammerResultFile);
system("cp " + hammerResultFile + " ../deformation_fields/" + hammerResultFile + ".high");

command = "splitfile_dev DeformationField.float.img NoUse 8 Field.1.img";
print( command + " \n");
system(command);
system("ls -al " + hammerResultFile);
system("md5sum " + hammerResultFile);

command = "transform3dvectorfield_dev Field.1.img subject1_warped.Field.1.img.Subj2Mdl -v256 -I";
print( command + " \n");
system(command);

command = "performdeformationusingvectorfield_dev  subject1_warped.Field.1.img.Subj2Mdl " + workingDirectory + "MdlFile " + workingDirectory + "subject1_warped.Warped.MdlSeg.img -s256 -v256 -I";
print( command + " \n");
system(command);

command = "performdeformationusingvectorfield_dev subject1_warped.Field.1.img.Subj2Mdl " + workingDirectory + "LabelFile " + workingDirectory + "subject1_warped.Warped.Labels.trans -s256 -v256 -I";
print( command + " \n");
system(command);


command = "cropslices_dev subject1_warped.Warped.MdlSeg.img subject1_warped.Warped.MdlSeg.img -v256 -c0,109";
print( command + " \n");
system(command);

command = "cropslices_dev subject1_warped.Warped.Labels.trans subject1_warped.Warped.Labels.trans -v256 -c0,109";
print( command + " \n");
system(command);

print( "Checking  the results ... \n");
system("ls -al " + hammerResultFile);
system("md5sum " + hammerResultFile);
system("md5sum subject1_warped.Field.1.img.Subj2Mdl");
system("md5sum subject1_warped.Warped.Labels.trans");
system("md5sum subject1_warped.Warped.MdlSeg.img");
print( "Distro:8895665ec88b33e6bc7c05f3474e0cdb  subject1_warped.Field.1.img.Subj2Mdl \n");
print( "Distro:dea0033ae77ac70e88431c1d6c3ec6c6  subject1_warped.Warped.Labels.trans \n");
print( "Distro:ccfa17c96ff69214fb19a94687f3389a  subject1_warped.Warped.MdlSeg.img \n");


print( "Done !");

