/* 
 * File:   adaptivebrain.h
 * Author: andresmf
 *
 * Created on March 26, 2007, 9:39 AM
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include "mvcd.h"
#include "cres.h"
#include "matrixSHEN.h"  /*by SHEN*/

#ifndef _adaptivebrain_H
#define	_adaptivebrain_H

#ifdef	__cplusplus
extern "C" {
#endif

#define ADD     1
#define NOTADD  0
#define NNO     0
#define YYES    1

/* features for vertices */
#define BG    0            /* background */
#define CSF   10
#define VN    50
#define GM    150
#define WM    250
#define GMVN_EDGE     100
#define GMCSFBG_EDGE  120  /* added on June 4, 2001*/
#define WMVN_EDGE     180
#define WMGM_EDGE     255

#define BASIC_R 0
#define BUBBNUM   10
#define BSIC_RAD 1

#define BUBBNUM   10    /* 8 10*/
#define STEPPNT   3     /* 3 (May2001), 20 */
#define ITER_THRD 0.85   /* iteration threshold for switching focus */

#define CHNEIGENNUM   3

typedef struct {
    unsigned char Geom_UP;
    unsigned char Geom_DN;
    unsigned char VNvlm_UP;
    unsigned char VNvlm_DN;
    unsigned char CSFBG_UP;
    unsigned char CSFBG_DN;
} Threshold ;    
    
void getWMEdgeGMVnEdgeFromSegmentedImg(ImgAttribute ***Img, int zSize, int imageSize);
void calculateHoodSpecial(Fvector3d *bubble, int bubble_size, int *pixelNumInBubble, float xres, float yres, float zres);

void computeGeometricFeatures(ImgAttribute ***Img, int scale, float Xres, float Yres, float Zres, int zSize, int imageSize) ;
void writeImg(char filename[180], unsigned char ***data, int image_size, int z_size);

void writeImgAttribute(char filename[180], ImgAttribute ***Img, int image_size, int z_size);
/* for model */
//void select3DEdgePointsInModelTo1D(int *MdlVer_Num, ImgAttribute ***MdlImg, Fvector3d ***DeformFld, int image_size, int z_size, Threshold mdlThreshold);
/* for object */
//void select3DEdgePointsInObjectTo1D(int *ObjVer_Num, ImgAttribute ***ObjImg, int image_size, int z_size);

void calculateHoodByIncreasingRadius(Ivector3d *Hood, int HoodSize, int *pixelNumInHood, float xres, float yres, float zres) ;

void readModelSurfVer(char SurfVerFileName[180], int *InputSurfVer, int maxNbr) ;

void calculateHood(Fvector3d **hood, int *nbr_size, float xres, float yres, float zres) ;
/*scaling and shifting*/
void estimatingScalingAndShiftOf3DSurfaceFromImg(Fvector3d *ModelVer, Ivector3d *FixedMdlVer, ImgAttribute *MdlVer_Fea, int MdlVer_Num, Fvector3d ***DeformFld, ImgAttribute ***ObjImg, int image_size, int z_size ) ;
unsigned char interpolatedIntensity(float ii, float jj, float kk, unsigned char ***Img, int image_size, int z_size) ;
void saveCurrentWarpingResultOnSegmentedObj( ImgAttribute ***ObjImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, int interpolate) ;

void saveCurrentWarpingResultOnOriginalObjImg( unsigned char ***ObjOriginalImg, Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, int interpolate) ;
void saveDeformedModelSurfVer(Fvector3d ***DeformFld, int image_size, int z_size, int XYZres, int fileOrder, int maxNbr) ;

void openDeformationField(char filename[180], Fvector3d ***DeformFld, int image_size, int z_size, float confidenceOnLastDeformation) ;
float similarityBetweenFocusedPointsInMdlObjImgs( ImgAttribute *ObjVer_Fea, int l, ImgAttribute *MdlVer_Fea, int s);
/* To speed up the algorithm */
void shiftByGuassianWeight(Fvector3d In, Fvector3d *Tmp, Fvector3d Search, float level, int max) ;
float similarityBetweenFeaturesInMdlAndObjImgs( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute ***MdlImg, int i, int j, int k ) ;

float similarityBetweenFeaturesInImgAndFeaturesInMdl( ImgAttribute ***ObjImg, int x, int y, int z, ImgAttribute *MdlVer_Fea, int s) ;

void globalAffineUpdatePlusLocalDeformation( Fvector3d *verObject, Fvector3d *verModel, int MdlVer_Num, Matrix *transform) ;
void smoothDeformationField(Fvector3d ***DeformFld, int image_size, int z_size) ;
void smoothDeformationFieldWithEdgePreserving( Ivector3d *FixedMdlVer, int MdlVer_Num, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, int image_size, int z_size, float ratio_iteration, int SmoothingTimes ) ;
void openTrainingResults( Matrix *T1, Matrix *T2, float *T3, int SizeOfT3, char mdlDirectory[]) ;
void alignmentObjectToModel( Fvector3d *verMdl, Fvector3d *verObj, Matrix *tMdl2Obj, int MdlVer_Num ) ;
void correct3DSurfaceByT1T2T3(Fvector3d *ver, int MdlVer_Num, Matrix *T1, Matrix *T2, float  *T3, float alpha) ;
void affineTransform3DSurface( Fvector3d *ver, Matrix *tMdl2Obj,  int  MdlVer_Num ) ;

/*int max_nbr=1 ;*/
void statisticalMapping(Fvector3d *ver,  int  MdlVer_Num, float alpha, int maxNbr,char mdlDirectory[]) ;

void searchTheNearestVertexForEachLandmark(Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, \
Fvector3d *ModelVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Ivector3d *FixedMdlVer, ImgAttribute ***MdlImg, Fvector3d ***DeformFld,   int image_size, int z_size,  int max, Fvector3d *forceByFocusedPntInObj, Ivector3d    *myHood, int *multiple, float smrThr, float matchingDegreeOfMdlOnImgEdge, int youngBrain) ;

//void affineDeform3D(Fvector3d *ModelVer, Ivector3d *FixedMdlVer, int MdlVer_Num, ImgAttribute *MdlVer_Fea, Fvector3d ***DeformFld, ImgAttribute ***MdlImg, Ivector3d *ObjVer, int ObjVer_Num, ImgAttribute *ObjVer_Fea, ImgAttribute ***ObjImg, int image_size, int z_size, int resolution, Fvector3d    *forceByFocusedPntInObj, Matrix *transform, Ivector3d *myHood, int *multiple, int smoothingTimes, int maxNbr, float ratioIteration, float deformRate, float statisticalFactor, float smoothFactor, float matchingDegreeOfMdlOnImgEdge, int statisticsEmployedOrNot, int objectForce, int globalConstraint, int youngBrain, char mdlDirectory[]);
void writeDeformationField(char filename[180], Fvector3d ***DeformFld, int image_size, int z_size) ;

void debugWriteDeformationField(char filename[180], Fvector3d ***DeformFld, int image_size, int z_size);

void loadImage(char filename[], ImgAttribute  ***ObjImg, int Img_XY, int zSize, int imageSize, float xyzRes);

void initializeDeformationField(Fvector3d ***DeformFld, int zSize, int imageSize);

#ifdef	__cplusplus
}
#endif

#endif	/* _adaptivebrain_H */

