%% Initialization
clear
%close all
clc
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/bin')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/lib')
addpath('/sbia/home/batmangn/Software/mosek/6/toolbox/r2009b')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA/src')
addpath('/sbia/home/batmangn/Software/liblinear-1.8/matlab')

USPSDataPath = '../data/uspsDigits' ;

% general variables for problem 
global ZSBT ;
ZSBT = 1e-20 ;   %zero substituite
MAXITR = 30 ;
tol =  1e-3 ;
r = 16      ;
D = 256 ;
ConstVars.MAXITR = MAXITR  ;                % MAXITR for optimization 
ConstVars.ZSBT = ZSBT ;                     % zero substituite
ConstVars.tol = tol ;                       % tolerance for optimization

% Dataset information
FeatureFilename = 'usps_4_7.mat' ;
DataFcnHandler = @uspsdigits ;
ConstVars.digitsList = {6,8} ;
ConstVars.classID = {'6','8'} ;
ConstVars.numfolds = 2 ; 
ConstVars.foldnum = 1 ;
Ni = 100    ;  % number of samples from each class
ConstVars.numClasses = length(ConstVars.digitsList) ;
N = 0    ;
for classCnt=1:ConstVars.numClasses
    ConstVars.classWeight(classCnt) = 1/Ni ;
    N = N + Ni ;
    ConstVars.numSampleList{classCnt}  = Ni ;	% number of images to be used to derive basis vectors
end
ConstVars.N = N ;                           % Number of samples to be used for training
ConstVars.nullWeight = 1/N ;
ConstVars.r = r ;                           % number of basis vectors
ConstVars.lambda_gen = 10000*1/(N*D) ;                  % weight for Frobinous norm
ConstVars.lambda_disc = 1 ;                 % weight for the loss function
ConstVars.lambda_const = 16*16*0.8 ;            % RHS of the sparseness term
ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
ConstVars.downsampleFlag = false ;
ConstVars.Datapath = USPSDataPath ;
ConstVars.pathTodata = USPSDataPath ;
ConstVars.reExtractFeature = true ;
ConstVars.FeatureFilename = FeatureFilename ;
ConstVars.D1 = 16 ;    % x: original image size
ConstVars.D2 = 16 ;    % y: original image size
ConstVars.D = D ;
ConstVars.DownSampleRatio = 1 ;
ConstVars.numChannels = 1 ;
ConstVars.saveAfterEachIteration = false ;
ConstVars.randSeed = 0 ;


% options for the Bsolver 
ConstVars.BSolver_opt.BBMethod = 3 ; 

% optimizer parameter
%ConstVars.BBSolverPath = BBSolverPath;
%ConstVars.mosekPath = mosekPath;
%ConstVars.LibLinearPath = LibLinearPath ;
ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C

if ConstVars.reExtractFeature
    [V,IndicesForBasis, IndicesForTrain,IndicesForTest] = feval(DataFcnHandler,ConstVars) ;   
    Data.V = V ;
    Data.y = [] ;
    for  classCnt=1:ConstVars.numClasses
        Data.y = [Data.y ;  classCnt*ones(Ni,1)  ];
    end
    save(ConstVars.FeatureFilename,'ConstVars','Data')
else
    load(ConstVars.FeatureFilename,'ConstVars','Data')
end

% create constant matrices
Data.W0 = rand(D,r) ;
Data.W0 = Data.W0./repmat(sum(Data.W0),D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible 
Data.H0 = rand(r,N) ;
Data.w0 = randn(r,1) ;

[B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
figure;plot(Report.Obj_Hist) ;
figure;nmf_ShowBasis(B,ConstVars) ;
figure;plot(Report.Terms_Hist(1,:))
figure;plot(Report.Terms_Hist(2,:))
figure;plot(Report.Terms_Hist(3,:))
Report.Obj_Hist(end)
% report of sparsity based on Hoyer's definition
sp = 1/(sqrt(D) - 1)*(sqrt(D) - sum(B)./sum(B.^2)) ;
mean(sp)

